unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, Menus, ExtCtrls;

type
  TMain = class(TForm)
    MainMenu1: TMainMenu;
    mFile: TMenuItem;
    mFileExit: TMenuItem;
    N1: TMenuItem;
    mFilePrintSetup: TMenuItem;
    mFilePrint: TMenuItem;
    N2: TMenuItem;
    mFileSaveAs: TMenuItem;
    mContent: TMemo;
    StatusBar1: TStatusBar;
    mEdit: TMenuItem;
    mEditCopy: TMenuItem;
    mEditSelectAll: TMenuItem;
    mView: TMenuItem;
    mViewFont: TMenuItem;
    mViewBar1: TMenuItem;
    mViewWordWrap: TMenuItem;
    mViewBevel: TMenuItem;
    mHelp: TMenuItem;
    mHelpAbout: TMenuItem;
    sdSave: TSaveDialog;
    fdFont: TFontDialog;
    mViewBar2: TMenuItem;
    mViewTextColor: TMenuItem;
    mViewBackgroundColor: TMenuItem;
    mViewResetColors: TMenuItem;
    cdColor: TColorDialog;
    fdFind: TFindDialog;
    mEditBar1: TMenuItem;
    mEditFind: TMenuItem;
    mEditFindNext: TMenuItem;
    PrinterSetupDialog1: TPrinterSetupDialog;
    mViewBar3: TMenuItem;
    mViewPause: TMenuItem;
    mFileClear: TMenuItem;
    procedure mFileSaveAsClick(Sender: TObject);
    procedure mEditCopyClick(Sender: TObject);
    procedure mEditSelectAllClick(Sender: TObject);
    procedure mViewFontClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure mViewWordWrapClick(Sender: TObject);
    procedure mViewBevelClick(Sender: TObject);
    procedure mViewResetColorsClick(Sender: TObject);
    procedure mViewTextColorClick(Sender: TObject);
    procedure mViewBackgroundColorClick(Sender: TObject);
    procedure mEditFindClick(Sender: TObject);
    procedure mEditFindNextClick(Sender: TObject);
    procedure fdFindFind(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure mFileExitClick(Sender: TObject);
    procedure mHelpAboutClick(Sender: TObject);
    procedure mFilePrintSetupClick(Sender: TObject);
    procedure mFilePrintClick(Sender: TObject);
    procedure mViewPauseClick(Sender: TObject);
    procedure mFileClearClick(Sender: TObject);
  private
    WW, Bevel: Boolean;
    FindStr: string;
    InputReader: TThread;
    procedure SetWordWrap(AWW: Boolean);
    procedure SetBevel(ABevel: Boolean);
    procedure DoFindNext;
    procedure SaveSettings;
    procedure LoadSettings;
  public
    procedure NewLine(ALine: string);
  end;

var
  Main: TMain;

implementation

uses
  Registry, Printers, InputUnit, AboutUnit;

{$R *.DFM}

procedure TMain.SetWordWrap(AWW: Boolean);
begin
  WW:=AWW;
  if WW then begin
    mContent.WordWrap:=True;
    mContent.ScrollBars:=ssVertical;
    mViewWordWrap.Checked:=True;
  end else begin
    mContent.WordWrap:=False;
    mContent.ScrollBars:=ssBoth;
    mViewWordWrap.Checked:=False;
  end;
end;

procedure TMain.SetBevel(ABevel: Boolean);
begin
  Bevel:=ABevel;
  if Bevel then begin
    mContent.BorderStyle:=bsSingle;
    mViewBevel.Checked:=True;
  end else begin
    mContent.BorderStyle:=bsNone;
    mViewBevel.Checked:=False;
  end;
end;

procedure TMain.DoFindNext;
var
  C, D: Integer;
  S, W: string;
  IC: Boolean;

  function MatchesHere: Boolean;
  var
    I: Integer;
  begin
    for I:=1 to Length(FindStr) do begin
      if C + I > Length(S) then begin
        Result:=False;
        Exit;
      end;
      if IC and (UpCase(S[C + I]) <> UpCase(FindStr[I])) then begin
        Result:=False;
        Exit;
      end;
      if (not IC) and (S[C + I] <> FindStr[I]) then begin
        Result:=False;
        Exit;
      end;
    end;
    if frWholeWord in fdFind.Options then begin
      if C + Length(FindStr) + 1 <= Length(S) then begin
        if S[C + Length(FindStr) + 1] in ['A'..'Z', 'a'..'z', '0'..'9'] then begin
          Result:=False;
          Exit;
        end;
      end;
    end;
    Result:=True;
  end;

begin
  if FindStr='' then Exit;
  S:=mContent.Lines.Text;
  if frDown in fdFind.Options then
    C:=mContent.SelStart + mContent.SelLength
  else
    C:=mContent.SelStart - mContent.SelLength;
  if C >= Length(S) then C:=Length(S) - 1;
  if C < 0 then C:=0;
  if C >= Length(S) then Exit;
  IC:=not (frMatchCase in fdFind.Options);
  while True do begin
    if MatchesHere then begin
      mContent.SelStart:=C;
      mContent.SelLength:=Length(FindStr);
      SendMessage(mContent.Handle, EM_SCROLLCARET, 0, 0);
      BringToFront;
      mContent.SetFocus;
      Break;
    end;
    if frDown in fdFind.Options then begin
      Inc(C);
      if C >= Length(S) then begin
        ShowMessage('Reached the end but the string was not found.');
        Break;
      end;
    end else begin
      Dec(C);
      if C < 0 then begin
        ShowMessage('Reached the top but the string was not found.');
        Break;
      end;
    end;
  end;
end;

procedure TMain.SaveSettings;
var
  Reg: TRegIniFile;
  WP: TWindowPlacement;
begin
  try
    Reg:=TRegIniFile.Create('Software\Runtime Terror\WinLess');
    Reg.WriteBool('Settings', 'WordWrap', WW);
    Reg.WriteBool('Settings', 'Bevel', Bevel);
    Reg.WriteInteger('Settings', 'TextColor', Integer(mContent.Font.Color));
    Reg.WriteInteger('Settings', 'BgColor', Integer(mContent.Color));
    Reg.WriteString('Settings', 'FontName', mContent.Font.Name);
    Reg.WriteInteger('Settings', 'FontSize', mContent.Font.Size);
    Reg.WriteBool('Settings', 'FontBold', fsBold in mContent.Font.Style);
    Reg.WriteBool('Settings', 'FontItalic', fsItalic in mContent.Font.Style);
    Reg.WriteBool('Settings', 'FontUnderline', fsUnderline in mContent.Font.Style);
    Reg.WriteBool('Settings', 'FontStrikeOut', fsStrikeOut in mContent.Font.Style);
    FillChar(WP, SizeOf(WP), 0);
    WP.Length:=SizeOf(WP);
    GetWindowPlacement(Handle, @WP);
    Reg.WriteBinaryData('WindowPlacement', WP, SizeOf(WP));
  except
    ShowMessage('Failed to save the settings');
  end;
  Reg.Free;
end;

procedure TMain.LoadSettings;
var
  Reg: TRegIniFile;
  WP: TWindowPlacement;
begin
  try
    Reg:=TRegIniFile.Create('Software\Runtime Terror\WinLess');
    SetWordWrap(Reg.ReadBool('Settings', 'WordWrap', WW));
    SetBevel(Reg.ReadBool('Settings', 'Bevel', Bevel));
    mContent.Font.Color:=TColor(Reg.ReadInteger('Settings', 'TextColor', Integer(mContent.Font.Color)));
    mContent.Color:=TColor(Reg.ReadInteger('Settings', 'BgColor', Integer(mContent.Color)));
    mContent.Font.Name:=Reg.ReadString('Settings', 'FontName', mContent.Font.Name);
    mContent.Font.Size:=Reg.ReadInteger('Settings', 'FontSize', mContent.Font.Size);
    mContent.Font.Style:=[];
    if Reg.ReadBool('Settings', 'FontBold', fsBold in mContent.Font.Style) then
      mContent.Font.Style:=mContent.Font.Style + [fsBold];
    if Reg.ReadBool('Settings', 'FontItalic', fsItalic in mContent.Font.Style) then
      mContent.Font.Style:=mContent.Font.Style + [fsItalic];
    if Reg.ReadBool('Settings', 'FontUnderline', fsUnderline in mContent.Font.Style) then
      mContent.Font.Style:=mContent.Font.Style + [fsUnderline];
    if Reg.ReadBool('Settings', 'FontStrikeOut', fsStrikeOut in mContent.Font.Style) then
      mContent.Font.Style:=mContent.Font.Style + [fsStrikeOut];
    FillChar(WP, SizeOf(WP), 0);
    WP.Length:=SizeOf(WP);
    GetWindowPlacement(Handle, @WP);
    Reg.ReadBinaryData('WindowPlacement', WP, SizeOf(WP));
    SetWindowPlacement(Handle, @WP);
  except
  end;
  Reg.Free;
end;

procedure TMain.NewLine(ALine: string);
begin
  mContent.Lines.Add(ALine);
  StatusBar1.Panels[0].Text:=IntToStr(mContent.Lines.Count) + ' Lines';
end;

procedure TMain.mFileSaveAsClick(Sender: TObject);
begin
  if sdSave.Execute then begin
    try
      mContent.Lines.SaveToFile(sdSave.FileName);
    except
      ShowMessage('Failed to save ' + sdSave.FileName);
    end;
  end;
end;

procedure TMain.mEditCopyClick(Sender: TObject);
begin
  mContent.CopyToClipboard;
end;

procedure TMain.mEditSelectAllClick(Sender: TObject);
begin
  mContent.SelectAll;
end;

procedure TMain.mViewFontClick(Sender: TObject);
begin
  fdFont.Font.Assign(mContent.Font);
  if fdFont.Execute then mContent.Font.Assign(fdFont.Font);
end;

procedure TMain.FormCreate(Sender: TObject);
var
  I: Integer;
  PassThrough: Boolean;
  S: string;

  procedure LoadFile(FN: string);
  var
    L: TStringList;
    I: Integer;
  begin
    try
      L:=TStringList.Create;
      L.LoadFromFile(FN);
      for I:=0 to L.Count - 1 do begin
        NewLine(L[I]);
        if PassThrough then Writeln(L[I]);
      end;
    except
      ShowMessage('Failed to open ' + FN);
    end;
    L.Free;
  end;

begin
  SetWordWrap(True);
  SetBevel(False);
  LoadSettings;
  PassThrough:=False;
  for I:=1 to ParamCount do begin
    if (ParamStr(I)='/?') or (UpperCase(ParamStr(I))='/HELP') or (UpperCase(ParamStr(I))='-HELP') then begin
      ShowMessage('Usage:'#13#10#13#10'winless.exe [/pt] [filename [filename ...]]'#13#10#13#10'/pt - Enable passthrough');
      halt;
    end else if (UpperCase(ParamStr(I))='/PT') or (UpperCase(ParamStr(I))='-PT') then
      PassThrough:=True
    else if (UpperCase(Copy(ParamStr(I), 1, 3))='/C:') or (UpperCase(Copy(ParamStr(I), 1, 3))='-C:') then begin
      S:=Copy(ParamStr(I), 4, MaxInt);
      for I:=1 to Length(S) do if S[I]='~' then S[I]:=' ';
      Caption:=S + ' - WinLess';
    end else if (Length(ParamStr(I)) > 1) and (ParamStr(1)[1]='/') then
      ShowMessage('Unknown option ' + ParamStr(I))
    else LoadFile(ParamStr(I));
  end;
  InputReader:=TInputReaderThread.Create(True);
  TInputReaderThread(InputReader).PassThrough:=PassThrough;
  InputReader.Suspended:=False;
end;

procedure TMain.mViewWordWrapClick(Sender: TObject);
begin
  SetWordWrap(not mViewWordWrap.Checked);
end;

procedure TMain.mViewBevelClick(Sender: TObject);
begin
  SetBevel(not mViewBevel.Checked);
end;

procedure TMain.mViewResetColorsClick(Sender: TObject);
begin
  mContent.Color:=clWindow;
  mContent.Font.Color:=clWindowText;
end;

procedure TMain.mViewTextColorClick(Sender: TObject);
begin
  cdColor.Color:=mContent.Font.Color;
  if cdColor.Execute then mContent.Font.Color:=cdColor.Color;
end;

procedure TMain.mViewBackgroundColorClick(Sender: TObject);
begin
  cdColor.Color:=mContent.Color;
  if cdColor.Execute then mContent.Color:=cdColor.Color;
end;

procedure TMain.mEditFindClick(Sender: TObject);
begin
  fdFind.FindText:=FindStr;
  fdFind.Execute;
end;

procedure TMain.mEditFindNextClick(Sender: TObject);
begin
  if FindStr='' then begin
    mEditFind.Click;
    Exit;
  end;
  DoFindNext;
end;

procedure TMain.fdFindFind(Sender: TObject);
begin
  FindStr:=fdFind.FindText;
  DoFindNext;
end;

procedure TMain.FormDestroy(Sender: TObject);
begin
  SaveSettings;
end;

procedure TMain.mFileExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMain.mHelpAboutClick(Sender: TObject);
begin
  AboutBox.ShowModal;
end;

procedure TMain.mFilePrintSetupClick(Sender: TObject);
begin
  PrinterSetupDialog1.Execute;
end;

procedure TMain.mFilePrintClick(Sender: TObject);
var
  I, Y, LH: Integer;
begin
  Printer.BeginDoc;
  Printer.Canvas.Font.Assign(mContent.Font);
  LH:=Printer.Canvas.TextHeight('A');
  Y:=LH;
  for I:=0 to mContent.Lines.Count - 1 do begin
    if LH*2 + Y >= Printer.PageHeight then begin
      Y:=LH;
      Printer.NewPage;
    end;
    Printer.Canvas.TextOut(LH, Y, mContent.Lines[I]);
    Y:=Y + Printer.Canvas.TextHeight('A');
  end;
  Printer.EndDoc;
end;

procedure TMain.mViewPauseClick(Sender: TObject);
begin
  if InputReader.Suspended then begin
    mViewPause.Checked:=False;
    InputReader.Suspended:=False;
    StatusBar1.Panels[1].Text:='Active';
  end else begin
    mViewPause.Checked:=True;
    InputReader.Suspended:=True;
    StatusBar1.Panels[1].Text:='Paused';
  end;
end;

procedure TMain.mFileClearClick(Sender: TObject);
begin
  mContent.Text:='';
  StatusBar1.Panels[0].Text:='0 Lines';
end;

end.
