//---------------------------------------------------------------------------
#ifndef UMainH
#define UMainH
//---------------------------------------------------------------------------
#include <vcl\Classes.hpp>
#include <vcl\Controls.hpp>
#include <vcl\StdCtrls.hpp>
#include <vcl\Forms.hpp>
#include "bcglvp.h"
#include <vcl\Menus.hpp>
#include "OpenGL.h"
#include "Textures.h"
#include <vcl\ExtCtrls.hpp>
//---------------------------------------------------------------------------
enum EViewMode
{
    VM_TILE,
    VM_WALL,
    VM_FLOOR
};
//---------------------------------------------------------------------------
class TMain : public TForm
{
__published:	// IDE-managed Components
    TOpenGLViewport *glv;
    TPopupMenu *PopupMenu1;
    TMenuItem *mPaste;
    TMenuItem *mBar1;
    TMenuItem *mTile2D;
    TMenuItem *mTileTileWall;
    TMenuItem *mTileFloor;
    TMenuItem *mBar2;
    TMenuItem *mScaleUp;
    TMenuItem *mScaleDown;
    TTimer *Timer1;
    TMenuItem *mBar3;
    TMenuItem *mMoreTiles;
    TMenuItem *mLessTiles;
    TMenuItem *mBar4;
    TMenuItem *mBilinearFiltering;
    TMenuItem *mReset;
    TMenuItem *mAbout;
    TMenuItem *mBar5;
    void __fastcall mPasteClick(TObject *Sender);
    void __fastcall glvRender(TObject *Sender);
    void __fastcall FormClose(TObject *Sender, TCloseAction &Action);
    void __fastcall mTile2DClick(TObject *Sender);
    void __fastcall mTileTileWallClick(TObject *Sender);
    void __fastcall mTileFloorClick(TObject *Sender);
    void __fastcall Timer1Timer(TObject *Sender);
    void __fastcall mScaleUpClick(TObject *Sender);
    void __fastcall mScaleDownClick(TObject *Sender);
    void __fastcall mMoreTilesClick(TObject *Sender);
    void __fastcall mLessTilesClick(TObject *Sender);
    void __fastcall PopupMenu1Popup(TObject *Sender);
    void __fastcall mBilinearFilteringClick(TObject *Sender);
    void __fastcall mResetClick(TObject *Sender);
    void __fastcall mAboutClick(TObject *Sender);
private:	// User declarations
    EViewMode   m_viewMode;
    CTexture    m_texture;
    float       m_zoom;
    int         m_tiles;
    bool        m_filter;
    void SetViewMode(EViewMode mode);
public:		// User declarations
    __fastcall TMain(TComponent* Owner);
};
//---------------------------------------------------------------------------
extern TMain *Main;
//---------------------------------------------------------------------------
#endif
