//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop
#include "UMain.h"
#include "Cameras.h"
//---------------------------------------------------------------------------
#pragma link "bcglvp"
#pragma resource "*.dfm"
TMain *Main;
//---------------------------------------------------------------------------
static bool IsPowerOfTwo(unsigned v)
{
    return v && !(v & (v - 1));
}
//---------------------------------------------------------------------------
__fastcall TMain::TMain(TComponent* Owner)
    : TForm(Owner)
    , m_zoom(1.0f)
{
}
//---------------------------------------------------------------------------
void TMain::SetViewMode(EViewMode mode)
{
    m_viewMode = mode;
}
//---------------------------------------------------------------------------
void __fastcall TMain::mPasteClick(TObject *Sender)
{
    if (!OpenClipboard(Handle))
    {
        ShowMessage("Failed to paste bitmap");
        return;
    }
    if (!IsClipboardFormatAvailable(CF_BITMAP))
    {
        ShowMessage("No bitmap in the clipboard");
        CloseClipboard();
        return;
    }
    HBITMAP bmp = GetClipboardData(CF_BITMAP);
    if (!bmp)
    {
        ShowMessage("Invalid bitmap in the clipboard");
        CloseClipboard();
        return;
    }
    Graphics::TBitmap* tbmp = new Graphics::TBitmap();
    tbmp->Handle = bmp;
    if (!IsPowerOfTwo(tbmp->Width) || !IsPowerOfTwo(tbmp->Height))
    {
        ShowMessage("Bitmap size is not power of two");
    }
    else
    {
        m_texture.SetFromBitmap(tbmp);
    }
    tbmp->Handle = 0;
    delete tbmp;
    CloseClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TMain::glvRender(TObject *Sender)
{
    static bool first = true;
    if (first)
    {
        InitializeMissingOpenGLFunctions();
        Graphics::TBitmap* tmp = new Graphics::TBitmap();
        tmp->Width = 32;
        tmp->Height = 32;
        tmp->Canvas->Rectangle(0, 0, 31, 31);
        tmp->Canvas->MoveTo(0, 0);
        tmp->Canvas->LineTo(32, 32);
        tmp->Canvas->MoveTo(32, 0);
        tmp->Canvas->LineTo(0, 32);
        m_texture.SetFromBitmap(tmp);
        delete tmp;
        first = false;
    }
    float taspect = (float)m_texture.GetWidth()/(float)m_texture.GetHeight();
    float vpaspect = (float)glv->Width/(float)glv->Height;
    GLCALL(glClearColor(0, 0, 0, 0));
    GLCALL(glClear(GL_COLOR_BUFFER_BIT));
    if (!m_texture.IsValid()) return;
    GLCALL(glMatrixMode(GL_PROJECTION));
    GLCALL(glLoadIdentity());
    GLCALL(glEnable(GL_TEXTURE_2D));
    GLCALL(glBindTexture(GL_TEXTURE_2D, m_texture.GetID()));
    CCamera cam;
    int w = 2, h = 2;
    switch (m_viewMode)
    {
    case VM_TILE:
        GLCALL(glMatrixMode(GL_MODELVIEW));
        GLCALL(glLoadIdentity());
        GLCALL(glScalef((float)m_texture.GetHeight()/(float)glv->Height/vpaspect*2.0f,
                        (float)m_texture.GetHeight()/(float)glv->Height*2.0f, 1));
        break;
    case VM_WALL:
        cam = CCamera();
        cam.SetPosition(AVector(0, 0, 4));
        cam.RotateHorizontally(-50*PI/180.0);
        cam.SetAspect(vpaspect);
        w = 20;
        GLCALL(glLoadMatrixf(cam.GetProjectionMatrix()));
        GLCALL(glMatrixMode(GL_MODELVIEW));
        GLCALL(glLoadMatrixf(cam.GetViewMatrix()));
        break;
    case VM_FLOOR:
        cam = CCamera();
        cam.SetPosition(AVector(0, 0, 1));
        cam.RotateVertically(90*PI/180.0);
        cam.SetAspect(vpaspect);
        h = 20;
        GLCALL(glLoadMatrixf(cam.GetProjectionMatrix()));
        GLCALL(glMatrixMode(GL_MODELVIEW));
        GLCALL(glLoadMatrixf(cam.GetViewMatrix()));
        break;
    }
    GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, m_filter ? GL_LINEAR : GL_NEAREST));
    GLCALL(glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, m_filter ? GL_LINEAR_MIPMAP_LINEAR : GL_NEAREST_MIPMAP_NEAREST));
    if (m_viewMode != VM_TILE)
    {
        float mani;
        GLCALL(glGetFloatv(0x84FF /*GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT*/, &mani));
        GLCALL(glTexParameterf(GL_TEXTURE_2D, 0x84FE /*GL_TEXTURE_MAX_ANISOTROPY_EXT*/, mani));
    }
    glScalef(m_zoom*taspect, m_zoom, 1.0f);
    glBegin(GL_QUADS);
    w += m_tiles;
    h += m_tiles;
    for (int y = -h; y < h; ++y)
    {
        for (int x = -w; x < w; ++x)
        {
            glTexCoord2f(0, 1);
            glVertex2f(x, y);
            glTexCoord2f(1, 1);
            glVertex2f(x + 1, y);
            glTexCoord2f(1, 0);
            glVertex2f(x + 1, y + 1);
            glTexCoord2f(0, 0);
            glVertex2f(x, y + 1);
        }
    }
    glEnd();
}
//---------------------------------------------------------------------------
void __fastcall TMain::FormClose(TObject *Sender, TCloseAction &Action)
{
    m_texture.Release();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mTile2DClick(TObject *Sender)
{
    SetViewMode(VM_TILE);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mTileTileWallClick(TObject *Sender)
{
    SetViewMode(VM_WALL);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mTileFloorClick(TObject *Sender)
{
    SetViewMode(VM_FLOOR);    
}
//---------------------------------------------------------------------------
void __fastcall TMain::Timer1Timer(TObject *Sender)
{
    glv->Invalidate();
}
//---------------------------------------------------------------------------

void __fastcall TMain::mScaleUpClick(TObject *Sender)
{
    m_zoom *= 2.0f;
}
//---------------------------------------------------------------------------
void __fastcall TMain::mScaleDownClick(TObject *Sender)
{
    m_zoom /= 2;
    if (m_zoom < 0.125f) m_zoom = 0.125f;
}
//---------------------------------------------------------------------------
void __fastcall TMain::mMoreTilesClick(TObject *Sender)
{
    m_tiles++;
}
//---------------------------------------------------------------------------
void __fastcall TMain::mLessTilesClick(TObject *Sender)
{
    m_tiles--;
    if (m_tiles < 0) m_tiles = 0;
}
//---------------------------------------------------------------------------
void __fastcall TMain::PopupMenu1Popup(TObject *Sender)
{
    mBilinearFiltering->Checked = m_filter;    
}
//---------------------------------------------------------------------------
void __fastcall TMain::mBilinearFilteringClick(TObject *Sender)
{
    m_filter = !m_filter;    
}
//---------------------------------------------------------------------------
void __fastcall TMain::mResetClick(TObject *Sender)
{
    m_viewMode = VM_TILE;
    m_zoom = 1.0f;
    m_tiles = 0;
    m_filter = false;
}
//---------------------------------------------------------------------------
void __fastcall TMain::mAboutClick(TObject *Sender)
{
    ShowMessage("Texture Paste Preview version 1.0\r\n\r\nCopyright (C) 2019 Kostas Michalopoulos");    
}
//---------------------------------------------------------------------------
