{*
 * olol2tab - utility that converts olol files to tab-indented text files
 * Copyright (C) 2011 Kostas Michalopoulos
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * Kostas Michalopoulos <badsector@runtimeterror.com>
 *}
program olol2tab;
{$MODE OBJFPC}{$H+}
var
  f: Text;
  Cmd, Arg, s: string;
  Tabs: Integer;
procedure LoadNode;
var
  Cmd, Arg, s: string;
  i: Integer;
begin
  while not Eof(f) do begin
    Readln(f, s);
    if Length(s) < 4 then continue;
    Cmd:=Copy(s, 1, 4);
    Arg:=Copy(s, 6, Length(s));
    if Cmd='DONE' then break
    else if Cmd='NODE' then begin
      for i:=1 to Tabs do Write(#9);
      WriteLn(Arg);
      Inc(Tabs);
      LoadNode;
      Dec(Tabs);
    end;
  end;
end;

begin
  if ParamCount=0 then begin
    Writeln('Usage: olol2tab <olol file>');
    exit;
  end;
  Assign(f, ParamStr(1));
  {$I-}
  Reset(f);
  {$I+}
  if IOResult <> 0 then begin
    Writeln('Failed to open ', ParamStr(1), ' for input');
    exit;
  end;
  while not Eof(f) do begin
    Readln(f, s);
    if Length(s) < 4 then continue;
    Cmd:=Copy(s, 1, 4);
    Arg:=Copy(s, 6, Length(s));
    if Cmd='STOP' then break;
    if Cmd='NODE' then LoadNode;
  end;
  Close(f);
end.
