{*
 * olol2pas - utility that converts olol files to code for nodes.pas
 * Copyright (C) 2011 Kostas Michalopoulos
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * Kostas Michalopoulos <badsector@runtimeterror.com>
 *}
program olol2pas;
{$MODE OBJFPC}{$H+}
var
  f: Text;
  Cmd, Arg, s: string;

function PasStr(s: string): string;
var
  Len, i: Integer;
begin
  Result:='';
  Len:=1;
  for i:=1 to Length(s) do begin
    Inc(Len);
    if Len=80 then begin
      Len:=1;
      Result:=Result + ''' + '#10'    ''';
    end;
    if s[i]='''' then Result:=Result + '''''' else Result:=Result + s[i];
  end;
end;

procedure LoadNode;
var
  Cmd, Arg, s: string;
begin
  while not Eof(f) do begin
    Readln(f, s);
    if Length(s) < 4 then continue;
    Cmd:=Copy(s, 1, 4);
    Arg:=Copy(s, 6, Length(s));
    if Cmd='DONE' then break
    else if Cmd='TYPE' then begin
      if Arg='NORMAL' then WriteLn('  Node.NodeType:=ntNormal;')
      else if Arg='TICKABLE' then WriteLn('  Node.NodeType:=ntTickable;');
    end else if Cmd='TICK' then
      WriteLn('  Node.Tick:=True;')
    else if Cmd='OPEN' then begin
      WriteLn('  Node.Open:=True;');
      WriteLn('  Node.WasOpen:=True;');
    end else if Cmd='NODE' then begin
      WriteLn('  NodeStack[NSP]:=Node;');
      WriteLn('  Inc(NSP);');
      WriteLn('  Node:=Node.AddStr(''' + PasStr(Arg) + ''');');
      LoadNode;
      WriteLn('  Dec(NSP);');
      WriteLn('  Node:=NodeStack[NSP];');
    end;
  end;
end;

begin
  if ParamCount=0 then begin
    Writeln('Usage: olol2pas <olol file>');
    exit;
  end;
  Assign(f, ParamStr(1));
  {$I-}
  Reset(f);
  {$I+}
  if IOResult <> 0 then begin
    Writeln('Failed to open ', ParamStr(1), ' for input');
    exit;
  end;
  while not Eof(f) do begin
    Readln(f, s);
    if Length(s) < 4 then continue;
    Cmd:=Copy(s, 1, 4);
    Arg:=Copy(s, 6, Length(s));
    if Cmd='STOP' then break;
    if Cmd='NODE' then LoadNode;
  end;
  Close(f);
end.
