(*
 * Free Pascal Windows Profiler Control Unit
 * Copyright (C) 2021 Kostas Michalopoulos
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any damages
 * arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 *
 * Kostas Michalopoulos <badsector@runtimeterror.com>
 *)
unit UFPWProfControl;
{$mode objfpc}{$H+}
interface
uses
  Classes, SysUtils, Windows;

const
  CmdStartStop = WM_APP + 1;
  CmdMarker = WM_APP + 2;

  { CmdStartStop parameters }
  CmdStartStop_Stop = 0;
  CmdStartStop_Start = 1;
  CmdStartStop_Pause = 2;
  CmdStartStop_Continue = 3;

function FPWPCtlConnect: Boolean;
procedure FPWPCtlDisconnect;
procedure FPWPSendCommand(Cmd: UInt; WParam: WPARAM; LParam: LPARAM);
procedure FPWPStartStop(StartStopCmd: Integer);
procedure FPWPMarker(Name: string='');

implementation

var
  Connected: Boolean;
  FPWPReceiver: HWND;

function EnumProc(Wnd: HWND; LParam: LPARAM): LongBool; stdcall;
var
  Text: PChar;
  Len: LongInt;
  Sub: HWND;
begin
  Len:=GetWindowTextLengthA(Wnd);
  Text:=GetMem(Len + 1);
  GetWindowTextA(Wnd, Text, Len);
  Text[Len]:=#0;
  if Pos('Free Pascal Windows Profiler', Text)=0 then begin
    FreeMem(Text);
    Exit(True);
  end;
  FreeMem(Text);
  {$IFDEF CPU64}
  Sub:=FindWindowEx(Wnd, 0, 'FPWPROF_CMDRECEIVER64', 'FPWPROF_CMDRECEIVER64');
  {$ELSE}
  Sub:=FindWindowEx(Wnd, 0, 'FPWPROF_CMDRECEIVER32', 'FPWPROF_CMDRECEIVER32');
  {$ENDIF}
  if Sub <> 0 then begin
    Move(Sub, {%H-}Pointer(LParam)^, SizeOf(Sub));
    Result:=False;
  end;
  Result:=True;
end;

function FPWPCtlConnect: Boolean;
var
  Target: HWND = 0;
begin
  FPWPCtlDisconnect;
  EnumWindows(@EnumProc, {%H-}LPARAM(@Target));
  if Target=0 then Exit(False);
  Connected:=True;
  FPWPReceiver:=Target;
  Result:=True;
end;

procedure FPWPCtlDisconnect;
begin
  Connected:=False;
  FPWPReceiver:=0;
end;

procedure FPWPSendCommand(Cmd: UInt; WParam: WPARAM; LParam: LPARAM);
begin
  if not Connected then if not FPWPCtlConnect then Exit;
  PostMessage(FPWPReceiver, Cmd, WParam, LParam);
end;

procedure FPWPStartStop(StartStopCmd: Integer);
begin
  FPWPSendCommand(CmdStartStop, StartStopCmd, 0);
end;

procedure FPWPMarker(Name: string);
var
  WParam: Windows.WPARAM;
  LParam: Windows.LPARAM;
  NameArr: array [0..7] of AnsiChar;
  I: Integer;
begin
  if Name <> '' then begin
    for I:=1 to 8 do
      if I <= Length(Name) then
        NameArr[I - 1]:=Name[I]
      else
        NameArr[I - 1]:=#0;
    WParam:=0;
    LParam:=0;
    Move(NameArr[0], WParam, 4);
    Move(NameArr[4], LParam, 4);
    FPWPSendCommand(CmdMarker, WParam, LParam);
  end else begin
    FPWPSendCommand(CmdMarker, 0, 0);
  end;
end;

end.

