unit UMain;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Forms, Controls, Graphics, Dialogs, Menus, ComCtrls,
  UFileList;

type

  { TForm1 }

  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    mFile: TMenuItem;
    mFileNewFileList: TMenuItem;
    mFileOpenFileList: TMenuItem;
    mFileSaveFileList: TMenuItem;
    MenuItem1: TMenuItem;
    mFileCreateIMG: TMenuItem;
    mFileExit: TMenuItem;
    MenuItem2: TMenuItem;
    mFiles: TMenuItem;
    mListAddFiles: TMenuItem;
    mListRemoveSelectedFiles: TMenuItem;
    mHelp: TMenuItem;
    mHelpAbout: TMenuItem;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ImageList1: TImageList;
    lvFiles: TListView;
    StatusBar1: TStatusBar;
    odAddFile: TOpenDialog;
    odOpenList: TOpenDialog;
    sdSaveList: TSaveDialog;
    sdSaveIMG: TSaveDialog;
    procedure mHelpAboutClick(Sender: TObject);
    procedure mFileNewFileListClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure mListAddFilesClick(Sender: TObject);
    procedure mListRemoveSelectedFilesClick(Sender: TObject);
    procedure mFileOpenFileListClick(Sender: TObject);
    procedure mFileSaveFileListClick(Sender: TObject);
    procedure mFileCreateIMGClick(Sender: TObject);
  private
    FileList: TImageFileList;
    procedure NewFileList;
    procedure UpdateFiles;
  public

  end;

var
  Form1: TForm1;

implementation

{$R *.lfm}

{ TForm1 }

procedure TForm1.mHelpAboutClick(Sender: TObject);
begin
  ShowMessage('FAT12 Floppy Image Maker version 0.1' + LineEnding + 'Copyright (C) 2020 Kostas Michalopoulos' +
    LineEnding + LineEnding + 'Licensed under the zlib license.');
end;

procedure TForm1.mFileNewFileListClick(Sender: TObject);
begin
  if MessageDlg('Create New File List', 'Are you sure? If you did not save the existing list, you will lose it.', mtConfirmation, mbYesNo, 0) <> mrYes then Exit;
  NewFileList;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  NewFileList;
end;

procedure TForm1.mListAddFilesClick(Sender: TObject);
var
  I: Integer;
begin
  if not odAddFile.Execute then Exit;
  for I:=0 to odAddFile.Files.Count - 1 do
    if FileList.IndexOfFileName(FileList.CalcDOSName(odAddFile.Files[I]))=-1 then begin
      try
        FileList.AddFile(odAddFile.Files[I]);
      except
        ShowMessage('Error adding ' + odAddFile.Files[I] + ': ' + Exception(ExceptObject).Message);
      end;
    end;
  UpdateFiles;
end;

procedure TForm1.mListRemoveSelectedFilesClick(Sender: TObject);
var
  ToDelete: array of TImageFileEntry = nil;
  I: Integer;
begin
  for I:=0 to lvFiles.Items.Count - 1 do
    if lvFiles.Items[I].Selected then begin
      SetLength(ToDelete, Length(ToDelete) + 1);
      ToDelete[High(ToDelete)]:=TImageFileEntry(lvFiles.Items[I].Data);
    end;
  for I:=0 to High(ToDelete) do FileList.RemoveFile(FileList.IndexOf(ToDelete[I]));
  UpdateFiles;
end;

procedure TForm1.mFileOpenFileListClick(Sender: TObject);
begin
  if odOpenList.Execute then try
    FileList.LoadFromFile(odOpenList.FileName);
  except
    ShowMessage('Error opening file list: ' + Exception(ExceptObject).Message);
    FileList.Free;
    FileList:=TImageFileList.Create(Self);
  end;
  UpdateFiles;
end;

procedure TForm1.mFileSaveFileListClick(Sender: TObject);
begin
  if sdSaveList.Execute then try
    FileList.SaveToFile(sdSaveList.FileName);
  except
    ShowMessage('Error saving file list: ' + Exception(ExceptObject).Message);
  end;
end;

procedure TForm1.mFileCreateIMGClick(Sender: TObject);
begin
  if sdSaveIMG.Execute then try
    FileList.CreateDiskImage(sdSaveIMG.FileName);
  except
    ShowMessage('Error creating disk image: ' + Exception(ExceptObject).Message);
  end;
end;

procedure TForm1.NewFileList;
begin
  FreeAndNil(FileList);
  FileList:=TImageFileList.Create(Self);
  UpdateFiles;
end;

procedure TForm1.UpdateFiles;
var
  I: Integer;
  Item: TListItem;
begin
  lvFiles.BeginUpdate;
  lvFiles.Items.Clear;
  for I:=0 to FileList.FileCount - 1 do with FileList.Files[I] do begin
    Item:=lvFiles.Items.Add;
    Item.Caption:=FileName;
    Item.SubItems.Add(IntToStr(FileSize));
    Item.SubItems.Add(LocalPath);
    Item.Data:=FileList.Files[I];
  end;
  lvFiles.EndUpdate;
end;

end.

