#include <Windows.h>
#include <stdlib.h>
#include <stdio.h>

int main(int argn, char** argv)
{
    int i;
    HANDLE hChange;
    BOOL subDirs = FALSE;
    char watchPath[MAX_PATH] = {0};
    DWORD time = INFINITE;
    for (i=1; i < argn; i++)
        if (!strcmp(argv[i], "-d"))
        {
            i++;
            strcpy(watchPath, argv[i]);
        }
        else if (!strcmp(argv[i], "-s"))
        {
            subDirs = TRUE;
        }
        else if (!strcmp(argv[i], "-t"))
        {
            i++;
            time = atoi(argv[i]);
        }
        else if (!strcmp(argv[i], "--help"))
        {
            puts("Usage: dirwait [-d path] [-s] [-t milliseconds]");
            puts("If -d is not given, dirwait will wait for changes in the current directorty");
            puts("If -s is given, subdirectories will also be monitored");
            puts("If -t is given, a timeout of the given milliseconds is used");
            return 0;
        }
    if (!watchPath[0])
    {
        GetCurrentDirectory(sizeof(watchPath), watchPath);
    }
    hChange = FindFirstChangeNotification(watchPath, subDirs,
        FILE_NOTIFY_CHANGE_FILE_NAME|
        FILE_NOTIFY_CHANGE_DIR_NAME|
        FILE_NOTIFY_CHANGE_ATTRIBUTES|
        FILE_NOTIFY_CHANGE_SIZE|
        FILE_NOTIFY_CHANGE_LAST_WRITE);
    if (hChange == INVALID_HANDLE_VALUE)
    {
        fprintf(stderr, "Failed to monitor '%s'\n", watchPath);
        return 1;
    }
    WaitForSingleObject(hChange, time);
    FindCloseChangeNotification(hChange);
    return 0;
}
