/*
 * ==========================================================================
 * Very very very simple application for creating a maximized
 * window with a configurable background color.
 * ==========================================================================
 * Runtime BgColor
 * Copyright (C) 2020 Kostas Michalopoulos
 * 
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any damages
 * arising from the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 * 
 * 1. The origin of this software must not be misrepresented; you must not
 *    claim that you wrote the original software. If you use this software
 *    in a product, an acknowledgment in the product documentation would be
 *    appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 * 
 * Kostas Michalopoulos <badsector@runtimeterror.com>
 * ==========================================================================
 */

#include <Windows.h>

COLORREF bgcolor, custom[16];

LRESULT CALLBACK TheWindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    switch (uMsg)
    {
    case WM_DESTROY:
        PostQuitMessage(0);
        break;
    case WM_LBUTTONDBLCLK:
        {
            CHOOSECOLOR col = {0};
            col.lStructSize = sizeof(col);
            col.hwndOwner = hWnd;
            col.rgbResult = bgcolor;
            col.lpCustColors = custom;
            col.Flags = CC_ANYCOLOR|CC_FULLOPEN|CC_RGBINIT|CC_SOLIDCOLOR;
            if (ChooseColor(&col))
            {
                HKEY key;
                bgcolor = col.rgbResult;
                InvalidateRect(hWnd, NULL, TRUE);
                if (RegCreateKeyEx(HKEY_CURRENT_USER, "Software\\Runtime Terror\\BgColor", 0, NULL,
                    REG_OPTION_NON_VOLATILE, KEY_WRITE, NULL, &key, NULL) == ERROR_SUCCESS)
                {
                    RegSetValueEx(key, "Background", 0, REG_DWORD, (CONST BYTE*)&bgcolor, 4);
                    RegCloseKey(key);
                }
            }
        }
        break;
    case WM_ERASEBKGND:
        {
            HDC dc = (HDC)wParam;
            HBRUSH brush = CreateSolidBrush(bgcolor);
            HGDIOBJ old = SelectObject(dc, brush);
            RECT r;
            GetClientRect(hWnd, &r);
            Rectangle(dc, -1, -1, r.right + 1, r.bottom + 1);
            SelectObject(dc, old);
            DeleteObject(brush);
        }
        return 0;
    }
    return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevIntance, LPSTR lpCmdLine, int nShowCmd)
{
    WNDCLASS wc = {0};
    MSG msg;
    DWORD i = 4, t = REG_DWORD;
    HKEY key;
    if (RegOpenKeyEx(HKEY_CURRENT_USER, "Software\\Runtime Terror\\BgColor", 0, KEY_READ, &key) == ERROR_SUCCESS)
    {
        RegQueryValueEx(key, "Background", 0, &t, (LPBYTE)&bgcolor, &i);
        RegCloseKey(key);
    }
    for (i=0; i < 16; i++) custom[i] = RGB(i*16, i*16, i*16);
    wc.hInstance = hInstance;
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hIcon = LoadIcon(hInstance, "IDI_ICON1");
    wc.lpfnWndProc = TheWindowProc;
    wc.style = CS_DBLCLKS;
    wc.lpszClassName = "BGCOLORWIN";
    RegisterClass(&wc);
    ShowWindow(CreateWindow("BGCOLORWIN", "", WS_OVERLAPPEDWINDOW,
        CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
        0, 0, hInstance, 0), SW_MAXIMIZE);
    while (GetMessage(&msg, 0, 0, 0))
    {
        TranslateMessage(&msg);
        DispatchMessage(&msg);
    }
    return 0;
}
