unit UtilMeshData;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, Maths, Meshes, Textures;

const
  SphereVertices: array [0..179] of Single = (
    0.000000, 0.000000, -1.000000, 0.723600, -0.525720, -0.447215, -0.276385, -0.850640, -0.447215   ,
    0.723600, -0.525720, -0.447215, 0.000000, 0.000000, -1.000000, 0.723600, 0.525720, -0.447215     ,
    0.000000, 0.000000, -1.000000, -0.276385, -0.850640, -0.447215, -0.894425, 0.000000, -0.447215   ,
    0.000000, 0.000000, -1.000000, -0.894425, 0.000000, -0.447215, -0.276385, 0.850640, -0.447215    ,
    0.000000, 0.000000, -1.000000, -0.276385, 0.850640, -0.447215, 0.723600, 0.525720, -0.447215     ,
    0.723600, -0.525720, -0.447215, 0.723600, 0.525720, -0.447215, 0.894425, 0.000000, 0.447215      ,
    -0.276385, -0.850640, -0.447215, 0.723600, -0.525720, -0.447215, 0.276385, -0.850640, 0.447215   ,
    -0.894425, 0.000000, -0.447215, -0.276385, -0.850640, -0.447215, -0.723600, -0.525720, 0.447215  ,
    -0.276385, 0.850640, -0.447215, -0.894425, 0.000000, -0.447215, -0.723600, 0.525720, 0.447215    ,
    0.723600, 0.525720, -0.447215, -0.276385, 0.850640, -0.447215, 0.276385, 0.850640, 0.447215      ,
    0.723600, -0.525720, -0.447215, 0.894425, 0.000000, 0.447215, 0.276385, -0.850640, 0.447215      ,
    -0.276385, -0.850640, -0.447215, 0.276385, -0.850640, 0.447215, -0.723600, -0.525720, 0.447215   ,
    -0.894425, 0.000000, -0.447215, -0.723600, -0.525720, 0.447215, -0.723600, 0.525720, 0.447215    ,
    -0.276385, 0.850640, -0.447215, -0.723600, 0.525720, 0.447215, 0.276385, 0.850640, 0.447215      ,
    0.723600, 0.525720, -0.447215, 0.276385, 0.850640, 0.447215, 0.894425, 0.000000, 0.447215        ,
    0.276385, -0.850640, 0.447215, 0.894425, 0.000000, 0.447215, 0.000000, 0.000000, 1.000000        ,
    -0.723600, -0.525720, 0.447215, 0.276385, -0.850640, 0.447215, 0.000000, 0.000000, 1.000000      ,
    -0.723600, 0.525720, 0.447215, -0.723600, -0.525720, 0.447215, 0.000000, 0.000000, 1.000000      ,
    0.276385, 0.850640, 0.447215, -0.723600, 0.525720, 0.447215, 0.000000, 0.000000, 1.000000        ,
    0.894425, 0.000000, 0.447215, 0.276385, 0.850640, 0.447215, 0.000000, 0.000000, 1.000000);

  CylinderVertices: array [0..251] of Single = (
    0.000000, 1.000000, 0.000000, 0.000000, 1.000000, 1.000000, 0.707107, 0.707107, 1.000000         ,
    0.707107, 0.707107, 1.000000, 0.707107, 0.707107, 0.000000, 0.000000, 1.000000, 0.000000         ,
    0.707107, 0.707107, 0.000000, 0.707107, 0.707107, 1.000000, 1.000000, -0.000000, 1.000000        ,
    1.000000, -0.000000, 1.000000, 1.000000, -0.000000, 0.000000, 0.707107, 0.707107, 0.000000       ,
    1.000000, -0.000000, 0.000000, 1.000000, -0.000000, 1.000000, 0.707107, -0.707107, 1.000000      ,
    0.707107, -0.707107, 1.000000, 0.707107, -0.707107, 0.000000, 1.000000, -0.000000, 0.000000      ,
    0.707107, -0.707107, 0.000000, 0.707107, -0.707107, 1.000000, -0.000000, -1.000000, 1.000000     ,
    -0.000000, -1.000000, 1.000000, -0.000000, -1.000000, 0.000000, 0.707107, -0.707107, 0.000000    ,
    -0.000000, -1.000000, 0.000000, -0.000000, -1.000000, 1.000000, -0.707107, -0.707107, 1.000000   ,
    -0.707107, -0.707107, 1.000000, -0.707107, -0.707107, 0.000000, -0.000000, -1.000000, 0.000000   ,
    -0.707107, -0.707107, 0.000000, -0.707107, -0.707107, 1.000000, -1.000000, 0.000000, 1.000000    ,
    -1.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000, -0.707107, -0.707107, 0.000000     ,
    1.000000, -0.000000, 1.000000, 0.707107, 0.707107, 1.000000, 0.000000, 1.000000, 1.000000        ,
    0.000000, 1.000000, 1.000000, -0.707107, 0.707107, 1.000000, -1.000000, 0.000000, 1.000000       ,
    -1.000000, 0.000000, 1.000000, -0.707107, -0.707107, 1.000000, -0.000000, -1.000000, 1.000000    ,
    -0.000000, -1.000000, 1.000000, 0.707107, -0.707107, 1.000000, 1.000000, -0.000000, 1.000000     ,
    1.000000, -0.000000, 1.000000, 0.000000, 1.000000, 1.000000, -1.000000, 0.000000, 1.000000       ,
    -1.000000, 0.000000, 1.000000, -0.000000, -1.000000, 1.000000, 1.000000, -0.000000, 1.000000     ,
    0.000000, 1.000000, 1.000000, 0.000000, 1.000000, 0.000000, -0.707107, 0.707107, 0.000000        ,
    -0.707107, 0.707107, 0.000000, -0.707107, 0.707107, 1.000000, 0.000000, 1.000000, 1.000000       ,
    -1.000000, 0.000000, 0.000000, -1.000000, 0.000000, 1.000000, -0.707107, 0.707107, 1.000000      ,
    -0.707107, 0.707107, 1.000000, -0.707107, 0.707107, 0.000000, -1.000000, 0.000000, 0.000000      ,
    -0.707107, 0.707107, 0.000000, 0.000000, 1.000000, 0.000000, 0.707107, 0.707107, 0.000000        ,
    0.707107, 0.707107, 0.000000, 1.000000, -0.000000, 0.000000, 0.707107, -0.707107, 0.000000       ,
    0.707107, -0.707107, 0.000000, -0.000000, -1.000000, 0.000000, -0.707107, -0.707107, 0.000000    ,
    -0.707107, -0.707107, 0.000000, -1.000000, 0.000000, 0.000000, -0.707107, 0.707107, 0.000000     ,
    -0.707107, 0.707107, 0.000000, 0.707107, 0.707107, 0.000000, 0.707107, -0.707107, 0.000000       ,
    0.707107, -0.707107, 0.000000, -0.707107, -0.707107, 0.000000, -0.707107, 0.707107, 0.000000);

  ConeVertices: array [0..125] of Single = (
    -0.707107, 0.707107, 0.000000, 0.000000, 1.000000, 0.000000, 0.707107, 0.707107, 0.000000        ,
    0.707107, 0.707107, 0.000000, 1.000000, -0.000000, 0.000000, 0.707107, -0.707107, 0.000000       ,
    0.707107, -0.707107, 0.000000, -0.000000, -1.000000, 0.000000, -0.707107, -0.707107, 0.000000    ,
    -0.707107, -0.707107, 0.000000, -1.000000, 0.000000, 0.000000, -0.707107, 0.707107, 0.000000     ,
    -0.707107, 0.707107, 0.000000, 0.707107, 0.707107, 0.000000, 0.707107, -0.707107, 0.000000       ,
    0.707107, -0.707107, 0.000000, -0.707107, -0.707107, 0.000000, -0.707107, 0.707107, 0.000000     ,
    0.000000, 1.000000, 0.000000, -0.000000, 0.000000, 1.000000, 0.707107, 0.707107, 0.000000        ,
    0.707107, 0.707107, 0.000000, -0.000000, 0.000000, 1.000000, 1.000000, -0.000000, 0.000000       ,
    1.000000, -0.000000, 0.000000, -0.000000, 0.000000, 1.000000, 0.707107, -0.707107, 0.000000      ,
    0.707107, -0.707107, 0.000000, -0.000000, 0.000000, 1.000000, -0.000000, -1.000000, 0.000000     ,
    -0.000000, -1.000000, 0.000000, -0.000000, 0.000000, 1.000000, -0.707107, -0.707107, 0.000000    ,
    -0.707107, -0.707107, 0.000000, -0.000000, 0.000000, 1.000000, -1.000000, 0.000000, 0.000000     ,
    -0.707107, 0.707107, 0.000000, -0.000000, 0.000000, 1.000000, 0.000000, 1.000000, 0.000000       ,
    -1.000000, 0.000000, 0.000000, -0.000000, 0.000000, 1.000000, -0.707107, 0.707107, 0.000000);

  CubeVertices: array [0..107] of Single = (
    -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000, 0.500000  ,
    -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, -0.500000    ,
    -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000       ,
    0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000     ,
    0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000, -0.500000      ,
    0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000, 0.500000      ,
    -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000   ,
    0.500000, -0.500000, 0.500000, -0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000   ,
    -0.500000, -0.500000, -0.500000, -0.500000, 0.500000, -0.500000, 0.500000, 0.500000, -0.500000   ,
    0.500000, 0.500000, -0.500000, 0.500000, -0.500000, -0.500000, -0.500000, -0.500000, -0.500000   ,
    0.500000, -0.500000, 0.500000, 0.500000, 0.500000, 0.500000, -0.500000, 0.500000, 0.500000       ,
    -0.500000, 0.500000, 0.500000, -0.500000, -0.500000, 0.500000, 0.500000, -0.500000, 0.500000);

  ArcCornerVertices: array [0..179] of Single = (
    0.232209, 0.714669, 0.000000, 0.000000, 0.751447, 0.000000, 0.000000, 1.000000, 0.000000,
    0.000000, 1.000000, 0.000000, 0.309016, 0.951057, 0.000000, 0.587784, 0.809018, 0.000000,
    0.587784, 0.809018, 0.000000, 0.809016, 0.587786, 0.000000, 0.951056, 0.309018, 0.000000,
    0.951056, 0.309018, 0.000000, 1.000000, 0.000001, 0.000000, 0.751447, 0.000001, 0.000000,
    0.951056, 0.309018, 0.000000, 0.751447, 0.000001, 0.000000, 0.714669, 0.232211, 0.000000,
    0.000000, 1.000000, 0.000000, 0.587784, 0.809018, 0.000000, 0.951056, 0.309018, 0.000000,
    0.441689, 0.607934, 0.000000, 0.232209, 0.714669, 0.000000, 0.000000, 1.000000, 0.000000,
    0.951056, 0.309018, 0.000000, 0.714669, 0.232211, 0.000000, 0.607933, 0.441690, 0.000000,
    0.441689, 0.607934, 0.000000, 0.000000, 1.000000, 0.000000, 0.951056, 0.309018, 0.000000,
    0.951056, 0.309018, 0.000000, 0.607933, 0.441690, 0.000000, 0.441689, 0.607934, 0.000000,
    0.000000, 1.000000, 0.018206, 0.000000, 0.751447, 0.018206, 0.232209, 0.714669, 0.018206,
    0.000000, 1.000000, 0.018206, 0.232209, 0.714669, 0.018206, 0.441689, 0.607934, 0.018206,
    0.587784, 0.809018, 0.018206, 0.309016, 0.951057, 0.018206, 0.000000, 1.000000, 0.018206,
    0.951056, 0.309018, 0.018206, 0.809016, 0.587786, 0.018206, 0.587784, 0.809018, 0.018206,
    0.751447, 0.000001, 0.018206, 1.000000, 0.000001, 0.018206, 0.951056, 0.309018, 0.018206,
    0.714669, 0.232211, 0.018206, 0.751447, 0.000001, 0.018206, 0.951056, 0.309018, 0.018206,
    0.951056, 0.309018, 0.018206, 0.587784, 0.809018, 0.018206, 0.000000, 1.000000, 0.018206,
    0.951056, 0.309018, 0.018206, 0.000000, 1.000000, 0.018206, 0.441689, 0.607934, 0.018206,
    0.607933, 0.441690, 0.018206, 0.714669, 0.232211, 0.018206, 0.951056, 0.309018, 0.018206,
    0.441689, 0.607934, 0.018206, 0.607933, 0.441690, 0.018206, 0.951056, 0.309018, 0.018206);

procedure DrawOpenGLTrianglesFor(const V: array of Single; const Matrix: TMatrix; BaseColor: TExtColor);
function CreateMeshFor(const V: array of Single): TMesh;

implementation

uses
  GL;

procedure DrawOpenGLTrianglesFor(const V: array of Single;
  const Matrix: TMatrix; BaseColor: TExtColor);
var
  N, V1, V2, V3: TVector;
  I: Integer;
  C: TExtColor;
  D: Double;
begin
  I:=0;
  glBegin(GL_TRIANGLES);
  while I < Length(V) do begin
    V1:=Vector(V[I], V[I + 1], V[I + 2]);
    V2:=Vector(V[I + 3], V[I + 4], V[I + 5]);
    V3:=Vector(V[I + 6], V[I + 7], V[I + 8]);
    Matrix.Transform(V1);
    Matrix.Transform(V2);
    Matrix.Transform(V3);
    N:=TriangleNormal(V1, V2, V3);
    D:=Clamp((N.Dot(Vector(-0.3, 0.5, -0.2)) + 1.5)/3, 0, 1);
    C:=BaseColor;
    C.Scale(0.25 + D*0.75);
    C.Add(ExtColor(D*C.r*0.25, D*C.g*0.25, D*C.b*0.25));
    glColor3f(C.r, C.g, C.b);
    glVertex3d(V1.x, V1.y, V1.z);
    glVertex3d(V2.x, V2.y, V2.z);
    glVertex3d(V3.x, V3.y, V3.z);
    Inc(I, 9);
  end;
  glEnd();
end;

function CreateMeshFor(const V: array of Single): TMesh;
var
  I, A, B, C: Integer;
  V1, V2, V3, N: TVector;
begin
  Result:=TMesh.Create;
  I:=0;
  while I < Length(V) do begin
    V1:=Vector(V[I], V[I + 1], V[I + 2]);
    V2:=Vector(V[I + 3], V[I + 4], V[I + 5]);
    V3:=Vector(V[I + 6], V[I + 7], V[I + 8]);
    N:=TriangleNormal(V1, V2, V3);
    A:=Result.AddVertex(V1, N, 0, 0);
    B:=Result.AddVertex(V2, N, 0, 0);
    C:=Result.AddVertex(V3, N, 0, 0);
    Result.AddFace(A, B, C);
    Inc(I, 9);
  end;
  glEnd();
end;

end.

