unit PaintBufferMaintainers;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs;

type

  { TPaintBufferMaintainer }

  TPaintBufferMaintainer = class(TComponent)
  private
    FBuffer: TBitmap;
    function GetBuffer: TBitmap;
    function GetWidth: Integer; inline;
    procedure SetWidth(AValue: Integer); inline;
    function GetHeight: Integer; inline;
    procedure SetHeight(AValue: Integer); inline;
    procedure CreateBufferOfSize(AWidth, AHeight: Integer);
    function GetCanvas: TCanvas; inline;
  protected
  public
    destructor Destroy; override;
    procedure ReleaseBuffer;
    procedure SetSize(AWidth, AHeight: Integer);
    procedure NeedSizeAtLeast(AWidth, AHeight: Integer);
    function GetBufferOfSizeAtLeast(AWidth, AHeight: Integer): TBitmap;
    property Buffer: TBitmap read GetBuffer;
    property Canvas: TCanvas read GetCanvas;
    property Width: Integer read GetWidth write SetWidth;
    property Height: Integer read GetHeight write SetHeight;
  published
  end;

procedure Register;

implementation

procedure Register;
begin
  {$I paintbuffermaintainers_icon.lrs}
  RegisterComponents('RTTK',[TPaintBufferMaintainer]);
end;

{ TPaintBufferMaintainer }

function TPaintBufferMaintainer.GetBuffer: TBitmap;
begin
  if not Assigned(FBuffer) then CreateBufferOfSize(1, 1);
  Result:=FBuffer;
end;

function TPaintBufferMaintainer.GetHeight: Integer;
begin
  Result:=Buffer.Width;
end;

function TPaintBufferMaintainer.GetWidth: Integer;
begin
  Result:=Buffer.Height;
end;

procedure TPaintBufferMaintainer.SetHeight(AValue: Integer);
begin
  SetSize(Width, AValue);
end;

procedure TPaintBufferMaintainer.CreateBufferOfSize(AWidth, AHeight: Integer);
begin
  FreeAndNil(FBuffer);
  FBuffer:=TBitmap.Create;
  FBuffer.PixelFormat:=pf32bit;
  FBuffer.Width:=AWidth;
  FBuffer.Height:=AHeight;
end;

function TPaintBufferMaintainer.GetCanvas: TCanvas;
begin
  Result:=Buffer.Canvas;
end;

procedure TPaintBufferMaintainer.SetWidth(AValue: Integer);
begin
  SetSize(AValue, Height);
end;

destructor TPaintBufferMaintainer.Destroy;
begin
  if Assigned(FBuffer) then FreeAndNil(FBuffer);
  inherited Destroy;
end;

procedure TPaintBufferMaintainer.ReleaseBuffer;
begin
  FreeAndNil(FBuffer);
end;

procedure TPaintBufferMaintainer.SetSize(AWidth, AHeight: Integer);
begin
  if AWidth < 1 then AWidth:=1;
  if AHeight < 1 then AHeight:=1;
  if (AWidth <> Width) or (AHeight <> Height) then CreateBufferOfSize(AWidth, AHeight);
end;

procedure TPaintBufferMaintainer.NeedSizeAtLeast(AWidth, AHeight: Integer);
begin
  if AWidth < Width then AWidth:=Width;
  if AHeight < Height then AHeight:=Height;
  SetSize(AWidth, AHeight);
end;

function TPaintBufferMaintainer.GetBufferOfSizeAtLeast(AWidth, AHeight: Integer): TBitmap;
begin
  NeedSizeAtLeast(AWidth, AHeight);
  Result:=Buffer;
end;

end.
