unit Logger;

{$mode objfpc}{$H+}

interface

uses
  {GlobalDefines, }Classes, SysUtils, FGL;

type
  TLogger = procedure(Message: string) of object;

var
  DisableLogger: Boolean = False;
  AllowLoggerConsoleOutput: Boolean = True;

procedure Log(Message: string);
procedure RegisterLogger(ALogger: TLogger);
procedure UnregisterLogger(ALogger: TLogger);

implementation

type
  TLoggerList = specialize TFPGList<TLogger>;

var
  List: TLoggerList;

procedure Log(Message: string);
var
  i: Integer;
begin
  if DisableLogger then Exit;
  for i:=0 to List.Count - 1 do List[i](Message);
  if AllowLoggerConsoleOutput and IsConsole then Writeln('(Logger) ', Message);
end;

procedure RegisterLogger(ALogger: TLogger);
begin
  List.Add(ALogger);
end;

procedure UnregisterLogger(ALogger: TLogger);
begin
  List.Remove(ALogger);
end;

initialization
  List:=TLoggerList.Create;

finalization
  FreeAndNil(List);
end.

