unit FirstTimeInit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, LResources, Forms, Controls, Graphics, Dialogs, ExtCtrls;

type

  { TFirstTimeInit }

  TFirstTimeInit = class(TComponent)
  private
    FTimer: TTimer;
    FOnInitialize: TNotifyEvent;
    procedure OnTimer(Sender: TObject);
  protected
  public
    procedure AfterConstruction; override;
  published
    property OnInitialize: TNotifyEvent read FOnInitialize write FOnInitialize;
  end;

procedure Register;

implementation

procedure Register;
begin
  {$I firsttimeinit_icon.lrs}
  RegisterComponents('RTTK',[TFirstTimeInit]);
end;

{ TFirstTimeInit }

procedure TFirstTimeInit.OnTimer(Sender: TObject);
begin
  FreeAndNil(FTimer);
  if Assigned(FOnInitialize) then FOnInitialize(Self);
end;

procedure TFirstTimeInit.AfterConstruction;
begin
  inherited AfterConstruction;
  if not (csDesigning in ComponentState) then begin
    FTimer:=TTimer.Create(Self);
    FTimer.Interval:=1;
    FTimer.OnTimer:=@OnTimer;
  end;
end;

end.
