unit WAVLoader;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils;

type
  TLoadWAVResult = (lwrFailed, lwrMono, lwrStereo);

function LoadWAV(Path: string; out Samples: PInt16; out Count: Integer): TLoadWAVResult;

implementation

function LoadWAV(Path: string; out Samples: PInt16; out Count: Integer): TLoadWAVResult;
var
  F: TFileStream;
  RIFF, WAVE, FMT, DATA: array [0..3] of AnsiChar;
  W: UInt16;
  L: UInt32;
  IsStereo: Boolean;
begin
  F:=nil;
  try
    F:=TFileStream.Create(Path, fmOpenRead);
  except
    Exit(lwrFailed);
  end;
  Samples:=nil;
  Count:=0;
  if IOResult <> 0 then Exit(lwrFailed);
  RIFF:='    ';
  WAVE:='    ';
  FMT:='    ';
  DATA:='    ';
  L:=0;
  W:=0;
  F.Read(RIFF, 4);
  F.Read(L, 4);
  F.Read(WAVE, 4);
  F.Read(FMT, 4);
  if (RIFF <> 'RIFF') or (WAVE <> 'WAVE') or (FMT <> 'fmt ') then begin
    F.Free;
    Exit(lwrFailed);
  end;
  F.Read(L, 4);
  if L <> 16 then begin
    F.Free;
    Exit(lwrFailed);
  end;
  F.Read(W, 2);
  if W <> 1 then begin
    F.Free;
    Exit(lwrFailed);
  end;
  F.Read(W, 2);
  if (W <> 1) and (W <> 2) then begin
    F.Free;
    Exit(lwrFailed);
  end;
  IsStereo:=W=2;
  F.Read(L, 4);
  if L <> 22050 then begin
    F.Free;
    Exit(lwrFailed);
  end;
  F.Read(L, 4);
  F.Read(W, 2);
  F.Read(W, 2);
  if W <> 16 then begin
    F.Free;
    Exit(lwrFailed);
  end;
  F.Read(DATA, 4);
  if DATA <> 'data' then begin
    F.Free;
    Exit(lwrFailed);
  end;
  F.Read(L, 4);
  Count:=L div 2;
  Samples:=GetMem(L);
  F.Read(Samples^, L);
  F.Free;
  if IsStereo then Result:=lwrStereo else Result:=lwrMono;
end;

end.

