//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "UICodeEditor.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TCodeEditor *CodeEditor;
//---------------------------------------------------------------------------
__fastcall TCodeEditor::TCodeEditor(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void TCodeEditor::UpdateCaption()
{
    AnsiString caption = FileName.IsEmpty() ? AnsiString("New File") : FileName;
    if (mCode->Modified) caption += '*';
    Caption = caption;
}
//---------------------------------------------------------------------------
bool TCodeEditor::SaveToFile(const AnsiString& path)
{
    try
    {
        mCode->Lines->SaveToFile(path);
        mCode->Modified = false;
        FileName = path;
        UpdateCaption();
        return true;
    }
    catch(...)
    {
        return false;
    }
}
//---------------------------------------------------------------------------
bool TCodeEditor::LoadFromFile(const AnsiString& path)
{
    try
    {
        mCode->Lines->LoadFromFile(path);
        mCode->Modified = false;
        FileName = path;
        UpdateCaption();
        return true;
    }
    catch(...)
    {
        return false;
    }
}
//---------------------------------------------------------------------------
void __fastcall TCodeEditor::FormClose(TObject *Sender, TCloseAction &Action)
{
    Action = caFree;
}
//---------------------------------------------------------------------------
void __fastcall TCodeEditor::FormCloseQuery(TObject *Sender, bool &CanClose)
{
    if (mCode->Modified)
    {
        CanClose = false;
        if (Application->MessageBox("The file has been modified. If you continue you will lose your changes. Continue?", "Modified File", MB_YESNO|MB_ICONWARNING|MB_DEFBUTTON2) == IDYES)
        {
            CanClose = true;
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TCodeEditor::mCodeChange(TObject *Sender)
{
    if (!ToInsert.IsEmpty())
    {
        AnsiString tmp = ToInsert;
        ToInsert = "";
        SendMessage(mCode->Handle, EM_REPLACESEL, FALSE, (LPARAM)tmp.c_str());
    }
    UpdateCaption();
}
//---------------------------------------------------------------------------
void __fastcall TCodeEditor::mCodeKeyDown(TObject *Sender, WORD &Key,
    TShiftState Shift)
{
    if (Key == VK_RETURN)
    {
        AnsiString text = mCode->Text;
        int i;
        for (i=mCode->SelStart - 1; i > 0; i--)
        {
            if (text[i] == '\r')
            {
                i += 2;
                break;
            }
            if (text[i] == '\n')
            {
                i++;
                break;
            }
        }
        if (i < 1) i = 0;
        if (text[i] == '\r' || text[i] == '\n') return;
        ToInsert = "";
        while (i < text.Length() && isspace(text[i]))
        {
            ToInsert += text[i++];
        }
    }
}
//---------------------------------------------------------------------------
