//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop
#include "UIConsole.h"
#include "EDState.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TConsoleForm *ConsoleForm;
//---------------------------------------------------------------------------
__fastcall TConsoleForm::TConsoleForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TConsoleForm::mCodeEnter(TObject *Sender)
{
    mCode->SelStart = mCode->Text.Length();
}
//---------------------------------------------------------------------------
void __fastcall TConsoleForm::mCodeKeyDown(TObject *Sender, WORD &Key,
    TShiftState Shift)
{
    if (Key == VK_LEFT || Key == VK_RIGHT ||
        Key == VK_UP || Key == VK_DOWN ||
        Key == VK_HOME || Key == VK_END ||
        Key == VK_PRIOR || Key == VK_NEXT) return;
    if (Key == VK_RETURN)
    {
        AnsiString code = mCode->Text, line;
        int pos = mCode->SelStart;
        for (int i=pos; i>0; i--)
        {
            if (code[i] == '\r' || code[i] == '\n')
            {
                break;
            }
            line = AnsiString(code[i]) + line;
        }
        if (!line.IsEmpty())
        {
            CodeToRun = line;
            WriteOutput("\r\n");
        }
        Key = 0;
    }
}
//---------------------------------------------------------------------------
void __fastcall TConsoleForm::mCodeKeyPress(TObject *Sender, char &Key)
{
    if (Key == 13) Key = 0;
}
//---------------------------------------------------------------------------
void __fastcall TConsoleForm::mCodeKeyUp(TObject *Sender, WORD &Key,
    TShiftState Shift)
{
    if (Key == 13) Key = 0;
    if (!CodeToRun.IsEmpty())
    {
        RunCode(CodeToRun, true);
        CodeToRun = "";
    }
}
//---------------------------------------------------------------------------
void ClearConsole()
{
    ConsoleForm->mCode->Clear();
}
//---------------------------------------------------------------------------
void RunCode(const AnsiString& code, bool printResult)
{
    lil_value_t v = lil_parse(GLIL, code.c_str(), code.Length(), 1);
    const char* vs = lil_to_string(v);
    if (printResult && vs && vs[0]) {
        WriteOutput(vs);        
        WriteOutput("\r\n");
    }
    lil_free_value(v);
}
//---------------------------------------------------------------------------
void SetVar(const AnsiString& name, const AnsiString& value)
{
    lil_value_t v = lil_alloc_string(value.c_str());
    lil_set_var(GLIL, name.c_str(), v, LIL_SETVAR_GLOBAL);
    lil_free_value(v);
}
//---------------------------------------------------------------------------
void WriteOutput(const AnsiString& s)
{
    AnsiString v;
    for (int i=1; i <= s.Length(); ++i)
    {
        if (s[i] == '\r') continue;
        if (s[i] == '\n') v += "\r\n";
        else v += s[i];
    }
    ConsoleForm->mCode->SelStart = ConsoleForm->mCode->Text.Length();
    ConsoleForm->mCode->SelLength = 0;
    SendMessage(ConsoleForm->mCode->Handle, EM_REPLACESEL, 0, (LPARAM)v.c_str());
    ConsoleForm->mCode->SelStart = ConsoleForm->mCode->Text.Length();
    ConsoleForm->mCode->SelLength = 0;
    SendMessage(ConsoleForm->mCode->Handle, EM_LINESCROLL, 0, 0xFFFFFFF);
}
//---------------------------------------------------------------------------

