//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop
#include "EDState.h"
#include "EDFuncs.h"
#include "UIConsole.h"
//---------------------------------------------------------------------------
lil_t               GLIL;
Graphics::TBitmap*  Gfx;
Graphics::TColor    Color;
//---------------------------------------------------------------------------
static void cb_write(lil_t lil, const char* msg)
{
    WriteOutput(msg);
}
//---------------------------------------------------------------------------
static void cb_error(lil_t lil, size_t pos, const char* msg)
{
    WriteOutput("LIL Error: ");
    WriteOutput(msg);
    WriteOutput("\r\n");
}
//---------------------------------------------------------------------------
void NState::Initialize()
{
    GLIL = lil_new();
    lil_callback(GLIL, LIL_CALLBACK_WRITE, (lil_callback_proc_t)cb_write);
    lil_callback(GLIL, LIL_CALLBACK_ERROR, (lil_callback_proc_t)cb_error);
    RegisterFunctions();
    Gfx = new Graphics::TBitmap();
}
//---------------------------------------------------------------------------
void NState::Shutdown()
{
    Gfx->Free();
    Gfx = NULL;
    lil_free(GLIL);
    GLIL = NULL;
}
//---------------------------------------------------------------------------

