//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop
#include "EDFuncs.h"
#include "EDState.h"
#include "UIMain.h"
#include "UIConsole.h"
#include "UIGraphics.h"
//---------------------------------------------------------------------------
AnsiString  ONKey;
AnsiString  ONChar;
AnsiString  ONDown;
AnsiString  ONUp;
AnsiString  ONMotion;
AnsiString  ONSize;
AnsiString  ONTimer;
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_clear(lil_t lil, size_t argc, lil_value_t* argv)
{
    if (argc > 0)
    {
        Gfx->Canvas->Brush->Color = (TColor)lil_to_integer(argv[0]);
        Gfx->Canvas->Pen->Color = (TColor)lil_to_integer(argv[0]);
        Gfx->Canvas->Rectangle(-1, -1, Gfx->Width + 2, Gfx->Height + 2);
        DamageGraphics();
    }
    else
    {
        ClearConsole();
    }
    return 0;
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_width(lil_t lil, size_t argc, lil_value_t* argv)
{
    return lil_alloc_integer(Gfx->Width);
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_height(lil_t lil, size_t argc, lil_value_t* argv)
{
    return lil_alloc_integer(Gfx->Height);
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_color(lil_t lil, size_t argc, lil_value_t* argv)
{
    if (argc < 1)
    {
        lil_set_error(lil, "Missing parameter from color, use like color <name> or color <color>");
        return 0;
    }
    // Return a named color
    const char* param = lil_to_string(argv[0]);
    if (!strcmp(param, "black")) return lil_alloc_integer(RGB(0, 0, 0));
    if (!strcmp(param, "blue")) return lil_alloc_integer(RGB(0, 0, 0xAA));
    if (!strcmp(param, "green")) return lil_alloc_integer(RGB(0, 0xAA, 0));
    if (!strcmp(param, "cyan")) return lil_alloc_integer(RGB(0, 0xAA, 0xAA));
    if (!strcmp(param, "red")) return lil_alloc_integer(RGB(0xAA, 0, 0));
    if (!strcmp(param, "magenta")) return lil_alloc_integer(RGB(0xAA, 0, 0xAA));
    if (!strcmp(param, "brown")) return lil_alloc_integer(RGB(0xAA, 0x55, 0));
    if (!strcmp(param, "light gray")) return lil_alloc_integer(RGB(0xAA, 0xAA, 0xAA));
    if (!strcmp(param, "light-gray")) return lil_alloc_integer(RGB(0xAA, 0xAA, 0xAA));
    if (!strcmp(param, "gray")) return lil_alloc_integer(RGB(0x55, 0x55, 0x55));
    if (!strcmp(param, "light blue")) return lil_alloc_integer(RGB(0x55, 0x55, 0xFF));
    if (!strcmp(param, "light-blue")) return lil_alloc_integer(RGB(0x55, 0x55, 0xFF));
    if (!strcmp(param, "light green")) return lil_alloc_integer(RGB(0x55, 0xFF, 0x55));
    if (!strcmp(param, "light-green")) return lil_alloc_integer(RGB(0x55, 0xFF, 0x55));
    if (!strcmp(param, "light cyan")) return lil_alloc_integer(RGB(0x55, 0xFF, 0xFF));
    if (!strcmp(param, "light-cyan")) return lil_alloc_integer(RGB(0x55, 0xFF, 0xFF));
    if (!strcmp(param, "light red")) return lil_alloc_integer(RGB(0xFF, 0x55, 0x55));
    if (!strcmp(param, "light-red")) return lil_alloc_integer(RGB(0xFF, 0x55, 0x55));
    if (!strcmp(param, "light magenta")) return lil_alloc_integer(RGB(0xFF, 0x55, 0xFF));
    if (!strcmp(param, "light-magenta")) return lil_alloc_integer(RGB(0xFF, 0x55, 0xFF));
    if (!strcmp(param, "yellow")) return lil_alloc_integer(RGB(0xFF, 0xFF, 0x55));
    if (!strcmp(param, "light brown")) return lil_alloc_integer(RGB(0xFF, 0xFF, 0x55));
    if (!strcmp(param, "light-brown")) return lil_alloc_integer(RGB(0xFF, 0xFF, 0x55));
    if (!strcmp(param, "white")) return lil_alloc_integer(0xFFFFFF);
    // Set the color to use (number)
    char tmp[32];
    int i = atoi(param);
    itoa(i, tmp, 10);
    if (!strcmp(param, tmp))
    {
        Color = (TColor)i;
        return 0;
    }
    // Return a zero color (assuming the user tried to use an unknown name)
    return lil_alloc_integer(0);
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_cga(lil_t lil, size_t argc, lil_value_t* argv)
{
    if (argc < 1)
    {
        lil_set_error(lil, "Missing parameter from cga, use like cga <color number>");
        return 0;
    }
    int param = (int)lil_to_integer(argv[0]);
    // A shitty way to do this, but i just copy pasted the code from above
    if (param == 1) return lil_alloc_integer(RGB(0, 0, 0xAA));
    if (param == 2) return lil_alloc_integer(RGB(0, 0xAA, 0));
    if (param == 3) return lil_alloc_integer(RGB(0, 0xAA, 0xAA));
    if (param == 4) return lil_alloc_integer(RGB(0xAA, 0, 0));
    if (param == 5) return lil_alloc_integer(RGB(0xAA, 0, 0xAA));
    if (param == 6) return lil_alloc_integer(RGB(0xAA, 0x55, 0));
    if (param == 7) return lil_alloc_integer(RGB(0xAA, 0xAA, 0xAA));
    if (param == 8) return lil_alloc_integer(RGB(0x55, 0x55, 0x55));
    if (param == 9) return lil_alloc_integer(RGB(0x55, 0x55, 0xFF));
    if (param == 10) return lil_alloc_integer(RGB(0x55, 0xFF, 0x55));
    if (param == 11) return lil_alloc_integer(RGB(0x55, 0xFF, 0xFF));
    if (param == 12) return lil_alloc_integer(RGB(0xFF, 0x55, 0x55));
    if (param == 13) return lil_alloc_integer(RGB(0xFF, 0x55, 0xFF));
    if (param == 14) return lil_alloc_integer(RGB(0xFF, 0xFF, 0x55));
    if (param == 15) return lil_alloc_integer(0xFFFFFF);
    return lil_alloc_integer(RGB(0, 0, 0));
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_rgb(lil_t lil, size_t argc, lil_value_t* argv)
{
    if (argc < 3)
    {
        lil_set_error(lil, "Missing parameter from rgb, use like rgb <red> <green> <blue>");
        return 0;
    }
    int r = (int)lil_to_integer(argv[0]);
    int g = (int)lil_to_integer(argv[1]);
    int b = (int)lil_to_integer(argv[2]);
    if (r < 0) r = 0; else if (r > 255) r = 255;
    if (g < 0) g = 0; else if (g > 255) g = 255;
    if (b < 0) b = 0; else if (b > 255) b = 255;
    return lil_alloc_integer(RGB(r, g, b));
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_red(lil_t lil, size_t argc, lil_value_t* argv)
{
    if (argc < 1)
    {
        lil_set_error(lil, "Missing parameter from red, use like red <color>");
        return 0;
    }
    return lil_alloc_integer(GetRValue((int)lil_to_integer(argv[0])));
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_green(lil_t lil, size_t argc, lil_value_t* argv)
{
    if (argc < 1)
    {
        lil_set_error(lil, "Missing parameter from green, use like green <color>");
        return 0;
    }
    return lil_alloc_integer(GetGValue((int)lil_to_integer(argv[0])));
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_blue(lil_t lil, size_t argc, lil_value_t* argv)
{
    if (argc < 1)
    {
        lil_set_error(lil, "Missing parameter from blue, use like blue <color>");
        return 0;
    }
    return lil_alloc_integer(GetBValue((int)lil_to_integer(argv[0])));
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_canvas(lil_t lil, size_t argc, lil_value_t* argv)
{
    if (!GraphicsForm)
    {
        Application->CreateForm(__classid(TGraphicsForm), &GraphicsForm);
    }
    if (argc > 1)
    {
        int w = (int)lil_to_integer(argv[0]);
        int h = (int)lil_to_integer(argv[1]);
        if (w < 1) w = 1;
        if (h < 1) h = 1;
        w += (GetSystemMetrics(SM_CXSIZEFRAME) + GetSystemMetrics(SM_CXEDGE))*2;
        h += (GetSystemMetrics(SM_CYSIZEFRAME) + GetSystemMetrics(SM_CYEDGE))*2;
        h += GetSystemMetrics(SM_CYCAPTION);
        GraphicsForm->Width = w;
        GraphicsForm->Height = h;
    }
    if ((argc == 1 && !strcmp(lil_to_string(argv[0]), "center")) ||
        (argc >= 3 && !strcmp(lil_to_string(argv[2]), "center")))
    {
        RECT r;
        GetClientRect(Main->ClientHandle, &r);
        GraphicsForm->Left = (r.right - GraphicsForm->Width)/2;
        GraphicsForm->Top = (r.bottom - GraphicsForm->Height)/2;
    }
    if (argc == 1 && !strcmp(lil_to_string(argv[0]), "maximize"))
    {
        GraphicsForm->WindowState = wsMaximized;
    }
    GraphicsForm->BringToFront();
    return 0;
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_line(lil_t lil, size_t argc, lil_value_t* argv)
{
    if (argc < 4)
    {
        lil_set_error(lil, "Missing parameter from line, use like line <x1> <y1> <x2> <y2>");
        return 0;
    }
    Gfx->Canvas->Pen->Color = Color;
    Gfx->Canvas->MoveTo((int)lil_to_integer(argv[0]), (int)lil_to_integer(argv[1]));
    Gfx->Canvas->LineTo((int)lil_to_integer(argv[2]), (int)lil_to_integer(argv[3]));
    Gfx->Canvas->Pixels[(int)lil_to_integer(argv[2])][(int)lil_to_integer(argv[3])] = Color;
    DamageGraphics();
    return 0;
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_rect(lil_t lil, size_t argc, lil_value_t* argv)
{
    if (argc < 4)
    {
        lil_set_error(lil, "Missing parameter from rect, use like rect <x1> <y1> <x2> <y2>");
        return 0;
    }
    int x1 = (int)lil_to_integer(argv[0]);
    int y1 = (int)lil_to_integer(argv[1]);
    int x2 = (int)lil_to_integer(argv[2]);
    int y2 = (int)lil_to_integer(argv[3]);
    if (x1 > x2) { int tmp = x1; x1 = x2; x2 = tmp; }
    if (y1 > y2) { int tmp = y1; y1 = y2; y2 = tmp; }
    if (x1 == x2 && y1 == y2)
    {
        Gfx->Canvas->Pixels[x1][y1] = Color;
        DamageGraphics();
        return 0;
    }
    Gfx->Canvas->Pen->Color = Color;
    Gfx->Canvas->Brush->Style = bsClear;
    Gfx->Canvas->Rectangle(x1, y1, x2 + 1, y2 + 1);
    Gfx->Canvas->Brush->Style = bsSolid;
    DamageGraphics();
    return 0;
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_box(lil_t lil, size_t argc, lil_value_t* argv)
{
    if (argc < 4)
    {
        lil_set_error(lil, "Missing parameter from box, use like box <x1> <y1> <x2> <y2>");
        return 0;
    }
    int x1 = (int)lil_to_integer(argv[0]);
    int y1 = (int)lil_to_integer(argv[1]);
    int x2 = (int)lil_to_integer(argv[2]);
    int y2 = (int)lil_to_integer(argv[3]);
    if (x1 > x2) { int tmp = x1; x1 = x2; x2 = tmp; }
    if (y1 > y2) { int tmp = y1; y1 = y2; y2 = tmp; }
    if (x1 == x2 && y1 == y2)
    {
        Gfx->Canvas->Pixels[x1][y1] = Color;
        DamageGraphics();
        return 0;
    }
    Gfx->Canvas->Pen->Color = Color;
    Gfx->Canvas->Brush->Color = Color;
    Gfx->Canvas->Rectangle(x1, y1, x2 + 1, y2 + 1);
    DamageGraphics();
    return 0;
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_oval(lil_t lil, size_t argc, lil_value_t* argv)
{
    if (argc < 4)
    {
        lil_set_error(lil, "Missing parameter from oval, use like oval <x1> <y1> <x2> <y2>");
        return 0;
    }
    int x1 = (int)lil_to_integer(argv[0]);
    int y1 = (int)lil_to_integer(argv[1]);
    int x2 = (int)lil_to_integer(argv[2]);
    int y2 = (int)lil_to_integer(argv[3]);
    if (x1 > x2) { int tmp = x1; x1 = x2; x2 = tmp; }
    if (y1 > y2) { int tmp = y1; y1 = y2; y2 = tmp; }
    if (x1 == x2 && y1 == y2)
    {
        Gfx->Canvas->Pixels[x1][y1] = Color;
        DamageGraphics();
        return 0;
    }
    Gfx->Canvas->Pen->Color = Color;
    Gfx->Canvas->Brush->Style = bsClear;
    Gfx->Canvas->Ellipse(x1, y1, x2 + 1, y2 + 1);
    Gfx->Canvas->Brush->Style = bsSolid;
    DamageGraphics();
    return 0;
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_disc(lil_t lil, size_t argc, lil_value_t* argv)
{
    if (argc < 4)
    {
        lil_set_error(lil, "Missing parameter from disc, use like disc <x1> <y1> <x2> <y2>");
        return 0;
    }
    int x1 = (int)lil_to_integer(argv[0]);
    int y1 = (int)lil_to_integer(argv[1]);
    int x2 = (int)lil_to_integer(argv[2]);
    int y2 = (int)lil_to_integer(argv[3]);
    if (x1 > x2) { int tmp = x1; x1 = x2; x2 = tmp; }
    if (y1 > y2) { int tmp = y1; y1 = y2; y2 = tmp; }
    if (x1 == x2 && y1 == y2)
    {
        Gfx->Canvas->Pixels[x1][y1] = Color;
        DamageGraphics();
        return 0;
    }
    Gfx->Canvas->Pen->Color = Color;
    Gfx->Canvas->Brush->Color = Color;
    Gfx->Canvas->Ellipse(x1, y1, x2 + 1, y2 + 1);
    DamageGraphics();
    return 0;
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_text(lil_t lil, size_t argc, lil_value_t* argv)
{
    if (argc < 1)
    {
        lil_set_error(lil, "Missing parameter from text, use like text <x> <y> <text> or text width <text> or text <height>");
        return 0;
    }
    if (!strcmp(lil_to_string(argv[0]), "width"))
    {
        if (argc < 2) return lil_alloc_integer(0);
        return lil_alloc_integer(Gfx->Canvas->TextWidth(lil_to_string(argv[1])));
    }
    if (!strcmp(lil_to_string(argv[0]), "height"))
    {
        return lil_alloc_integer(Gfx->Canvas->TextHeight("W"));
    }
    if (argc < 3)
    {
        lil_set_error(lil, "Missing parameter from text, use like text <x> <y> <text>");
        return 0;
    }
    int x = (int)lil_to_integer(argv[0]);
    int y = (int)lil_to_integer(argv[1]);
    SetBkMode(Gfx->Canvas->Handle, TRANSPARENT);
    Gfx->Canvas->Font->Color = Color;
    Gfx->Canvas->TextOut(x, y, lil_to_string(argv[2]));
    DamageGraphics();
    return 0;
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_beep(lil_t lil, size_t argc, lil_value_t* argv)
{
    MessageBeep(0xFFFFFFFF);
    return 0;
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_process(lil_t lil, size_t argc, lil_value_t* argv)
{
    Application->ProcessMessages();
    return 0;
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_confirm(lil_t lil, size_t argc, lil_value_t* argv)
{
    AnsiString msg;
    for (size_t i=0; i < argc; i++) msg += lil_to_string(argv[i]);
    msg.Trim();
    if (Application->MessageBox(msg.c_str(), "WinLIL", MB_ICONQUESTION|MB_YESNO) == IDYES)
        return lil_alloc_integer(1);
    return 0;
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_message(lil_t lil, size_t argc, lil_value_t* argv)
{
    AnsiString msg;
    for (size_t i=0; i < argc; i++) msg += lil_to_string(argv[i]);
    msg.Trim();
    ShowMessage(msg);
    return 0;
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_on(lil_t lil, size_t argc, lil_value_t* argv)
{
    if (argc < 2)
    {
        lil_set_error(lil, "Missing parameter from on, use like on <event> <code> where <event> is one of key, char, down, up, motion, size or timer");
        return 0;
    }
    if (!strcmp(lil_to_string(argv[0]), "key")) ONKey = lil_to_string(argv[1]);
    else if (!strcmp(lil_to_string(argv[0]), "char")) ONChar = lil_to_string(argv[1]);
    else if (!strcmp(lil_to_string(argv[0]), "down")) ONDown = lil_to_string(argv[1]);
    else if (!strcmp(lil_to_string(argv[0]), "up")) ONUp = lil_to_string(argv[1]);
    else if (!strcmp(lil_to_string(argv[0]), "motion")) ONMotion = lil_to_string(argv[1]);
    else if (!strcmp(lil_to_string(argv[0]), "size")) ONSize = lil_to_string(argv[1]);
    else if (!strcmp(lil_to_string(argv[0]), "timer")) ONTimer = lil_to_string(argv[1]);
    else lil_set_error(lil, "Unknown event type");
    return 0;
}
//---------------------------------------------------------------------------
static lil_value_t __cdecl fnc_timer(lil_t lil, size_t argc, lil_value_t* argv)
{
    if (argc < 1)
    {
        if (!Main->Generic->Enabled) return lil_alloc_integer(0);
        return lil_alloc_integer(Main->Generic->Interval);
    }
    if (!strcmp(lil_to_string(argv[0]), "enable")) Main->Generic->Enabled = true;
    else if (!strcmp(lil_to_string(argv[0]), "disable")) Main->Generic->Enabled = false;
    else
    {
        int interval = (int)lil_to_integer(argv[0]);
        if (interval <= 0)
        {
            Main->Generic->Enabled = false;
            return 0;
        }
        Main->Generic->Interval = interval;
        Main->Generic->Enabled = true;
    }
    return 0;
}
//---------------------------------------------------------------------------
void RegisterFunctions()
{
    lil_register(GLIL, "clear", fnc_clear);
    lil_register(GLIL, "width", fnc_width);
    lil_register(GLIL, "height", fnc_height);
    lil_register(GLIL, "color", fnc_color);
    lil_register(GLIL, "cga", fnc_cga);
    lil_register(GLIL, "rgb", fnc_rgb);
    lil_register(GLIL, "red", fnc_red);
    lil_register(GLIL, "green", fnc_green);
    lil_register(GLIL, "blue", fnc_blue);
    lil_register(GLIL, "canvas", fnc_canvas);
    lil_register(GLIL, "line", fnc_line);
    lil_register(GLIL, "rect", fnc_rect);
    lil_register(GLIL, "box", fnc_box);
    lil_register(GLIL, "oval", fnc_oval);
    lil_register(GLIL, "disc", fnc_disc);
    lil_register(GLIL, "text", fnc_text);
    lil_register(GLIL, "beep", fnc_beep);
    lil_register(GLIL, "process", fnc_process);
    lil_register(GLIL, "confirm", fnc_confirm);
    lil_register(GLIL, "message", fnc_message);
    lil_register(GLIL, "on", fnc_on);
    lil_register(GLIL, "timer", fnc_timer);
}
//---------------------------------------------------------------------------

