//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop
#include "UIMain.h"
#include "EDState.h"
#include "EDFuncs.h"
#include "UIDocs.h"
#include "UICodeEditor.h"
#include "UIConsole.h"
#include "UIGraphics.h"
//---------------------------------------------------------------------------
extern AnsiString CommandLine;
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TMain *Main;
//---------------------------------------------------------------------------
__fastcall TMain::TMain(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void TMain::ParseCommandLine()
{
    TStringList* sl = new TStringList();
    AnsiString part;
    const char* cmdline = CommandLine.c_str();
    for (int i=0; cmdline[i]; i++)
    {
        if (isspace(cmdline[i]))
        {
            while (isspace(cmdline[i])) i++;
            i--;
            sl->Add(part);
            part = "";
            continue;
        }
        else if (cmdline[i] == '"')
        {
            for (i++; cmdline[i]; i++)
            {
                if (cmdline[i] == '"') break;
                part += cmdline[i];
            }
            continue;
        }
        else
        {
            part += cmdline[i];
        }
    }
    if (!part.IsEmpty()) sl->Add(part);
    bool runNext = false;
    for (int i=0; i < sl->Count; i++)
    {
        if (LowerCase(sl->Strings[i]) == "/run")
        {
            runNext = true;
        }
        else
        {
            TCodeEditor* editor;
            Application->CreateForm(__classid(TCodeEditor), &editor);
            if (!editor->LoadFromFile(sl->Strings[i]))
            {
                editor->Free();
                Application->MessageBox(AnsiString("Failed to open the file " + sl->Strings[i]).c_str(), "Error", MB_ICONERROR|MB_OK);
                runNext = false;
                continue;
            }
            if (runNext) RunCode(editor->mCode->Text, false);
        }
    }
    sl->Free();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mFileExitClick(TObject *Sender)
{
    Close();
}
//---------------------------------------------------------------------------
void __fastcall TMain::FormDestroy(TObject *Sender)
{
    NState::Shutdown();    
}
//---------------------------------------------------------------------------
void __fastcall TMain::FormCreate(TObject *Sender)
{
    NState::Initialize();
    Application->OnIdle = OnIdle;
}
//---------------------------------------------------------------------------
void __fastcall TMain::mHelpDocumentationsClick(TObject *Sender)
{
    if (!DocForm)
    {
        Application->CreateForm(__classid(TDocForm), &DocForm);
    }
    else
    {
        DocForm->BringToFront();
    }
}
//---------------------------------------------------------------------------
void __fastcall TMain::sbDocumentationClick(TObject *Sender)
{
    mHelpDocumentations->Click();
}
//---------------------------------------------------------------------------
void __fastcall TMain::OnIdle(TObject *Sender, bool& Done)
{
    bool needsDoubleBorder = true;
    if (ActiveMDIChild && ActiveMDIChild->WindowState == wsMaximized)
    {
        needsDoubleBorder = false;
    }
    DWORD exstyle = GetWindowLong(ClientHandle, GWL_EXSTYLE);
    bool hasDoubleBorder = (exstyle&WS_EX_CLIENTEDGE) == WS_EX_CLIENTEDGE;
    if (needsDoubleBorder != hasDoubleBorder)
    {
        if (needsDoubleBorder) exstyle |= WS_EX_CLIENTEDGE;
        else exstyle &= ~WS_EX_CLIENTEDGE;
        SetWindowLong(ClientHandle, GWL_EXSTYLE, exstyle);
        SetWindowPos(ClientHandle, 0, 0, 0, 0, 0,
          SWP_DRAWFRAME|SWP_FRAMECHANGED|SWP_NOACTIVATE|SWP_NOCOPYBITS|
          SWP_NOMOVE|SWP_NOOWNERZORDER|SWP_NOREPOSITION|SWP_NOSIZE|SWP_NOZORDER);
    }
    bool isEditorActive = ActiveMDIChild && dynamic_cast<TCodeEditor*>(ActiveMDIChild);
    mFileSave->Enabled = isEditorActive;
    sbSave->Enabled = isEditorActive;
    mFileSaveAs->Enabled = isEditorActive;
    mCodeRun->Enabled = isEditorActive;
    sbRun->Enabled = isEditorActive;
    if (RunOnSize) {
        Application->ProcessMessages();
        RunOnSize = false;
        if (!ONSize.IsEmpty()) RunCode(ONSize, false);
    }
    Done = true;
}
//---------------------------------------------------------------------------
void __fastcall TMain::mFileNewClick(TObject *Sender)
{
    TCodeEditor* editor;
    Application->CreateForm(__classid(TCodeEditor), &editor);
}
//---------------------------------------------------------------------------
void __fastcall TMain::sbNewClick(TObject *Sender)
{
    mFileNew->Click();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mCodeRunClick(TObject *Sender)
{
    if (ActiveMDIChild && dynamic_cast<TCodeEditor*>(ActiveMDIChild))
    {
        TCodeEditor* editor = static_cast<TCodeEditor*>(ActiveMDIChild);
        RunCode(editor->mCode->Text, false);
    }
}
//---------------------------------------------------------------------------
void __fastcall TMain::sbRunClick(TObject *Sender)
{
    mCodeRun->Click();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mFileOpenClick(TObject *Sender)
{
    if (OpenDialog1->Execute())
    {
        TCodeEditor* editor;
        Application->CreateForm(__classid(TCodeEditor), &editor);
        if (!editor->LoadFromFile(OpenDialog1->FileName))
        {
            editor->Free();
            Application->MessageBox("Failed to open the file", "Error", MB_ICONERROR|MB_OK);
            return;
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TMain::sbOpenClick(TObject *Sender)
{
    mFileOpen->Click();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mFileSaveClick(TObject *Sender)
{
    if (ActiveMDIChild && dynamic_cast<TCodeEditor*>(ActiveMDIChild))
    {
        TCodeEditor* editor = static_cast<TCodeEditor*>(ActiveMDIChild);
        if (editor->FileName.IsEmpty())
        {
            mFileSaveAs->Click();
            return;
        }
        if (!editor->SaveToFile(editor->FileName))
        {
            Application->MessageBox("Failed to save the file", "Error", MB_ICONERROR|MB_OK);
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TMain::sbSaveClick(TObject *Sender)
{
    mFileSave->Click();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mFileSaveAsClick(TObject *Sender)
{
    if (ActiveMDIChild && dynamic_cast<TCodeEditor*>(ActiveMDIChild))
    {
        TCodeEditor* editor = static_cast<TCodeEditor*>(ActiveMDIChild);
        SaveDialog1->FileName = editor->FileName;
        if (SaveDialog1->Execute())
        {
            if (!editor->SaveToFile(SaveDialog1->FileName))
            {
                Application->MessageBox("Failed to save the file", "Error", MB_ICONERROR|MB_OK);
            }
        }
    }
}
//---------------------------------------------------------------------------
void __fastcall TMain::GenericTimer(TObject *Sender)
{
    static bool FirstTime = true;
    if (FirstTime)
    {
        FirstTime = False;
        Generic->Enabled = false;
        Generic->Interval = 50;
        ParseCommandLine();
        return;
    }
    if (!ONTimer.IsEmpty()) RunCode(ONTimer, false);
}
//---------------------------------------------------------------------------
void __fastcall TMain::mCodeClick(TObject *Sender)
{
    mCodeStopTimer->Enabled = Generic->Enabled;    
}
//---------------------------------------------------------------------------
void __fastcall TMain::mCodeStopTimerClick(TObject *Sender)
{
    Generic->Enabled = false;    
}
//---------------------------------------------------------------------------
void __fastcall TMain::mViewConsoleClick(TObject *Sender)
{
    ConsoleForm->BringToFront();    
}
//---------------------------------------------------------------------------
void __fastcall TMain::mViewGraphicsClick(TObject *Sender)
{
    if (!GraphicsForm)
    {
        Application->CreateForm(__classid(TGraphicsForm), &GraphicsForm);
    }
    GraphicsForm->BringToFront();
}
//---------------------------------------------------------------------------
void __fastcall TMain::sbViewConsoleClick(TObject *Sender)
{
    mViewConsole->Click();    
}
//---------------------------------------------------------------------------
void __fastcall TMain::sbViewGraphicsClick(TObject *Sender)
{
    mViewGraphics->Click();
}
//---------------------------------------------------------------------------
void __fastcall TMain::mHelpAboutClick(TObject *Sender)
{
    Application->MessageBox("WinLIL version 1.3 by Kostas \"Bad Sector\" Michalopoulos.\r\nBased on LIL pre-release 20190114 (Fossil checkin 2861a290a0).", "About...", MB_OK);
}
//---------------------------------------------------------------------------
