//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop
#include "UIGraphics.h"
#include "UIConsole.h"
#include "EDState.h"
#include "EDFuncs.h"
#include "UIMain.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TGraphicsForm *GraphicsForm;
//---------------------------------------------------------------------------
__fastcall TGraphicsForm::TGraphicsForm(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TGraphicsForm::pbScrPaint(TObject *Sender)
{
    if (Gfx->Width != pbScr->Width || Gfx->Height != pbScr->Height)
    {
        Graphics::TBitmap* newGfx = new Graphics::TBitmap();
        newGfx->Width = pbScr->Width;
        newGfx->Height = pbScr->Height;
        newGfx->Canvas->Draw(0, 0, Gfx);
        Gfx->Free();
        Gfx = newGfx;
    }
    pbScr->Canvas->Draw(0, 0, Gfx);
}
//---------------------------------------------------------------------------
void DamageGraphics()
{
    if (GraphicsForm) GraphicsForm->pbScr->Invalidate();
}
//---------------------------------------------------------------------------
void UpdateGraphics()
{
    if (GraphicsForm) GraphicsForm->pbScrPaint(0);
}
//---------------------------------------------------------------------------

void __fastcall TGraphicsForm::pbScrMouseDown(TObject *Sender,
    TMouseButton Button, TShiftState Shift, int X, int Y)
{
    if (Button == mbLeft && !ONDown.IsEmpty())
    {
        SetVar("x", IntToStr(X));
        SetVar("y", IntToStr(Y));
        RunCode(ONDown, false);
    }
}
//---------------------------------------------------------------------------
void __fastcall TGraphicsForm::pbScrMouseUp(TObject *Sender,
    TMouseButton Button, TShiftState Shift, int X, int Y)
{
    if (Button == mbLeft && !ONUp.IsEmpty())
    {
        SetVar("x", IntToStr(X));
        SetVar("y", IntToStr(Y));
        RunCode(ONUp, false);
    }
}
//---------------------------------------------------------------------------
void __fastcall TGraphicsForm::pbScrMouseMove(TObject *Sender,
    TShiftState Shift, int X, int Y)
{
    if (!ONMotion.IsEmpty())
    {
        SetVar("x", IntToStr(X));
        SetVar("y", IntToStr(Y));
        RunCode(ONMotion, false);
    }
}
//---------------------------------------------------------------------------
void __fastcall TGraphicsForm::FormKeyDown(TObject *Sender, WORD &Key,
    TShiftState Shift)
{
    if (!ONKey.IsEmpty())
    {
        SetVar("code", IntToStr(Key));
        SetVar("pressed", "1");
        RunCode(ONKey, false);
    }
}
//---------------------------------------------------------------------------
void __fastcall TGraphicsForm::FormKeyUp(TObject *Sender, WORD &Key,
    TShiftState Shift)
{
    if (!ONKey.IsEmpty())
    {
        SetVar("code", IntToStr(Key));
        SetVar("pressed", "0");
        RunCode(ONKey, false);
    }
}
//---------------------------------------------------------------------------
void __fastcall TGraphicsForm::FormKeyPress(TObject *Sender, char &Key)
{
    if (!ONChar.IsEmpty())
    {
        SetVar("character", Key);
        RunCode(ONChar, false);
    }
}
//---------------------------------------------------------------------------
void __fastcall TGraphicsForm::Panel1Resize(TObject *Sender)
{
    if (!ONSize.IsEmpty()) RunCode(ONSize, false);
    Main->RunOnSize = true;
}
//---------------------------------------------------------------------------
void __fastcall TGraphicsForm::FormClose(TObject *Sender, TCloseAction &Action)
{
    Action = caFree;
    GraphicsForm = NULL;    
}
//---------------------------------------------------------------------------
