unit MainUnit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, SynEdit, SynCompletion, SynHighlighterAny, Forms,
  Controls, Graphics, Dialogs, Menus, StdCtrls, ExtCtrls, ComCtrls, Buttons,
  LazLILGUI, FPLIL;

type

  { TMain }

  TMain = class(TForm)
    ApplicationProperties1: TApplicationProperties;
    edCmd: TEdit;
    ImageList1: TImageList;
    LazLILGUI1: TLazLILGUI;
    LIL1: TLIL;
    MainMenu1: TMainMenu;
    mEditRedo: TMenuItem;
    mEditBar1: TMenuItem;
    mEditCut: TMenuItem;
    mEditCopy: TMenuItem;
    mEditPaste: TMenuItem;
    mEditSelectAll: TMenuItem;
    mCode: TMenuItem;
    mCodeRun: TMenuItem;
    mCodeBar1: TMenuItem;
    mCodeClearOutput: TMenuItem;
    mCodeResetState: TMenuItem;
    mHelpAbout: TMenuItem;
    mHelp: TMenuItem;
    mOutput: TMemo;
    mEditUndo: TMenuItem;
    mFile: TMenuItem;
    mEdit: TMenuItem;
    mFileExit: TMenuItem;
    mFileNew: TMenuItem;
    mFileOpen: TMenuItem;
    mFileSave: TMenuItem;
    mFileSaveAs: TMenuItem;
    mFileBar1: TMenuItem;
    OpenDialog1: TOpenDialog;
    plBottomBar: TPanel;
    plSideBar: TPanel;
    SaveDialog1: TSaveDialog;
    Splitter1: TSplitter;
    Splitter2: TSplitter;
    StatusBar1: TStatusBar;
    SynAnySyn1: TSynAnySyn;
    SynCompletion1: TSynCompletion;
    SynEdit1: TSynEdit;
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    ToolButton12: TToolButton;
    ToolButton13: TToolButton;
    ToolButton14: TToolButton;
    ToolButton15: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    procedure ApplicationProperties1IdleEnd(Sender: TObject);
    procedure edCmdKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure edCmdKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormClose(Sender: TObject; var CloseAction: TCloseAction);
    procedure FormCloseQuery(Sender: TObject; var CanClose: boolean);
    procedure LIL1Error(LIL: TLIL; APosition: Integer; AMessage: string);
    procedure LIL1Exit(LIL: TLIL; Arg: TLILValue);
    procedure LIL1Write(LIL: TLIL; Chars: string);
    procedure mCodeClearOutputClick(Sender: TObject);
    procedure mCodeRunClick(Sender: TObject);
    procedure mEditCopyClick(Sender: TObject);
    procedure mEditCutClick(Sender: TObject);
    procedure mEditPasteClick(Sender: TObject);
    procedure mEditRedoClick(Sender: TObject);
    procedure mEditSelectAllClick(Sender: TObject);
    procedure mEditUndoClick(Sender: TObject);
    procedure mCodeResetStateClick(Sender: TObject);
    procedure mFileExitClick(Sender: TObject);
    procedure mFileNewClick(Sender: TObject);
    procedure mFileOpenClick(Sender: TObject);
    procedure mFileSaveAsClick(Sender: TObject);
    procedure mFileSaveClick(Sender: TObject);
    procedure mHelpAboutClick(Sender: TObject);
    procedure SynEdit1Change(Sender: TObject);
    procedure ToolButton10Click(Sender: TObject);
    procedure ToolButton11Click(Sender: TObject);
    procedure ToolButton13Click(Sender: TObject);
    procedure ToolButton15Click(Sender: TObject);
    procedure ToolButton1Click(Sender: TObject);
    procedure ToolButton2Click(Sender: TObject);
    procedure ToolButton3Click(Sender: TObject);
    procedure ToolButton4Click(Sender: TObject);
    procedure ToolButton6Click(Sender: TObject);
    procedure ToolButton7Click(Sender: TObject);
    procedure ToolButton9Click(Sender: TObject);
  private
    FFileName: string;
    procedure SetFileName(AValue: string);
    procedure UpdateCaption;
  public
    property FileName: string read FFileName write SetFileName;
  end;

var
  Main: TMain;

implementation

uses
  AboutUnit, LCLType;

{$R *.lfm}

{ TMain }

procedure TMain.ToolButton1Click(Sender: TObject);
begin
  mFileNew.Click;
end;

procedure TMain.ToolButton10Click(Sender: TObject);
begin
  mEditCopy.Click;
end;

procedure TMain.mEditUndoClick(Sender: TObject);
begin
  SynEdit1.Undo;
end;

procedure TMain.mCodeResetStateClick(Sender: TObject);
begin
  LazLILGUI1.RemoveLCLHost(plSideBar);
  LazLILGUI1.LIL:=nil;
  LIL1.Free;
  LIL1:=TLIL.Create(Self);
  LIL1.OnError:=@LIL1Error;
  LIL1.OnExit:=@LIL1Exit;
  LIL1.OnWrite:=@LIL1Write;
  LazLILGUI1.LIL:=LIL1;
  StatusBar1.Panels[2].Text:='';
end;

procedure TMain.mFileExitClick(Sender: TObject);
begin
  Close;
end;

procedure TMain.mFileNewClick(Sender: TObject);
begin
  if SynEdit1.Modified then begin
    if MessageDlg('The code from "' + FileName + '" has been modified. If you proceed you will lose your changes. Create new file and lose the changes?', mtWarning, mbYesNo, 0, mbNo) <> mrYes then Exit;
  end;
  mCodeResetState.Click;
  mCodeClearOutput.Click;
  SynEdit1.Clear;
  SynEdit1.ClearUndo;
  StatusBar1.Panels[2].Text:='New file';
end;

procedure TMain.mFileOpenClick(Sender: TObject);
begin
  if SynEdit1.Modified then begin
    if MessageDlg('The code from "' + FileName + '" has been modified. If you proceed you will lose your changes. Open another file and lose the changes?', mtWarning, mbYesNo, 0, mbNo) <> mrYes then Exit;
  end;
  if OpenDialog1.Execute then begin
    try
      SynEdit1.Lines.LoadFromFile(OpenDialog1.FileName);
    except
      MessageDlg('Error', 'Failed to open "' + OpenDialog1.FileName + '"', mtError, [mbOK], 0);
      Exit;
    end;
    SynEdit1.ClearUndo;
    SynEdit1.Modified:=False;
    FileName:=OpenDialog1.FileName;
    StatusBar1.Panels[2].Text:='Opened ' + FileName;
  end;
end;

procedure TMain.mFileSaveAsClick(Sender: TObject);
begin
  if SaveDialog1.Execute then begin
    FileName:=SaveDialog1.FileName;
    mFileSave.Click;
  end;
end;

procedure TMain.mFileSaveClick(Sender: TObject);
begin
  if FileName='' then begin
    mFileSaveAs.Click;
    Exit;
  end;
  try
    SynEdit1.Lines.SaveToFile(FileName);
  except
    MessageDlg('Error', 'Failed to save "' + SaveDialog1.FileName + '"', mtError, [mbOK], 0);
    Exit;
  end;
  SynEdit1.MarkTextAsSaved;
  SynEdit1.Modified:=False;
  StatusBar1.Panels[2].Text:='Saved ' + FileName;
  UpdateCaption;
end;

procedure TMain.mHelpAboutClick(Sender: TObject);
begin
  Application.CreateForm(TAboutBox, AboutBox);
  AboutBox.ShowModal;
  AboutBox.Free;
end;

procedure TMain.SynEdit1Change(Sender: TObject);
begin
  UpdateCaption;
end;

procedure TMain.mEditRedoClick(Sender: TObject);
begin
  SynEdit1.Redo;
end;

procedure TMain.mEditSelectAllClick(Sender: TObject);
begin
  SynEdit1.SelectAll;
end;

procedure TMain.mEditCutClick(Sender: TObject);
begin
  SynEdit1.CutToClipboard;
end;

procedure TMain.mEditPasteClick(Sender: TObject);
begin
  SynEdit1.PasteFromClipboard;
end;

procedure TMain.mEditCopyClick(Sender: TObject);
begin
  SynEdit1.CopyToClipboard;
end;

procedure TMain.mCodeClearOutputClick(Sender: TObject);
begin
  mOutput.Clear;
end;

procedure TMain.FormClose(Sender: TObject; var CloseAction: TCloseAction);
begin
  // Normally this isn't necessary, however it is needed in this case
  // since we are destroying LIL components to reset them and we may have
  // lingering references around
  LazLILGUI1.RemoveLCLHost(plSideBar);
end;

procedure TMain.FormCloseQuery(Sender: TObject; var CanClose: boolean);
begin
  CanClose:=False;
  if SynEdit1.Modified then begin
    if MessageDlg('The code from "' + FileName + '" has been modified. If you proceed you will lose your changes. Exit and lose the changes?', mtWarning, mbYesNo, 0, mbNo) <> mrYes then Exit;
  end;
  CanClose:=True;
end;

procedure TMain.edCmdKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if Key=VK_RETURN then begin
    LIL1.Parse(edCmd.Text).Free;
    edCmd.Text:='';
    Key:=0;
  end;
end;

procedure TMain.ApplicationProperties1IdleEnd(Sender: TObject);
begin
  ToolButton6.Enabled:=SynEdit1.CanUndo;
  mEditUndo.Enabled:=SynEdit1.CanUndo;
  ToolButton7.Enabled:=SynEdit1.CanRedo;
  mEditRedo.Enabled:=SynEdit1.CanRedo;
  ToolButton9.Enabled:=SynEdit1.SelText <> '';
  mEditCut.Enabled:=ToolButton9.Enabled;
  ToolButton10.Enabled:=SynEdit1.SelText <> '';
  mEditCopy.Enabled:=ToolButton10.Enabled;
  ToolButton11.Enabled:=SynEdit1.CanPaste;
  mEditPaste.Enabled:=ToolButton11.Enabled;
  StatusBar1.Panels[0].Text:=IntToStr(SynEdit1.CaretY);
  StatusBar1.Panels[1].Text:=IntToStr(SynEdit1.CaretX);
end;

procedure TMain.edCmdKeyUp(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  if Key=VK_RETURN then Key:=0;
end;

procedure TMain.LIL1Error(LIL: TLIL; APosition: Integer; AMessage: string);
begin
  mOutput.Lines.BeginUpdate;
  mOutput.Lines.Add('LIL Error: ' + AMessage);
  mOutput.Lines.Add('Error at ' + IntToStr(APosition) + ' when parsing ' + LIL.EvaluatedCode);
  mOutput.Lines.EndUpdate;
  mOutput.SelStart:=Length(mOutput.Text);
  StatusBar1.Panels[2].Text:='LIL Error: ' + AMessage;
end;

procedure TMain.LIL1Exit(LIL: TLIL; Arg: TLILValue);
begin
  Close;
end;

procedure TMain.LIL1Write(LIL: TLIL; Chars: string);
var
  I: Integer;
  S: string;
begin
  mOutput.Lines.BeginUpdate;
  S:='';
  for I:=1 to Length(Chars) do begin
    if Chars[I]=#10 then begin
      mOutput.Text:=mOutput.Text + S + LineEnding;
      S:='';
    end else S += Chars[I];
  end;
  if S <> '' then mOutput.Text:=mOutput.Text + S;
  mOutput.Lines.EndUpdate;
  mOutput.SelStart:=Length(mOutput.Text);
end;

procedure TMain.mCodeRunClick(Sender: TObject);
begin
  // Remove and add the host so that any previously created controls
  // will be destroyed
  LazLILGUI1.RemoveLCLHost(plSideBar);
  LazLILGUI1.AddLCLHost(plSideBar, True);
  LIL1.Parse(SynEdit1.Text).Free;
end;

procedure TMain.ToolButton11Click(Sender: TObject);
begin
  mEditPaste.Click;
end;

procedure TMain.ToolButton13Click(Sender: TObject);
begin
  mCodeRun.Click;
end;

procedure TMain.ToolButton15Click(Sender: TObject);
begin
  mHelpAbout.Click;
end;

procedure TMain.ToolButton2Click(Sender: TObject);
begin
  mFileOpen.Click;
end;

procedure TMain.ToolButton3Click(Sender: TObject);
begin
  mFileSave.Click;
end;

procedure TMain.ToolButton4Click(Sender: TObject);
begin
  mFileSaveAs.Click;
end;

procedure TMain.ToolButton6Click(Sender: TObject);
begin
  mEditUndo.Click;
end;

procedure TMain.ToolButton7Click(Sender: TObject);
begin
  mEditRedo.Click;
end;

procedure TMain.ToolButton9Click(Sender: TObject);
begin
  mEditCut.Click;
end;

procedure TMain.SetFileName(AValue: string);
begin
  if FFileName=AValue then Exit;
  FFileName:=AValue;
  UpdateCaption;
end;

procedure TMain.UpdateCaption;
begin
  if SynEdit1.Modified then begin
    if FileName='' then
      Caption:='(untitled)* - LazLILGUI Notepad'
    else
      Caption:=ExtractFileName(FileName) + '* - LazLILGUI Nodepad';
  end else begin
    if FileName='' then
      Caption:='LazLILGUI Notepad'
    else
      Caption:=ExtractFileName(FileName) + ' - LazLILGUI Nodepad';
  end;
end;

end.

