unit Unit1;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, Graphics, Dialogs, StdCtrls,
  ExtCtrls, LazLILGUI, FPLIL;

type

  { TForm1 }

  TForm1 = class(TForm)
    Button1: TButton;
    Label1: TLabel;
    LazLILGUI1: TLazLILGUI;
    LIL1: TLIL;
    Memo1: TMemo;
    Panel1: TPanel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure LIL1Error(LIL: TLIL; APosition: Integer; AMessage: string);
  private
    { private declarations }
  public
    { public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  AlphaColorUnit;

type

  { TLILGUIColorControl - the actual LILGUI control }

  TLILGUIColorControl = class(TLILGUIControl)
  private
    // The bound variable, if any
    ValueVar: TLILVariable;
    // Sent by the control when the value changes
    procedure OnChange(Sender: TObject);
    // Sent by LIL when the variable changes
    procedure OnVarChange(Sender: TObject);
    // Called by FncControl to setup the variable bind
    procedure SetupBind(AVarNameValue: TLILValue);
  protected
    // Called by LazLILGUI to setup the control after it has been created
    procedure SetupControl; override;
  public
    // We need the destructor to unwatch the variable
    destructor Destroy; override;
  end;

{$R *.lfm}

{ Global }

// This is the LIL function that will make the control available
function FncColor(LIL: TLIL; Args: TLILFunctionProcArgs): TLILValue;
var
  LCLControl: TAlphaColorFrame;
  Control: TLILGUIControl;
begin
  // Create the LCL control.  We use the LIL instance as the owner of the new
  // control since we are keeping a TLILVariable instance owned by LIL
  LCLControl:=TAlphaColorFrame.Create(Form1.LIL1);
  // Create the LILGUI control
  Control:=Form1.LazLILGUI1.CreateGUIControl(LCLControl, TLILGUIColorControl);
  // Bind the variable
  if (Length(Args) > 0) then
    TLILGUIColorControl(Control).SetupBind(Args[0]);
  // Return the control's id as a value
  Result:=Control.ToValue;
end;

{ TLILGUIColorControl }

procedure TLILGUIColorControl.OnChange(Sender: TObject);
var
  Tmp: TLILValue;
begin
  if Assigned(ValueVar) then begin
    // We need to convert the value from the control to a LIL value that
    // can be assigned to the LIL variable
    Tmp:=TLIL.AllocString(TAlphaColorFrame(LCLControl).Value);
    ValueVar.Value:=Tmp;
    Tmp.Free; // We don't need the LIL value anymore
  end;
end;

procedure TLILGUIColorControl.OnVarChange(Sender: TObject);
begin
  // Disable event checking to avoid circular calls
  TAlphaColorFrame(LCLControl).OnChange:=nil;
  TAlphaColorFrame(LCLControl).Value:=TLIL.ToString(ValueVar.Value);
  TAlphaColorFrame(LCLControl).OnChange:=@OnChange;
end;

procedure TLILGUIColorControl.SetupBind(AVarNameValue: TLILValue);
begin
  ValueVar:=SetupVar(TLIL.ToString(AVarNameValue), @OnVarChange);
end;

procedure TLILGUIColorControl.SetupControl;
begin
  inherited SetupControl;
  TAlphaColorFrame(LCLControl).OnChange:=@OnChange;
end;

destructor TLILGUIColorControl.Destroy;
begin
  // Remove the watch
  if Assigned(ValueVar) then ValueVar.RemoveWatch(@OnVarChange);
  inherited Destroy;
end;

{ TForm1 }

procedure TForm1.LIL1Error(LIL: TLIL; APosition: Integer; AMessage: string);
begin
  ShowMessage('Error at ' + IntToStr(APosition) + ': ' + AMessage + LineEnding + 'While parsing: ' + LIL.EvaluatedCode);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  // Remove previous controls by removing and readding the host
  LazLILGUI1.RemoveLCLHost(Panel1);
  LazLILGUI1.AddLCLHost(Panel1, True);
  // Parse the code
  LIL1.Parse(Memo1.Text).Free;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  // Register the new function that will create the control
  LIL1.Register('color', @FncColor);
end;

end.

