unit AlphaColorUnit;

{$mode objfpc}{$H+}

interface

uses
  Classes, SysUtils, FileUtil, Forms, Controls, StdCtrls, Dialogs, ComCtrls,
  Graphics;

type

  { TAlphaColorFrame }

  TAlphaColorFrame = class(TFrame)
    ColorButton1: TColorButton;
    Label1: TLabel;
    Label2: TLabel;
    TrackBar1: TTrackBar;
    procedure ColorButton1ColorChanged(Sender: TObject);
  private
    FOnChange: TNotifyEvent;
    function GetValue: string;
    procedure SetValue(AValue: string);
  public
    property OnChange: TNotifyEvent read FOnChange write FOnChange;
    property Value: string read GetValue write SetValue;
  end;

implementation

{$R *.lfm}

{ TAlphaColorFrame }

procedure TAlphaColorFrame.ColorButton1ColorChanged(Sender: TObject);
begin
  if Assigned(FOnChange) then FOnChange(Self);
end;

function TAlphaColorFrame.GetValue: string;
var
  RGB, Alpha: QWord;
begin
  RGB:=DWORD(ColorButton1.ButtonColor) and $FFFFFF;
  Alpha:=TrackBar1.Position shl 24;
  Result:=HexStr(RGB + Alpha, 8);
end;

procedure TAlphaColorFrame.SetValue(AValue: string);
var
  HexVal: Int64;
begin
  HexVal:=StrToInt64Def('$' + AValue, 0);
  ColorButton1.ButtonColor:=TColor(HexVal and $FFFFFF);
  TrackBar1.Position:=HexVal shr 24;
end;

end.

