#define LFORMS_SOURCE_CODE
#include <ctype.h>
#include <lforms.h>

#define MAXWORDLEN 256

struct scanner
{
    const char* code;
    int head, num, wlen;
    char word[MAXWORDLEN];
};

struct cment
{
    const char* chr;
    ff_color_t col;
};

struct symcol
{
    char* name;
    ff_color_t col;
};

static struct symcol* symcol;
static size_t symcols;

static void free_symcol(void)
{
    size_t i;
    for (i=0; i < symcols; i++) free(symcol[i].name);
    free(symcol);
}

static void init_symcol(void)
{
    ff_atexit(free_symcol);
    ff_xpmsym("none", FF_RGB(255, 0, 255));
    ff_xpmsym("3d-face", FF_3DFACE_COLOR);
    ff_xpmsym("3d-shadow", FF_3DSHADOW_COLOR);
    ff_xpmsym("3d-dark", FF_3DDARK_COLOR);
    ff_xpmsym("3d-light", FF_3DLIGHT_COLOR);
    ff_xpmsym("3d-text", FF_3DTEXT_COLOR);
    ff_xpmsym("3d-disabled-text", FF_3DDISABLEDTEXT_COLOR);
    ff_xpmsym("active", FF_ACTIVE_COLOR);
    ff_xpmsym("active-text", FF_ACTEXT_COLOR);
    ff_xpmsym("editor", FF_EDITOR_COLOR);
    ff_xpmsym("editor-text", FF_EDTEXT_COLOR);
    ff_xpmsym("editor-disabled-text", FF_EDDISABLEDTEXT_COLOR);
    ff_xpmsym("track", FF_TRACK_COLOR);
    ff_xpmsym("dark-track", FF_DARKTRACK_COLOR);
    ff_xpmsym("scrollbar-border", FF_SCROLLBAR_BORDER_COLOR);
    ff_xpmsym("scrollbar-pad", FF_SCROLLBAR_PAD_COLOR);
    ff_xpmsym("scrollbar", FF_SCROLLBAR_COLOR);
    ff_xpmsym("menu", FF_MENU_COLOR);
    ff_xpmsym("menu-text", FF_MENUTEXT_COLOR);
}

static ff_color_t symcolor(const char* name)
{
    size_t i;
    if (!symcols) init_symcol();
    for (i=0; i < symcols; i++)
        if (!strcmp(name, symcol[i].name))
            return symcol[i].col;
    return 0;
}

static char* scanword(struct scanner* p)
{
    while (isspace(p->code[p->head])) p->head++;
    p->wlen = 0;
    while (p->code[p->head] &&
           !isspace(p->code[p->head]) &&
           p->wlen + 1 < MAXWORDLEN)
        p->word[p->wlen++] = (char)tolower(p->code[p->head++]);
    p->word[p->wlen] = 0;
    return p->word;
}

static int scannum(struct scanner* p)
{
    while (isspace(p->code[p->head])) p->head++;
    p->num = 0;
    while (p->code[p->head] &&
           isdigit(p->code[p->head]))
        p->num = p->num*10 + (p->code[p->head++] - '0');
    return p->num;
}

static char* scanpart(struct scanner* p, int len)
{
    p->wlen = 0;
    while (p->code[p->head] && p->wlen < len)
        p->word[p->wlen++] = p->code[p->head++];
    p->word[p->wlen] = 0;
    return p->word;
}

static ff_bitmap_t do_xpm(char** code, int lines, int* xhot, int* yhot)
{
    struct scanner p = {0};
    ff_color_t* rgba;
    ff_color_t* tgt;
    ff_bitmap_t bmp = NULL;
    struct cment* cmap;
    int i, x, w, h, cpp, cmsize, r;
    if (!code || !code[0]) return NULL;
    p.code = code[0];
    w = scannum(&p);
    h = scannum(&p);
    if (w > 16384 || h > 16384) return NULL;
    cmsize = scannum(&p);
    cpp = scannum(&p);
    if (cpp + 1 > MAXWORDLEN) return NULL;
    i = scannum(&p); if (xhot) *xhot = i;
    i = scannum(&p); if (yhot) *yhot = i;
    if (w < 1 || h < 1 || cmsize < 1 || cpp < 1) return NULL;
    tgt = rgba = calloc(1, sizeof(ff_color_t)*(size_t)(w*h));
    if (!rgba) return NULL;
    cmap = calloc(1, sizeof(struct cment)*(size_t)cmsize);
    if (!cmap) {
        free(rgba);
        return NULL;
    }
    lines--;
    for (r=1; r <= cmsize && lines > 0; r++,lines--) {
        if (!code[r]) {
            free(cmap);
            free(rgba);
            return NULL;
        }
        p.code = code[r];
        p.head = 0;
        cmap[r - 1].chr = p.code + p.head;
        scanpart(&p, cpp);
        scanword(&p);
        if (!strcmp(p.word, "c")) {
            scanword(&p);
            if (p.word[0] == '#' &&
                isxdigit(p.word[1]) &&
                isxdigit(p.word[2]) &&
                isxdigit(p.word[3])) {
                int R, G, B;
                char v[5] = {0, 0, 0, 0, 0};
                if (isxdigit(p.word[4]) &&
                    isxdigit(p.word[5]) &&
                    isxdigit(p.word[6])) {
                    if (isxdigit(p.word[7]) &&
                        isxdigit(p.word[8]) &&
                        isxdigit(p.word[9]) &&
                        isxdigit(p.word[10]) &&
                        isxdigit(p.word[11]) &&
                        isxdigit(p.word[12])) {
                        v[0] = p.word[1];
                        v[1] = p.word[2];
                        v[2] = p.word[3];
                        v[3] = p.word[4];
                        R = (int)(strtol(v, NULL, 16) >> 8U);
                        v[0] = p.word[5];
                        v[1] = p.word[6];
                        v[2] = p.word[7];
                        v[3] = p.word[8];
                        G = (int)(strtol(v, NULL, 16) >> 8U);
                        v[0] = p.word[9];
                        v[1] = p.word[10];
                        v[2] = p.word[11];
                        v[3] = p.word[12];
                        B = (int)(strtol(v, NULL, 16) >> 8U);
                    } else {
                        v[0] = p.word[1];
                        v[1] = p.word[2];
                        R = (int)strtol(v, NULL, 16);
                        v[0] = p.word[3];
                        v[1] = p.word[4];
                        G = (int)strtol(v, NULL, 16);
                        v[0] = p.word[5];
                        v[1] = p.word[6];
                        B = (int)strtol(v, NULL, 16);
                    }
                } else {
                    v[0] = p.word[1];
                    R = (int)(strtol(v, NULL, 16) << 4U);
                    v[0] = p.word[2];
                    G = (int)(strtol(v, NULL, 16) << 4U);
                    v[0] = p.word[3];
                    B = (int)(strtol(v, NULL, 16) << 4U);
                }
                cmap[r - 1].col = FF_RGB(R, G, B);
            } else if (!strcmp(p.word, "none")) cmap[r - 1].col = FF_RGB(255, 0, 255);
            else if (!strcmp(p.word, "snow")) cmap[r - 1].col = FF_RGB(255, 250, 250);
            else if (!strcmp(p.word, "ghost white")) cmap[r - 1].col = FF_RGB(248, 248, 255);
            else if (!strcmp(p.word, "ghostwhite")) cmap[r - 1].col = FF_RGB(248, 248, 255);
            else if (!strcmp(p.word, "white smoke")) cmap[r - 1].col = FF_RGB(245, 245, 245);
            else if (!strcmp(p.word, "whitesmoke")) cmap[r - 1].col = FF_RGB(245, 245, 245);
            else if (!strcmp(p.word, "gainsboro")) cmap[r - 1].col = FF_RGB(220, 220, 220);
            else if (!strcmp(p.word, "floral white")) cmap[r - 1].col = FF_RGB(255, 250, 240);
            else if (!strcmp(p.word, "floralwhite")) cmap[r - 1].col = FF_RGB(255, 250, 240);
            else if (!strcmp(p.word, "old lace")) cmap[r - 1].col = FF_RGB(253, 245, 230);
            else if (!strcmp(p.word, "oldlace")) cmap[r - 1].col = FF_RGB(253, 245, 230);
            else if (!strcmp(p.word, "linen")) cmap[r - 1].col = FF_RGB(250, 240, 230);
            else if (!strcmp(p.word, "antique white")) cmap[r - 1].col = FF_RGB(250, 235, 215);
            else if (!strcmp(p.word, "antiquewhite")) cmap[r - 1].col = FF_RGB(250, 235, 215);
            else if (!strcmp(p.word, "papaya whip")) cmap[r - 1].col = FF_RGB(255, 239, 213);
            else if (!strcmp(p.word, "papayawhip")) cmap[r - 1].col = FF_RGB(255, 239, 213);
            else if (!strcmp(p.word, "blanched almond")) cmap[r - 1].col = FF_RGB(255, 235, 205);
            else if (!strcmp(p.word, "blanchedalmond")) cmap[r - 1].col = FF_RGB(255, 235, 205);
            else if (!strcmp(p.word, "bisque")) cmap[r - 1].col = FF_RGB(255, 228, 196);
            else if (!strcmp(p.word, "peach puff")) cmap[r - 1].col = FF_RGB(255, 218, 185);
            else if (!strcmp(p.word, "peachpuff")) cmap[r - 1].col = FF_RGB(255, 218, 185);
            else if (!strcmp(p.word, "navajo white")) cmap[r - 1].col = FF_RGB(255, 222, 173);
            else if (!strcmp(p.word, "navajowhite")) cmap[r - 1].col = FF_RGB(255, 222, 173);
            else if (!strcmp(p.word, "moccasin")) cmap[r - 1].col = FF_RGB(255, 228, 181);
            else if (!strcmp(p.word, "cornsilk")) cmap[r - 1].col = FF_RGB(255, 248, 220);
            else if (!strcmp(p.word, "ivory")) cmap[r - 1].col = FF_RGB(255, 255, 240);
            else if (!strcmp(p.word, "lemon chiffon")) cmap[r - 1].col = FF_RGB(255, 250, 205);
            else if (!strcmp(p.word, "lemonchiffon")) cmap[r - 1].col = FF_RGB(255, 250, 205);
            else if (!strcmp(p.word, "seashell")) cmap[r - 1].col = FF_RGB(255, 245, 238);
            else if (!strcmp(p.word, "honeydew")) cmap[r - 1].col = FF_RGB(240, 255, 240);
            else if (!strcmp(p.word, "mint cream")) cmap[r - 1].col = FF_RGB(245, 255, 250);
            else if (!strcmp(p.word, "mintcream")) cmap[r - 1].col = FF_RGB(245, 255, 250);
            else if (!strcmp(p.word, "azure")) cmap[r - 1].col = FF_RGB(240, 255, 255);
            else if (!strcmp(p.word, "alice blue")) cmap[r - 1].col = FF_RGB(240, 248, 255);
            else if (!strcmp(p.word, "aliceblue")) cmap[r - 1].col = FF_RGB(240, 248, 255);
            else if (!strcmp(p.word, "lavender")) cmap[r - 1].col = FF_RGB(230, 230, 250);
            else if (!strcmp(p.word, "lavender blush")) cmap[r - 1].col = FF_RGB(255, 240, 245);
            else if (!strcmp(p.word, "lavenderblush")) cmap[r - 1].col = FF_RGB(255, 240, 245);
            else if (!strcmp(p.word, "misty rose")) cmap[r - 1].col = FF_RGB(255, 228, 225);
            else if (!strcmp(p.word, "mistyrose")) cmap[r - 1].col = FF_RGB(255, 228, 225);
            else if (!strcmp(p.word, "white")) cmap[r - 1].col = FF_RGB(255, 255, 255);
            else if (!strcmp(p.word, "black")) cmap[r - 1].col = FF_RGB(0, 0, 0);
            else if (!strcmp(p.word, "dark slate gray")) cmap[r - 1].col = FF_RGB(47, 79, 79);
            else if (!strcmp(p.word, "darkslategray")) cmap[r - 1].col = FF_RGB(47, 79, 79);
            else if (!strcmp(p.word, "dark slate grey")) cmap[r - 1].col = FF_RGB(47, 79, 79);
            else if (!strcmp(p.word, "darkslategrey")) cmap[r - 1].col = FF_RGB(47, 79, 79);
            else if (!strcmp(p.word, "dim gray")) cmap[r - 1].col = FF_RGB(105, 105, 105);
            else if (!strcmp(p.word, "dimgray")) cmap[r - 1].col = FF_RGB(105, 105, 105);
            else if (!strcmp(p.word, "dim grey")) cmap[r - 1].col = FF_RGB(105, 105, 105);
            else if (!strcmp(p.word, "dimgrey")) cmap[r - 1].col = FF_RGB(105, 105, 105);
            else if (!strcmp(p.word, "slate gray")) cmap[r - 1].col = FF_RGB(112, 128, 144);
            else if (!strcmp(p.word, "slategray")) cmap[r - 1].col = FF_RGB(112, 128, 144);
            else if (!strcmp(p.word, "slate grey")) cmap[r - 1].col = FF_RGB(112, 128, 144);
            else if (!strcmp(p.word, "slategrey")) cmap[r - 1].col = FF_RGB(112, 128, 144);
            else if (!strcmp(p.word, "light slate gray")) cmap[r - 1].col = FF_RGB(119, 136, 153);
            else if (!strcmp(p.word, "lightslategray")) cmap[r - 1].col = FF_RGB(119, 136, 153);
            else if (!strcmp(p.word, "light slate grey")) cmap[r - 1].col = FF_RGB(119, 136, 153);
            else if (!strcmp(p.word, "lightslategrey")) cmap[r - 1].col = FF_RGB(119, 136, 153);
            else if (!strcmp(p.word, "gray")) cmap[r - 1].col = FF_RGB(190, 190, 190);
            else if (!strcmp(p.word, "grey")) cmap[r - 1].col = FF_RGB(190, 190, 190);
            else if (!strcmp(p.word, "light grey")) cmap[r - 1].col = FF_RGB(211, 211, 211);
            else if (!strcmp(p.word, "lightgrey")) cmap[r - 1].col = FF_RGB(211, 211, 211);
            else if (!strcmp(p.word, "light gray")) cmap[r - 1].col = FF_RGB(211, 211, 211);
            else if (!strcmp(p.word, "lightgray")) cmap[r - 1].col = FF_RGB(211, 211, 211);
            else if (!strcmp(p.word, "midnight blue")) cmap[r - 1].col = FF_RGB(25, 25, 112);
            else if (!strcmp(p.word, "midnightblue")) cmap[r - 1].col = FF_RGB(25, 25, 112);
            else if (!strcmp(p.word, "navy")) cmap[r - 1].col = FF_RGB(0, 0, 128);
            else if (!strcmp(p.word, "navy blue")) cmap[r - 1].col = FF_RGB(0, 0, 128);
            else if (!strcmp(p.word, "navyblue")) cmap[r - 1].col = FF_RGB(0, 0, 128);
            else if (!strcmp(p.word, "cornflower blue")) cmap[r - 1].col = FF_RGB(100, 149, 237);
            else if (!strcmp(p.word, "cornflowerblue")) cmap[r - 1].col = FF_RGB(100, 149, 237);
            else if (!strcmp(p.word, "dark slate blue")) cmap[r - 1].col = FF_RGB(72, 61, 139);
            else if (!strcmp(p.word, "darkslateblue")) cmap[r - 1].col = FF_RGB(72, 61, 139);
            else if (!strcmp(p.word, "slate blue")) cmap[r - 1].col = FF_RGB(106, 90, 205);
            else if (!strcmp(p.word, "slateblue")) cmap[r - 1].col = FF_RGB(106, 90, 205);
            else if (!strcmp(p.word, "medium slate blue")) cmap[r - 1].col = FF_RGB(123, 104, 238);
            else if (!strcmp(p.word, "mediumslateblue")) cmap[r - 1].col = FF_RGB(123, 104, 238);
            else if (!strcmp(p.word, "light slate blue")) cmap[r - 1].col = FF_RGB(132, 112, 255);
            else if (!strcmp(p.word, "lightslateblue")) cmap[r - 1].col = FF_RGB(132, 112, 255);
            else if (!strcmp(p.word, "medium blue")) cmap[r - 1].col = FF_RGB(0, 0, 205);
            else if (!strcmp(p.word, "mediumblue")) cmap[r - 1].col = FF_RGB(0, 0, 205);
            else if (!strcmp(p.word, "royal blue")) cmap[r - 1].col = FF_RGB(65, 105, 225);
            else if (!strcmp(p.word, "royalblue")) cmap[r - 1].col = FF_RGB(65, 105, 225);
            else if (!strcmp(p.word, "blue")) cmap[r - 1].col = FF_RGB(0, 0, 255);
            else if (!strcmp(p.word, "dodger blue")) cmap[r - 1].col = FF_RGB(30, 144, 255);
            else if (!strcmp(p.word, "dodgerblue")) cmap[r - 1].col = FF_RGB(30, 144, 255);
            else if (!strcmp(p.word, "deep sky blue")) cmap[r - 1].col = FF_RGB(0, 191, 255);
            else if (!strcmp(p.word, "deepskyblue")) cmap[r - 1].col = FF_RGB(0, 191, 255);
            else if (!strcmp(p.word, "sky blue")) cmap[r - 1].col = FF_RGB(135, 206, 235);
            else if (!strcmp(p.word, "skyblue")) cmap[r - 1].col = FF_RGB(135, 206, 235);
            else if (!strcmp(p.word, "light sky blue")) cmap[r - 1].col = FF_RGB(135, 206, 250);
            else if (!strcmp(p.word, "lightskyblue")) cmap[r - 1].col = FF_RGB(135, 206, 250);
            else if (!strcmp(p.word, "steel blue")) cmap[r - 1].col = FF_RGB(70, 130, 180);
            else if (!strcmp(p.word, "steelblue")) cmap[r - 1].col = FF_RGB(70, 130, 180);
            else if (!strcmp(p.word, "light steel blue")) cmap[r - 1].col = FF_RGB(176, 196, 222);
            else if (!strcmp(p.word, "lightsteelblue")) cmap[r - 1].col = FF_RGB(176, 196, 222);
            else if (!strcmp(p.word, "light blue")) cmap[r - 1].col = FF_RGB(173, 216, 230);
            else if (!strcmp(p.word, "lightblue")) cmap[r - 1].col = FF_RGB(173, 216, 230);
            else if (!strcmp(p.word, "powder blue")) cmap[r - 1].col = FF_RGB(176, 224, 230);
            else if (!strcmp(p.word, "powderblue")) cmap[r - 1].col = FF_RGB(176, 224, 230);
            else if (!strcmp(p.word, "pale turquoise")) cmap[r - 1].col = FF_RGB(175, 238, 238);
            else if (!strcmp(p.word, "paleturquoise")) cmap[r - 1].col = FF_RGB(175, 238, 238);
            else if (!strcmp(p.word, "dark turquoise")) cmap[r - 1].col = FF_RGB(0, 206, 209);
            else if (!strcmp(p.word, "darkturquoise")) cmap[r - 1].col = FF_RGB(0, 206, 209);
            else if (!strcmp(p.word, "medium turquoise")) cmap[r - 1].col = FF_RGB(72, 209, 204);
            else if (!strcmp(p.word, "mediumturquoise")) cmap[r - 1].col = FF_RGB(72, 209, 204);
            else if (!strcmp(p.word, "turquoise")) cmap[r - 1].col = FF_RGB(64, 224, 208);
            else if (!strcmp(p.word, "cyan")) cmap[r - 1].col = FF_RGB(0, 255, 255);
            else if (!strcmp(p.word, "light cyan")) cmap[r - 1].col = FF_RGB(224, 255, 255);
            else if (!strcmp(p.word, "lightcyan")) cmap[r - 1].col = FF_RGB(224, 255, 255);
            else if (!strcmp(p.word, "cadet blue")) cmap[r - 1].col = FF_RGB(95, 158, 160);
            else if (!strcmp(p.word, "cadetblue")) cmap[r - 1].col = FF_RGB(95, 158, 160);
            else if (!strcmp(p.word, "medium aquamarine")) cmap[r - 1].col = FF_RGB(102, 205, 170);
            else if (!strcmp(p.word, "mediumaquamarine")) cmap[r - 1].col = FF_RGB(102, 205, 170);
            else if (!strcmp(p.word, "aquamarine")) cmap[r - 1].col = FF_RGB(127, 255, 212);
            else if (!strcmp(p.word, "dark green")) cmap[r - 1].col = FF_RGB(0, 100, 0);
            else if (!strcmp(p.word, "darkgreen")) cmap[r - 1].col = FF_RGB(0, 100, 0);
            else if (!strcmp(p.word, "dark olive green")) cmap[r - 1].col = FF_RGB(85, 107, 47);
            else if (!strcmp(p.word, "darkolivegreen")) cmap[r - 1].col = FF_RGB(85, 107, 47);
            else if (!strcmp(p.word, "dark sea green")) cmap[r - 1].col = FF_RGB(143, 188, 143);
            else if (!strcmp(p.word, "darkseagreen")) cmap[r - 1].col = FF_RGB(143, 188, 143);
            else if (!strcmp(p.word, "sea green")) cmap[r - 1].col = FF_RGB(46, 139, 87);
            else if (!strcmp(p.word, "seagreen")) cmap[r - 1].col = FF_RGB(46, 139, 87);
            else if (!strcmp(p.word, "medium sea green")) cmap[r - 1].col = FF_RGB(60, 179, 113);
            else if (!strcmp(p.word, "mediumseagreen")) cmap[r - 1].col = FF_RGB(60, 179, 113);
            else if (!strcmp(p.word, "light sea green")) cmap[r - 1].col = FF_RGB(32, 178, 170);
            else if (!strcmp(p.word, "lightseagreen")) cmap[r - 1].col = FF_RGB(32, 178, 170);
            else if (!strcmp(p.word, "pale green")) cmap[r - 1].col = FF_RGB(152, 251, 152);
            else if (!strcmp(p.word, "palegreen")) cmap[r - 1].col = FF_RGB(152, 251, 152);
            else if (!strcmp(p.word, "spring green")) cmap[r - 1].col = FF_RGB(0, 255, 127);
            else if (!strcmp(p.word, "springgreen")) cmap[r - 1].col = FF_RGB(0, 255, 127);
            else if (!strcmp(p.word, "lawn green")) cmap[r - 1].col = FF_RGB(124, 252, 0);
            else if (!strcmp(p.word, "lawngreen")) cmap[r - 1].col = FF_RGB(124, 252, 0);
            else if (!strcmp(p.word, "green")) cmap[r - 1].col = FF_RGB(0, 255, 0);
            else if (!strcmp(p.word, "chartreuse")) cmap[r - 1].col = FF_RGB(127, 255, 0);
            else if (!strcmp(p.word, "medium spring green")) cmap[r - 1].col = FF_RGB(0, 250, 154);
            else if (!strcmp(p.word, "mediumspringgreen")) cmap[r - 1].col = FF_RGB(0, 250, 154);
            else if (!strcmp(p.word, "green yellow")) cmap[r - 1].col = FF_RGB(173, 255, 47);
            else if (!strcmp(p.word, "greenyellow")) cmap[r - 1].col = FF_RGB(173, 255, 47);
            else if (!strcmp(p.word, "lime green")) cmap[r - 1].col = FF_RGB(50, 205, 50);
            else if (!strcmp(p.word, "limegreen")) cmap[r - 1].col = FF_RGB(50, 205, 50);
            else if (!strcmp(p.word, "yellow green")) cmap[r - 1].col = FF_RGB(154, 205, 50);
            else if (!strcmp(p.word, "yellowgreen")) cmap[r - 1].col = FF_RGB(154, 205, 50);
            else if (!strcmp(p.word, "forest green")) cmap[r - 1].col = FF_RGB(34, 139, 34);
            else if (!strcmp(p.word, "forestgreen")) cmap[r - 1].col = FF_RGB(34, 139, 34);
            else if (!strcmp(p.word, "olive drab")) cmap[r - 1].col = FF_RGB(107, 142, 35);
            else if (!strcmp(p.word, "olivedrab")) cmap[r - 1].col = FF_RGB(107, 142, 35);
            else if (!strcmp(p.word, "dark khaki")) cmap[r - 1].col = FF_RGB(189, 183, 107);
            else if (!strcmp(p.word, "darkkhaki")) cmap[r - 1].col = FF_RGB(189, 183, 107);
            else if (!strcmp(p.word, "khaki")) cmap[r - 1].col = FF_RGB(240, 230, 140);
            else if (!strcmp(p.word, "pale goldenrod")) cmap[r - 1].col = FF_RGB(238, 232, 170);
            else if (!strcmp(p.word, "palegoldenrod")) cmap[r - 1].col = FF_RGB(238, 232, 170);
            else if (!strcmp(p.word, "light goldenrod yellow")) cmap[r - 1].col = FF_RGB(250, 250, 210);
            else if (!strcmp(p.word, "lightgoldenrodyellow")) cmap[r - 1].col = FF_RGB(250, 250, 210);
            else if (!strcmp(p.word, "light yellow")) cmap[r - 1].col = FF_RGB(255, 255, 224);
            else if (!strcmp(p.word, "lightyellow")) cmap[r - 1].col = FF_RGB(255, 255, 224);
            else if (!strcmp(p.word, "yellow")) cmap[r - 1].col = FF_RGB(255, 255, 0);
            else if (!strcmp(p.word, "gold")) cmap[r - 1].col = FF_RGB(255, 215, 0);
            else if (!strcmp(p.word, "light goldenrod")) cmap[r - 1].col = FF_RGB(238, 221, 130);
            else if (!strcmp(p.word, "lightgoldenrod")) cmap[r - 1].col = FF_RGB(238, 221, 130);
            else if (!strcmp(p.word, "goldenrod")) cmap[r - 1].col = FF_RGB(218, 165, 32);
            else if (!strcmp(p.word, "dark goldenrod")) cmap[r - 1].col = FF_RGB(184, 134, 11);
            else if (!strcmp(p.word, "darkgoldenrod")) cmap[r - 1].col = FF_RGB(184, 134, 11);
            else if (!strcmp(p.word, "rosy brown")) cmap[r - 1].col = FF_RGB(188, 143, 143);
            else if (!strcmp(p.word, "rosybrown")) cmap[r - 1].col = FF_RGB(188, 143, 143);
            else if (!strcmp(p.word, "indian red")) cmap[r - 1].col = FF_RGB(205, 92, 92);
            else if (!strcmp(p.word, "indianred")) cmap[r - 1].col = FF_RGB(205, 92, 92);
            else if (!strcmp(p.word, "saddle brown")) cmap[r - 1].col = FF_RGB(139, 69, 19);
            else if (!strcmp(p.word, "saddlebrown")) cmap[r - 1].col = FF_RGB(139, 69, 19);
            else if (!strcmp(p.word, "sienna")) cmap[r - 1].col = FF_RGB(160, 82, 45);
            else if (!strcmp(p.word, "peru")) cmap[r - 1].col = FF_RGB(205, 133, 63);
            else if (!strcmp(p.word, "burlywood")) cmap[r - 1].col = FF_RGB(222, 184, 135);
            else if (!strcmp(p.word, "beige")) cmap[r - 1].col = FF_RGB(245, 245, 220);
            else if (!strcmp(p.word, "wheat")) cmap[r - 1].col = FF_RGB(245, 222, 179);
            else if (!strcmp(p.word, "sandy brown")) cmap[r - 1].col = FF_RGB(244, 164, 96);
            else if (!strcmp(p.word, "sandybrown")) cmap[r - 1].col = FF_RGB(244, 164, 96);
            else if (!strcmp(p.word, "tan")) cmap[r - 1].col = FF_RGB(210, 180, 140);
            else if (!strcmp(p.word, "chocolate")) cmap[r - 1].col = FF_RGB(210, 105, 30);
            else if (!strcmp(p.word, "firebrick")) cmap[r - 1].col = FF_RGB(178, 34, 34);
            else if (!strcmp(p.word, "brown")) cmap[r - 1].col = FF_RGB(165, 42, 42);
            else if (!strcmp(p.word, "dark salmon")) cmap[r - 1].col = FF_RGB(233, 150, 122);
            else if (!strcmp(p.word, "darksalmon")) cmap[r - 1].col = FF_RGB(233, 150, 122);
            else if (!strcmp(p.word, "salmon")) cmap[r - 1].col = FF_RGB(250, 128, 114);
            else if (!strcmp(p.word, "light salmon")) cmap[r - 1].col = FF_RGB(255, 160, 122);
            else if (!strcmp(p.word, "lightsalmon")) cmap[r - 1].col = FF_RGB(255, 160, 122);
            else if (!strcmp(p.word, "orange")) cmap[r - 1].col = FF_RGB(255, 165, 0);
            else if (!strcmp(p.word, "dark orange")) cmap[r - 1].col = FF_RGB(255, 140, 0);
            else if (!strcmp(p.word, "darkorange")) cmap[r - 1].col = FF_RGB(255, 140, 0);
            else if (!strcmp(p.word, "coral")) cmap[r - 1].col = FF_RGB(255, 127, 80);
            else if (!strcmp(p.word, "light coral")) cmap[r - 1].col = FF_RGB(240, 128, 128);
            else if (!strcmp(p.word, "lightcoral")) cmap[r - 1].col = FF_RGB(240, 128, 128);
            else if (!strcmp(p.word, "tomato")) cmap[r - 1].col = FF_RGB(255, 99, 71);
            else if (!strcmp(p.word, "orange red")) cmap[r - 1].col = FF_RGB(255, 69, 0);
            else if (!strcmp(p.word, "orangered")) cmap[r - 1].col = FF_RGB(255, 69, 0);
            else if (!strcmp(p.word, "red")) cmap[r - 1].col = FF_RGB(255, 0, 0);
            else if (!strcmp(p.word, "hot pink")) cmap[r - 1].col = FF_RGB(255, 105, 180);
            else if (!strcmp(p.word, "hotpink")) cmap[r - 1].col = FF_RGB(255, 105, 180);
            else if (!strcmp(p.word, "deep pink")) cmap[r - 1].col = FF_RGB(255, 20, 147);
            else if (!strcmp(p.word, "deeppink")) cmap[r - 1].col = FF_RGB(255, 20, 147);
            else if (!strcmp(p.word, "pink")) cmap[r - 1].col = FF_RGB(255, 192, 203);
            else if (!strcmp(p.word, "light pink")) cmap[r - 1].col = FF_RGB(255, 182, 193);
            else if (!strcmp(p.word, "lightpink")) cmap[r - 1].col = FF_RGB(255, 182, 193);
            else if (!strcmp(p.word, "pale violet red")) cmap[r - 1].col = FF_RGB(219, 112, 147);
            else if (!strcmp(p.word, "palevioletred")) cmap[r - 1].col = FF_RGB(219, 112, 147);
            else if (!strcmp(p.word, "maroon")) cmap[r - 1].col = FF_RGB(176, 48, 96);
            else if (!strcmp(p.word, "medium violet red")) cmap[r - 1].col = FF_RGB(199, 21, 133);
            else if (!strcmp(p.word, "mediumvioletred")) cmap[r - 1].col = FF_RGB(199, 21, 133);
            else if (!strcmp(p.word, "violet red")) cmap[r - 1].col = FF_RGB(208, 32, 144);
            else if (!strcmp(p.word, "violetred")) cmap[r - 1].col = FF_RGB(208, 32, 144);
            else if (!strcmp(p.word, "magenta")) cmap[r - 1].col = FF_RGB(255, 0, 255);
            else if (!strcmp(p.word, "violet")) cmap[r - 1].col = FF_RGB(238, 130, 238);
            else if (!strcmp(p.word, "plum")) cmap[r - 1].col = FF_RGB(221, 160, 221);
            else if (!strcmp(p.word, "orchid")) cmap[r - 1].col = FF_RGB(218, 112, 214);
            else if (!strcmp(p.word, "medium orchid")) cmap[r - 1].col = FF_RGB(186, 85, 211);
            else if (!strcmp(p.word, "mediumorchid")) cmap[r - 1].col = FF_RGB(186, 85, 211);
            else if (!strcmp(p.word, "dark orchid")) cmap[r - 1].col = FF_RGB(153, 50, 204);
            else if (!strcmp(p.word, "darkorchid")) cmap[r - 1].col = FF_RGB(153, 50, 204);
            else if (!strcmp(p.word, "dark violet")) cmap[r - 1].col = FF_RGB(148, 0, 211);
            else if (!strcmp(p.word, "darkviolet")) cmap[r - 1].col = FF_RGB(148, 0, 211);
            else if (!strcmp(p.word, "blue violet")) cmap[r - 1].col = FF_RGB(138, 43, 226);
            else if (!strcmp(p.word, "blueviolet")) cmap[r - 1].col = FF_RGB(138, 43, 226);
            else if (!strcmp(p.word, "purple")) cmap[r - 1].col = FF_RGB(160, 32, 240);
            else if (!strcmp(p.word, "medium purple")) cmap[r - 1].col = FF_RGB(147, 112, 219);
            else if (!strcmp(p.word, "mediumpurple")) cmap[r - 1].col = FF_RGB(147, 112, 219);
            else if (!strcmp(p.word, "thistle")) cmap[r - 1].col = FF_RGB(216, 191, 216);
            else if (!strcmp(p.word, "snow1")) cmap[r - 1].col = FF_RGB(255, 250, 250);
            else if (!strcmp(p.word, "snow2")) cmap[r - 1].col = FF_RGB(238, 233, 233);
            else if (!strcmp(p.word, "snow3")) cmap[r - 1].col = FF_RGB(205, 201, 201);
            else if (!strcmp(p.word, "snow4")) cmap[r - 1].col = FF_RGB(139, 137, 137);
            else if (!strcmp(p.word, "seashell1")) cmap[r - 1].col = FF_RGB(255, 245, 238);
            else if (!strcmp(p.word, "seashell2")) cmap[r - 1].col = FF_RGB(238, 229, 222);
            else if (!strcmp(p.word, "seashell3")) cmap[r - 1].col = FF_RGB(205, 197, 191);
            else if (!strcmp(p.word, "seashell4")) cmap[r - 1].col = FF_RGB(139, 134, 130);
            else if (!strcmp(p.word, "antiquewhite1")) cmap[r - 1].col = FF_RGB(255, 239, 219);
            else if (!strcmp(p.word, "antiquewhite2")) cmap[r - 1].col = FF_RGB(238, 223, 204);
            else if (!strcmp(p.word, "antiquewhite3")) cmap[r - 1].col = FF_RGB(205, 192, 176);
            else if (!strcmp(p.word, "antiquewhite4")) cmap[r - 1].col = FF_RGB(139, 131, 120);
            else if (!strcmp(p.word, "bisque1")) cmap[r - 1].col = FF_RGB(255, 228, 196);
            else if (!strcmp(p.word, "bisque2")) cmap[r - 1].col = FF_RGB(238, 213, 183);
            else if (!strcmp(p.word, "bisque3")) cmap[r - 1].col = FF_RGB(205, 183, 158);
            else if (!strcmp(p.word, "bisque4")) cmap[r - 1].col = FF_RGB(139, 125, 107);
            else if (!strcmp(p.word, "peachpuff1")) cmap[r - 1].col = FF_RGB(255, 218, 185);
            else if (!strcmp(p.word, "peachpuff2")) cmap[r - 1].col = FF_RGB(238, 203, 173);
            else if (!strcmp(p.word, "peachpuff3")) cmap[r - 1].col = FF_RGB(205, 175, 149);
            else if (!strcmp(p.word, "peachpuff4")) cmap[r - 1].col = FF_RGB(139, 119, 101);
            else if (!strcmp(p.word, "navajowhite1")) cmap[r - 1].col = FF_RGB(255, 222, 173);
            else if (!strcmp(p.word, "navajowhite2")) cmap[r - 1].col = FF_RGB(238, 207, 161);
            else if (!strcmp(p.word, "navajowhite3")) cmap[r - 1].col = FF_RGB(205, 179, 139);
            else if (!strcmp(p.word, "navajowhite4")) cmap[r - 1].col = FF_RGB(139, 121, 94);
            else if (!strcmp(p.word, "lemonchiffon1")) cmap[r - 1].col = FF_RGB(255, 250, 205);
            else if (!strcmp(p.word, "lemonchiffon2")) cmap[r - 1].col = FF_RGB(238, 233, 191);
            else if (!strcmp(p.word, "lemonchiffon3")) cmap[r - 1].col = FF_RGB(205, 201, 165);
            else if (!strcmp(p.word, "lemonchiffon4")) cmap[r - 1].col = FF_RGB(139, 137, 112);
            else if (!strcmp(p.word, "cornsilk1")) cmap[r - 1].col = FF_RGB(255, 248, 220);
            else if (!strcmp(p.word, "cornsilk2")) cmap[r - 1].col = FF_RGB(238, 232, 205);
            else if (!strcmp(p.word, "cornsilk3")) cmap[r - 1].col = FF_RGB(205, 200, 177);
            else if (!strcmp(p.word, "cornsilk4")) cmap[r - 1].col = FF_RGB(139, 136, 120);
            else if (!strcmp(p.word, "ivory1")) cmap[r - 1].col = FF_RGB(255, 255, 240);
            else if (!strcmp(p.word, "ivory2")) cmap[r - 1].col = FF_RGB(238, 238, 224);
            else if (!strcmp(p.word, "ivory3")) cmap[r - 1].col = FF_RGB(205, 205, 193);
            else if (!strcmp(p.word, "ivory4")) cmap[r - 1].col = FF_RGB(139, 139, 131);
            else if (!strcmp(p.word, "honeydew1")) cmap[r - 1].col = FF_RGB(240, 255, 240);
            else if (!strcmp(p.word, "honeydew2")) cmap[r - 1].col = FF_RGB(224, 238, 224);
            else if (!strcmp(p.word, "honeydew3")) cmap[r - 1].col = FF_RGB(193, 205, 193);
            else if (!strcmp(p.word, "honeydew4")) cmap[r - 1].col = FF_RGB(131, 139, 131);
            else if (!strcmp(p.word, "lavenderblush1")) cmap[r - 1].col = FF_RGB(255, 240, 245);
            else if (!strcmp(p.word, "lavenderblush2")) cmap[r - 1].col = FF_RGB(238, 224, 229);
            else if (!strcmp(p.word, "lavenderblush3")) cmap[r - 1].col = FF_RGB(205, 193, 197);
            else if (!strcmp(p.word, "lavenderblush4")) cmap[r - 1].col = FF_RGB(139, 131, 134);
            else if (!strcmp(p.word, "mistyrose1")) cmap[r - 1].col = FF_RGB(255, 228, 225);
            else if (!strcmp(p.word, "mistyrose2")) cmap[r - 1].col = FF_RGB(238, 213, 210);
            else if (!strcmp(p.word, "mistyrose3")) cmap[r - 1].col = FF_RGB(205, 183, 181);
            else if (!strcmp(p.word, "mistyrose4")) cmap[r - 1].col = FF_RGB(139, 125, 123);
            else if (!strcmp(p.word, "azure1")) cmap[r - 1].col = FF_RGB(240, 255, 255);
            else if (!strcmp(p.word, "azure2")) cmap[r - 1].col = FF_RGB(224, 238, 238);
            else if (!strcmp(p.word, "azure3")) cmap[r - 1].col = FF_RGB(193, 205, 205);
            else if (!strcmp(p.word, "azure4")) cmap[r - 1].col = FF_RGB(131, 139, 139);
            else if (!strcmp(p.word, "slateblue1")) cmap[r - 1].col = FF_RGB(131, 111, 255);
            else if (!strcmp(p.word, "slateblue2")) cmap[r - 1].col = FF_RGB(122, 103, 238);
            else if (!strcmp(p.word, "slateblue3")) cmap[r - 1].col = FF_RGB(105, 89, 205);
            else if (!strcmp(p.word, "slateblue4")) cmap[r - 1].col = FF_RGB(71, 60, 139);
            else if (!strcmp(p.word, "royalblue1")) cmap[r - 1].col = FF_RGB(72, 118, 255);
            else if (!strcmp(p.word, "royalblue2")) cmap[r - 1].col = FF_RGB(67, 110, 238);
            else if (!strcmp(p.word, "royalblue3")) cmap[r - 1].col = FF_RGB(58, 95, 205);
            else if (!strcmp(p.word, "royalblue4")) cmap[r - 1].col = FF_RGB(39, 64, 139);
            else if (!strcmp(p.word, "blue1")) cmap[r - 1].col = FF_RGB(0, 0, 255);
            else if (!strcmp(p.word, "blue2")) cmap[r - 1].col = FF_RGB(0, 0, 238);
            else if (!strcmp(p.word, "blue3")) cmap[r - 1].col = FF_RGB(0, 0, 205);
            else if (!strcmp(p.word, "blue4")) cmap[r - 1].col = FF_RGB(0, 0, 139);
            else if (!strcmp(p.word, "dodgerblue1")) cmap[r - 1].col = FF_RGB(30, 144, 255);
            else if (!strcmp(p.word, "dodgerblue2")) cmap[r - 1].col = FF_RGB(28, 134, 238);
            else if (!strcmp(p.word, "dodgerblue3")) cmap[r - 1].col = FF_RGB(24, 116, 205);
            else if (!strcmp(p.word, "dodgerblue4")) cmap[r - 1].col = FF_RGB(16, 78, 139);
            else if (!strcmp(p.word, "steelblue1")) cmap[r - 1].col = FF_RGB(99, 184, 255);
            else if (!strcmp(p.word, "steelblue2")) cmap[r - 1].col = FF_RGB(92, 172, 238);
            else if (!strcmp(p.word, "steelblue3")) cmap[r - 1].col = FF_RGB(79, 148, 205);
            else if (!strcmp(p.word, "steelblue4")) cmap[r - 1].col = FF_RGB(54, 100, 139);
            else if (!strcmp(p.word, "deepskyblue1")) cmap[r - 1].col = FF_RGB(0, 191, 255);
            else if (!strcmp(p.word, "deepskyblue2")) cmap[r - 1].col = FF_RGB(0, 178, 238);
            else if (!strcmp(p.word, "deepskyblue3")) cmap[r - 1].col = FF_RGB(0, 154, 205);
            else if (!strcmp(p.word, "deepskyblue4")) cmap[r - 1].col = FF_RGB(0, 104, 139);
            else if (!strcmp(p.word, "skyblue1")) cmap[r - 1].col = FF_RGB(135, 206, 255);
            else if (!strcmp(p.word, "skyblue2")) cmap[r - 1].col = FF_RGB(126, 192, 238);
            else if (!strcmp(p.word, "skyblue3")) cmap[r - 1].col = FF_RGB(108, 166, 205);
            else if (!strcmp(p.word, "skyblue4")) cmap[r - 1].col = FF_RGB(74, 112, 139);
            else if (!strcmp(p.word, "lightskyblue1")) cmap[r - 1].col = FF_RGB(176, 226, 255);
            else if (!strcmp(p.word, "lightskyblue2")) cmap[r - 1].col = FF_RGB(164, 211, 238);
            else if (!strcmp(p.word, "lightskyblue3")) cmap[r - 1].col = FF_RGB(141, 182, 205);
            else if (!strcmp(p.word, "lightskyblue4")) cmap[r - 1].col = FF_RGB(96, 123, 139);
            else if (!strcmp(p.word, "slategray1")) cmap[r - 1].col = FF_RGB(198, 226, 255);
            else if (!strcmp(p.word, "slategray2")) cmap[r - 1].col = FF_RGB(185, 211, 238);
            else if (!strcmp(p.word, "slategray3")) cmap[r - 1].col = FF_RGB(159, 182, 205);
            else if (!strcmp(p.word, "slategray4")) cmap[r - 1].col = FF_RGB(108, 123, 139);
            else if (!strcmp(p.word, "lightsteelblue1")) cmap[r - 1].col = FF_RGB(202, 225, 255);
            else if (!strcmp(p.word, "lightsteelblue2")) cmap[r - 1].col = FF_RGB(188, 210, 238);
            else if (!strcmp(p.word, "lightsteelblue3")) cmap[r - 1].col = FF_RGB(162, 181, 205);
            else if (!strcmp(p.word, "lightsteelblue4")) cmap[r - 1].col = FF_RGB(110, 123, 139);
            else if (!strcmp(p.word, "lightblue1")) cmap[r - 1].col = FF_RGB(191, 239, 255);
            else if (!strcmp(p.word, "lightblue2")) cmap[r - 1].col = FF_RGB(178, 223, 238);
            else if (!strcmp(p.word, "lightblue3")) cmap[r - 1].col = FF_RGB(154, 192, 205);
            else if (!strcmp(p.word, "lightblue4")) cmap[r - 1].col = FF_RGB(104, 131, 139);
            else if (!strcmp(p.word, "lightcyan1")) cmap[r - 1].col = FF_RGB(224, 255, 255);
            else if (!strcmp(p.word, "lightcyan2")) cmap[r - 1].col = FF_RGB(209, 238, 238);
            else if (!strcmp(p.word, "lightcyan3")) cmap[r - 1].col = FF_RGB(180, 205, 205);
            else if (!strcmp(p.word, "lightcyan4")) cmap[r - 1].col = FF_RGB(122, 139, 139);
            else if (!strcmp(p.word, "paleturquoise1")) cmap[r - 1].col = FF_RGB(187, 255, 255);
            else if (!strcmp(p.word, "paleturquoise2")) cmap[r - 1].col = FF_RGB(174, 238, 238);
            else if (!strcmp(p.word, "paleturquoise3")) cmap[r - 1].col = FF_RGB(150, 205, 205);
            else if (!strcmp(p.word, "paleturquoise4")) cmap[r - 1].col = FF_RGB(102, 139, 139);
            else if (!strcmp(p.word, "cadetblue1")) cmap[r - 1].col = FF_RGB(152, 245, 255);
            else if (!strcmp(p.word, "cadetblue2")) cmap[r - 1].col = FF_RGB(142, 229, 238);
            else if (!strcmp(p.word, "cadetblue3")) cmap[r - 1].col = FF_RGB(122, 197, 205);
            else if (!strcmp(p.word, "cadetblue4")) cmap[r - 1].col = FF_RGB(83, 134, 139);
            else if (!strcmp(p.word, "turquoise1")) cmap[r - 1].col = FF_RGB(0, 245, 255);
            else if (!strcmp(p.word, "turquoise2")) cmap[r - 1].col = FF_RGB(0, 229, 238);
            else if (!strcmp(p.word, "turquoise3")) cmap[r - 1].col = FF_RGB(0, 197, 205);
            else if (!strcmp(p.word, "turquoise4")) cmap[r - 1].col = FF_RGB(0, 134, 139);
            else if (!strcmp(p.word, "cyan1")) cmap[r - 1].col = FF_RGB(0, 255, 255);
            else if (!strcmp(p.word, "cyan2")) cmap[r - 1].col = FF_RGB(0, 238, 238);
            else if (!strcmp(p.word, "cyan3")) cmap[r - 1].col = FF_RGB(0, 205, 205);
            else if (!strcmp(p.word, "cyan4")) cmap[r - 1].col = FF_RGB(0, 139, 139);
            else if (!strcmp(p.word, "darkslategray1")) cmap[r - 1].col = FF_RGB(151, 255, 255);
            else if (!strcmp(p.word, "darkslategray2")) cmap[r - 1].col = FF_RGB(141, 238, 238);
            else if (!strcmp(p.word, "darkslategray3")) cmap[r - 1].col = FF_RGB(121, 205, 205);
            else if (!strcmp(p.word, "darkslategray4")) cmap[r - 1].col = FF_RGB(82, 139, 139);
            else if (!strcmp(p.word, "aquamarine1")) cmap[r - 1].col = FF_RGB(127, 255, 212);
            else if (!strcmp(p.word, "aquamarine2")) cmap[r - 1].col = FF_RGB(118, 238, 198);
            else if (!strcmp(p.word, "aquamarine3")) cmap[r - 1].col = FF_RGB(102, 205, 170);
            else if (!strcmp(p.word, "aquamarine4")) cmap[r - 1].col = FF_RGB(69, 139, 116);
            else if (!strcmp(p.word, "darkseagreen1")) cmap[r - 1].col = FF_RGB(193, 255, 193);
            else if (!strcmp(p.word, "darkseagreen2")) cmap[r - 1].col = FF_RGB(180, 238, 180);
            else if (!strcmp(p.word, "darkseagreen3")) cmap[r - 1].col = FF_RGB(155, 205, 155);
            else if (!strcmp(p.word, "darkseagreen4")) cmap[r - 1].col = FF_RGB(105, 139, 105);
            else if (!strcmp(p.word, "seagreen1")) cmap[r - 1].col = FF_RGB(84, 255, 159);
            else if (!strcmp(p.word, "seagreen2")) cmap[r - 1].col = FF_RGB(78, 238, 148);
            else if (!strcmp(p.word, "seagreen3")) cmap[r - 1].col = FF_RGB(67, 205, 128);
            else if (!strcmp(p.word, "seagreen4")) cmap[r - 1].col = FF_RGB(46, 139, 87);
            else if (!strcmp(p.word, "palegreen1")) cmap[r - 1].col = FF_RGB(154, 255, 154);
            else if (!strcmp(p.word, "palegreen2")) cmap[r - 1].col = FF_RGB(144, 238, 144);
            else if (!strcmp(p.word, "palegreen3")) cmap[r - 1].col = FF_RGB(124, 205, 124);
            else if (!strcmp(p.word, "palegreen4")) cmap[r - 1].col = FF_RGB(84, 139, 84);
            else if (!strcmp(p.word, "springgreen1")) cmap[r - 1].col = FF_RGB(0, 255, 127);
            else if (!strcmp(p.word, "springgreen2")) cmap[r - 1].col = FF_RGB(0, 238, 118);
            else if (!strcmp(p.word, "springgreen3")) cmap[r - 1].col = FF_RGB(0, 205, 102);
            else if (!strcmp(p.word, "springgreen4")) cmap[r - 1].col = FF_RGB(0, 139, 69);
            else if (!strcmp(p.word, "green1")) cmap[r - 1].col = FF_RGB(0, 255, 0);
            else if (!strcmp(p.word, "green2")) cmap[r - 1].col = FF_RGB(0, 238, 0);
            else if (!strcmp(p.word, "green3")) cmap[r - 1].col = FF_RGB(0, 205, 0);
            else if (!strcmp(p.word, "green4")) cmap[r - 1].col = FF_RGB(0, 139, 0);
            else if (!strcmp(p.word, "chartreuse1")) cmap[r - 1].col = FF_RGB(127, 255, 0);
            else if (!strcmp(p.word, "chartreuse2")) cmap[r - 1].col = FF_RGB(118, 238, 0);
            else if (!strcmp(p.word, "chartreuse3")) cmap[r - 1].col = FF_RGB(102, 205, 0);
            else if (!strcmp(p.word, "chartreuse4")) cmap[r - 1].col = FF_RGB(69, 139, 0);
            else if (!strcmp(p.word, "olivedrab1")) cmap[r - 1].col = FF_RGB(192, 255, 62);
            else if (!strcmp(p.word, "olivedrab2")) cmap[r - 1].col = FF_RGB(179, 238, 58);
            else if (!strcmp(p.word, "olivedrab3")) cmap[r - 1].col = FF_RGB(154, 205, 50);
            else if (!strcmp(p.word, "olivedrab4")) cmap[r - 1].col = FF_RGB(105, 139, 34);
            else if (!strcmp(p.word, "darkolivegreen1")) cmap[r - 1].col = FF_RGB(202, 255, 112);
            else if (!strcmp(p.word, "darkolivegreen2")) cmap[r - 1].col = FF_RGB(188, 238, 104);
            else if (!strcmp(p.word, "darkolivegreen3")) cmap[r - 1].col = FF_RGB(162, 205, 90);
            else if (!strcmp(p.word, "darkolivegreen4")) cmap[r - 1].col = FF_RGB(110, 139, 61);
            else if (!strcmp(p.word, "khaki1")) cmap[r - 1].col = FF_RGB(255, 246, 143);
            else if (!strcmp(p.word, "khaki2")) cmap[r - 1].col = FF_RGB(238, 230, 133);
            else if (!strcmp(p.word, "khaki3")) cmap[r - 1].col = FF_RGB(205, 198, 115);
            else if (!strcmp(p.word, "khaki4")) cmap[r - 1].col = FF_RGB(139, 134, 78);
            else if (!strcmp(p.word, "lightgoldenrod1")) cmap[r - 1].col = FF_RGB(255, 236, 139);
            else if (!strcmp(p.word, "lightgoldenrod2")) cmap[r - 1].col = FF_RGB(238, 220, 130);
            else if (!strcmp(p.word, "lightgoldenrod3")) cmap[r - 1].col = FF_RGB(205, 190, 112);
            else if (!strcmp(p.word, "lightgoldenrod4")) cmap[r - 1].col = FF_RGB(139, 129, 76);
            else if (!strcmp(p.word, "lightyellow1")) cmap[r - 1].col = FF_RGB(255, 255, 224);
            else if (!strcmp(p.word, "lightyellow2")) cmap[r - 1].col = FF_RGB(238, 238, 209);
            else if (!strcmp(p.word, "lightyellow3")) cmap[r - 1].col = FF_RGB(205, 205, 180);
            else if (!strcmp(p.word, "lightyellow4")) cmap[r - 1].col = FF_RGB(139, 139, 122);
            else if (!strcmp(p.word, "yellow1")) cmap[r - 1].col = FF_RGB(255, 255, 0);
            else if (!strcmp(p.word, "yellow2")) cmap[r - 1].col = FF_RGB(238, 238, 0);
            else if (!strcmp(p.word, "yellow3")) cmap[r - 1].col = FF_RGB(205, 205, 0);
            else if (!strcmp(p.word, "yellow4")) cmap[r - 1].col = FF_RGB(139, 139, 0);
            else if (!strcmp(p.word, "gold1")) cmap[r - 1].col = FF_RGB(255, 215, 0);
            else if (!strcmp(p.word, "gold2")) cmap[r - 1].col = FF_RGB(238, 201, 0);
            else if (!strcmp(p.word, "gold3")) cmap[r - 1].col = FF_RGB(205, 173, 0);
            else if (!strcmp(p.word, "gold4")) cmap[r - 1].col = FF_RGB(139, 117, 0);
            else if (!strcmp(p.word, "goldenrod1")) cmap[r - 1].col = FF_RGB(255, 193, 37);
            else if (!strcmp(p.word, "goldenrod2")) cmap[r - 1].col = FF_RGB(238, 180, 34);
            else if (!strcmp(p.word, "goldenrod3")) cmap[r - 1].col = FF_RGB(205, 155, 29);
            else if (!strcmp(p.word, "goldenrod4")) cmap[r - 1].col = FF_RGB(139, 105, 20);
            else if (!strcmp(p.word, "darkgoldenrod1")) cmap[r - 1].col = FF_RGB(255, 185, 15);
            else if (!strcmp(p.word, "darkgoldenrod2")) cmap[r - 1].col = FF_RGB(238, 173, 14);
            else if (!strcmp(p.word, "darkgoldenrod3")) cmap[r - 1].col = FF_RGB(205, 149, 12);
            else if (!strcmp(p.word, "darkgoldenrod4")) cmap[r - 1].col = FF_RGB(139, 101, 8);
            else if (!strcmp(p.word, "rosybrown1")) cmap[r - 1].col = FF_RGB(255, 193, 193);
            else if (!strcmp(p.word, "rosybrown2")) cmap[r - 1].col = FF_RGB(238, 180, 180);
            else if (!strcmp(p.word, "rosybrown3")) cmap[r - 1].col = FF_RGB(205, 155, 155);
            else if (!strcmp(p.word, "rosybrown4")) cmap[r - 1].col = FF_RGB(139, 105, 105);
            else if (!strcmp(p.word, "indianred1")) cmap[r - 1].col = FF_RGB(255, 106, 106);
            else if (!strcmp(p.word, "indianred2")) cmap[r - 1].col = FF_RGB(238, 99, 99);
            else if (!strcmp(p.word, "indianred3")) cmap[r - 1].col = FF_RGB(205, 85, 85);
            else if (!strcmp(p.word, "indianred4")) cmap[r - 1].col = FF_RGB(139, 58, 58);
            else if (!strcmp(p.word, "sienna1")) cmap[r - 1].col = FF_RGB(255, 130, 71);
            else if (!strcmp(p.word, "sienna2")) cmap[r - 1].col = FF_RGB(238, 121, 66);
            else if (!strcmp(p.word, "sienna3")) cmap[r - 1].col = FF_RGB(205, 104, 57);
            else if (!strcmp(p.word, "sienna4")) cmap[r - 1].col = FF_RGB(139, 71, 38);
            else if (!strcmp(p.word, "burlywood1")) cmap[r - 1].col = FF_RGB(255, 211, 155);
            else if (!strcmp(p.word, "burlywood2")) cmap[r - 1].col = FF_RGB(238, 197, 145);
            else if (!strcmp(p.word, "burlywood3")) cmap[r - 1].col = FF_RGB(205, 170, 125);
            else if (!strcmp(p.word, "burlywood4")) cmap[r - 1].col = FF_RGB(139, 115, 85);
            else if (!strcmp(p.word, "wheat1")) cmap[r - 1].col = FF_RGB(255, 231, 186);
            else if (!strcmp(p.word, "wheat2")) cmap[r - 1].col = FF_RGB(238, 216, 174);
            else if (!strcmp(p.word, "wheat3")) cmap[r - 1].col = FF_RGB(205, 186, 150);
            else if (!strcmp(p.word, "wheat4")) cmap[r - 1].col = FF_RGB(139, 126, 102);
            else if (!strcmp(p.word, "tan1")) cmap[r - 1].col = FF_RGB(255, 165, 79);
            else if (!strcmp(p.word, "tan2")) cmap[r - 1].col = FF_RGB(238, 154, 73);
            else if (!strcmp(p.word, "tan3")) cmap[r - 1].col = FF_RGB(205, 133, 63);
            else if (!strcmp(p.word, "tan4")) cmap[r - 1].col = FF_RGB(139, 90, 43);
            else if (!strcmp(p.word, "chocolate1")) cmap[r - 1].col = FF_RGB(255, 127, 36);
            else if (!strcmp(p.word, "chocolate2")) cmap[r - 1].col = FF_RGB(238, 118, 33);
            else if (!strcmp(p.word, "chocolate3")) cmap[r - 1].col = FF_RGB(205, 102, 29);
            else if (!strcmp(p.word, "chocolate4")) cmap[r - 1].col = FF_RGB(139, 69, 19);
            else if (!strcmp(p.word, "firebrick1")) cmap[r - 1].col = FF_RGB(255, 48, 48);
            else if (!strcmp(p.word, "firebrick2")) cmap[r - 1].col = FF_RGB(238, 44, 44);
            else if (!strcmp(p.word, "firebrick3")) cmap[r - 1].col = FF_RGB(205, 38, 38);
            else if (!strcmp(p.word, "firebrick4")) cmap[r - 1].col = FF_RGB(139, 26, 26);
            else if (!strcmp(p.word, "brown1")) cmap[r - 1].col = FF_RGB(255, 64, 64);
            else if (!strcmp(p.word, "brown2")) cmap[r - 1].col = FF_RGB(238, 59, 59);
            else if (!strcmp(p.word, "brown3")) cmap[r - 1].col = FF_RGB(205, 51, 51);
            else if (!strcmp(p.word, "brown4")) cmap[r - 1].col = FF_RGB(139, 35, 35);
            else if (!strcmp(p.word, "salmon1")) cmap[r - 1].col = FF_RGB(255, 140, 105);
            else if (!strcmp(p.word, "salmon2")) cmap[r - 1].col = FF_RGB(238, 130, 98);
            else if (!strcmp(p.word, "salmon3")) cmap[r - 1].col = FF_RGB(205, 112, 84);
            else if (!strcmp(p.word, "salmon4")) cmap[r - 1].col = FF_RGB(139, 76, 57);
            else if (!strcmp(p.word, "lightsalmon1")) cmap[r - 1].col = FF_RGB(255, 160, 122);
            else if (!strcmp(p.word, "lightsalmon2")) cmap[r - 1].col = FF_RGB(238, 149, 114);
            else if (!strcmp(p.word, "lightsalmon3")) cmap[r - 1].col = FF_RGB(205, 129, 98);
            else if (!strcmp(p.word, "lightsalmon4")) cmap[r - 1].col = FF_RGB(139, 87, 66);
            else if (!strcmp(p.word, "orange1")) cmap[r - 1].col = FF_RGB(255, 165, 0);
            else if (!strcmp(p.word, "orange2")) cmap[r - 1].col = FF_RGB(238, 154, 0);
            else if (!strcmp(p.word, "orange3")) cmap[r - 1].col = FF_RGB(205, 133, 0);
            else if (!strcmp(p.word, "orange4")) cmap[r - 1].col = FF_RGB(139, 90, 0);
            else if (!strcmp(p.word, "darkorange1")) cmap[r - 1].col = FF_RGB(255, 127, 0);
            else if (!strcmp(p.word, "darkorange2")) cmap[r - 1].col = FF_RGB(238, 118, 0);
            else if (!strcmp(p.word, "darkorange3")) cmap[r - 1].col = FF_RGB(205, 102, 0);
            else if (!strcmp(p.word, "darkorange4")) cmap[r - 1].col = FF_RGB(139, 69, 0);
            else if (!strcmp(p.word, "coral1")) cmap[r - 1].col = FF_RGB(255, 114, 86);
            else if (!strcmp(p.word, "coral2")) cmap[r - 1].col = FF_RGB(238, 106, 80);
            else if (!strcmp(p.word, "coral3")) cmap[r - 1].col = FF_RGB(205, 91, 69);
            else if (!strcmp(p.word, "coral4")) cmap[r - 1].col = FF_RGB(139, 62, 47);
            else if (!strcmp(p.word, "tomato1")) cmap[r - 1].col = FF_RGB(255, 99, 71);
            else if (!strcmp(p.word, "tomato2")) cmap[r - 1].col = FF_RGB(238, 92, 66);
            else if (!strcmp(p.word, "tomato3")) cmap[r - 1].col = FF_RGB(205, 79, 57);
            else if (!strcmp(p.word, "tomato4")) cmap[r - 1].col = FF_RGB(139, 54, 38);
            else if (!strcmp(p.word, "orangered1")) cmap[r - 1].col = FF_RGB(255, 69, 0);
            else if (!strcmp(p.word, "orangered2")) cmap[r - 1].col = FF_RGB(238, 64, 0);
            else if (!strcmp(p.word, "orangered3")) cmap[r - 1].col = FF_RGB(205, 55, 0);
            else if (!strcmp(p.word, "orangered4")) cmap[r - 1].col = FF_RGB(139, 37, 0);
            else if (!strcmp(p.word, "red1")) cmap[r - 1].col = FF_RGB(255, 0, 0);
            else if (!strcmp(p.word, "red2")) cmap[r - 1].col = FF_RGB(238, 0, 0);
            else if (!strcmp(p.word, "red3")) cmap[r - 1].col = FF_RGB(205, 0, 0);
            else if (!strcmp(p.word, "red4")) cmap[r - 1].col = FF_RGB(139, 0, 0);
            else if (!strcmp(p.word, "debianred")) cmap[r - 1].col = FF_RGB(215, 7, 81);
            else if (!strcmp(p.word, "deeppink1")) cmap[r - 1].col = FF_RGB(255, 20, 147);
            else if (!strcmp(p.word, "deeppink2")) cmap[r - 1].col = FF_RGB(238, 18, 137);
            else if (!strcmp(p.word, "deeppink3")) cmap[r - 1].col = FF_RGB(205, 16, 118);
            else if (!strcmp(p.word, "deeppink4")) cmap[r - 1].col = FF_RGB(139, 10, 80);
            else if (!strcmp(p.word, "hotpink1")) cmap[r - 1].col = FF_RGB(255, 110, 180);
            else if (!strcmp(p.word, "hotpink2")) cmap[r - 1].col = FF_RGB(238, 106, 167);
            else if (!strcmp(p.word, "hotpink3")) cmap[r - 1].col = FF_RGB(205, 96, 144);
            else if (!strcmp(p.word, "hotpink4")) cmap[r - 1].col = FF_RGB(139, 58, 98);
            else if (!strcmp(p.word, "pink1")) cmap[r - 1].col = FF_RGB(255, 181, 197);
            else if (!strcmp(p.word, "pink2")) cmap[r - 1].col = FF_RGB(238, 169, 184);
            else if (!strcmp(p.word, "pink3")) cmap[r - 1].col = FF_RGB(205, 145, 158);
            else if (!strcmp(p.word, "pink4")) cmap[r - 1].col = FF_RGB(139, 99, 108);
            else if (!strcmp(p.word, "lightpink1")) cmap[r - 1].col = FF_RGB(255, 174, 185);
            else if (!strcmp(p.word, "lightpink2")) cmap[r - 1].col = FF_RGB(238, 162, 173);
            else if (!strcmp(p.word, "lightpink3")) cmap[r - 1].col = FF_RGB(205, 140, 149);
            else if (!strcmp(p.word, "lightpink4")) cmap[r - 1].col = FF_RGB(139, 95, 101);
            else if (!strcmp(p.word, "palevioletred1")) cmap[r - 1].col = FF_RGB(255, 130, 171);
            else if (!strcmp(p.word, "palevioletred2")) cmap[r - 1].col = FF_RGB(238, 121, 159);
            else if (!strcmp(p.word, "palevioletred3")) cmap[r - 1].col = FF_RGB(205, 104, 137);
            else if (!strcmp(p.word, "palevioletred4")) cmap[r - 1].col = FF_RGB(139, 71, 93);
            else if (!strcmp(p.word, "maroon1")) cmap[r - 1].col = FF_RGB(255, 52, 179);
            else if (!strcmp(p.word, "maroon2")) cmap[r - 1].col = FF_RGB(238, 48, 167);
            else if (!strcmp(p.word, "maroon3")) cmap[r - 1].col = FF_RGB(205, 41, 144);
            else if (!strcmp(p.word, "maroon4")) cmap[r - 1].col = FF_RGB(139, 28, 98);
            else if (!strcmp(p.word, "violetred1")) cmap[r - 1].col = FF_RGB(255, 62, 150);
            else if (!strcmp(p.word, "violetred2")) cmap[r - 1].col = FF_RGB(238, 58, 140);
            else if (!strcmp(p.word, "violetred3")) cmap[r - 1].col = FF_RGB(205, 50, 120);
            else if (!strcmp(p.word, "violetred4")) cmap[r - 1].col = FF_RGB(139, 34, 82);
            else if (!strcmp(p.word, "magenta1")) cmap[r - 1].col = FF_RGB(255, 0, 255);
            else if (!strcmp(p.word, "magenta2")) cmap[r - 1].col = FF_RGB(238, 0, 238);
            else if (!strcmp(p.word, "magenta3")) cmap[r - 1].col = FF_RGB(205, 0, 205);
            else if (!strcmp(p.word, "magenta4")) cmap[r - 1].col = FF_RGB(139, 0, 139);
            else if (!strcmp(p.word, "orchid1")) cmap[r - 1].col = FF_RGB(255, 131, 250);
            else if (!strcmp(p.word, "orchid2")) cmap[r - 1].col = FF_RGB(238, 122, 233);
            else if (!strcmp(p.word, "orchid3")) cmap[r - 1].col = FF_RGB(205, 105, 201);
            else if (!strcmp(p.word, "orchid4")) cmap[r - 1].col = FF_RGB(139, 71, 137);
            else if (!strcmp(p.word, "plum1")) cmap[r - 1].col = FF_RGB(255, 187, 255);
            else if (!strcmp(p.word, "plum2")) cmap[r - 1].col = FF_RGB(238, 174, 238);
            else if (!strcmp(p.word, "plum3")) cmap[r - 1].col = FF_RGB(205, 150, 205);
            else if (!strcmp(p.word, "plum4")) cmap[r - 1].col = FF_RGB(139, 102, 139);
            else if (!strcmp(p.word, "mediumorchid1")) cmap[r - 1].col = FF_RGB(224, 102, 255);
            else if (!strcmp(p.word, "mediumorchid2")) cmap[r - 1].col = FF_RGB(209, 95, 238);
            else if (!strcmp(p.word, "mediumorchid3")) cmap[r - 1].col = FF_RGB(180, 82, 205);
            else if (!strcmp(p.word, "mediumorchid4")) cmap[r - 1].col = FF_RGB(122, 55, 139);
            else if (!strcmp(p.word, "darkorchid1")) cmap[r - 1].col = FF_RGB(191, 62, 255);
            else if (!strcmp(p.word, "darkorchid2")) cmap[r - 1].col = FF_RGB(178, 58, 238);
            else if (!strcmp(p.word, "darkorchid3")) cmap[r - 1].col = FF_RGB(154, 50, 205);
            else if (!strcmp(p.word, "darkorchid4")) cmap[r - 1].col = FF_RGB(104, 34, 139);
            else if (!strcmp(p.word, "purple1")) cmap[r - 1].col = FF_RGB(155, 48, 255);
            else if (!strcmp(p.word, "purple2")) cmap[r - 1].col = FF_RGB(145, 44, 238);
            else if (!strcmp(p.word, "purple3")) cmap[r - 1].col = FF_RGB(125, 38, 205);
            else if (!strcmp(p.word, "purple4")) cmap[r - 1].col = FF_RGB(85, 26, 139);
            else if (!strcmp(p.word, "mediumpurple1")) cmap[r - 1].col = FF_RGB(171, 130, 255);
            else if (!strcmp(p.word, "mediumpurple2")) cmap[r - 1].col = FF_RGB(159, 121, 238);
            else if (!strcmp(p.word, "mediumpurple3")) cmap[r - 1].col = FF_RGB(137, 104, 205);
            else if (!strcmp(p.word, "mediumpurple4")) cmap[r - 1].col = FF_RGB(93, 71, 139);
            else if (!strcmp(p.word, "thistle1")) cmap[r - 1].col = FF_RGB(255, 225, 255);
            else if (!strcmp(p.word, "thistle2")) cmap[r - 1].col = FF_RGB(238, 210, 238);
            else if (!strcmp(p.word, "thistle3")) cmap[r - 1].col = FF_RGB(205, 181, 205);
            else if (!strcmp(p.word, "thistle4")) cmap[r - 1].col = FF_RGB(139, 123, 139);
            else if (!strcmp(p.word, "gray0")) cmap[r - 1].col = FF_RGB(0, 0, 0);
            else if (!strcmp(p.word, "grey0")) cmap[r - 1].col = FF_RGB(0, 0, 0);
            else if (!strcmp(p.word, "gray1")) cmap[r - 1].col = FF_RGB(3, 3, 3);
            else if (!strcmp(p.word, "grey1")) cmap[r - 1].col = FF_RGB(3, 3, 3);
            else if (!strcmp(p.word, "gray2")) cmap[r - 1].col = FF_RGB(5, 5, 5);
            else if (!strcmp(p.word, "grey2")) cmap[r - 1].col = FF_RGB(5, 5, 5);
            else if (!strcmp(p.word, "gray3")) cmap[r - 1].col = FF_RGB(8, 8, 8);
            else if (!strcmp(p.word, "grey3")) cmap[r - 1].col = FF_RGB(8, 8, 8);
            else if (!strcmp(p.word, "gray4")) cmap[r - 1].col = FF_RGB(10, 10, 10);
            else if (!strcmp(p.word, "grey4")) cmap[r - 1].col = FF_RGB(10, 10, 10);
            else if (!strcmp(p.word, "gray5")) cmap[r - 1].col = FF_RGB(13, 13, 13);
            else if (!strcmp(p.word, "grey5")) cmap[r - 1].col = FF_RGB(13, 13, 13);
            else if (!strcmp(p.word, "gray6")) cmap[r - 1].col = FF_RGB(15, 15, 15);
            else if (!strcmp(p.word, "grey6")) cmap[r - 1].col = FF_RGB(15, 15, 15);
            else if (!strcmp(p.word, "gray7")) cmap[r - 1].col = FF_RGB(18, 18, 18);
            else if (!strcmp(p.word, "grey7")) cmap[r - 1].col = FF_RGB(18, 18, 18);
            else if (!strcmp(p.word, "gray8")) cmap[r - 1].col = FF_RGB(20, 20, 20);
            else if (!strcmp(p.word, "grey8")) cmap[r - 1].col = FF_RGB(20, 20, 20);
            else if (!strcmp(p.word, "gray9")) cmap[r - 1].col = FF_RGB(23, 23, 23);
            else if (!strcmp(p.word, "grey9")) cmap[r - 1].col = FF_RGB(23, 23, 23);
            else if (!strcmp(p.word, "gray10")) cmap[r - 1].col = FF_RGB(26, 26, 26);
            else if (!strcmp(p.word, "grey10")) cmap[r - 1].col = FF_RGB(26, 26, 26);
            else if (!strcmp(p.word, "gray11")) cmap[r - 1].col = FF_RGB(28, 28, 28);
            else if (!strcmp(p.word, "grey11")) cmap[r - 1].col = FF_RGB(28, 28, 28);
            else if (!strcmp(p.word, "gray12")) cmap[r - 1].col = FF_RGB(31, 31, 31);
            else if (!strcmp(p.word, "grey12")) cmap[r - 1].col = FF_RGB(31, 31, 31);
            else if (!strcmp(p.word, "gray13")) cmap[r - 1].col = FF_RGB(33, 33, 33);
            else if (!strcmp(p.word, "grey13")) cmap[r - 1].col = FF_RGB(33, 33, 33);
            else if (!strcmp(p.word, "gray14")) cmap[r - 1].col = FF_RGB(36, 36, 36);
            else if (!strcmp(p.word, "grey14")) cmap[r - 1].col = FF_RGB(36, 36, 36);
            else if (!strcmp(p.word, "gray15")) cmap[r - 1].col = FF_RGB(38, 38, 38);
            else if (!strcmp(p.word, "grey15")) cmap[r - 1].col = FF_RGB(38, 38, 38);
            else if (!strcmp(p.word, "gray16")) cmap[r - 1].col = FF_RGB(41, 41, 41);
            else if (!strcmp(p.word, "grey16")) cmap[r - 1].col = FF_RGB(41, 41, 41);
            else if (!strcmp(p.word, "gray17")) cmap[r - 1].col = FF_RGB(43, 43, 43);
            else if (!strcmp(p.word, "grey17")) cmap[r - 1].col = FF_RGB(43, 43, 43);
            else if (!strcmp(p.word, "gray18")) cmap[r - 1].col = FF_RGB(46, 46, 46);
            else if (!strcmp(p.word, "grey18")) cmap[r - 1].col = FF_RGB(46, 46, 46);
            else if (!strcmp(p.word, "gray19")) cmap[r - 1].col = FF_RGB(48, 48, 48);
            else if (!strcmp(p.word, "grey19")) cmap[r - 1].col = FF_RGB(48, 48, 48);
            else if (!strcmp(p.word, "gray20")) cmap[r - 1].col = FF_RGB(51, 51, 51);
            else if (!strcmp(p.word, "grey20")) cmap[r - 1].col = FF_RGB(51, 51, 51);
            else if (!strcmp(p.word, "gray21")) cmap[r - 1].col = FF_RGB(54, 54, 54);
            else if (!strcmp(p.word, "grey21")) cmap[r - 1].col = FF_RGB(54, 54, 54);
            else if (!strcmp(p.word, "gray22")) cmap[r - 1].col = FF_RGB(56, 56, 56);
            else if (!strcmp(p.word, "grey22")) cmap[r - 1].col = FF_RGB(56, 56, 56);
            else if (!strcmp(p.word, "gray23")) cmap[r - 1].col = FF_RGB(59, 59, 59);
            else if (!strcmp(p.word, "grey23")) cmap[r - 1].col = FF_RGB(59, 59, 59);
            else if (!strcmp(p.word, "gray24")) cmap[r - 1].col = FF_RGB(61, 61, 61);
            else if (!strcmp(p.word, "grey24")) cmap[r - 1].col = FF_RGB(61, 61, 61);
            else if (!strcmp(p.word, "gray25")) cmap[r - 1].col = FF_RGB(64, 64, 64);
            else if (!strcmp(p.word, "grey25")) cmap[r - 1].col = FF_RGB(64, 64, 64);
            else if (!strcmp(p.word, "gray26")) cmap[r - 1].col = FF_RGB(66, 66, 66);
            else if (!strcmp(p.word, "grey26")) cmap[r - 1].col = FF_RGB(66, 66, 66);
            else if (!strcmp(p.word, "gray27")) cmap[r - 1].col = FF_RGB(69, 69, 69);
            else if (!strcmp(p.word, "grey27")) cmap[r - 1].col = FF_RGB(69, 69, 69);
            else if (!strcmp(p.word, "gray28")) cmap[r - 1].col = FF_RGB(71, 71, 71);
            else if (!strcmp(p.word, "grey28")) cmap[r - 1].col = FF_RGB(71, 71, 71);
            else if (!strcmp(p.word, "gray29")) cmap[r - 1].col = FF_RGB(74, 74, 74);
            else if (!strcmp(p.word, "grey29")) cmap[r - 1].col = FF_RGB(74, 74, 74);
            else if (!strcmp(p.word, "gray30")) cmap[r - 1].col = FF_RGB(77, 77, 77);
            else if (!strcmp(p.word, "grey30")) cmap[r - 1].col = FF_RGB(77, 77, 77);
            else if (!strcmp(p.word, "gray31")) cmap[r - 1].col = FF_RGB(79, 79, 79);
            else if (!strcmp(p.word, "grey31")) cmap[r - 1].col = FF_RGB(79, 79, 79);
            else if (!strcmp(p.word, "gray32")) cmap[r - 1].col = FF_RGB(82, 82, 82);
            else if (!strcmp(p.word, "grey32")) cmap[r - 1].col = FF_RGB(82, 82, 82);
            else if (!strcmp(p.word, "gray33")) cmap[r - 1].col = FF_RGB(84, 84, 84);
            else if (!strcmp(p.word, "grey33")) cmap[r - 1].col = FF_RGB(84, 84, 84);
            else if (!strcmp(p.word, "gray34")) cmap[r - 1].col = FF_RGB(87, 87, 87);
            else if (!strcmp(p.word, "grey34")) cmap[r - 1].col = FF_RGB(87, 87, 87);
            else if (!strcmp(p.word, "gray35")) cmap[r - 1].col = FF_RGB(89, 89, 89);
            else if (!strcmp(p.word, "grey35")) cmap[r - 1].col = FF_RGB(89, 89, 89);
            else if (!strcmp(p.word, "gray36")) cmap[r - 1].col = FF_RGB(92, 92, 92);
            else if (!strcmp(p.word, "grey36")) cmap[r - 1].col = FF_RGB(92, 92, 92);
            else if (!strcmp(p.word, "gray37")) cmap[r - 1].col = FF_RGB(94, 94, 94);
            else if (!strcmp(p.word, "grey37")) cmap[r - 1].col = FF_RGB(94, 94, 94);
            else if (!strcmp(p.word, "gray38")) cmap[r - 1].col = FF_RGB(97, 97, 97);
            else if (!strcmp(p.word, "grey38")) cmap[r - 1].col = FF_RGB(97, 97, 97);
            else if (!strcmp(p.word, "gray39")) cmap[r - 1].col = FF_RGB(99, 99, 99);
            else if (!strcmp(p.word, "grey39")) cmap[r - 1].col = FF_RGB(99, 99, 99);
            else if (!strcmp(p.word, "gray40")) cmap[r - 1].col = FF_RGB(102, 102, 102);
            else if (!strcmp(p.word, "grey40")) cmap[r - 1].col = FF_RGB(102, 102, 102);
            else if (!strcmp(p.word, "gray41")) cmap[r - 1].col = FF_RGB(105, 105, 105);
            else if (!strcmp(p.word, "grey41")) cmap[r - 1].col = FF_RGB(105, 105, 105);
            else if (!strcmp(p.word, "gray42")) cmap[r - 1].col = FF_RGB(107, 107, 107);
            else if (!strcmp(p.word, "grey42")) cmap[r - 1].col = FF_RGB(107, 107, 107);
            else if (!strcmp(p.word, "gray43")) cmap[r - 1].col = FF_RGB(110, 110, 110);
            else if (!strcmp(p.word, "grey43")) cmap[r - 1].col = FF_RGB(110, 110, 110);
            else if (!strcmp(p.word, "gray44")) cmap[r - 1].col = FF_RGB(112, 112, 112);
            else if (!strcmp(p.word, "grey44")) cmap[r - 1].col = FF_RGB(112, 112, 112);
            else if (!strcmp(p.word, "gray45")) cmap[r - 1].col = FF_RGB(115, 115, 115);
            else if (!strcmp(p.word, "grey45")) cmap[r - 1].col = FF_RGB(115, 115, 115);
            else if (!strcmp(p.word, "gray46")) cmap[r - 1].col = FF_RGB(117, 117, 117);
            else if (!strcmp(p.word, "grey46")) cmap[r - 1].col = FF_RGB(117, 117, 117);
            else if (!strcmp(p.word, "gray47")) cmap[r - 1].col = FF_RGB(120, 120, 120);
            else if (!strcmp(p.word, "grey47")) cmap[r - 1].col = FF_RGB(120, 120, 120);
            else if (!strcmp(p.word, "gray48")) cmap[r - 1].col = FF_RGB(122, 122, 122);
            else if (!strcmp(p.word, "grey48")) cmap[r - 1].col = FF_RGB(122, 122, 122);
            else if (!strcmp(p.word, "gray49")) cmap[r - 1].col = FF_RGB(125, 125, 125);
            else if (!strcmp(p.word, "grey49")) cmap[r - 1].col = FF_RGB(125, 125, 125);
            else if (!strcmp(p.word, "gray50")) cmap[r - 1].col = FF_RGB(127, 127, 127);
            else if (!strcmp(p.word, "grey50")) cmap[r - 1].col = FF_RGB(127, 127, 127);
            else if (!strcmp(p.word, "gray51")) cmap[r - 1].col = FF_RGB(130, 130, 130);
            else if (!strcmp(p.word, "grey51")) cmap[r - 1].col = FF_RGB(130, 130, 130);
            else if (!strcmp(p.word, "gray52")) cmap[r - 1].col = FF_RGB(133, 133, 133);
            else if (!strcmp(p.word, "grey52")) cmap[r - 1].col = FF_RGB(133, 133, 133);
            else if (!strcmp(p.word, "gray53")) cmap[r - 1].col = FF_RGB(135, 135, 135);
            else if (!strcmp(p.word, "grey53")) cmap[r - 1].col = FF_RGB(135, 135, 135);
            else if (!strcmp(p.word, "gray54")) cmap[r - 1].col = FF_RGB(138, 138, 138);
            else if (!strcmp(p.word, "grey54")) cmap[r - 1].col = FF_RGB(138, 138, 138);
            else if (!strcmp(p.word, "gray55")) cmap[r - 1].col = FF_RGB(140, 140, 140);
            else if (!strcmp(p.word, "grey55")) cmap[r - 1].col = FF_RGB(140, 140, 140);
            else if (!strcmp(p.word, "gray56")) cmap[r - 1].col = FF_RGB(143, 143, 143);
            else if (!strcmp(p.word, "grey56")) cmap[r - 1].col = FF_RGB(143, 143, 143);
            else if (!strcmp(p.word, "gray57")) cmap[r - 1].col = FF_RGB(145, 145, 145);
            else if (!strcmp(p.word, "grey57")) cmap[r - 1].col = FF_RGB(145, 145, 145);
            else if (!strcmp(p.word, "gray58")) cmap[r - 1].col = FF_RGB(148, 148, 148);
            else if (!strcmp(p.word, "grey58")) cmap[r - 1].col = FF_RGB(148, 148, 148);
            else if (!strcmp(p.word, "gray59")) cmap[r - 1].col = FF_RGB(150, 150, 150);
            else if (!strcmp(p.word, "grey59")) cmap[r - 1].col = FF_RGB(150, 150, 150);
            else if (!strcmp(p.word, "gray60")) cmap[r - 1].col = FF_RGB(153, 153, 153);
            else if (!strcmp(p.word, "grey60")) cmap[r - 1].col = FF_RGB(153, 153, 153);
            else if (!strcmp(p.word, "gray61")) cmap[r - 1].col = FF_RGB(156, 156, 156);
            else if (!strcmp(p.word, "grey61")) cmap[r - 1].col = FF_RGB(156, 156, 156);
            else if (!strcmp(p.word, "gray62")) cmap[r - 1].col = FF_RGB(158, 158, 158);
            else if (!strcmp(p.word, "grey62")) cmap[r - 1].col = FF_RGB(158, 158, 158);
            else if (!strcmp(p.word, "gray63")) cmap[r - 1].col = FF_RGB(161, 161, 161);
            else if (!strcmp(p.word, "grey63")) cmap[r - 1].col = FF_RGB(161, 161, 161);
            else if (!strcmp(p.word, "gray64")) cmap[r - 1].col = FF_RGB(163, 163, 163);
            else if (!strcmp(p.word, "grey64")) cmap[r - 1].col = FF_RGB(163, 163, 163);
            else if (!strcmp(p.word, "gray65")) cmap[r - 1].col = FF_RGB(166, 166, 166);
            else if (!strcmp(p.word, "grey65")) cmap[r - 1].col = FF_RGB(166, 166, 166);
            else if (!strcmp(p.word, "gray66")) cmap[r - 1].col = FF_RGB(168, 168, 168);
            else if (!strcmp(p.word, "grey66")) cmap[r - 1].col = FF_RGB(168, 168, 168);
            else if (!strcmp(p.word, "gray67")) cmap[r - 1].col = FF_RGB(171, 171, 171);
            else if (!strcmp(p.word, "grey67")) cmap[r - 1].col = FF_RGB(171, 171, 171);
            else if (!strcmp(p.word, "gray68")) cmap[r - 1].col = FF_RGB(173, 173, 173);
            else if (!strcmp(p.word, "grey68")) cmap[r - 1].col = FF_RGB(173, 173, 173);
            else if (!strcmp(p.word, "gray69")) cmap[r - 1].col = FF_RGB(176, 176, 176);
            else if (!strcmp(p.word, "grey69")) cmap[r - 1].col = FF_RGB(176, 176, 176);
            else if (!strcmp(p.word, "gray70")) cmap[r - 1].col = FF_RGB(179, 179, 179);
            else if (!strcmp(p.word, "grey70")) cmap[r - 1].col = FF_RGB(179, 179, 179);
            else if (!strcmp(p.word, "gray71")) cmap[r - 1].col = FF_RGB(181, 181, 181);
            else if (!strcmp(p.word, "grey71")) cmap[r - 1].col = FF_RGB(181, 181, 181);
            else if (!strcmp(p.word, "gray72")) cmap[r - 1].col = FF_RGB(184, 184, 184);
            else if (!strcmp(p.word, "grey72")) cmap[r - 1].col = FF_RGB(184, 184, 184);
            else if (!strcmp(p.word, "gray73")) cmap[r - 1].col = FF_RGB(186, 186, 186);
            else if (!strcmp(p.word, "grey73")) cmap[r - 1].col = FF_RGB(186, 186, 186);
            else if (!strcmp(p.word, "gray74")) cmap[r - 1].col = FF_RGB(189, 189, 189);
            else if (!strcmp(p.word, "grey74")) cmap[r - 1].col = FF_RGB(189, 189, 189);
            else if (!strcmp(p.word, "gray75")) cmap[r - 1].col = FF_RGB(191, 191, 191);
            else if (!strcmp(p.word, "grey75")) cmap[r - 1].col = FF_RGB(191, 191, 191);
            else if (!strcmp(p.word, "gray76")) cmap[r - 1].col = FF_RGB(194, 194, 194);
            else if (!strcmp(p.word, "grey76")) cmap[r - 1].col = FF_RGB(194, 194, 194);
            else if (!strcmp(p.word, "gray77")) cmap[r - 1].col = FF_RGB(196, 196, 196);
            else if (!strcmp(p.word, "grey77")) cmap[r - 1].col = FF_RGB(196, 196, 196);
            else if (!strcmp(p.word, "gray78")) cmap[r - 1].col = FF_RGB(199, 199, 199);
            else if (!strcmp(p.word, "grey78")) cmap[r - 1].col = FF_RGB(199, 199, 199);
            else if (!strcmp(p.word, "gray79")) cmap[r - 1].col = FF_RGB(201, 201, 201);
            else if (!strcmp(p.word, "grey79")) cmap[r - 1].col = FF_RGB(201, 201, 201);
            else if (!strcmp(p.word, "gray80")) cmap[r - 1].col = FF_RGB(204, 204, 204);
            else if (!strcmp(p.word, "grey80")) cmap[r - 1].col = FF_RGB(204, 204, 204);
            else if (!strcmp(p.word, "gray81")) cmap[r - 1].col = FF_RGB(207, 207, 207);
            else if (!strcmp(p.word, "grey81")) cmap[r - 1].col = FF_RGB(207, 207, 207);
            else if (!strcmp(p.word, "gray82")) cmap[r - 1].col = FF_RGB(209, 209, 209);
            else if (!strcmp(p.word, "grey82")) cmap[r - 1].col = FF_RGB(209, 209, 209);
            else if (!strcmp(p.word, "gray83")) cmap[r - 1].col = FF_RGB(212, 212, 212);
            else if (!strcmp(p.word, "grey83")) cmap[r - 1].col = FF_RGB(212, 212, 212);
            else if (!strcmp(p.word, "gray84")) cmap[r - 1].col = FF_RGB(214, 214, 214);
            else if (!strcmp(p.word, "grey84")) cmap[r - 1].col = FF_RGB(214, 214, 214);
            else if (!strcmp(p.word, "gray85")) cmap[r - 1].col = FF_RGB(217, 217, 217);
            else if (!strcmp(p.word, "grey85")) cmap[r - 1].col = FF_RGB(217, 217, 217);
            else if (!strcmp(p.word, "gray86")) cmap[r - 1].col = FF_RGB(219, 219, 219);
            else if (!strcmp(p.word, "grey86")) cmap[r - 1].col = FF_RGB(219, 219, 219);
            else if (!strcmp(p.word, "gray87")) cmap[r - 1].col = FF_RGB(222, 222, 222);
            else if (!strcmp(p.word, "grey87")) cmap[r - 1].col = FF_RGB(222, 222, 222);
            else if (!strcmp(p.word, "gray88")) cmap[r - 1].col = FF_RGB(224, 224, 224);
            else if (!strcmp(p.word, "grey88")) cmap[r - 1].col = FF_RGB(224, 224, 224);
            else if (!strcmp(p.word, "gray89")) cmap[r - 1].col = FF_RGB(227, 227, 227);
            else if (!strcmp(p.word, "grey89")) cmap[r - 1].col = FF_RGB(227, 227, 227);
            else if (!strcmp(p.word, "gray90")) cmap[r - 1].col = FF_RGB(229, 229, 229);
            else if (!strcmp(p.word, "grey90")) cmap[r - 1].col = FF_RGB(229, 229, 229);
            else if (!strcmp(p.word, "gray91")) cmap[r - 1].col = FF_RGB(232, 232, 232);
            else if (!strcmp(p.word, "grey91")) cmap[r - 1].col = FF_RGB(232, 232, 232);
            else if (!strcmp(p.word, "gray92")) cmap[r - 1].col = FF_RGB(235, 235, 235);
            else if (!strcmp(p.word, "grey92")) cmap[r - 1].col = FF_RGB(235, 235, 235);
            else if (!strcmp(p.word, "gray93")) cmap[r - 1].col = FF_RGB(237, 237, 237);
            else if (!strcmp(p.word, "grey93")) cmap[r - 1].col = FF_RGB(237, 237, 237);
            else if (!strcmp(p.word, "gray94")) cmap[r - 1].col = FF_RGB(240, 240, 240);
            else if (!strcmp(p.word, "grey94")) cmap[r - 1].col = FF_RGB(240, 240, 240);
            else if (!strcmp(p.word, "gray95")) cmap[r - 1].col = FF_RGB(242, 242, 242);
            else if (!strcmp(p.word, "grey95")) cmap[r - 1].col = FF_RGB(242, 242, 242);
            else if (!strcmp(p.word, "gray96")) cmap[r - 1].col = FF_RGB(245, 245, 245);
            else if (!strcmp(p.word, "grey96")) cmap[r - 1].col = FF_RGB(245, 245, 245);
            else if (!strcmp(p.word, "gray97")) cmap[r - 1].col = FF_RGB(247, 247, 247);
            else if (!strcmp(p.word, "grey97")) cmap[r - 1].col = FF_RGB(247, 247, 247);
            else if (!strcmp(p.word, "gray98")) cmap[r - 1].col = FF_RGB(250, 250, 250);
            else if (!strcmp(p.word, "grey98")) cmap[r - 1].col = FF_RGB(250, 250, 250);
            else if (!strcmp(p.word, "gray99")) cmap[r - 1].col = FF_RGB(252, 252, 252);
            else if (!strcmp(p.word, "grey99")) cmap[r - 1].col = FF_RGB(252, 252, 252);
            else if (!strcmp(p.word, "gray100")) cmap[r - 1].col = FF_RGB(255, 255, 255);
            else if (!strcmp(p.word, "grey100")) cmap[r - 1].col = FF_RGB(255, 255, 255);
            else if (!strcmp(p.word, "dark grey")) cmap[r - 1].col = FF_RGB(169, 169, 169);
            else if (!strcmp(p.word, "darkgrey")) cmap[r - 1].col = FF_RGB(169, 169, 169);
            else if (!strcmp(p.word, "dark gray")) cmap[r - 1].col = FF_RGB(169, 169, 169);
            else if (!strcmp(p.word, "darkgray")) cmap[r - 1].col = FF_RGB(169, 169, 169);
            else if (!strcmp(p.word, "dark blue")) cmap[r - 1].col = FF_RGB(0, 0, 139);
            else if (!strcmp(p.word, "darkblue")) cmap[r - 1].col = FF_RGB(0, 0, 139);
            else if (!strcmp(p.word, "dark cyan")) cmap[r - 1].col = FF_RGB(0, 139, 139);
            else if (!strcmp(p.word, "darkcyan")) cmap[r - 1].col = FF_RGB(0, 139, 139);
            else if (!strcmp(p.word, "dark magenta")) cmap[r - 1].col = FF_RGB(139, 0, 139);
            else if (!strcmp(p.word, "darkmagenta")) cmap[r - 1].col = FF_RGB(139, 0, 139);
            else if (!strcmp(p.word, "dark red")) cmap[r - 1].col = FF_RGB(139, 0, 0);
            else if (!strcmp(p.word, "darkred")) cmap[r - 1].col = FF_RGB(139, 0, 0);
            else if (!strcmp(p.word, "light green")) cmap[r - 1].col = FF_RGB(144, 238, 144);
            else if (!strcmp(p.word, "lightgreen")) cmap[r - 1].col = FF_RGB(144, 238, 144);
        } else if (!strcmp(p.word, "s")) {
            scanword(&p);
            cmap[r - 1].col = symcolor(p.word);
        }
    }
    for (r=cmsize + 1; r < cmsize + 1 + h && lines > 0; r++,lines--) {
        if (!code[r]) {
            free(cmap);
            free(rgba);
            return NULL;
        }
        p.code = code[r];
        p.head = 0;
        for (x=0; x < w; x++,tgt++) {
            ff_color_t c = 0;
            scanpart(&p, cpp);
            for (i=0; i < cmsize; i++)
                if (!strncmp(p.word, cmap[i].chr, (size_t)cpp)) {
                    c = cmap[i].col;
                    break;
                }
            *tgt = c;
        }
    }
    bmp = ff_bitmap(w, h, rgba);
    free(cmap);
    free(rgba);
    return bmp;
}

ff_bitmap_t ff_xpm(char** code, int* xhot, int* yhot)
{
    return do_xpm(code, (int)0x7FFFFFFF, xhot, yhot);
}

ff_bitmap_t ff_xpmload(const char* filename, int* xhot, int* yhot)
{
    FILE* f = fopen(filename, "rb");
    char* buff;
    char* xpm;
    char** line;
    long len, head = 0, tgt = 0;
    int bracket = FF_NO, lines = 0;
    ff_bitmap_t bmp;
    if (!f) return NULL;
    if (fseek(f, 0, SEEK_END)) {
        fclose(f);
        return NULL;
    }
    len = ftell(f);
    if (len == -1) {
        fclose(f);
        return NULL;
    }
    if (fseek(f, 0, SEEK_SET)) {
        fclose(f);
        return NULL;
    }
    buff = calloc(1, (size_t)(len + 1));
    if (fread(buff, (size_t)len, 1U, f) != 1) {
        free(buff);
        fclose(f);
        return NULL;
    }
    fclose(f);
    xpm = calloc(1, (size_t)(len + 1));
    line = calloc(1, sizeof(char*));
    line[0] = xpm;
    lines = 1;
    while (buff[head]) {
        while (buff[head]) {
            if (buff[head] == '/' && buff[head + 1] == '*') {
                head += 2;
                while (buff[head]) {
                    if (buff[head] == '*' && buff[head + 1] == '/') {
                        head += 2;
                        break;
                    }
                    head++;
                }
            } else if (buff[head] == '/' && buff[head + 1] == '/') {
                while (buff[head] &&
                       buff[head] != '\n' &&
                       buff[head] != '\r') head++;
            } else if (!isspace(buff[head])) break;
              else head++;
        }
        if (!buff[head]) break;
        if (buff[head] == '{') bracket = FF_YES;
        if (buff[head] == '}') break;
        if (bracket && buff[head] == '"') {
            head++;
            while (buff[head] && buff[head] != '"') {
                char ch = buff[head];
                if (ch == '\\') {
                    ch = buff[++head];
                    switch (ch) {
                    case 'r': ch = '\r'; break;
                    case 'n': ch = '\n'; break;
                    case 't': ch = '\t'; break;
                    }
                }
                if (!ch) break;
                xpm[tgt++] = ch;
                head++;
            }
            xpm[tgt++] = 0;
            line = realloc(line, sizeof(char*)*(size_t)(lines + 1));
            line[lines++] = xpm + tgt;
        }
        if (!buff[head]) break;
        head++;
    }
    free(buff);
    bmp = do_xpm(line, lines - 1, xhot, yhot);
    free(line);
    free(xpm);
    return bmp;
}

void ff_xpmsym(const char* name, ff_color_t color)
{
    size_t i;
    for (i=0; i < symcols; i++)
        if (!strcmp(name, symcol[i].name)) {
            symcol[i].col = color;
            return;
        }
    symcol = realloc(symcol, sizeof(struct symcol)*(symcols + 1));
    symcol[symcols].name = ff_strdup(name);
    for (i=0; symcol[symcols].name[i]; i++)
        symcol[symcols].name[i] = (char)tolower(symcol[symcols].name[i]);
    symcol[symcols].col = color;
    symcols++;
}
