#define LFORMS_SOURCE_CODE
#include <stdlib.h>
#include <string.h>
#include <lforms.h>
#include <lforms/winsys.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#ifndef LFORMS_NO_OPENGL
#include <GL/gl.h>
#include <GL/glx.h>
#endif
#ifdef LFORMS_USE_XFT
#include <X11/Xft/Xft.h>
#endif

#define FF_WSFLAG_INVALID 0x00000001U
#define FF_WSFLAG_TOPLEVEL 0x00000002U
#define FF_WSFLAG_CENTER 0x00000004U
#define FF_WSFLAG_DISABLED 0x00000008U

struct modal {
    struct _wswin_t* window;
    struct modal* next;
};

struct _ff_gc_t
{
    Window w;
    Drawable d;
    GC gc;
    ff_color_t color;
    ff_font_t font;
    int dx1, dy1, dx2, dy2;
};

struct _ff_bitmap_t
{
    FF_REFOBJ_HEAD
    Pixmap pixmap;
    Pixmap mask;
    int width;
    int height;
    ff_gc_t gc;
};

struct _ff_font_t
{
#ifdef LFORMS_USE_XFT
    XftFont* font;
#else
    XFontStruct* font;
#endif
    char* name;
    int size;
    unsigned flags;
};

typedef struct _wswin_t
{
    Window w;
    ff_gc_t gc;
    ff_window_t ffwindow;
    struct _wswin_t* parent;
    struct _wswin_t* focus_child;
    struct modal* modal;
    unsigned flags;
    unsigned wsflags;
    int width, height;
    Pixmap db;
    int dbw, dbh;
#ifndef LFORMS_NO_OPENGL
    GLXWindow glw;
    GLXContext glc;
#endif
    Colormap cmap;
} wswin_t;

#define FF_WS_VALIDWIN(w) (!((w)->wsflags & FF_WSFLAG_INVALID))

extern Display* ff_ws_display;
extern int ff_ws_screen;
extern Atom ff_ws_wm_delete_window;

#define DISPLAY ff_ws_display
#define SCREEN ff_ws_screen

ff_gc_t ff_ws_create_gc(Window w, wswin_t* win);
void ff_ws_free_gc(ff_gc_t gc, wswin_t* win);

#ifndef LFORMS_NO_OPENGL
extern Bool (*ff__x11_L_glXMakeContextCurrent)(Display*, GLXDrawable, GLXDrawable, GLXContext);
extern void (*ff__x11_L_glXSwapBuffers)(Display*, GLXDrawable);
#endif
