#define LFORMS_SOURCE_CODE
#include <stdlib.h>
#include <lforms.h>
#include <lforms/winsys.h>

typedef struct _regent_t
{
    void* native;
    void* wswin;
    struct _regent_t* next;
} regent_t;

static regent_t* first;

void ff_ws_common_init(void)
{
    ff_ws_gfx_init();
}

void ff_ws_common_shutdown(void)
{
    regent_t* e;
    while (ff_ws_has_events()) ff_ws_pump_events();
    for (e=first;e;) {
        regent_t* next = e->next;
        ff_ws_destroy_window(e->wswin);
        while (ff_ws_has_events()) ff_ws_pump_events();
        e = next;
    }
    ff_ws_gfx_shutdown();
}

void ff_ws_regwin(void* native, void* wswin)
{
    regent_t* re = malloc(sizeof(regent_t));
    re->native = native;
    re->wswin = wswin;
    re->next = first;
    first = re;
}

void ff_ws_unregwin(void* wswin)
{
    regent_t* re;
    regent_t* prev = NULL;
    for (re=first; re; re=re->next) {
        if (re->wswin == wswin) {
            if (prev) prev->next = re->next; else first=re->next;
            free(re);
            return;
        }
        prev = re;
    }
}

void ff_ws_enumreg(void (*proc)(void* native, void* wswin, void* data), void* data)
{
    regent_t* re;
    for (re=first; re; re=re->next) proc(re->native, re->wswin, data);
}

void* ff_ws_native(void* wswin)
{
    regent_t* re;
    for (re=first; re; re=re->next)
        if (re->wswin == wswin)
            return re->native;
    return NULL;
}

void* ff_ws_wswin(void* native)
{
    regent_t* re;
    for (re=first; re; re=re->next)
        if (re->native == native)
            return re->wswin;
    return NULL;
}
