#define LFORMS_SOURCE_CODE
#include <stdlib.h>
#include <string.h>
#include <lforms.h>
#include <lforms/winsys.h>
#include <windows.h>
#include <gl/gl.h>

#define FF_WSFLAG_INVALID 0x00000001U
#define FF_WSFLAG_TOPLEVEL 0x00000002U
#define FF_WSFLAG_CENTER 0x00000004U
#define FF_WSFLAG_DISABLED 0x00000008U

struct modal {
    struct _wswin_t* window;
    struct modal* next;
};

struct _ff_gc_t
{
    HWND w;
    HDC dc;
    COLORREF color;
    ff_font_t font;
    int bmpw, bmph;
};

struct _ff_bitmap_t
{
    FF_REFOBJ_HEAD
    int width;
    int height;
    HBITMAP bmp, oldbmp, mask;
    struct _ff_gc_t gc;
};

struct _ff_font_t
{
    HFONT font;
    char* name;
    int size;
    unsigned flags;
};

typedef struct _wswin_t
{
    HWND w;
    ff_gc_t gc;
    ff_window_t ffwindow;
    struct _wswin_t* parent;
    struct modal* modal;
    unsigned flags;
    unsigned wsflags;
    int law, lah; /* last reported width and height through FF_AREA */
#ifdef UNICODE
    unsigned leadsurr; /* lead surrogate for WM_CHAR */
#endif
    DWORD style;
    HDC dbdc; /* also holds OpenGL DC */
    HBITMAP db, dbold;
    int dbw, dbh;
    HGLRC rc;
    HCURSOR cursor;
} wswin_t;

ff_gc_t ff_ws_create_gc(HWND w, wswin_t* win);
void ff_ws_free_gc(ff_gc_t gc, wswin_t* win);

