#define LFORMS_SOURCE_CODE
#include <stdlib.h>
#include <string.h>
#include <lforms.h>

static ff_bitmap_t temp_bitmap;

static void free_temp_bitmap(void)
{
    ff_bitmap_free(temp_bitmap);
    temp_bitmap = NULL;
}

void ff_color_attr(ff_gc_t gc, ff_window_t win, const char* name, ff_color_t def)
{
    ff_color(gc, ff_color_get(win, name, def));
}

ff_color_t ff_color_get(ff_window_t win, const char* name, ff_color_t def)
{
    int color = 0;
    if (win && ff_geti_or_fail(win, name, &color))
        return (ff_color_t)color;
    return def;
}

void ff_font_text_size(ff_font_t font, const char* text, int* width, int* height)
{
    ff_gc_t gc;
    if (!temp_bitmap) {
        temp_bitmap = ff_bitmap(1, 1, NULL);
        ff_atexit(free_temp_bitmap);
    }
    gc = ff_bitmap_gc(temp_bitmap);
    ff_font(gc, font);
    ff_text_size(gc, text, width, height);
}
