#define LFORMS_SOURCE_CODE
#include <stdlib.h>
#include <string.h>
#include <lforms.h>

static int fail_paint_handler(void* glbox, ff_event_t* ev, void* data)
{
    ff_gc_t gc = ev->p;
    int w, h;
    ff_area(glbox, NULL, NULL, &w, &h);
    ff_color(gc, 0);
    ff_fill(gc, 0, 0, w, h);
    ff_color(gc, FF_RGB(255, 255, 255));
    ff_text(gc, 0, h/2, "Failed to create OpenGL context");
    return 1;
}

ff_window_t ff_glbox(ff_window_t parent, int width, int height, ff_handler_proc_t paint_handler, void* data)
{
    ff_window_t glbox = ff_window(parent, 0, 0, width, height, FF_OPENGL);
    if (!glbox) {
        glbox = ff_window(parent, 0, 0, width, height, FF_NOFLAGS);
        ff_set(glbox, "class", (void*)"glbox");
        ff_seti(glbox, "opengl-failed", FF_YES);
        ff_link(glbox, FF_PAINT, fail_paint_handler, NULL);
    } else {
        ff_set(glbox, "class", (void*)"glbox");
        ff_link(glbox, FF_PAINT, paint_handler, data);
    }
    return glbox;
}
