#define LFORMS_SOURCE_CODE
#include <stdlib.h>
#include <lforms.h>
#include <lforms/winsys.h>

struct _ff_window_t
{
    void* wswin;
};

static ff_bitmap_t default_icon;

static void free_default_icon(void)
{
    ff_bitmap_free(default_icon);
}

static ff_bitmap_t mkicon(void)
{
    static const unsigned char data[48*12] = {
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,0,0,0,
        0,0,0,0,80,85,1,0,0,0,0,0,0,0,0,64,149,86,5,0,0,0,0,0,0,0,0,85,
        106,102,86,0,0,0,0,0,0,0,84,169,90,105,89,1,0,0,0,0,0,80,165,
        251,166,166,167,21,0,0,0,0,64,149,233,238,154,90,90,89,0,0,0,
        0,84,170,191,191,190,181,166,102,5,0,0,0,84,254,254,255,170,154,
        154,149,21,0,0,0,116,249,251,255,127,122,121,122,89,1,0,0,121,
        249,255,254,235,154,150,154,90,5,0,0,117,151,255,255,191,107,
        107,107,106,22,0,0,117,110,254,255,254,249,229,229,213,86,0,0,
        117,127,246,255,255,187,171,170,106,85,0,0,121,255,151,255,191,
        174,110,109,149,86,0,0,117,191,107,255,255,255,171,86,234,102,
        0,0,101,254,127,249,239,235,85,157,101,89,0,0,117,187,255,166,
        191,106,117,171,105,87,0,0,105,238,254,94,90,105,238,106,154,
        89,0,0,121,175,255,111,101,255,251,159,118,95,0,0,105,158,238,
        238,233,239,174,166,157,86,0,0,101,174,254,238,245,187,235,121,
        231,101,0,0,89,158,221,222,185,174,118,158,185,93,0,0,101,170,
        222,238,190,187,174,119,110,87,0,0,149,153,221,221,233,106,214,
        105,218,85,0,0,101,170,222,237,186,218,118,154,182,94,0,0,85,
        153,221,221,173,166,157,166,93,87,0,0,85,154,154,237,169,105,
        167,105,155,102,0,0,80,153,217,221,101,218,105,154,101,89,0,0,
        64,149,153,169,173,183,153,102,105,86,1,0,0,149,153,153,165,89,
        150,89,154,89,5,0,0,84,154,154,121,154,101,150,102,91,21,0,0,
        80,149,153,153,85,89,149,89,85,85,0,0,0,149,85,101,85,166,105,
        85,85,85,0,0,0,84,153,85,149,89,85,85,85,5,0,0,0,80,85,89,102,
        86,85,85,21,0,0,0,0,0,149,85,89,85,85,21,0,0,0,0,0,0,84,101,85,
        85,85,0,0,0,0,0,0,0,80,85,85,85,1,0,0,0,0,0,0,0,0,85,85,1,0,0,
        0,0,0,0,0,0,0,80,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
        0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
    };
    ff_color_t pal[4] = {
        FF_RGB(255, 0, 255),
        FF_3DDARK_COLOR,
        FF_3DSHADOW_COLOR,
        FF_3DFACE_COLOR};
    ff_color_t rgb[48*48];
    int x, y;
    for (y=0; y < 48; y++) {
        for (x=0; x < 48; x += 4) {
            rgb[y*48 + x] = pal[data[(y*48 + x)/4]&0x03];
            rgb[y*48 + x + 1] = pal[(data[(y*48 + x)/4]>>2)&0x03];
            rgb[y*48 + x + 2] = pal[(data[(y*48 + x)/4]>>4)&0x03];
            rgb[y*48 + x + 3] = pal[(data[(y*48 + x)/4]>>6)&0x03];
        }
    }
    default_icon = ff_bitmap(48, 48, rgb);
    ff_atexit(free_default_icon);
    return default_icon;
}

ff_window_t ff_frame(ff_window_t parent, const char* title, ff_bitmap_t icon, int width, int height, unsigned flags)
{
    ff_window_t frame;
    if (parent) flags |= FF_POPUP;
    frame = ff_window(parent, 0, 0, width, height, flags|FF_INVISIBLE);
    ff_setcs(frame, "class", "frame");
    ff_setcs(frame, "caption", title);
    ff_reicon(frame, icon);
    if (!(flags & FF_INVISIBLE)) ff_show(frame, FF_YES);
    return frame;
}

ff_window_t ff_mainframe(const char* title, ff_bitmap_t icon, int width, int height, unsigned flags)
{
    ff_window_t frame = ff_frame(NULL, title, icon, width, height, flags);
    if (!frame) return NULL;
    ff_seti(frame, "exit-on-close", FF_YES);
    return frame;
}

void ff_retitle(ff_window_t frame, const char* title)
{
    if (frame) ff_ws_set_caption(frame->wswin, title ? title : "");
}

void ff_reicon(ff_window_t frame, ff_bitmap_t icon)
{
    if (frame) {
        if (!icon) {
            if (!default_icon) mkicon();
            icon = default_icon;
        }
        ff_ws_set_icon(frame->wswin, icon);
    }
}
