#define LFORMS_SOURCE_CODE
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <lforms.h>

void ff_border(ff_window_t win, ff_window_t* child, int children, int width, int height)
{
    int cx = 0, cy = 0, wpw = 0, wph = 0, pw, ph, cw = width, ch = height, i;
    ff_window_t top = NULL, bottom = NULL, left = NULL, right = NULL, center = NULL;
    int pa = ff_geti(win, "padding-around");
    const char* arrangement = ff_get(win, "border-arrangement");
    int horizout = arrangement && !strcmp(arrangement, "horizontal-out");
    int contw = ff_geti(win, "container-width");
    int conth = ff_geti(win, "container-height");
    cx += ff_geti(win, "padding-left") + pa;
    cy += ff_geti(win, "padding-top") + pa;
    cw -= ff_geti(win, "padding-right") + cx + pa;
    ch -= ff_geti(win, "padding-bottom") + cy + pa;
    width -= ff_geti(win, "padding-right") + pa;
    height -= ff_geti(win, "padding-bottom") + pa;
    for (i=0; i<children; i++) {
        const char* align;
        int aligned = 0;
        if (!ff_shown(child[i])) continue;
        align = ff_get(child[i], "border-align");
        if (align) {
            aligned = 1;
            if (!strcmp(align, "top")) top = child[i];
            else if (!strcmp(align, "bottom")) bottom = child[i];
            else if (!strcmp(align, "left")) left = child[i];
            else if (!strcmp(align, "right")) right = child[i];
            else if (!strcmp(align, "center")) center = child[i];
            else aligned = 0;
        }
        if (!aligned) {
            if (!center) center = child[i];
            else if (!top) top = child[i];
            else if (!bottom) bottom = child[i];
            else if (!left) left = child[i];
            else if (!right) right = child[i];
        }
    }

    if (center) {
        ff_lh_prefsize(center, &pw, &ph, FF_NOFLAGS);
        wpw = pw;
        wph = ph;
    }
    if (horizout) {
        if (left) {
            ff_lh_prefsize(left, &pw, &ph, FF_NOFLAGS);
            ff_lh_place(left, cx, cy, pw, ch);
            cx += pw;
            cw -= pw;
            wpw += pw;
            if (wph < ph) wph = ph;
        }
        if (right) {
            ff_lh_prefsize(right, &pw, &ph, FF_NOFLAGS);
            ff_lh_place(right, width - pw, cy, pw, ch);
            cw -= pw;
            wpw += pw;
            if (wph < ph) wph = ph;
        }
        if (top) {
            ff_lh_prefsize(top, &pw, &ph, FF_NOFLAGS);
            ff_lh_place(top, cx, cy, cw, ph);
            cy += ph;
            ch -= ph;
            if (wpw < pw) wpw = pw;
            if (wph < ph) wph = ph;
        }
        if (bottom) {
            ff_lh_prefsize(bottom, &pw, &ph, FF_NOFLAGS);
            ff_lh_place(bottom, cx, height - ph, cw, ph);
            ch -= ph;
            if (wpw < pw) wpw = pw;
            if (wph < ph) wph = ph;
        }
    } else {
        int topbottomheight = 0;
        if (top) {
            ff_lh_prefsize(top, &pw, &ph, FF_NOFLAGS);
            ff_lh_place(top, cx, cy, cw, ph);
            cy += ph;
            ch -= ph;
            if (wpw < pw) wpw = pw;
            topbottomheight += ph;
        }
        if (bottom) {
            ff_lh_prefsize(bottom, &pw, &ph, FF_NOFLAGS);
            ff_lh_place(bottom, cx, height - ph, cw, ph);
            ch -= ph;
            if (wpw < pw) wpw = pw;
            topbottomheight += ph;
        }
        if (left) {
            ff_lh_prefsize(left, &pw, &ph, FF_NOFLAGS);
            ff_lh_place(left, cx, cy, pw, ch);
            cx += pw;
            cw -= pw;
            wpw += pw;
            if (wph < ph) wph = ph;
        }
        if (right) {
            ff_lh_prefsize(right, &pw, &ph, FF_NOFLAGS);
            ff_lh_place(right, width - pw, cy, pw, ch);
            cw -= pw;
            wpw += pw;
            if (wph < ph) wph = ph;
        }
        wph += topbottomheight;
    }
    if (center) {
        ff_lh_place(center, cx, cy, cw, ch);
    }
    wpw += ff_geti(win, "padding-right") + ff_geti(win, "padding-left") + pa*2;
    wph += ff_geti(win, "padding-bottom") + ff_geti(win, "padding-top") + pa*2;

    if (wpw < contw) wpw = contw;
    if (wph < conth) wph = conth;

    ff_prefsize(win, wpw, wph);
}
