#include <lforms.h>

static ff_window_t main_frame;  /* The main frame (window) */
static ff_window_t splitter;    /* The splitter */
static ff_window_t subsplitter; /* The splitter inside the splitter */

/* Entry point */
int main(int argc, char** argv)
{
    /* Initialize */
    if (!ff_init(argc, argv, "Splitter"))
        return 1;

    /* Create main frame */
    main_frame = ff_mainframe("Splitter Example", NULL,
                              320, 180,
                              FF_NOFLAGS);
    ff_layout(main_frame, ff_border);

    /* Create the main splitter */
    splitter = ff_splitter(main_frame, FF_VERTICAL);

    /* Create a buttons for the top side of the splitter */
    ff_button(splitter, "First Button (hard set to 50px)", NULL, NULL);

    /* Create a second splitter to be used as the bottom side of the
     * main splitter. */
    subsplitter = ff_splitter(splitter, FF_HORIZONTAL);

    /* Create two buttons in the second splitter */
    ff_button(subsplitter, "Second Button (fit)", NULL, NULL);
    ff_button(subsplitter, "Third Button", NULL, NULL);

    /* Pump the events - at this point the layout isn't settled yet
     * because not all events have been processed so any further attempt
     * to modify the splitter position will fail if it is outside the
     * splitter area and any subsequent area event may change it.  By
     * pumping the events we ensure that the layout will be in place up
     * to this point and splitter positioning will work as expected */
    ff_pump_events();

    /* Set the initial splitter position to 50 pixels */
    ff_seti(splitter, "position", 50);

    /* Set the initial subsplitter position to the preferred width of
     * the left control.  We do this by making the right control to be
     * the growing control and calling ff_subsplitter_fit which moves
     * the splitter to the non-growing side.  Note that technically we
     * do not need to set the grow property to left since this is the
     * default value - the call is here for illustrational purposes */
    ff_set(subsplitter, "grow", "right");
    ff_splitter_fit(subsplitter);

    /* Set the control growth to happen for both controls */
    ff_set(subsplitter, "grow", "both");

    /* Enter main loop */
    return ff_run();
}
