#include <lforms.h>

static ff_window_t main_frame;  /* The main frame (window) */
static ff_window_t label1;      /* First label */
static ff_window_t label2;      /* Second label */

/* Called when the position of a scrollbar changes */
static int change(void* sb, ff_event_t* ev, void* data)
{
    char tmp[256];
    int horizontal = ((const char*)ff_get(sb, "orientation"))[0] == 'h';
    sprintf(tmp, "%s pos is %i of %i with pagesize %i",
            horizontal ? "Horizontal" : "Vertical",
            ev->x, ev->y, ev->z);
    ff_set(horizontal ? label1 : label2, "caption", tmp);
    return 1;
}

/* Entry point */
int main(int argc, char** argv)
{
    ff_window_t sb; /* Used for both scrollbars */
    ff_window_t lc; /* Label container */

    /* Initialize */
    if (!ff_init(argc, argv, "Scrollbar Test"))
        return 1;

    /* Create main frame */
    main_frame = ff_mainframe("Scrollbar Test", NULL,
                              400, 120,
                              FF_NOFLAGS);
    ff_layout(main_frame, ff_border);
    ff_set(main_frame, "border-arrangement", "horizontal-out");

    /* Create the labels */
    lc = ff_window(main_frame, 0, 0, 1, 1, 0);
    ff_set(lc, "border-align", "center");
    ff_set(lc, "align-horizontal", "center");
    ff_set(lc, "align-vertical", "center");
    ff_layout(lc, ff_stack);
    label1 = ff_label(lc, "Horizontal Scrollbar");
    label2 = ff_label(lc, "Vertical Scrollbar");
    ff_set(label1, "align-horizontal", "center");
    ff_set(label2, "align-horizontal", "center");

    /* Create vertical scrollbar */
    sb = ff_scrollbar(main_frame, FF_AUTO, 500, 250, 0);
    ff_set(sb, "border-align", "left");
    ff_seti(sb, "margin-left", -1);
    ff_seti(sb, "margin-top", -1);
    ff_seti(sb, "margin-bottom", -1);
    ff_link(sb, FF_CHANGE, change, NULL);
    ff_link(main_frame, FF_PRESS, ff_redirect, sb);

    /* Create horizontal scrollbar */
    sb = ff_scrollbar(main_frame, 0, 10, 0, 1);
    ff_set(sb, "border-align", "bottom");
    ff_seti(sb, "margin-left", -1);
    ff_seti(sb, "margin-right", -1);
    ff_seti(sb, "margin-bottom", -1);
    ff_link(sb, FF_CHANGE, change, NULL);

    /* Enter main loop */
    return ff_run();
}
