#include <lforms.h>

static ff_window_t main_frame;  /* The main frame (window) */
static ff_window_t label;       /* A label to show messages */

/* Called when a child radio button with a value is selected */
static int value_change(void* box, ff_event_t* ev, void* data)
{
    char tmp[256];
    /* Ensure this change event is intended for the radio button's
     * parent (ev->p is set with the source radio button) and is not a
     * bubbled up change event sent to the radio button itself. */
    if (!ev->p) return FF_NO;
    /* Update the status caption */
    sprintf(tmp, "Selected '%s' with value '%s'",
        (char*)ff_get(ev->p, "caption"),
        (char*)ff_get(box, "radio-value"));
    ff_set(label, "caption", tmp);
    return FF_YES;  /* We handled the event */
}

/* Entry point */
int main(int argc, char** argv)
{
    ff_window_t box;    /* Helper box */

    /* Initialize */
    if (!ff_init(argc, argv, "Radio Buttons"))
        return 1;

    /* Create main frame */
    main_frame = ff_mainframe("Radio Buttons", NULL,
                              320, 320,
                              FF_INVISIBLE);

    /* Setup layout */
    ff_layout(main_frame, ff_stack);
    ff_seti(main_frame, "padding-around", 15);
    ff_seti(main_frame, "stack-spacing", 6);

    /* Create a simple group of radio buttons */
    box = ff_box(main_frame, "Some radio buttons", NULL);
    ff_layout(box, ff_stack);
    ff_seti(box, "stack-spacing", 4);
    ff_radio(box, "Option 1", 1);
    ff_radio(box, "Option 2", 0);
    ff_radio(box, "Option 3", 0);

    /* Create another group of radio buttons */
    box = ff_box(main_frame, "Radio buttons with values", NULL);
    ff_layout(box, ff_stack);
    ff_seti(box, "stack-spacing", 4);
    ff_set(ff_radio(box, "Option A", 0), "value", "Foo");
    ff_set(ff_radio(box, "Option B", 1), "value", "Bar");

    /* Pump events to get rid of the FF_CHANGE that was generated by
     * setting the values for the radio boxes.  Normally we want those
     * events to be generated for the the application state to be
     * consistent with or without user actions, but in this case we use
     * the same label for both an initial message and for messages when
     * the event is set.  By pumping the events, we make sure that the
     * label's caption below be replaced right as the program starts. */
    ff_pump_events();

    /* Create the messages label */
    label = ff_label(main_frame, "Click on any radio button to select it.");

    /* Link the FF_CHANGE event for the last box that will receive it
     * when any radio button with a value becomes selected. */
    ff_link(box, FF_CHANGE, value_change, NULL);

    /* Pack and show */
    ff_pack(main_frame, FF_BOTH);
    ff_show(main_frame, FF_YES);

    /* Enter main loop */
    return ff_run();
}
