#include <lforms.h>

static ff_window_t main_frame;  /* The main frame (window) */
static ff_window_t choice;      /* The choice box */
static ff_window_t label;       /* A label to display text into */

/* Event callback for the FF_SELECT ven from 'choice' */
static int chosen(void* cb, ff_event_t* ev, void* data)
{
    char tmp[256];
    sprintf(tmp, "You chose option #%i, '%s'",
        ff_geti(cb, "selection") + 1,
        (const char*)ff_get(cb, "text"));
    ff_set(label, "caption", tmp);
    return 1;
}

/* Entry point */
int main(int argc, char** argv)
{
    /* The choices to use */
    const char* items[] = {
        "Choice A", "Choice B", "Another choice", "Some other choice",
        "Not a real choice", "Best choice", "Last choice"
    };

    /* Initialize */
    if (!ff_init(argc, argv, "Choice"))
        return 1;

    /* Create main frame */
    main_frame = ff_mainframe("The Choice", NULL,
                              320, 320,
                              FF_NOFLAGS);
    ff_layout(main_frame, ff_stack);
    ff_seti(main_frame, "padding-around", 15);
    ff_seti(main_frame, "stack-spacing", 5);

    /* Create the widgets */
    ff_label(main_frame, "Make a choice:");
    choice = ff_choice(main_frame, items, NULL, sizeof(items)/sizeof(char*), 0);
    label = ff_label(main_frame, "You chose option #X, "
        "Some big placeholder text");

    /* Link the selection change event in the choice box */
    ff_link(choice, FF_SELECT, chosen, NULL);

    /* Pack the window both horizontally and vertically to fit
     * the preferred size of its chilren */
    ff_pack(main_frame, FF_BOTH);

    /* Enter main loop */
    return ff_run();
}

