#!/usr/bin/env python2

import os
import sys
import subprocess
from optparse import OptionParser

def runcmd(cmd):
    return subprocess.check_output(cmd, stderr=subprocess.STDOUT, shell=True).strip()

winsys = 'x11'
winansi = False
usexft = 'yes'
platform = sys.platform
if sys.platform == 'win32' or sys.platform == 'msys':
    platform = 'win32'
    winsys = 'win32'
    usexft = 'no'
elif sys.platform.startswith('darwin'):
    #winsys = 'cocoa'
    platform = 'osx'
    winsys = 'x11'
    usexft = 'no'

oparser = OptionParser(version="configure script for Little Forms")
oparser.add_option("--winsys", action="store", type="string", dest="winsys", default=winsys, help="target window system (can be x11 or win32) [default: %default]")
oparser.add_option("--use-xft", action="store", type="string", dest="usexft", default=usexft, help="use the Xft library for font rendering under x11 (can be yes or no) [default: %default]")
oparser.add_option("--no-opengl", action="store_true", dest="noopengl", default=False, help="disable OpenGL support")
oparser.add_option("--no-xim", action="store_true", dest="noxim", default=False, help="disable XIM support (X11 only)")
oparser.add_option("--no-examples", action="store_true", dest="noexamples", default=False, help="do not build the examples")
oparser.add_option("--bits", action="store", dest="bits", default="", help="specify build bits (-mnumber parameter), leave empty for none")
oparser.add_option("--debug", action="store_true", dest="debugbuild", default=False, help="Debug build")
oparser.add_option("--enable-sanitizers", action="store_true", dest="debugsanitizers", default=False, help="Enable sanitizers (asan, ubsan, etc) in debug build")
oparser.add_option("--trap-x11-errors", action="store_true", dest="trapx11errors", default=False, help="Call __builtin_trap() for X11 errors")
oparser.add_option("--win32-ansi", action="store_true", dest="win32ansi", default=False, help="use ANSI calls for Win32 (mainly for Win9x/ME builds)")
oparser.add_option("--devel", action="store_true", dest="devel", default=False, help="shortcut for no Xft, no OpenGL, debug, enable sanitizers and trap X11 errors")
oparser.add_option("--develv", action="store_true", dest="develv", default=False, help="like --devel but without --enable-sanitizers")
(options, args) = oparser.parse_args()

if options.devel:
    options.usexft=False
    options.noopengl=True
    options.debugbuild=True
    options.debugsanitizers=True
    options.trapx11errors=True


if options.develv:
    options.usexft=False
    options.noopengl=True
    options.debugbuild=True
    options.debugsanitizers=False
    options.trapx11errors=True

print "Little Forms Configuration Script"
print "================================="
print "Current Platform                 " + platform
print "Target Window System:            " + options.winsys
print "Use Xft library:                 " + str(options.usexft)
print "Enable OpenGL support:           " + str(not options.noopengl)
if options.winsys == 'x11':
    print "Enable XIM support:              " + str(not options.noxim)
print "Enable Examples:                 " + str(not options.noexamples)
if options.bits == '':
    print "Target Bits:                     (default)"
else:
    print "Target Bits:                     " + options.bits
print "Debug Build:                     " + str(options.debugbuild)
print "Debug Build Sanitizers:          " + str(options.debugsanitizers)
print "Trap X11 Errors:                 " + str(options.trapx11errors)
print "Use ANSI calls for Win32:        " + str(options.win32ansi)

winsys = options.winsys
winansi = options.win32ansi
ws_cflags = ''
ws_ldflags = ''
cfg_cflags = ''
cfg_ldflags = ''
sanitize_flags = ''
opengl_lib = ''

ws_cflags = ws_cflags + ' -ansi -pedantic -Wall -Wextra -Wno-unused-parameter -fno-strict-aliasing -fno-strict-overflow '
ws_cflags = ws_cflags + '-ffunction-sections -fdata-sections '
ws_ldflags = ws_ldflags + ' -Wl,--as-needed,--gc-sections '
cfg_ldflags = cfg_ldflags + ' -Wl,--as-needed,--gc-sections '

if options.debugsanitizers:
    sanitize_flags = ' -fsanitize=address -fsanitize=undefined -fstack-protector-all '

ws_cflags = ws_cflags + ' -Wdouble-promotion -Wformat=2 -Wformat-signedness -Wnull-dereference -Wshift-negative-value -Wshift-overflow=2 -Wunused-const-variable=2 -Wc90-c99-compat -Wc99-c11-compat  -Wcast-align -Wconversion -Wdate-time -Wjump-misses-init -Wlogical-op -Waggregate-return -Wstrict-prototypes -Wold-style-definition -Wduplicated-cond -Wtrampolines -Wfloat-equal -Wdeclaration-after-statement -Wundef -Wvla -Wunsuffixed-float-constants -Wno-overlength-strings '

# -Wpadded

if options.bits <> '':
    ws_cflags = ws_cflags + ' -m' + options.bits + ' '
    ws_ldflags = ws_ldflags + ' -m' + options.bits + ' '
    cfg_cflags = cfg_cflags + ' -m' + options.bits + ' '
    cfg_ldflags = cfg_ldflags + ' -m' + options.bits + ' '

if options.debugbuild:
    ws_cflags = ws_cflags + ' -g3 ' + sanitize_flags
    ws_ldflags = ws_ldflags + sanitize_flags
else:
    ws_cflags = ws_cflags + ' -O2 ' + sanitize_flags
    ws_ldflags = ws_ldflags + ' -O ' + sanitize_flags

if winsys == 'win32':
    if not winansi:
        ws_cflags = ws_cflags + ' -DUNICODE -D_UNICODE '
        cfg_cflags = cfg_cflags + ' -DUNICODE -D_UNICODE '
        #ws_ldflags = ws_ldflags + ' -municode '
    ws_ldflags = ws_ldflags + '-mwindows -llforms '
    cfg_ldflags = cfg_ldflags + ' -mwindows -llforms '
    if not options.noopengl:
        ws_ldflags = ws_ldflags + '-lopengl32 '
        cfg_ldflags = cfg_ldflags + '-lopengl32 '
    ws_ldflags = ws_ldflags + '-lm '
    cfg_ldflags = cfg_ldflags + '-lm '
elif winsys == 'x11':
    ws_ldflags = ws_ldflags + '-llforms '
    cfg_ldflags = cfg_ldflags + '-llforms '
    ws_ldflags = ws_ldflags + ' -lX11 -lm'
    cfg_ldflags = cfg_ldflags + ' -lX11 -lm '
    if not options.noopengl:
        ws_ldflags = ws_ldflags + ' -ldl '
        cfg_ldflags = cfg_ldflags + ' -ldl '
        opengl_lib = ' -lGL '
    if options.noxim:
        ws_cflags = ws_cflags + ' -DLFORMS_NOXIM '
    if options.usexft == 'yes':
        ws_cflags = ws_cflags + ' -DLFORMS_USE_XFT ' + runcmd('pkg-config xft --cflags') + ' '
        ws_ldflags = ws_ldflags + ' ' + runcmd('pkg-config xft --libs') + ' -lfontconfig '
        cfg_cflags = cfg_cflags + ' ' + runcmd('pkg-config xft --cflags') + ' '
        cfg_ldflags = cfg_ldflags + ' ' + runcmd('pkg-config xft --libs') + ' -lfontconfig '
    if options.trapx11errors:
        ws_cflags = ws_cflags + ' -DLFORMS_TRAPX11ERRORS '
    if platform == 'win32':
        ws_ldflags = ws_ldflags + ' -lws2_32 '
        cfg_ldflags = cfg_ldflags + ' -lws2_32 '
    if platform == 'osx':
        ws_cflags = ws_cflags + ' -I/usr/X11/include -I/usr/X11R6/include '
#elif winsys == 'cocoa':
#    ws_ldflags = '-llforms '
#    if not options.noopengl:
#        ws_ldflags = ws_ldflags + ' -framework OpenGL '
#    ws_ldflags = ws_ldflags + ' -lm'

if options.noopengl:
    ws_cflags = ws_cflags + ' -DLFORMS_NO_OPENGL '
    cfg_cflags = cfg_cflags + ' -DLFORMS_NO_OPENGL '
if options.debugbuild:
    ws_cflags = ws_cflags + '-DLFORMS_DEBUG '
    cfg_cflags = cfg_cflags + ' -DLFORMS_DEBUG '

ws_cflags = str.strip(ws_cflags)
ws_ldflags = str.strip(ws_ldflags)
cfg_cflags = str.strip(cfg_cflags)
cfg_ldflags = str.strip(cfg_ldflags)

print ""
print "Compiler Options:"
print "-----------------"
print "library CFLAGS=" + ws_cflags
print "library LDFLAGS=" + ws_ldflags
print "config  CFLAGS=" + cfg_cflags
print "config  LDFLAGS=" + cfg_ldflags

f = open("lforms-config", "w")
f.write('''#!/bin/bash

# Compile configuration script for Little Forms
# Do not modify directly, please use configure.py instead

showhelp=1
showcflags=0
showldflags=0
showwscflags=0
showwsldflags=0
showmakefile=0
showopenglflags=0
lformsconfig=lforms-config

for ((i=1; i<=$#; i++));
do

    if [ ${!i} = "--cflags" ]
    then
        showcflags=1
        showhelp=0
    elif [ ${!i} = "--libs" ]
    then
        showldflags=1
        showhelp=0
    elif [ ${!i} = "--ws-cflags" ]
    then
        showwscflags=1
        showhelp=0
    elif [ ${!i} = "--ws-libs" ]
    then
        showwsldflags=1
        showhelp=0
    elif [ ${!i} = "--opengl" ]
    then
        showopenglflags=1
        showhelp=0
    elif [ ${!i} = "--makefile" ]
    then
        showmakefile=1
        showhelp=0
    elif [ ${!i} = "--lformsconfig" ]
    then
        ((i++))
        lformsconfig=${!i}
    else
        echo "Unknown parameter"
    fi

done

if [ $showhelp = "1" ]
then
    echo "Usage: lforms-config [--cflags] [--libs] [--ws-cflags] [--ws-libs] [--opengl] [--makefile] [--lformsconfig <relative path to lforms-config>]"
fi

if [ $showcflags = "1" ]
then
    echo '-I''' + os.getcwd() + "/include " + cfg_cflags + ''''
fi

if [ $showldflags = "1" ]
then
    echo '-L''' + os.getcwd() + " " + cfg_ldflags + ''''
fi

if [ $showwscflags = "1" ]
then
    echo '-I''' + os.getcwd() + "/include " + ws_cflags + ''''
fi

if [ $showwsldflags = "1" ]
then
    echo '-L''' + os.getcwd() + " " + ws_ldflags + ''''
fi

if [ $showopenglflags = "1" ]
then
    echo ''' + opengl_lib + '''
fi

if [ $showmakefile = "1" ]
then
    echo '# Generated makefile by lforms-config, feel free to edit'
    echo 'OUTPUT=example'
    echo 'CFLAGS=-ansi -pedantic -Wall -Wextra -Wno-unused-parameter $(shell ' $lformsconfig ' --cflags)'
    echo 'LDFLAGS=$(shell ' $lformsconfig ' --libs)'
    echo 'SOURCES=$(wildcard *.c)'
    echo 'OBJECTS=$(patsubst %.c,%.o,$(SOURCES))'
    echo 'HEADERS=$(wildcard *.h)'
    echo 'CC ?= gcc'
    echo 'RM ?= rm -f'
    echo ''
    echo '.PHONY: all'
    echo 'all: $(OUTPUT)'
    echo ''
    echo '$(OUTPUT): $(OBJECTS)'
    echo '	$(CC) $(LDFLAGS) -o $(OUTPUT) $(OBJECTS) $(LDFLAGS)'
    echo ''
    echo '%.o: %.c $(HEADERS)'
    echo '	$(CC) $(CFLAGS) -c $< -o $@'
    echo ''
    echo '.PHONY: clean'
    echo 'clean:'
    echo '	$(RM) $(OUTPUT) $(OBJECTS)'
    echo ''
    echo '.PHONY: distclean'
    echo 'distclean: clean'
fi

''');

try:
    os.chmod("lforms-config", 509) # 0775
except:
    pass

f = open("Makefile", "w")
f.write("# generated makefile, do not modify. Use configure.py instead.\n\n")
f.write("OUTPUT=liblforms.a\n")
f.write("CFLAGS=$(shell ./lforms-config --ws-cflags)\n")
f.write("SOURCES=$(wildcard src/*.c) $(wildcard src/" + winsys + "/*.c)\n")
f.write("OBJECTS=$(patsubst %.c,%.o,$(SOURCES))\n")
f.write("HEADERS=$(wildcard include/lforms/*.h) $(wildcard src/"+ winsys + "/*.h)\n")
f.write("CC ?= gcc\n")
f.write("AR ?= ar\n")
f.write("RANLIB ?= ranlib\n")
f.write("\n")
f.write('''
.PHONY: all
all: $(OUTPUT) demo examples

.PHONY: demo
demo: $(OUTPUT) icons
''')
if not options.noexamples:
    f.write("\t$(MAKE) -C demo\n")
f.write('''
.PHONY: examples
examples: $(OUTPUT) icons
''')
if not options.noexamples:
    f.write("\t$(MAKE) -C examples\n")
f.write('''
$(OUTPUT): $(OBJECTS)
	$(AR) rcs $(OUTPUT) $(OBJECTS)
	$(RANLIB) $(OUTPUT)

%.o: %.c $(HEADERS)
	$(CC) -DLFORMS_SOURCE_CODE_CHECK $(CFLAGS) -c $< -o $@

.PHONY: clean
clean:
	$(RM) $(OUTPUT) $(OBJECTS)
	$(MAKE) -C demo clean
	$(MAKE) -C examples clean

.PHONY: distclean
distclean: clean
	$(MAKE) -C demo distclean
	$(MAKE) -C examples distclean
	$(RM) Makefile lforms-config

''')
f.close()

print ""
print "You can type  make  to build Little Forms now"
