unit RBUtil;
{$MODE OBJFPC}{$H+}
interface

const
  VersionHi = 0;
  VersionLo = 1;
  VersionStr = '0.1';

function LoadTextFile(AFileName: string): string;
procedure SaveTextFile(AFIleName, Contents: string);
procedure GetTextRowAndColumn(const Text: string; Pos: Integer; out Row, Col: Integer);
function FloatStr(V: Double): string; inline;

implementation

uses
  Classes, SysUtils;

var
  FS: TFormatSettings;

function LoadTextFile(AFileName: string): string;
var
  FS: TFileStream = nil;
  Code: PChar = nil;
  Len: Cardinal;
begin
  try
    FS:=TFileStream.Create(AFileName, fmOpenRead);
    Len:=FS.Size;
    Code:=GetMem(Len + 1);
    FillChar(Code^, Len + 1, #0);
    FS.ReadBuffer(Code^, Len);
    Result:=Code;
  finally
    if Assigned(FS) then FS.Free;
    if Assigned(Code) then FreeMem(Code);
  end;
end;

procedure SaveTextFile(AFIleName, Contents: string);
var
  FS: TFileStream = nil;
begin
  try
    FS:=TFileStream.Create(AFileName, fmCreate);
    FS.WriteBuffer((@Contents[1])^, Length(Contents));
  finally
    if Assigned(FS) then FS.Free;
  end;
end;

procedure GetTextRowAndColumn(const Text: string; Pos: Integer; out Row, Col: Integer);
var
  I: Integer;
begin
  Row:=1;
  Col:=1;
  I:=1;
  while I < Pos do begin
    if Text[I] in [#10, #13] then begin
      Inc(Row);
      Inc(I);
      if (I <= Pos) and (Text[I]=#10) and (Text[I - 1]=#13) then Inc(I);
      Col:=1;
      Continue;
    end else begin
      Inc(Col);
    end;
    Inc(I);
  end;
end;

// This function sucks, but couldn't find a better
// way to format numbers in a way that makes sense
function FloatStr(V: Double): string; inline;
begin
  if Frac(V)=0.0 then
    Result:=IntToStr(Round(V)) + '.0'
  else begin
    Result:=FloatToStrF(V, ffFixed, 256, 256, FS);
    while (Result <> '') and (Result[Length(Result)]='0') do Result:=Copy(Result, 1, Length(Result) - 1);
    if Result[Length(Result)]='.' then Result:=Result + '0';
  end;
end;

initialization
  FS:=DefaultFormatSettings;
  FS.DecimalSeparator:='.';
end.
