unit RBUTF8;
{$MODE OBJFPC}{$H+}
interface

function UTF8Next(s: string; I: Integer): Integer; inline;
function UTF8Length(s: string): Integer; inline;
function UTF8Copy(s: string; Start, Len: Integer): string; inline;
function UTF8Index(s: string; Index: Integer): Integer; inline;

implementation

function UTF8Next(s: string; I: Integer): Integer; inline;
begin
  Result:=I;
  if Length(s) < Result then begin end
  else if (Ord(s[Result]) and $C0)=$C0 then Inc(Result, 2)
  else if (Ord(s[Result]) and $E0)=$E0 then Inc(Result, 3)
  else if (Ord(s[Result]) and $F0)=$F0 then Inc(Result, 4)
  else if (Ord(s[Result]) and $F8)=$F8 then Inc(Result, 5)
  else if (Ord(s[Result]) and $FC)=$FC then Inc(Result, 6)
  else Inc(Result);
end;

function UTF8Length(s: string): Integer; inline;
var
  I: Integer;
begin
  Result:=0;
  I:=1;
  while I <= Length(s) do begin
    I:=UTF8Next(s, I);
    Inc(Result);
  end;
end;

function UTF8Copy(s: string; Start, Len: Integer): string; inline;
var
  I, NI: Integer;
begin
  Result:='';
  I:=UTF8Index(s, Start);
  if (Len > 0) and (I <= Length(s)) then repeat
    NI:=UTF8Next(s, I);
    if I=NI then Break;
    Result:=Result + Copy(s, I, NI - I);
    I:=NI;
    Dec(Len);
  until (Len=0) or (I > Length(s));
end;

function UTF8Index(s: string; Index: Integer): Integer; inline;
var
  I: Integer;
begin
  Result:=1;
  I:=Index;
  while I > 1 do begin
    Result:=UTF8Next(s, Result);
    Dec(I);
  end;
end;

end.
