unit RBOwn;
{$MODE OBJFPC}{$H+}
interface

type
  TOwnable = class
  private
    FOwner: TOwnable;
    FOwned: array of TOwnable;
    function GetOwnables(AIndex: Integer): TOwnable; inline;
    function GetOwnableCount: Integer; inline;
    procedure Disown(AOwnable: TOwnable);
  public
    constructor Create(AOwner: TOwnable); virtual;
    destructor Destroy; override;
    property Owner: TOwnable read FOwner;
    property Ownables[AIndex: Integer]: TOwnable read GetOwnables;
    property OwnableCount: Integer read GetOwnableCount;
  end;

implementation

{ TOwnable }
function TOwnable.GetOwnables(AIndex: Integer): TOwnable; inline;
begin
  Result:=FOwned[AIndex];
end;

function TOwnable.GetOwnableCount: Integer; inline;
begin
  Result:=Length(FOwned);
end;

procedure TOwnable.Disown(AOwnable: TOwnable);
var
  I, J: Integer;
begin
  for I:=0 to High(FOwned) do
    if FOwned[I]=AOwnable then begin
      for J:=I to High(FOwned)-1 do FOwned[J]:=FOwned[J + 1];
      SetLength(FOwned, Length(FOwned)-1);
      Exit;
    end;
end;

constructor TOwnable.Create(AOwner: TOwnable);
begin
  FOwner:=AOwner;
  if Assigned(Owner) then begin
    SetLength(Owner.FOwned, Length(Owner.FOwned) + 1);
    Owner.FOwned[High(Owner.FOwned)]:=Self;
  end;
end;

destructor TOwnable.Destroy;
begin
  while Length(FOwned) > 0 do FOwned[High(FOwned)].Free;
  if Assigned(Owner) then Owner.Disown(Self);
end;

end.
