unit RBStrDB;
{$MODE OBJFPC}{$H+}
interface
uses
  RBOwn;

type
  TStringDB = class(TOwnable)
  private
    Strings: array of string;
  public
    function StringToID(const AString: string): Integer;
    function IDToString(const ID: Integer): string;
    //procedure Encode(Stream: TStream);
    //procedure Decode(Stream: TStream);
  end;

implementation

{ TStringDB }
function TStringDB.StringToID(const AString: string): Integer;
var
  I: Integer;
begin
  for I:=0 to High(Strings) do if Strings[I]=AString then Exit(I + 1);
  SetLength(Strings, Length(Strings) + 1);
  Strings[High(Strings)]:=AString;
  Result:=High(Strings) + 1;
end;

function TStringDB.IDToString(const ID: Integer): string;
begin
  if (ID=0) or (ID > Length(Strings)) then Exit('');
  Result:=Strings[ID - 1];
end;
{
procedure TStringDB.Encode(Stream: TStream);
var
  I, J: Integer;

  procedure EncInt(I: Cardinal);
  begin
    Stream.WriteByte(I and $FF);
    Stream.WriteByte((I shr 8) and $FF);
    Stream.WriteByte((I shr 16) and $FF);
    Stream.WriteByte((I shr 24) and $FF);
  end;

begin
  Stream.WriteByte(24);
  EncInt(Length(Strings));
  if Length(Strings) > 0 then begin
    for I:=0 to High(Strings) do begin
      EncInt(Length(Strings[I]));
      for J:=1 to Length(Strings[I]) do begin
        Stream.WriteByte(Ord(Strings[I][J]) and $FF);
      end;
    end;
  end;
end;

procedure TStringDB.Decode(Stream: TStream);
var
  I, J, C, L: Integer;

  function DecInt: Cardinal;
  begin
    Result:=Stream.ReadByte;
    Result:=(Stream.ReadByte shl 8) or Result;
    Result:=(Stream.ReadByte shl 16) or Result;
    Result:=(Stream.ReadByte shl 24) or Result;
  end;

begin
  if Stream.ReadByte <> 24 then Exit;
  SetLength(Strings, DecInt);
  if Length(Strings) > 0 then begin
    for I:=0 to High(Strings) do begin
      L:=DecInt;
      Strings[I]:='';
      for J:=1 to L do begin
        C:=Stream.ReadByte;
        Strings[I]:=Strings[I] + Char(C);
      end;
    end;
  end;
end;
}
end.
