unit RBSrc;
{$MODE OBJFPC}{$H+}
interface
uses
  RBOwn;

type

  { TSource }

  TSource = class(TOwnable)
  private
    FSourceCode: string;
    procedure SetSourceCode(const AValue: string);
  public
    procedure LoadFromFile(AFileName: string);
    procedure Analyze;
    procedure GetRowAndColumn(Pos: Integer; out Row, Col: Integer);
    property SourceCode: string read FSourceCode write SetSourceCode;
  end;

implementation

uses
  RBUtil;

{ TSource }
procedure TSource.SetSourceCode(const AValue: string);
begin
  if AValue=FSourceCode then Exit;
  FSourceCode:=AValue;
  Analyze;
end;

procedure TSource.LoadFromFile(AFileName: string);
begin
  SourceCode:=LoadTextFile(AFileName);
end;

procedure TSource.Analyze;
begin
end;

procedure TSource.GetRowAndColumn(Pos: Integer; out Row, Col: Integer);
begin
  GetTextRowAndColumn(SourceCode, Pos, Row, Col);
end;

end.
