unit RBFmt;
{$MODE OBJFPC}{$H+}
interface

uses
  SysUtils, RBOwn, RBScan, RBProg, RBNative;

type
  TFormatter = class(TOwnable)
  private
    FProg: TProgram;

  public
    function FormatLine(ALine: string): string;
    property Prog: TProgram read FProg write FProg;
  end;

implementation

{ TFormatter }
function TFormatter.FormatLine(ALine: string): string;
var
  Scanner: TScanner;

  procedure AddInitialSpaces;
  begin
    while Scanner.HasMore and (Scanner.NextChar in [#9, #32]) do begin
      Result:=Result + Scanner.NextChar;
      Scanner.Skip;
    end;
  end;

  function FormatIdentifier(const Token: TToken): string;
  var
    Native: TNativeMethodInfo;
  begin
    if Prog.NativeInterface.Find(Token.StrValue, Native) then
      Result:=Native.FmtName
    else if Token.StrValue='PRINT' then
      Result:='Print'
    else
      Result:=Token.Original;
  end;

  procedure FormatTheLine;
  var
    TT: TTokenType;
    NoSpace: Boolean = True;
    Last: TToken;
  begin
    Result:='';
    AddInitialSpaces;
    Last.TokenType:=ttInvalid;
    while Scanner.Scan and not (Scanner.Token.TokenType in [ttInvalid, ttEndOfLine]) do begin
      TT:=Scanner.Token.TokenType;
      if not NoSpace then begin
        if not (TT in [ttComma, ttSemicolon, ttLeftParen, ttRightParen]) then Result:=Result + ' ';
        if (TT=ttLeftParen) and (ALine[Scanner.Token.Position - 1] in [#9, #32]) then Result:=Result + ' ';
      end;
      NoSpace:=False;
      if TT=ttLeftParen then NoSpace:=True else
      if (TT=ttMinus) and (Scanner.Peek.TokenType in [ttInteger, ttReal]) and not (Last.TokenType in [ttInteger, ttReal, ttIdentifier, ttEqual]) then NoSpace:=True;
      if TT=ttIdentifier then
        Result:=Result + FormatIdentifier(Scanner.Token)
      else
        Result:=Result + Scanner.Token.ToString;
      Last:=Scanner.Token;
    end;
  end;

begin
  try
    Result:='';
    Scanner:=TScanner.Create(Self);
    Scanner.Code:=ALine;
    FormatTheLine;
  except
    Result:=ALine;
  end;
  FreeAndNil(Scanner);
end;

end.
