" Vim syntax file
" Language:     LazHelp
" Maintainer:   Kostas Michalopoulos <badsector@runtimelegend.com>
" Last Change:  2012/01/08
" Version:      1.0
" URL:          https://github.com/badsector/lazhelp
"
if version < 600
  syntax clear
elseif exists("b:current_syntax")
  finish
endif

" Special characters
syn match lazhelpSpecial "[{}[\]]"

" Escapes
syn match lazhelpEscape "/."

" Normal nodes
syn region lazhelpNodeValue start="\[" end="\]" keepend contained
syn region lazhelpNode start="\\\([#@{]\)\@!" end="{"me=e-1 contains=lazhelpNodeValue

" Define the default highlighting
if version >= 508 || !exists("did_lazhelp_syntax_inits")
  if version < 508
    let did_lazhelp_syntax_inits = 1
	command -nargs=+ LazhelpHiLink hi link <args>
  else
    command -nargs=+ LazhelpHiLink hi def link <args>
  endif

  LazhelpHiLink lazhelpNodeValue	String
  LazhelpHiLink lazhelpNode		Identifier
  LazhelpHiLink lazhelpSpecial		Special
  LazhelpHiLink lazhelpEscape		String

  delcommand LazhelpHiLink
endif

let b:current_syntax = "lazhelp"

" vim: ts=8 noet

