////////////////////////////////////////////////////////////////////////////////
// Delphi 2 compatible OpenGL 4.6 unit                              ..---.    //
// Based on a unit for Free Pascal enerated by gl2unit             (( OpenGL  //
// at 8/16/2017 and edited by hand to be Delphi 2 compatible        ``---'    //
//                                                                            //
// Copyright (C) 2018 Kostas Michalopoulos                                    //
//                                                                            //
// This software is provided 'as-is', without any express or implied          //
// warranty. In no event will the authors be held liable for any damages      //
// arising from the use of this software.                                     //
//                                                                            //
// Permission is granted to anyone to use this software for any purpose,      //
// including commercial applications, and to alter it and redistribute it     //
// freely, subject to the following restrictions:                             //
//                                                                            //
// 1. The origin of this software must not be misrepresented; you must not    //
//    claim that you wrote the original software. If you use this software    //
//    in a product, an acknowledgment in the product documentation would be   //
//    appreciated but is not required.                                        //
// 2. Altered source versions must be plainly marked as such, and must not be //
//    misrepresented as being the original software.                          //
// 3. This notice may not be removed or altered from any source distribution. //
////////////////////////////////////////////////////////////////////////////////
unit OpenGL;
interface
uses
  Classes;

type
  // Some generated types
  Pvoid = Pointer;
  PPvoid = ^Pointer;
  // OpenGL types
  GLenum = Cardinal;
  TGLenum = GLenum;
  PGLenum = ^GLenum;
  PPGLenum = ^PGLenum;
  GLboolean = Byte;
  TGLboolean = GLboolean;
  PGLboolean = ^GLboolean;
  PPGLboolean = ^PGLboolean;
  GLbitfield = Cardinal;
  TGLbitfield = GLbitfield;
  PGLbitfield = ^GLbitfield;
  PPGLbitfield = ^PGLbitfield;
  GLbyte = ShortInt;
  TGLbyte = GLbyte;
  PGLbyte = ^GLbyte;
  PPGLbyte = ^PGLbyte;
  GLshort = SmallInt;
  TGLshort = GLshort;
  PGLshort = ^GLshort;
  PPGLshort = ^PGLshort;
  GLint = LongInt;
  TGLint = GLint;
  PGLint = ^GLint;
  PPGLint = ^PGLint;
  GLclampx = LongInt;
  TGLclampx = GLclampx;
  PGLclampx = ^GLclampx;
  PPGLclampx = ^PGLclampx;
  GLubyte = Byte;
  TGLubyte = GLubyte;
  PGLubyte = ^GLubyte;
  PPGLubyte = ^PGLubyte;
  GLushort = Word;
  TGLushort = GLushort;
  PGLushort = ^GLushort;
  PPGLushort = ^PGLushort;
  GLuint = Cardinal;
  TGLuint = GLuint;
  PGLuint = ^GLuint;
  PPGLuint = ^PGLuint;
  GLsizei = LongInt;
  TGLsizei = GLsizei;
  PGLsizei = ^GLsizei;
  PPGLsizei = ^PGLsizei;
  GLfloat = Single;
  TGLfloat = GLfloat;
  PGLfloat = ^GLfloat;
  PPGLfloat = ^PGLfloat;
  GLclampf = Single;
  TGLclampf = GLclampf;
  PGLclampf = ^GLclampf;
  PPGLclampf = ^PGLclampf;
  GLdouble = Double;
  TGLdouble = GLdouble;
  PGLdouble = ^GLdouble;
  PPGLdouble = ^PGLdouble;
  GLclampd = Double;
  TGLclampd = GLclampd;
  PGLclampd = ^GLclampd;
  PPGLclampd = ^PGLclampd;
  GLeglClientBufferEXT = Pointer;
  TGLeglClientBufferEXT = GLeglClientBufferEXT;
  PGLeglClientBufferEXT = ^GLeglClientBufferEXT;
  PPGLeglClientBufferEXT = ^PGLeglClientBufferEXT;
  GLeglImageOES = Pointer;
  TGLeglImageOES = GLeglImageOES;
  PGLeglImageOES = ^GLeglImageOES;
  PPGLeglImageOES = ^PGLeglImageOES;
  GLchar = AnsiChar;
  TGLchar = GLchar;
  PGLchar = ^GLchar;
  PPGLchar = ^PGLchar;
  GLcharARB = AnsiChar;
  TGLcharARB = GLcharARB;
  PGLcharARB = ^GLcharARB;
  PPGLcharARB = ^PGLcharARB;
{$IFDEF darwin}
  GLhandleARB = Pointer;
  TGLhandleARB = GLhandleARB;
  PGLhandleARB = ^GLhandleARB;
  PPGLhandleARB = ^PGLhandleARB;
{$ELSE}
  GLhandleARB = Cardinal;
  TGLhandleARB = GLhandleARB;
  PGLhandleARB = ^GLhandleARB;
  PPGLhandleARB = ^PGLhandleARB;
{$ENDIF}
  GLhalfARB = Word;
  TGLhalfARB = GLhalfARB;
  PGLhalfARB = ^GLhalfARB;
  PPGLhalfARB = ^PGLhalfARB;
  GLhalf = Word;
  TGLhalf = GLhalf;
  PGLhalf = ^GLhalf;
  PPGLhalf = ^PGLhalf;
  GLfixed = LongInt;
  TGLfixed = GLfixed;
  PGLfixed = ^GLfixed;
  PPGLfixed = ^PGLfixed;
  GLintptr = Integer;
  TGLintptr = GLintptr;
  PGLintptr = ^GLintptr;
  PPGLintptr = ^PGLintptr;
  GLsizeiptr = Integer;
  TGLsizeiptr = GLsizeiptr;
  PGLsizeiptr = ^GLsizeiptr;
  PPGLsizeiptr = ^PGLsizeiptr;
  GLint64 = packed record
    LowPart, HighPart: Integer;
  end;
  TGLint64 = GLint64;
  PGLint64 = ^GLint64;
  PPGLint64 = ^PGLint64;
  GLuint64 = packed record
    LowPart, HighPart: Cardinal;
  end;
  TGLuint64 = GLuint64;
  PGLuint64 = ^GLuint64;
  PPGLuint64 = ^PGLuint64;
  GLintptrARB = Integer;
  TGLintptrARB = GLintptrARB;
  PGLintptrARB = ^GLintptrARB;
  PPGLintptrARB = ^PGLintptrARB;
  GLsizeiptrARB = Integer;
  TGLsizeiptrARB = GLsizeiptrARB;
  PGLsizeiptrARB = ^GLsizeiptrARB;
  PPGLsizeiptrARB = ^PGLsizeiptrARB;
  GLint64EXT = GLint64;
  TGLint64EXT = GLint64EXT;
  PGLint64EXT = ^GLint64EXT;
  PPGLint64EXT = ^PGLint64EXT;
  GLuint64EXT = GLuint64;
  TGLuint64EXT = GLuint64EXT;
  PGLuint64EXT = ^GLuint64EXT;
  PPGLuint64EXT = ^PGLuint64EXT;
  GLsync = Pointer;
  TGLsync = GLsync;
  PGLsync = ^GLsync;
  PPGLsync = ^PGLsync;
  Pstruct_cl_context = Pointer;
  Pstruct_cl_event = Pointer;
  PGLvoid = Pointer;
  PPGLvoid = ^PGLVoid;
  GLDEBUGPROC = procedure(source: GLenum; type_: GLenum; id: GLuint; severity: GLenum; length: GLsizei; message_: PGLchar; userParam: Pointer); stdcall;
  GLDEBUGPROCARB = procedure(source: GLenum; type_: GLenum; id: GLuint; severity: GLenum; length: GLsizei; message_: PGLchar; userParam: Pointer); stdcall;
  GLDEBUGPROCKHR = procedure(source: GLenum; type_: GLenum; id: GLuint; severity: GLenum; length: GLsizei; message_: PGLchar; userParam: Pointer); stdcall;
  TGLDEBUGPROC = GLDEBUGPROC;
  PGLDEBUGPROC = ^GLDEBUGPROC;
  PPGLDEBUGPROC = ^PGLDEBUGPROC;
  TGLDEBUGPROCARB = GLDEBUGPROCARB;
  PGLDEBUGPROCARB = ^GLDEBUGPROCARB;
  PPGLDEBUGPROCARB = ^PGLDEBUGPROCARB;
  TGLDEBUGPROCKHR = GLDEBUGPROCKHR;
  PGLDEBUGPROCKHR = ^GLDEBUGPROCKHR;
  PPGLDEBUGPROCKHR = ^PGLDEBUGPROCKHR;
  GLDEBUGPROCAMD = procedure(id: GLuint; category: GLenum; severity: GLenum; length: GLsizei; message_: PGLchar; userParam: Pointer); stdcall;
  TGLDEBUGPROCAMD = GLDEBUGPROCAMD;
  PGLDEBUGPROCAMD = ^GLDEBUGPROCAMD;
  PPGLDEBUGPROCAMD = ^PGLDEBUGPROCAMD;
  GLhalfNV = Word;
  TGLhalfNV = GLhalfNV;
  PGLhalfNV = ^GLhalfNV;
  PPGLhalfNV = ^PGLhalfNV;
  GLvdpauSurfaceNV = GLintptr;
  TGLvdpauSurfaceNV = GLvdpauSurfaceNV;
  PGLvdpauSurfaceNV = ^GLvdpauSurfaceNV;
  PPGLvdpauSurfaceNV = ^PGLvdpauSurfaceNV;
  GLVULKANPROCNV = procedure; stdcall;
  TGLVULKANPROCNV = GLVULKANPROCNV;
  PGLVULKANPROCNV = ^GLVULKANPROCNV;
  PPGLVULKANPROCNV = ^PGLVULKANPROCNV;
const
  // OpenGL constants
  GL_CURRENT_BIT = $00000001;
  GL_POINT_BIT = $00000002;
  GL_LINE_BIT = $00000004;
  GL_POLYGON_BIT = $00000008;
  GL_POLYGON_STIPPLE_BIT = $00000010;
  GL_PIXEL_MODE_BIT = $00000020;
  GL_LIGHTING_BIT = $00000040;
  GL_FOG_BIT = $00000080;
  GL_DEPTH_BUFFER_BIT = $00000100;
  GL_ACCUM_BUFFER_BIT = $00000200;
  GL_STENCIL_BUFFER_BIT = $00000400;
  GL_VIEWPORT_BIT = $00000800;
  GL_TRANSFORM_BIT = $00001000;
  GL_ENABLE_BIT = $00002000;
  GL_COLOR_BUFFER_BIT = $00004000;
  GL_HINT_BIT = $00008000;
  GL_EVAL_BIT = $00010000;
  GL_LIST_BIT = $00020000;
  GL_TEXTURE_BIT = $00040000;
  GL_SCISSOR_BIT = $00080000;
  GL_MULTISAMPLE_BIT = $20000000;
  GL_MULTISAMPLE_BIT_ARB = $20000000;
  GL_MULTISAMPLE_BIT_EXT = $20000000;
  GL_MULTISAMPLE_BIT_3DFX = $20000000;
  GL_ALL_ATTRIB_BITS = $FFFFFFFF;
  GL_COVERAGE_BUFFER_BIT_NV = $00008000;
  GL_CLIENT_PIXEL_STORE_BIT = $00000001;
  GL_CLIENT_VERTEX_ARRAY_BIT = $00000002;
  GL_CLIENT_ALL_ATTRIB_BITS = $FFFFFFFF;
  GL_CONTEXT_FLAG_FORWARD_COMPATIBLE_BIT = $00000001;
  GL_CONTEXT_FLAG_DEBUG_BIT = $00000002;
  GL_CONTEXT_FLAG_DEBUG_BIT_KHR = $00000002;
  GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT = $00000004;
  GL_CONTEXT_FLAG_ROBUST_ACCESS_BIT_ARB = $00000004;
  GL_CONTEXT_FLAG_NO_ERROR_BIT = $00000008;
  GL_CONTEXT_FLAG_NO_ERROR_BIT_KHR = $00000008;
  GL_CONTEXT_FLAG_PROTECTED_CONTENT_BIT_EXT = $00000010;
  GL_CONTEXT_CORE_PROFILE_BIT = $00000001;
  GL_CONTEXT_COMPATIBILITY_PROFILE_BIT = $00000002;
  GL_MAP_READ_BIT = $0001;
  GL_MAP_READ_BIT_EXT = $0001;
  GL_MAP_WRITE_BIT = $0002;
  GL_MAP_WRITE_BIT_EXT = $0002;
  GL_MAP_INVALIDATE_RANGE_BIT = $0004;
  GL_MAP_INVALIDATE_RANGE_BIT_EXT = $0004;
  GL_MAP_INVALIDATE_BUFFER_BIT = $0008;
  GL_MAP_INVALIDATE_BUFFER_BIT_EXT = $0008;
  GL_MAP_FLUSH_EXPLICIT_BIT = $0010;
  GL_MAP_FLUSH_EXPLICIT_BIT_EXT = $0010;
  GL_MAP_UNSYNCHRONIZED_BIT = $0020;
  GL_MAP_UNSYNCHRONIZED_BIT_EXT = $0020;
  GL_MAP_PERSISTENT_BIT = $0040;
  GL_MAP_PERSISTENT_BIT_EXT = $0040;
  GL_MAP_COHERENT_BIT = $0080;
  GL_MAP_COHERENT_BIT_EXT = $0080;
  GL_DYNAMIC_STORAGE_BIT = $0100;
  GL_DYNAMIC_STORAGE_BIT_EXT = $0100;
  GL_CLIENT_STORAGE_BIT = $0200;
  GL_CLIENT_STORAGE_BIT_EXT = $0200;
  GL_SPARSE_STORAGE_BIT_ARB = $0400;
  GL_LGPU_SEPARATE_STORAGE_BIT_NVX = $0800;
  GL_PER_GPU_STORAGE_BIT_NV = $0800;
  GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT = $00000001;
  GL_VERTEX_ATTRIB_ARRAY_BARRIER_BIT_EXT = $00000001;
  GL_ELEMENT_ARRAY_BARRIER_BIT = $00000002;
  GL_ELEMENT_ARRAY_BARRIER_BIT_EXT = $00000002;
  GL_UNIFORM_BARRIER_BIT = $00000004;
  GL_UNIFORM_BARRIER_BIT_EXT = $00000004;
  GL_TEXTURE_FETCH_BARRIER_BIT = $00000008;
  GL_TEXTURE_FETCH_BARRIER_BIT_EXT = $00000008;
  GL_SHADER_GLOBAL_ACCESS_BARRIER_BIT_NV = $00000010;
  GL_SHADER_IMAGE_ACCESS_BARRIER_BIT = $00000020;
  GL_SHADER_IMAGE_ACCESS_BARRIER_BIT_EXT = $00000020;
  GL_COMMAND_BARRIER_BIT = $00000040;
  GL_COMMAND_BARRIER_BIT_EXT = $00000040;
  GL_PIXEL_BUFFER_BARRIER_BIT = $00000080;
  GL_PIXEL_BUFFER_BARRIER_BIT_EXT = $00000080;
  GL_TEXTURE_UPDATE_BARRIER_BIT = $00000100;
  GL_TEXTURE_UPDATE_BARRIER_BIT_EXT = $00000100;
  GL_BUFFER_UPDATE_BARRIER_BIT = $00000200;
  GL_BUFFER_UPDATE_BARRIER_BIT_EXT = $00000200;
  GL_FRAMEBUFFER_BARRIER_BIT = $00000400;
  GL_FRAMEBUFFER_BARRIER_BIT_EXT = $00000400;
  GL_TRANSFORM_FEEDBACK_BARRIER_BIT = $00000800;
  GL_TRANSFORM_FEEDBACK_BARRIER_BIT_EXT = $00000800;
  GL_ATOMIC_COUNTER_BARRIER_BIT = $00001000;
  GL_ATOMIC_COUNTER_BARRIER_BIT_EXT = $00001000;
  GL_SHADER_STORAGE_BARRIER_BIT = $00002000;
  GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT = $00004000;
  GL_CLIENT_MAPPED_BUFFER_BARRIER_BIT_EXT = $00004000;
  GL_QUERY_BUFFER_BARRIER_BIT = $00008000;
  GL_ALL_BARRIER_BITS = $FFFFFFFF;
  GL_ALL_BARRIER_BITS_EXT = $FFFFFFFF;
  GL_QUERY_DEPTH_PASS_EVENT_BIT_AMD = $00000001;
  GL_QUERY_DEPTH_FAIL_EVENT_BIT_AMD = $00000002;
  GL_QUERY_STENCIL_FAIL_EVENT_BIT_AMD = $00000004;
  GL_QUERY_DEPTH_BOUNDS_FAIL_EVENT_BIT_AMD = $00000008;
  GL_QUERY_ALL_EVENT_BITS_AMD = $FFFFFFFF;
  GL_SYNC_FLUSH_COMMANDS_BIT = $00000001;
  GL_SYNC_FLUSH_COMMANDS_BIT_APPLE = $00000001;
  GL_VERTEX_SHADER_BIT = $00000001;
  GL_VERTEX_SHADER_BIT_EXT = $00000001;
  GL_FRAGMENT_SHADER_BIT = $00000002;
  GL_FRAGMENT_SHADER_BIT_EXT = $00000002;
  GL_GEOMETRY_SHADER_BIT = $00000004;
  GL_GEOMETRY_SHADER_BIT_EXT = $00000004;
  GL_GEOMETRY_SHADER_BIT_OES = $00000004;
  GL_TESS_CONTROL_SHADER_BIT = $00000008;
  GL_TESS_CONTROL_SHADER_BIT_EXT = $00000008;
  GL_TESS_CONTROL_SHADER_BIT_OES = $00000008;
  GL_TESS_EVALUATION_SHADER_BIT = $00000010;
  GL_TESS_EVALUATION_SHADER_BIT_EXT = $00000010;
  GL_TESS_EVALUATION_SHADER_BIT_OES = $00000010;
  GL_COMPUTE_SHADER_BIT = $00000020;
  GL_ALL_SHADER_BITS = $FFFFFFFF;
  GL_ALL_SHADER_BITS_EXT = $FFFFFFFF;
  GL_TEXTURE_STORAGE_SPARSE_BIT_AMD = $00000001;
  GL_RED_BIT_ATI = $00000001;
  GL_GREEN_BIT_ATI = $00000002;
  GL_BLUE_BIT_ATI = $00000004;
  GL_2X_BIT_ATI = $00000001;
  GL_4X_BIT_ATI = $00000002;
  GL_8X_BIT_ATI = $00000004;
  GL_HALF_BIT_ATI = $00000008;
  GL_QUARTER_BIT_ATI = $00000010;
  GL_EIGHTH_BIT_ATI = $00000020;
  GL_SATURATE_BIT_ATI = $00000040;
  GL_COMP_BIT_ATI = $00000002;
  GL_NEGATE_BIT_ATI = $00000004;
  GL_BIAS_BIT_ATI = $00000008;
  GL_TRACE_OPERATIONS_BIT_MESA = $0001;
  GL_TRACE_PRIMITIVES_BIT_MESA = $0002;
  GL_TRACE_ARRAYS_BIT_MESA = $0004;
  GL_TRACE_TEXTURES_BIT_MESA = $0008;
  GL_TRACE_PIXELS_BIT_MESA = $0010;
  GL_TRACE_ERRORS_BIT_MESA = $0020;
  GL_TRACE_ALL_BITS_MESA = $FFFF;
  GL_BOLD_BIT_NV = $01;
  GL_ITALIC_BIT_NV = $02;
  GL_GLYPH_WIDTH_BIT_NV = $01;
  GL_GLYPH_HEIGHT_BIT_NV = $02;
  GL_GLYPH_HORIZONTAL_BEARING_X_BIT_NV = $04;
  GL_GLYPH_HORIZONTAL_BEARING_Y_BIT_NV = $08;
  GL_GLYPH_HORIZONTAL_BEARING_ADVANCE_BIT_NV = $10;
  GL_GLYPH_VERTICAL_BEARING_X_BIT_NV = $20;
  GL_GLYPH_VERTICAL_BEARING_Y_BIT_NV = $40;
  GL_GLYPH_VERTICAL_BEARING_ADVANCE_BIT_NV = $80;
  GL_GLYPH_HAS_KERNING_BIT_NV = $100;
  GL_FONT_X_MIN_BOUNDS_BIT_NV = $00010000;
  GL_FONT_Y_MIN_BOUNDS_BIT_NV = $00020000;
  GL_FONT_X_MAX_BOUNDS_BIT_NV = $00040000;
  GL_FONT_Y_MAX_BOUNDS_BIT_NV = $00080000;
  GL_FONT_UNITS_PER_EM_BIT_NV = $00100000;
  GL_FONT_ASCENDER_BIT_NV = $00200000;
  GL_FONT_DESCENDER_BIT_NV = $00400000;
  GL_FONT_HEIGHT_BIT_NV = $00800000;
  GL_FONT_MAX_ADVANCE_WIDTH_BIT_NV = $01000000;
  GL_FONT_MAX_ADVANCE_HEIGHT_BIT_NV = $02000000;
  GL_FONT_UNDERLINE_POSITION_BIT_NV = $04000000;
  GL_FONT_UNDERLINE_THICKNESS_BIT_NV = $08000000;
  GL_FONT_HAS_KERNING_BIT_NV = $10000000;
  GL_FONT_NUM_GLYPH_INDICES_BIT_NV = $20000000;
  GL_PERFQUERY_SINGLE_CONTEXT_INTEL = $00000000;
  GL_PERFQUERY_GLOBAL_CONTEXT_INTEL = $00000001;
  GL_VERTEX23_BIT_PGI = $00000004;
  GL_VERTEX4_BIT_PGI = $00000008;
  GL_COLOR3_BIT_PGI = $00010000;
  GL_COLOR4_BIT_PGI = $00020000;
  GL_EDGEFLAG_BIT_PGI = $00040000;
  GL_INDEX_BIT_PGI = $00080000;
  GL_MAT_AMBIENT_BIT_PGI = $00100000;
  GL_MAT_AMBIENT_AND_DIFFUSE_BIT_PGI = $00200000;
  GL_MAT_DIFFUSE_BIT_PGI = $00400000;
  GL_MAT_EMISSION_BIT_PGI = $00800000;
  GL_MAT_COLOR_INDEXES_BIT_PGI = $01000000;
  GL_MAT_SHININESS_BIT_PGI = $02000000;
  GL_MAT_SPECULAR_BIT_PGI = $04000000;
  GL_NORMAL_BIT_PGI = $08000000;
  GL_TEXCOORD1_BIT_PGI = $10000000;
  GL_TEXCOORD2_BIT_PGI = $20000000;
  GL_TEXCOORD3_BIT_PGI = $40000000;
  GL_TEXCOORD4_BIT_PGI = $80000000;
  GL_COLOR_BUFFER_BIT0_QCOM = $00000001;
  GL_COLOR_BUFFER_BIT1_QCOM = $00000002;
  GL_COLOR_BUFFER_BIT2_QCOM = $00000004;
  GL_COLOR_BUFFER_BIT3_QCOM = $00000008;
  GL_COLOR_BUFFER_BIT4_QCOM = $00000010;
  GL_COLOR_BUFFER_BIT5_QCOM = $00000020;
  GL_COLOR_BUFFER_BIT6_QCOM = $00000040;
  GL_COLOR_BUFFER_BIT7_QCOM = $00000080;
  GL_DEPTH_BUFFER_BIT0_QCOM = $00000100;
  GL_DEPTH_BUFFER_BIT1_QCOM = $00000200;
  GL_DEPTH_BUFFER_BIT2_QCOM = $00000400;
  GL_DEPTH_BUFFER_BIT3_QCOM = $00000800;
  GL_DEPTH_BUFFER_BIT4_QCOM = $00001000;
  GL_DEPTH_BUFFER_BIT5_QCOM = $00002000;
  GL_DEPTH_BUFFER_BIT6_QCOM = $00004000;
  GL_DEPTH_BUFFER_BIT7_QCOM = $00008000;
  GL_STENCIL_BUFFER_BIT0_QCOM = $00010000;
  GL_STENCIL_BUFFER_BIT1_QCOM = $00020000;
  GL_STENCIL_BUFFER_BIT2_QCOM = $00040000;
  GL_STENCIL_BUFFER_BIT3_QCOM = $00080000;
  GL_STENCIL_BUFFER_BIT4_QCOM = $00100000;
  GL_STENCIL_BUFFER_BIT5_QCOM = $00200000;
  GL_STENCIL_BUFFER_BIT6_QCOM = $00400000;
  GL_STENCIL_BUFFER_BIT7_QCOM = $00800000;
  GL_MULTISAMPLE_BUFFER_BIT0_QCOM = $01000000;
  GL_MULTISAMPLE_BUFFER_BIT1_QCOM = $02000000;
  GL_MULTISAMPLE_BUFFER_BIT2_QCOM = $04000000;
  GL_MULTISAMPLE_BUFFER_BIT3_QCOM = $08000000;
  GL_MULTISAMPLE_BUFFER_BIT4_QCOM = $10000000;
  GL_MULTISAMPLE_BUFFER_BIT5_QCOM = $20000000;
  GL_MULTISAMPLE_BUFFER_BIT6_QCOM = $40000000;
  GL_MULTISAMPLE_BUFFER_BIT7_QCOM = $80000000;
  GL_FOVEATION_ENABLE_BIT_QCOM = $00000001;
  GL_FOVEATION_SCALED_BIN_METHOD_BIT_QCOM = $00000002;
  GL_TEXTURE_DEFORMATION_BIT_SGIX = $00000001;
  GL_GEOMETRY_DEFORMATION_BIT_SGIX = $00000002;
  GL_TERMINATE_SEQUENCE_COMMAND_NV = $0000;
  GL_NOP_COMMAND_NV = $0001;
  GL_DRAW_ELEMENTS_COMMAND_NV = $0002;
  GL_DRAW_ARRAYS_COMMAND_NV = $0003;
  GL_DRAW_ELEMENTS_STRIP_COMMAND_NV = $0004;
  GL_DRAW_ARRAYS_STRIP_COMMAND_NV = $0005;
  GL_DRAW_ELEMENTS_INSTANCED_COMMAND_NV = $0006;
  GL_DRAW_ARRAYS_INSTANCED_COMMAND_NV = $0007;
  GL_ELEMENT_ADDRESS_COMMAND_NV = $0008;
  GL_ATTRIBUTE_ADDRESS_COMMAND_NV = $0009;
  GL_UNIFORM_ADDRESS_COMMAND_NV = $000A;
  GL_BLEND_COLOR_COMMAND_NV = $000B;
  GL_STENCIL_REF_COMMAND_NV = $000C;
  GL_LINE_WIDTH_COMMAND_NV = $000D;
  GL_POLYGON_OFFSET_COMMAND_NV = $000E;
  GL_ALPHA_REF_COMMAND_NV = $000F;
  GL_VIEWPORT_COMMAND_NV = $0010;
  GL_SCISSOR_COMMAND_NV = $0011;
  GL_FRONT_FACE_COMMAND_NV = $0012;
  GL_LAYOUT_DEFAULT_INTEL = 0;
  GL_LAYOUT_LINEAR_INTEL = 1;
  GL_LAYOUT_LINEAR_CPU_CACHED_INTEL = 2;
  GL_CLOSE_PATH_NV = $00;
  GL_MOVE_TO_NV = $02;
  GL_RELATIVE_MOVE_TO_NV = $03;
  GL_LINE_TO_NV = $04;
  GL_RELATIVE_LINE_TO_NV = $05;
  GL_HORIZONTAL_LINE_TO_NV = $06;
  GL_RELATIVE_HORIZONTAL_LINE_TO_NV = $07;
  GL_VERTICAL_LINE_TO_NV = $08;
  GL_RELATIVE_VERTICAL_LINE_TO_NV = $09;
  GL_QUADRATIC_CURVE_TO_NV = $0A;
  GL_RELATIVE_QUADRATIC_CURVE_TO_NV = $0B;
  GL_CUBIC_CURVE_TO_NV = $0C;
  GL_RELATIVE_CUBIC_CURVE_TO_NV = $0D;
  GL_SMOOTH_QUADRATIC_CURVE_TO_NV = $0E;
  GL_RELATIVE_SMOOTH_QUADRATIC_CURVE_TO_NV = $0F;
  GL_SMOOTH_CUBIC_CURVE_TO_NV = $10;
  GL_RELATIVE_SMOOTH_CUBIC_CURVE_TO_NV = $11;
  GL_SMALL_CCW_ARC_TO_NV = $12;
  GL_RELATIVE_SMALL_CCW_ARC_TO_NV = $13;
  GL_SMALL_CW_ARC_TO_NV = $14;
  GL_RELATIVE_SMALL_CW_ARC_TO_NV = $15;
  GL_LARGE_CCW_ARC_TO_NV = $16;
  GL_RELATIVE_LARGE_CCW_ARC_TO_NV = $17;
  GL_LARGE_CW_ARC_TO_NV = $18;
  GL_RELATIVE_LARGE_CW_ARC_TO_NV = $19;
  GL_CONIC_CURVE_TO_NV = $1A;
  GL_RELATIVE_CONIC_CURVE_TO_NV = $1B;
  GL_SHARED_EDGE_NV = $C0;
  GL_ROUNDED_RECT_NV = $E8;
  GL_RELATIVE_ROUNDED_RECT_NV = $E9;
  GL_ROUNDED_RECT2_NV = $EA;
  GL_RELATIVE_ROUNDED_RECT2_NV = $EB;
  GL_ROUNDED_RECT4_NV = $EC;
  GL_RELATIVE_ROUNDED_RECT4_NV = $ED;
  GL_ROUNDED_RECT8_NV = $EE;
  GL_RELATIVE_ROUNDED_RECT8_NV = $EF;
  GL_RESTART_PATH_NV = $F0;
  GL_DUP_FIRST_CUBIC_CURVE_TO_NV = $F2;
  GL_DUP_LAST_CUBIC_CURVE_TO_NV = $F4;
  GL_RECT_NV = $F6;
  GL_RELATIVE_RECT_NV = $F7;
  GL_CIRCULAR_CCW_ARC_TO_NV = $F8;
  GL_CIRCULAR_CW_ARC_TO_NV = $FA;
  GL_CIRCULAR_TANGENT_ARC_TO_NV = $FC;
  GL_ARC_TO_NV = $FE;
  GL_RELATIVE_ARC_TO_NV = $FF;
  GL_NEXT_BUFFER_NV = -2;
  GL_SKIP_COMPONENTS4_NV = -3;
  GL_SKIP_COMPONENTS3_NV = -4;
  GL_SKIP_COMPONENTS2_NV = -5;
  GL_SKIP_COMPONENTS1_NV = -6;
  GL_RESTART_SUN = $0001;
  GL_REPLACE_MIDDLE_SUN = $0002;
  GL_REPLACE_OLDEST_SUN = $0003;
  GL_FALSE = 0;
  GL_NO_ERROR = 0;
  GL_ZERO = 0;
  GL_NONE = 0;
  GL_NONE_OES = 0;
  GL_TRUE = 1;
  GL_ONE = 1;
  GL_INVALID_INDEX = $FFFFFFFF;
  GL_ALL_PIXELS_AMD = $FFFFFFFF;
  //GL_TIMEOUT_IGNORED = $FFFFFFFFFFFFFFFF;
  //GL_TIMEOUT_IGNORED_APPLE = $FFFFFFFFFFFFFFFF;
  GL_VERSION_ES_CL_1_0 = 1;
  GL_VERSION_ES_CM_1_1 = 1;
  GL_VERSION_ES_CL_1_1 = 1;
  GL_UUID_SIZE_EXT = 16;
  GL_LUID_SIZE_EXT = 8;
  GL_POINTS = $0000;
  GL_LINES = $0001;
  GL_LINE_LOOP = $0002;
  GL_LINE_STRIP = $0003;
  GL_TRIANGLES = $0004;
  GL_TRIANGLE_STRIP = $0005;
  GL_TRIANGLE_FAN = $0006;
  GL_QUADS = $0007;
  GL_QUADS_EXT = $0007;
  GL_QUADS_OES = $0007;
  GL_QUAD_STRIP = $0008;
  GL_POLYGON = $0009;
  GL_LINES_ADJACENCY = $000A;
  GL_LINES_ADJACENCY_ARB = $000A;
  GL_LINES_ADJACENCY_EXT = $000A;
  GL_LINES_ADJACENCY_OES = $000A;
  GL_LINE_STRIP_ADJACENCY = $000B;
  GL_LINE_STRIP_ADJACENCY_ARB = $000B;
  GL_LINE_STRIP_ADJACENCY_EXT = $000B;
  GL_LINE_STRIP_ADJACENCY_OES = $000B;
  GL_TRIANGLES_ADJACENCY = $000C;
  GL_TRIANGLES_ADJACENCY_ARB = $000C;
  GL_TRIANGLES_ADJACENCY_EXT = $000C;
  GL_TRIANGLES_ADJACENCY_OES = $000C;
  GL_TRIANGLE_STRIP_ADJACENCY = $000D;
  GL_TRIANGLE_STRIP_ADJACENCY_ARB = $000D;
  GL_TRIANGLE_STRIP_ADJACENCY_EXT = $000D;
  GL_TRIANGLE_STRIP_ADJACENCY_OES = $000D;
  GL_PATCHES = $000E;
  GL_PATCHES_EXT = $000E;
  GL_PATCHES_OES = $000E;
  GL_ACCUM = $0100;
  GL_LOAD = $0101;
  GL_RETURN = $0102;
  GL_MULT = $0103;
  GL_ADD = $0104;
  GL_NEVER = $0200;
  GL_LESS = $0201;
  GL_EQUAL = $0202;
  GL_LEQUAL = $0203;
  GL_GREATER = $0204;
  GL_NOTEQUAL = $0205;
  GL_GEQUAL = $0206;
  GL_ALWAYS = $0207;
  GL_SRC_COLOR = $0300;
  GL_ONE_MINUS_SRC_COLOR = $0301;
  GL_SRC_ALPHA = $0302;
  GL_ONE_MINUS_SRC_ALPHA = $0303;
  GL_DST_ALPHA = $0304;
  GL_ONE_MINUS_DST_ALPHA = $0305;
  GL_DST_COLOR = $0306;
  GL_ONE_MINUS_DST_COLOR = $0307;
  GL_SRC_ALPHA_SATURATE = $0308;
  GL_SRC_ALPHA_SATURATE_EXT = $0308;
  GL_FRONT_LEFT = $0400;
  GL_FRONT_RIGHT = $0401;
  GL_BACK_LEFT = $0402;
  GL_BACK_RIGHT = $0403;
  GL_FRONT = $0404;
  GL_BACK = $0405;
  GL_LEFT = $0406;
  GL_RIGHT = $0407;
  GL_FRONT_AND_BACK = $0408;
  GL_AUX0 = $0409;
  GL_AUX1 = $040A;
  GL_AUX2 = $040B;
  GL_AUX3 = $040C;
  GL_INVALID_ENUM = $0500;
  GL_INVALID_VALUE = $0501;
  GL_INVALID_OPERATION = $0502;
  GL_STACK_OVERFLOW = $0503;
  GL_STACK_OVERFLOW_KHR = $0503;
  GL_STACK_UNDERFLOW = $0504;
  GL_STACK_UNDERFLOW_KHR = $0504;
  GL_OUT_OF_MEMORY = $0505;
  GL_INVALID_FRAMEBUFFER_OPERATION = $0506;
  GL_INVALID_FRAMEBUFFER_OPERATION_EXT = $0506;
  GL_INVALID_FRAMEBUFFER_OPERATION_OES = $0506;
  GL_CONTEXT_LOST = $0507;
  GL_CONTEXT_LOST_KHR = $0507;
  GL_2D = $0600;
  GL_3D = $0601;
  GL_3D_COLOR = $0602;
  GL_3D_COLOR_TEXTURE = $0603;
  GL_4D_COLOR_TEXTURE = $0604;
  GL_PASS_THROUGH_TOKEN = $0700;
  GL_POINT_TOKEN = $0701;
  GL_LINE_TOKEN = $0702;
  GL_POLYGON_TOKEN = $0703;
  GL_BITMAP_TOKEN = $0704;
  GL_DRAW_PIXEL_TOKEN = $0705;
  GL_COPY_PIXEL_TOKEN = $0706;
  GL_LINE_RESET_TOKEN = $0707;
  GL_EXP = $0800;
  GL_EXP2 = $0801;
  GL_CW = $0900;
  GL_CCW = $0901;
  GL_COEFF = $0A00;
  GL_ORDER = $0A01;
  GL_DOMAIN = $0A02;
  GL_CURRENT_COLOR = $0B00;
  GL_CURRENT_INDEX = $0B01;
  GL_CURRENT_NORMAL = $0B02;
  GL_CURRENT_TEXTURE_COORDS = $0B03;
  GL_CURRENT_RASTER_COLOR = $0B04;
  GL_CURRENT_RASTER_INDEX = $0B05;
  GL_CURRENT_RASTER_TEXTURE_COORDS = $0B06;
  GL_CURRENT_RASTER_POSITION = $0B07;
  GL_CURRENT_RASTER_POSITION_VALID = $0B08;
  GL_CURRENT_RASTER_DISTANCE = $0B09;
  GL_POINT_SMOOTH = $0B10;
  GL_POINT_SIZE = $0B11;
  GL_POINT_SIZE_RANGE = $0B12;
  GL_SMOOTH_POINT_SIZE_RANGE = $0B12;
  GL_POINT_SIZE_GRANULARITY = $0B13;
  GL_SMOOTH_POINT_SIZE_GRANULARITY = $0B13;
  GL_LINE_SMOOTH = $0B20;
  GL_LINE_WIDTH = $0B21;
  GL_LINE_WIDTH_RANGE = $0B22;
  GL_SMOOTH_LINE_WIDTH_RANGE = $0B22;
  GL_LINE_WIDTH_GRANULARITY = $0B23;
  GL_SMOOTH_LINE_WIDTH_GRANULARITY = $0B23;
  GL_LINE_STIPPLE = $0B24;
  GL_LINE_STIPPLE_PATTERN = $0B25;
  GL_LINE_STIPPLE_REPEAT = $0B26;
  GL_LIST_MODE = $0B30;
  GL_MAX_LIST_NESTING = $0B31;
  GL_LIST_BASE = $0B32;
  GL_LIST_INDEX = $0B33;
  GL_POLYGON_MODE = $0B40;
  GL_POLYGON_MODE_NV = $0B40;
  GL_POLYGON_SMOOTH = $0B41;
  GL_POLYGON_STIPPLE = $0B42;
  GL_EDGE_FLAG = $0B43;
  GL_CULL_FACE = $0B44;
  GL_CULL_FACE_MODE = $0B45;
  GL_FRONT_FACE = $0B46;
  GL_LIGHTING = $0B50;
  GL_LIGHT_MODEL_LOCAL_VIEWER = $0B51;
  GL_LIGHT_MODEL_TWO_SIDE = $0B52;
  GL_LIGHT_MODEL_AMBIENT = $0B53;
  GL_SHADE_MODEL = $0B54;
  GL_COLOR_MATERIAL_FACE = $0B55;
  GL_COLOR_MATERIAL_PARAMETER = $0B56;
  GL_COLOR_MATERIAL = $0B57;
  GL_FOG = $0B60;
  GL_FOG_INDEX = $0B61;
  GL_FOG_DENSITY = $0B62;
  GL_FOG_START = $0B63;
  GL_FOG_END = $0B64;
  GL_FOG_MODE = $0B65;
  GL_FOG_COLOR = $0B66;
  GL_DEPTH_RANGE = $0B70;
  GL_DEPTH_TEST = $0B71;
  GL_DEPTH_WRITEMASK = $0B72;
  GL_DEPTH_CLEAR_VALUE = $0B73;
  GL_DEPTH_FUNC = $0B74;
  GL_ACCUM_CLEAR_VALUE = $0B80;
  GL_STENCIL_TEST = $0B90;
  GL_STENCIL_CLEAR_VALUE = $0B91;
  GL_STENCIL_FUNC = $0B92;
  GL_STENCIL_VALUE_MASK = $0B93;
  GL_STENCIL_FAIL = $0B94;
  GL_STENCIL_PASS_DEPTH_FAIL = $0B95;
  GL_STENCIL_PASS_DEPTH_PASS = $0B96;
  GL_STENCIL_REF = $0B97;
  GL_STENCIL_WRITEMASK = $0B98;
  GL_MATRIX_MODE = $0BA0;
  GL_NORMALIZE = $0BA1;
  GL_VIEWPORT = $0BA2;
  GL_MODELVIEW_STACK_DEPTH = $0BA3;
  GL_MODELVIEW0_STACK_DEPTH_EXT = $0BA3;
  GL_PATH_MODELVIEW_STACK_DEPTH_NV = $0BA3;
  GL_PROJECTION_STACK_DEPTH = $0BA4;
  GL_PATH_PROJECTION_STACK_DEPTH_NV = $0BA4;
  GL_TEXTURE_STACK_DEPTH = $0BA5;
  GL_MODELVIEW_MATRIX = $0BA6;
  GL_MODELVIEW0_MATRIX_EXT = $0BA6;
  GL_PATH_MODELVIEW_MATRIX_NV = $0BA6;
  GL_PROJECTION_MATRIX = $0BA7;
  GL_PATH_PROJECTION_MATRIX_NV = $0BA7;
  GL_TEXTURE_MATRIX = $0BA8;
  GL_ATTRIB_STACK_DEPTH = $0BB0;
  GL_CLIENT_ATTRIB_STACK_DEPTH = $0BB1;
  GL_ALPHA_TEST = $0BC0;
  GL_ALPHA_TEST_QCOM = $0BC0;
  GL_ALPHA_TEST_FUNC = $0BC1;
  GL_ALPHA_TEST_FUNC_QCOM = $0BC1;
  GL_ALPHA_TEST_REF = $0BC2;
  GL_ALPHA_TEST_REF_QCOM = $0BC2;
  GL_DITHER = $0BD0;
  GL_BLEND_DST = $0BE0;
  GL_BLEND_SRC = $0BE1;
  GL_BLEND = $0BE2;
  GL_LOGIC_OP_MODE = $0BF0;
  GL_INDEX_LOGIC_OP = $0BF1;
  GL_LOGIC_OP = $0BF1;
  GL_COLOR_LOGIC_OP = $0BF2;
  GL_AUX_BUFFERS = $0C00;
  GL_DRAW_BUFFER = $0C01;
  GL_DRAW_BUFFER_EXT = $0C01;
  GL_READ_BUFFER = $0C02;
  GL_READ_BUFFER_EXT = $0C02;
  GL_READ_BUFFER_NV = $0C02;
  GL_SCISSOR_BOX = $0C10;
  GL_SCISSOR_TEST = $0C11;
  GL_INDEX_CLEAR_VALUE = $0C20;
  GL_INDEX_WRITEMASK = $0C21;
  GL_COLOR_CLEAR_VALUE = $0C22;
  GL_COLOR_WRITEMASK = $0C23;
  GL_INDEX_MODE = $0C30;
  GL_RGBA_MODE = $0C31;
  GL_DOUBLEBUFFER = $0C32;
  GL_STEREO = $0C33;
  GL_RENDER_MODE = $0C40;
  GL_PERSPECTIVE_CORRECTION_HINT = $0C50;
  GL_POINT_SMOOTH_HINT = $0C51;
  GL_LINE_SMOOTH_HINT = $0C52;
  GL_POLYGON_SMOOTH_HINT = $0C53;
  GL_FOG_HINT = $0C54;
  GL_TEXTURE_GEN_S = $0C60;
  GL_TEXTURE_GEN_T = $0C61;
  GL_TEXTURE_GEN_R = $0C62;
  GL_TEXTURE_GEN_Q = $0C63;
  GL_PIXEL_MAP_I_TO_I = $0C70;
  GL_PIXEL_MAP_S_TO_S = $0C71;
  GL_PIXEL_MAP_I_TO_R = $0C72;
  GL_PIXEL_MAP_I_TO_G = $0C73;
  GL_PIXEL_MAP_I_TO_B = $0C74;
  GL_PIXEL_MAP_I_TO_A = $0C75;
  GL_PIXEL_MAP_R_TO_R = $0C76;
  GL_PIXEL_MAP_G_TO_G = $0C77;
  GL_PIXEL_MAP_B_TO_B = $0C78;
  GL_PIXEL_MAP_A_TO_A = $0C79;
  GL_PIXEL_MAP_I_TO_I_SIZE = $0CB0;
  GL_PIXEL_MAP_S_TO_S_SIZE = $0CB1;
  GL_PIXEL_MAP_I_TO_R_SIZE = $0CB2;
  GL_PIXEL_MAP_I_TO_G_SIZE = $0CB3;
  GL_PIXEL_MAP_I_TO_B_SIZE = $0CB4;
  GL_PIXEL_MAP_I_TO_A_SIZE = $0CB5;
  GL_PIXEL_MAP_R_TO_R_SIZE = $0CB6;
  GL_PIXEL_MAP_G_TO_G_SIZE = $0CB7;
  GL_PIXEL_MAP_B_TO_B_SIZE = $0CB8;
  GL_PIXEL_MAP_A_TO_A_SIZE = $0CB9;
  GL_UNPACK_SWAP_BYTES = $0CF0;
  GL_UNPACK_LSB_FIRST = $0CF1;
  GL_UNPACK_ROW_LENGTH = $0CF2;
  GL_UNPACK_ROW_LENGTH_EXT = $0CF2;
  GL_UNPACK_SKIP_ROWS = $0CF3;
  GL_UNPACK_SKIP_ROWS_EXT = $0CF3;
  GL_UNPACK_SKIP_PIXELS = $0CF4;
  GL_UNPACK_SKIP_PIXELS_EXT = $0CF4;
  GL_UNPACK_ALIGNMENT = $0CF5;
  GL_PACK_SWAP_BYTES = $0D00;
  GL_PACK_LSB_FIRST = $0D01;
  GL_PACK_ROW_LENGTH = $0D02;
  GL_PACK_SKIP_ROWS = $0D03;
  GL_PACK_SKIP_PIXELS = $0D04;
  GL_PACK_ALIGNMENT = $0D05;
  GL_MAP_COLOR = $0D10;
  GL_MAP_STENCIL = $0D11;
  GL_INDEX_SHIFT = $0D12;
  GL_INDEX_OFFSET = $0D13;
  GL_RED_SCALE = $0D14;
  GL_RED_BIAS = $0D15;
  GL_ZOOM_X = $0D16;
  GL_ZOOM_Y = $0D17;
  GL_GREEN_SCALE = $0D18;
  GL_GREEN_BIAS = $0D19;
  GL_BLUE_SCALE = $0D1A;
  GL_BLUE_BIAS = $0D1B;
  GL_ALPHA_SCALE = $0D1C;
  GL_ALPHA_BIAS = $0D1D;
  GL_DEPTH_SCALE = $0D1E;
  GL_DEPTH_BIAS = $0D1F;
  GL_MAX_EVAL_ORDER = $0D30;
  GL_MAX_LIGHTS = $0D31;
  GL_MAX_CLIP_PLANES = $0D32;
  GL_MAX_CLIP_PLANES_IMG = $0D32;
  GL_MAX_CLIP_DISTANCES = $0D32;
  GL_MAX_CLIP_DISTANCES_EXT = $0D32;
  GL_MAX_CLIP_DISTANCES_APPLE = $0D32;
  GL_MAX_TEXTURE_SIZE = $0D33;
  GL_MAX_PIXEL_MAP_TABLE = $0D34;
  GL_MAX_ATTRIB_STACK_DEPTH = $0D35;
  GL_MAX_MODELVIEW_STACK_DEPTH = $0D36;
  GL_PATH_MAX_MODELVIEW_STACK_DEPTH_NV = $0D36;
  GL_MAX_NAME_STACK_DEPTH = $0D37;
  GL_MAX_PROJECTION_STACK_DEPTH = $0D38;
  GL_PATH_MAX_PROJECTION_STACK_DEPTH_NV = $0D38;
  GL_MAX_TEXTURE_STACK_DEPTH = $0D39;
  GL_MAX_VIEWPORT_DIMS = $0D3A;
  GL_MAX_CLIENT_ATTRIB_STACK_DEPTH = $0D3B;
  GL_SUBPIXEL_BITS = $0D50;
  GL_INDEX_BITS = $0D51;
  GL_RED_BITS = $0D52;
  GL_GREEN_BITS = $0D53;
  GL_BLUE_BITS = $0D54;
  GL_ALPHA_BITS = $0D55;
  GL_DEPTH_BITS = $0D56;
  GL_STENCIL_BITS = $0D57;
  GL_ACCUM_RED_BITS = $0D58;
  GL_ACCUM_GREEN_BITS = $0D59;
  GL_ACCUM_BLUE_BITS = $0D5A;
  GL_ACCUM_ALPHA_BITS = $0D5B;
  GL_NAME_STACK_DEPTH = $0D70;
  GL_AUTO_NORMAL = $0D80;
  GL_MAP1_COLOR_4 = $0D90;
  GL_MAP1_INDEX = $0D91;
  GL_MAP1_NORMAL = $0D92;
  GL_MAP1_TEXTURE_COORD_1 = $0D93;
  GL_MAP1_TEXTURE_COORD_2 = $0D94;
  GL_MAP1_TEXTURE_COORD_3 = $0D95;
  GL_MAP1_TEXTURE_COORD_4 = $0D96;
  GL_MAP1_VERTEX_3 = $0D97;
  GL_MAP1_VERTEX_4 = $0D98;
  GL_MAP2_COLOR_4 = $0DB0;
  GL_MAP2_INDEX = $0DB1;
  GL_MAP2_NORMAL = $0DB2;
  GL_MAP2_TEXTURE_COORD_1 = $0DB3;
  GL_MAP2_TEXTURE_COORD_2 = $0DB4;
  GL_MAP2_TEXTURE_COORD_3 = $0DB5;
  GL_MAP2_TEXTURE_COORD_4 = $0DB6;
  GL_MAP2_VERTEX_3 = $0DB7;
  GL_MAP2_VERTEX_4 = $0DB8;
  GL_MAP1_GRID_DOMAIN = $0DD0;
  GL_MAP1_GRID_SEGMENTS = $0DD1;
  GL_MAP2_GRID_DOMAIN = $0DD2;
  GL_MAP2_GRID_SEGMENTS = $0DD3;
  GL_TEXTURE_1D = $0DE0;
  GL_TEXTURE_2D = $0DE1;
  GL_FEEDBACK_BUFFER_POINTER = $0DF0;
  GL_FEEDBACK_BUFFER_SIZE = $0DF1;
  GL_FEEDBACK_BUFFER_TYPE = $0DF2;
  GL_SELECTION_BUFFER_POINTER = $0DF3;
  GL_SELECTION_BUFFER_SIZE = $0DF4;
  GL_TEXTURE_WIDTH = $1000;
  GL_TEXTURE_HEIGHT = $1001;
  GL_TEXTURE_INTERNAL_FORMAT = $1003;
  GL_TEXTURE_COMPONENTS = $1003;
  GL_TEXTURE_BORDER_COLOR = $1004;
  GL_TEXTURE_BORDER_COLOR_EXT = $1004;
  GL_TEXTURE_BORDER_COLOR_NV = $1004;
  GL_TEXTURE_BORDER_COLOR_OES = $1004;
  GL_TEXTURE_BORDER = $1005;
  GL_TEXTURE_TARGET = $1006;
  GL_DONT_CARE = $1100;
  GL_FASTEST = $1101;
  GL_NICEST = $1102;
  GL_AMBIENT = $1200;
  GL_DIFFUSE = $1201;
  GL_SPECULAR = $1202;
  GL_POSITION = $1203;
  GL_SPOT_DIRECTION = $1204;
  GL_SPOT_EXPONENT = $1205;
  GL_SPOT_CUTOFF = $1206;
  GL_CONSTANT_ATTENUATION = $1207;
  GL_LINEAR_ATTENUATION = $1208;
  GL_QUADRATIC_ATTENUATION = $1209;
  GL_COMPILE = $1300;
  GL_COMPILE_AND_EXECUTE = $1301;
  GL_BYTE = $1400;
  GL_UNSIGNED_BYTE = $1401;
  GL_SHORT = $1402;
  GL_UNSIGNED_SHORT = $1403;
  GL_INT = $1404;
  GL_UNSIGNED_INT = $1405;
  GL_FLOAT = $1406;
  GL_2_BYTES = $1407;
  GL_2_BYTES_NV = $1407;
  GL_3_BYTES = $1408;
  GL_3_BYTES_NV = $1408;
  GL_4_BYTES = $1409;
  GL_4_BYTES_NV = $1409;
  GL_DOUBLE = $140A;
  GL_DOUBLE_EXT = $140A;
  GL_HALF_FLOAT = $140B;
  GL_HALF_FLOAT_ARB = $140B;
  GL_HALF_FLOAT_NV = $140B;
  GL_HALF_APPLE = $140B;
  GL_FIXED = $140C;
  GL_FIXED_OES = $140C;
  GL_INT64_ARB = $140E;
  GL_INT64_NV = $140E;
  GL_UNSIGNED_INT64_ARB = $140F;
  GL_UNSIGNED_INT64_NV = $140F;
  GL_CLEAR = $1500;
  GL_AND = $1501;
  GL_AND_REVERSE = $1502;
  GL_COPY = $1503;
  GL_AND_INVERTED = $1504;
  GL_NOOP = $1505;
  GL_XOR = $1506;
  GL_XOR_NV = $1506;
  GL_OR = $1507;
  GL_NOR = $1508;
  GL_EQUIV = $1509;
  GL_INVERT = $150A;
  GL_OR_REVERSE = $150B;
  GL_COPY_INVERTED = $150C;
  GL_OR_INVERTED = $150D;
  GL_NAND = $150E;
  GL_SET = $150F;
  GL_EMISSION = $1600;
  GL_SHININESS = $1601;
  GL_AMBIENT_AND_DIFFUSE = $1602;
  GL_COLOR_INDEXES = $1603;
  GL_MODELVIEW = $1700;
  GL_MODELVIEW0_ARB = $1700;
  GL_MODELVIEW0_EXT = $1700;
  GL_PATH_MODELVIEW_NV = $1700;
  GL_PROJECTION = $1701;
  GL_PATH_PROJECTION_NV = $1701;
  GL_TEXTURE = $1702;
  GL_COLOR = $1800;
  GL_COLOR_EXT = $1800;
  GL_DEPTH = $1801;
  GL_DEPTH_EXT = $1801;
  GL_STENCIL = $1802;
  GL_STENCIL_EXT = $1802;
  GL_COLOR_INDEX = $1900;
  GL_STENCIL_INDEX = $1901;
  GL_STENCIL_INDEX_OES = $1901;
  GL_DEPTH_COMPONENT = $1902;
  GL_RED = $1903;
  GL_RED_EXT = $1903;
  GL_RED_NV = $1903;
  GL_GREEN = $1904;
  GL_GREEN_NV = $1904;
  GL_BLUE = $1905;
  GL_BLUE_NV = $1905;
  GL_ALPHA = $1906;
  GL_RGB = $1907;
  GL_RGBA = $1908;
  GL_LUMINANCE = $1909;
  GL_LUMINANCE_ALPHA = $190A;
  GL_BITMAP = $1A00;
  GL_POINT = $1B00;
  GL_POINT_NV = $1B00;
  GL_LINE = $1B01;
  GL_LINE_NV = $1B01;
  GL_FILL = $1B02;
  GL_FILL_NV = $1B02;
  GL_RENDER = $1C00;
  GL_FEEDBACK = $1C01;
  GL_SELECT = $1C02;
  GL_FLAT = $1D00;
  GL_SMOOTH = $1D01;
  GL_KEEP = $1E00;
  GL_REPLACE = $1E01;
  GL_INCR = $1E02;
  GL_DECR = $1E03;
  GL_VENDOR = $1F00;
  GL_RENDERER = $1F01;
  GL_VERSION = $1F02;
  GL_EXTENSIONS = $1F03;
  GL_S = $2000;
  GL_T = $2001;
  GL_R = $2002;
  GL_Q = $2003;
  GL_MODULATE = $2100;
  GL_DECAL = $2101;
  GL_TEXTURE_ENV_MODE = $2200;
  GL_TEXTURE_ENV_COLOR = $2201;
  GL_TEXTURE_ENV = $2300;
  GL_EYE_LINEAR = $2400;
  GL_EYE_LINEAR_NV = $2400;
  GL_OBJECT_LINEAR = $2401;
  GL_OBJECT_LINEAR_NV = $2401;
  GL_SPHERE_MAP = $2402;
  GL_TEXTURE_GEN_MODE = $2500;
  GL_TEXTURE_GEN_MODE_OES = $2500;
  GL_OBJECT_PLANE = $2501;
  GL_EYE_PLANE = $2502;
  GL_NEAREST = $2600;
  GL_LINEAR = $2601;
  GL_NEAREST_MIPMAP_NEAREST = $2700;
  GL_LINEAR_MIPMAP_NEAREST = $2701;
  GL_NEAREST_MIPMAP_LINEAR = $2702;
  GL_LINEAR_MIPMAP_LINEAR = $2703;
  GL_TEXTURE_MAG_FILTER = $2800;
  GL_TEXTURE_MIN_FILTER = $2801;
  GL_TEXTURE_WRAP_S = $2802;
  GL_TEXTURE_WRAP_T = $2803;
  GL_CLAMP = $2900;
  GL_REPEAT = $2901;
  GL_POLYGON_OFFSET_UNITS = $2A00;
  GL_POLYGON_OFFSET_POINT = $2A01;
  GL_POLYGON_OFFSET_POINT_NV = $2A01;
  GL_POLYGON_OFFSET_LINE = $2A02;
  GL_POLYGON_OFFSET_LINE_NV = $2A02;
  GL_R3_G3_B2 = $2A10;
  GL_V2F = $2A20;
  GL_V3F = $2A21;
  GL_C4UB_V2F = $2A22;
  GL_C4UB_V3F = $2A23;
  GL_C3F_V3F = $2A24;
  GL_N3F_V3F = $2A25;
  GL_C4F_N3F_V3F = $2A26;
  GL_T2F_V3F = $2A27;
  GL_T4F_V4F = $2A28;
  GL_T2F_C4UB_V3F = $2A29;
  GL_T2F_C3F_V3F = $2A2A;
  GL_T2F_N3F_V3F = $2A2B;
  GL_T2F_C4F_N3F_V3F = $2A2C;
  GL_T4F_C4F_N3F_V4F = $2A2D;
  GL_CLIP_PLANE0 = $3000;
  GL_CLIP_PLANE0_IMG = $3000;
  GL_CLIP_DISTANCE0 = $3000;
  GL_CLIP_DISTANCE0_EXT = $3000;
  GL_CLIP_DISTANCE0_APPLE = $3000;
  GL_CLIP_PLANE1 = $3001;
  GL_CLIP_PLANE1_IMG = $3001;
  GL_CLIP_DISTANCE1 = $3001;
  GL_CLIP_DISTANCE1_EXT = $3001;
  GL_CLIP_DISTANCE1_APPLE = $3001;
  GL_CLIP_PLANE2 = $3002;
  GL_CLIP_PLANE2_IMG = $3002;
  GL_CLIP_DISTANCE2 = $3002;
  GL_CLIP_DISTANCE2_EXT = $3002;
  GL_CLIP_DISTANCE2_APPLE = $3002;
  GL_CLIP_PLANE3 = $3003;
  GL_CLIP_PLANE3_IMG = $3003;
  GL_CLIP_DISTANCE3 = $3003;
  GL_CLIP_DISTANCE3_EXT = $3003;
  GL_CLIP_DISTANCE3_APPLE = $3003;
  GL_CLIP_PLANE4 = $3004;
  GL_CLIP_PLANE4_IMG = $3004;
  GL_CLIP_DISTANCE4 = $3004;
  GL_CLIP_DISTANCE4_EXT = $3004;
  GL_CLIP_DISTANCE4_APPLE = $3004;
  GL_CLIP_PLANE5 = $3005;
  GL_CLIP_PLANE5_IMG = $3005;
  GL_CLIP_DISTANCE5 = $3005;
  GL_CLIP_DISTANCE5_EXT = $3005;
  GL_CLIP_DISTANCE5_APPLE = $3005;
  GL_CLIP_DISTANCE6 = $3006;
  GL_CLIP_DISTANCE6_EXT = $3006;
  GL_CLIP_DISTANCE6_APPLE = $3006;
  GL_CLIP_DISTANCE7 = $3007;
  GL_CLIP_DISTANCE7_EXT = $3007;
  GL_CLIP_DISTANCE7_APPLE = $3007;
  GL_LIGHT0 = $4000;
  GL_LIGHT1 = $4001;
  GL_LIGHT2 = $4002;
  GL_LIGHT3 = $4003;
  GL_LIGHT4 = $4004;
  GL_LIGHT5 = $4005;
  GL_LIGHT6 = $4006;
  GL_LIGHT7 = $4007;
  GL_ABGR_EXT = $8000;
  GL_CONSTANT_COLOR = $8001;
  GL_CONSTANT_COLOR_EXT = $8001;
  GL_ONE_MINUS_CONSTANT_COLOR = $8002;
  GL_ONE_MINUS_CONSTANT_COLOR_EXT = $8002;
  GL_CONSTANT_ALPHA = $8003;
  GL_CONSTANT_ALPHA_EXT = $8003;
  GL_ONE_MINUS_CONSTANT_ALPHA = $8004;
  GL_ONE_MINUS_CONSTANT_ALPHA_EXT = $8004;
  GL_BLEND_COLOR = $8005;
  GL_BLEND_COLOR_EXT = $8005;
  GL_FUNC_ADD = $8006;
  GL_FUNC_ADD_EXT = $8006;
  GL_FUNC_ADD_OES = $8006;
  GL_MIN = $8007;
  GL_MIN_EXT = $8007;
  GL_MAX = $8008;
  GL_MAX_EXT = $8008;
  GL_BLEND_EQUATION = $8009;
  GL_BLEND_EQUATION_EXT = $8009;
  GL_BLEND_EQUATION_OES = $8009;
  GL_BLEND_EQUATION_RGB = $8009;
  GL_BLEND_EQUATION_RGB_EXT = $8009;
  GL_BLEND_EQUATION_RGB_OES = $8009;
  GL_FUNC_SUBTRACT = $800A;
  GL_FUNC_SUBTRACT_EXT = $800A;
  GL_FUNC_SUBTRACT_OES = $800A;
  GL_FUNC_REVERSE_SUBTRACT = $800B;
  GL_FUNC_REVERSE_SUBTRACT_EXT = $800B;
  GL_FUNC_REVERSE_SUBTRACT_OES = $800B;
  GL_CMYK_EXT = $800C;
  GL_CMYKA_EXT = $800D;
  GL_PACK_CMYK_HINT_EXT = $800E;
  GL_UNPACK_CMYK_HINT_EXT = $800F;
  GL_CONVOLUTION_1D = $8010;
  GL_CONVOLUTION_1D_EXT = $8010;
  GL_CONVOLUTION_2D = $8011;
  GL_CONVOLUTION_2D_EXT = $8011;
  GL_SEPARABLE_2D = $8012;
  GL_SEPARABLE_2D_EXT = $8012;
  GL_CONVOLUTION_BORDER_MODE = $8013;
  GL_CONVOLUTION_BORDER_MODE_EXT = $8013;
  GL_CONVOLUTION_FILTER_SCALE = $8014;
  GL_CONVOLUTION_FILTER_SCALE_EXT = $8014;
  GL_CONVOLUTION_FILTER_BIAS = $8015;
  GL_CONVOLUTION_FILTER_BIAS_EXT = $8015;
  GL_REDUCE = $8016;
  GL_REDUCE_EXT = $8016;
  GL_CONVOLUTION_FORMAT = $8017;
  GL_CONVOLUTION_FORMAT_EXT = $8017;
  GL_CONVOLUTION_WIDTH = $8018;
  GL_CONVOLUTION_WIDTH_EXT = $8018;
  GL_CONVOLUTION_HEIGHT = $8019;
  GL_CONVOLUTION_HEIGHT_EXT = $8019;
  GL_MAX_CONVOLUTION_WIDTH = $801A;
  GL_MAX_CONVOLUTION_WIDTH_EXT = $801A;
  GL_MAX_CONVOLUTION_HEIGHT = $801B;
  GL_MAX_CONVOLUTION_HEIGHT_EXT = $801B;
  GL_POST_CONVOLUTION_RED_SCALE = $801C;
  GL_POST_CONVOLUTION_RED_SCALE_EXT = $801C;
  GL_POST_CONVOLUTION_GREEN_SCALE = $801D;
  GL_POST_CONVOLUTION_GREEN_SCALE_EXT = $801D;
  GL_POST_CONVOLUTION_BLUE_SCALE = $801E;
  GL_POST_CONVOLUTION_BLUE_SCALE_EXT = $801E;
  GL_POST_CONVOLUTION_ALPHA_SCALE = $801F;
  GL_POST_CONVOLUTION_ALPHA_SCALE_EXT = $801F;
  GL_POST_CONVOLUTION_RED_BIAS = $8020;
  GL_POST_CONVOLUTION_RED_BIAS_EXT = $8020;
  GL_POST_CONVOLUTION_GREEN_BIAS = $8021;
  GL_POST_CONVOLUTION_GREEN_BIAS_EXT = $8021;
  GL_POST_CONVOLUTION_BLUE_BIAS = $8022;
  GL_POST_CONVOLUTION_BLUE_BIAS_EXT = $8022;
  GL_POST_CONVOLUTION_ALPHA_BIAS = $8023;
  GL_POST_CONVOLUTION_ALPHA_BIAS_EXT = $8023;
  GL_HISTOGRAM = $8024;
  GL_HISTOGRAM_EXT = $8024;
  GL_PROXY_HISTOGRAM = $8025;
  GL_PROXY_HISTOGRAM_EXT = $8025;
  GL_HISTOGRAM_WIDTH = $8026;
  GL_HISTOGRAM_WIDTH_EXT = $8026;
  GL_HISTOGRAM_FORMAT = $8027;
  GL_HISTOGRAM_FORMAT_EXT = $8027;
  GL_HISTOGRAM_RED_SIZE = $8028;
  GL_HISTOGRAM_RED_SIZE_EXT = $8028;
  GL_HISTOGRAM_GREEN_SIZE = $8029;
  GL_HISTOGRAM_GREEN_SIZE_EXT = $8029;
  GL_HISTOGRAM_BLUE_SIZE = $802A;
  GL_HISTOGRAM_BLUE_SIZE_EXT = $802A;
  GL_HISTOGRAM_ALPHA_SIZE = $802B;
  GL_HISTOGRAM_ALPHA_SIZE_EXT = $802B;
  GL_HISTOGRAM_LUMINANCE_SIZE = $802C;
  GL_HISTOGRAM_LUMINANCE_SIZE_EXT = $802C;
  GL_HISTOGRAM_SINK = $802D;
  GL_HISTOGRAM_SINK_EXT = $802D;
  GL_MINMAX = $802E;
  GL_MINMAX_EXT = $802E;
  GL_MINMAX_FORMAT = $802F;
  GL_MINMAX_FORMAT_EXT = $802F;
  GL_MINMAX_SINK = $8030;
  GL_MINMAX_SINK_EXT = $8030;
  GL_TABLE_TOO_LARGE_EXT = $8031;
  GL_TABLE_TOO_LARGE = $8031;
  GL_UNSIGNED_BYTE_3_3_2 = $8032;
  GL_UNSIGNED_BYTE_3_3_2_EXT = $8032;
  GL_UNSIGNED_SHORT_4_4_4_4 = $8033;
  GL_UNSIGNED_SHORT_4_4_4_4_EXT = $8033;
  GL_UNSIGNED_SHORT_5_5_5_1 = $8034;
  GL_UNSIGNED_SHORT_5_5_5_1_EXT = $8034;
  GL_UNSIGNED_INT_8_8_8_8 = $8035;
  GL_UNSIGNED_INT_8_8_8_8_EXT = $8035;
  GL_UNSIGNED_INT_10_10_10_2 = $8036;
  GL_UNSIGNED_INT_10_10_10_2_EXT = $8036;
  GL_POLYGON_OFFSET_EXT = $8037;
  GL_POLYGON_OFFSET_FILL = $8037;
  GL_POLYGON_OFFSET_FACTOR = $8038;
  GL_POLYGON_OFFSET_FACTOR_EXT = $8038;
  GL_POLYGON_OFFSET_BIAS_EXT = $8039;
  GL_RESCALE_NORMAL = $803A;
  GL_RESCALE_NORMAL_EXT = $803A;
  GL_ALPHA4 = $803B;
  GL_ALPHA4_EXT = $803B;
  GL_ALPHA8 = $803C;
  GL_ALPHA8_EXT = $803C;
  GL_ALPHA8_OES = $803C;
  GL_ALPHA12 = $803D;
  GL_ALPHA12_EXT = $803D;
  GL_ALPHA16 = $803E;
  GL_ALPHA16_EXT = $803E;
  GL_LUMINANCE4 = $803F;
  GL_LUMINANCE4_EXT = $803F;
  GL_LUMINANCE8 = $8040;
  GL_LUMINANCE8_EXT = $8040;
  GL_LUMINANCE8_OES = $8040;
  GL_LUMINANCE12 = $8041;
  GL_LUMINANCE12_EXT = $8041;
  GL_LUMINANCE16 = $8042;
  GL_LUMINANCE16_EXT = $8042;
  GL_LUMINANCE4_ALPHA4 = $8043;
  GL_LUMINANCE4_ALPHA4_EXT = $8043;
  GL_LUMINANCE4_ALPHA4_OES = $8043;
  GL_LUMINANCE6_ALPHA2 = $8044;
  GL_LUMINANCE6_ALPHA2_EXT = $8044;
  GL_LUMINANCE8_ALPHA8 = $8045;
  GL_LUMINANCE8_ALPHA8_EXT = $8045;
  GL_LUMINANCE8_ALPHA8_OES = $8045;
  GL_LUMINANCE12_ALPHA4 = $8046;
  GL_LUMINANCE12_ALPHA4_EXT = $8046;
  GL_LUMINANCE12_ALPHA12 = $8047;
  GL_LUMINANCE12_ALPHA12_EXT = $8047;
  GL_LUMINANCE16_ALPHA16 = $8048;
  GL_LUMINANCE16_ALPHA16_EXT = $8048;
  GL_INTENSITY = $8049;
  GL_INTENSITY_EXT = $8049;
  GL_INTENSITY4 = $804A;
  GL_INTENSITY4_EXT = $804A;
  GL_INTENSITY8 = $804B;
  GL_INTENSITY8_EXT = $804B;
  GL_INTENSITY12 = $804C;
  GL_INTENSITY12_EXT = $804C;
  GL_INTENSITY16 = $804D;
  GL_INTENSITY16_EXT = $804D;
  GL_RGB2_EXT = $804E;
  GL_RGB4 = $804F;
  GL_RGB4_EXT = $804F;
  GL_RGB5 = $8050;
  GL_RGB5_EXT = $8050;
  GL_RGB8 = $8051;
  GL_RGB8_EXT = $8051;
  GL_RGB8_OES = $8051;
  GL_RGB10 = $8052;
  GL_RGB10_EXT = $8052;
  GL_RGB12 = $8053;
  GL_RGB12_EXT = $8053;
  GL_RGB16 = $8054;
  GL_RGB16_EXT = $8054;
  GL_RGBA2 = $8055;
  GL_RGBA2_EXT = $8055;
  GL_RGBA4 = $8056;
  GL_RGBA4_EXT = $8056;
  GL_RGBA4_OES = $8056;
  GL_RGB5_A1 = $8057;
  GL_RGB5_A1_EXT = $8057;
  GL_RGB5_A1_OES = $8057;
  GL_RGBA8 = $8058;
  GL_RGBA8_EXT = $8058;
  GL_RGBA8_OES = $8058;
  GL_RGB10_A2 = $8059;
  GL_RGB10_A2_EXT = $8059;
  GL_RGBA12 = $805A;
  GL_RGBA12_EXT = $805A;
  GL_RGBA16 = $805B;
  GL_RGBA16_EXT = $805B;
  GL_TEXTURE_RED_SIZE = $805C;
  GL_TEXTURE_RED_SIZE_EXT = $805C;
  GL_TEXTURE_GREEN_SIZE = $805D;
  GL_TEXTURE_GREEN_SIZE_EXT = $805D;
  GL_TEXTURE_BLUE_SIZE = $805E;
  GL_TEXTURE_BLUE_SIZE_EXT = $805E;
  GL_TEXTURE_ALPHA_SIZE = $805F;
  GL_TEXTURE_ALPHA_SIZE_EXT = $805F;
  GL_TEXTURE_LUMINANCE_SIZE = $8060;
  GL_TEXTURE_LUMINANCE_SIZE_EXT = $8060;
  GL_TEXTURE_INTENSITY_SIZE = $8061;
  GL_TEXTURE_INTENSITY_SIZE_EXT = $8061;
  GL_REPLACE_EXT = $8062;
  GL_PROXY_TEXTURE_1D = $8063;
  GL_PROXY_TEXTURE_1D_EXT = $8063;
  GL_PROXY_TEXTURE_2D = $8064;
  GL_PROXY_TEXTURE_2D_EXT = $8064;
  GL_TEXTURE_TOO_LARGE_EXT = $8065;
  GL_TEXTURE_PRIORITY = $8066;
  GL_TEXTURE_PRIORITY_EXT = $8066;
  GL_TEXTURE_RESIDENT = $8067;
  GL_TEXTURE_RESIDENT_EXT = $8067;
  GL_TEXTURE_1D_BINDING_EXT = $8068;
  GL_TEXTURE_BINDING_1D = $8068;
  GL_TEXTURE_2D_BINDING_EXT = $8069;
  GL_TEXTURE_BINDING_2D = $8069;
  GL_TEXTURE_3D_BINDING_EXT = $806A;
  GL_TEXTURE_3D_BINDING_OES = $806A;
  GL_TEXTURE_BINDING_3D = $806A;
  GL_TEXTURE_BINDING_3D_OES = $806A;
  GL_PACK_SKIP_IMAGES = $806B;
  GL_PACK_SKIP_IMAGES_EXT = $806B;
  GL_PACK_IMAGE_HEIGHT = $806C;
  GL_PACK_IMAGE_HEIGHT_EXT = $806C;
  GL_UNPACK_SKIP_IMAGES = $806D;
  GL_UNPACK_SKIP_IMAGES_EXT = $806D;
  GL_UNPACK_IMAGE_HEIGHT = $806E;
  GL_UNPACK_IMAGE_HEIGHT_EXT = $806E;
  GL_TEXTURE_3D = $806F;
  GL_TEXTURE_3D_EXT = $806F;
  GL_TEXTURE_3D_OES = $806F;
  GL_PROXY_TEXTURE_3D = $8070;
  GL_PROXY_TEXTURE_3D_EXT = $8070;
  GL_TEXTURE_DEPTH = $8071;
  GL_TEXTURE_DEPTH_EXT = $8071;
  GL_TEXTURE_WRAP_R = $8072;
  GL_TEXTURE_WRAP_R_EXT = $8072;
  GL_TEXTURE_WRAP_R_OES = $8072;
  GL_MAX_3D_TEXTURE_SIZE = $8073;
  GL_MAX_3D_TEXTURE_SIZE_EXT = $8073;
  GL_MAX_3D_TEXTURE_SIZE_OES = $8073;
  GL_VERTEX_ARRAY = $8074;
  GL_VERTEX_ARRAY_EXT = $8074;
  GL_VERTEX_ARRAY_KHR = $8074;
  GL_NORMAL_ARRAY = $8075;
  GL_NORMAL_ARRAY_EXT = $8075;
  GL_COLOR_ARRAY = $8076;
  GL_COLOR_ARRAY_EXT = $8076;
  GL_INDEX_ARRAY = $8077;
  GL_INDEX_ARRAY_EXT = $8077;
  GL_TEXTURE_COORD_ARRAY = $8078;
  GL_TEXTURE_COORD_ARRAY_EXT = $8078;
  GL_EDGE_FLAG_ARRAY = $8079;
  GL_EDGE_FLAG_ARRAY_EXT = $8079;
  GL_VERTEX_ARRAY_SIZE = $807A;
  GL_VERTEX_ARRAY_SIZE_EXT = $807A;
  GL_VERTEX_ARRAY_TYPE = $807B;
  GL_VERTEX_ARRAY_TYPE_EXT = $807B;
  GL_VERTEX_ARRAY_STRIDE = $807C;
  GL_VERTEX_ARRAY_STRIDE_EXT = $807C;
  GL_VERTEX_ARRAY_COUNT_EXT = $807D;
  GL_NORMAL_ARRAY_TYPE = $807E;
  GL_NORMAL_ARRAY_TYPE_EXT = $807E;
  GL_NORMAL_ARRAY_STRIDE = $807F;
  GL_NORMAL_ARRAY_STRIDE_EXT = $807F;
  GL_NORMAL_ARRAY_COUNT_EXT = $8080;
  GL_COLOR_ARRAY_SIZE = $8081;
  GL_COLOR_ARRAY_SIZE_EXT = $8081;
  GL_COLOR_ARRAY_TYPE = $8082;
  GL_COLOR_ARRAY_TYPE_EXT = $8082;
  GL_COLOR_ARRAY_STRIDE = $8083;
  GL_COLOR_ARRAY_STRIDE_EXT = $8083;
  GL_COLOR_ARRAY_COUNT_EXT = $8084;
  GL_INDEX_ARRAY_TYPE = $8085;
  GL_INDEX_ARRAY_TYPE_EXT = $8085;
  GL_INDEX_ARRAY_STRIDE = $8086;
  GL_INDEX_ARRAY_STRIDE_EXT = $8086;
  GL_INDEX_ARRAY_COUNT_EXT = $8087;
  GL_TEXTURE_COORD_ARRAY_SIZE = $8088;
  GL_TEXTURE_COORD_ARRAY_SIZE_EXT = $8088;
  GL_TEXTURE_COORD_ARRAY_TYPE = $8089;
  GL_TEXTURE_COORD_ARRAY_TYPE_EXT = $8089;
  GL_TEXTURE_COORD_ARRAY_STRIDE = $808A;
  GL_TEXTURE_COORD_ARRAY_STRIDE_EXT = $808A;
  GL_TEXTURE_COORD_ARRAY_COUNT_EXT = $808B;
  GL_EDGE_FLAG_ARRAY_STRIDE = $808C;
  GL_EDGE_FLAG_ARRAY_STRIDE_EXT = $808C;
  GL_EDGE_FLAG_ARRAY_COUNT_EXT = $808D;
  GL_VERTEX_ARRAY_POINTER = $808E;
  GL_VERTEX_ARRAY_POINTER_EXT = $808E;
  GL_NORMAL_ARRAY_POINTER = $808F;
  GL_NORMAL_ARRAY_POINTER_EXT = $808F;
  GL_COLOR_ARRAY_POINTER = $8090;
  GL_COLOR_ARRAY_POINTER_EXT = $8090;
  GL_INDEX_ARRAY_POINTER = $8091;
  GL_INDEX_ARRAY_POINTER_EXT = $8091;
  GL_TEXTURE_COORD_ARRAY_POINTER = $8092;
  GL_TEXTURE_COORD_ARRAY_POINTER_EXT = $8092;
  GL_EDGE_FLAG_ARRAY_POINTER = $8093;
  GL_EDGE_FLAG_ARRAY_POINTER_EXT = $8093;
  GL_INTERLACE_SGIX = $8094;
  GL_DETAIL_TEXTURE_2D_SGIS = $8095;
  GL_DETAIL_TEXTURE_2D_BINDING_SGIS = $8096;
  GL_LINEAR_DETAIL_SGIS = $8097;
  GL_LINEAR_DETAIL_ALPHA_SGIS = $8098;
  GL_LINEAR_DETAIL_COLOR_SGIS = $8099;
  GL_DETAIL_TEXTURE_LEVEL_SGIS = $809A;
  GL_DETAIL_TEXTURE_MODE_SGIS = $809B;
  GL_DETAIL_TEXTURE_FUNC_POINTS_SGIS = $809C;
  GL_MULTISAMPLE = $809D;
  GL_MULTISAMPLE_ARB = $809D;
  GL_MULTISAMPLE_EXT = $809D;
  GL_MULTISAMPLE_SGIS = $809D;
  GL_SAMPLE_ALPHA_TO_COVERAGE = $809E;
  GL_SAMPLE_ALPHA_TO_COVERAGE_ARB = $809E;
  GL_SAMPLE_ALPHA_TO_MASK_EXT = $809E;
  GL_SAMPLE_ALPHA_TO_MASK_SGIS = $809E;
  GL_SAMPLE_ALPHA_TO_ONE = $809F;
  GL_SAMPLE_ALPHA_TO_ONE_ARB = $809F;
  GL_SAMPLE_ALPHA_TO_ONE_EXT = $809F;
  GL_SAMPLE_ALPHA_TO_ONE_SGIS = $809F;
  GL_SAMPLE_COVERAGE = $80A0;
  GL_SAMPLE_COVERAGE_ARB = $80A0;
  GL_SAMPLE_MASK_EXT = $80A0;
  GL_SAMPLE_MASK_SGIS = $80A0;
  GL_1PASS_EXT = $80A1;
  GL_1PASS_SGIS = $80A1;
  GL_2PASS_0_EXT = $80A2;
  GL_2PASS_0_SGIS = $80A2;
  GL_2PASS_1_EXT = $80A3;
  GL_2PASS_1_SGIS = $80A3;
  GL_4PASS_0_EXT = $80A4;
  GL_4PASS_0_SGIS = $80A4;
  GL_4PASS_1_EXT = $80A5;
  GL_4PASS_1_SGIS = $80A5;
  GL_4PASS_2_EXT = $80A6;
  GL_4PASS_2_SGIS = $80A6;
  GL_4PASS_3_EXT = $80A7;
  GL_4PASS_3_SGIS = $80A7;
  GL_SAMPLE_BUFFERS = $80A8;
  GL_SAMPLE_BUFFERS_ARB = $80A8;
  GL_SAMPLE_BUFFERS_EXT = $80A8;
  GL_SAMPLE_BUFFERS_SGIS = $80A8;
  GL_SAMPLES = $80A9;
  GL_SAMPLES_ARB = $80A9;
  GL_SAMPLES_EXT = $80A9;
  GL_SAMPLES_SGIS = $80A9;
  GL_SAMPLE_COVERAGE_VALUE = $80AA;
  GL_SAMPLE_COVERAGE_VALUE_ARB = $80AA;
  GL_SAMPLE_MASK_VALUE_EXT = $80AA;
  GL_SAMPLE_MASK_VALUE_SGIS = $80AA;
  GL_SAMPLE_COVERAGE_INVERT = $80AB;
  GL_SAMPLE_COVERAGE_INVERT_ARB = $80AB;
  GL_SAMPLE_MASK_INVERT_EXT = $80AB;
  GL_SAMPLE_MASK_INVERT_SGIS = $80AB;
  GL_SAMPLE_PATTERN_EXT = $80AC;
  GL_SAMPLE_PATTERN_SGIS = $80AC;
  GL_LINEAR_SHARPEN_SGIS = $80AD;
  GL_LINEAR_SHARPEN_ALPHA_SGIS = $80AE;
  GL_LINEAR_SHARPEN_COLOR_SGIS = $80AF;
  GL_SHARPEN_TEXTURE_FUNC_POINTS_SGIS = $80B0;
  GL_COLOR_MATRIX = $80B1;
  GL_COLOR_MATRIX_SGI = $80B1;
  GL_COLOR_MATRIX_STACK_DEPTH = $80B2;
  GL_COLOR_MATRIX_STACK_DEPTH_SGI = $80B2;
  GL_MAX_COLOR_MATRIX_STACK_DEPTH = $80B3;
  GL_MAX_COLOR_MATRIX_STACK_DEPTH_SGI = $80B3;
  GL_POST_COLOR_MATRIX_RED_SCALE = $80B4;
  GL_POST_COLOR_MATRIX_RED_SCALE_SGI = $80B4;
  GL_POST_COLOR_MATRIX_GREEN_SCALE = $80B5;
  GL_POST_COLOR_MATRIX_GREEN_SCALE_SGI = $80B5;
  GL_POST_COLOR_MATRIX_BLUE_SCALE = $80B6;
  GL_POST_COLOR_MATRIX_BLUE_SCALE_SGI = $80B6;
  GL_POST_COLOR_MATRIX_ALPHA_SCALE = $80B7;
  GL_POST_COLOR_MATRIX_ALPHA_SCALE_SGI = $80B7;
  GL_POST_COLOR_MATRIX_RED_BIAS = $80B8;
  GL_POST_COLOR_MATRIX_RED_BIAS_SGI = $80B8;
  GL_POST_COLOR_MATRIX_GREEN_BIAS = $80B9;
  GL_POST_COLOR_MATRIX_GREEN_BIAS_SGI = $80B9;
  GL_POST_COLOR_MATRIX_BLUE_BIAS = $80BA;
  GL_POST_COLOR_MATRIX_BLUE_BIAS_SGI = $80BA;
  GL_POST_COLOR_MATRIX_ALPHA_BIAS = $80BB;
  GL_POST_COLOR_MATRIX_ALPHA_BIAS_SGI = $80BB;
  GL_TEXTURE_COLOR_TABLE_SGI = $80BC;
  GL_PROXY_TEXTURE_COLOR_TABLE_SGI = $80BD;
  GL_TEXTURE_ENV_BIAS_SGIX = $80BE;
  GL_SHADOW_AMBIENT_SGIX = $80BF;
  GL_TEXTURE_COMPARE_FAIL_VALUE_ARB = $80BF;
  GL_BLEND_DST_RGB = $80C8;
  GL_BLEND_DST_RGB_EXT = $80C8;
  GL_BLEND_DST_RGB_OES = $80C8;
  GL_BLEND_SRC_RGB = $80C9;
  GL_BLEND_SRC_RGB_EXT = $80C9;
  GL_BLEND_SRC_RGB_OES = $80C9;
  GL_BLEND_DST_ALPHA = $80CA;
  GL_BLEND_DST_ALPHA_EXT = $80CA;
  GL_BLEND_DST_ALPHA_OES = $80CA;
  GL_BLEND_SRC_ALPHA = $80CB;
  GL_BLEND_SRC_ALPHA_EXT = $80CB;
  GL_BLEND_SRC_ALPHA_OES = $80CB;
  GL_422_EXT = $80CC;
  GL_422_REV_EXT = $80CD;
  GL_422_AVERAGE_EXT = $80CE;
  GL_422_REV_AVERAGE_EXT = $80CF;
  GL_COLOR_TABLE = $80D0;
  GL_COLOR_TABLE_SGI = $80D0;
  GL_POST_CONVOLUTION_COLOR_TABLE = $80D1;
  GL_POST_CONVOLUTION_COLOR_TABLE_SGI = $80D1;
  GL_POST_COLOR_MATRIX_COLOR_TABLE = $80D2;
  GL_POST_COLOR_MATRIX_COLOR_TABLE_SGI = $80D2;
  GL_PROXY_COLOR_TABLE = $80D3;
  GL_PROXY_COLOR_TABLE_SGI = $80D3;
  GL_PROXY_POST_CONVOLUTION_COLOR_TABLE = $80D4;
  GL_PROXY_POST_CONVOLUTION_COLOR_TABLE_SGI = $80D4;
  GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE = $80D5;
  GL_PROXY_POST_COLOR_MATRIX_COLOR_TABLE_SGI = $80D5;
  GL_COLOR_TABLE_SCALE = $80D6;
  GL_COLOR_TABLE_SCALE_SGI = $80D6;
  GL_COLOR_TABLE_BIAS = $80D7;
  GL_COLOR_TABLE_BIAS_SGI = $80D7;
  GL_COLOR_TABLE_FORMAT = $80D8;
  GL_COLOR_TABLE_FORMAT_SGI = $80D8;
  GL_COLOR_TABLE_WIDTH = $80D9;
  GL_COLOR_TABLE_WIDTH_SGI = $80D9;
  GL_COLOR_TABLE_RED_SIZE = $80DA;
  GL_COLOR_TABLE_RED_SIZE_SGI = $80DA;
  GL_COLOR_TABLE_GREEN_SIZE = $80DB;
  GL_COLOR_TABLE_GREEN_SIZE_SGI = $80DB;
  GL_COLOR_TABLE_BLUE_SIZE = $80DC;
  GL_COLOR_TABLE_BLUE_SIZE_SGI = $80DC;
  GL_COLOR_TABLE_ALPHA_SIZE = $80DD;
  GL_COLOR_TABLE_ALPHA_SIZE_SGI = $80DD;
  GL_COLOR_TABLE_LUMINANCE_SIZE = $80DE;
  GL_COLOR_TABLE_LUMINANCE_SIZE_SGI = $80DE;
  GL_COLOR_TABLE_INTENSITY_SIZE = $80DF;
  GL_COLOR_TABLE_INTENSITY_SIZE_SGI = $80DF;
  GL_BGR = $80E0;
  GL_BGR_EXT = $80E0;
  GL_BGRA = $80E1;
  GL_BGRA_EXT = $80E1;
  GL_BGRA_IMG = $80E1;
  GL_COLOR_INDEX1_EXT = $80E2;
  GL_COLOR_INDEX2_EXT = $80E3;
  GL_COLOR_INDEX4_EXT = $80E4;
  GL_COLOR_INDEX8_EXT = $80E5;
  GL_COLOR_INDEX12_EXT = $80E6;
  GL_COLOR_INDEX16_EXT = $80E7;
  GL_MAX_ELEMENTS_VERTICES = $80E8;
  GL_MAX_ELEMENTS_VERTICES_EXT = $80E8;
  GL_MAX_ELEMENTS_INDICES = $80E9;
  GL_MAX_ELEMENTS_INDICES_EXT = $80E9;
  GL_PHONG_WIN = $80EA;
  GL_PHONG_HINT_WIN = $80EB;
  GL_FOG_SPECULAR_TEXTURE_WIN = $80EC;
  GL_TEXTURE_INDEX_SIZE_EXT = $80ED;
  GL_PARAMETER_BUFFER = $80EE;
  GL_PARAMETER_BUFFER_ARB = $80EE;
  GL_PARAMETER_BUFFER_BINDING = $80EF;
  GL_PARAMETER_BUFFER_BINDING_ARB = $80EF;
  GL_CLIP_VOLUME_CLIPPING_HINT_EXT = $80F0;
  GL_DUAL_ALPHA4_SGIS = $8110;
  GL_DUAL_ALPHA8_SGIS = $8111;
  GL_DUAL_ALPHA12_SGIS = $8112;
  GL_DUAL_ALPHA16_SGIS = $8113;
  GL_DUAL_LUMINANCE4_SGIS = $8114;
  GL_DUAL_LUMINANCE8_SGIS = $8115;
  GL_DUAL_LUMINANCE12_SGIS = $8116;
  GL_DUAL_LUMINANCE16_SGIS = $8117;
  GL_DUAL_INTENSITY4_SGIS = $8118;
  GL_DUAL_INTENSITY8_SGIS = $8119;
  GL_DUAL_INTENSITY12_SGIS = $811A;
  GL_DUAL_INTENSITY16_SGIS = $811B;
  GL_DUAL_LUMINANCE_ALPHA4_SGIS = $811C;
  GL_DUAL_LUMINANCE_ALPHA8_SGIS = $811D;
  GL_QUAD_ALPHA4_SGIS = $811E;
  GL_QUAD_ALPHA8_SGIS = $811F;
  GL_QUAD_LUMINANCE4_SGIS = $8120;
  GL_QUAD_LUMINANCE8_SGIS = $8121;
  GL_QUAD_INTENSITY4_SGIS = $8122;
  GL_QUAD_INTENSITY8_SGIS = $8123;
  GL_DUAL_TEXTURE_SELECT_SGIS = $8124;
  GL_QUAD_TEXTURE_SELECT_SGIS = $8125;
  GL_POINT_SIZE_MIN = $8126;
  GL_POINT_SIZE_MIN_ARB = $8126;
  GL_POINT_SIZE_MIN_EXT = $8126;
  GL_POINT_SIZE_MIN_SGIS = $8126;
  GL_POINT_SIZE_MAX = $8127;
  GL_POINT_SIZE_MAX_ARB = $8127;
  GL_POINT_SIZE_MAX_EXT = $8127;
  GL_POINT_SIZE_MAX_SGIS = $8127;
  GL_POINT_FADE_THRESHOLD_SIZE = $8128;
  GL_POINT_FADE_THRESHOLD_SIZE_ARB = $8128;
  GL_POINT_FADE_THRESHOLD_SIZE_EXT = $8128;
  GL_POINT_FADE_THRESHOLD_SIZE_SGIS = $8128;
  GL_DISTANCE_ATTENUATION_EXT = $8129;
  GL_DISTANCE_ATTENUATION_SGIS = $8129;
  GL_POINT_DISTANCE_ATTENUATION = $8129;
  GL_POINT_DISTANCE_ATTENUATION_ARB = $8129;
  GL_FOG_FUNC_SGIS = $812A;
  GL_FOG_FUNC_POINTS_SGIS = $812B;
  GL_MAX_FOG_FUNC_POINTS_SGIS = $812C;
  GL_CLAMP_TO_BORDER = $812D;
  GL_CLAMP_TO_BORDER_ARB = $812D;
  GL_CLAMP_TO_BORDER_EXT = $812D;
  GL_CLAMP_TO_BORDER_NV = $812D;
  GL_CLAMP_TO_BORDER_SGIS = $812D;
  GL_CLAMP_TO_BORDER_OES = $812D;
  GL_TEXTURE_MULTI_BUFFER_HINT_SGIX = $812E;
  GL_CLAMP_TO_EDGE = $812F;
  GL_CLAMP_TO_EDGE_SGIS = $812F;
  GL_PACK_SKIP_VOLUMES_SGIS = $8130;
  GL_PACK_IMAGE_DEPTH_SGIS = $8131;
  GL_UNPACK_SKIP_VOLUMES_SGIS = $8132;
  GL_UNPACK_IMAGE_DEPTH_SGIS = $8133;
  GL_TEXTURE_4D_SGIS = $8134;
  GL_PROXY_TEXTURE_4D_SGIS = $8135;
  GL_TEXTURE_4DSIZE_SGIS = $8136;
  GL_TEXTURE_WRAP_Q_SGIS = $8137;
  GL_MAX_4D_TEXTURE_SIZE_SGIS = $8138;
  GL_PIXEL_TEX_GEN_SGIX = $8139;
  GL_TEXTURE_MIN_LOD = $813A;
  GL_TEXTURE_MIN_LOD_SGIS = $813A;
  GL_TEXTURE_MAX_LOD = $813B;
  GL_TEXTURE_MAX_LOD_SGIS = $813B;
  GL_TEXTURE_BASE_LEVEL = $813C;
  GL_TEXTURE_BASE_LEVEL_SGIS = $813C;
  GL_TEXTURE_MAX_LEVEL = $813D;
  GL_TEXTURE_MAX_LEVEL_APPLE = $813D;
  GL_TEXTURE_MAX_LEVEL_SGIS = $813D;
  GL_PIXEL_TILE_BEST_ALIGNMENT_SGIX = $813E;
  GL_PIXEL_TILE_CACHE_INCREMENT_SGIX = $813F;
  GL_PIXEL_TILE_WIDTH_SGIX = $8140;
  GL_PIXEL_TILE_HEIGHT_SGIX = $8141;
  GL_PIXEL_TILE_GRID_WIDTH_SGIX = $8142;
  GL_PIXEL_TILE_GRID_HEIGHT_SGIX = $8143;
  GL_PIXEL_TILE_GRID_DEPTH_SGIX = $8144;
  GL_PIXEL_TILE_CACHE_SIZE_SGIX = $8145;
  GL_FILTER4_SGIS = $8146;
  GL_TEXTURE_FILTER4_SIZE_SGIS = $8147;
  GL_SPRITE_SGIX = $8148;
  GL_SPRITE_MODE_SGIX = $8149;
  GL_SPRITE_AXIS_SGIX = $814A;
  GL_SPRITE_TRANSLATION_SGIX = $814B;
  GL_SPRITE_AXIAL_SGIX = $814C;
  GL_SPRITE_OBJECT_ALIGNED_SGIX = $814D;
  GL_SPRITE_EYE_ALIGNED_SGIX = $814E;
  GL_TEXTURE_4D_BINDING_SGIS = $814F;
  GL_IGNORE_BORDER_HP = $8150;
  GL_CONSTANT_BORDER = $8151;
  GL_CONSTANT_BORDER_HP = $8151;
  GL_REPLICATE_BORDER = $8153;
  GL_REPLICATE_BORDER_HP = $8153;
  GL_CONVOLUTION_BORDER_COLOR = $8154;
  GL_CONVOLUTION_BORDER_COLOR_HP = $8154;
  GL_IMAGE_SCALE_X_HP = $8155;
  GL_IMAGE_SCALE_Y_HP = $8156;
  GL_IMAGE_TRANSLATE_X_HP = $8157;
  GL_IMAGE_TRANSLATE_Y_HP = $8158;
  GL_IMAGE_ROTATE_ANGLE_HP = $8159;
  GL_IMAGE_ROTATE_ORIGIN_X_HP = $815A;
  GL_IMAGE_ROTATE_ORIGIN_Y_HP = $815B;
  GL_IMAGE_MAG_FILTER_HP = $815C;
  GL_IMAGE_MIN_FILTER_HP = $815D;
  GL_IMAGE_CUBIC_WEIGHT_HP = $815E;
  GL_CUBIC_HP = $815F;
  GL_AVERAGE_HP = $8160;
  GL_IMAGE_TRANSFORM_2D_HP = $8161;
  GL_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP = $8162;
  GL_PROXY_POST_IMAGE_TRANSFORM_COLOR_TABLE_HP = $8163;
  GL_OCCLUSION_TEST_HP = $8165;
  GL_OCCLUSION_TEST_RESULT_HP = $8166;
  GL_TEXTURE_LIGHTING_MODE_HP = $8167;
  GL_TEXTURE_POST_SPECULAR_HP = $8168;
  GL_TEXTURE_PRE_SPECULAR_HP = $8169;
  GL_LINEAR_CLIPMAP_LINEAR_SGIX = $8170;
  GL_TEXTURE_CLIPMAP_CENTER_SGIX = $8171;
  GL_TEXTURE_CLIPMAP_FRAME_SGIX = $8172;
  GL_TEXTURE_CLIPMAP_OFFSET_SGIX = $8173;
  GL_TEXTURE_CLIPMAP_VIRTUAL_DEPTH_SGIX = $8174;
  GL_TEXTURE_CLIPMAP_LOD_OFFSET_SGIX = $8175;
  GL_TEXTURE_CLIPMAP_DEPTH_SGIX = $8176;
  GL_MAX_CLIPMAP_DEPTH_SGIX = $8177;
  GL_MAX_CLIPMAP_VIRTUAL_DEPTH_SGIX = $8178;
  GL_POST_TEXTURE_FILTER_BIAS_SGIX = $8179;
  GL_POST_TEXTURE_FILTER_SCALE_SGIX = $817A;
  GL_POST_TEXTURE_FILTER_BIAS_RANGE_SGIX = $817B;
  GL_POST_TEXTURE_FILTER_SCALE_RANGE_SGIX = $817C;
  GL_REFERENCE_PLANE_SGIX = $817D;
  GL_REFERENCE_PLANE_EQUATION_SGIX = $817E;
  GL_IR_INSTRUMENT1_SGIX = $817F;
  GL_INSTRUMENT_BUFFER_POINTER_SGIX = $8180;
  GL_INSTRUMENT_MEASUREMENTS_SGIX = $8181;
  GL_LIST_PRIORITY_SGIX = $8182;
  GL_CALLIGRAPHIC_FRAGMENT_SGIX = $8183;
  GL_PIXEL_TEX_GEN_Q_CEILING_SGIX = $8184;
  GL_PIXEL_TEX_GEN_Q_ROUND_SGIX = $8185;
  GL_PIXEL_TEX_GEN_Q_FLOOR_SGIX = $8186;
  GL_PIXEL_TEX_GEN_ALPHA_REPLACE_SGIX = $8187;
  GL_PIXEL_TEX_GEN_ALPHA_NO_REPLACE_SGIX = $8188;
  GL_PIXEL_TEX_GEN_ALPHA_LS_SGIX = $8189;
  GL_PIXEL_TEX_GEN_ALPHA_MS_SGIX = $818A;
  GL_FRAMEZOOM_SGIX = $818B;
  GL_FRAMEZOOM_FACTOR_SGIX = $818C;
  GL_MAX_FRAMEZOOM_FACTOR_SGIX = $818D;
  GL_TEXTURE_LOD_BIAS_S_SGIX = $818E;
  GL_TEXTURE_LOD_BIAS_T_SGIX = $818F;
  GL_TEXTURE_LOD_BIAS_R_SGIX = $8190;
  GL_GENERATE_MIPMAP = $8191;
  GL_GENERATE_MIPMAP_SGIS = $8191;
  GL_GENERATE_MIPMAP_HINT = $8192;
  GL_GENERATE_MIPMAP_HINT_SGIS = $8192;
  GL_GEOMETRY_DEFORMATION_SGIX = $8194;
  GL_TEXTURE_DEFORMATION_SGIX = $8195;
  GL_DEFORMATIONS_MASK_SGIX = $8196;
  GL_MAX_DEFORMATION_ORDER_SGIX = $8197;
  GL_FOG_OFFSET_SGIX = $8198;
  GL_FOG_OFFSET_VALUE_SGIX = $8199;
  GL_TEXTURE_COMPARE_SGIX = $819A;
  GL_TEXTURE_COMPARE_OPERATOR_SGIX = $819B;
  GL_TEXTURE_LEQUAL_R_SGIX = $819C;
  GL_TEXTURE_GEQUAL_R_SGIX = $819D;
  GL_DEPTH_COMPONENT16 = $81A5;
  GL_DEPTH_COMPONENT16_ARB = $81A5;
  GL_DEPTH_COMPONENT16_OES = $81A5;
  GL_DEPTH_COMPONENT16_SGIX = $81A5;
  GL_DEPTH_COMPONENT24 = $81A6;
  GL_DEPTH_COMPONENT24_ARB = $81A6;
  GL_DEPTH_COMPONENT24_OES = $81A6;
  GL_DEPTH_COMPONENT24_SGIX = $81A6;
  GL_DEPTH_COMPONENT32 = $81A7;
  GL_DEPTH_COMPONENT32_ARB = $81A7;
  GL_DEPTH_COMPONENT32_OES = $81A7;
  GL_DEPTH_COMPONENT32_SGIX = $81A7;
  GL_ARRAY_ELEMENT_LOCK_FIRST_EXT = $81A8;
  GL_ARRAY_ELEMENT_LOCK_COUNT_EXT = $81A9;
  GL_CULL_VERTEX_EXT = $81AA;
  GL_CULL_VERTEX_EYE_POSITION_EXT = $81AB;
  GL_CULL_VERTEX_OBJECT_POSITION_EXT = $81AC;
  GL_IUI_V2F_EXT = $81AD;
  GL_IUI_V3F_EXT = $81AE;
  GL_IUI_N3F_V2F_EXT = $81AF;
  GL_IUI_N3F_V3F_EXT = $81B0;
  GL_T2F_IUI_V2F_EXT = $81B1;
  GL_T2F_IUI_V3F_EXT = $81B2;
  GL_T2F_IUI_N3F_V2F_EXT = $81B3;
  GL_T2F_IUI_N3F_V3F_EXT = $81B4;
  GL_INDEX_TEST_EXT = $81B5;
  GL_INDEX_TEST_FUNC_EXT = $81B6;
  GL_INDEX_TEST_REF_EXT = $81B7;
  GL_INDEX_MATERIAL_EXT = $81B8;
  GL_INDEX_MATERIAL_PARAMETER_EXT = $81B9;
  GL_INDEX_MATERIAL_FACE_EXT = $81BA;
  GL_YCRCB_422_SGIX = $81BB;
  GL_YCRCB_444_SGIX = $81BC;
  GL_WRAP_BORDER_SUN = $81D4;
  GL_UNPACK_CONSTANT_DATA_SUNX = $81D5;
  GL_TEXTURE_CONSTANT_DATA_SUNX = $81D6;
  GL_TRIANGLE_LIST_SUN = $81D7;
  GL_REPLACEMENT_CODE_SUN = $81D8;
  GL_GLOBAL_ALPHA_SUN = $81D9;
  GL_GLOBAL_ALPHA_FACTOR_SUN = $81DA;
  GL_TEXTURE_COLOR_WRITEMASK_SGIS = $81EF;
  GL_EYE_DISTANCE_TO_POINT_SGIS = $81F0;
  GL_OBJECT_DISTANCE_TO_POINT_SGIS = $81F1;
  GL_EYE_DISTANCE_TO_LINE_SGIS = $81F2;
  GL_OBJECT_DISTANCE_TO_LINE_SGIS = $81F3;
  GL_EYE_POINT_SGIS = $81F4;
  GL_OBJECT_POINT_SGIS = $81F5;
  GL_EYE_LINE_SGIS = $81F6;
  GL_OBJECT_LINE_SGIS = $81F7;
  GL_LIGHT_MODEL_COLOR_CONTROL = $81F8;
  GL_LIGHT_MODEL_COLOR_CONTROL_EXT = $81F8;
  GL_SINGLE_COLOR = $81F9;
  GL_SINGLE_COLOR_EXT = $81F9;
  GL_SEPARATE_SPECULAR_COLOR = $81FA;
  GL_SEPARATE_SPECULAR_COLOR_EXT = $81FA;
  GL_SHARED_TEXTURE_PALETTE_EXT = $81FB;
  GL_TEXT_FRAGMENT_SHADER_ATI = $8200;
  GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING = $8210;
  GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING_EXT = $8210;
  GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE = $8211;
  GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE_EXT = $8211;
  GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE = $8212;
  GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE = $8213;
  GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE = $8214;
  GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE = $8215;
  GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE = $8216;
  GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE = $8217;
  GL_FRAMEBUFFER_DEFAULT = $8218;
  GL_FRAMEBUFFER_UNDEFINED = $8219;
  GL_FRAMEBUFFER_UNDEFINED_OES = $8219;
  GL_DEPTH_STENCIL_ATTACHMENT = $821A;
  GL_MAJOR_VERSION = $821B;
  GL_MINOR_VERSION = $821C;
  GL_NUM_EXTENSIONS = $821D;
  GL_CONTEXT_FLAGS = $821E;
  GL_BUFFER_IMMUTABLE_STORAGE = $821F;
  GL_BUFFER_IMMUTABLE_STORAGE_EXT = $821F;
  GL_BUFFER_STORAGE_FLAGS = $8220;
  GL_BUFFER_STORAGE_FLAGS_EXT = $8220;
  GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED = $8221;
  GL_PRIMITIVE_RESTART_FOR_PATCHES_SUPPORTED_OES = $8221;
  GL_INDEX = $8222;
  GL_COMPRESSED_RED = $8225;
  GL_COMPRESSED_RG = $8226;
  GL_RG = $8227;
  GL_RG_EXT = $8227;
  GL_RG_INTEGER = $8228;
  GL_R8 = $8229;
  GL_R8_EXT = $8229;
  GL_R16 = $822A;
  GL_R16_EXT = $822A;
  GL_RG8 = $822B;
  GL_RG8_EXT = $822B;
  GL_RG16 = $822C;
  GL_RG16_EXT = $822C;
  GL_R16F = $822D;
  GL_R16F_EXT = $822D;
  GL_R32F = $822E;
  GL_R32F_EXT = $822E;
  GL_RG16F = $822F;
  GL_RG16F_EXT = $822F;
  GL_RG32F = $8230;
  GL_RG32F_EXT = $8230;
  GL_R8I = $8231;
  GL_R8UI = $8232;
  GL_R16I = $8233;
  GL_R16UI = $8234;
  GL_R32I = $8235;
  GL_R32UI = $8236;
  GL_RG8I = $8237;
  GL_RG8UI = $8238;
  GL_RG16I = $8239;
  GL_RG16UI = $823A;
  GL_RG32I = $823B;
  GL_RG32UI = $823C;
  GL_SYNC_CL_EVENT_ARB = $8240;
  GL_SYNC_CL_EVENT_COMPLETE_ARB = $8241;
  GL_DEBUG_OUTPUT_SYNCHRONOUS = $8242;
  GL_DEBUG_OUTPUT_SYNCHRONOUS_ARB = $8242;
  GL_DEBUG_OUTPUT_SYNCHRONOUS_KHR = $8242;
  GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = $8243;
  GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_ARB = $8243;
  GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH_KHR = $8243;
  GL_DEBUG_CALLBACK_FUNCTION = $8244;
  GL_DEBUG_CALLBACK_FUNCTION_ARB = $8244;
  GL_DEBUG_CALLBACK_FUNCTION_KHR = $8244;
  GL_DEBUG_CALLBACK_USER_PARAM = $8245;
  GL_DEBUG_CALLBACK_USER_PARAM_ARB = $8245;
  GL_DEBUG_CALLBACK_USER_PARAM_KHR = $8245;
  GL_DEBUG_SOURCE_API = $8246;
  GL_DEBUG_SOURCE_API_ARB = $8246;
  GL_DEBUG_SOURCE_API_KHR = $8246;
  GL_DEBUG_SOURCE_WINDOW_SYSTEM = $8247;
  GL_DEBUG_SOURCE_WINDOW_SYSTEM_ARB = $8247;
  GL_DEBUG_SOURCE_WINDOW_SYSTEM_KHR = $8247;
  GL_DEBUG_SOURCE_SHADER_COMPILER = $8248;
  GL_DEBUG_SOURCE_SHADER_COMPILER_ARB = $8248;
  GL_DEBUG_SOURCE_SHADER_COMPILER_KHR = $8248;
  GL_DEBUG_SOURCE_THIRD_PARTY = $8249;
  GL_DEBUG_SOURCE_THIRD_PARTY_ARB = $8249;
  GL_DEBUG_SOURCE_THIRD_PARTY_KHR = $8249;
  GL_DEBUG_SOURCE_APPLICATION = $824A;
  GL_DEBUG_SOURCE_APPLICATION_ARB = $824A;
  GL_DEBUG_SOURCE_APPLICATION_KHR = $824A;
  GL_DEBUG_SOURCE_OTHER = $824B;
  GL_DEBUG_SOURCE_OTHER_ARB = $824B;
  GL_DEBUG_SOURCE_OTHER_KHR = $824B;
  GL_DEBUG_TYPE_ERROR = $824C;
  GL_DEBUG_TYPE_ERROR_ARB = $824C;
  GL_DEBUG_TYPE_ERROR_KHR = $824C;
  GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = $824D;
  GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_ARB = $824D;
  GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR_KHR = $824D;
  GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = $824E;
  GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_ARB = $824E;
  GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR_KHR = $824E;
  GL_DEBUG_TYPE_PORTABILITY = $824F;
  GL_DEBUG_TYPE_PORTABILITY_ARB = $824F;
  GL_DEBUG_TYPE_PORTABILITY_KHR = $824F;
  GL_DEBUG_TYPE_PERFORMANCE = $8250;
  GL_DEBUG_TYPE_PERFORMANCE_ARB = $8250;
  GL_DEBUG_TYPE_PERFORMANCE_KHR = $8250;
  GL_DEBUG_TYPE_OTHER = $8251;
  GL_DEBUG_TYPE_OTHER_ARB = $8251;
  GL_DEBUG_TYPE_OTHER_KHR = $8251;
  GL_LOSE_CONTEXT_ON_RESET = $8252;
  GL_LOSE_CONTEXT_ON_RESET_ARB = $8252;
  GL_LOSE_CONTEXT_ON_RESET_EXT = $8252;
  GL_LOSE_CONTEXT_ON_RESET_KHR = $8252;
  GL_GUILTY_CONTEXT_RESET = $8253;
  GL_GUILTY_CONTEXT_RESET_ARB = $8253;
  GL_GUILTY_CONTEXT_RESET_EXT = $8253;
  GL_GUILTY_CONTEXT_RESET_KHR = $8253;
  GL_INNOCENT_CONTEXT_RESET = $8254;
  GL_INNOCENT_CONTEXT_RESET_ARB = $8254;
  GL_INNOCENT_CONTEXT_RESET_EXT = $8254;
  GL_INNOCENT_CONTEXT_RESET_KHR = $8254;
  GL_UNKNOWN_CONTEXT_RESET = $8255;
  GL_UNKNOWN_CONTEXT_RESET_ARB = $8255;
  GL_UNKNOWN_CONTEXT_RESET_EXT = $8255;
  GL_UNKNOWN_CONTEXT_RESET_KHR = $8255;
  GL_RESET_NOTIFICATION_STRATEGY = $8256;
  GL_RESET_NOTIFICATION_STRATEGY_ARB = $8256;
  GL_RESET_NOTIFICATION_STRATEGY_EXT = $8256;
  GL_RESET_NOTIFICATION_STRATEGY_KHR = $8256;
  GL_PROGRAM_BINARY_RETRIEVABLE_HINT = $8257;
  GL_PROGRAM_SEPARABLE = $8258;
  GL_PROGRAM_SEPARABLE_EXT = $8258;
  GL_ACTIVE_PROGRAM = $8259;
  GL_PROGRAM_PIPELINE_BINDING = $825A;
  GL_PROGRAM_PIPELINE_BINDING_EXT = $825A;
  GL_MAX_VIEWPORTS = $825B;
  GL_MAX_VIEWPORTS_NV = $825B;
  GL_MAX_VIEWPORTS_OES = $825B;
  GL_VIEWPORT_SUBPIXEL_BITS = $825C;
  GL_VIEWPORT_SUBPIXEL_BITS_EXT = $825C;
  GL_VIEWPORT_SUBPIXEL_BITS_NV = $825C;
  GL_VIEWPORT_SUBPIXEL_BITS_OES = $825C;
  GL_VIEWPORT_BOUNDS_RANGE = $825D;
  GL_VIEWPORT_BOUNDS_RANGE_EXT = $825D;
  GL_VIEWPORT_BOUNDS_RANGE_NV = $825D;
  GL_VIEWPORT_BOUNDS_RANGE_OES = $825D;
  GL_LAYER_PROVOKING_VERTEX = $825E;
  GL_LAYER_PROVOKING_VERTEX_EXT = $825E;
  GL_LAYER_PROVOKING_VERTEX_OES = $825E;
  GL_VIEWPORT_INDEX_PROVOKING_VERTEX = $825F;
  GL_VIEWPORT_INDEX_PROVOKING_VERTEX_EXT = $825F;
  GL_VIEWPORT_INDEX_PROVOKING_VERTEX_NV = $825F;
  GL_VIEWPORT_INDEX_PROVOKING_VERTEX_OES = $825F;
  GL_UNDEFINED_VERTEX = $8260;
  GL_UNDEFINED_VERTEX_EXT = $8260;
  GL_UNDEFINED_VERTEX_OES = $8260;
  GL_NO_RESET_NOTIFICATION = $8261;
  GL_NO_RESET_NOTIFICATION_ARB = $8261;
  GL_NO_RESET_NOTIFICATION_EXT = $8261;
  GL_NO_RESET_NOTIFICATION_KHR = $8261;
  GL_MAX_COMPUTE_SHARED_MEMORY_SIZE = $8262;
  GL_MAX_COMPUTE_UNIFORM_COMPONENTS = $8263;
  GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = $8264;
  GL_MAX_COMPUTE_ATOMIC_COUNTERS = $8265;
  GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = $8266;
  GL_COMPUTE_WORK_GROUP_SIZE = $8267;
  GL_DEBUG_TYPE_MARKER = $8268;
  GL_DEBUG_TYPE_MARKER_KHR = $8268;
  GL_DEBUG_TYPE_PUSH_GROUP = $8269;
  GL_DEBUG_TYPE_PUSH_GROUP_KHR = $8269;
  GL_DEBUG_TYPE_POP_GROUP = $826A;
  GL_DEBUG_TYPE_POP_GROUP_KHR = $826A;
  GL_DEBUG_SEVERITY_NOTIFICATION = $826B;
  GL_DEBUG_SEVERITY_NOTIFICATION_KHR = $826B;
  GL_MAX_DEBUG_GROUP_STACK_DEPTH = $826C;
  GL_MAX_DEBUG_GROUP_STACK_DEPTH_KHR = $826C;
  GL_DEBUG_GROUP_STACK_DEPTH = $826D;
  GL_DEBUG_GROUP_STACK_DEPTH_KHR = $826D;
  GL_MAX_UNIFORM_LOCATIONS = $826E;
  GL_INTERNALFORMAT_SUPPORTED = $826F;
  GL_INTERNALFORMAT_PREFERRED = $8270;
  GL_INTERNALFORMAT_RED_SIZE = $8271;
  GL_INTERNALFORMAT_GREEN_SIZE = $8272;
  GL_INTERNALFORMAT_BLUE_SIZE = $8273;
  GL_INTERNALFORMAT_ALPHA_SIZE = $8274;
  GL_INTERNALFORMAT_DEPTH_SIZE = $8275;
  GL_INTERNALFORMAT_STENCIL_SIZE = $8276;
  GL_INTERNALFORMAT_SHARED_SIZE = $8277;
  GL_INTERNALFORMAT_RED_TYPE = $8278;
  GL_INTERNALFORMAT_GREEN_TYPE = $8279;
  GL_INTERNALFORMAT_BLUE_TYPE = $827A;
  GL_INTERNALFORMAT_ALPHA_TYPE = $827B;
  GL_INTERNALFORMAT_DEPTH_TYPE = $827C;
  GL_INTERNALFORMAT_STENCIL_TYPE = $827D;
  GL_MAX_WIDTH = $827E;
  GL_MAX_HEIGHT = $827F;
  GL_MAX_DEPTH = $8280;
  GL_MAX_LAYERS = $8281;
  GL_MAX_COMBINED_DIMENSIONS = $8282;
  GL_COLOR_COMPONENTS = $8283;
  GL_DEPTH_COMPONENTS = $8284;
  GL_STENCIL_COMPONENTS = $8285;
  GL_COLOR_RENDERABLE = $8286;
  GL_DEPTH_RENDERABLE = $8287;
  GL_STENCIL_RENDERABLE = $8288;
  GL_FRAMEBUFFER_RENDERABLE = $8289;
  GL_FRAMEBUFFER_RENDERABLE_LAYERED = $828A;
  GL_FRAMEBUFFER_BLEND = $828B;
  GL_READ_PIXELS = $828C;
  GL_READ_PIXELS_FORMAT = $828D;
  GL_READ_PIXELS_TYPE = $828E;
  GL_TEXTURE_IMAGE_FORMAT = $828F;
  GL_TEXTURE_IMAGE_TYPE = $8290;
  GL_GET_TEXTURE_IMAGE_FORMAT = $8291;
  GL_GET_TEXTURE_IMAGE_TYPE = $8292;
  GL_MIPMAP = $8293;
  GL_MANUAL_GENERATE_MIPMAP = $8294;
  GL_AUTO_GENERATE_MIPMAP = $8295;
  GL_COLOR_ENCODING = $8296;
  GL_SRGB_READ = $8297;
  GL_SRGB_WRITE = $8298;
  GL_SRGB_DECODE_ARB = $8299;
  GL_FILTER = $829A;
  GL_VERTEX_TEXTURE = $829B;
  GL_TESS_CONTROL_TEXTURE = $829C;
  GL_TESS_EVALUATION_TEXTURE = $829D;
  GL_GEOMETRY_TEXTURE = $829E;
  GL_FRAGMENT_TEXTURE = $829F;
  GL_COMPUTE_TEXTURE = $82A0;
  GL_TEXTURE_SHADOW = $82A1;
  GL_TEXTURE_GATHER = $82A2;
  GL_TEXTURE_GATHER_SHADOW = $82A3;
  GL_SHADER_IMAGE_LOAD = $82A4;
  GL_SHADER_IMAGE_STORE = $82A5;
  GL_SHADER_IMAGE_ATOMIC = $82A6;
  GL_IMAGE_TEXEL_SIZE = $82A7;
  GL_IMAGE_COMPATIBILITY_CLASS = $82A8;
  GL_IMAGE_PIXEL_FORMAT = $82A9;
  GL_IMAGE_PIXEL_TYPE = $82AA;
  GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST = $82AC;
  GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST = $82AD;
  GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE = $82AE;
  GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE = $82AF;
  GL_TEXTURE_COMPRESSED_BLOCK_WIDTH = $82B1;
  GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT = $82B2;
  GL_TEXTURE_COMPRESSED_BLOCK_SIZE = $82B3;
  GL_CLEAR_BUFFER = $82B4;
  GL_TEXTURE_VIEW = $82B5;
  GL_VIEW_COMPATIBILITY_CLASS = $82B6;
  GL_FULL_SUPPORT = $82B7;
  GL_CAVEAT_SUPPORT = $82B8;
  GL_IMAGE_CLASS_4_X_32 = $82B9;
  GL_IMAGE_CLASS_2_X_32 = $82BA;
  GL_IMAGE_CLASS_1_X_32 = $82BB;
  GL_IMAGE_CLASS_4_X_16 = $82BC;
  GL_IMAGE_CLASS_2_X_16 = $82BD;
  GL_IMAGE_CLASS_1_X_16 = $82BE;
  GL_IMAGE_CLASS_4_X_8 = $82BF;
  GL_IMAGE_CLASS_2_X_8 = $82C0;
  GL_IMAGE_CLASS_1_X_8 = $82C1;
  GL_IMAGE_CLASS_11_11_10 = $82C2;
  GL_IMAGE_CLASS_10_10_10_2 = $82C3;
  GL_VIEW_CLASS_128_BITS = $82C4;
  GL_VIEW_CLASS_96_BITS = $82C5;
  GL_VIEW_CLASS_64_BITS = $82C6;
  GL_VIEW_CLASS_48_BITS = $82C7;
  GL_VIEW_CLASS_32_BITS = $82C8;
  GL_VIEW_CLASS_24_BITS = $82C9;
  GL_VIEW_CLASS_16_BITS = $82CA;
  GL_VIEW_CLASS_8_BITS = $82CB;
  GL_VIEW_CLASS_S3TC_DXT1_RGB = $82CC;
  GL_VIEW_CLASS_S3TC_DXT1_RGBA = $82CD;
  GL_VIEW_CLASS_S3TC_DXT3_RGBA = $82CE;
  GL_VIEW_CLASS_S3TC_DXT5_RGBA = $82CF;
  GL_VIEW_CLASS_RGTC1_RED = $82D0;
  GL_VIEW_CLASS_RGTC2_RG = $82D1;
  GL_VIEW_CLASS_BPTC_UNORM = $82D2;
  GL_VIEW_CLASS_BPTC_FLOAT = $82D3;
  GL_VERTEX_ATTRIB_BINDING = $82D4;
  GL_VERTEX_ATTRIB_RELATIVE_OFFSET = $82D5;
  GL_VERTEX_BINDING_DIVISOR = $82D6;
  GL_VERTEX_BINDING_OFFSET = $82D7;
  GL_VERTEX_BINDING_STRIDE = $82D8;
  GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = $82D9;
  GL_MAX_VERTEX_ATTRIB_BINDINGS = $82DA;
  GL_TEXTURE_VIEW_MIN_LEVEL = $82DB;
  GL_TEXTURE_VIEW_MIN_LEVEL_EXT = $82DB;
  GL_TEXTURE_VIEW_MIN_LEVEL_OES = $82DB;
  GL_TEXTURE_VIEW_NUM_LEVELS = $82DC;
  GL_TEXTURE_VIEW_NUM_LEVELS_EXT = $82DC;
  GL_TEXTURE_VIEW_NUM_LEVELS_OES = $82DC;
  GL_TEXTURE_VIEW_MIN_LAYER = $82DD;
  GL_TEXTURE_VIEW_MIN_LAYER_EXT = $82DD;
  GL_TEXTURE_VIEW_MIN_LAYER_OES = $82DD;
  GL_TEXTURE_VIEW_NUM_LAYERS = $82DE;
  GL_TEXTURE_VIEW_NUM_LAYERS_EXT = $82DE;
  GL_TEXTURE_VIEW_NUM_LAYERS_OES = $82DE;
  GL_TEXTURE_IMMUTABLE_LEVELS = $82DF;
  GL_BUFFER = $82E0;
  GL_BUFFER_KHR = $82E0;
  GL_SHADER = $82E1;
  GL_SHADER_KHR = $82E1;
  GL_PROGRAM = $82E2;
  GL_PROGRAM_KHR = $82E2;
  GL_QUERY = $82E3;
  GL_QUERY_KHR = $82E3;
  GL_PROGRAM_PIPELINE = $82E4;
  GL_PROGRAM_PIPELINE_KHR = $82E4;
  GL_MAX_VERTEX_ATTRIB_STRIDE = $82E5;
  GL_SAMPLER = $82E6;
  GL_SAMPLER_KHR = $82E6;
  GL_DISPLAY_LIST = $82E7;
  GL_MAX_LABEL_LENGTH = $82E8;
  GL_MAX_LABEL_LENGTH_KHR = $82E8;
  GL_NUM_SHADING_LANGUAGE_VERSIONS = $82E9;
  GL_QUERY_TARGET = $82EA;
  GL_TRANSFORM_FEEDBACK_OVERFLOW = $82EC;
  GL_TRANSFORM_FEEDBACK_OVERFLOW_ARB = $82EC;
  GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW = $82ED;
  GL_TRANSFORM_FEEDBACK_STREAM_OVERFLOW_ARB = $82ED;
  GL_VERTICES_SUBMITTED = $82EE;
  GL_VERTICES_SUBMITTED_ARB = $82EE;
  GL_PRIMITIVES_SUBMITTED = $82EF;
  GL_PRIMITIVES_SUBMITTED_ARB = $82EF;
  GL_VERTEX_SHADER_INVOCATIONS = $82F0;
  GL_VERTEX_SHADER_INVOCATIONS_ARB = $82F0;
  GL_TESS_CONTROL_SHADER_PATCHES = $82F1;
  GL_TESS_CONTROL_SHADER_PATCHES_ARB = $82F1;
  GL_TESS_EVALUATION_SHADER_INVOCATIONS = $82F2;
  GL_TESS_EVALUATION_SHADER_INVOCATIONS_ARB = $82F2;
  GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED = $82F3;
  GL_GEOMETRY_SHADER_PRIMITIVES_EMITTED_ARB = $82F3;
  GL_FRAGMENT_SHADER_INVOCATIONS = $82F4;
  GL_FRAGMENT_SHADER_INVOCATIONS_ARB = $82F4;
  GL_COMPUTE_SHADER_INVOCATIONS = $82F5;
  GL_COMPUTE_SHADER_INVOCATIONS_ARB = $82F5;
  GL_CLIPPING_INPUT_PRIMITIVES = $82F6;
  GL_CLIPPING_INPUT_PRIMITIVES_ARB = $82F6;
  GL_CLIPPING_OUTPUT_PRIMITIVES = $82F7;
  GL_CLIPPING_OUTPUT_PRIMITIVES_ARB = $82F7;
  GL_SPARSE_BUFFER_PAGE_SIZE_ARB = $82F8;
  GL_MAX_CULL_DISTANCES = $82F9;
  GL_MAX_CULL_DISTANCES_EXT = $82F9;
  GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES = $82FA;
  GL_MAX_COMBINED_CLIP_AND_CULL_DISTANCES_EXT = $82FA;
  GL_CONTEXT_RELEASE_BEHAVIOR = $82FB;
  GL_CONTEXT_RELEASE_BEHAVIOR_KHR = $82FB;
  GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH = $82FC;
  GL_CONTEXT_RELEASE_BEHAVIOR_FLUSH_KHR = $82FC;
  GL_DEPTH_PASS_INSTRUMENT_SGIX = $8310;
  GL_DEPTH_PASS_INSTRUMENT_COUNTERS_SGIX = $8311;
  GL_DEPTH_PASS_INSTRUMENT_MAX_SGIX = $8312;
  GL_FRAGMENTS_INSTRUMENT_SGIX = $8313;
  GL_FRAGMENTS_INSTRUMENT_COUNTERS_SGIX = $8314;
  GL_FRAGMENTS_INSTRUMENT_MAX_SGIX = $8315;
  GL_CONVOLUTION_HINT_SGIX = $8316;
  GL_YCRCB_SGIX = $8318;
  GL_YCRCBA_SGIX = $8319;
  GL_UNPACK_COMPRESSED_SIZE_SGIX = $831A;
  GL_PACK_MAX_COMPRESSED_SIZE_SGIX = $831B;
  GL_PACK_COMPRESSED_SIZE_SGIX = $831C;
  GL_SLIM8U_SGIX = $831D;
  GL_SLIM10U_SGIX = $831E;
  GL_SLIM12S_SGIX = $831F;
  GL_ALPHA_MIN_SGIX = $8320;
  GL_ALPHA_MAX_SGIX = $8321;
  GL_SCALEBIAS_HINT_SGIX = $8322;
  GL_ASYNC_MARKER_SGIX = $8329;
  GL_PIXEL_TEX_GEN_MODE_SGIX = $832B;
  GL_ASYNC_HISTOGRAM_SGIX = $832C;
  GL_MAX_ASYNC_HISTOGRAM_SGIX = $832D;
  GL_PIXEL_TRANSFORM_2D_EXT = $8330;
  GL_PIXEL_MAG_FILTER_EXT = $8331;
  GL_PIXEL_MIN_FILTER_EXT = $8332;
  GL_PIXEL_CUBIC_WEIGHT_EXT = $8333;
  GL_CUBIC_EXT = $8334;
  GL_AVERAGE_EXT = $8335;
  GL_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT = $8336;
  GL_MAX_PIXEL_TRANSFORM_2D_STACK_DEPTH_EXT = $8337;
  GL_PIXEL_TRANSFORM_2D_MATRIX_EXT = $8338;
  GL_FRAGMENT_MATERIAL_EXT = $8349;
  GL_FRAGMENT_NORMAL_EXT = $834A;
  GL_FRAGMENT_COLOR_EXT = $834C;
  GL_ATTENUATION_EXT = $834D;
  GL_SHADOW_ATTENUATION_EXT = $834E;
  GL_TEXTURE_APPLICATION_MODE_EXT = $834F;
  GL_TEXTURE_LIGHT_EXT = $8350;
  GL_TEXTURE_MATERIAL_FACE_EXT = $8351;
  GL_TEXTURE_MATERIAL_PARAMETER_EXT = $8352;
  GL_PIXEL_TEXTURE_SGIS = $8353;
  GL_PIXEL_FRAGMENT_RGB_SOURCE_SGIS = $8354;
  GL_PIXEL_FRAGMENT_ALPHA_SOURCE_SGIS = $8355;
  GL_PIXEL_GROUP_COLOR_SGIS = $8356;
  GL_LINE_QUALITY_HINT_SGIX = $835B;
  GL_ASYNC_TEX_IMAGE_SGIX = $835C;
  GL_ASYNC_DRAW_PIXELS_SGIX = $835D;
  GL_ASYNC_READ_PIXELS_SGIX = $835E;
  GL_MAX_ASYNC_TEX_IMAGE_SGIX = $835F;
  GL_MAX_ASYNC_DRAW_PIXELS_SGIX = $8360;
  GL_MAX_ASYNC_READ_PIXELS_SGIX = $8361;
  GL_UNSIGNED_BYTE_2_3_3_REV = $8362;
  GL_UNSIGNED_BYTE_2_3_3_REV_EXT = $8362;
  GL_UNSIGNED_SHORT_5_6_5 = $8363;
  GL_UNSIGNED_SHORT_5_6_5_EXT = $8363;
  GL_UNSIGNED_SHORT_5_6_5_REV = $8364;
  GL_UNSIGNED_SHORT_5_6_5_REV_EXT = $8364;
  GL_UNSIGNED_SHORT_4_4_4_4_REV = $8365;
  GL_UNSIGNED_SHORT_4_4_4_4_REV_EXT = $8365;
  GL_UNSIGNED_SHORT_4_4_4_4_REV_IMG = $8365;
  GL_UNSIGNED_SHORT_1_5_5_5_REV = $8366;
  GL_UNSIGNED_SHORT_1_5_5_5_REV_EXT = $8366;
  GL_UNSIGNED_INT_8_8_8_8_REV = $8367;
  GL_UNSIGNED_INT_8_8_8_8_REV_EXT = $8367;
  GL_UNSIGNED_INT_2_10_10_10_REV = $8368;
  GL_UNSIGNED_INT_2_10_10_10_REV_EXT = $8368;
  GL_TEXTURE_MAX_CLAMP_S_SGIX = $8369;
  GL_TEXTURE_MAX_CLAMP_T_SGIX = $836A;
  GL_TEXTURE_MAX_CLAMP_R_SGIX = $836B;
  GL_MIRRORED_REPEAT = $8370;
  GL_MIRRORED_REPEAT_ARB = $8370;
  GL_MIRRORED_REPEAT_IBM = $8370;
  GL_MIRRORED_REPEAT_OES = $8370;
  GL_RGB_S3TC = $83A0;
  GL_RGB4_S3TC = $83A1;
  GL_RGBA_S3TC = $83A2;
  GL_RGBA4_S3TC = $83A3;
  GL_RGBA_DXT5_S3TC = $83A4;
  GL_RGBA4_DXT5_S3TC = $83A5;
  GL_VERTEX_PRECLIP_SGIX = $83EE;
  GL_VERTEX_PRECLIP_HINT_SGIX = $83EF;
  GL_COMPRESSED_RGB_S3TC_DXT1_EXT = $83F0;
  GL_COMPRESSED_RGBA_S3TC_DXT1_EXT = $83F1;
  GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE = $83F2;
  GL_COMPRESSED_RGBA_S3TC_DXT3_EXT = $83F2;
  GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE = $83F3;
  GL_COMPRESSED_RGBA_S3TC_DXT5_EXT = $83F3;
  GL_PARALLEL_ARRAYS_INTEL = $83F4;
  GL_VERTEX_ARRAY_PARALLEL_POINTERS_INTEL = $83F5;
  GL_NORMAL_ARRAY_PARALLEL_POINTERS_INTEL = $83F6;
  GL_COLOR_ARRAY_PARALLEL_POINTERS_INTEL = $83F7;
  GL_TEXTURE_COORD_ARRAY_PARALLEL_POINTERS_INTEL = $83F8;
  GL_PERFQUERY_DONOT_FLUSH_INTEL = $83F9;
  GL_PERFQUERY_FLUSH_INTEL = $83FA;
  GL_PERFQUERY_WAIT_INTEL = $83FB;
  GL_CONSERVATIVE_RASTERIZATION_INTEL = $83FE;
  GL_TEXTURE_MEMORY_LAYOUT_INTEL = $83FF;
  GL_FRAGMENT_LIGHTING_SGIX = $8400;
  GL_FRAGMENT_COLOR_MATERIAL_SGIX = $8401;
  GL_FRAGMENT_COLOR_MATERIAL_FACE_SGIX = $8402;
  GL_FRAGMENT_COLOR_MATERIAL_PARAMETER_SGIX = $8403;
  GL_MAX_FRAGMENT_LIGHTS_SGIX = $8404;
  GL_MAX_ACTIVE_LIGHTS_SGIX = $8405;
  GL_CURRENT_RASTER_NORMAL_SGIX = $8406;
  GL_LIGHT_ENV_MODE_SGIX = $8407;
  GL_FRAGMENT_LIGHT_MODEL_LOCAL_VIEWER_SGIX = $8408;
  GL_FRAGMENT_LIGHT_MODEL_TWO_SIDE_SGIX = $8409;
  GL_FRAGMENT_LIGHT_MODEL_AMBIENT_SGIX = $840A;
  GL_FRAGMENT_LIGHT_MODEL_NORMAL_INTERPOLATION_SGIX = $840B;
  GL_FRAGMENT_LIGHT0_SGIX = $840C;
  GL_FRAGMENT_LIGHT1_SGIX = $840D;
  GL_FRAGMENT_LIGHT2_SGIX = $840E;
  GL_FRAGMENT_LIGHT3_SGIX = $840F;
  GL_FRAGMENT_LIGHT4_SGIX = $8410;
  GL_FRAGMENT_LIGHT5_SGIX = $8411;
  GL_FRAGMENT_LIGHT6_SGIX = $8412;
  GL_FRAGMENT_LIGHT7_SGIX = $8413;
  GL_PACK_RESAMPLE_SGIX = $842E;
  GL_UNPACK_RESAMPLE_SGIX = $842F;
  GL_RESAMPLE_DECIMATE_SGIX = $8430;
  GL_RESAMPLE_REPLICATE_SGIX = $8433;
  GL_RESAMPLE_ZERO_FILL_SGIX = $8434;
  GL_TANGENT_ARRAY_EXT = $8439;
  GL_BINORMAL_ARRAY_EXT = $843A;
  GL_CURRENT_TANGENT_EXT = $843B;
  GL_CURRENT_BINORMAL_EXT = $843C;
  GL_TANGENT_ARRAY_TYPE_EXT = $843E;
  GL_TANGENT_ARRAY_STRIDE_EXT = $843F;
  GL_BINORMAL_ARRAY_TYPE_EXT = $8440;
  GL_BINORMAL_ARRAY_STRIDE_EXT = $8441;
  GL_TANGENT_ARRAY_POINTER_EXT = $8442;
  GL_BINORMAL_ARRAY_POINTER_EXT = $8443;
  GL_MAP1_TANGENT_EXT = $8444;
  GL_MAP2_TANGENT_EXT = $8445;
  GL_MAP1_BINORMAL_EXT = $8446;
  GL_MAP2_BINORMAL_EXT = $8447;
  GL_NEAREST_CLIPMAP_NEAREST_SGIX = $844D;
  GL_NEAREST_CLIPMAP_LINEAR_SGIX = $844E;
  GL_LINEAR_CLIPMAP_NEAREST_SGIX = $844F;
  GL_FOG_COORDINATE_SOURCE = $8450;
  GL_FOG_COORDINATE_SOURCE_EXT = $8450;
  GL_FOG_COORD_SRC = $8450;
  GL_FOG_COORDINATE = $8451;
  GL_FOG_COORD = $8451;
  GL_FOG_COORDINATE_EXT = $8451;
  GL_FRAGMENT_DEPTH = $8452;
  GL_FRAGMENT_DEPTH_EXT = $8452;
  GL_CURRENT_FOG_COORDINATE = $8453;
  GL_CURRENT_FOG_COORD = $8453;
  GL_CURRENT_FOG_COORDINATE_EXT = $8453;
  GL_FOG_COORDINATE_ARRAY_TYPE = $8454;
  GL_FOG_COORDINATE_ARRAY_TYPE_EXT = $8454;
  GL_FOG_COORD_ARRAY_TYPE = $8454;
  GL_FOG_COORDINATE_ARRAY_STRIDE = $8455;
  GL_FOG_COORDINATE_ARRAY_STRIDE_EXT = $8455;
  GL_FOG_COORD_ARRAY_STRIDE = $8455;
  GL_FOG_COORDINATE_ARRAY_POINTER = $8456;
  GL_FOG_COORDINATE_ARRAY_POINTER_EXT = $8456;
  GL_FOG_COORD_ARRAY_POINTER = $8456;
  GL_FOG_COORDINATE_ARRAY = $8457;
  GL_FOG_COORDINATE_ARRAY_EXT = $8457;
  GL_FOG_COORD_ARRAY = $8457;
  GL_COLOR_SUM = $8458;
  GL_COLOR_SUM_ARB = $8458;
  GL_COLOR_SUM_EXT = $8458;
  GL_CURRENT_SECONDARY_COLOR = $8459;
  GL_CURRENT_SECONDARY_COLOR_EXT = $8459;
  GL_SECONDARY_COLOR_ARRAY_SIZE = $845A;
  GL_SECONDARY_COLOR_ARRAY_SIZE_EXT = $845A;
  GL_SECONDARY_COLOR_ARRAY_TYPE = $845B;
  GL_SECONDARY_COLOR_ARRAY_TYPE_EXT = $845B;
  GL_SECONDARY_COLOR_ARRAY_STRIDE = $845C;
  GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT = $845C;
  GL_SECONDARY_COLOR_ARRAY_POINTER = $845D;
  GL_SECONDARY_COLOR_ARRAY_POINTER_EXT = $845D;
  GL_SECONDARY_COLOR_ARRAY = $845E;
  GL_SECONDARY_COLOR_ARRAY_EXT = $845E;
  GL_CURRENT_RASTER_SECONDARY_COLOR = $845F;
  GL_ALIASED_POINT_SIZE_RANGE = $846D;
  GL_ALIASED_LINE_WIDTH_RANGE = $846E;
  GL_SCREEN_COORDINATES_REND = $8490;
  GL_INVERTED_SCREEN_W_REND = $8491;
  GL_TEXTURE0 = $84C0;
  GL_TEXTURE0_ARB = $84C0;
  GL_TEXTURE1 = $84C1;
  GL_TEXTURE1_ARB = $84C1;
  GL_TEXTURE2 = $84C2;
  GL_TEXTURE2_ARB = $84C2;
  GL_TEXTURE3 = $84C3;
  GL_TEXTURE3_ARB = $84C3;
  GL_TEXTURE4 = $84C4;
  GL_TEXTURE4_ARB = $84C4;
  GL_TEXTURE5 = $84C5;
  GL_TEXTURE5_ARB = $84C5;
  GL_TEXTURE6 = $84C6;
  GL_TEXTURE6_ARB = $84C6;
  GL_TEXTURE7 = $84C7;
  GL_TEXTURE7_ARB = $84C7;
  GL_TEXTURE8 = $84C8;
  GL_TEXTURE8_ARB = $84C8;
  GL_TEXTURE9 = $84C9;
  GL_TEXTURE9_ARB = $84C9;
  GL_TEXTURE10 = $84CA;
  GL_TEXTURE10_ARB = $84CA;
  GL_TEXTURE11 = $84CB;
  GL_TEXTURE11_ARB = $84CB;
  GL_TEXTURE12 = $84CC;
  GL_TEXTURE12_ARB = $84CC;
  GL_TEXTURE13 = $84CD;
  GL_TEXTURE13_ARB = $84CD;
  GL_TEXTURE14 = $84CE;
  GL_TEXTURE14_ARB = $84CE;
  GL_TEXTURE15 = $84CF;
  GL_TEXTURE15_ARB = $84CF;
  GL_TEXTURE16 = $84D0;
  GL_TEXTURE16_ARB = $84D0;
  GL_TEXTURE17 = $84D1;
  GL_TEXTURE17_ARB = $84D1;
  GL_TEXTURE18 = $84D2;
  GL_TEXTURE18_ARB = $84D2;
  GL_TEXTURE19 = $84D3;
  GL_TEXTURE19_ARB = $84D3;
  GL_TEXTURE20 = $84D4;
  GL_TEXTURE20_ARB = $84D4;
  GL_TEXTURE21 = $84D5;
  GL_TEXTURE21_ARB = $84D5;
  GL_TEXTURE22 = $84D6;
  GL_TEXTURE22_ARB = $84D6;
  GL_TEXTURE23 = $84D7;
  GL_TEXTURE23_ARB = $84D7;
  GL_TEXTURE24 = $84D8;
  GL_TEXTURE24_ARB = $84D8;
  GL_TEXTURE25 = $84D9;
  GL_TEXTURE25_ARB = $84D9;
  GL_TEXTURE26 = $84DA;
  GL_TEXTURE26_ARB = $84DA;
  GL_TEXTURE27 = $84DB;
  GL_TEXTURE27_ARB = $84DB;
  GL_TEXTURE28 = $84DC;
  GL_TEXTURE28_ARB = $84DC;
  GL_TEXTURE29 = $84DD;
  GL_TEXTURE29_ARB = $84DD;
  GL_TEXTURE30 = $84DE;
  GL_TEXTURE30_ARB = $84DE;
  GL_TEXTURE31 = $84DF;
  GL_TEXTURE31_ARB = $84DF;
  GL_ACTIVE_TEXTURE = $84E0;
  GL_ACTIVE_TEXTURE_ARB = $84E0;
  GL_CLIENT_ACTIVE_TEXTURE = $84E1;
  GL_CLIENT_ACTIVE_TEXTURE_ARB = $84E1;
  GL_MAX_TEXTURE_UNITS = $84E2;
  GL_MAX_TEXTURE_UNITS_ARB = $84E2;
  GL_TRANSPOSE_MODELVIEW_MATRIX = $84E3;
  GL_TRANSPOSE_MODELVIEW_MATRIX_ARB = $84E3;
  GL_PATH_TRANSPOSE_MODELVIEW_MATRIX_NV = $84E3;
  GL_TRANSPOSE_PROJECTION_MATRIX = $84E4;
  GL_TRANSPOSE_PROJECTION_MATRIX_ARB = $84E4;
  GL_PATH_TRANSPOSE_PROJECTION_MATRIX_NV = $84E4;
  GL_TRANSPOSE_TEXTURE_MATRIX = $84E5;
  GL_TRANSPOSE_TEXTURE_MATRIX_ARB = $84E5;
  GL_TRANSPOSE_COLOR_MATRIX = $84E6;
  GL_TRANSPOSE_COLOR_MATRIX_ARB = $84E6;
  GL_SUBTRACT = $84E7;
  GL_SUBTRACT_ARB = $84E7;
  GL_MAX_RENDERBUFFER_SIZE = $84E8;
  GL_MAX_RENDERBUFFER_SIZE_EXT = $84E8;
  GL_MAX_RENDERBUFFER_SIZE_OES = $84E8;
  GL_COMPRESSED_ALPHA = $84E9;
  GL_COMPRESSED_ALPHA_ARB = $84E9;
  GL_COMPRESSED_LUMINANCE = $84EA;
  GL_COMPRESSED_LUMINANCE_ARB = $84EA;
  GL_COMPRESSED_LUMINANCE_ALPHA = $84EB;
  GL_COMPRESSED_LUMINANCE_ALPHA_ARB = $84EB;
  GL_COMPRESSED_INTENSITY = $84EC;
  GL_COMPRESSED_INTENSITY_ARB = $84EC;
  GL_COMPRESSED_RGB = $84ED;
  GL_COMPRESSED_RGB_ARB = $84ED;
  GL_COMPRESSED_RGBA = $84EE;
  GL_COMPRESSED_RGBA_ARB = $84EE;
  GL_TEXTURE_COMPRESSION_HINT = $84EF;
  GL_TEXTURE_COMPRESSION_HINT_ARB = $84EF;
  GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = $84F0;
  GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = $84F1;
  GL_ALL_COMPLETED_NV = $84F2;
  GL_FENCE_STATUS_NV = $84F3;
  GL_FENCE_CONDITION_NV = $84F4;
  GL_TEXTURE_RECTANGLE = $84F5;
  GL_TEXTURE_RECTANGLE_ARB = $84F5;
  GL_TEXTURE_RECTANGLE_NV = $84F5;
  GL_TEXTURE_BINDING_RECTANGLE = $84F6;
  GL_TEXTURE_BINDING_RECTANGLE_ARB = $84F6;
  GL_TEXTURE_BINDING_RECTANGLE_NV = $84F6;
  GL_PROXY_TEXTURE_RECTANGLE = $84F7;
  GL_PROXY_TEXTURE_RECTANGLE_ARB = $84F7;
  GL_PROXY_TEXTURE_RECTANGLE_NV = $84F7;
  GL_MAX_RECTANGLE_TEXTURE_SIZE = $84F8;
  GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB = $84F8;
  GL_MAX_RECTANGLE_TEXTURE_SIZE_NV = $84F8;
  GL_DEPTH_STENCIL = $84F9;
  GL_DEPTH_STENCIL_EXT = $84F9;
  GL_DEPTH_STENCIL_NV = $84F9;
  GL_DEPTH_STENCIL_OES = $84F9;
  GL_UNSIGNED_INT_24_8 = $84FA;
  GL_UNSIGNED_INT_24_8_EXT = $84FA;
  GL_UNSIGNED_INT_24_8_NV = $84FA;
  GL_UNSIGNED_INT_24_8_OES = $84FA;
  GL_MAX_TEXTURE_LOD_BIAS = $84FD;
  GL_MAX_TEXTURE_LOD_BIAS_EXT = $84FD;
  GL_TEXTURE_MAX_ANISOTROPY = $84FE;
  GL_TEXTURE_MAX_ANISOTROPY_EXT = $84FE;
  GL_MAX_TEXTURE_MAX_ANISOTROPY = $84FF;
  GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT = $84FF;
  GL_TEXTURE_FILTER_CONTROL = $8500;
  GL_TEXTURE_FILTER_CONTROL_EXT = $8500;
  GL_TEXTURE_LOD_BIAS = $8501;
  GL_TEXTURE_LOD_BIAS_EXT = $8501;
  GL_MODELVIEW1_STACK_DEPTH_EXT = $8502;
  GL_COMBINE4_NV = $8503;
  GL_MAX_SHININESS_NV = $8504;
  GL_MAX_SPOT_EXPONENT_NV = $8505;
  GL_MODELVIEW1_MATRIX_EXT = $8506;
  GL_INCR_WRAP = $8507;
  GL_INCR_WRAP_EXT = $8507;
  GL_INCR_WRAP_OES = $8507;
  GL_DECR_WRAP = $8508;
  GL_DECR_WRAP_EXT = $8508;
  GL_DECR_WRAP_OES = $8508;
  GL_VERTEX_WEIGHTING_EXT = $8509;
  GL_MODELVIEW1_ARB = $850A;
  GL_MODELVIEW1_EXT = $850A;
  GL_CURRENT_VERTEX_WEIGHT_EXT = $850B;
  GL_VERTEX_WEIGHT_ARRAY_EXT = $850C;
  GL_VERTEX_WEIGHT_ARRAY_SIZE_EXT = $850D;
  GL_VERTEX_WEIGHT_ARRAY_TYPE_EXT = $850E;
  GL_VERTEX_WEIGHT_ARRAY_STRIDE_EXT = $850F;
  GL_VERTEX_WEIGHT_ARRAY_POINTER_EXT = $8510;
  GL_NORMAL_MAP = $8511;
  GL_NORMAL_MAP_ARB = $8511;
  GL_NORMAL_MAP_EXT = $8511;
  GL_NORMAL_MAP_NV = $8511;
  GL_NORMAL_MAP_OES = $8511;
  GL_REFLECTION_MAP = $8512;
  GL_REFLECTION_MAP_ARB = $8512;
  GL_REFLECTION_MAP_EXT = $8512;
  GL_REFLECTION_MAP_NV = $8512;
  GL_REFLECTION_MAP_OES = $8512;
  GL_TEXTURE_CUBE_MAP = $8513;
  GL_TEXTURE_CUBE_MAP_ARB = $8513;
  GL_TEXTURE_CUBE_MAP_EXT = $8513;
  GL_TEXTURE_CUBE_MAP_OES = $8513;
  GL_TEXTURE_BINDING_CUBE_MAP = $8514;
  GL_TEXTURE_BINDING_CUBE_MAP_ARB = $8514;
  GL_TEXTURE_BINDING_CUBE_MAP_EXT = $8514;
  GL_TEXTURE_BINDING_CUBE_MAP_OES = $8514;
  GL_TEXTURE_CUBE_MAP_POSITIVE_X = $8515;
  GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB = $8515;
  GL_TEXTURE_CUBE_MAP_POSITIVE_X_EXT = $8515;
  GL_TEXTURE_CUBE_MAP_POSITIVE_X_OES = $8515;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X = $8516;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB = $8516;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X_EXT = $8516;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_X_OES = $8516;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y = $8517;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB = $8517;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y_EXT = $8517;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Y_OES = $8517;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y = $8518;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB = $8518;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_EXT = $8518;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_OES = $8518;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z = $8519;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB = $8519;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z_EXT = $8519;
  GL_TEXTURE_CUBE_MAP_POSITIVE_Z_OES = $8519;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z = $851A;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB = $851A;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_EXT = $851A;
  GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_OES = $851A;
  GL_PROXY_TEXTURE_CUBE_MAP = $851B;
  GL_PROXY_TEXTURE_CUBE_MAP_ARB = $851B;
  GL_PROXY_TEXTURE_CUBE_MAP_EXT = $851B;
  GL_MAX_CUBE_MAP_TEXTURE_SIZE = $851C;
  GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB = $851C;
  GL_MAX_CUBE_MAP_TEXTURE_SIZE_EXT = $851C;
  GL_MAX_CUBE_MAP_TEXTURE_SIZE_OES = $851C;
  GL_VERTEX_ARRAY_RANGE_APPLE = $851D;
  GL_VERTEX_ARRAY_RANGE_NV = $851D;
  GL_VERTEX_ARRAY_RANGE_LENGTH_APPLE = $851E;
  GL_VERTEX_ARRAY_RANGE_LENGTH_NV = $851E;
  GL_VERTEX_ARRAY_RANGE_VALID_NV = $851F;
  GL_VERTEX_ARRAY_STORAGE_HINT_APPLE = $851F;
  GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV = $8520;
  GL_VERTEX_ARRAY_RANGE_POINTER_APPLE = $8521;
  GL_VERTEX_ARRAY_RANGE_POINTER_NV = $8521;
  GL_REGISTER_COMBINERS_NV = $8522;
  GL_VARIABLE_A_NV = $8523;
  GL_VARIABLE_B_NV = $8524;
  GL_VARIABLE_C_NV = $8525;
  GL_VARIABLE_D_NV = $8526;
  GL_VARIABLE_E_NV = $8527;
  GL_VARIABLE_F_NV = $8528;
  GL_VARIABLE_G_NV = $8529;
  GL_CONSTANT_COLOR0_NV = $852A;
  GL_CONSTANT_COLOR1_NV = $852B;
  GL_PRIMARY_COLOR_NV = $852C;
  GL_SECONDARY_COLOR_NV = $852D;
  GL_SPARE0_NV = $852E;
  GL_SPARE1_NV = $852F;
  GL_DISCARD_NV = $8530;
  GL_E_TIMES_F_NV = $8531;
  GL_SPARE0_PLUS_SECONDARY_COLOR_NV = $8532;
  GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV = $8533;
  GL_MULTISAMPLE_FILTER_HINT_NV = $8534;
  GL_PER_STAGE_CONSTANTS_NV = $8535;
  GL_UNSIGNED_IDENTITY_NV = $8536;
  GL_UNSIGNED_INVERT_NV = $8537;
  GL_EXPAND_NORMAL_NV = $8538;
  GL_EXPAND_NEGATE_NV = $8539;
  GL_HALF_BIAS_NORMAL_NV = $853A;
  GL_HALF_BIAS_NEGATE_NV = $853B;
  GL_SIGNED_IDENTITY_NV = $853C;
  GL_SIGNED_NEGATE_NV = $853D;
  GL_SCALE_BY_TWO_NV = $853E;
  GL_SCALE_BY_FOUR_NV = $853F;
  GL_SCALE_BY_ONE_HALF_NV = $8540;
  GL_BIAS_BY_NEGATIVE_ONE_HALF_NV = $8541;
  GL_COMBINER_INPUT_NV = $8542;
  GL_COMBINER_MAPPING_NV = $8543;
  GL_COMBINER_COMPONENT_USAGE_NV = $8544;
  GL_COMBINER_AB_DOT_PRODUCT_NV = $8545;
  GL_COMBINER_CD_DOT_PRODUCT_NV = $8546;
  GL_COMBINER_MUX_SUM_NV = $8547;
  GL_COMBINER_SCALE_NV = $8548;
  GL_COMBINER_BIAS_NV = $8549;
  GL_COMBINER_AB_OUTPUT_NV = $854A;
  GL_COMBINER_CD_OUTPUT_NV = $854B;
  GL_COMBINER_SUM_OUTPUT_NV = $854C;
  GL_MAX_GENERAL_COMBINERS_NV = $854D;
  GL_NUM_GENERAL_COMBINERS_NV = $854E;
  GL_COLOR_SUM_CLAMP_NV = $854F;
  GL_COMBINER0_NV = $8550;
  GL_COMBINER1_NV = $8551;
  GL_COMBINER2_NV = $8552;
  GL_COMBINER3_NV = $8553;
  GL_COMBINER4_NV = $8554;
  GL_COMBINER5_NV = $8555;
  GL_COMBINER6_NV = $8556;
  GL_COMBINER7_NV = $8557;
  GL_PRIMITIVE_RESTART_NV = $8558;
  GL_PRIMITIVE_RESTART_INDEX_NV = $8559;
  GL_FOG_DISTANCE_MODE_NV = $855A;
  GL_EYE_RADIAL_NV = $855B;
  GL_EYE_PLANE_ABSOLUTE_NV = $855C;
  GL_EMBOSS_LIGHT_NV = $855D;
  GL_EMBOSS_CONSTANT_NV = $855E;
  GL_EMBOSS_MAP_NV = $855F;
  GL_RED_MIN_CLAMP_INGR = $8560;
  GL_GREEN_MIN_CLAMP_INGR = $8561;
  GL_BLUE_MIN_CLAMP_INGR = $8562;
  GL_ALPHA_MIN_CLAMP_INGR = $8563;
  GL_RED_MAX_CLAMP_INGR = $8564;
  GL_GREEN_MAX_CLAMP_INGR = $8565;
  GL_BLUE_MAX_CLAMP_INGR = $8566;
  GL_ALPHA_MAX_CLAMP_INGR = $8567;
  GL_INTERLACE_READ_INGR = $8568;
  GL_COMBINE = $8570;
  GL_COMBINE_ARB = $8570;
  GL_COMBINE_EXT = $8570;
  GL_COMBINE_RGB = $8571;
  GL_COMBINE_RGB_ARB = $8571;
  GL_COMBINE_RGB_EXT = $8571;
  GL_COMBINE_ALPHA = $8572;
  GL_COMBINE_ALPHA_ARB = $8572;
  GL_COMBINE_ALPHA_EXT = $8572;
  GL_RGB_SCALE = $8573;
  GL_RGB_SCALE_ARB = $8573;
  GL_RGB_SCALE_EXT = $8573;
  GL_ADD_SIGNED = $8574;
  GL_ADD_SIGNED_ARB = $8574;
  GL_ADD_SIGNED_EXT = $8574;
  GL_INTERPOLATE = $8575;
  GL_INTERPOLATE_ARB = $8575;
  GL_INTERPOLATE_EXT = $8575;
  GL_CONSTANT = $8576;
  GL_CONSTANT_ARB = $8576;
  GL_CONSTANT_EXT = $8576;
  GL_CONSTANT_NV = $8576;
  GL_PRIMARY_COLOR = $8577;
  GL_PRIMARY_COLOR_ARB = $8577;
  GL_PRIMARY_COLOR_EXT = $8577;
  GL_PREVIOUS = $8578;
  GL_PREVIOUS_ARB = $8578;
  GL_PREVIOUS_EXT = $8578;
  GL_SOURCE0_RGB = $8580;
  GL_SOURCE0_RGB_ARB = $8580;
  GL_SOURCE0_RGB_EXT = $8580;
  GL_SRC0_RGB = $8580;
  GL_SOURCE1_RGB = $8581;
  GL_SOURCE1_RGB_ARB = $8581;
  GL_SOURCE1_RGB_EXT = $8581;
  GL_SRC1_RGB = $8581;
  GL_SOURCE2_RGB = $8582;
  GL_SOURCE2_RGB_ARB = $8582;
  GL_SOURCE2_RGB_EXT = $8582;
  GL_SRC2_RGB = $8582;
  GL_SOURCE3_RGB_NV = $8583;
  GL_SOURCE0_ALPHA = $8588;
  GL_SOURCE0_ALPHA_ARB = $8588;
  GL_SOURCE0_ALPHA_EXT = $8588;
  GL_SRC0_ALPHA = $8588;
  GL_SOURCE1_ALPHA = $8589;
  GL_SOURCE1_ALPHA_ARB = $8589;
  GL_SOURCE1_ALPHA_EXT = $8589;
  GL_SRC1_ALPHA = $8589;
  GL_SRC1_ALPHA_EXT = $8589;
  GL_SOURCE2_ALPHA = $858A;
  GL_SOURCE2_ALPHA_ARB = $858A;
  GL_SOURCE2_ALPHA_EXT = $858A;
  GL_SRC2_ALPHA = $858A;
  GL_SOURCE3_ALPHA_NV = $858B;
  GL_OPERAND0_RGB = $8590;
  GL_OPERAND0_RGB_ARB = $8590;
  GL_OPERAND0_RGB_EXT = $8590;
  GL_OPERAND1_RGB = $8591;
  GL_OPERAND1_RGB_ARB = $8591;
  GL_OPERAND1_RGB_EXT = $8591;
  GL_OPERAND2_RGB = $8592;
  GL_OPERAND2_RGB_ARB = $8592;
  GL_OPERAND2_RGB_EXT = $8592;
  GL_OPERAND3_RGB_NV = $8593;
  GL_OPERAND0_ALPHA = $8598;
  GL_OPERAND0_ALPHA_ARB = $8598;
  GL_OPERAND0_ALPHA_EXT = $8598;
  GL_OPERAND1_ALPHA = $8599;
  GL_OPERAND1_ALPHA_ARB = $8599;
  GL_OPERAND1_ALPHA_EXT = $8599;
  GL_OPERAND2_ALPHA = $859A;
  GL_OPERAND2_ALPHA_ARB = $859A;
  GL_OPERAND2_ALPHA_EXT = $859A;
  GL_OPERAND3_ALPHA_NV = $859B;
  GL_PACK_SUBSAMPLE_RATE_SGIX = $85A0;
  GL_UNPACK_SUBSAMPLE_RATE_SGIX = $85A1;
  GL_PIXEL_SUBSAMPLE_4444_SGIX = $85A2;
  GL_PIXEL_SUBSAMPLE_2424_SGIX = $85A3;
  GL_PIXEL_SUBSAMPLE_4242_SGIX = $85A4;
  GL_PERTURB_EXT = $85AE;
  GL_TEXTURE_NORMAL_EXT = $85AF;
  GL_LIGHT_MODEL_SPECULAR_VECTOR_APPLE = $85B0;
  GL_TRANSFORM_HINT_APPLE = $85B1;
  GL_UNPACK_CLIENT_STORAGE_APPLE = $85B2;
  GL_BUFFER_OBJECT_APPLE = $85B3;
  GL_STORAGE_CLIENT_APPLE = $85B4;
  GL_VERTEX_ARRAY_BINDING = $85B5;
  GL_VERTEX_ARRAY_BINDING_APPLE = $85B5;
  GL_VERTEX_ARRAY_BINDING_OES = $85B5;
  GL_TEXTURE_RANGE_LENGTH_APPLE = $85B7;
  GL_TEXTURE_RANGE_POINTER_APPLE = $85B8;
  GL_YCBCR_422_APPLE = $85B9;
  GL_UNSIGNED_SHORT_8_8_APPLE = $85BA;
  GL_UNSIGNED_SHORT_8_8_MESA = $85BA;
  GL_UNSIGNED_SHORT_8_8_REV_APPLE = $85BB;
  GL_UNSIGNED_SHORT_8_8_REV_MESA = $85BB;
  GL_TEXTURE_STORAGE_HINT_APPLE = $85BC;
  GL_STORAGE_PRIVATE_APPLE = $85BD;
  GL_STORAGE_CACHED_APPLE = $85BE;
  GL_STORAGE_SHARED_APPLE = $85BF;
  GL_REPLACEMENT_CODE_ARRAY_SUN = $85C0;
  GL_REPLACEMENT_CODE_ARRAY_TYPE_SUN = $85C1;
  GL_REPLACEMENT_CODE_ARRAY_STRIDE_SUN = $85C2;
  GL_REPLACEMENT_CODE_ARRAY_POINTER_SUN = $85C3;
  GL_R1UI_V3F_SUN = $85C4;
  GL_R1UI_C4UB_V3F_SUN = $85C5;
  GL_R1UI_C3F_V3F_SUN = $85C6;
  GL_R1UI_N3F_V3F_SUN = $85C7;
  GL_R1UI_C4F_N3F_V3F_SUN = $85C8;
  GL_R1UI_T2F_V3F_SUN = $85C9;
  GL_R1UI_T2F_N3F_V3F_SUN = $85CA;
  GL_R1UI_T2F_C4F_N3F_V3F_SUN = $85CB;
  GL_SLICE_ACCUM_SUN = $85CC;
  GL_QUAD_MESH_SUN = $8614;
  GL_TRIANGLE_MESH_SUN = $8615;
  GL_VERTEX_PROGRAM_ARB = $8620;
  GL_VERTEX_PROGRAM_NV = $8620;
  GL_VERTEX_STATE_PROGRAM_NV = $8621;
  GL_VERTEX_ATTRIB_ARRAY_ENABLED = $8622;
  GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB = $8622;
  GL_ATTRIB_ARRAY_SIZE_NV = $8623;
  GL_VERTEX_ATTRIB_ARRAY_SIZE = $8623;
  GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB = $8623;
  GL_ATTRIB_ARRAY_STRIDE_NV = $8624;
  GL_VERTEX_ATTRIB_ARRAY_STRIDE = $8624;
  GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB = $8624;
  GL_ATTRIB_ARRAY_TYPE_NV = $8625;
  GL_VERTEX_ATTRIB_ARRAY_TYPE = $8625;
  GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB = $8625;
  GL_CURRENT_ATTRIB_NV = $8626;
  GL_CURRENT_VERTEX_ATTRIB = $8626;
  GL_CURRENT_VERTEX_ATTRIB_ARB = $8626;
  GL_PROGRAM_LENGTH_ARB = $8627;
  GL_PROGRAM_LENGTH_NV = $8627;
  GL_PROGRAM_STRING_ARB = $8628;
  GL_PROGRAM_STRING_NV = $8628;
  GL_MODELVIEW_PROJECTION_NV = $8629;
  GL_IDENTITY_NV = $862A;
  GL_INVERSE_NV = $862B;
  GL_TRANSPOSE_NV = $862C;
  GL_INVERSE_TRANSPOSE_NV = $862D;
  GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB = $862E;
  GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV = $862E;
  GL_MAX_PROGRAM_MATRICES_ARB = $862F;
  GL_MAX_TRACK_MATRICES_NV = $862F;
  GL_MATRIX0_NV = $8630;
  GL_MATRIX1_NV = $8631;
  GL_MATRIX2_NV = $8632;
  GL_MATRIX3_NV = $8633;
  GL_MATRIX4_NV = $8634;
  GL_MATRIX5_NV = $8635;
  GL_MATRIX6_NV = $8636;
  GL_MATRIX7_NV = $8637;
  GL_CURRENT_MATRIX_STACK_DEPTH_ARB = $8640;
  GL_CURRENT_MATRIX_STACK_DEPTH_NV = $8640;
  GL_CURRENT_MATRIX_ARB = $8641;
  GL_CURRENT_MATRIX_NV = $8641;
  GL_VERTEX_PROGRAM_POINT_SIZE = $8642;
  GL_VERTEX_PROGRAM_POINT_SIZE_ARB = $8642;
  GL_VERTEX_PROGRAM_POINT_SIZE_NV = $8642;
  GL_PROGRAM_POINT_SIZE = $8642;
  GL_PROGRAM_POINT_SIZE_ARB = $8642;
  GL_PROGRAM_POINT_SIZE_EXT = $8642;
  GL_VERTEX_PROGRAM_TWO_SIDE = $8643;
  GL_VERTEX_PROGRAM_TWO_SIDE_ARB = $8643;
  GL_VERTEX_PROGRAM_TWO_SIDE_NV = $8643;
  GL_PROGRAM_PARAMETER_NV = $8644;
  GL_ATTRIB_ARRAY_POINTER_NV = $8645;
  GL_VERTEX_ATTRIB_ARRAY_POINTER = $8645;
  GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB = $8645;
  GL_PROGRAM_TARGET_NV = $8646;
  GL_PROGRAM_RESIDENT_NV = $8647;
  GL_TRACK_MATRIX_NV = $8648;
  GL_TRACK_MATRIX_TRANSFORM_NV = $8649;
  GL_VERTEX_PROGRAM_BINDING_NV = $864A;
  GL_PROGRAM_ERROR_POSITION_ARB = $864B;
  GL_PROGRAM_ERROR_POSITION_NV = $864B;
  GL_OFFSET_TEXTURE_RECTANGLE_NV = $864C;
  GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV = $864D;
  GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV = $864E;
  GL_DEPTH_CLAMP = $864F;
  GL_DEPTH_CLAMP_NV = $864F;
  GL_VERTEX_ATTRIB_ARRAY0_NV = $8650;
  GL_VERTEX_ATTRIB_ARRAY1_NV = $8651;
  GL_VERTEX_ATTRIB_ARRAY2_NV = $8652;
  GL_VERTEX_ATTRIB_ARRAY3_NV = $8653;
  GL_VERTEX_ATTRIB_ARRAY4_NV = $8654;
  GL_VERTEX_ATTRIB_ARRAY5_NV = $8655;
  GL_VERTEX_ATTRIB_ARRAY6_NV = $8656;
  GL_VERTEX_ATTRIB_ARRAY7_NV = $8657;
  GL_VERTEX_ATTRIB_ARRAY8_NV = $8658;
  GL_VERTEX_ATTRIB_ARRAY9_NV = $8659;
  GL_VERTEX_ATTRIB_ARRAY10_NV = $865A;
  GL_VERTEX_ATTRIB_ARRAY11_NV = $865B;
  GL_VERTEX_ATTRIB_ARRAY12_NV = $865C;
  GL_VERTEX_ATTRIB_ARRAY13_NV = $865D;
  GL_VERTEX_ATTRIB_ARRAY14_NV = $865E;
  GL_VERTEX_ATTRIB_ARRAY15_NV = $865F;
  GL_MAP1_VERTEX_ATTRIB0_4_NV = $8660;
  GL_MAP1_VERTEX_ATTRIB1_4_NV = $8661;
  GL_MAP1_VERTEX_ATTRIB2_4_NV = $8662;
  GL_MAP1_VERTEX_ATTRIB3_4_NV = $8663;
  GL_MAP1_VERTEX_ATTRIB4_4_NV = $8664;
  GL_MAP1_VERTEX_ATTRIB5_4_NV = $8665;
  GL_MAP1_VERTEX_ATTRIB6_4_NV = $8666;
  GL_MAP1_VERTEX_ATTRIB7_4_NV = $8667;
  GL_MAP1_VERTEX_ATTRIB8_4_NV = $8668;
  GL_MAP1_VERTEX_ATTRIB9_4_NV = $8669;
  GL_MAP1_VERTEX_ATTRIB10_4_NV = $866A;
  GL_MAP1_VERTEX_ATTRIB11_4_NV = $866B;
  GL_MAP1_VERTEX_ATTRIB12_4_NV = $866C;
  GL_MAP1_VERTEX_ATTRIB13_4_NV = $866D;
  GL_MAP1_VERTEX_ATTRIB14_4_NV = $866E;
  GL_MAP1_VERTEX_ATTRIB15_4_NV = $866F;
  GL_MAP2_VERTEX_ATTRIB0_4_NV = $8670;
  GL_MAP2_VERTEX_ATTRIB1_4_NV = $8671;
  GL_MAP2_VERTEX_ATTRIB2_4_NV = $8672;
  GL_MAP2_VERTEX_ATTRIB3_4_NV = $8673;
  GL_MAP2_VERTEX_ATTRIB4_4_NV = $8674;
  GL_MAP2_VERTEX_ATTRIB5_4_NV = $8675;
  GL_MAP2_VERTEX_ATTRIB6_4_NV = $8676;
  GL_MAP2_VERTEX_ATTRIB7_4_NV = $8677;
  GL_PROGRAM_BINDING_ARB = $8677;
  GL_MAP2_VERTEX_ATTRIB8_4_NV = $8678;
  GL_MAP2_VERTEX_ATTRIB9_4_NV = $8679;
  GL_MAP2_VERTEX_ATTRIB10_4_NV = $867A;
  GL_MAP2_VERTEX_ATTRIB11_4_NV = $867B;
  GL_MAP2_VERTEX_ATTRIB12_4_NV = $867C;
  GL_MAP2_VERTEX_ATTRIB13_4_NV = $867D;
  GL_MAP2_VERTEX_ATTRIB14_4_NV = $867E;
  GL_MAP2_VERTEX_ATTRIB15_4_NV = $867F;
  GL_TEXTURE_COMPRESSED_IMAGE_SIZE = $86A0;
  GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB = $86A0;
  GL_TEXTURE_COMPRESSED = $86A1;
  GL_TEXTURE_COMPRESSED_ARB = $86A1;
  GL_NUM_COMPRESSED_TEXTURE_FORMATS = $86A2;
  GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB = $86A2;
  GL_COMPRESSED_TEXTURE_FORMATS = $86A3;
  GL_COMPRESSED_TEXTURE_FORMATS_ARB = $86A3;
  GL_MAX_VERTEX_UNITS_ARB = $86A4;
  GL_MAX_VERTEX_UNITS_OES = $86A4;
  GL_ACTIVE_VERTEX_UNITS_ARB = $86A5;
  GL_WEIGHT_SUM_UNITY_ARB = $86A6;
  GL_VERTEX_BLEND_ARB = $86A7;
  GL_CURRENT_WEIGHT_ARB = $86A8;
  GL_WEIGHT_ARRAY_TYPE_ARB = $86A9;
  GL_WEIGHT_ARRAY_TYPE_OES = $86A9;
  GL_WEIGHT_ARRAY_STRIDE_ARB = $86AA;
  GL_WEIGHT_ARRAY_STRIDE_OES = $86AA;
  GL_WEIGHT_ARRAY_SIZE_ARB = $86AB;
  GL_WEIGHT_ARRAY_SIZE_OES = $86AB;
  GL_WEIGHT_ARRAY_POINTER_ARB = $86AC;
  GL_WEIGHT_ARRAY_POINTER_OES = $86AC;
  GL_WEIGHT_ARRAY_ARB = $86AD;
  GL_WEIGHT_ARRAY_OES = $86AD;
  GL_DOT3_RGB = $86AE;
  GL_DOT3_RGB_ARB = $86AE;
  GL_DOT3_RGBA = $86AF;
  GL_DOT3_RGBA_ARB = $86AF;
  GL_DOT3_RGBA_IMG = $86AF;
  GL_COMPRESSED_RGB_FXT1_3DFX = $86B0;
  GL_COMPRESSED_RGBA_FXT1_3DFX = $86B1;
  GL_MULTISAMPLE_3DFX = $86B2;
  GL_SAMPLE_BUFFERS_3DFX = $86B3;
  GL_SAMPLES_3DFX = $86B4;
  GL_EVAL_2D_NV = $86C0;
  GL_EVAL_TRIANGULAR_2D_NV = $86C1;
  GL_MAP_TESSELLATION_NV = $86C2;
  GL_MAP_ATTRIB_U_ORDER_NV = $86C3;
  GL_MAP_ATTRIB_V_ORDER_NV = $86C4;
  GL_EVAL_FRACTIONAL_TESSELLATION_NV = $86C5;
  GL_EVAL_VERTEX_ATTRIB0_NV = $86C6;
  GL_EVAL_VERTEX_ATTRIB1_NV = $86C7;
  GL_EVAL_VERTEX_ATTRIB2_NV = $86C8;
  GL_EVAL_VERTEX_ATTRIB3_NV = $86C9;
  GL_EVAL_VERTEX_ATTRIB4_NV = $86CA;
  GL_EVAL_VERTEX_ATTRIB5_NV = $86CB;
  GL_EVAL_VERTEX_ATTRIB6_NV = $86CC;
  GL_EVAL_VERTEX_ATTRIB7_NV = $86CD;
  GL_EVAL_VERTEX_ATTRIB8_NV = $86CE;
  GL_EVAL_VERTEX_ATTRIB9_NV = $86CF;
  GL_EVAL_VERTEX_ATTRIB10_NV = $86D0;
  GL_EVAL_VERTEX_ATTRIB11_NV = $86D1;
  GL_EVAL_VERTEX_ATTRIB12_NV = $86D2;
  GL_EVAL_VERTEX_ATTRIB13_NV = $86D3;
  GL_EVAL_VERTEX_ATTRIB14_NV = $86D4;
  GL_EVAL_VERTEX_ATTRIB15_NV = $86D5;
  GL_MAX_MAP_TESSELLATION_NV = $86D6;
  GL_MAX_RATIONAL_EVAL_ORDER_NV = $86D7;
  GL_MAX_PROGRAM_PATCH_ATTRIBS_NV = $86D8;
  GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV = $86D9;
  GL_UNSIGNED_INT_S8_S8_8_8_NV = $86DA;
  GL_UNSIGNED_INT_8_8_S8_S8_REV_NV = $86DB;
  GL_DSDT_MAG_INTENSITY_NV = $86DC;
  GL_SHADER_CONSISTENT_NV = $86DD;
  GL_TEXTURE_SHADER_NV = $86DE;
  GL_SHADER_OPERATION_NV = $86DF;
  GL_CULL_MODES_NV = $86E0;
  GL_OFFSET_TEXTURE_MATRIX_NV = $86E1;
  GL_OFFSET_TEXTURE_2D_MATRIX_NV = $86E1;
  GL_OFFSET_TEXTURE_SCALE_NV = $86E2;
  GL_OFFSET_TEXTURE_2D_SCALE_NV = $86E2;
  GL_OFFSET_TEXTURE_BIAS_NV = $86E3;
  GL_OFFSET_TEXTURE_2D_BIAS_NV = $86E3;
  GL_PREVIOUS_TEXTURE_INPUT_NV = $86E4;
  GL_CONST_EYE_NV = $86E5;
  GL_PASS_THROUGH_NV = $86E6;
  GL_CULL_FRAGMENT_NV = $86E7;
  GL_OFFSET_TEXTURE_2D_NV = $86E8;
  GL_DEPENDENT_AR_TEXTURE_2D_NV = $86E9;
  GL_DEPENDENT_GB_TEXTURE_2D_NV = $86EA;
  GL_SURFACE_STATE_NV = $86EB;
  GL_DOT_PRODUCT_NV = $86EC;
  GL_DOT_PRODUCT_DEPTH_REPLACE_NV = $86ED;
  GL_DOT_PRODUCT_TEXTURE_2D_NV = $86EE;
  GL_DOT_PRODUCT_TEXTURE_3D_NV = $86EF;
  GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV = $86F0;
  GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV = $86F1;
  GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV = $86F2;
  GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV = $86F3;
  GL_HILO_NV = $86F4;
  GL_DSDT_NV = $86F5;
  GL_DSDT_MAG_NV = $86F6;
  GL_DSDT_MAG_VIB_NV = $86F7;
  GL_HILO16_NV = $86F8;
  GL_SIGNED_HILO_NV = $86F9;
  GL_SIGNED_HILO16_NV = $86FA;
  GL_SIGNED_RGBA_NV = $86FB;
  GL_SIGNED_RGBA8_NV = $86FC;
  GL_SURFACE_REGISTERED_NV = $86FD;
  GL_SIGNED_RGB_NV = $86FE;
  GL_SIGNED_RGB8_NV = $86FF;
  GL_SURFACE_MAPPED_NV = $8700;
  GL_SIGNED_LUMINANCE_NV = $8701;
  GL_SIGNED_LUMINANCE8_NV = $8702;
  GL_SIGNED_LUMINANCE_ALPHA_NV = $8703;
  GL_SIGNED_LUMINANCE8_ALPHA8_NV = $8704;
  GL_SIGNED_ALPHA_NV = $8705;
  GL_SIGNED_ALPHA8_NV = $8706;
  GL_SIGNED_INTENSITY_NV = $8707;
  GL_SIGNED_INTENSITY8_NV = $8708;
  GL_DSDT8_NV = $8709;
  GL_DSDT8_MAG8_NV = $870A;
  GL_DSDT8_MAG8_INTENSITY8_NV = $870B;
  GL_SIGNED_RGB_UNSIGNED_ALPHA_NV = $870C;
  GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV = $870D;
  GL_HI_SCALE_NV = $870E;
  GL_LO_SCALE_NV = $870F;
  GL_DS_SCALE_NV = $8710;
  GL_DT_SCALE_NV = $8711;
  GL_MAGNITUDE_SCALE_NV = $8712;
  GL_VIBRANCE_SCALE_NV = $8713;
  GL_HI_BIAS_NV = $8714;
  GL_LO_BIAS_NV = $8715;
  GL_DS_BIAS_NV = $8716;
  GL_DT_BIAS_NV = $8717;
  GL_MAGNITUDE_BIAS_NV = $8718;
  GL_VIBRANCE_BIAS_NV = $8719;
  GL_TEXTURE_BORDER_VALUES_NV = $871A;
  GL_TEXTURE_HI_SIZE_NV = $871B;
  GL_TEXTURE_LO_SIZE_NV = $871C;
  GL_TEXTURE_DS_SIZE_NV = $871D;
  GL_TEXTURE_DT_SIZE_NV = $871E;
  GL_TEXTURE_MAG_SIZE_NV = $871F;
  GL_MODELVIEW2_ARB = $8722;
  GL_MODELVIEW3_ARB = $8723;
  GL_MODELVIEW4_ARB = $8724;
  GL_MODELVIEW5_ARB = $8725;
  GL_MODELVIEW6_ARB = $8726;
  GL_MODELVIEW7_ARB = $8727;
  GL_MODELVIEW8_ARB = $8728;
  GL_MODELVIEW9_ARB = $8729;
  GL_MODELVIEW10_ARB = $872A;
  GL_MODELVIEW11_ARB = $872B;
  GL_MODELVIEW12_ARB = $872C;
  GL_MODELVIEW13_ARB = $872D;
  GL_MODELVIEW14_ARB = $872E;
  GL_MODELVIEW15_ARB = $872F;
  GL_MODELVIEW16_ARB = $8730;
  GL_MODELVIEW17_ARB = $8731;
  GL_MODELVIEW18_ARB = $8732;
  GL_MODELVIEW19_ARB = $8733;
  GL_MODELVIEW20_ARB = $8734;
  GL_MODELVIEW21_ARB = $8735;
  GL_MODELVIEW22_ARB = $8736;
  GL_MODELVIEW23_ARB = $8737;
  GL_MODELVIEW24_ARB = $8738;
  GL_MODELVIEW25_ARB = $8739;
  GL_MODELVIEW26_ARB = $873A;
  GL_MODELVIEW27_ARB = $873B;
  GL_MODELVIEW28_ARB = $873C;
  GL_MODELVIEW29_ARB = $873D;
  GL_MODELVIEW30_ARB = $873E;
  GL_MODELVIEW31_ARB = $873F;
  GL_DOT3_RGB_EXT = $8740;
  GL_Z400_BINARY_AMD = $8740;
  GL_DOT3_RGBA_EXT = $8741;
  GL_PROGRAM_BINARY_LENGTH_OES = $8741;
  GL_PROGRAM_BINARY_LENGTH = $8741;
  GL_MIRROR_CLAMP_ATI = $8742;
  GL_MIRROR_CLAMP_EXT = $8742;
  GL_MIRROR_CLAMP_TO_EDGE = $8743;
  GL_MIRROR_CLAMP_TO_EDGE_ATI = $8743;
  GL_MIRROR_CLAMP_TO_EDGE_EXT = $8743;
  GL_MODULATE_ADD_ATI = $8744;
  GL_MODULATE_SIGNED_ADD_ATI = $8745;
  GL_MODULATE_SUBTRACT_ATI = $8746;
  GL_SET_AMD = $874A;
  GL_REPLACE_VALUE_AMD = $874B;
  GL_STENCIL_OP_VALUE_AMD = $874C;
  GL_STENCIL_BACK_OP_VALUE_AMD = $874D;
  GL_VERTEX_ATTRIB_ARRAY_LONG = $874E;
  GL_OCCLUSION_QUERY_EVENT_MASK_AMD = $874F;
  GL_DEPTH_STENCIL_MESA = $8750;
  GL_UNSIGNED_INT_24_8_MESA = $8751;
  GL_UNSIGNED_INT_8_24_REV_MESA = $8752;
  GL_UNSIGNED_SHORT_15_1_MESA = $8753;
  GL_UNSIGNED_SHORT_1_15_REV_MESA = $8754;
  GL_TRACE_MASK_MESA = $8755;
  GL_TRACE_NAME_MESA = $8756;
  GL_YCBCR_MESA = $8757;
  GL_PACK_INVERT_MESA = $8758;
  GL_DEBUG_OBJECT_MESA = $8759;
  GL_TEXTURE_1D_STACK_MESAX = $8759;
  GL_DEBUG_PRINT_MESA = $875A;
  GL_TEXTURE_2D_STACK_MESAX = $875A;
  GL_DEBUG_ASSERT_MESA = $875B;
  GL_PROXY_TEXTURE_1D_STACK_MESAX = $875B;
  GL_PROXY_TEXTURE_2D_STACK_MESAX = $875C;
  GL_TEXTURE_1D_STACK_BINDING_MESAX = $875D;
  GL_TEXTURE_2D_STACK_BINDING_MESAX = $875E;
  GL_STATIC_ATI = $8760;
  GL_DYNAMIC_ATI = $8761;
  GL_PRESERVE_ATI = $8762;
  GL_DISCARD_ATI = $8763;
  GL_BUFFER_SIZE = $8764;
  GL_BUFFER_SIZE_ARB = $8764;
  GL_OBJECT_BUFFER_SIZE_ATI = $8764;
  GL_BUFFER_USAGE = $8765;
  GL_BUFFER_USAGE_ARB = $8765;
  GL_OBJECT_BUFFER_USAGE_ATI = $8765;
  GL_ARRAY_OBJECT_BUFFER_ATI = $8766;
  GL_ARRAY_OBJECT_OFFSET_ATI = $8767;
  GL_ELEMENT_ARRAY_ATI = $8768;
  GL_ELEMENT_ARRAY_TYPE_ATI = $8769;
  GL_ELEMENT_ARRAY_POINTER_ATI = $876A;
  GL_MAX_VERTEX_STREAMS_ATI = $876B;
  GL_VERTEX_STREAM0_ATI = $876C;
  GL_VERTEX_STREAM1_ATI = $876D;
  GL_VERTEX_STREAM2_ATI = $876E;
  GL_VERTEX_STREAM3_ATI = $876F;
  GL_VERTEX_STREAM4_ATI = $8770;
  GL_VERTEX_STREAM5_ATI = $8771;
  GL_VERTEX_STREAM6_ATI = $8772;
  GL_VERTEX_STREAM7_ATI = $8773;
  GL_VERTEX_SOURCE_ATI = $8774;
  GL_BUMP_ROT_MATRIX_ATI = $8775;
  GL_BUMP_ROT_MATRIX_SIZE_ATI = $8776;
  GL_BUMP_NUM_TEX_UNITS_ATI = $8777;
  GL_BUMP_TEX_UNITS_ATI = $8778;
  GL_DUDV_ATI = $8779;
  GL_DU8DV8_ATI = $877A;
  GL_BUMP_ENVMAP_ATI = $877B;
  GL_BUMP_TARGET_ATI = $877C;
  GL_VERTEX_SHADER_EXT = $8780;
  GL_VERTEX_SHADER_BINDING_EXT = $8781;
  GL_OP_INDEX_EXT = $8782;
  GL_OP_NEGATE_EXT = $8783;
  GL_OP_DOT3_EXT = $8784;
  GL_OP_DOT4_EXT = $8785;
  GL_OP_MUL_EXT = $8786;
  GL_OP_ADD_EXT = $8787;
  GL_OP_MADD_EXT = $8788;
  GL_OP_FRAC_EXT = $8789;
  GL_OP_MAX_EXT = $878A;
  GL_OP_MIN_EXT = $878B;
  GL_OP_SET_GE_EXT = $878C;
  GL_OP_SET_LT_EXT = $878D;
  GL_OP_CLAMP_EXT = $878E;
  GL_OP_FLOOR_EXT = $878F;
  GL_OP_ROUND_EXT = $8790;
  GL_OP_EXP_BASE_2_EXT = $8791;
  GL_OP_LOG_BASE_2_EXT = $8792;
  GL_OP_POWER_EXT = $8793;
  GL_OP_RECIP_EXT = $8794;
  GL_OP_RECIP_SQRT_EXT = $8795;
  GL_OP_SUB_EXT = $8796;
  GL_OP_CROSS_PRODUCT_EXT = $8797;
  GL_OP_MULTIPLY_MATRIX_EXT = $8798;
  GL_OP_MOV_EXT = $8799;
  GL_OUTPUT_VERTEX_EXT = $879A;
  GL_OUTPUT_COLOR0_EXT = $879B;
  GL_OUTPUT_COLOR1_EXT = $879C;
  GL_OUTPUT_TEXTURE_COORD0_EXT = $879D;
  GL_OUTPUT_TEXTURE_COORD1_EXT = $879E;
  GL_OUTPUT_TEXTURE_COORD2_EXT = $879F;
  GL_OUTPUT_TEXTURE_COORD3_EXT = $87A0;
  GL_OUTPUT_TEXTURE_COORD4_EXT = $87A1;
  GL_OUTPUT_TEXTURE_COORD5_EXT = $87A2;
  GL_OUTPUT_TEXTURE_COORD6_EXT = $87A3;
  GL_OUTPUT_TEXTURE_COORD7_EXT = $87A4;
  GL_OUTPUT_TEXTURE_COORD8_EXT = $87A5;
  GL_OUTPUT_TEXTURE_COORD9_EXT = $87A6;
  GL_OUTPUT_TEXTURE_COORD10_EXT = $87A7;
  GL_OUTPUT_TEXTURE_COORD11_EXT = $87A8;
  GL_OUTPUT_TEXTURE_COORD12_EXT = $87A9;
  GL_OUTPUT_TEXTURE_COORD13_EXT = $87AA;
  GL_OUTPUT_TEXTURE_COORD14_EXT = $87AB;
  GL_OUTPUT_TEXTURE_COORD15_EXT = $87AC;
  GL_OUTPUT_TEXTURE_COORD16_EXT = $87AD;
  GL_OUTPUT_TEXTURE_COORD17_EXT = $87AE;
  GL_OUTPUT_TEXTURE_COORD18_EXT = $87AF;
  GL_OUTPUT_TEXTURE_COORD19_EXT = $87B0;
  GL_OUTPUT_TEXTURE_COORD20_EXT = $87B1;
  GL_OUTPUT_TEXTURE_COORD21_EXT = $87B2;
  GL_OUTPUT_TEXTURE_COORD22_EXT = $87B3;
  GL_OUTPUT_TEXTURE_COORD23_EXT = $87B4;
  GL_OUTPUT_TEXTURE_COORD24_EXT = $87B5;
  GL_OUTPUT_TEXTURE_COORD25_EXT = $87B6;
  GL_OUTPUT_TEXTURE_COORD26_EXT = $87B7;
  GL_OUTPUT_TEXTURE_COORD27_EXT = $87B8;
  GL_OUTPUT_TEXTURE_COORD28_EXT = $87B9;
  GL_OUTPUT_TEXTURE_COORD29_EXT = $87BA;
  GL_OUTPUT_TEXTURE_COORD30_EXT = $87BB;
  GL_OUTPUT_TEXTURE_COORD31_EXT = $87BC;
  GL_OUTPUT_FOG_EXT = $87BD;
  GL_SCALAR_EXT = $87BE;
  GL_VECTOR_EXT = $87BF;
  GL_MATRIX_EXT = $87C0;
  GL_VARIANT_EXT = $87C1;
  GL_INVARIANT_EXT = $87C2;
  GL_LOCAL_CONSTANT_EXT = $87C3;
  GL_LOCAL_EXT = $87C4;
  GL_MAX_VERTEX_SHADER_INSTRUCTIONS_EXT = $87C5;
  GL_MAX_VERTEX_SHADER_VARIANTS_EXT = $87C6;
  GL_MAX_VERTEX_SHADER_INVARIANTS_EXT = $87C7;
  GL_MAX_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = $87C8;
  GL_MAX_VERTEX_SHADER_LOCALS_EXT = $87C9;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_INSTRUCTIONS_EXT = $87CA;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_VARIANTS_EXT = $87CB;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = $87CC;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_INVARIANTS_EXT = $87CD;
  GL_MAX_OPTIMIZED_VERTEX_SHADER_LOCALS_EXT = $87CE;
  GL_VERTEX_SHADER_INSTRUCTIONS_EXT = $87CF;
  GL_VERTEX_SHADER_VARIANTS_EXT = $87D0;
  GL_VERTEX_SHADER_INVARIANTS_EXT = $87D1;
  GL_VERTEX_SHADER_LOCAL_CONSTANTS_EXT = $87D2;
  GL_VERTEX_SHADER_LOCALS_EXT = $87D3;
  GL_VERTEX_SHADER_OPTIMIZED_EXT = $87D4;
  GL_X_EXT = $87D5;
  GL_Y_EXT = $87D6;
  GL_Z_EXT = $87D7;
  GL_W_EXT = $87D8;
  GL_NEGATIVE_X_EXT = $87D9;
  GL_NEGATIVE_Y_EXT = $87DA;
  GL_NEGATIVE_Z_EXT = $87DB;
  GL_NEGATIVE_W_EXT = $87DC;
  GL_ZERO_EXT = $87DD;
  GL_ONE_EXT = $87DE;
  GL_NEGATIVE_ONE_EXT = $87DF;
  GL_NORMALIZED_RANGE_EXT = $87E0;
  GL_FULL_RANGE_EXT = $87E1;
  GL_CURRENT_VERTEX_EXT = $87E2;
  GL_MVP_MATRIX_EXT = $87E3;
  GL_VARIANT_VALUE_EXT = $87E4;
  GL_VARIANT_DATATYPE_EXT = $87E5;
  GL_VARIANT_ARRAY_STRIDE_EXT = $87E6;
  GL_VARIANT_ARRAY_TYPE_EXT = $87E7;
  GL_VARIANT_ARRAY_EXT = $87E8;
  GL_VARIANT_ARRAY_POINTER_EXT = $87E9;
  GL_INVARIANT_VALUE_EXT = $87EA;
  GL_INVARIANT_DATATYPE_EXT = $87EB;
  GL_LOCAL_CONSTANT_VALUE_EXT = $87EC;
  GL_LOCAL_CONSTANT_DATATYPE_EXT = $87ED;
  GL_ATC_RGBA_INTERPOLATED_ALPHA_AMD = $87EE;
  GL_PN_TRIANGLES_ATI = $87F0;
  GL_MAX_PN_TRIANGLES_TESSELATION_LEVEL_ATI = $87F1;
  GL_PN_TRIANGLES_POINT_MODE_ATI = $87F2;
  GL_PN_TRIANGLES_NORMAL_MODE_ATI = $87F3;
  GL_PN_TRIANGLES_TESSELATION_LEVEL_ATI = $87F4;
  GL_PN_TRIANGLES_POINT_MODE_LINEAR_ATI = $87F5;
  GL_PN_TRIANGLES_POINT_MODE_CUBIC_ATI = $87F6;
  GL_PN_TRIANGLES_NORMAL_MODE_LINEAR_ATI = $87F7;
  GL_PN_TRIANGLES_NORMAL_MODE_QUADRATIC_ATI = $87F8;
  GL_3DC_X_AMD = $87F9;
  GL_3DC_XY_AMD = $87FA;
  GL_VBO_FREE_MEMORY_ATI = $87FB;
  GL_TEXTURE_FREE_MEMORY_ATI = $87FC;
  GL_RENDERBUFFER_FREE_MEMORY_ATI = $87FD;
  GL_NUM_PROGRAM_BINARY_FORMATS = $87FE;
  GL_NUM_PROGRAM_BINARY_FORMATS_OES = $87FE;
  GL_PROGRAM_BINARY_FORMATS = $87FF;
  GL_PROGRAM_BINARY_FORMATS_OES = $87FF;
  GL_STENCIL_BACK_FUNC = $8800;
  GL_STENCIL_BACK_FUNC_ATI = $8800;
  GL_STENCIL_BACK_FAIL = $8801;
  GL_STENCIL_BACK_FAIL_ATI = $8801;
  GL_STENCIL_BACK_PASS_DEPTH_FAIL = $8802;
  GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI = $8802;
  GL_STENCIL_BACK_PASS_DEPTH_PASS = $8803;
  GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI = $8803;
  GL_FRAGMENT_PROGRAM_ARB = $8804;
  GL_PROGRAM_ALU_INSTRUCTIONS_ARB = $8805;
  GL_PROGRAM_TEX_INSTRUCTIONS_ARB = $8806;
  GL_PROGRAM_TEX_INDIRECTIONS_ARB = $8807;
  GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = $8808;
  GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = $8809;
  GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = $880A;
  GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB = $880B;
  GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB = $880C;
  GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB = $880D;
  GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB = $880E;
  GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB = $880F;
  GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB = $8810;
  GL_RGBA32F = $8814;
  GL_RGBA32F_ARB = $8814;
  GL_RGBA32F_EXT = $8814;
  GL_RGBA_FLOAT32_APPLE = $8814;
  GL_RGBA_FLOAT32_ATI = $8814;
  GL_RGB32F = $8815;
  GL_RGB32F_ARB = $8815;
  GL_RGB32F_EXT = $8815;
  GL_RGB_FLOAT32_APPLE = $8815;
  GL_RGB_FLOAT32_ATI = $8815;
  GL_ALPHA32F_ARB = $8816;
  GL_ALPHA32F_EXT = $8816;
  GL_ALPHA_FLOAT32_APPLE = $8816;
  GL_ALPHA_FLOAT32_ATI = $8816;
  GL_INTENSITY32F_ARB = $8817;
  GL_INTENSITY_FLOAT32_APPLE = $8817;
  GL_INTENSITY_FLOAT32_ATI = $8817;
  GL_LUMINANCE32F_ARB = $8818;
  GL_LUMINANCE32F_EXT = $8818;
  GL_LUMINANCE_FLOAT32_APPLE = $8818;
  GL_LUMINANCE_FLOAT32_ATI = $8818;
  GL_LUMINANCE_ALPHA32F_ARB = $8819;
  GL_LUMINANCE_ALPHA32F_EXT = $8819;
  GL_LUMINANCE_ALPHA_FLOAT32_APPLE = $8819;
  GL_LUMINANCE_ALPHA_FLOAT32_ATI = $8819;
  GL_RGBA16F = $881A;
  GL_RGBA16F_ARB = $881A;
  GL_RGBA16F_EXT = $881A;
  GL_RGBA_FLOAT16_APPLE = $881A;
  GL_RGBA_FLOAT16_ATI = $881A;
  GL_RGB16F = $881B;
  GL_RGB16F_ARB = $881B;
  GL_RGB16F_EXT = $881B;
  GL_RGB_FLOAT16_APPLE = $881B;
  GL_RGB_FLOAT16_ATI = $881B;
  GL_ALPHA16F_ARB = $881C;
  GL_ALPHA16F_EXT = $881C;
  GL_ALPHA_FLOAT16_APPLE = $881C;
  GL_ALPHA_FLOAT16_ATI = $881C;
  GL_INTENSITY16F_ARB = $881D;
  GL_INTENSITY_FLOAT16_APPLE = $881D;
  GL_INTENSITY_FLOAT16_ATI = $881D;
  GL_LUMINANCE16F_ARB = $881E;
  GL_LUMINANCE16F_EXT = $881E;
  GL_LUMINANCE_FLOAT16_APPLE = $881E;
  GL_LUMINANCE_FLOAT16_ATI = $881E;
  GL_LUMINANCE_ALPHA16F_ARB = $881F;
  GL_LUMINANCE_ALPHA16F_EXT = $881F;
  GL_LUMINANCE_ALPHA_FLOAT16_APPLE = $881F;
  GL_LUMINANCE_ALPHA_FLOAT16_ATI = $881F;
  GL_RGBA_FLOAT_MODE_ARB = $8820;
  GL_RGBA_FLOAT_MODE_ATI = $8820;
  GL_WRITEONLY_RENDERING_QCOM = $8823;
  GL_MAX_DRAW_BUFFERS = $8824;
  GL_MAX_DRAW_BUFFERS_ARB = $8824;
  GL_MAX_DRAW_BUFFERS_ATI = $8824;
  GL_MAX_DRAW_BUFFERS_EXT = $8824;
  GL_MAX_DRAW_BUFFERS_NV = $8824;
  GL_DRAW_BUFFER0 = $8825;
  GL_DRAW_BUFFER0_ARB = $8825;
  GL_DRAW_BUFFER0_ATI = $8825;
  GL_DRAW_BUFFER0_EXT = $8825;
  GL_DRAW_BUFFER0_NV = $8825;
  GL_DRAW_BUFFER1 = $8826;
  GL_DRAW_BUFFER1_ARB = $8826;
  GL_DRAW_BUFFER1_ATI = $8826;
  GL_DRAW_BUFFER1_EXT = $8826;
  GL_DRAW_BUFFER1_NV = $8826;
  GL_DRAW_BUFFER2 = $8827;
  GL_DRAW_BUFFER2_ARB = $8827;
  GL_DRAW_BUFFER2_ATI = $8827;
  GL_DRAW_BUFFER2_EXT = $8827;
  GL_DRAW_BUFFER2_NV = $8827;
  GL_DRAW_BUFFER3 = $8828;
  GL_DRAW_BUFFER3_ARB = $8828;
  GL_DRAW_BUFFER3_ATI = $8828;
  GL_DRAW_BUFFER3_EXT = $8828;
  GL_DRAW_BUFFER3_NV = $8828;
  GL_DRAW_BUFFER4 = $8829;
  GL_DRAW_BUFFER4_ARB = $8829;
  GL_DRAW_BUFFER4_ATI = $8829;
  GL_DRAW_BUFFER4_EXT = $8829;
  GL_DRAW_BUFFER4_NV = $8829;
  GL_DRAW_BUFFER5 = $882A;
  GL_DRAW_BUFFER5_ARB = $882A;
  GL_DRAW_BUFFER5_ATI = $882A;
  GL_DRAW_BUFFER5_EXT = $882A;
  GL_DRAW_BUFFER5_NV = $882A;
  GL_DRAW_BUFFER6 = $882B;
  GL_DRAW_BUFFER6_ARB = $882B;
  GL_DRAW_BUFFER6_ATI = $882B;
  GL_DRAW_BUFFER6_EXT = $882B;
  GL_DRAW_BUFFER6_NV = $882B;
  GL_DRAW_BUFFER7 = $882C;
  GL_DRAW_BUFFER7_ARB = $882C;
  GL_DRAW_BUFFER7_ATI = $882C;
  GL_DRAW_BUFFER7_EXT = $882C;
  GL_DRAW_BUFFER7_NV = $882C;
  GL_DRAW_BUFFER8 = $882D;
  GL_DRAW_BUFFER8_ARB = $882D;
  GL_DRAW_BUFFER8_ATI = $882D;
  GL_DRAW_BUFFER8_EXT = $882D;
  GL_DRAW_BUFFER8_NV = $882D;
  GL_DRAW_BUFFER9 = $882E;
  GL_DRAW_BUFFER9_ARB = $882E;
  GL_DRAW_BUFFER9_ATI = $882E;
  GL_DRAW_BUFFER9_EXT = $882E;
  GL_DRAW_BUFFER9_NV = $882E;
  GL_DRAW_BUFFER10 = $882F;
  GL_DRAW_BUFFER10_ARB = $882F;
  GL_DRAW_BUFFER10_ATI = $882F;
  GL_DRAW_BUFFER10_EXT = $882F;
  GL_DRAW_BUFFER10_NV = $882F;
  GL_DRAW_BUFFER11 = $8830;
  GL_DRAW_BUFFER11_ARB = $8830;
  GL_DRAW_BUFFER11_ATI = $8830;
  GL_DRAW_BUFFER11_EXT = $8830;
  GL_DRAW_BUFFER11_NV = $8830;
  GL_DRAW_BUFFER12 = $8831;
  GL_DRAW_BUFFER12_ARB = $8831;
  GL_DRAW_BUFFER12_ATI = $8831;
  GL_DRAW_BUFFER12_EXT = $8831;
  GL_DRAW_BUFFER12_NV = $8831;
  GL_DRAW_BUFFER13 = $8832;
  GL_DRAW_BUFFER13_ARB = $8832;
  GL_DRAW_BUFFER13_ATI = $8832;
  GL_DRAW_BUFFER13_EXT = $8832;
  GL_DRAW_BUFFER13_NV = $8832;
  GL_DRAW_BUFFER14 = $8833;
  GL_DRAW_BUFFER14_ARB = $8833;
  GL_DRAW_BUFFER14_ATI = $8833;
  GL_DRAW_BUFFER14_EXT = $8833;
  GL_DRAW_BUFFER14_NV = $8833;
  GL_DRAW_BUFFER15 = $8834;
  GL_DRAW_BUFFER15_ARB = $8834;
  GL_DRAW_BUFFER15_ATI = $8834;
  GL_DRAW_BUFFER15_EXT = $8834;
  GL_DRAW_BUFFER15_NV = $8834;
  GL_COLOR_CLEAR_UNCLAMPED_VALUE_ATI = $8835;
  GL_COMPRESSED_LUMINANCE_ALPHA_3DC_ATI = $8837;
  GL_BLEND_EQUATION_ALPHA = $883D;
  GL_BLEND_EQUATION_ALPHA_EXT = $883D;
  GL_BLEND_EQUATION_ALPHA_OES = $883D;
  GL_SUBSAMPLE_DISTANCE_AMD = $883F;
  GL_MATRIX_PALETTE_ARB = $8840;
  GL_MATRIX_PALETTE_OES = $8840;
  GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB = $8841;
  GL_MAX_PALETTE_MATRICES_ARB = $8842;
  GL_MAX_PALETTE_MATRICES_OES = $8842;
  GL_CURRENT_PALETTE_MATRIX_ARB = $8843;
  GL_CURRENT_PALETTE_MATRIX_OES = $8843;
  GL_MATRIX_INDEX_ARRAY_ARB = $8844;
  GL_MATRIX_INDEX_ARRAY_OES = $8844;
  GL_CURRENT_MATRIX_INDEX_ARB = $8845;
  GL_MATRIX_INDEX_ARRAY_SIZE_ARB = $8846;
  GL_MATRIX_INDEX_ARRAY_SIZE_OES = $8846;
  GL_MATRIX_INDEX_ARRAY_TYPE_ARB = $8847;
  GL_MATRIX_INDEX_ARRAY_TYPE_OES = $8847;
  GL_MATRIX_INDEX_ARRAY_STRIDE_ARB = $8848;
  GL_MATRIX_INDEX_ARRAY_STRIDE_OES = $8848;
  GL_MATRIX_INDEX_ARRAY_POINTER_ARB = $8849;
  GL_MATRIX_INDEX_ARRAY_POINTER_OES = $8849;
  GL_TEXTURE_DEPTH_SIZE = $884A;
  GL_TEXTURE_DEPTH_SIZE_ARB = $884A;
  GL_DEPTH_TEXTURE_MODE = $884B;
  GL_DEPTH_TEXTURE_MODE_ARB = $884B;
  GL_TEXTURE_COMPARE_MODE = $884C;
  GL_TEXTURE_COMPARE_MODE_ARB = $884C;
  GL_TEXTURE_COMPARE_MODE_EXT = $884C;
  GL_TEXTURE_COMPARE_FUNC = $884D;
  GL_TEXTURE_COMPARE_FUNC_ARB = $884D;
  GL_TEXTURE_COMPARE_FUNC_EXT = $884D;
  GL_COMPARE_R_TO_TEXTURE = $884E;
  GL_COMPARE_R_TO_TEXTURE_ARB = $884E;
  GL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT = $884E;
  GL_COMPARE_REF_TO_TEXTURE = $884E;
  GL_COMPARE_REF_TO_TEXTURE_EXT = $884E;
  GL_TEXTURE_CUBE_MAP_SEAMLESS = $884F;
  GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV = $8850;
  GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV = $8851;
  GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV = $8852;
  GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV = $8853;
  GL_OFFSET_HILO_TEXTURE_2D_NV = $8854;
  GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV = $8855;
  GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV = $8856;
  GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV = $8857;
  GL_DEPENDENT_HILO_TEXTURE_2D_NV = $8858;
  GL_DEPENDENT_RGB_TEXTURE_3D_NV = $8859;
  GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV = $885A;
  GL_DOT_PRODUCT_PASS_THROUGH_NV = $885B;
  GL_DOT_PRODUCT_TEXTURE_1D_NV = $885C;
  GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV = $885D;
  GL_HILO8_NV = $885E;
  GL_SIGNED_HILO8_NV = $885F;
  GL_FORCE_BLUE_TO_ONE_NV = $8860;
  GL_POINT_SPRITE = $8861;
  GL_POINT_SPRITE_ARB = $8861;
  GL_POINT_SPRITE_NV = $8861;
  GL_POINT_SPRITE_OES = $8861;
  GL_COORD_REPLACE = $8862;
  GL_COORD_REPLACE_ARB = $8862;
  GL_COORD_REPLACE_NV = $8862;
  GL_COORD_REPLACE_OES = $8862;
  GL_POINT_SPRITE_R_MODE_NV = $8863;
  GL_PIXEL_COUNTER_BITS_NV = $8864;
  GL_QUERY_COUNTER_BITS = $8864;
  GL_QUERY_COUNTER_BITS_ARB = $8864;
  GL_QUERY_COUNTER_BITS_EXT = $8864;
  GL_CURRENT_OCCLUSION_QUERY_ID_NV = $8865;
  GL_CURRENT_QUERY = $8865;
  GL_CURRENT_QUERY_ARB = $8865;
  GL_CURRENT_QUERY_EXT = $8865;
  GL_PIXEL_COUNT_NV = $8866;
  GL_QUERY_RESULT = $8866;
  GL_QUERY_RESULT_ARB = $8866;
  GL_QUERY_RESULT_EXT = $8866;
  GL_PIXEL_COUNT_AVAILABLE_NV = $8867;
  GL_QUERY_RESULT_AVAILABLE = $8867;
  GL_QUERY_RESULT_AVAILABLE_ARB = $8867;
  GL_QUERY_RESULT_AVAILABLE_EXT = $8867;
  GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV = $8868;
  GL_MAX_VERTEX_ATTRIBS = $8869;
  GL_MAX_VERTEX_ATTRIBS_ARB = $8869;
  GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = $886A;
  GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB = $886A;
  GL_MAX_TESS_CONTROL_INPUT_COMPONENTS = $886C;
  GL_MAX_TESS_CONTROL_INPUT_COMPONENTS_EXT = $886C;
  GL_MAX_TESS_CONTROL_INPUT_COMPONENTS_OES = $886C;
  GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = $886D;
  GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS_EXT = $886D;
  GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS_OES = $886D;
  GL_DEPTH_STENCIL_TO_RGBA_NV = $886E;
  GL_DEPTH_STENCIL_TO_BGRA_NV = $886F;
  GL_FRAGMENT_PROGRAM_NV = $8870;
  GL_MAX_TEXTURE_COORDS = $8871;
  GL_MAX_TEXTURE_COORDS_ARB = $8871;
  GL_MAX_TEXTURE_COORDS_NV = $8871;
  GL_MAX_TEXTURE_IMAGE_UNITS = $8872;
  GL_MAX_TEXTURE_IMAGE_UNITS_ARB = $8872;
  GL_MAX_TEXTURE_IMAGE_UNITS_NV = $8872;
  GL_FRAGMENT_PROGRAM_BINDING_NV = $8873;
  GL_PROGRAM_ERROR_STRING_ARB = $8874;
  GL_PROGRAM_ERROR_STRING_NV = $8874;
  GL_PROGRAM_FORMAT_ASCII_ARB = $8875;
  GL_PROGRAM_FORMAT_ARB = $8876;
  GL_WRITE_PIXEL_DATA_RANGE_NV = $8878;
  GL_READ_PIXEL_DATA_RANGE_NV = $8879;
  GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV = $887A;
  GL_READ_PIXEL_DATA_RANGE_LENGTH_NV = $887B;
  GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV = $887C;
  GL_READ_PIXEL_DATA_RANGE_POINTER_NV = $887D;
  GL_GEOMETRY_SHADER_INVOCATIONS = $887F;
  GL_GEOMETRY_SHADER_INVOCATIONS_EXT = $887F;
  GL_GEOMETRY_SHADER_INVOCATIONS_OES = $887F;
  GL_FLOAT_R_NV = $8880;
  GL_FLOAT_RG_NV = $8881;
  GL_FLOAT_RGB_NV = $8882;
  GL_FLOAT_RGBA_NV = $8883;
  GL_FLOAT_R16_NV = $8884;
  GL_FLOAT_R32_NV = $8885;
  GL_FLOAT_RG16_NV = $8886;
  GL_FLOAT_RG32_NV = $8887;
  GL_FLOAT_RGB16_NV = $8888;
  GL_FLOAT_RGB32_NV = $8889;
  GL_FLOAT_RGBA16_NV = $888A;
  GL_FLOAT_RGBA32_NV = $888B;
  GL_TEXTURE_FLOAT_COMPONENTS_NV = $888C;
  GL_FLOAT_CLEAR_COLOR_VALUE_NV = $888D;
  GL_FLOAT_RGBA_MODE_NV = $888E;
  GL_TEXTURE_UNSIGNED_REMAP_MODE_NV = $888F;
  GL_DEPTH_BOUNDS_TEST_EXT = $8890;
  GL_DEPTH_BOUNDS_EXT = $8891;
  GL_ARRAY_BUFFER = $8892;
  GL_ARRAY_BUFFER_ARB = $8892;
  GL_ELEMENT_ARRAY_BUFFER = $8893;
  GL_ELEMENT_ARRAY_BUFFER_ARB = $8893;
  GL_ARRAY_BUFFER_BINDING = $8894;
  GL_ARRAY_BUFFER_BINDING_ARB = $8894;
  GL_ELEMENT_ARRAY_BUFFER_BINDING = $8895;
  GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB = $8895;
  GL_VERTEX_ARRAY_BUFFER_BINDING = $8896;
  GL_VERTEX_ARRAY_BUFFER_BINDING_ARB = $8896;
  GL_NORMAL_ARRAY_BUFFER_BINDING = $8897;
  GL_NORMAL_ARRAY_BUFFER_BINDING_ARB = $8897;
  GL_COLOR_ARRAY_BUFFER_BINDING = $8898;
  GL_COLOR_ARRAY_BUFFER_BINDING_ARB = $8898;
  GL_INDEX_ARRAY_BUFFER_BINDING = $8899;
  GL_INDEX_ARRAY_BUFFER_BINDING_ARB = $8899;
  GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING = $889A;
  GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB = $889A;
  GL_EDGE_FLAG_ARRAY_BUFFER_BINDING = $889B;
  GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB = $889B;
  GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING = $889C;
  GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB = $889C;
  GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB = $889D;
  GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING = $889D;
  GL_FOG_COORD_ARRAY_BUFFER_BINDING = $889D;
  GL_WEIGHT_ARRAY_BUFFER_BINDING = $889E;
  GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB = $889E;
  GL_WEIGHT_ARRAY_BUFFER_BINDING_OES = $889E;
  GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING = $889F;
  GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB = $889F;
  GL_PROGRAM_INSTRUCTIONS_ARB = $88A0;
  GL_MAX_PROGRAM_INSTRUCTIONS_ARB = $88A1;
  GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB = $88A2;
  GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB = $88A3;
  GL_PROGRAM_TEMPORARIES_ARB = $88A4;
  GL_MAX_PROGRAM_TEMPORARIES_ARB = $88A5;
  GL_PROGRAM_NATIVE_TEMPORARIES_ARB = $88A6;
  GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB = $88A7;
  GL_PROGRAM_PARAMETERS_ARB = $88A8;
  GL_MAX_PROGRAM_PARAMETERS_ARB = $88A9;
  GL_PROGRAM_NATIVE_PARAMETERS_ARB = $88AA;
  GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB = $88AB;
  GL_PROGRAM_ATTRIBS_ARB = $88AC;
  GL_MAX_PROGRAM_ATTRIBS_ARB = $88AD;
  GL_PROGRAM_NATIVE_ATTRIBS_ARB = $88AE;
  GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB = $88AF;
  GL_PROGRAM_ADDRESS_REGISTERS_ARB = $88B0;
  GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB = $88B1;
  GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = $88B2;
  GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB = $88B3;
  GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB = $88B4;
  GL_MAX_PROGRAM_ENV_PARAMETERS_ARB = $88B5;
  GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB = $88B6;
  GL_TRANSPOSE_CURRENT_MATRIX_ARB = $88B7;
  GL_READ_ONLY = $88B8;
  GL_READ_ONLY_ARB = $88B8;
  GL_WRITE_ONLY = $88B9;
  GL_WRITE_ONLY_ARB = $88B9;
  GL_WRITE_ONLY_OES = $88B9;
  GL_READ_WRITE = $88BA;
  GL_READ_WRITE_ARB = $88BA;
  GL_BUFFER_ACCESS = $88BB;
  GL_BUFFER_ACCESS_ARB = $88BB;
  GL_BUFFER_ACCESS_OES = $88BB;
  GL_BUFFER_MAPPED = $88BC;
  GL_BUFFER_MAPPED_ARB = $88BC;
  GL_BUFFER_MAPPED_OES = $88BC;
  GL_BUFFER_MAP_POINTER = $88BD;
  GL_BUFFER_MAP_POINTER_ARB = $88BD;
  GL_BUFFER_MAP_POINTER_OES = $88BD;
  GL_WRITE_DISCARD_NV = $88BE;
  GL_TIME_ELAPSED = $88BF;
  GL_TIME_ELAPSED_EXT = $88BF;
  GL_MATRIX0_ARB = $88C0;
  GL_MATRIX1_ARB = $88C1;
  GL_MATRIX2_ARB = $88C2;
  GL_MATRIX3_ARB = $88C3;
  GL_MATRIX4_ARB = $88C4;
  GL_MATRIX5_ARB = $88C5;
  GL_MATRIX6_ARB = $88C6;
  GL_MATRIX7_ARB = $88C7;
  GL_MATRIX8_ARB = $88C8;
  GL_MATRIX9_ARB = $88C9;
  GL_MATRIX10_ARB = $88CA;
  GL_MATRIX11_ARB = $88CB;
  GL_MATRIX12_ARB = $88CC;
  GL_MATRIX13_ARB = $88CD;
  GL_MATRIX14_ARB = $88CE;
  GL_MATRIX15_ARB = $88CF;
  GL_MATRIX16_ARB = $88D0;
  GL_MATRIX17_ARB = $88D1;
  GL_MATRIX18_ARB = $88D2;
  GL_MATRIX19_ARB = $88D3;
  GL_MATRIX20_ARB = $88D4;
  GL_MATRIX21_ARB = $88D5;
  GL_MATRIX22_ARB = $88D6;
  GL_MATRIX23_ARB = $88D7;
  GL_MATRIX24_ARB = $88D8;
  GL_MATRIX25_ARB = $88D9;
  GL_MATRIX26_ARB = $88DA;
  GL_MATRIX27_ARB = $88DB;
  GL_MATRIX28_ARB = $88DC;
  GL_MATRIX29_ARB = $88DD;
  GL_MATRIX30_ARB = $88DE;
  GL_MATRIX31_ARB = $88DF;
  GL_STREAM_DRAW = $88E0;
  GL_STREAM_DRAW_ARB = $88E0;
  GL_STREAM_READ = $88E1;
  GL_STREAM_READ_ARB = $88E1;
  GL_STREAM_COPY = $88E2;
  GL_STREAM_COPY_ARB = $88E2;
  GL_STATIC_DRAW = $88E4;
  GL_STATIC_DRAW_ARB = $88E4;
  GL_STATIC_READ = $88E5;
  GL_STATIC_READ_ARB = $88E5;
  GL_STATIC_COPY = $88E6;
  GL_STATIC_COPY_ARB = $88E6;
  GL_DYNAMIC_DRAW = $88E8;
  GL_DYNAMIC_DRAW_ARB = $88E8;
  GL_DYNAMIC_READ = $88E9;
  GL_DYNAMIC_READ_ARB = $88E9;
  GL_DYNAMIC_COPY = $88EA;
  GL_DYNAMIC_COPY_ARB = $88EA;
  GL_PIXEL_PACK_BUFFER = $88EB;
  GL_PIXEL_PACK_BUFFER_ARB = $88EB;
  GL_PIXEL_PACK_BUFFER_EXT = $88EB;
  GL_PIXEL_PACK_BUFFER_NV = $88EB;
  GL_PIXEL_UNPACK_BUFFER = $88EC;
  GL_PIXEL_UNPACK_BUFFER_ARB = $88EC;
  GL_PIXEL_UNPACK_BUFFER_EXT = $88EC;
  GL_PIXEL_UNPACK_BUFFER_NV = $88EC;
  GL_PIXEL_PACK_BUFFER_BINDING = $88ED;
  GL_PIXEL_PACK_BUFFER_BINDING_ARB = $88ED;
  GL_PIXEL_PACK_BUFFER_BINDING_EXT = $88ED;
  GL_PIXEL_PACK_BUFFER_BINDING_NV = $88ED;
  GL_ETC1_SRGB8_NV = $88EE;
  GL_PIXEL_UNPACK_BUFFER_BINDING = $88EF;
  GL_PIXEL_UNPACK_BUFFER_BINDING_ARB = $88EF;
  GL_PIXEL_UNPACK_BUFFER_BINDING_EXT = $88EF;
  GL_PIXEL_UNPACK_BUFFER_BINDING_NV = $88EF;
  GL_DEPTH24_STENCIL8 = $88F0;
  GL_DEPTH24_STENCIL8_EXT = $88F0;
  GL_DEPTH24_STENCIL8_OES = $88F0;
  GL_TEXTURE_STENCIL_SIZE = $88F1;
  GL_TEXTURE_STENCIL_SIZE_EXT = $88F1;
  GL_STENCIL_TAG_BITS_EXT = $88F2;
  GL_STENCIL_CLEAR_TAG_VALUE_EXT = $88F3;
  GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV = $88F4;
  GL_MAX_PROGRAM_CALL_DEPTH_NV = $88F5;
  GL_MAX_PROGRAM_IF_DEPTH_NV = $88F6;
  GL_MAX_PROGRAM_LOOP_DEPTH_NV = $88F7;
  GL_MAX_PROGRAM_LOOP_COUNT_NV = $88F8;
  GL_SRC1_COLOR = $88F9;
  GL_SRC1_COLOR_EXT = $88F9;
  GL_ONE_MINUS_SRC1_COLOR = $88FA;
  GL_ONE_MINUS_SRC1_COLOR_EXT = $88FA;
  GL_ONE_MINUS_SRC1_ALPHA = $88FB;
  GL_ONE_MINUS_SRC1_ALPHA_EXT = $88FB;
  GL_MAX_DUAL_SOURCE_DRAW_BUFFERS = $88FC;
  GL_MAX_DUAL_SOURCE_DRAW_BUFFERS_EXT = $88FC;
  GL_VERTEX_ATTRIB_ARRAY_INTEGER = $88FD;
  GL_VERTEX_ATTRIB_ARRAY_INTEGER_EXT = $88FD;
  GL_VERTEX_ATTRIB_ARRAY_INTEGER_NV = $88FD;
  GL_VERTEX_ATTRIB_ARRAY_DIVISOR = $88FE;
  GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ANGLE = $88FE;
  GL_VERTEX_ATTRIB_ARRAY_DIVISOR_ARB = $88FE;
  GL_VERTEX_ATTRIB_ARRAY_DIVISOR_EXT = $88FE;
  GL_VERTEX_ATTRIB_ARRAY_DIVISOR_NV = $88FE;
  GL_MAX_ARRAY_TEXTURE_LAYERS = $88FF;
  GL_MAX_ARRAY_TEXTURE_LAYERS_EXT = $88FF;
  GL_MIN_PROGRAM_TEXEL_OFFSET = $8904;
  GL_MIN_PROGRAM_TEXEL_OFFSET_EXT = $8904;
  GL_MIN_PROGRAM_TEXEL_OFFSET_NV = $8904;
  GL_MAX_PROGRAM_TEXEL_OFFSET = $8905;
  GL_MAX_PROGRAM_TEXEL_OFFSET_EXT = $8905;
  GL_MAX_PROGRAM_TEXEL_OFFSET_NV = $8905;
  GL_PROGRAM_ATTRIB_COMPONENTS_NV = $8906;
  GL_PROGRAM_RESULT_COMPONENTS_NV = $8907;
  GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV = $8908;
  GL_MAX_PROGRAM_RESULT_COMPONENTS_NV = $8909;
  GL_STENCIL_TEST_TWO_SIDE_EXT = $8910;
  GL_ACTIVE_STENCIL_FACE_EXT = $8911;
  GL_MIRROR_CLAMP_TO_BORDER_EXT = $8912;
  GL_SAMPLES_PASSED = $8914;
  GL_SAMPLES_PASSED_ARB = $8914;
  GL_GEOMETRY_VERTICES_OUT = $8916;
  GL_GEOMETRY_LINKED_VERTICES_OUT_EXT = $8916;
  GL_GEOMETRY_LINKED_VERTICES_OUT_OES = $8916;
  GL_GEOMETRY_INPUT_TYPE = $8917;
  GL_GEOMETRY_LINKED_INPUT_TYPE_EXT = $8917;
  GL_GEOMETRY_LINKED_INPUT_TYPE_OES = $8917;
  GL_GEOMETRY_OUTPUT_TYPE = $8918;
  GL_GEOMETRY_LINKED_OUTPUT_TYPE_EXT = $8918;
  GL_GEOMETRY_LINKED_OUTPUT_TYPE_OES = $8918;
  GL_SAMPLER_BINDING = $8919;
  GL_CLAMP_VERTEX_COLOR = $891A;
  GL_CLAMP_VERTEX_COLOR_ARB = $891A;
  GL_CLAMP_FRAGMENT_COLOR = $891B;
  GL_CLAMP_FRAGMENT_COLOR_ARB = $891B;
  GL_CLAMP_READ_COLOR = $891C;
  GL_CLAMP_READ_COLOR_ARB = $891C;
  GL_FIXED_ONLY = $891D;
  GL_FIXED_ONLY_ARB = $891D;
  GL_TESS_CONTROL_PROGRAM_NV = $891E;
  GL_TESS_EVALUATION_PROGRAM_NV = $891F;
  GL_FRAGMENT_SHADER_ATI = $8920;
  GL_REG_0_ATI = $8921;
  GL_REG_1_ATI = $8922;
  GL_REG_2_ATI = $8923;
  GL_REG_3_ATI = $8924;
  GL_REG_4_ATI = $8925;
  GL_REG_5_ATI = $8926;
  GL_REG_6_ATI = $8927;
  GL_REG_7_ATI = $8928;
  GL_REG_8_ATI = $8929;
  GL_REG_9_ATI = $892A;
  GL_REG_10_ATI = $892B;
  GL_REG_11_ATI = $892C;
  GL_REG_12_ATI = $892D;
  GL_REG_13_ATI = $892E;
  GL_REG_14_ATI = $892F;
  GL_REG_15_ATI = $8930;
  GL_REG_16_ATI = $8931;
  GL_REG_17_ATI = $8932;
  GL_REG_18_ATI = $8933;
  GL_REG_19_ATI = $8934;
  GL_REG_20_ATI = $8935;
  GL_REG_21_ATI = $8936;
  GL_REG_22_ATI = $8937;
  GL_REG_23_ATI = $8938;
  GL_REG_24_ATI = $8939;
  GL_REG_25_ATI = $893A;
  GL_REG_26_ATI = $893B;
  GL_REG_27_ATI = $893C;
  GL_REG_28_ATI = $893D;
  GL_REG_29_ATI = $893E;
  GL_REG_30_ATI = $893F;
  GL_REG_31_ATI = $8940;
  GL_CON_0_ATI = $8941;
  GL_CON_1_ATI = $8942;
  GL_CON_2_ATI = $8943;
  GL_CON_3_ATI = $8944;
  GL_CON_4_ATI = $8945;
  GL_CON_5_ATI = $8946;
  GL_CON_6_ATI = $8947;
  GL_CON_7_ATI = $8948;
  GL_CON_8_ATI = $8949;
  GL_CON_9_ATI = $894A;
  GL_CON_10_ATI = $894B;
  GL_CON_11_ATI = $894C;
  GL_CON_12_ATI = $894D;
  GL_CON_13_ATI = $894E;
  GL_CON_14_ATI = $894F;
  GL_CON_15_ATI = $8950;
  GL_CON_16_ATI = $8951;
  GL_CON_17_ATI = $8952;
  GL_CON_18_ATI = $8953;
  GL_CON_19_ATI = $8954;
  GL_CON_20_ATI = $8955;
  GL_CON_21_ATI = $8956;
  GL_CON_22_ATI = $8957;
  GL_CON_23_ATI = $8958;
  GL_CON_24_ATI = $8959;
  GL_CON_25_ATI = $895A;
  GL_CON_26_ATI = $895B;
  GL_CON_27_ATI = $895C;
  GL_CON_28_ATI = $895D;
  GL_CON_29_ATI = $895E;
  GL_CON_30_ATI = $895F;
  GL_CON_31_ATI = $8960;
  GL_MOV_ATI = $8961;
  GL_ADD_ATI = $8963;
  GL_MUL_ATI = $8964;
  GL_SUB_ATI = $8965;
  GL_DOT3_ATI = $8966;
  GL_DOT4_ATI = $8967;
  GL_MAD_ATI = $8968;
  GL_LERP_ATI = $8969;
  GL_CND_ATI = $896A;
  GL_CND0_ATI = $896B;
  GL_DOT2_ADD_ATI = $896C;
  GL_SECONDARY_INTERPOLATOR_ATI = $896D;
  GL_NUM_FRAGMENT_REGISTERS_ATI = $896E;
  GL_NUM_FRAGMENT_CONSTANTS_ATI = $896F;
  GL_NUM_PASSES_ATI = $8970;
  GL_NUM_INSTRUCTIONS_PER_PASS_ATI = $8971;
  GL_NUM_INSTRUCTIONS_TOTAL_ATI = $8972;
  GL_NUM_INPUT_INTERPOLATOR_COMPONENTS_ATI = $8973;
  GL_NUM_LOOPBACK_COMPONENTS_ATI = $8974;
  GL_COLOR_ALPHA_PAIRING_ATI = $8975;
  GL_SWIZZLE_STR_ATI = $8976;
  GL_SWIZZLE_STQ_ATI = $8977;
  GL_SWIZZLE_STR_DR_ATI = $8978;
  GL_SWIZZLE_STQ_DQ_ATI = $8979;
  GL_SWIZZLE_STRQ_ATI = $897A;
  GL_SWIZZLE_STRQ_DQ_ATI = $897B;
  GL_INTERLACE_OML = $8980;
  GL_INTERLACE_READ_OML = $8981;
  GL_FORMAT_SUBSAMPLE_24_24_OML = $8982;
  GL_FORMAT_SUBSAMPLE_244_244_OML = $8983;
  GL_PACK_RESAMPLE_OML = $8984;
  GL_UNPACK_RESAMPLE_OML = $8985;
  GL_RESAMPLE_REPLICATE_OML = $8986;
  GL_RESAMPLE_ZERO_FILL_OML = $8987;
  GL_RESAMPLE_AVERAGE_OML = $8988;
  GL_RESAMPLE_DECIMATE_OML = $8989;
  GL_POINT_SIZE_ARRAY_TYPE_OES = $898A;
  GL_POINT_SIZE_ARRAY_STRIDE_OES = $898B;
  GL_POINT_SIZE_ARRAY_POINTER_OES = $898C;
  GL_MODELVIEW_MATRIX_FLOAT_AS_INT_BITS_OES = $898D;
  GL_PROJECTION_MATRIX_FLOAT_AS_INT_BITS_OES = $898E;
  GL_TEXTURE_MATRIX_FLOAT_AS_INT_BITS_OES = $898F;
  GL_VERTEX_ATTRIB_MAP1_APPLE = $8A00;
  GL_VERTEX_ATTRIB_MAP2_APPLE = $8A01;
  GL_VERTEX_ATTRIB_MAP1_SIZE_APPLE = $8A02;
  GL_VERTEX_ATTRIB_MAP1_COEFF_APPLE = $8A03;
  GL_VERTEX_ATTRIB_MAP1_ORDER_APPLE = $8A04;
  GL_VERTEX_ATTRIB_MAP1_DOMAIN_APPLE = $8A05;
  GL_VERTEX_ATTRIB_MAP2_SIZE_APPLE = $8A06;
  GL_VERTEX_ATTRIB_MAP2_COEFF_APPLE = $8A07;
  GL_VERTEX_ATTRIB_MAP2_ORDER_APPLE = $8A08;
  GL_VERTEX_ATTRIB_MAP2_DOMAIN_APPLE = $8A09;
  GL_DRAW_PIXELS_APPLE = $8A0A;
  GL_FENCE_APPLE = $8A0B;
  GL_ELEMENT_ARRAY_APPLE = $8A0C;
  GL_ELEMENT_ARRAY_TYPE_APPLE = $8A0D;
  GL_ELEMENT_ARRAY_POINTER_APPLE = $8A0E;
  GL_COLOR_FLOAT_APPLE = $8A0F;
  GL_UNIFORM_BUFFER = $8A11;
  GL_BUFFER_SERIALIZED_MODIFY_APPLE = $8A12;
  GL_BUFFER_FLUSHING_UNMAP_APPLE = $8A13;
  GL_AUX_DEPTH_STENCIL_APPLE = $8A14;
  GL_PACK_ROW_BYTES_APPLE = $8A15;
  GL_UNPACK_ROW_BYTES_APPLE = $8A16;
  GL_RELEASED_APPLE = $8A19;
  GL_VOLATILE_APPLE = $8A1A;
  GL_RETAINED_APPLE = $8A1B;
  GL_UNDEFINED_APPLE = $8A1C;
  GL_PURGEABLE_APPLE = $8A1D;
  GL_RGB_422_APPLE = $8A1F;
  GL_UNIFORM_BUFFER_BINDING = $8A28;
  GL_UNIFORM_BUFFER_START = $8A29;
  GL_UNIFORM_BUFFER_SIZE = $8A2A;
  GL_MAX_VERTEX_UNIFORM_BLOCKS = $8A2B;
  GL_MAX_GEOMETRY_UNIFORM_BLOCKS = $8A2C;
  GL_MAX_GEOMETRY_UNIFORM_BLOCKS_EXT = $8A2C;
  GL_MAX_GEOMETRY_UNIFORM_BLOCKS_OES = $8A2C;
  GL_MAX_FRAGMENT_UNIFORM_BLOCKS = $8A2D;
  GL_MAX_COMBINED_UNIFORM_BLOCKS = $8A2E;
  GL_MAX_UNIFORM_BUFFER_BINDINGS = $8A2F;
  GL_MAX_UNIFORM_BLOCK_SIZE = $8A30;
  GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS = $8A31;
  GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS = $8A32;
  GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_EXT = $8A32;
  GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS_OES = $8A32;
  GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS = $8A33;
  GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT = $8A34;
  GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH = $8A35;
  GL_ACTIVE_UNIFORM_BLOCKS = $8A36;
  GL_UNIFORM_TYPE = $8A37;
  GL_UNIFORM_SIZE = $8A38;
  GL_UNIFORM_NAME_LENGTH = $8A39;
  GL_UNIFORM_BLOCK_INDEX = $8A3A;
  GL_UNIFORM_OFFSET = $8A3B;
  GL_UNIFORM_ARRAY_STRIDE = $8A3C;
  GL_UNIFORM_MATRIX_STRIDE = $8A3D;
  GL_UNIFORM_IS_ROW_MAJOR = $8A3E;
  GL_UNIFORM_BLOCK_BINDING = $8A3F;
  GL_UNIFORM_BLOCK_DATA_SIZE = $8A40;
  GL_UNIFORM_BLOCK_NAME_LENGTH = $8A41;
  GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS = $8A42;
  GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES = $8A43;
  GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER = $8A44;
  GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER = $8A45;
  GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER = $8A46;
  GL_TEXTURE_SRGB_DECODE_EXT = $8A48;
  GL_DECODE_EXT = $8A49;
  GL_SKIP_DECODE_EXT = $8A4A;
  GL_PROGRAM_PIPELINE_OBJECT_EXT = $8A4F;
  GL_RGB_RAW_422_APPLE = $8A51;
  GL_FRAGMENT_SHADER_DISCARDS_SAMPLES_EXT = $8A52;
  GL_SYNC_OBJECT_APPLE = $8A53;
  GL_COMPRESSED_SRGB_PVRTC_2BPPV1_EXT = $8A54;
  GL_COMPRESSED_SRGB_PVRTC_4BPPV1_EXT = $8A55;
  GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV1_EXT = $8A56;
  GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV1_EXT = $8A57;
  GL_FRAGMENT_SHADER = $8B30;
  GL_FRAGMENT_SHADER_ARB = $8B30;
  GL_VERTEX_SHADER = $8B31;
  GL_VERTEX_SHADER_ARB = $8B31;
  GL_PROGRAM_OBJECT_ARB = $8B40;
  GL_PROGRAM_OBJECT_EXT = $8B40;
  GL_SHADER_OBJECT_ARB = $8B48;
  GL_SHADER_OBJECT_EXT = $8B48;
  GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = $8B49;
  GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB = $8B49;
  GL_MAX_VERTEX_UNIFORM_COMPONENTS = $8B4A;
  GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB = $8B4A;
  GL_MAX_VARYING_FLOATS = $8B4B;
  GL_MAX_VARYING_COMPONENTS = $8B4B;
  GL_MAX_VARYING_COMPONENTS_EXT = $8B4B;
  GL_MAX_VARYING_FLOATS_ARB = $8B4B;
  GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = $8B4C;
  GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB = $8B4C;
  GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = $8B4D;
  GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB = $8B4D;
  GL_OBJECT_TYPE_ARB = $8B4E;
  GL_SHADER_TYPE = $8B4F;
  GL_OBJECT_SUBTYPE_ARB = $8B4F;
  GL_FLOAT_VEC2 = $8B50;
  GL_FLOAT_VEC2_ARB = $8B50;
  GL_FLOAT_VEC3 = $8B51;
  GL_FLOAT_VEC3_ARB = $8B51;
  GL_FLOAT_VEC4 = $8B52;
  GL_FLOAT_VEC4_ARB = $8B52;
  GL_INT_VEC2 = $8B53;
  GL_INT_VEC2_ARB = $8B53;
  GL_INT_VEC3 = $8B54;
  GL_INT_VEC3_ARB = $8B54;
  GL_INT_VEC4 = $8B55;
  GL_INT_VEC4_ARB = $8B55;
  GL_BOOL = $8B56;
  GL_BOOL_ARB = $8B56;
  GL_BOOL_VEC2 = $8B57;
  GL_BOOL_VEC2_ARB = $8B57;
  GL_BOOL_VEC3 = $8B58;
  GL_BOOL_VEC3_ARB = $8B58;
  GL_BOOL_VEC4 = $8B59;
  GL_BOOL_VEC4_ARB = $8B59;
  GL_FLOAT_MAT2 = $8B5A;
  GL_FLOAT_MAT2_ARB = $8B5A;
  GL_FLOAT_MAT3 = $8B5B;
  GL_FLOAT_MAT3_ARB = $8B5B;
  GL_FLOAT_MAT4 = $8B5C;
  GL_FLOAT_MAT4_ARB = $8B5C;
  GL_SAMPLER_1D = $8B5D;
  GL_SAMPLER_1D_ARB = $8B5D;
  GL_SAMPLER_2D = $8B5E;
  GL_SAMPLER_2D_ARB = $8B5E;
  GL_SAMPLER_3D = $8B5F;
  GL_SAMPLER_3D_ARB = $8B5F;
  GL_SAMPLER_3D_OES = $8B5F;
  GL_SAMPLER_CUBE = $8B60;
  GL_SAMPLER_CUBE_ARB = $8B60;
  GL_SAMPLER_1D_SHADOW = $8B61;
  GL_SAMPLER_1D_SHADOW_ARB = $8B61;
  GL_SAMPLER_2D_SHADOW = $8B62;
  GL_SAMPLER_2D_SHADOW_ARB = $8B62;
  GL_SAMPLER_2D_SHADOW_EXT = $8B62;
  GL_SAMPLER_2D_RECT = $8B63;
  GL_SAMPLER_2D_RECT_ARB = $8B63;
  GL_SAMPLER_2D_RECT_SHADOW = $8B64;
  GL_SAMPLER_2D_RECT_SHADOW_ARB = $8B64;
  GL_FLOAT_MAT2x3 = $8B65;
  GL_FLOAT_MAT2x3_NV = $8B65;
  GL_FLOAT_MAT2x4 = $8B66;
  GL_FLOAT_MAT2x4_NV = $8B66;
  GL_FLOAT_MAT3x2 = $8B67;
  GL_FLOAT_MAT3x2_NV = $8B67;
  GL_FLOAT_MAT3x4 = $8B68;
  GL_FLOAT_MAT3x4_NV = $8B68;
  GL_FLOAT_MAT4x2 = $8B69;
  GL_FLOAT_MAT4x2_NV = $8B69;
  GL_FLOAT_MAT4x3 = $8B6A;
  GL_FLOAT_MAT4x3_NV = $8B6A;
  GL_DELETE_STATUS = $8B80;
  GL_OBJECT_DELETE_STATUS_ARB = $8B80;
  GL_COMPILE_STATUS = $8B81;
  GL_OBJECT_COMPILE_STATUS_ARB = $8B81;
  GL_LINK_STATUS = $8B82;
  GL_OBJECT_LINK_STATUS_ARB = $8B82;
  GL_VALIDATE_STATUS = $8B83;
  GL_OBJECT_VALIDATE_STATUS_ARB = $8B83;
  GL_INFO_LOG_LENGTH = $8B84;
  GL_OBJECT_INFO_LOG_LENGTH_ARB = $8B84;
  GL_ATTACHED_SHADERS = $8B85;
  GL_OBJECT_ATTACHED_OBJECTS_ARB = $8B85;
  GL_ACTIVE_UNIFORMS = $8B86;
  GL_OBJECT_ACTIVE_UNIFORMS_ARB = $8B86;
  GL_ACTIVE_UNIFORM_MAX_LENGTH = $8B87;
  GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = $8B87;
  GL_SHADER_SOURCE_LENGTH = $8B88;
  GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = $8B88;
  GL_ACTIVE_ATTRIBUTES = $8B89;
  GL_OBJECT_ACTIVE_ATTRIBUTES_ARB = $8B89;
  GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = $8B8A;
  GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB = $8B8A;
  GL_FRAGMENT_SHADER_DERIVATIVE_HINT = $8B8B;
  GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB = $8B8B;
  GL_FRAGMENT_SHADER_DERIVATIVE_HINT_OES = $8B8B;
  GL_SHADING_LANGUAGE_VERSION = $8B8C;
  GL_SHADING_LANGUAGE_VERSION_ARB = $8B8C;
  GL_CURRENT_PROGRAM = $8B8D;
  GL_ACTIVE_PROGRAM_EXT = $8B8D;
  GL_PALETTE4_RGB8_OES = $8B90;
  GL_PALETTE4_RGBA8_OES = $8B91;
  GL_PALETTE4_R5_G6_B5_OES = $8B92;
  GL_PALETTE4_RGBA4_OES = $8B93;
  GL_PALETTE4_RGB5_A1_OES = $8B94;
  GL_PALETTE8_RGB8_OES = $8B95;
  GL_PALETTE8_RGBA8_OES = $8B96;
  GL_PALETTE8_R5_G6_B5_OES = $8B97;
  GL_PALETTE8_RGBA4_OES = $8B98;
  GL_PALETTE8_RGB5_A1_OES = $8B99;
  GL_IMPLEMENTATION_COLOR_READ_TYPE = $8B9A;
  GL_IMPLEMENTATION_COLOR_READ_TYPE_OES = $8B9A;
  GL_IMPLEMENTATION_COLOR_READ_FORMAT = $8B9B;
  GL_IMPLEMENTATION_COLOR_READ_FORMAT_OES = $8B9B;
  GL_POINT_SIZE_ARRAY_OES = $8B9C;
  GL_TEXTURE_CROP_RECT_OES = $8B9D;
  GL_MATRIX_INDEX_ARRAY_BUFFER_BINDING_OES = $8B9E;
  GL_POINT_SIZE_ARRAY_BUFFER_BINDING_OES = $8B9F;
  GL_FRAGMENT_PROGRAM_POSITION_MESA = $8BB0;
  GL_FRAGMENT_PROGRAM_CALLBACK_MESA = $8BB1;
  GL_FRAGMENT_PROGRAM_CALLBACK_FUNC_MESA = $8BB2;
  GL_FRAGMENT_PROGRAM_CALLBACK_DATA_MESA = $8BB3;
  GL_VERTEX_PROGRAM_POSITION_MESA = $8BB4;
  GL_VERTEX_PROGRAM_CALLBACK_MESA = $8BB5;
  GL_VERTEX_PROGRAM_CALLBACK_FUNC_MESA = $8BB6;
  GL_VERTEX_PROGRAM_CALLBACK_DATA_MESA = $8BB7;
  GL_COUNTER_TYPE_AMD = $8BC0;
  GL_COUNTER_RANGE_AMD = $8BC1;
  GL_UNSIGNED_INT64_AMD = $8BC2;
  GL_PERCENTAGE_AMD = $8BC3;
  GL_PERFMON_RESULT_AVAILABLE_AMD = $8BC4;
  GL_PERFMON_RESULT_SIZE_AMD = $8BC5;
  GL_PERFMON_RESULT_AMD = $8BC6;
  GL_TEXTURE_WIDTH_QCOM = $8BD2;
  GL_TEXTURE_HEIGHT_QCOM = $8BD3;
  GL_TEXTURE_DEPTH_QCOM = $8BD4;
  GL_TEXTURE_INTERNAL_FORMAT_QCOM = $8BD5;
  GL_TEXTURE_FORMAT_QCOM = $8BD6;
  GL_TEXTURE_TYPE_QCOM = $8BD7;
  GL_TEXTURE_IMAGE_VALID_QCOM = $8BD8;
  GL_TEXTURE_NUM_LEVELS_QCOM = $8BD9;
  GL_TEXTURE_TARGET_QCOM = $8BDA;
  GL_TEXTURE_OBJECT_VALID_QCOM = $8BDB;
  GL_STATE_RESTORE = $8BDC;
  GL_SAMPLER_EXTERNAL_2D_Y2Y_EXT = $8BE7;
  GL_TEXTURE_PROTECTED_EXT = $8BFA;
  GL_COMPRESSED_RGB_PVRTC_4BPPV1_IMG = $8C00;
  GL_COMPRESSED_RGB_PVRTC_2BPPV1_IMG = $8C01;
  GL_COMPRESSED_RGBA_PVRTC_4BPPV1_IMG = $8C02;
  GL_COMPRESSED_RGBA_PVRTC_2BPPV1_IMG = $8C03;
  GL_MODULATE_COLOR_IMG = $8C04;
  GL_RECIP_ADD_SIGNED_ALPHA_IMG = $8C05;
  GL_TEXTURE_ALPHA_MODULATE_IMG = $8C06;
  GL_FACTOR_ALPHA_MODULATE_IMG = $8C07;
  GL_FRAGMENT_ALPHA_MODULATE_IMG = $8C08;
  GL_ADD_BLEND_IMG = $8C09;
  GL_SGX_BINARY_IMG = $8C0A;
  GL_TEXTURE_RED_TYPE = $8C10;
  GL_TEXTURE_RED_TYPE_ARB = $8C10;
  GL_TEXTURE_GREEN_TYPE = $8C11;
  GL_TEXTURE_GREEN_TYPE_ARB = $8C11;
  GL_TEXTURE_BLUE_TYPE = $8C12;
  GL_TEXTURE_BLUE_TYPE_ARB = $8C12;
  GL_TEXTURE_ALPHA_TYPE = $8C13;
  GL_TEXTURE_ALPHA_TYPE_ARB = $8C13;
  GL_TEXTURE_LUMINANCE_TYPE = $8C14;
  GL_TEXTURE_LUMINANCE_TYPE_ARB = $8C14;
  GL_TEXTURE_INTENSITY_TYPE = $8C15;
  GL_TEXTURE_INTENSITY_TYPE_ARB = $8C15;
  GL_TEXTURE_DEPTH_TYPE = $8C16;
  GL_TEXTURE_DEPTH_TYPE_ARB = $8C16;
  GL_UNSIGNED_NORMALIZED = $8C17;
  GL_UNSIGNED_NORMALIZED_ARB = $8C17;
  GL_UNSIGNED_NORMALIZED_EXT = $8C17;
  GL_TEXTURE_1D_ARRAY = $8C18;
  GL_TEXTURE_1D_ARRAY_EXT = $8C18;
  GL_PROXY_TEXTURE_1D_ARRAY = $8C19;
  GL_PROXY_TEXTURE_1D_ARRAY_EXT = $8C19;
  GL_TEXTURE_2D_ARRAY = $8C1A;
  GL_TEXTURE_2D_ARRAY_EXT = $8C1A;
  GL_PROXY_TEXTURE_2D_ARRAY = $8C1B;
  GL_PROXY_TEXTURE_2D_ARRAY_EXT = $8C1B;
  GL_TEXTURE_BINDING_1D_ARRAY = $8C1C;
  GL_TEXTURE_BINDING_1D_ARRAY_EXT = $8C1C;
  GL_TEXTURE_BINDING_2D_ARRAY = $8C1D;
  GL_TEXTURE_BINDING_2D_ARRAY_EXT = $8C1D;
  GL_GEOMETRY_PROGRAM_NV = $8C26;
  GL_MAX_PROGRAM_OUTPUT_VERTICES_NV = $8C27;
  GL_MAX_PROGRAM_TOTAL_OUTPUT_COMPONENTS_NV = $8C28;
  GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = $8C29;
  GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB = $8C29;
  GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT = $8C29;
  GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_OES = $8C29;
  GL_TEXTURE_BUFFER = $8C2A;
  GL_TEXTURE_BUFFER_ARB = $8C2A;
  GL_TEXTURE_BUFFER_EXT = $8C2A;
  GL_TEXTURE_BUFFER_OES = $8C2A;
  GL_TEXTURE_BUFFER_BINDING = $8C2A;
  GL_TEXTURE_BUFFER_BINDING_EXT = $8C2A;
  GL_TEXTURE_BUFFER_BINDING_OES = $8C2A;
  GL_MAX_TEXTURE_BUFFER_SIZE = $8C2B;
  GL_MAX_TEXTURE_BUFFER_SIZE_ARB = $8C2B;
  GL_MAX_TEXTURE_BUFFER_SIZE_EXT = $8C2B;
  GL_MAX_TEXTURE_BUFFER_SIZE_OES = $8C2B;
  GL_TEXTURE_BINDING_BUFFER = $8C2C;
  GL_TEXTURE_BINDING_BUFFER_ARB = $8C2C;
  GL_TEXTURE_BINDING_BUFFER_EXT = $8C2C;
  GL_TEXTURE_BINDING_BUFFER_OES = $8C2C;
  GL_TEXTURE_BUFFER_DATA_STORE_BINDING = $8C2D;
  GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB = $8C2D;
  GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT = $8C2D;
  GL_TEXTURE_BUFFER_DATA_STORE_BINDING_OES = $8C2D;
  GL_TEXTURE_BUFFER_FORMAT_ARB = $8C2E;
  GL_TEXTURE_BUFFER_FORMAT_EXT = $8C2E;
  GL_ANY_SAMPLES_PASSED = $8C2F;
  GL_ANY_SAMPLES_PASSED_EXT = $8C2F;
  GL_SAMPLE_SHADING = $8C36;
  GL_SAMPLE_SHADING_ARB = $8C36;
  GL_SAMPLE_SHADING_OES = $8C36;
  GL_MIN_SAMPLE_SHADING_VALUE = $8C37;
  GL_MIN_SAMPLE_SHADING_VALUE_ARB = $8C37;
  GL_MIN_SAMPLE_SHADING_VALUE_OES = $8C37;
  GL_R11F_G11F_B10F = $8C3A;
  GL_R11F_G11F_B10F_APPLE = $8C3A;
  GL_R11F_G11F_B10F_EXT = $8C3A;
  GL_UNSIGNED_INT_10F_11F_11F_REV = $8C3B;
  GL_UNSIGNED_INT_10F_11F_11F_REV_APPLE = $8C3B;
  GL_UNSIGNED_INT_10F_11F_11F_REV_EXT = $8C3B;
  GL_RGBA_SIGNED_COMPONENTS_EXT = $8C3C;
  GL_RGB9_E5 = $8C3D;
  GL_RGB9_E5_APPLE = $8C3D;
  GL_RGB9_E5_EXT = $8C3D;
  GL_UNSIGNED_INT_5_9_9_9_REV = $8C3E;
  GL_UNSIGNED_INT_5_9_9_9_REV_APPLE = $8C3E;
  GL_UNSIGNED_INT_5_9_9_9_REV_EXT = $8C3E;
  GL_TEXTURE_SHARED_SIZE = $8C3F;
  GL_TEXTURE_SHARED_SIZE_EXT = $8C3F;
  GL_SRGB = $8C40;
  GL_SRGB_EXT = $8C40;
  GL_SRGB8 = $8C41;
  GL_SRGB8_EXT = $8C41;
  GL_SRGB8_NV = $8C41;
  GL_SRGB_ALPHA = $8C42;
  GL_SRGB_ALPHA_EXT = $8C42;
  GL_SRGB8_ALPHA8 = $8C43;
  GL_SRGB8_ALPHA8_EXT = $8C43;
  GL_SLUMINANCE_ALPHA = $8C44;
  GL_SLUMINANCE_ALPHA_EXT = $8C44;
  GL_SLUMINANCE_ALPHA_NV = $8C44;
  GL_SLUMINANCE8_ALPHA8 = $8C45;
  GL_SLUMINANCE8_ALPHA8_EXT = $8C45;
  GL_SLUMINANCE8_ALPHA8_NV = $8C45;
  GL_SLUMINANCE = $8C46;
  GL_SLUMINANCE_EXT = $8C46;
  GL_SLUMINANCE_NV = $8C46;
  GL_SLUMINANCE8 = $8C47;
  GL_SLUMINANCE8_EXT = $8C47;
  GL_SLUMINANCE8_NV = $8C47;
  GL_COMPRESSED_SRGB = $8C48;
  GL_COMPRESSED_SRGB_EXT = $8C48;
  GL_COMPRESSED_SRGB_ALPHA = $8C49;
  GL_COMPRESSED_SRGB_ALPHA_EXT = $8C49;
  GL_COMPRESSED_SLUMINANCE = $8C4A;
  GL_COMPRESSED_SLUMINANCE_EXT = $8C4A;
  GL_COMPRESSED_SLUMINANCE_ALPHA = $8C4B;
  GL_COMPRESSED_SLUMINANCE_ALPHA_EXT = $8C4B;
  GL_COMPRESSED_SRGB_S3TC_DXT1_EXT = $8C4C;
  GL_COMPRESSED_SRGB_S3TC_DXT1_NV = $8C4C;
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT = $8C4D;
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_NV = $8C4D;
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT = $8C4E;
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_NV = $8C4E;
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT = $8C4F;
  GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_NV = $8C4F;
  GL_COMPRESSED_LUMINANCE_LATC1_EXT = $8C70;
  GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT = $8C71;
  GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT = $8C72;
  GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT = $8C73;
  GL_TESS_CONTROL_PROGRAM_PARAMETER_BUFFER_NV = $8C74;
  GL_TESS_EVALUATION_PROGRAM_PARAMETER_BUFFER_NV = $8C75;
  GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH = $8C76;
  GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT = $8C76;
  GL_BACK_PRIMARY_COLOR_NV = $8C77;
  GL_BACK_SECONDARY_COLOR_NV = $8C78;
  GL_TEXTURE_COORD_NV = $8C79;
  GL_CLIP_DISTANCE_NV = $8C7A;
  GL_VERTEX_ID_NV = $8C7B;
  GL_PRIMITIVE_ID_NV = $8C7C;
  GL_GENERIC_ATTRIB_NV = $8C7D;
  GL_TRANSFORM_FEEDBACK_ATTRIBS_NV = $8C7E;
  GL_TRANSFORM_FEEDBACK_BUFFER_MODE = $8C7F;
  GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT = $8C7F;
  GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV = $8C7F;
  GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS = $8C80;
  GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT = $8C80;
  GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV = $8C80;
  GL_ACTIVE_VARYINGS_NV = $8C81;
  GL_ACTIVE_VARYING_MAX_LENGTH_NV = $8C82;
  GL_TRANSFORM_FEEDBACK_VARYINGS = $8C83;
  GL_TRANSFORM_FEEDBACK_VARYINGS_EXT = $8C83;
  GL_TRANSFORM_FEEDBACK_VARYINGS_NV = $8C83;
  GL_TRANSFORM_FEEDBACK_BUFFER_START = $8C84;
  GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT = $8C84;
  GL_TRANSFORM_FEEDBACK_BUFFER_START_NV = $8C84;
  GL_TRANSFORM_FEEDBACK_BUFFER_SIZE = $8C85;
  GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT = $8C85;
  GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV = $8C85;
  GL_TRANSFORM_FEEDBACK_RECORD_NV = $8C86;
  GL_PRIMITIVES_GENERATED = $8C87;
  GL_PRIMITIVES_GENERATED_EXT = $8C87;
  GL_PRIMITIVES_GENERATED_NV = $8C87;
  GL_PRIMITIVES_GENERATED_OES = $8C87;
  GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN = $8C88;
  GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT = $8C88;
  GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV = $8C88;
  GL_RASTERIZER_DISCARD = $8C89;
  GL_RASTERIZER_DISCARD_EXT = $8C89;
  GL_RASTERIZER_DISCARD_NV = $8C89;
  GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS = $8C8A;
  GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT = $8C8A;
  GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV = $8C8A;
  GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS = $8C8B;
  GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT = $8C8B;
  GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV = $8C8B;
  GL_INTERLEAVED_ATTRIBS = $8C8C;
  GL_INTERLEAVED_ATTRIBS_EXT = $8C8C;
  GL_INTERLEAVED_ATTRIBS_NV = $8C8C;
  GL_SEPARATE_ATTRIBS = $8C8D;
  GL_SEPARATE_ATTRIBS_EXT = $8C8D;
  GL_SEPARATE_ATTRIBS_NV = $8C8D;
  GL_TRANSFORM_FEEDBACK_BUFFER = $8C8E;
  GL_TRANSFORM_FEEDBACK_BUFFER_EXT = $8C8E;
  GL_TRANSFORM_FEEDBACK_BUFFER_NV = $8C8E;
  GL_TRANSFORM_FEEDBACK_BUFFER_BINDING = $8C8F;
  GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT = $8C8F;
  GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV = $8C8F;
  GL_ATC_RGB_AMD = $8C92;
  GL_ATC_RGBA_EXPLICIT_ALPHA_AMD = $8C93;
  GL_POINT_SPRITE_COORD_ORIGIN = $8CA0;
  GL_LOWER_LEFT = $8CA1;
  GL_UPPER_LEFT = $8CA2;
  GL_STENCIL_BACK_REF = $8CA3;
  GL_STENCIL_BACK_VALUE_MASK = $8CA4;
  GL_STENCIL_BACK_WRITEMASK = $8CA5;
  GL_DRAW_FRAMEBUFFER_BINDING = $8CA6;
  GL_DRAW_FRAMEBUFFER_BINDING_ANGLE = $8CA6;
  GL_DRAW_FRAMEBUFFER_BINDING_APPLE = $8CA6;
  GL_DRAW_FRAMEBUFFER_BINDING_EXT = $8CA6;
  GL_DRAW_FRAMEBUFFER_BINDING_NV = $8CA6;
  GL_FRAMEBUFFER_BINDING = $8CA6;
  GL_FRAMEBUFFER_BINDING_ANGLE = $8CA6;
  GL_FRAMEBUFFER_BINDING_EXT = $8CA6;
  GL_FRAMEBUFFER_BINDING_OES = $8CA6;
  GL_RENDERBUFFER_BINDING = $8CA7;
  GL_RENDERBUFFER_BINDING_ANGLE = $8CA7;
  GL_RENDERBUFFER_BINDING_EXT = $8CA7;
  GL_RENDERBUFFER_BINDING_OES = $8CA7;
  GL_READ_FRAMEBUFFER = $8CA8;
  GL_READ_FRAMEBUFFER_ANGLE = $8CA8;
  GL_READ_FRAMEBUFFER_APPLE = $8CA8;
  GL_READ_FRAMEBUFFER_EXT = $8CA8;
  GL_READ_FRAMEBUFFER_NV = $8CA8;
  GL_DRAW_FRAMEBUFFER = $8CA9;
  GL_DRAW_FRAMEBUFFER_ANGLE = $8CA9;
  GL_DRAW_FRAMEBUFFER_APPLE = $8CA9;
  GL_DRAW_FRAMEBUFFER_EXT = $8CA9;
  GL_DRAW_FRAMEBUFFER_NV = $8CA9;
  GL_READ_FRAMEBUFFER_BINDING = $8CAA;
  GL_READ_FRAMEBUFFER_BINDING_ANGLE = $8CAA;
  GL_READ_FRAMEBUFFER_BINDING_APPLE = $8CAA;
  GL_READ_FRAMEBUFFER_BINDING_EXT = $8CAA;
  GL_READ_FRAMEBUFFER_BINDING_NV = $8CAA;
  GL_RENDERBUFFER_COVERAGE_SAMPLES_NV = $8CAB;
  GL_RENDERBUFFER_SAMPLES = $8CAB;
  GL_RENDERBUFFER_SAMPLES_ANGLE = $8CAB;
  GL_RENDERBUFFER_SAMPLES_APPLE = $8CAB;
  GL_RENDERBUFFER_SAMPLES_EXT = $8CAB;
  GL_RENDERBUFFER_SAMPLES_NV = $8CAB;
  GL_DEPTH_COMPONENT32F = $8CAC;
  GL_DEPTH32F_STENCIL8 = $8CAD;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE = $8CD0;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT = $8CD0;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_OES = $8CD0;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME = $8CD1;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT = $8CD1;
  GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_OES = $8CD1;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL = $8CD2;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT = $8CD2;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_OES = $8CD2;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE = $8CD3;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT = $8CD3;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_OES = $8CD3;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT = $8CD4;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_OES = $8CD4;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER = $8CD4;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT = $8CD4;
  GL_FRAMEBUFFER_COMPLETE = $8CD5;
  GL_FRAMEBUFFER_COMPLETE_EXT = $8CD5;
  GL_FRAMEBUFFER_COMPLETE_OES = $8CD5;
  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT = $8CD6;
  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT = $8CD6;
  GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_OES = $8CD6;
  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT = $8CD7;
  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT = $8CD7;
  GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_OES = $8CD7;
  GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS = $8CD9;
  GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT = $8CD9;
  GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_OES = $8CD9;
  GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT = $8CDA;
  GL_FRAMEBUFFER_INCOMPLETE_FORMATS_OES = $8CDA;
  GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER = $8CDB;
  GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT = $8CDB;
  GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_OES = $8CDB;
  GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER = $8CDC;
  GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT = $8CDC;
  GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_OES = $8CDC;
  GL_FRAMEBUFFER_UNSUPPORTED = $8CDD;
  GL_FRAMEBUFFER_UNSUPPORTED_EXT = $8CDD;
  GL_FRAMEBUFFER_UNSUPPORTED_OES = $8CDD;
  GL_MAX_COLOR_ATTACHMENTS = $8CDF;
  GL_MAX_COLOR_ATTACHMENTS_EXT = $8CDF;
  GL_MAX_COLOR_ATTACHMENTS_NV = $8CDF;
  GL_COLOR_ATTACHMENT0 = $8CE0;
  GL_COLOR_ATTACHMENT0_EXT = $8CE0;
  GL_COLOR_ATTACHMENT0_NV = $8CE0;
  GL_COLOR_ATTACHMENT0_OES = $8CE0;
  GL_COLOR_ATTACHMENT1 = $8CE1;
  GL_COLOR_ATTACHMENT1_EXT = $8CE1;
  GL_COLOR_ATTACHMENT1_NV = $8CE1;
  GL_COLOR_ATTACHMENT2 = $8CE2;
  GL_COLOR_ATTACHMENT2_EXT = $8CE2;
  GL_COLOR_ATTACHMENT2_NV = $8CE2;
  GL_COLOR_ATTACHMENT3 = $8CE3;
  GL_COLOR_ATTACHMENT3_EXT = $8CE3;
  GL_COLOR_ATTACHMENT3_NV = $8CE3;
  GL_COLOR_ATTACHMENT4 = $8CE4;
  GL_COLOR_ATTACHMENT4_EXT = $8CE4;
  GL_COLOR_ATTACHMENT4_NV = $8CE4;
  GL_COLOR_ATTACHMENT5 = $8CE5;
  GL_COLOR_ATTACHMENT5_EXT = $8CE5;
  GL_COLOR_ATTACHMENT5_NV = $8CE5;
  GL_COLOR_ATTACHMENT6 = $8CE6;
  GL_COLOR_ATTACHMENT6_EXT = $8CE6;
  GL_COLOR_ATTACHMENT6_NV = $8CE6;
  GL_COLOR_ATTACHMENT7 = $8CE7;
  GL_COLOR_ATTACHMENT7_EXT = $8CE7;
  GL_COLOR_ATTACHMENT7_NV = $8CE7;
  GL_COLOR_ATTACHMENT8 = $8CE8;
  GL_COLOR_ATTACHMENT8_EXT = $8CE8;
  GL_COLOR_ATTACHMENT8_NV = $8CE8;
  GL_COLOR_ATTACHMENT9 = $8CE9;
  GL_COLOR_ATTACHMENT9_EXT = $8CE9;
  GL_COLOR_ATTACHMENT9_NV = $8CE9;
  GL_COLOR_ATTACHMENT10 = $8CEA;
  GL_COLOR_ATTACHMENT10_EXT = $8CEA;
  GL_COLOR_ATTACHMENT10_NV = $8CEA;
  GL_COLOR_ATTACHMENT11 = $8CEB;
  GL_COLOR_ATTACHMENT11_EXT = $8CEB;
  GL_COLOR_ATTACHMENT11_NV = $8CEB;
  GL_COLOR_ATTACHMENT12 = $8CEC;
  GL_COLOR_ATTACHMENT12_EXT = $8CEC;
  GL_COLOR_ATTACHMENT12_NV = $8CEC;
  GL_COLOR_ATTACHMENT13 = $8CED;
  GL_COLOR_ATTACHMENT13_EXT = $8CED;
  GL_COLOR_ATTACHMENT13_NV = $8CED;
  GL_COLOR_ATTACHMENT14 = $8CEE;
  GL_COLOR_ATTACHMENT14_EXT = $8CEE;
  GL_COLOR_ATTACHMENT14_NV = $8CEE;
  GL_COLOR_ATTACHMENT15 = $8CEF;
  GL_COLOR_ATTACHMENT15_EXT = $8CEF;
  GL_COLOR_ATTACHMENT15_NV = $8CEF;
  GL_COLOR_ATTACHMENT16 = $8CF0;
  GL_COLOR_ATTACHMENT17 = $8CF1;
  GL_COLOR_ATTACHMENT18 = $8CF2;
  GL_COLOR_ATTACHMENT19 = $8CF3;
  GL_COLOR_ATTACHMENT20 = $8CF4;
  GL_COLOR_ATTACHMENT21 = $8CF5;
  GL_COLOR_ATTACHMENT22 = $8CF6;
  GL_COLOR_ATTACHMENT23 = $8CF7;
  GL_COLOR_ATTACHMENT24 = $8CF8;
  GL_COLOR_ATTACHMENT25 = $8CF9;
  GL_COLOR_ATTACHMENT26 = $8CFA;
  GL_COLOR_ATTACHMENT27 = $8CFB;
  GL_COLOR_ATTACHMENT28 = $8CFC;
  GL_COLOR_ATTACHMENT29 = $8CFD;
  GL_COLOR_ATTACHMENT30 = $8CFE;
  GL_COLOR_ATTACHMENT31 = $8CFF;
  GL_DEPTH_ATTACHMENT = $8D00;
  GL_DEPTH_ATTACHMENT_EXT = $8D00;
  GL_DEPTH_ATTACHMENT_OES = $8D00;
  GL_STENCIL_ATTACHMENT = $8D20;
  GL_STENCIL_ATTACHMENT_EXT = $8D20;
  GL_STENCIL_ATTACHMENT_OES = $8D20;
  GL_FRAMEBUFFER = $8D40;
  GL_FRAMEBUFFER_EXT = $8D40;
  GL_FRAMEBUFFER_OES = $8D40;
  GL_RENDERBUFFER = $8D41;
  GL_RENDERBUFFER_EXT = $8D41;
  GL_RENDERBUFFER_OES = $8D41;
  GL_RENDERBUFFER_WIDTH = $8D42;
  GL_RENDERBUFFER_WIDTH_EXT = $8D42;
  GL_RENDERBUFFER_WIDTH_OES = $8D42;
  GL_RENDERBUFFER_HEIGHT = $8D43;
  GL_RENDERBUFFER_HEIGHT_EXT = $8D43;
  GL_RENDERBUFFER_HEIGHT_OES = $8D43;
  GL_RENDERBUFFER_INTERNAL_FORMAT = $8D44;
  GL_RENDERBUFFER_INTERNAL_FORMAT_EXT = $8D44;
  GL_RENDERBUFFER_INTERNAL_FORMAT_OES = $8D44;
  GL_STENCIL_INDEX1 = $8D46;
  GL_STENCIL_INDEX1_EXT = $8D46;
  GL_STENCIL_INDEX1_OES = $8D46;
  GL_STENCIL_INDEX4 = $8D47;
  GL_STENCIL_INDEX4_EXT = $8D47;
  GL_STENCIL_INDEX4_OES = $8D47;
  GL_STENCIL_INDEX8 = $8D48;
  GL_STENCIL_INDEX8_EXT = $8D48;
  GL_STENCIL_INDEX8_OES = $8D48;
  GL_STENCIL_INDEX16 = $8D49;
  GL_STENCIL_INDEX16_EXT = $8D49;
  GL_RENDERBUFFER_RED_SIZE = $8D50;
  GL_RENDERBUFFER_RED_SIZE_EXT = $8D50;
  GL_RENDERBUFFER_RED_SIZE_OES = $8D50;
  GL_RENDERBUFFER_GREEN_SIZE = $8D51;
  GL_RENDERBUFFER_GREEN_SIZE_EXT = $8D51;
  GL_RENDERBUFFER_GREEN_SIZE_OES = $8D51;
  GL_RENDERBUFFER_BLUE_SIZE = $8D52;
  GL_RENDERBUFFER_BLUE_SIZE_EXT = $8D52;
  GL_RENDERBUFFER_BLUE_SIZE_OES = $8D52;
  GL_RENDERBUFFER_ALPHA_SIZE = $8D53;
  GL_RENDERBUFFER_ALPHA_SIZE_EXT = $8D53;
  GL_RENDERBUFFER_ALPHA_SIZE_OES = $8D53;
  GL_RENDERBUFFER_DEPTH_SIZE = $8D54;
  GL_RENDERBUFFER_DEPTH_SIZE_EXT = $8D54;
  GL_RENDERBUFFER_DEPTH_SIZE_OES = $8D54;
  GL_RENDERBUFFER_STENCIL_SIZE = $8D55;
  GL_RENDERBUFFER_STENCIL_SIZE_EXT = $8D55;
  GL_RENDERBUFFER_STENCIL_SIZE_OES = $8D55;
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE = $8D56;
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_ANGLE = $8D56;
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_APPLE = $8D56;
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT = $8D56;
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_NV = $8D56;
  GL_MAX_SAMPLES = $8D57;
  GL_MAX_SAMPLES_ANGLE = $8D57;
  GL_MAX_SAMPLES_APPLE = $8D57;
  GL_MAX_SAMPLES_EXT = $8D57;
  GL_MAX_SAMPLES_NV = $8D57;
  GL_TEXTURE_GEN_STR_OES = $8D60;
  GL_HALF_FLOAT_OES = $8D61;
  GL_RGB565_OES = $8D62;
  GL_RGB565 = $8D62;
  GL_ETC1_RGB8_OES = $8D64;
  GL_TEXTURE_EXTERNAL_OES = $8D65;
  GL_SAMPLER_EXTERNAL_OES = $8D66;
  GL_TEXTURE_BINDING_EXTERNAL_OES = $8D67;
  GL_REQUIRED_TEXTURE_IMAGE_UNITS_OES = $8D68;
  GL_PRIMITIVE_RESTART_FIXED_INDEX = $8D69;
  GL_ANY_SAMPLES_PASSED_CONSERVATIVE = $8D6A;
  GL_ANY_SAMPLES_PASSED_CONSERVATIVE_EXT = $8D6A;
  GL_MAX_ELEMENT_INDEX = $8D6B;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SAMPLES_EXT = $8D6C;
  GL_RGBA32UI = $8D70;
  GL_RGBA32UI_EXT = $8D70;
  GL_RGB32UI = $8D71;
  GL_RGB32UI_EXT = $8D71;
  GL_ALPHA32UI_EXT = $8D72;
  GL_INTENSITY32UI_EXT = $8D73;
  GL_LUMINANCE32UI_EXT = $8D74;
  GL_LUMINANCE_ALPHA32UI_EXT = $8D75;
  GL_RGBA16UI = $8D76;
  GL_RGBA16UI_EXT = $8D76;
  GL_RGB16UI = $8D77;
  GL_RGB16UI_EXT = $8D77;
  GL_ALPHA16UI_EXT = $8D78;
  GL_INTENSITY16UI_EXT = $8D79;
  GL_LUMINANCE16UI_EXT = $8D7A;
  GL_LUMINANCE_ALPHA16UI_EXT = $8D7B;
  GL_RGBA8UI = $8D7C;
  GL_RGBA8UI_EXT = $8D7C;
  GL_RGB8UI = $8D7D;
  GL_RGB8UI_EXT = $8D7D;
  GL_ALPHA8UI_EXT = $8D7E;
  GL_INTENSITY8UI_EXT = $8D7F;
  GL_LUMINANCE8UI_EXT = $8D80;
  GL_LUMINANCE_ALPHA8UI_EXT = $8D81;
  GL_RGBA32I = $8D82;
  GL_RGBA32I_EXT = $8D82;
  GL_RGB32I = $8D83;
  GL_RGB32I_EXT = $8D83;
  GL_ALPHA32I_EXT = $8D84;
  GL_INTENSITY32I_EXT = $8D85;
  GL_LUMINANCE32I_EXT = $8D86;
  GL_LUMINANCE_ALPHA32I_EXT = $8D87;
  GL_RGBA16I = $8D88;
  GL_RGBA16I_EXT = $8D88;
  GL_RGB16I = $8D89;
  GL_RGB16I_EXT = $8D89;
  GL_ALPHA16I_EXT = $8D8A;
  GL_INTENSITY16I_EXT = $8D8B;
  GL_LUMINANCE16I_EXT = $8D8C;
  GL_LUMINANCE_ALPHA16I_EXT = $8D8D;
  GL_RGBA8I = $8D8E;
  GL_RGBA8I_EXT = $8D8E;
  GL_RGB8I = $8D8F;
  GL_RGB8I_EXT = $8D8F;
  GL_ALPHA8I_EXT = $8D90;
  GL_INTENSITY8I_EXT = $8D91;
  GL_LUMINANCE8I_EXT = $8D92;
  GL_LUMINANCE_ALPHA8I_EXT = $8D93;
  GL_RED_INTEGER = $8D94;
  GL_RED_INTEGER_EXT = $8D94;
  GL_GREEN_INTEGER = $8D95;
  GL_GREEN_INTEGER_EXT = $8D95;
  GL_BLUE_INTEGER = $8D96;
  GL_BLUE_INTEGER_EXT = $8D96;
  GL_ALPHA_INTEGER = $8D97;
  GL_ALPHA_INTEGER_EXT = $8D97;
  GL_RGB_INTEGER = $8D98;
  GL_RGB_INTEGER_EXT = $8D98;
  GL_RGBA_INTEGER = $8D99;
  GL_RGBA_INTEGER_EXT = $8D99;
  GL_BGR_INTEGER = $8D9A;
  GL_BGR_INTEGER_EXT = $8D9A;
  GL_BGRA_INTEGER = $8D9B;
  GL_BGRA_INTEGER_EXT = $8D9B;
  GL_LUMINANCE_INTEGER_EXT = $8D9C;
  GL_LUMINANCE_ALPHA_INTEGER_EXT = $8D9D;
  GL_RGBA_INTEGER_MODE_EXT = $8D9E;
  GL_INT_2_10_10_10_REV = $8D9F;
  GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV = $8DA0;
  GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV = $8DA1;
  GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV = $8DA2;
  GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV = $8DA3;
  GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV = $8DA4;
  GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV = $8DA5;
  GL_MAX_PROGRAM_GENERIC_RESULTS_NV = $8DA6;
  GL_FRAMEBUFFER_ATTACHMENT_LAYERED = $8DA7;
  GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB = $8DA7;
  GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT = $8DA7;
  GL_FRAMEBUFFER_ATTACHMENT_LAYERED_OES = $8DA7;
  GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = $8DA8;
  GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB = $8DA8;
  GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT = $8DA8;
  GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_OES = $8DA8;
  GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB = $8DA9;
  GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT = $8DA9;
  GL_LAYER_NV = $8DAA;
  GL_DEPTH_COMPONENT32F_NV = $8DAB;
  GL_DEPTH32F_STENCIL8_NV = $8DAC;
  GL_FLOAT_32_UNSIGNED_INT_24_8_REV = $8DAD;
  GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV = $8DAD;
  GL_SHADER_INCLUDE_ARB = $8DAE;
  GL_DEPTH_BUFFER_FLOAT_MODE_NV = $8DAF;
  GL_FRAMEBUFFER_SRGB = $8DB9;
  GL_FRAMEBUFFER_SRGB_EXT = $8DB9;
  GL_FRAMEBUFFER_SRGB_CAPABLE_EXT = $8DBA;
  GL_COMPRESSED_RED_RGTC1 = $8DBB;
  GL_COMPRESSED_RED_RGTC1_EXT = $8DBB;
  GL_COMPRESSED_SIGNED_RED_RGTC1 = $8DBC;
  GL_COMPRESSED_SIGNED_RED_RGTC1_EXT = $8DBC;
  GL_COMPRESSED_RED_GREEN_RGTC2_EXT = $8DBD;
  GL_COMPRESSED_RG_RGTC2 = $8DBD;
  GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT = $8DBE;
  GL_COMPRESSED_SIGNED_RG_RGTC2 = $8DBE;
  GL_SAMPLER_1D_ARRAY = $8DC0;
  GL_SAMPLER_1D_ARRAY_EXT = $8DC0;
  GL_SAMPLER_2D_ARRAY = $8DC1;
  GL_SAMPLER_2D_ARRAY_EXT = $8DC1;
  GL_SAMPLER_BUFFER = $8DC2;
  GL_SAMPLER_BUFFER_EXT = $8DC2;
  GL_SAMPLER_BUFFER_OES = $8DC2;
  GL_SAMPLER_1D_ARRAY_SHADOW = $8DC3;
  GL_SAMPLER_1D_ARRAY_SHADOW_EXT = $8DC3;
  GL_SAMPLER_2D_ARRAY_SHADOW = $8DC4;
  GL_SAMPLER_2D_ARRAY_SHADOW_EXT = $8DC4;
  GL_SAMPLER_2D_ARRAY_SHADOW_NV = $8DC4;
  GL_SAMPLER_CUBE_SHADOW = $8DC5;
  GL_SAMPLER_CUBE_SHADOW_EXT = $8DC5;
  GL_SAMPLER_CUBE_SHADOW_NV = $8DC5;
  GL_UNSIGNED_INT_VEC2 = $8DC6;
  GL_UNSIGNED_INT_VEC2_EXT = $8DC6;
  GL_UNSIGNED_INT_VEC3 = $8DC7;
  GL_UNSIGNED_INT_VEC3_EXT = $8DC7;
  GL_UNSIGNED_INT_VEC4 = $8DC8;
  GL_UNSIGNED_INT_VEC4_EXT = $8DC8;
  GL_INT_SAMPLER_1D = $8DC9;
  GL_INT_SAMPLER_1D_EXT = $8DC9;
  GL_INT_SAMPLER_2D = $8DCA;
  GL_INT_SAMPLER_2D_EXT = $8DCA;
  GL_INT_SAMPLER_3D = $8DCB;
  GL_INT_SAMPLER_3D_EXT = $8DCB;
  GL_INT_SAMPLER_CUBE = $8DCC;
  GL_INT_SAMPLER_CUBE_EXT = $8DCC;
  GL_INT_SAMPLER_2D_RECT = $8DCD;
  GL_INT_SAMPLER_2D_RECT_EXT = $8DCD;
  GL_INT_SAMPLER_1D_ARRAY = $8DCE;
  GL_INT_SAMPLER_1D_ARRAY_EXT = $8DCE;
  GL_INT_SAMPLER_2D_ARRAY = $8DCF;
  GL_INT_SAMPLER_2D_ARRAY_EXT = $8DCF;
  GL_INT_SAMPLER_BUFFER = $8DD0;
  GL_INT_SAMPLER_BUFFER_EXT = $8DD0;
  GL_INT_SAMPLER_BUFFER_OES = $8DD0;
  GL_UNSIGNED_INT_SAMPLER_1D = $8DD1;
  GL_UNSIGNED_INT_SAMPLER_1D_EXT = $8DD1;
  GL_UNSIGNED_INT_SAMPLER_2D = $8DD2;
  GL_UNSIGNED_INT_SAMPLER_2D_EXT = $8DD2;
  GL_UNSIGNED_INT_SAMPLER_3D = $8DD3;
  GL_UNSIGNED_INT_SAMPLER_3D_EXT = $8DD3;
  GL_UNSIGNED_INT_SAMPLER_CUBE = $8DD4;
  GL_UNSIGNED_INT_SAMPLER_CUBE_EXT = $8DD4;
  GL_UNSIGNED_INT_SAMPLER_2D_RECT = $8DD5;
  GL_UNSIGNED_INT_SAMPLER_2D_RECT_EXT = $8DD5;
  GL_UNSIGNED_INT_SAMPLER_1D_ARRAY = $8DD6;
  GL_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT = $8DD6;
  GL_UNSIGNED_INT_SAMPLER_2D_ARRAY = $8DD7;
  GL_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT = $8DD7;
  GL_UNSIGNED_INT_SAMPLER_BUFFER = $8DD8;
  GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT = $8DD8;
  GL_UNSIGNED_INT_SAMPLER_BUFFER_OES = $8DD8;
  GL_GEOMETRY_SHADER = $8DD9;
  GL_GEOMETRY_SHADER_ARB = $8DD9;
  GL_GEOMETRY_SHADER_EXT = $8DD9;
  GL_GEOMETRY_SHADER_OES = $8DD9;
  GL_GEOMETRY_VERTICES_OUT_ARB = $8DDA;
  GL_GEOMETRY_VERTICES_OUT_EXT = $8DDA;
  GL_GEOMETRY_INPUT_TYPE_ARB = $8DDB;
  GL_GEOMETRY_INPUT_TYPE_EXT = $8DDB;
  GL_GEOMETRY_OUTPUT_TYPE_ARB = $8DDC;
  GL_GEOMETRY_OUTPUT_TYPE_EXT = $8DDC;
  GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB = $8DDD;
  GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT = $8DDD;
  GL_MAX_VERTEX_VARYING_COMPONENTS_ARB = $8DDE;
  GL_MAX_VERTEX_VARYING_COMPONENTS_EXT = $8DDE;
  GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = $8DDF;
  GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB = $8DDF;
  GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT = $8DDF;
  GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_OES = $8DDF;
  GL_MAX_GEOMETRY_OUTPUT_VERTICES = $8DE0;
  GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB = $8DE0;
  GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT = $8DE0;
  GL_MAX_GEOMETRY_OUTPUT_VERTICES_OES = $8DE0;
  GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = $8DE1;
  GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB = $8DE1;
  GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT = $8DE1;
  GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_OES = $8DE1;
  GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT = $8DE2;
  GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT = $8DE3;
  GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT = $8DE4;
  GL_ACTIVE_SUBROUTINES = $8DE5;
  GL_ACTIVE_SUBROUTINE_UNIFORMS = $8DE6;
  GL_MAX_SUBROUTINES = $8DE7;
  GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = $8DE8;
  GL_NAMED_STRING_LENGTH_ARB = $8DE9;
  GL_NAMED_STRING_TYPE_ARB = $8DEA;
  GL_MAX_BINDABLE_UNIFORM_SIZE_EXT = $8DED;
  GL_UNIFORM_BUFFER_EXT = $8DEE;
  GL_UNIFORM_BUFFER_BINDING_EXT = $8DEF;
  GL_LOW_FLOAT = $8DF0;
  GL_MEDIUM_FLOAT = $8DF1;
  GL_HIGH_FLOAT = $8DF2;
  GL_LOW_INT = $8DF3;
  GL_MEDIUM_INT = $8DF4;
  GL_HIGH_INT = $8DF5;
  GL_UNSIGNED_INT_10_10_10_2_OES = $8DF6;
  GL_INT_10_10_10_2_OES = $8DF7;
  GL_SHADER_BINARY_FORMATS = $8DF8;
  GL_NUM_SHADER_BINARY_FORMATS = $8DF9;
  GL_SHADER_COMPILER = $8DFA;
  GL_MAX_VERTEX_UNIFORM_VECTORS = $8DFB;
  GL_MAX_VARYING_VECTORS = $8DFC;
  GL_MAX_FRAGMENT_UNIFORM_VECTORS = $8DFD;
  GL_RENDERBUFFER_COLOR_SAMPLES_NV = $8E10;
  GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV = $8E11;
  GL_MULTISAMPLE_COVERAGE_MODES_NV = $8E12;
  GL_QUERY_WAIT = $8E13;
  GL_QUERY_WAIT_NV = $8E13;
  GL_QUERY_NO_WAIT = $8E14;
  GL_QUERY_NO_WAIT_NV = $8E14;
  GL_QUERY_BY_REGION_WAIT = $8E15;
  GL_QUERY_BY_REGION_WAIT_NV = $8E15;
  GL_QUERY_BY_REGION_NO_WAIT = $8E16;
  GL_QUERY_BY_REGION_NO_WAIT_NV = $8E16;
  GL_QUERY_WAIT_INVERTED = $8E17;
  GL_QUERY_NO_WAIT_INVERTED = $8E18;
  GL_QUERY_BY_REGION_WAIT_INVERTED = $8E19;
  GL_QUERY_BY_REGION_NO_WAIT_INVERTED = $8E1A;
  GL_POLYGON_OFFSET_CLAMP = $8E1B;
  GL_POLYGON_OFFSET_CLAMP_EXT = $8E1B;
  GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = $8E1E;
  GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_EXT = $8E1E;
  GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS_OES = $8E1E;
  GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = $8E1F;
  GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT = $8E1F;
  GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS_OES = $8E1F;
  GL_COLOR_SAMPLES_NV = $8E20;
  GL_TRANSFORM_FEEDBACK = $8E22;
  GL_TRANSFORM_FEEDBACK_NV = $8E22;
  GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED = $8E23;
  GL_TRANSFORM_FEEDBACK_PAUSED = $8E23;
  GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED_NV = $8E23;
  GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE = $8E24;
  GL_TRANSFORM_FEEDBACK_ACTIVE = $8E24;
  GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE_NV = $8E24;
  GL_TRANSFORM_FEEDBACK_BINDING = $8E25;
  GL_TRANSFORM_FEEDBACK_BINDING_NV = $8E25;
  GL_FRAME_NV = $8E26;
  GL_FIELDS_NV = $8E27;
  GL_CURRENT_TIME_NV = $8E28;
  GL_TIMESTAMP = $8E28;
  GL_TIMESTAMP_EXT = $8E28;
  GL_NUM_FILL_STREAMS_NV = $8E29;
  GL_PRESENT_TIME_NV = $8E2A;
  GL_PRESENT_DURATION_NV = $8E2B;
  GL_DEPTH_COMPONENT16_NONLINEAR_NV = $8E2C;
  GL_PROGRAM_MATRIX_EXT = $8E2D;
  GL_TRANSPOSE_PROGRAM_MATRIX_EXT = $8E2E;
  GL_PROGRAM_MATRIX_STACK_DEPTH_EXT = $8E2F;
  GL_TEXTURE_SWIZZLE_R = $8E42;
  GL_TEXTURE_SWIZZLE_R_EXT = $8E42;
  GL_TEXTURE_SWIZZLE_G = $8E43;
  GL_TEXTURE_SWIZZLE_G_EXT = $8E43;
  GL_TEXTURE_SWIZZLE_B = $8E44;
  GL_TEXTURE_SWIZZLE_B_EXT = $8E44;
  GL_TEXTURE_SWIZZLE_A = $8E45;
  GL_TEXTURE_SWIZZLE_A_EXT = $8E45;
  GL_TEXTURE_SWIZZLE_RGBA = $8E46;
  GL_TEXTURE_SWIZZLE_RGBA_EXT = $8E46;
  GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = $8E47;
  GL_ACTIVE_SUBROUTINE_MAX_LENGTH = $8E48;
  GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = $8E49;
  GL_NUM_COMPATIBLE_SUBROUTINES = $8E4A;
  GL_COMPATIBLE_SUBROUTINES = $8E4B;
  GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = $8E4C;
  GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT = $8E4C;
  GL_FIRST_VERTEX_CONVENTION = $8E4D;
  GL_FIRST_VERTEX_CONVENTION_EXT = $8E4D;
  GL_FIRST_VERTEX_CONVENTION_OES = $8E4D;
  GL_LAST_VERTEX_CONVENTION = $8E4E;
  GL_LAST_VERTEX_CONVENTION_EXT = $8E4E;
  GL_LAST_VERTEX_CONVENTION_OES = $8E4E;
  GL_PROVOKING_VERTEX = $8E4F;
  GL_PROVOKING_VERTEX_EXT = $8E4F;
  GL_SAMPLE_POSITION = $8E50;
  GL_SAMPLE_POSITION_NV = $8E50;
  GL_SAMPLE_LOCATION_ARB = $8E50;
  GL_SAMPLE_LOCATION_NV = $8E50;
  GL_SAMPLE_MASK = $8E51;
  GL_SAMPLE_MASK_NV = $8E51;
  GL_SAMPLE_MASK_VALUE = $8E52;
  GL_SAMPLE_MASK_VALUE_NV = $8E52;
  GL_TEXTURE_BINDING_RENDERBUFFER_NV = $8E53;
  GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV = $8E54;
  GL_TEXTURE_RENDERBUFFER_NV = $8E55;
  GL_SAMPLER_RENDERBUFFER_NV = $8E56;
  GL_INT_SAMPLER_RENDERBUFFER_NV = $8E57;
  GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV = $8E58;
  GL_MAX_SAMPLE_MASK_WORDS = $8E59;
  GL_MAX_SAMPLE_MASK_WORDS_NV = $8E59;
  GL_MAX_GEOMETRY_PROGRAM_INVOCATIONS_NV = $8E5A;
  GL_MAX_GEOMETRY_SHADER_INVOCATIONS = $8E5A;
  GL_MAX_GEOMETRY_SHADER_INVOCATIONS_EXT = $8E5A;
  GL_MAX_GEOMETRY_SHADER_INVOCATIONS_OES = $8E5A;
  GL_MIN_FRAGMENT_INTERPOLATION_OFFSET = $8E5B;
  GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_OES = $8E5B;
  GL_MIN_FRAGMENT_INTERPOLATION_OFFSET_NV = $8E5B;
  GL_MAX_FRAGMENT_INTERPOLATION_OFFSET = $8E5C;
  GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_OES = $8E5C;
  GL_MAX_FRAGMENT_INTERPOLATION_OFFSET_NV = $8E5C;
  GL_FRAGMENT_INTERPOLATION_OFFSET_BITS = $8E5D;
  GL_FRAGMENT_INTERPOLATION_OFFSET_BITS_OES = $8E5D;
  GL_FRAGMENT_PROGRAM_INTERPOLATION_OFFSET_BITS_NV = $8E5D;
  GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET = $8E5E;
  GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = $8E5E;
  GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET_NV = $8E5E;
  GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET = $8E5F;
  GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_ARB = $8E5F;
  GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET_NV = $8E5F;
  GL_MAX_TRANSFORM_FEEDBACK_BUFFERS = $8E70;
  GL_MAX_VERTEX_STREAMS = $8E71;
  GL_PATCH_VERTICES = $8E72;
  GL_PATCH_VERTICES_EXT = $8E72;
  GL_PATCH_VERTICES_OES = $8E72;
  GL_PATCH_DEFAULT_INNER_LEVEL = $8E73;
  GL_PATCH_DEFAULT_INNER_LEVEL_EXT = $8E73;
  GL_PATCH_DEFAULT_OUTER_LEVEL = $8E74;
  GL_PATCH_DEFAULT_OUTER_LEVEL_EXT = $8E74;
  GL_TESS_CONTROL_OUTPUT_VERTICES = $8E75;
  GL_TESS_CONTROL_OUTPUT_VERTICES_EXT = $8E75;
  GL_TESS_CONTROL_OUTPUT_VERTICES_OES = $8E75;
  GL_TESS_GEN_MODE = $8E76;
  GL_TESS_GEN_MODE_EXT = $8E76;
  GL_TESS_GEN_MODE_OES = $8E76;
  GL_TESS_GEN_SPACING = $8E77;
  GL_TESS_GEN_SPACING_EXT = $8E77;
  GL_TESS_GEN_SPACING_OES = $8E77;
  GL_TESS_GEN_VERTEX_ORDER = $8E78;
  GL_TESS_GEN_VERTEX_ORDER_EXT = $8E78;
  GL_TESS_GEN_VERTEX_ORDER_OES = $8E78;
  GL_TESS_GEN_POINT_MODE = $8E79;
  GL_TESS_GEN_POINT_MODE_EXT = $8E79;
  GL_TESS_GEN_POINT_MODE_OES = $8E79;
  GL_ISOLINES = $8E7A;
  GL_ISOLINES_EXT = $8E7A;
  GL_ISOLINES_OES = $8E7A;
  GL_FRACTIONAL_ODD = $8E7B;
  GL_FRACTIONAL_ODD_EXT = $8E7B;
  GL_FRACTIONAL_ODD_OES = $8E7B;
  GL_FRACTIONAL_EVEN = $8E7C;
  GL_FRACTIONAL_EVEN_EXT = $8E7C;
  GL_FRACTIONAL_EVEN_OES = $8E7C;
  GL_MAX_PATCH_VERTICES = $8E7D;
  GL_MAX_PATCH_VERTICES_EXT = $8E7D;
  GL_MAX_PATCH_VERTICES_OES = $8E7D;
  GL_MAX_TESS_GEN_LEVEL = $8E7E;
  GL_MAX_TESS_GEN_LEVEL_EXT = $8E7E;
  GL_MAX_TESS_GEN_LEVEL_OES = $8E7E;
  GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = $8E7F;
  GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_EXT = $8E7F;
  GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS_OES = $8E7F;
  GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = $8E80;
  GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_EXT = $8E80;
  GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS_OES = $8E80;
  GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = $8E81;
  GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_EXT = $8E81;
  GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS_OES = $8E81;
  GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = $8E82;
  GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_EXT = $8E82;
  GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS_OES = $8E82;
  GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = $8E83;
  GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_EXT = $8E83;
  GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS_OES = $8E83;
  GL_MAX_TESS_PATCH_COMPONENTS = $8E84;
  GL_MAX_TESS_PATCH_COMPONENTS_EXT = $8E84;
  GL_MAX_TESS_PATCH_COMPONENTS_OES = $8E84;
  GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = $8E85;
  GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_EXT = $8E85;
  GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS_OES = $8E85;
  GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = $8E86;
  GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_EXT = $8E86;
  GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS_OES = $8E86;
  GL_TESS_EVALUATION_SHADER = $8E87;
  GL_TESS_EVALUATION_SHADER_EXT = $8E87;
  GL_TESS_EVALUATION_SHADER_OES = $8E87;
  GL_TESS_CONTROL_SHADER = $8E88;
  GL_TESS_CONTROL_SHADER_EXT = $8E88;
  GL_TESS_CONTROL_SHADER_OES = $8E88;
  GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = $8E89;
  GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS_EXT = $8E89;
  GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS_OES = $8E89;
  GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = $8E8A;
  GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_EXT = $8E8A;
  GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS_OES = $8E8A;
  GL_COMPRESSED_RGBA_BPTC_UNORM = $8E8C;
  GL_COMPRESSED_RGBA_BPTC_UNORM_ARB = $8E8C;
  GL_COMPRESSED_RGBA_BPTC_UNORM_EXT = $8E8C;
  GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM = $8E8D;
  GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_ARB = $8E8D;
  GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT = $8E8D;
  GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT = $8E8E;
  GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_ARB = $8E8E;
  GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT = $8E8E;
  GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT = $8E8F;
  GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_ARB = $8E8F;
  GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT = $8E8F;
  GL_COVERAGE_COMPONENT_NV = $8ED0;
  GL_COVERAGE_COMPONENT4_NV = $8ED1;
  GL_COVERAGE_ATTACHMENT_NV = $8ED2;
  GL_COVERAGE_BUFFERS_NV = $8ED3;
  GL_COVERAGE_SAMPLES_NV = $8ED4;
  GL_COVERAGE_ALL_FRAGMENTS_NV = $8ED5;
  GL_COVERAGE_EDGE_FRAGMENTS_NV = $8ED6;
  GL_COVERAGE_AUTOMATIC_NV = $8ED7;
  GL_INCLUSIVE_EXT = $8F10;
  GL_EXCLUSIVE_EXT = $8F11;
  GL_WINDOW_RECTANGLE_EXT = $8F12;
  GL_WINDOW_RECTANGLE_MODE_EXT = $8F13;
  GL_MAX_WINDOW_RECTANGLES_EXT = $8F14;
  GL_NUM_WINDOW_RECTANGLES_EXT = $8F15;
  GL_BUFFER_GPU_ADDRESS_NV = $8F1D;
  GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV = $8F1E;
  GL_ELEMENT_ARRAY_UNIFIED_NV = $8F1F;
  GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV = $8F20;
  GL_VERTEX_ARRAY_ADDRESS_NV = $8F21;
  GL_NORMAL_ARRAY_ADDRESS_NV = $8F22;
  GL_COLOR_ARRAY_ADDRESS_NV = $8F23;
  GL_INDEX_ARRAY_ADDRESS_NV = $8F24;
  GL_TEXTURE_COORD_ARRAY_ADDRESS_NV = $8F25;
  GL_EDGE_FLAG_ARRAY_ADDRESS_NV = $8F26;
  GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV = $8F27;
  GL_FOG_COORD_ARRAY_ADDRESS_NV = $8F28;
  GL_ELEMENT_ARRAY_ADDRESS_NV = $8F29;
  GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV = $8F2A;
  GL_VERTEX_ARRAY_LENGTH_NV = $8F2B;
  GL_NORMAL_ARRAY_LENGTH_NV = $8F2C;
  GL_COLOR_ARRAY_LENGTH_NV = $8F2D;
  GL_INDEX_ARRAY_LENGTH_NV = $8F2E;
  GL_TEXTURE_COORD_ARRAY_LENGTH_NV = $8F2F;
  GL_EDGE_FLAG_ARRAY_LENGTH_NV = $8F30;
  GL_SECONDARY_COLOR_ARRAY_LENGTH_NV = $8F31;
  GL_FOG_COORD_ARRAY_LENGTH_NV = $8F32;
  GL_ELEMENT_ARRAY_LENGTH_NV = $8F33;
  GL_GPU_ADDRESS_NV = $8F34;
  GL_MAX_SHADER_BUFFER_ADDRESS_NV = $8F35;
  GL_COPY_READ_BUFFER = $8F36;
  GL_COPY_READ_BUFFER_NV = $8F36;
  GL_COPY_READ_BUFFER_BINDING = $8F36;
  GL_COPY_WRITE_BUFFER = $8F37;
  GL_COPY_WRITE_BUFFER_NV = $8F37;
  GL_COPY_WRITE_BUFFER_BINDING = $8F37;
  GL_MAX_IMAGE_UNITS = $8F38;
  GL_MAX_IMAGE_UNITS_EXT = $8F38;
  GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS = $8F39;
  GL_MAX_COMBINED_IMAGE_UNITS_AND_FRAGMENT_OUTPUTS_EXT = $8F39;
  GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES = $8F39;
  GL_IMAGE_BINDING_NAME = $8F3A;
  GL_IMAGE_BINDING_NAME_EXT = $8F3A;
  GL_IMAGE_BINDING_LEVEL = $8F3B;
  GL_IMAGE_BINDING_LEVEL_EXT = $8F3B;
  GL_IMAGE_BINDING_LAYERED = $8F3C;
  GL_IMAGE_BINDING_LAYERED_EXT = $8F3C;
  GL_IMAGE_BINDING_LAYER = $8F3D;
  GL_IMAGE_BINDING_LAYER_EXT = $8F3D;
  GL_IMAGE_BINDING_ACCESS = $8F3E;
  GL_IMAGE_BINDING_ACCESS_EXT = $8F3E;
  GL_DRAW_INDIRECT_BUFFER = $8F3F;
  GL_DRAW_INDIRECT_UNIFIED_NV = $8F40;
  GL_DRAW_INDIRECT_ADDRESS_NV = $8F41;
  GL_DRAW_INDIRECT_LENGTH_NV = $8F42;
  GL_DRAW_INDIRECT_BUFFER_BINDING = $8F43;
  GL_MAX_PROGRAM_SUBROUTINE_PARAMETERS_NV = $8F44;
  GL_MAX_PROGRAM_SUBROUTINE_NUM_NV = $8F45;
  GL_DOUBLE_MAT2 = $8F46;
  GL_DOUBLE_MAT2_EXT = $8F46;
  GL_DOUBLE_MAT3 = $8F47;
  GL_DOUBLE_MAT3_EXT = $8F47;
  GL_DOUBLE_MAT4 = $8F48;
  GL_DOUBLE_MAT4_EXT = $8F48;
  GL_DOUBLE_MAT2x3 = $8F49;
  GL_DOUBLE_MAT2x3_EXT = $8F49;
  GL_DOUBLE_MAT2x4 = $8F4A;
  GL_DOUBLE_MAT2x4_EXT = $8F4A;
  GL_DOUBLE_MAT3x2 = $8F4B;
  GL_DOUBLE_MAT3x2_EXT = $8F4B;
  GL_DOUBLE_MAT3x4 = $8F4C;
  GL_DOUBLE_MAT3x4_EXT = $8F4C;
  GL_DOUBLE_MAT4x2 = $8F4D;
  GL_DOUBLE_MAT4x2_EXT = $8F4D;
  GL_DOUBLE_MAT4x3 = $8F4E;
  GL_DOUBLE_MAT4x3_EXT = $8F4E;
  GL_VERTEX_BINDING_BUFFER = $8F4F;
  GL_MALI_SHADER_BINARY_ARM = $8F60;
  GL_MALI_PROGRAM_BINARY_ARM = $8F61;
  GL_MAX_SHADER_PIXEL_LOCAL_STORAGE_FAST_SIZE_EXT = $8F63;
  GL_SHADER_PIXEL_LOCAL_STORAGE_EXT = $8F64;
  GL_FETCH_PER_SAMPLE_ARM = $8F65;
  GL_FRAGMENT_SHADER_FRAMEBUFFER_FETCH_MRT_ARM = $8F66;
  GL_MAX_SHADER_PIXEL_LOCAL_STORAGE_SIZE_EXT = $8F67;
  GL_TEXTURE_ASTC_DECODE_PRECISION_EXT = $8F69;
  GL_RED_SNORM = $8F90;
  GL_RG_SNORM = $8F91;
  GL_RGB_SNORM = $8F92;
  GL_RGBA_SNORM = $8F93;
  GL_R8_SNORM = $8F94;
  GL_RG8_SNORM = $8F95;
  GL_RGB8_SNORM = $8F96;
  GL_RGBA8_SNORM = $8F97;
  GL_R16_SNORM = $8F98;
  GL_R16_SNORM_EXT = $8F98;
  GL_RG16_SNORM = $8F99;
  GL_RG16_SNORM_EXT = $8F99;
  GL_RGB16_SNORM = $8F9A;
  GL_RGB16_SNORM_EXT = $8F9A;
  GL_RGBA16_SNORM = $8F9B;
  GL_RGBA16_SNORM_EXT = $8F9B;
  GL_SIGNED_NORMALIZED = $8F9C;
  GL_PRIMITIVE_RESTART = $8F9D;
  GL_PRIMITIVE_RESTART_INDEX = $8F9E;
  GL_MAX_PROGRAM_TEXTURE_GATHER_COMPONENTS_ARB = $8F9F;
  GL_PERFMON_GLOBAL_MODE_QCOM = $8FA0;
  GL_BINNING_CONTROL_HINT_QCOM = $8FB0;
  GL_CPU_OPTIMIZED_QCOM = $8FB1;
  GL_GPU_OPTIMIZED_QCOM = $8FB2;
  GL_RENDER_DIRECT_TO_FRAMEBUFFER_QCOM = $8FB3;
  GL_GPU_DISJOINT_EXT = $8FBB;
  GL_SR8_EXT = $8FBD;
  GL_SRG8_EXT = $8FBE;
  GL_SHADER_BINARY_VIV = $8FC4;
  GL_INT8_NV = $8FE0;
  GL_INT8_VEC2_NV = $8FE1;
  GL_INT8_VEC3_NV = $8FE2;
  GL_INT8_VEC4_NV = $8FE3;
  GL_INT16_NV = $8FE4;
  GL_INT16_VEC2_NV = $8FE5;
  GL_INT16_VEC3_NV = $8FE6;
  GL_INT16_VEC4_NV = $8FE7;
  GL_INT64_VEC2_ARB = $8FE9;
  GL_INT64_VEC2_NV = $8FE9;
  GL_INT64_VEC3_ARB = $8FEA;
  GL_INT64_VEC3_NV = $8FEA;
  GL_INT64_VEC4_ARB = $8FEB;
  GL_INT64_VEC4_NV = $8FEB;
  GL_UNSIGNED_INT8_NV = $8FEC;
  GL_UNSIGNED_INT8_VEC2_NV = $8FED;
  GL_UNSIGNED_INT8_VEC3_NV = $8FEE;
  GL_UNSIGNED_INT8_VEC4_NV = $8FEF;
  GL_UNSIGNED_INT16_NV = $8FF0;
  GL_UNSIGNED_INT16_VEC2_NV = $8FF1;
  GL_UNSIGNED_INT16_VEC3_NV = $8FF2;
  GL_UNSIGNED_INT16_VEC4_NV = $8FF3;
  GL_UNSIGNED_INT64_VEC2_ARB = $8FF5;
  GL_UNSIGNED_INT64_VEC2_NV = $8FF5;
  GL_UNSIGNED_INT64_VEC3_ARB = $8FF6;
  GL_UNSIGNED_INT64_VEC3_NV = $8FF6;
  GL_UNSIGNED_INT64_VEC4_ARB = $8FF7;
  GL_UNSIGNED_INT64_VEC4_NV = $8FF7;
  GL_FLOAT16_NV = $8FF8;
  GL_FLOAT16_VEC2_NV = $8FF9;
  GL_FLOAT16_VEC3_NV = $8FFA;
  GL_FLOAT16_VEC4_NV = $8FFB;
  GL_DOUBLE_VEC2 = $8FFC;
  GL_DOUBLE_VEC2_EXT = $8FFC;
  GL_DOUBLE_VEC3 = $8FFD;
  GL_DOUBLE_VEC3_EXT = $8FFD;
  GL_DOUBLE_VEC4 = $8FFE;
  GL_DOUBLE_VEC4_EXT = $8FFE;
  GL_SAMPLER_BUFFER_AMD = $9001;
  GL_INT_SAMPLER_BUFFER_AMD = $9002;
  GL_UNSIGNED_INT_SAMPLER_BUFFER_AMD = $9003;
  GL_TESSELLATION_MODE_AMD = $9004;
  GL_TESSELLATION_FACTOR_AMD = $9005;
  GL_DISCRETE_AMD = $9006;
  GL_CONTINUOUS_AMD = $9007;
  GL_TEXTURE_CUBE_MAP_ARRAY = $9009;
  GL_TEXTURE_CUBE_MAP_ARRAY_ARB = $9009;
  GL_TEXTURE_CUBE_MAP_ARRAY_EXT = $9009;
  GL_TEXTURE_CUBE_MAP_ARRAY_OES = $9009;
  GL_TEXTURE_BINDING_CUBE_MAP_ARRAY = $900A;
  GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_ARB = $900A;
  GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_EXT = $900A;
  GL_TEXTURE_BINDING_CUBE_MAP_ARRAY_OES = $900A;
  GL_PROXY_TEXTURE_CUBE_MAP_ARRAY = $900B;
  GL_PROXY_TEXTURE_CUBE_MAP_ARRAY_ARB = $900B;
  GL_SAMPLER_CUBE_MAP_ARRAY = $900C;
  GL_SAMPLER_CUBE_MAP_ARRAY_ARB = $900C;
  GL_SAMPLER_CUBE_MAP_ARRAY_EXT = $900C;
  GL_SAMPLER_CUBE_MAP_ARRAY_OES = $900C;
  GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = $900D;
  GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_ARB = $900D;
  GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_EXT = $900D;
  GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW_OES = $900D;
  GL_INT_SAMPLER_CUBE_MAP_ARRAY = $900E;
  GL_INT_SAMPLER_CUBE_MAP_ARRAY_ARB = $900E;
  GL_INT_SAMPLER_CUBE_MAP_ARRAY_EXT = $900E;
  GL_INT_SAMPLER_CUBE_MAP_ARRAY_OES = $900E;
  GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = $900F;
  GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_ARB = $900F;
  GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_EXT = $900F;
  GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY_OES = $900F;
  GL_ALPHA_SNORM = $9010;
  GL_LUMINANCE_SNORM = $9011;
  GL_LUMINANCE_ALPHA_SNORM = $9012;
  GL_INTENSITY_SNORM = $9013;
  GL_ALPHA8_SNORM = $9014;
  GL_LUMINANCE8_SNORM = $9015;
  GL_LUMINANCE8_ALPHA8_SNORM = $9016;
  GL_INTENSITY8_SNORM = $9017;
  GL_ALPHA16_SNORM = $9018;
  GL_LUMINANCE16_SNORM = $9019;
  GL_LUMINANCE16_ALPHA16_SNORM = $901A;
  GL_INTENSITY16_SNORM = $901B;
  GL_FACTOR_MIN_AMD = $901C;
  GL_FACTOR_MAX_AMD = $901D;
  GL_DEPTH_CLAMP_NEAR_AMD = $901E;
  GL_DEPTH_CLAMP_FAR_AMD = $901F;
  GL_VIDEO_BUFFER_NV = $9020;
  GL_VIDEO_BUFFER_BINDING_NV = $9021;
  GL_FIELD_UPPER_NV = $9022;
  GL_FIELD_LOWER_NV = $9023;
  GL_NUM_VIDEO_CAPTURE_STREAMS_NV = $9024;
  GL_NEXT_VIDEO_CAPTURE_BUFFER_STATUS_NV = $9025;
  GL_VIDEO_CAPTURE_TO_422_SUPPORTED_NV = $9026;
  GL_LAST_VIDEO_CAPTURE_STATUS_NV = $9027;
  GL_VIDEO_BUFFER_PITCH_NV = $9028;
  GL_VIDEO_COLOR_CONVERSION_MATRIX_NV = $9029;
  GL_VIDEO_COLOR_CONVERSION_MAX_NV = $902A;
  GL_VIDEO_COLOR_CONVERSION_MIN_NV = $902B;
  GL_VIDEO_COLOR_CONVERSION_OFFSET_NV = $902C;
  GL_VIDEO_BUFFER_INTERNAL_FORMAT_NV = $902D;
  GL_PARTIAL_SUCCESS_NV = $902E;
  GL_SUCCESS_NV = $902F;
  GL_FAILURE_NV = $9030;
  GL_YCBYCR8_422_NV = $9031;
  GL_YCBAYCR8A_4224_NV = $9032;
  GL_Z6Y10Z6CB10Z6Y10Z6CR10_422_NV = $9033;
  GL_Z6Y10Z6CB10Z6A10Z6Y10Z6CR10Z6A10_4224_NV = $9034;
  GL_Z4Y12Z4CB12Z4Y12Z4CR12_422_NV = $9035;
  GL_Z4Y12Z4CB12Z4A12Z4Y12Z4CR12Z4A12_4224_NV = $9036;
  GL_Z4Y12Z4CB12Z4CR12_444_NV = $9037;
  GL_VIDEO_CAPTURE_FRAME_WIDTH_NV = $9038;
  GL_VIDEO_CAPTURE_FRAME_HEIGHT_NV = $9039;
  GL_VIDEO_CAPTURE_FIELD_UPPER_HEIGHT_NV = $903A;
  GL_VIDEO_CAPTURE_FIELD_LOWER_HEIGHT_NV = $903B;
  GL_VIDEO_CAPTURE_SURFACE_ORIGIN_NV = $903C;
  GL_TEXTURE_COVERAGE_SAMPLES_NV = $9045;
  GL_TEXTURE_COLOR_SAMPLES_NV = $9046;
  GL_GPU_MEMORY_INFO_DEDICATED_VIDMEM_NVX = $9047;
  GL_GPU_MEMORY_INFO_TOTAL_AVAILABLE_MEMORY_NVX = $9048;
  GL_GPU_MEMORY_INFO_CURRENT_AVAILABLE_VIDMEM_NVX = $9049;
  GL_GPU_MEMORY_INFO_EVICTION_COUNT_NVX = $904A;
  GL_GPU_MEMORY_INFO_EVICTED_MEMORY_NVX = $904B;
  GL_IMAGE_1D = $904C;
  GL_IMAGE_1D_EXT = $904C;
  GL_IMAGE_2D = $904D;
  GL_IMAGE_2D_EXT = $904D;
  GL_IMAGE_3D = $904E;
  GL_IMAGE_3D_EXT = $904E;
  GL_IMAGE_2D_RECT = $904F;
  GL_IMAGE_2D_RECT_EXT = $904F;
  GL_IMAGE_CUBE = $9050;
  GL_IMAGE_CUBE_EXT = $9050;
  GL_IMAGE_BUFFER = $9051;
  GL_IMAGE_BUFFER_EXT = $9051;
  GL_IMAGE_BUFFER_OES = $9051;
  GL_IMAGE_1D_ARRAY = $9052;
  GL_IMAGE_1D_ARRAY_EXT = $9052;
  GL_IMAGE_2D_ARRAY = $9053;
  GL_IMAGE_2D_ARRAY_EXT = $9053;
  GL_IMAGE_CUBE_MAP_ARRAY = $9054;
  GL_IMAGE_CUBE_MAP_ARRAY_EXT = $9054;
  GL_IMAGE_CUBE_MAP_ARRAY_OES = $9054;
  GL_IMAGE_2D_MULTISAMPLE = $9055;
  GL_IMAGE_2D_MULTISAMPLE_EXT = $9055;
  GL_IMAGE_2D_MULTISAMPLE_ARRAY = $9056;
  GL_IMAGE_2D_MULTISAMPLE_ARRAY_EXT = $9056;
  GL_INT_IMAGE_1D = $9057;
  GL_INT_IMAGE_1D_EXT = $9057;
  GL_INT_IMAGE_2D = $9058;
  GL_INT_IMAGE_2D_EXT = $9058;
  GL_INT_IMAGE_3D = $9059;
  GL_INT_IMAGE_3D_EXT = $9059;
  GL_INT_IMAGE_2D_RECT = $905A;
  GL_INT_IMAGE_2D_RECT_EXT = $905A;
  GL_INT_IMAGE_CUBE = $905B;
  GL_INT_IMAGE_CUBE_EXT = $905B;
  GL_INT_IMAGE_BUFFER = $905C;
  GL_INT_IMAGE_BUFFER_EXT = $905C;
  GL_INT_IMAGE_BUFFER_OES = $905C;
  GL_INT_IMAGE_1D_ARRAY = $905D;
  GL_INT_IMAGE_1D_ARRAY_EXT = $905D;
  GL_INT_IMAGE_2D_ARRAY = $905E;
  GL_INT_IMAGE_2D_ARRAY_EXT = $905E;
  GL_INT_IMAGE_CUBE_MAP_ARRAY = $905F;
  GL_INT_IMAGE_CUBE_MAP_ARRAY_EXT = $905F;
  GL_INT_IMAGE_CUBE_MAP_ARRAY_OES = $905F;
  GL_INT_IMAGE_2D_MULTISAMPLE = $9060;
  GL_INT_IMAGE_2D_MULTISAMPLE_EXT = $9060;
  GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY = $9061;
  GL_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT = $9061;
  GL_UNSIGNED_INT_IMAGE_1D = $9062;
  GL_UNSIGNED_INT_IMAGE_1D_EXT = $9062;
  GL_UNSIGNED_INT_IMAGE_2D = $9063;
  GL_UNSIGNED_INT_IMAGE_2D_EXT = $9063;
  GL_UNSIGNED_INT_IMAGE_3D = $9064;
  GL_UNSIGNED_INT_IMAGE_3D_EXT = $9064;
  GL_UNSIGNED_INT_IMAGE_2D_RECT = $9065;
  GL_UNSIGNED_INT_IMAGE_2D_RECT_EXT = $9065;
  GL_UNSIGNED_INT_IMAGE_CUBE = $9066;
  GL_UNSIGNED_INT_IMAGE_CUBE_EXT = $9066;
  GL_UNSIGNED_INT_IMAGE_BUFFER = $9067;
  GL_UNSIGNED_INT_IMAGE_BUFFER_EXT = $9067;
  GL_UNSIGNED_INT_IMAGE_BUFFER_OES = $9067;
  GL_UNSIGNED_INT_IMAGE_1D_ARRAY = $9068;
  GL_UNSIGNED_INT_IMAGE_1D_ARRAY_EXT = $9068;
  GL_UNSIGNED_INT_IMAGE_2D_ARRAY = $9069;
  GL_UNSIGNED_INT_IMAGE_2D_ARRAY_EXT = $9069;
  GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY = $906A;
  GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_EXT = $906A;
  GL_UNSIGNED_INT_IMAGE_CUBE_MAP_ARRAY_OES = $906A;
  GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE = $906B;
  GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_EXT = $906B;
  GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY = $906C;
  GL_UNSIGNED_INT_IMAGE_2D_MULTISAMPLE_ARRAY_EXT = $906C;
  GL_MAX_IMAGE_SAMPLES = $906D;
  GL_MAX_IMAGE_SAMPLES_EXT = $906D;
  GL_IMAGE_BINDING_FORMAT = $906E;
  GL_IMAGE_BINDING_FORMAT_EXT = $906E;
  GL_RGB10_A2UI = $906F;
  GL_PATH_FORMAT_SVG_NV = $9070;
  GL_PATH_FORMAT_PS_NV = $9071;
  GL_STANDARD_FONT_NAME_NV = $9072;
  GL_SYSTEM_FONT_NAME_NV = $9073;
  GL_FILE_NAME_NV = $9074;
  GL_PATH_STROKE_WIDTH_NV = $9075;
  GL_PATH_END_CAPS_NV = $9076;
  GL_PATH_INITIAL_END_CAP_NV = $9077;
  GL_PATH_TERMINAL_END_CAP_NV = $9078;
  GL_PATH_JOIN_STYLE_NV = $9079;
  GL_PATH_MITER_LIMIT_NV = $907A;
  GL_PATH_DASH_CAPS_NV = $907B;
  GL_PATH_INITIAL_DASH_CAP_NV = $907C;
  GL_PATH_TERMINAL_DASH_CAP_NV = $907D;
  GL_PATH_DASH_OFFSET_NV = $907E;
  GL_PATH_CLIENT_LENGTH_NV = $907F;
  GL_PATH_FILL_MODE_NV = $9080;
  GL_PATH_FILL_MASK_NV = $9081;
  GL_PATH_FILL_COVER_MODE_NV = $9082;
  GL_PATH_STROKE_COVER_MODE_NV = $9083;
  GL_PATH_STROKE_MASK_NV = $9084;
  GL_COUNT_UP_NV = $9088;
  GL_COUNT_DOWN_NV = $9089;
  GL_PATH_OBJECT_BOUNDING_BOX_NV = $908A;
  GL_CONVEX_HULL_NV = $908B;
  GL_BOUNDING_BOX_NV = $908D;
  GL_TRANSLATE_X_NV = $908E;
  GL_TRANSLATE_Y_NV = $908F;
  GL_TRANSLATE_2D_NV = $9090;
  GL_TRANSLATE_3D_NV = $9091;
  GL_AFFINE_2D_NV = $9092;
  GL_AFFINE_3D_NV = $9094;
  GL_TRANSPOSE_AFFINE_2D_NV = $9096;
  GL_TRANSPOSE_AFFINE_3D_NV = $9098;
  GL_UTF8_NV = $909A;
  GL_UTF16_NV = $909B;
  GL_BOUNDING_BOX_OF_BOUNDING_BOXES_NV = $909C;
  GL_PATH_COMMAND_COUNT_NV = $909D;
  GL_PATH_COORD_COUNT_NV = $909E;
  GL_PATH_DASH_ARRAY_COUNT_NV = $909F;
  GL_PATH_COMPUTED_LENGTH_NV = $90A0;
  GL_PATH_FILL_BOUNDING_BOX_NV = $90A1;
  GL_PATH_STROKE_BOUNDING_BOX_NV = $90A2;
  GL_SQUARE_NV = $90A3;
  GL_ROUND_NV = $90A4;
  GL_TRIANGULAR_NV = $90A5;
  GL_BEVEL_NV = $90A6;
  GL_MITER_REVERT_NV = $90A7;
  GL_MITER_TRUNCATE_NV = $90A8;
  GL_SKIP_MISSING_GLYPH_NV = $90A9;
  GL_USE_MISSING_GLYPH_NV = $90AA;
  GL_PATH_ERROR_POSITION_NV = $90AB;
  GL_PATH_FOG_GEN_MODE_NV = $90AC;
  GL_ACCUM_ADJACENT_PAIRS_NV = $90AD;
  GL_ADJACENT_PAIRS_NV = $90AE;
  GL_FIRST_TO_REST_NV = $90AF;
  GL_PATH_GEN_MODE_NV = $90B0;
  GL_PATH_GEN_COEFF_NV = $90B1;
  GL_PATH_GEN_COLOR_FORMAT_NV = $90B2;
  GL_PATH_GEN_COMPONENTS_NV = $90B3;
  GL_PATH_DASH_OFFSET_RESET_NV = $90B4;
  GL_MOVE_TO_RESETS_NV = $90B5;
  GL_MOVE_TO_CONTINUES_NV = $90B6;
  GL_PATH_STENCIL_FUNC_NV = $90B7;
  GL_PATH_STENCIL_REF_NV = $90B8;
  GL_PATH_STENCIL_VALUE_MASK_NV = $90B9;
  GL_SCALED_RESOLVE_FASTEST_EXT = $90BA;
  GL_SCALED_RESOLVE_NICEST_EXT = $90BB;
  GL_MIN_MAP_BUFFER_ALIGNMENT = $90BC;
  GL_PATH_STENCIL_DEPTH_OFFSET_FACTOR_NV = $90BD;
  GL_PATH_STENCIL_DEPTH_OFFSET_UNITS_NV = $90BE;
  GL_PATH_COVER_DEPTH_FUNC_NV = $90BF;
  GL_IMAGE_FORMAT_COMPATIBILITY_TYPE = $90C7;
  GL_IMAGE_FORMAT_COMPATIBILITY_BY_SIZE = $90C8;
  GL_IMAGE_FORMAT_COMPATIBILITY_BY_CLASS = $90C9;
  GL_MAX_VERTEX_IMAGE_UNIFORMS = $90CA;
  GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS = $90CB;
  GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS_EXT = $90CB;
  GL_MAX_TESS_CONTROL_IMAGE_UNIFORMS_OES = $90CB;
  GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS = $90CC;
  GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_EXT = $90CC;
  GL_MAX_TESS_EVALUATION_IMAGE_UNIFORMS_OES = $90CC;
  GL_MAX_GEOMETRY_IMAGE_UNIFORMS = $90CD;
  GL_MAX_GEOMETRY_IMAGE_UNIFORMS_EXT = $90CD;
  GL_MAX_GEOMETRY_IMAGE_UNIFORMS_OES = $90CD;
  GL_MAX_FRAGMENT_IMAGE_UNIFORMS = $90CE;
  GL_MAX_COMBINED_IMAGE_UNIFORMS = $90CF;
  GL_MAX_DEEP_3D_TEXTURE_WIDTH_HEIGHT_NV = $90D0;
  GL_MAX_DEEP_3D_TEXTURE_DEPTH_NV = $90D1;
  GL_SHADER_STORAGE_BUFFER = $90D2;
  GL_SHADER_STORAGE_BUFFER_BINDING = $90D3;
  GL_SHADER_STORAGE_BUFFER_START = $90D4;
  GL_SHADER_STORAGE_BUFFER_SIZE = $90D5;
  GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS = $90D6;
  GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS = $90D7;
  GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_EXT = $90D7;
  GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS_OES = $90D7;
  GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS = $90D8;
  GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_EXT = $90D8;
  GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS_OES = $90D8;
  GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS = $90D9;
  GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_EXT = $90D9;
  GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS_OES = $90D9;
  GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS = $90DA;
  GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS = $90DB;
  GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS = $90DC;
  GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS = $90DD;
  GL_MAX_SHADER_STORAGE_BLOCK_SIZE = $90DE;
  GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT = $90DF;
  GL_SYNC_X11_FENCE_EXT = $90E1;
  GL_DEPTH_STENCIL_TEXTURE_MODE = $90EA;
  GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS = $90EB;
  GL_MAX_COMPUTE_FIXED_GROUP_INVOCATIONS_ARB = $90EB;
  GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER = $90EC;
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER = $90ED;
  GL_DISPATCH_INDIRECT_BUFFER = $90EE;
  GL_DISPATCH_INDIRECT_BUFFER_BINDING = $90EF;
  GL_COLOR_ATTACHMENT_EXT = $90F0;
  GL_MULTIVIEW_EXT = $90F1;
  GL_MAX_MULTIVIEW_BUFFERS_EXT = $90F2;
  GL_CONTEXT_ROBUST_ACCESS = $90F3;
  GL_CONTEXT_ROBUST_ACCESS_EXT = $90F3;
  GL_CONTEXT_ROBUST_ACCESS_KHR = $90F3;
  GL_COMPUTE_PROGRAM_NV = $90FB;
  GL_COMPUTE_PROGRAM_PARAMETER_BUFFER_NV = $90FC;
  GL_TEXTURE_2D_MULTISAMPLE = $9100;
  GL_PROXY_TEXTURE_2D_MULTISAMPLE = $9101;
  GL_TEXTURE_2D_MULTISAMPLE_ARRAY = $9102;
  GL_TEXTURE_2D_MULTISAMPLE_ARRAY_OES = $9102;
  GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = $9103;
  GL_TEXTURE_BINDING_2D_MULTISAMPLE = $9104;
  GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = $9105;
  GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY_OES = $9105;
  GL_TEXTURE_SAMPLES = $9106;
  GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = $9107;
  GL_SAMPLER_2D_MULTISAMPLE = $9108;
  GL_INT_SAMPLER_2D_MULTISAMPLE = $9109;
  GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = $910A;
  GL_SAMPLER_2D_MULTISAMPLE_ARRAY = $910B;
  GL_SAMPLER_2D_MULTISAMPLE_ARRAY_OES = $910B;
  GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = $910C;
  GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES = $910C;
  GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = $910D;
  GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY_OES = $910D;
  GL_MAX_COLOR_TEXTURE_SAMPLES = $910E;
  GL_MAX_DEPTH_TEXTURE_SAMPLES = $910F;
  GL_MAX_INTEGER_SAMPLES = $9110;
  GL_MAX_SERVER_WAIT_TIMEOUT = $9111;
  GL_MAX_SERVER_WAIT_TIMEOUT_APPLE = $9111;
  GL_OBJECT_TYPE = $9112;
  GL_OBJECT_TYPE_APPLE = $9112;
  GL_SYNC_CONDITION = $9113;
  GL_SYNC_CONDITION_APPLE = $9113;
  GL_SYNC_STATUS = $9114;
  GL_SYNC_STATUS_APPLE = $9114;
  GL_SYNC_FLAGS = $9115;
  GL_SYNC_FLAGS_APPLE = $9115;
  GL_SYNC_FENCE = $9116;
  GL_SYNC_FENCE_APPLE = $9116;
  GL_SYNC_GPU_COMMANDS_COMPLETE = $9117;
  GL_SYNC_GPU_COMMANDS_COMPLETE_APPLE = $9117;
  GL_UNSIGNALED = $9118;
  GL_UNSIGNALED_APPLE = $9118;
  GL_SIGNALED = $9119;
  GL_SIGNALED_APPLE = $9119;
  GL_ALREADY_SIGNALED = $911A;
  GL_ALREADY_SIGNALED_APPLE = $911A;
  GL_TIMEOUT_EXPIRED = $911B;
  GL_TIMEOUT_EXPIRED_APPLE = $911B;
  GL_CONDITION_SATISFIED = $911C;
  GL_CONDITION_SATISFIED_APPLE = $911C;
  GL_WAIT_FAILED = $911D;
  GL_WAIT_FAILED_APPLE = $911D;
  GL_BUFFER_ACCESS_FLAGS = $911F;
  GL_BUFFER_MAP_LENGTH = $9120;
  GL_BUFFER_MAP_OFFSET = $9121;
  GL_MAX_VERTEX_OUTPUT_COMPONENTS = $9122;
  GL_MAX_GEOMETRY_INPUT_COMPONENTS = $9123;
  GL_MAX_GEOMETRY_INPUT_COMPONENTS_EXT = $9123;
  GL_MAX_GEOMETRY_INPUT_COMPONENTS_OES = $9123;
  GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = $9124;
  GL_MAX_GEOMETRY_OUTPUT_COMPONENTS_EXT = $9124;
  GL_MAX_GEOMETRY_OUTPUT_COMPONENTS_OES = $9124;
  GL_MAX_FRAGMENT_INPUT_COMPONENTS = $9125;
  GL_CONTEXT_PROFILE_MASK = $9126;
  GL_UNPACK_COMPRESSED_BLOCK_WIDTH = $9127;
  GL_UNPACK_COMPRESSED_BLOCK_HEIGHT = $9128;
  GL_UNPACK_COMPRESSED_BLOCK_DEPTH = $9129;
  GL_UNPACK_COMPRESSED_BLOCK_SIZE = $912A;
  GL_PACK_COMPRESSED_BLOCK_WIDTH = $912B;
  GL_PACK_COMPRESSED_BLOCK_HEIGHT = $912C;
  GL_PACK_COMPRESSED_BLOCK_DEPTH = $912D;
  GL_PACK_COMPRESSED_BLOCK_SIZE = $912E;
  GL_TEXTURE_IMMUTABLE_FORMAT = $912F;
  GL_TEXTURE_IMMUTABLE_FORMAT_EXT = $912F;
  GL_SGX_PROGRAM_BINARY_IMG = $9130;
  GL_RENDERBUFFER_SAMPLES_IMG = $9133;
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_IMG = $9134;
  GL_MAX_SAMPLES_IMG = $9135;
  GL_TEXTURE_SAMPLES_IMG = $9136;
  GL_COMPRESSED_RGBA_PVRTC_2BPPV2_IMG = $9137;
  GL_COMPRESSED_RGBA_PVRTC_4BPPV2_IMG = $9138;
  GL_CUBIC_IMG = $9139;
  GL_CUBIC_MIPMAP_NEAREST_IMG = $913A;
  GL_CUBIC_MIPMAP_LINEAR_IMG = $913B;
  GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_AND_DOWNSAMPLE_IMG = $913C;
  GL_NUM_DOWNSAMPLE_SCALES_IMG = $913D;
  GL_DOWNSAMPLE_SCALES_IMG = $913E;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_SCALE_IMG = $913F;
  GL_MAX_DEBUG_MESSAGE_LENGTH = $9143;
  GL_MAX_DEBUG_MESSAGE_LENGTH_AMD = $9143;
  GL_MAX_DEBUG_MESSAGE_LENGTH_ARB = $9143;
  GL_MAX_DEBUG_MESSAGE_LENGTH_KHR = $9143;
  GL_MAX_DEBUG_LOGGED_MESSAGES = $9144;
  GL_MAX_DEBUG_LOGGED_MESSAGES_AMD = $9144;
  GL_MAX_DEBUG_LOGGED_MESSAGES_ARB = $9144;
  GL_MAX_DEBUG_LOGGED_MESSAGES_KHR = $9144;
  GL_DEBUG_LOGGED_MESSAGES = $9145;
  GL_DEBUG_LOGGED_MESSAGES_AMD = $9145;
  GL_DEBUG_LOGGED_MESSAGES_ARB = $9145;
  GL_DEBUG_LOGGED_MESSAGES_KHR = $9145;
  GL_DEBUG_SEVERITY_HIGH = $9146;
  GL_DEBUG_SEVERITY_HIGH_AMD = $9146;
  GL_DEBUG_SEVERITY_HIGH_ARB = $9146;
  GL_DEBUG_SEVERITY_HIGH_KHR = $9146;
  GL_DEBUG_SEVERITY_MEDIUM = $9147;
  GL_DEBUG_SEVERITY_MEDIUM_AMD = $9147;
  GL_DEBUG_SEVERITY_MEDIUM_ARB = $9147;
  GL_DEBUG_SEVERITY_MEDIUM_KHR = $9147;
  GL_DEBUG_SEVERITY_LOW = $9148;
  GL_DEBUG_SEVERITY_LOW_AMD = $9148;
  GL_DEBUG_SEVERITY_LOW_ARB = $9148;
  GL_DEBUG_SEVERITY_LOW_KHR = $9148;
  GL_DEBUG_CATEGORY_API_ERROR_AMD = $9149;
  GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD = $914A;
  GL_DEBUG_CATEGORY_DEPRECATION_AMD = $914B;
  GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD = $914C;
  GL_DEBUG_CATEGORY_PERFORMANCE_AMD = $914D;
  GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD = $914E;
  GL_DEBUG_CATEGORY_APPLICATION_AMD = $914F;
  GL_DEBUG_CATEGORY_OTHER_AMD = $9150;
  GL_BUFFER_OBJECT_EXT = $9151;
  GL_DATA_BUFFER_AMD = $9151;
  GL_PERFORMANCE_MONITOR_AMD = $9152;
  GL_QUERY_OBJECT_AMD = $9153;
  GL_QUERY_OBJECT_EXT = $9153;
  GL_VERTEX_ARRAY_OBJECT_AMD = $9154;
  GL_VERTEX_ARRAY_OBJECT_EXT = $9154;
  GL_SAMPLER_OBJECT_AMD = $9155;
  GL_EXTERNAL_VIRTUAL_MEMORY_BUFFER_AMD = $9160;
  GL_QUERY_BUFFER = $9192;
  GL_QUERY_BUFFER_AMD = $9192;
  GL_QUERY_BUFFER_BINDING = $9193;
  GL_QUERY_BUFFER_BINDING_AMD = $9193;
  GL_QUERY_RESULT_NO_WAIT = $9194;
  GL_QUERY_RESULT_NO_WAIT_AMD = $9194;
  GL_VIRTUAL_PAGE_SIZE_X_ARB = $9195;
  GL_VIRTUAL_PAGE_SIZE_X_EXT = $9195;
  GL_VIRTUAL_PAGE_SIZE_X_AMD = $9195;
  GL_VIRTUAL_PAGE_SIZE_Y_ARB = $9196;
  GL_VIRTUAL_PAGE_SIZE_Y_EXT = $9196;
  GL_VIRTUAL_PAGE_SIZE_Y_AMD = $9196;
  GL_VIRTUAL_PAGE_SIZE_Z_ARB = $9197;
  GL_VIRTUAL_PAGE_SIZE_Z_EXT = $9197;
  GL_VIRTUAL_PAGE_SIZE_Z_AMD = $9197;
  GL_MAX_SPARSE_TEXTURE_SIZE_ARB = $9198;
  GL_MAX_SPARSE_TEXTURE_SIZE_EXT = $9198;
  GL_MAX_SPARSE_TEXTURE_SIZE_AMD = $9198;
  GL_MAX_SPARSE_3D_TEXTURE_SIZE_ARB = $9199;
  GL_MAX_SPARSE_3D_TEXTURE_SIZE_EXT = $9199;
  GL_MAX_SPARSE_3D_TEXTURE_SIZE_AMD = $9199;
  GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS = $919A;
  GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_ARB = $919A;
  GL_MAX_SPARSE_ARRAY_TEXTURE_LAYERS_EXT = $919A;
  GL_MIN_SPARSE_LEVEL_AMD = $919B;
  GL_MIN_LOD_WARNING_AMD = $919C;
  GL_TEXTURE_BUFFER_OFFSET = $919D;
  GL_TEXTURE_BUFFER_OFFSET_EXT = $919D;
  GL_TEXTURE_BUFFER_OFFSET_OES = $919D;
  GL_TEXTURE_BUFFER_SIZE = $919E;
  GL_TEXTURE_BUFFER_SIZE_EXT = $919E;
  GL_TEXTURE_BUFFER_SIZE_OES = $919E;
  GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT = $919F;
  GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT_EXT = $919F;
  GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT_OES = $919F;
  GL_STREAM_RASTERIZATION_AMD = $91A0;
  GL_VERTEX_ELEMENT_SWIZZLE_AMD = $91A4;
  GL_VERTEX_ID_SWIZZLE_AMD = $91A5;
  GL_TEXTURE_SPARSE_ARB = $91A6;
  GL_TEXTURE_SPARSE_EXT = $91A6;
  GL_VIRTUAL_PAGE_SIZE_INDEX_ARB = $91A7;
  GL_VIRTUAL_PAGE_SIZE_INDEX_EXT = $91A7;
  GL_NUM_VIRTUAL_PAGE_SIZES_ARB = $91A8;
  GL_NUM_VIRTUAL_PAGE_SIZES_EXT = $91A8;
  GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_ARB = $91A9;
  GL_SPARSE_TEXTURE_FULL_ARRAY_CUBE_MIPMAPS_EXT = $91A9;
  GL_NUM_SPARSE_LEVELS_ARB = $91AA;
  GL_NUM_SPARSE_LEVELS_EXT = $91AA;
  GL_PIXELS_PER_SAMPLE_PATTERN_X_AMD = $91AE;
  GL_PIXELS_PER_SAMPLE_PATTERN_Y_AMD = $91AF;
  GL_MAX_SHADER_COMPILER_THREADS_ARB = $91B0;
  GL_COMPLETION_STATUS_ARB = $91B1;
  GL_COMPUTE_SHADER = $91B9;
  GL_MAX_COMPUTE_UNIFORM_BLOCKS = $91BB;
  GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS = $91BC;
  GL_MAX_COMPUTE_IMAGE_UNIFORMS = $91BD;
  GL_MAX_COMPUTE_WORK_GROUP_COUNT = $91BE;
  GL_MAX_COMPUTE_WORK_GROUP_SIZE = $91BF;
  GL_MAX_COMPUTE_FIXED_GROUP_SIZE_ARB = $91BF;
  GL_FLOAT16_MAT2_AMD = $91C5;
  GL_FLOAT16_MAT3_AMD = $91C6;
  GL_FLOAT16_MAT4_AMD = $91C7;
  GL_FLOAT16_MAT2x3_AMD = $91C8;
  GL_FLOAT16_MAT2x4_AMD = $91C9;
  GL_FLOAT16_MAT3x2_AMD = $91CA;
  GL_FLOAT16_MAT3x4_AMD = $91CB;
  GL_FLOAT16_MAT4x2_AMD = $91CC;
  GL_FLOAT16_MAT4x3_AMD = $91CD;
  GL_UNPACK_FLIP_Y_WEBGL = $9240;
  GL_UNPACK_PREMULTIPLY_ALPHA_WEBGL = $9241;
  GL_CONTEXT_LOST_WEBGL = $9242;
  GL_UNPACK_COLORSPACE_CONVERSION_WEBGL = $9243;
  GL_BROWSER_DEFAULT_WEBGL = $9244;
  GL_SHADER_BINARY_DMP = $9250;
  GL_SMAPHS30_PROGRAM_BINARY_DMP = $9251;
  GL_SMAPHS_PROGRAM_BINARY_DMP = $9252;
  GL_DMP_PROGRAM_BINARY_DMP = $9253;
  GL_GCCSO_SHADER_BINARY_FJ = $9260;
  GL_COMPRESSED_R11_EAC = $9270;
  GL_COMPRESSED_R11_EAC_OES = $9270;
  GL_COMPRESSED_SIGNED_R11_EAC = $9271;
  GL_COMPRESSED_SIGNED_R11_EAC_OES = $9271;
  GL_COMPRESSED_RG11_EAC = $9272;
  GL_COMPRESSED_RG11_EAC_OES = $9272;
  GL_COMPRESSED_SIGNED_RG11_EAC = $9273;
  GL_COMPRESSED_SIGNED_RG11_EAC_OES = $9273;
  GL_COMPRESSED_RGB8_ETC2 = $9274;
  GL_COMPRESSED_RGB8_ETC2_OES = $9274;
  GL_COMPRESSED_SRGB8_ETC2 = $9275;
  GL_COMPRESSED_SRGB8_ETC2_OES = $9275;
  GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = $9276;
  GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2_OES = $9276;
  GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = $9277;
  GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2_OES = $9277;
  GL_COMPRESSED_RGBA8_ETC2_EAC = $9278;
  GL_COMPRESSED_RGBA8_ETC2_EAC_OES = $9278;
  GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = $9279;
  GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC_OES = $9279;
  GL_BLEND_PREMULTIPLIED_SRC_NV = $9280;
  GL_BLEND_OVERLAP_NV = $9281;
  GL_UNCORRELATED_NV = $9282;
  GL_DISJOINT_NV = $9283;
  GL_CONJOINT_NV = $9284;
  GL_BLEND_ADVANCED_COHERENT_KHR = $9285;
  GL_BLEND_ADVANCED_COHERENT_NV = $9285;
  GL_SRC_NV = $9286;
  GL_DST_NV = $9287;
  GL_SRC_OVER_NV = $9288;
  GL_DST_OVER_NV = $9289;
  GL_SRC_IN_NV = $928A;
  GL_DST_IN_NV = $928B;
  GL_SRC_OUT_NV = $928C;
  GL_DST_OUT_NV = $928D;
  GL_SRC_ATOP_NV = $928E;
  GL_DST_ATOP_NV = $928F;
  GL_PLUS_NV = $9291;
  GL_PLUS_DARKER_NV = $9292;
  GL_MULTIPLY = $9294;
  GL_MULTIPLY_KHR = $9294;
  GL_MULTIPLY_NV = $9294;
  GL_SCREEN = $9295;
  GL_SCREEN_KHR = $9295;
  GL_SCREEN_NV = $9295;
  GL_OVERLAY = $9296;
  GL_OVERLAY_KHR = $9296;
  GL_OVERLAY_NV = $9296;
  GL_DARKEN = $9297;
  GL_DARKEN_KHR = $9297;
  GL_DARKEN_NV = $9297;
  GL_LIGHTEN = $9298;
  GL_LIGHTEN_KHR = $9298;
  GL_LIGHTEN_NV = $9298;
  GL_COLORDODGE = $9299;
  GL_COLORDODGE_KHR = $9299;
  GL_COLORDODGE_NV = $9299;
  GL_COLORBURN = $929A;
  GL_COLORBURN_KHR = $929A;
  GL_COLORBURN_NV = $929A;
  GL_HARDLIGHT = $929B;
  GL_HARDLIGHT_KHR = $929B;
  GL_HARDLIGHT_NV = $929B;
  GL_SOFTLIGHT = $929C;
  GL_SOFTLIGHT_KHR = $929C;
  GL_SOFTLIGHT_NV = $929C;
  GL_DIFFERENCE = $929E;
  GL_DIFFERENCE_KHR = $929E;
  GL_DIFFERENCE_NV = $929E;
  GL_MINUS_NV = $929F;
  GL_EXCLUSION = $92A0;
  GL_EXCLUSION_KHR = $92A0;
  GL_EXCLUSION_NV = $92A0;
  GL_CONTRAST_NV = $92A1;
  GL_INVERT_RGB_NV = $92A3;
  GL_LINEARDODGE_NV = $92A4;
  GL_LINEARBURN_NV = $92A5;
  GL_VIVIDLIGHT_NV = $92A6;
  GL_LINEARLIGHT_NV = $92A7;
  GL_PINLIGHT_NV = $92A8;
  GL_HARDMIX_NV = $92A9;
  GL_HSL_HUE = $92AD;
  GL_HSL_HUE_KHR = $92AD;
  GL_HSL_HUE_NV = $92AD;
  GL_HSL_SATURATION = $92AE;
  GL_HSL_SATURATION_KHR = $92AE;
  GL_HSL_SATURATION_NV = $92AE;
  GL_HSL_COLOR = $92AF;
  GL_HSL_COLOR_KHR = $92AF;
  GL_HSL_COLOR_NV = $92AF;
  GL_HSL_LUMINOSITY = $92B0;
  GL_HSL_LUMINOSITY_KHR = $92B0;
  GL_HSL_LUMINOSITY_NV = $92B0;
  GL_PLUS_CLAMPED_NV = $92B1;
  GL_PLUS_CLAMPED_ALPHA_NV = $92B2;
  GL_MINUS_CLAMPED_NV = $92B3;
  GL_INVERT_OVG_NV = $92B4;
  GL_MAX_LGPU_GPUS_NVX = $92BA;
  GL_MULTICAST_GPUS_NV = $92BA;
  GL_PURGED_CONTEXT_RESET_NV = $92BB;
  GL_PRIMITIVE_BOUNDING_BOX_ARB = $92BE;
  GL_PRIMITIVE_BOUNDING_BOX = $92BE;
  GL_PRIMITIVE_BOUNDING_BOX_EXT = $92BE;
  GL_PRIMITIVE_BOUNDING_BOX_OES = $92BE;
  GL_ALPHA_TO_COVERAGE_DITHER_MODE_NV = $92BF;
  GL_ATOMIC_COUNTER_BUFFER = $92C0;
  GL_ATOMIC_COUNTER_BUFFER_BINDING = $92C1;
  GL_ATOMIC_COUNTER_BUFFER_START = $92C2;
  GL_ATOMIC_COUNTER_BUFFER_SIZE = $92C3;
  GL_ATOMIC_COUNTER_BUFFER_DATA_SIZE = $92C4;
  GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTERS = $92C5;
  GL_ATOMIC_COUNTER_BUFFER_ACTIVE_ATOMIC_COUNTER_INDICES = $92C6;
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_VERTEX_SHADER = $92C7;
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_CONTROL_SHADER = $92C8;
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_TESS_EVALUATION_SHADER = $92C9;
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_GEOMETRY_SHADER = $92CA;
  GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_FRAGMENT_SHADER = $92CB;
  GL_MAX_VERTEX_ATOMIC_COUNTER_BUFFERS = $92CC;
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS = $92CD;
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_EXT = $92CD;
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTER_BUFFERS_OES = $92CD;
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS = $92CE;
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_EXT = $92CE;
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTER_BUFFERS_OES = $92CE;
  GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS = $92CF;
  GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_EXT = $92CF;
  GL_MAX_GEOMETRY_ATOMIC_COUNTER_BUFFERS_OES = $92CF;
  GL_MAX_FRAGMENT_ATOMIC_COUNTER_BUFFERS = $92D0;
  GL_MAX_COMBINED_ATOMIC_COUNTER_BUFFERS = $92D1;
  GL_MAX_VERTEX_ATOMIC_COUNTERS = $92D2;
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS = $92D3;
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS_EXT = $92D3;
  GL_MAX_TESS_CONTROL_ATOMIC_COUNTERS_OES = $92D3;
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS = $92D4;
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_EXT = $92D4;
  GL_MAX_TESS_EVALUATION_ATOMIC_COUNTERS_OES = $92D4;
  GL_MAX_GEOMETRY_ATOMIC_COUNTERS = $92D5;
  GL_MAX_GEOMETRY_ATOMIC_COUNTERS_EXT = $92D5;
  GL_MAX_GEOMETRY_ATOMIC_COUNTERS_OES = $92D5;
  GL_MAX_FRAGMENT_ATOMIC_COUNTERS = $92D6;
  GL_MAX_COMBINED_ATOMIC_COUNTERS = $92D7;
  GL_MAX_ATOMIC_COUNTER_BUFFER_SIZE = $92D8;
  GL_ACTIVE_ATOMIC_COUNTER_BUFFERS = $92D9;
  GL_UNIFORM_ATOMIC_COUNTER_BUFFER_INDEX = $92DA;
  GL_UNSIGNED_INT_ATOMIC_COUNTER = $92DB;
  GL_MAX_ATOMIC_COUNTER_BUFFER_BINDINGS = $92DC;
  GL_FRAGMENT_COVERAGE_TO_COLOR_NV = $92DD;
  GL_FRAGMENT_COVERAGE_COLOR_NV = $92DE;
  GL_DEBUG_OUTPUT = $92E0;
  GL_DEBUG_OUTPUT_KHR = $92E0;
  GL_UNIFORM = $92E1;
  GL_UNIFORM_BLOCK = $92E2;
  GL_PROGRAM_INPUT = $92E3;
  GL_PROGRAM_OUTPUT = $92E4;
  GL_BUFFER_VARIABLE = $92E5;
  GL_SHADER_STORAGE_BLOCK = $92E6;
  GL_IS_PER_PATCH = $92E7;
  GL_IS_PER_PATCH_EXT = $92E7;
  GL_IS_PER_PATCH_OES = $92E7;
  GL_VERTEX_SUBROUTINE = $92E8;
  GL_TESS_CONTROL_SUBROUTINE = $92E9;
  GL_TESS_EVALUATION_SUBROUTINE = $92EA;
  GL_GEOMETRY_SUBROUTINE = $92EB;
  GL_FRAGMENT_SUBROUTINE = $92EC;
  GL_COMPUTE_SUBROUTINE = $92ED;
  GL_VERTEX_SUBROUTINE_UNIFORM = $92EE;
  GL_TESS_CONTROL_SUBROUTINE_UNIFORM = $92EF;
  GL_TESS_EVALUATION_SUBROUTINE_UNIFORM = $92F0;
  GL_GEOMETRY_SUBROUTINE_UNIFORM = $92F1;
  GL_FRAGMENT_SUBROUTINE_UNIFORM = $92F2;
  GL_COMPUTE_SUBROUTINE_UNIFORM = $92F3;
  GL_TRANSFORM_FEEDBACK_VARYING = $92F4;
  GL_ACTIVE_RESOURCES = $92F5;
  GL_MAX_NAME_LENGTH = $92F6;
  GL_MAX_NUM_ACTIVE_VARIABLES = $92F7;
  GL_MAX_NUM_COMPATIBLE_SUBROUTINES = $92F8;
  GL_NAME_LENGTH = $92F9;
  GL_TYPE = $92FA;
  GL_ARRAY_SIZE = $92FB;
  GL_OFFSET = $92FC;
  GL_BLOCK_INDEX = $92FD;
  GL_ARRAY_STRIDE = $92FE;
  GL_MATRIX_STRIDE = $92FF;
  GL_IS_ROW_MAJOR = $9300;
  GL_ATOMIC_COUNTER_BUFFER_INDEX = $9301;
  GL_BUFFER_BINDING = $9302;
  GL_BUFFER_DATA_SIZE = $9303;
  GL_NUM_ACTIVE_VARIABLES = $9304;
  GL_ACTIVE_VARIABLES = $9305;
  GL_REFERENCED_BY_VERTEX_SHADER = $9306;
  GL_REFERENCED_BY_TESS_CONTROL_SHADER = $9307;
  GL_REFERENCED_BY_TESS_CONTROL_SHADER_EXT = $9307;
  GL_REFERENCED_BY_TESS_CONTROL_SHADER_OES = $9307;
  GL_REFERENCED_BY_TESS_EVALUATION_SHADER = $9308;
  GL_REFERENCED_BY_TESS_EVALUATION_SHADER_EXT = $9308;
  GL_REFERENCED_BY_TESS_EVALUATION_SHADER_OES = $9308;
  GL_REFERENCED_BY_GEOMETRY_SHADER = $9309;
  GL_REFERENCED_BY_GEOMETRY_SHADER_EXT = $9309;
  GL_REFERENCED_BY_GEOMETRY_SHADER_OES = $9309;
  GL_REFERENCED_BY_FRAGMENT_SHADER = $930A;
  GL_REFERENCED_BY_COMPUTE_SHADER = $930B;
  GL_TOP_LEVEL_ARRAY_SIZE = $930C;
  GL_TOP_LEVEL_ARRAY_STRIDE = $930D;
  GL_LOCATION = $930E;
  GL_LOCATION_INDEX = $930F;
  GL_LOCATION_INDEX_EXT = $930F;
  GL_FRAMEBUFFER_DEFAULT_WIDTH = $9310;
  GL_FRAMEBUFFER_DEFAULT_HEIGHT = $9311;
  GL_FRAMEBUFFER_DEFAULT_LAYERS = $9312;
  GL_FRAMEBUFFER_DEFAULT_LAYERS_EXT = $9312;
  GL_FRAMEBUFFER_DEFAULT_LAYERS_OES = $9312;
  GL_FRAMEBUFFER_DEFAULT_SAMPLES = $9313;
  GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = $9314;
  GL_MAX_FRAMEBUFFER_WIDTH = $9315;
  GL_MAX_FRAMEBUFFER_HEIGHT = $9316;
  GL_MAX_FRAMEBUFFER_LAYERS = $9317;
  GL_MAX_FRAMEBUFFER_LAYERS_EXT = $9317;
  GL_MAX_FRAMEBUFFER_LAYERS_OES = $9317;
  GL_MAX_FRAMEBUFFER_SAMPLES = $9318;
  GL_RASTER_MULTISAMPLE_EXT = $9327;
  GL_RASTER_SAMPLES_EXT = $9328;
  GL_MAX_RASTER_SAMPLES_EXT = $9329;
  GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT = $932A;
  GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT = $932B;
  GL_EFFECTIVE_RASTER_SAMPLES_EXT = $932C;
  GL_DEPTH_SAMPLES_NV = $932D;
  GL_STENCIL_SAMPLES_NV = $932E;
  GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV = $932F;
  GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV = $9330;
  GL_COVERAGE_MODULATION_TABLE_NV = $9331;
  GL_COVERAGE_MODULATION_NV = $9332;
  GL_COVERAGE_MODULATION_TABLE_SIZE_NV = $9333;
  GL_WARP_SIZE_NV = $9339;
  GL_WARPS_PER_SM_NV = $933A;
  GL_SM_COUNT_NV = $933B;
  GL_FILL_RECTANGLE_NV = $933C;
  GL_SAMPLE_LOCATION_SUBPIXEL_BITS_ARB = $933D;
  GL_SAMPLE_LOCATION_SUBPIXEL_BITS_NV = $933D;
  GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_ARB = $933E;
  GL_SAMPLE_LOCATION_PIXEL_GRID_WIDTH_NV = $933E;
  GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_ARB = $933F;
  GL_SAMPLE_LOCATION_PIXEL_GRID_HEIGHT_NV = $933F;
  GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_ARB = $9340;
  GL_PROGRAMMABLE_SAMPLE_LOCATION_TABLE_SIZE_NV = $9340;
  GL_PROGRAMMABLE_SAMPLE_LOCATION_ARB = $9341;
  GL_PROGRAMMABLE_SAMPLE_LOCATION_NV = $9341;
  GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_ARB = $9342;
  GL_FRAMEBUFFER_PROGRAMMABLE_SAMPLE_LOCATIONS_NV = $9342;
  GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_ARB = $9343;
  GL_FRAMEBUFFER_SAMPLE_LOCATION_PIXEL_GRID_NV = $9343;
  GL_MAX_COMPUTE_VARIABLE_GROUP_INVOCATIONS_ARB = $9344;
  GL_MAX_COMPUTE_VARIABLE_GROUP_SIZE_ARB = $9345;
  GL_CONSERVATIVE_RASTERIZATION_NV = $9346;
  GL_SUBPIXEL_PRECISION_BIAS_X_BITS_NV = $9347;
  GL_SUBPIXEL_PRECISION_BIAS_Y_BITS_NV = $9348;
  GL_MAX_SUBPIXEL_PRECISION_BIAS_BITS_NV = $9349;
  GL_LOCATION_COMPONENT = $934A;
  GL_TRANSFORM_FEEDBACK_BUFFER_INDEX = $934B;
  GL_TRANSFORM_FEEDBACK_BUFFER_STRIDE = $934C;
  GL_ALPHA_TO_COVERAGE_DITHER_DEFAULT_NV = $934D;
  GL_ALPHA_TO_COVERAGE_DITHER_ENABLE_NV = $934E;
  GL_ALPHA_TO_COVERAGE_DITHER_DISABLE_NV = $934F;
  GL_VIEWPORT_SWIZZLE_POSITIVE_X_NV = $9350;
  GL_VIEWPORT_SWIZZLE_NEGATIVE_X_NV = $9351;
  GL_VIEWPORT_SWIZZLE_POSITIVE_Y_NV = $9352;
  GL_VIEWPORT_SWIZZLE_NEGATIVE_Y_NV = $9353;
  GL_VIEWPORT_SWIZZLE_POSITIVE_Z_NV = $9354;
  GL_VIEWPORT_SWIZZLE_NEGATIVE_Z_NV = $9355;
  GL_VIEWPORT_SWIZZLE_POSITIVE_W_NV = $9356;
  GL_VIEWPORT_SWIZZLE_NEGATIVE_W_NV = $9357;
  GL_VIEWPORT_SWIZZLE_X_NV = $9358;
  GL_VIEWPORT_SWIZZLE_Y_NV = $9359;
  GL_VIEWPORT_SWIZZLE_Z_NV = $935A;
  GL_VIEWPORT_SWIZZLE_W_NV = $935B;
  GL_CLIP_ORIGIN = $935C;
  GL_CLIP_DEPTH_MODE = $935D;
  GL_NEGATIVE_ONE_TO_ONE = $935E;
  GL_ZERO_TO_ONE = $935F;
  GL_CLEAR_TEXTURE = $9365;
  GL_TEXTURE_REDUCTION_MODE_ARB = $9366;
  GL_WEIGHTED_AVERAGE_ARB = $9367;
  GL_FONT_GLYPHS_AVAILABLE_NV = $9368;
  GL_FONT_TARGET_UNAVAILABLE_NV = $9369;
  GL_FONT_UNAVAILABLE_NV = $936A;
  GL_FONT_UNINTELLIGIBLE_NV = $936B;
  GL_STANDARD_FONT_FORMAT_NV = $936C;
  GL_FRAGMENT_INPUT_NV = $936D;
  GL_UNIFORM_BUFFER_UNIFIED_NV = $936E;
  GL_UNIFORM_BUFFER_ADDRESS_NV = $936F;
  GL_UNIFORM_BUFFER_LENGTH_NV = $9370;
  GL_MULTISAMPLES_NV = $9371;
  GL_SUPERSAMPLE_SCALE_X_NV = $9372;
  GL_SUPERSAMPLE_SCALE_Y_NV = $9373;
  GL_CONFORMANT_NV = $9374;
  GL_CONSERVATIVE_RASTER_DILATE_NV = $9379;
  GL_CONSERVATIVE_RASTER_DILATE_RANGE_NV = $937A;
  GL_CONSERVATIVE_RASTER_DILATE_GRANULARITY_NV = $937B;
  GL_VIEWPORT_POSITION_W_SCALE_NV = $937C;
  GL_VIEWPORT_POSITION_W_SCALE_X_COEFF_NV = $937D;
  GL_VIEWPORT_POSITION_W_SCALE_Y_COEFF_NV = $937E;
  GL_NUM_SAMPLE_COUNTS = $9380;
  GL_MULTISAMPLE_LINE_WIDTH_RANGE_ARB = $9381;
  GL_MULTISAMPLE_LINE_WIDTH_RANGE = $9381;
  GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY_ARB = $9382;
  GL_MULTISAMPLE_LINE_WIDTH_GRANULARITY = $9382;
  GL_TRANSLATED_SHADER_SOURCE_LENGTH_ANGLE = $93A0;
  GL_BGRA8_EXT = $93A1;
  GL_TEXTURE_USAGE_ANGLE = $93A2;
  GL_FRAMEBUFFER_ATTACHMENT_ANGLE = $93A3;
  GL_PACK_REVERSE_ROW_ORDER_ANGLE = $93A4;
  GL_PROGRAM_BINARY_ANGLE = $93A6;
  GL_COMPRESSED_RGBA_ASTC_4x4 = $93B0;
  GL_COMPRESSED_RGBA_ASTC_4x4_KHR = $93B0;
  GL_COMPRESSED_RGBA_ASTC_5x4 = $93B1;
  GL_COMPRESSED_RGBA_ASTC_5x4_KHR = $93B1;
  GL_COMPRESSED_RGBA_ASTC_5x5 = $93B2;
  GL_COMPRESSED_RGBA_ASTC_5x5_KHR = $93B2;
  GL_COMPRESSED_RGBA_ASTC_6x5 = $93B3;
  GL_COMPRESSED_RGBA_ASTC_6x5_KHR = $93B3;
  GL_COMPRESSED_RGBA_ASTC_6x6 = $93B4;
  GL_COMPRESSED_RGBA_ASTC_6x6_KHR = $93B4;
  GL_COMPRESSED_RGBA_ASTC_8x5 = $93B5;
  GL_COMPRESSED_RGBA_ASTC_8x5_KHR = $93B5;
  GL_COMPRESSED_RGBA_ASTC_8x6 = $93B6;
  GL_COMPRESSED_RGBA_ASTC_8x6_KHR = $93B6;
  GL_COMPRESSED_RGBA_ASTC_8x8 = $93B7;
  GL_COMPRESSED_RGBA_ASTC_8x8_KHR = $93B7;
  GL_COMPRESSED_RGBA_ASTC_10x5 = $93B8;
  GL_COMPRESSED_RGBA_ASTC_10x5_KHR = $93B8;
  GL_COMPRESSED_RGBA_ASTC_10x6 = $93B9;
  GL_COMPRESSED_RGBA_ASTC_10x6_KHR = $93B9;
  GL_COMPRESSED_RGBA_ASTC_10x8 = $93BA;
  GL_COMPRESSED_RGBA_ASTC_10x8_KHR = $93BA;
  GL_COMPRESSED_RGBA_ASTC_10x10 = $93BB;
  GL_COMPRESSED_RGBA_ASTC_10x10_KHR = $93BB;
  GL_COMPRESSED_RGBA_ASTC_12x10 = $93BC;
  GL_COMPRESSED_RGBA_ASTC_12x10_KHR = $93BC;
  GL_COMPRESSED_RGBA_ASTC_12x12 = $93BD;
  GL_COMPRESSED_RGBA_ASTC_12x12_KHR = $93BD;
  GL_COMPRESSED_RGBA_ASTC_3x3x3_OES = $93C0;
  GL_COMPRESSED_RGBA_ASTC_4x3x3_OES = $93C1;
  GL_COMPRESSED_RGBA_ASTC_4x4x3_OES = $93C2;
  GL_COMPRESSED_RGBA_ASTC_4x4x4_OES = $93C3;
  GL_COMPRESSED_RGBA_ASTC_5x4x4_OES = $93C4;
  GL_COMPRESSED_RGBA_ASTC_5x5x4_OES = $93C5;
  GL_COMPRESSED_RGBA_ASTC_5x5x5_OES = $93C6;
  GL_COMPRESSED_RGBA_ASTC_6x5x5_OES = $93C7;
  GL_COMPRESSED_RGBA_ASTC_6x6x5_OES = $93C8;
  GL_COMPRESSED_RGBA_ASTC_6x6x6_OES = $93C9;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4 = $93D0;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR = $93D0;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4 = $93D1;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR = $93D1;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5 = $93D2;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR = $93D2;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5 = $93D3;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR = $93D3;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6 = $93D4;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR = $93D4;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5 = $93D5;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR = $93D5;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6 = $93D6;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR = $93D6;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8 = $93D7;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR = $93D7;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5 = $93D8;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR = $93D8;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6 = $93D9;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR = $93D9;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8 = $93DA;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR = $93DA;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10 = $93DB;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR = $93DB;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10 = $93DC;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR = $93DC;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12 = $93DD;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR = $93DD;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_3x3x3_OES = $93E0;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x3x3_OES = $93E1;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x3_OES = $93E2;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4x4_OES = $93E3;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4x4_OES = $93E4;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x4_OES = $93E5;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5x5_OES = $93E6;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5x5_OES = $93E7;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x5_OES = $93E8;
  GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6x6_OES = $93E9;
  GL_COMPRESSED_SRGB_ALPHA_PVRTC_2BPPV2_IMG = $93F0;
  GL_COMPRESSED_SRGB_ALPHA_PVRTC_4BPPV2_IMG = $93F1;
  GL_PERFQUERY_COUNTER_EVENT_INTEL = $94F0;
  GL_PERFQUERY_COUNTER_DURATION_NORM_INTEL = $94F1;
  GL_PERFQUERY_COUNTER_DURATION_RAW_INTEL = $94F2;
  GL_PERFQUERY_COUNTER_THROUGHPUT_INTEL = $94F3;
  GL_PERFQUERY_COUNTER_RAW_INTEL = $94F4;
  GL_PERFQUERY_COUNTER_TIMESTAMP_INTEL = $94F5;
  GL_PERFQUERY_COUNTER_DATA_UINT32_INTEL = $94F8;
  GL_PERFQUERY_COUNTER_DATA_UINT64_INTEL = $94F9;
  GL_PERFQUERY_COUNTER_DATA_FLOAT_INTEL = $94FA;
  GL_PERFQUERY_COUNTER_DATA_DOUBLE_INTEL = $94FB;
  GL_PERFQUERY_COUNTER_DATA_BOOL32_INTEL = $94FC;
  GL_PERFQUERY_QUERY_NAME_LENGTH_MAX_INTEL = $94FD;
  GL_PERFQUERY_COUNTER_NAME_LENGTH_MAX_INTEL = $94FE;
  GL_PERFQUERY_COUNTER_DESC_LENGTH_MAX_INTEL = $94FF;
  GL_PERFQUERY_GPA_EXTENDED_COUNTERS_INTEL = $9500;
  GL_PER_GPU_STORAGE_NV = $9548;
  GL_MULTICAST_PROGRAMMABLE_SAMPLE_LOCATION_NV = $9549;
  GL_CONSERVATIVE_RASTER_MODE_NV = $954D;
  GL_CONSERVATIVE_RASTER_MODE_POST_SNAP_NV = $954E;
  GL_CONSERVATIVE_RASTER_MODE_PRE_SNAP_TRIANGLES_NV = $954F;
  GL_SHADER_BINARY_FORMAT_SPIR_V = $9551;
  GL_SHADER_BINARY_FORMAT_SPIR_V_ARB = $9551;
  GL_SPIR_V_BINARY = $9552;
  GL_SPIR_V_BINARY_ARB = $9552;
  GL_SPIR_V_EXTENSIONS = $9553;
  GL_NUM_SPIR_V_EXTENSIONS = $9554;
  GL_RENDER_GPU_MASK_NV = $9558;
  GL_TEXTURE_TILING_EXT = $9580;
  GL_DEDICATED_MEMORY_OBJECT_EXT = $9581;
  GL_NUM_TILING_TYPES_EXT = $9582;
  GL_TILING_TYPES_EXT = $9583;
  GL_OPTIMAL_TILING_EXT = $9584;
  GL_LINEAR_TILING_EXT = $9585;
  GL_HANDLE_TYPE_OPAQUE_FD_EXT = $9586;
  GL_HANDLE_TYPE_OPAQUE_WIN32_EXT = $9587;
  GL_HANDLE_TYPE_OPAQUE_WIN32_KMT_EXT = $9588;
  GL_HANDLE_TYPE_D3D12_TILEPOOL_EXT = $9589;
  GL_HANDLE_TYPE_D3D12_RESOURCE_EXT = $958A;
  GL_HANDLE_TYPE_D3D11_IMAGE_EXT = $958B;
  GL_HANDLE_TYPE_D3D11_IMAGE_KMT_EXT = $958C;
  GL_LAYOUT_GENERAL_EXT = $958D;
  GL_LAYOUT_COLOR_ATTACHMENT_EXT = $958E;
  GL_LAYOUT_DEPTH_STENCIL_ATTACHMENT_EXT = $958F;
  GL_LAYOUT_DEPTH_STENCIL_READ_ONLY_EXT = $9590;
  GL_LAYOUT_SHADER_READ_ONLY_EXT = $9591;
  GL_LAYOUT_TRANSFER_SRC_EXT = $9592;
  GL_LAYOUT_TRANSFER_DST_EXT = $9593;
  GL_HANDLE_TYPE_D3D12_FENCE_EXT = $9594;
  GL_D3D12_FENCE_VALUE_EXT = $9595;
  GL_NUM_DEVICE_UUIDS_EXT = $9596;
  GL_DEVICE_UUID_EXT = $9597;
  GL_DRIVER_UUID_EXT = $9598;
  GL_DEVICE_LUID_EXT = $9599;
  GL_DEVICE_NODE_MASK_EXT = $959A;
  GL_PROTECTED_MEMORY_OBJECT_EXT = $959B;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_NUM_VIEWS_OVR = $9630;
  GL_MAX_VIEWS_OVR = $9631;
  GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_BASE_VIEW_INDEX_OVR = $9632;
  GL_FRAMEBUFFER_INCOMPLETE_VIEW_TARGETS_OVR = $9633;
  GL_GS_SHADER_BINARY_MTK = $9640;
  GL_GS_PROGRAM_BINARY_MTK = $9641;
  GL_MAX_SHADER_COMBINED_LOCAL_STORAGE_FAST_SIZE_EXT = $9650;
  GL_MAX_SHADER_COMBINED_LOCAL_STORAGE_SIZE_EXT = $9651;
  GL_FRAMEBUFFER_INCOMPLETE_INSUFFICIENT_SHADER_COMBINED_LOCAL_STORAGE_EXT = $9652;
  GL_FRAMEBUFFER_FETCH_NONCOHERENT_QCOM = $96A2;
  GL_RASTER_POSITION_UNCLIPPED_IBM = $19262;
  GL_CULL_VERTEX_IBM = 103050;
  GL_ALL_STATIC_DATA_IBM = 103060;
  GL_STATIC_VERTEX_ARRAY_IBM = 103061;
  GL_VERTEX_ARRAY_LIST_IBM = 103070;
  GL_NORMAL_ARRAY_LIST_IBM = 103071;
  GL_COLOR_ARRAY_LIST_IBM = 103072;
  GL_INDEX_ARRAY_LIST_IBM = 103073;
  GL_TEXTURE_COORD_ARRAY_LIST_IBM = 103074;
  GL_EDGE_FLAG_ARRAY_LIST_IBM = 103075;
  GL_FOG_COORDINATE_ARRAY_LIST_IBM = 103076;
  GL_SECONDARY_COLOR_ARRAY_LIST_IBM = 103077;
  GL_VERTEX_ARRAY_LIST_STRIDE_IBM = 103080;
  GL_NORMAL_ARRAY_LIST_STRIDE_IBM = 103081;
  GL_COLOR_ARRAY_LIST_STRIDE_IBM = 103082;
  GL_INDEX_ARRAY_LIST_STRIDE_IBM = 103083;
  GL_TEXTURE_COORD_ARRAY_LIST_STRIDE_IBM = 103084;
  GL_EDGE_FLAG_ARRAY_LIST_STRIDE_IBM = 103085;
  GL_FOG_COORDINATE_ARRAY_LIST_STRIDE_IBM = 103086;
  GL_SECONDARY_COLOR_ARRAY_LIST_STRIDE_IBM = 103087;
  GL_PREFER_DOUBLEBUFFER_HINT_PGI = $1A1F8;
  GL_CONSERVE_MEMORY_HINT_PGI = $1A1FD;
  GL_RECLAIM_MEMORY_HINT_PGI = $1A1FE;
  GL_NATIVE_GRAPHICS_HANDLE_PGI = $1A202;
  GL_NATIVE_GRAPHICS_BEGIN_HINT_PGI = $1A203;
  GL_NATIVE_GRAPHICS_END_HINT_PGI = $1A204;
  GL_ALWAYS_FAST_HINT_PGI = $1A20C;
  GL_ALWAYS_SOFT_HINT_PGI = $1A20D;
  GL_ALLOW_DRAW_OBJ_HINT_PGI = $1A20E;
  GL_ALLOW_DRAW_WIN_HINT_PGI = $1A20F;
  GL_ALLOW_DRAW_FRG_HINT_PGI = $1A210;
  GL_ALLOW_DRAW_MEM_HINT_PGI = $1A211;
  GL_STRICT_DEPTHFUNC_HINT_PGI = $1A216;
  GL_STRICT_LIGHTING_HINT_PGI = $1A217;
  GL_STRICT_SCISSOR_HINT_PGI = $1A218;
  GL_FULL_STIPPLE_HINT_PGI = $1A219;
  GL_CLIP_NEAR_HINT_PGI = $1A220;
  GL_CLIP_FAR_HINT_PGI = $1A221;
  GL_WIDE_LINE_HINT_PGI = $1A222;
  GL_BACK_NORMALS_HINT_PGI = $1A223;
  GL_VERTEX_DATA_HINT_PGI = $1A22A;
  GL_VERTEX_CONSISTENT_HINT_PGI = $1A22B;
  GL_MATERIAL_SIDE_HINT_PGI = $1A22C;
  GL_MAX_VERTEX_HINT_PGI = $1A22D;
type
  // OpenGL command variable types
  TglAccum = procedure(op: GLenum; value: GLfloat);stdcall;
  TglAccumxOES = procedure(op: GLenum; value: GLfixed);stdcall;
  TglActiveProgramEXT = procedure(program_: GLuint);stdcall;
  TglActiveShaderProgram = procedure(pipeline: GLuint; program_: GLuint);stdcall;
  TglActiveShaderProgramEXT = procedure(pipeline: GLuint; program_: GLuint);stdcall;
  TglActiveStencilFaceEXT = procedure(face: GLenum);stdcall;
  TglActiveTexture = procedure(texture: GLenum);stdcall;
  TglActiveTextureARB = procedure(texture: GLenum);stdcall;
  TglActiveVaryingNV = procedure(program_: GLuint; name_: PGLchar);stdcall;
  TglAlphaFragmentOp1ATI = procedure(op: GLenum; dst: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint);stdcall;
  TglAlphaFragmentOp2ATI = procedure(op: GLenum; dst: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint; arg2: GLuint; arg2Rep: GLuint; arg2Mod: GLuint);stdcall;
  TglAlphaFragmentOp3ATI = procedure(op: GLenum; dst: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint; arg2: GLuint; arg2Rep: GLuint; arg2Mod: GLuint; arg3: GLuint; arg3Rep: GLuint; arg3Mod: GLuint);stdcall;
  TglAlphaFunc = procedure(func: GLenum; ref: GLfloat);stdcall;
  TglAlphaFuncQCOM = procedure(func: GLenum; ref: GLclampf);stdcall;
  TglAlphaFuncx = procedure(func: GLenum; ref: GLfixed);stdcall;
  TglAlphaFuncxOES = procedure(func: GLenum; ref: GLfixed);stdcall;
  TglAlphaToCoverageDitherControlNV = procedure(mode: GLenum);stdcall;
  TglApplyFramebufferAttachmentCMAAINTEL = procedure;stdcall;
  TglApplyTextureEXT = procedure(mode: GLenum);stdcall;
  TglAcquireKeyedMutexWin32EXT = function(memory: GLuint; key: GLuint64; timeout: GLuint): GLboolean;stdcall;
  TglAreProgramsResidentNV = function(n: GLsizei; programs: PGLuint; residences: PGLboolean): GLboolean;stdcall;
  TglAreTexturesResident = function(n: GLsizei; textures: PGLuint; residences: PGLboolean): GLboolean;stdcall;
  TglAreTexturesResidentEXT = function(n: GLsizei; textures: PGLuint; residences: PGLboolean): GLboolean;stdcall;
  TglArrayElement = procedure(i: GLint);stdcall;
  TglArrayElementEXT = procedure(i: GLint);stdcall;
  TglArrayObjectATI = procedure(array_: GLenum; size: GLint; type_: GLenum; stride: GLsizei; buffer: GLuint; offset: GLuint);stdcall;
  TglAsyncMarkerSGIX = procedure(marker: GLuint);stdcall;
  TglAttachObjectARB = procedure(containerObj: GLhandleARB; obj: GLhandleARB);stdcall;
  TglAttachShader = procedure(program_: GLuint; shader: GLuint);stdcall;
  TglBegin = procedure(mode: GLenum);stdcall;
  TglBeginConditionalRender = procedure(id: GLuint; mode: GLenum);stdcall;
  TglBeginConditionalRenderNV = procedure(id: GLuint; mode: GLenum);stdcall;
  TglBeginConditionalRenderNVX = procedure(id: GLuint);stdcall;
  TglBeginFragmentShaderATI = procedure;stdcall;
  TglBeginOcclusionQueryNV = procedure(id: GLuint);stdcall;
  TglBeginPerfMonitorAMD = procedure(monitor: GLuint);stdcall;
  TglBeginPerfQueryINTEL = procedure(queryHandle: GLuint);stdcall;
  TglBeginQuery = procedure(target: GLenum; id: GLuint);stdcall;
  TglBeginQueryARB = procedure(target: GLenum; id: GLuint);stdcall;
  TglBeginQueryEXT = procedure(target: GLenum; id: GLuint);stdcall;
  TglBeginQueryIndexed = procedure(target: GLenum; index_: GLuint; id: GLuint);stdcall;
  TglBeginTransformFeedback = procedure(primitiveMode: GLenum);stdcall;
  TglBeginTransformFeedbackEXT = procedure(primitiveMode: GLenum);stdcall;
  TglBeginTransformFeedbackNV = procedure(primitiveMode: GLenum);stdcall;
  TglBeginVertexShaderEXT = procedure;stdcall;
  TglBeginVideoCaptureNV = procedure(video_capture_slot: GLuint);stdcall;
  TglBindAttribLocation = procedure(program_: GLuint; index_: GLuint; name_: PGLchar);stdcall;
  TglBindAttribLocationARB = procedure(programObj: GLhandleARB; index_: GLuint; name_: PGLcharARB);stdcall;
  TglBindBuffer = procedure(target: GLenum; buffer: GLuint);stdcall;
  TglBindBufferARB = procedure(target: GLenum; buffer: GLuint);stdcall;
  TglBindBufferBase = procedure(target: GLenum; index_: GLuint; buffer: GLuint);stdcall;
  TglBindBufferBaseEXT = procedure(target: GLenum; index_: GLuint; buffer: GLuint);stdcall;
  TglBindBufferBaseNV = procedure(target: GLenum; index_: GLuint; buffer: GLuint);stdcall;
  TglBindBufferOffsetEXT = procedure(target: GLenum; index_: GLuint; buffer: GLuint; offset: GLintptr);stdcall;
  TglBindBufferOffsetNV = procedure(target: GLenum; index_: GLuint; buffer: GLuint; offset: GLintptr);stdcall;
  TglBindBufferRange = procedure(target: GLenum; index_: GLuint; buffer: GLuint; offset: GLintptr; size: GLsizeiptr);stdcall;
  TglBindBufferRangeEXT = procedure(target: GLenum; index_: GLuint; buffer: GLuint; offset: GLintptr; size: GLsizeiptr);stdcall;
  TglBindBufferRangeNV = procedure(target: GLenum; index_: GLuint; buffer: GLuint; offset: GLintptr; size: GLsizeiptr);stdcall;
  TglBindBuffersBase = procedure(target: GLenum; first: GLuint; count: GLsizei; buffers: PGLuint);stdcall;
  TglBindBuffersRange = procedure(target: GLenum; first: GLuint; count: GLsizei; buffers: PGLuint; offsets: PGLintptr; sizes: PGLsizeiptr);stdcall;
  TglBindFragDataLocation = procedure(program_: GLuint; color: GLuint; name_: PGLchar);stdcall;
  TglBindFragDataLocationEXT = procedure(program_: GLuint; color: GLuint; name_: PGLchar);stdcall;
  TglBindFragDataLocationIndexed = procedure(program_: GLuint; colorNumber: GLuint; index_: GLuint; name_: PGLchar);stdcall;
  TglBindFragDataLocationIndexedEXT = procedure(program_: GLuint; colorNumber: GLuint; index_: GLuint; name_: PGLchar);stdcall;
  TglBindFragmentShaderATI = procedure(id: GLuint);stdcall;
  TglBindFramebuffer = procedure(target: GLenum; framebuffer: GLuint);stdcall;
  TglBindFramebufferEXT = procedure(target: GLenum; framebuffer: GLuint);stdcall;
  TglBindFramebufferOES = procedure(target: GLenum; framebuffer: GLuint);stdcall;
  TglBindImageTexture = procedure(unit_: GLuint; texture: GLuint; level: GLint; layered: GLboolean; layer: GLint; access: GLenum; format: GLenum);stdcall;
  TglBindImageTextureEXT = procedure(index_: GLuint; texture: GLuint; level: GLint; layered: GLboolean; layer: GLint; access: GLenum; format: GLint);stdcall;
  TglBindImageTextures = procedure(first: GLuint; count: GLsizei; textures: PGLuint);stdcall;
  TglBindLightParameterEXT = function(light: GLenum; value: GLenum): GLuint;stdcall;
  TglBindMaterialParameterEXT = function(face: GLenum; value: GLenum): GLuint;stdcall;
  TglBindMultiTextureEXT = procedure(texunit: GLenum; target: GLenum; texture: GLuint);stdcall;
  TglBindParameterEXT = function(value: GLenum): GLuint;stdcall;
  TglBindProgramARB = procedure(target: GLenum; program_: GLuint);stdcall;
  TglBindProgramNV = procedure(target: GLenum; id: GLuint);stdcall;
  TglBindProgramPipeline = procedure(pipeline: GLuint);stdcall;
  TglBindProgramPipelineEXT = procedure(pipeline: GLuint);stdcall;
  TglBindRenderbuffer = procedure(target: GLenum; renderbuffer: GLuint);stdcall;
  TglBindRenderbufferEXT = procedure(target: GLenum; renderbuffer: GLuint);stdcall;
  TglBindRenderbufferOES = procedure(target: GLenum; renderbuffer: GLuint);stdcall;
  TglBindSampler = procedure(unit_: GLuint; sampler: GLuint);stdcall;
  TglBindSamplers = procedure(first: GLuint; count: GLsizei; samplers: PGLuint);stdcall;
  TglBindTexGenParameterEXT = function(unit_: GLenum; coord: GLenum; value: GLenum): GLuint;stdcall;
  TglBindTexture = procedure(target: GLenum; texture: GLuint);stdcall;
  TglBindTextureEXT = procedure(target: GLenum; texture: GLuint);stdcall;
  TglBindTextureUnit = procedure(unit_: GLuint; texture: GLuint);stdcall;
  TglBindTextureUnitParameterEXT = function(unit_: GLenum; value: GLenum): GLuint;stdcall;
  TglBindTextures = procedure(first: GLuint; count: GLsizei; textures: PGLuint);stdcall;
  TglBindTransformFeedback = procedure(target: GLenum; id: GLuint);stdcall;
  TglBindTransformFeedbackNV = procedure(target: GLenum; id: GLuint);stdcall;
  TglBindVertexArray = procedure(array_: GLuint);stdcall;
  TglBindVertexArrayAPPLE = procedure(array_: GLuint);stdcall;
  TglBindVertexArrayOES = procedure(array_: GLuint);stdcall;
  TglBindVertexBuffer = procedure(bindingindex: GLuint; buffer: GLuint; offset: GLintptr; stride: GLsizei);stdcall;
  TglBindVertexBuffers = procedure(first: GLuint; count: GLsizei; buffers: PGLuint; offsets: PGLintptr; strides: PGLsizei);stdcall;
  TglBindVertexShaderEXT = procedure(id: GLuint);stdcall;
  TglBindVideoCaptureStreamBufferNV = procedure(video_capture_slot: GLuint; stream: GLuint; frame_region: GLenum; offset: GLintptrARB);stdcall;
  TglBindVideoCaptureStreamTextureNV = procedure(video_capture_slot: GLuint; stream: GLuint; frame_region: GLenum; target: GLenum; texture: GLuint);stdcall;
  TglBinormal3bEXT = procedure(bx: GLbyte; by: GLbyte; bz: GLbyte);stdcall;
  TglBinormal3bvEXT = procedure(v: PGLbyte);stdcall;
  TglBinormal3dEXT = procedure(bx: GLdouble; by: GLdouble; bz: GLdouble);stdcall;
  TglBinormal3dvEXT = procedure(v: PGLdouble);stdcall;
  TglBinormal3fEXT = procedure(bx: GLfloat; by: GLfloat; bz: GLfloat);stdcall;
  TglBinormal3fvEXT = procedure(v: PGLfloat);stdcall;
  TglBinormal3iEXT = procedure(bx: GLint; by: GLint; bz: GLint);stdcall;
  TglBinormal3ivEXT = procedure(v: PGLint);stdcall;
  TglBinormal3sEXT = procedure(bx: GLshort; by: GLshort; bz: GLshort);stdcall;
  TglBinormal3svEXT = procedure(v: PGLshort);stdcall;
  TglBinormalPointerEXT = procedure(type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglBitmap = procedure(width: GLsizei; height: GLsizei; xorig: GLfloat; yorig: GLfloat; xmove: GLfloat; ymove: GLfloat; bitmap: PGLubyte);stdcall;
  TglBitmapxOES = procedure(width: GLsizei; height: GLsizei; xorig: GLfixed; yorig: GLfixed; xmove: GLfixed; ymove: GLfixed; bitmap: PGLubyte);stdcall;
  TglBlendBarrier = procedure;stdcall;
  TglBlendBarrierKHR = procedure;stdcall;
  TglBlendBarrierNV = procedure;stdcall;
  TglBlendColor = procedure(red: GLfloat; green: GLfloat; blue: GLfloat; alpha: GLfloat);stdcall;
  TglBlendColorEXT = procedure(red: GLfloat; green: GLfloat; blue: GLfloat; alpha: GLfloat);stdcall;
  TglBlendColorxOES = procedure(red: GLfixed; green: GLfixed; blue: GLfixed; alpha: GLfixed);stdcall;
  TglBlendEquation = procedure(mode: GLenum);stdcall;
  TglBlendEquationEXT = procedure(mode: GLenum);stdcall;
  TglBlendEquationIndexedAMD = procedure(buf: GLuint; mode: GLenum);stdcall;
  TglBlendEquationOES = procedure(mode: GLenum);stdcall;
  TglBlendEquationSeparate = procedure(modeRGB: GLenum; modeAlpha: GLenum);stdcall;
  TglBlendEquationSeparateEXT = procedure(modeRGB: GLenum; modeAlpha: GLenum);stdcall;
  TglBlendEquationSeparateIndexedAMD = procedure(buf: GLuint; modeRGB: GLenum; modeAlpha: GLenum);stdcall;
  TglBlendEquationSeparateOES = procedure(modeRGB: GLenum; modeAlpha: GLenum);stdcall;
  TglBlendEquationSeparatei = procedure(buf: GLuint; modeRGB: GLenum; modeAlpha: GLenum);stdcall;
  TglBlendEquationSeparateiARB = procedure(buf: GLuint; modeRGB: GLenum; modeAlpha: GLenum);stdcall;
  TglBlendEquationSeparateiEXT = procedure(buf: GLuint; modeRGB: GLenum; modeAlpha: GLenum);stdcall;
  TglBlendEquationSeparateiOES = procedure(buf: GLuint; modeRGB: GLenum; modeAlpha: GLenum);stdcall;
  TglBlendEquationi = procedure(buf: GLuint; mode: GLenum);stdcall;
  TglBlendEquationiARB = procedure(buf: GLuint; mode: GLenum);stdcall;
  TglBlendEquationiEXT = procedure(buf: GLuint; mode: GLenum);stdcall;
  TglBlendEquationiOES = procedure(buf: GLuint; mode: GLenum);stdcall;
  TglBlendFunc = procedure(sfactor: GLenum; dfactor: GLenum);stdcall;
  TglBlendFuncIndexedAMD = procedure(buf: GLuint; src: GLenum; dst: GLenum);stdcall;
  TglBlendFuncSeparate = procedure(sfactorRGB: GLenum; dfactorRGB: GLenum; sfactorAlpha: GLenum; dfactorAlpha: GLenum);stdcall;
  TglBlendFuncSeparateEXT = procedure(sfactorRGB: GLenum; dfactorRGB: GLenum; sfactorAlpha: GLenum; dfactorAlpha: GLenum);stdcall;
  TglBlendFuncSeparateINGR = procedure(sfactorRGB: GLenum; dfactorRGB: GLenum; sfactorAlpha: GLenum; dfactorAlpha: GLenum);stdcall;
  TglBlendFuncSeparateIndexedAMD = procedure(buf: GLuint; srcRGB: GLenum; dstRGB: GLenum; srcAlpha: GLenum; dstAlpha: GLenum);stdcall;
  TglBlendFuncSeparateOES = procedure(srcRGB: GLenum; dstRGB: GLenum; srcAlpha: GLenum; dstAlpha: GLenum);stdcall;
  TglBlendFuncSeparatei = procedure(buf: GLuint; srcRGB: GLenum; dstRGB: GLenum; srcAlpha: GLenum; dstAlpha: GLenum);stdcall;
  TglBlendFuncSeparateiARB = procedure(buf: GLuint; srcRGB: GLenum; dstRGB: GLenum; srcAlpha: GLenum; dstAlpha: GLenum);stdcall;
  TglBlendFuncSeparateiEXT = procedure(buf: GLuint; srcRGB: GLenum; dstRGB: GLenum; srcAlpha: GLenum; dstAlpha: GLenum);stdcall;
  TglBlendFuncSeparateiOES = procedure(buf: GLuint; srcRGB: GLenum; dstRGB: GLenum; srcAlpha: GLenum; dstAlpha: GLenum);stdcall;
  TglBlendFunci = procedure(buf: GLuint; src: GLenum; dst: GLenum);stdcall;
  TglBlendFunciARB = procedure(buf: GLuint; src: GLenum; dst: GLenum);stdcall;
  TglBlendFunciEXT = procedure(buf: GLuint; src: GLenum; dst: GLenum);stdcall;
  TglBlendFunciOES = procedure(buf: GLuint; src: GLenum; dst: GLenum);stdcall;
  TglBlendParameteriNV = procedure(pname: GLenum; value: GLint);stdcall;
  TglBlitFramebuffer = procedure(srcX0: GLint; srcY0: GLint; srcX1: GLint; srcY1: GLint; dstX0: GLint; dstY0: GLint; dstX1: GLint; dstY1: GLint; mask: GLbitfield; filter: GLenum);stdcall;
  TglBlitFramebufferANGLE = procedure(srcX0: GLint; srcY0: GLint; srcX1: GLint; srcY1: GLint; dstX0: GLint; dstY0: GLint; dstX1: GLint; dstY1: GLint; mask: GLbitfield; filter: GLenum);stdcall;
  TglBlitFramebufferEXT = procedure(srcX0: GLint; srcY0: GLint; srcX1: GLint; srcY1: GLint; dstX0: GLint; dstY0: GLint; dstX1: GLint; dstY1: GLint; mask: GLbitfield; filter: GLenum);stdcall;
  TglBlitFramebufferNV = procedure(srcX0: GLint; srcY0: GLint; srcX1: GLint; srcY1: GLint; dstX0: GLint; dstY0: GLint; dstX1: GLint; dstY1: GLint; mask: GLbitfield; filter: GLenum);stdcall;
  TglBlitNamedFramebuffer = procedure(readFramebuffer: GLuint; drawFramebuffer: GLuint; srcX0: GLint; srcY0: GLint; srcX1: GLint; srcY1: GLint; dstX0: GLint; dstY0: GLint; dstX1: GLint; dstY1: GLint; mask: GLbitfield; filter: GLenum);stdcall;
  TglBufferAddressRangeNV = procedure(pname: GLenum; index_: GLuint; address: GLuint64EXT; length: GLsizeiptr);stdcall;
  TglBufferData = procedure(target: GLenum; size: GLsizeiptr; data: Pvoid; usage: GLenum);stdcall;
  TglBufferDataARB = procedure(target: GLenum; size: GLsizeiptrARB; data: Pvoid; usage: GLenum);stdcall;
  TglBufferPageCommitmentARB = procedure(target: GLenum; offset: GLintptr; size: GLsizeiptr; commit: GLboolean);stdcall;
  TglBufferParameteriAPPLE = procedure(target: GLenum; pname: GLenum; param: GLint);stdcall;
  TglBufferStorage = procedure(target: GLenum; size: GLsizeiptr; data: Pvoid; flags: GLbitfield);stdcall;
  TglBufferStorageEXT = procedure(target: GLenum; size: GLsizeiptr; data: Pvoid; flags: GLbitfield);stdcall;
  TglBufferStorageExternalEXT = procedure(target: GLenum; offset: GLintptr; size: GLsizeiptr; clientBuffer: GLeglClientBufferEXT; flags: GLbitfield);stdcall;
  TglBufferStorageMemEXT = procedure(target: GLenum; size: GLsizeiptr; memory: GLuint; offset: GLuint64);stdcall;
  TglBufferSubData = procedure(target: GLenum; offset: GLintptr; size: GLsizeiptr; data: Pvoid);stdcall;
  TglBufferSubDataARB = procedure(target: GLenum; offset: GLintptrARB; size: GLsizeiptrARB; data: Pvoid);stdcall;
  TglCallCommandListNV = procedure(list: GLuint);stdcall;
  TglCallList = procedure(list: GLuint);stdcall;
  TglCallLists = procedure(n: GLsizei; type_: GLenum; lists: Pvoid);stdcall;
  TglCheckFramebufferStatus = function(target: GLenum): GLenum;stdcall;
  TglCheckFramebufferStatusEXT = function(target: GLenum): GLenum;stdcall;
  TglCheckFramebufferStatusOES = function(target: GLenum): GLenum;stdcall;
  TglCheckNamedFramebufferStatus = function(framebuffer: GLuint; target: GLenum): GLenum;stdcall;
  TglCheckNamedFramebufferStatusEXT = function(framebuffer: GLuint; target: GLenum): GLenum;stdcall;
  TglClampColor = procedure(target: GLenum; clamp: GLenum);stdcall;
  TglClampColorARB = procedure(target: GLenum; clamp: GLenum);stdcall;
  TglClear = procedure(mask: GLbitfield);stdcall;
  TglClearAccum = procedure(red: GLfloat; green: GLfloat; blue: GLfloat; alpha: GLfloat);stdcall;
  TglClearAccumxOES = procedure(red: GLfixed; green: GLfixed; blue: GLfixed; alpha: GLfixed);stdcall;
  TglClearBufferData = procedure(target: GLenum; internalformat: GLenum; format: GLenum; type_: GLenum; data: Pvoid);stdcall;
  TglClearBufferSubData = procedure(target: GLenum; internalformat: GLenum; offset: GLintptr; size: GLsizeiptr; format: GLenum; type_: GLenum; data: Pvoid);stdcall;
  TglClearBufferfi = procedure(buffer: GLenum; drawbuffer: GLint; depth: GLfloat; stencil: GLint);stdcall;
  TglClearBufferfv = procedure(buffer: GLenum; drawbuffer: GLint; value: PGLfloat);stdcall;
  TglClearBufferiv = procedure(buffer: GLenum; drawbuffer: GLint; value: PGLint);stdcall;
  TglClearBufferuiv = procedure(buffer: GLenum; drawbuffer: GLint; value: PGLuint);stdcall;
  TglClearColor = procedure(red: GLfloat; green: GLfloat; blue: GLfloat; alpha: GLfloat);stdcall;
  TglClearColorIiEXT = procedure(red: GLint; green: GLint; blue: GLint; alpha: GLint);stdcall;
  TglClearColorIuiEXT = procedure(red: GLuint; green: GLuint; blue: GLuint; alpha: GLuint);stdcall;
  TglClearColorx = procedure(red: GLfixed; green: GLfixed; blue: GLfixed; alpha: GLfixed);stdcall;
  TglClearColorxOES = procedure(red: GLfixed; green: GLfixed; blue: GLfixed; alpha: GLfixed);stdcall;
  TglClearDepth = procedure(depth: GLdouble);stdcall;
  TglClearDepthdNV = procedure(depth: GLdouble);stdcall;
  TglClearDepthf = procedure(d: GLfloat);stdcall;
  TglClearDepthfOES = procedure(depth: GLclampf);stdcall;
  TglClearDepthx = procedure(depth: GLfixed);stdcall;
  TglClearDepthxOES = procedure(depth: GLfixed);stdcall;
  TglClearIndex = procedure(c: GLfloat);stdcall;
  TglClearNamedBufferData = procedure(buffer: GLuint; internalformat: GLenum; format: GLenum; type_: GLenum; data: Pvoid);stdcall;
  TglClearNamedBufferDataEXT = procedure(buffer: GLuint; internalformat: GLenum; format: GLenum; type_: GLenum; data: Pvoid);stdcall;
  TglClearNamedBufferSubData = procedure(buffer: GLuint; internalformat: GLenum; offset: GLintptr; size: GLsizeiptr; format: GLenum; type_: GLenum; data: Pvoid);stdcall;
  TglClearNamedBufferSubDataEXT = procedure(buffer: GLuint; internalformat: GLenum; offset: GLsizeiptr; size: GLsizeiptr; format: GLenum; type_: GLenum; data: Pvoid);stdcall;
  TglClearNamedFramebufferfi = procedure(framebuffer: GLuint; buffer: GLenum; drawbuffer: GLint; depth: GLfloat; stencil: GLint);stdcall;
  TglClearNamedFramebufferfv = procedure(framebuffer: GLuint; buffer: GLenum; drawbuffer: GLint; value: PGLfloat);stdcall;
  TglClearNamedFramebufferiv = procedure(framebuffer: GLuint; buffer: GLenum; drawbuffer: GLint; value: PGLint);stdcall;
  TglClearNamedFramebufferuiv = procedure(framebuffer: GLuint; buffer: GLenum; drawbuffer: GLint; value: PGLuint);stdcall;
  TglClearPixelLocalStorageuiEXT = procedure(offset: GLsizei; n: GLsizei; values: PGLuint);stdcall;
  TglClearStencil = procedure(s: GLint);stdcall;
  TglClearTexImage = procedure(texture: GLuint; level: GLint; format: GLenum; type_: GLenum; data: Pvoid);stdcall;
  TglClearTexImageEXT = procedure(texture: GLuint; level: GLint; format: GLenum; type_: GLenum; data: Pvoid);stdcall;
  TglClearTexSubImage = procedure(texture: GLuint; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; type_: GLenum; data: Pvoid);stdcall;
  TglClearTexSubImageEXT = procedure(texture: GLuint; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; type_: GLenum; data: Pvoid);stdcall;
  TglClientActiveTexture = procedure(texture: GLenum);stdcall;
  TglClientActiveTextureARB = procedure(texture: GLenum);stdcall;
  TglClientActiveVertexStreamATI = procedure(stream: GLenum);stdcall;
  TglClientAttribDefaultEXT = procedure(mask: GLbitfield);stdcall;
  TglClientWaitSync = function(sync: GLsync; flags: GLbitfield; timeout: GLuint64): GLenum;stdcall;
  TglClientWaitSyncAPPLE = function(sync: GLsync; flags: GLbitfield; timeout: GLuint64): GLenum;stdcall;
  TglClipControl = procedure(origin: GLenum; depth: GLenum);stdcall;
  TglClipPlane = procedure(plane: GLenum; equation: PGLdouble);stdcall;
  TglClipPlanef = procedure(p: GLenum; eqn: PGLfloat);stdcall;
  TglClipPlanefIMG = procedure(p: GLenum; eqn: PGLfloat);stdcall;
  TglClipPlanefOES = procedure(plane: GLenum; equation: PGLfloat);stdcall;
  TglClipPlanex = procedure(plane: GLenum; equation: PGLfixed);stdcall;
  TglClipPlanexIMG = procedure(p: GLenum; eqn: PGLfixed);stdcall;
  TglClipPlanexOES = procedure(plane: GLenum; equation: PGLfixed);stdcall;
  TglColor3b = procedure(red: GLbyte; green: GLbyte; blue: GLbyte);stdcall;
  TglColor3bv = procedure(v: PGLbyte);stdcall;
  TglColor3d = procedure(red: GLdouble; green: GLdouble; blue: GLdouble);stdcall;
  TglColor3dv = procedure(v: PGLdouble);stdcall;
  TglColor3f = procedure(red: GLfloat; green: GLfloat; blue: GLfloat);stdcall;
  TglColor3fVertex3fSUN = procedure(r: GLfloat; g: GLfloat; b: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglColor3fVertex3fvSUN = procedure(c: PGLfloat; v: PGLfloat);stdcall;
  TglColor3fv = procedure(v: PGLfloat);stdcall;
  TglColor3hNV = procedure(red: GLhalfNV; green: GLhalfNV; blue: GLhalfNV);stdcall;
  TglColor3hvNV = procedure(v: PGLhalfNV);stdcall;
  TglColor3i = procedure(red: GLint; green: GLint; blue: GLint);stdcall;
  TglColor3iv = procedure(v: PGLint);stdcall;
  TglColor3s = procedure(red: GLshort; green: GLshort; blue: GLshort);stdcall;
  TglColor3sv = procedure(v: PGLshort);stdcall;
  TglColor3ub = procedure(red: GLubyte; green: GLubyte; blue: GLubyte);stdcall;
  TglColor3ubv = procedure(v: PGLubyte);stdcall;
  TglColor3ui = procedure(red: GLuint; green: GLuint; blue: GLuint);stdcall;
  TglColor3uiv = procedure(v: PGLuint);stdcall;
  TglColor3us = procedure(red: GLushort; green: GLushort; blue: GLushort);stdcall;
  TglColor3usv = procedure(v: PGLushort);stdcall;
  TglColor3xOES = procedure(red: GLfixed; green: GLfixed; blue: GLfixed);stdcall;
  TglColor3xvOES = procedure(components: PGLfixed);stdcall;
  TglColor4b = procedure(red: GLbyte; green: GLbyte; blue: GLbyte; alpha: GLbyte);stdcall;
  TglColor4bv = procedure(v: PGLbyte);stdcall;
  TglColor4d = procedure(red: GLdouble; green: GLdouble; blue: GLdouble; alpha: GLdouble);stdcall;
  TglColor4dv = procedure(v: PGLdouble);stdcall;
  TglColor4f = procedure(red: GLfloat; green: GLfloat; blue: GLfloat; alpha: GLfloat);stdcall;
  TglColor4fNormal3fVertex3fSUN = procedure(r: GLfloat; g: GLfloat; b: GLfloat; a: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglColor4fNormal3fVertex3fvSUN = procedure(c: PGLfloat; n: PGLfloat; v: PGLfloat);stdcall;
  TglColor4fv = procedure(v: PGLfloat);stdcall;
  TglColor4hNV = procedure(red: GLhalfNV; green: GLhalfNV; blue: GLhalfNV; alpha: GLhalfNV);stdcall;
  TglColor4hvNV = procedure(v: PGLhalfNV);stdcall;
  TglColor4i = procedure(red: GLint; green: GLint; blue: GLint; alpha: GLint);stdcall;
  TglColor4iv = procedure(v: PGLint);stdcall;
  TglColor4s = procedure(red: GLshort; green: GLshort; blue: GLshort; alpha: GLshort);stdcall;
  TglColor4sv = procedure(v: PGLshort);stdcall;
  TglColor4ub = procedure(red: GLubyte; green: GLubyte; blue: GLubyte; alpha: GLubyte);stdcall;
  TglColor4ubVertex2fSUN = procedure(r: GLubyte; g: GLubyte; b: GLubyte; a: GLubyte; x: GLfloat; y: GLfloat);stdcall;
  TglColor4ubVertex2fvSUN = procedure(c: PGLubyte; v: PGLfloat);stdcall;
  TglColor4ubVertex3fSUN = procedure(r: GLubyte; g: GLubyte; b: GLubyte; a: GLubyte; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglColor4ubVertex3fvSUN = procedure(c: PGLubyte; v: PGLfloat);stdcall;
  TglColor4ubv = procedure(v: PGLubyte);stdcall;
  TglColor4ui = procedure(red: GLuint; green: GLuint; blue: GLuint; alpha: GLuint);stdcall;
  TglColor4uiv = procedure(v: PGLuint);stdcall;
  TglColor4us = procedure(red: GLushort; green: GLushort; blue: GLushort; alpha: GLushort);stdcall;
  TglColor4usv = procedure(v: PGLushort);stdcall;
  TglColor4x = procedure(red: GLfixed; green: GLfixed; blue: GLfixed; alpha: GLfixed);stdcall;
  TglColor4xOES = procedure(red: GLfixed; green: GLfixed; blue: GLfixed; alpha: GLfixed);stdcall;
  TglColor4xvOES = procedure(components: PGLfixed);stdcall;
  TglColorFormatNV = procedure(size: GLint; type_: GLenum; stride: GLsizei);stdcall;
  TglColorFragmentOp1ATI = procedure(op: GLenum; dst: GLuint; dstMask: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint);stdcall;
  TglColorFragmentOp2ATI = procedure(op: GLenum; dst: GLuint; dstMask: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint; arg2: GLuint; arg2Rep: GLuint; arg2Mod: GLuint);stdcall;
  TglColorFragmentOp3ATI = procedure(op: GLenum; dst: GLuint; dstMask: GLuint; dstMod: GLuint; arg1: GLuint; arg1Rep: GLuint; arg1Mod: GLuint; arg2: GLuint; arg2Rep: GLuint; arg2Mod: GLuint; arg3: GLuint; arg3Rep: GLuint; arg3Mod: GLuint);stdcall;
  TglColorMask = procedure(red: GLboolean; green: GLboolean; blue: GLboolean; alpha: GLboolean);stdcall;
  TglColorMaskIndexedEXT = procedure(index_: GLuint; r: GLboolean; g: GLboolean; b: GLboolean; a: GLboolean);stdcall;
  TglColorMaski = procedure(index_: GLuint; r: GLboolean; g: GLboolean; b: GLboolean; a: GLboolean);stdcall;
  TglColorMaskiEXT = procedure(index_: GLuint; r: GLboolean; g: GLboolean; b: GLboolean; a: GLboolean);stdcall;
  TglColorMaskiOES = procedure(index_: GLuint; r: GLboolean; g: GLboolean; b: GLboolean; a: GLboolean);stdcall;
  TglColorMaterial = procedure(face: GLenum; mode: GLenum);stdcall;
  TglColorP3ui = procedure(type_: GLenum; color: GLuint);stdcall;
  TglColorP3uiv = procedure(type_: GLenum; color: PGLuint);stdcall;
  TglColorP4ui = procedure(type_: GLenum; color: GLuint);stdcall;
  TglColorP4uiv = procedure(type_: GLenum; color: PGLuint);stdcall;
  TglColorPointer = procedure(size: GLint; type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglColorPointerEXT = procedure(size: GLint; type_: GLenum; stride: GLsizei; count: GLsizei; pointer: Pvoid);stdcall;
  TglColorPointerListIBM = procedure(size: GLint; type_: GLenum; stride: GLint; pointer: PPvoid; ptrstride: GLint);stdcall;
  TglColorPointervINTEL = procedure(size: GLint; type_: GLenum; pointer: PPvoid);stdcall;
  TglColorSubTable = procedure(target: GLenum; start: GLsizei; count: GLsizei; format: GLenum; type_: GLenum; data: Pvoid);stdcall;
  TglColorSubTableEXT = procedure(target: GLenum; start: GLsizei; count: GLsizei; format: GLenum; type_: GLenum; data: Pvoid);stdcall;
  TglColorTable = procedure(target: GLenum; internalformat: GLenum; width: GLsizei; format: GLenum; type_: GLenum; table: Pvoid);stdcall;
  TglColorTableEXT = procedure(target: GLenum; internalFormat: GLenum; width: GLsizei; format: GLenum; type_: GLenum; table: Pvoid);stdcall;
  TglColorTableParameterfv = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglColorTableParameterfvSGI = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglColorTableParameteriv = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglColorTableParameterivSGI = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglColorTableSGI = procedure(target: GLenum; internalformat: GLenum; width: GLsizei; format: GLenum; type_: GLenum; table: Pvoid);stdcall;
  TglCombinerInputNV = procedure(stage: GLenum; portion: GLenum; variable: GLenum; input: GLenum; mapping: GLenum; componentUsage: GLenum);stdcall;
  TglCombinerOutputNV = procedure(stage: GLenum; portion: GLenum; abOutput: GLenum; cdOutput: GLenum; sumOutput: GLenum; scale: GLenum; bias: GLenum; abDotProduct: GLboolean; cdDotProduct: GLboolean; muxSum: GLboolean);stdcall;
  TglCombinerParameterfNV = procedure(pname: GLenum; param: GLfloat);stdcall;
  TglCombinerParameterfvNV = procedure(pname: GLenum; params: PGLfloat);stdcall;
  TglCombinerParameteriNV = procedure(pname: GLenum; param: GLint);stdcall;
  TglCombinerParameterivNV = procedure(pname: GLenum; params: PGLint);stdcall;
  TglCombinerStageParameterfvNV = procedure(stage: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglCommandListSegmentsNV = procedure(list: GLuint; segments: GLuint);stdcall;
  TglCompileCommandListNV = procedure(list: GLuint);stdcall;
  TglCompileShader = procedure(shader: GLuint);stdcall;
  TglCompileShaderARB = procedure(shaderObj: GLhandleARB);stdcall;
  TglCompileShaderIncludeARB = procedure(shader: GLuint; count: GLsizei; path: PPGLchar; length: PGLint);stdcall;
  TglCompressedMultiTexImage1DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; border: GLint; imageSize: GLsizei; bits: Pvoid);stdcall;
  TglCompressedMultiTexImage2DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; border: GLint; imageSize: GLsizei; bits: Pvoid);stdcall;
  TglCompressedMultiTexImage3DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; imageSize: GLsizei; bits: Pvoid);stdcall;
  TglCompressedMultiTexSubImage1DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; xoffset: GLint; width: GLsizei; format: GLenum; imageSize: GLsizei; bits: Pvoid);stdcall;
  TglCompressedMultiTexSubImage2DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; width: GLsizei; height: GLsizei; format: GLenum; imageSize: GLsizei; bits: Pvoid);stdcall;
  TglCompressedMultiTexSubImage3DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; imageSize: GLsizei; bits: Pvoid);stdcall;
  TglCompressedTexImage1D = procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; border: GLint; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTexImage1DARB = procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; border: GLint; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTexImage2D = procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; border: GLint; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTexImage2DARB = procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; border: GLint; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTexImage3D = procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTexImage3DARB = procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTexImage3DOES = procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTexSubImage1D = procedure(target: GLenum; level: GLint; xoffset: GLint; width: GLsizei; format: GLenum; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTexSubImage1DARB = procedure(target: GLenum; level: GLint; xoffset: GLint; width: GLsizei; format: GLenum; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTexSubImage2D = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; width: GLsizei; height: GLsizei; format: GLenum; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTexSubImage2DARB = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; width: GLsizei; height: GLsizei; format: GLenum; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTexSubImage3D = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTexSubImage3DARB = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTexSubImage3DOES = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTextureImage1DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; border: GLint; imageSize: GLsizei; bits: Pvoid);stdcall;
  TglCompressedTextureImage2DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; border: GLint; imageSize: GLsizei; bits: Pvoid);stdcall;
  TglCompressedTextureImage3DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; imageSize: GLsizei; bits: Pvoid);stdcall;
  TglCompressedTextureSubImage1D = procedure(texture: GLuint; level: GLint; xoffset: GLint; width: GLsizei; format: GLenum; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTextureSubImage1DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; xoffset: GLint; width: GLsizei; format: GLenum; imageSize: GLsizei; bits: Pvoid);stdcall;
  TglCompressedTextureSubImage2D = procedure(texture: GLuint; level: GLint; xoffset: GLint; yoffset: GLint; width: GLsizei; height: GLsizei; format: GLenum; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTextureSubImage2DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; width: GLsizei; height: GLsizei; format: GLenum; imageSize: GLsizei; bits: Pvoid);stdcall;
  TglCompressedTextureSubImage3D = procedure(texture: GLuint; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; imageSize: GLsizei; data: Pvoid);stdcall;
  TglCompressedTextureSubImage3DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; imageSize: GLsizei;
    bits: Pvoid);stdcall;
  TglConservativeRasterParameterfNV = procedure(pname: GLenum; value: GLfloat);stdcall;
  TglConservativeRasterParameteriNV = procedure(pname: GLenum; param: GLint);stdcall;
  TglConvolutionFilter1D = procedure(target: GLenum; internalformat: GLenum; width: GLsizei; format: GLenum; type_: GLenum; image: Pvoid);stdcall;
  TglConvolutionFilter1DEXT = procedure(target: GLenum; internalformat: GLenum; width: GLsizei; format: GLenum; type_: GLenum; image: Pvoid);stdcall;
  TglConvolutionFilter2D = procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei; format: GLenum; type_: GLenum; image: Pvoid);stdcall;
  TglConvolutionFilter2DEXT = procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei; format: GLenum; type_: GLenum; image: Pvoid);stdcall;
  TglConvolutionParameterf = procedure(target: GLenum; pname: GLenum; params: GLfloat);stdcall;
  TglConvolutionParameterfEXT = procedure(target: GLenum; pname: GLenum; params: GLfloat);stdcall;
  TglConvolutionParameterfv = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglConvolutionParameterfvEXT = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglConvolutionParameteri = procedure(target: GLenum; pname: GLenum; params: GLint);stdcall;
  TglConvolutionParameteriEXT = procedure(target: GLenum; pname: GLenum; params: GLint);stdcall;
  TglConvolutionParameteriv = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglConvolutionParameterivEXT = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglConvolutionParameterxOES = procedure(target: GLenum; pname: GLenum; param: GLfixed);stdcall;
  TglConvolutionParameterxvOES = procedure(target: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglCopyBufferSubData = procedure(readTarget: GLenum; writeTarget: GLenum; readOffset: GLintptr; writeOffset: GLintptr; size: GLsizeiptr);stdcall;
  TglCopyBufferSubDataNV = procedure(readTarget: GLenum; writeTarget: GLenum; readOffset: GLintptr; writeOffset: GLintptr; size: GLsizeiptr);stdcall;
  TglCopyColorSubTable = procedure(target: GLenum; start: GLsizei; x: GLint; y: GLint; width: GLsizei);stdcall;
  TglCopyColorSubTableEXT = procedure(target: GLenum; start: GLsizei; x: GLint; y: GLint; width: GLsizei);stdcall;
  TglCopyColorTable = procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei);stdcall;
  TglCopyColorTableSGI = procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei);stdcall;
  TglCopyConvolutionFilter1D = procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei);stdcall;
  TglCopyConvolutionFilter1DEXT = procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei);stdcall;
  TglCopyConvolutionFilter2D = procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglCopyConvolutionFilter2DEXT = procedure(target: GLenum; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglCopyImageSubData = procedure(srcName: GLuint; srcTarget: GLenum; srcLevel: GLint; srcX: GLint; srcY: GLint; srcZ: GLint; dstName: GLuint; dstTarget: GLenum; dstLevel: GLint; dstX: GLint; dstY: GLint; dstZ: GLint; srcWidth: GLsizei; srcHeight: GLsizei; srcDepth: GLsizei);stdcall;
  TglCopyImageSubDataEXT = procedure(srcName: GLuint; srcTarget: GLenum; srcLevel: GLint; srcX: GLint; srcY: GLint; srcZ: GLint; dstName: GLuint; dstTarget: GLenum; dstLevel: GLint; dstX: GLint; dstY: GLint; dstZ: GLint; srcWidth: GLsizei; srcHeight: GLsizei; srcDepth: GLsizei);stdcall;
  TglCopyImageSubDataNV = procedure(srcName: GLuint; srcTarget: GLenum; srcLevel: GLint; srcX: GLint; srcY: GLint; srcZ: GLint; dstName: GLuint; dstTarget: GLenum; dstLevel: GLint; dstX: GLint; dstY: GLint; dstZ: GLint; width: GLsizei; height: GLsizei; depth: GLsizei);stdcall;
  TglCopyImageSubDataOES = procedure(srcName: GLuint; srcTarget: GLenum; srcLevel: GLint; srcX: GLint; srcY: GLint; srcZ: GLint; dstName: GLuint; dstTarget: GLenum; dstLevel: GLint; dstX: GLint; dstY: GLint; dstZ: GLint; srcWidth: GLsizei; srcHeight: GLsizei; srcDepth: GLsizei);stdcall;
  TglCopyMultiTexImage1DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei; border: GLint);stdcall;
  TglCopyMultiTexImage2DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei; height: GLsizei; border: GLint);stdcall;
  TglCopyMultiTexSubImage1DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; xoffset: GLint; x: GLint; y: GLint; width: GLsizei);stdcall;
  TglCopyMultiTexSubImage2DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglCopyMultiTexSubImage3DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglCopyNamedBufferSubData = procedure(readBuffer: GLuint; writeBuffer: GLuint; readOffset: GLintptr; writeOffset: GLintptr; size: GLsizeiptr);stdcall;
  TglCopyPathNV = procedure(resultPath: GLuint; srcPath: GLuint);stdcall;
  TglCopyPixels = procedure(x: GLint; y: GLint; width: GLsizei; height: GLsizei; type_: GLenum);stdcall;
  TglCopyTexImage1D = procedure(target: GLenum; level: GLint; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei; border: GLint);stdcall;
  TglCopyTexImage1DEXT = procedure(target: GLenum; level: GLint; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei; border: GLint);stdcall;
  TglCopyTexImage2D = procedure(target: GLenum; level: GLint; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei; height: GLsizei; border: GLint);stdcall;
  TglCopyTexImage2DEXT = procedure(target: GLenum; level: GLint; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei; height: GLsizei; border: GLint);stdcall;
  TglCopyTexSubImage1D = procedure(target: GLenum; level: GLint; xoffset: GLint; x: GLint; y: GLint; width: GLsizei);stdcall;
  TglCopyTexSubImage1DEXT = procedure(target: GLenum; level: GLint; xoffset: GLint; x: GLint; y: GLint; width: GLsizei);stdcall;
  TglCopyTexSubImage2D = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglCopyTexSubImage2DEXT = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglCopyTexSubImage3D = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglCopyTexSubImage3DEXT = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglCopyTexSubImage3DOES = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglCopyTextureImage1DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei; border: GLint);stdcall;
  TglCopyTextureImage2DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; internalformat: GLenum; x: GLint; y: GLint; width: GLsizei; height: GLsizei; border: GLint);stdcall;
  TglCopyTextureLevelsAPPLE = procedure(destinationTexture: GLuint; sourceTexture: GLuint; sourceBaseLevel: GLint; sourceLevelCount: GLsizei);stdcall;
  TglCopyTextureSubImage1D = procedure(texture: GLuint; level: GLint; xoffset: GLint; x: GLint; y: GLint; width: GLsizei);stdcall;
  TglCopyTextureSubImage1DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; xoffset: GLint; x: GLint; y: GLint; width: GLsizei);stdcall;
  TglCopyTextureSubImage2D = procedure(texture: GLuint; level: GLint; xoffset: GLint; yoffset: GLint; x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglCopyTextureSubImage2DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglCopyTextureSubImage3D = procedure(texture: GLuint; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglCopyTextureSubImage3DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglCoverFillPathInstancedNV = procedure(numPaths: GLsizei; pathNameType: GLenum; paths: Pvoid; pathBase: GLuint; coverMode: GLenum; transformType: GLenum; transformValues: PGLfloat);stdcall;
  TglCoverFillPathNV = procedure(path: GLuint; coverMode: GLenum);stdcall;
  TglCoverStrokePathInstancedNV = procedure(numPaths: GLsizei; pathNameType: GLenum; paths: Pvoid; pathBase: GLuint; coverMode: GLenum; transformType: GLenum; transformValues: PGLfloat);stdcall;
  TglCoverStrokePathNV = procedure(path: GLuint; coverMode: GLenum);stdcall;
  TglCoverageMaskNV = procedure(mask: GLboolean);stdcall;
  TglCoverageModulationNV = procedure(components: GLenum);stdcall;
  TglCoverageModulationTableNV = procedure(n: GLsizei; v: PGLfloat);stdcall;
  TglCoverageOperationNV = procedure(operation: GLenum);stdcall;
  TglCreateBuffers = procedure(n: GLsizei; buffers: PGLuint);stdcall;
  TglCreateCommandListsNV = procedure(n: GLsizei; lists: PGLuint);stdcall;
  TglCreateFramebuffers = procedure(n: GLsizei; framebuffers: PGLuint);stdcall;
  TglCreateMemoryObjectsEXT = procedure(n: GLsizei; memoryObjects: PGLuint);stdcall;
  TglCreatePerfQueryINTEL = procedure(queryId: GLuint; queryHandle: PGLuint);stdcall;
  TglCreateProgram = function: GLuint;stdcall;
  TglCreateProgramObjectARB = function: GLhandleARB;stdcall;
  TglCreateProgramPipelines = procedure(n: GLsizei; pipelines: PGLuint);stdcall;
  TglCreateQueries = procedure(target: GLenum; n: GLsizei; ids: PGLuint);stdcall;
  TglCreateRenderbuffers = procedure(n: GLsizei; renderbuffers: PGLuint);stdcall;
  TglCreateSamplers = procedure(n: GLsizei; samplers: PGLuint);stdcall;
  TglCreateShader = function(type_: GLenum): GLuint;stdcall;
  TglCreateShaderObjectARB = function(shaderType: GLenum): GLhandleARB;stdcall;
  TglCreateShaderProgramEXT = function(type_: GLenum; string_: PGLchar): GLuint;stdcall;
  TglCreateShaderProgramv = function(type_: GLenum; count: GLsizei; strings: PPGLchar): GLuint;stdcall;
  TglCreateShaderProgramvEXT = function(type_: GLenum; count: GLsizei; strings: PPGLchar): GLuint;stdcall;
  TglCreateStatesNV = procedure(n: GLsizei; states: PGLuint);stdcall;
  TglCreateSyncFromCLeventARB = function(context: Pstruct_cl_context; event: Pstruct_cl_event; flags: GLbitfield): GLsync;stdcall;
  TglCreateTextures = procedure(target: GLenum; n: GLsizei; textures: PGLuint);stdcall;
  TglCreateTransformFeedbacks = procedure(n: GLsizei; ids: PGLuint);stdcall;
  TglCreateVertexArrays = procedure(n: GLsizei; arrays: PGLuint);stdcall;
  TglCullFace = procedure(mode: GLenum);stdcall;
  TglCullParameterdvEXT = procedure(pname: GLenum; params: PGLdouble);stdcall;
  TglCullParameterfvEXT = procedure(pname: GLenum; params: PGLfloat);stdcall;
  TglCurrentPaletteMatrixARB = procedure(index_: GLint);stdcall;
  TglCurrentPaletteMatrixOES = procedure(matrixpaletteindex: GLuint);stdcall;
  TglDebugMessageCallback = procedure(callback: GLDEBUGPROC; userParam: Pvoid);stdcall;
  TglDebugMessageCallbackAMD = procedure(callback: GLDEBUGPROCAMD; userParam: Pvoid);stdcall;
  TglDebugMessageCallbackARB = procedure(callback: GLDEBUGPROCARB; userParam: Pvoid);stdcall;
  TglDebugMessageCallbackKHR = procedure(callback: GLDEBUGPROCKHR; userParam: Pvoid);stdcall;
  TglDebugMessageControl = procedure(source: GLenum; type_: GLenum; severity: GLenum; count: GLsizei; ids: PGLuint; enabled: GLboolean);stdcall;
  TglDebugMessageControlARB = procedure(source: GLenum; type_: GLenum; severity: GLenum; count: GLsizei; ids: PGLuint; enabled: GLboolean);stdcall;
  TglDebugMessageControlKHR = procedure(source: GLenum; type_: GLenum; severity: GLenum; count: GLsizei; ids: PGLuint; enabled: GLboolean);stdcall;
  TglDebugMessageEnableAMD = procedure(category: GLenum; severity: GLenum; count: GLsizei; ids: PGLuint; enabled: GLboolean);stdcall;
  TglDebugMessageInsert = procedure(source: GLenum; type_: GLenum; id: GLuint; severity: GLenum; length: GLsizei; buf: PGLchar);stdcall;
  TglDebugMessageInsertAMD = procedure(category: GLenum; severity: GLenum; id: GLuint; length: GLsizei; buf: PGLchar);stdcall;
  TglDebugMessageInsertARB = procedure(source: GLenum; type_: GLenum; id: GLuint; severity: GLenum; length: GLsizei; buf: PGLchar);stdcall;
  TglDebugMessageInsertKHR = procedure(source: GLenum; type_: GLenum; id: GLuint; severity: GLenum; length: GLsizei; buf: PGLchar);stdcall;
  TglDeformSGIX = procedure(mask: GLbitfield);stdcall;
  TglDeformationMap3dSGIX = procedure(target: GLenum; u1: GLdouble; u2: GLdouble; ustride: GLint; uorder: GLint; v1: GLdouble; v2: GLdouble; vstride: GLint; vorder: GLint; w1: GLdouble; w2: GLdouble; wstride: GLint; worder: GLint; points: PGLdouble);stdcall;
  TglDeformationMap3fSGIX = procedure(target: GLenum; u1: GLfloat; u2: GLfloat; ustride: GLint; uorder: GLint; v1: GLfloat; v2: GLfloat; vstride: GLint; vorder: GLint; w1: GLfloat; w2: GLfloat; wstride: GLint; worder: GLint; points: PGLfloat);stdcall;
  TglDeleteAsyncMarkersSGIX = procedure(marker: GLuint; range: GLsizei);stdcall;
  TglDeleteBuffers = procedure(n: GLsizei; buffers: PGLuint);stdcall;
  TglDeleteBuffersARB = procedure(n: GLsizei; buffers: PGLuint);stdcall;
  TglDeleteCommandListsNV = procedure(n: GLsizei; lists: PGLuint);stdcall;
  TglDeleteFencesAPPLE = procedure(n: GLsizei; fences: PGLuint);stdcall;
  TglDeleteFencesNV = procedure(n: GLsizei; fences: PGLuint);stdcall;
  TglDeleteFragmentShaderATI = procedure(id: GLuint);stdcall;
  TglDeleteFramebuffers = procedure(n: GLsizei; framebuffers: PGLuint);stdcall;
  TglDeleteFramebuffersEXT = procedure(n: GLsizei; framebuffers: PGLuint);stdcall;
  TglDeleteFramebuffersOES = procedure(n: GLsizei; framebuffers: PGLuint);stdcall;
  TglDeleteLists = procedure(list: GLuint; range: GLsizei);stdcall;
  TglDeleteMemoryObjectsEXT = procedure(n: GLsizei; memoryObjects: PGLuint);stdcall;
  TglDeleteNamedStringARB = procedure(namelen: GLint; name_: PGLchar);stdcall;
  TglDeleteNamesAMD = procedure(identifier: GLenum; num: GLuint; names: PGLuint);stdcall;
  TglDeleteObjectARB = procedure(obj: GLhandleARB);stdcall;
  TglDeleteOcclusionQueriesNV = procedure(n: GLsizei; ids: PGLuint);stdcall;
  TglDeletePathsNV = procedure(path: GLuint; range: GLsizei);stdcall;
  TglDeletePerfMonitorsAMD = procedure(n: GLsizei; monitors: PGLuint);stdcall;
  TglDeletePerfQueryINTEL = procedure(queryHandle: GLuint);stdcall;
  TglDeleteProgram = procedure(program_: GLuint);stdcall;
  TglDeleteProgramPipelines = procedure(n: GLsizei; pipelines: PGLuint);stdcall;
  TglDeleteProgramPipelinesEXT = procedure(n: GLsizei; pipelines: PGLuint);stdcall;
  TglDeleteProgramsARB = procedure(n: GLsizei; programs: PGLuint);stdcall;
  TglDeleteProgramsNV = procedure(n: GLsizei; programs: PGLuint);stdcall;
  TglDeleteQueries = procedure(n: GLsizei; ids: PGLuint);stdcall;
  TglDeleteQueriesARB = procedure(n: GLsizei; ids: PGLuint);stdcall;
  TglDeleteQueriesEXT = procedure(n: GLsizei; ids: PGLuint);stdcall;
  TglDeleteRenderbuffers = procedure(n: GLsizei; renderbuffers: PGLuint);stdcall;
  TglDeleteRenderbuffersEXT = procedure(n: GLsizei; renderbuffers: PGLuint);stdcall;
  TglDeleteRenderbuffersOES = procedure(n: GLsizei; renderbuffers: PGLuint);stdcall;
  TglDeleteSamplers = procedure(count: GLsizei; samplers: PGLuint);stdcall;
  TglDeleteSemaphoresEXT = procedure(n: GLsizei; semaphores: PGLuint);stdcall;
  TglDeleteShader = procedure(shader: GLuint);stdcall;
  TglDeleteStatesNV = procedure(n: GLsizei; states: PGLuint);stdcall;
  TglDeleteSync = procedure(sync: GLsync);stdcall;
  TglDeleteSyncAPPLE = procedure(sync: GLsync);stdcall;
  TglDeleteTextures = procedure(n: GLsizei; textures: PGLuint);stdcall;
  TglDeleteTexturesEXT = procedure(n: GLsizei; textures: PGLuint);stdcall;
  TglDeleteTransformFeedbacks = procedure(n: GLsizei; ids: PGLuint);stdcall;
  TglDeleteTransformFeedbacksNV = procedure(n: GLsizei; ids: PGLuint);stdcall;
  TglDeleteVertexArrays = procedure(n: GLsizei; arrays: PGLuint);stdcall;
  TglDeleteVertexArraysAPPLE = procedure(n: GLsizei; arrays: PGLuint);stdcall;
  TglDeleteVertexArraysOES = procedure(n: GLsizei; arrays: PGLuint);stdcall;
  TglDeleteVertexShaderEXT = procedure(id: GLuint);stdcall;
  TglDepthBoundsEXT = procedure(zmin: GLclampd; zmax: GLclampd);stdcall;
  TglDepthBoundsdNV = procedure(zmin: GLdouble; zmax: GLdouble);stdcall;
  TglDepthFunc = procedure(func: GLenum);stdcall;
  TglDepthMask = procedure(flag: GLboolean);stdcall;
  TglDepthRange = procedure(near_: GLdouble; far_: GLdouble);stdcall;
  TglDepthRangeArrayfvNV = procedure(first: GLuint; count: GLsizei; v: PGLfloat);stdcall;
  TglDepthRangeArrayfvOES = procedure(first: GLuint; count: GLsizei; v: PGLfloat);stdcall;
  TglDepthRangeArrayv = procedure(first: GLuint; count: GLsizei; v: PGLdouble);stdcall;
  TglDepthRangeIndexed = procedure(index_: GLuint; n: GLdouble; f: GLdouble);stdcall;
  TglDepthRangeIndexedfNV = procedure(index_: GLuint; n: GLfloat; f: GLfloat);stdcall;
  TglDepthRangeIndexedfOES = procedure(index_: GLuint; n: GLfloat; f: GLfloat);stdcall;
  TglDepthRangedNV = procedure(zNear: GLdouble; zFar: GLdouble);stdcall;
  TglDepthRangef = procedure(n: GLfloat; f: GLfloat);stdcall;
  TglDepthRangefOES = procedure(n: GLclampf; f: GLclampf);stdcall;
  TglDepthRangex = procedure(n: GLfixed; f: GLfixed);stdcall;
  TglDepthRangexOES = procedure(n: GLfixed; f: GLfixed);stdcall;
  TglDetachObjectARB = procedure(containerObj: GLhandleARB; attachedObj: GLhandleARB);stdcall;
  TglDetachShader = procedure(program_: GLuint; shader: GLuint);stdcall;
  TglDetailTexFuncSGIS = procedure(target: GLenum; n: GLsizei; points: PGLfloat);stdcall;
  TglDisable = procedure(cap: GLenum);stdcall;
  TglDisableClientState = procedure(array_: GLenum);stdcall;
  TglDisableClientStateIndexedEXT = procedure(array_: GLenum; index_: GLuint);stdcall;
  TglDisableClientStateiEXT = procedure(array_: GLenum; index_: GLuint);stdcall;
  TglDisableDriverControlQCOM = procedure(driverControl: GLuint);stdcall;
  TglDisableIndexedEXT = procedure(target: GLenum; index_: GLuint);stdcall;
  TglDisableVariantClientStateEXT = procedure(id: GLuint);stdcall;
  TglDisableVertexArrayAttrib = procedure(vaobj: GLuint; index_: GLuint);stdcall;
  TglDisableVertexArrayAttribEXT = procedure(vaobj: GLuint; index_: GLuint);stdcall;
  TglDisableVertexArrayEXT = procedure(vaobj: GLuint; array_: GLenum);stdcall;
  TglDisableVertexAttribAPPLE = procedure(index_: GLuint; pname: GLenum);stdcall;
  TglDisableVertexAttribArray = procedure(index_: GLuint);stdcall;
  TglDisableVertexAttribArrayARB = procedure(index_: GLuint);stdcall;
  TglDisablei = procedure(target: GLenum; index_: GLuint);stdcall;
  TglDisableiEXT = procedure(target: GLenum; index_: GLuint);stdcall;
  TglDisableiNV = procedure(target: GLenum; index_: GLuint);stdcall;
  TglDisableiOES = procedure(target: GLenum; index_: GLuint);stdcall;
  TglDiscardFramebufferEXT = procedure(target: GLenum; numAttachments: GLsizei; attachments: PGLenum);stdcall;
  TglDispatchCompute = procedure(num_groups_x: GLuint; num_groups_y: GLuint; num_groups_z: GLuint);stdcall;
  TglDispatchComputeGroupSizeARB = procedure(num_groups_x: GLuint; num_groups_y: GLuint; num_groups_z: GLuint; group_size_x: GLuint; group_size_y: GLuint; group_size_z: GLuint);stdcall;
  TglDispatchComputeIndirect = procedure(indirect: GLintptr);stdcall;
  TglDrawArrays = procedure(mode: GLenum; first: GLint; count: GLsizei);stdcall;
  TglDrawArraysEXT = procedure(mode: GLenum; first: GLint; count: GLsizei);stdcall;
  TglDrawArraysIndirect = procedure(mode: GLenum; indirect: Pvoid);stdcall;
  TglDrawArraysInstanced = procedure(mode: GLenum; first: GLint; count: GLsizei; instancecount: GLsizei);stdcall;
  TglDrawArraysInstancedANGLE = procedure(mode: GLenum; first: GLint; count: GLsizei; primcount: GLsizei);stdcall;
  TglDrawArraysInstancedARB = procedure(mode: GLenum; first: GLint; count: GLsizei; primcount: GLsizei);stdcall;
  TglDrawArraysInstancedBaseInstance = procedure(mode: GLenum; first: GLint; count: GLsizei; instancecount: GLsizei; baseinstance: GLuint);stdcall;
  TglDrawArraysInstancedBaseInstanceEXT = procedure(mode: GLenum; first: GLint; count: GLsizei; instancecount: GLsizei; baseinstance: GLuint);stdcall;
  TglDrawArraysInstancedEXT = procedure(mode: GLenum; start: GLint; count: GLsizei; primcount: GLsizei);stdcall;
  TglDrawArraysInstancedNV = procedure(mode: GLenum; first: GLint; count: GLsizei; primcount: GLsizei);stdcall;
  TglDrawBuffer = procedure(buf: GLenum);stdcall;
  TglDrawBuffers = procedure(n: GLsizei; bufs: PGLenum);stdcall;
  TglDrawBuffersARB = procedure(n: GLsizei; bufs: PGLenum);stdcall;
  TglDrawBuffersATI = procedure(n: GLsizei; bufs: PGLenum);stdcall;
  TglDrawBuffersEXT = procedure(n: GLsizei; bufs: PGLenum);stdcall;
  TglDrawBuffersIndexedEXT = procedure(n: GLint; location: PGLenum; indices: PGLint);stdcall;
  TglDrawBuffersNV = procedure(n: GLsizei; bufs: PGLenum);stdcall;
  TglDrawCommandsAddressNV = procedure(primitiveMode: GLenum; indirects: PGLuint64; sizes: PGLsizei; count: GLuint);stdcall;
  TglDrawCommandsNV = procedure(primitiveMode: GLenum; buffer: GLuint; indirects: PGLintptr; sizes: PGLsizei; count: GLuint);stdcall;
  TglDrawCommandsStatesAddressNV = procedure(indirects: PGLuint64; sizes: PGLsizei; states: PGLuint; fbos: PGLuint; count: GLuint);stdcall;
  TglDrawCommandsStatesNV = procedure(buffer: GLuint; indirects: PGLintptr; sizes: PGLsizei; states: PGLuint; fbos: PGLuint; count: GLuint);stdcall;
  TglDrawElementArrayAPPLE = procedure(mode: GLenum; first: GLint; count: GLsizei);stdcall;
  TglDrawElementArrayATI = procedure(mode: GLenum; count: GLsizei);stdcall;
  TglDrawElements = procedure(mode: GLenum; count: GLsizei; type_: GLenum; indices: Pvoid);stdcall;
  TglDrawElementsBaseVertex = procedure(mode: GLenum; count: GLsizei; type_: GLenum; indices: Pvoid; basevertex: GLint);stdcall;
  TglDrawElementsBaseVertexEXT = procedure(mode: GLenum; count: GLsizei; type_: GLenum; indices: Pvoid; basevertex: GLint);stdcall;
  TglDrawElementsBaseVertexOES = procedure(mode: GLenum; count: GLsizei; type_: GLenum; indices: Pvoid; basevertex: GLint);stdcall;
  TglDrawElementsIndirect = procedure(mode: GLenum; type_: GLenum; indirect: Pvoid);stdcall;
  TglDrawElementsInstanced = procedure(mode: GLenum; count: GLsizei; type_: GLenum; indices: Pvoid; instancecount: GLsizei);stdcall;
  TglDrawElementsInstancedANGLE = procedure(mode: GLenum; count: GLsizei; type_: GLenum; indices: Pvoid; primcount: GLsizei);stdcall;
  TglDrawElementsInstancedARB = procedure(mode: GLenum; count: GLsizei; type_: GLenum; indices: Pvoid; primcount: GLsizei);stdcall;
  TglDrawElementsInstancedBaseInstance = procedure(mode: GLenum; count: GLsizei; type_: GLenum; indices: Pvoid; instancecount: GLsizei; baseinstance: GLuint);stdcall;
  TglDrawElementsInstancedBaseInstanceEXT = procedure(mode: GLenum; count: GLsizei; type_: GLenum; indices: Pvoid; instancecount: GLsizei; baseinstance: GLuint);stdcall;
  TglDrawElementsInstancedBaseVertex = procedure(mode: GLenum; count: GLsizei; type_: GLenum; indices: Pvoid; instancecount: GLsizei; basevertex: GLint);stdcall;
  TglDrawElementsInstancedBaseVertexBaseInstance = procedure(mode: GLenum; count: GLsizei; type_: GLenum; indices: Pvoid; instancecount: GLsizei; basevertex: GLint; baseinstance: GLuint);stdcall;
  TglDrawElementsInstancedBaseVertexBaseInstanceEXT = procedure(mode: GLenum; count: GLsizei; type_: GLenum; indices: Pvoid; instancecount: GLsizei; basevertex: GLint; baseinstance: GLuint);stdcall;
  TglDrawElementsInstancedBaseVertexEXT = procedure(mode: GLenum; count: GLsizei; type_: GLenum; indices: Pvoid; instancecount: GLsizei; basevertex: GLint);stdcall;
  TglDrawElementsInstancedBaseVertexOES = procedure(mode: GLenum; count: GLsizei; type_: GLenum; indices: Pvoid; instancecount: GLsizei; basevertex: GLint);stdcall;
  TglDrawElementsInstancedEXT = procedure(mode: GLenum; count: GLsizei; type_: GLenum; indices: Pvoid; primcount: GLsizei);stdcall;
  TglDrawElementsInstancedNV = procedure(mode: GLenum; count: GLsizei; type_: GLenum; indices: Pvoid; primcount: GLsizei);stdcall;
  TglDrawMeshArraysSUN = procedure(mode: GLenum; first: GLint; count: GLsizei; width: GLsizei);stdcall;
  TglDrawPixels = procedure(width: GLsizei; height: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglDrawRangeElementArrayAPPLE = procedure(mode: GLenum; start: GLuint; end_: GLuint; first: GLint; count: GLsizei);stdcall;
  TglDrawRangeElementArrayATI = procedure(mode: GLenum; start: GLuint; end_: GLuint; count: GLsizei);stdcall;
  TglDrawRangeElements = procedure(mode: GLenum; start: GLuint; end_: GLuint; count: GLsizei; type_: GLenum; indices: Pvoid);stdcall;
  TglDrawRangeElementsBaseVertex = procedure(mode: GLenum; start: GLuint; end_: GLuint; count: GLsizei; type_: GLenum; indices: Pvoid; basevertex: GLint);stdcall;
  TglDrawRangeElementsBaseVertexEXT = procedure(mode: GLenum; start: GLuint; end_: GLuint; count: GLsizei; type_: GLenum; indices: Pvoid; basevertex: GLint);stdcall;
  TglDrawRangeElementsBaseVertexOES = procedure(mode: GLenum; start: GLuint; end_: GLuint; count: GLsizei; type_: GLenum; indices: Pvoid; basevertex: GLint);stdcall;
  TglDrawRangeElementsEXT = procedure(mode: GLenum; start: GLuint; end_: GLuint; count: GLsizei; type_: GLenum; indices: Pvoid);stdcall;
  TglDrawTexfOES = procedure(x: GLfloat; y: GLfloat; z: GLfloat; width: GLfloat; height: GLfloat);stdcall;
  TglDrawTexfvOES = procedure(coords: PGLfloat);stdcall;
  TglDrawTexiOES = procedure(x: GLint; y: GLint; z: GLint; width: GLint; height: GLint);stdcall;
  TglDrawTexivOES = procedure(coords: PGLint);stdcall;
  TglDrawTexsOES = procedure(x: GLshort; y: GLshort; z: GLshort; width: GLshort; height: GLshort);stdcall;
  TglDrawTexsvOES = procedure(coords: PGLshort);stdcall;
  TglDrawTextureNV = procedure(texture: GLuint; sampler: GLuint; x0: GLfloat; y0: GLfloat; x1: GLfloat; y1: GLfloat; z: GLfloat; s0: GLfloat; t0: GLfloat; s1: GLfloat; t1: GLfloat);stdcall;
  TglDrawTexxOES = procedure(x: GLfixed; y: GLfixed; z: GLfixed; width: GLfixed; height: GLfixed);stdcall;
  TglDrawTexxvOES = procedure(coords: PGLfixed);stdcall;
  TglDrawTransformFeedback = procedure(mode: GLenum; id: GLuint);stdcall;
  TglDrawTransformFeedbackEXT = procedure(mode: GLenum; id: GLuint);stdcall;
  TglDrawTransformFeedbackInstanced = procedure(mode: GLenum; id: GLuint; instancecount: GLsizei);stdcall;
  TglDrawTransformFeedbackInstancedEXT = procedure(mode: GLenum; id: GLuint; instancecount: GLsizei);stdcall;
  TglDrawTransformFeedbackNV = procedure(mode: GLenum; id: GLuint);stdcall;
  TglDrawTransformFeedbackStream = procedure(mode: GLenum; id: GLuint; stream: GLuint);stdcall;
  TglDrawTransformFeedbackStreamInstanced = procedure(mode: GLenum; id: GLuint; stream: GLuint; instancecount: GLsizei);stdcall;
  TglEGLImageTargetRenderbufferStorageOES = procedure(target: GLenum; image: GLeglImageOES);stdcall;
  TglEGLImageTargetTexture2DOES = procedure(target: GLenum; image: GLeglImageOES);stdcall;
  TglEdgeFlag = procedure(flag: GLboolean);stdcall;
  TglEdgeFlagFormatNV = procedure(stride: GLsizei);stdcall;
  TglEdgeFlagPointer = procedure(stride: GLsizei; pointer: Pvoid);stdcall;
  TglEdgeFlagPointerEXT = procedure(stride: GLsizei; count: GLsizei; pointer: PGLboolean);stdcall;
  TglEdgeFlagPointerListIBM = procedure(stride: GLint; pointer: PPGLboolean; ptrstride: GLint);stdcall;
  TglEdgeFlagv = procedure(flag: PGLboolean);stdcall;
  TglElementPointerAPPLE = procedure(type_: GLenum; pointer: Pvoid);stdcall;
  TglElementPointerATI = procedure(type_: GLenum; pointer: Pvoid);stdcall;
  TglEnable = procedure(cap: GLenum);stdcall;
  TglEnableClientState = procedure(array_: GLenum);stdcall;
  TglEnableClientStateIndexedEXT = procedure(array_: GLenum; index_: GLuint);stdcall;
  TglEnableClientStateiEXT = procedure(array_: GLenum; index_: GLuint);stdcall;
  TglEnableDriverControlQCOM = procedure(driverControl: GLuint);stdcall;
  TglEnableIndexedEXT = procedure(target: GLenum; index_: GLuint);stdcall;
  TglEnableVariantClientStateEXT = procedure(id: GLuint);stdcall;
  TglEnableVertexArrayAttrib = procedure(vaobj: GLuint; index_: GLuint);stdcall;
  TglEnableVertexArrayAttribEXT = procedure(vaobj: GLuint; index_: GLuint);stdcall;
  TglEnableVertexArrayEXT = procedure(vaobj: GLuint; array_: GLenum);stdcall;
  TglEnableVertexAttribAPPLE = procedure(index_: GLuint; pname: GLenum);stdcall;
  TglEnableVertexAttribArray = procedure(index_: GLuint);stdcall;
  TglEnableVertexAttribArrayARB = procedure(index_: GLuint);stdcall;
  TglEnablei = procedure(target: GLenum; index_: GLuint);stdcall;
  TglEnableiEXT = procedure(target: GLenum; index_: GLuint);stdcall;
  TglEnableiNV = procedure(target: GLenum; index_: GLuint);stdcall;
  TglEnableiOES = procedure(target: GLenum; index_: GLuint);stdcall;
  TglEnd = procedure;stdcall;
  TglEndConditionalRender = procedure;stdcall;
  TglEndConditionalRenderNV = procedure;stdcall;
  TglEndConditionalRenderNVX = procedure;stdcall;
  TglEndFragmentShaderATI = procedure;stdcall;
  TglEndList = procedure;stdcall;
  TglEndOcclusionQueryNV = procedure;stdcall;
  TglEndPerfMonitorAMD = procedure(monitor: GLuint);stdcall;
  TglEndPerfQueryINTEL = procedure(queryHandle: GLuint);stdcall;
  TglEndQuery = procedure(target: GLenum);stdcall;
  TglEndQueryARB = procedure(target: GLenum);stdcall;
  TglEndQueryEXT = procedure(target: GLenum);stdcall;
  TglEndQueryIndexed = procedure(target: GLenum; index_: GLuint);stdcall;
  TglEndTilingQCOM = procedure(preserveMask: GLbitfield);stdcall;
  TglEndTransformFeedback = procedure;stdcall;
  TglEndTransformFeedbackEXT = procedure;stdcall;
  TglEndTransformFeedbackNV = procedure;stdcall;
  TglEndVertexShaderEXT = procedure;stdcall;
  TglEndVideoCaptureNV = procedure(video_capture_slot: GLuint);stdcall;
  TglEvalCoord1d = procedure(u: GLdouble);stdcall;
  TglEvalCoord1dv = procedure(u: PGLdouble);stdcall;
  TglEvalCoord1f = procedure(u: GLfloat);stdcall;
  TglEvalCoord1fv = procedure(u: PGLfloat);stdcall;
  TglEvalCoord1xOES = procedure(u: GLfixed);stdcall;
  TglEvalCoord1xvOES = procedure(coords: PGLfixed);stdcall;
  TglEvalCoord2d = procedure(u: GLdouble; v: GLdouble);stdcall;
  TglEvalCoord2dv = procedure(u: PGLdouble);stdcall;
  TglEvalCoord2f = procedure(u: GLfloat; v: GLfloat);stdcall;
  TglEvalCoord2fv = procedure(u: PGLfloat);stdcall;
  TglEvalCoord2xOES = procedure(u: GLfixed; v: GLfixed);stdcall;
  TglEvalCoord2xvOES = procedure(coords: PGLfixed);stdcall;
  TglEvalMapsNV = procedure(target: GLenum; mode: GLenum);stdcall;
  TglEvalMesh1 = procedure(mode: GLenum; i1: GLint; i2: GLint);stdcall;
  TglEvalMesh2 = procedure(mode: GLenum; i1: GLint; i2: GLint; j1: GLint; j2: GLint);stdcall;
  TglEvalPoint1 = procedure(i: GLint);stdcall;
  TglEvalPoint2 = procedure(i: GLint; j: GLint);stdcall;
  TglEvaluateDepthValuesARB = procedure;stdcall;
  TglExecuteProgramNV = procedure(target: GLenum; id: GLuint; params: PGLfloat);stdcall;
  TglExtGetBufferPointervQCOM = procedure(target: GLenum; params: PPvoid);stdcall;
  TglExtGetBuffersQCOM = procedure(buffers: PGLuint; maxBuffers: GLint; numBuffers: PGLint);stdcall;
  TglExtGetFramebuffersQCOM = procedure(framebuffers: PGLuint; maxFramebuffers: GLint; numFramebuffers: PGLint);stdcall;
  TglExtGetProgramBinarySourceQCOM = procedure(program_: GLuint; shadertype: GLenum; source: PGLchar; length: PGLint);stdcall;
  TglExtGetProgramsQCOM = procedure(programs: PGLuint; maxPrograms: GLint; numPrograms: PGLint);stdcall;
  TglExtGetRenderbuffersQCOM = procedure(renderbuffers: PGLuint; maxRenderbuffers: GLint; numRenderbuffers: PGLint);stdcall;
  TglExtGetShadersQCOM = procedure(shaders: PGLuint; maxShaders: GLint; numShaders: PGLint);stdcall;
  TglExtGetTexLevelParameterivQCOM = procedure(texture: GLuint; face: GLenum; level: GLint; pname: GLenum; params: PGLint);stdcall;
  TglExtGetTexSubImageQCOM = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; type_: GLenum; texels: Pvoid);stdcall;
  TglExtGetTexturesQCOM = procedure(textures: PGLuint; maxTextures: GLint; numTextures: PGLint);stdcall;
  TglExtIsProgramBinaryQCOM = function(program_: GLuint): GLboolean;stdcall;
  TglExtTexObjectStateOverrideiQCOM = procedure(target: GLenum; pname: GLenum; param: GLint);stdcall;
  TglExtractComponentEXT = procedure(res: GLuint; src: GLuint; num: GLuint);stdcall;
  TglFeedbackBuffer = procedure(size: GLsizei; type_: GLenum; buffer: PGLfloat);stdcall;
  TglFeedbackBufferxOES = procedure(n: GLsizei; type_: GLenum; buffer: PGLfixed);stdcall;
  TglFenceSync = function(condition: GLenum; flags: GLbitfield): GLsync;stdcall;
  TglFenceSyncAPPLE = function(condition: GLenum; flags: GLbitfield): GLsync;stdcall;
  TglFinalCombinerInputNV = procedure(variable: GLenum; input: GLenum; mapping: GLenum; componentUsage: GLenum);stdcall;
  TglFinish = procedure;stdcall;
  TglFinishAsyncSGIX = function(markerp: PGLuint): GLint;stdcall;
  TglFinishFenceAPPLE = procedure(fence: GLuint);stdcall;
  TglFinishFenceNV = procedure(fence: GLuint);stdcall;
  TglFinishObjectAPPLE = procedure(object_: GLenum; name_: GLint);stdcall;
  TglFinishTextureSUNX = procedure;stdcall;
  TglFlush = procedure;stdcall;
  TglFlushMappedBufferRange = procedure(target: GLenum; offset: GLintptr; length: GLsizeiptr);stdcall;
  TglFlushMappedBufferRangeAPPLE = procedure(target: GLenum; offset: GLintptr; size: GLsizeiptr);stdcall;
  TglFlushMappedBufferRangeEXT = procedure(target: GLenum; offset: GLintptr; length: GLsizeiptr);stdcall;
  TglFlushMappedNamedBufferRange = procedure(buffer: GLuint; offset: GLintptr; length: GLsizeiptr);stdcall;
  TglFlushMappedNamedBufferRangeEXT = procedure(buffer: GLuint; offset: GLintptr; length: GLsizeiptr);stdcall;
  TglFlushPixelDataRangeNV = procedure(target: GLenum);stdcall;
  TglFlushRasterSGIX = procedure;stdcall;
  TglFlushStaticDataIBM = procedure(target: GLenum);stdcall;
  TglFlushVertexArrayRangeAPPLE = procedure(length: GLsizei; pointer: Pvoid);stdcall;
  TglFlushVertexArrayRangeNV = procedure;stdcall;
  TglFogCoordFormatNV = procedure(type_: GLenum; stride: GLsizei);stdcall;
  TglFogCoordPointer = procedure(type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglFogCoordPointerEXT = procedure(type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglFogCoordPointerListIBM = procedure(type_: GLenum; stride: GLint; pointer: PPvoid; ptrstride: GLint);stdcall;
  TglFogCoordd = procedure(coord: GLdouble);stdcall;
  TglFogCoorddEXT = procedure(coord: GLdouble);stdcall;
  TglFogCoorddv = procedure(coord: PGLdouble);stdcall;
  TglFogCoorddvEXT = procedure(coord: PGLdouble);stdcall;
  TglFogCoordf = procedure(coord: GLfloat);stdcall;
  TglFogCoordfEXT = procedure(coord: GLfloat);stdcall;
  TglFogCoordfv = procedure(coord: PGLfloat);stdcall;
  TglFogCoordfvEXT = procedure(coord: PGLfloat);stdcall;
  TglFogCoordhNV = procedure(fog: GLhalfNV);stdcall;
  TglFogCoordhvNV = procedure(fog: PGLhalfNV);stdcall;
  TglFogFuncSGIS = procedure(n: GLsizei; points: PGLfloat);stdcall;
  TglFogf = procedure(pname: GLenum; param: GLfloat);stdcall;
  TglFogfv = procedure(pname: GLenum; params: PGLfloat);stdcall;
  TglFogi = procedure(pname: GLenum; param: GLint);stdcall;
  TglFogiv = procedure(pname: GLenum; params: PGLint);stdcall;
  TglFogx = procedure(pname: GLenum; param: GLfixed);stdcall;
  TglFogxOES = procedure(pname: GLenum; param: GLfixed);stdcall;
  TglFogxv = procedure(pname: GLenum; param: PGLfixed);stdcall;
  TglFogxvOES = procedure(pname: GLenum; param: PGLfixed);stdcall;
  TglFragmentColorMaterialSGIX = procedure(face: GLenum; mode: GLenum);stdcall;
  TglFragmentCoverageColorNV = procedure(color: GLuint);stdcall;
  TglFragmentLightModelfSGIX = procedure(pname: GLenum; param: GLfloat);stdcall;
  TglFragmentLightModelfvSGIX = procedure(pname: GLenum; params: PGLfloat);stdcall;
  TglFragmentLightModeliSGIX = procedure(pname: GLenum; param: GLint);stdcall;
  TglFragmentLightModelivSGIX = procedure(pname: GLenum; params: PGLint);stdcall;
  TglFragmentLightfSGIX = procedure(light: GLenum; pname: GLenum; param: GLfloat);stdcall;
  TglFragmentLightfvSGIX = procedure(light: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglFragmentLightiSGIX = procedure(light: GLenum; pname: GLenum; param: GLint);stdcall;
  TglFragmentLightivSGIX = procedure(light: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglFragmentMaterialfSGIX = procedure(face: GLenum; pname: GLenum; param: GLfloat);stdcall;
  TglFragmentMaterialfvSGIX = procedure(face: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglFragmentMaterialiSGIX = procedure(face: GLenum; pname: GLenum; param: GLint);stdcall;
  TglFragmentMaterialivSGIX = procedure(face: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglFrameTerminatorGREMEDY = procedure;stdcall;
  TglFrameZoomSGIX = procedure(factor: GLint);stdcall;
  TglFramebufferDrawBufferEXT = procedure(framebuffer: GLuint; mode: GLenum);stdcall;
  TglFramebufferDrawBuffersEXT = procedure(framebuffer: GLuint; n: GLsizei; bufs: PGLenum);stdcall;
  TglFramebufferFetchBarrierQCOM = procedure;stdcall;
  TglFramebufferFoveationConfigQCOM = procedure(framebuffer: GLuint; numLayers: GLuint; focalPointsPerLayer: GLuint; requestedFeatures: GLuint; providedFeatures: PGLuint);stdcall;
  TglFramebufferFoveationParametersQCOM = procedure(framebuffer: GLuint; layer: GLuint; focalPoint: GLuint; focalX: GLfloat; focalY: GLfloat; gainX: GLfloat; gainY: GLfloat; foveaArea: GLfloat);stdcall;
  TglFramebufferParameteri = procedure(target: GLenum; pname: GLenum; param: GLint);stdcall;
  TglFramebufferPixelLocalStorageSizeEXT = procedure(target: GLuint; size: GLsizei);stdcall;
  TglFramebufferReadBufferEXT = procedure(framebuffer: GLuint; mode: GLenum);stdcall;
  TglFramebufferRenderbuffer = procedure(target: GLenum; attachment: GLenum; renderbuffertarget: GLenum; renderbuffer: GLuint);stdcall;
  TglFramebufferRenderbufferEXT = procedure(target: GLenum; attachment: GLenum; renderbuffertarget: GLenum; renderbuffer: GLuint);stdcall;
  TglFramebufferRenderbufferOES = procedure(target: GLenum; attachment: GLenum; renderbuffertarget: GLenum; renderbuffer: GLuint);stdcall;
  TglFramebufferSampleLocationsfvARB = procedure(target: GLenum; start: GLuint; count: GLsizei; v: PGLfloat);stdcall;
  TglFramebufferSampleLocationsfvNV = procedure(target: GLenum; start: GLuint; count: GLsizei; v: PGLfloat);stdcall;
  TglFramebufferSamplePositionsfvAMD = procedure(target: GLenum; numsamples: GLuint; pixelindex: GLuint; values: PGLfloat);stdcall;
  TglFramebufferTexture = procedure(target: GLenum; attachment: GLenum; texture: GLuint; level: GLint);stdcall;
  TglFramebufferTexture1D = procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint);stdcall;
  TglFramebufferTexture1DEXT = procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint);stdcall;
  TglFramebufferTexture2D = procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint);stdcall;
  TglFramebufferTexture2DEXT = procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint);stdcall;
  TglFramebufferTexture2DDownsampleIMG = procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint; xscale: GLint; yscale: GLint);stdcall;
  TglFramebufferTexture2DMultisampleEXT = procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint; samples: GLsizei);stdcall;
  TglFramebufferTexture2DMultisampleIMG = procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint; samples: GLsizei);stdcall;
  TglFramebufferTexture2DOES = procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint);stdcall;
  TglFramebufferTexture3D = procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint; zoffset: GLint);stdcall;
  TglFramebufferTexture3DEXT = procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint; zoffset: GLint);stdcall;
  TglFramebufferTexture3DOES = procedure(target: GLenum; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint; zoffset: GLint);stdcall;
  TglFramebufferTextureARB = procedure(target: GLenum; attachment: GLenum; texture: GLuint; level: GLint);stdcall;
  TglFramebufferTextureEXT = procedure(target: GLenum; attachment: GLenum; texture: GLuint; level: GLint);stdcall;
  TglFramebufferTextureFaceARB = procedure(target: GLenum; attachment: GLenum; texture: GLuint; level: GLint; face: GLenum);stdcall;
  TglFramebufferTextureFaceEXT = procedure(target: GLenum; attachment: GLenum; texture: GLuint; level: GLint; face: GLenum);stdcall;
  TglFramebufferTextureLayer = procedure(target: GLenum; attachment: GLenum; texture: GLuint; level: GLint; layer: GLint);stdcall;
  TglFramebufferTextureLayerARB = procedure(target: GLenum; attachment: GLenum; texture: GLuint; level: GLint; layer: GLint);stdcall;
  TglFramebufferTextureLayerEXT = procedure(target: GLenum; attachment: GLenum; texture: GLuint; level: GLint; layer: GLint);stdcall;
  TglFramebufferTextureLayerDownsampleIMG = procedure(target: GLenum; attachment: GLenum; texture: GLuint; level: GLint; layer: GLint; xscale: GLint; yscale: GLint);stdcall;
  TglFramebufferTextureMultisampleMultiviewOVR = procedure(target: GLenum; attachment: GLenum; texture: GLuint; level: GLint; samples: GLsizei; baseViewIndex: GLint; numViews: GLsizei);stdcall;
  TglFramebufferTextureMultiviewOVR = procedure(target: GLenum; attachment: GLenum; texture: GLuint; level: GLint; baseViewIndex: GLint; numViews: GLsizei);stdcall;
  TglFramebufferTextureOES = procedure(target: GLenum; attachment: GLenum; texture: GLuint; level: GLint);stdcall;
  TglFreeObjectBufferATI = procedure(buffer: GLuint);stdcall;
  TglFrontFace = procedure(mode: GLenum);stdcall;
  TglFrustum = procedure(left: GLdouble; right: GLdouble; bottom: GLdouble; top: GLdouble; zNear: GLdouble; zFar: GLdouble);stdcall;
  TglFrustumf = procedure(l: GLfloat; r: GLfloat; b: GLfloat; t: GLfloat; n: GLfloat; f: GLfloat);stdcall;
  TglFrustumfOES = procedure(l: GLfloat; r: GLfloat; b: GLfloat; t: GLfloat; n: GLfloat; f: GLfloat);stdcall;
  TglFrustumx = procedure(l: GLfixed; r: GLfixed; b: GLfixed; t: GLfixed; n: GLfixed; f: GLfixed);stdcall;
  TglFrustumxOES = procedure(l: GLfixed; r: GLfixed; b: GLfixed; t: GLfixed; n: GLfixed; f: GLfixed);stdcall;
  TglGenAsyncMarkersSGIX = function(range: GLsizei): GLuint;stdcall;
  TglGenBuffers = procedure(n: GLsizei; buffers: PGLuint);stdcall;
  TglGenBuffersARB = procedure(n: GLsizei; buffers: PGLuint);stdcall;
  TglGenFencesAPPLE = procedure(n: GLsizei; fences: PGLuint);stdcall;
  TglGenFencesNV = procedure(n: GLsizei; fences: PGLuint);stdcall;
  TglGenFragmentShadersATI = function(range: GLuint): GLuint;stdcall;
  TglGenFramebuffers = procedure(n: GLsizei; framebuffers: PGLuint);stdcall;
  TglGenFramebuffersEXT = procedure(n: GLsizei; framebuffers: PGLuint);stdcall;
  TglGenFramebuffersOES = procedure(n: GLsizei; framebuffers: PGLuint);stdcall;
  TglGenLists = function(range: GLsizei): GLuint;stdcall;
  TglGenNamesAMD = procedure(identifier: GLenum; num: GLuint; names: PGLuint);stdcall;
  TglGenOcclusionQueriesNV = procedure(n: GLsizei; ids: PGLuint);stdcall;
  TglGenPathsNV = function(range: GLsizei): GLuint;stdcall;
  TglGenPerfMonitorsAMD = procedure(n: GLsizei; monitors: PGLuint);stdcall;
  TglGenProgramPipelines = procedure(n: GLsizei; pipelines: PGLuint);stdcall;
  TglGenProgramPipelinesEXT = procedure(n: GLsizei; pipelines: PGLuint);stdcall;
  TglGenProgramsARB = procedure(n: GLsizei; programs: PGLuint);stdcall;
  TglGenProgramsNV = procedure(n: GLsizei; programs: PGLuint);stdcall;
  TglGenQueries = procedure(n: GLsizei; ids: PGLuint);stdcall;
  TglGenQueriesARB = procedure(n: GLsizei; ids: PGLuint);stdcall;
  TglGenQueriesEXT = procedure(n: GLsizei; ids: PGLuint);stdcall;
  TglGenRenderbuffers = procedure(n: GLsizei; renderbuffers: PGLuint);stdcall;
  TglGenRenderbuffersEXT = procedure(n: GLsizei; renderbuffers: PGLuint);stdcall;
  TglGenRenderbuffersOES = procedure(n: GLsizei; renderbuffers: PGLuint);stdcall;
  TglGenSamplers = procedure(count: GLsizei; samplers: PGLuint);stdcall;
  TglGenSemaphoresEXT = procedure(n: GLsizei; semaphores: PGLuint);stdcall;
  TglGenSymbolsEXT = function(datatype: GLenum; storagetype: GLenum; range: GLenum; components: GLuint): GLuint;stdcall;
  TglGenTextures = procedure(n: GLsizei; textures: PGLuint);stdcall;
  TglGenTexturesEXT = procedure(n: GLsizei; textures: PGLuint);stdcall;
  TglGenTransformFeedbacks = procedure(n: GLsizei; ids: PGLuint);stdcall;
  TglGenTransformFeedbacksNV = procedure(n: GLsizei; ids: PGLuint);stdcall;
  TglGenVertexArrays = procedure(n: GLsizei; arrays: PGLuint);stdcall;
  TglGenVertexArraysAPPLE = procedure(n: GLsizei; arrays: PGLuint);stdcall;
  TglGenVertexArraysOES = procedure(n: GLsizei; arrays: PGLuint);stdcall;
  TglGenVertexShadersEXT = function(range: GLuint): GLuint;stdcall;
  TglGenerateMipmap = procedure(target: GLenum);stdcall;
  TglGenerateMipmapEXT = procedure(target: GLenum);stdcall;
  TglGenerateMipmapOES = procedure(target: GLenum);stdcall;
  TglGenerateMultiTexMipmapEXT = procedure(texunit: GLenum; target: GLenum);stdcall;
  TglGenerateTextureMipmap = procedure(texture: GLuint);stdcall;
  TglGenerateTextureMipmapEXT = procedure(texture: GLuint; target: GLenum);stdcall;
  TglGetActiveAtomicCounterBufferiv = procedure(program_: GLuint; bufferIndex: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetActiveAttrib = procedure(program_: GLuint; index_: GLuint; bufSize: GLsizei; length: PGLsizei; size: PGLint; type_: PGLenum; name_: PGLchar);stdcall;
  TglGetActiveAttribARB = procedure(programObj: GLhandleARB; index_: GLuint; maxLength: GLsizei; length: PGLsizei; size: PGLint; type_: PGLenum; name_: PGLcharARB);stdcall;
  TglGetActiveSubroutineName = procedure(program_: GLuint; shadertype: GLenum; index_: GLuint; bufsize: GLsizei; length: PGLsizei; name_: PGLchar);stdcall;
  TglGetActiveSubroutineUniformName = procedure(program_: GLuint; shadertype: GLenum; index_: GLuint; bufsize: GLsizei; length: PGLsizei; name_: PGLchar);stdcall;
  TglGetActiveSubroutineUniformiv = procedure(program_: GLuint; shadertype: GLenum; index_: GLuint; pname: GLenum; values: PGLint);stdcall;
  TglGetActiveUniform = procedure(program_: GLuint; index_: GLuint; bufSize: GLsizei; length: PGLsizei; size: PGLint; type_: PGLenum; name_: PGLchar);stdcall;
  TglGetActiveUniformARB = procedure(programObj: GLhandleARB; index_: GLuint; maxLength: GLsizei; length: PGLsizei; size: PGLint; type_: PGLenum; name_: PGLcharARB);stdcall;
  TglGetActiveUniformBlockName = procedure(program_: GLuint; uniformBlockIndex: GLuint; bufSize: GLsizei; length: PGLsizei; uniformBlockName: PGLchar);stdcall;
  TglGetActiveUniformBlockiv = procedure(program_: GLuint; uniformBlockIndex: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetActiveUniformName = procedure(program_: GLuint; uniformIndex: GLuint; bufSize: GLsizei; length: PGLsizei; uniformName: PGLchar);stdcall;
  TglGetActiveUniformsiv = procedure(program_: GLuint; uniformCount: GLsizei; uniformIndices: PGLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetActiveVaryingNV = procedure(program_: GLuint; index_: GLuint; bufSize: GLsizei; length: PGLsizei; size: PGLsizei; type_: PGLenum; name_: PGLchar);stdcall;
  TglGetArrayObjectfvATI = procedure(array_: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetArrayObjectivATI = procedure(array_: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetAttachedObjectsARB = procedure(containerObj: GLhandleARB; maxCount: GLsizei; count: PGLsizei; obj: PGLhandleARB);stdcall;
  TglGetAttachedShaders = procedure(program_: GLuint; maxCount: GLsizei; count: PGLsizei; shaders: PGLuint);stdcall;
  TglGetAttribLocation = function(program_: GLuint; name_: PGLchar): GLint;stdcall;
  TglGetAttribLocationARB = function(programObj: GLhandleARB; name_: PGLcharARB): GLint;stdcall;
  TglGetBooleanIndexedvEXT = procedure(target: GLenum; index_: GLuint; data: PGLboolean);stdcall;
  TglGetBooleani_v = procedure(target: GLenum; index_: GLuint; data: PGLboolean);stdcall;
  TglGetBooleanv = procedure(pname: GLenum; data: PGLboolean);stdcall;
  TglGetBufferParameteri64v = procedure(target: GLenum; pname: GLenum; params: PGLint64);stdcall;
  TglGetBufferParameteriv = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetBufferParameterivARB = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetBufferParameterui64vNV = procedure(target: GLenum; pname: GLenum; params: PGLuint64EXT);stdcall;
  TglGetBufferPointerv = procedure(target: GLenum; pname: GLenum; params: PPvoid);stdcall;
  TglGetBufferPointervARB = procedure(target: GLenum; pname: GLenum; params: PPvoid);stdcall;
  TglGetBufferPointervOES = procedure(target: GLenum; pname: GLenum; params: PPvoid);stdcall;
  TglGetBufferSubData = procedure(target: GLenum; offset: GLintptr; size: GLsizeiptr; data: Pvoid);stdcall;
  TglGetBufferSubDataARB = procedure(target: GLenum; offset: GLintptrARB; size: GLsizeiptrARB; data: Pvoid);stdcall;
  TglGetClipPlane = procedure(plane: GLenum; equation: PGLdouble);stdcall;
  TglGetClipPlanef = procedure(plane: GLenum; equation: PGLfloat);stdcall;
  TglGetClipPlanefOES = procedure(plane: GLenum; equation: PGLfloat);stdcall;
  TglGetClipPlanex = procedure(plane: GLenum; equation: PGLfixed);stdcall;
  TglGetClipPlanexOES = procedure(plane: GLenum; equation: PGLfixed);stdcall;
  TglGetColorTable = procedure(target: GLenum; format: GLenum; type_: GLenum; table: Pvoid);stdcall;
  TglGetColorTableEXT = procedure(target: GLenum; format: GLenum; type_: GLenum; data: Pvoid);stdcall;
  TglGetColorTableParameterfv = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetColorTableParameterfvEXT = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetColorTableParameterfvSGI = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetColorTableParameteriv = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetColorTableParameterivEXT = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetColorTableParameterivSGI = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetColorTableSGI = procedure(target: GLenum; format: GLenum; type_: GLenum; table: Pvoid);stdcall;
  TglGetCombinerInputParameterfvNV = procedure(stage: GLenum; portion: GLenum; variable: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetCombinerInputParameterivNV = procedure(stage: GLenum; portion: GLenum; variable: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetCombinerOutputParameterfvNV = procedure(stage: GLenum; portion: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetCombinerOutputParameterivNV = procedure(stage: GLenum; portion: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetCombinerStageParameterfvNV = procedure(stage: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetCommandHeaderNV = function(tokenID: GLenum; size: GLuint): GLuint;stdcall;
  TglGetCompressedMultiTexImageEXT = procedure(texunit: GLenum; target: GLenum; lod: GLint; img: Pvoid);stdcall;
  TglGetCompressedTexImage = procedure(target: GLenum; level: GLint; img: Pvoid);stdcall;
  TglGetCompressedTexImageARB = procedure(target: GLenum; level: GLint; img: Pvoid);stdcall;
  TglGetCompressedTextureImage = procedure(texture: GLuint; level: GLint; bufSize: GLsizei; pixels: Pvoid);stdcall;
  TglGetCompressedTextureImageEXT = procedure(texture: GLuint; target: GLenum; lod: GLint; img: Pvoid);stdcall;
  TglGetCompressedTextureSubImage = procedure(texture: GLuint; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; bufSize: GLsizei; pixels: Pvoid);stdcall;
  TglGetConvolutionFilter = procedure(target: GLenum; format: GLenum; type_: GLenum; image: Pvoid);stdcall;
  TglGetConvolutionFilterEXT = procedure(target: GLenum; format: GLenum; type_: GLenum; image: Pvoid);stdcall;
  TglGetConvolutionParameterfv = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetConvolutionParameterfvEXT = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetConvolutionParameteriv = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetConvolutionParameterivEXT = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetConvolutionParameterxvOES = procedure(target: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglGetCoverageModulationTableNV = procedure(bufsize: GLsizei; v: PGLfloat);stdcall;
  TglGetDebugMessageLog = function(count: GLuint; bufSize: GLsizei; sources: PGLenum; types: PGLenum; ids: PGLuint; severities: PGLenum; lengths: PGLsizei; messageLog: PGLchar): GLuint;stdcall;
  TglGetDebugMessageLogAMD = function(count: GLuint; bufsize: GLsizei; categories: PGLenum; severities: PGLuint; ids: PGLuint; lengths: PGLsizei; message_: PGLchar): GLuint;stdcall;
  TglGetDebugMessageLogARB = function(count: GLuint; bufSize: GLsizei; sources: PGLenum; types: PGLenum; ids: PGLuint; severities: PGLenum; lengths: PGLsizei; messageLog: PGLchar): GLuint;stdcall;
  TglGetDebugMessageLogKHR = function(count: GLuint; bufSize: GLsizei; sources: PGLenum; types: PGLenum; ids: PGLuint; severities: PGLenum; lengths: PGLsizei; messageLog: PGLchar): GLuint;stdcall;
  TglGetDetailTexFuncSGIS = procedure(target: GLenum; points: PGLfloat);stdcall;
  TglGetDoubleIndexedvEXT = procedure(target: GLenum; index_: GLuint; data: PGLdouble);stdcall;
  TglGetDoublei_v = procedure(target: GLenum; index_: GLuint; data: PGLdouble);stdcall;
  TglGetDoublei_vEXT = procedure(pname: GLenum; index_: GLuint; params: PGLdouble);stdcall;
  TglGetDoublev = procedure(pname: GLenum; data: PGLdouble);stdcall;
  TglGetDriverControlStringQCOM = procedure(driverControl: GLuint; bufSize: GLsizei; length: PGLsizei; driverControlString: PGLchar);stdcall;
  TglGetDriverControlsQCOM = procedure(num: PGLint; size: GLsizei; driverControls: PGLuint);stdcall;
  TglGetError = function: GLenum;stdcall;
  TglGetFenceivNV = procedure(fence: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetFinalCombinerInputParameterfvNV = procedure(variable: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetFinalCombinerInputParameterivNV = procedure(variable: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetFirstPerfQueryIdINTEL = procedure(queryId: PGLuint);stdcall;
  TglGetFixedv = procedure(pname: GLenum; params: PGLfixed);stdcall;
  TglGetFixedvOES = procedure(pname: GLenum; params: PGLfixed);stdcall;
  TglGetFloatIndexedvEXT = procedure(target: GLenum; index_: GLuint; data: PGLfloat);stdcall;
  TglGetFloati_v = procedure(target: GLenum; index_: GLuint; data: PGLfloat);stdcall;
  TglGetFloati_vEXT = procedure(pname: GLenum; index_: GLuint; params: PGLfloat);stdcall;
  TglGetFloati_vNV = procedure(target: GLenum; index_: GLuint; data: PGLfloat);stdcall;
  TglGetFloati_vOES = procedure(target: GLenum; index_: GLuint; data: PGLfloat);stdcall;
  TglGetFloatv = procedure(pname: GLenum; data: PGLfloat);stdcall;
  TglGetFogFuncSGIS = procedure(points: PGLfloat);stdcall;
  TglGetFragDataIndex = function(program_: GLuint; name_: PGLchar): GLint;stdcall;
  TglGetFragDataIndexEXT = function(program_: GLuint; name_: PGLchar): GLint;stdcall;
  TglGetFragDataLocation = function(program_: GLuint; name_: PGLchar): GLint;stdcall;
  TglGetFragDataLocationEXT = function(program_: GLuint; name_: PGLchar): GLint;stdcall;
  TglGetFragmentLightfvSGIX = procedure(light: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetFragmentLightivSGIX = procedure(light: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetFragmentMaterialfvSGIX = procedure(face: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetFragmentMaterialivSGIX = procedure(face: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetFramebufferAttachmentParameteriv = procedure(target: GLenum; attachment: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetFramebufferAttachmentParameterivEXT = procedure(target: GLenum; attachment: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetFramebufferAttachmentParameterivOES = procedure(target: GLenum; attachment: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetFramebufferParameterfvAMD = procedure(target: GLenum; pname: GLenum; numsamples: GLuint; pixelindex: GLuint; size: GLsizei; values: PGLfloat);stdcall;
  TglGetFramebufferParameteriv = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetFramebufferParameterivEXT = procedure(framebuffer: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetFramebufferPixelLocalStorageSizeEXT = function(target: GLuint): GLsizei;stdcall;
  TglGetGraphicsResetStatus = function: GLenum;stdcall;
  TglGetGraphicsResetStatusARB = function: GLenum;stdcall;
  TglGetGraphicsResetStatusEXT = function: GLenum;stdcall;
  TglGetGraphicsResetStatusKHR = function: GLenum;stdcall;
  TglGetHandleARB = function(pname: GLenum): GLhandleARB;stdcall;
  TglGetHistogram = procedure(target: GLenum; reset: GLboolean; format: GLenum; type_: GLenum; values: Pvoid);stdcall;
  TglGetHistogramEXT = procedure(target: GLenum; reset: GLboolean; format: GLenum; type_: GLenum; values: Pvoid);stdcall;
  TglGetHistogramParameterfv = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetHistogramParameterfvEXT = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetHistogramParameteriv = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetHistogramParameterivEXT = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetHistogramParameterxvOES = procedure(target: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglGetImageHandleARB = function(texture: GLuint; level: GLint; layered: GLboolean; layer: GLint; format: GLenum): GLuint64;stdcall;
  TglGetImageHandleNV = function(texture: GLuint; level: GLint; layered: GLboolean; layer: GLint; format: GLenum): GLuint64;stdcall;
  TglGetImageTransformParameterfvHP = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetImageTransformParameterivHP = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetInfoLogARB = procedure(obj: GLhandleARB; maxLength: GLsizei; length: PGLsizei; infoLog: PGLcharARB);stdcall;
  TglGetInstrumentsSGIX = function: GLint;stdcall;
  TglGetInteger64i_v = procedure(target: GLenum; index_: GLuint; data: PGLint64);stdcall;
  TglGetInteger64v = procedure(pname: GLenum; data: PGLint64);stdcall;
  TglGetInteger64vAPPLE = procedure(pname: GLenum; params: PGLint64);stdcall;
  TglGetIntegerIndexedvEXT = procedure(target: GLenum; index_: GLuint; data: PGLint);stdcall;
  TglGetIntegeri_v = procedure(target: GLenum; index_: GLuint; data: PGLint);stdcall;
  TglGetIntegeri_vEXT = procedure(target: GLenum; index_: GLuint; data: PGLint);stdcall;
  TglGetIntegerui64i_vNV = procedure(value: GLenum; index_: GLuint; result_: PGLuint64EXT);stdcall;
  TglGetIntegerui64vNV = procedure(value: GLenum; result_: PGLuint64EXT);stdcall;
  TglGetIntegerv = procedure(pname: GLenum; data: PGLint);stdcall;
  TglGetInternalformatSampleivNV = procedure(target: GLenum; internalformat: GLenum; samples: GLsizei; pname: GLenum; bufSize: GLsizei; params: PGLint);stdcall;
  TglGetInternalformati64v = procedure(target: GLenum; internalformat: GLenum; pname: GLenum; bufSize: GLsizei; params: PGLint64);stdcall;
  TglGetInternalformativ = procedure(target: GLenum; internalformat: GLenum; pname: GLenum; bufSize: GLsizei; params: PGLint);stdcall;
  TglGetInvariantBooleanvEXT = procedure(id: GLuint; value: GLenum; data: PGLboolean);stdcall;
  TglGetInvariantFloatvEXT = procedure(id: GLuint; value: GLenum; data: PGLfloat);stdcall;
  TglGetInvariantIntegervEXT = procedure(id: GLuint; value: GLenum; data: PGLint);stdcall;
  TglGetLightfv = procedure(light: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetLightiv = procedure(light: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetLightxOES = procedure(light: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglGetLightxv = procedure(light: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglGetLightxvOES = procedure(light: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglGetListParameterfvSGIX = procedure(list: GLuint; pname: GLenum; params: PGLfloat);stdcall;
  TglGetListParameterivSGIX = procedure(list: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetLocalConstantBooleanvEXT = procedure(id: GLuint; value: GLenum; data: PGLboolean);stdcall;
  TglGetLocalConstantFloatvEXT = procedure(id: GLuint; value: GLenum; data: PGLfloat);stdcall;
  TglGetLocalConstantIntegervEXT = procedure(id: GLuint; value: GLenum; data: PGLint);stdcall;
  TglGetMapAttribParameterfvNV = procedure(target: GLenum; index_: GLuint; pname: GLenum; params: PGLfloat);stdcall;
  TglGetMapAttribParameterivNV = procedure(target: GLenum; index_: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetMapControlPointsNV = procedure(target: GLenum; index_: GLuint; type_: GLenum; ustride: GLsizei; vstride: GLsizei; packed_: GLboolean; points: Pvoid);stdcall;
  TglGetMapParameterfvNV = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetMapParameterivNV = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetMapdv = procedure(target: GLenum; query: GLenum; v: PGLdouble);stdcall;
  TglGetMapfv = procedure(target: GLenum; query: GLenum; v: PGLfloat);stdcall;
  TglGetMapiv = procedure(target: GLenum; query: GLenum; v: PGLint);stdcall;
  TglGetMapxvOES = procedure(target: GLenum; query: GLenum; v: PGLfixed);stdcall;
  TglGetMaterialfv = procedure(face: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetMaterialiv = procedure(face: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetMaterialxOES = procedure(face: GLenum; pname: GLenum; param: GLfixed);stdcall;
  TglGetMaterialxv = procedure(face: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglGetMaterialxvOES = procedure(face: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglGetMemoryObjectParameterivEXT = procedure(memoryObject: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetMinmax = procedure(target: GLenum; reset: GLboolean; format: GLenum; type_: GLenum; values: Pvoid);stdcall;
  TglGetMinmaxEXT = procedure(target: GLenum; reset: GLboolean; format: GLenum; type_: GLenum; values: Pvoid);stdcall;
  TglGetMinmaxParameterfv = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetMinmaxParameterfvEXT = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetMinmaxParameteriv = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetMinmaxParameterivEXT = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetMultiTexEnvfvEXT = procedure(texunit: GLenum; target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetMultiTexEnvivEXT = procedure(texunit: GLenum; target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetMultiTexGendvEXT = procedure(texunit: GLenum; coord: GLenum; pname: GLenum; params: PGLdouble);stdcall;
  TglGetMultiTexGenfvEXT = procedure(texunit: GLenum; coord: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetMultiTexGenivEXT = procedure(texunit: GLenum; coord: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetMultiTexImageEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglGetMultiTexLevelParameterfvEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; pname: GLenum; params: PGLfloat);stdcall;
  TglGetMultiTexLevelParameterivEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; pname: GLenum; params: PGLint);stdcall;
  TglGetMultiTexParameterIivEXT = procedure(texunit: GLenum; target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetMultiTexParameterIuivEXT = procedure(texunit: GLenum; target: GLenum; pname: GLenum; params: PGLuint);stdcall;
  TglGetMultiTexParameterfvEXT = procedure(texunit: GLenum; target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetMultiTexParameterivEXT = procedure(texunit: GLenum; target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetMultisamplefv = procedure(pname: GLenum; index_: GLuint; val: PGLfloat);stdcall;
  TglGetMultisamplefvNV = procedure(pname: GLenum; index_: GLuint; val: PGLfloat);stdcall;
  TglGetNamedBufferParameteri64v = procedure(buffer: GLuint; pname: GLenum; params: PGLint64);stdcall;
  TglGetNamedBufferParameteriv = procedure(buffer: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetNamedBufferParameterivEXT = procedure(buffer: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetNamedBufferParameterui64vNV = procedure(buffer: GLuint; pname: GLenum; params: PGLuint64EXT);stdcall;
  TglGetNamedBufferPointerv = procedure(buffer: GLuint; pname: GLenum; params: PPvoid);stdcall;
  TglGetNamedBufferPointervEXT = procedure(buffer: GLuint; pname: GLenum; params: PPvoid);stdcall;
  TglGetNamedBufferSubData = procedure(buffer: GLuint; offset: GLintptr; size: GLsizeiptr; data: Pvoid);stdcall;
  TglGetNamedBufferSubDataEXT = procedure(buffer: GLuint; offset: GLintptr; size: GLsizeiptr; data: Pvoid);stdcall;
  TglGetNamedFramebufferParameterfvAMD = procedure(framebuffer: GLuint; pname: GLenum; numsamples: GLuint; pixelindex: GLuint; size: GLsizei; values: PGLfloat);stdcall;
  TglGetNamedFramebufferAttachmentParameteriv = procedure(framebuffer: GLuint; attachment: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetNamedFramebufferAttachmentParameterivEXT = procedure(framebuffer: GLuint; attachment: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetNamedFramebufferParameteriv = procedure(framebuffer: GLuint; pname: GLenum; param: PGLint);stdcall;
  TglGetNamedFramebufferParameterivEXT = procedure(framebuffer: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetNamedProgramLocalParameterIivEXT = procedure(program_: GLuint; target: GLenum; index_: GLuint; params: PGLint);stdcall;
  TglGetNamedProgramLocalParameterIuivEXT = procedure(program_: GLuint; target: GLenum; index_: GLuint; params: PGLuint);stdcall;
  TglGetNamedProgramLocalParameterdvEXT = procedure(program_: GLuint; target: GLenum; index_: GLuint; params: PGLdouble);stdcall;
  TglGetNamedProgramLocalParameterfvEXT = procedure(program_: GLuint; target: GLenum; index_: GLuint; params: PGLfloat);stdcall;
  TglGetNamedProgramStringEXT = procedure(program_: GLuint; target: GLenum; pname: GLenum; string_: Pvoid);stdcall;
  TglGetNamedProgramivEXT = procedure(program_: GLuint; target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetNamedRenderbufferParameteriv = procedure(renderbuffer: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetNamedRenderbufferParameterivEXT = procedure(renderbuffer: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetNamedStringARB = procedure(namelen: GLint; name_: PGLchar; bufSize: GLsizei; stringlen: PGLint; string_: PGLchar);stdcall;
  TglGetNamedStringivARB = procedure(namelen: GLint; name_: PGLchar; pname: GLenum; params: PGLint);stdcall;
  TglGetNextPerfQueryIdINTEL = procedure(queryId: GLuint; nextQueryId: PGLuint);stdcall;
  TglGetObjectBufferfvATI = procedure(buffer: GLuint; pname: GLenum; params: PGLfloat);stdcall;
  TglGetObjectBufferivATI = procedure(buffer: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetObjectLabel = procedure(identifier: GLenum; name_: GLuint; bufSize: GLsizei; length: PGLsizei; label_: PGLchar);stdcall;
  TglGetObjectLabelEXT = procedure(type_: GLenum; object_: GLuint; bufSize: GLsizei; length: PGLsizei; label_: PGLchar);stdcall;
  TglGetObjectLabelKHR = procedure(identifier: GLenum; name_: GLuint; bufSize: GLsizei; length: PGLsizei; label_: PGLchar);stdcall;
  TglGetObjectParameterfvARB = procedure(obj: GLhandleARB; pname: GLenum; params: PGLfloat);stdcall;
  TglGetObjectParameterivAPPLE = procedure(objectType: GLenum; name_: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetObjectParameterivARB = procedure(obj: GLhandleARB; pname: GLenum; params: PGLint);stdcall;
  TglGetObjectPtrLabel = procedure(ptr: Pvoid; bufSize: GLsizei; length: PGLsizei; label_: PGLchar);stdcall;
  TglGetObjectPtrLabelKHR = procedure(ptr: Pvoid; bufSize: GLsizei; length: PGLsizei; label_: PGLchar);stdcall;
  TglGetOcclusionQueryivNV = procedure(id: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetOcclusionQueryuivNV = procedure(id: GLuint; pname: GLenum; params: PGLuint);stdcall;
  TglGetPathColorGenfvNV = procedure(color: GLenum; pname: GLenum; value: PGLfloat);stdcall;
  TglGetPathColorGenivNV = procedure(color: GLenum; pname: GLenum; value: PGLint);stdcall;
  TglGetPathCommandsNV = procedure(path: GLuint; commands: PGLubyte);stdcall;
  TglGetPathCoordsNV = procedure(path: GLuint; coords: PGLfloat);stdcall;
  TglGetPathDashArrayNV = procedure(path: GLuint; dashArray: PGLfloat);stdcall;
  TglGetPathLengthNV = function(path: GLuint; startSegment: GLsizei; numSegments: GLsizei): GLfloat;stdcall;
  TglGetPathMetricRangeNV = procedure(metricQueryMask: GLbitfield; firstPathName: GLuint; numPaths: GLsizei; stride: GLsizei; metrics: PGLfloat);stdcall;
  TglGetPathMetricsNV = procedure(metricQueryMask: GLbitfield; numPaths: GLsizei; pathNameType: GLenum; paths: Pvoid; pathBase: GLuint; stride: GLsizei; metrics: PGLfloat);stdcall;
  TglGetPathParameterfvNV = procedure(path: GLuint; pname: GLenum; value: PGLfloat);stdcall;
  TglGetPathParameterivNV = procedure(path: GLuint; pname: GLenum; value: PGLint);stdcall;
  TglGetPathSpacingNV = procedure(pathListMode: GLenum; numPaths: GLsizei; pathNameType: GLenum; paths: Pvoid; pathBase: GLuint; advanceScale: GLfloat; kerningScale: GLfloat; transformType: GLenum; returnedSpacing: PGLfloat);stdcall;
  TglGetPathTexGenfvNV = procedure(texCoordSet: GLenum; pname: GLenum; value: PGLfloat);stdcall;
  TglGetPathTexGenivNV = procedure(texCoordSet: GLenum; pname: GLenum; value: PGLint);stdcall;
  TglGetPerfCounterInfoINTEL = procedure(queryId: GLuint; counterId: GLuint; counterNameLength: GLuint; counterName: PGLchar; counterDescLength: GLuint; counterDesc: PGLchar; counterOffset: PGLuint; counterDataSize: PGLuint;
    counterTypeEnum: PGLuint; counterDataTypeEnum: PGLuint; rawCounterMaxValue: PGLuint64);stdcall;
  TglGetPerfMonitorCounterDataAMD = procedure(monitor: GLuint; pname: GLenum; dataSize: GLsizei; data: PGLuint; bytesWritten: PGLint);stdcall;
  TglGetPerfMonitorCounterInfoAMD = procedure(group: GLuint; counter: GLuint; pname: GLenum; data: Pvoid);stdcall;
  TglGetPerfMonitorCounterStringAMD = procedure(group: GLuint; counter: GLuint; bufSize: GLsizei; length: PGLsizei; counterString: PGLchar);stdcall;
  TglGetPerfMonitorCountersAMD = procedure(group: GLuint; numCounters: PGLint; maxActiveCounters: PGLint; counterSize: GLsizei; counters: PGLuint);stdcall;
  TglGetPerfMonitorGroupStringAMD = procedure(group: GLuint; bufSize: GLsizei; length: PGLsizei; groupString: PGLchar);stdcall;
  TglGetPerfMonitorGroupsAMD = procedure(numGroups: PGLint; groupsSize: GLsizei; groups: PGLuint);stdcall;
  TglGetPerfQueryDataINTEL = procedure(queryHandle: GLuint; flags: GLuint; dataSize: GLsizei; data: PGLvoid; bytesWritten: PGLuint);stdcall;
  TglGetPerfQueryIdByNameINTEL = procedure(queryName: PGLchar; queryId: PGLuint);stdcall;
  TglGetPerfQueryInfoINTEL = procedure(queryId: GLuint; queryNameLength: GLuint; queryName: PGLchar; dataSize: PGLuint; noCounters: PGLuint; noInstances: PGLuint; capsMask: PGLuint);stdcall;
  TglGetPixelMapfv = procedure(map: GLenum; values: PGLfloat);stdcall;
  TglGetPixelMapuiv = procedure(map: GLenum; values: PGLuint);stdcall;
  TglGetPixelMapusv = procedure(map: GLenum; values: PGLushort);stdcall;
  TglGetPixelMapxv = procedure(map: GLenum; size: GLint; values: PGLfixed);stdcall;
  TglGetPixelTexGenParameterfvSGIS = procedure(pname: GLenum; params: PGLfloat);stdcall;
  TglGetPixelTexGenParameterivSGIS = procedure(pname: GLenum; params: PGLint);stdcall;
  TglGetPixelTransformParameterfvEXT = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetPixelTransformParameterivEXT = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetPointerIndexedvEXT = procedure(target: GLenum; index_: GLuint; data: PPvoid);stdcall;
  TglGetPointeri_vEXT = procedure(pname: GLenum; index_: GLuint; params: PPvoid);stdcall;
  TglGetPointerv = procedure(pname: GLenum; params: PPvoid);stdcall;
  TglGetPointervEXT = procedure(pname: GLenum; params: PPvoid);stdcall;
  TglGetPointervKHR = procedure(pname: GLenum; params: PPvoid);stdcall;
  TglGetPolygonStipple = procedure(mask: PGLubyte);stdcall;
  TglGetProgramBinary = procedure(program_: GLuint; bufSize: GLsizei; length: PGLsizei; binaryFormat: PGLenum; binary: Pvoid);stdcall;
  TglGetProgramBinaryOES = procedure(program_: GLuint; bufSize: GLsizei; length: PGLsizei; binaryFormat: PGLenum; binary: Pvoid);stdcall;
  TglGetProgramEnvParameterIivNV = procedure(target: GLenum; index_: GLuint; params: PGLint);stdcall;
  TglGetProgramEnvParameterIuivNV = procedure(target: GLenum; index_: GLuint; params: PGLuint);stdcall;
  TglGetProgramEnvParameterdvARB = procedure(target: GLenum; index_: GLuint; params: PGLdouble);stdcall;
  TglGetProgramEnvParameterfvARB = procedure(target: GLenum; index_: GLuint; params: PGLfloat);stdcall;
  TglGetProgramInfoLog = procedure(program_: GLuint; bufSize: GLsizei; length: PGLsizei; infoLog: PGLchar);stdcall;
  TglGetProgramInterfaceiv = procedure(program_: GLuint; programInterface: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetProgramLocalParameterIivNV = procedure(target: GLenum; index_: GLuint; params: PGLint);stdcall;
  TglGetProgramLocalParameterIuivNV = procedure(target: GLenum; index_: GLuint; params: PGLuint);stdcall;
  TglGetProgramLocalParameterdvARB = procedure(target: GLenum; index_: GLuint; params: PGLdouble);stdcall;
  TglGetProgramLocalParameterfvARB = procedure(target: GLenum; index_: GLuint; params: PGLfloat);stdcall;
  TglGetProgramNamedParameterdvNV = procedure(id: GLuint; len: GLsizei; name_: PGLubyte; params: PGLdouble);stdcall;
  TglGetProgramNamedParameterfvNV = procedure(id: GLuint; len: GLsizei; name_: PGLubyte; params: PGLfloat);stdcall;
  TglGetProgramParameterdvNV = procedure(target: GLenum; index_: GLuint; pname: GLenum; params: PGLdouble);stdcall;
  TglGetProgramParameterfvNV = procedure(target: GLenum; index_: GLuint; pname: GLenum; params: PGLfloat);stdcall;
  TglGetProgramPipelineInfoLog = procedure(pipeline: GLuint; bufSize: GLsizei; length: PGLsizei; infoLog: PGLchar);stdcall;
  TglGetProgramPipelineInfoLogEXT = procedure(pipeline: GLuint; bufSize: GLsizei; length: PGLsizei; infoLog: PGLchar);stdcall;
  TglGetProgramPipelineiv = procedure(pipeline: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetProgramPipelineivEXT = procedure(pipeline: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetProgramResourceIndex = function(program_: GLuint; programInterface: GLenum; name_: PGLchar): GLuint;stdcall;
  TglGetProgramResourceLocation = function(program_: GLuint; programInterface: GLenum; name_: PGLchar): GLint;stdcall;
  TglGetProgramResourceLocationIndex = function(program_: GLuint; programInterface: GLenum; name_: PGLchar): GLint;stdcall;
  TglGetProgramResourceLocationIndexEXT = function(program_: GLuint; programInterface: GLenum; name_: PGLchar): GLint;stdcall;
  TglGetProgramResourceName = procedure(program_: GLuint; programInterface: GLenum; index_: GLuint; bufSize: GLsizei; length: PGLsizei; name_: PGLchar);stdcall;
  TglGetProgramResourcefvNV = procedure(program_: GLuint; programInterface: GLenum; index_: GLuint; propCount: GLsizei; props: PGLenum; bufSize: GLsizei; length: PGLsizei; params: PGLfloat);stdcall;
  TglGetProgramResourceiv = procedure(program_: GLuint; programInterface: GLenum; index_: GLuint; propCount: GLsizei; props: PGLenum; bufSize: GLsizei; length: PGLsizei; params: PGLint);stdcall;
  TglGetProgramStageiv = procedure(program_: GLuint; shadertype: GLenum; pname: GLenum; values: PGLint);stdcall;
  TglGetProgramStringARB = procedure(target: GLenum; pname: GLenum; string_: Pvoid);stdcall;
  TglGetProgramStringNV = procedure(id: GLuint; pname: GLenum; program_: PGLubyte);stdcall;
  TglGetProgramSubroutineParameteruivNV = procedure(target: GLenum; index_: GLuint; param: PGLuint);stdcall;
  TglGetProgramiv = procedure(program_: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetProgramivARB = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetProgramivNV = procedure(id: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetQueryBufferObjecti64v = procedure(id: GLuint; buffer: GLuint; pname: GLenum; offset: GLintptr);stdcall;
  TglGetQueryBufferObjectiv = procedure(id: GLuint; buffer: GLuint; pname: GLenum; offset: GLintptr);stdcall;
  TglGetQueryBufferObjectui64v = procedure(id: GLuint; buffer: GLuint; pname: GLenum; offset: GLintptr);stdcall;
  TglGetQueryBufferObjectuiv = procedure(id: GLuint; buffer: GLuint; pname: GLenum; offset: GLintptr);stdcall;
  TglGetQueryIndexediv = procedure(target: GLenum; index_: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetQueryObjecti64v = procedure(id: GLuint; pname: GLenum; params: PGLint64);stdcall;
  TglGetQueryObjecti64vEXT = procedure(id: GLuint; pname: GLenum; params: PGLint64);stdcall;
  TglGetQueryObjectiv = procedure(id: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetQueryObjectivARB = procedure(id: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetQueryObjectivEXT = procedure(id: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetQueryObjectui64v = procedure(id: GLuint; pname: GLenum; params: PGLuint64);stdcall;
  TglGetQueryObjectui64vEXT = procedure(id: GLuint; pname: GLenum; params: PGLuint64);stdcall;
  TglGetQueryObjectuiv = procedure(id: GLuint; pname: GLenum; params: PGLuint);stdcall;
  TglGetQueryObjectuivARB = procedure(id: GLuint; pname: GLenum; params: PGLuint);stdcall;
  TglGetQueryObjectuivEXT = procedure(id: GLuint; pname: GLenum; params: PGLuint);stdcall;
  TglGetQueryiv = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetQueryivARB = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetQueryivEXT = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetRenderbufferParameteriv = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetRenderbufferParameterivEXT = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetRenderbufferParameterivOES = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetSamplerParameterIiv = procedure(sampler: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetSamplerParameterIivEXT = procedure(sampler: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetSamplerParameterIivOES = procedure(sampler: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetSamplerParameterIuiv = procedure(sampler: GLuint; pname: GLenum; params: PGLuint);stdcall;
  TglGetSamplerParameterIuivEXT = procedure(sampler: GLuint; pname: GLenum; params: PGLuint);stdcall;
  TglGetSamplerParameterIuivOES = procedure(sampler: GLuint; pname: GLenum; params: PGLuint);stdcall;
  TglGetSamplerParameterfv = procedure(sampler: GLuint; pname: GLenum; params: PGLfloat);stdcall;
  TglGetSamplerParameteriv = procedure(sampler: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetSemaphoreParameterui64vEXT = procedure(semaphore: GLuint; pname: GLenum; params: PGLuint64);stdcall;
  TglGetSeparableFilter = procedure(target: GLenum; format: GLenum; type_: GLenum; row: Pvoid; column: Pvoid; span: Pvoid);stdcall;
  TglGetSeparableFilterEXT = procedure(target: GLenum; format: GLenum; type_: GLenum; row: Pvoid; column: Pvoid; span: Pvoid);stdcall;
  TglGetShaderInfoLog = procedure(shader: GLuint; bufSize: GLsizei; length: PGLsizei; infoLog: PGLchar);stdcall;
  TglGetShaderPrecisionFormat = procedure(shadertype: GLenum; precisiontype: GLenum; range: PGLint; precision: PGLint);stdcall;
  TglGetShaderSource = procedure(shader: GLuint; bufSize: GLsizei; length: PGLsizei; source: PGLchar);stdcall;
  TglGetShaderSourceARB = procedure(obj: GLhandleARB; maxLength: GLsizei; length: PGLsizei; source: PGLcharARB);stdcall;
  TglGetShaderiv = procedure(shader: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetSharpenTexFuncSGIS = procedure(target: GLenum; points: PGLfloat);stdcall;
  TglGetStageIndexNV = function(shadertype: GLenum): GLushort;stdcall;
  TglGetString = function(name_: GLenum): PGLubyte;stdcall;
  TglGetStringi = function(name_: GLenum; index_: GLuint): PGLubyte;stdcall;
  TglGetSubroutineIndex = function(program_: GLuint; shadertype: GLenum; name_: PGLchar): GLuint;stdcall;
  TglGetSubroutineUniformLocation = function(program_: GLuint; shadertype: GLenum; name_: PGLchar): GLint;stdcall;
  TglGetSynciv = procedure(sync: GLsync; pname: GLenum; bufSize: GLsizei; length: PGLsizei; values: PGLint);stdcall;
  TglGetSyncivAPPLE = procedure(sync: GLsync; pname: GLenum; bufSize: GLsizei; length: PGLsizei; values: PGLint);stdcall;
  TglGetTexBumpParameterfvATI = procedure(pname: GLenum; param: PGLfloat);stdcall;
  TglGetTexBumpParameterivATI = procedure(pname: GLenum; param: PGLint);stdcall;
  TglGetTexEnvfv = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetTexEnviv = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetTexEnvxv = procedure(target: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglGetTexEnvxvOES = procedure(target: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglGetTexFilterFuncSGIS = procedure(target: GLenum; filter: GLenum; weights: PGLfloat);stdcall;
  TglGetTexGendv = procedure(coord: GLenum; pname: GLenum; params: PGLdouble);stdcall;
  TglGetTexGenfv = procedure(coord: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetTexGenfvOES = procedure(coord: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetTexGeniv = procedure(coord: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetTexGenivOES = procedure(coord: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetTexGenxvOES = procedure(coord: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglGetTexImage = procedure(target: GLenum; level: GLint; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglGetTexLevelParameterfv = procedure(target: GLenum; level: GLint; pname: GLenum; params: PGLfloat);stdcall;
  TglGetTexLevelParameteriv = procedure(target: GLenum; level: GLint; pname: GLenum; params: PGLint);stdcall;
  TglGetTexLevelParameterxvOES = procedure(target: GLenum; level: GLint; pname: GLenum; params: PGLfixed);stdcall;
  TglGetTexParameterIiv = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetTexParameterIivEXT = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetTexParameterIivOES = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetTexParameterIuiv = procedure(target: GLenum; pname: GLenum; params: PGLuint);stdcall;
  TglGetTexParameterIuivEXT = procedure(target: GLenum; pname: GLenum; params: PGLuint);stdcall;
  TglGetTexParameterIuivOES = procedure(target: GLenum; pname: GLenum; params: PGLuint);stdcall;
  TglGetTexParameterPointervAPPLE = procedure(target: GLenum; pname: GLenum; params: PPvoid);stdcall;
  TglGetTexParameterfv = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetTexParameteriv = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetTexParameterxv = procedure(target: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglGetTexParameterxvOES = procedure(target: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglGetTextureHandleARB = function(texture: GLuint): GLuint64;stdcall;
  TglGetTextureHandleIMG = function(texture: GLuint): GLuint64;stdcall;
  TglGetTextureHandleNV = function(texture: GLuint): GLuint64;stdcall;
  TglGetTextureImage = procedure(texture: GLuint; level: GLint; format: GLenum; type_: GLenum; bufSize: GLsizei; pixels: Pvoid);stdcall;
  TglGetTextureImageEXT = procedure(texture: GLuint; target: GLenum; level: GLint; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglGetTextureLevelParameterfv = procedure(texture: GLuint; level: GLint; pname: GLenum; params: PGLfloat);stdcall;
  TglGetTextureLevelParameterfvEXT = procedure(texture: GLuint; target: GLenum; level: GLint; pname: GLenum; params: PGLfloat);stdcall;
  TglGetTextureLevelParameteriv = procedure(texture: GLuint; level: GLint; pname: GLenum; params: PGLint);stdcall;
  TglGetTextureLevelParameterivEXT = procedure(texture: GLuint; target: GLenum; level: GLint; pname: GLenum; params: PGLint);stdcall;
  TglGetTextureParameterIiv = procedure(texture: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetTextureParameterIivEXT = procedure(texture: GLuint; target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetTextureParameterIuiv = procedure(texture: GLuint; pname: GLenum; params: PGLuint);stdcall;
  TglGetTextureParameterIuivEXT = procedure(texture: GLuint; target: GLenum; pname: GLenum; params: PGLuint);stdcall;
  TglGetTextureParameterfv = procedure(texture: GLuint; pname: GLenum; params: PGLfloat);stdcall;
  TglGetTextureParameterfvEXT = procedure(texture: GLuint; target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglGetTextureParameteriv = procedure(texture: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetTextureParameterivEXT = procedure(texture: GLuint; target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglGetTextureSamplerHandleARB = function(texture: GLuint; sampler: GLuint): GLuint64;stdcall;
  TglGetTextureSamplerHandleIMG = function(texture: GLuint; sampler: GLuint): GLuint64;stdcall;
  TglGetTextureSamplerHandleNV = function(texture: GLuint; sampler: GLuint): GLuint64;stdcall;
  TglGetTextureSubImage = procedure(texture: GLuint; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; type_: GLenum; bufSize: GLsizei; pixels: Pvoid);stdcall;
  TglGetTrackMatrixivNV = procedure(target: GLenum; address: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetTransformFeedbackVarying = procedure(program_: GLuint; index_: GLuint; bufSize: GLsizei; length: PGLsizei; size: PGLsizei; type_: PGLenum; name_: PGLchar);stdcall;
  TglGetTransformFeedbackVaryingEXT = procedure(program_: GLuint; index_: GLuint; bufSize: GLsizei; length: PGLsizei; size: PGLsizei; type_: PGLenum; name_: PGLchar);stdcall;
  TglGetTransformFeedbackVaryingNV = procedure(program_: GLuint; index_: GLuint; location: PGLint);stdcall;
  TglGetTransformFeedbacki64_v = procedure(xfb: GLuint; pname: GLenum; index_: GLuint; param: PGLint64);stdcall;
  TglGetTransformFeedbacki_v = procedure(xfb: GLuint; pname: GLenum; index_: GLuint; param: PGLint);stdcall;
  TglGetTransformFeedbackiv = procedure(xfb: GLuint; pname: GLenum; param: PGLint);stdcall;
  TglGetTranslatedShaderSourceANGLE = procedure(shader: GLuint; bufsize: GLsizei; length: PGLsizei; source: PGLchar);stdcall;
  TglGetUniformBlockIndex = function(program_: GLuint; uniformBlockName: PGLchar): GLuint;stdcall;
  TglGetUniformBufferSizeEXT = function(program_: GLuint; location: GLint): GLint;stdcall;
  TglGetUniformIndices = procedure(program_: GLuint; uniformCount: GLsizei; uniformNames: PPGLchar; uniformIndices: PGLuint);stdcall;
  TglGetUniformLocation = function(program_: GLuint; name_: PGLchar): GLint;stdcall;
  TglGetUniformLocationARB = function(programObj: GLhandleARB; name_: PGLcharARB): GLint;stdcall;
  TglGetUniformOffsetEXT = function(program_: GLuint; location: GLint): GLintptr;stdcall;
  TglGetUniformSubroutineuiv = procedure(shadertype: GLenum; location: GLint; params: PGLuint);stdcall;
  TglGetUniformdv = procedure(program_: GLuint; location: GLint; params: PGLdouble);stdcall;
  TglGetUniformfv = procedure(program_: GLuint; location: GLint; params: PGLfloat);stdcall;
  TglGetUniformfvARB = procedure(programObj: GLhandleARB; location: GLint; params: PGLfloat);stdcall;
  TglGetUniformi64vARB = procedure(program_: GLuint; location: GLint; params: PGLint64);stdcall;
  TglGetUniformi64vNV = procedure(program_: GLuint; location: GLint; params: PGLint64EXT);stdcall;
  TglGetUniformiv = procedure(program_: GLuint; location: GLint; params: PGLint);stdcall;
  TglGetUniformivARB = procedure(programObj: GLhandleARB; location: GLint; params: PGLint);stdcall;
  TglGetUniformui64vARB = procedure(program_: GLuint; location: GLint; params: PGLuint64);stdcall;
  TglGetUniformui64vNV = procedure(program_: GLuint; location: GLint; params: PGLuint64EXT);stdcall;
  TglGetUniformuiv = procedure(program_: GLuint; location: GLint; params: PGLuint);stdcall;
  TglGetUniformuivEXT = procedure(program_: GLuint; location: GLint; params: PGLuint);stdcall;
  TglGetUnsignedBytevEXT = procedure(pname: GLenum; data: PGLubyte);stdcall;
  TglGetUnsignedBytei_vEXT = procedure(target: GLenum; index_: GLuint; data: PGLubyte);stdcall;
  TglGetVariantArrayObjectfvATI = procedure(id: GLuint; pname: GLenum; params: PGLfloat);stdcall;
  TglGetVariantArrayObjectivATI = procedure(id: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetVariantBooleanvEXT = procedure(id: GLuint; value: GLenum; data: PGLboolean);stdcall;
  TglGetVariantFloatvEXT = procedure(id: GLuint; value: GLenum; data: PGLfloat);stdcall;
  TglGetVariantIntegervEXT = procedure(id: GLuint; value: GLenum; data: PGLint);stdcall;
  TglGetVariantPointervEXT = procedure(id: GLuint; value: GLenum; data: PPvoid);stdcall;
  TglGetVaryingLocationNV = function(program_: GLuint; name_: PGLchar): GLint;stdcall;
  TglGetVertexArrayIndexed64iv = procedure(vaobj: GLuint; index_: GLuint; pname: GLenum; param: PGLint64);stdcall;
  TglGetVertexArrayIndexediv = procedure(vaobj: GLuint; index_: GLuint; pname: GLenum; param: PGLint);stdcall;
  TglGetVertexArrayIntegeri_vEXT = procedure(vaobj: GLuint; index_: GLuint; pname: GLenum; param: PGLint);stdcall;
  TglGetVertexArrayIntegervEXT = procedure(vaobj: GLuint; pname: GLenum; param: PGLint);stdcall;
  TglGetVertexArrayPointeri_vEXT = procedure(vaobj: GLuint; index_: GLuint; pname: GLenum; param: PPvoid);stdcall;
  TglGetVertexArrayPointervEXT = procedure(vaobj: GLuint; pname: GLenum; param: PPvoid);stdcall;
  TglGetVertexArrayiv = procedure(vaobj: GLuint; pname: GLenum; param: PGLint);stdcall;
  TglGetVertexAttribArrayObjectfvATI = procedure(index_: GLuint; pname: GLenum; params: PGLfloat);stdcall;
  TglGetVertexAttribArrayObjectivATI = procedure(index_: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetVertexAttribIiv = procedure(index_: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetVertexAttribIivEXT = procedure(index_: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetVertexAttribIuiv = procedure(index_: GLuint; pname: GLenum; params: PGLuint);stdcall;
  TglGetVertexAttribIuivEXT = procedure(index_: GLuint; pname: GLenum; params: PGLuint);stdcall;
  TglGetVertexAttribLdv = procedure(index_: GLuint; pname: GLenum; params: PGLdouble);stdcall;
  TglGetVertexAttribLdvEXT = procedure(index_: GLuint; pname: GLenum; params: PGLdouble);stdcall;
  TglGetVertexAttribLi64vNV = procedure(index_: GLuint; pname: GLenum; params: PGLint64EXT);stdcall;
  TglGetVertexAttribLui64vARB = procedure(index_: GLuint; pname: GLenum; params: PGLuint64EXT);stdcall;
  TglGetVertexAttribLui64vNV = procedure(index_: GLuint; pname: GLenum; params: PGLuint64EXT);stdcall;
  TglGetVertexAttribPointerv = procedure(index_: GLuint; pname: GLenum; pointer: PPvoid);stdcall;
  TglGetVertexAttribPointervARB = procedure(index_: GLuint; pname: GLenum; pointer: PPvoid);stdcall;
  TglGetVertexAttribPointervNV = procedure(index_: GLuint; pname: GLenum; pointer: PPvoid);stdcall;
  TglGetVertexAttribdv = procedure(index_: GLuint; pname: GLenum; params: PGLdouble);stdcall;
  TglGetVertexAttribdvARB = procedure(index_: GLuint; pname: GLenum; params: PGLdouble);stdcall;
  TglGetVertexAttribdvNV = procedure(index_: GLuint; pname: GLenum; params: PGLdouble);stdcall;
  TglGetVertexAttribfv = procedure(index_: GLuint; pname: GLenum; params: PGLfloat);stdcall;
  TglGetVertexAttribfvARB = procedure(index_: GLuint; pname: GLenum; params: PGLfloat);stdcall;
  TglGetVertexAttribfvNV = procedure(index_: GLuint; pname: GLenum; params: PGLfloat);stdcall;
  TglGetVertexAttribiv = procedure(index_: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetVertexAttribivARB = procedure(index_: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetVertexAttribivNV = procedure(index_: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetVideoCaptureStreamdvNV = procedure(video_capture_slot: GLuint; stream: GLuint; pname: GLenum; params: PGLdouble);stdcall;
  TglGetVideoCaptureStreamfvNV = procedure(video_capture_slot: GLuint; stream: GLuint; pname: GLenum; params: PGLfloat);stdcall;
  TglGetVideoCaptureStreamivNV = procedure(video_capture_slot: GLuint; stream: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetVideoCaptureivNV = procedure(video_capture_slot: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetVideoi64vNV = procedure(video_slot: GLuint; pname: GLenum; params: PGLint64EXT);stdcall;
  TglGetVideoivNV = procedure(video_slot: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglGetVideoui64vNV = procedure(video_slot: GLuint; pname: GLenum; params: PGLuint64EXT);stdcall;
  TglGetVideouivNV = procedure(video_slot: GLuint; pname: GLenum; params: PGLuint);stdcall;
  TglGetnColorTable = procedure(target: GLenum; format: GLenum; type_: GLenum; bufSize: GLsizei; table: Pvoid);stdcall;
  TglGetnColorTableARB = procedure(target: GLenum; format: GLenum; type_: GLenum; bufSize: GLsizei; table: Pvoid);stdcall;
  TglGetnCompressedTexImage = procedure(target: GLenum; lod: GLint; bufSize: GLsizei; pixels: Pvoid);stdcall;
  TglGetnCompressedTexImageARB = procedure(target: GLenum; lod: GLint; bufSize: GLsizei; img: Pvoid);stdcall;
  TglGetnConvolutionFilter = procedure(target: GLenum; format: GLenum; type_: GLenum; bufSize: GLsizei; image: Pvoid);stdcall;
  TglGetnConvolutionFilterARB = procedure(target: GLenum; format: GLenum; type_: GLenum; bufSize: GLsizei; image: Pvoid);stdcall;
  TglGetnHistogram = procedure(target: GLenum; reset: GLboolean; format: GLenum; type_: GLenum; bufSize: GLsizei; values: Pvoid);stdcall;
  TglGetnHistogramARB = procedure(target: GLenum; reset: GLboolean; format: GLenum; type_: GLenum; bufSize: GLsizei; values: Pvoid);stdcall;
  TglGetnMapdv = procedure(target: GLenum; query: GLenum; bufSize: GLsizei; v: PGLdouble);stdcall;
  TglGetnMapdvARB = procedure(target: GLenum; query: GLenum; bufSize: GLsizei; v: PGLdouble);stdcall;
  TglGetnMapfv = procedure(target: GLenum; query: GLenum; bufSize: GLsizei; v: PGLfloat);stdcall;
  TglGetnMapfvARB = procedure(target: GLenum; query: GLenum; bufSize: GLsizei; v: PGLfloat);stdcall;
  TglGetnMapiv = procedure(target: GLenum; query: GLenum; bufSize: GLsizei; v: PGLint);stdcall;
  TglGetnMapivARB = procedure(target: GLenum; query: GLenum; bufSize: GLsizei; v: PGLint);stdcall;
  TglGetnMinmax = procedure(target: GLenum; reset: GLboolean; format: GLenum; type_: GLenum; bufSize: GLsizei; values: Pvoid);stdcall;
  TglGetnMinmaxARB = procedure(target: GLenum; reset: GLboolean; format: GLenum; type_: GLenum; bufSize: GLsizei; values: Pvoid);stdcall;
  TglGetnPixelMapfv = procedure(map: GLenum; bufSize: GLsizei; values: PGLfloat);stdcall;
  TglGetnPixelMapfvARB = procedure(map: GLenum; bufSize: GLsizei; values: PGLfloat);stdcall;
  TglGetnPixelMapuiv = procedure(map: GLenum; bufSize: GLsizei; values: PGLuint);stdcall;
  TglGetnPixelMapuivARB = procedure(map: GLenum; bufSize: GLsizei; values: PGLuint);stdcall;
  TglGetnPixelMapusv = procedure(map: GLenum; bufSize: GLsizei; values: PGLushort);stdcall;
  TglGetnPixelMapusvARB = procedure(map: GLenum; bufSize: GLsizei; values: PGLushort);stdcall;
  TglGetnPolygonStipple = procedure(bufSize: GLsizei; pattern: PGLubyte);stdcall;
  TglGetnPolygonStippleARB = procedure(bufSize: GLsizei; pattern: PGLubyte);stdcall;
  TglGetnSeparableFilter = procedure(target: GLenum; format: GLenum; type_: GLenum; rowBufSize: GLsizei; row: Pvoid; columnBufSize: GLsizei; column: Pvoid; span: Pvoid);stdcall;
  TglGetnSeparableFilterARB = procedure(target: GLenum; format: GLenum; type_: GLenum; rowBufSize: GLsizei; row: Pvoid; columnBufSize: GLsizei; column: Pvoid; span: Pvoid);stdcall;
  TglGetnTexImage = procedure(target: GLenum; level: GLint; format: GLenum; type_: GLenum; bufSize: GLsizei; pixels: Pvoid);stdcall;
  TglGetnTexImageARB = procedure(target: GLenum; level: GLint; format: GLenum; type_: GLenum; bufSize: GLsizei; img: Pvoid);stdcall;
  TglGetnUniformdv = procedure(program_: GLuint; location: GLint; bufSize: GLsizei; params: PGLdouble);stdcall;
  TglGetnUniformdvARB = procedure(program_: GLuint; location: GLint; bufSize: GLsizei; params: PGLdouble);stdcall;
  TglGetnUniformfv = procedure(program_: GLuint; location: GLint; bufSize: GLsizei; params: PGLfloat);stdcall;
  TglGetnUniformfvARB = procedure(program_: GLuint; location: GLint; bufSize: GLsizei; params: PGLfloat);stdcall;
  TglGetnUniformfvEXT = procedure(program_: GLuint; location: GLint; bufSize: GLsizei; params: PGLfloat);stdcall;
  TglGetnUniformfvKHR = procedure(program_: GLuint; location: GLint; bufSize: GLsizei; params: PGLfloat);stdcall;
  TglGetnUniformi64vARB = procedure(program_: GLuint; location: GLint; bufSize: GLsizei; params: PGLint64);stdcall;
  TglGetnUniformiv = procedure(program_: GLuint; location: GLint; bufSize: GLsizei; params: PGLint);stdcall;
  TglGetnUniformivARB = procedure(program_: GLuint; location: GLint; bufSize: GLsizei; params: PGLint);stdcall;
  TglGetnUniformivEXT = procedure(program_: GLuint; location: GLint; bufSize: GLsizei; params: PGLint);stdcall;
  TglGetnUniformivKHR = procedure(program_: GLuint; location: GLint; bufSize: GLsizei; params: PGLint);stdcall;
  TglGetnUniformui64vARB = procedure(program_: GLuint; location: GLint; bufSize: GLsizei; params: PGLuint64);stdcall;
  TglGetnUniformuiv = procedure(program_: GLuint; location: GLint; bufSize: GLsizei; params: PGLuint);stdcall;
  TglGetnUniformuivARB = procedure(program_: GLuint; location: GLint; bufSize: GLsizei; params: PGLuint);stdcall;
  TglGetnUniformuivKHR = procedure(program_: GLuint; location: GLint; bufSize: GLsizei; params: PGLuint);stdcall;
  TglGlobalAlphaFactorbSUN = procedure(factor: GLbyte);stdcall;
  TglGlobalAlphaFactordSUN = procedure(factor: GLdouble);stdcall;
  TglGlobalAlphaFactorfSUN = procedure(factor: GLfloat);stdcall;
  TglGlobalAlphaFactoriSUN = procedure(factor: GLint);stdcall;
  TglGlobalAlphaFactorsSUN = procedure(factor: GLshort);stdcall;
  TglGlobalAlphaFactorubSUN = procedure(factor: GLubyte);stdcall;
  TglGlobalAlphaFactoruiSUN = procedure(factor: GLuint);stdcall;
  TglGlobalAlphaFactorusSUN = procedure(factor: GLushort);stdcall;
  TglHint = procedure(target: GLenum; mode: GLenum);stdcall;
  TglHintPGI = procedure(target: GLenum; mode: GLint);stdcall;
  TglHistogram = procedure(target: GLenum; width: GLsizei; internalformat: GLenum; sink: GLboolean);stdcall;
  TglHistogramEXT = procedure(target: GLenum; width: GLsizei; internalformat: GLenum; sink: GLboolean);stdcall;
  TglIglooInterfaceSGIX = procedure(pname: GLenum; params: Pvoid);stdcall;
  TglImageTransformParameterfHP = procedure(target: GLenum; pname: GLenum; param: GLfloat);stdcall;
  TglImageTransformParameterfvHP = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglImageTransformParameteriHP = procedure(target: GLenum; pname: GLenum; param: GLint);stdcall;
  TglImageTransformParameterivHP = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglImportMemoryFdEXT = procedure(memory: GLuint; size: GLuint64; handleType: GLenum; fd: GLint);stdcall;
  TglImportMemoryWin32HandleEXT = procedure(memory: GLuint; size: GLuint64; handleType: GLenum; handle: Pvoid);stdcall;
  TglImportMemoryWin32NameEXT = procedure(memory: GLuint; size: GLuint64; handleType: GLenum; name_: Pvoid);stdcall;
  TglImportSemaphoreFdEXT = procedure(semaphore: GLuint; handleType: GLenum; fd: GLint);stdcall;
  TglImportSemaphoreWin32HandleEXT = procedure(semaphore: GLuint; handleType: GLenum; handle: Pvoid);stdcall;
  TglImportSemaphoreWin32NameEXT = procedure(semaphore: GLuint; handleType: GLenum; name_: Pvoid);stdcall;
  TglImportSyncEXT = function(external_sync_type: GLenum; external_sync: GLintptr; flags: GLbitfield): GLsync;stdcall;
  TglIndexFormatNV = procedure(type_: GLenum; stride: GLsizei);stdcall;
  TglIndexFuncEXT = procedure(func: GLenum; ref: GLclampf);stdcall;
  TglIndexMask = procedure(mask: GLuint);stdcall;
  TglIndexMaterialEXT = procedure(face: GLenum; mode: GLenum);stdcall;
  TglIndexPointer = procedure(type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglIndexPointerEXT = procedure(type_: GLenum; stride: GLsizei; count: GLsizei; pointer: Pvoid);stdcall;
  TglIndexPointerListIBM = procedure(type_: GLenum; stride: GLint; pointer: PPvoid; ptrstride: GLint);stdcall;
  TglIndexd = procedure(c: GLdouble);stdcall;
  TglIndexdv = procedure(c: PGLdouble);stdcall;
  TglIndexf = procedure(c: GLfloat);stdcall;
  TglIndexfv = procedure(c: PGLfloat);stdcall;
  TglIndexi = procedure(c: GLint);stdcall;
  TglIndexiv = procedure(c: PGLint);stdcall;
  TglIndexs = procedure(c: GLshort);stdcall;
  TglIndexsv = procedure(c: PGLshort);stdcall;
  TglIndexub = procedure(c: GLubyte);stdcall;
  TglIndexubv = procedure(c: PGLubyte);stdcall;
  TglIndexxOES = procedure(component: GLfixed);stdcall;
  TglIndexxvOES = procedure(component: PGLfixed);stdcall;
  TglInitNames = procedure;stdcall;
  TglInsertComponentEXT = procedure(res: GLuint; src: GLuint; num: GLuint);stdcall;
  TglInsertEventMarkerEXT = procedure(length: GLsizei; marker: PGLchar);stdcall;
  TglInstrumentsBufferSGIX = procedure(size: GLsizei; buffer: PGLint);stdcall;
  TglInterleavedArrays = procedure(format: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglInterpolatePathsNV = procedure(resultPath: GLuint; pathA: GLuint; pathB: GLuint; weight: GLfloat);stdcall;
  TglInvalidateBufferData = procedure(buffer: GLuint);stdcall;
  TglInvalidateBufferSubData = procedure(buffer: GLuint; offset: GLintptr; length: GLsizeiptr);stdcall;
  TglInvalidateFramebuffer = procedure(target: GLenum; numAttachments: GLsizei; attachments: PGLenum);stdcall;
  TglInvalidateNamedFramebufferData = procedure(framebuffer: GLuint; numAttachments: GLsizei; attachments: PGLenum);stdcall;
  TglInvalidateNamedFramebufferSubData = procedure(framebuffer: GLuint; numAttachments: GLsizei; attachments: PGLenum; x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglInvalidateSubFramebuffer = procedure(target: GLenum; numAttachments: GLsizei; attachments: PGLenum; x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglInvalidateTexImage = procedure(texture: GLuint; level: GLint);stdcall;
  TglInvalidateTexSubImage = procedure(texture: GLuint; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei);stdcall;
  TglIsAsyncMarkerSGIX = function(marker: GLuint): GLboolean;stdcall;
  TglIsBuffer = function(buffer: GLuint): GLboolean;stdcall;
  TglIsBufferARB = function(buffer: GLuint): GLboolean;stdcall;
  TglIsBufferResidentNV = function(target: GLenum): GLboolean;stdcall;
  TglIsCommandListNV = function(list: GLuint): GLboolean;stdcall;
  TglIsEnabled = function(cap: GLenum): GLboolean;stdcall;
  TglIsEnabledIndexedEXT = function(target: GLenum; index_: GLuint): GLboolean;stdcall;
  TglIsEnabledi = function(target: GLenum; index_: GLuint): GLboolean;stdcall;
  TglIsEnablediEXT = function(target: GLenum; index_: GLuint): GLboolean;stdcall;
  TglIsEnablediNV = function(target: GLenum; index_: GLuint): GLboolean;stdcall;
  TglIsEnablediOES = function(target: GLenum; index_: GLuint): GLboolean;stdcall;
  TglIsFenceAPPLE = function(fence: GLuint): GLboolean;stdcall;
  TglIsFenceNV = function(fence: GLuint): GLboolean;stdcall;
  TglIsFramebuffer = function(framebuffer: GLuint): GLboolean;stdcall;
  TglIsFramebufferEXT = function(framebuffer: GLuint): GLboolean;stdcall;
  TglIsFramebufferOES = function(framebuffer: GLuint): GLboolean;stdcall;
  TglIsImageHandleResidentARB = function(handle: GLuint64): GLboolean;stdcall;
  TglIsImageHandleResidentNV = function(handle: GLuint64): GLboolean;stdcall;
  TglIsList = function(list: GLuint): GLboolean;stdcall;
  TglIsMemoryObjectEXT = function(memoryObject: GLuint): GLboolean;stdcall;
  TglIsNameAMD = function(identifier: GLenum; name_: GLuint): GLboolean;stdcall;
  TglIsNamedBufferResidentNV = function(buffer: GLuint): GLboolean;stdcall;
  TglIsNamedStringARB = function(namelen: GLint; name_: PGLchar): GLboolean;stdcall;
  TglIsObjectBufferATI = function(buffer: GLuint): GLboolean;stdcall;
  TglIsOcclusionQueryNV = function(id: GLuint): GLboolean;stdcall;
  TglIsPathNV = function(path: GLuint): GLboolean;stdcall;
  TglIsPointInFillPathNV = function(path: GLuint; mask: GLuint; x: GLfloat; y: GLfloat): GLboolean;stdcall;
  TglIsPointInStrokePathNV = function(path: GLuint; x: GLfloat; y: GLfloat): GLboolean;stdcall;
  TglIsProgram = function(program_: GLuint): GLboolean;stdcall;
  TglIsProgramARB = function(program_: GLuint): GLboolean;stdcall;
  TglIsProgramNV = function(id: GLuint): GLboolean;stdcall;
  TglIsProgramPipeline = function(pipeline: GLuint): GLboolean;stdcall;
  TglIsProgramPipelineEXT = function(pipeline: GLuint): GLboolean;stdcall;
  TglIsQuery = function(id: GLuint): GLboolean;stdcall;
  TglIsQueryARB = function(id: GLuint): GLboolean;stdcall;
  TglIsQueryEXT = function(id: GLuint): GLboolean;stdcall;
  TglIsRenderbuffer = function(renderbuffer: GLuint): GLboolean;stdcall;
  TglIsRenderbufferEXT = function(renderbuffer: GLuint): GLboolean;stdcall;
  TglIsRenderbufferOES = function(renderbuffer: GLuint): GLboolean;stdcall;
  TglIsSemaphoreEXT = function(semaphore: GLuint): GLboolean;stdcall;
  TglIsSampler = function(sampler: GLuint): GLboolean;stdcall;
  TglIsShader = function(shader: GLuint): GLboolean;stdcall;
  TglIsStateNV = function(state: GLuint): GLboolean;stdcall;
  TglIsSync = function(sync: GLsync): GLboolean;stdcall;
  TglIsSyncAPPLE = function(sync: GLsync): GLboolean;stdcall;
  TglIsTexture = function(texture: GLuint): GLboolean;stdcall;
  TglIsTextureEXT = function(texture: GLuint): GLboolean;stdcall;
  TglIsTextureHandleResidentARB = function(handle: GLuint64): GLboolean;stdcall;
  TglIsTextureHandleResidentNV = function(handle: GLuint64): GLboolean;stdcall;
  TglIsTransformFeedback = function(id: GLuint): GLboolean;stdcall;
  TglIsTransformFeedbackNV = function(id: GLuint): GLboolean;stdcall;
  TglIsVariantEnabledEXT = function(id: GLuint; cap: GLenum): GLboolean;stdcall;
  TglIsVertexArray = function(array_: GLuint): GLboolean;stdcall;
  TglIsVertexArrayAPPLE = function(array_: GLuint): GLboolean;stdcall;
  TglIsVertexArrayOES = function(array_: GLuint): GLboolean;stdcall;
  TglIsVertexAttribEnabledAPPLE = function(index_: GLuint; pname: GLenum): GLboolean;stdcall;
  TglLGPUCopyImageSubDataNVX = procedure(sourceGpu: GLuint; destinationGpuMask: GLbitfield; srcName: GLuint; srcTarget: GLenum; srcLevel: GLint; srcX: GLint; srxY: GLint; srcZ: GLint; dstName: GLuint; dstTarget: GLenum; dstLevel: GLint; dstX: GLint; dstY: GLint; dstZ: GLint; width: GLsizei; height: GLsizei; depth: GLsizei);stdcall;
  TglLGPUInterlockNVX = procedure;stdcall;
  TglLGPUNamedBufferSubDataNVX = procedure(gpuMask: GLbitfield; buffer: GLuint; offset: GLintptr; size: GLsizeiptr; data: Pvoid);stdcall;
  TglLabelObjectEXT = procedure(type_: GLenum; object_: GLuint; length: GLsizei; label_: PGLchar);stdcall;
  TglLightEnviSGIX = procedure(pname: GLenum; param: GLint);stdcall;
  TglLightModelf = procedure(pname: GLenum; param: GLfloat);stdcall;
  TglLightModelfv = procedure(pname: GLenum; params: PGLfloat);stdcall;
  TglLightModeli = procedure(pname: GLenum; param: GLint);stdcall;
  TglLightModeliv = procedure(pname: GLenum; params: PGLint);stdcall;
  TglLightModelx = procedure(pname: GLenum; param: GLfixed);stdcall;
  TglLightModelxOES = procedure(pname: GLenum; param: GLfixed);stdcall;
  TglLightModelxv = procedure(pname: GLenum; param: PGLfixed);stdcall;
  TglLightModelxvOES = procedure(pname: GLenum; param: PGLfixed);stdcall;
  TglLightf = procedure(light: GLenum; pname: GLenum; param: GLfloat);stdcall;
  TglLightfv = procedure(light: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglLighti = procedure(light: GLenum; pname: GLenum; param: GLint);stdcall;
  TglLightiv = procedure(light: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglLightx = procedure(light: GLenum; pname: GLenum; param: GLfixed);stdcall;
  TglLightxOES = procedure(light: GLenum; pname: GLenum; param: GLfixed);stdcall;
  TglLightxv = procedure(light: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglLightxvOES = procedure(light: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglLineStipple = procedure(factor: GLint; pattern: GLushort);stdcall;
  TglLineWidth = procedure(width: GLfloat);stdcall;
  TglLineWidthx = procedure(width: GLfixed);stdcall;
  TglLineWidthxOES = procedure(width: GLfixed);stdcall;
  TglLinkProgram = procedure(program_: GLuint);stdcall;
  TglLinkProgramARB = procedure(programObj: GLhandleARB);stdcall;
  TglListBase = procedure(base: GLuint);stdcall;
  TglListDrawCommandsStatesClientNV = procedure(list: GLuint; segment: GLuint; indirects: PPvoid; sizes: PGLsizei; states: PGLuint; fbos: PGLuint; count: GLuint);stdcall;
  TglListParameterfSGIX = procedure(list: GLuint; pname: GLenum; param: GLfloat);stdcall;
  TglListParameterfvSGIX = procedure(list: GLuint; pname: GLenum; params: PGLfloat);stdcall;
  TglListParameteriSGIX = procedure(list: GLuint; pname: GLenum; param: GLint);stdcall;
  TglListParameterivSGIX = procedure(list: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglLoadIdentity = procedure;stdcall;
  TglLoadIdentityDeformationMapSGIX = procedure(mask: GLbitfield);stdcall;
  TglLoadMatrixd = procedure(m: PGLdouble);stdcall;
  TglLoadMatrixf = procedure(m: PGLfloat);stdcall;
  TglLoadMatrixx = procedure(m: PGLfixed);stdcall;
  TglLoadMatrixxOES = procedure(m: PGLfixed);stdcall;
  TglLoadName = procedure(name_: GLuint);stdcall;
  TglLoadPaletteFromModelViewMatrixOES = procedure;stdcall;
  TglLoadProgramNV = procedure(target: GLenum; id: GLuint; len: GLsizei; program_: PGLubyte);stdcall;
  TglLoadTransposeMatrixd = procedure(m: PGLdouble);stdcall;
  TglLoadTransposeMatrixdARB = procedure(m: PGLdouble);stdcall;
  TglLoadTransposeMatrixf = procedure(m: PGLfloat);stdcall;
  TglLoadTransposeMatrixfARB = procedure(m: PGLfloat);stdcall;
  TglLoadTransposeMatrixxOES = procedure(m: PGLfixed);stdcall;
  TglLockArraysEXT = procedure(first: GLint; count: GLsizei);stdcall;
  TglLogicOp = procedure(opcode: GLenum);stdcall;
  TglMakeBufferNonResidentNV = procedure(target: GLenum);stdcall;
  TglMakeBufferResidentNV = procedure(target: GLenum; access: GLenum);stdcall;
  TglMakeImageHandleNonResidentARB = procedure(handle: GLuint64);stdcall;
  TglMakeImageHandleNonResidentNV = procedure(handle: GLuint64);stdcall;
  TglMakeImageHandleResidentARB = procedure(handle: GLuint64; access: GLenum);stdcall;
  TglMakeImageHandleResidentNV = procedure(handle: GLuint64; access: GLenum);stdcall;
  TglMakeNamedBufferNonResidentNV = procedure(buffer: GLuint);stdcall;
  TglMakeNamedBufferResidentNV = procedure(buffer: GLuint; access: GLenum);stdcall;
  TglMakeTextureHandleNonResidentARB = procedure(handle: GLuint64);stdcall;
  TglMakeTextureHandleNonResidentNV = procedure(handle: GLuint64);stdcall;
  TglMakeTextureHandleResidentARB = procedure(handle: GLuint64);stdcall;
  TglMakeTextureHandleResidentNV = procedure(handle: GLuint64);stdcall;
  TglMap1d = procedure(target: GLenum; u1: GLdouble; u2: GLdouble; stride: GLint; order: GLint; points: PGLdouble);stdcall;
  TglMap1f = procedure(target: GLenum; u1: GLfloat; u2: GLfloat; stride: GLint; order: GLint; points: PGLfloat);stdcall;
  TglMap1xOES = procedure(target: GLenum; u1: GLfixed; u2: GLfixed; stride: GLint; order: GLint; points: GLfixed);stdcall;
  TglMap2d = procedure(target: GLenum; u1: GLdouble; u2: GLdouble; ustride: GLint; uorder: GLint; v1: GLdouble; v2: GLdouble; vstride: GLint; vorder: GLint; points: PGLdouble);stdcall;
  TglMap2f = procedure(target: GLenum; u1: GLfloat; u2: GLfloat; ustride: GLint; uorder: GLint; v1: GLfloat; v2: GLfloat; vstride: GLint; vorder: GLint; points: PGLfloat);stdcall;
  TglMap2xOES = procedure(target: GLenum; u1: GLfixed; u2: GLfixed; ustride: GLint; uorder: GLint; v1: GLfixed; v2: GLfixed; vstride: GLint; vorder: GLint; points: GLfixed);stdcall;
  TglMapBuffer = function(target: GLenum; access: GLenum): Pvoid;stdcall;
  TglMapBufferARB = function(target: GLenum; access: GLenum): Pvoid;stdcall;
  TglMapBufferOES = function(target: GLenum; access: GLenum): Pvoid;stdcall;
  TglMapBufferRange = function(target: GLenum; offset: GLintptr; length: GLsizeiptr; access: GLbitfield): Pvoid;stdcall;
  TglMapBufferRangeEXT = function(target: GLenum; offset: GLintptr; length: GLsizeiptr; access: GLbitfield): Pvoid;stdcall;
  TglMapControlPointsNV = procedure(target: GLenum; index_: GLuint; type_: GLenum; ustride: GLsizei; vstride: GLsizei; uorder: GLint; vorder: GLint; packed_: GLboolean; points: Pvoid);stdcall;
  TglMapGrid1d = procedure(un: GLint; u1: GLdouble; u2: GLdouble);stdcall;
  TglMapGrid1f = procedure(un: GLint; u1: GLfloat; u2: GLfloat);stdcall;
  TglMapGrid1xOES = procedure(n: GLint; u1: GLfixed; u2: GLfixed);stdcall;
  TglMapGrid2d = procedure(un: GLint; u1: GLdouble; u2: GLdouble; vn: GLint; v1: GLdouble; v2: GLdouble);stdcall;
  TglMapGrid2f = procedure(un: GLint; u1: GLfloat; u2: GLfloat; vn: GLint; v1: GLfloat; v2: GLfloat);stdcall;
  TglMapGrid2xOES = procedure(n: GLint; u1: GLfixed; u2: GLfixed; v1: GLfixed; v2: GLfixed);stdcall;
  TglMapNamedBuffer = function(buffer: GLuint; access: GLenum): Pvoid;stdcall;
  TglMapNamedBufferEXT = function(buffer: GLuint; access: GLenum): Pvoid;stdcall;
  TglMapNamedBufferRange = function(buffer: GLuint; offset: GLintptr; length: GLsizeiptr; access: GLbitfield): Pvoid;stdcall;
  TglMapNamedBufferRangeEXT = function(buffer: GLuint; offset: GLintptr; length: GLsizeiptr; access: GLbitfield): Pvoid;stdcall;
  TglMapObjectBufferATI = function(buffer: GLuint): Pvoid;stdcall;
  TglMapParameterfvNV = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglMapParameterivNV = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglMapTexture2DINTEL = function(texture: GLuint; level: GLint; access: GLbitfield; stride: PGLint; layout: PGLenum): Pvoid;stdcall;
  TglMapVertexAttrib1dAPPLE = procedure(index_: GLuint; size: GLuint; u1: GLdouble; u2: GLdouble; stride: GLint; order: GLint; points: PGLdouble);stdcall;
  TglMapVertexAttrib1fAPPLE = procedure(index_: GLuint; size: GLuint; u1: GLfloat; u2: GLfloat; stride: GLint; order: GLint; points: PGLfloat);stdcall;
  TglMapVertexAttrib2dAPPLE = procedure(index_: GLuint; size: GLuint; u1: GLdouble; u2: GLdouble; ustride: GLint; uorder: GLint; v1: GLdouble; v2: GLdouble; vstride: GLint; vorder: GLint; points: PGLdouble);stdcall;
  TglMapVertexAttrib2fAPPLE = procedure(index_: GLuint; size: GLuint; u1: GLfloat; u2: GLfloat; ustride: GLint; uorder: GLint; v1: GLfloat; v2: GLfloat; vstride: GLint; vorder: GLint; points: PGLfloat);stdcall;
  TglMaterialf = procedure(face: GLenum; pname: GLenum; param: GLfloat);stdcall;
  TglMaterialfv = procedure(face: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglMateriali = procedure(face: GLenum; pname: GLenum; param: GLint);stdcall;
  TglMaterialiv = procedure(face: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglMaterialx = procedure(face: GLenum; pname: GLenum; param: GLfixed);stdcall;
  TglMaterialxOES = procedure(face: GLenum; pname: GLenum; param: GLfixed);stdcall;
  TglMaterialxv = procedure(face: GLenum; pname: GLenum; param: PGLfixed);stdcall;
  TglMaterialxvOES = procedure(face: GLenum; pname: GLenum; param: PGLfixed);stdcall;
  TglMatrixFrustumEXT = procedure(mode: GLenum; left: GLdouble; right: GLdouble; bottom: GLdouble; top: GLdouble; zNear: GLdouble; zFar: GLdouble);stdcall;
  TglMatrixIndexPointerARB = procedure(size: GLint; type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglMatrixIndexPointerOES = procedure(size: GLint; type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglMatrixIndexubvARB = procedure(size: GLint; indices: PGLubyte);stdcall;
  TglMatrixIndexuivARB = procedure(size: GLint; indices: PGLuint);stdcall;
  TglMatrixIndexusvARB = procedure(size: GLint; indices: PGLushort);stdcall;
  TglMatrixLoad3x2fNV = procedure(matrixMode: GLenum; m: PGLfloat);stdcall;
  TglMatrixLoad3x3fNV = procedure(matrixMode: GLenum; m: PGLfloat);stdcall;
  TglMatrixLoadIdentityEXT = procedure(mode: GLenum);stdcall;
  TglMatrixLoadTranspose3x3fNV = procedure(matrixMode: GLenum; m: PGLfloat);stdcall;
  TglMatrixLoadTransposedEXT = procedure(mode: GLenum; m: PGLdouble);stdcall;
  TglMatrixLoadTransposefEXT = procedure(mode: GLenum; m: PGLfloat);stdcall;
  TglMatrixLoaddEXT = procedure(mode: GLenum; m: PGLdouble);stdcall;
  TglMatrixLoadfEXT = procedure(mode: GLenum; m: PGLfloat);stdcall;
  TglMatrixMode = procedure(mode: GLenum);stdcall;
  TglMatrixMult3x2fNV = procedure(matrixMode: GLenum; m: PGLfloat);stdcall;
  TglMatrixMult3x3fNV = procedure(matrixMode: GLenum; m: PGLfloat);stdcall;
  TglMatrixMultTranspose3x3fNV = procedure(matrixMode: GLenum; m: PGLfloat);stdcall;
  TglMatrixMultTransposedEXT = procedure(mode: GLenum; m: PGLdouble);stdcall;
  TglMatrixMultTransposefEXT = procedure(mode: GLenum; m: PGLfloat);stdcall;
  TglMatrixMultdEXT = procedure(mode: GLenum; m: PGLdouble);stdcall;
  TglMatrixMultfEXT = procedure(mode: GLenum; m: PGLfloat);stdcall;
  TglMatrixOrthoEXT = procedure(mode: GLenum; left: GLdouble; right: GLdouble; bottom: GLdouble; top: GLdouble; zNear: GLdouble; zFar: GLdouble);stdcall;
  TglMatrixPopEXT = procedure(mode: GLenum);stdcall;
  TglMatrixPushEXT = procedure(mode: GLenum);stdcall;
  TglMatrixRotatedEXT = procedure(mode: GLenum; angle: GLdouble; x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglMatrixRotatefEXT = procedure(mode: GLenum; angle: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglMatrixScaledEXT = procedure(mode: GLenum; x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglMatrixScalefEXT = procedure(mode: GLenum; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglMatrixTranslatedEXT = procedure(mode: GLenum; x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglMatrixTranslatefEXT = procedure(mode: GLenum; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglMaxShaderCompilerThreadsARB = procedure(count: GLuint);stdcall;
  TglMemoryBarrier = procedure(barriers: GLbitfield);stdcall;
  TglMemoryBarrierByRegion = procedure(barriers: GLbitfield);stdcall;
  TglMemoryBarrierEXT = procedure(barriers: GLbitfield);stdcall;
  TglMemoryObjectParameterivEXT = procedure(memoryObject: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglMinSampleShading = procedure(value: GLfloat);stdcall;
  TglMinSampleShadingARB = procedure(value: GLfloat);stdcall;
  TglMinSampleShadingOES = procedure(value: GLfloat);stdcall;
  TglMinmax = procedure(target: GLenum; internalformat: GLenum; sink: GLboolean);stdcall;
  TglMinmaxEXT = procedure(target: GLenum; internalformat: GLenum; sink: GLboolean);stdcall;
  TglMultMatrixd = procedure(m: PGLdouble);stdcall;
  TglMultMatrixf = procedure(m: PGLfloat);stdcall;
  TglMultMatrixx = procedure(m: PGLfixed);stdcall;
  TglMultMatrixxOES = procedure(m: PGLfixed);stdcall;
  TglMultTransposeMatrixd = procedure(m: PGLdouble);stdcall;
  TglMultTransposeMatrixdARB = procedure(m: PGLdouble);stdcall;
  TglMultTransposeMatrixf = procedure(m: PGLfloat);stdcall;
  TglMultTransposeMatrixfARB = procedure(m: PGLfloat);stdcall;
  TglMultTransposeMatrixxOES = procedure(m: PGLfixed);stdcall;
  TglMultiDrawArrays = procedure(mode: GLenum; first: PGLint; count: PGLsizei; drawcount: GLsizei);stdcall;
  TglMultiDrawArraysEXT = procedure(mode: GLenum; first: PGLint; count: PGLsizei; primcount: GLsizei);stdcall;
  TglMultiDrawArraysIndirect = procedure(mode: GLenum; indirect: Pvoid; drawcount: GLsizei; stride: GLsizei);stdcall;
  TglMultiDrawArraysIndirectAMD = procedure(mode: GLenum; indirect: Pvoid; primcount: GLsizei; stride: GLsizei);stdcall;
  TglMultiDrawArraysIndirectBindlessCountNV = procedure(mode: GLenum; indirect: Pvoid; drawCount: GLsizei; maxDrawCount: GLsizei; stride: GLsizei; vertexBufferCount: GLint);stdcall;
  TglMultiDrawArraysIndirectBindlessNV = procedure(mode: GLenum; indirect: Pvoid; drawCount: GLsizei; stride: GLsizei; vertexBufferCount: GLint);stdcall;
  TglMultiDrawArraysIndirectCount = procedure(mode: GLenum; indirect: Pvoid; drawcount: GLintptr; maxdrawcount: GLsizei; stride: GLsizei);stdcall;
  TglMultiDrawArraysIndirectCountARB = procedure(mode: GLenum; indirect: Pvoid; drawcount: GLintptr; maxdrawcount: GLsizei; stride: GLsizei);stdcall;
  TglMultiDrawArraysIndirectEXT = procedure(mode: GLenum; indirect: Pvoid; drawcount: GLsizei; stride: GLsizei);stdcall;
  TglMultiDrawElementArrayAPPLE = procedure(mode: GLenum; first: PGLint; count: PGLsizei; primcount: GLsizei);stdcall;
  TglMultiDrawElements = procedure(mode: GLenum; count: PGLsizei; type_: GLenum; indices: PPvoid; drawcount: GLsizei);stdcall;
  TglMultiDrawElementsBaseVertex = procedure(mode: GLenum; count: PGLsizei; type_: GLenum; indices: PPvoid; drawcount: GLsizei; basevertex: PGLint);stdcall;
  TglMultiDrawElementsBaseVertexEXT = procedure(mode: GLenum; count: PGLsizei; type_: GLenum; indices: PPvoid; primcount: GLsizei; basevertex: PGLint);stdcall;
  TglMultiDrawElementsEXT = procedure(mode: GLenum; count: PGLsizei; type_: GLenum; indices: PPvoid; primcount: GLsizei);stdcall;
  TglMultiDrawElementsIndirect = procedure(mode: GLenum; type_: GLenum; indirect: Pvoid; drawcount: GLsizei; stride: GLsizei);stdcall;
  TglMultiDrawElementsIndirectAMD = procedure(mode: GLenum; type_: GLenum; indirect: Pvoid; primcount: GLsizei; stride: GLsizei);stdcall;
  TglMultiDrawElementsIndirectBindlessCountNV = procedure(mode: GLenum; type_: GLenum; indirect: Pvoid; drawCount: GLsizei; maxDrawCount: GLsizei; stride: GLsizei; vertexBufferCount: GLint);stdcall;
  TglMultiDrawElementsIndirectBindlessNV = procedure(mode: GLenum; type_: GLenum; indirect: Pvoid; drawCount: GLsizei; stride: GLsizei; vertexBufferCount: GLint);stdcall;
  TglMultiDrawElementsIndirectCount = procedure(mode: GLenum; type_: GLenum; indirect: Pvoid; drawcount: GLintptr; maxdrawcount: GLsizei; stride: GLsizei);stdcall;
  TglMultiDrawElementsIndirectCountARB = procedure(mode: GLenum; type_: GLenum; indirect: Pvoid; drawcount: GLintptr; maxdrawcount: GLsizei; stride: GLsizei);stdcall;
  TglMultiDrawElementsIndirectEXT = procedure(mode: GLenum; type_: GLenum; indirect: Pvoid; drawcount: GLsizei; stride: GLsizei);stdcall;
  TglMultiDrawRangeElementArrayAPPLE = procedure(mode: GLenum; start: GLuint; end_: GLuint; first: PGLint; count: PGLsizei; primcount: GLsizei);stdcall;
  TglMultiModeDrawArraysIBM = procedure(mode: PGLenum; first: PGLint; count: PGLsizei; primcount: GLsizei; modestride: GLint);stdcall;
  TglMultiModeDrawElementsIBM = procedure(mode: PGLenum; count: PGLsizei; type_: GLenum; indices: PPvoid; primcount: GLsizei; modestride: GLint);stdcall;
  TglMultiTexBufferEXT = procedure(texunit: GLenum; target: GLenum; internalformat: GLenum; buffer: GLuint);stdcall;
  TglMultiTexCoord1bOES = procedure(texture: GLenum; s: GLbyte);stdcall;
  TglMultiTexCoord1bvOES = procedure(texture: GLenum; coords: PGLbyte);stdcall;
  TglMultiTexCoord1d = procedure(target: GLenum; s: GLdouble);stdcall;
  TglMultiTexCoord1dARB = procedure(target: GLenum; s: GLdouble);stdcall;
  TglMultiTexCoord1dv = procedure(target: GLenum; v: PGLdouble);stdcall;
  TglMultiTexCoord1dvARB = procedure(target: GLenum; v: PGLdouble);stdcall;
  TglMultiTexCoord1f = procedure(target: GLenum; s: GLfloat);stdcall;
  TglMultiTexCoord1fARB = procedure(target: GLenum; s: GLfloat);stdcall;
  TglMultiTexCoord1fv = procedure(target: GLenum; v: PGLfloat);stdcall;
  TglMultiTexCoord1fvARB = procedure(target: GLenum; v: PGLfloat);stdcall;
  TglMultiTexCoord1hNV = procedure(target: GLenum; s: GLhalfNV);stdcall;
  TglMultiTexCoord1hvNV = procedure(target: GLenum; v: PGLhalfNV);stdcall;
  TglMultiTexCoord1i = procedure(target: GLenum; s: GLint);stdcall;
  TglMultiTexCoord1iARB = procedure(target: GLenum; s: GLint);stdcall;
  TglMultiTexCoord1iv = procedure(target: GLenum; v: PGLint);stdcall;
  TglMultiTexCoord1ivARB = procedure(target: GLenum; v: PGLint);stdcall;
  TglMultiTexCoord1s = procedure(target: GLenum; s: GLshort);stdcall;
  TglMultiTexCoord1sARB = procedure(target: GLenum; s: GLshort);stdcall;
  TglMultiTexCoord1sv = procedure(target: GLenum; v: PGLshort);stdcall;
  TglMultiTexCoord1svARB = procedure(target: GLenum; v: PGLshort);stdcall;
  TglMultiTexCoord1xOES = procedure(texture: GLenum; s: GLfixed);stdcall;
  TglMultiTexCoord1xvOES = procedure(texture: GLenum; coords: PGLfixed);stdcall;
  TglMultiTexCoord2bOES = procedure(texture: GLenum; s: GLbyte; t: GLbyte);stdcall;
  TglMultiTexCoord2bvOES = procedure(texture: GLenum; coords: PGLbyte);stdcall;
  TglMultiTexCoord2d = procedure(target: GLenum; s: GLdouble; t: GLdouble);stdcall;
  TglMultiTexCoord2dARB = procedure(target: GLenum; s: GLdouble; t: GLdouble);stdcall;
  TglMultiTexCoord2dv = procedure(target: GLenum; v: PGLdouble);stdcall;
  TglMultiTexCoord2dvARB = procedure(target: GLenum; v: PGLdouble);stdcall;
  TglMultiTexCoord2f = procedure(target: GLenum; s: GLfloat; t: GLfloat);stdcall;
  TglMultiTexCoord2fARB = procedure(target: GLenum; s: GLfloat; t: GLfloat);stdcall;
  TglMultiTexCoord2fv = procedure(target: GLenum; v: PGLfloat);stdcall;
  TglMultiTexCoord2fvARB = procedure(target: GLenum; v: PGLfloat);stdcall;
  TglMultiTexCoord2hNV = procedure(target: GLenum; s: GLhalfNV; t: GLhalfNV);stdcall;
  TglMultiTexCoord2hvNV = procedure(target: GLenum; v: PGLhalfNV);stdcall;
  TglMultiTexCoord2i = procedure(target: GLenum; s: GLint; t: GLint);stdcall;
  TglMultiTexCoord2iARB = procedure(target: GLenum; s: GLint; t: GLint);stdcall;
  TglMultiTexCoord2iv = procedure(target: GLenum; v: PGLint);stdcall;
  TglMultiTexCoord2ivARB = procedure(target: GLenum; v: PGLint);stdcall;
  TglMultiTexCoord2s = procedure(target: GLenum; s: GLshort; t: GLshort);stdcall;
  TglMultiTexCoord2sARB = procedure(target: GLenum; s: GLshort; t: GLshort);stdcall;
  TglMultiTexCoord2sv = procedure(target: GLenum; v: PGLshort);stdcall;
  TglMultiTexCoord2svARB = procedure(target: GLenum; v: PGLshort);stdcall;
  TglMultiTexCoord2xOES = procedure(texture: GLenum; s: GLfixed; t: GLfixed);stdcall;
  TglMultiTexCoord2xvOES = procedure(texture: GLenum; coords: PGLfixed);stdcall;
  TglMultiTexCoord3bOES = procedure(texture: GLenum; s: GLbyte; t: GLbyte; r: GLbyte);stdcall;
  TglMultiTexCoord3bvOES = procedure(texture: GLenum; coords: PGLbyte);stdcall;
  TglMultiTexCoord3d = procedure(target: GLenum; s: GLdouble; t: GLdouble; r: GLdouble);stdcall;
  TglMultiTexCoord3dARB = procedure(target: GLenum; s: GLdouble; t: GLdouble; r: GLdouble);stdcall;
  TglMultiTexCoord3dv = procedure(target: GLenum; v: PGLdouble);stdcall;
  TglMultiTexCoord3dvARB = procedure(target: GLenum; v: PGLdouble);stdcall;
  TglMultiTexCoord3f = procedure(target: GLenum; s: GLfloat; t: GLfloat; r: GLfloat);stdcall;
  TglMultiTexCoord3fARB = procedure(target: GLenum; s: GLfloat; t: GLfloat; r: GLfloat);stdcall;
  TglMultiTexCoord3fv = procedure(target: GLenum; v: PGLfloat);stdcall;
  TglMultiTexCoord3fvARB = procedure(target: GLenum; v: PGLfloat);stdcall;
  TglMultiTexCoord3hNV = procedure(target: GLenum; s: GLhalfNV; t: GLhalfNV; r: GLhalfNV);stdcall;
  TglMultiTexCoord3hvNV = procedure(target: GLenum; v: PGLhalfNV);stdcall;
  TglMultiTexCoord3i = procedure(target: GLenum; s: GLint; t: GLint; r: GLint);stdcall;
  TglMultiTexCoord3iARB = procedure(target: GLenum; s: GLint; t: GLint; r: GLint);stdcall;
  TglMultiTexCoord3iv = procedure(target: GLenum; v: PGLint);stdcall;
  TglMultiTexCoord3ivARB = procedure(target: GLenum; v: PGLint);stdcall;
  TglMultiTexCoord3s = procedure(target: GLenum; s: GLshort; t: GLshort; r: GLshort);stdcall;
  TglMultiTexCoord3sARB = procedure(target: GLenum; s: GLshort; t: GLshort; r: GLshort);stdcall;
  TglMultiTexCoord3sv = procedure(target: GLenum; v: PGLshort);stdcall;
  TglMultiTexCoord3svARB = procedure(target: GLenum; v: PGLshort);stdcall;
  TglMultiTexCoord3xOES = procedure(texture: GLenum; s: GLfixed; t: GLfixed; r: GLfixed);stdcall;
  TglMultiTexCoord3xvOES = procedure(texture: GLenum; coords: PGLfixed);stdcall;
  TglMultiTexCoord4bOES = procedure(texture: GLenum; s: GLbyte; t: GLbyte; r: GLbyte; q: GLbyte);stdcall;
  TglMultiTexCoord4bvOES = procedure(texture: GLenum; coords: PGLbyte);stdcall;
  TglMultiTexCoord4d = procedure(target: GLenum; s: GLdouble; t: GLdouble; r: GLdouble; q: GLdouble);stdcall;
  TglMultiTexCoord4dARB = procedure(target: GLenum; s: GLdouble; t: GLdouble; r: GLdouble; q: GLdouble);stdcall;
  TglMultiTexCoord4dv = procedure(target: GLenum; v: PGLdouble);stdcall;
  TglMultiTexCoord4dvARB = procedure(target: GLenum; v: PGLdouble);stdcall;
  TglMultiTexCoord4f = procedure(target: GLenum; s: GLfloat; t: GLfloat; r: GLfloat; q: GLfloat);stdcall;
  TglMultiTexCoord4fARB = procedure(target: GLenum; s: GLfloat; t: GLfloat; r: GLfloat; q: GLfloat);stdcall;
  TglMultiTexCoord4fv = procedure(target: GLenum; v: PGLfloat);stdcall;
  TglMultiTexCoord4fvARB = procedure(target: GLenum; v: PGLfloat);stdcall;
  TglMultiTexCoord4hNV = procedure(target: GLenum; s: GLhalfNV; t: GLhalfNV; r: GLhalfNV; q: GLhalfNV);stdcall;
  TglMultiTexCoord4hvNV = procedure(target: GLenum; v: PGLhalfNV);stdcall;
  TglMultiTexCoord4i = procedure(target: GLenum; s: GLint; t: GLint; r: GLint; q: GLint);stdcall;
  TglMultiTexCoord4iARB = procedure(target: GLenum; s: GLint; t: GLint; r: GLint; q: GLint);stdcall;
  TglMultiTexCoord4iv = procedure(target: GLenum; v: PGLint);stdcall;
  TglMultiTexCoord4ivARB = procedure(target: GLenum; v: PGLint);stdcall;
  TglMultiTexCoord4s = procedure(target: GLenum; s: GLshort; t: GLshort; r: GLshort; q: GLshort);stdcall;
  TglMultiTexCoord4sARB = procedure(target: GLenum; s: GLshort; t: GLshort; r: GLshort; q: GLshort);stdcall;
  TglMultiTexCoord4sv = procedure(target: GLenum; v: PGLshort);stdcall;
  TglMultiTexCoord4svARB = procedure(target: GLenum; v: PGLshort);stdcall;
  TglMultiTexCoord4x = procedure(texture: GLenum; s: GLfixed; t: GLfixed; r: GLfixed; q: GLfixed);stdcall;
  TglMultiTexCoord4xOES = procedure(texture: GLenum; s: GLfixed; t: GLfixed; r: GLfixed; q: GLfixed);stdcall;
  TglMultiTexCoord4xvOES = procedure(texture: GLenum; coords: PGLfixed);stdcall;
  TglMultiTexCoordP1ui = procedure(texture: GLenum; type_: GLenum; coords: GLuint);stdcall;
  TglMultiTexCoordP1uiv = procedure(texture: GLenum; type_: GLenum; coords: PGLuint);stdcall;
  TglMultiTexCoordP2ui = procedure(texture: GLenum; type_: GLenum; coords: GLuint);stdcall;
  TglMultiTexCoordP2uiv = procedure(texture: GLenum; type_: GLenum; coords: PGLuint);stdcall;
  TglMultiTexCoordP3ui = procedure(texture: GLenum; type_: GLenum; coords: GLuint);stdcall;
  TglMultiTexCoordP3uiv = procedure(texture: GLenum; type_: GLenum; coords: PGLuint);stdcall;
  TglMultiTexCoordP4ui = procedure(texture: GLenum; type_: GLenum; coords: GLuint);stdcall;
  TglMultiTexCoordP4uiv = procedure(texture: GLenum; type_: GLenum; coords: PGLuint);stdcall;
  TglMultiTexCoordPointerEXT = procedure(texunit: GLenum; size: GLint; type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglMultiTexEnvfEXT = procedure(texunit: GLenum; target: GLenum; pname: GLenum; param: GLfloat);stdcall;
  TglMultiTexEnvfvEXT = procedure(texunit: GLenum; target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglMultiTexEnviEXT = procedure(texunit: GLenum; target: GLenum; pname: GLenum; param: GLint);stdcall;
  TglMultiTexEnvivEXT = procedure(texunit: GLenum; target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglMultiTexGendEXT = procedure(texunit: GLenum; coord: GLenum; pname: GLenum; param: GLdouble);stdcall;
  TglMultiTexGendvEXT = procedure(texunit: GLenum; coord: GLenum; pname: GLenum; params: PGLdouble);stdcall;
  TglMultiTexGenfEXT = procedure(texunit: GLenum; coord: GLenum; pname: GLenum; param: GLfloat);stdcall;
  TglMultiTexGenfvEXT = procedure(texunit: GLenum; coord: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglMultiTexGeniEXT = procedure(texunit: GLenum; coord: GLenum; pname: GLenum; param: GLint);stdcall;
  TglMultiTexGenivEXT = procedure(texunit: GLenum; coord: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglMultiTexImage1DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; internalformat: GLint; width: GLsizei; border: GLint; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglMultiTexImage2DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; internalformat: GLint; width: GLsizei; height: GLsizei; border: GLint; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglMultiTexImage3DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; internalformat: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglMultiTexParameterIivEXT = procedure(texunit: GLenum; target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglMultiTexParameterIuivEXT = procedure(texunit: GLenum; target: GLenum; pname: GLenum; params: PGLuint);stdcall;
  TglMultiTexParameterfEXT = procedure(texunit: GLenum; target: GLenum; pname: GLenum; param: GLfloat);stdcall;
  TglMultiTexParameterfvEXT = procedure(texunit: GLenum; target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglMultiTexParameteriEXT = procedure(texunit: GLenum; target: GLenum; pname: GLenum; param: GLint);stdcall;
  TglMultiTexParameterivEXT = procedure(texunit: GLenum; target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglMultiTexRenderbufferEXT = procedure(texunit: GLenum; target: GLenum; renderbuffer: GLuint);stdcall;
  TglMultiTexSubImage1DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; xoffset: GLint; width: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglMultiTexSubImage2DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; width: GLsizei; height: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglMultiTexSubImage3DEXT = procedure(texunit: GLenum; target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglMulticastBarrierNV = procedure;stdcall;
  TglMulticastBlitFramebufferNV = procedure(srcGpu: GLuint; dstGpu: GLuint; srcX0: GLint; srcY0: GLint; srcX1: GLint; srcY1: GLint; dstX0: GLint; dstY0: GLint; dstX1: GLint; dstY1: GLint; mask: GLbitfield; filter: GLenum);stdcall;
  TglMulticastBufferSubDataNV = procedure(gpuMask: GLbitfield; buffer: GLuint; offset: GLintptr; size: GLsizeiptr; data: PGLvoid);stdcall;
  TglMulticastCopyBufferSubDataNV = procedure(readGpu: GLuint; writeGpuMask: GLbitfield; readBuffer: GLuint; writeBuffer: GLuint; readOffset: GLintptr; writeOffset: GLintptr; size: GLsizeiptr);stdcall;
  TglMulticastCopyImageSubDataNV = procedure(srcGpu: GLuint; dstGpuMask: GLbitfield; srcName: GLuint; srcTarget: GLenum; srcLevel: GLint; srcX: GLint; srcY: GLint; srcZ: GLint; dstName: GLuint; dstTarget: GLenum; dstLevel: GLint; dstX: GLint; dstY: GLint; dstZ: GLint; srcWidth: GLsizei; srcHeight: GLsizei; srcDepth: GLsizei);stdcall;
  TglMulticastFramebufferSampleLocationsfvNV = procedure(gpu: GLuint; framebuffer: GLuint; start: GLuint; count: GLsizei; v: PGLfloat);stdcall;
  TglMulticastGetQueryObjecti64vNV = procedure(gpu: GLuint; id: GLuint; pname: GLenum; params: PGLint64);stdcall;
  TglMulticastGetQueryObjectivNV = procedure(gpu: GLuint; id: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglMulticastGetQueryObjectui64vNV = procedure(gpu: GLuint; id: GLuint; pname: GLenum; params: PGLuint64);stdcall;
  TglMulticastGetQueryObjectuivNV = procedure(gpu: GLuint; id: GLuint; pname: GLenum; params: PGLuint);stdcall;
  TglMulticastWaitSyncNV = procedure(signalGpu: GLuint; waitGpuMask: GLbitfield);stdcall;
  TglNamedBufferData = procedure(buffer: GLuint; size: GLsizeiptr; data: Pvoid; usage: GLenum);stdcall;
  TglNamedBufferDataEXT = procedure(buffer: GLuint; size: GLsizeiptr; data: Pvoid; usage: GLenum);stdcall;
  TglNamedBufferPageCommitmentARB = procedure(buffer: GLuint; offset: GLintptr; size: GLsizeiptr; commit: GLboolean);stdcall;
  TglNamedBufferPageCommitmentEXT = procedure(buffer: GLuint; offset: GLintptr; size: GLsizeiptr; commit: GLboolean);stdcall;
  TglNamedBufferStorage = procedure(buffer: GLuint; size: GLsizeiptr; data: Pvoid; flags: GLbitfield);stdcall;
  TglNamedBufferStorageExternalEXT = procedure(buffer: GLuint; offset: GLintptr; size: GLsizeiptr; clientBuffer: GLeglClientBufferEXT; flags: GLbitfield);stdcall;
  TglNamedBufferStorageEXT = procedure(buffer: GLuint; size: GLsizeiptr; data: Pvoid; flags: GLbitfield);stdcall;
  TglNamedBufferStorageMemEXT = procedure(buffer: GLuint; size: GLsizeiptr; memory: GLuint; offset: GLuint64);stdcall;
  TglNamedBufferSubData = procedure(buffer: GLuint; offset: GLintptr; size: GLsizeiptr; data: Pvoid);stdcall;
  TglNamedBufferSubDataEXT = procedure(buffer: GLuint; offset: GLintptr; size: GLsizeiptr; data: Pvoid);stdcall;
  TglNamedCopyBufferSubDataEXT = procedure(readBuffer: GLuint; writeBuffer: GLuint; readOffset: GLintptr; writeOffset: GLintptr; size: GLsizeiptr);stdcall;
  TglNamedFramebufferDrawBuffer = procedure(framebuffer: GLuint; buf: GLenum);stdcall;
  TglNamedFramebufferDrawBuffers = procedure(framebuffer: GLuint; n: GLsizei; bufs: PGLenum);stdcall;
  TglNamedFramebufferParameteri = procedure(framebuffer: GLuint; pname: GLenum; param: GLint);stdcall;
  TglNamedFramebufferParameteriEXT = procedure(framebuffer: GLuint; pname: GLenum; param: GLint);stdcall;
  TglNamedFramebufferReadBuffer = procedure(framebuffer: GLuint; src: GLenum);stdcall;
  TglNamedFramebufferRenderbuffer = procedure(framebuffer: GLuint; attachment: GLenum; renderbuffertarget: GLenum; renderbuffer: GLuint);stdcall;
  TglNamedFramebufferRenderbufferEXT = procedure(framebuffer: GLuint; attachment: GLenum; renderbuffertarget: GLenum; renderbuffer: GLuint);stdcall;
  TglNamedFramebufferSampleLocationsfvARB = procedure(framebuffer: GLuint; start: GLuint; count: GLsizei; v: PGLfloat);stdcall;
  TglNamedFramebufferSampleLocationsfvNV = procedure(framebuffer: GLuint; start: GLuint; count: GLsizei; v: PGLfloat);stdcall;
  TglNamedFramebufferTexture = procedure(framebuffer: GLuint; attachment: GLenum; texture: GLuint; level: GLint);stdcall;
  TglNamedFramebufferSamplePositionsfvAMD = procedure(framebuffer: GLuint; numsamples: GLuint; pixelindex: GLuint; values: PGLfloat);stdcall;
  TglNamedFramebufferTexture1DEXT = procedure(framebuffer: GLuint; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint);stdcall;
  TglNamedFramebufferTexture2DEXT = procedure(framebuffer: GLuint; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint);stdcall;
  TglNamedFramebufferTexture3DEXT = procedure(framebuffer: GLuint; attachment: GLenum; textarget: GLenum; texture: GLuint; level: GLint; zoffset: GLint);stdcall;
  TglNamedFramebufferTextureEXT = procedure(framebuffer: GLuint; attachment: GLenum; texture: GLuint; level: GLint);stdcall;
  TglNamedFramebufferTextureFaceEXT = procedure(framebuffer: GLuint; attachment: GLenum; texture: GLuint; level: GLint; face: GLenum);stdcall;
  TglNamedFramebufferTextureLayer = procedure(framebuffer: GLuint; attachment: GLenum; texture: GLuint; level: GLint; layer: GLint);stdcall;
  TglNamedFramebufferTextureLayerEXT = procedure(framebuffer: GLuint; attachment: GLenum; texture: GLuint; level: GLint; layer: GLint);stdcall;
  TglNamedProgramLocalParameter4dEXT = procedure(program_: GLuint; target: GLenum; index_: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble);stdcall;
  TglNamedProgramLocalParameter4dvEXT = procedure(program_: GLuint; target: GLenum; index_: GLuint; params: PGLdouble);stdcall;
  TglNamedProgramLocalParameter4fEXT = procedure(program_: GLuint; target: GLenum; index_: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat);stdcall;
  TglNamedProgramLocalParameter4fvEXT = procedure(program_: GLuint; target: GLenum; index_: GLuint; params: PGLfloat);stdcall;
  TglNamedProgramLocalParameterI4iEXT = procedure(program_: GLuint; target: GLenum; index_: GLuint; x: GLint; y: GLint; z: GLint; w: GLint);stdcall;
  TglNamedProgramLocalParameterI4ivEXT = procedure(program_: GLuint; target: GLenum; index_: GLuint; params: PGLint);stdcall;
  TglNamedProgramLocalParameterI4uiEXT = procedure(program_: GLuint; target: GLenum; index_: GLuint; x: GLuint; y: GLuint; z: GLuint; w: GLuint);stdcall;
  TglNamedProgramLocalParameterI4uivEXT = procedure(program_: GLuint; target: GLenum; index_: GLuint; params: PGLuint);stdcall;
  TglNamedProgramLocalParameters4fvEXT = procedure(program_: GLuint; target: GLenum; index_: GLuint; count: GLsizei; params: PGLfloat);stdcall;
  TglNamedProgramLocalParametersI4ivEXT = procedure(program_: GLuint; target: GLenum; index_: GLuint; count: GLsizei; params: PGLint);stdcall;
  TglNamedProgramLocalParametersI4uivEXT = procedure(program_: GLuint; target: GLenum; index_: GLuint; count: GLsizei; params: PGLuint);stdcall;
  TglNamedProgramStringEXT = procedure(program_: GLuint; target: GLenum; format: GLenum; len: GLsizei; string_: Pvoid);stdcall;
  TglNamedRenderbufferStorage = procedure(renderbuffer: GLuint; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglNamedRenderbufferStorageEXT = procedure(renderbuffer: GLuint; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglNamedRenderbufferStorageMultisample = procedure(renderbuffer: GLuint; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglNamedRenderbufferStorageMultisampleCoverageEXT = procedure(renderbuffer: GLuint; coverageSamples: GLsizei; colorSamples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglNamedRenderbufferStorageMultisampleEXT = procedure(renderbuffer: GLuint; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglNamedStringARB = procedure(type_: GLenum; namelen: GLint; name_: PGLchar; stringlen: GLint; string_: PGLchar);stdcall;
  TglNewList = procedure(list: GLuint; mode: GLenum);stdcall;
  TglNewObjectBufferATI = function(size: GLsizei; pointer: Pvoid; usage: GLenum): GLuint;stdcall;
  TglNormal3b = procedure(nx: GLbyte; ny: GLbyte; nz: GLbyte);stdcall;
  TglNormal3bv = procedure(v: PGLbyte);stdcall;
  TglNormal3d = procedure(nx: GLdouble; ny: GLdouble; nz: GLdouble);stdcall;
  TglNormal3dv = procedure(v: PGLdouble);stdcall;
  TglNormal3f = procedure(nx: GLfloat; ny: GLfloat; nz: GLfloat);stdcall;
  TglNormal3fVertex3fSUN = procedure(nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglNormal3fVertex3fvSUN = procedure(n: PGLfloat; v: PGLfloat);stdcall;
  TglNormal3fv = procedure(v: PGLfloat);stdcall;
  TglNormal3hNV = procedure(nx: GLhalfNV; ny: GLhalfNV; nz: GLhalfNV);stdcall;
  TglNormal3hvNV = procedure(v: PGLhalfNV);stdcall;
  TglNormal3i = procedure(nx: GLint; ny: GLint; nz: GLint);stdcall;
  TglNormal3iv = procedure(v: PGLint);stdcall;
  TglNormal3s = procedure(nx: GLshort; ny: GLshort; nz: GLshort);stdcall;
  TglNormal3sv = procedure(v: PGLshort);stdcall;
  TglNormal3x = procedure(nx: GLfixed; ny: GLfixed; nz: GLfixed);stdcall;
  TglNormal3xOES = procedure(nx: GLfixed; ny: GLfixed; nz: GLfixed);stdcall;
  TglNormal3xvOES = procedure(coords: PGLfixed);stdcall;
  TglNormalFormatNV = procedure(type_: GLenum; stride: GLsizei);stdcall;
  TglNormalP3ui = procedure(type_: GLenum; coords: GLuint);stdcall;
  TglNormalP3uiv = procedure(type_: GLenum; coords: PGLuint);stdcall;
  TglNormalPointer = procedure(type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglNormalPointerEXT = procedure(type_: GLenum; stride: GLsizei; count: GLsizei; pointer: Pvoid);stdcall;
  TglNormalPointerListIBM = procedure(type_: GLenum; stride: GLint; pointer: PPvoid; ptrstride: GLint);stdcall;
  TglNormalPointervINTEL = procedure(type_: GLenum; pointer: PPvoid);stdcall;
  TglNormalStream3bATI = procedure(stream: GLenum; nx: GLbyte; ny: GLbyte; nz: GLbyte);stdcall;
  TglNormalStream3bvATI = procedure(stream: GLenum; coords: PGLbyte);stdcall;
  TglNormalStream3dATI = procedure(stream: GLenum; nx: GLdouble; ny: GLdouble; nz: GLdouble);stdcall;
  TglNormalStream3dvATI = procedure(stream: GLenum; coords: PGLdouble);stdcall;
  TglNormalStream3fATI = procedure(stream: GLenum; nx: GLfloat; ny: GLfloat; nz: GLfloat);stdcall;
  TglNormalStream3fvATI = procedure(stream: GLenum; coords: PGLfloat);stdcall;
  TglNormalStream3iATI = procedure(stream: GLenum; nx: GLint; ny: GLint; nz: GLint);stdcall;
  TglNormalStream3ivATI = procedure(stream: GLenum; coords: PGLint);stdcall;
  TglNormalStream3sATI = procedure(stream: GLenum; nx: GLshort; ny: GLshort; nz: GLshort);stdcall;
  TglNormalStream3svATI = procedure(stream: GLenum; coords: PGLshort);stdcall;
  TglObjectLabel = procedure(identifier: GLenum; name_: GLuint; length: GLsizei; label_: PGLchar);stdcall;
  TglObjectLabelKHR = procedure(identifier: GLenum; name_: GLuint; length: GLsizei; label_: PGLchar);stdcall;
  TglObjectPtrLabel = procedure(ptr: Pvoid; length: GLsizei; label_: PGLchar);stdcall;
  TglObjectPtrLabelKHR = procedure(ptr: Pvoid; length: GLsizei; label_: PGLchar);stdcall;
  TglObjectPurgeableAPPLE = function(objectType: GLenum; name_: GLuint; option: GLenum): GLenum;stdcall;
  TglObjectUnpurgeableAPPLE = function(objectType: GLenum; name_: GLuint; option: GLenum): GLenum;stdcall;
  TglOrtho = procedure(left: GLdouble; right: GLdouble; bottom: GLdouble; top: GLdouble; zNear: GLdouble; zFar: GLdouble);stdcall;
  TglOrthof = procedure(l: GLfloat; r: GLfloat; b: GLfloat; t: GLfloat; n: GLfloat; f: GLfloat);stdcall;
  TglOrthofOES = procedure(l: GLfloat; r: GLfloat; b: GLfloat; t: GLfloat; n: GLfloat; f: GLfloat);stdcall;
  TglOrthox = procedure(l: GLfixed; r: GLfixed; b: GLfixed; t: GLfixed; n: GLfixed; f: GLfixed);stdcall;
  TglOrthoxOES = procedure(l: GLfixed; r: GLfixed; b: GLfixed; t: GLfixed; n: GLfixed; f: GLfixed);stdcall;
  TglPNTrianglesfATI = procedure(pname: GLenum; param: GLfloat);stdcall;
  TglPNTrianglesiATI = procedure(pname: GLenum; param: GLint);stdcall;
  TglPassTexCoordATI = procedure(dst: GLuint; coord: GLuint; swizzle: GLenum);stdcall;
  TglPassThrough = procedure(token: GLfloat);stdcall;
  TglPassThroughxOES = procedure(token: GLfixed);stdcall;
  TglPatchParameterfv = procedure(pname: GLenum; values: PGLfloat);stdcall;
  TglPatchParameteri = procedure(pname: GLenum; value: GLint);stdcall;
  TglPatchParameteriEXT = procedure(pname: GLenum; value: GLint);stdcall;
  TglPatchParameteriOES = procedure(pname: GLenum; value: GLint);stdcall;
  TglPathColorGenNV = procedure(color: GLenum; genMode: GLenum; colorFormat: GLenum; coeffs: PGLfloat);stdcall;
  TglPathCommandsNV = procedure(path: GLuint; numCommands: GLsizei; commands: PGLubyte; numCoords: GLsizei; coordType: GLenum; coords: Pvoid);stdcall;
  TglPathCoordsNV = procedure(path: GLuint; numCoords: GLsizei; coordType: GLenum; coords: Pvoid);stdcall;
  TglPathCoverDepthFuncNV = procedure(func: GLenum);stdcall;
  TglPathDashArrayNV = procedure(path: GLuint; dashCount: GLsizei; dashArray: PGLfloat);stdcall;
  TglPathFogGenNV = procedure(genMode: GLenum);stdcall;
  TglPathGlyphIndexArrayNV = function(firstPathName: GLuint; fontTarget: GLenum; fontName: Pvoid; fontStyle: GLbitfield; firstGlyphIndex: GLuint; numGlyphs: GLsizei; pathParameterTemplate: GLuint; emScale: GLfloat): GLenum;stdcall;
  TglPathGlyphIndexRangeNV = function(fontTarget: GLenum; fontName: Pvoid; fontStyle: GLbitfield; pathParameterTemplate: GLuint; emScale: GLfloat; baseAndCount: PGLuint): GLenum;stdcall;
  TglPathGlyphRangeNV = procedure(firstPathName: GLuint; fontTarget: GLenum; fontName: Pvoid; fontStyle: GLbitfield; firstGlyph: GLuint; numGlyphs: GLsizei; handleMissingGlyphs: GLenum; pathParameterTemplate: GLuint; emScale: GLfloat);stdcall;
  TglPathGlyphsNV = procedure(firstPathName: GLuint; fontTarget: GLenum; fontName: Pvoid; fontStyle: GLbitfield; numGlyphs: GLsizei; type_: GLenum; charcodes: Pvoid; handleMissingGlyphs: GLenum; pathParameterTemplate: GLuint; emScale: GLfloat);stdcall;
  TglPathMemoryGlyphIndexArrayNV = function(firstPathName: GLuint; fontTarget: GLenum; fontSize: GLsizeiptr; fontData: Pvoid; faceIndex: GLsizei; firstGlyphIndex: GLuint; numGlyphs: GLsizei; pathParameterTemplate: GLuint; emScale: GLfloat): GLenum;stdcall;
  TglPathParameterfNV = procedure(path: GLuint; pname: GLenum; value: GLfloat);stdcall;
  TglPathParameterfvNV = procedure(path: GLuint; pname: GLenum; value: PGLfloat);stdcall;
  TglPathParameteriNV = procedure(path: GLuint; pname: GLenum; value: GLint);stdcall;
  TglPathParameterivNV = procedure(path: GLuint; pname: GLenum; value: PGLint);stdcall;
  TglPathStencilDepthOffsetNV = procedure(factor: GLfloat; units: GLfloat);stdcall;
  TglPathStencilFuncNV = procedure(func: GLenum; ref: GLint; mask: GLuint);stdcall;
  TglPathStringNV = procedure(path: GLuint; format: GLenum; length: GLsizei; pathString: Pvoid);stdcall;
  TglPathSubCommandsNV = procedure(path: GLuint; commandStart: GLsizei; commandsToDelete: GLsizei; numCommands: GLsizei; commands: PGLubyte; numCoords: GLsizei; coordType: GLenum; coords: Pvoid);stdcall;
  TglPathSubCoordsNV = procedure(path: GLuint; coordStart: GLsizei; numCoords: GLsizei; coordType: GLenum; coords: Pvoid);stdcall;
  TglPathTexGenNV = procedure(texCoordSet: GLenum; genMode: GLenum; components: GLint; coeffs: PGLfloat);stdcall;
  TglPauseTransformFeedback = procedure;stdcall;
  TglPauseTransformFeedbackNV = procedure;stdcall;
  TglPixelDataRangeNV = procedure(target: GLenum; length: GLsizei; pointer: Pvoid);stdcall;
  TglPixelMapfv = procedure(map: GLenum; mapsize: GLsizei; values: PGLfloat);stdcall;
  TglPixelMapuiv = procedure(map: GLenum; mapsize: GLsizei; values: PGLuint);stdcall;
  TglPixelMapusv = procedure(map: GLenum; mapsize: GLsizei; values: PGLushort);stdcall;
  TglPixelMapx = procedure(map: GLenum; size: GLint; values: PGLfixed);stdcall;
  TglPixelStoref = procedure(pname: GLenum; param: GLfloat);stdcall;
  TglPixelStorei = procedure(pname: GLenum; param: GLint);stdcall;
  TglPixelStorex = procedure(pname: GLenum; param: GLfixed);stdcall;
  TglPixelTexGenParameterfSGIS = procedure(pname: GLenum; param: GLfloat);stdcall;
  TglPixelTexGenParameterfvSGIS = procedure(pname: GLenum; params: PGLfloat);stdcall;
  TglPixelTexGenParameteriSGIS = procedure(pname: GLenum; param: GLint);stdcall;
  TglPixelTexGenParameterivSGIS = procedure(pname: GLenum; params: PGLint);stdcall;
  TglPixelTexGenSGIX = procedure(mode: GLenum);stdcall;
  TglPixelTransferf = procedure(pname: GLenum; param: GLfloat);stdcall;
  TglPixelTransferi = procedure(pname: GLenum; param: GLint);stdcall;
  TglPixelTransferxOES = procedure(pname: GLenum; param: GLfixed);stdcall;
  TglPixelTransformParameterfEXT = procedure(target: GLenum; pname: GLenum; param: GLfloat);stdcall;
  TglPixelTransformParameterfvEXT = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglPixelTransformParameteriEXT = procedure(target: GLenum; pname: GLenum; param: GLint);stdcall;
  TglPixelTransformParameterivEXT = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglPixelZoom = procedure(xfactor: GLfloat; yfactor: GLfloat);stdcall;
  TglPixelZoomxOES = procedure(xfactor: GLfixed; yfactor: GLfixed);stdcall;
  TglPointAlongPathNV = function(path: GLuint; startSegment: GLsizei; numSegments: GLsizei; distance: GLfloat; x: PGLfloat; y: PGLfloat; tangentX: PGLfloat; tangentY: PGLfloat): GLboolean;stdcall;
  TglPointParameterf = procedure(pname: GLenum; param: GLfloat);stdcall;
  TglPointParameterfARB = procedure(pname: GLenum; param: GLfloat);stdcall;
  TglPointParameterfEXT = procedure(pname: GLenum; param: GLfloat);stdcall;
  TglPointParameterfSGIS = procedure(pname: GLenum; param: GLfloat);stdcall;
  TglPointParameterfv = procedure(pname: GLenum; params: PGLfloat);stdcall;
  TglPointParameterfvARB = procedure(pname: GLenum; params: PGLfloat);stdcall;
  TglPointParameterfvEXT = procedure(pname: GLenum; params: PGLfloat);stdcall;
  TglPointParameterfvSGIS = procedure(pname: GLenum; params: PGLfloat);stdcall;
  TglPointParameteri = procedure(pname: GLenum; param: GLint);stdcall;
  TglPointParameteriNV = procedure(pname: GLenum; param: GLint);stdcall;
  TglPointParameteriv = procedure(pname: GLenum; params: PGLint);stdcall;
  TglPointParameterivNV = procedure(pname: GLenum; params: PGLint);stdcall;
  TglPointParameterx = procedure(pname: GLenum; param: GLfixed);stdcall;
  TglPointParameterxOES = procedure(pname: GLenum; param: GLfixed);stdcall;
  TglPointParameterxv = procedure(pname: GLenum; params: PGLfixed);stdcall;
  TglPointParameterxvOES = procedure(pname: GLenum; params: PGLfixed);stdcall;
  TglPointSize = procedure(size: GLfloat);stdcall;
  TglPointSizePointerOES = procedure(type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglPointSizex = procedure(size: GLfixed);stdcall;
  TglPointSizexOES = procedure(size: GLfixed);stdcall;
  TglPollAsyncSGIX = function(markerp: PGLuint): GLint;stdcall;
  TglPollInstrumentsSGIX = function(marker_p: PGLint): GLint;stdcall;
  TglPolygonMode = procedure(face: GLenum; mode: GLenum);stdcall;
  TglPolygonModeNV = procedure(face: GLenum; mode: GLenum);stdcall;
  TglPolygonOffset = procedure(factor: GLfloat; units: GLfloat);stdcall;
  TglPolygonOffsetClamp = procedure(factor: GLfloat; units: GLfloat; clamp: GLfloat);stdcall;
  TglPolygonOffsetClampEXT = procedure(factor: GLfloat; units: GLfloat; clamp: GLfloat);stdcall;
  TglPolygonOffsetEXT = procedure(factor: GLfloat; bias: GLfloat);stdcall;
  TglPolygonOffsetx = procedure(factor: GLfixed; units: GLfixed);stdcall;
  TglPolygonOffsetxOES = procedure(factor: GLfixed; units: GLfixed);stdcall;
  TglPolygonStipple = procedure(mask: PGLubyte);stdcall;
  TglPopAttrib = procedure;stdcall;
  TglPopClientAttrib = procedure;stdcall;
  TglPopDebugGroup = procedure;stdcall;
  TglPopDebugGroupKHR = procedure;stdcall;
  TglPopGroupMarkerEXT = procedure;stdcall;
  TglPopMatrix = procedure;stdcall;
  TglPopName = procedure;stdcall;
  TglPresentFrameDualFillNV = procedure(video_slot: GLuint; minPresentTime: GLuint64EXT; beginPresentTimeId: GLuint; presentDurationId: GLuint; type_: GLenum; target0: GLenum; fill0: GLuint; target1: GLenum; fill1: GLuint; target2: GLenum; fill2: GLuint; target3: GLenum; fill3: GLuint);stdcall;
  TglPresentFrameKeyedNV = procedure(video_slot: GLuint; minPresentTime: GLuint64EXT; beginPresentTimeId: GLuint; presentDurationId: GLuint; type_: GLenum; target0: GLenum; fill0: GLuint; key0: GLuint; target1: GLenum; fill1: GLuint; key1: GLuint);stdcall;
  TglPrimitiveBoundingBox = procedure(minX: GLfloat; minY: GLfloat; minZ: GLfloat; minW: GLfloat; maxX: GLfloat; maxY: GLfloat; maxZ: GLfloat; maxW: GLfloat);stdcall;
  TglPrimitiveBoundingBoxARB = procedure(minX: GLfloat; minY: GLfloat; minZ: GLfloat; minW: GLfloat; maxX: GLfloat; maxY: GLfloat; maxZ: GLfloat; maxW: GLfloat);stdcall;
  TglPrimitiveBoundingBoxEXT = procedure(minX: GLfloat; minY: GLfloat; minZ: GLfloat; minW: GLfloat; maxX: GLfloat; maxY: GLfloat; maxZ: GLfloat; maxW: GLfloat);stdcall;
  TglPrimitiveBoundingBoxOES = procedure(minX: GLfloat; minY: GLfloat; minZ: GLfloat; minW: GLfloat; maxX: GLfloat; maxY: GLfloat; maxZ: GLfloat; maxW: GLfloat);stdcall;
  TglPrimitiveRestartIndex = procedure(index_: GLuint);stdcall;
  TglPrimitiveRestartIndexNV = procedure(index_: GLuint);stdcall;
  TglPrimitiveRestartNV = procedure;stdcall;
  TglPrioritizeTextures = procedure(n: GLsizei; textures: PGLuint; priorities: PGLfloat);stdcall;
  TglPrioritizeTexturesEXT = procedure(n: GLsizei; textures: PGLuint; priorities: PGLclampf);stdcall;
  TglPrioritizeTexturesxOES = procedure(n: GLsizei; textures: PGLuint; priorities: PGLfixed);stdcall;
  TglProgramBinary = procedure(program_: GLuint; binaryFormat: GLenum; binary: Pvoid; length: GLsizei);stdcall;
  TglProgramBinaryOES = procedure(program_: GLuint; binaryFormat: GLenum; binary: Pvoid; length: GLint);stdcall;
  TglProgramBufferParametersIivNV = procedure(target: GLenum; bindingIndex: GLuint; wordIndex: GLuint; count: GLsizei; params: PGLint);stdcall;
  TglProgramBufferParametersIuivNV = procedure(target: GLenum; bindingIndex: GLuint; wordIndex: GLuint; count: GLsizei; params: PGLuint);stdcall;
  TglProgramBufferParametersfvNV = procedure(target: GLenum; bindingIndex: GLuint; wordIndex: GLuint; count: GLsizei; params: PGLfloat);stdcall;
  TglProgramEnvParameter4dARB = procedure(target: GLenum; index_: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble);stdcall;
  TglProgramEnvParameter4dvARB = procedure(target: GLenum; index_: GLuint; params: PGLdouble);stdcall;
  TglProgramEnvParameter4fARB = procedure(target: GLenum; index_: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat);stdcall;
  TglProgramEnvParameter4fvARB = procedure(target: GLenum; index_: GLuint; params: PGLfloat);stdcall;
  TglProgramEnvParameterI4iNV = procedure(target: GLenum; index_: GLuint; x: GLint; y: GLint; z: GLint; w: GLint);stdcall;
  TglProgramEnvParameterI4ivNV = procedure(target: GLenum; index_: GLuint; params: PGLint);stdcall;
  TglProgramEnvParameterI4uiNV = procedure(target: GLenum; index_: GLuint; x: GLuint; y: GLuint; z: GLuint; w: GLuint);stdcall;
  TglProgramEnvParameterI4uivNV = procedure(target: GLenum; index_: GLuint; params: PGLuint);stdcall;
  TglProgramEnvParameters4fvEXT = procedure(target: GLenum; index_: GLuint; count: GLsizei; params: PGLfloat);stdcall;
  TglProgramEnvParametersI4ivNV = procedure(target: GLenum; index_: GLuint; count: GLsizei; params: PGLint);stdcall;
  TglProgramEnvParametersI4uivNV = procedure(target: GLenum; index_: GLuint; count: GLsizei; params: PGLuint);stdcall;
  TglProgramLocalParameter4dARB = procedure(target: GLenum; index_: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble);stdcall;
  TglProgramLocalParameter4dvARB = procedure(target: GLenum; index_: GLuint; params: PGLdouble);stdcall;
  TglProgramLocalParameter4fARB = procedure(target: GLenum; index_: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat);stdcall;
  TglProgramLocalParameter4fvARB = procedure(target: GLenum; index_: GLuint; params: PGLfloat);stdcall;
  TglProgramLocalParameterI4iNV = procedure(target: GLenum; index_: GLuint; x: GLint; y: GLint; z: GLint; w: GLint);stdcall;
  TglProgramLocalParameterI4ivNV = procedure(target: GLenum; index_: GLuint; params: PGLint);stdcall;
  TglProgramLocalParameterI4uiNV = procedure(target: GLenum; index_: GLuint; x: GLuint; y: GLuint; z: GLuint; w: GLuint);stdcall;
  TglProgramLocalParameterI4uivNV = procedure(target: GLenum; index_: GLuint; params: PGLuint);stdcall;
  TglProgramLocalParameters4fvEXT = procedure(target: GLenum; index_: GLuint; count: GLsizei; params: PGLfloat);stdcall;
  TglProgramLocalParametersI4ivNV = procedure(target: GLenum; index_: GLuint; count: GLsizei; params: PGLint);stdcall;
  TglProgramLocalParametersI4uivNV = procedure(target: GLenum; index_: GLuint; count: GLsizei; params: PGLuint);stdcall;
  TglProgramNamedParameter4dNV = procedure(id: GLuint; len: GLsizei; name_: PGLubyte; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble);stdcall;
  TglProgramNamedParameter4dvNV = procedure(id: GLuint; len: GLsizei; name_: PGLubyte; v: PGLdouble);stdcall;
  TglProgramNamedParameter4fNV = procedure(id: GLuint; len: GLsizei; name_: PGLubyte; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat);stdcall;
  TglProgramNamedParameter4fvNV = procedure(id: GLuint; len: GLsizei; name_: PGLubyte; v: PGLfloat);stdcall;
  TglProgramParameter4dNV = procedure(target: GLenum; index_: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble);stdcall;
  TglProgramParameter4dvNV = procedure(target: GLenum; index_: GLuint; v: PGLdouble);stdcall;
  TglProgramParameter4fNV = procedure(target: GLenum; index_: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat);stdcall;
  TglProgramParameter4fvNV = procedure(target: GLenum; index_: GLuint; v: PGLfloat);stdcall;
  TglProgramParameteri = procedure(program_: GLuint; pname: GLenum; value: GLint);stdcall;
  TglProgramParameteriARB = procedure(program_: GLuint; pname: GLenum; value: GLint);stdcall;
  TglProgramParameteriEXT = procedure(program_: GLuint; pname: GLenum; value: GLint);stdcall;
  TglProgramParameters4dvNV = procedure(target: GLenum; index_: GLuint; count: GLsizei; v: PGLdouble);stdcall;
  TglProgramParameters4fvNV = procedure(target: GLenum; index_: GLuint; count: GLsizei; v: PGLfloat);stdcall;
  TglProgramPathFragmentInputGenNV = procedure(program_: GLuint; location: GLint; genMode: GLenum; components: GLint; coeffs: PGLfloat);stdcall;
  TglProgramStringARB = procedure(target: GLenum; format: GLenum; len: GLsizei; string_: Pvoid);stdcall;
  TglProgramSubroutineParametersuivNV = procedure(target: GLenum; count: GLsizei; params: PGLuint);stdcall;
  TglProgramUniform1d = procedure(program_: GLuint; location: GLint; v0: GLdouble);stdcall;
  TglProgramUniform1dEXT = procedure(program_: GLuint; location: GLint; x: GLdouble);stdcall;
  TglProgramUniform1dv = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLdouble);stdcall;
  TglProgramUniform1dvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLdouble);stdcall;
  TglProgramUniform1f = procedure(program_: GLuint; location: GLint; v0: GLfloat);stdcall;
  TglProgramUniform1fEXT = procedure(program_: GLuint; location: GLint; v0: GLfloat);stdcall;
  TglProgramUniform1fv = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLfloat);stdcall;
  TglProgramUniform1fvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLfloat);stdcall;
  TglProgramUniform1i = procedure(program_: GLuint; location: GLint; v0: GLint);stdcall;
  TglProgramUniform1i64ARB = procedure(program_: GLuint; location: GLint; x: GLint64);stdcall;
  TglProgramUniform1i64NV = procedure(program_: GLuint; location: GLint; x: GLint64EXT);stdcall;
  TglProgramUniform1i64vARB = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLint64);stdcall;
  TglProgramUniform1i64vNV = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLint64EXT);stdcall;
  TglProgramUniform1iEXT = procedure(program_: GLuint; location: GLint; v0: GLint);stdcall;
  TglProgramUniform1iv = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLint);stdcall;
  TglProgramUniform1ivEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLint);stdcall;
  TglProgramUniform1ui = procedure(program_: GLuint; location: GLint; v0: GLuint);stdcall;
  TglProgramUniform1ui64ARB = procedure(program_: GLuint; location: GLint; x: GLuint64);stdcall;
  TglProgramUniform1ui64NV = procedure(program_: GLuint; location: GLint; x: GLuint64EXT);stdcall;
  TglProgramUniform1ui64vARB = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint64);stdcall;
  TglProgramUniform1ui64vNV = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint64EXT);stdcall;
  TglProgramUniform1uiEXT = procedure(program_: GLuint; location: GLint; v0: GLuint);stdcall;
  TglProgramUniform1uiv = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint);stdcall;
  TglProgramUniform1uivEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint);stdcall;
  TglProgramUniform2d = procedure(program_: GLuint; location: GLint; v0: GLdouble; v1: GLdouble);stdcall;
  TglProgramUniform2dEXT = procedure(program_: GLuint; location: GLint; x: GLdouble; y: GLdouble);stdcall;
  TglProgramUniform2dv = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLdouble);stdcall;
  TglProgramUniform2dvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLdouble);stdcall;
  TglProgramUniform2f = procedure(program_: GLuint; location: GLint; v0: GLfloat; v1: GLfloat);stdcall;
  TglProgramUniform2fEXT = procedure(program_: GLuint; location: GLint; v0: GLfloat; v1: GLfloat);stdcall;
  TglProgramUniform2fv = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLfloat);stdcall;
  TglProgramUniform2fvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLfloat);stdcall;
  TglProgramUniform2i = procedure(program_: GLuint; location: GLint; v0: GLint; v1: GLint);stdcall;
  TglProgramUniform2i64ARB = procedure(program_: GLuint; location: GLint; x: GLint64; y: GLint64);stdcall;
  TglProgramUniform2i64NV = procedure(program_: GLuint; location: GLint; x: GLint64EXT; y: GLint64EXT);stdcall;
  TglProgramUniform2i64vARB = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLint64);stdcall;
  TglProgramUniform2i64vNV = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLint64EXT);stdcall;
  TglProgramUniform2iEXT = procedure(program_: GLuint; location: GLint; v0: GLint; v1: GLint);stdcall;
  TglProgramUniform2iv = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLint);stdcall;
  TglProgramUniform2ivEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLint);stdcall;
  TglProgramUniform2ui = procedure(program_: GLuint; location: GLint; v0: GLuint; v1: GLuint);stdcall;
  TglProgramUniform2ui64ARB = procedure(program_: GLuint; location: GLint; x: GLuint64; y: GLuint64);stdcall;
  TglProgramUniform2ui64NV = procedure(program_: GLuint; location: GLint; x: GLuint64EXT; y: GLuint64EXT);stdcall;
  TglProgramUniform2ui64vARB = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint64);stdcall;
  TglProgramUniform2ui64vNV = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint64EXT);stdcall;
  TglProgramUniform2uiEXT = procedure(program_: GLuint; location: GLint; v0: GLuint; v1: GLuint);stdcall;
  TglProgramUniform2uiv = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint);stdcall;
  TglProgramUniform2uivEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint);stdcall;
  TglProgramUniform3d = procedure(program_: GLuint; location: GLint; v0: GLdouble; v1: GLdouble; v2: GLdouble);stdcall;
  TglProgramUniform3dEXT = procedure(program_: GLuint; location: GLint; x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglProgramUniform3dv = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLdouble);stdcall;
  TglProgramUniform3dvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLdouble);stdcall;
  TglProgramUniform3f = procedure(program_: GLuint; location: GLint; v0: GLfloat; v1: GLfloat; v2: GLfloat);stdcall;
  TglProgramUniform3fEXT = procedure(program_: GLuint; location: GLint; v0: GLfloat; v1: GLfloat; v2: GLfloat);stdcall;
  TglProgramUniform3fv = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLfloat);stdcall;
  TglProgramUniform3fvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLfloat);stdcall;
  TglProgramUniform3i = procedure(program_: GLuint; location: GLint; v0: GLint; v1: GLint; v2: GLint);stdcall;
  TglProgramUniform3i64ARB = procedure(program_: GLuint; location: GLint; x: GLint64; y: GLint64; z: GLint64);stdcall;
  TglProgramUniform3i64NV = procedure(program_: GLuint; location: GLint; x: GLint64EXT; y: GLint64EXT; z: GLint64EXT);stdcall;
  TglProgramUniform3i64vARB = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLint64);stdcall;
  TglProgramUniform3i64vNV = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLint64EXT);stdcall;
  TglProgramUniform3iEXT = procedure(program_: GLuint; location: GLint; v0: GLint; v1: GLint; v2: GLint);stdcall;
  TglProgramUniform3iv = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLint);stdcall;
  TglProgramUniform3ivEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLint);stdcall;
  TglProgramUniform3ui = procedure(program_: GLuint; location: GLint; v0: GLuint; v1: GLuint; v2: GLuint);stdcall;
  TglProgramUniform3ui64ARB = procedure(program_: GLuint; location: GLint; x: GLuint64; y: GLuint64; z: GLuint64);stdcall;
  TglProgramUniform3ui64NV = procedure(program_: GLuint; location: GLint; x: GLuint64EXT; y: GLuint64EXT; z: GLuint64EXT);stdcall;
  TglProgramUniform3ui64vARB = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint64);stdcall;
  TglProgramUniform3ui64vNV = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint64EXT);stdcall;
  TglProgramUniform3uiEXT = procedure(program_: GLuint; location: GLint; v0: GLuint; v1: GLuint; v2: GLuint);stdcall;
  TglProgramUniform3uiv = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint);stdcall;
  TglProgramUniform3uivEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint);stdcall;
  TglProgramUniform4d = procedure(program_: GLuint; location: GLint; v0: GLdouble; v1: GLdouble; v2: GLdouble; v3: GLdouble);stdcall;
  TglProgramUniform4dEXT = procedure(program_: GLuint; location: GLint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble);stdcall;
  TglProgramUniform4dv = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLdouble);stdcall;
  TglProgramUniform4dvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLdouble);stdcall;
  TglProgramUniform4f = procedure(program_: GLuint; location: GLint; v0: GLfloat; v1: GLfloat; v2: GLfloat; v3: GLfloat);stdcall;
  TglProgramUniform4fEXT = procedure(program_: GLuint; location: GLint; v0: GLfloat; v1: GLfloat; v2: GLfloat; v3: GLfloat);stdcall;
  TglProgramUniform4fv = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLfloat);stdcall;
  TglProgramUniform4fvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLfloat);stdcall;
  TglProgramUniform4i = procedure(program_: GLuint; location: GLint; v0: GLint; v1: GLint; v2: GLint; v3: GLint);stdcall;
  TglProgramUniform4i64ARB = procedure(program_: GLuint; location: GLint; x: GLint64; y: GLint64; z: GLint64; w: GLint64);stdcall;
  TglProgramUniform4i64NV = procedure(program_: GLuint; location: GLint; x: GLint64EXT; y: GLint64EXT; z: GLint64EXT; w: GLint64EXT);stdcall;
  TglProgramUniform4i64vARB = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLint64);stdcall;
  TglProgramUniform4i64vNV = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLint64EXT);stdcall;
  TglProgramUniform4iEXT = procedure(program_: GLuint; location: GLint; v0: GLint; v1: GLint; v2: GLint; v3: GLint);stdcall;
  TglProgramUniform4iv = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLint);stdcall;
  TglProgramUniform4ivEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLint);stdcall;
  TglProgramUniform4ui = procedure(program_: GLuint; location: GLint; v0: GLuint; v1: GLuint; v2: GLuint; v3: GLuint);stdcall;
  TglProgramUniform4ui64ARB = procedure(program_: GLuint; location: GLint; x: GLuint64; y: GLuint64; z: GLuint64; w: GLuint64);stdcall;
  TglProgramUniform4ui64NV = procedure(program_: GLuint; location: GLint; x: GLuint64EXT; y: GLuint64EXT; z: GLuint64EXT; w: GLuint64EXT);stdcall;
  TglProgramUniform4ui64vARB = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint64);stdcall;
  TglProgramUniform4ui64vNV = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint64EXT);stdcall;
  TglProgramUniform4uiEXT = procedure(program_: GLuint; location: GLint; v0: GLuint; v1: GLuint; v2: GLuint; v3: GLuint);stdcall;
  TglProgramUniform4uiv = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint);stdcall;
  TglProgramUniform4uivEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint);stdcall;
  TglProgramUniformHandleui64ARB = procedure(program_: GLuint; location: GLint; value: GLuint64);stdcall;
  TglProgramUniformHandleui64IMG = procedure(program_: GLuint; location: GLint; value: GLuint64);stdcall;
  TglProgramUniformHandleui64NV = procedure(program_: GLuint; location: GLint; value: GLuint64);stdcall;
  TglProgramUniformHandleui64vARB = procedure(program_: GLuint; location: GLint; count: GLsizei; values: PGLuint64);stdcall;
  TglProgramUniformHandleui64vIMG = procedure(program_: GLuint; location: GLint; count: GLsizei; values: PGLuint64);stdcall;
  TglProgramUniformHandleui64vNV = procedure(program_: GLuint; location: GLint; count: GLsizei; values: PGLuint64);stdcall;
  TglProgramUniformMatrix2dv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix2dvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix2fv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix2fvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix2x3dv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix2x3dvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix2x3fv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix2x3fvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix2x4dv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix2x4dvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix2x4fv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix2x4fvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix3dv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix3dvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix3fv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix3fvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix3x2dv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix3x2dvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix3x2fv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix3x2fvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix3x4dv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix3x4dvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix3x4fv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix3x4fvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix4dv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix4dvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix4fv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix4fvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix4x2dv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix4x2dvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix4x2fv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix4x2fvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix4x3dv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix4x3dvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglProgramUniformMatrix4x3fv = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformMatrix4x3fvEXT = procedure(program_: GLuint; location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglProgramUniformui64NV = procedure(program_: GLuint; location: GLint; value: GLuint64EXT);stdcall;
  TglProgramUniformui64vNV = procedure(program_: GLuint; location: GLint; count: GLsizei; value: PGLuint64EXT);stdcall;
  TglProgramVertexLimitNV = procedure(target: GLenum; limit: GLint);stdcall;
  TglProvokingVertex = procedure(mode: GLenum);stdcall;
  TglProvokingVertexEXT = procedure(mode: GLenum);stdcall;
  TglPushAttrib = procedure(mask: GLbitfield);stdcall;
  TglPushClientAttrib = procedure(mask: GLbitfield);stdcall;
  TglPushClientAttribDefaultEXT = procedure(mask: GLbitfield);stdcall;
  TglPushDebugGroup = procedure(source: GLenum; id: GLuint; length: GLsizei; message_: PGLchar);stdcall;
  TglPushDebugGroupKHR = procedure(source: GLenum; id: GLuint; length: GLsizei; message_: PGLchar);stdcall;
  TglPushGroupMarkerEXT = procedure(length: GLsizei; marker: PGLchar);stdcall;
  TglPushMatrix = procedure;stdcall;
  TglPushName = procedure(name_: GLuint);stdcall;
  TglQueryCounter = procedure(id: GLuint; target: GLenum);stdcall;
  TglQueryCounterEXT = procedure(id: GLuint; target: GLenum);stdcall;
  TglQueryMatrixxOES = function(mantissa: PGLfixed; exponent: PGLint): GLbitfield;stdcall;
  TglQueryObjectParameteruiAMD = procedure(target: GLenum; id: GLuint; pname: GLenum; param: GLuint);stdcall;
  TglRasterPos2d = procedure(x: GLdouble; y: GLdouble);stdcall;
  TglRasterPos2dv = procedure(v: PGLdouble);stdcall;
  TglRasterPos2f = procedure(x: GLfloat; y: GLfloat);stdcall;
  TglRasterPos2fv = procedure(v: PGLfloat);stdcall;
  TglRasterPos2i = procedure(x: GLint; y: GLint);stdcall;
  TglRasterPos2iv = procedure(v: PGLint);stdcall;
  TglRasterPos2s = procedure(x: GLshort; y: GLshort);stdcall;
  TglRasterPos2sv = procedure(v: PGLshort);stdcall;
  TglRasterPos2xOES = procedure(x: GLfixed; y: GLfixed);stdcall;
  TglRasterPos2xvOES = procedure(coords: PGLfixed);stdcall;
  TglRasterPos3d = procedure(x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglRasterPos3dv = procedure(v: PGLdouble);stdcall;
  TglRasterPos3f = procedure(x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglRasterPos3fv = procedure(v: PGLfloat);stdcall;
  TglRasterPos3i = procedure(x: GLint; y: GLint; z: GLint);stdcall;
  TglRasterPos3iv = procedure(v: PGLint);stdcall;
  TglRasterPos3s = procedure(x: GLshort; y: GLshort; z: GLshort);stdcall;
  TglRasterPos3sv = procedure(v: PGLshort);stdcall;
  TglRasterPos3xOES = procedure(x: GLfixed; y: GLfixed; z: GLfixed);stdcall;
  TglRasterPos3xvOES = procedure(coords: PGLfixed);stdcall;
  TglRasterPos4d = procedure(x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble);stdcall;
  TglRasterPos4dv = procedure(v: PGLdouble);stdcall;
  TglRasterPos4f = procedure(x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat);stdcall;
  TglRasterPos4fv = procedure(v: PGLfloat);stdcall;
  TglRasterPos4i = procedure(x: GLint; y: GLint; z: GLint; w: GLint);stdcall;
  TglRasterPos4iv = procedure(v: PGLint);stdcall;
  TglRasterPos4s = procedure(x: GLshort; y: GLshort; z: GLshort; w: GLshort);stdcall;
  TglRasterPos4sv = procedure(v: PGLshort);stdcall;
  TglRasterPos4xOES = procedure(x: GLfixed; y: GLfixed; z: GLfixed; w: GLfixed);stdcall;
  TglRasterPos4xvOES = procedure(coords: PGLfixed);stdcall;
  TglRasterSamplesEXT = procedure(samples: GLuint; fixedsamplelocations: GLboolean);stdcall;
  TglReadBuffer = procedure(src: GLenum);stdcall;
  TglReadBufferIndexedEXT = procedure(src: GLenum; index_: GLint);stdcall;
  TglReadBufferNV = procedure(mode: GLenum);stdcall;
  TglReadInstrumentsSGIX = procedure(marker: GLint);stdcall;
  TglReadPixels = procedure(x: GLint; y: GLint; width: GLsizei; height: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglReadnPixels = procedure(x: GLint; y: GLint; width: GLsizei; height: GLsizei; format: GLenum; type_: GLenum; bufSize: GLsizei; data: Pvoid);stdcall;
  TglReadnPixelsARB = procedure(x: GLint; y: GLint; width: GLsizei; height: GLsizei; format: GLenum; type_: GLenum; bufSize: GLsizei; data: Pvoid);stdcall;
  TglReadnPixelsEXT = procedure(x: GLint; y: GLint; width: GLsizei; height: GLsizei; format: GLenum; type_: GLenum; bufSize: GLsizei; data: Pvoid);stdcall;
  TglReadnPixelsKHR = procedure(x: GLint; y: GLint; width: GLsizei; height: GLsizei; format: GLenum; type_: GLenum; bufSize: GLsizei; data: Pvoid);stdcall;
  TglReleaseKeyedMutexWin32EXT = function(memory: GLuint; key: GLuint64): GLboolean;stdcall;
  TglRectd = procedure(x1: GLdouble; y1: GLdouble; x2: GLdouble; y2: GLdouble);stdcall;
  TglRectdv = procedure(v1: PGLdouble; v2: PGLdouble);stdcall;
  TglRectf = procedure(x1: GLfloat; y1: GLfloat; x2: GLfloat; y2: GLfloat);stdcall;
  TglRectfv = procedure(v1: PGLfloat; v2: PGLfloat);stdcall;
  TglRecti = procedure(x1: GLint; y1: GLint; x2: GLint; y2: GLint);stdcall;
  TglRectiv = procedure(v1: PGLint; v2: PGLint);stdcall;
  TglRects = procedure(x1: GLshort; y1: GLshort; x2: GLshort; y2: GLshort);stdcall;
  TglRectsv = procedure(v1: PGLshort; v2: PGLshort);stdcall;
  TglRectxOES = procedure(x1: GLfixed; y1: GLfixed; x2: GLfixed; y2: GLfixed);stdcall;
  TglRectxvOES = procedure(v1: PGLfixed; v2: PGLfixed);stdcall;
  TglReferencePlaneSGIX = procedure(equation: PGLdouble);stdcall;
  TglReleaseShaderCompiler = procedure;stdcall;
  TglRenderGpuMaskNV = procedure(mask: GLbitfield);stdcall;
  TglRenderMode = function(mode: GLenum): GLint;stdcall;
  TglRenderbufferStorage = procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglRenderbufferStorageEXT = procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglRenderbufferStorageMultisample = procedure(target: GLenum; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglRenderbufferStorageMultisampleANGLE = procedure(target: GLenum; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglRenderbufferStorageMultisampleAPPLE = procedure(target: GLenum; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglRenderbufferStorageMultisampleCoverageNV = procedure(target: GLenum; coverageSamples: GLsizei; colorSamples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglRenderbufferStorageMultisampleEXT = procedure(target: GLenum; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglRenderbufferStorageMultisampleIMG = procedure(target: GLenum; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglRenderbufferStorageMultisampleNV = procedure(target: GLenum; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglRenderbufferStorageOES = procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglReplacementCodePointerSUN = procedure(type_: GLenum; stride: GLsizei; pointer: PPvoid);stdcall;
  TglReplacementCodeubSUN = procedure(code: GLubyte);stdcall;
  TglReplacementCodeubvSUN = procedure(code: PGLubyte);stdcall;
  TglReplacementCodeuiColor3fVertex3fSUN = procedure(rc: GLuint; r: GLfloat; g: GLfloat; b: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglReplacementCodeuiColor3fVertex3fvSUN = procedure(rc: PGLuint; c: PGLfloat; v: PGLfloat);stdcall;
  TglReplacementCodeuiColor4fNormal3fVertex3fSUN = procedure(rc: GLuint; r: GLfloat; g: GLfloat; b: GLfloat; a: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglReplacementCodeuiColor4fNormal3fVertex3fvSUN = procedure(rc: PGLuint; c: PGLfloat; n: PGLfloat; v: PGLfloat);stdcall;
  TglReplacementCodeuiColor4ubVertex3fSUN = procedure(rc: GLuint; r: GLubyte; g: GLubyte; b: GLubyte; a: GLubyte; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglReplacementCodeuiColor4ubVertex3fvSUN = procedure(rc: PGLuint; c: PGLubyte; v: PGLfloat);stdcall;
  TglReplacementCodeuiNormal3fVertex3fSUN = procedure(rc: GLuint; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglReplacementCodeuiNormal3fVertex3fvSUN = procedure(rc: PGLuint; n: PGLfloat; v: PGLfloat);stdcall;
  TglReplacementCodeuiSUN = procedure(code: GLuint);stdcall;
  TglReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN = procedure(rc: GLuint; s: GLfloat; t: GLfloat; r: GLfloat; g: GLfloat; b: GLfloat; a: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN = procedure(rc: PGLuint; tc: PGLfloat; c: PGLfloat; n: PGLfloat; v: PGLfloat);stdcall;
  TglReplacementCodeuiTexCoord2fNormal3fVertex3fSUN = procedure(rc: GLuint; s: GLfloat; t: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN = procedure(rc: PGLuint; tc: PGLfloat; n: PGLfloat; v: PGLfloat);stdcall;
  TglReplacementCodeuiTexCoord2fVertex3fSUN = procedure(rc: GLuint; s: GLfloat; t: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglReplacementCodeuiTexCoord2fVertex3fvSUN = procedure(rc: PGLuint; tc: PGLfloat; v: PGLfloat);stdcall;
  TglReplacementCodeuiVertex3fSUN = procedure(rc: GLuint; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglReplacementCodeuiVertex3fvSUN = procedure(rc: PGLuint; v: PGLfloat);stdcall;
  TglReplacementCodeuivSUN = procedure(code: PGLuint);stdcall;
  TglReplacementCodeusSUN = procedure(code: GLushort);stdcall;
  TglReplacementCodeusvSUN = procedure(code: PGLushort);stdcall;
  TglRequestResidentProgramsNV = procedure(n: GLsizei; programs: PGLuint);stdcall;
  TglResetHistogram = procedure(target: GLenum);stdcall;
  TglResetHistogramEXT = procedure(target: GLenum);stdcall;
  TglResetMinmax = procedure(target: GLenum);stdcall;
  TglResetMinmaxEXT = procedure(target: GLenum);stdcall;
  TglResizeBuffersMESA = procedure;stdcall;
  TglResolveDepthValuesNV = procedure;stdcall;
  TglResolveMultisampleFramebufferAPPLE = procedure;stdcall;
  TglResumeTransformFeedback = procedure;stdcall;
  TglResumeTransformFeedbackNV = procedure;stdcall;
  TglRotated = procedure(angle: GLdouble; x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglRotatef = procedure(angle: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglRotatex = procedure(angle: GLfixed; x: GLfixed; y: GLfixed; z: GLfixed);stdcall;
  TglRotatexOES = procedure(angle: GLfixed; x: GLfixed; y: GLfixed; z: GLfixed);stdcall;
  TglSampleCoverage = procedure(value: GLfloat; invert: GLboolean);stdcall;
  TglSampleCoverageARB = procedure(value: GLfloat; invert: GLboolean);stdcall;
  TglSampleCoveragex = procedure(value: GLclampx; invert: GLboolean);stdcall;
  TglSampleCoveragexOES = procedure(value: GLclampx; invert: GLboolean);stdcall;
  TglSampleMapATI = procedure(dst: GLuint; interp: GLuint; swizzle: GLenum);stdcall;
  TglSampleMaskEXT = procedure(value: GLclampf; invert: GLboolean);stdcall;
  TglSampleMaskIndexedNV = procedure(index_: GLuint; mask: GLbitfield);stdcall;
  TglSampleMaskSGIS = procedure(value: GLclampf; invert: GLboolean);stdcall;
  TglSampleMaski = procedure(maskNumber: GLuint; mask: GLbitfield);stdcall;
  TglSamplePatternEXT = procedure(pattern: GLenum);stdcall;
  TglSamplePatternSGIS = procedure(pattern: GLenum);stdcall;
  TglSamplerParameterIiv = procedure(sampler: GLuint; pname: GLenum; param: PGLint);stdcall;
  TglSamplerParameterIivEXT = procedure(sampler: GLuint; pname: GLenum; param: PGLint);stdcall;
  TglSamplerParameterIivOES = procedure(sampler: GLuint; pname: GLenum; param: PGLint);stdcall;
  TglSamplerParameterIuiv = procedure(sampler: GLuint; pname: GLenum; param: PGLuint);stdcall;
  TglSamplerParameterIuivEXT = procedure(sampler: GLuint; pname: GLenum; param: PGLuint);stdcall;
  TglSamplerParameterIuivOES = procedure(sampler: GLuint; pname: GLenum; param: PGLuint);stdcall;
  TglSamplerParameterf = procedure(sampler: GLuint; pname: GLenum; param: GLfloat);stdcall;
  TglSamplerParameterfv = procedure(sampler: GLuint; pname: GLenum; param: PGLfloat);stdcall;
  TglSamplerParameteri = procedure(sampler: GLuint; pname: GLenum; param: GLint);stdcall;
  TglSamplerParameteriv = procedure(sampler: GLuint; pname: GLenum; param: PGLint);stdcall;
  TglScaled = procedure(x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglScalef = procedure(x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglScalex = procedure(x: GLfixed; y: GLfixed; z: GLfixed);stdcall;
  TglScalexOES = procedure(x: GLfixed; y: GLfixed; z: GLfixed);stdcall;
  TglScissor = procedure(x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglScissorArrayv = procedure(first: GLuint; count: GLsizei; v: PGLint);stdcall;
  TglScissorArrayvNV = procedure(first: GLuint; count: GLsizei; v: PGLint);stdcall;
  TglScissorArrayvOES = procedure(first: GLuint; count: GLsizei; v: PGLint);stdcall;
  TglScissorIndexed = procedure(index_: GLuint; left: GLint; bottom: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglScissorIndexedNV = procedure(index_: GLuint; left: GLint; bottom: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglScissorIndexedOES = procedure(index_: GLuint; left: GLint; bottom: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglScissorIndexedv = procedure(index_: GLuint; v: PGLint);stdcall;
  TglScissorIndexedvNV = procedure(index_: GLuint; v: PGLint);stdcall;
  TglScissorIndexedvOES = procedure(index_: GLuint; v: PGLint);stdcall;
  TglSecondaryColor3b = procedure(red: GLbyte; green: GLbyte; blue: GLbyte);stdcall;
  TglSecondaryColor3bEXT = procedure(red: GLbyte; green: GLbyte; blue: GLbyte);stdcall;
  TglSecondaryColor3bv = procedure(v: PGLbyte);stdcall;
  TglSecondaryColor3bvEXT = procedure(v: PGLbyte);stdcall;
  TglSecondaryColor3d = procedure(red: GLdouble; green: GLdouble; blue: GLdouble);stdcall;
  TglSecondaryColor3dEXT = procedure(red: GLdouble; green: GLdouble; blue: GLdouble);stdcall;
  TglSecondaryColor3dv = procedure(v: PGLdouble);stdcall;
  TglSecondaryColor3dvEXT = procedure(v: PGLdouble);stdcall;
  TglSecondaryColor3f = procedure(red: GLfloat; green: GLfloat; blue: GLfloat);stdcall;
  TglSecondaryColor3fEXT = procedure(red: GLfloat; green: GLfloat; blue: GLfloat);stdcall;
  TglSecondaryColor3fv = procedure(v: PGLfloat);stdcall;
  TglSecondaryColor3fvEXT = procedure(v: PGLfloat);stdcall;
  TglSecondaryColor3hNV = procedure(red: GLhalfNV; green: GLhalfNV; blue: GLhalfNV);stdcall;
  TglSecondaryColor3hvNV = procedure(v: PGLhalfNV);stdcall;
  TglSecondaryColor3i = procedure(red: GLint; green: GLint; blue: GLint);stdcall;
  TglSecondaryColor3iEXT = procedure(red: GLint; green: GLint; blue: GLint);stdcall;
  TglSecondaryColor3iv = procedure(v: PGLint);stdcall;
  TglSecondaryColor3ivEXT = procedure(v: PGLint);stdcall;
  TglSecondaryColor3s = procedure(red: GLshort; green: GLshort; blue: GLshort);stdcall;
  TglSecondaryColor3sEXT = procedure(red: GLshort; green: GLshort; blue: GLshort);stdcall;
  TglSecondaryColor3sv = procedure(v: PGLshort);stdcall;
  TglSecondaryColor3svEXT = procedure(v: PGLshort);stdcall;
  TglSecondaryColor3ub = procedure(red: GLubyte; green: GLubyte; blue: GLubyte);stdcall;
  TglSecondaryColor3ubEXT = procedure(red: GLubyte; green: GLubyte; blue: GLubyte);stdcall;
  TglSecondaryColor3ubv = procedure(v: PGLubyte);stdcall;
  TglSecondaryColor3ubvEXT = procedure(v: PGLubyte);stdcall;
  TglSecondaryColor3ui = procedure(red: GLuint; green: GLuint; blue: GLuint);stdcall;
  TglSecondaryColor3uiEXT = procedure(red: GLuint; green: GLuint; blue: GLuint);stdcall;
  TglSecondaryColor3uiv = procedure(v: PGLuint);stdcall;
  TglSecondaryColor3uivEXT = procedure(v: PGLuint);stdcall;
  TglSecondaryColor3us = procedure(red: GLushort; green: GLushort; blue: GLushort);stdcall;
  TglSecondaryColor3usEXT = procedure(red: GLushort; green: GLushort; blue: GLushort);stdcall;
  TglSecondaryColor3usv = procedure(v: PGLushort);stdcall;
  TglSecondaryColor3usvEXT = procedure(v: PGLushort);stdcall;
  TglSecondaryColorFormatNV = procedure(size: GLint; type_: GLenum; stride: GLsizei);stdcall;
  TglSecondaryColorP3ui = procedure(type_: GLenum; color: GLuint);stdcall;
  TglSecondaryColorP3uiv = procedure(type_: GLenum; color: PGLuint);stdcall;
  TglSecondaryColorPointer = procedure(size: GLint; type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglSecondaryColorPointerEXT = procedure(size: GLint; type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglSecondaryColorPointerListIBM = procedure(size: GLint; type_: GLenum; stride: GLint; pointer: PPvoid; ptrstride: GLint);stdcall;
  TglSelectBuffer = procedure(size: GLsizei; buffer: PGLuint);stdcall;
  TglSelectPerfMonitorCountersAMD = procedure(monitor: GLuint; enable: GLboolean; group: GLuint; numCounters: GLint; counterList: PGLuint);stdcall;
  TglSemaphoreParameterui64vEXT = procedure(semaphore: GLuint; pname: GLenum; params: PGLuint64);stdcall;
  TglSeparableFilter2D = procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei; format: GLenum; type_: GLenum; row: Pvoid; column: Pvoid);stdcall;
  TglSeparableFilter2DEXT = procedure(target: GLenum; internalformat: GLenum; width: GLsizei; height: GLsizei; format: GLenum; type_: GLenum; row: Pvoid; column: Pvoid);stdcall;
  TglSetFenceAPPLE = procedure(fence: GLuint);stdcall;
  TglSetFenceNV = procedure(fence: GLuint; condition: GLenum);stdcall;
  TglSetFragmentShaderConstantATI = procedure(dst: GLuint; value: PGLfloat);stdcall;
  TglSetInvariantEXT = procedure(id: GLuint; type_: GLenum; addr: Pvoid);stdcall;
  TglSetLocalConstantEXT = procedure(id: GLuint; type_: GLenum; addr: Pvoid);stdcall;
  TglSetMultisamplefvAMD = procedure(pname: GLenum; index_: GLuint; val: PGLfloat);stdcall;
  TglShadeModel = procedure(mode: GLenum);stdcall;
  TglShaderBinary = procedure(count: GLsizei; shaders: PGLuint; binaryformat: GLenum; binary: Pvoid; length: GLsizei);stdcall;
  TglShaderOp1EXT = procedure(op: GLenum; res: GLuint; arg1: GLuint);stdcall;
  TglShaderOp2EXT = procedure(op: GLenum; res: GLuint; arg1: GLuint; arg2: GLuint);stdcall;
  TglShaderOp3EXT = procedure(op: GLenum; res: GLuint; arg1: GLuint; arg2: GLuint; arg3: GLuint);stdcall;
  TglShaderSource = procedure(shader: GLuint; count: GLsizei; string_: PPGLchar; length: PGLint);stdcall;
  TglShaderSourceARB = procedure(shaderObj: GLhandleARB; count: GLsizei; string_: PPGLcharARB; length: PGLint);stdcall;
  TglShaderStorageBlockBinding = procedure(program_: GLuint; storageBlockIndex: GLuint; storageBlockBinding: GLuint);stdcall;
  TglSharpenTexFuncSGIS = procedure(target: GLenum; n: GLsizei; points: PGLfloat);stdcall;
  TglSignalSemaphoreEXT = procedure(semaphore: GLuint; numBufferBarriers: GLuint; buffers: PGLuint; numTextureBarriers: GLuint; textures: PGLuint; dstLayouts: PGLenum);stdcall;
  TglSpecializeShader = procedure(shader: GLuint; pEntryPoint: PGLchar; numSpecializationConstants: GLuint; pConstantIndex: PGLuint; pConstantValue: PGLuint);stdcall;
  TglSpecializeShaderARB = procedure(shader: GLuint; pEntryPoint: PGLchar; numSpecializationConstants: GLuint; pConstantIndex: PGLuint; pConstantValue: PGLuint);stdcall;
  TglSpriteParameterfSGIX = procedure(pname: GLenum; param: GLfloat);stdcall;
  TglSpriteParameterfvSGIX = procedure(pname: GLenum; params: PGLfloat);stdcall;
  TglSpriteParameteriSGIX = procedure(pname: GLenum; param: GLint);stdcall;
  TglSpriteParameterivSGIX = procedure(pname: GLenum; params: PGLint);stdcall;
  TglStartInstrumentsSGIX = procedure;stdcall;
  TglStartTilingQCOM = procedure(x: GLuint; y: GLuint; width: GLuint; height: GLuint; preserveMask: GLbitfield);stdcall;
  TglStateCaptureNV = procedure(state: GLuint; mode: GLenum);stdcall;
  TglStencilClearTagEXT = procedure(stencilTagBits: GLsizei; stencilClearTag: GLuint);stdcall;
  TglStencilFillPathInstancedNV = procedure(numPaths: GLsizei; pathNameType: GLenum; paths: Pvoid; pathBase: GLuint; fillMode: GLenum; mask: GLuint; transformType: GLenum; transformValues: PGLfloat);stdcall;
  TglStencilFillPathNV = procedure(path: GLuint; fillMode: GLenum; mask: GLuint);stdcall;
  TglStencilFunc = procedure(func: GLenum; ref: GLint; mask: GLuint);stdcall;
  TglStencilFuncSeparate = procedure(face: GLenum; func: GLenum; ref: GLint; mask: GLuint);stdcall;
  TglStencilFuncSeparateATI = procedure(frontfunc: GLenum; backfunc: GLenum; ref: GLint; mask: GLuint);stdcall;
  TglStencilMask = procedure(mask: GLuint);stdcall;
  TglStencilMaskSeparate = procedure(face: GLenum; mask: GLuint);stdcall;
  TglStencilOp = procedure(fail: GLenum; zfail: GLenum; zpass: GLenum);stdcall;
  TglStencilOpSeparate = procedure(face: GLenum; sfail: GLenum; dpfail: GLenum; dppass: GLenum);stdcall;
  TglStencilOpSeparateATI = procedure(face: GLenum; sfail: GLenum; dpfail: GLenum; dppass: GLenum);stdcall;
  TglStencilOpValueAMD = procedure(face: GLenum; value: GLuint);stdcall;
  TglStencilStrokePathInstancedNV = procedure(numPaths: GLsizei; pathNameType: GLenum; paths: Pvoid; pathBase: GLuint; reference: GLint; mask: GLuint; transformType: GLenum; transformValues: PGLfloat);stdcall;
  TglStencilStrokePathNV = procedure(path: GLuint; reference: GLint; mask: GLuint);stdcall;
  TglStencilThenCoverFillPathInstancedNV = procedure(numPaths: GLsizei; pathNameType: GLenum; paths: Pvoid; pathBase: GLuint; fillMode: GLenum; mask: GLuint; coverMode: GLenum; transformType: GLenum; transformValues: PGLfloat);stdcall;
  TglStencilThenCoverFillPathNV = procedure(path: GLuint; fillMode: GLenum; mask: GLuint; coverMode: GLenum);stdcall;
  TglStencilThenCoverStrokePathInstancedNV = procedure(numPaths: GLsizei; pathNameType: GLenum; paths: Pvoid; pathBase: GLuint; reference: GLint; mask: GLuint; coverMode: GLenum; transformType: GLenum; transformValues: PGLfloat);stdcall;
  TglStencilThenCoverStrokePathNV = procedure(path: GLuint; reference: GLint; mask: GLuint; coverMode: GLenum);stdcall;
  TglStopInstrumentsSGIX = procedure(marker: GLint);stdcall;
  TglStringMarkerGREMEDY = procedure(len: GLsizei; string_: Pvoid);stdcall;
  TglSubpixelPrecisionBiasNV = procedure(xbits: GLuint; ybits: GLuint);stdcall;
  TglSwizzleEXT = procedure(res: GLuint; in_: GLuint; outX: GLenum; outY: GLenum; outZ: GLenum; outW: GLenum);stdcall;
  TglSyncTextureINTEL = procedure(texture: GLuint);stdcall;
  TglTagSampleBufferSGIX = procedure;stdcall;
  TglTangent3bEXT = procedure(tx: GLbyte; ty: GLbyte; tz: GLbyte);stdcall;
  TglTangent3bvEXT = procedure(v: PGLbyte);stdcall;
  TglTangent3dEXT = procedure(tx: GLdouble; ty: GLdouble; tz: GLdouble);stdcall;
  TglTangent3dvEXT = procedure(v: PGLdouble);stdcall;
  TglTangent3fEXT = procedure(tx: GLfloat; ty: GLfloat; tz: GLfloat);stdcall;
  TglTangent3fvEXT = procedure(v: PGLfloat);stdcall;
  TglTangent3iEXT = procedure(tx: GLint; ty: GLint; tz: GLint);stdcall;
  TglTangent3ivEXT = procedure(v: PGLint);stdcall;
  TglTangent3sEXT = procedure(tx: GLshort; ty: GLshort; tz: GLshort);stdcall;
  TglTangent3svEXT = procedure(v: PGLshort);stdcall;
  TglTangentPointerEXT = procedure(type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglTbufferMask3DFX = procedure(mask: GLuint);stdcall;
  TglTessellationFactorAMD = procedure(factor: GLfloat);stdcall;
  TglTessellationModeAMD = procedure(mode: GLenum);stdcall;
  TglTestFenceAPPLE = function(fence: GLuint): GLboolean;stdcall;
  TglTestFenceNV = function(fence: GLuint): GLboolean;stdcall;
  TglTestObjectAPPLE = function(object_: GLenum; name_: GLuint): GLboolean;stdcall;
  TglTexBuffer = procedure(target: GLenum; internalformat: GLenum; buffer: GLuint);stdcall;
  TglTexBufferARB = procedure(target: GLenum; internalformat: GLenum; buffer: GLuint);stdcall;
  TglTexBufferEXT = procedure(target: GLenum; internalformat: GLenum; buffer: GLuint);stdcall;
  TglTexBufferOES = procedure(target: GLenum; internalformat: GLenum; buffer: GLuint);stdcall;
  TglTexBufferRange = procedure(target: GLenum; internalformat: GLenum; buffer: GLuint; offset: GLintptr; size: GLsizeiptr);stdcall;
  TglTexBufferRangeEXT = procedure(target: GLenum; internalformat: GLenum; buffer: GLuint; offset: GLintptr; size: GLsizeiptr);stdcall;
  TglTexBufferRangeOES = procedure(target: GLenum; internalformat: GLenum; buffer: GLuint; offset: GLintptr; size: GLsizeiptr);stdcall;
  TglTexBumpParameterfvATI = procedure(pname: GLenum; param: PGLfloat);stdcall;
  TglTexBumpParameterivATI = procedure(pname: GLenum; param: PGLint);stdcall;
  TglTexCoord1bOES = procedure(s: GLbyte);stdcall;
  TglTexCoord1bvOES = procedure(coords: PGLbyte);stdcall;
  TglTexCoord1d = procedure(s: GLdouble);stdcall;
  TglTexCoord1dv = procedure(v: PGLdouble);stdcall;
  TglTexCoord1f = procedure(s: GLfloat);stdcall;
  TglTexCoord1fv = procedure(v: PGLfloat);stdcall;
  TglTexCoord1hNV = procedure(s: GLhalfNV);stdcall;
  TglTexCoord1hvNV = procedure(v: PGLhalfNV);stdcall;
  TglTexCoord1i = procedure(s: GLint);stdcall;
  TglTexCoord1iv = procedure(v: PGLint);stdcall;
  TglTexCoord1s = procedure(s: GLshort);stdcall;
  TglTexCoord1sv = procedure(v: PGLshort);stdcall;
  TglTexCoord1xOES = procedure(s: GLfixed);stdcall;
  TglTexCoord1xvOES = procedure(coords: PGLfixed);stdcall;
  TglTexCoord2bOES = procedure(s: GLbyte; t: GLbyte);stdcall;
  TglTexCoord2bvOES = procedure(coords: PGLbyte);stdcall;
  TglTexCoord2d = procedure(s: GLdouble; t: GLdouble);stdcall;
  TglTexCoord2dv = procedure(v: PGLdouble);stdcall;
  TglTexCoord2f = procedure(s: GLfloat; t: GLfloat);stdcall;
  TglTexCoord2fColor3fVertex3fSUN = procedure(s: GLfloat; t: GLfloat; r: GLfloat; g: GLfloat; b: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglTexCoord2fColor3fVertex3fvSUN = procedure(tc: PGLfloat; c: PGLfloat; v: PGLfloat);stdcall;
  TglTexCoord2fColor4fNormal3fVertex3fSUN = procedure(s: GLfloat; t: GLfloat; r: GLfloat; g: GLfloat; b: GLfloat; a: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglTexCoord2fColor4fNormal3fVertex3fvSUN = procedure(tc: PGLfloat; c: PGLfloat; n: PGLfloat; v: PGLfloat);stdcall;
  TglTexCoord2fColor4ubVertex3fSUN = procedure(s: GLfloat; t: GLfloat; r: GLubyte; g: GLubyte; b: GLubyte; a: GLubyte; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglTexCoord2fColor4ubVertex3fvSUN = procedure(tc: PGLfloat; c: PGLubyte; v: PGLfloat);stdcall;
  TglTexCoord2fNormal3fVertex3fSUN = procedure(s: GLfloat; t: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglTexCoord2fNormal3fVertex3fvSUN = procedure(tc: PGLfloat; n: PGLfloat; v: PGLfloat);stdcall;
  TglTexCoord2fVertex3fSUN = procedure(s: GLfloat; t: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglTexCoord2fVertex3fvSUN = procedure(tc: PGLfloat; v: PGLfloat);stdcall;
  TglTexCoord2fv = procedure(v: PGLfloat);stdcall;
  TglTexCoord2hNV = procedure(s: GLhalfNV; t: GLhalfNV);stdcall;
  TglTexCoord2hvNV = procedure(v: PGLhalfNV);stdcall;
  TglTexCoord2i = procedure(s: GLint; t: GLint);stdcall;
  TglTexCoord2iv = procedure(v: PGLint);stdcall;
  TglTexCoord2s = procedure(s: GLshort; t: GLshort);stdcall;
  TglTexCoord2sv = procedure(v: PGLshort);stdcall;
  TglTexCoord2xOES = procedure(s: GLfixed; t: GLfixed);stdcall;
  TglTexCoord2xvOES = procedure(coords: PGLfixed);stdcall;
  TglTexCoord3bOES = procedure(s: GLbyte; t: GLbyte; r: GLbyte);stdcall;
  TglTexCoord3bvOES = procedure(coords: PGLbyte);stdcall;
  TglTexCoord3d = procedure(s: GLdouble; t: GLdouble; r: GLdouble);stdcall;
  TglTexCoord3dv = procedure(v: PGLdouble);stdcall;
  TglTexCoord3f = procedure(s: GLfloat; t: GLfloat; r: GLfloat);stdcall;
  TglTexCoord3fv = procedure(v: PGLfloat);stdcall;
  TglTexCoord3hNV = procedure(s: GLhalfNV; t: GLhalfNV; r: GLhalfNV);stdcall;
  TglTexCoord3hvNV = procedure(v: PGLhalfNV);stdcall;
  TglTexCoord3i = procedure(s: GLint; t: GLint; r: GLint);stdcall;
  TglTexCoord3iv = procedure(v: PGLint);stdcall;
  TglTexCoord3s = procedure(s: GLshort; t: GLshort; r: GLshort);stdcall;
  TglTexCoord3sv = procedure(v: PGLshort);stdcall;
  TglTexCoord3xOES = procedure(s: GLfixed; t: GLfixed; r: GLfixed);stdcall;
  TglTexCoord3xvOES = procedure(coords: PGLfixed);stdcall;
  TglTexCoord4bOES = procedure(s: GLbyte; t: GLbyte; r: GLbyte; q: GLbyte);stdcall;
  TglTexCoord4bvOES = procedure(coords: PGLbyte);stdcall;
  TglTexCoord4d = procedure(s: GLdouble; t: GLdouble; r: GLdouble; q: GLdouble);stdcall;
  TglTexCoord4dv = procedure(v: PGLdouble);stdcall;
  TglTexCoord4f = procedure(s: GLfloat; t: GLfloat; r: GLfloat; q: GLfloat);stdcall;
  TglTexCoord4fColor4fNormal3fVertex4fSUN = procedure(s: GLfloat; t: GLfloat; p: GLfloat; q: GLfloat; r: GLfloat; g: GLfloat; b: GLfloat; a: GLfloat; nx: GLfloat; ny: GLfloat; nz: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat);stdcall;
  TglTexCoord4fColor4fNormal3fVertex4fvSUN = procedure(tc: PGLfloat; c: PGLfloat; n: PGLfloat; v: PGLfloat);stdcall;
  TglTexCoord4fVertex4fSUN = procedure(s: GLfloat; t: GLfloat; p: GLfloat; q: GLfloat; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat);stdcall;
  TglTexCoord4fVertex4fvSUN = procedure(tc: PGLfloat; v: PGLfloat);stdcall;
  TglTexCoord4fv = procedure(v: PGLfloat);stdcall;
  TglTexCoord4hNV = procedure(s: GLhalfNV; t: GLhalfNV; r: GLhalfNV; q: GLhalfNV);stdcall;
  TglTexCoord4hvNV = procedure(v: PGLhalfNV);stdcall;
  TglTexCoord4i = procedure(s: GLint; t: GLint; r: GLint; q: GLint);stdcall;
  TglTexCoord4iv = procedure(v: PGLint);stdcall;
  TglTexCoord4s = procedure(s: GLshort; t: GLshort; r: GLshort; q: GLshort);stdcall;
  TglTexCoord4sv = procedure(v: PGLshort);stdcall;
  TglTexCoord4xOES = procedure(s: GLfixed; t: GLfixed; r: GLfixed; q: GLfixed);stdcall;
  TglTexCoord4xvOES = procedure(coords: PGLfixed);stdcall;
  TglTexCoordFormatNV = procedure(size: GLint; type_: GLenum; stride: GLsizei);stdcall;
  TglTexCoordP1ui = procedure(type_: GLenum; coords: GLuint);stdcall;
  TglTexCoordP1uiv = procedure(type_: GLenum; coords: PGLuint);stdcall;
  TglTexCoordP2ui = procedure(type_: GLenum; coords: GLuint);stdcall;
  TglTexCoordP2uiv = procedure(type_: GLenum; coords: PGLuint);stdcall;
  TglTexCoordP3ui = procedure(type_: GLenum; coords: GLuint);stdcall;
  TglTexCoordP3uiv = procedure(type_: GLenum; coords: PGLuint);stdcall;
  TglTexCoordP4ui = procedure(type_: GLenum; coords: GLuint);stdcall;
  TglTexCoordP4uiv = procedure(type_: GLenum; coords: PGLuint);stdcall;
  TglTexCoordPointer = procedure(size: GLint; type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglTexCoordPointerEXT = procedure(size: GLint; type_: GLenum; stride: GLsizei; count: GLsizei; pointer: Pvoid);stdcall;
  TglTexCoordPointerListIBM = procedure(size: GLint; type_: GLenum; stride: GLint; pointer: PPvoid; ptrstride: GLint);stdcall;
  TglTexCoordPointervINTEL = procedure(size: GLint; type_: GLenum; pointer: PPvoid);stdcall;
  TglTexEnvf = procedure(target: GLenum; pname: GLenum; param: GLfloat);stdcall;
  TglTexEnvfv = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglTexEnvi = procedure(target: GLenum; pname: GLenum; param: GLint);stdcall;
  TglTexEnviv = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglTexEnvx = procedure(target: GLenum; pname: GLenum; param: GLfixed);stdcall;
  TglTexEnvxOES = procedure(target: GLenum; pname: GLenum; param: GLfixed);stdcall;
  TglTexEnvxv = procedure(target: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglTexEnvxvOES = procedure(target: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglTexFilterFuncSGIS = procedure(target: GLenum; filter: GLenum; n: GLsizei; weights: PGLfloat);stdcall;
  TglTexGend = procedure(coord: GLenum; pname: GLenum; param: GLdouble);stdcall;
  TglTexGendv = procedure(coord: GLenum; pname: GLenum; params: PGLdouble);stdcall;
  TglTexGenf = procedure(coord: GLenum; pname: GLenum; param: GLfloat);stdcall;
  TglTexGenfOES = procedure(coord: GLenum; pname: GLenum; param: GLfloat);stdcall;
  TglTexGenfv = procedure(coord: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglTexGenfvOES = procedure(coord: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglTexGeni = procedure(coord: GLenum; pname: GLenum; param: GLint);stdcall;
  TglTexGeniOES = procedure(coord: GLenum; pname: GLenum; param: GLint);stdcall;
  TglTexGeniv = procedure(coord: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglTexGenivOES = procedure(coord: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglTexGenxOES = procedure(coord: GLenum; pname: GLenum; param: GLfixed);stdcall;
  TglTexGenxvOES = procedure(coord: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglTexImage1D = procedure(target: GLenum; level: GLint; internalformat: GLint; width: GLsizei; border: GLint; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTexImage2D = procedure(target: GLenum; level: GLint; internalformat: GLint; width: GLsizei; height: GLsizei; border: GLint; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTexImage2DMultisample = procedure(target: GLenum; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei; fixedsamplelocations: GLboolean);stdcall;
  TglTexImage2DMultisampleCoverageNV = procedure(target: GLenum; coverageSamples: GLsizei; colorSamples: GLsizei; internalFormat: GLint; width: GLsizei; height: GLsizei; fixedSampleLocations: GLboolean);stdcall;
  TglTexImage3D = procedure(target: GLenum; level: GLint; internalformat: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTexImage3DEXT = procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTexImage3DMultisample = procedure(target: GLenum; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; fixedsamplelocations: GLboolean);stdcall;
  TglTexImage3DMultisampleCoverageNV = procedure(target: GLenum; coverageSamples: GLsizei; colorSamples: GLsizei; internalFormat: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; fixedSampleLocations: GLboolean);stdcall;
  TglTexImage3DOES = procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTexImage4DSGIS = procedure(target: GLenum; level: GLint; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; size4d: GLsizei; border: GLint; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTexPageCommitmentARB = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; commit: GLboolean);stdcall;
  TglTexPageCommitmentEXT = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; commit: GLboolean);stdcall;
  TglTexParameterIiv = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglTexParameterIivEXT = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglTexParameterIivOES = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglTexParameterIuiv = procedure(target: GLenum; pname: GLenum; params: PGLuint);stdcall;
  TglTexParameterIuivEXT = procedure(target: GLenum; pname: GLenum; params: PGLuint);stdcall;
  TglTexParameterIuivOES = procedure(target: GLenum; pname: GLenum; params: PGLuint);stdcall;
  TglTexParameterf = procedure(target: GLenum; pname: GLenum; param: GLfloat);stdcall;
  TglTexParameterfv = procedure(target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglTexParameteri = procedure(target: GLenum; pname: GLenum; param: GLint);stdcall;
  TglTexParameteriv = procedure(target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglTexParameterx = procedure(target: GLenum; pname: GLenum; param: GLfixed);stdcall;
  TglTexParameterxOES = procedure(target: GLenum; pname: GLenum; param: GLfixed);stdcall;
  TglTexParameterxv = procedure(target: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglTexParameterxvOES = procedure(target: GLenum; pname: GLenum; params: PGLfixed);stdcall;
  TglTexRenderbufferNV = procedure(target: GLenum; renderbuffer: GLuint);stdcall;
  TglTexStorage1D = procedure(target: GLenum; levels: GLsizei; internalformat: GLenum; width: GLsizei);stdcall;
  TglTexStorage1DEXT = procedure(target: GLenum; levels: GLsizei; internalformat: GLenum; width: GLsizei);stdcall;
  TglTexStorage2D = procedure(target: GLenum; levels: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglTexStorage2DEXT = procedure(target: GLenum; levels: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglTexStorage2DMultisample = procedure(target: GLenum; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei; fixedsamplelocations: GLboolean);stdcall;
  TglTexStorage3D = procedure(target: GLenum; levels: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei);stdcall;
  TglTexStorage3DEXT = procedure(target: GLenum; levels: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei);stdcall;
  TglTexStorage3DMultisample = procedure(target: GLenum; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; fixedsamplelocations: GLboolean);stdcall;
  TglTexStorage3DMultisampleOES = procedure(target: GLenum; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; fixedsamplelocations: GLboolean);stdcall;
  TglTexStorageMem1DEXT = procedure(target: GLenum; levels: GLsizei; internalFormat: GLenum; width: GLsizei; memory: GLuint; offset: GLuint64);stdcall;
  TglTexStorageMem2DEXT = procedure(target: GLenum; levels: GLsizei; internalFormat: GLenum; width: GLsizei; height: GLsizei; memory: GLuint; offset: GLuint64);stdcall;
  TglTexStorageMem2DMultisampleEXT = procedure(target: GLenum; samples: GLsizei; internalFormat: GLenum; width: GLsizei; height: GLsizei; fixedSampleLocations: GLboolean; memory: GLuint; offset: GLuint64);stdcall;
  TglTexStorageMem3DEXT = procedure(target: GLenum; levels: GLsizei; internalFormat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; memory: GLuint; offset: GLuint64);stdcall;
  TglTexStorageMem3DMultisampleEXT = procedure(target: GLenum; samples: GLsizei; internalFormat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; fixedSampleLocations: GLboolean; memory: GLuint; offset: GLuint64);stdcall;
  TglTexStorageSparseAMD = procedure(target: GLenum; internalFormat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; layers: GLsizei; flags: GLbitfield);stdcall;
  TglTexSubImage1D = procedure(target: GLenum; level: GLint; xoffset: GLint; width: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTexSubImage1DEXT = procedure(target: GLenum; level: GLint; xoffset: GLint; width: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTexSubImage2D = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; width: GLsizei; height: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTexSubImage2DEXT = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; width: GLsizei; height: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTexSubImage3D = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTexSubImage3DEXT = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTexSubImage3DOES = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTexSubImage4DSGIS = procedure(target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; woffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; size4d: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTextureBarrier = procedure;stdcall;
  TglTextureBarrierNV = procedure;stdcall;
  TglTextureBuffer = procedure(texture: GLuint; internalformat: GLenum; buffer: GLuint);stdcall;
  TglTextureBufferEXT = procedure(texture: GLuint; target: GLenum; internalformat: GLenum; buffer: GLuint);stdcall;
  TglTextureBufferRange = procedure(texture: GLuint; internalformat: GLenum; buffer: GLuint; offset: GLintptr; size: GLsizeiptr);stdcall;
  TglTextureBufferRangeEXT = procedure(texture: GLuint; target: GLenum; internalformat: GLenum; buffer: GLuint; offset: GLintptr; size: GLsizeiptr);stdcall;
  TglTextureColorMaskSGIS = procedure(red: GLboolean; green: GLboolean; blue: GLboolean; alpha: GLboolean);stdcall;
  TglTextureImage1DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; internalformat: GLint; width: GLsizei; border: GLint; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTextureImage2DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; internalformat: GLint; width: GLsizei; height: GLsizei; border: GLint; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTextureImage2DMultisampleCoverageNV = procedure(texture: GLuint; target: GLenum; coverageSamples: GLsizei; colorSamples: GLsizei; internalFormat: GLint; width: GLsizei; height: GLsizei; fixedSampleLocations: GLboolean);stdcall;
  TglTextureImage2DMultisampleNV = procedure(texture: GLuint; target: GLenum; samples: GLsizei; internalFormat: GLint; width: GLsizei; height: GLsizei; fixedSampleLocations: GLboolean);stdcall;
  TglTextureImage3DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; internalformat: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; border: GLint; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTextureImage3DMultisampleCoverageNV = procedure(texture: GLuint; target: GLenum; coverageSamples: GLsizei; colorSamples: GLsizei; internalFormat: GLint; width: GLsizei; height: GLsizei; depth: GLsizei;
    fixedSampleLocations: GLboolean);stdcall;
  TglTextureImage3DMultisampleNV = procedure(texture: GLuint; target: GLenum; samples: GLsizei; internalFormat: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; fixedSampleLocations: GLboolean);stdcall;
  TglTextureLightEXT = procedure(pname: GLenum);stdcall;
  TglTextureMaterialEXT = procedure(face: GLenum; mode: GLenum);stdcall;
  TglTextureNormalEXT = procedure(mode: GLenum);stdcall;
  TglTexturePageCommitmentEXT = procedure(texture: GLuint; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; commit: GLboolean);stdcall;
  TglTextureParameterIiv = procedure(texture: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglTextureParameterIivEXT = procedure(texture: GLuint; target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglTextureParameterIuiv = procedure(texture: GLuint; pname: GLenum; params: PGLuint);stdcall;
  TglTextureParameterIuivEXT = procedure(texture: GLuint; target: GLenum; pname: GLenum; params: PGLuint);stdcall;
  TglTextureParameterf = procedure(texture: GLuint; pname: GLenum; param: GLfloat);stdcall;
  TglTextureParameterfEXT = procedure(texture: GLuint; target: GLenum; pname: GLenum; param: GLfloat);stdcall;
  TglTextureParameterfv = procedure(texture: GLuint; pname: GLenum; param: PGLfloat);stdcall;
  TglTextureParameterfvEXT = procedure(texture: GLuint; target: GLenum; pname: GLenum; params: PGLfloat);stdcall;
  TglTextureParameteri = procedure(texture: GLuint; pname: GLenum; param: GLint);stdcall;
  TglTextureParameteriEXT = procedure(texture: GLuint; target: GLenum; pname: GLenum; param: GLint);stdcall;
  TglTextureParameteriv = procedure(texture: GLuint; pname: GLenum; param: PGLint);stdcall;
  TglTextureParameterivEXT = procedure(texture: GLuint; target: GLenum; pname: GLenum; params: PGLint);stdcall;
  TglTextureRangeAPPLE = procedure(target: GLenum; length: GLsizei; pointer: Pvoid);stdcall;
  TglTextureRenderbufferEXT = procedure(texture: GLuint; target: GLenum; renderbuffer: GLuint);stdcall;
  TglTextureStorage1D = procedure(texture: GLuint; levels: GLsizei; internalformat: GLenum; width: GLsizei);stdcall;
  TglTextureStorage1DEXT = procedure(texture: GLuint; target: GLenum; levels: GLsizei; internalformat: GLenum; width: GLsizei);stdcall;
  TglTextureStorage2D = procedure(texture: GLuint; levels: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglTextureStorage2DEXT = procedure(texture: GLuint; target: GLenum; levels: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei);stdcall;
  TglTextureStorage2DMultisample = procedure(texture: GLuint; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei; fixedsamplelocations: GLboolean);stdcall;
  TglTextureStorage2DMultisampleEXT = procedure(texture: GLuint; target: GLenum; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei; fixedsamplelocations: GLboolean);stdcall;
  TglTextureStorage3D = procedure(texture: GLuint; levels: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei);stdcall;
  TglTextureStorage3DEXT = procedure(texture: GLuint; target: GLenum; levels: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei);stdcall;
  TglTextureStorage3DMultisample = procedure(texture: GLuint; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; fixedsamplelocations: GLboolean);stdcall;
  TglTextureStorage3DMultisampleEXT = procedure(texture: GLuint; target: GLenum; samples: GLsizei; internalformat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; fixedsamplelocations: GLboolean);stdcall;
  TglTextureStorageMem1DEXT = procedure(texture: GLuint; levels: GLsizei; internalFormat: GLenum; width: GLsizei; memory: GLuint; offset: GLuint64);stdcall;
  TglTextureStorageMem2DEXT = procedure(texture: GLuint; levels: GLsizei; internalFormat: GLenum; width: GLsizei; height: GLsizei; memory: GLuint; offset: GLuint64);stdcall;
  TglTextureStorageMem2DMultisampleEXT = procedure(texture: GLuint; samples: GLsizei; internalFormat: GLenum; width: GLsizei; height: GLsizei; fixedSampleLocations: GLboolean; memory: GLuint; offset: GLuint64);stdcall;
  TglTextureStorageMem3DEXT = procedure(texture: GLuint; levels: GLsizei; internalFormat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; memory: GLuint; offset: GLuint64);stdcall;
  TglTextureStorageMem3DMultisampleEXT = procedure(texture: GLuint; samples: GLsizei; internalFormat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; fixedSampleLocations: GLboolean; memory: GLuint; offset: GLuint64);stdcall;
  TglTextureStorageSparseAMD = procedure(texture: GLuint; target: GLenum; internalFormat: GLenum; width: GLsizei; height: GLsizei; depth: GLsizei; layers: GLsizei; flags: GLbitfield);stdcall;
  TglTextureSubImage1D = procedure(texture: GLuint; level: GLint; xoffset: GLint; width: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTextureSubImage1DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; xoffset: GLint; width: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTextureSubImage2D = procedure(texture: GLuint; level: GLint; xoffset: GLint; yoffset: GLint; width: GLsizei; height: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTextureSubImage2DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; width: GLsizei; height: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTextureSubImage3D = procedure(texture: GLuint; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTextureSubImage3DEXT = procedure(texture: GLuint; target: GLenum; level: GLint; xoffset: GLint; yoffset: GLint; zoffset: GLint; width: GLsizei; height: GLsizei; depth: GLsizei; format: GLenum; type_: GLenum; pixels: Pvoid);stdcall;
  TglTextureView = procedure(texture: GLuint; target: GLenum; origtexture: GLuint; internalformat: GLenum; minlevel: GLuint; numlevels: GLuint; minlayer: GLuint; numlayers: GLuint);stdcall;
  TglTextureViewEXT = procedure(texture: GLuint; target: GLenum; origtexture: GLuint; internalformat: GLenum; minlevel: GLuint; numlevels: GLuint; minlayer: GLuint; numlayers: GLuint);stdcall;
  TglTextureViewOES = procedure(texture: GLuint; target: GLenum; origtexture: GLuint; internalformat: GLenum; minlevel: GLuint; numlevels: GLuint; minlayer: GLuint; numlayers: GLuint);stdcall;
  TglTrackMatrixNV = procedure(target: GLenum; address: GLuint; matrix: GLenum; transform: GLenum);stdcall;
  TglTransformFeedbackAttribsNV = procedure(count: GLsizei; attribs: PGLint; bufferMode: GLenum);stdcall;
  TglTransformFeedbackBufferBase = procedure(xfb: GLuint; index_: GLuint; buffer: GLuint);stdcall;
  TglTransformFeedbackBufferRange = procedure(xfb: GLuint; index_: GLuint; buffer: GLuint; offset: GLintptr; size: GLsizeiptr);stdcall;
  TglTransformFeedbackStreamAttribsNV = procedure(count: GLsizei; attribs: PGLint; nbuffers: GLsizei; bufstreams: PGLint; bufferMode: GLenum);stdcall;
  TglTransformFeedbackVaryings = procedure(program_: GLuint; count: GLsizei; varyings: PPGLchar; bufferMode: GLenum);stdcall;
  TglTransformFeedbackVaryingsEXT = procedure(program_: GLuint; count: GLsizei; varyings: PPGLchar; bufferMode: GLenum);stdcall;
  TglTransformFeedbackVaryingsNV = procedure(program_: GLuint; count: GLsizei; locations: PGLint; bufferMode: GLenum);stdcall;
  TglTransformPathNV = procedure(resultPath: GLuint; srcPath: GLuint; transformType: GLenum; transformValues: PGLfloat);stdcall;
  TglTranslated = procedure(x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglTranslatef = procedure(x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglTranslatex = procedure(x: GLfixed; y: GLfixed; z: GLfixed);stdcall;
  TglTranslatexOES = procedure(x: GLfixed; y: GLfixed; z: GLfixed);stdcall;
  TglUniform1d = procedure(location: GLint; x: GLdouble);stdcall;
  TglUniform1dv = procedure(location: GLint; count: GLsizei; value: PGLdouble);stdcall;
  TglUniform1f = procedure(location: GLint; v0: GLfloat);stdcall;
  TglUniform1fARB = procedure(location: GLint; v0: GLfloat);stdcall;
  TglUniform1fv = procedure(location: GLint; count: GLsizei; value: PGLfloat);stdcall;
  TglUniform1fvARB = procedure(location: GLint; count: GLsizei; value: PGLfloat);stdcall;
  TglUniform1i = procedure(location: GLint; v0: GLint);stdcall;
  TglUniform1i64ARB = procedure(location: GLint; x: GLint64);stdcall;
  TglUniform1i64NV = procedure(location: GLint; x: GLint64EXT);stdcall;
  TglUniform1i64vARB = procedure(location: GLint; count: GLsizei; value: PGLint64);stdcall;
  TglUniform1i64vNV = procedure(location: GLint; count: GLsizei; value: PGLint64EXT);stdcall;
  TglUniform1iARB = procedure(location: GLint; v0: GLint);stdcall;
  TglUniform1iv = procedure(location: GLint; count: GLsizei; value: PGLint);stdcall;
  TglUniform1ivARB = procedure(location: GLint; count: GLsizei; value: PGLint);stdcall;
  TglUniform1ui = procedure(location: GLint; v0: GLuint);stdcall;
  TglUniform1ui64ARB = procedure(location: GLint; x: GLuint64);stdcall;
  TglUniform1ui64NV = procedure(location: GLint; x: GLuint64EXT);stdcall;
  TglUniform1ui64vARB = procedure(location: GLint; count: GLsizei; value: PGLuint64);stdcall;
  TglUniform1ui64vNV = procedure(location: GLint; count: GLsizei; value: PGLuint64EXT);stdcall;
  TglUniform1uiEXT = procedure(location: GLint; v0: GLuint);stdcall;
  TglUniform1uiv = procedure(location: GLint; count: GLsizei; value: PGLuint);stdcall;
  TglUniform1uivEXT = procedure(location: GLint; count: GLsizei; value: PGLuint);stdcall;
  TglUniform2d = procedure(location: GLint; x: GLdouble; y: GLdouble);stdcall;
  TglUniform2dv = procedure(location: GLint; count: GLsizei; value: PGLdouble);stdcall;
  TglUniform2f = procedure(location: GLint; v0: GLfloat; v1: GLfloat);stdcall;
  TglUniform2fARB = procedure(location: GLint; v0: GLfloat; v1: GLfloat);stdcall;
  TglUniform2fv = procedure(location: GLint; count: GLsizei; value: PGLfloat);stdcall;
  TglUniform2fvARB = procedure(location: GLint; count: GLsizei; value: PGLfloat);stdcall;
  TglUniform2i = procedure(location: GLint; v0: GLint; v1: GLint);stdcall;
  TglUniform2i64ARB = procedure(location: GLint; x: GLint64; y: GLint64);stdcall;
  TglUniform2i64NV = procedure(location: GLint; x: GLint64EXT; y: GLint64EXT);stdcall;
  TglUniform2i64vARB = procedure(location: GLint; count: GLsizei; value: PGLint64);stdcall;
  TglUniform2i64vNV = procedure(location: GLint; count: GLsizei; value: PGLint64EXT);stdcall;
  TglUniform2iARB = procedure(location: GLint; v0: GLint; v1: GLint);stdcall;
  TglUniform2iv = procedure(location: GLint; count: GLsizei; value: PGLint);stdcall;
  TglUniform2ivARB = procedure(location: GLint; count: GLsizei; value: PGLint);stdcall;
  TglUniform2ui = procedure(location: GLint; v0: GLuint; v1: GLuint);stdcall;
  TglUniform2ui64ARB = procedure(location: GLint; x: GLuint64; y: GLuint64);stdcall;
  TglUniform2ui64NV = procedure(location: GLint; x: GLuint64EXT; y: GLuint64EXT);stdcall;
  TglUniform2ui64vARB = procedure(location: GLint; count: GLsizei; value: PGLuint64);stdcall;
  TglUniform2ui64vNV = procedure(location: GLint; count: GLsizei; value: PGLuint64EXT);stdcall;
  TglUniform2uiEXT = procedure(location: GLint; v0: GLuint; v1: GLuint);stdcall;
  TglUniform2uiv = procedure(location: GLint; count: GLsizei; value: PGLuint);stdcall;
  TglUniform2uivEXT = procedure(location: GLint; count: GLsizei; value: PGLuint);stdcall;
  TglUniform3d = procedure(location: GLint; x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglUniform3dv = procedure(location: GLint; count: GLsizei; value: PGLdouble);stdcall;
  TglUniform3f = procedure(location: GLint; v0: GLfloat; v1: GLfloat; v2: GLfloat);stdcall;
  TglUniform3fARB = procedure(location: GLint; v0: GLfloat; v1: GLfloat; v2: GLfloat);stdcall;
  TglUniform3fv = procedure(location: GLint; count: GLsizei; value: PGLfloat);stdcall;
  TglUniform3fvARB = procedure(location: GLint; count: GLsizei; value: PGLfloat);stdcall;
  TglUniform3i = procedure(location: GLint; v0: GLint; v1: GLint; v2: GLint);stdcall;
  TglUniform3i64ARB = procedure(location: GLint; x: GLint64; y: GLint64; z: GLint64);stdcall;
  TglUniform3i64NV = procedure(location: GLint; x: GLint64EXT; y: GLint64EXT; z: GLint64EXT);stdcall;
  TglUniform3i64vARB = procedure(location: GLint; count: GLsizei; value: PGLint64);stdcall;
  TglUniform3i64vNV = procedure(location: GLint; count: GLsizei; value: PGLint64EXT);stdcall;
  TglUniform3iARB = procedure(location: GLint; v0: GLint; v1: GLint; v2: GLint);stdcall;
  TglUniform3iv = procedure(location: GLint; count: GLsizei; value: PGLint);stdcall;
  TglUniform3ivARB = procedure(location: GLint; count: GLsizei; value: PGLint);stdcall;
  TglUniform3ui = procedure(location: GLint; v0: GLuint; v1: GLuint; v2: GLuint);stdcall;
  TglUniform3ui64ARB = procedure(location: GLint; x: GLuint64; y: GLuint64; z: GLuint64);stdcall;
  TglUniform3ui64NV = procedure(location: GLint; x: GLuint64EXT; y: GLuint64EXT; z: GLuint64EXT);stdcall;
  TglUniform3ui64vARB = procedure(location: GLint; count: GLsizei; value: PGLuint64);stdcall;
  TglUniform3ui64vNV = procedure(location: GLint; count: GLsizei; value: PGLuint64EXT);stdcall;
  TglUniform3uiEXT = procedure(location: GLint; v0: GLuint; v1: GLuint; v2: GLuint);stdcall;
  TglUniform3uiv = procedure(location: GLint; count: GLsizei; value: PGLuint);stdcall;
  TglUniform3uivEXT = procedure(location: GLint; count: GLsizei; value: PGLuint);stdcall;
  TglUniform4d = procedure(location: GLint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble);stdcall;
  TglUniform4dv = procedure(location: GLint; count: GLsizei; value: PGLdouble);stdcall;
  TglUniform4f = procedure(location: GLint; v0: GLfloat; v1: GLfloat; v2: GLfloat; v3: GLfloat);stdcall;
  TglUniform4fARB = procedure(location: GLint; v0: GLfloat; v1: GLfloat; v2: GLfloat; v3: GLfloat);stdcall;
  TglUniform4fv = procedure(location: GLint; count: GLsizei; value: PGLfloat);stdcall;
  TglUniform4fvARB = procedure(location: GLint; count: GLsizei; value: PGLfloat);stdcall;
  TglUniform4i = procedure(location: GLint; v0: GLint; v1: GLint; v2: GLint; v3: GLint);stdcall;
  TglUniform4i64ARB = procedure(location: GLint; x: GLint64; y: GLint64; z: GLint64; w: GLint64);stdcall;
  TglUniform4i64NV = procedure(location: GLint; x: GLint64EXT; y: GLint64EXT; z: GLint64EXT; w: GLint64EXT);stdcall;
  TglUniform4i64vARB = procedure(location: GLint; count: GLsizei; value: PGLint64);stdcall;
  TglUniform4i64vNV = procedure(location: GLint; count: GLsizei; value: PGLint64EXT);stdcall;
  TglUniform4iARB = procedure(location: GLint; v0: GLint; v1: GLint; v2: GLint; v3: GLint);stdcall;
  TglUniform4iv = procedure(location: GLint; count: GLsizei; value: PGLint);stdcall;
  TglUniform4ivARB = procedure(location: GLint; count: GLsizei; value: PGLint);stdcall;
  TglUniform4ui = procedure(location: GLint; v0: GLuint; v1: GLuint; v2: GLuint; v3: GLuint);stdcall;
  TglUniform4ui64ARB = procedure(location: GLint; x: GLuint64; y: GLuint64; z: GLuint64; w: GLuint64);stdcall;
  TglUniform4ui64NV = procedure(location: GLint; x: GLuint64EXT; y: GLuint64EXT; z: GLuint64EXT; w: GLuint64EXT);stdcall;
  TglUniform4ui64vARB = procedure(location: GLint; count: GLsizei; value: PGLuint64);stdcall;
  TglUniform4ui64vNV = procedure(location: GLint; count: GLsizei; value: PGLuint64EXT);stdcall;
  TglUniform4uiEXT = procedure(location: GLint; v0: GLuint; v1: GLuint; v2: GLuint; v3: GLuint);stdcall;
  TglUniform4uiv = procedure(location: GLint; count: GLsizei; value: PGLuint);stdcall;
  TglUniform4uivEXT = procedure(location: GLint; count: GLsizei; value: PGLuint);stdcall;
  TglUniformBlockBinding = procedure(program_: GLuint; uniformBlockIndex: GLuint; uniformBlockBinding: GLuint);stdcall;
  TglUniformBufferEXT = procedure(program_: GLuint; location: GLint; buffer: GLuint);stdcall;
  TglUniformHandleui64ARB = procedure(location: GLint; value: GLuint64);stdcall;
  TglUniformHandleui64IMG = procedure(location: GLint; value: GLuint64);stdcall;
  TglUniformHandleui64NV = procedure(location: GLint; value: GLuint64);stdcall;
  TglUniformHandleui64vARB = procedure(location: GLint; count: GLsizei; value: PGLuint64);stdcall;
  TglUniformHandleui64vIMG = procedure(location: GLint; count: GLsizei; value: PGLuint64);stdcall;
  TglUniformHandleui64vNV = procedure(location: GLint; count: GLsizei; value: PGLuint64);stdcall;
  TglUniformMatrix2dv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglUniformMatrix2fv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix2fvARB = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix2x3dv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglUniformMatrix2x3fv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix2x3fvNV = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix2x4dv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglUniformMatrix2x4fv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix2x4fvNV = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix3dv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglUniformMatrix3fv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix3fvARB = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix3x2dv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglUniformMatrix3x2fv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix3x2fvNV = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix3x4dv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglUniformMatrix3x4fv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix3x4fvNV = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix4dv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglUniformMatrix4fv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix4fvARB = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix4x2dv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglUniformMatrix4x2fv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix4x2fvNV = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix4x3dv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLdouble);stdcall;
  TglUniformMatrix4x3fv = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformMatrix4x3fvNV = procedure(location: GLint; count: GLsizei; transpose: GLboolean; value: PGLfloat);stdcall;
  TglUniformSubroutinesuiv = procedure(shadertype: GLenum; count: GLsizei; indices: PGLuint);stdcall;
  TglUniformui64NV = procedure(location: GLint; value: GLuint64EXT);stdcall;
  TglUniformui64vNV = procedure(location: GLint; count: GLsizei; value: PGLuint64EXT);stdcall;
  TglUnlockArraysEXT = procedure;stdcall;
  TglUnmapBuffer = function(target: GLenum): GLboolean;stdcall;
  TglUnmapBufferARB = function(target: GLenum): GLboolean;stdcall;
  TglUnmapBufferOES = function(target: GLenum): GLboolean;stdcall;
  TglUnmapNamedBuffer = function(buffer: GLuint): GLboolean;stdcall;
  TglUnmapNamedBufferEXT = function(buffer: GLuint): GLboolean;stdcall;
  TglUnmapObjectBufferATI = procedure(buffer: GLuint);stdcall;
  TglUnmapTexture2DINTEL = procedure(texture: GLuint; level: GLint);stdcall;
  TglUpdateObjectBufferATI = procedure(buffer: GLuint; offset: GLuint; size: GLsizei; pointer: Pvoid; preserve: GLenum);stdcall;
  TglUseProgram = procedure(program_: GLuint);stdcall;
  TglUseProgramObjectARB = procedure(programObj: GLhandleARB);stdcall;
  TglUseProgramStages = procedure(pipeline: GLuint; stages: GLbitfield; program_: GLuint);stdcall;
  TglUseProgramStagesEXT = procedure(pipeline: GLuint; stages: GLbitfield; program_: GLuint);stdcall;
  TglUseShaderProgramEXT = procedure(type_: GLenum; program_: GLuint);stdcall;
  TglVDPAUFiniNV = procedure;stdcall;
  TglVDPAUGetSurfaceivNV = procedure(surface: GLvdpauSurfaceNV; pname: GLenum; bufSize: GLsizei; length: PGLsizei; values: PGLint);stdcall;
  TglVDPAUInitNV = procedure(vdpDevice: Pvoid; getProcAddress: Pvoid);stdcall;
  TglVDPAUIsSurfaceNV = function(surface: GLvdpauSurfaceNV): GLboolean;stdcall;
  TglVDPAUMapSurfacesNV = procedure(numSurfaces: GLsizei; surfaces: PGLvdpauSurfaceNV);stdcall;
  TglVDPAURegisterOutputSurfaceNV = function(vdpSurface: Pvoid; target: GLenum; numTextureNames: GLsizei; textureNames: PGLuint): GLvdpauSurfaceNV;stdcall;
  TglVDPAURegisterVideoSurfaceNV = function(vdpSurface: Pvoid; target: GLenum; numTextureNames: GLsizei; textureNames: PGLuint): GLvdpauSurfaceNV;stdcall;
  TglVDPAUSurfaceAccessNV = procedure(surface: GLvdpauSurfaceNV; access: GLenum);stdcall;
  TglVDPAUUnmapSurfacesNV = procedure(numSurface: GLsizei; surfaces: PGLvdpauSurfaceNV);stdcall;
  TglVDPAUUnregisterSurfaceNV = procedure(surface: GLvdpauSurfaceNV);stdcall;
  TglValidateProgram = procedure(program_: GLuint);stdcall;
  TglValidateProgramARB = procedure(programObj: GLhandleARB);stdcall;
  TglValidateProgramPipeline = procedure(pipeline: GLuint);stdcall;
  TglValidateProgramPipelineEXT = procedure(pipeline: GLuint);stdcall;
  TglVariantArrayObjectATI = procedure(id: GLuint; type_: GLenum; stride: GLsizei; buffer: GLuint; offset: GLuint);stdcall;
  TglVariantPointerEXT = procedure(id: GLuint; type_: GLenum; stride: GLuint; addr: Pvoid);stdcall;
  TglVariantbvEXT = procedure(id: GLuint; addr: PGLbyte);stdcall;
  TglVariantdvEXT = procedure(id: GLuint; addr: PGLdouble);stdcall;
  TglVariantfvEXT = procedure(id: GLuint; addr: PGLfloat);stdcall;
  TglVariantivEXT = procedure(id: GLuint; addr: PGLint);stdcall;
  TglVariantsvEXT = procedure(id: GLuint; addr: PGLshort);stdcall;
  TglVariantubvEXT = procedure(id: GLuint; addr: PGLubyte);stdcall;
  TglVariantuivEXT = procedure(id: GLuint; addr: PGLuint);stdcall;
  TglVariantusvEXT = procedure(id: GLuint; addr: PGLushort);stdcall;
  TglVertex2bOES = procedure(x: GLbyte; y: GLbyte);stdcall;
  TglVertex2bvOES = procedure(coords: PGLbyte);stdcall;
  TglVertex2d = procedure(x: GLdouble; y: GLdouble);stdcall;
  TglVertex2dv = procedure(v: PGLdouble);stdcall;
  TglVertex2f = procedure(x: GLfloat; y: GLfloat);stdcall;
  TglVertex2fv = procedure(v: PGLfloat);stdcall;
  TglVertex2hNV = procedure(x: GLhalfNV; y: GLhalfNV);stdcall;
  TglVertex2hvNV = procedure(v: PGLhalfNV);stdcall;
  TglVertex2i = procedure(x: GLint; y: GLint);stdcall;
  TglVertex2iv = procedure(v: PGLint);stdcall;
  TglVertex2s = procedure(x: GLshort; y: GLshort);stdcall;
  TglVertex2sv = procedure(v: PGLshort);stdcall;
  TglVertex2xOES = procedure(x: GLfixed);stdcall;
  TglVertex2xvOES = procedure(coords: PGLfixed);stdcall;
  TglVertex3bOES = procedure(x: GLbyte; y: GLbyte; z: GLbyte);stdcall;
  TglVertex3bvOES = procedure(coords: PGLbyte);stdcall;
  TglVertex3d = procedure(x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglVertex3dv = procedure(v: PGLdouble);stdcall;
  TglVertex3f = procedure(x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglVertex3fv = procedure(v: PGLfloat);stdcall;
  TglVertex3hNV = procedure(x: GLhalfNV; y: GLhalfNV; z: GLhalfNV);stdcall;
  TglVertex3hvNV = procedure(v: PGLhalfNV);stdcall;
  TglVertex3i = procedure(x: GLint; y: GLint; z: GLint);stdcall;
  TglVertex3iv = procedure(v: PGLint);stdcall;
  TglVertex3s = procedure(x: GLshort; y: GLshort; z: GLshort);stdcall;
  TglVertex3sv = procedure(v: PGLshort);stdcall;
  TglVertex3xOES = procedure(x: GLfixed; y: GLfixed);stdcall;
  TglVertex3xvOES = procedure(coords: PGLfixed);stdcall;
  TglVertex4bOES = procedure(x: GLbyte; y: GLbyte; z: GLbyte; w: GLbyte);stdcall;
  TglVertex4bvOES = procedure(coords: PGLbyte);stdcall;
  TglVertex4d = procedure(x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble);stdcall;
  TglVertex4dv = procedure(v: PGLdouble);stdcall;
  TglVertex4f = procedure(x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat);stdcall;
  TglVertex4fv = procedure(v: PGLfloat);stdcall;
  TglVertex4hNV = procedure(x: GLhalfNV; y: GLhalfNV; z: GLhalfNV; w: GLhalfNV);stdcall;
  TglVertex4hvNV = procedure(v: PGLhalfNV);stdcall;
  TglVertex4i = procedure(x: GLint; y: GLint; z: GLint; w: GLint);stdcall;
  TglVertex4iv = procedure(v: PGLint);stdcall;
  TglVertex4s = procedure(x: GLshort; y: GLshort; z: GLshort; w: GLshort);stdcall;
  TglVertex4sv = procedure(v: PGLshort);stdcall;
  TglVertex4xOES = procedure(x: GLfixed; y: GLfixed; z: GLfixed);stdcall;
  TglVertex4xvOES = procedure(coords: PGLfixed);stdcall;
  TglVertexArrayAttribBinding = procedure(vaobj: GLuint; attribindex: GLuint; bindingindex: GLuint);stdcall;
  TglVertexArrayAttribFormat = procedure(vaobj: GLuint; attribindex: GLuint; size: GLint; type_: GLenum; normalized: GLboolean; relativeoffset: GLuint);stdcall;
  TglVertexArrayAttribIFormat = procedure(vaobj: GLuint; attribindex: GLuint; size: GLint; type_: GLenum; relativeoffset: GLuint);stdcall;
  TglVertexArrayAttribLFormat = procedure(vaobj: GLuint; attribindex: GLuint; size: GLint; type_: GLenum; relativeoffset: GLuint);stdcall;
  TglVertexArrayBindVertexBufferEXT = procedure(vaobj: GLuint; bindingindex: GLuint; buffer: GLuint; offset: GLintptr; stride: GLsizei);stdcall;
  TglVertexArrayBindingDivisor = procedure(vaobj: GLuint; bindingindex: GLuint; divisor: GLuint);stdcall;
  TglVertexArrayColorOffsetEXT = procedure(vaobj: GLuint; buffer: GLuint; size: GLint; type_: GLenum; stride: GLsizei; offset: GLintptr);stdcall;
  TglVertexArrayEdgeFlagOffsetEXT = procedure(vaobj: GLuint; buffer: GLuint; stride: GLsizei; offset: GLintptr);stdcall;
  TglVertexArrayElementBuffer = procedure(vaobj: GLuint; buffer: GLuint);stdcall;
  TglVertexArrayFogCoordOffsetEXT = procedure(vaobj: GLuint; buffer: GLuint; type_: GLenum; stride: GLsizei; offset: GLintptr);stdcall;
  TglVertexArrayIndexOffsetEXT = procedure(vaobj: GLuint; buffer: GLuint; type_: GLenum; stride: GLsizei; offset: GLintptr);stdcall;
  TglVertexArrayMultiTexCoordOffsetEXT = procedure(vaobj: GLuint; buffer: GLuint; texunit: GLenum; size: GLint; type_: GLenum; stride: GLsizei; offset: GLintptr);stdcall;
  TglVertexArrayNormalOffsetEXT = procedure(vaobj: GLuint; buffer: GLuint; type_: GLenum; stride: GLsizei; offset: GLintptr);stdcall;
  TglVertexArrayParameteriAPPLE = procedure(pname: GLenum; param: GLint);stdcall;
  TglVertexArrayRangeAPPLE = procedure(length: GLsizei; pointer: Pvoid);stdcall;
  TglVertexArrayRangeNV = procedure(length: GLsizei; pointer: Pvoid);stdcall;
  TglVertexArraySecondaryColorOffsetEXT = procedure(vaobj: GLuint; buffer: GLuint; size: GLint; type_: GLenum; stride: GLsizei; offset: GLintptr);stdcall;
  TglVertexArrayTexCoordOffsetEXT = procedure(vaobj: GLuint; buffer: GLuint; size: GLint; type_: GLenum; stride: GLsizei; offset: GLintptr);stdcall;
  TglVertexArrayVertexAttribBindingEXT = procedure(vaobj: GLuint; attribindex: GLuint; bindingindex: GLuint);stdcall;
  TglVertexArrayVertexAttribDivisorEXT = procedure(vaobj: GLuint; index_: GLuint; divisor: GLuint);stdcall;
  TglVertexArrayVertexAttribFormatEXT = procedure(vaobj: GLuint; attribindex: GLuint; size: GLint; type_: GLenum; normalized: GLboolean; relativeoffset: GLuint);stdcall;
  TglVertexArrayVertexAttribIFormatEXT = procedure(vaobj: GLuint; attribindex: GLuint; size: GLint; type_: GLenum; relativeoffset: GLuint);stdcall;
  TglVertexArrayVertexAttribIOffsetEXT = procedure(vaobj: GLuint; buffer: GLuint; index_: GLuint; size: GLint; type_: GLenum; stride: GLsizei; offset: GLintptr);stdcall;
  TglVertexArrayVertexAttribLFormatEXT = procedure(vaobj: GLuint; attribindex: GLuint; size: GLint; type_: GLenum; relativeoffset: GLuint);stdcall;
  TglVertexArrayVertexAttribLOffsetEXT = procedure(vaobj: GLuint; buffer: GLuint; index_: GLuint; size: GLint; type_: GLenum; stride: GLsizei; offset: GLintptr);stdcall;
  TglVertexArrayVertexAttribOffsetEXT = procedure(vaobj: GLuint; buffer: GLuint; index_: GLuint; size: GLint; type_: GLenum; normalized: GLboolean; stride: GLsizei; offset: GLintptr);stdcall;
  TglVertexArrayVertexBindingDivisorEXT = procedure(vaobj: GLuint; bindingindex: GLuint; divisor: GLuint);stdcall;
  TglVertexArrayVertexBuffer = procedure(vaobj: GLuint; bindingindex: GLuint; buffer: GLuint; offset: GLintptr; stride: GLsizei);stdcall;
  TglVertexArrayVertexBuffers = procedure(vaobj: GLuint; first: GLuint; count: GLsizei; buffers: PGLuint; offsets: PGLintptr; strides: PGLsizei);stdcall;
  TglVertexArrayVertexOffsetEXT = procedure(vaobj: GLuint; buffer: GLuint; size: GLint; type_: GLenum; stride: GLsizei; offset: GLintptr);stdcall;
  TglVertexAttrib1d = procedure(index_: GLuint; x: GLdouble);stdcall;
  TglVertexAttrib1dARB = procedure(index_: GLuint; x: GLdouble);stdcall;
  TglVertexAttrib1dNV = procedure(index_: GLuint; x: GLdouble);stdcall;
  TglVertexAttrib1dv = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttrib1dvARB = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttrib1dvNV = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttrib1f = procedure(index_: GLuint; x: GLfloat);stdcall;
  TglVertexAttrib1fARB = procedure(index_: GLuint; x: GLfloat);stdcall;
  TglVertexAttrib1fNV = procedure(index_: GLuint; x: GLfloat);stdcall;
  TglVertexAttrib1fv = procedure(index_: GLuint; v: PGLfloat);stdcall;
  TglVertexAttrib1fvARB = procedure(index_: GLuint; v: PGLfloat);stdcall;
  TglVertexAttrib1fvNV = procedure(index_: GLuint; v: PGLfloat);stdcall;
  TglVertexAttrib1hNV = procedure(index_: GLuint; x: GLhalfNV);stdcall;
  TglVertexAttrib1hvNV = procedure(index_: GLuint; v: PGLhalfNV);stdcall;
  TglVertexAttrib1s = procedure(index_: GLuint; x: GLshort);stdcall;
  TglVertexAttrib1sARB = procedure(index_: GLuint; x: GLshort);stdcall;
  TglVertexAttrib1sNV = procedure(index_: GLuint; x: GLshort);stdcall;
  TglVertexAttrib1sv = procedure(index_: GLuint; v: PGLshort);stdcall;
  TglVertexAttrib1svARB = procedure(index_: GLuint; v: PGLshort);stdcall;
  TglVertexAttrib1svNV = procedure(index_: GLuint; v: PGLshort);stdcall;
  TglVertexAttrib2d = procedure(index_: GLuint; x: GLdouble; y: GLdouble);stdcall;
  TglVertexAttrib2dARB = procedure(index_: GLuint; x: GLdouble; y: GLdouble);stdcall;
  TglVertexAttrib2dNV = procedure(index_: GLuint; x: GLdouble; y: GLdouble);stdcall;
  TglVertexAttrib2dv = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttrib2dvARB = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttrib2dvNV = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttrib2f = procedure(index_: GLuint; x: GLfloat; y: GLfloat);stdcall;
  TglVertexAttrib2fARB = procedure(index_: GLuint; x: GLfloat; y: GLfloat);stdcall;
  TglVertexAttrib2fNV = procedure(index_: GLuint; x: GLfloat; y: GLfloat);stdcall;
  TglVertexAttrib2fv = procedure(index_: GLuint; v: PGLfloat);stdcall;
  TglVertexAttrib2fvARB = procedure(index_: GLuint; v: PGLfloat);stdcall;
  TglVertexAttrib2fvNV = procedure(index_: GLuint; v: PGLfloat);stdcall;
  TglVertexAttrib2hNV = procedure(index_: GLuint; x: GLhalfNV; y: GLhalfNV);stdcall;
  TglVertexAttrib2hvNV = procedure(index_: GLuint; v: PGLhalfNV);stdcall;
  TglVertexAttrib2s = procedure(index_: GLuint; x: GLshort; y: GLshort);stdcall;
  TglVertexAttrib2sARB = procedure(index_: GLuint; x: GLshort; y: GLshort);stdcall;
  TglVertexAttrib2sNV = procedure(index_: GLuint; x: GLshort; y: GLshort);stdcall;
  TglVertexAttrib2sv = procedure(index_: GLuint; v: PGLshort);stdcall;
  TglVertexAttrib2svARB = procedure(index_: GLuint; v: PGLshort);stdcall;
  TglVertexAttrib2svNV = procedure(index_: GLuint; v: PGLshort);stdcall;
  TglVertexAttrib3d = procedure(index_: GLuint; x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglVertexAttrib3dARB = procedure(index_: GLuint; x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglVertexAttrib3dNV = procedure(index_: GLuint; x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglVertexAttrib3dv = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttrib3dvARB = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttrib3dvNV = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttrib3f = procedure(index_: GLuint; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglVertexAttrib3fARB = procedure(index_: GLuint; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglVertexAttrib3fNV = procedure(index_: GLuint; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglVertexAttrib3fv = procedure(index_: GLuint; v: PGLfloat);stdcall;
  TglVertexAttrib3fvARB = procedure(index_: GLuint; v: PGLfloat);stdcall;
  TglVertexAttrib3fvNV = procedure(index_: GLuint; v: PGLfloat);stdcall;
  TglVertexAttrib3hNV = procedure(index_: GLuint; x: GLhalfNV; y: GLhalfNV; z: GLhalfNV);stdcall;
  TglVertexAttrib3hvNV = procedure(index_: GLuint; v: PGLhalfNV);stdcall;
  TglVertexAttrib3s = procedure(index_: GLuint; x: GLshort; y: GLshort; z: GLshort);stdcall;
  TglVertexAttrib3sARB = procedure(index_: GLuint; x: GLshort; y: GLshort; z: GLshort);stdcall;
  TglVertexAttrib3sNV = procedure(index_: GLuint; x: GLshort; y: GLshort; z: GLshort);stdcall;
  TglVertexAttrib3sv = procedure(index_: GLuint; v: PGLshort);stdcall;
  TglVertexAttrib3svARB = procedure(index_: GLuint; v: PGLshort);stdcall;
  TglVertexAttrib3svNV = procedure(index_: GLuint; v: PGLshort);stdcall;
  TglVertexAttrib4Nbv = procedure(index_: GLuint; v: PGLbyte);stdcall;
  TglVertexAttrib4NbvARB = procedure(index_: GLuint; v: PGLbyte);stdcall;
  TglVertexAttrib4Niv = procedure(index_: GLuint; v: PGLint);stdcall;
  TglVertexAttrib4NivARB = procedure(index_: GLuint; v: PGLint);stdcall;
  TglVertexAttrib4Nsv = procedure(index_: GLuint; v: PGLshort);stdcall;
  TglVertexAttrib4NsvARB = procedure(index_: GLuint; v: PGLshort);stdcall;
  TglVertexAttrib4Nub = procedure(index_: GLuint; x: GLubyte; y: GLubyte; z: GLubyte; w: GLubyte);stdcall;
  TglVertexAttrib4NubARB = procedure(index_: GLuint; x: GLubyte; y: GLubyte; z: GLubyte; w: GLubyte);stdcall;
  TglVertexAttrib4Nubv = procedure(index_: GLuint; v: PGLubyte);stdcall;
  TglVertexAttrib4NubvARB = procedure(index_: GLuint; v: PGLubyte);stdcall;
  TglVertexAttrib4Nuiv = procedure(index_: GLuint; v: PGLuint);stdcall;
  TglVertexAttrib4NuivARB = procedure(index_: GLuint; v: PGLuint);stdcall;
  TglVertexAttrib4Nusv = procedure(index_: GLuint; v: PGLushort);stdcall;
  TglVertexAttrib4NusvARB = procedure(index_: GLuint; v: PGLushort);stdcall;
  TglVertexAttrib4bv = procedure(index_: GLuint; v: PGLbyte);stdcall;
  TglVertexAttrib4bvARB = procedure(index_: GLuint; v: PGLbyte);stdcall;
  TglVertexAttrib4d = procedure(index_: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble);stdcall;
  TglVertexAttrib4dARB = procedure(index_: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble);stdcall;
  TglVertexAttrib4dNV = procedure(index_: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble);stdcall;
  TglVertexAttrib4dv = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttrib4dvARB = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttrib4dvNV = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttrib4f = procedure(index_: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat);stdcall;
  TglVertexAttrib4fARB = procedure(index_: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat);stdcall;
  TglVertexAttrib4fNV = procedure(index_: GLuint; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat);stdcall;
  TglVertexAttrib4fv = procedure(index_: GLuint; v: PGLfloat);stdcall;
  TglVertexAttrib4fvARB = procedure(index_: GLuint; v: PGLfloat);stdcall;
  TglVertexAttrib4fvNV = procedure(index_: GLuint; v: PGLfloat);stdcall;
  TglVertexAttrib4hNV = procedure(index_: GLuint; x: GLhalfNV; y: GLhalfNV; z: GLhalfNV; w: GLhalfNV);stdcall;
  TglVertexAttrib4hvNV = procedure(index_: GLuint; v: PGLhalfNV);stdcall;
  TglVertexAttrib4iv = procedure(index_: GLuint; v: PGLint);stdcall;
  TglVertexAttrib4ivARB = procedure(index_: GLuint; v: PGLint);stdcall;
  TglVertexAttrib4s = procedure(index_: GLuint; x: GLshort; y: GLshort; z: GLshort; w: GLshort);stdcall;
  TglVertexAttrib4sARB = procedure(index_: GLuint; x: GLshort; y: GLshort; z: GLshort; w: GLshort);stdcall;
  TglVertexAttrib4sNV = procedure(index_: GLuint; x: GLshort; y: GLshort; z: GLshort; w: GLshort);stdcall;
  TglVertexAttrib4sv = procedure(index_: GLuint; v: PGLshort);stdcall;
  TglVertexAttrib4svARB = procedure(index_: GLuint; v: PGLshort);stdcall;
  TglVertexAttrib4svNV = procedure(index_: GLuint; v: PGLshort);stdcall;
  TglVertexAttrib4ubNV = procedure(index_: GLuint; x: GLubyte; y: GLubyte; z: GLubyte; w: GLubyte);stdcall;
  TglVertexAttrib4ubv = procedure(index_: GLuint; v: PGLubyte);stdcall;
  TglVertexAttrib4ubvARB = procedure(index_: GLuint; v: PGLubyte);stdcall;
  TglVertexAttrib4ubvNV = procedure(index_: GLuint; v: PGLubyte);stdcall;
  TglVertexAttrib4uiv = procedure(index_: GLuint; v: PGLuint);stdcall;
  TglVertexAttrib4uivARB = procedure(index_: GLuint; v: PGLuint);stdcall;
  TglVertexAttrib4usv = procedure(index_: GLuint; v: PGLushort);stdcall;
  TglVertexAttrib4usvARB = procedure(index_: GLuint; v: PGLushort);stdcall;
  TglVertexAttribArrayObjectATI = procedure(index_: GLuint; size: GLint; type_: GLenum; normalized: GLboolean; stride: GLsizei; buffer: GLuint; offset: GLuint);stdcall;
  TglVertexAttribBinding = procedure(attribindex: GLuint; bindingindex: GLuint);stdcall;
  TglVertexAttribDivisor = procedure(index_: GLuint; divisor: GLuint);stdcall;
  TglVertexAttribDivisorANGLE = procedure(index_: GLuint; divisor: GLuint);stdcall;
  TglVertexAttribDivisorARB = procedure(index_: GLuint; divisor: GLuint);stdcall;
  TglVertexAttribDivisorEXT = procedure(index_: GLuint; divisor: GLuint);stdcall;
  TglVertexAttribDivisorNV = procedure(index_: GLuint; divisor: GLuint);stdcall;
  TglVertexAttribFormat = procedure(attribindex: GLuint; size: GLint; type_: GLenum; normalized: GLboolean; relativeoffset: GLuint);stdcall;
  TglVertexAttribFormatNV = procedure(index_: GLuint; size: GLint; type_: GLenum; normalized: GLboolean; stride: GLsizei);stdcall;
  TglVertexAttribI1i = procedure(index_: GLuint; x: GLint);stdcall;
  TglVertexAttribI1iEXT = procedure(index_: GLuint; x: GLint);stdcall;
  TglVertexAttribI1iv = procedure(index_: GLuint; v: PGLint);stdcall;
  TglVertexAttribI1ivEXT = procedure(index_: GLuint; v: PGLint);stdcall;
  TglVertexAttribI1ui = procedure(index_: GLuint; x: GLuint);stdcall;
  TglVertexAttribI1uiEXT = procedure(index_: GLuint; x: GLuint);stdcall;
  TglVertexAttribI1uiv = procedure(index_: GLuint; v: PGLuint);stdcall;
  TglVertexAttribI1uivEXT = procedure(index_: GLuint; v: PGLuint);stdcall;
  TglVertexAttribI2i = procedure(index_: GLuint; x: GLint; y: GLint);stdcall;
  TglVertexAttribI2iEXT = procedure(index_: GLuint; x: GLint; y: GLint);stdcall;
  TglVertexAttribI2iv = procedure(index_: GLuint; v: PGLint);stdcall;
  TglVertexAttribI2ivEXT = procedure(index_: GLuint; v: PGLint);stdcall;
  TglVertexAttribI2ui = procedure(index_: GLuint; x: GLuint; y: GLuint);stdcall;
  TglVertexAttribI2uiEXT = procedure(index_: GLuint; x: GLuint; y: GLuint);stdcall;
  TglVertexAttribI2uiv = procedure(index_: GLuint; v: PGLuint);stdcall;
  TglVertexAttribI2uivEXT = procedure(index_: GLuint; v: PGLuint);stdcall;
  TglVertexAttribI3i = procedure(index_: GLuint; x: GLint; y: GLint; z: GLint);stdcall;
  TglVertexAttribI3iEXT = procedure(index_: GLuint; x: GLint; y: GLint; z: GLint);stdcall;
  TglVertexAttribI3iv = procedure(index_: GLuint; v: PGLint);stdcall;
  TglVertexAttribI3ivEXT = procedure(index_: GLuint; v: PGLint);stdcall;
  TglVertexAttribI3ui = procedure(index_: GLuint; x: GLuint; y: GLuint; z: GLuint);stdcall;
  TglVertexAttribI3uiEXT = procedure(index_: GLuint; x: GLuint; y: GLuint; z: GLuint);stdcall;
  TglVertexAttribI3uiv = procedure(index_: GLuint; v: PGLuint);stdcall;
  TglVertexAttribI3uivEXT = procedure(index_: GLuint; v: PGLuint);stdcall;
  TglVertexAttribI4bv = procedure(index_: GLuint; v: PGLbyte);stdcall;
  TglVertexAttribI4bvEXT = procedure(index_: GLuint; v: PGLbyte);stdcall;
  TglVertexAttribI4i = procedure(index_: GLuint; x: GLint; y: GLint; z: GLint; w: GLint);stdcall;
  TglVertexAttribI4iEXT = procedure(index_: GLuint; x: GLint; y: GLint; z: GLint; w: GLint);stdcall;
  TglVertexAttribI4iv = procedure(index_: GLuint; v: PGLint);stdcall;
  TglVertexAttribI4ivEXT = procedure(index_: GLuint; v: PGLint);stdcall;
  TglVertexAttribI4sv = procedure(index_: GLuint; v: PGLshort);stdcall;
  TglVertexAttribI4svEXT = procedure(index_: GLuint; v: PGLshort);stdcall;
  TglVertexAttribI4ubv = procedure(index_: GLuint; v: PGLubyte);stdcall;
  TglVertexAttribI4ubvEXT = procedure(index_: GLuint; v: PGLubyte);stdcall;
  TglVertexAttribI4ui = procedure(index_: GLuint; x: GLuint; y: GLuint; z: GLuint; w: GLuint);stdcall;
  TglVertexAttribI4uiEXT = procedure(index_: GLuint; x: GLuint; y: GLuint; z: GLuint; w: GLuint);stdcall;
  TglVertexAttribI4uiv = procedure(index_: GLuint; v: PGLuint);stdcall;
  TglVertexAttribI4uivEXT = procedure(index_: GLuint; v: PGLuint);stdcall;
  TglVertexAttribI4usv = procedure(index_: GLuint; v: PGLushort);stdcall;
  TglVertexAttribI4usvEXT = procedure(index_: GLuint; v: PGLushort);stdcall;
  TglVertexAttribIFormat = procedure(attribindex: GLuint; size: GLint; type_: GLenum; relativeoffset: GLuint);stdcall;
  TglVertexAttribIFormatNV = procedure(index_: GLuint; size: GLint; type_: GLenum; stride: GLsizei);stdcall;
  TglVertexAttribIPointer = procedure(index_: GLuint; size: GLint; type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglVertexAttribIPointerEXT = procedure(index_: GLuint; size: GLint; type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglVertexAttribL1d = procedure(index_: GLuint; x: GLdouble);stdcall;
  TglVertexAttribL1dEXT = procedure(index_: GLuint; x: GLdouble);stdcall;
  TglVertexAttribL1dv = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttribL1dvEXT = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttribL1i64NV = procedure(index_: GLuint; x: GLint64EXT);stdcall;
  TglVertexAttribL1i64vNV = procedure(index_: GLuint; v: PGLint64EXT);stdcall;
  TglVertexAttribL1ui64ARB = procedure(index_: GLuint; x: GLuint64EXT);stdcall;
  TglVertexAttribL1ui64NV = procedure(index_: GLuint; x: GLuint64EXT);stdcall;
  TglVertexAttribL1ui64vARB = procedure(index_: GLuint; v: PGLuint64EXT);stdcall;
  TglVertexAttribL1ui64vNV = procedure(index_: GLuint; v: PGLuint64EXT);stdcall;
  TglVertexAttribL2d = procedure(index_: GLuint; x: GLdouble; y: GLdouble);stdcall;
  TglVertexAttribL2dEXT = procedure(index_: GLuint; x: GLdouble; y: GLdouble);stdcall;
  TglVertexAttribL2dv = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttribL2dvEXT = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttribL2i64NV = procedure(index_: GLuint; x: GLint64EXT; y: GLint64EXT);stdcall;
  TglVertexAttribL2i64vNV = procedure(index_: GLuint; v: PGLint64EXT);stdcall;
  TglVertexAttribL2ui64NV = procedure(index_: GLuint; x: GLuint64EXT; y: GLuint64EXT);stdcall;
  TglVertexAttribL2ui64vNV = procedure(index_: GLuint; v: PGLuint64EXT);stdcall;
  TglVertexAttribL3d = procedure(index_: GLuint; x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglVertexAttribL3dEXT = procedure(index_: GLuint; x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglVertexAttribL3dv = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttribL3dvEXT = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttribL3i64NV = procedure(index_: GLuint; x: GLint64EXT; y: GLint64EXT; z: GLint64EXT);stdcall;
  TglVertexAttribL3i64vNV = procedure(index_: GLuint; v: PGLint64EXT);stdcall;
  TglVertexAttribL3ui64NV = procedure(index_: GLuint; x: GLuint64EXT; y: GLuint64EXT; z: GLuint64EXT);stdcall;
  TglVertexAttribL3ui64vNV = procedure(index_: GLuint; v: PGLuint64EXT);stdcall;
  TglVertexAttribL4d = procedure(index_: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble);stdcall;
  TglVertexAttribL4dEXT = procedure(index_: GLuint; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble);stdcall;
  TglVertexAttribL4dv = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttribL4dvEXT = procedure(index_: GLuint; v: PGLdouble);stdcall;
  TglVertexAttribL4i64NV = procedure(index_: GLuint; x: GLint64EXT; y: GLint64EXT; z: GLint64EXT; w: GLint64EXT);stdcall;
  TglVertexAttribL4i64vNV = procedure(index_: GLuint; v: PGLint64EXT);stdcall;
  TglVertexAttribL4ui64NV = procedure(index_: GLuint; x: GLuint64EXT; y: GLuint64EXT; z: GLuint64EXT; w: GLuint64EXT);stdcall;
  TglVertexAttribL4ui64vNV = procedure(index_: GLuint; v: PGLuint64EXT);stdcall;
  TglVertexAttribLFormat = procedure(attribindex: GLuint; size: GLint; type_: GLenum; relativeoffset: GLuint);stdcall;
  TglVertexAttribLFormatNV = procedure(index_: GLuint; size: GLint; type_: GLenum; stride: GLsizei);stdcall;
  TglVertexAttribLPointer = procedure(index_: GLuint; size: GLint; type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglVertexAttribLPointerEXT = procedure(index_: GLuint; size: GLint; type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglVertexAttribP1ui = procedure(index_: GLuint; type_: GLenum; normalized: GLboolean; value: GLuint);stdcall;
  TglVertexAttribP1uiv = procedure(index_: GLuint; type_: GLenum; normalized: GLboolean; value: PGLuint);stdcall;
  TglVertexAttribP2ui = procedure(index_: GLuint; type_: GLenum; normalized: GLboolean; value: GLuint);stdcall;
  TglVertexAttribP2uiv = procedure(index_: GLuint; type_: GLenum; normalized: GLboolean; value: PGLuint);stdcall;
  TglVertexAttribP3ui = procedure(index_: GLuint; type_: GLenum; normalized: GLboolean; value: GLuint);stdcall;
  TglVertexAttribP3uiv = procedure(index_: GLuint; type_: GLenum; normalized: GLboolean; value: PGLuint);stdcall;
  TglVertexAttribP4ui = procedure(index_: GLuint; type_: GLenum; normalized: GLboolean; value: GLuint);stdcall;
  TglVertexAttribP4uiv = procedure(index_: GLuint; type_: GLenum; normalized: GLboolean; value: PGLuint);stdcall;
  TglVertexAttribParameteriAMD = procedure(index_: GLuint; pname: GLenum; param: GLint);stdcall;
  TglVertexAttribPointer = procedure(index_: GLuint; size: GLint; type_: GLenum; normalized: GLboolean; stride: GLsizei; pointer: Pvoid);stdcall;
  TglVertexAttribPointerARB = procedure(index_: GLuint; size: GLint; type_: GLenum; normalized: GLboolean; stride: GLsizei; pointer: Pvoid);stdcall;
  TglVertexAttribPointerNV = procedure(index_: GLuint; fsize: GLint; type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglVertexAttribs1dvNV = procedure(index_: GLuint; count: GLsizei; v: PGLdouble);stdcall;
  TglVertexAttribs1fvNV = procedure(index_: GLuint; count: GLsizei; v: PGLfloat);stdcall;
  TglVertexAttribs1hvNV = procedure(index_: GLuint; n: GLsizei; v: PGLhalfNV);stdcall;
  TglVertexAttribs1svNV = procedure(index_: GLuint; count: GLsizei; v: PGLshort);stdcall;
  TglVertexAttribs2dvNV = procedure(index_: GLuint; count: GLsizei; v: PGLdouble);stdcall;
  TglVertexAttribs2fvNV = procedure(index_: GLuint; count: GLsizei; v: PGLfloat);stdcall;
  TglVertexAttribs2hvNV = procedure(index_: GLuint; n: GLsizei; v: PGLhalfNV);stdcall;
  TglVertexAttribs2svNV = procedure(index_: GLuint; count: GLsizei; v: PGLshort);stdcall;
  TglVertexAttribs3dvNV = procedure(index_: GLuint; count: GLsizei; v: PGLdouble);stdcall;
  TglVertexAttribs3fvNV = procedure(index_: GLuint; count: GLsizei; v: PGLfloat);stdcall;
  TglVertexAttribs3hvNV = procedure(index_: GLuint; n: GLsizei; v: PGLhalfNV);stdcall;
  TglVertexAttribs3svNV = procedure(index_: GLuint; count: GLsizei; v: PGLshort);stdcall;
  TglVertexAttribs4dvNV = procedure(index_: GLuint; count: GLsizei; v: PGLdouble);stdcall;
  TglVertexAttribs4fvNV = procedure(index_: GLuint; count: GLsizei; v: PGLfloat);stdcall;
  TglVertexAttribs4hvNV = procedure(index_: GLuint; n: GLsizei; v: PGLhalfNV);stdcall;
  TglVertexAttribs4svNV = procedure(index_: GLuint; count: GLsizei; v: PGLshort);stdcall;
  TglVertexAttribs4ubvNV = procedure(index_: GLuint; count: GLsizei; v: PGLubyte);stdcall;
  TglVertexBindingDivisor = procedure(bindingindex: GLuint; divisor: GLuint);stdcall;
  TglVertexBlendARB = procedure(count: GLint);stdcall;
  TglVertexBlendEnvfATI = procedure(pname: GLenum; param: GLfloat);stdcall;
  TglVertexBlendEnviATI = procedure(pname: GLenum; param: GLint);stdcall;
  TglVertexFormatNV = procedure(size: GLint; type_: GLenum; stride: GLsizei);stdcall;
  TglVertexP2ui = procedure(type_: GLenum; value: GLuint);stdcall;
  TglVertexP2uiv = procedure(type_: GLenum; value: PGLuint);stdcall;
  TglVertexP3ui = procedure(type_: GLenum; value: GLuint);stdcall;
  TglVertexP3uiv = procedure(type_: GLenum; value: PGLuint);stdcall;
  TglVertexP4ui = procedure(type_: GLenum; value: GLuint);stdcall;
  TglVertexP4uiv = procedure(type_: GLenum; value: PGLuint);stdcall;
  TglVertexPointer = procedure(size: GLint; type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglVertexPointerEXT = procedure(size: GLint; type_: GLenum; stride: GLsizei; count: GLsizei; pointer: Pvoid);stdcall;
  TglVertexPointerListIBM = procedure(size: GLint; type_: GLenum; stride: GLint; pointer: PPvoid; ptrstride: GLint);stdcall;
  TglVertexPointervINTEL = procedure(size: GLint; type_: GLenum; pointer: PPvoid);stdcall;
  TglVertexStream1dATI = procedure(stream: GLenum; x: GLdouble);stdcall;
  TglVertexStream1dvATI = procedure(stream: GLenum; coords: PGLdouble);stdcall;
  TglVertexStream1fATI = procedure(stream: GLenum; x: GLfloat);stdcall;
  TglVertexStream1fvATI = procedure(stream: GLenum; coords: PGLfloat);stdcall;
  TglVertexStream1iATI = procedure(stream: GLenum; x: GLint);stdcall;
  TglVertexStream1ivATI = procedure(stream: GLenum; coords: PGLint);stdcall;
  TglVertexStream1sATI = procedure(stream: GLenum; x: GLshort);stdcall;
  TglVertexStream1svATI = procedure(stream: GLenum; coords: PGLshort);stdcall;
  TglVertexStream2dATI = procedure(stream: GLenum; x: GLdouble; y: GLdouble);stdcall;
  TglVertexStream2dvATI = procedure(stream: GLenum; coords: PGLdouble);stdcall;
  TglVertexStream2fATI = procedure(stream: GLenum; x: GLfloat; y: GLfloat);stdcall;
  TglVertexStream2fvATI = procedure(stream: GLenum; coords: PGLfloat);stdcall;
  TglVertexStream2iATI = procedure(stream: GLenum; x: GLint; y: GLint);stdcall;
  TglVertexStream2ivATI = procedure(stream: GLenum; coords: PGLint);stdcall;
  TglVertexStream2sATI = procedure(stream: GLenum; x: GLshort; y: GLshort);stdcall;
  TglVertexStream2svATI = procedure(stream: GLenum; coords: PGLshort);stdcall;
  TglVertexStream3dATI = procedure(stream: GLenum; x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglVertexStream3dvATI = procedure(stream: GLenum; coords: PGLdouble);stdcall;
  TglVertexStream3fATI = procedure(stream: GLenum; x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglVertexStream3fvATI = procedure(stream: GLenum; coords: PGLfloat);stdcall;
  TglVertexStream3iATI = procedure(stream: GLenum; x: GLint; y: GLint; z: GLint);stdcall;
  TglVertexStream3ivATI = procedure(stream: GLenum; coords: PGLint);stdcall;
  TglVertexStream3sATI = procedure(stream: GLenum; x: GLshort; y: GLshort; z: GLshort);stdcall;
  TglVertexStream3svATI = procedure(stream: GLenum; coords: PGLshort);stdcall;
  TglVertexStream4dATI = procedure(stream: GLenum; x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble);stdcall;
  TglVertexStream4dvATI = procedure(stream: GLenum; coords: PGLdouble);stdcall;
  TglVertexStream4fATI = procedure(stream: GLenum; x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat);stdcall;
  TglVertexStream4fvATI = procedure(stream: GLenum; coords: PGLfloat);stdcall;
  TglVertexStream4iATI = procedure(stream: GLenum; x: GLint; y: GLint; z: GLint; w: GLint);stdcall;
  TglVertexStream4ivATI = procedure(stream: GLenum; coords: PGLint);stdcall;
  TglVertexStream4sATI = procedure(stream: GLenum; x: GLshort; y: GLshort; z: GLshort; w: GLshort);stdcall;
  TglVertexStream4svATI = procedure(stream: GLenum; coords: PGLshort);stdcall;
  TglVertexWeightPointerEXT = procedure(size: GLint; type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglVertexWeightfEXT = procedure(weight: GLfloat);stdcall;
  TglVertexWeightfvEXT = procedure(weight: PGLfloat);stdcall;
  TglVertexWeighthNV = procedure(weight: GLhalfNV);stdcall;
  TglVertexWeighthvNV = procedure(weight: PGLhalfNV);stdcall;
  TglVideoCaptureNV = function(video_capture_slot: GLuint; sequence_num: PGLuint; capture_time: PGLuint64EXT): GLenum;stdcall;
  TglVideoCaptureStreamParameterdvNV = procedure(video_capture_slot: GLuint; stream: GLuint; pname: GLenum; params: PGLdouble);stdcall;
  TglVideoCaptureStreamParameterfvNV = procedure(video_capture_slot: GLuint; stream: GLuint; pname: GLenum; params: PGLfloat);stdcall;
  TglVideoCaptureStreamParameterivNV = procedure(video_capture_slot: GLuint; stream: GLuint; pname: GLenum; params: PGLint);stdcall;
  TglViewport = procedure(x: GLint; y: GLint; width: GLsizei; height: GLsizei);stdcall;
  TglViewportArrayv = procedure(first: GLuint; count: GLsizei; v: PGLfloat);stdcall;
  TglViewportArrayvNV = procedure(first: GLuint; count: GLsizei; v: PGLfloat);stdcall;
  TglViewportArrayvOES = procedure(first: GLuint; count: GLsizei; v: PGLfloat);stdcall;
  TglViewportIndexedf = procedure(index_: GLuint; x: GLfloat; y: GLfloat; w: GLfloat; h: GLfloat);stdcall;
  TglViewportIndexedfOES = procedure(index_: GLuint; x: GLfloat; y: GLfloat; w: GLfloat; h: GLfloat);stdcall;
  TglViewportIndexedfNV = procedure(index_: GLuint; x: GLfloat; y: GLfloat; w: GLfloat; h: GLfloat);stdcall;
  TglViewportIndexedfv = procedure(index_: GLuint; v: PGLfloat);stdcall;
  TglViewportIndexedfvOES = procedure(index_: GLuint; v: PGLfloat);stdcall;
  TglViewportIndexedfvNV = procedure(index_: GLuint; v: PGLfloat);stdcall;
  TglViewportPositionWScaleNV = procedure(index_: GLuint; xcoeff: GLfloat; ycoeff: GLfloat);stdcall;
  TglViewportSwizzleNV = procedure(index_: GLuint; swizzlex: GLenum; swizzley: GLenum; swizzlez: GLenum; swizzlew: GLenum);stdcall;
  TglWaitSemaphoreEXT = procedure(semaphore: GLuint; numBufferBarriers: GLuint; buffers: PGLuint; numTextureBarriers: GLuint; textures: PGLuint; srcLayouts: PGLenum);stdcall;
  TglWaitSync = procedure(sync: GLsync; flags: GLbitfield; timeout: GLuint64);stdcall;
  TglWaitSyncAPPLE = procedure(sync: GLsync; flags: GLbitfield; timeout: GLuint64);stdcall;
  TglWeightPathsNV = procedure(resultPath: GLuint; numPaths: GLsizei; paths: PGLuint; weights: PGLfloat);stdcall;
  TglWeightPointerARB = procedure(size: GLint; type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglWeightPointerOES = procedure(size: GLint; type_: GLenum; stride: GLsizei; pointer: Pvoid);stdcall;
  TglWeightbvARB = procedure(size: GLint; weights: PGLbyte);stdcall;
  TglWeightdvARB = procedure(size: GLint; weights: PGLdouble);stdcall;
  TglWeightfvARB = procedure(size: GLint; weights: PGLfloat);stdcall;
  TglWeightivARB = procedure(size: GLint; weights: PGLint);stdcall;
  TglWeightsvARB = procedure(size: GLint; weights: PGLshort);stdcall;
  TglWeightubvARB = procedure(size: GLint; weights: PGLubyte);stdcall;
  TglWeightuivARB = procedure(size: GLint; weights: PGLuint);stdcall;
  TglWeightusvARB = procedure(size: GLint; weights: PGLushort);stdcall;
  TglWindowPos2d = procedure(x: GLdouble; y: GLdouble);stdcall;
  TglWindowPos2dARB = procedure(x: GLdouble; y: GLdouble);stdcall;
  TglWindowPos2dMESA = procedure(x: GLdouble; y: GLdouble);stdcall;
  TglWindowPos2dv = procedure(v: PGLdouble);stdcall;
  TglWindowPos2dvARB = procedure(v: PGLdouble);stdcall;
  TglWindowPos2dvMESA = procedure(v: PGLdouble);stdcall;
  TglWindowPos2f = procedure(x: GLfloat; y: GLfloat);stdcall;
  TglWindowPos2fARB = procedure(x: GLfloat; y: GLfloat);stdcall;
  TglWindowPos2fMESA = procedure(x: GLfloat; y: GLfloat);stdcall;
  TglWindowPos2fv = procedure(v: PGLfloat);stdcall;
  TglWindowPos2fvARB = procedure(v: PGLfloat);stdcall;
  TglWindowPos2fvMESA = procedure(v: PGLfloat);stdcall;
  TglWindowPos2i = procedure(x: GLint; y: GLint);stdcall;
  TglWindowPos2iARB = procedure(x: GLint; y: GLint);stdcall;
  TglWindowPos2iMESA = procedure(x: GLint; y: GLint);stdcall;
  TglWindowPos2iv = procedure(v: PGLint);stdcall;
  TglWindowPos2ivARB = procedure(v: PGLint);stdcall;
  TglWindowPos2ivMESA = procedure(v: PGLint);stdcall;
  TglWindowPos2s = procedure(x: GLshort; y: GLshort);stdcall;
  TglWindowPos2sARB = procedure(x: GLshort; y: GLshort);stdcall;
  TglWindowPos2sMESA = procedure(x: GLshort; y: GLshort);stdcall;
  TglWindowPos2sv = procedure(v: PGLshort);stdcall;
  TglWindowPos2svARB = procedure(v: PGLshort);stdcall;
  TglWindowPos2svMESA = procedure(v: PGLshort);stdcall;
  TglWindowPos3d = procedure(x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglWindowPos3dARB = procedure(x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglWindowPos3dMESA = procedure(x: GLdouble; y: GLdouble; z: GLdouble);stdcall;
  TglWindowPos3dv = procedure(v: PGLdouble);stdcall;
  TglWindowPos3dvARB = procedure(v: PGLdouble);stdcall;
  TglWindowPos3dvMESA = procedure(v: PGLdouble);stdcall;
  TglWindowPos3f = procedure(x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglWindowPos3fARB = procedure(x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglWindowPos3fMESA = procedure(x: GLfloat; y: GLfloat; z: GLfloat);stdcall;
  TglWindowPos3fv = procedure(v: PGLfloat);stdcall;
  TglWindowPos3fvARB = procedure(v: PGLfloat);stdcall;
  TglWindowPos3fvMESA = procedure(v: PGLfloat);stdcall;
  TglWindowPos3i = procedure(x: GLint; y: GLint; z: GLint);stdcall;
  TglWindowPos3iARB = procedure(x: GLint; y: GLint; z: GLint);stdcall;
  TglWindowPos3iMESA = procedure(x: GLint; y: GLint; z: GLint);stdcall;
  TglWindowPos3iv = procedure(v: PGLint);stdcall;
  TglWindowPos3ivARB = procedure(v: PGLint);stdcall;
  TglWindowPos3ivMESA = procedure(v: PGLint);stdcall;
  TglWindowPos3s = procedure(x: GLshort; y: GLshort; z: GLshort);stdcall;
  TglWindowPos3sARB = procedure(x: GLshort; y: GLshort; z: GLshort);stdcall;
  TglWindowPos3sMESA = procedure(x: GLshort; y: GLshort; z: GLshort);stdcall;
  TglWindowPos3sv = procedure(v: PGLshort);stdcall;
  TglWindowPos3svARB = procedure(v: PGLshort);stdcall;
  TglWindowPos3svMESA = procedure(v: PGLshort);stdcall;
  TglWindowPos4dMESA = procedure(x: GLdouble; y: GLdouble; z: GLdouble; w: GLdouble);stdcall;
  TglWindowPos4dvMESA = procedure(v: PGLdouble);stdcall;
  TglWindowPos4fMESA = procedure(x: GLfloat; y: GLfloat; z: GLfloat; w: GLfloat);stdcall;
  TglWindowPos4fvMESA = procedure(v: PGLfloat);stdcall;
  TglWindowPos4iMESA = procedure(x: GLint; y: GLint; z: GLint; w: GLint);stdcall;
  TglWindowPos4ivMESA = procedure(v: PGLint);stdcall;
  TglWindowPos4sMESA = procedure(x: GLshort; y: GLshort; z: GLshort; w: GLshort);stdcall;
  TglWindowPos4svMESA = procedure(v: PGLshort);stdcall;
  TglWindowRectanglesEXT = procedure(mode: GLenum; count: GLsizei; box: PGLint);stdcall;
  TglWriteMaskEXT = procedure(res: GLuint; in_: GLuint; outX: GLenum; outY: GLenum; outZ: GLenum; outW: GLenum);stdcall;
  TglDrawVkImageNV = procedure(vkImage: GLuint64; sampler: GLuint; x0: GLfloat; y0: GLfloat; x1: GLfloat; y1: GLfloat; z: GLfloat; s0: GLfloat; t0: GLfloat; s1: GLfloat; t1: GLfloat);stdcall;
  TglGetVkProcAddrNV = function(name_: PGLchar): GLVULKANPROCNV;stdcall;
  TglWaitVkSemaphoreNV = procedure(vkSemaphore: GLuint64);stdcall;
  TglSignalVkSemaphoreNV = procedure(vkSemaphore: GLuint64);stdcall;
  TglSignalVkFenceNV = procedure(vkFence: GLuint64);stdcall;
var
  // OpenGL command variables
  glAccum: TglAccum;
  glAccumxOES: TglAccumxOES;
  glActiveProgramEXT: TglActiveProgramEXT;
  glActiveShaderProgram: TglActiveShaderProgram;
  glActiveShaderProgramEXT: TglActiveShaderProgramEXT;
  glActiveStencilFaceEXT: TglActiveStencilFaceEXT;
  glActiveTexture: TglActiveTexture;
  glActiveTextureARB: TglActiveTextureARB;
  glActiveVaryingNV: TglActiveVaryingNV;
  glAlphaFragmentOp1ATI: TglAlphaFragmentOp1ATI;
  glAlphaFragmentOp2ATI: TglAlphaFragmentOp2ATI;
  glAlphaFragmentOp3ATI: TglAlphaFragmentOp3ATI;
  glAlphaFunc: TglAlphaFunc;
  glAlphaFuncQCOM: TglAlphaFuncQCOM;
  glAlphaFuncx: TglAlphaFuncx;
  glAlphaFuncxOES: TglAlphaFuncxOES;
  glAlphaToCoverageDitherControlNV: TglAlphaToCoverageDitherControlNV;
  glApplyFramebufferAttachmentCMAAINTEL: TglApplyFramebufferAttachmentCMAAINTEL;
  glApplyTextureEXT: TglApplyTextureEXT;
  glAcquireKeyedMutexWin32EXT: TglAcquireKeyedMutexWin32EXT;
  glAreProgramsResidentNV: TglAreProgramsResidentNV;
  glAreTexturesResident: TglAreTexturesResident;
  glAreTexturesResidentEXT: TglAreTexturesResidentEXT;
  glArrayElement: TglArrayElement;
  glArrayElementEXT: TglArrayElementEXT;
  glArrayObjectATI: TglArrayObjectATI;
  glAsyncMarkerSGIX: TglAsyncMarkerSGIX;
  glAttachObjectARB: TglAttachObjectARB;
  glAttachShader: TglAttachShader;
  glBegin: TglBegin;
  glBeginConditionalRender: TglBeginConditionalRender;
  glBeginConditionalRenderNV: TglBeginConditionalRenderNV;
  glBeginConditionalRenderNVX: TglBeginConditionalRenderNVX;
  glBeginFragmentShaderATI: TglBeginFragmentShaderATI;
  glBeginOcclusionQueryNV: TglBeginOcclusionQueryNV;
  glBeginPerfMonitorAMD: TglBeginPerfMonitorAMD;
  glBeginPerfQueryINTEL: TglBeginPerfQueryINTEL;
  glBeginQuery: TglBeginQuery;
  glBeginQueryARB: TglBeginQueryARB;
  glBeginQueryEXT: TglBeginQueryEXT;
  glBeginQueryIndexed: TglBeginQueryIndexed;
  glBeginTransformFeedback: TglBeginTransformFeedback;
  glBeginTransformFeedbackEXT: TglBeginTransformFeedbackEXT;
  glBeginTransformFeedbackNV: TglBeginTransformFeedbackNV;
  glBeginVertexShaderEXT: TglBeginVertexShaderEXT;
  glBeginVideoCaptureNV: TglBeginVideoCaptureNV;
  glBindAttribLocation: TglBindAttribLocation;
  glBindAttribLocationARB: TglBindAttribLocationARB;
  glBindBuffer: TglBindBuffer;
  glBindBufferARB: TglBindBufferARB;
  glBindBufferBase: TglBindBufferBase;
  glBindBufferBaseEXT: TglBindBufferBaseEXT;
  glBindBufferBaseNV: TglBindBufferBaseNV;
  glBindBufferOffsetEXT: TglBindBufferOffsetEXT;
  glBindBufferOffsetNV: TglBindBufferOffsetNV;
  glBindBufferRange: TglBindBufferRange;
  glBindBufferRangeEXT: TglBindBufferRangeEXT;
  glBindBufferRangeNV: TglBindBufferRangeNV;
  glBindBuffersBase: TglBindBuffersBase;
  glBindBuffersRange: TglBindBuffersRange;
  glBindFragDataLocation: TglBindFragDataLocation;
  glBindFragDataLocationEXT: TglBindFragDataLocationEXT;
  glBindFragDataLocationIndexed: TglBindFragDataLocationIndexed;
  glBindFragDataLocationIndexedEXT: TglBindFragDataLocationIndexedEXT;
  glBindFragmentShaderATI: TglBindFragmentShaderATI;
  glBindFramebuffer: TglBindFramebuffer;
  glBindFramebufferEXT: TglBindFramebufferEXT;
  glBindFramebufferOES: TglBindFramebufferOES;
  glBindImageTexture: TglBindImageTexture;
  glBindImageTextureEXT: TglBindImageTextureEXT;
  glBindImageTextures: TglBindImageTextures;
  glBindLightParameterEXT: TglBindLightParameterEXT;
  glBindMaterialParameterEXT: TglBindMaterialParameterEXT;
  glBindMultiTextureEXT: TglBindMultiTextureEXT;
  glBindParameterEXT: TglBindParameterEXT;
  glBindProgramARB: TglBindProgramARB;
  glBindProgramNV: TglBindProgramNV;
  glBindProgramPipeline: TglBindProgramPipeline;
  glBindProgramPipelineEXT: TglBindProgramPipelineEXT;
  glBindRenderbuffer: TglBindRenderbuffer;
  glBindRenderbufferEXT: TglBindRenderbufferEXT;
  glBindRenderbufferOES: TglBindRenderbufferOES;
  glBindSampler: TglBindSampler;
  glBindSamplers: TglBindSamplers;
  glBindTexGenParameterEXT: TglBindTexGenParameterEXT;
  glBindTexture: TglBindTexture;
  glBindTextureEXT: TglBindTextureEXT;
  glBindTextureUnit: TglBindTextureUnit;
  glBindTextureUnitParameterEXT: TglBindTextureUnitParameterEXT;
  glBindTextures: TglBindTextures;
  glBindTransformFeedback: TglBindTransformFeedback;
  glBindTransformFeedbackNV: TglBindTransformFeedbackNV;
  glBindVertexArray: TglBindVertexArray;
  glBindVertexArrayAPPLE: TglBindVertexArrayAPPLE;
  glBindVertexArrayOES: TglBindVertexArrayOES;
  glBindVertexBuffer: TglBindVertexBuffer;
  glBindVertexBuffers: TglBindVertexBuffers;
  glBindVertexShaderEXT: TglBindVertexShaderEXT;
  glBindVideoCaptureStreamBufferNV: TglBindVideoCaptureStreamBufferNV;
  glBindVideoCaptureStreamTextureNV: TglBindVideoCaptureStreamTextureNV;
  glBinormal3bEXT: TglBinormal3bEXT;
  glBinormal3bvEXT: TglBinormal3bvEXT;
  glBinormal3dEXT: TglBinormal3dEXT;
  glBinormal3dvEXT: TglBinormal3dvEXT;
  glBinormal3fEXT: TglBinormal3fEXT;
  glBinormal3fvEXT: TglBinormal3fvEXT;
  glBinormal3iEXT: TglBinormal3iEXT;
  glBinormal3ivEXT: TglBinormal3ivEXT;
  glBinormal3sEXT: TglBinormal3sEXT;
  glBinormal3svEXT: TglBinormal3svEXT;
  glBinormalPointerEXT: TglBinormalPointerEXT;
  glBitmap: TglBitmap;
  glBitmapxOES: TglBitmapxOES;
  glBlendBarrier: TglBlendBarrier;
  glBlendBarrierKHR: TglBlendBarrierKHR;
  glBlendBarrierNV: TglBlendBarrierNV;
  glBlendColor: TglBlendColor;
  glBlendColorEXT: TglBlendColorEXT;
  glBlendColorxOES: TglBlendColorxOES;
  glBlendEquation: TglBlendEquation;
  glBlendEquationEXT: TglBlendEquationEXT;
  glBlendEquationIndexedAMD: TglBlendEquationIndexedAMD;
  glBlendEquationOES: TglBlendEquationOES;
  glBlendEquationSeparate: TglBlendEquationSeparate;
  glBlendEquationSeparateEXT: TglBlendEquationSeparateEXT;
  glBlendEquationSeparateIndexedAMD: TglBlendEquationSeparateIndexedAMD;
  glBlendEquationSeparateOES: TglBlendEquationSeparateOES;
  glBlendEquationSeparatei: TglBlendEquationSeparatei;
  glBlendEquationSeparateiARB: TglBlendEquationSeparateiARB;
  glBlendEquationSeparateiEXT: TglBlendEquationSeparateiEXT;
  glBlendEquationSeparateiOES: TglBlendEquationSeparateiOES;
  glBlendEquationi: TglBlendEquationi;
  glBlendEquationiARB: TglBlendEquationiARB;
  glBlendEquationiEXT: TglBlendEquationiEXT;
  glBlendEquationiOES: TglBlendEquationiOES;
  glBlendFunc: TglBlendFunc;
  glBlendFuncIndexedAMD: TglBlendFuncIndexedAMD;
  glBlendFuncSeparate: TglBlendFuncSeparate;
  glBlendFuncSeparateEXT: TglBlendFuncSeparateEXT;
  glBlendFuncSeparateINGR: TglBlendFuncSeparateINGR;
  glBlendFuncSeparateIndexedAMD: TglBlendFuncSeparateIndexedAMD;
  glBlendFuncSeparateOES: TglBlendFuncSeparateOES;
  glBlendFuncSeparatei: TglBlendFuncSeparatei;
  glBlendFuncSeparateiARB: TglBlendFuncSeparateiARB;
  glBlendFuncSeparateiEXT: TglBlendFuncSeparateiEXT;
  glBlendFuncSeparateiOES: TglBlendFuncSeparateiOES;
  glBlendFunci: TglBlendFunci;
  glBlendFunciARB: TglBlendFunciARB;
  glBlendFunciEXT: TglBlendFunciEXT;
  glBlendFunciOES: TglBlendFunciOES;
  glBlendParameteriNV: TglBlendParameteriNV;
  glBlitFramebuffer: TglBlitFramebuffer;
  glBlitFramebufferANGLE: TglBlitFramebufferANGLE;
  glBlitFramebufferEXT: TglBlitFramebufferEXT;
  glBlitFramebufferNV: TglBlitFramebufferNV;
  glBlitNamedFramebuffer: TglBlitNamedFramebuffer;
  glBufferAddressRangeNV: TglBufferAddressRangeNV;
  glBufferData: TglBufferData;
  glBufferDataARB: TglBufferDataARB;
  glBufferPageCommitmentARB: TglBufferPageCommitmentARB;
  glBufferParameteriAPPLE: TglBufferParameteriAPPLE;
  glBufferStorage: TglBufferStorage;
  glBufferStorageEXT: TglBufferStorageEXT;
  glBufferStorageExternalEXT: TglBufferStorageExternalEXT;
  glBufferStorageMemEXT: TglBufferStorageMemEXT;
  glBufferSubData: TglBufferSubData;
  glBufferSubDataARB: TglBufferSubDataARB;
  glCallCommandListNV: TglCallCommandListNV;
  glCallList: TglCallList;
  glCallLists: TglCallLists;
  glCheckFramebufferStatus: TglCheckFramebufferStatus;
  glCheckFramebufferStatusEXT: TglCheckFramebufferStatusEXT;
  glCheckFramebufferStatusOES: TglCheckFramebufferStatusOES;
  glCheckNamedFramebufferStatus: TglCheckNamedFramebufferStatus;
  glCheckNamedFramebufferStatusEXT: TglCheckNamedFramebufferStatusEXT;
  glClampColor: TglClampColor;
  glClampColorARB: TglClampColorARB;
  glClear: TglClear;
  glClearAccum: TglClearAccum;
  glClearAccumxOES: TglClearAccumxOES;
  glClearBufferData: TglClearBufferData;
  glClearBufferSubData: TglClearBufferSubData;
  glClearBufferfi: TglClearBufferfi;
  glClearBufferfv: TglClearBufferfv;
  glClearBufferiv: TglClearBufferiv;
  glClearBufferuiv: TglClearBufferuiv;
  glClearColor: TglClearColor;
  glClearColorIiEXT: TglClearColorIiEXT;
  glClearColorIuiEXT: TglClearColorIuiEXT;
  glClearColorx: TglClearColorx;
  glClearColorxOES: TglClearColorxOES;
  glClearDepth: TglClearDepth;
  glClearDepthdNV: TglClearDepthdNV;
  glClearDepthf: TglClearDepthf;
  glClearDepthfOES: TglClearDepthfOES;
  glClearDepthx: TglClearDepthx;
  glClearDepthxOES: TglClearDepthxOES;
  glClearIndex: TglClearIndex;
  glClearNamedBufferData: TglClearNamedBufferData;
  glClearNamedBufferDataEXT: TglClearNamedBufferDataEXT;
  glClearNamedBufferSubData: TglClearNamedBufferSubData;
  glClearNamedBufferSubDataEXT: TglClearNamedBufferSubDataEXT;
  glClearNamedFramebufferfi: TglClearNamedFramebufferfi;
  glClearNamedFramebufferfv: TglClearNamedFramebufferfv;
  glClearNamedFramebufferiv: TglClearNamedFramebufferiv;
  glClearNamedFramebufferuiv: TglClearNamedFramebufferuiv;
  glClearPixelLocalStorageuiEXT: TglClearPixelLocalStorageuiEXT;
  glClearStencil: TglClearStencil;
  glClearTexImage: TglClearTexImage;
  glClearTexImageEXT: TglClearTexImageEXT;
  glClearTexSubImage: TglClearTexSubImage;
  glClearTexSubImageEXT: TglClearTexSubImageEXT;
  glClientActiveTexture: TglClientActiveTexture;
  glClientActiveTextureARB: TglClientActiveTextureARB;
  glClientActiveVertexStreamATI: TglClientActiveVertexStreamATI;
  glClientAttribDefaultEXT: TglClientAttribDefaultEXT;
  glClientWaitSync: TglClientWaitSync;
  glClientWaitSyncAPPLE: TglClientWaitSyncAPPLE;
  glClipControl: TglClipControl;
  glClipPlane: TglClipPlane;
  glClipPlanef: TglClipPlanef;
  glClipPlanefIMG: TglClipPlanefIMG;
  glClipPlanefOES: TglClipPlanefOES;
  glClipPlanex: TglClipPlanex;
  glClipPlanexIMG: TglClipPlanexIMG;
  glClipPlanexOES: TglClipPlanexOES;
  glColor3b: TglColor3b;
  glColor3bv: TglColor3bv;
  glColor3d: TglColor3d;
  glColor3dv: TglColor3dv;
  glColor3f: TglColor3f;
  glColor3fVertex3fSUN: TglColor3fVertex3fSUN;
  glColor3fVertex3fvSUN: TglColor3fVertex3fvSUN;
  glColor3fv: TglColor3fv;
  glColor3hNV: TglColor3hNV;
  glColor3hvNV: TglColor3hvNV;
  glColor3i: TglColor3i;
  glColor3iv: TglColor3iv;
  glColor3s: TglColor3s;
  glColor3sv: TglColor3sv;
  glColor3ub: TglColor3ub;
  glColor3ubv: TglColor3ubv;
  glColor3ui: TglColor3ui;
  glColor3uiv: TglColor3uiv;
  glColor3us: TglColor3us;
  glColor3usv: TglColor3usv;
  glColor3xOES: TglColor3xOES;
  glColor3xvOES: TglColor3xvOES;
  glColor4b: TglColor4b;
  glColor4bv: TglColor4bv;
  glColor4d: TglColor4d;
  glColor4dv: TglColor4dv;
  glColor4f: TglColor4f;
  glColor4fNormal3fVertex3fSUN: TglColor4fNormal3fVertex3fSUN;
  glColor4fNormal3fVertex3fvSUN: TglColor4fNormal3fVertex3fvSUN;
  glColor4fv: TglColor4fv;
  glColor4hNV: TglColor4hNV;
  glColor4hvNV: TglColor4hvNV;
  glColor4i: TglColor4i;
  glColor4iv: TglColor4iv;
  glColor4s: TglColor4s;
  glColor4sv: TglColor4sv;
  glColor4ub: TglColor4ub;
  glColor4ubVertex2fSUN: TglColor4ubVertex2fSUN;
  glColor4ubVertex2fvSUN: TglColor4ubVertex2fvSUN;
  glColor4ubVertex3fSUN: TglColor4ubVertex3fSUN;
  glColor4ubVertex3fvSUN: TglColor4ubVertex3fvSUN;
  glColor4ubv: TglColor4ubv;
  glColor4ui: TglColor4ui;
  glColor4uiv: TglColor4uiv;
  glColor4us: TglColor4us;
  glColor4usv: TglColor4usv;
  glColor4x: TglColor4x;
  glColor4xOES: TglColor4xOES;
  glColor4xvOES: TglColor4xvOES;
  glColorFormatNV: TglColorFormatNV;
  glColorFragmentOp1ATI: TglColorFragmentOp1ATI;
  glColorFragmentOp2ATI: TglColorFragmentOp2ATI;
  glColorFragmentOp3ATI: TglColorFragmentOp3ATI;
  glColorMask: TglColorMask;
  glColorMaskIndexedEXT: TglColorMaskIndexedEXT;
  glColorMaski: TglColorMaski;
  glColorMaskiEXT: TglColorMaskiEXT;
  glColorMaskiOES: TglColorMaskiOES;
  glColorMaterial: TglColorMaterial;
  glColorP3ui: TglColorP3ui;
  glColorP3uiv: TglColorP3uiv;
  glColorP4ui: TglColorP4ui;
  glColorP4uiv: TglColorP4uiv;
  glColorPointer: TglColorPointer;
  glColorPointerEXT: TglColorPointerEXT;
  glColorPointerListIBM: TglColorPointerListIBM;
  glColorPointervINTEL: TglColorPointervINTEL;
  glColorSubTable: TglColorSubTable;
  glColorSubTableEXT: TglColorSubTableEXT;
  glColorTable: TglColorTable;
  glColorTableEXT: TglColorTableEXT;
  glColorTableParameterfv: TglColorTableParameterfv;
  glColorTableParameterfvSGI: TglColorTableParameterfvSGI;
  glColorTableParameteriv: TglColorTableParameteriv;
  glColorTableParameterivSGI: TglColorTableParameterivSGI;
  glColorTableSGI: TglColorTableSGI;
  glCombinerInputNV: TglCombinerInputNV;
  glCombinerOutputNV: TglCombinerOutputNV;
  glCombinerParameterfNV: TglCombinerParameterfNV;
  glCombinerParameterfvNV: TglCombinerParameterfvNV;
  glCombinerParameteriNV: TglCombinerParameteriNV;
  glCombinerParameterivNV: TglCombinerParameterivNV;
  glCombinerStageParameterfvNV: TglCombinerStageParameterfvNV;
  glCommandListSegmentsNV: TglCommandListSegmentsNV;
  glCompileCommandListNV: TglCompileCommandListNV;
  glCompileShader: TglCompileShader;
  glCompileShaderARB: TglCompileShaderARB;
  glCompileShaderIncludeARB: TglCompileShaderIncludeARB;
  glCompressedMultiTexImage1DEXT: TglCompressedMultiTexImage1DEXT;
  glCompressedMultiTexImage2DEXT: TglCompressedMultiTexImage2DEXT;
  glCompressedMultiTexImage3DEXT: TglCompressedMultiTexImage3DEXT;
  glCompressedMultiTexSubImage1DEXT: TglCompressedMultiTexSubImage1DEXT;
  glCompressedMultiTexSubImage2DEXT: TglCompressedMultiTexSubImage2DEXT;
  glCompressedMultiTexSubImage3DEXT: TglCompressedMultiTexSubImage3DEXT;
  glCompressedTexImage1D: TglCompressedTexImage1D;
  glCompressedTexImage1DARB: TglCompressedTexImage1DARB;
  glCompressedTexImage2D: TglCompressedTexImage2D;
  glCompressedTexImage2DARB: TglCompressedTexImage2DARB;
  glCompressedTexImage3D: TglCompressedTexImage3D;
  glCompressedTexImage3DARB: TglCompressedTexImage3DARB;
  glCompressedTexImage3DOES: TglCompressedTexImage3DOES;
  glCompressedTexSubImage1D: TglCompressedTexSubImage1D;
  glCompressedTexSubImage1DARB: TglCompressedTexSubImage1DARB;
  glCompressedTexSubImage2D: TglCompressedTexSubImage2D;
  glCompressedTexSubImage2DARB: TglCompressedTexSubImage2DARB;
  glCompressedTexSubImage3D: TglCompressedTexSubImage3D;
  glCompressedTexSubImage3DARB: TglCompressedTexSubImage3DARB;
  glCompressedTexSubImage3DOES: TglCompressedTexSubImage3DOES;
  glCompressedTextureImage1DEXT: TglCompressedTextureImage1DEXT;
  glCompressedTextureImage2DEXT: TglCompressedTextureImage2DEXT;
  glCompressedTextureImage3DEXT: TglCompressedTextureImage3DEXT;
  glCompressedTextureSubImage1D: TglCompressedTextureSubImage1D;
  glCompressedTextureSubImage1DEXT: TglCompressedTextureSubImage1DEXT;
  glCompressedTextureSubImage2D: TglCompressedTextureSubImage2D;
  glCompressedTextureSubImage2DEXT: TglCompressedTextureSubImage2DEXT;
  glCompressedTextureSubImage3D: TglCompressedTextureSubImage3D;
  glCompressedTextureSubImage3DEXT: TglCompressedTextureSubImage3DEXT;
  glConservativeRasterParameterfNV: TglConservativeRasterParameterfNV;
  glConservativeRasterParameteriNV: TglConservativeRasterParameteriNV;
  glConvolutionFilter1D: TglConvolutionFilter1D;
  glConvolutionFilter1DEXT: TglConvolutionFilter1DEXT;
  glConvolutionFilter2D: TglConvolutionFilter2D;
  glConvolutionFilter2DEXT: TglConvolutionFilter2DEXT;
  glConvolutionParameterf: TglConvolutionParameterf;
  glConvolutionParameterfEXT: TglConvolutionParameterfEXT;
  glConvolutionParameterfv: TglConvolutionParameterfv;
  glConvolutionParameterfvEXT: TglConvolutionParameterfvEXT;
  glConvolutionParameteri: TglConvolutionParameteri;
  glConvolutionParameteriEXT: TglConvolutionParameteriEXT;
  glConvolutionParameteriv: TglConvolutionParameteriv;
  glConvolutionParameterivEXT: TglConvolutionParameterivEXT;
  glConvolutionParameterxOES: TglConvolutionParameterxOES;
  glConvolutionParameterxvOES: TglConvolutionParameterxvOES;
  glCopyBufferSubData: TglCopyBufferSubData;
  glCopyBufferSubDataNV: TglCopyBufferSubDataNV;
  glCopyColorSubTable: TglCopyColorSubTable;
  glCopyColorSubTableEXT: TglCopyColorSubTableEXT;
  glCopyColorTable: TglCopyColorTable;
  glCopyColorTableSGI: TglCopyColorTableSGI;
  glCopyConvolutionFilter1D: TglCopyConvolutionFilter1D;
  glCopyConvolutionFilter1DEXT: TglCopyConvolutionFilter1DEXT;
  glCopyConvolutionFilter2D: TglCopyConvolutionFilter2D;
  glCopyConvolutionFilter2DEXT: TglCopyConvolutionFilter2DEXT;
  glCopyImageSubData: TglCopyImageSubData;
  glCopyImageSubDataEXT: TglCopyImageSubDataEXT;
  glCopyImageSubDataNV: TglCopyImageSubDataNV;
  glCopyImageSubDataOES: TglCopyImageSubDataOES;
  glCopyMultiTexImage1DEXT: TglCopyMultiTexImage1DEXT;
  glCopyMultiTexImage2DEXT: TglCopyMultiTexImage2DEXT;
  glCopyMultiTexSubImage1DEXT: TglCopyMultiTexSubImage1DEXT;
  glCopyMultiTexSubImage2DEXT: TglCopyMultiTexSubImage2DEXT;
  glCopyMultiTexSubImage3DEXT: TglCopyMultiTexSubImage3DEXT;
  glCopyNamedBufferSubData: TglCopyNamedBufferSubData;
  glCopyPathNV: TglCopyPathNV;
  glCopyPixels: TglCopyPixels;
  glCopyTexImage1D: TglCopyTexImage1D;
  glCopyTexImage1DEXT: TglCopyTexImage1DEXT;
  glCopyTexImage2D: TglCopyTexImage2D;
  glCopyTexImage2DEXT: TglCopyTexImage2DEXT;
  glCopyTexSubImage1D: TglCopyTexSubImage1D;
  glCopyTexSubImage1DEXT: TglCopyTexSubImage1DEXT;
  glCopyTexSubImage2D: TglCopyTexSubImage2D;
  glCopyTexSubImage2DEXT: TglCopyTexSubImage2DEXT;
  glCopyTexSubImage3D: TglCopyTexSubImage3D;
  glCopyTexSubImage3DEXT: TglCopyTexSubImage3DEXT;
  glCopyTexSubImage3DOES: TglCopyTexSubImage3DOES;
  glCopyTextureImage1DEXT: TglCopyTextureImage1DEXT;
  glCopyTextureImage2DEXT: TglCopyTextureImage2DEXT;
  glCopyTextureLevelsAPPLE: TglCopyTextureLevelsAPPLE;
  glCopyTextureSubImage1D: TglCopyTextureSubImage1D;
  glCopyTextureSubImage1DEXT: TglCopyTextureSubImage1DEXT;
  glCopyTextureSubImage2D: TglCopyTextureSubImage2D;
  glCopyTextureSubImage2DEXT: TglCopyTextureSubImage2DEXT;
  glCopyTextureSubImage3D: TglCopyTextureSubImage3D;
  glCopyTextureSubImage3DEXT: TglCopyTextureSubImage3DEXT;
  glCoverFillPathInstancedNV: TglCoverFillPathInstancedNV;
  glCoverFillPathNV: TglCoverFillPathNV;
  glCoverStrokePathInstancedNV: TglCoverStrokePathInstancedNV;
  glCoverStrokePathNV: TglCoverStrokePathNV;
  glCoverageMaskNV: TglCoverageMaskNV;
  glCoverageModulationNV: TglCoverageModulationNV;
  glCoverageModulationTableNV: TglCoverageModulationTableNV;
  glCoverageOperationNV: TglCoverageOperationNV;
  glCreateBuffers: TglCreateBuffers;
  glCreateCommandListsNV: TglCreateCommandListsNV;
  glCreateFramebuffers: TglCreateFramebuffers;
  glCreateMemoryObjectsEXT: TglCreateMemoryObjectsEXT;
  glCreatePerfQueryINTEL: TglCreatePerfQueryINTEL;
  glCreateProgram: TglCreateProgram;
  glCreateProgramObjectARB: TglCreateProgramObjectARB;
  glCreateProgramPipelines: TglCreateProgramPipelines;
  glCreateQueries: TglCreateQueries;
  glCreateRenderbuffers: TglCreateRenderbuffers;
  glCreateSamplers: TglCreateSamplers;
  glCreateShader: TglCreateShader;
  glCreateShaderObjectARB: TglCreateShaderObjectARB;
  glCreateShaderProgramEXT: TglCreateShaderProgramEXT;
  glCreateShaderProgramv: TglCreateShaderProgramv;
  glCreateShaderProgramvEXT: TglCreateShaderProgramvEXT;
  glCreateStatesNV: TglCreateStatesNV;
  glCreateSyncFromCLeventARB: TglCreateSyncFromCLeventARB;
  glCreateTextures: TglCreateTextures;
  glCreateTransformFeedbacks: TglCreateTransformFeedbacks;
  glCreateVertexArrays: TglCreateVertexArrays;
  glCullFace: TglCullFace;
  glCullParameterdvEXT: TglCullParameterdvEXT;
  glCullParameterfvEXT: TglCullParameterfvEXT;
  glCurrentPaletteMatrixARB: TglCurrentPaletteMatrixARB;
  glCurrentPaletteMatrixOES: TglCurrentPaletteMatrixOES;
  glDebugMessageCallback: TglDebugMessageCallback;
  glDebugMessageCallbackAMD: TglDebugMessageCallbackAMD;
  glDebugMessageCallbackARB: TglDebugMessageCallbackARB;
  glDebugMessageCallbackKHR: TglDebugMessageCallbackKHR;
  glDebugMessageControl: TglDebugMessageControl;
  glDebugMessageControlARB: TglDebugMessageControlARB;
  glDebugMessageControlKHR: TglDebugMessageControlKHR;
  glDebugMessageEnableAMD: TglDebugMessageEnableAMD;
  glDebugMessageInsert: TglDebugMessageInsert;
  glDebugMessageInsertAMD: TglDebugMessageInsertAMD;
  glDebugMessageInsertARB: TglDebugMessageInsertARB;
  glDebugMessageInsertKHR: TglDebugMessageInsertKHR;
  glDeformSGIX: TglDeformSGIX;
  glDeformationMap3dSGIX: TglDeformationMap3dSGIX;
  glDeformationMap3fSGIX: TglDeformationMap3fSGIX;
  glDeleteAsyncMarkersSGIX: TglDeleteAsyncMarkersSGIX;
  glDeleteBuffers: TglDeleteBuffers;
  glDeleteBuffersARB: TglDeleteBuffersARB;
  glDeleteCommandListsNV: TglDeleteCommandListsNV;
  glDeleteFencesAPPLE: TglDeleteFencesAPPLE;
  glDeleteFencesNV: TglDeleteFencesNV;
  glDeleteFragmentShaderATI: TglDeleteFragmentShaderATI;
  glDeleteFramebuffers: TglDeleteFramebuffers;
  glDeleteFramebuffersEXT: TglDeleteFramebuffersEXT;
  glDeleteFramebuffersOES: TglDeleteFramebuffersOES;
  glDeleteLists: TglDeleteLists;
  glDeleteMemoryObjectsEXT: TglDeleteMemoryObjectsEXT;
  glDeleteNamedStringARB: TglDeleteNamedStringARB;
  glDeleteNamesAMD: TglDeleteNamesAMD;
  glDeleteObjectARB: TglDeleteObjectARB;
  glDeleteOcclusionQueriesNV: TglDeleteOcclusionQueriesNV;
  glDeletePathsNV: TglDeletePathsNV;
  glDeletePerfMonitorsAMD: TglDeletePerfMonitorsAMD;
  glDeletePerfQueryINTEL: TglDeletePerfQueryINTEL;
  glDeleteProgram: TglDeleteProgram;
  glDeleteProgramPipelines: TglDeleteProgramPipelines;
  glDeleteProgramPipelinesEXT: TglDeleteProgramPipelinesEXT;
  glDeleteProgramsARB: TglDeleteProgramsARB;
  glDeleteProgramsNV: TglDeleteProgramsNV;
  glDeleteQueries: TglDeleteQueries;
  glDeleteQueriesARB: TglDeleteQueriesARB;
  glDeleteQueriesEXT: TglDeleteQueriesEXT;
  glDeleteRenderbuffers: TglDeleteRenderbuffers;
  glDeleteRenderbuffersEXT: TglDeleteRenderbuffersEXT;
  glDeleteRenderbuffersOES: TglDeleteRenderbuffersOES;
  glDeleteSamplers: TglDeleteSamplers;
  glDeleteSemaphoresEXT: TglDeleteSemaphoresEXT;
  glDeleteShader: TglDeleteShader;
  glDeleteStatesNV: TglDeleteStatesNV;
  glDeleteSync: TglDeleteSync;
  glDeleteSyncAPPLE: TglDeleteSyncAPPLE;
  glDeleteTextures: TglDeleteTextures;
  glDeleteTexturesEXT: TglDeleteTexturesEXT;
  glDeleteTransformFeedbacks: TglDeleteTransformFeedbacks;
  glDeleteTransformFeedbacksNV: TglDeleteTransformFeedbacksNV;
  glDeleteVertexArrays: TglDeleteVertexArrays;
  glDeleteVertexArraysAPPLE: TglDeleteVertexArraysAPPLE;
  glDeleteVertexArraysOES: TglDeleteVertexArraysOES;
  glDeleteVertexShaderEXT: TglDeleteVertexShaderEXT;
  glDepthBoundsEXT: TglDepthBoundsEXT;
  glDepthBoundsdNV: TglDepthBoundsdNV;
  glDepthFunc: TglDepthFunc;
  glDepthMask: TglDepthMask;
  glDepthRange: TglDepthRange;
  glDepthRangeArrayfvNV: TglDepthRangeArrayfvNV;
  glDepthRangeArrayfvOES: TglDepthRangeArrayfvOES;
  glDepthRangeArrayv: TglDepthRangeArrayv;
  glDepthRangeIndexed: TglDepthRangeIndexed;
  glDepthRangeIndexedfNV: TglDepthRangeIndexedfNV;
  glDepthRangeIndexedfOES: TglDepthRangeIndexedfOES;
  glDepthRangedNV: TglDepthRangedNV;
  glDepthRangef: TglDepthRangef;
  glDepthRangefOES: TglDepthRangefOES;
  glDepthRangex: TglDepthRangex;
  glDepthRangexOES: TglDepthRangexOES;
  glDetachObjectARB: TglDetachObjectARB;
  glDetachShader: TglDetachShader;
  glDetailTexFuncSGIS: TglDetailTexFuncSGIS;
  glDisable: TglDisable;
  glDisableClientState: TglDisableClientState;
  glDisableClientStateIndexedEXT: TglDisableClientStateIndexedEXT;
  glDisableClientStateiEXT: TglDisableClientStateiEXT;
  glDisableDriverControlQCOM: TglDisableDriverControlQCOM;
  glDisableIndexedEXT: TglDisableIndexedEXT;
  glDisableVariantClientStateEXT: TglDisableVariantClientStateEXT;
  glDisableVertexArrayAttrib: TglDisableVertexArrayAttrib;
  glDisableVertexArrayAttribEXT: TglDisableVertexArrayAttribEXT;
  glDisableVertexArrayEXT: TglDisableVertexArrayEXT;
  glDisableVertexAttribAPPLE: TglDisableVertexAttribAPPLE;
  glDisableVertexAttribArray: TglDisableVertexAttribArray;
  glDisableVertexAttribArrayARB: TglDisableVertexAttribArrayARB;
  glDisablei: TglDisablei;
  glDisableiEXT: TglDisableiEXT;
  glDisableiNV: TglDisableiNV;
  glDisableiOES: TglDisableiOES;
  glDiscardFramebufferEXT: TglDiscardFramebufferEXT;
  glDispatchCompute: TglDispatchCompute;
  glDispatchComputeGroupSizeARB: TglDispatchComputeGroupSizeARB;
  glDispatchComputeIndirect: TglDispatchComputeIndirect;
  glDrawArrays: TglDrawArrays;
  glDrawArraysEXT: TglDrawArraysEXT;
  glDrawArraysIndirect: TglDrawArraysIndirect;
  glDrawArraysInstanced: TglDrawArraysInstanced;
  glDrawArraysInstancedANGLE: TglDrawArraysInstancedANGLE;
  glDrawArraysInstancedARB: TglDrawArraysInstancedARB;
  glDrawArraysInstancedBaseInstance: TglDrawArraysInstancedBaseInstance;
  glDrawArraysInstancedBaseInstanceEXT: TglDrawArraysInstancedBaseInstanceEXT;
  glDrawArraysInstancedEXT: TglDrawArraysInstancedEXT;
  glDrawArraysInstancedNV: TglDrawArraysInstancedNV;
  glDrawBuffer: TglDrawBuffer;
  glDrawBuffers: TglDrawBuffers;
  glDrawBuffersARB: TglDrawBuffersARB;
  glDrawBuffersATI: TglDrawBuffersATI;
  glDrawBuffersEXT: TglDrawBuffersEXT;
  glDrawBuffersIndexedEXT: TglDrawBuffersIndexedEXT;
  glDrawBuffersNV: TglDrawBuffersNV;
  glDrawCommandsAddressNV: TglDrawCommandsAddressNV;
  glDrawCommandsNV: TglDrawCommandsNV;
  glDrawCommandsStatesAddressNV: TglDrawCommandsStatesAddressNV;
  glDrawCommandsStatesNV: TglDrawCommandsStatesNV;
  glDrawElementArrayAPPLE: TglDrawElementArrayAPPLE;
  glDrawElementArrayATI: TglDrawElementArrayATI;
  glDrawElements: TglDrawElements;
  glDrawElementsBaseVertex: TglDrawElementsBaseVertex;
  glDrawElementsBaseVertexEXT: TglDrawElementsBaseVertexEXT;
  glDrawElementsBaseVertexOES: TglDrawElementsBaseVertexOES;
  glDrawElementsIndirect: TglDrawElementsIndirect;
  glDrawElementsInstanced: TglDrawElementsInstanced;
  glDrawElementsInstancedANGLE: TglDrawElementsInstancedANGLE;
  glDrawElementsInstancedARB: TglDrawElementsInstancedARB;
  glDrawElementsInstancedBaseInstance: TglDrawElementsInstancedBaseInstance;
  glDrawElementsInstancedBaseInstanceEXT: TglDrawElementsInstancedBaseInstanceEXT;
  glDrawElementsInstancedBaseVertex: TglDrawElementsInstancedBaseVertex;
  glDrawElementsInstancedBaseVertexBaseInstance: TglDrawElementsInstancedBaseVertexBaseInstance;
  glDrawElementsInstancedBaseVertexBaseInstanceEXT: TglDrawElementsInstancedBaseVertexBaseInstanceEXT;
  glDrawElementsInstancedBaseVertexEXT: TglDrawElementsInstancedBaseVertexEXT;
  glDrawElementsInstancedBaseVertexOES: TglDrawElementsInstancedBaseVertexOES;
  glDrawElementsInstancedEXT: TglDrawElementsInstancedEXT;
  glDrawElementsInstancedNV: TglDrawElementsInstancedNV;
  glDrawMeshArraysSUN: TglDrawMeshArraysSUN;
  glDrawPixels: TglDrawPixels;
  glDrawRangeElementArrayAPPLE: TglDrawRangeElementArrayAPPLE;
  glDrawRangeElementArrayATI: TglDrawRangeElementArrayATI;
  glDrawRangeElements: TglDrawRangeElements;
  glDrawRangeElementsBaseVertex: TglDrawRangeElementsBaseVertex;
  glDrawRangeElementsBaseVertexEXT: TglDrawRangeElementsBaseVertexEXT;
  glDrawRangeElementsBaseVertexOES: TglDrawRangeElementsBaseVertexOES;
  glDrawRangeElementsEXT: TglDrawRangeElementsEXT;
  glDrawTexfOES: TglDrawTexfOES;
  glDrawTexfvOES: TglDrawTexfvOES;
  glDrawTexiOES: TglDrawTexiOES;
  glDrawTexivOES: TglDrawTexivOES;
  glDrawTexsOES: TglDrawTexsOES;
  glDrawTexsvOES: TglDrawTexsvOES;
  glDrawTextureNV: TglDrawTextureNV;
  glDrawTexxOES: TglDrawTexxOES;
  glDrawTexxvOES: TglDrawTexxvOES;
  glDrawTransformFeedback: TglDrawTransformFeedback;
  glDrawTransformFeedbackEXT: TglDrawTransformFeedbackEXT;
  glDrawTransformFeedbackInstanced: TglDrawTransformFeedbackInstanced;
  glDrawTransformFeedbackInstancedEXT: TglDrawTransformFeedbackInstancedEXT;
  glDrawTransformFeedbackNV: TglDrawTransformFeedbackNV;
  glDrawTransformFeedbackStream: TglDrawTransformFeedbackStream;
  glDrawTransformFeedbackStreamInstanced: TglDrawTransformFeedbackStreamInstanced;
  glEGLImageTargetRenderbufferStorageOES: TglEGLImageTargetRenderbufferStorageOES;
  glEGLImageTargetTexture2DOES: TglEGLImageTargetTexture2DOES;
  glEdgeFlag: TglEdgeFlag;
  glEdgeFlagFormatNV: TglEdgeFlagFormatNV;
  glEdgeFlagPointer: TglEdgeFlagPointer;
  glEdgeFlagPointerEXT: TglEdgeFlagPointerEXT;
  glEdgeFlagPointerListIBM: TglEdgeFlagPointerListIBM;
  glEdgeFlagv: TglEdgeFlagv;
  glElementPointerAPPLE: TglElementPointerAPPLE;
  glElementPointerATI: TglElementPointerATI;
  glEnable: TglEnable;
  glEnableClientState: TglEnableClientState;
  glEnableClientStateIndexedEXT: TglEnableClientStateIndexedEXT;
  glEnableClientStateiEXT: TglEnableClientStateiEXT;
  glEnableDriverControlQCOM: TglEnableDriverControlQCOM;
  glEnableIndexedEXT: TglEnableIndexedEXT;
  glEnableVariantClientStateEXT: TglEnableVariantClientStateEXT;
  glEnableVertexArrayAttrib: TglEnableVertexArrayAttrib;
  glEnableVertexArrayAttribEXT: TglEnableVertexArrayAttribEXT;
  glEnableVertexArrayEXT: TglEnableVertexArrayEXT;
  glEnableVertexAttribAPPLE: TglEnableVertexAttribAPPLE;
  glEnableVertexAttribArray: TglEnableVertexAttribArray;
  glEnableVertexAttribArrayARB: TglEnableVertexAttribArrayARB;
  glEnablei: TglEnablei;
  glEnableiEXT: TglEnableiEXT;
  glEnableiNV: TglEnableiNV;
  glEnableiOES: TglEnableiOES;
  glEnd: TglEnd;
  glEndConditionalRender: TglEndConditionalRender;
  glEndConditionalRenderNV: TglEndConditionalRenderNV;
  glEndConditionalRenderNVX: TglEndConditionalRenderNVX;
  glEndFragmentShaderATI: TglEndFragmentShaderATI;
  glEndList: TglEndList;
  glEndOcclusionQueryNV: TglEndOcclusionQueryNV;
  glEndPerfMonitorAMD: TglEndPerfMonitorAMD;
  glEndPerfQueryINTEL: TglEndPerfQueryINTEL;
  glEndQuery: TglEndQuery;
  glEndQueryARB: TglEndQueryARB;
  glEndQueryEXT: TglEndQueryEXT;
  glEndQueryIndexed: TglEndQueryIndexed;
  glEndTilingQCOM: TglEndTilingQCOM;
  glEndTransformFeedback: TglEndTransformFeedback;
  glEndTransformFeedbackEXT: TglEndTransformFeedbackEXT;
  glEndTransformFeedbackNV: TglEndTransformFeedbackNV;
  glEndVertexShaderEXT: TglEndVertexShaderEXT;
  glEndVideoCaptureNV: TglEndVideoCaptureNV;
  glEvalCoord1d: TglEvalCoord1d;
  glEvalCoord1dv: TglEvalCoord1dv;
  glEvalCoord1f: TglEvalCoord1f;
  glEvalCoord1fv: TglEvalCoord1fv;
  glEvalCoord1xOES: TglEvalCoord1xOES;
  glEvalCoord1xvOES: TglEvalCoord1xvOES;
  glEvalCoord2d: TglEvalCoord2d;
  glEvalCoord2dv: TglEvalCoord2dv;
  glEvalCoord2f: TglEvalCoord2f;
  glEvalCoord2fv: TglEvalCoord2fv;
  glEvalCoord2xOES: TglEvalCoord2xOES;
  glEvalCoord2xvOES: TglEvalCoord2xvOES;
  glEvalMapsNV: TglEvalMapsNV;
  glEvalMesh1: TglEvalMesh1;
  glEvalMesh2: TglEvalMesh2;
  glEvalPoint1: TglEvalPoint1;
  glEvalPoint2: TglEvalPoint2;
  glEvaluateDepthValuesARB: TglEvaluateDepthValuesARB;
  glExecuteProgramNV: TglExecuteProgramNV;
  glExtGetBufferPointervQCOM: TglExtGetBufferPointervQCOM;
  glExtGetBuffersQCOM: TglExtGetBuffersQCOM;
  glExtGetFramebuffersQCOM: TglExtGetFramebuffersQCOM;
  glExtGetProgramBinarySourceQCOM: TglExtGetProgramBinarySourceQCOM;
  glExtGetProgramsQCOM: TglExtGetProgramsQCOM;
  glExtGetRenderbuffersQCOM: TglExtGetRenderbuffersQCOM;
  glExtGetShadersQCOM: TglExtGetShadersQCOM;
  glExtGetTexLevelParameterivQCOM: TglExtGetTexLevelParameterivQCOM;
  glExtGetTexSubImageQCOM: TglExtGetTexSubImageQCOM;
  glExtGetTexturesQCOM: TglExtGetTexturesQCOM;
  glExtIsProgramBinaryQCOM: TglExtIsProgramBinaryQCOM;
  glExtTexObjectStateOverrideiQCOM: TglExtTexObjectStateOverrideiQCOM;
  glExtractComponentEXT: TglExtractComponentEXT;
  glFeedbackBuffer: TglFeedbackBuffer;
  glFeedbackBufferxOES: TglFeedbackBufferxOES;
  glFenceSync: TglFenceSync;
  glFenceSyncAPPLE: TglFenceSyncAPPLE;
  glFinalCombinerInputNV: TglFinalCombinerInputNV;
  glFinish: TglFinish;
  glFinishAsyncSGIX: TglFinishAsyncSGIX;
  glFinishFenceAPPLE: TglFinishFenceAPPLE;
  glFinishFenceNV: TglFinishFenceNV;
  glFinishObjectAPPLE: TglFinishObjectAPPLE;
  glFinishTextureSUNX: TglFinishTextureSUNX;
  glFlush: TglFlush;
  glFlushMappedBufferRange: TglFlushMappedBufferRange;
  glFlushMappedBufferRangeAPPLE: TglFlushMappedBufferRangeAPPLE;
  glFlushMappedBufferRangeEXT: TglFlushMappedBufferRangeEXT;
  glFlushMappedNamedBufferRange: TglFlushMappedNamedBufferRange;
  glFlushMappedNamedBufferRangeEXT: TglFlushMappedNamedBufferRangeEXT;
  glFlushPixelDataRangeNV: TglFlushPixelDataRangeNV;
  glFlushRasterSGIX: TglFlushRasterSGIX;
  glFlushStaticDataIBM: TglFlushStaticDataIBM;
  glFlushVertexArrayRangeAPPLE: TglFlushVertexArrayRangeAPPLE;
  glFlushVertexArrayRangeNV: TglFlushVertexArrayRangeNV;
  glFogCoordFormatNV: TglFogCoordFormatNV;
  glFogCoordPointer: TglFogCoordPointer;
  glFogCoordPointerEXT: TglFogCoordPointerEXT;
  glFogCoordPointerListIBM: TglFogCoordPointerListIBM;
  glFogCoordd: TglFogCoordd;
  glFogCoorddEXT: TglFogCoorddEXT;
  glFogCoorddv: TglFogCoorddv;
  glFogCoorddvEXT: TglFogCoorddvEXT;
  glFogCoordf: TglFogCoordf;
  glFogCoordfEXT: TglFogCoordfEXT;
  glFogCoordfv: TglFogCoordfv;
  glFogCoordfvEXT: TglFogCoordfvEXT;
  glFogCoordhNV: TglFogCoordhNV;
  glFogCoordhvNV: TglFogCoordhvNV;
  glFogFuncSGIS: TglFogFuncSGIS;
  glFogf: TglFogf;
  glFogfv: TglFogfv;
  glFogi: TglFogi;
  glFogiv: TglFogiv;
  glFogx: TglFogx;
  glFogxOES: TglFogxOES;
  glFogxv: TglFogxv;
  glFogxvOES: TglFogxvOES;
  glFragmentColorMaterialSGIX: TglFragmentColorMaterialSGIX;
  glFragmentCoverageColorNV: TglFragmentCoverageColorNV;
  glFragmentLightModelfSGIX: TglFragmentLightModelfSGIX;
  glFragmentLightModelfvSGIX: TglFragmentLightModelfvSGIX;
  glFragmentLightModeliSGIX: TglFragmentLightModeliSGIX;
  glFragmentLightModelivSGIX: TglFragmentLightModelivSGIX;
  glFragmentLightfSGIX: TglFragmentLightfSGIX;
  glFragmentLightfvSGIX: TglFragmentLightfvSGIX;
  glFragmentLightiSGIX: TglFragmentLightiSGIX;
  glFragmentLightivSGIX: TglFragmentLightivSGIX;
  glFragmentMaterialfSGIX: TglFragmentMaterialfSGIX;
  glFragmentMaterialfvSGIX: TglFragmentMaterialfvSGIX;
  glFragmentMaterialiSGIX: TglFragmentMaterialiSGIX;
  glFragmentMaterialivSGIX: TglFragmentMaterialivSGIX;
  glFrameTerminatorGREMEDY: TglFrameTerminatorGREMEDY;
  glFrameZoomSGIX: TglFrameZoomSGIX;
  glFramebufferDrawBufferEXT: TglFramebufferDrawBufferEXT;
  glFramebufferDrawBuffersEXT: TglFramebufferDrawBuffersEXT;
  glFramebufferFetchBarrierQCOM: TglFramebufferFetchBarrierQCOM;
  glFramebufferFoveationConfigQCOM: TglFramebufferFoveationConfigQCOM;
  glFramebufferFoveationParametersQCOM: TglFramebufferFoveationParametersQCOM;
  glFramebufferParameteri: TglFramebufferParameteri;
  glFramebufferPixelLocalStorageSizeEXT: TglFramebufferPixelLocalStorageSizeEXT;
  glFramebufferReadBufferEXT: TglFramebufferReadBufferEXT;
  glFramebufferRenderbuffer: TglFramebufferRenderbuffer;
  glFramebufferRenderbufferEXT: TglFramebufferRenderbufferEXT;
  glFramebufferRenderbufferOES: TglFramebufferRenderbufferOES;
  glFramebufferSampleLocationsfvARB: TglFramebufferSampleLocationsfvARB;
  glFramebufferSampleLocationsfvNV: TglFramebufferSampleLocationsfvNV;
  glFramebufferSamplePositionsfvAMD: TglFramebufferSamplePositionsfvAMD;
  glFramebufferTexture: TglFramebufferTexture;
  glFramebufferTexture1D: TglFramebufferTexture1D;
  glFramebufferTexture1DEXT: TglFramebufferTexture1DEXT;
  glFramebufferTexture2D: TglFramebufferTexture2D;
  glFramebufferTexture2DEXT: TglFramebufferTexture2DEXT;
  glFramebufferTexture2DDownsampleIMG: TglFramebufferTexture2DDownsampleIMG;
  glFramebufferTexture2DMultisampleEXT: TglFramebufferTexture2DMultisampleEXT;
  glFramebufferTexture2DMultisampleIMG: TglFramebufferTexture2DMultisampleIMG;
  glFramebufferTexture2DOES: TglFramebufferTexture2DOES;
  glFramebufferTexture3D: TglFramebufferTexture3D;
  glFramebufferTexture3DEXT: TglFramebufferTexture3DEXT;
  glFramebufferTexture3DOES: TglFramebufferTexture3DOES;
  glFramebufferTextureARB: TglFramebufferTextureARB;
  glFramebufferTextureEXT: TglFramebufferTextureEXT;
  glFramebufferTextureFaceARB: TglFramebufferTextureFaceARB;
  glFramebufferTextureFaceEXT: TglFramebufferTextureFaceEXT;
  glFramebufferTextureLayer: TglFramebufferTextureLayer;
  glFramebufferTextureLayerARB: TglFramebufferTextureLayerARB;
  glFramebufferTextureLayerEXT: TglFramebufferTextureLayerEXT;
  glFramebufferTextureLayerDownsampleIMG: TglFramebufferTextureLayerDownsampleIMG;
  glFramebufferTextureMultisampleMultiviewOVR: TglFramebufferTextureMultisampleMultiviewOVR;
  glFramebufferTextureMultiviewOVR: TglFramebufferTextureMultiviewOVR;
  glFramebufferTextureOES: TglFramebufferTextureOES;
  glFreeObjectBufferATI: TglFreeObjectBufferATI;
  glFrontFace: TglFrontFace;
  glFrustum: TglFrustum;
  glFrustumf: TglFrustumf;
  glFrustumfOES: TglFrustumfOES;
  glFrustumx: TglFrustumx;
  glFrustumxOES: TglFrustumxOES;
  glGenAsyncMarkersSGIX: TglGenAsyncMarkersSGIX;
  glGenBuffers: TglGenBuffers;
  glGenBuffersARB: TglGenBuffersARB;
  glGenFencesAPPLE: TglGenFencesAPPLE;
  glGenFencesNV: TglGenFencesNV;
  glGenFragmentShadersATI: TglGenFragmentShadersATI;
  glGenFramebuffers: TglGenFramebuffers;
  glGenFramebuffersEXT: TglGenFramebuffersEXT;
  glGenFramebuffersOES: TglGenFramebuffersOES;
  glGenLists: TglGenLists;
  glGenNamesAMD: TglGenNamesAMD;
  glGenOcclusionQueriesNV: TglGenOcclusionQueriesNV;
  glGenPathsNV: TglGenPathsNV;
  glGenPerfMonitorsAMD: TglGenPerfMonitorsAMD;
  glGenProgramPipelines: TglGenProgramPipelines;
  glGenProgramPipelinesEXT: TglGenProgramPipelinesEXT;
  glGenProgramsARB: TglGenProgramsARB;
  glGenProgramsNV: TglGenProgramsNV;
  glGenQueries: TglGenQueries;
  glGenQueriesARB: TglGenQueriesARB;
  glGenQueriesEXT: TglGenQueriesEXT;
  glGenRenderbuffers: TglGenRenderbuffers;
  glGenRenderbuffersEXT: TglGenRenderbuffersEXT;
  glGenRenderbuffersOES: TglGenRenderbuffersOES;
  glGenSamplers: TglGenSamplers;
  glGenSemaphoresEXT: TglGenSemaphoresEXT;
  glGenSymbolsEXT: TglGenSymbolsEXT;
  glGenTextures: TglGenTextures;
  glGenTexturesEXT: TglGenTexturesEXT;
  glGenTransformFeedbacks: TglGenTransformFeedbacks;
  glGenTransformFeedbacksNV: TglGenTransformFeedbacksNV;
  glGenVertexArrays: TglGenVertexArrays;
  glGenVertexArraysAPPLE: TglGenVertexArraysAPPLE;
  glGenVertexArraysOES: TglGenVertexArraysOES;
  glGenVertexShadersEXT: TglGenVertexShadersEXT;
  glGenerateMipmap: TglGenerateMipmap;
  glGenerateMipmapEXT: TglGenerateMipmapEXT;
  glGenerateMipmapOES: TglGenerateMipmapOES;
  glGenerateMultiTexMipmapEXT: TglGenerateMultiTexMipmapEXT;
  glGenerateTextureMipmap: TglGenerateTextureMipmap;
  glGenerateTextureMipmapEXT: TglGenerateTextureMipmapEXT;
  glGetActiveAtomicCounterBufferiv: TglGetActiveAtomicCounterBufferiv;
  glGetActiveAttrib: TglGetActiveAttrib;
  glGetActiveAttribARB: TglGetActiveAttribARB;
  glGetActiveSubroutineName: TglGetActiveSubroutineName;
  glGetActiveSubroutineUniformName: TglGetActiveSubroutineUniformName;
  glGetActiveSubroutineUniformiv: TglGetActiveSubroutineUniformiv;
  glGetActiveUniform: TglGetActiveUniform;
  glGetActiveUniformARB: TglGetActiveUniformARB;
  glGetActiveUniformBlockName: TglGetActiveUniformBlockName;
  glGetActiveUniformBlockiv: TglGetActiveUniformBlockiv;
  glGetActiveUniformName: TglGetActiveUniformName;
  glGetActiveUniformsiv: TglGetActiveUniformsiv;
  glGetActiveVaryingNV: TglGetActiveVaryingNV;
  glGetArrayObjectfvATI: TglGetArrayObjectfvATI;
  glGetArrayObjectivATI: TglGetArrayObjectivATI;
  glGetAttachedObjectsARB: TglGetAttachedObjectsARB;
  glGetAttachedShaders: TglGetAttachedShaders;
  glGetAttribLocation: TglGetAttribLocation;
  glGetAttribLocationARB: TglGetAttribLocationARB;
  glGetBooleanIndexedvEXT: TglGetBooleanIndexedvEXT;
  glGetBooleani_v: TglGetBooleani_v;
  glGetBooleanv: TglGetBooleanv;
  glGetBufferParameteri64v: TglGetBufferParameteri64v;
  glGetBufferParameteriv: TglGetBufferParameteriv;
  glGetBufferParameterivARB: TglGetBufferParameterivARB;
  glGetBufferParameterui64vNV: TglGetBufferParameterui64vNV;
  glGetBufferPointerv: TglGetBufferPointerv;
  glGetBufferPointervARB: TglGetBufferPointervARB;
  glGetBufferPointervOES: TglGetBufferPointervOES;
  glGetBufferSubData: TglGetBufferSubData;
  glGetBufferSubDataARB: TglGetBufferSubDataARB;
  glGetClipPlane: TglGetClipPlane;
  glGetClipPlanef: TglGetClipPlanef;
  glGetClipPlanefOES: TglGetClipPlanefOES;
  glGetClipPlanex: TglGetClipPlanex;
  glGetClipPlanexOES: TglGetClipPlanexOES;
  glGetColorTable: TglGetColorTable;
  glGetColorTableEXT: TglGetColorTableEXT;
  glGetColorTableParameterfv: TglGetColorTableParameterfv;
  glGetColorTableParameterfvEXT: TglGetColorTableParameterfvEXT;
  glGetColorTableParameterfvSGI: TglGetColorTableParameterfvSGI;
  glGetColorTableParameteriv: TglGetColorTableParameteriv;
  glGetColorTableParameterivEXT: TglGetColorTableParameterivEXT;
  glGetColorTableParameterivSGI: TglGetColorTableParameterivSGI;
  glGetColorTableSGI: TglGetColorTableSGI;
  glGetCombinerInputParameterfvNV: TglGetCombinerInputParameterfvNV;
  glGetCombinerInputParameterivNV: TglGetCombinerInputParameterivNV;
  glGetCombinerOutputParameterfvNV: TglGetCombinerOutputParameterfvNV;
  glGetCombinerOutputParameterivNV: TglGetCombinerOutputParameterivNV;
  glGetCombinerStageParameterfvNV: TglGetCombinerStageParameterfvNV;
  glGetCommandHeaderNV: TglGetCommandHeaderNV;
  glGetCompressedMultiTexImageEXT: TglGetCompressedMultiTexImageEXT;
  glGetCompressedTexImage: TglGetCompressedTexImage;
  glGetCompressedTexImageARB: TglGetCompressedTexImageARB;
  glGetCompressedTextureImage: TglGetCompressedTextureImage;
  glGetCompressedTextureImageEXT: TglGetCompressedTextureImageEXT;
  glGetCompressedTextureSubImage: TglGetCompressedTextureSubImage;
  glGetConvolutionFilter: TglGetConvolutionFilter;
  glGetConvolutionFilterEXT: TglGetConvolutionFilterEXT;
  glGetConvolutionParameterfv: TglGetConvolutionParameterfv;
  glGetConvolutionParameterfvEXT: TglGetConvolutionParameterfvEXT;
  glGetConvolutionParameteriv: TglGetConvolutionParameteriv;
  glGetConvolutionParameterivEXT: TglGetConvolutionParameterivEXT;
  glGetConvolutionParameterxvOES: TglGetConvolutionParameterxvOES;
  glGetCoverageModulationTableNV: TglGetCoverageModulationTableNV;
  glGetDebugMessageLog: TglGetDebugMessageLog;
  glGetDebugMessageLogAMD: TglGetDebugMessageLogAMD;
  glGetDebugMessageLogARB: TglGetDebugMessageLogARB;
  glGetDebugMessageLogKHR: TglGetDebugMessageLogKHR;
  glGetDetailTexFuncSGIS: TglGetDetailTexFuncSGIS;
  glGetDoubleIndexedvEXT: TglGetDoubleIndexedvEXT;
  glGetDoublei_v: TglGetDoublei_v;
  glGetDoublei_vEXT: TglGetDoublei_vEXT;
  glGetDoublev: TglGetDoublev;
  glGetDriverControlStringQCOM: TglGetDriverControlStringQCOM;
  glGetDriverControlsQCOM: TglGetDriverControlsQCOM;
  glGetError: TglGetError;
  glGetFenceivNV: TglGetFenceivNV;
  glGetFinalCombinerInputParameterfvNV: TglGetFinalCombinerInputParameterfvNV;
  glGetFinalCombinerInputParameterivNV: TglGetFinalCombinerInputParameterivNV;
  glGetFirstPerfQueryIdINTEL: TglGetFirstPerfQueryIdINTEL;
  glGetFixedv: TglGetFixedv;
  glGetFixedvOES: TglGetFixedvOES;
  glGetFloatIndexedvEXT: TglGetFloatIndexedvEXT;
  glGetFloati_v: TglGetFloati_v;
  glGetFloati_vEXT: TglGetFloati_vEXT;
  glGetFloati_vNV: TglGetFloati_vNV;
  glGetFloati_vOES: TglGetFloati_vOES;
  glGetFloatv: TglGetFloatv;
  glGetFogFuncSGIS: TglGetFogFuncSGIS;
  glGetFragDataIndex: TglGetFragDataIndex;
  glGetFragDataIndexEXT: TglGetFragDataIndexEXT;
  glGetFragDataLocation: TglGetFragDataLocation;
  glGetFragDataLocationEXT: TglGetFragDataLocationEXT;
  glGetFragmentLightfvSGIX: TglGetFragmentLightfvSGIX;
  glGetFragmentLightivSGIX: TglGetFragmentLightivSGIX;
  glGetFragmentMaterialfvSGIX: TglGetFragmentMaterialfvSGIX;
  glGetFragmentMaterialivSGIX: TglGetFragmentMaterialivSGIX;
  glGetFramebufferAttachmentParameteriv: TglGetFramebufferAttachmentParameteriv;
  glGetFramebufferAttachmentParameterivEXT: TglGetFramebufferAttachmentParameterivEXT;
  glGetFramebufferAttachmentParameterivOES: TglGetFramebufferAttachmentParameterivOES;
  glGetFramebufferParameterfvAMD: TglGetFramebufferParameterfvAMD;
  glGetFramebufferParameteriv: TglGetFramebufferParameteriv;
  glGetFramebufferParameterivEXT: TglGetFramebufferParameterivEXT;
  glGetFramebufferPixelLocalStorageSizeEXT: TglGetFramebufferPixelLocalStorageSizeEXT;
  glGetGraphicsResetStatus: TglGetGraphicsResetStatus;
  glGetGraphicsResetStatusARB: TglGetGraphicsResetStatusARB;
  glGetGraphicsResetStatusEXT: TglGetGraphicsResetStatusEXT;
  glGetGraphicsResetStatusKHR: TglGetGraphicsResetStatusKHR;
  glGetHandleARB: TglGetHandleARB;
  glGetHistogram: TglGetHistogram;
  glGetHistogramEXT: TglGetHistogramEXT;
  glGetHistogramParameterfv: TglGetHistogramParameterfv;
  glGetHistogramParameterfvEXT: TglGetHistogramParameterfvEXT;
  glGetHistogramParameteriv: TglGetHistogramParameteriv;
  glGetHistogramParameterivEXT: TglGetHistogramParameterivEXT;
  glGetHistogramParameterxvOES: TglGetHistogramParameterxvOES;
  glGetImageHandleARB: TglGetImageHandleARB;
  glGetImageHandleNV: TglGetImageHandleNV;
  glGetImageTransformParameterfvHP: TglGetImageTransformParameterfvHP;
  glGetImageTransformParameterivHP: TglGetImageTransformParameterivHP;
  glGetInfoLogARB: TglGetInfoLogARB;
  glGetInstrumentsSGIX: TglGetInstrumentsSGIX;
  glGetInteger64i_v: TglGetInteger64i_v;
  glGetInteger64v: TglGetInteger64v;
  glGetInteger64vAPPLE: TglGetInteger64vAPPLE;
  glGetIntegerIndexedvEXT: TglGetIntegerIndexedvEXT;
  glGetIntegeri_v: TglGetIntegeri_v;
  glGetIntegeri_vEXT: TglGetIntegeri_vEXT;
  glGetIntegerui64i_vNV: TglGetIntegerui64i_vNV;
  glGetIntegerui64vNV: TglGetIntegerui64vNV;
  glGetIntegerv: TglGetIntegerv;
  glGetInternalformatSampleivNV: TglGetInternalformatSampleivNV;
  glGetInternalformati64v: TglGetInternalformati64v;
  glGetInternalformativ: TglGetInternalformativ;
  glGetInvariantBooleanvEXT: TglGetInvariantBooleanvEXT;
  glGetInvariantFloatvEXT: TglGetInvariantFloatvEXT;
  glGetInvariantIntegervEXT: TglGetInvariantIntegervEXT;
  glGetLightfv: TglGetLightfv;
  glGetLightiv: TglGetLightiv;
  glGetLightxOES: TglGetLightxOES;
  glGetLightxv: TglGetLightxv;
  glGetLightxvOES: TglGetLightxvOES;
  glGetListParameterfvSGIX: TglGetListParameterfvSGIX;
  glGetListParameterivSGIX: TglGetListParameterivSGIX;
  glGetLocalConstantBooleanvEXT: TglGetLocalConstantBooleanvEXT;
  glGetLocalConstantFloatvEXT: TglGetLocalConstantFloatvEXT;
  glGetLocalConstantIntegervEXT: TglGetLocalConstantIntegervEXT;
  glGetMapAttribParameterfvNV: TglGetMapAttribParameterfvNV;
  glGetMapAttribParameterivNV: TglGetMapAttribParameterivNV;
  glGetMapControlPointsNV: TglGetMapControlPointsNV;
  glGetMapParameterfvNV: TglGetMapParameterfvNV;
  glGetMapParameterivNV: TglGetMapParameterivNV;
  glGetMapdv: TglGetMapdv;
  glGetMapfv: TglGetMapfv;
  glGetMapiv: TglGetMapiv;
  glGetMapxvOES: TglGetMapxvOES;
  glGetMaterialfv: TglGetMaterialfv;
  glGetMaterialiv: TglGetMaterialiv;
  glGetMaterialxOES: TglGetMaterialxOES;
  glGetMaterialxv: TglGetMaterialxv;
  glGetMaterialxvOES: TglGetMaterialxvOES;
  glGetMemoryObjectParameterivEXT: TglGetMemoryObjectParameterivEXT;
  glGetMinmax: TglGetMinmax;
  glGetMinmaxEXT: TglGetMinmaxEXT;
  glGetMinmaxParameterfv: TglGetMinmaxParameterfv;
  glGetMinmaxParameterfvEXT: TglGetMinmaxParameterfvEXT;
  glGetMinmaxParameteriv: TglGetMinmaxParameteriv;
  glGetMinmaxParameterivEXT: TglGetMinmaxParameterivEXT;
  glGetMultiTexEnvfvEXT: TglGetMultiTexEnvfvEXT;
  glGetMultiTexEnvivEXT: TglGetMultiTexEnvivEXT;
  glGetMultiTexGendvEXT: TglGetMultiTexGendvEXT;
  glGetMultiTexGenfvEXT: TglGetMultiTexGenfvEXT;
  glGetMultiTexGenivEXT: TglGetMultiTexGenivEXT;
  glGetMultiTexImageEXT: TglGetMultiTexImageEXT;
  glGetMultiTexLevelParameterfvEXT: TglGetMultiTexLevelParameterfvEXT;
  glGetMultiTexLevelParameterivEXT: TglGetMultiTexLevelParameterivEXT;
  glGetMultiTexParameterIivEXT: TglGetMultiTexParameterIivEXT;
  glGetMultiTexParameterIuivEXT: TglGetMultiTexParameterIuivEXT;
  glGetMultiTexParameterfvEXT: TglGetMultiTexParameterfvEXT;
  glGetMultiTexParameterivEXT: TglGetMultiTexParameterivEXT;
  glGetMultisamplefv: TglGetMultisamplefv;
  glGetMultisamplefvNV: TglGetMultisamplefvNV;
  glGetNamedBufferParameteri64v: TglGetNamedBufferParameteri64v;
  glGetNamedBufferParameteriv: TglGetNamedBufferParameteriv;
  glGetNamedBufferParameterivEXT: TglGetNamedBufferParameterivEXT;
  glGetNamedBufferParameterui64vNV: TglGetNamedBufferParameterui64vNV;
  glGetNamedBufferPointerv: TglGetNamedBufferPointerv;
  glGetNamedBufferPointervEXT: TglGetNamedBufferPointervEXT;
  glGetNamedBufferSubData: TglGetNamedBufferSubData;
  glGetNamedBufferSubDataEXT: TglGetNamedBufferSubDataEXT;
  glGetNamedFramebufferParameterfvAMD: TglGetNamedFramebufferParameterfvAMD;
  glGetNamedFramebufferAttachmentParameteriv: TglGetNamedFramebufferAttachmentParameteriv;
  glGetNamedFramebufferAttachmentParameterivEXT: TglGetNamedFramebufferAttachmentParameterivEXT;
  glGetNamedFramebufferParameteriv: TglGetNamedFramebufferParameteriv;
  glGetNamedFramebufferParameterivEXT: TglGetNamedFramebufferParameterivEXT;
  glGetNamedProgramLocalParameterIivEXT: TglGetNamedProgramLocalParameterIivEXT;
  glGetNamedProgramLocalParameterIuivEXT: TglGetNamedProgramLocalParameterIuivEXT;
  glGetNamedProgramLocalParameterdvEXT: TglGetNamedProgramLocalParameterdvEXT;
  glGetNamedProgramLocalParameterfvEXT: TglGetNamedProgramLocalParameterfvEXT;
  glGetNamedProgramStringEXT: TglGetNamedProgramStringEXT;
  glGetNamedProgramivEXT: TglGetNamedProgramivEXT;
  glGetNamedRenderbufferParameteriv: TglGetNamedRenderbufferParameteriv;
  glGetNamedRenderbufferParameterivEXT: TglGetNamedRenderbufferParameterivEXT;
  glGetNamedStringARB: TglGetNamedStringARB;
  glGetNamedStringivARB: TglGetNamedStringivARB;
  glGetNextPerfQueryIdINTEL: TglGetNextPerfQueryIdINTEL;
  glGetObjectBufferfvATI: TglGetObjectBufferfvATI;
  glGetObjectBufferivATI: TglGetObjectBufferivATI;
  glGetObjectLabel: TglGetObjectLabel;
  glGetObjectLabelEXT: TglGetObjectLabelEXT;
  glGetObjectLabelKHR: TglGetObjectLabelKHR;
  glGetObjectParameterfvARB: TglGetObjectParameterfvARB;
  glGetObjectParameterivAPPLE: TglGetObjectParameterivAPPLE;
  glGetObjectParameterivARB: TglGetObjectParameterivARB;
  glGetObjectPtrLabel: TglGetObjectPtrLabel;
  glGetObjectPtrLabelKHR: TglGetObjectPtrLabelKHR;
  glGetOcclusionQueryivNV: TglGetOcclusionQueryivNV;
  glGetOcclusionQueryuivNV: TglGetOcclusionQueryuivNV;
  glGetPathColorGenfvNV: TglGetPathColorGenfvNV;
  glGetPathColorGenivNV: TglGetPathColorGenivNV;
  glGetPathCommandsNV: TglGetPathCommandsNV;
  glGetPathCoordsNV: TglGetPathCoordsNV;
  glGetPathDashArrayNV: TglGetPathDashArrayNV;
  glGetPathLengthNV: TglGetPathLengthNV;
  glGetPathMetricRangeNV: TglGetPathMetricRangeNV;
  glGetPathMetricsNV: TglGetPathMetricsNV;
  glGetPathParameterfvNV: TglGetPathParameterfvNV;
  glGetPathParameterivNV: TglGetPathParameterivNV;
  glGetPathSpacingNV: TglGetPathSpacingNV;
  glGetPathTexGenfvNV: TglGetPathTexGenfvNV;
  glGetPathTexGenivNV: TglGetPathTexGenivNV;
  glGetPerfCounterInfoINTEL: TglGetPerfCounterInfoINTEL;
  glGetPerfMonitorCounterDataAMD: TglGetPerfMonitorCounterDataAMD;
  glGetPerfMonitorCounterInfoAMD: TglGetPerfMonitorCounterInfoAMD;
  glGetPerfMonitorCounterStringAMD: TglGetPerfMonitorCounterStringAMD;
  glGetPerfMonitorCountersAMD: TglGetPerfMonitorCountersAMD;
  glGetPerfMonitorGroupStringAMD: TglGetPerfMonitorGroupStringAMD;
  glGetPerfMonitorGroupsAMD: TglGetPerfMonitorGroupsAMD;
  glGetPerfQueryDataINTEL: TglGetPerfQueryDataINTEL;
  glGetPerfQueryIdByNameINTEL: TglGetPerfQueryIdByNameINTEL;
  glGetPerfQueryInfoINTEL: TglGetPerfQueryInfoINTEL;
  glGetPixelMapfv: TglGetPixelMapfv;
  glGetPixelMapuiv: TglGetPixelMapuiv;
  glGetPixelMapusv: TglGetPixelMapusv;
  glGetPixelMapxv: TglGetPixelMapxv;
  glGetPixelTexGenParameterfvSGIS: TglGetPixelTexGenParameterfvSGIS;
  glGetPixelTexGenParameterivSGIS: TglGetPixelTexGenParameterivSGIS;
  glGetPixelTransformParameterfvEXT: TglGetPixelTransformParameterfvEXT;
  glGetPixelTransformParameterivEXT: TglGetPixelTransformParameterivEXT;
  glGetPointerIndexedvEXT: TglGetPointerIndexedvEXT;
  glGetPointeri_vEXT: TglGetPointeri_vEXT;
  glGetPointerv: TglGetPointerv;
  glGetPointervEXT: TglGetPointervEXT;
  glGetPointervKHR: TglGetPointervKHR;
  glGetPolygonStipple: TglGetPolygonStipple;
  glGetProgramBinary: TglGetProgramBinary;
  glGetProgramBinaryOES: TglGetProgramBinaryOES;
  glGetProgramEnvParameterIivNV: TglGetProgramEnvParameterIivNV;
  glGetProgramEnvParameterIuivNV: TglGetProgramEnvParameterIuivNV;
  glGetProgramEnvParameterdvARB: TglGetProgramEnvParameterdvARB;
  glGetProgramEnvParameterfvARB: TglGetProgramEnvParameterfvARB;
  glGetProgramInfoLog: TglGetProgramInfoLog;
  glGetProgramInterfaceiv: TglGetProgramInterfaceiv;
  glGetProgramLocalParameterIivNV: TglGetProgramLocalParameterIivNV;
  glGetProgramLocalParameterIuivNV: TglGetProgramLocalParameterIuivNV;
  glGetProgramLocalParameterdvARB: TglGetProgramLocalParameterdvARB;
  glGetProgramLocalParameterfvARB: TglGetProgramLocalParameterfvARB;
  glGetProgramNamedParameterdvNV: TglGetProgramNamedParameterdvNV;
  glGetProgramNamedParameterfvNV: TglGetProgramNamedParameterfvNV;
  glGetProgramParameterdvNV: TglGetProgramParameterdvNV;
  glGetProgramParameterfvNV: TglGetProgramParameterfvNV;
  glGetProgramPipelineInfoLog: TglGetProgramPipelineInfoLog;
  glGetProgramPipelineInfoLogEXT: TglGetProgramPipelineInfoLogEXT;
  glGetProgramPipelineiv: TglGetProgramPipelineiv;
  glGetProgramPipelineivEXT: TglGetProgramPipelineivEXT;
  glGetProgramResourceIndex: TglGetProgramResourceIndex;
  glGetProgramResourceLocation: TglGetProgramResourceLocation;
  glGetProgramResourceLocationIndex: TglGetProgramResourceLocationIndex;
  glGetProgramResourceLocationIndexEXT: TglGetProgramResourceLocationIndexEXT;
  glGetProgramResourceName: TglGetProgramResourceName;
  glGetProgramResourcefvNV: TglGetProgramResourcefvNV;
  glGetProgramResourceiv: TglGetProgramResourceiv;
  glGetProgramStageiv: TglGetProgramStageiv;
  glGetProgramStringARB: TglGetProgramStringARB;
  glGetProgramStringNV: TglGetProgramStringNV;
  glGetProgramSubroutineParameteruivNV: TglGetProgramSubroutineParameteruivNV;
  glGetProgramiv: TglGetProgramiv;
  glGetProgramivARB: TglGetProgramivARB;
  glGetProgramivNV: TglGetProgramivNV;
  glGetQueryBufferObjecti64v: TglGetQueryBufferObjecti64v;
  glGetQueryBufferObjectiv: TglGetQueryBufferObjectiv;
  glGetQueryBufferObjectui64v: TglGetQueryBufferObjectui64v;
  glGetQueryBufferObjectuiv: TglGetQueryBufferObjectuiv;
  glGetQueryIndexediv: TglGetQueryIndexediv;
  glGetQueryObjecti64v: TglGetQueryObjecti64v;
  glGetQueryObjecti64vEXT: TglGetQueryObjecti64vEXT;
  glGetQueryObjectiv: TglGetQueryObjectiv;
  glGetQueryObjectivARB: TglGetQueryObjectivARB;
  glGetQueryObjectivEXT: TglGetQueryObjectivEXT;
  glGetQueryObjectui64v: TglGetQueryObjectui64v;
  glGetQueryObjectui64vEXT: TglGetQueryObjectui64vEXT;
  glGetQueryObjectuiv: TglGetQueryObjectuiv;
  glGetQueryObjectuivARB: TglGetQueryObjectuivARB;
  glGetQueryObjectuivEXT: TglGetQueryObjectuivEXT;
  glGetQueryiv: TglGetQueryiv;
  glGetQueryivARB: TglGetQueryivARB;
  glGetQueryivEXT: TglGetQueryivEXT;
  glGetRenderbufferParameteriv: TglGetRenderbufferParameteriv;
  glGetRenderbufferParameterivEXT: TglGetRenderbufferParameterivEXT;
  glGetRenderbufferParameterivOES: TglGetRenderbufferParameterivOES;
  glGetSamplerParameterIiv: TglGetSamplerParameterIiv;
  glGetSamplerParameterIivEXT: TglGetSamplerParameterIivEXT;
  glGetSamplerParameterIivOES: TglGetSamplerParameterIivOES;
  glGetSamplerParameterIuiv: TglGetSamplerParameterIuiv;
  glGetSamplerParameterIuivEXT: TglGetSamplerParameterIuivEXT;
  glGetSamplerParameterIuivOES: TglGetSamplerParameterIuivOES;
  glGetSamplerParameterfv: TglGetSamplerParameterfv;
  glGetSamplerParameteriv: TglGetSamplerParameteriv;
  glGetSemaphoreParameterui64vEXT: TglGetSemaphoreParameterui64vEXT;
  glGetSeparableFilter: TglGetSeparableFilter;
  glGetSeparableFilterEXT: TglGetSeparableFilterEXT;
  glGetShaderInfoLog: TglGetShaderInfoLog;
  glGetShaderPrecisionFormat: TglGetShaderPrecisionFormat;
  glGetShaderSource: TglGetShaderSource;
  glGetShaderSourceARB: TglGetShaderSourceARB;
  glGetShaderiv: TglGetShaderiv;
  glGetSharpenTexFuncSGIS: TglGetSharpenTexFuncSGIS;
  glGetStageIndexNV: TglGetStageIndexNV;
  glGetString: TglGetString;
  glGetStringi: TglGetStringi;
  glGetSubroutineIndex: TglGetSubroutineIndex;
  glGetSubroutineUniformLocation: TglGetSubroutineUniformLocation;
  glGetSynciv: TglGetSynciv;
  glGetSyncivAPPLE: TglGetSyncivAPPLE;
  glGetTexBumpParameterfvATI: TglGetTexBumpParameterfvATI;
  glGetTexBumpParameterivATI: TglGetTexBumpParameterivATI;
  glGetTexEnvfv: TglGetTexEnvfv;
  glGetTexEnviv: TglGetTexEnviv;
  glGetTexEnvxv: TglGetTexEnvxv;
  glGetTexEnvxvOES: TglGetTexEnvxvOES;
  glGetTexFilterFuncSGIS: TglGetTexFilterFuncSGIS;
  glGetTexGendv: TglGetTexGendv;
  glGetTexGenfv: TglGetTexGenfv;
  glGetTexGenfvOES: TglGetTexGenfvOES;
  glGetTexGeniv: TglGetTexGeniv;
  glGetTexGenivOES: TglGetTexGenivOES;
  glGetTexGenxvOES: TglGetTexGenxvOES;
  glGetTexImage: TglGetTexImage;
  glGetTexLevelParameterfv: TglGetTexLevelParameterfv;
  glGetTexLevelParameteriv: TglGetTexLevelParameteriv;
  glGetTexLevelParameterxvOES: TglGetTexLevelParameterxvOES;
  glGetTexParameterIiv: TglGetTexParameterIiv;
  glGetTexParameterIivEXT: TglGetTexParameterIivEXT;
  glGetTexParameterIivOES: TglGetTexParameterIivOES;
  glGetTexParameterIuiv: TglGetTexParameterIuiv;
  glGetTexParameterIuivEXT: TglGetTexParameterIuivEXT;
  glGetTexParameterIuivOES: TglGetTexParameterIuivOES;
  glGetTexParameterPointervAPPLE: TglGetTexParameterPointervAPPLE;
  glGetTexParameterfv: TglGetTexParameterfv;
  glGetTexParameteriv: TglGetTexParameteriv;
  glGetTexParameterxv: TglGetTexParameterxv;
  glGetTexParameterxvOES: TglGetTexParameterxvOES;
  glGetTextureHandleARB: TglGetTextureHandleARB;
  glGetTextureHandleIMG: TglGetTextureHandleIMG;
  glGetTextureHandleNV: TglGetTextureHandleNV;
  glGetTextureImage: TglGetTextureImage;
  glGetTextureImageEXT: TglGetTextureImageEXT;
  glGetTextureLevelParameterfv: TglGetTextureLevelParameterfv;
  glGetTextureLevelParameterfvEXT: TglGetTextureLevelParameterfvEXT;
  glGetTextureLevelParameteriv: TglGetTextureLevelParameteriv;
  glGetTextureLevelParameterivEXT: TglGetTextureLevelParameterivEXT;
  glGetTextureParameterIiv: TglGetTextureParameterIiv;
  glGetTextureParameterIivEXT: TglGetTextureParameterIivEXT;
  glGetTextureParameterIuiv: TglGetTextureParameterIuiv;
  glGetTextureParameterIuivEXT: TglGetTextureParameterIuivEXT;
  glGetTextureParameterfv: TglGetTextureParameterfv;
  glGetTextureParameterfvEXT: TglGetTextureParameterfvEXT;
  glGetTextureParameteriv: TglGetTextureParameteriv;
  glGetTextureParameterivEXT: TglGetTextureParameterivEXT;
  glGetTextureSamplerHandleARB: TglGetTextureSamplerHandleARB;
  glGetTextureSamplerHandleIMG: TglGetTextureSamplerHandleIMG;
  glGetTextureSamplerHandleNV: TglGetTextureSamplerHandleNV;
  glGetTextureSubImage: TglGetTextureSubImage;
  glGetTrackMatrixivNV: TglGetTrackMatrixivNV;
  glGetTransformFeedbackVarying: TglGetTransformFeedbackVarying;
  glGetTransformFeedbackVaryingEXT: TglGetTransformFeedbackVaryingEXT;
  glGetTransformFeedbackVaryingNV: TglGetTransformFeedbackVaryingNV;
  glGetTransformFeedbacki64_v: TglGetTransformFeedbacki64_v;
  glGetTransformFeedbacki_v: TglGetTransformFeedbacki_v;
  glGetTransformFeedbackiv: TglGetTransformFeedbackiv;
  glGetTranslatedShaderSourceANGLE: TglGetTranslatedShaderSourceANGLE;
  glGetUniformBlockIndex: TglGetUniformBlockIndex;
  glGetUniformBufferSizeEXT: TglGetUniformBufferSizeEXT;
  glGetUniformIndices: TglGetUniformIndices;
  glGetUniformLocation: TglGetUniformLocation;
  glGetUniformLocationARB: TglGetUniformLocationARB;
  glGetUniformOffsetEXT: TglGetUniformOffsetEXT;
  glGetUniformSubroutineuiv: TglGetUniformSubroutineuiv;
  glGetUniformdv: TglGetUniformdv;
  glGetUniformfv: TglGetUniformfv;
  glGetUniformfvARB: TglGetUniformfvARB;
  glGetUniformi64vARB: TglGetUniformi64vARB;
  glGetUniformi64vNV: TglGetUniformi64vNV;
  glGetUniformiv: TglGetUniformiv;
  glGetUniformivARB: TglGetUniformivARB;
  glGetUniformui64vARB: TglGetUniformui64vARB;
  glGetUniformui64vNV: TglGetUniformui64vNV;
  glGetUniformuiv: TglGetUniformuiv;
  glGetUniformuivEXT: TglGetUniformuivEXT;
  glGetUnsignedBytevEXT: TglGetUnsignedBytevEXT;
  glGetUnsignedBytei_vEXT: TglGetUnsignedBytei_vEXT;
  glGetVariantArrayObjectfvATI: TglGetVariantArrayObjectfvATI;
  glGetVariantArrayObjectivATI: TglGetVariantArrayObjectivATI;
  glGetVariantBooleanvEXT: TglGetVariantBooleanvEXT;
  glGetVariantFloatvEXT: TglGetVariantFloatvEXT;
  glGetVariantIntegervEXT: TglGetVariantIntegervEXT;
  glGetVariantPointervEXT: TglGetVariantPointervEXT;
  glGetVaryingLocationNV: TglGetVaryingLocationNV;
  glGetVertexArrayIndexed64iv: TglGetVertexArrayIndexed64iv;
  glGetVertexArrayIndexediv: TglGetVertexArrayIndexediv;
  glGetVertexArrayIntegeri_vEXT: TglGetVertexArrayIntegeri_vEXT;
  glGetVertexArrayIntegervEXT: TglGetVertexArrayIntegervEXT;
  glGetVertexArrayPointeri_vEXT: TglGetVertexArrayPointeri_vEXT;
  glGetVertexArrayPointervEXT: TglGetVertexArrayPointervEXT;
  glGetVertexArrayiv: TglGetVertexArrayiv;
  glGetVertexAttribArrayObjectfvATI: TglGetVertexAttribArrayObjectfvATI;
  glGetVertexAttribArrayObjectivATI: TglGetVertexAttribArrayObjectivATI;
  glGetVertexAttribIiv: TglGetVertexAttribIiv;
  glGetVertexAttribIivEXT: TglGetVertexAttribIivEXT;
  glGetVertexAttribIuiv: TglGetVertexAttribIuiv;
  glGetVertexAttribIuivEXT: TglGetVertexAttribIuivEXT;
  glGetVertexAttribLdv: TglGetVertexAttribLdv;
  glGetVertexAttribLdvEXT: TglGetVertexAttribLdvEXT;
  glGetVertexAttribLi64vNV: TglGetVertexAttribLi64vNV;
  glGetVertexAttribLui64vARB: TglGetVertexAttribLui64vARB;
  glGetVertexAttribLui64vNV: TglGetVertexAttribLui64vNV;
  glGetVertexAttribPointerv: TglGetVertexAttribPointerv;
  glGetVertexAttribPointervARB: TglGetVertexAttribPointervARB;
  glGetVertexAttribPointervNV: TglGetVertexAttribPointervNV;
  glGetVertexAttribdv: TglGetVertexAttribdv;
  glGetVertexAttribdvARB: TglGetVertexAttribdvARB;
  glGetVertexAttribdvNV: TglGetVertexAttribdvNV;
  glGetVertexAttribfv: TglGetVertexAttribfv;
  glGetVertexAttribfvARB: TglGetVertexAttribfvARB;
  glGetVertexAttribfvNV: TglGetVertexAttribfvNV;
  glGetVertexAttribiv: TglGetVertexAttribiv;
  glGetVertexAttribivARB: TglGetVertexAttribivARB;
  glGetVertexAttribivNV: TglGetVertexAttribivNV;
  glGetVideoCaptureStreamdvNV: TglGetVideoCaptureStreamdvNV;
  glGetVideoCaptureStreamfvNV: TglGetVideoCaptureStreamfvNV;
  glGetVideoCaptureStreamivNV: TglGetVideoCaptureStreamivNV;
  glGetVideoCaptureivNV: TglGetVideoCaptureivNV;
  glGetVideoi64vNV: TglGetVideoi64vNV;
  glGetVideoivNV: TglGetVideoivNV;
  glGetVideoui64vNV: TglGetVideoui64vNV;
  glGetVideouivNV: TglGetVideouivNV;
  glGetnColorTable: TglGetnColorTable;
  glGetnColorTableARB: TglGetnColorTableARB;
  glGetnCompressedTexImage: TglGetnCompressedTexImage;
  glGetnCompressedTexImageARB: TglGetnCompressedTexImageARB;
  glGetnConvolutionFilter: TglGetnConvolutionFilter;
  glGetnConvolutionFilterARB: TglGetnConvolutionFilterARB;
  glGetnHistogram: TglGetnHistogram;
  glGetnHistogramARB: TglGetnHistogramARB;
  glGetnMapdv: TglGetnMapdv;
  glGetnMapdvARB: TglGetnMapdvARB;
  glGetnMapfv: TglGetnMapfv;
  glGetnMapfvARB: TglGetnMapfvARB;
  glGetnMapiv: TglGetnMapiv;
  glGetnMapivARB: TglGetnMapivARB;
  glGetnMinmax: TglGetnMinmax;
  glGetnMinmaxARB: TglGetnMinmaxARB;
  glGetnPixelMapfv: TglGetnPixelMapfv;
  glGetnPixelMapfvARB: TglGetnPixelMapfvARB;
  glGetnPixelMapuiv: TglGetnPixelMapuiv;
  glGetnPixelMapuivARB: TglGetnPixelMapuivARB;
  glGetnPixelMapusv: TglGetnPixelMapusv;
  glGetnPixelMapusvARB: TglGetnPixelMapusvARB;
  glGetnPolygonStipple: TglGetnPolygonStipple;
  glGetnPolygonStippleARB: TglGetnPolygonStippleARB;
  glGetnSeparableFilter: TglGetnSeparableFilter;
  glGetnSeparableFilterARB: TglGetnSeparableFilterARB;
  glGetnTexImage: TglGetnTexImage;
  glGetnTexImageARB: TglGetnTexImageARB;
  glGetnUniformdv: TglGetnUniformdv;
  glGetnUniformdvARB: TglGetnUniformdvARB;
  glGetnUniformfv: TglGetnUniformfv;
  glGetnUniformfvARB: TglGetnUniformfvARB;
  glGetnUniformfvEXT: TglGetnUniformfvEXT;
  glGetnUniformfvKHR: TglGetnUniformfvKHR;
  glGetnUniformi64vARB: TglGetnUniformi64vARB;
  glGetnUniformiv: TglGetnUniformiv;
  glGetnUniformivARB: TglGetnUniformivARB;
  glGetnUniformivEXT: TglGetnUniformivEXT;
  glGetnUniformivKHR: TglGetnUniformivKHR;
  glGetnUniformui64vARB: TglGetnUniformui64vARB;
  glGetnUniformuiv: TglGetnUniformuiv;
  glGetnUniformuivARB: TglGetnUniformuivARB;
  glGetnUniformuivKHR: TglGetnUniformuivKHR;
  glGlobalAlphaFactorbSUN: TglGlobalAlphaFactorbSUN;
  glGlobalAlphaFactordSUN: TglGlobalAlphaFactordSUN;
  glGlobalAlphaFactorfSUN: TglGlobalAlphaFactorfSUN;
  glGlobalAlphaFactoriSUN: TglGlobalAlphaFactoriSUN;
  glGlobalAlphaFactorsSUN: TglGlobalAlphaFactorsSUN;
  glGlobalAlphaFactorubSUN: TglGlobalAlphaFactorubSUN;
  glGlobalAlphaFactoruiSUN: TglGlobalAlphaFactoruiSUN;
  glGlobalAlphaFactorusSUN: TglGlobalAlphaFactorusSUN;
  glHint: TglHint;
  glHintPGI: TglHintPGI;
  glHistogram: TglHistogram;
  glHistogramEXT: TglHistogramEXT;
  glIglooInterfaceSGIX: TglIglooInterfaceSGIX;
  glImageTransformParameterfHP: TglImageTransformParameterfHP;
  glImageTransformParameterfvHP: TglImageTransformParameterfvHP;
  glImageTransformParameteriHP: TglImageTransformParameteriHP;
  glImageTransformParameterivHP: TglImageTransformParameterivHP;
  glImportMemoryFdEXT: TglImportMemoryFdEXT;
  glImportMemoryWin32HandleEXT: TglImportMemoryWin32HandleEXT;
  glImportMemoryWin32NameEXT: TglImportMemoryWin32NameEXT;
  glImportSemaphoreFdEXT: TglImportSemaphoreFdEXT;
  glImportSemaphoreWin32HandleEXT: TglImportSemaphoreWin32HandleEXT;
  glImportSemaphoreWin32NameEXT: TglImportSemaphoreWin32NameEXT;
  glImportSyncEXT: TglImportSyncEXT;
  glIndexFormatNV: TglIndexFormatNV;
  glIndexFuncEXT: TglIndexFuncEXT;
  glIndexMask: TglIndexMask;
  glIndexMaterialEXT: TglIndexMaterialEXT;
  glIndexPointer: TglIndexPointer;
  glIndexPointerEXT: TglIndexPointerEXT;
  glIndexPointerListIBM: TglIndexPointerListIBM;
  glIndexd: TglIndexd;
  glIndexdv: TglIndexdv;
  glIndexf: TglIndexf;
  glIndexfv: TglIndexfv;
  glIndexi: TglIndexi;
  glIndexiv: TglIndexiv;
  glIndexs: TglIndexs;
  glIndexsv: TglIndexsv;
  glIndexub: TglIndexub;
  glIndexubv: TglIndexubv;
  glIndexxOES: TglIndexxOES;
  glIndexxvOES: TglIndexxvOES;
  glInitNames: TglInitNames;
  glInsertComponentEXT: TglInsertComponentEXT;
  glInsertEventMarkerEXT: TglInsertEventMarkerEXT;
  glInstrumentsBufferSGIX: TglInstrumentsBufferSGIX;
  glInterleavedArrays: TglInterleavedArrays;
  glInterpolatePathsNV: TglInterpolatePathsNV;
  glInvalidateBufferData: TglInvalidateBufferData;
  glInvalidateBufferSubData: TglInvalidateBufferSubData;
  glInvalidateFramebuffer: TglInvalidateFramebuffer;
  glInvalidateNamedFramebufferData: TglInvalidateNamedFramebufferData;
  glInvalidateNamedFramebufferSubData: TglInvalidateNamedFramebufferSubData;
  glInvalidateSubFramebuffer: TglInvalidateSubFramebuffer;
  glInvalidateTexImage: TglInvalidateTexImage;
  glInvalidateTexSubImage: TglInvalidateTexSubImage;
  glIsAsyncMarkerSGIX: TglIsAsyncMarkerSGIX;
  glIsBuffer: TglIsBuffer;
  glIsBufferARB: TglIsBufferARB;
  glIsBufferResidentNV: TglIsBufferResidentNV;
  glIsCommandListNV: TglIsCommandListNV;
  glIsEnabled: TglIsEnabled;
  glIsEnabledIndexedEXT: TglIsEnabledIndexedEXT;
  glIsEnabledi: TglIsEnabledi;
  glIsEnablediEXT: TglIsEnablediEXT;
  glIsEnablediNV: TglIsEnablediNV;
  glIsEnablediOES: TglIsEnablediOES;
  glIsFenceAPPLE: TglIsFenceAPPLE;
  glIsFenceNV: TglIsFenceNV;
  glIsFramebuffer: TglIsFramebuffer;
  glIsFramebufferEXT: TglIsFramebufferEXT;
  glIsFramebufferOES: TglIsFramebufferOES;
  glIsImageHandleResidentARB: TglIsImageHandleResidentARB;
  glIsImageHandleResidentNV: TglIsImageHandleResidentNV;
  glIsList: TglIsList;
  glIsMemoryObjectEXT: TglIsMemoryObjectEXT;
  glIsNameAMD: TglIsNameAMD;
  glIsNamedBufferResidentNV: TglIsNamedBufferResidentNV;
  glIsNamedStringARB: TglIsNamedStringARB;
  glIsObjectBufferATI: TglIsObjectBufferATI;
  glIsOcclusionQueryNV: TglIsOcclusionQueryNV;
  glIsPathNV: TglIsPathNV;
  glIsPointInFillPathNV: TglIsPointInFillPathNV;
  glIsPointInStrokePathNV: TglIsPointInStrokePathNV;
  glIsProgram: TglIsProgram;
  glIsProgramARB: TglIsProgramARB;
  glIsProgramNV: TglIsProgramNV;
  glIsProgramPipeline: TglIsProgramPipeline;
  glIsProgramPipelineEXT: TglIsProgramPipelineEXT;
  glIsQuery: TglIsQuery;
  glIsQueryARB: TglIsQueryARB;
  glIsQueryEXT: TglIsQueryEXT;
  glIsRenderbuffer: TglIsRenderbuffer;
  glIsRenderbufferEXT: TglIsRenderbufferEXT;
  glIsRenderbufferOES: TglIsRenderbufferOES;
  glIsSemaphoreEXT: TglIsSemaphoreEXT;
  glIsSampler: TglIsSampler;
  glIsShader: TglIsShader;
  glIsStateNV: TglIsStateNV;
  glIsSync: TglIsSync;
  glIsSyncAPPLE: TglIsSyncAPPLE;
  glIsTexture: TglIsTexture;
  glIsTextureEXT: TglIsTextureEXT;
  glIsTextureHandleResidentARB: TglIsTextureHandleResidentARB;
  glIsTextureHandleResidentNV: TglIsTextureHandleResidentNV;
  glIsTransformFeedback: TglIsTransformFeedback;
  glIsTransformFeedbackNV: TglIsTransformFeedbackNV;
  glIsVariantEnabledEXT: TglIsVariantEnabledEXT;
  glIsVertexArray: TglIsVertexArray;
  glIsVertexArrayAPPLE: TglIsVertexArrayAPPLE;
  glIsVertexArrayOES: TglIsVertexArrayOES;
  glIsVertexAttribEnabledAPPLE: TglIsVertexAttribEnabledAPPLE;
  glLGPUCopyImageSubDataNVX: TglLGPUCopyImageSubDataNVX;
  glLGPUInterlockNVX: TglLGPUInterlockNVX;
  glLGPUNamedBufferSubDataNVX: TglLGPUNamedBufferSubDataNVX;
  glLabelObjectEXT: TglLabelObjectEXT;
  glLightEnviSGIX: TglLightEnviSGIX;
  glLightModelf: TglLightModelf;
  glLightModelfv: TglLightModelfv;
  glLightModeli: TglLightModeli;
  glLightModeliv: TglLightModeliv;
  glLightModelx: TglLightModelx;
  glLightModelxOES: TglLightModelxOES;
  glLightModelxv: TglLightModelxv;
  glLightModelxvOES: TglLightModelxvOES;
  glLightf: TglLightf;
  glLightfv: TglLightfv;
  glLighti: TglLighti;
  glLightiv: TglLightiv;
  glLightx: TglLightx;
  glLightxOES: TglLightxOES;
  glLightxv: TglLightxv;
  glLightxvOES: TglLightxvOES;
  glLineStipple: TglLineStipple;
  glLineWidth: TglLineWidth;
  glLineWidthx: TglLineWidthx;
  glLineWidthxOES: TglLineWidthxOES;
  glLinkProgram: TglLinkProgram;
  glLinkProgramARB: TglLinkProgramARB;
  glListBase: TglListBase;
  glListDrawCommandsStatesClientNV: TglListDrawCommandsStatesClientNV;
  glListParameterfSGIX: TglListParameterfSGIX;
  glListParameterfvSGIX: TglListParameterfvSGIX;
  glListParameteriSGIX: TglListParameteriSGIX;
  glListParameterivSGIX: TglListParameterivSGIX;
  glLoadIdentity: TglLoadIdentity;
  glLoadIdentityDeformationMapSGIX: TglLoadIdentityDeformationMapSGIX;
  glLoadMatrixd: TglLoadMatrixd;
  glLoadMatrixf: TglLoadMatrixf;
  glLoadMatrixx: TglLoadMatrixx;
  glLoadMatrixxOES: TglLoadMatrixxOES;
  glLoadName: TglLoadName;
  glLoadPaletteFromModelViewMatrixOES: TglLoadPaletteFromModelViewMatrixOES;
  glLoadProgramNV: TglLoadProgramNV;
  glLoadTransposeMatrixd: TglLoadTransposeMatrixd;
  glLoadTransposeMatrixdARB: TglLoadTransposeMatrixdARB;
  glLoadTransposeMatrixf: TglLoadTransposeMatrixf;
  glLoadTransposeMatrixfARB: TglLoadTransposeMatrixfARB;
  glLoadTransposeMatrixxOES: TglLoadTransposeMatrixxOES;
  glLockArraysEXT: TglLockArraysEXT;
  glLogicOp: TglLogicOp;
  glMakeBufferNonResidentNV: TglMakeBufferNonResidentNV;
  glMakeBufferResidentNV: TglMakeBufferResidentNV;
  glMakeImageHandleNonResidentARB: TglMakeImageHandleNonResidentARB;
  glMakeImageHandleNonResidentNV: TglMakeImageHandleNonResidentNV;
  glMakeImageHandleResidentARB: TglMakeImageHandleResidentARB;
  glMakeImageHandleResidentNV: TglMakeImageHandleResidentNV;
  glMakeNamedBufferNonResidentNV: TglMakeNamedBufferNonResidentNV;
  glMakeNamedBufferResidentNV: TglMakeNamedBufferResidentNV;
  glMakeTextureHandleNonResidentARB: TglMakeTextureHandleNonResidentARB;
  glMakeTextureHandleNonResidentNV: TglMakeTextureHandleNonResidentNV;
  glMakeTextureHandleResidentARB: TglMakeTextureHandleResidentARB;
  glMakeTextureHandleResidentNV: TglMakeTextureHandleResidentNV;
  glMap1d: TglMap1d;
  glMap1f: TglMap1f;
  glMap1xOES: TglMap1xOES;
  glMap2d: TglMap2d;
  glMap2f: TglMap2f;
  glMap2xOES: TglMap2xOES;
  glMapBuffer: TglMapBuffer;
  glMapBufferARB: TglMapBufferARB;
  glMapBufferOES: TglMapBufferOES;
  glMapBufferRange: TglMapBufferRange;
  glMapBufferRangeEXT: TglMapBufferRangeEXT;
  glMapControlPointsNV: TglMapControlPointsNV;
  glMapGrid1d: TglMapGrid1d;
  glMapGrid1f: TglMapGrid1f;
  glMapGrid1xOES: TglMapGrid1xOES;
  glMapGrid2d: TglMapGrid2d;
  glMapGrid2f: TglMapGrid2f;
  glMapGrid2xOES: TglMapGrid2xOES;
  glMapNamedBuffer: TglMapNamedBuffer;
  glMapNamedBufferEXT: TglMapNamedBufferEXT;
  glMapNamedBufferRange: TglMapNamedBufferRange;
  glMapNamedBufferRangeEXT: TglMapNamedBufferRangeEXT;
  glMapObjectBufferATI: TglMapObjectBufferATI;
  glMapParameterfvNV: TglMapParameterfvNV;
  glMapParameterivNV: TglMapParameterivNV;
  glMapTexture2DINTEL: TglMapTexture2DINTEL;
  glMapVertexAttrib1dAPPLE: TglMapVertexAttrib1dAPPLE;
  glMapVertexAttrib1fAPPLE: TglMapVertexAttrib1fAPPLE;
  glMapVertexAttrib2dAPPLE: TglMapVertexAttrib2dAPPLE;
  glMapVertexAttrib2fAPPLE: TglMapVertexAttrib2fAPPLE;
  glMaterialf: TglMaterialf;
  glMaterialfv: TglMaterialfv;
  glMateriali: TglMateriali;
  glMaterialiv: TglMaterialiv;
  glMaterialx: TglMaterialx;
  glMaterialxOES: TglMaterialxOES;
  glMaterialxv: TglMaterialxv;
  glMaterialxvOES: TglMaterialxvOES;
  glMatrixFrustumEXT: TglMatrixFrustumEXT;
  glMatrixIndexPointerARB: TglMatrixIndexPointerARB;
  glMatrixIndexPointerOES: TglMatrixIndexPointerOES;
  glMatrixIndexubvARB: TglMatrixIndexubvARB;
  glMatrixIndexuivARB: TglMatrixIndexuivARB;
  glMatrixIndexusvARB: TglMatrixIndexusvARB;
  glMatrixLoad3x2fNV: TglMatrixLoad3x2fNV;
  glMatrixLoad3x3fNV: TglMatrixLoad3x3fNV;
  glMatrixLoadIdentityEXT: TglMatrixLoadIdentityEXT;
  glMatrixLoadTranspose3x3fNV: TglMatrixLoadTranspose3x3fNV;
  glMatrixLoadTransposedEXT: TglMatrixLoadTransposedEXT;
  glMatrixLoadTransposefEXT: TglMatrixLoadTransposefEXT;
  glMatrixLoaddEXT: TglMatrixLoaddEXT;
  glMatrixLoadfEXT: TglMatrixLoadfEXT;
  glMatrixMode: TglMatrixMode;
  glMatrixMult3x2fNV: TglMatrixMult3x2fNV;
  glMatrixMult3x3fNV: TglMatrixMult3x3fNV;
  glMatrixMultTranspose3x3fNV: TglMatrixMultTranspose3x3fNV;
  glMatrixMultTransposedEXT: TglMatrixMultTransposedEXT;
  glMatrixMultTransposefEXT: TglMatrixMultTransposefEXT;
  glMatrixMultdEXT: TglMatrixMultdEXT;
  glMatrixMultfEXT: TglMatrixMultfEXT;
  glMatrixOrthoEXT: TglMatrixOrthoEXT;
  glMatrixPopEXT: TglMatrixPopEXT;
  glMatrixPushEXT: TglMatrixPushEXT;
  glMatrixRotatedEXT: TglMatrixRotatedEXT;
  glMatrixRotatefEXT: TglMatrixRotatefEXT;
  glMatrixScaledEXT: TglMatrixScaledEXT;
  glMatrixScalefEXT: TglMatrixScalefEXT;
  glMatrixTranslatedEXT: TglMatrixTranslatedEXT;
  glMatrixTranslatefEXT: TglMatrixTranslatefEXT;
  glMaxShaderCompilerThreadsARB: TglMaxShaderCompilerThreadsARB;
  glMemoryBarrier: TglMemoryBarrier;
  glMemoryBarrierByRegion: TglMemoryBarrierByRegion;
  glMemoryBarrierEXT: TglMemoryBarrierEXT;
  glMemoryObjectParameterivEXT: TglMemoryObjectParameterivEXT;
  glMinSampleShading: TglMinSampleShading;
  glMinSampleShadingARB: TglMinSampleShadingARB;
  glMinSampleShadingOES: TglMinSampleShadingOES;
  glMinmax: TglMinmax;
  glMinmaxEXT: TglMinmaxEXT;
  glMultMatrixd: TglMultMatrixd;
  glMultMatrixf: TglMultMatrixf;
  glMultMatrixx: TglMultMatrixx;
  glMultMatrixxOES: TglMultMatrixxOES;
  glMultTransposeMatrixd: TglMultTransposeMatrixd;
  glMultTransposeMatrixdARB: TglMultTransposeMatrixdARB;
  glMultTransposeMatrixf: TglMultTransposeMatrixf;
  glMultTransposeMatrixfARB: TglMultTransposeMatrixfARB;
  glMultTransposeMatrixxOES: TglMultTransposeMatrixxOES;
  glMultiDrawArrays: TglMultiDrawArrays;
  glMultiDrawArraysEXT: TglMultiDrawArraysEXT;
  glMultiDrawArraysIndirect: TglMultiDrawArraysIndirect;
  glMultiDrawArraysIndirectAMD: TglMultiDrawArraysIndirectAMD;
  glMultiDrawArraysIndirectBindlessCountNV: TglMultiDrawArraysIndirectBindlessCountNV;
  glMultiDrawArraysIndirectBindlessNV: TglMultiDrawArraysIndirectBindlessNV;
  glMultiDrawArraysIndirectCount: TglMultiDrawArraysIndirectCount;
  glMultiDrawArraysIndirectCountARB: TglMultiDrawArraysIndirectCountARB;
  glMultiDrawArraysIndirectEXT: TglMultiDrawArraysIndirectEXT;
  glMultiDrawElementArrayAPPLE: TglMultiDrawElementArrayAPPLE;
  glMultiDrawElements: TglMultiDrawElements;
  glMultiDrawElementsBaseVertex: TglMultiDrawElementsBaseVertex;
  glMultiDrawElementsBaseVertexEXT: TglMultiDrawElementsBaseVertexEXT;
  glMultiDrawElementsEXT: TglMultiDrawElementsEXT;
  glMultiDrawElementsIndirect: TglMultiDrawElementsIndirect;
  glMultiDrawElementsIndirectAMD: TglMultiDrawElementsIndirectAMD;
  glMultiDrawElementsIndirectBindlessCountNV: TglMultiDrawElementsIndirectBindlessCountNV;
  glMultiDrawElementsIndirectBindlessNV: TglMultiDrawElementsIndirectBindlessNV;
  glMultiDrawElementsIndirectCount: TglMultiDrawElementsIndirectCount;
  glMultiDrawElementsIndirectCountARB: TglMultiDrawElementsIndirectCountARB;
  glMultiDrawElementsIndirectEXT: TglMultiDrawElementsIndirectEXT;
  glMultiDrawRangeElementArrayAPPLE: TglMultiDrawRangeElementArrayAPPLE;
  glMultiModeDrawArraysIBM: TglMultiModeDrawArraysIBM;
  glMultiModeDrawElementsIBM: TglMultiModeDrawElementsIBM;
  glMultiTexBufferEXT: TglMultiTexBufferEXT;
  glMultiTexCoord1bOES: TglMultiTexCoord1bOES;
  glMultiTexCoord1bvOES: TglMultiTexCoord1bvOES;
  glMultiTexCoord1d: TglMultiTexCoord1d;
  glMultiTexCoord1dARB: TglMultiTexCoord1dARB;
  glMultiTexCoord1dv: TglMultiTexCoord1dv;
  glMultiTexCoord1dvARB: TglMultiTexCoord1dvARB;
  glMultiTexCoord1f: TglMultiTexCoord1f;
  glMultiTexCoord1fARB: TglMultiTexCoord1fARB;
  glMultiTexCoord1fv: TglMultiTexCoord1fv;
  glMultiTexCoord1fvARB: TglMultiTexCoord1fvARB;
  glMultiTexCoord1hNV: TglMultiTexCoord1hNV;
  glMultiTexCoord1hvNV: TglMultiTexCoord1hvNV;
  glMultiTexCoord1i: TglMultiTexCoord1i;
  glMultiTexCoord1iARB: TglMultiTexCoord1iARB;
  glMultiTexCoord1iv: TglMultiTexCoord1iv;
  glMultiTexCoord1ivARB: TglMultiTexCoord1ivARB;
  glMultiTexCoord1s: TglMultiTexCoord1s;
  glMultiTexCoord1sARB: TglMultiTexCoord1sARB;
  glMultiTexCoord1sv: TglMultiTexCoord1sv;
  glMultiTexCoord1svARB: TglMultiTexCoord1svARB;
  glMultiTexCoord1xOES: TglMultiTexCoord1xOES;
  glMultiTexCoord1xvOES: TglMultiTexCoord1xvOES;
  glMultiTexCoord2bOES: TglMultiTexCoord2bOES;
  glMultiTexCoord2bvOES: TglMultiTexCoord2bvOES;
  glMultiTexCoord2d: TglMultiTexCoord2d;
  glMultiTexCoord2dARB: TglMultiTexCoord2dARB;
  glMultiTexCoord2dv: TglMultiTexCoord2dv;
  glMultiTexCoord2dvARB: TglMultiTexCoord2dvARB;
  glMultiTexCoord2f: TglMultiTexCoord2f;
  glMultiTexCoord2fARB: TglMultiTexCoord2fARB;
  glMultiTexCoord2fv: TglMultiTexCoord2fv;
  glMultiTexCoord2fvARB: TglMultiTexCoord2fvARB;
  glMultiTexCoord2hNV: TglMultiTexCoord2hNV;
  glMultiTexCoord2hvNV: TglMultiTexCoord2hvNV;
  glMultiTexCoord2i: TglMultiTexCoord2i;
  glMultiTexCoord2iARB: TglMultiTexCoord2iARB;
  glMultiTexCoord2iv: TglMultiTexCoord2iv;
  glMultiTexCoord2ivARB: TglMultiTexCoord2ivARB;
  glMultiTexCoord2s: TglMultiTexCoord2s;
  glMultiTexCoord2sARB: TglMultiTexCoord2sARB;
  glMultiTexCoord2sv: TglMultiTexCoord2sv;
  glMultiTexCoord2svARB: TglMultiTexCoord2svARB;
  glMultiTexCoord2xOES: TglMultiTexCoord2xOES;
  glMultiTexCoord2xvOES: TglMultiTexCoord2xvOES;
  glMultiTexCoord3bOES: TglMultiTexCoord3bOES;
  glMultiTexCoord3bvOES: TglMultiTexCoord3bvOES;
  glMultiTexCoord3d: TglMultiTexCoord3d;
  glMultiTexCoord3dARB: TglMultiTexCoord3dARB;
  glMultiTexCoord3dv: TglMultiTexCoord3dv;
  glMultiTexCoord3dvARB: TglMultiTexCoord3dvARB;
  glMultiTexCoord3f: TglMultiTexCoord3f;
  glMultiTexCoord3fARB: TglMultiTexCoord3fARB;
  glMultiTexCoord3fv: TglMultiTexCoord3fv;
  glMultiTexCoord3fvARB: TglMultiTexCoord3fvARB;
  glMultiTexCoord3hNV: TglMultiTexCoord3hNV;
  glMultiTexCoord3hvNV: TglMultiTexCoord3hvNV;
  glMultiTexCoord3i: TglMultiTexCoord3i;
  glMultiTexCoord3iARB: TglMultiTexCoord3iARB;
  glMultiTexCoord3iv: TglMultiTexCoord3iv;
  glMultiTexCoord3ivARB: TglMultiTexCoord3ivARB;
  glMultiTexCoord3s: TglMultiTexCoord3s;
  glMultiTexCoord3sARB: TglMultiTexCoord3sARB;
  glMultiTexCoord3sv: TglMultiTexCoord3sv;
  glMultiTexCoord3svARB: TglMultiTexCoord3svARB;
  glMultiTexCoord3xOES: TglMultiTexCoord3xOES;
  glMultiTexCoord3xvOES: TglMultiTexCoord3xvOES;
  glMultiTexCoord4bOES: TglMultiTexCoord4bOES;
  glMultiTexCoord4bvOES: TglMultiTexCoord4bvOES;
  glMultiTexCoord4d: TglMultiTexCoord4d;
  glMultiTexCoord4dARB: TglMultiTexCoord4dARB;
  glMultiTexCoord4dv: TglMultiTexCoord4dv;
  glMultiTexCoord4dvARB: TglMultiTexCoord4dvARB;
  glMultiTexCoord4f: TglMultiTexCoord4f;
  glMultiTexCoord4fARB: TglMultiTexCoord4fARB;
  glMultiTexCoord4fv: TglMultiTexCoord4fv;
  glMultiTexCoord4fvARB: TglMultiTexCoord4fvARB;
  glMultiTexCoord4hNV: TglMultiTexCoord4hNV;
  glMultiTexCoord4hvNV: TglMultiTexCoord4hvNV;
  glMultiTexCoord4i: TglMultiTexCoord4i;
  glMultiTexCoord4iARB: TglMultiTexCoord4iARB;
  glMultiTexCoord4iv: TglMultiTexCoord4iv;
  glMultiTexCoord4ivARB: TglMultiTexCoord4ivARB;
  glMultiTexCoord4s: TglMultiTexCoord4s;
  glMultiTexCoord4sARB: TglMultiTexCoord4sARB;
  glMultiTexCoord4sv: TglMultiTexCoord4sv;
  glMultiTexCoord4svARB: TglMultiTexCoord4svARB;
  glMultiTexCoord4x: TglMultiTexCoord4x;
  glMultiTexCoord4xOES: TglMultiTexCoord4xOES;
  glMultiTexCoord4xvOES: TglMultiTexCoord4xvOES;
  glMultiTexCoordP1ui: TglMultiTexCoordP1ui;
  glMultiTexCoordP1uiv: TglMultiTexCoordP1uiv;
  glMultiTexCoordP2ui: TglMultiTexCoordP2ui;
  glMultiTexCoordP2uiv: TglMultiTexCoordP2uiv;
  glMultiTexCoordP3ui: TglMultiTexCoordP3ui;
  glMultiTexCoordP3uiv: TglMultiTexCoordP3uiv;
  glMultiTexCoordP4ui: TglMultiTexCoordP4ui;
  glMultiTexCoordP4uiv: TglMultiTexCoordP4uiv;
  glMultiTexCoordPointerEXT: TglMultiTexCoordPointerEXT;
  glMultiTexEnvfEXT: TglMultiTexEnvfEXT;
  glMultiTexEnvfvEXT: TglMultiTexEnvfvEXT;
  glMultiTexEnviEXT: TglMultiTexEnviEXT;
  glMultiTexEnvivEXT: TglMultiTexEnvivEXT;
  glMultiTexGendEXT: TglMultiTexGendEXT;
  glMultiTexGendvEXT: TglMultiTexGendvEXT;
  glMultiTexGenfEXT: TglMultiTexGenfEXT;
  glMultiTexGenfvEXT: TglMultiTexGenfvEXT;
  glMultiTexGeniEXT: TglMultiTexGeniEXT;
  glMultiTexGenivEXT: TglMultiTexGenivEXT;
  glMultiTexImage1DEXT: TglMultiTexImage1DEXT;
  glMultiTexImage2DEXT: TglMultiTexImage2DEXT;
  glMultiTexImage3DEXT: TglMultiTexImage3DEXT;
  glMultiTexParameterIivEXT: TglMultiTexParameterIivEXT;
  glMultiTexParameterIuivEXT: TglMultiTexParameterIuivEXT;
  glMultiTexParameterfEXT: TglMultiTexParameterfEXT;
  glMultiTexParameterfvEXT: TglMultiTexParameterfvEXT;
  glMultiTexParameteriEXT: TglMultiTexParameteriEXT;
  glMultiTexParameterivEXT: TglMultiTexParameterivEXT;
  glMultiTexRenderbufferEXT: TglMultiTexRenderbufferEXT;
  glMultiTexSubImage1DEXT: TglMultiTexSubImage1DEXT;
  glMultiTexSubImage2DEXT: TglMultiTexSubImage2DEXT;
  glMultiTexSubImage3DEXT: TglMultiTexSubImage3DEXT;
  glMulticastBarrierNV: TglMulticastBarrierNV;
  glMulticastBlitFramebufferNV: TglMulticastBlitFramebufferNV;
  glMulticastBufferSubDataNV: TglMulticastBufferSubDataNV;
  glMulticastCopyBufferSubDataNV: TglMulticastCopyBufferSubDataNV;
  glMulticastCopyImageSubDataNV: TglMulticastCopyImageSubDataNV;
  glMulticastFramebufferSampleLocationsfvNV: TglMulticastFramebufferSampleLocationsfvNV;
  glMulticastGetQueryObjecti64vNV: TglMulticastGetQueryObjecti64vNV;
  glMulticastGetQueryObjectivNV: TglMulticastGetQueryObjectivNV;
  glMulticastGetQueryObjectui64vNV: TglMulticastGetQueryObjectui64vNV;
  glMulticastGetQueryObjectuivNV: TglMulticastGetQueryObjectuivNV;
  glMulticastWaitSyncNV: TglMulticastWaitSyncNV;
  glNamedBufferData: TglNamedBufferData;
  glNamedBufferDataEXT: TglNamedBufferDataEXT;
  glNamedBufferPageCommitmentARB: TglNamedBufferPageCommitmentARB;
  glNamedBufferPageCommitmentEXT: TglNamedBufferPageCommitmentEXT;
  glNamedBufferStorage: TglNamedBufferStorage;
  glNamedBufferStorageExternalEXT: TglNamedBufferStorageExternalEXT;
  glNamedBufferStorageEXT: TglNamedBufferStorageEXT;
  glNamedBufferStorageMemEXT: TglNamedBufferStorageMemEXT;
  glNamedBufferSubData: TglNamedBufferSubData;
  glNamedBufferSubDataEXT: TglNamedBufferSubDataEXT;
  glNamedCopyBufferSubDataEXT: TglNamedCopyBufferSubDataEXT;
  glNamedFramebufferDrawBuffer: TglNamedFramebufferDrawBuffer;
  glNamedFramebufferDrawBuffers: TglNamedFramebufferDrawBuffers;
  glNamedFramebufferParameteri: TglNamedFramebufferParameteri;
  glNamedFramebufferParameteriEXT: TglNamedFramebufferParameteriEXT;
  glNamedFramebufferReadBuffer: TglNamedFramebufferReadBuffer;
  glNamedFramebufferRenderbuffer: TglNamedFramebufferRenderbuffer;
  glNamedFramebufferRenderbufferEXT: TglNamedFramebufferRenderbufferEXT;
  glNamedFramebufferSampleLocationsfvARB: TglNamedFramebufferSampleLocationsfvARB;
  glNamedFramebufferSampleLocationsfvNV: TglNamedFramebufferSampleLocationsfvNV;
  glNamedFramebufferTexture: TglNamedFramebufferTexture;
  glNamedFramebufferSamplePositionsfvAMD: TglNamedFramebufferSamplePositionsfvAMD;
  glNamedFramebufferTexture1DEXT: TglNamedFramebufferTexture1DEXT;
  glNamedFramebufferTexture2DEXT: TglNamedFramebufferTexture2DEXT;
  glNamedFramebufferTexture3DEXT: TglNamedFramebufferTexture3DEXT;
  glNamedFramebufferTextureEXT: TglNamedFramebufferTextureEXT;
  glNamedFramebufferTextureFaceEXT: TglNamedFramebufferTextureFaceEXT;
  glNamedFramebufferTextureLayer: TglNamedFramebufferTextureLayer;
  glNamedFramebufferTextureLayerEXT: TglNamedFramebufferTextureLayerEXT;
  glNamedProgramLocalParameter4dEXT: TglNamedProgramLocalParameter4dEXT;
  glNamedProgramLocalParameter4dvEXT: TglNamedProgramLocalParameter4dvEXT;
  glNamedProgramLocalParameter4fEXT: TglNamedProgramLocalParameter4fEXT;
  glNamedProgramLocalParameter4fvEXT: TglNamedProgramLocalParameter4fvEXT;
  glNamedProgramLocalParameterI4iEXT: TglNamedProgramLocalParameterI4iEXT;
  glNamedProgramLocalParameterI4ivEXT: TglNamedProgramLocalParameterI4ivEXT;
  glNamedProgramLocalParameterI4uiEXT: TglNamedProgramLocalParameterI4uiEXT;
  glNamedProgramLocalParameterI4uivEXT: TglNamedProgramLocalParameterI4uivEXT;
  glNamedProgramLocalParameters4fvEXT: TglNamedProgramLocalParameters4fvEXT;
  glNamedProgramLocalParametersI4ivEXT: TglNamedProgramLocalParametersI4ivEXT;
  glNamedProgramLocalParametersI4uivEXT: TglNamedProgramLocalParametersI4uivEXT;
  glNamedProgramStringEXT: TglNamedProgramStringEXT;
  glNamedRenderbufferStorage: TglNamedRenderbufferStorage;
  glNamedRenderbufferStorageEXT: TglNamedRenderbufferStorageEXT;
  glNamedRenderbufferStorageMultisample: TglNamedRenderbufferStorageMultisample;
  glNamedRenderbufferStorageMultisampleCoverageEXT: TglNamedRenderbufferStorageMultisampleCoverageEXT;
  glNamedRenderbufferStorageMultisampleEXT: TglNamedRenderbufferStorageMultisampleEXT;
  glNamedStringARB: TglNamedStringARB;
  glNewList: TglNewList;
  glNewObjectBufferATI: TglNewObjectBufferATI;
  glNormal3b: TglNormal3b;
  glNormal3bv: TglNormal3bv;
  glNormal3d: TglNormal3d;
  glNormal3dv: TglNormal3dv;
  glNormal3f: TglNormal3f;
  glNormal3fVertex3fSUN: TglNormal3fVertex3fSUN;
  glNormal3fVertex3fvSUN: TglNormal3fVertex3fvSUN;
  glNormal3fv: TglNormal3fv;
  glNormal3hNV: TglNormal3hNV;
  glNormal3hvNV: TglNormal3hvNV;
  glNormal3i: TglNormal3i;
  glNormal3iv: TglNormal3iv;
  glNormal3s: TglNormal3s;
  glNormal3sv: TglNormal3sv;
  glNormal3x: TglNormal3x;
  glNormal3xOES: TglNormal3xOES;
  glNormal3xvOES: TglNormal3xvOES;
  glNormalFormatNV: TglNormalFormatNV;
  glNormalP3ui: TglNormalP3ui;
  glNormalP3uiv: TglNormalP3uiv;
  glNormalPointer: TglNormalPointer;
  glNormalPointerEXT: TglNormalPointerEXT;
  glNormalPointerListIBM: TglNormalPointerListIBM;
  glNormalPointervINTEL: TglNormalPointervINTEL;
  glNormalStream3bATI: TglNormalStream3bATI;
  glNormalStream3bvATI: TglNormalStream3bvATI;
  glNormalStream3dATI: TglNormalStream3dATI;
  glNormalStream3dvATI: TglNormalStream3dvATI;
  glNormalStream3fATI: TglNormalStream3fATI;
  glNormalStream3fvATI: TglNormalStream3fvATI;
  glNormalStream3iATI: TglNormalStream3iATI;
  glNormalStream3ivATI: TglNormalStream3ivATI;
  glNormalStream3sATI: TglNormalStream3sATI;
  glNormalStream3svATI: TglNormalStream3svATI;
  glObjectLabel: TglObjectLabel;
  glObjectLabelKHR: TglObjectLabelKHR;
  glObjectPtrLabel: TglObjectPtrLabel;
  glObjectPtrLabelKHR: TglObjectPtrLabelKHR;
  glObjectPurgeableAPPLE: TglObjectPurgeableAPPLE;
  glObjectUnpurgeableAPPLE: TglObjectUnpurgeableAPPLE;
  glOrtho: TglOrtho;
  glOrthof: TglOrthof;
  glOrthofOES: TglOrthofOES;
  glOrthox: TglOrthox;
  glOrthoxOES: TglOrthoxOES;
  glPNTrianglesfATI: TglPNTrianglesfATI;
  glPNTrianglesiATI: TglPNTrianglesiATI;
  glPassTexCoordATI: TglPassTexCoordATI;
  glPassThrough: TglPassThrough;
  glPassThroughxOES: TglPassThroughxOES;
  glPatchParameterfv: TglPatchParameterfv;
  glPatchParameteri: TglPatchParameteri;
  glPatchParameteriEXT: TglPatchParameteriEXT;
  glPatchParameteriOES: TglPatchParameteriOES;
  glPathColorGenNV: TglPathColorGenNV;
  glPathCommandsNV: TglPathCommandsNV;
  glPathCoordsNV: TglPathCoordsNV;
  glPathCoverDepthFuncNV: TglPathCoverDepthFuncNV;
  glPathDashArrayNV: TglPathDashArrayNV;
  glPathFogGenNV: TglPathFogGenNV;
  glPathGlyphIndexArrayNV: TglPathGlyphIndexArrayNV;
  glPathGlyphIndexRangeNV: TglPathGlyphIndexRangeNV;
  glPathGlyphRangeNV: TglPathGlyphRangeNV;
  glPathGlyphsNV: TglPathGlyphsNV;
  glPathMemoryGlyphIndexArrayNV: TglPathMemoryGlyphIndexArrayNV;
  glPathParameterfNV: TglPathParameterfNV;
  glPathParameterfvNV: TglPathParameterfvNV;
  glPathParameteriNV: TglPathParameteriNV;
  glPathParameterivNV: TglPathParameterivNV;
  glPathStencilDepthOffsetNV: TglPathStencilDepthOffsetNV;
  glPathStencilFuncNV: TglPathStencilFuncNV;
  glPathStringNV: TglPathStringNV;
  glPathSubCommandsNV: TglPathSubCommandsNV;
  glPathSubCoordsNV: TglPathSubCoordsNV;
  glPathTexGenNV: TglPathTexGenNV;
  glPauseTransformFeedback: TglPauseTransformFeedback;
  glPauseTransformFeedbackNV: TglPauseTransformFeedbackNV;
  glPixelDataRangeNV: TglPixelDataRangeNV;
  glPixelMapfv: TglPixelMapfv;
  glPixelMapuiv: TglPixelMapuiv;
  glPixelMapusv: TglPixelMapusv;
  glPixelMapx: TglPixelMapx;
  glPixelStoref: TglPixelStoref;
  glPixelStorei: TglPixelStorei;
  glPixelStorex: TglPixelStorex;
  glPixelTexGenParameterfSGIS: TglPixelTexGenParameterfSGIS;
  glPixelTexGenParameterfvSGIS: TglPixelTexGenParameterfvSGIS;
  glPixelTexGenParameteriSGIS: TglPixelTexGenParameteriSGIS;
  glPixelTexGenParameterivSGIS: TglPixelTexGenParameterivSGIS;
  glPixelTexGenSGIX: TglPixelTexGenSGIX;
  glPixelTransferf: TglPixelTransferf;
  glPixelTransferi: TglPixelTransferi;
  glPixelTransferxOES: TglPixelTransferxOES;
  glPixelTransformParameterfEXT: TglPixelTransformParameterfEXT;
  glPixelTransformParameterfvEXT: TglPixelTransformParameterfvEXT;
  glPixelTransformParameteriEXT: TglPixelTransformParameteriEXT;
  glPixelTransformParameterivEXT: TglPixelTransformParameterivEXT;
  glPixelZoom: TglPixelZoom;
  glPixelZoomxOES: TglPixelZoomxOES;
  glPointAlongPathNV: TglPointAlongPathNV;
  glPointParameterf: TglPointParameterf;
  glPointParameterfARB: TglPointParameterfARB;
  glPointParameterfEXT: TglPointParameterfEXT;
  glPointParameterfSGIS: TglPointParameterfSGIS;
  glPointParameterfv: TglPointParameterfv;
  glPointParameterfvARB: TglPointParameterfvARB;
  glPointParameterfvEXT: TglPointParameterfvEXT;
  glPointParameterfvSGIS: TglPointParameterfvSGIS;
  glPointParameteri: TglPointParameteri;
  glPointParameteriNV: TglPointParameteriNV;
  glPointParameteriv: TglPointParameteriv;
  glPointParameterivNV: TglPointParameterivNV;
  glPointParameterx: TglPointParameterx;
  glPointParameterxOES: TglPointParameterxOES;
  glPointParameterxv: TglPointParameterxv;
  glPointParameterxvOES: TglPointParameterxvOES;
  glPointSize: TglPointSize;
  glPointSizePointerOES: TglPointSizePointerOES;
  glPointSizex: TglPointSizex;
  glPointSizexOES: TglPointSizexOES;
  glPollAsyncSGIX: TglPollAsyncSGIX;
  glPollInstrumentsSGIX: TglPollInstrumentsSGIX;
  glPolygonMode: TglPolygonMode;
  glPolygonModeNV: TglPolygonModeNV;
  glPolygonOffset: TglPolygonOffset;
  glPolygonOffsetClamp: TglPolygonOffsetClamp;
  glPolygonOffsetClampEXT: TglPolygonOffsetClampEXT;
  glPolygonOffsetEXT: TglPolygonOffsetEXT;
  glPolygonOffsetx: TglPolygonOffsetx;
  glPolygonOffsetxOES: TglPolygonOffsetxOES;
  glPolygonStipple: TglPolygonStipple;
  glPopAttrib: TglPopAttrib;
  glPopClientAttrib: TglPopClientAttrib;
  glPopDebugGroup: TglPopDebugGroup;
  glPopDebugGroupKHR: TglPopDebugGroupKHR;
  glPopGroupMarkerEXT: TglPopGroupMarkerEXT;
  glPopMatrix: TglPopMatrix;
  glPopName: TglPopName;
  glPresentFrameDualFillNV: TglPresentFrameDualFillNV;
  glPresentFrameKeyedNV: TglPresentFrameKeyedNV;
  glPrimitiveBoundingBox: TglPrimitiveBoundingBox;
  glPrimitiveBoundingBoxARB: TglPrimitiveBoundingBoxARB;
  glPrimitiveBoundingBoxEXT: TglPrimitiveBoundingBoxEXT;
  glPrimitiveBoundingBoxOES: TglPrimitiveBoundingBoxOES;
  glPrimitiveRestartIndex: TglPrimitiveRestartIndex;
  glPrimitiveRestartIndexNV: TglPrimitiveRestartIndexNV;
  glPrimitiveRestartNV: TglPrimitiveRestartNV;
  glPrioritizeTextures: TglPrioritizeTextures;
  glPrioritizeTexturesEXT: TglPrioritizeTexturesEXT;
  glPrioritizeTexturesxOES: TglPrioritizeTexturesxOES;
  glProgramBinary: TglProgramBinary;
  glProgramBinaryOES: TglProgramBinaryOES;
  glProgramBufferParametersIivNV: TglProgramBufferParametersIivNV;
  glProgramBufferParametersIuivNV: TglProgramBufferParametersIuivNV;
  glProgramBufferParametersfvNV: TglProgramBufferParametersfvNV;
  glProgramEnvParameter4dARB: TglProgramEnvParameter4dARB;
  glProgramEnvParameter4dvARB: TglProgramEnvParameter4dvARB;
  glProgramEnvParameter4fARB: TglProgramEnvParameter4fARB;
  glProgramEnvParameter4fvARB: TglProgramEnvParameter4fvARB;
  glProgramEnvParameterI4iNV: TglProgramEnvParameterI4iNV;
  glProgramEnvParameterI4ivNV: TglProgramEnvParameterI4ivNV;
  glProgramEnvParameterI4uiNV: TglProgramEnvParameterI4uiNV;
  glProgramEnvParameterI4uivNV: TglProgramEnvParameterI4uivNV;
  glProgramEnvParameters4fvEXT: TglProgramEnvParameters4fvEXT;
  glProgramEnvParametersI4ivNV: TglProgramEnvParametersI4ivNV;
  glProgramEnvParametersI4uivNV: TglProgramEnvParametersI4uivNV;
  glProgramLocalParameter4dARB: TglProgramLocalParameter4dARB;
  glProgramLocalParameter4dvARB: TglProgramLocalParameter4dvARB;
  glProgramLocalParameter4fARB: TglProgramLocalParameter4fARB;
  glProgramLocalParameter4fvARB: TglProgramLocalParameter4fvARB;
  glProgramLocalParameterI4iNV: TglProgramLocalParameterI4iNV;
  glProgramLocalParameterI4ivNV: TglProgramLocalParameterI4ivNV;
  glProgramLocalParameterI4uiNV: TglProgramLocalParameterI4uiNV;
  glProgramLocalParameterI4uivNV: TglProgramLocalParameterI4uivNV;
  glProgramLocalParameters4fvEXT: TglProgramLocalParameters4fvEXT;
  glProgramLocalParametersI4ivNV: TglProgramLocalParametersI4ivNV;
  glProgramLocalParametersI4uivNV: TglProgramLocalParametersI4uivNV;
  glProgramNamedParameter4dNV: TglProgramNamedParameter4dNV;
  glProgramNamedParameter4dvNV: TglProgramNamedParameter4dvNV;
  glProgramNamedParameter4fNV: TglProgramNamedParameter4fNV;
  glProgramNamedParameter4fvNV: TglProgramNamedParameter4fvNV;
  glProgramParameter4dNV: TglProgramParameter4dNV;
  glProgramParameter4dvNV: TglProgramParameter4dvNV;
  glProgramParameter4fNV: TglProgramParameter4fNV;
  glProgramParameter4fvNV: TglProgramParameter4fvNV;
  glProgramParameteri: TglProgramParameteri;
  glProgramParameteriARB: TglProgramParameteriARB;
  glProgramParameteriEXT: TglProgramParameteriEXT;
  glProgramParameters4dvNV: TglProgramParameters4dvNV;
  glProgramParameters4fvNV: TglProgramParameters4fvNV;
  glProgramPathFragmentInputGenNV: TglProgramPathFragmentInputGenNV;
  glProgramStringARB: TglProgramStringARB;
  glProgramSubroutineParametersuivNV: TglProgramSubroutineParametersuivNV;
  glProgramUniform1d: TglProgramUniform1d;
  glProgramUniform1dEXT: TglProgramUniform1dEXT;
  glProgramUniform1dv: TglProgramUniform1dv;
  glProgramUniform1dvEXT: TglProgramUniform1dvEXT;
  glProgramUniform1f: TglProgramUniform1f;
  glProgramUniform1fEXT: TglProgramUniform1fEXT;
  glProgramUniform1fv: TglProgramUniform1fv;
  glProgramUniform1fvEXT: TglProgramUniform1fvEXT;
  glProgramUniform1i: TglProgramUniform1i;
  glProgramUniform1i64ARB: TglProgramUniform1i64ARB;
  glProgramUniform1i64NV: TglProgramUniform1i64NV;
  glProgramUniform1i64vARB: TglProgramUniform1i64vARB;
  glProgramUniform1i64vNV: TglProgramUniform1i64vNV;
  glProgramUniform1iEXT: TglProgramUniform1iEXT;
  glProgramUniform1iv: TglProgramUniform1iv;
  glProgramUniform1ivEXT: TglProgramUniform1ivEXT;
  glProgramUniform1ui: TglProgramUniform1ui;
  glProgramUniform1ui64ARB: TglProgramUniform1ui64ARB;
  glProgramUniform1ui64NV: TglProgramUniform1ui64NV;
  glProgramUniform1ui64vARB: TglProgramUniform1ui64vARB;
  glProgramUniform1ui64vNV: TglProgramUniform1ui64vNV;
  glProgramUniform1uiEXT: TglProgramUniform1uiEXT;
  glProgramUniform1uiv: TglProgramUniform1uiv;
  glProgramUniform1uivEXT: TglProgramUniform1uivEXT;
  glProgramUniform2d: TglProgramUniform2d;
  glProgramUniform2dEXT: TglProgramUniform2dEXT;
  glProgramUniform2dv: TglProgramUniform2dv;
  glProgramUniform2dvEXT: TglProgramUniform2dvEXT;
  glProgramUniform2f: TglProgramUniform2f;
  glProgramUniform2fEXT: TglProgramUniform2fEXT;
  glProgramUniform2fv: TglProgramUniform2fv;
  glProgramUniform2fvEXT: TglProgramUniform2fvEXT;
  glProgramUniform2i: TglProgramUniform2i;
  glProgramUniform2i64ARB: TglProgramUniform2i64ARB;
  glProgramUniform2i64NV: TglProgramUniform2i64NV;
  glProgramUniform2i64vARB: TglProgramUniform2i64vARB;
  glProgramUniform2i64vNV: TglProgramUniform2i64vNV;
  glProgramUniform2iEXT: TglProgramUniform2iEXT;
  glProgramUniform2iv: TglProgramUniform2iv;
  glProgramUniform2ivEXT: TglProgramUniform2ivEXT;
  glProgramUniform2ui: TglProgramUniform2ui;
  glProgramUniform2ui64ARB: TglProgramUniform2ui64ARB;
  glProgramUniform2ui64NV: TglProgramUniform2ui64NV;
  glProgramUniform2ui64vARB: TglProgramUniform2ui64vARB;
  glProgramUniform2ui64vNV: TglProgramUniform2ui64vNV;
  glProgramUniform2uiEXT: TglProgramUniform2uiEXT;
  glProgramUniform2uiv: TglProgramUniform2uiv;
  glProgramUniform2uivEXT: TglProgramUniform2uivEXT;
  glProgramUniform3d: TglProgramUniform3d;
  glProgramUniform3dEXT: TglProgramUniform3dEXT;
  glProgramUniform3dv: TglProgramUniform3dv;
  glProgramUniform3dvEXT: TglProgramUniform3dvEXT;
  glProgramUniform3f: TglProgramUniform3f;
  glProgramUniform3fEXT: TglProgramUniform3fEXT;
  glProgramUniform3fv: TglProgramUniform3fv;
  glProgramUniform3fvEXT: TglProgramUniform3fvEXT;
  glProgramUniform3i: TglProgramUniform3i;
  glProgramUniform3i64ARB: TglProgramUniform3i64ARB;
  glProgramUniform3i64NV: TglProgramUniform3i64NV;
  glProgramUniform3i64vARB: TglProgramUniform3i64vARB;
  glProgramUniform3i64vNV: TglProgramUniform3i64vNV;
  glProgramUniform3iEXT: TglProgramUniform3iEXT;
  glProgramUniform3iv: TglProgramUniform3iv;
  glProgramUniform3ivEXT: TglProgramUniform3ivEXT;
  glProgramUniform3ui: TglProgramUniform3ui;
  glProgramUniform3ui64ARB: TglProgramUniform3ui64ARB;
  glProgramUniform3ui64NV: TglProgramUniform3ui64NV;
  glProgramUniform3ui64vARB: TglProgramUniform3ui64vARB;
  glProgramUniform3ui64vNV: TglProgramUniform3ui64vNV;
  glProgramUniform3uiEXT: TglProgramUniform3uiEXT;
  glProgramUniform3uiv: TglProgramUniform3uiv;
  glProgramUniform3uivEXT: TglProgramUniform3uivEXT;
  glProgramUniform4d: TglProgramUniform4d;
  glProgramUniform4dEXT: TglProgramUniform4dEXT;
  glProgramUniform4dv: TglProgramUniform4dv;
  glProgramUniform4dvEXT: TglProgramUniform4dvEXT;
  glProgramUniform4f: TglProgramUniform4f;
  glProgramUniform4fEXT: TglProgramUniform4fEXT;
  glProgramUniform4fv: TglProgramUniform4fv;
  glProgramUniform4fvEXT: TglProgramUniform4fvEXT;
  glProgramUniform4i: TglProgramUniform4i;
  glProgramUniform4i64ARB: TglProgramUniform4i64ARB;
  glProgramUniform4i64NV: TglProgramUniform4i64NV;
  glProgramUniform4i64vARB: TglProgramUniform4i64vARB;
  glProgramUniform4i64vNV: TglProgramUniform4i64vNV;
  glProgramUniform4iEXT: TglProgramUniform4iEXT;
  glProgramUniform4iv: TglProgramUniform4iv;
  glProgramUniform4ivEXT: TglProgramUniform4ivEXT;
  glProgramUniform4ui: TglProgramUniform4ui;
  glProgramUniform4ui64ARB: TglProgramUniform4ui64ARB;
  glProgramUniform4ui64NV: TglProgramUniform4ui64NV;
  glProgramUniform4ui64vARB: TglProgramUniform4ui64vARB;
  glProgramUniform4ui64vNV: TglProgramUniform4ui64vNV;
  glProgramUniform4uiEXT: TglProgramUniform4uiEXT;
  glProgramUniform4uiv: TglProgramUniform4uiv;
  glProgramUniform4uivEXT: TglProgramUniform4uivEXT;
  glProgramUniformHandleui64ARB: TglProgramUniformHandleui64ARB;
  glProgramUniformHandleui64IMG: TglProgramUniformHandleui64IMG;
  glProgramUniformHandleui64NV: TglProgramUniformHandleui64NV;
  glProgramUniformHandleui64vARB: TglProgramUniformHandleui64vARB;
  glProgramUniformHandleui64vIMG: TglProgramUniformHandleui64vIMG;
  glProgramUniformHandleui64vNV: TglProgramUniformHandleui64vNV;
  glProgramUniformMatrix2dv: TglProgramUniformMatrix2dv;
  glProgramUniformMatrix2dvEXT: TglProgramUniformMatrix2dvEXT;
  glProgramUniformMatrix2fv: TglProgramUniformMatrix2fv;
  glProgramUniformMatrix2fvEXT: TglProgramUniformMatrix2fvEXT;
  glProgramUniformMatrix2x3dv: TglProgramUniformMatrix2x3dv;
  glProgramUniformMatrix2x3dvEXT: TglProgramUniformMatrix2x3dvEXT;
  glProgramUniformMatrix2x3fv: TglProgramUniformMatrix2x3fv;
  glProgramUniformMatrix2x3fvEXT: TglProgramUniformMatrix2x3fvEXT;
  glProgramUniformMatrix2x4dv: TglProgramUniformMatrix2x4dv;
  glProgramUniformMatrix2x4dvEXT: TglProgramUniformMatrix2x4dvEXT;
  glProgramUniformMatrix2x4fv: TglProgramUniformMatrix2x4fv;
  glProgramUniformMatrix2x4fvEXT: TglProgramUniformMatrix2x4fvEXT;
  glProgramUniformMatrix3dv: TglProgramUniformMatrix3dv;
  glProgramUniformMatrix3dvEXT: TglProgramUniformMatrix3dvEXT;
  glProgramUniformMatrix3fv: TglProgramUniformMatrix3fv;
  glProgramUniformMatrix3fvEXT: TglProgramUniformMatrix3fvEXT;
  glProgramUniformMatrix3x2dv: TglProgramUniformMatrix3x2dv;
  glProgramUniformMatrix3x2dvEXT: TglProgramUniformMatrix3x2dvEXT;
  glProgramUniformMatrix3x2fv: TglProgramUniformMatrix3x2fv;
  glProgramUniformMatrix3x2fvEXT: TglProgramUniformMatrix3x2fvEXT;
  glProgramUniformMatrix3x4dv: TglProgramUniformMatrix3x4dv;
  glProgramUniformMatrix3x4dvEXT: TglProgramUniformMatrix3x4dvEXT;
  glProgramUniformMatrix3x4fv: TglProgramUniformMatrix3x4fv;
  glProgramUniformMatrix3x4fvEXT: TglProgramUniformMatrix3x4fvEXT;
  glProgramUniformMatrix4dv: TglProgramUniformMatrix4dv;
  glProgramUniformMatrix4dvEXT: TglProgramUniformMatrix4dvEXT;
  glProgramUniformMatrix4fv: TglProgramUniformMatrix4fv;
  glProgramUniformMatrix4fvEXT: TglProgramUniformMatrix4fvEXT;
  glProgramUniformMatrix4x2dv: TglProgramUniformMatrix4x2dv;
  glProgramUniformMatrix4x2dvEXT: TglProgramUniformMatrix4x2dvEXT;
  glProgramUniformMatrix4x2fv: TglProgramUniformMatrix4x2fv;
  glProgramUniformMatrix4x2fvEXT: TglProgramUniformMatrix4x2fvEXT;
  glProgramUniformMatrix4x3dv: TglProgramUniformMatrix4x3dv;
  glProgramUniformMatrix4x3dvEXT: TglProgramUniformMatrix4x3dvEXT;
  glProgramUniformMatrix4x3fv: TglProgramUniformMatrix4x3fv;
  glProgramUniformMatrix4x3fvEXT: TglProgramUniformMatrix4x3fvEXT;
  glProgramUniformui64NV: TglProgramUniformui64NV;
  glProgramUniformui64vNV: TglProgramUniformui64vNV;
  glProgramVertexLimitNV: TglProgramVertexLimitNV;
  glProvokingVertex: TglProvokingVertex;
  glProvokingVertexEXT: TglProvokingVertexEXT;
  glPushAttrib: TglPushAttrib;
  glPushClientAttrib: TglPushClientAttrib;
  glPushClientAttribDefaultEXT: TglPushClientAttribDefaultEXT;
  glPushDebugGroup: TglPushDebugGroup;
  glPushDebugGroupKHR: TglPushDebugGroupKHR;
  glPushGroupMarkerEXT: TglPushGroupMarkerEXT;
  glPushMatrix: TglPushMatrix;
  glPushName: TglPushName;
  glQueryCounter: TglQueryCounter;
  glQueryCounterEXT: TglQueryCounterEXT;
  glQueryMatrixxOES: TglQueryMatrixxOES;
  glQueryObjectParameteruiAMD: TglQueryObjectParameteruiAMD;
  glRasterPos2d: TglRasterPos2d;
  glRasterPos2dv: TglRasterPos2dv;
  glRasterPos2f: TglRasterPos2f;
  glRasterPos2fv: TglRasterPos2fv;
  glRasterPos2i: TglRasterPos2i;
  glRasterPos2iv: TglRasterPos2iv;
  glRasterPos2s: TglRasterPos2s;
  glRasterPos2sv: TglRasterPos2sv;
  glRasterPos2xOES: TglRasterPos2xOES;
  glRasterPos2xvOES: TglRasterPos2xvOES;
  glRasterPos3d: TglRasterPos3d;
  glRasterPos3dv: TglRasterPos3dv;
  glRasterPos3f: TglRasterPos3f;
  glRasterPos3fv: TglRasterPos3fv;
  glRasterPos3i: TglRasterPos3i;
  glRasterPos3iv: TglRasterPos3iv;
  glRasterPos3s: TglRasterPos3s;
  glRasterPos3sv: TglRasterPos3sv;
  glRasterPos3xOES: TglRasterPos3xOES;
  glRasterPos3xvOES: TglRasterPos3xvOES;
  glRasterPos4d: TglRasterPos4d;
  glRasterPos4dv: TglRasterPos4dv;
  glRasterPos4f: TglRasterPos4f;
  glRasterPos4fv: TglRasterPos4fv;
  glRasterPos4i: TglRasterPos4i;
  glRasterPos4iv: TglRasterPos4iv;
  glRasterPos4s: TglRasterPos4s;
  glRasterPos4sv: TglRasterPos4sv;
  glRasterPos4xOES: TglRasterPos4xOES;
  glRasterPos4xvOES: TglRasterPos4xvOES;
  glRasterSamplesEXT: TglRasterSamplesEXT;
  glReadBuffer: TglReadBuffer;
  glReadBufferIndexedEXT: TglReadBufferIndexedEXT;
  glReadBufferNV: TglReadBufferNV;
  glReadInstrumentsSGIX: TglReadInstrumentsSGIX;
  glReadPixels: TglReadPixels;
  glReadnPixels: TglReadnPixels;
  glReadnPixelsARB: TglReadnPixelsARB;
  glReadnPixelsEXT: TglReadnPixelsEXT;
  glReadnPixelsKHR: TglReadnPixelsKHR;
  glReleaseKeyedMutexWin32EXT: TglReleaseKeyedMutexWin32EXT;
  glRectd: TglRectd;
  glRectdv: TglRectdv;
  glRectf: TglRectf;
  glRectfv: TglRectfv;
  glRecti: TglRecti;
  glRectiv: TglRectiv;
  glRects: TglRects;
  glRectsv: TglRectsv;
  glRectxOES: TglRectxOES;
  glRectxvOES: TglRectxvOES;
  glReferencePlaneSGIX: TglReferencePlaneSGIX;
  glReleaseShaderCompiler: TglReleaseShaderCompiler;
  glRenderGpuMaskNV: TglRenderGpuMaskNV;
  glRenderMode: TglRenderMode;
  glRenderbufferStorage: TglRenderbufferStorage;
  glRenderbufferStorageEXT: TglRenderbufferStorageEXT;
  glRenderbufferStorageMultisample: TglRenderbufferStorageMultisample;
  glRenderbufferStorageMultisampleANGLE: TglRenderbufferStorageMultisampleANGLE;
  glRenderbufferStorageMultisampleAPPLE: TglRenderbufferStorageMultisampleAPPLE;
  glRenderbufferStorageMultisampleCoverageNV: TglRenderbufferStorageMultisampleCoverageNV;
  glRenderbufferStorageMultisampleEXT: TglRenderbufferStorageMultisampleEXT;
  glRenderbufferStorageMultisampleIMG: TglRenderbufferStorageMultisampleIMG;
  glRenderbufferStorageMultisampleNV: TglRenderbufferStorageMultisampleNV;
  glRenderbufferStorageOES: TglRenderbufferStorageOES;
  glReplacementCodePointerSUN: TglReplacementCodePointerSUN;
  glReplacementCodeubSUN: TglReplacementCodeubSUN;
  glReplacementCodeubvSUN: TglReplacementCodeubvSUN;
  glReplacementCodeuiColor3fVertex3fSUN: TglReplacementCodeuiColor3fVertex3fSUN;
  glReplacementCodeuiColor3fVertex3fvSUN: TglReplacementCodeuiColor3fVertex3fvSUN;
  glReplacementCodeuiColor4fNormal3fVertex3fSUN: TglReplacementCodeuiColor4fNormal3fVertex3fSUN;
  glReplacementCodeuiColor4fNormal3fVertex3fvSUN: TglReplacementCodeuiColor4fNormal3fVertex3fvSUN;
  glReplacementCodeuiColor4ubVertex3fSUN: TglReplacementCodeuiColor4ubVertex3fSUN;
  glReplacementCodeuiColor4ubVertex3fvSUN: TglReplacementCodeuiColor4ubVertex3fvSUN;
  glReplacementCodeuiNormal3fVertex3fSUN: TglReplacementCodeuiNormal3fVertex3fSUN;
  glReplacementCodeuiNormal3fVertex3fvSUN: TglReplacementCodeuiNormal3fVertex3fvSUN;
  glReplacementCodeuiSUN: TglReplacementCodeuiSUN;
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN: TglReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fSUN;
  glReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN: TglReplacementCodeuiTexCoord2fColor4fNormal3fVertex3fvSUN;
  glReplacementCodeuiTexCoord2fNormal3fVertex3fSUN: TglReplacementCodeuiTexCoord2fNormal3fVertex3fSUN;
  glReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN: TglReplacementCodeuiTexCoord2fNormal3fVertex3fvSUN;
  glReplacementCodeuiTexCoord2fVertex3fSUN: TglReplacementCodeuiTexCoord2fVertex3fSUN;
  glReplacementCodeuiTexCoord2fVertex3fvSUN: TglReplacementCodeuiTexCoord2fVertex3fvSUN;
  glReplacementCodeuiVertex3fSUN: TglReplacementCodeuiVertex3fSUN;
  glReplacementCodeuiVertex3fvSUN: TglReplacementCodeuiVertex3fvSUN;
  glReplacementCodeuivSUN: TglReplacementCodeuivSUN;
  glReplacementCodeusSUN: TglReplacementCodeusSUN;
  glReplacementCodeusvSUN: TglReplacementCodeusvSUN;
  glRequestResidentProgramsNV: TglRequestResidentProgramsNV;
  glResetHistogram: TglResetHistogram;
  glResetHistogramEXT: TglResetHistogramEXT;
  glResetMinmax: TglResetMinmax;
  glResetMinmaxEXT: TglResetMinmaxEXT;
  glResizeBuffersMESA: TglResizeBuffersMESA;
  glResolveDepthValuesNV: TglResolveDepthValuesNV;
  glResolveMultisampleFramebufferAPPLE: TglResolveMultisampleFramebufferAPPLE;
  glResumeTransformFeedback: TglResumeTransformFeedback;
  glResumeTransformFeedbackNV: TglResumeTransformFeedbackNV;
  glRotated: TglRotated;
  glRotatef: TglRotatef;
  glRotatex: TglRotatex;
  glRotatexOES: TglRotatexOES;
  glSampleCoverage: TglSampleCoverage;
  glSampleCoverageARB: TglSampleCoverageARB;
  glSampleCoveragex: TglSampleCoveragex;
  glSampleCoveragexOES: TglSampleCoveragexOES;
  glSampleMapATI: TglSampleMapATI;
  glSampleMaskEXT: TglSampleMaskEXT;
  glSampleMaskIndexedNV: TglSampleMaskIndexedNV;
  glSampleMaskSGIS: TglSampleMaskSGIS;
  glSampleMaski: TglSampleMaski;
  glSamplePatternEXT: TglSamplePatternEXT;
  glSamplePatternSGIS: TglSamplePatternSGIS;
  glSamplerParameterIiv: TglSamplerParameterIiv;
  glSamplerParameterIivEXT: TglSamplerParameterIivEXT;
  glSamplerParameterIivOES: TglSamplerParameterIivOES;
  glSamplerParameterIuiv: TglSamplerParameterIuiv;
  glSamplerParameterIuivEXT: TglSamplerParameterIuivEXT;
  glSamplerParameterIuivOES: TglSamplerParameterIuivOES;
  glSamplerParameterf: TglSamplerParameterf;
  glSamplerParameterfv: TglSamplerParameterfv;
  glSamplerParameteri: TglSamplerParameteri;
  glSamplerParameteriv: TglSamplerParameteriv;
  glScaled: TglScaled;
  glScalef: TglScalef;
  glScalex: TglScalex;
  glScalexOES: TglScalexOES;
  glScissor: TglScissor;
  glScissorArrayv: TglScissorArrayv;
  glScissorArrayvNV: TglScissorArrayvNV;
  glScissorArrayvOES: TglScissorArrayvOES;
  glScissorIndexed: TglScissorIndexed;
  glScissorIndexedNV: TglScissorIndexedNV;
  glScissorIndexedOES: TglScissorIndexedOES;
  glScissorIndexedv: TglScissorIndexedv;
  glScissorIndexedvNV: TglScissorIndexedvNV;
  glScissorIndexedvOES: TglScissorIndexedvOES;
  glSecondaryColor3b: TglSecondaryColor3b;
  glSecondaryColor3bEXT: TglSecondaryColor3bEXT;
  glSecondaryColor3bv: TglSecondaryColor3bv;
  glSecondaryColor3bvEXT: TglSecondaryColor3bvEXT;
  glSecondaryColor3d: TglSecondaryColor3d;
  glSecondaryColor3dEXT: TglSecondaryColor3dEXT;
  glSecondaryColor3dv: TglSecondaryColor3dv;
  glSecondaryColor3dvEXT: TglSecondaryColor3dvEXT;
  glSecondaryColor3f: TglSecondaryColor3f;
  glSecondaryColor3fEXT: TglSecondaryColor3fEXT;
  glSecondaryColor3fv: TglSecondaryColor3fv;
  glSecondaryColor3fvEXT: TglSecondaryColor3fvEXT;
  glSecondaryColor3hNV: TglSecondaryColor3hNV;
  glSecondaryColor3hvNV: TglSecondaryColor3hvNV;
  glSecondaryColor3i: TglSecondaryColor3i;
  glSecondaryColor3iEXT: TglSecondaryColor3iEXT;
  glSecondaryColor3iv: TglSecondaryColor3iv;
  glSecondaryColor3ivEXT: TglSecondaryColor3ivEXT;
  glSecondaryColor3s: TglSecondaryColor3s;
  glSecondaryColor3sEXT: TglSecondaryColor3sEXT;
  glSecondaryColor3sv: TglSecondaryColor3sv;
  glSecondaryColor3svEXT: TglSecondaryColor3svEXT;
  glSecondaryColor3ub: TglSecondaryColor3ub;
  glSecondaryColor3ubEXT: TglSecondaryColor3ubEXT;
  glSecondaryColor3ubv: TglSecondaryColor3ubv;
  glSecondaryColor3ubvEXT: TglSecondaryColor3ubvEXT;
  glSecondaryColor3ui: TglSecondaryColor3ui;
  glSecondaryColor3uiEXT: TglSecondaryColor3uiEXT;
  glSecondaryColor3uiv: TglSecondaryColor3uiv;
  glSecondaryColor3uivEXT: TglSecondaryColor3uivEXT;
  glSecondaryColor3us: TglSecondaryColor3us;
  glSecondaryColor3usEXT: TglSecondaryColor3usEXT;
  glSecondaryColor3usv: TglSecondaryColor3usv;
  glSecondaryColor3usvEXT: TglSecondaryColor3usvEXT;
  glSecondaryColorFormatNV: TglSecondaryColorFormatNV;
  glSecondaryColorP3ui: TglSecondaryColorP3ui;
  glSecondaryColorP3uiv: TglSecondaryColorP3uiv;
  glSecondaryColorPointer: TglSecondaryColorPointer;
  glSecondaryColorPointerEXT: TglSecondaryColorPointerEXT;
  glSecondaryColorPointerListIBM: TglSecondaryColorPointerListIBM;
  glSelectBuffer: TglSelectBuffer;
  glSelectPerfMonitorCountersAMD: TglSelectPerfMonitorCountersAMD;
  glSemaphoreParameterui64vEXT: TglSemaphoreParameterui64vEXT;
  glSeparableFilter2D: TglSeparableFilter2D;
  glSeparableFilter2DEXT: TglSeparableFilter2DEXT;
  glSetFenceAPPLE: TglSetFenceAPPLE;
  glSetFenceNV: TglSetFenceNV;
  glSetFragmentShaderConstantATI: TglSetFragmentShaderConstantATI;
  glSetInvariantEXT: TglSetInvariantEXT;
  glSetLocalConstantEXT: TglSetLocalConstantEXT;
  glSetMultisamplefvAMD: TglSetMultisamplefvAMD;
  glShadeModel: TglShadeModel;
  glShaderBinary: TglShaderBinary;
  glShaderOp1EXT: TglShaderOp1EXT;
  glShaderOp2EXT: TglShaderOp2EXT;
  glShaderOp3EXT: TglShaderOp3EXT;
  glShaderSource: TglShaderSource;
  glShaderSourceARB: TglShaderSourceARB;
  glShaderStorageBlockBinding: TglShaderStorageBlockBinding;
  glSharpenTexFuncSGIS: TglSharpenTexFuncSGIS;
  glSignalSemaphoreEXT: TglSignalSemaphoreEXT;
  glSpecializeShader: TglSpecializeShader;
  glSpecializeShaderARB: TglSpecializeShaderARB;
  glSpriteParameterfSGIX: TglSpriteParameterfSGIX;
  glSpriteParameterfvSGIX: TglSpriteParameterfvSGIX;
  glSpriteParameteriSGIX: TglSpriteParameteriSGIX;
  glSpriteParameterivSGIX: TglSpriteParameterivSGIX;
  glStartInstrumentsSGIX: TglStartInstrumentsSGIX;
  glStartTilingQCOM: TglStartTilingQCOM;
  glStateCaptureNV: TglStateCaptureNV;
  glStencilClearTagEXT: TglStencilClearTagEXT;
  glStencilFillPathInstancedNV: TglStencilFillPathInstancedNV;
  glStencilFillPathNV: TglStencilFillPathNV;
  glStencilFunc: TglStencilFunc;
  glStencilFuncSeparate: TglStencilFuncSeparate;
  glStencilFuncSeparateATI: TglStencilFuncSeparateATI;
  glStencilMask: TglStencilMask;
  glStencilMaskSeparate: TglStencilMaskSeparate;
  glStencilOp: TglStencilOp;
  glStencilOpSeparate: TglStencilOpSeparate;
  glStencilOpSeparateATI: TglStencilOpSeparateATI;
  glStencilOpValueAMD: TglStencilOpValueAMD;
  glStencilStrokePathInstancedNV: TglStencilStrokePathInstancedNV;
  glStencilStrokePathNV: TglStencilStrokePathNV;
  glStencilThenCoverFillPathInstancedNV: TglStencilThenCoverFillPathInstancedNV;
  glStencilThenCoverFillPathNV: TglStencilThenCoverFillPathNV;
  glStencilThenCoverStrokePathInstancedNV: TglStencilThenCoverStrokePathInstancedNV;
  glStencilThenCoverStrokePathNV: TglStencilThenCoverStrokePathNV;
  glStopInstrumentsSGIX: TglStopInstrumentsSGIX;
  glStringMarkerGREMEDY: TglStringMarkerGREMEDY;
  glSubpixelPrecisionBiasNV: TglSubpixelPrecisionBiasNV;
  glSwizzleEXT: TglSwizzleEXT;
  glSyncTextureINTEL: TglSyncTextureINTEL;
  glTagSampleBufferSGIX: TglTagSampleBufferSGIX;
  glTangent3bEXT: TglTangent3bEXT;
  glTangent3bvEXT: TglTangent3bvEXT;
  glTangent3dEXT: TglTangent3dEXT;
  glTangent3dvEXT: TglTangent3dvEXT;
  glTangent3fEXT: TglTangent3fEXT;
  glTangent3fvEXT: TglTangent3fvEXT;
  glTangent3iEXT: TglTangent3iEXT;
  glTangent3ivEXT: TglTangent3ivEXT;
  glTangent3sEXT: TglTangent3sEXT;
  glTangent3svEXT: TglTangent3svEXT;
  glTangentPointerEXT: TglTangentPointerEXT;
  glTbufferMask3DFX: TglTbufferMask3DFX;
  glTessellationFactorAMD: TglTessellationFactorAMD;
  glTessellationModeAMD: TglTessellationModeAMD;
  glTestFenceAPPLE: TglTestFenceAPPLE;
  glTestFenceNV: TglTestFenceNV;
  glTestObjectAPPLE: TglTestObjectAPPLE;
  glTexBuffer: TglTexBuffer;
  glTexBufferARB: TglTexBufferARB;
  glTexBufferEXT: TglTexBufferEXT;
  glTexBufferOES: TglTexBufferOES;
  glTexBufferRange: TglTexBufferRange;
  glTexBufferRangeEXT: TglTexBufferRangeEXT;
  glTexBufferRangeOES: TglTexBufferRangeOES;
  glTexBumpParameterfvATI: TglTexBumpParameterfvATI;
  glTexBumpParameterivATI: TglTexBumpParameterivATI;
  glTexCoord1bOES: TglTexCoord1bOES;
  glTexCoord1bvOES: TglTexCoord1bvOES;
  glTexCoord1d: TglTexCoord1d;
  glTexCoord1dv: TglTexCoord1dv;
  glTexCoord1f: TglTexCoord1f;
  glTexCoord1fv: TglTexCoord1fv;
  glTexCoord1hNV: TglTexCoord1hNV;
  glTexCoord1hvNV: TglTexCoord1hvNV;
  glTexCoord1i: TglTexCoord1i;
  glTexCoord1iv: TglTexCoord1iv;
  glTexCoord1s: TglTexCoord1s;
  glTexCoord1sv: TglTexCoord1sv;
  glTexCoord1xOES: TglTexCoord1xOES;
  glTexCoord1xvOES: TglTexCoord1xvOES;
  glTexCoord2bOES: TglTexCoord2bOES;
  glTexCoord2bvOES: TglTexCoord2bvOES;
  glTexCoord2d: TglTexCoord2d;
  glTexCoord2dv: TglTexCoord2dv;
  glTexCoord2f: TglTexCoord2f;
  glTexCoord2fColor3fVertex3fSUN: TglTexCoord2fColor3fVertex3fSUN;
  glTexCoord2fColor3fVertex3fvSUN: TglTexCoord2fColor3fVertex3fvSUN;
  glTexCoord2fColor4fNormal3fVertex3fSUN: TglTexCoord2fColor4fNormal3fVertex3fSUN;
  glTexCoord2fColor4fNormal3fVertex3fvSUN: TglTexCoord2fColor4fNormal3fVertex3fvSUN;
  glTexCoord2fColor4ubVertex3fSUN: TglTexCoord2fColor4ubVertex3fSUN;
  glTexCoord2fColor4ubVertex3fvSUN: TglTexCoord2fColor4ubVertex3fvSUN;
  glTexCoord2fNormal3fVertex3fSUN: TglTexCoord2fNormal3fVertex3fSUN;
  glTexCoord2fNormal3fVertex3fvSUN: TglTexCoord2fNormal3fVertex3fvSUN;
  glTexCoord2fVertex3fSUN: TglTexCoord2fVertex3fSUN;
  glTexCoord2fVertex3fvSUN: TglTexCoord2fVertex3fvSUN;
  glTexCoord2fv: TglTexCoord2fv;
  glTexCoord2hNV: TglTexCoord2hNV;
  glTexCoord2hvNV: TglTexCoord2hvNV;
  glTexCoord2i: TglTexCoord2i;
  glTexCoord2iv: TglTexCoord2iv;
  glTexCoord2s: TglTexCoord2s;
  glTexCoord2sv: TglTexCoord2sv;
  glTexCoord2xOES: TglTexCoord2xOES;
  glTexCoord2xvOES: TglTexCoord2xvOES;
  glTexCoord3bOES: TglTexCoord3bOES;
  glTexCoord3bvOES: TglTexCoord3bvOES;
  glTexCoord3d: TglTexCoord3d;
  glTexCoord3dv: TglTexCoord3dv;
  glTexCoord3f: TglTexCoord3f;
  glTexCoord3fv: TglTexCoord3fv;
  glTexCoord3hNV: TglTexCoord3hNV;
  glTexCoord3hvNV: TglTexCoord3hvNV;
  glTexCoord3i: TglTexCoord3i;
  glTexCoord3iv: TglTexCoord3iv;
  glTexCoord3s: TglTexCoord3s;
  glTexCoord3sv: TglTexCoord3sv;
  glTexCoord3xOES: TglTexCoord3xOES;
  glTexCoord3xvOES: TglTexCoord3xvOES;
  glTexCoord4bOES: TglTexCoord4bOES;
  glTexCoord4bvOES: TglTexCoord4bvOES;
  glTexCoord4d: TglTexCoord4d;
  glTexCoord4dv: TglTexCoord4dv;
  glTexCoord4f: TglTexCoord4f;
  glTexCoord4fColor4fNormal3fVertex4fSUN: TglTexCoord4fColor4fNormal3fVertex4fSUN;
  glTexCoord4fColor4fNormal3fVertex4fvSUN: TglTexCoord4fColor4fNormal3fVertex4fvSUN;
  glTexCoord4fVertex4fSUN: TglTexCoord4fVertex4fSUN;
  glTexCoord4fVertex4fvSUN: TglTexCoord4fVertex4fvSUN;
  glTexCoord4fv: TglTexCoord4fv;
  glTexCoord4hNV: TglTexCoord4hNV;
  glTexCoord4hvNV: TglTexCoord4hvNV;
  glTexCoord4i: TglTexCoord4i;
  glTexCoord4iv: TglTexCoord4iv;
  glTexCoord4s: TglTexCoord4s;
  glTexCoord4sv: TglTexCoord4sv;
  glTexCoord4xOES: TglTexCoord4xOES;
  glTexCoord4xvOES: TglTexCoord4xvOES;
  glTexCoordFormatNV: TglTexCoordFormatNV;
  glTexCoordP1ui: TglTexCoordP1ui;
  glTexCoordP1uiv: TglTexCoordP1uiv;
  glTexCoordP2ui: TglTexCoordP2ui;
  glTexCoordP2uiv: TglTexCoordP2uiv;
  glTexCoordP3ui: TglTexCoordP3ui;
  glTexCoordP3uiv: TglTexCoordP3uiv;
  glTexCoordP4ui: TglTexCoordP4ui;
  glTexCoordP4uiv: TglTexCoordP4uiv;
  glTexCoordPointer: TglTexCoordPointer;
  glTexCoordPointerEXT: TglTexCoordPointerEXT;
  glTexCoordPointerListIBM: TglTexCoordPointerListIBM;
  glTexCoordPointervINTEL: TglTexCoordPointervINTEL;
  glTexEnvf: TglTexEnvf;
  glTexEnvfv: TglTexEnvfv;
  glTexEnvi: TglTexEnvi;
  glTexEnviv: TglTexEnviv;
  glTexEnvx: TglTexEnvx;
  glTexEnvxOES: TglTexEnvxOES;
  glTexEnvxv: TglTexEnvxv;
  glTexEnvxvOES: TglTexEnvxvOES;
  glTexFilterFuncSGIS: TglTexFilterFuncSGIS;
  glTexGend: TglTexGend;
  glTexGendv: TglTexGendv;
  glTexGenf: TglTexGenf;
  glTexGenfOES: TglTexGenfOES;
  glTexGenfv: TglTexGenfv;
  glTexGenfvOES: TglTexGenfvOES;
  glTexGeni: TglTexGeni;
  glTexGeniOES: TglTexGeniOES;
  glTexGeniv: TglTexGeniv;
  glTexGenivOES: TglTexGenivOES;
  glTexGenxOES: TglTexGenxOES;
  glTexGenxvOES: TglTexGenxvOES;
  glTexImage1D: TglTexImage1D;
  glTexImage2D: TglTexImage2D;
  glTexImage2DMultisample: TglTexImage2DMultisample;
  glTexImage2DMultisampleCoverageNV: TglTexImage2DMultisampleCoverageNV;
  glTexImage3D: TglTexImage3D;
  glTexImage3DEXT: TglTexImage3DEXT;
  glTexImage3DMultisample: TglTexImage3DMultisample;
  glTexImage3DMultisampleCoverageNV: TglTexImage3DMultisampleCoverageNV;
  glTexImage3DOES: TglTexImage3DOES;
  glTexImage4DSGIS: TglTexImage4DSGIS;
  glTexPageCommitmentARB: TglTexPageCommitmentARB;
  glTexPageCommitmentEXT: TglTexPageCommitmentEXT;
  glTexParameterIiv: TglTexParameterIiv;
  glTexParameterIivEXT: TglTexParameterIivEXT;
  glTexParameterIivOES: TglTexParameterIivOES;
  glTexParameterIuiv: TglTexParameterIuiv;
  glTexParameterIuivEXT: TglTexParameterIuivEXT;
  glTexParameterIuivOES: TglTexParameterIuivOES;
  glTexParameterf: TglTexParameterf;
  glTexParameterfv: TglTexParameterfv;
  glTexParameteri: TglTexParameteri;
  glTexParameteriv: TglTexParameteriv;
  glTexParameterx: TglTexParameterx;
  glTexParameterxOES: TglTexParameterxOES;
  glTexParameterxv: TglTexParameterxv;
  glTexParameterxvOES: TglTexParameterxvOES;
  glTexRenderbufferNV: TglTexRenderbufferNV;
  glTexStorage1D: TglTexStorage1D;
  glTexStorage1DEXT: TglTexStorage1DEXT;
  glTexStorage2D: TglTexStorage2D;
  glTexStorage2DEXT: TglTexStorage2DEXT;
  glTexStorage2DMultisample: TglTexStorage2DMultisample;
  glTexStorage3D: TglTexStorage3D;
  glTexStorage3DEXT: TglTexStorage3DEXT;
  glTexStorage3DMultisample: TglTexStorage3DMultisample;
  glTexStorage3DMultisampleOES: TglTexStorage3DMultisampleOES;
  glTexStorageMem1DEXT: TglTexStorageMem1DEXT;
  glTexStorageMem2DEXT: TglTexStorageMem2DEXT;
  glTexStorageMem2DMultisampleEXT: TglTexStorageMem2DMultisampleEXT;
  glTexStorageMem3DEXT: TglTexStorageMem3DEXT;
  glTexStorageMem3DMultisampleEXT: TglTexStorageMem3DMultisampleEXT;
  glTexStorageSparseAMD: TglTexStorageSparseAMD;
  glTexSubImage1D: TglTexSubImage1D;
  glTexSubImage1DEXT: TglTexSubImage1DEXT;
  glTexSubImage2D: TglTexSubImage2D;
  glTexSubImage2DEXT: TglTexSubImage2DEXT;
  glTexSubImage3D: TglTexSubImage3D;
  glTexSubImage3DEXT: TglTexSubImage3DEXT;
  glTexSubImage3DOES: TglTexSubImage3DOES;
  glTexSubImage4DSGIS: TglTexSubImage4DSGIS;
  glTextureBarrier: TglTextureBarrier;
  glTextureBarrierNV: TglTextureBarrierNV;
  glTextureBuffer: TglTextureBuffer;
  glTextureBufferEXT: TglTextureBufferEXT;
  glTextureBufferRange: TglTextureBufferRange;
  glTextureBufferRangeEXT: TglTextureBufferRangeEXT;
  glTextureColorMaskSGIS: TglTextureColorMaskSGIS;
  glTextureImage1DEXT: TglTextureImage1DEXT;
  glTextureImage2DEXT: TglTextureImage2DEXT;
  glTextureImage2DMultisampleCoverageNV: TglTextureImage2DMultisampleCoverageNV;
  glTextureImage2DMultisampleNV: TglTextureImage2DMultisampleNV;
  glTextureImage3DEXT: TglTextureImage3DEXT;
  glTextureImage3DMultisampleCoverageNV: TglTextureImage3DMultisampleCoverageNV;
  glTextureImage3DMultisampleNV: TglTextureImage3DMultisampleNV;
  glTextureLightEXT: TglTextureLightEXT;
  glTextureMaterialEXT: TglTextureMaterialEXT;
  glTextureNormalEXT: TglTextureNormalEXT;
  glTexturePageCommitmentEXT: TglTexturePageCommitmentEXT;
  glTextureParameterIiv: TglTextureParameterIiv;
  glTextureParameterIivEXT: TglTextureParameterIivEXT;
  glTextureParameterIuiv: TglTextureParameterIuiv;
  glTextureParameterIuivEXT: TglTextureParameterIuivEXT;
  glTextureParameterf: TglTextureParameterf;
  glTextureParameterfEXT: TglTextureParameterfEXT;
  glTextureParameterfv: TglTextureParameterfv;
  glTextureParameterfvEXT: TglTextureParameterfvEXT;
  glTextureParameteri: TglTextureParameteri;
  glTextureParameteriEXT: TglTextureParameteriEXT;
  glTextureParameteriv: TglTextureParameteriv;
  glTextureParameterivEXT: TglTextureParameterivEXT;
  glTextureRangeAPPLE: TglTextureRangeAPPLE;
  glTextureRenderbufferEXT: TglTextureRenderbufferEXT;
  glTextureStorage1D: TglTextureStorage1D;
  glTextureStorage1DEXT: TglTextureStorage1DEXT;
  glTextureStorage2D: TglTextureStorage2D;
  glTextureStorage2DEXT: TglTextureStorage2DEXT;
  glTextureStorage2DMultisample: TglTextureStorage2DMultisample;
  glTextureStorage2DMultisampleEXT: TglTextureStorage2DMultisampleEXT;
  glTextureStorage3D: TglTextureStorage3D;
  glTextureStorage3DEXT: TglTextureStorage3DEXT;
  glTextureStorage3DMultisample: TglTextureStorage3DMultisample;
  glTextureStorage3DMultisampleEXT: TglTextureStorage3DMultisampleEXT;
  glTextureStorageMem1DEXT: TglTextureStorageMem1DEXT;
  glTextureStorageMem2DEXT: TglTextureStorageMem2DEXT;
  glTextureStorageMem2DMultisampleEXT: TglTextureStorageMem2DMultisampleEXT;
  glTextureStorageMem3DEXT: TglTextureStorageMem3DEXT;
  glTextureStorageMem3DMultisampleEXT: TglTextureStorageMem3DMultisampleEXT;
  glTextureStorageSparseAMD: TglTextureStorageSparseAMD;
  glTextureSubImage1D: TglTextureSubImage1D;
  glTextureSubImage1DEXT: TglTextureSubImage1DEXT;
  glTextureSubImage2D: TglTextureSubImage2D;
  glTextureSubImage2DEXT: TglTextureSubImage2DEXT;
  glTextureSubImage3D: TglTextureSubImage3D;
  glTextureSubImage3DEXT: TglTextureSubImage3DEXT;
  glTextureView: TglTextureView;
  glTextureViewEXT: TglTextureViewEXT;
  glTextureViewOES: TglTextureViewOES;
  glTrackMatrixNV: TglTrackMatrixNV;
  glTransformFeedbackAttribsNV: TglTransformFeedbackAttribsNV;
  glTransformFeedbackBufferBase: TglTransformFeedbackBufferBase;
  glTransformFeedbackBufferRange: TglTransformFeedbackBufferRange;
  glTransformFeedbackStreamAttribsNV: TglTransformFeedbackStreamAttribsNV;
  glTransformFeedbackVaryings: TglTransformFeedbackVaryings;
  glTransformFeedbackVaryingsEXT: TglTransformFeedbackVaryingsEXT;
  glTransformFeedbackVaryingsNV: TglTransformFeedbackVaryingsNV;
  glTransformPathNV: TglTransformPathNV;
  glTranslated: TglTranslated;
  glTranslatef: TglTranslatef;
  glTranslatex: TglTranslatex;
  glTranslatexOES: TglTranslatexOES;
  glUniform1d: TglUniform1d;
  glUniform1dv: TglUniform1dv;
  glUniform1f: TglUniform1f;
  glUniform1fARB: TglUniform1fARB;
  glUniform1fv: TglUniform1fv;
  glUniform1fvARB: TglUniform1fvARB;
  glUniform1i: TglUniform1i;
  glUniform1i64ARB: TglUniform1i64ARB;
  glUniform1i64NV: TglUniform1i64NV;
  glUniform1i64vARB: TglUniform1i64vARB;
  glUniform1i64vNV: TglUniform1i64vNV;
  glUniform1iARB: TglUniform1iARB;
  glUniform1iv: TglUniform1iv;
  glUniform1ivARB: TglUniform1ivARB;
  glUniform1ui: TglUniform1ui;
  glUniform1ui64ARB: TglUniform1ui64ARB;
  glUniform1ui64NV: TglUniform1ui64NV;
  glUniform1ui64vARB: TglUniform1ui64vARB;
  glUniform1ui64vNV: TglUniform1ui64vNV;
  glUniform1uiEXT: TglUniform1uiEXT;
  glUniform1uiv: TglUniform1uiv;
  glUniform1uivEXT: TglUniform1uivEXT;
  glUniform2d: TglUniform2d;
  glUniform2dv: TglUniform2dv;
  glUniform2f: TglUniform2f;
  glUniform2fARB: TglUniform2fARB;
  glUniform2fv: TglUniform2fv;
  glUniform2fvARB: TglUniform2fvARB;
  glUniform2i: TglUniform2i;
  glUniform2i64ARB: TglUniform2i64ARB;
  glUniform2i64NV: TglUniform2i64NV;
  glUniform2i64vARB: TglUniform2i64vARB;
  glUniform2i64vNV: TglUniform2i64vNV;
  glUniform2iARB: TglUniform2iARB;
  glUniform2iv: TglUniform2iv;
  glUniform2ivARB: TglUniform2ivARB;
  glUniform2ui: TglUniform2ui;
  glUniform2ui64ARB: TglUniform2ui64ARB;
  glUniform2ui64NV: TglUniform2ui64NV;
  glUniform2ui64vARB: TglUniform2ui64vARB;
  glUniform2ui64vNV: TglUniform2ui64vNV;
  glUniform2uiEXT: TglUniform2uiEXT;
  glUniform2uiv: TglUniform2uiv;
  glUniform2uivEXT: TglUniform2uivEXT;
  glUniform3d: TglUniform3d;
  glUniform3dv: TglUniform3dv;
  glUniform3f: TglUniform3f;
  glUniform3fARB: TglUniform3fARB;
  glUniform3fv: TglUniform3fv;
  glUniform3fvARB: TglUniform3fvARB;
  glUniform3i: TglUniform3i;
  glUniform3i64ARB: TglUniform3i64ARB;
  glUniform3i64NV: TglUniform3i64NV;
  glUniform3i64vARB: TglUniform3i64vARB;
  glUniform3i64vNV: TglUniform3i64vNV;
  glUniform3iARB: TglUniform3iARB;
  glUniform3iv: TglUniform3iv;
  glUniform3ivARB: TglUniform3ivARB;
  glUniform3ui: TglUniform3ui;
  glUniform3ui64ARB: TglUniform3ui64ARB;
  glUniform3ui64NV: TglUniform3ui64NV;
  glUniform3ui64vARB: TglUniform3ui64vARB;
  glUniform3ui64vNV: TglUniform3ui64vNV;
  glUniform3uiEXT: TglUniform3uiEXT;
  glUniform3uiv: TglUniform3uiv;
  glUniform3uivEXT: TglUniform3uivEXT;
  glUniform4d: TglUniform4d;
  glUniform4dv: TglUniform4dv;
  glUniform4f: TglUniform4f;
  glUniform4fARB: TglUniform4fARB;
  glUniform4fv: TglUniform4fv;
  glUniform4fvARB: TglUniform4fvARB;
  glUniform4i: TglUniform4i;
  glUniform4i64ARB: TglUniform4i64ARB;
  glUniform4i64NV: TglUniform4i64NV;
  glUniform4i64vARB: TglUniform4i64vARB;
  glUniform4i64vNV: TglUniform4i64vNV;
  glUniform4iARB: TglUniform4iARB;
  glUniform4iv: TglUniform4iv;
  glUniform4ivARB: TglUniform4ivARB;
  glUniform4ui: TglUniform4ui;
  glUniform4ui64ARB: TglUniform4ui64ARB;
  glUniform4ui64NV: TglUniform4ui64NV;
  glUniform4ui64vARB: TglUniform4ui64vARB;
  glUniform4ui64vNV: TglUniform4ui64vNV;
  glUniform4uiEXT: TglUniform4uiEXT;
  glUniform4uiv: TglUniform4uiv;
  glUniform4uivEXT: TglUniform4uivEXT;
  glUniformBlockBinding: TglUniformBlockBinding;
  glUniformBufferEXT: TglUniformBufferEXT;
  glUniformHandleui64ARB: TglUniformHandleui64ARB;
  glUniformHandleui64IMG: TglUniformHandleui64IMG;
  glUniformHandleui64NV: TglUniformHandleui64NV;
  glUniformHandleui64vARB: TglUniformHandleui64vARB;
  glUniformHandleui64vIMG: TglUniformHandleui64vIMG;
  glUniformHandleui64vNV: TglUniformHandleui64vNV;
  glUniformMatrix2dv: TglUniformMatrix2dv;
  glUniformMatrix2fv: TglUniformMatrix2fv;
  glUniformMatrix2fvARB: TglUniformMatrix2fvARB;
  glUniformMatrix2x3dv: TglUniformMatrix2x3dv;
  glUniformMatrix2x3fv: TglUniformMatrix2x3fv;
  glUniformMatrix2x3fvNV: TglUniformMatrix2x3fvNV;
  glUniformMatrix2x4dv: TglUniformMatrix2x4dv;
  glUniformMatrix2x4fv: TglUniformMatrix2x4fv;
  glUniformMatrix2x4fvNV: TglUniformMatrix2x4fvNV;
  glUniformMatrix3dv: TglUniformMatrix3dv;
  glUniformMatrix3fv: TglUniformMatrix3fv;
  glUniformMatrix3fvARB: TglUniformMatrix3fvARB;
  glUniformMatrix3x2dv: TglUniformMatrix3x2dv;
  glUniformMatrix3x2fv: TglUniformMatrix3x2fv;
  glUniformMatrix3x2fvNV: TglUniformMatrix3x2fvNV;
  glUniformMatrix3x4dv: TglUniformMatrix3x4dv;
  glUniformMatrix3x4fv: TglUniformMatrix3x4fv;
  glUniformMatrix3x4fvNV: TglUniformMatrix3x4fvNV;
  glUniformMatrix4dv: TglUniformMatrix4dv;
  glUniformMatrix4fv: TglUniformMatrix4fv;
  glUniformMatrix4fvARB: TglUniformMatrix4fvARB;
  glUniformMatrix4x2dv: TglUniformMatrix4x2dv;
  glUniformMatrix4x2fv: TglUniformMatrix4x2fv;
  glUniformMatrix4x2fvNV: TglUniformMatrix4x2fvNV;
  glUniformMatrix4x3dv: TglUniformMatrix4x3dv;
  glUniformMatrix4x3fv: TglUniformMatrix4x3fv;
  glUniformMatrix4x3fvNV: TglUniformMatrix4x3fvNV;
  glUniformSubroutinesuiv: TglUniformSubroutinesuiv;
  glUniformui64NV: TglUniformui64NV;
  glUniformui64vNV: TglUniformui64vNV;
  glUnlockArraysEXT: TglUnlockArraysEXT;
  glUnmapBuffer: TglUnmapBuffer;
  glUnmapBufferARB: TglUnmapBufferARB;
  glUnmapBufferOES: TglUnmapBufferOES;
  glUnmapNamedBuffer: TglUnmapNamedBuffer;
  glUnmapNamedBufferEXT: TglUnmapNamedBufferEXT;
  glUnmapObjectBufferATI: TglUnmapObjectBufferATI;
  glUnmapTexture2DINTEL: TglUnmapTexture2DINTEL;
  glUpdateObjectBufferATI: TglUpdateObjectBufferATI;
  glUseProgram: TglUseProgram;
  glUseProgramObjectARB: TglUseProgramObjectARB;
  glUseProgramStages: TglUseProgramStages;
  glUseProgramStagesEXT: TglUseProgramStagesEXT;
  glUseShaderProgramEXT: TglUseShaderProgramEXT;
  glVDPAUFiniNV: TglVDPAUFiniNV;
  glVDPAUGetSurfaceivNV: TglVDPAUGetSurfaceivNV;
  glVDPAUInitNV: TglVDPAUInitNV;
  glVDPAUIsSurfaceNV: TglVDPAUIsSurfaceNV;
  glVDPAUMapSurfacesNV: TglVDPAUMapSurfacesNV;
  glVDPAURegisterOutputSurfaceNV: TglVDPAURegisterOutputSurfaceNV;
  glVDPAURegisterVideoSurfaceNV: TglVDPAURegisterVideoSurfaceNV;
  glVDPAUSurfaceAccessNV: TglVDPAUSurfaceAccessNV;
  glVDPAUUnmapSurfacesNV: TglVDPAUUnmapSurfacesNV;
  glVDPAUUnregisterSurfaceNV: TglVDPAUUnregisterSurfaceNV;
  glValidateProgram: TglValidateProgram;
  glValidateProgramARB: TglValidateProgramARB;
  glValidateProgramPipeline: TglValidateProgramPipeline;
  glValidateProgramPipelineEXT: TglValidateProgramPipelineEXT;
  glVariantArrayObjectATI: TglVariantArrayObjectATI;
  glVariantPointerEXT: TglVariantPointerEXT;
  glVariantbvEXT: TglVariantbvEXT;
  glVariantdvEXT: TglVariantdvEXT;
  glVariantfvEXT: TglVariantfvEXT;
  glVariantivEXT: TglVariantivEXT;
  glVariantsvEXT: TglVariantsvEXT;
  glVariantubvEXT: TglVariantubvEXT;
  glVariantuivEXT: TglVariantuivEXT;
  glVariantusvEXT: TglVariantusvEXT;
  glVertex2bOES: TglVertex2bOES;
  glVertex2bvOES: TglVertex2bvOES;
  glVertex2d: TglVertex2d;
  glVertex2dv: TglVertex2dv;
  glVertex2f: TglVertex2f;
  glVertex2fv: TglVertex2fv;
  glVertex2hNV: TglVertex2hNV;
  glVertex2hvNV: TglVertex2hvNV;
  glVertex2i: TglVertex2i;
  glVertex2iv: TglVertex2iv;
  glVertex2s: TglVertex2s;
  glVertex2sv: TglVertex2sv;
  glVertex2xOES: TglVertex2xOES;
  glVertex2xvOES: TglVertex2xvOES;
  glVertex3bOES: TglVertex3bOES;
  glVertex3bvOES: TglVertex3bvOES;
  glVertex3d: TglVertex3d;
  glVertex3dv: TglVertex3dv;
  glVertex3f: TglVertex3f;
  glVertex3fv: TglVertex3fv;
  glVertex3hNV: TglVertex3hNV;
  glVertex3hvNV: TglVertex3hvNV;
  glVertex3i: TglVertex3i;
  glVertex3iv: TglVertex3iv;
  glVertex3s: TglVertex3s;
  glVertex3sv: TglVertex3sv;
  glVertex3xOES: TglVertex3xOES;
  glVertex3xvOES: TglVertex3xvOES;
  glVertex4bOES: TglVertex4bOES;
  glVertex4bvOES: TglVertex4bvOES;
  glVertex4d: TglVertex4d;
  glVertex4dv: TglVertex4dv;
  glVertex4f: TglVertex4f;
  glVertex4fv: TglVertex4fv;
  glVertex4hNV: TglVertex4hNV;
  glVertex4hvNV: TglVertex4hvNV;
  glVertex4i: TglVertex4i;
  glVertex4iv: TglVertex4iv;
  glVertex4s: TglVertex4s;
  glVertex4sv: TglVertex4sv;
  glVertex4xOES: TglVertex4xOES;
  glVertex4xvOES: TglVertex4xvOES;
  glVertexArrayAttribBinding: TglVertexArrayAttribBinding;
  glVertexArrayAttribFormat: TglVertexArrayAttribFormat;
  glVertexArrayAttribIFormat: TglVertexArrayAttribIFormat;
  glVertexArrayAttribLFormat: TglVertexArrayAttribLFormat;
  glVertexArrayBindVertexBufferEXT: TglVertexArrayBindVertexBufferEXT;
  glVertexArrayBindingDivisor: TglVertexArrayBindingDivisor;
  glVertexArrayColorOffsetEXT: TglVertexArrayColorOffsetEXT;
  glVertexArrayEdgeFlagOffsetEXT: TglVertexArrayEdgeFlagOffsetEXT;
  glVertexArrayElementBuffer: TglVertexArrayElementBuffer;
  glVertexArrayFogCoordOffsetEXT: TglVertexArrayFogCoordOffsetEXT;
  glVertexArrayIndexOffsetEXT: TglVertexArrayIndexOffsetEXT;
  glVertexArrayMultiTexCoordOffsetEXT: TglVertexArrayMultiTexCoordOffsetEXT;
  glVertexArrayNormalOffsetEXT: TglVertexArrayNormalOffsetEXT;
  glVertexArrayParameteriAPPLE: TglVertexArrayParameteriAPPLE;
  glVertexArrayRangeAPPLE: TglVertexArrayRangeAPPLE;
  glVertexArrayRangeNV: TglVertexArrayRangeNV;
  glVertexArraySecondaryColorOffsetEXT: TglVertexArraySecondaryColorOffsetEXT;
  glVertexArrayTexCoordOffsetEXT: TglVertexArrayTexCoordOffsetEXT;
  glVertexArrayVertexAttribBindingEXT: TglVertexArrayVertexAttribBindingEXT;
  glVertexArrayVertexAttribDivisorEXT: TglVertexArrayVertexAttribDivisorEXT;
  glVertexArrayVertexAttribFormatEXT: TglVertexArrayVertexAttribFormatEXT;
  glVertexArrayVertexAttribIFormatEXT: TglVertexArrayVertexAttribIFormatEXT;
  glVertexArrayVertexAttribIOffsetEXT: TglVertexArrayVertexAttribIOffsetEXT;
  glVertexArrayVertexAttribLFormatEXT: TglVertexArrayVertexAttribLFormatEXT;
  glVertexArrayVertexAttribLOffsetEXT: TglVertexArrayVertexAttribLOffsetEXT;
  glVertexArrayVertexAttribOffsetEXT: TglVertexArrayVertexAttribOffsetEXT;
  glVertexArrayVertexBindingDivisorEXT: TglVertexArrayVertexBindingDivisorEXT;
  glVertexArrayVertexBuffer: TglVertexArrayVertexBuffer;
  glVertexArrayVertexBuffers: TglVertexArrayVertexBuffers;
  glVertexArrayVertexOffsetEXT: TglVertexArrayVertexOffsetEXT;
  glVertexAttrib1d: TglVertexAttrib1d;
  glVertexAttrib1dARB: TglVertexAttrib1dARB;
  glVertexAttrib1dNV: TglVertexAttrib1dNV;
  glVertexAttrib1dv: TglVertexAttrib1dv;
  glVertexAttrib1dvARB: TglVertexAttrib1dvARB;
  glVertexAttrib1dvNV: TglVertexAttrib1dvNV;
  glVertexAttrib1f: TglVertexAttrib1f;
  glVertexAttrib1fARB: TglVertexAttrib1fARB;
  glVertexAttrib1fNV: TglVertexAttrib1fNV;
  glVertexAttrib1fv: TglVertexAttrib1fv;
  glVertexAttrib1fvARB: TglVertexAttrib1fvARB;
  glVertexAttrib1fvNV: TglVertexAttrib1fvNV;
  glVertexAttrib1hNV: TglVertexAttrib1hNV;
  glVertexAttrib1hvNV: TglVertexAttrib1hvNV;
  glVertexAttrib1s: TglVertexAttrib1s;
  glVertexAttrib1sARB: TglVertexAttrib1sARB;
  glVertexAttrib1sNV: TglVertexAttrib1sNV;
  glVertexAttrib1sv: TglVertexAttrib1sv;
  glVertexAttrib1svARB: TglVertexAttrib1svARB;
  glVertexAttrib1svNV: TglVertexAttrib1svNV;
  glVertexAttrib2d: TglVertexAttrib2d;
  glVertexAttrib2dARB: TglVertexAttrib2dARB;
  glVertexAttrib2dNV: TglVertexAttrib2dNV;
  glVertexAttrib2dv: TglVertexAttrib2dv;
  glVertexAttrib2dvARB: TglVertexAttrib2dvARB;
  glVertexAttrib2dvNV: TglVertexAttrib2dvNV;
  glVertexAttrib2f: TglVertexAttrib2f;
  glVertexAttrib2fARB: TglVertexAttrib2fARB;
  glVertexAttrib2fNV: TglVertexAttrib2fNV;
  glVertexAttrib2fv: TglVertexAttrib2fv;
  glVertexAttrib2fvARB: TglVertexAttrib2fvARB;
  glVertexAttrib2fvNV: TglVertexAttrib2fvNV;
  glVertexAttrib2hNV: TglVertexAttrib2hNV;
  glVertexAttrib2hvNV: TglVertexAttrib2hvNV;
  glVertexAttrib2s: TglVertexAttrib2s;
  glVertexAttrib2sARB: TglVertexAttrib2sARB;
  glVertexAttrib2sNV: TglVertexAttrib2sNV;
  glVertexAttrib2sv: TglVertexAttrib2sv;
  glVertexAttrib2svARB: TglVertexAttrib2svARB;
  glVertexAttrib2svNV: TglVertexAttrib2svNV;
  glVertexAttrib3d: TglVertexAttrib3d;
  glVertexAttrib3dARB: TglVertexAttrib3dARB;
  glVertexAttrib3dNV: TglVertexAttrib3dNV;
  glVertexAttrib3dv: TglVertexAttrib3dv;
  glVertexAttrib3dvARB: TglVertexAttrib3dvARB;
  glVertexAttrib3dvNV: TglVertexAttrib3dvNV;
  glVertexAttrib3f: TglVertexAttrib3f;
  glVertexAttrib3fARB: TglVertexAttrib3fARB;
  glVertexAttrib3fNV: TglVertexAttrib3fNV;
  glVertexAttrib3fv: TglVertexAttrib3fv;
  glVertexAttrib3fvARB: TglVertexAttrib3fvARB;
  glVertexAttrib3fvNV: TglVertexAttrib3fvNV;
  glVertexAttrib3hNV: TglVertexAttrib3hNV;
  glVertexAttrib3hvNV: TglVertexAttrib3hvNV;
  glVertexAttrib3s: TglVertexAttrib3s;
  glVertexAttrib3sARB: TglVertexAttrib3sARB;
  glVertexAttrib3sNV: TglVertexAttrib3sNV;
  glVertexAttrib3sv: TglVertexAttrib3sv;
  glVertexAttrib3svARB: TglVertexAttrib3svARB;
  glVertexAttrib3svNV: TglVertexAttrib3svNV;
  glVertexAttrib4Nbv: TglVertexAttrib4Nbv;
  glVertexAttrib4NbvARB: TglVertexAttrib4NbvARB;
  glVertexAttrib4Niv: TglVertexAttrib4Niv;
  glVertexAttrib4NivARB: TglVertexAttrib4NivARB;
  glVertexAttrib4Nsv: TglVertexAttrib4Nsv;
  glVertexAttrib4NsvARB: TglVertexAttrib4NsvARB;
  glVertexAttrib4Nub: TglVertexAttrib4Nub;
  glVertexAttrib4NubARB: TglVertexAttrib4NubARB;
  glVertexAttrib4Nubv: TglVertexAttrib4Nubv;
  glVertexAttrib4NubvARB: TglVertexAttrib4NubvARB;
  glVertexAttrib4Nuiv: TglVertexAttrib4Nuiv;
  glVertexAttrib4NuivARB: TglVertexAttrib4NuivARB;
  glVertexAttrib4Nusv: TglVertexAttrib4Nusv;
  glVertexAttrib4NusvARB: TglVertexAttrib4NusvARB;
  glVertexAttrib4bv: TglVertexAttrib4bv;
  glVertexAttrib4bvARB: TglVertexAttrib4bvARB;
  glVertexAttrib4d: TglVertexAttrib4d;
  glVertexAttrib4dARB: TglVertexAttrib4dARB;
  glVertexAttrib4dNV: TglVertexAttrib4dNV;
  glVertexAttrib4dv: TglVertexAttrib4dv;
  glVertexAttrib4dvARB: TglVertexAttrib4dvARB;
  glVertexAttrib4dvNV: TglVertexAttrib4dvNV;
  glVertexAttrib4f: TglVertexAttrib4f;
  glVertexAttrib4fARB: TglVertexAttrib4fARB;
  glVertexAttrib4fNV: TglVertexAttrib4fNV;
  glVertexAttrib4fv: TglVertexAttrib4fv;
  glVertexAttrib4fvARB: TglVertexAttrib4fvARB;
  glVertexAttrib4fvNV: TglVertexAttrib4fvNV;
  glVertexAttrib4hNV: TglVertexAttrib4hNV;
  glVertexAttrib4hvNV: TglVertexAttrib4hvNV;
  glVertexAttrib4iv: TglVertexAttrib4iv;
  glVertexAttrib4ivARB: TglVertexAttrib4ivARB;
  glVertexAttrib4s: TglVertexAttrib4s;
  glVertexAttrib4sARB: TglVertexAttrib4sARB;
  glVertexAttrib4sNV: TglVertexAttrib4sNV;
  glVertexAttrib4sv: TglVertexAttrib4sv;
  glVertexAttrib4svARB: TglVertexAttrib4svARB;
  glVertexAttrib4svNV: TglVertexAttrib4svNV;
  glVertexAttrib4ubNV: TglVertexAttrib4ubNV;
  glVertexAttrib4ubv: TglVertexAttrib4ubv;
  glVertexAttrib4ubvARB: TglVertexAttrib4ubvARB;
  glVertexAttrib4ubvNV: TglVertexAttrib4ubvNV;
  glVertexAttrib4uiv: TglVertexAttrib4uiv;
  glVertexAttrib4uivARB: TglVertexAttrib4uivARB;
  glVertexAttrib4usv: TglVertexAttrib4usv;
  glVertexAttrib4usvARB: TglVertexAttrib4usvARB;
  glVertexAttribArrayObjectATI: TglVertexAttribArrayObjectATI;
  glVertexAttribBinding: TglVertexAttribBinding;
  glVertexAttribDivisor: TglVertexAttribDivisor;
  glVertexAttribDivisorANGLE: TglVertexAttribDivisorANGLE;
  glVertexAttribDivisorARB: TglVertexAttribDivisorARB;
  glVertexAttribDivisorEXT: TglVertexAttribDivisorEXT;
  glVertexAttribDivisorNV: TglVertexAttribDivisorNV;
  glVertexAttribFormat: TglVertexAttribFormat;
  glVertexAttribFormatNV: TglVertexAttribFormatNV;
  glVertexAttribI1i: TglVertexAttribI1i;
  glVertexAttribI1iEXT: TglVertexAttribI1iEXT;
  glVertexAttribI1iv: TglVertexAttribI1iv;
  glVertexAttribI1ivEXT: TglVertexAttribI1ivEXT;
  glVertexAttribI1ui: TglVertexAttribI1ui;
  glVertexAttribI1uiEXT: TglVertexAttribI1uiEXT;
  glVertexAttribI1uiv: TglVertexAttribI1uiv;
  glVertexAttribI1uivEXT: TglVertexAttribI1uivEXT;
  glVertexAttribI2i: TglVertexAttribI2i;
  glVertexAttribI2iEXT: TglVertexAttribI2iEXT;
  glVertexAttribI2iv: TglVertexAttribI2iv;
  glVertexAttribI2ivEXT: TglVertexAttribI2ivEXT;
  glVertexAttribI2ui: TglVertexAttribI2ui;
  glVertexAttribI2uiEXT: TglVertexAttribI2uiEXT;
  glVertexAttribI2uiv: TglVertexAttribI2uiv;
  glVertexAttribI2uivEXT: TglVertexAttribI2uivEXT;
  glVertexAttribI3i: TglVertexAttribI3i;
  glVertexAttribI3iEXT: TglVertexAttribI3iEXT;
  glVertexAttribI3iv: TglVertexAttribI3iv;
  glVertexAttribI3ivEXT: TglVertexAttribI3ivEXT;
  glVertexAttribI3ui: TglVertexAttribI3ui;
  glVertexAttribI3uiEXT: TglVertexAttribI3uiEXT;
  glVertexAttribI3uiv: TglVertexAttribI3uiv;
  glVertexAttribI3uivEXT: TglVertexAttribI3uivEXT;
  glVertexAttribI4bv: TglVertexAttribI4bv;
  glVertexAttribI4bvEXT: TglVertexAttribI4bvEXT;
  glVertexAttribI4i: TglVertexAttribI4i;
  glVertexAttribI4iEXT: TglVertexAttribI4iEXT;
  glVertexAttribI4iv: TglVertexAttribI4iv;
  glVertexAttribI4ivEXT: TglVertexAttribI4ivEXT;
  glVertexAttribI4sv: TglVertexAttribI4sv;
  glVertexAttribI4svEXT: TglVertexAttribI4svEXT;
  glVertexAttribI4ubv: TglVertexAttribI4ubv;
  glVertexAttribI4ubvEXT: TglVertexAttribI4ubvEXT;
  glVertexAttribI4ui: TglVertexAttribI4ui;
  glVertexAttribI4uiEXT: TglVertexAttribI4uiEXT;
  glVertexAttribI4uiv: TglVertexAttribI4uiv;
  glVertexAttribI4uivEXT: TglVertexAttribI4uivEXT;
  glVertexAttribI4usv: TglVertexAttribI4usv;
  glVertexAttribI4usvEXT: TglVertexAttribI4usvEXT;
  glVertexAttribIFormat: TglVertexAttribIFormat;
  glVertexAttribIFormatNV: TglVertexAttribIFormatNV;
  glVertexAttribIPointer: TglVertexAttribIPointer;
  glVertexAttribIPointerEXT: TglVertexAttribIPointerEXT;
  glVertexAttribL1d: TglVertexAttribL1d;
  glVertexAttribL1dEXT: TglVertexAttribL1dEXT;
  glVertexAttribL1dv: TglVertexAttribL1dv;
  glVertexAttribL1dvEXT: TglVertexAttribL1dvEXT;
  glVertexAttribL1i64NV: TglVertexAttribL1i64NV;
  glVertexAttribL1i64vNV: TglVertexAttribL1i64vNV;
  glVertexAttribL1ui64ARB: TglVertexAttribL1ui64ARB;
  glVertexAttribL1ui64NV: TglVertexAttribL1ui64NV;
  glVertexAttribL1ui64vARB: TglVertexAttribL1ui64vARB;
  glVertexAttribL1ui64vNV: TglVertexAttribL1ui64vNV;
  glVertexAttribL2d: TglVertexAttribL2d;
  glVertexAttribL2dEXT: TglVertexAttribL2dEXT;
  glVertexAttribL2dv: TglVertexAttribL2dv;
  glVertexAttribL2dvEXT: TglVertexAttribL2dvEXT;
  glVertexAttribL2i64NV: TglVertexAttribL2i64NV;
  glVertexAttribL2i64vNV: TglVertexAttribL2i64vNV;
  glVertexAttribL2ui64NV: TglVertexAttribL2ui64NV;
  glVertexAttribL2ui64vNV: TglVertexAttribL2ui64vNV;
  glVertexAttribL3d: TglVertexAttribL3d;
  glVertexAttribL3dEXT: TglVertexAttribL3dEXT;
  glVertexAttribL3dv: TglVertexAttribL3dv;
  glVertexAttribL3dvEXT: TglVertexAttribL3dvEXT;
  glVertexAttribL3i64NV: TglVertexAttribL3i64NV;
  glVertexAttribL3i64vNV: TglVertexAttribL3i64vNV;
  glVertexAttribL3ui64NV: TglVertexAttribL3ui64NV;
  glVertexAttribL3ui64vNV: TglVertexAttribL3ui64vNV;
  glVertexAttribL4d: TglVertexAttribL4d;
  glVertexAttribL4dEXT: TglVertexAttribL4dEXT;
  glVertexAttribL4dv: TglVertexAttribL4dv;
  glVertexAttribL4dvEXT: TglVertexAttribL4dvEXT;
  glVertexAttribL4i64NV: TglVertexAttribL4i64NV;
  glVertexAttribL4i64vNV: TglVertexAttribL4i64vNV;
  glVertexAttribL4ui64NV: TglVertexAttribL4ui64NV;
  glVertexAttribL4ui64vNV: TglVertexAttribL4ui64vNV;
  glVertexAttribLFormat: TglVertexAttribLFormat;
  glVertexAttribLFormatNV: TglVertexAttribLFormatNV;
  glVertexAttribLPointer: TglVertexAttribLPointer;
  glVertexAttribLPointerEXT: TglVertexAttribLPointerEXT;
  glVertexAttribP1ui: TglVertexAttribP1ui;
  glVertexAttribP1uiv: TglVertexAttribP1uiv;
  glVertexAttribP2ui: TglVertexAttribP2ui;
  glVertexAttribP2uiv: TglVertexAttribP2uiv;
  glVertexAttribP3ui: TglVertexAttribP3ui;
  glVertexAttribP3uiv: TglVertexAttribP3uiv;
  glVertexAttribP4ui: TglVertexAttribP4ui;
  glVertexAttribP4uiv: TglVertexAttribP4uiv;
  glVertexAttribParameteriAMD: TglVertexAttribParameteriAMD;
  glVertexAttribPointer: TglVertexAttribPointer;
  glVertexAttribPointerARB: TglVertexAttribPointerARB;
  glVertexAttribPointerNV: TglVertexAttribPointerNV;
  glVertexAttribs1dvNV: TglVertexAttribs1dvNV;
  glVertexAttribs1fvNV: TglVertexAttribs1fvNV;
  glVertexAttribs1hvNV: TglVertexAttribs1hvNV;
  glVertexAttribs1svNV: TglVertexAttribs1svNV;
  glVertexAttribs2dvNV: TglVertexAttribs2dvNV;
  glVertexAttribs2fvNV: TglVertexAttribs2fvNV;
  glVertexAttribs2hvNV: TglVertexAttribs2hvNV;
  glVertexAttribs2svNV: TglVertexAttribs2svNV;
  glVertexAttribs3dvNV: TglVertexAttribs3dvNV;
  glVertexAttribs3fvNV: TglVertexAttribs3fvNV;
  glVertexAttribs3hvNV: TglVertexAttribs3hvNV;
  glVertexAttribs3svNV: TglVertexAttribs3svNV;
  glVertexAttribs4dvNV: TglVertexAttribs4dvNV;
  glVertexAttribs4fvNV: TglVertexAttribs4fvNV;
  glVertexAttribs4hvNV: TglVertexAttribs4hvNV;
  glVertexAttribs4svNV: TglVertexAttribs4svNV;
  glVertexAttribs4ubvNV: TglVertexAttribs4ubvNV;
  glVertexBindingDivisor: TglVertexBindingDivisor;
  glVertexBlendARB: TglVertexBlendARB;
  glVertexBlendEnvfATI: TglVertexBlendEnvfATI;
  glVertexBlendEnviATI: TglVertexBlendEnviATI;
  glVertexFormatNV: TglVertexFormatNV;
  glVertexP2ui: TglVertexP2ui;
  glVertexP2uiv: TglVertexP2uiv;
  glVertexP3ui: TglVertexP3ui;
  glVertexP3uiv: TglVertexP3uiv;
  glVertexP4ui: TglVertexP4ui;
  glVertexP4uiv: TglVertexP4uiv;
  glVertexPointer: TglVertexPointer;
  glVertexPointerEXT: TglVertexPointerEXT;
  glVertexPointerListIBM: TglVertexPointerListIBM;
  glVertexPointervINTEL: TglVertexPointervINTEL;
  glVertexStream1dATI: TglVertexStream1dATI;
  glVertexStream1dvATI: TglVertexStream1dvATI;
  glVertexStream1fATI: TglVertexStream1fATI;
  glVertexStream1fvATI: TglVertexStream1fvATI;
  glVertexStream1iATI: TglVertexStream1iATI;
  glVertexStream1ivATI: TglVertexStream1ivATI;
  glVertexStream1sATI: TglVertexStream1sATI;
  glVertexStream1svATI: TglVertexStream1svATI;
  glVertexStream2dATI: TglVertexStream2dATI;
  glVertexStream2dvATI: TglVertexStream2dvATI;
  glVertexStream2fATI: TglVertexStream2fATI;
  glVertexStream2fvATI: TglVertexStream2fvATI;
  glVertexStream2iATI: TglVertexStream2iATI;
  glVertexStream2ivATI: TglVertexStream2ivATI;
  glVertexStream2sATI: TglVertexStream2sATI;
  glVertexStream2svATI: TglVertexStream2svATI;
  glVertexStream3dATI: TglVertexStream3dATI;
  glVertexStream3dvATI: TglVertexStream3dvATI;
  glVertexStream3fATI: TglVertexStream3fATI;
  glVertexStream3fvATI: TglVertexStream3fvATI;
  glVertexStream3iATI: TglVertexStream3iATI;
  glVertexStream3ivATI: TglVertexStream3ivATI;
  glVertexStream3sATI: TglVertexStream3sATI;
  glVertexStream3svATI: TglVertexStream3svATI;
  glVertexStream4dATI: TglVertexStream4dATI;
  glVertexStream4dvATI: TglVertexStream4dvATI;
  glVertexStream4fATI: TglVertexStream4fATI;
  glVertexStream4fvATI: TglVertexStream4fvATI;
  glVertexStream4iATI: TglVertexStream4iATI;
  glVertexStream4ivATI: TglVertexStream4ivATI;
  glVertexStream4sATI: TglVertexStream4sATI;
  glVertexStream4svATI: TglVertexStream4svATI;
  glVertexWeightPointerEXT: TglVertexWeightPointerEXT;
  glVertexWeightfEXT: TglVertexWeightfEXT;
  glVertexWeightfvEXT: TglVertexWeightfvEXT;
  glVertexWeighthNV: TglVertexWeighthNV;
  glVertexWeighthvNV: TglVertexWeighthvNV;
  glVideoCaptureNV: TglVideoCaptureNV;
  glVideoCaptureStreamParameterdvNV: TglVideoCaptureStreamParameterdvNV;
  glVideoCaptureStreamParameterfvNV: TglVideoCaptureStreamParameterfvNV;
  glVideoCaptureStreamParameterivNV: TglVideoCaptureStreamParameterivNV;
  glViewport: TglViewport;
  glViewportArrayv: TglViewportArrayv;
  glViewportArrayvNV: TglViewportArrayvNV;
  glViewportArrayvOES: TglViewportArrayvOES;
  glViewportIndexedf: TglViewportIndexedf;
  glViewportIndexedfOES: TglViewportIndexedfOES;
  glViewportIndexedfNV: TglViewportIndexedfNV;
  glViewportIndexedfv: TglViewportIndexedfv;
  glViewportIndexedfvOES: TglViewportIndexedfvOES;
  glViewportIndexedfvNV: TglViewportIndexedfvNV;
  glViewportPositionWScaleNV: TglViewportPositionWScaleNV;
  glViewportSwizzleNV: TglViewportSwizzleNV;
  glWaitSemaphoreEXT: TglWaitSemaphoreEXT;
  glWaitSync: TglWaitSync;
  glWaitSyncAPPLE: TglWaitSyncAPPLE;
  glWeightPathsNV: TglWeightPathsNV;
  glWeightPointerARB: TglWeightPointerARB;
  glWeightPointerOES: TglWeightPointerOES;
  glWeightbvARB: TglWeightbvARB;
  glWeightdvARB: TglWeightdvARB;
  glWeightfvARB: TglWeightfvARB;
  glWeightivARB: TglWeightivARB;
  glWeightsvARB: TglWeightsvARB;
  glWeightubvARB: TglWeightubvARB;
  glWeightuivARB: TglWeightuivARB;
  glWeightusvARB: TglWeightusvARB;
  glWindowPos2d: TglWindowPos2d;
  glWindowPos2dARB: TglWindowPos2dARB;
  glWindowPos2dMESA: TglWindowPos2dMESA;
  glWindowPos2dv: TglWindowPos2dv;
  glWindowPos2dvARB: TglWindowPos2dvARB;
  glWindowPos2dvMESA: TglWindowPos2dvMESA;
  glWindowPos2f: TglWindowPos2f;
  glWindowPos2fARB: TglWindowPos2fARB;
  glWindowPos2fMESA: TglWindowPos2fMESA;
  glWindowPos2fv: TglWindowPos2fv;
  glWindowPos2fvARB: TglWindowPos2fvARB;
  glWindowPos2fvMESA: TglWindowPos2fvMESA;
  glWindowPos2i: TglWindowPos2i;
  glWindowPos2iARB: TglWindowPos2iARB;
  glWindowPos2iMESA: TglWindowPos2iMESA;
  glWindowPos2iv: TglWindowPos2iv;
  glWindowPos2ivARB: TglWindowPos2ivARB;
  glWindowPos2ivMESA: TglWindowPos2ivMESA;
  glWindowPos2s: TglWindowPos2s;
  glWindowPos2sARB: TglWindowPos2sARB;
  glWindowPos2sMESA: TglWindowPos2sMESA;
  glWindowPos2sv: TglWindowPos2sv;
  glWindowPos2svARB: TglWindowPos2svARB;
  glWindowPos2svMESA: TglWindowPos2svMESA;
  glWindowPos3d: TglWindowPos3d;
  glWindowPos3dARB: TglWindowPos3dARB;
  glWindowPos3dMESA: TglWindowPos3dMESA;
  glWindowPos3dv: TglWindowPos3dv;
  glWindowPos3dvARB: TglWindowPos3dvARB;
  glWindowPos3dvMESA: TglWindowPos3dvMESA;
  glWindowPos3f: TglWindowPos3f;
  glWindowPos3fARB: TglWindowPos3fARB;
  glWindowPos3fMESA: TglWindowPos3fMESA;
  glWindowPos3fv: TglWindowPos3fv;
  glWindowPos3fvARB: TglWindowPos3fvARB;
  glWindowPos3fvMESA: TglWindowPos3fvMESA;
  glWindowPos3i: TglWindowPos3i;
  glWindowPos3iARB: TglWindowPos3iARB;
  glWindowPos3iMESA: TglWindowPos3iMESA;
  glWindowPos3iv: TglWindowPos3iv;
  glWindowPos3ivARB: TglWindowPos3ivARB;
  glWindowPos3ivMESA: TglWindowPos3ivMESA;
  glWindowPos3s: TglWindowPos3s;
  glWindowPos3sARB: TglWindowPos3sARB;
  glWindowPos3sMESA: TglWindowPos3sMESA;
  glWindowPos3sv: TglWindowPos3sv;
  glWindowPos3svARB: TglWindowPos3svARB;
  glWindowPos3svMESA: TglWindowPos3svMESA;
  glWindowPos4dMESA: TglWindowPos4dMESA;
  glWindowPos4dvMESA: TglWindowPos4dvMESA;
  glWindowPos4fMESA: TglWindowPos4fMESA;
  glWindowPos4fvMESA: TglWindowPos4fvMESA;
  glWindowPos4iMESA: TglWindowPos4iMESA;
  glWindowPos4ivMESA: TglWindowPos4ivMESA;
  glWindowPos4sMESA: TglWindowPos4sMESA;
  glWindowPos4svMESA: TglWindowPos4svMESA;
  glWindowRectanglesEXT: TglWindowRectanglesEXT;
  glWriteMaskEXT: TglWriteMaskEXT;
  glDrawVkImageNV: TglDrawVkImageNV;
  glGetVkProcAddrNV: TglGetVkProcAddrNV;
  glWaitVkSemaphoreNV: TglWaitVkSemaphoreNV;
  glSignalVkSemaphoreNV: TglSignalVkSemaphoreNV;
  glSignalVkFenceNV: TglSignalVkFenceNV;
var
  // OpenGL extension flags (Has_XXX means that XXX extension is available)
  Has_GL_3DFX_multisample: Boolean;
  Has_GL_3DFX_tbuffer: Boolean;
  Has_GL_3DFX_texture_compression_FXT1: Boolean;
  Has_GL_AMD_blend_minmax_factor: Boolean;
  Has_GL_AMD_compressed_3DC_texture: Boolean;
  Has_GL_AMD_compressed_ATC_texture: Boolean;
  Has_GL_AMD_conservative_depth: Boolean;
  Has_GL_AMD_debug_output: Boolean;
  Has_GL_AMD_depth_clamp_separate: Boolean;
  Has_GL_AMD_draw_buffers_blend: Boolean;
  Has_GL_AMD_framebuffer_sample_positions: Boolean;
  Has_GL_AMD_gcn_shader: Boolean;
  Has_GL_AMD_gpu_shader_half_float: Boolean;
  Has_GL_AMD_gpu_shader_int16: Boolean;
  Has_GL_AMD_gpu_shader_int64: Boolean;
  Has_GL_AMD_interleaved_elements: Boolean;
  Has_GL_AMD_multi_draw_indirect: Boolean;
  Has_GL_AMD_name_gen_delete: Boolean;
  Has_GL_AMD_occlusion_query_event: Boolean;
  Has_GL_AMD_performance_monitor: Boolean;
  Has_GL_AMD_pinned_memory: Boolean;
  Has_GL_AMD_program_binary_Z400: Boolean;
  Has_GL_AMD_query_buffer_object: Boolean;
  Has_GL_AMD_sample_positions: Boolean;
  Has_GL_AMD_seamless_cubemap_per_texture: Boolean;
  Has_GL_AMD_shader_atomic_counter_ops: Boolean;
  Has_GL_AMD_shader_ballot: Boolean;
  Has_GL_AMD_shader_stencil_export: Boolean;
  Has_GL_AMD_shader_trinary_minmax: Boolean;
  Has_GL_AMD_shader_explicit_vertex_parameter: Boolean;
  Has_GL_AMD_sparse_texture: Boolean;
  Has_GL_AMD_stencil_operation_extended: Boolean;
  Has_GL_AMD_texture_gather_bias_lod: Boolean;
  Has_GL_AMD_texture_texture4: Boolean;
  Has_GL_AMD_transform_feedback3_lines_triangles: Boolean;
  Has_GL_AMD_transform_feedback4: Boolean;
  Has_GL_AMD_vertex_shader_layer: Boolean;
  Has_GL_AMD_vertex_shader_tessellator: Boolean;
  Has_GL_AMD_vertex_shader_viewport_index: Boolean;
  Has_GL_ANDROID_extension_pack_es31a: Boolean;
  Has_GL_ANGLE_depth_texture: Boolean;
  Has_GL_ANGLE_framebuffer_blit: Boolean;
  Has_GL_ANGLE_framebuffer_multisample: Boolean;
  Has_GL_ANGLE_instanced_arrays: Boolean;
  Has_GL_ANGLE_pack_reverse_row_order: Boolean;
  Has_GL_ANGLE_program_binary: Boolean;
  Has_GL_ANGLE_texture_compression_dxt3: Boolean;
  Has_GL_ANGLE_texture_compression_dxt5: Boolean;
  Has_GL_ANGLE_texture_usage: Boolean;
  Has_GL_ANGLE_translated_shader_source: Boolean;
  Has_GL_APPLE_aux_depth_stencil: Boolean;
  Has_GL_APPLE_client_storage: Boolean;
  Has_GL_APPLE_clip_distance: Boolean;
  Has_GL_APPLE_color_buffer_packed_float: Boolean;
  Has_GL_APPLE_copy_texture_levels: Boolean;
  Has_GL_APPLE_element_array: Boolean;
  Has_GL_APPLE_fence: Boolean;
  Has_GL_APPLE_float_pixels: Boolean;
  Has_GL_APPLE_flush_buffer_range: Boolean;
  Has_GL_APPLE_framebuffer_multisample: Boolean;
  Has_GL_APPLE_object_purgeable: Boolean;
  Has_GL_APPLE_rgb_422: Boolean;
  Has_GL_APPLE_row_bytes: Boolean;
  Has_GL_APPLE_specular_vector: Boolean;
  Has_GL_APPLE_sync: Boolean;
  Has_GL_APPLE_texture_2D_limited_npot: Boolean;
  Has_GL_APPLE_texture_format_BGRA8888: Boolean;
  Has_GL_APPLE_texture_max_level: Boolean;
  Has_GL_APPLE_texture_packed_float: Boolean;
  Has_GL_APPLE_texture_range: Boolean;
  Has_GL_APPLE_transform_hint: Boolean;
  Has_GL_APPLE_vertex_array_object: Boolean;
  Has_GL_APPLE_vertex_array_range: Boolean;
  Has_GL_APPLE_vertex_program_evaluators: Boolean;
  Has_GL_APPLE_ycbcr_422: Boolean;
  Has_GL_ARB_ES2_compatibility: Boolean;
  Has_GL_ARB_ES3_1_compatibility: Boolean;
  Has_GL_ARB_ES3_2_compatibility: Boolean;
  Has_GL_ARB_ES3_compatibility: Boolean;
  Has_GL_ARB_arrays_of_arrays: Boolean;
  Has_GL_ARB_base_instance: Boolean;
  Has_GL_ARB_bindless_texture: Boolean;
  Has_GL_ARB_blend_func_extended: Boolean;
  Has_GL_ARB_buffer_storage: Boolean;
  Has_GL_ARB_cl_event: Boolean;
  Has_GL_ARB_clear_buffer_object: Boolean;
  Has_GL_ARB_clear_texture: Boolean;
  Has_GL_ARB_clip_control: Boolean;
  Has_GL_ARB_color_buffer_float: Boolean;
  Has_GL_ARB_compatibility: Boolean;
  Has_GL_ARB_compressed_texture_pixel_storage: Boolean;
  Has_GL_ARB_compute_shader: Boolean;
  Has_GL_ARB_compute_variable_group_size: Boolean;
  Has_GL_ARB_conditional_render_inverted: Boolean;
  Has_GL_ARB_conservative_depth: Boolean;
  Has_GL_ARB_copy_buffer: Boolean;
  Has_GL_ARB_copy_image: Boolean;
  Has_GL_ARB_cull_distance: Boolean;
  Has_GL_ARB_debug_output: Boolean;
  Has_GL_ARB_depth_buffer_float: Boolean;
  Has_GL_ARB_depth_clamp: Boolean;
  Has_GL_ARB_depth_texture: Boolean;
  Has_GL_ARB_derivative_control: Boolean;
  Has_GL_ARB_direct_state_access: Boolean;
  Has_GL_ARB_draw_buffers: Boolean;
  Has_GL_ARB_draw_buffers_blend: Boolean;
  Has_GL_ARB_draw_elements_base_vertex: Boolean;
  Has_GL_ARB_draw_indirect: Boolean;
  Has_GL_ARB_draw_instanced: Boolean;
  Has_GL_ARB_enhanced_layouts: Boolean;
  Has_GL_ARB_explicit_attrib_location: Boolean;
  Has_GL_ARB_explicit_uniform_location: Boolean;
  Has_GL_ARB_fragment_coord_conventions: Boolean;
  Has_GL_ARB_fragment_layer_viewport: Boolean;
  Has_GL_ARB_fragment_program: Boolean;
  Has_GL_ARB_fragment_program_shadow: Boolean;
  Has_GL_ARB_fragment_shader: Boolean;
  Has_GL_ARB_fragment_shader_interlock: Boolean;
  Has_GL_ARB_framebuffer_no_attachments: Boolean;
  Has_GL_ARB_framebuffer_object: Boolean;
  Has_GL_ARB_framebuffer_sRGB: Boolean;
  Has_GL_ARB_geometry_shader4: Boolean;
  Has_GL_ARB_get_program_binary: Boolean;
  Has_GL_ARB_get_texture_sub_image: Boolean;
  Has_GL_ARB_gl_spirv: Boolean;
  Has_GL_ARB_gpu_shader5: Boolean;
  Has_GL_ARB_gpu_shader_fp64: Boolean;
  Has_GL_ARB_gpu_shader_int64: Boolean;
  Has_GL_ARB_half_float_pixel: Boolean;
  Has_GL_ARB_half_float_vertex: Boolean;
  Has_GL_ARB_imaging: Boolean;
  Has_GL_ARB_indirect_parameters: Boolean;
  Has_GL_ARB_instanced_arrays: Boolean;
  Has_GL_ARB_internalformat_query: Boolean;
  Has_GL_ARB_internalformat_query2: Boolean;
  Has_GL_ARB_invalidate_subdata: Boolean;
  Has_GL_ARB_map_buffer_alignment: Boolean;
  Has_GL_ARB_map_buffer_range: Boolean;
  Has_GL_ARB_matrix_palette: Boolean;
  Has_GL_ARB_multi_bind: Boolean;
  Has_GL_ARB_multi_draw_indirect: Boolean;
  Has_GL_ARB_multisample: Boolean;
  Has_GL_ARB_multitexture: Boolean;
  Has_GL_ARB_occlusion_query: Boolean;
  Has_GL_ARB_occlusion_query2: Boolean;
  Has_GL_ARB_parallel_shader_compile: Boolean;
  Has_GL_ARB_pipeline_statistics_query: Boolean;
  Has_GL_ARB_pixel_buffer_object: Boolean;
  Has_GL_ARB_point_parameters: Boolean;
  Has_GL_ARB_point_sprite: Boolean;
  Has_GL_ARB_polygon_offset_clamp: Boolean;
  Has_GL_ARB_post_depth_coverage: Boolean;
  Has_GL_ARB_program_interface_query: Boolean;
  Has_GL_ARB_provoking_vertex: Boolean;
  Has_GL_ARB_query_buffer_object: Boolean;
  Has_GL_ARB_robust_buffer_access_behavior: Boolean;
  Has_GL_ARB_robustness: Boolean;
  Has_GL_ARB_robustness_isolation: Boolean;
  Has_GL_ARB_sample_locations: Boolean;
  Has_GL_ARB_sample_shading: Boolean;
  Has_GL_ARB_sampler_objects: Boolean;
  Has_GL_ARB_seamless_cube_map: Boolean;
  Has_GL_ARB_seamless_cubemap_per_texture: Boolean;
  Has_GL_ARB_separate_shader_objects: Boolean;
  Has_GL_ARB_shader_atomic_counter_ops: Boolean;
  Has_GL_ARB_shader_atomic_counters: Boolean;
  Has_GL_ARB_shader_ballot: Boolean;
  Has_GL_ARB_shader_bit_encoding: Boolean;
  Has_GL_ARB_shader_clock: Boolean;
  Has_GL_ARB_shader_draw_parameters: Boolean;
  Has_GL_ARB_shader_group_vote: Boolean;
  Has_GL_ARB_shader_image_load_store: Boolean;
  Has_GL_ARB_shader_image_size: Boolean;
  Has_GL_ARB_shader_objects: Boolean;
  Has_GL_ARB_shader_precision: Boolean;
  Has_GL_ARB_shader_stencil_export: Boolean;
  Has_GL_ARB_shader_storage_buffer_object: Boolean;
  Has_GL_ARB_shader_subroutine: Boolean;
  Has_GL_ARB_shader_texture_image_samples: Boolean;
  Has_GL_ARB_shader_texture_lod: Boolean;
  Has_GL_ARB_shader_viewport_layer_array: Boolean;
  Has_GL_ARB_shading_language_100: Boolean;
  Has_GL_ARB_shading_language_420pack: Boolean;
  Has_GL_ARB_shading_language_include: Boolean;
  Has_GL_ARB_shading_language_packing: Boolean;
  Has_GL_ARB_shadow: Boolean;
  Has_GL_ARB_shadow_ambient: Boolean;
  Has_GL_ARB_sparse_buffer: Boolean;
  Has_GL_ARB_sparse_texture: Boolean;
  Has_GL_ARB_sparse_texture2: Boolean;
  Has_GL_ARB_sparse_texture_clamp: Boolean;
  Has_GL_ARB_spirv_extensions: Boolean;
  Has_GL_ARB_stencil_texturing: Boolean;
  Has_GL_ARB_sync: Boolean;
  Has_GL_ARB_tessellation_shader: Boolean;
  Has_GL_ARB_texture_barrier: Boolean;
  Has_GL_ARB_texture_border_clamp: Boolean;
  Has_GL_ARB_texture_buffer_object: Boolean;
  Has_GL_ARB_texture_buffer_object_rgb32: Boolean;
  Has_GL_ARB_texture_buffer_range: Boolean;
  Has_GL_ARB_texture_compression: Boolean;
  Has_GL_ARB_texture_compression_bptc: Boolean;
  Has_GL_ARB_texture_compression_rgtc: Boolean;
  Has_GL_ARB_texture_cube_map: Boolean;
  Has_GL_ARB_texture_cube_map_array: Boolean;
  Has_GL_ARB_texture_env_add: Boolean;
  Has_GL_ARB_texture_env_combine: Boolean;
  Has_GL_ARB_texture_env_crossbar: Boolean;
  Has_GL_ARB_texture_env_dot3: Boolean;
  Has_GL_ARB_texture_filter_anisotropic: Boolean;
  Has_GL_ARB_texture_filter_minmax: Boolean;
  Has_GL_ARB_texture_float: Boolean;
  Has_GL_ARB_texture_gather: Boolean;
  Has_GL_ARB_texture_mirror_clamp_to_edge: Boolean;
  Has_GL_ARB_texture_mirrored_repeat: Boolean;
  Has_GL_ARB_texture_multisample: Boolean;
  Has_GL_ARB_texture_non_power_of_two: Boolean;
  Has_GL_ARB_texture_query_levels: Boolean;
  Has_GL_ARB_texture_query_lod: Boolean;
  Has_GL_ARB_texture_rectangle: Boolean;
  Has_GL_ARB_texture_rg: Boolean;
  Has_GL_ARB_texture_rgb10_a2ui: Boolean;
  Has_GL_ARB_texture_stencil8: Boolean;
  Has_GL_ARB_texture_storage: Boolean;
  Has_GL_ARB_texture_storage_multisample: Boolean;
  Has_GL_ARB_texture_swizzle: Boolean;
  Has_GL_ARB_texture_view: Boolean;
  Has_GL_ARB_timer_query: Boolean;
  Has_GL_ARB_transform_feedback2: Boolean;
  Has_GL_ARB_transform_feedback3: Boolean;
  Has_GL_ARB_transform_feedback_instanced: Boolean;
  Has_GL_ARB_transform_feedback_overflow_query: Boolean;
  Has_GL_ARB_transpose_matrix: Boolean;
  Has_GL_ARB_uniform_buffer_object: Boolean;
  Has_GL_ARB_vertex_array_bgra: Boolean;
  Has_GL_ARB_vertex_array_object: Boolean;
  Has_GL_ARB_vertex_attrib_64bit: Boolean;
  Has_GL_ARB_vertex_attrib_binding: Boolean;
  Has_GL_ARB_vertex_blend: Boolean;
  Has_GL_ARB_vertex_buffer_object: Boolean;
  Has_GL_ARB_vertex_program: Boolean;
  Has_GL_ARB_vertex_shader: Boolean;
  Has_GL_ARB_vertex_type_10f_11f_11f_rev: Boolean;
  Has_GL_ARB_vertex_type_2_10_10_10_rev: Boolean;
  Has_GL_ARB_viewport_array: Boolean;
  Has_GL_ARB_window_pos: Boolean;
  Has_GL_ARM_mali_program_binary: Boolean;
  Has_GL_ARM_mali_shader_binary: Boolean;
  Has_GL_ARM_rgba8: Boolean;
  Has_GL_ARM_shader_framebuffer_fetch: Boolean;
  Has_GL_ARM_shader_framebuffer_fetch_depth_stencil: Boolean;
  Has_GL_ATI_draw_buffers: Boolean;
  Has_GL_ATI_element_array: Boolean;
  Has_GL_ATI_envmap_bumpmap: Boolean;
  Has_GL_ATI_fragment_shader: Boolean;
  Has_GL_ATI_map_object_buffer: Boolean;
  Has_GL_ATI_meminfo: Boolean;
  Has_GL_ATI_pixel_format_float: Boolean;
  Has_GL_ATI_pn_triangles: Boolean;
  Has_GL_ATI_separate_stencil: Boolean;
  Has_GL_ATI_text_fragment_shader: Boolean;
  Has_GL_ATI_texture_env_combine3: Boolean;
  Has_GL_ATI_texture_float: Boolean;
  Has_GL_ATI_texture_mirror_once: Boolean;
  Has_GL_ATI_vertex_array_object: Boolean;
  Has_GL_ATI_vertex_attrib_array_object: Boolean;
  Has_GL_ATI_vertex_streams: Boolean;
  Has_GL_DMP_program_binary: Boolean;
  Has_GL_DMP_shader_binary: Boolean;
  Has_GL_EXT_422_pixels: Boolean;
  Has_GL_EXT_EGL_image_array: Boolean;
  Has_GL_EXT_YUV_target: Boolean;
  Has_GL_EXT_abgr: Boolean;
  Has_GL_EXT_base_instance: Boolean;
  Has_GL_EXT_bgra: Boolean;
  Has_GL_EXT_bindable_uniform: Boolean;
  Has_GL_EXT_blend_color: Boolean;
  Has_GL_EXT_blend_equation_separate: Boolean;
  Has_GL_EXT_blend_func_extended: Boolean;
  Has_GL_EXT_blend_func_separate: Boolean;
  Has_GL_EXT_blend_logic_op: Boolean;
  Has_GL_EXT_blend_minmax: Boolean;
  Has_GL_EXT_blend_subtract: Boolean;
  Has_GL_EXT_buffer_storage: Boolean;
  Has_GL_EXT_clear_texture: Boolean;
  Has_GL_EXT_clip_cull_distance: Boolean;
  Has_GL_EXT_clip_volume_hint: Boolean;
  Has_GL_EXT_cmyka: Boolean;
  Has_GL_EXT_color_buffer_float: Boolean;
  Has_GL_EXT_color_buffer_half_float: Boolean;
  Has_GL_EXT_color_subtable: Boolean;
  Has_GL_EXT_compiled_vertex_array: Boolean;
  Has_GL_EXT_conservative_depth: Boolean;
  Has_GL_EXT_convolution: Boolean;
  Has_GL_EXT_coordinate_frame: Boolean;
  Has_GL_EXT_copy_image: Boolean;
  Has_GL_EXT_copy_texture: Boolean;
  Has_GL_EXT_cull_vertex: Boolean;
  Has_GL_EXT_debug_label: Boolean;
  Has_GL_EXT_debug_marker: Boolean;
  Has_GL_EXT_depth_bounds_test: Boolean;
  Has_GL_EXT_direct_state_access: Boolean;
  Has_GL_EXT_discard_framebuffer: Boolean;
  Has_GL_EXT_disjoint_timer_query: Boolean;
  Has_GL_EXT_draw_buffers: Boolean;
  Has_GL_EXT_draw_buffers2: Boolean;
  Has_GL_EXT_draw_buffers_indexed: Boolean;
  Has_GL_EXT_draw_elements_base_vertex: Boolean;
  Has_GL_EXT_draw_instanced: Boolean;
  Has_GL_EXT_draw_range_elements: Boolean;
  Has_GL_EXT_draw_transform_feedback: Boolean;
  Has_GL_EXT_external_buffer: Boolean;
  Has_GL_EXT_float_blend: Boolean;
  Has_GL_EXT_fog_coord: Boolean;
  Has_GL_EXT_framebuffer_blit: Boolean;
  Has_GL_EXT_framebuffer_multisample: Boolean;
  Has_GL_EXT_framebuffer_multisample_blit_scaled: Boolean;
  Has_GL_EXT_framebuffer_object: Boolean;
  Has_GL_EXT_framebuffer_sRGB: Boolean;
  Has_GL_EXT_geometry_point_size: Boolean;
  Has_GL_EXT_geometry_shader: Boolean;
  Has_GL_EXT_geometry_shader4: Boolean;
  Has_GL_EXT_gpu_program_parameters: Boolean;
  Has_GL_EXT_gpu_shader4: Boolean;
  Has_GL_EXT_gpu_shader5: Boolean;
  Has_GL_EXT_histogram: Boolean;
  Has_GL_EXT_index_array_formats: Boolean;
  Has_GL_EXT_index_func: Boolean;
  Has_GL_EXT_index_material: Boolean;
  Has_GL_EXT_index_texture: Boolean;
  Has_GL_EXT_instanced_arrays: Boolean;
  Has_GL_EXT_light_texture: Boolean;
  Has_GL_EXT_map_buffer_range: Boolean;
  Has_GL_EXT_memory_object: Boolean;
  Has_GL_EXT_memory_object_fd: Boolean;
  Has_GL_EXT_memory_object_win32: Boolean;
  Has_GL_EXT_misc_attribute: Boolean;
  Has_GL_EXT_multi_draw_arrays: Boolean;
  Has_GL_EXT_multi_draw_indirect: Boolean;
  Has_GL_EXT_multisample: Boolean;
  Has_GL_EXT_multisampled_compatibility: Boolean;
  Has_GL_EXT_multisampled_render_to_texture: Boolean;
  Has_GL_EXT_multiview_draw_buffers: Boolean;
  Has_GL_EXT_occlusion_query_boolean: Boolean;
  Has_GL_EXT_packed_depth_stencil: Boolean;
  Has_GL_EXT_packed_float: Boolean;
  Has_GL_EXT_packed_pixels: Boolean;
  Has_GL_EXT_paletted_texture: Boolean;
  Has_GL_EXT_pixel_buffer_object: Boolean;
  Has_GL_EXT_pixel_transform: Boolean;
  Has_GL_EXT_pixel_transform_color_table: Boolean;
  Has_GL_EXT_point_parameters: Boolean;
  Has_GL_EXT_polygon_offset: Boolean;
  Has_GL_EXT_polygon_offset_clamp: Boolean;
  Has_GL_EXT_post_depth_coverage: Boolean;
  Has_GL_EXT_primitive_bounding_box: Boolean;
  Has_GL_EXT_protected_textures: Boolean;
  Has_GL_EXT_provoking_vertex: Boolean;
  Has_GL_EXT_pvrtc_sRGB: Boolean;
  Has_GL_EXT_raster_multisample: Boolean;
  Has_GL_EXT_read_format_bgra: Boolean;
  Has_GL_EXT_render_snorm: Boolean;
  Has_GL_EXT_rescale_normal: Boolean;
  Has_GL_EXT_robustness: Boolean;
  Has_GL_EXT_semaphore: Boolean;
  Has_GL_EXT_semaphore_fd: Boolean;
  Has_GL_EXT_semaphore_win32: Boolean;
  Has_GL_EXT_sRGB: Boolean;
  Has_GL_EXT_sRGB_write_control: Boolean;
  Has_GL_EXT_secondary_color: Boolean;
  Has_GL_EXT_separate_shader_objects: Boolean;
  Has_GL_EXT_separate_specular_color: Boolean;
  Has_GL_EXT_shader_framebuffer_fetch: Boolean;
  Has_GL_EXT_shader_group_vote: Boolean;
  Has_GL_EXT_shader_image_load_formatted: Boolean;
  Has_GL_EXT_shader_image_load_store: Boolean;
  Has_GL_EXT_shader_implicit_conversions: Boolean;
  Has_GL_EXT_shader_integer_mix: Boolean;
  Has_GL_EXT_shader_io_blocks: Boolean;
  Has_GL_EXT_shader_non_constant_global_initializers: Boolean;
  Has_GL_EXT_shader_pixel_local_storage: Boolean;
  Has_GL_EXT_shader_pixel_local_storage2: Boolean;
  Has_GL_EXT_shader_texture_lod: Boolean;
  Has_GL_EXT_shadow_funcs: Boolean;
  Has_GL_EXT_shadow_samplers: Boolean;
  Has_GL_EXT_shared_texture_palette: Boolean;
  Has_GL_EXT_sparse_texture: Boolean;
  Has_GL_EXT_sparse_texture2: Boolean;
  Has_GL_EXT_stencil_clear_tag: Boolean;
  Has_GL_EXT_stencil_two_side: Boolean;
  Has_GL_EXT_stencil_wrap: Boolean;
  Has_GL_EXT_subtexture: Boolean;
  Has_GL_EXT_tessellation_point_size: Boolean;
  Has_GL_EXT_tessellation_shader: Boolean;
  Has_GL_EXT_texture: Boolean;
  Has_GL_EXT_texture3D: Boolean;
  Has_GL_EXT_texture_array: Boolean;
  Has_GL_EXT_texture_border_clamp: Boolean;
  Has_GL_EXT_texture_buffer: Boolean;
  Has_GL_EXT_texture_buffer_object: Boolean;
  Has_GL_EXT_texture_compression_astc_decode_mode: Boolean;
  Has_GL_EXT_texture_compression_bptc: Boolean;
  Has_GL_EXT_texture_compression_dxt1: Boolean;
  Has_GL_EXT_texture_compression_latc: Boolean;
  Has_GL_EXT_texture_compression_rgtc: Boolean;
  Has_GL_EXT_texture_compression_s3tc: Boolean;
  Has_GL_EXT_texture_cube_map: Boolean;
  Has_GL_EXT_texture_cube_map_array: Boolean;
  Has_GL_EXT_texture_env_add: Boolean;
  Has_GL_EXT_texture_env_combine: Boolean;
  Has_GL_EXT_texture_env_dot3: Boolean;
  Has_GL_EXT_texture_filter_anisotropic: Boolean;
  Has_GL_EXT_texture_filter_minmax: Boolean;
  Has_GL_EXT_texture_format_BGRA8888: Boolean;
  Has_GL_EXT_texture_integer: Boolean;
  Has_GL_EXT_texture_lod_bias: Boolean;
  Has_GL_EXT_texture_mirror_clamp: Boolean;
  Has_GL_EXT_texture_norm16: Boolean;
  Has_GL_EXT_texture_object: Boolean;
  Has_GL_EXT_texture_perturb_normal: Boolean;
  Has_GL_EXT_texture_rg: Boolean;
  Has_GL_EXT_texture_sRGB: Boolean;
  Has_GL_EXT_texture_sRGB_R8: Boolean;
  Has_GL_EXT_texture_sRGB_RG8: Boolean;
  Has_GL_EXT_texture_sRGB_decode: Boolean;
  Has_GL_EXT_texture_shared_exponent: Boolean;
  Has_GL_EXT_texture_snorm: Boolean;
  Has_GL_EXT_texture_storage: Boolean;
  Has_GL_EXT_texture_swizzle: Boolean;
  Has_GL_EXT_texture_type_2_10_10_10_REV: Boolean;
  Has_GL_EXT_texture_view: Boolean;
  Has_GL_EXT_timer_query: Boolean;
  Has_GL_EXT_transform_feedback: Boolean;
  Has_GL_EXT_unpack_subimage: Boolean;
  Has_GL_EXT_vertex_array: Boolean;
  Has_GL_EXT_vertex_array_bgra: Boolean;
  Has_GL_EXT_vertex_attrib_64bit: Boolean;
  Has_GL_EXT_vertex_shader: Boolean;
  Has_GL_EXT_vertex_weighting: Boolean;
  Has_GL_EXT_win32_keyed_mutex: Boolean;
  Has_GL_EXT_window_rectangles: Boolean;
  Has_GL_EXT_x11_sync_object: Boolean;
  Has_GL_FJ_shader_binary_GCCSO: Boolean;
  Has_GL_GREMEDY_frame_terminator: Boolean;
  Has_GL_GREMEDY_string_marker: Boolean;
  Has_GL_HP_convolution_border_modes: Boolean;
  Has_GL_HP_image_transform: Boolean;
  Has_GL_HP_occlusion_test: Boolean;
  Has_GL_HP_texture_lighting: Boolean;
  Has_GL_IBM_cull_vertex: Boolean;
  Has_GL_IBM_multimode_draw_arrays: Boolean;
  Has_GL_IBM_rasterpos_clip: Boolean;
  Has_GL_IBM_static_data: Boolean;
  Has_GL_IBM_texture_mirrored_repeat: Boolean;
  Has_GL_IBM_vertex_array_lists: Boolean;
  Has_GL_IMG_bindless_texture: Boolean;
  Has_GL_IMG_framebuffer_downsample: Boolean;
  Has_GL_IMG_multisampled_render_to_texture: Boolean;
  Has_GL_IMG_program_binary: Boolean;
  Has_GL_IMG_read_format: Boolean;
  Has_GL_IMG_shader_binary: Boolean;
  Has_GL_IMG_texture_compression_pvrtc: Boolean;
  Has_GL_IMG_texture_compression_pvrtc2: Boolean;
  Has_GL_IMG_texture_env_enhanced_fixed_function: Boolean;
  Has_GL_IMG_texture_filter_cubic: Boolean;
  Has_GL_IMG_user_clip_plane: Boolean;
  Has_GL_INGR_blend_func_separate: Boolean;
  Has_GL_INGR_color_clamp: Boolean;
  Has_GL_INGR_interlace_read: Boolean;
  Has_GL_INTEL_conservative_rasterization: Boolean;
  Has_GL_INTEL_fragment_shader_ordering: Boolean;
  Has_GL_INTEL_framebuffer_CMAA: Boolean;
  Has_GL_INTEL_map_texture: Boolean;
  Has_GL_INTEL_parallel_arrays: Boolean;
  Has_GL_INTEL_performance_query: Boolean;
  Has_GL_KHR_blend_equation_advanced: Boolean;
  Has_GL_KHR_blend_equation_advanced_coherent: Boolean;
  Has_GL_KHR_context_flush_control: Boolean;
  Has_GL_KHR_debug: Boolean;
  Has_GL_KHR_no_error: Boolean;
  Has_GL_KHR_robust_buffer_access_behavior: Boolean;
  Has_GL_KHR_robustness: Boolean;
  Has_GL_KHR_texture_compression_astc_hdr: Boolean;
  Has_GL_KHR_texture_compression_astc_ldr: Boolean;
  Has_GL_KHR_texture_compression_astc_sliced_3d: Boolean;
  Has_GL_MESAX_texture_stack: Boolean;
  Has_GL_MESA_pack_invert: Boolean;
  Has_GL_MESA_resize_buffers: Boolean;
  Has_GL_MESA_shader_integer_functions: Boolean;
  Has_GL_MESA_window_pos: Boolean;
  Has_GL_MESA_ycbcr_texture: Boolean;
  Has_GL_NVX_blend_equation_advanced_multi_draw_buffers: Boolean;
  Has_GL_NVX_conditional_render: Boolean;
  Has_GL_NVX_gpu_memory_info: Boolean;
  Has_GL_NVX_linked_gpu_multicast: Boolean;
  Has_GL_NV_alpha_to_coverage_dither_control: Boolean;
  Has_GL_NV_bindless_multi_draw_indirect: Boolean;
  Has_GL_NV_bindless_multi_draw_indirect_count: Boolean;
  Has_GL_NV_bindless_texture: Boolean;
  Has_GL_NV_blend_equation_advanced: Boolean;
  Has_GL_NV_blend_equation_advanced_coherent: Boolean;
  Has_GL_NV_blend_minmax_factor: Boolean;
  Has_GL_NV_blend_square: Boolean;
  Has_GL_NV_clip_space_w_scaling: Boolean;
  Has_GL_NV_command_list: Boolean;
  Has_GL_NV_compute_program5: Boolean;
  Has_GL_NV_conditional_render: Boolean;
  Has_GL_NV_conservative_raster: Boolean;
  Has_GL_NV_conservative_raster_dilate: Boolean;
  Has_GL_NV_conservative_raster_pre_snap_triangles: Boolean;
  Has_GL_NV_copy_buffer: Boolean;
  Has_GL_NV_copy_depth_to_color: Boolean;
  Has_GL_NV_copy_image: Boolean;
  Has_GL_NV_coverage_sample: Boolean;
  Has_GL_NV_deep_texture3D: Boolean;
  Has_GL_NV_depth_buffer_float: Boolean;
  Has_GL_NV_depth_clamp: Boolean;
  Has_GL_NV_depth_nonlinear: Boolean;
  Has_GL_NV_draw_buffers: Boolean;
  Has_GL_NV_draw_instanced: Boolean;
  Has_GL_NV_draw_texture: Boolean;
  Has_GL_NV_draw_vulkan_image: Boolean;
  Has_GL_NV_evaluators: Boolean;
  Has_GL_NV_explicit_attrib_location: Boolean;
  Has_GL_NV_explicit_multisample: Boolean;
  Has_GL_NV_fbo_color_attachments: Boolean;
  Has_GL_NV_fence: Boolean;
  Has_GL_NV_fill_rectangle: Boolean;
  Has_GL_NV_float_buffer: Boolean;
  Has_GL_NV_fog_distance: Boolean;
  Has_GL_NV_fragment_coverage_to_color: Boolean;
  Has_GL_NV_fragment_program: Boolean;
  Has_GL_NV_fragment_program2: Boolean;
  Has_GL_NV_fragment_program4: Boolean;
  Has_GL_NV_fragment_program_option: Boolean;
  Has_GL_NV_fragment_shader_interlock: Boolean;
  Has_GL_NV_framebuffer_blit: Boolean;
  Has_GL_NV_framebuffer_mixed_samples: Boolean;
  Has_GL_NV_framebuffer_multisample: Boolean;
  Has_GL_NV_framebuffer_multisample_coverage: Boolean;
  Has_GL_NV_generate_mipmap_sRGB: Boolean;
  Has_GL_NV_geometry_program4: Boolean;
  Has_GL_NV_geometry_shader4: Boolean;
  Has_GL_NV_geometry_shader_passthrough: Boolean;
  Has_GL_NV_gpu_program4: Boolean;
  Has_GL_NV_gpu_program5: Boolean;
  Has_GL_NV_gpu_program5_mem_extended: Boolean;
  Has_GL_NV_gpu_shader5: Boolean;
  Has_GL_NV_half_float: Boolean;
  Has_GL_NV_image_formats: Boolean;
  Has_GL_NV_instanced_arrays: Boolean;
  Has_GL_NV_internalformat_sample_query: Boolean;
  Has_GL_NV_light_max_exponent: Boolean;
  Has_GL_NV_gpu_multicast: Boolean;
  Has_GL_NV_multisample_coverage: Boolean;
  Has_GL_NV_multisample_filter_hint: Boolean;
  Has_GL_NV_non_square_matrices: Boolean;
  Has_GL_NV_occlusion_query: Boolean;
  Has_GL_NV_packed_depth_stencil: Boolean;
  Has_GL_NV_parameter_buffer_object: Boolean;
  Has_GL_NV_parameter_buffer_object2: Boolean;
  Has_GL_NV_path_rendering: Boolean;
  Has_GL_NV_path_rendering_shared_edge: Boolean;
  Has_GL_NV_pixel_data_range: Boolean;
  Has_GL_NV_pixel_buffer_object: Boolean;
  Has_GL_NV_point_sprite: Boolean;
  Has_GL_NV_polygon_mode: Boolean;
  Has_GL_NV_present_video: Boolean;
  Has_GL_NV_primitive_restart: Boolean;
  Has_GL_NV_read_buffer: Boolean;
  Has_GL_NV_read_buffer_front: Boolean;
  Has_GL_NV_read_depth: Boolean;
  Has_GL_NV_read_depth_stencil: Boolean;
  Has_GL_NV_read_stencil: Boolean;
  Has_GL_NV_register_combiners: Boolean;
  Has_GL_NV_register_combiners2: Boolean;
  Has_GL_NV_robustness_video_memory_purge: Boolean;
  Has_GL_NV_sRGB_formats: Boolean;
  Has_GL_NV_sample_locations: Boolean;
  Has_GL_NV_sample_mask_override_coverage: Boolean;
  Has_GL_NV_shader_atomic_counters: Boolean;
  Has_GL_NV_shader_atomic_float: Boolean;
  Has_GL_NV_shader_atomic_float64: Boolean;
  Has_GL_NV_shader_atomic_fp16_vector: Boolean;
  Has_GL_NV_shader_atomic_int64: Boolean;
  Has_GL_NV_shader_buffer_load: Boolean;
  Has_GL_NV_shader_buffer_store: Boolean;
  Has_GL_NV_shader_noperspective_interpolation: Boolean;
  Has_GL_NV_shader_storage_buffer_object: Boolean;
  Has_GL_NV_shader_thread_group: Boolean;
  Has_GL_NV_shader_thread_shuffle: Boolean;
  Has_GL_NV_shadow_samplers_array: Boolean;
  Has_GL_NV_shadow_samplers_cube: Boolean;
  Has_GL_NV_stereo_view_rendering: Boolean;
  Has_GL_NV_tessellation_program5: Boolean;
  Has_GL_NV_texgen_emboss: Boolean;
  Has_GL_NV_texgen_reflection: Boolean;
  Has_GL_NV_texture_barrier: Boolean;
  Has_GL_NV_texture_border_clamp: Boolean;
  Has_GL_NV_texture_compression_s3tc_update: Boolean;
  Has_GL_NV_texture_compression_vtc: Boolean;
  Has_GL_NV_texture_env_combine4: Boolean;
  Has_GL_NV_texture_expand_normal: Boolean;
  Has_GL_NV_texture_multisample: Boolean;
  Has_GL_NV_texture_npot_2D_mipmap: Boolean;
  Has_GL_NV_texture_rectangle: Boolean;
  Has_GL_NV_texture_rectangle_compressed: Boolean;
  Has_GL_NV_texture_shader: Boolean;
  Has_GL_NV_texture_shader2: Boolean;
  Has_GL_NV_texture_shader3: Boolean;
  Has_GL_NV_transform_feedback: Boolean;
  Has_GL_NV_transform_feedback2: Boolean;
  Has_GL_NV_uniform_buffer_unified_memory: Boolean;
  Has_GL_NV_vdpau_interop: Boolean;
  Has_GL_NV_vertex_array_range: Boolean;
  Has_GL_NV_vertex_array_range2: Boolean;
  Has_GL_NV_vertex_attrib_integer_64bit: Boolean;
  Has_GL_NV_vertex_buffer_unified_memory: Boolean;
  Has_GL_NV_vertex_program: Boolean;
  Has_GL_NV_vertex_program1_1: Boolean;
  Has_GL_NV_vertex_program2: Boolean;
  Has_GL_NV_vertex_program2_option: Boolean;
  Has_GL_NV_vertex_program3: Boolean;
  Has_GL_NV_vertex_program4: Boolean;
  Has_GL_NV_video_capture: Boolean;
  Has_GL_NV_viewport_array: Boolean;
  Has_GL_NV_viewport_array2: Boolean;
  Has_GL_NV_viewport_swizzle: Boolean;
  Has_GL_OES_EGL_image: Boolean;
  Has_GL_OES_EGL_image_external: Boolean;
  Has_GL_OES_EGL_image_external_essl3: Boolean;
  Has_GL_OES_blend_equation_separate: Boolean;
  Has_GL_OES_blend_func_separate: Boolean;
  Has_GL_OES_blend_subtract: Boolean;
  Has_GL_OES_byte_coordinates: Boolean;
  Has_GL_OES_compressed_ETC1_RGB8_sub_texture: Boolean;
  Has_GL_OES_compressed_ETC1_RGB8_texture: Boolean;
  Has_GL_OES_compressed_paletted_texture: Boolean;
  Has_GL_OES_copy_image: Boolean;
  Has_GL_OES_depth24: Boolean;
  Has_GL_OES_depth32: Boolean;
  Has_GL_OES_depth_texture: Boolean;
  Has_GL_OES_draw_buffers_indexed: Boolean;
  Has_GL_OES_draw_elements_base_vertex: Boolean;
  Has_GL_OES_draw_texture: Boolean;
  Has_GL_OES_element_index_uint: Boolean;
  Has_GL_OES_extended_matrix_palette: Boolean;
  Has_GL_OES_fbo_render_mipmap: Boolean;
  Has_GL_OES_fixed_point: Boolean;
  Has_GL_OES_fragment_precision_high: Boolean;
  Has_GL_OES_framebuffer_object: Boolean;
  Has_GL_OES_geometry_point_size: Boolean;
  Has_GL_OES_geometry_shader: Boolean;
  Has_GL_OES_get_program_binary: Boolean;
  Has_GL_OES_gpu_shader5: Boolean;
  Has_GL_OES_mapbuffer: Boolean;
  Has_GL_OES_matrix_get: Boolean;
  Has_GL_OES_matrix_palette: Boolean;
  Has_GL_OES_packed_depth_stencil: Boolean;
  Has_GL_OES_point_size_array: Boolean;
  Has_GL_OES_point_sprite: Boolean;
  Has_GL_OES_primitive_bounding_box: Boolean;
  Has_GL_OES_query_matrix: Boolean;
  Has_GL_OES_read_format: Boolean;
  Has_GL_OES_required_internalformat: Boolean;
  Has_GL_OES_rgb8_rgba8: Boolean;
  Has_GL_OES_sample_shading: Boolean;
  Has_GL_OES_sample_variables: Boolean;
  Has_GL_OES_shader_image_atomic: Boolean;
  Has_GL_OES_shader_io_blocks: Boolean;
  Has_GL_OES_shader_multisample_interpolation: Boolean;
  Has_GL_OES_single_precision: Boolean;
  Has_GL_OES_standard_derivatives: Boolean;
  Has_GL_OES_stencil1: Boolean;
  Has_GL_OES_stencil4: Boolean;
  Has_GL_OES_stencil8: Boolean;
  Has_GL_OES_stencil_wrap: Boolean;
  Has_GL_OES_surfaceless_context: Boolean;
  Has_GL_OES_tessellation_point_size: Boolean;
  Has_GL_OES_tessellation_shader: Boolean;
  Has_GL_OES_texture_3D: Boolean;
  Has_GL_OES_texture_border_clamp: Boolean;
  Has_GL_OES_texture_buffer: Boolean;
  Has_GL_OES_texture_compression_astc: Boolean;
  Has_GL_OES_texture_cube_map: Boolean;
  Has_GL_OES_texture_cube_map_array: Boolean;
  Has_GL_OES_texture_env_crossbar: Boolean;
  Has_GL_OES_texture_float: Boolean;
  Has_GL_OES_texture_float_linear: Boolean;
  Has_GL_OES_texture_half_float: Boolean;
  Has_GL_OES_texture_half_float_linear: Boolean;
  Has_GL_OES_texture_mirrored_repeat: Boolean;
  Has_GL_OES_texture_npot: Boolean;
  Has_GL_OES_texture_stencil8: Boolean;
  Has_GL_OES_texture_storage_multisample_2d_array: Boolean;
  Has_GL_OES_texture_view: Boolean;
  Has_GL_OES_vertex_array_object: Boolean;
  Has_GL_OES_vertex_half_float: Boolean;
  Has_GL_OES_vertex_type_10_10_10_2: Boolean;
  Has_GL_OES_viewport_array: Boolean;
  Has_GL_OML_interlace: Boolean;
  Has_GL_OML_resample: Boolean;
  Has_GL_OML_subsample: Boolean;
  Has_GL_OVR_multiview: Boolean;
  Has_GL_OVR_multiview2: Boolean;
  Has_GL_OVR_multiview_multisampled_render_to_texture: Boolean;
  Has_GL_PGI_misc_hints: Boolean;
  Has_GL_PGI_vertex_hints: Boolean;
  Has_GL_QCOM_alpha_test: Boolean;
  Has_GL_QCOM_binning_control: Boolean;
  Has_GL_QCOM_driver_control: Boolean;
  Has_GL_QCOM_extended_get: Boolean;
  Has_GL_QCOM_extended_get2: Boolean;
  Has_GL_QCOM_framebuffer_foveated: Boolean;
  Has_GL_QCOM_perfmon_global_mode: Boolean;
  Has_GL_QCOM_shader_framebuffer_fetch_noncoherent: Boolean;
  Has_GL_QCOM_tiled_rendering: Boolean;
  Has_GL_QCOM_writeonly_rendering: Boolean;
  Has_GL_REND_screen_coordinates: Boolean;
  Has_GL_S3_s3tc: Boolean;
  Has_GL_SGIS_detail_texture: Boolean;
  Has_GL_SGIS_fog_function: Boolean;
  Has_GL_SGIS_generate_mipmap: Boolean;
  Has_GL_SGIS_multisample: Boolean;
  Has_GL_SGIS_pixel_texture: Boolean;
  Has_GL_SGIS_point_line_texgen: Boolean;
  Has_GL_SGIS_point_parameters: Boolean;
  Has_GL_SGIS_sharpen_texture: Boolean;
  Has_GL_SGIS_texture4D: Boolean;
  Has_GL_SGIS_texture_border_clamp: Boolean;
  Has_GL_SGIS_texture_color_mask: Boolean;
  Has_GL_SGIS_texture_edge_clamp: Boolean;
  Has_GL_SGIS_texture_filter4: Boolean;
  Has_GL_SGIS_texture_lod: Boolean;
  Has_GL_SGIS_texture_select: Boolean;
  Has_GL_SGIX_async: Boolean;
  Has_GL_SGIX_async_histogram: Boolean;
  Has_GL_SGIX_async_pixel: Boolean;
  Has_GL_SGIX_blend_alpha_minmax: Boolean;
  Has_GL_SGIX_calligraphic_fragment: Boolean;
  Has_GL_SGIX_clipmap: Boolean;
  Has_GL_SGIX_convolution_accuracy: Boolean;
  Has_GL_SGIX_depth_pass_instrument: Boolean;
  Has_GL_SGIX_depth_texture: Boolean;
  Has_GL_SGIX_flush_raster: Boolean;
  Has_GL_SGIX_fog_offset: Boolean;
  Has_GL_SGIX_fragment_lighting: Boolean;
  Has_GL_SGIX_framezoom: Boolean;
  Has_GL_SGIX_igloo_interface: Boolean;
  Has_GL_SGIX_instruments: Boolean;
  Has_GL_SGIX_interlace: Boolean;
  Has_GL_SGIX_ir_instrument1: Boolean;
  Has_GL_SGIX_list_priority: Boolean;
  Has_GL_SGIX_pixel_texture: Boolean;
  Has_GL_SGIX_pixel_tiles: Boolean;
  Has_GL_SGIX_polynomial_ffd: Boolean;
  Has_GL_SGIX_reference_plane: Boolean;
  Has_GL_SGIX_resample: Boolean;
  Has_GL_SGIX_scalebias_hint: Boolean;
  Has_GL_SGIX_shadow: Boolean;
  Has_GL_SGIX_shadow_ambient: Boolean;
  Has_GL_SGIX_sprite: Boolean;
  Has_GL_SGIX_subsample: Boolean;
  Has_GL_SGIX_tag_sample_buffer: Boolean;
  Has_GL_SGIX_texture_add_env: Boolean;
  Has_GL_SGIX_texture_coordinate_clamp: Boolean;
  Has_GL_SGIX_texture_lod_bias: Boolean;
  Has_GL_SGIX_texture_multi_buffer: Boolean;
  Has_GL_SGIX_texture_scale_bias: Boolean;
  Has_GL_SGIX_vertex_preclip: Boolean;
  Has_GL_SGIX_ycrcb: Boolean;
  Has_GL_SGIX_ycrcb_subsample: Boolean;
  Has_GL_SGIX_ycrcba: Boolean;
  Has_GL_SGI_color_matrix: Boolean;
  Has_GL_SGI_color_table: Boolean;
  Has_GL_SGI_texture_color_table: Boolean;
  Has_GL_SUNX_constant_data: Boolean;
  Has_GL_SUN_convolution_border_modes: Boolean;
  Has_GL_SUN_global_alpha: Boolean;
  Has_GL_SUN_mesh_array: Boolean;
  Has_GL_SUN_slice_accum: Boolean;
  Has_GL_SUN_triangle_list: Boolean;
  Has_GL_SUN_vertex: Boolean;
  Has_GL_VIV_shader_binary: Boolean;
  Has_GL_WIN_phong_shading: Boolean;
  Has_GL_WIN_specular_fog: Boolean;
  AllExtensions: TStringList;

function HasExtension(Name: string): Boolean;
function LoadGLProcs: Boolean;
function GL_TIMEOUT_IGNORED: GLint64;
function GL_TIMEOUT_IGNORED_APPLE: GLint64;

implementation
uses Math;
procedure FillExtensions;
var
  ExtStr, EName: string;
  I: Integer;
begin
  ExtStr:=string(PChar(glGetString(GL_EXTENSIONS))) + ' ';
  EName:='';
  if not Assigned(AllExtensions) then AllExtensions:=TStringList.Create;
  AllExtensions.Clear;
  for I:=1 to Length(ExtStr) do begin
    if ExtStr[I]=' ' then begin
      if EName <> '' then begin
        AllExtensions.Add(EName);
      end;
      EName:='';
    end else EName:=EName + ExtStr[I];
  end;
end;

function HasExtension(Name: string): Boolean;
var
  I: Integer;
begin
  for I:=0 to AllExtensions.Count - 1 do
    if AllExtensions[I]=Name then begin
      Result:=True;
      Exit;
    end;
  Result:=False;
end;
type
  LibHandle = Cardinal;
const FailedHandle = 0;
function LoadLibrary(lpLibFileName:PChar):LibHandle; stdcall external 'kernel32' name 'LoadLibraryA';
function GetProcAddress(hModule:LibHandle; lpProcName:PChar):Pointer; stdcall external 'kernel32' name 'GetProcAddress';
function GLGetProcAddr(name: PChar): Pointer; stdcall external 'opengl32' name 'wglGetProcAddress';

// Delphi 2 seems to be unable to handle all the string literals in a single
// procedure (it compiles but after some calls literals become corrupted), so
// the Part1/2/3 procedures here are used to split loading

var
  Lib: LibHandle;

procedure Part1; forward;
procedure Part2; forward;
procedure Part3; forward;

function LoadGLProcs: Boolean;
begin
  // Load base OpenGL library
  Result:=True;
  Lib:=LoadLibrary('opengl32');
  if Lib=FailedHandle then begin
    Result:=False;
    Exit;
  end;
  Part1;
  Part2;
  Part3;
end;

procedure Part1;
begin
  // Try to load ALL OpenGL procs
  glAccum:=TglAccum(GLGetProcAddr('glAccum'));
  if not Assigned(glAccum) then
    glAccum:=TglAccum(GetProcAddress(Lib, 'glAccum'));
  glAccumxOES:=TglAccumxOES(GLGetProcAddr('glAccumxOES'));
  if not Assigned(glAccumxOES) then
    glAccumxOES:=TglAccumxOES(GetProcAddress(Lib, 'glAccumxOES'));
  glActiveProgramEXT:=TglActiveProgramEXT(GLGetProcAddr('glActiveProgramEXT'));
  if not Assigned(glActiveProgramEXT) then
    glActiveProgramEXT:=TglActiveProgramEXT(GetProcAddress(Lib, 'glActiveProgramEXT'));
  glActiveShaderProgram:=TglActiveShaderProgram(GLGetProcAddr('glActiveShaderProgram'));
  if not Assigned(glActiveShaderProgram) then
    glActiveShaderProgram:=TglActiveShaderProgram(GetProcAddress(Lib, 'glActiveShaderProgram'));
  glActiveShaderProgramEXT:=TglActiveShaderProgramEXT(GLGetProcAddr('glActiveShaderProgramEXT'));
  if not Assigned(glActiveShaderProgramEXT) then
    glActiveShaderProgramEXT:=TglActiveShaderProgramEXT(GetProcAddress(Lib, 'glActiveShaderProgramEXT'));
  glActiveStencilFaceEXT:=TglActiveStencilFaceEXT(GLGetProcAddr('glActiveStencilFaceEXT'));
  if not Assigned(glActiveStencilFaceEXT) then
    glActiveStencilFaceEXT:=TglActiveStencilFaceEXT(GetProcAddress(Lib, 'glActiveStencilFaceEXT'));
  glActiveTexture:=TglActiveTexture(GLGetProcAddr('glActiveTexture'));
  if not Assigned(glActiveTexture) then
    glActiveTexture:=TglActiveTexture(GetProcAddress(Lib, 'glActiveTexture'));
  glActiveTextureARB:=TglActiveTextureARB(GLGetProcAddr('glActiveTextureARB'));
  if not Assigned(glActiveTextureARB) then
    glActiveTextureARB:=TglActiveTextureARB(GetProcAddress(Lib, 'glActiveTextureARB'));
  glActiveVaryingNV:=TglActiveVaryingNV(GLGetProcAddr('glActiveVaryingNV'));
  if not Assigned(glActiveVaryingNV) then
    glActiveVaryingNV:=TglActiveVaryingNV(GetProcAddress(Lib, 'glActiveVaryingNV'));
  glAlphaFragmentOp1ATI:=TglAlphaFragmentOp1ATI(GLGetProcAddr('glAlphaFragmentOp1ATI'));
  if not Assigned(glAlphaFragmentOp1ATI) then
    glAlphaFragmentOp1ATI:=TglAlphaFragmentOp1ATI(GetProcAddress(Lib, 'glAlphaFragmentOp1ATI'));
  glAlphaFragmentOp2ATI:=TglAlphaFragmentOp2ATI(GLGetProcAddr('glAlphaFragmentOp2ATI'));
  if not Assigned(glAlphaFragmentOp2ATI) then 
    glAlphaFragmentOp2ATI:=TglAlphaFragmentOp2ATI(GetProcAddress(Lib, 'glAlphaFragmentOp2ATI'));
  glAlphaFragmentOp3ATI:=TglAlphaFragmentOp3ATI(GLGetProcAddr('glAlphaFragmentOp3ATI'));
  if not Assigned(glAlphaFragmentOp3ATI) then 
    glAlphaFragmentOp3ATI:=TglAlphaFragmentOp3ATI(GetProcAddress(Lib, 'glAlphaFragmentOp3ATI'));
  glAlphaFunc:=TglAlphaFunc(GLGetProcAddr('glAlphaFunc'));
  if not Assigned(glAlphaFunc) then 
    glAlphaFunc:=TglAlphaFunc(GetProcAddress(Lib, 'glAlphaFunc'));
  glAlphaFuncQCOM:=TglAlphaFuncQCOM(GLGetProcAddr('glAlphaFuncQCOM'));
  if not Assigned(glAlphaFuncQCOM) then 
    glAlphaFuncQCOM:=TglAlphaFuncQCOM(GetProcAddress(Lib, 'glAlphaFuncQCOM'));
  glAlphaFuncx:=TglAlphaFuncx(GLGetProcAddr('glAlphaFuncx'));
  if not Assigned(glAlphaFuncx) then 
    glAlphaFuncx:=TglAlphaFuncx(GetProcAddress(Lib, 'glAlphaFuncx'));
  glAlphaFuncxOES:=TglAlphaFuncxOES(GLGetProcAddr('glAlphaFuncxOES'));
  if not Assigned(glAlphaFuncxOES) then 
    glAlphaFuncxOES:=TglAlphaFuncxOES(GetProcAddress(Lib, 'glAlphaFuncxOES'));
  glAlphaToCoverageDitherControlNV:=TglAlphaToCoverageDitherControlNV(GLGetProcAddr('glAlphaToCoverageDitherControlNV'));
  if not Assigned(glAlphaToCoverageDitherControlNV) then 
    glAlphaToCoverageDitherControlNV:=TglAlphaToCoverageDitherControlNV(GetProcAddress(Lib, 'glAlphaToCoverageDitherControlNV'));
  glApplyFramebufferAttachmentCMAAINTEL:=TglApplyFramebufferAttachmentCMAAINTEL(GLGetProcAddr('glApplyFramebufferAttachmentCMAAINTEL'));
  if not Assigned(glApplyFramebufferAttachmentCMAAINTEL) then 
    glApplyFramebufferAttachmentCMAAINTEL:=TglApplyFramebufferAttachmentCMAAINTEL(GetProcAddress(Lib, 'glApplyFramebufferAttachmentCMAAINTEL'));
  glApplyTextureEXT:=TglApplyTextureEXT(GLGetProcAddr('glApplyTextureEXT'));
  if not Assigned(glApplyTextureEXT) then 
    glApplyTextureEXT:=TglApplyTextureEXT(GetProcAddress(Lib, 'glApplyTextureEXT'));
  glAcquireKeyedMutexWin32EXT:=TglAcquireKeyedMutexWin32EXT(GLGetProcAddr('glAcquireKeyedMutexWin32EXT'));
  if not Assigned(glAcquireKeyedMutexWin32EXT) then 
    glAcquireKeyedMutexWin32EXT:=TglAcquireKeyedMutexWin32EXT(GetProcAddress(Lib, 'glAcquireKeyedMutexWin32EXT'));
  glAreProgramsResidentNV:=TglAreProgramsResidentNV(GLGetProcAddr('glAreProgramsResidentNV'));
  if not Assigned(glAreProgramsResidentNV) then 
    glAreProgramsResidentNV:=TglAreProgramsResidentNV(GetProcAddress(Lib, 'glAreProgramsResidentNV'));
  glAreTexturesResident:=TglAreTexturesResident(GLGetProcAddr('glAreTexturesResident'));
  if not Assigned(glAreTexturesResident) then 
    glAreTexturesResident:=TglAreTexturesResident(GetProcAddress(Lib, 'glAreTexturesResident'));
  glAreTexturesResidentEXT:=TglAreTexturesResidentEXT(GLGetProcAddr('glAreTexturesResidentEXT'));
  if not Assigned(glAreTexturesResidentEXT) then 
    glAreTexturesResidentEXT:=TglAreTexturesResidentEXT(GetProcAddress(Lib, 'glAreTexturesResidentEXT'));
  glArrayElement:=TglArrayElement(GLGetProcAddr('glArrayElement'));
  if not Assigned(glArrayElement) then 
    glArrayElement:=TglArrayElement(GetProcAddress(Lib, 'glArrayElement'));
  glArrayElementEXT:=TglArrayElementEXT(GLGetProcAddr('glArrayElementEXT'));
  if not Assigned(glArrayElementEXT) then 
    glArrayElementEXT:=TglArrayElementEXT(GetProcAddress(Lib, 'glArrayElementEXT'));
  glArrayObjectATI:=TglArrayObjectATI(GLGetProcAddr('glArrayObjectATI'));
  if not Assigned(glArrayObjectATI) then
    glArrayObjectATI:=TglArrayObjectATI(GetProcAddress(Lib, 'glArrayObjectATI'));
  glAsyncMarkerSGIX:=TglAsyncMarkerSGIX(GLGetProcAddr('glAsyncMarkerSGIX'));
  if not Assigned(glAsyncMarkerSGIX) then
    glAsyncMarkerSGIX:=TglAsyncMarkerSGIX(GetProcAddress(Lib, 'glAsyncMarkerSGIX'));
  glAttachObjectARB:=TglAttachObjectARB(GLGetProcAddr('glAttachObjectARB'));
  if not Assigned(glAttachObjectARB) then 
    glAttachObjectARB:=TglAttachObjectARB(GetProcAddress(Lib, 'glAttachObjectARB'));
  glAttachShader:=TglAttachShader(GLGetProcAddr('glAttachShader'));
  if not Assigned(glAttachShader) then 
    glAttachShader:=TglAttachShader(GetProcAddress(Lib, 'glAttachShader'));
  glBegin:=TglBegin(GLGetProcAddr('glBegin'));
  if not Assigned(glBegin) then 
    glBegin:=TglBegin(GetProcAddress(Lib, 'glBegin'));
  glBeginConditionalRender:=TglBeginConditionalRender(GLGetProcAddr('glBeginConditionalRender'));
  if not Assigned(glBeginConditionalRender) then 
    glBeginConditionalRender:=TglBeginConditionalRender(GetProcAddress(Lib, 'glBeginConditionalRender'));
  glBeginConditionalRenderNV:=TglBeginConditionalRenderNV(GLGetProcAddr('glBeginConditionalRenderNV'));
  if not Assigned(glBeginConditionalRenderNV) then 
    glBeginConditionalRenderNV:=TglBeginConditionalRenderNV(GetProcAddress(Lib, 'glBeginConditionalRenderNV'));
  glBeginConditionalRenderNVX:=TglBeginConditionalRenderNVX(GLGetProcAddr('glBeginConditionalRenderNVX'));
  if not Assigned(glBeginConditionalRenderNVX) then 
    glBeginConditionalRenderNVX:=TglBeginConditionalRenderNVX(GetProcAddress(Lib, 'glBeginConditionalRenderNVX'));
  glBeginFragmentShaderATI:=TglBeginFragmentShaderATI(GLGetProcAddr('glBeginFragmentShaderATI'));
  if not Assigned(glBeginFragmentShaderATI) then 
    glBeginFragmentShaderATI:=TglBeginFragmentShaderATI(GetProcAddress(Lib, 'glBeginFragmentShaderATI'));
  glBeginOcclusionQueryNV:=TglBeginOcclusionQueryNV(GLGetProcAddr('glBeginOcclusionQueryNV'));
  if not Assigned(glBeginOcclusionQueryNV) then 
    glBeginOcclusionQueryNV:=TglBeginOcclusionQueryNV(GetProcAddress(Lib, 'glBeginOcclusionQueryNV'));
  glBeginPerfMonitorAMD:=TglBeginPerfMonitorAMD(GLGetProcAddr('glBeginPerfMonitorAMD'));
  if not Assigned(glBeginPerfMonitorAMD) then 
    glBeginPerfMonitorAMD:=TglBeginPerfMonitorAMD(GetProcAddress(Lib, 'glBeginPerfMonitorAMD'));
  glBeginPerfQueryINTEL:=TglBeginPerfQueryINTEL(GLGetProcAddr('glBeginPerfQueryINTEL'));
  if not Assigned(glBeginPerfQueryINTEL) then 
    glBeginPerfQueryINTEL:=TglBeginPerfQueryINTEL(GetProcAddress(Lib, 'glBeginPerfQueryINTEL'));
  glBeginQuery:=TglBeginQuery(GLGetProcAddr('glBeginQuery'));
  if not Assigned(glBeginQuery) then 
    glBeginQuery:=TglBeginQuery(GetProcAddress(Lib, 'glBeginQuery'));
  glBeginQueryARB:=TglBeginQueryARB(GLGetProcAddr('glBeginQueryARB'));
  if not Assigned(glBeginQueryARB) then 
    glBeginQueryARB:=TglBeginQueryARB(GetProcAddress(Lib, 'glBeginQueryARB'));
  glBeginQueryEXT:=TglBeginQueryEXT(GLGetProcAddr('glBeginQueryEXT'));
  if not Assigned(glBeginQueryEXT) then 
    glBeginQueryEXT:=TglBeginQueryEXT(GetProcAddress(Lib, 'glBeginQueryEXT'));
  glBeginQueryIndexed:=TglBeginQueryIndexed(GLGetProcAddr('glBeginQueryIndexed'));
  if not Assigned(glBeginQueryIndexed) then 
    glBeginQueryIndexed:=TglBeginQueryIndexed(GetProcAddress(Lib, 'glBeginQueryIndexed'));
  glBeginTransformFeedback:=TglBeginTransformFeedback(GLGetProcAddr('glBeginTransformFeedback'));
  if not Assigned(glBeginTransformFeedback) then 
    glBeginTransformFeedback:=TglBeginTransformFeedback(GetProcAddress(Lib, 'glBeginTransformFeedback'));
  glBeginTransformFeedbackEXT:=TglBeginTransformFeedbackEXT(GLGetProcAddr('glBeginTransformFeedbackEXT'));
  if not Assigned(glBeginTransformFeedbackEXT) then 
    glBeginTransformFeedbackEXT:=TglBeginTransformFeedbackEXT(GetProcAddress(Lib, 'glBeginTransformFeedbackEXT'));
  glBeginTransformFeedbackNV:=TglBeginTransformFeedbackNV(GLGetProcAddr('glBeginTransformFeedbackNV'));
  if not Assigned(glBeginTransformFeedbackNV) then 
    glBeginTransformFeedbackNV:=TglBeginTransformFeedbackNV(GetProcAddress(Lib, 'glBeginTransformFeedbackNV'));
  glBeginVertexShaderEXT:=TglBeginVertexShaderEXT(GLGetProcAddr('glBeginVertexShaderEXT'));
  if not Assigned(glBeginVertexShaderEXT) then 
    glBeginVertexShaderEXT:=TglBeginVertexShaderEXT(GetProcAddress(Lib, 'glBeginVertexShaderEXT'));
  glBeginVideoCaptureNV:=TglBeginVideoCaptureNV(GLGetProcAddr('glBeginVideoCaptureNV'));
  if not Assigned(glBeginVideoCaptureNV) then
    glBeginVideoCaptureNV:=TglBeginVideoCaptureNV(GetProcAddress(Lib, 'glBeginVideoCaptureNV'));
  glBindAttribLocation:=TglBindAttribLocation(GLGetProcAddr('glBindAttribLocation'));
  if not Assigned(glBindAttribLocation) then 
    glBindAttribLocation:=TglBindAttribLocation(GetProcAddress(Lib, 'glBindAttribLocation'));
  glBindAttribLocationARB:=TglBindAttribLocationARB(GLGetProcAddr('glBindAttribLocationARB'));
  if not Assigned(glBindAttribLocationARB) then 
    glBindAttribLocationARB:=TglBindAttribLocationARB(GetProcAddress(Lib, 'glBindAttribLocationARB'));
  glBindBuffer:=TglBindBuffer(GLGetProcAddr('glBindBuffer'));
  if not Assigned(glBindBuffer) then 
    glBindBuffer:=TglBindBuffer(GetProcAddress(Lib, 'glBindBuffer'));
  glBindBufferARB:=TglBindBufferARB(GLGetProcAddr('glBindBufferARB'));
  if not Assigned(glBindBufferARB) then 
    glBindBufferARB:=TglBindBufferARB(GetProcAddress(Lib, 'glBindBufferARB'));
  glBindBufferBase:=TglBindBufferBase(GLGetProcAddr('glBindBufferBase'));
  if not Assigned(glBindBufferBase) then 
    glBindBufferBase:=TglBindBufferBase(GetProcAddress(Lib, 'glBindBufferBase'));
  glBindBufferBaseEXT:=TglBindBufferBaseEXT(GLGetProcAddr('glBindBufferBaseEXT'));
  if not Assigned(glBindBufferBaseEXT) then
    glBindBufferBaseEXT:=TglBindBufferBaseEXT(GetProcAddress(Lib, 'glBindBufferBaseEXT'));
  glBindBufferBaseNV:=TglBindBufferBaseNV(GLGetProcAddr('glBindBufferBaseNV'));
  if not Assigned(glBindBufferBaseNV) then 
    glBindBufferBaseNV:=TglBindBufferBaseNV(GetProcAddress(Lib, 'glBindBufferBaseNV'));
  glBindBufferOffsetEXT:=TglBindBufferOffsetEXT(GLGetProcAddr('glBindBufferOffsetEXT'));
  if not Assigned(glBindBufferOffsetEXT) then 
    glBindBufferOffsetEXT:=TglBindBufferOffsetEXT(GetProcAddress(Lib, 'glBindBufferOffsetEXT'));
  glBindBufferOffsetNV:=TglBindBufferOffsetNV(GLGetProcAddr('glBindBufferOffsetNV'));
  if not Assigned(glBindBufferOffsetNV) then 
    glBindBufferOffsetNV:=TglBindBufferOffsetNV(GetProcAddress(Lib, 'glBindBufferOffsetNV'));
  glBindBufferRange:=TglBindBufferRange(GLGetProcAddr('glBindBufferRange'));
  if not Assigned(glBindBufferRange) then 
    glBindBufferRange:=TglBindBufferRange(GetProcAddress(Lib, 'glBindBufferRange'));
  glBindBufferRangeEXT:=TglBindBufferRangeEXT(GLGetProcAddr('glBindBufferRangeEXT'));
  if not Assigned(glBindBufferRangeEXT) then 
    glBindBufferRangeEXT:=TglBindBufferRangeEXT(GetProcAddress(Lib, 'glBindBufferRangeEXT'));
  glBindBufferRangeNV:=TglBindBufferRangeNV(GLGetProcAddr('glBindBufferRangeNV'));
  if not Assigned(glBindBufferRangeNV) then 
    glBindBufferRangeNV:=TglBindBufferRangeNV(GetProcAddress(Lib, 'glBindBufferRangeNV'));
  glBindBuffersBase:=TglBindBuffersBase(GLGetProcAddr('glBindBuffersBase'));
  if not Assigned(glBindBuffersBase) then 
    glBindBuffersBase:=TglBindBuffersBase(GetProcAddress(Lib, 'glBindBuffersBase'));
  glBindBuffersRange:=TglBindBuffersRange(GLGetProcAddr('glBindBuffersRange'));
  if not Assigned(glBindBuffersRange) then 
    glBindBuffersRange:=TglBindBuffersRange(GetProcAddress(Lib, 'glBindBuffersRange'));
  glBindFragDataLocation:=TglBindFragDataLocation(GLGetProcAddr('glBindFragDataLocation'));
  if not Assigned(glBindFragDataLocation) then 
    glBindFragDataLocation:=TglBindFragDataLocation(GetProcAddress(Lib, 'glBindFragDataLocation'));
  glBindFragDataLocationEXT:=TglBindFragDataLocationEXT(GLGetProcAddr('glBindFragDataLocationEXT'));
  if not Assigned(glBindFragDataLocationEXT) then 
    glBindFragDataLocationEXT:=TglBindFragDataLocationEXT(GetProcAddress(Lib, 'glBindFragDataLocationEXT'));
  glBindFragDataLocationIndexed:=TglBindFragDataLocationIndexed(GLGetProcAddr('glBindFragDataLocationIndexed'));
  if not Assigned(glBindFragDataLocationIndexed) then 
    glBindFragDataLocationIndexed:=TglBindFragDataLocationIndexed(GetProcAddress(Lib, 'glBindFragDataLocationIndexed'));
  glBindFragDataLocationIndexedEXT:=TglBindFragDataLocationIndexedEXT(GLGetProcAddr('glBindFragDataLocationIndexedEXT'));
  if not Assigned(glBindFragDataLocationIndexedEXT) then 
    glBindFragDataLocationIndexedEXT:=TglBindFragDataLocationIndexedEXT(GetProcAddress(Lib, 'glBindFragDataLocationIndexedEXT'));
  glBindFragmentShaderATI:=TglBindFragmentShaderATI(GLGetProcAddr('glBindFragmentShaderATI'));
  if not Assigned(glBindFragmentShaderATI) then
    glBindFragmentShaderATI:=TglBindFragmentShaderATI(GetProcAddress(Lib, 'glBindFragmentShaderATI'));
  glBindFramebuffer:=TglBindFramebuffer(GLGetProcAddr('glBindFramebuffer'));
  if not Assigned(glBindFramebuffer) then 
    glBindFramebuffer:=TglBindFramebuffer(GetProcAddress(Lib, 'glBindFramebuffer'));
  glBindFramebufferEXT:=TglBindFramebufferEXT(GLGetProcAddr('glBindFramebufferEXT'));
  if not Assigned(glBindFramebufferEXT) then 
    glBindFramebufferEXT:=TglBindFramebufferEXT(GetProcAddress(Lib, 'glBindFramebufferEXT'));
  glBindFramebufferOES:=TglBindFramebufferOES(GLGetProcAddr('glBindFramebufferOES'));
  if not Assigned(glBindFramebufferOES) then 
    glBindFramebufferOES:=TglBindFramebufferOES(GetProcAddress(Lib, 'glBindFramebufferOES'));
  glBindImageTexture:=TglBindImageTexture(GLGetProcAddr('glBindImageTexture'));
  if not Assigned(glBindImageTexture) then 
    glBindImageTexture:=TglBindImageTexture(GetProcAddress(Lib, 'glBindImageTexture'));
  glBindImageTextureEXT:=TglBindImageTextureEXT(GLGetProcAddr('glBindImageTextureEXT'));
  if not Assigned(glBindImageTextureEXT) then 
    glBindImageTextureEXT:=TglBindImageTextureEXT(GetProcAddress(Lib, 'glBindImageTextureEXT'));
  glBindImageTextures:=TglBindImageTextures(GLGetProcAddr('glBindImageTextures'));
  if not Assigned(glBindImageTextures) then 
    glBindImageTextures:=TglBindImageTextures(GetProcAddress(Lib, 'glBindImageTextures'));
  glBindLightParameterEXT:=TglBindLightParameterEXT(GLGetProcAddr('glBindLightParameterEXT'));
  if not Assigned(glBindLightParameterEXT) then 
    glBindLightParameterEXT:=TglBindLightParameterEXT(GetProcAddress(Lib, 'glBindLightParameterEXT'));
  glBindMaterialParameterEXT:=TglBindMaterialParameterEXT(GLGetProcAddr('glBindMaterialParameterEXT'));
  if not Assigned(glBindMaterialParameterEXT) then 
    glBindMaterialParameterEXT:=TglBindMaterialParameterEXT(GetProcAddress(Lib, 'glBindMaterialParameterEXT'));
  glBindMultiTextureEXT:=TglBindMultiTextureEXT(GLGetProcAddr('glBindMultiTextureEXT'));
  if not Assigned(glBindMultiTextureEXT) then 
    glBindMultiTextureEXT:=TglBindMultiTextureEXT(GetProcAddress(Lib, 'glBindMultiTextureEXT'));
  glBindParameterEXT:=TglBindParameterEXT(GLGetProcAddr('glBindParameterEXT'));
  if not Assigned(glBindParameterEXT) then 
    glBindParameterEXT:=TglBindParameterEXT(GetProcAddress(Lib, 'glBindParameterEXT'));
  glBindProgramARB:=TglBindProgramARB(GLGetProcAddr('glBindProgramARB'));
  if not Assigned(glBindProgramARB) then 
    glBindProgramARB:=TglBindProgramARB(GetProcAddress(Lib, 'glBindProgramARB'));
  glBindProgramNV:=TglBindProgramNV(GLGetProcAddr('glBindProgramNV'));
  if not Assigned(glBindProgramNV) then 
    glBindProgramNV:=TglBindProgramNV(GetProcAddress(Lib, 'glBindProgramNV'));
  glBindProgramPipeline:=TglBindProgramPipeline(GLGetProcAddr('glBindProgramPipeline'));
  if not Assigned(glBindProgramPipeline) then
    glBindProgramPipeline:=TglBindProgramPipeline(GetProcAddress(Lib, 'glBindProgramPipeline'));
  glBindProgramPipelineEXT:=TglBindProgramPipelineEXT(GLGetProcAddr('glBindProgramPipelineEXT'));
  if not Assigned(glBindProgramPipelineEXT) then 
    glBindProgramPipelineEXT:=TglBindProgramPipelineEXT(GetProcAddress(Lib, 'glBindProgramPipelineEXT'));
  glBindRenderbuffer:=TglBindRenderbuffer(GLGetProcAddr('glBindRenderbuffer'));
  if not Assigned(glBindRenderbuffer) then 
    glBindRenderbuffer:=TglBindRenderbuffer(GetProcAddress(Lib, 'glBindRenderbuffer'));
  glBindRenderbufferEXT:=TglBindRenderbufferEXT(GLGetProcAddr('glBindRenderbufferEXT'));
  if not Assigned(glBindRenderbufferEXT) then 
    glBindRenderbufferEXT:=TglBindRenderbufferEXT(GetProcAddress(Lib, 'glBindRenderbufferEXT'));
  glBindRenderbufferOES:=TglBindRenderbufferOES(GLGetProcAddr('glBindRenderbufferOES'));
  if not Assigned(glBindRenderbufferOES) then 
    glBindRenderbufferOES:=TglBindRenderbufferOES(GetProcAddress(Lib, 'glBindRenderbufferOES'));
  glBindSampler:=TglBindSampler(GLGetProcAddr('glBindSampler'));
  if not Assigned(glBindSampler) then 
    glBindSampler:=TglBindSampler(GetProcAddress(Lib, 'glBindSampler'));
  glBindSamplers:=TglBindSamplers(GLGetProcAddr('glBindSamplers'));
  if not Assigned(glBindSamplers) then
    glBindSamplers:=TglBindSamplers(GetProcAddress(Lib, 'glBindSamplers'));
  glBindTexGenParameterEXT:=TglBindTexGenParameterEXT(GLGetProcAddr('glBindTexGenParameterEXT'));
  if not Assigned(glBindTexGenParameterEXT) then 
    glBindTexGenParameterEXT:=TglBindTexGenParameterEXT(GetProcAddress(Lib, 'glBindTexGenParameterEXT'));
  glBindTexture:=TglBindTexture(GLGetProcAddr('glBindTexture'));
  if not Assigned(glBindTexture) then 
    glBindTexture:=TglBindTexture(GetProcAddress(Lib, 'glBindTexture'));
  glBindTextureEXT:=TglBindTextureEXT(GLGetProcAddr('glBindTextureEXT'));
  if not Assigned(glBindTextureEXT) then 
    glBindTextureEXT:=TglBindTextureEXT(GetProcAddress(Lib, 'glBindTextureEXT'));
  glBindTextureUnit:=TglBindTextureUnit(GLGetProcAddr('glBindTextureUnit'));
  if not Assigned(glBindTextureUnit) then 
    glBindTextureUnit:=TglBindTextureUnit(GetProcAddress(Lib, 'glBindTextureUnit'));
  glBindTextureUnitParameterEXT:=TglBindTextureUnitParameterEXT(GLGetProcAddr('glBindTextureUnitParameterEXT'));
  if not Assigned(glBindTextureUnitParameterEXT) then 
    glBindTextureUnitParameterEXT:=TglBindTextureUnitParameterEXT(GetProcAddress(Lib, 'glBindTextureUnitParameterEXT'));
  glBindTextures:=TglBindTextures(GLGetProcAddr('glBindTextures'));
  if not Assigned(glBindTextures) then 
    glBindTextures:=TglBindTextures(GetProcAddress(Lib, 'glBindTextures'));
  glBindTransformFeedback:=TglBindTransformFeedback(GLGetProcAddr('glBindTransformFeedback'));
  if not Assigned(glBindTransformFeedback) then 
    glBindTransformFeedback:=TglBindTransformFeedback(GetProcAddress(Lib, 'glBindTransformFeedback'));
  glBindTransformFeedbackNV:=TglBindTransformFeedbackNV(GLGetProcAddr('glBindTransformFeedbackNV'));
  if not Assigned(glBindTransformFeedbackNV) then 
    glBindTransformFeedbackNV:=TglBindTransformFeedbackNV(GetProcAddress(Lib, 'glBindTransformFeedbackNV'));
  glBindVertexArray:=TglBindVertexArray(GLGetProcAddr('glBindVertexArray'));
  if not Assigned(glBindVertexArray) then 
    glBindVertexArray:=TglBindVertexArray(GetProcAddress(Lib, 'glBindVertexArray'));
  glBindVertexArrayAPPLE:=TglBindVertexArrayAPPLE(GLGetProcAddr('glBindVertexArrayAPPLE'));
  if not Assigned(glBindVertexArrayAPPLE) then 
    glBindVertexArrayAPPLE:=TglBindVertexArrayAPPLE(GetProcAddress(Lib, 'glBindVertexArrayAPPLE'));
  glBindVertexArrayOES:=TglBindVertexArrayOES(GLGetProcAddr('glBindVertexArrayOES'));
  if not Assigned(glBindVertexArrayOES) then 
    glBindVertexArrayOES:=TglBindVertexArrayOES(GetProcAddress(Lib, 'glBindVertexArrayOES'));
  glBindVertexBuffer:=TglBindVertexBuffer(GLGetProcAddr('glBindVertexBuffer'));
  if not Assigned(glBindVertexBuffer) then 
    glBindVertexBuffer:=TglBindVertexBuffer(GetProcAddress(Lib, 'glBindVertexBuffer'));
  glBindVertexBuffers:=TglBindVertexBuffers(GLGetProcAddr('glBindVertexBuffers'));
  if not Assigned(glBindVertexBuffers) then 
    glBindVertexBuffers:=TglBindVertexBuffers(GetProcAddress(Lib, 'glBindVertexBuffers'));
  glBindVertexShaderEXT:=TglBindVertexShaderEXT(GLGetProcAddr('glBindVertexShaderEXT'));
  if not Assigned(glBindVertexShaderEXT) then 
    glBindVertexShaderEXT:=TglBindVertexShaderEXT(GetProcAddress(Lib, 'glBindVertexShaderEXT'));
  glBindVideoCaptureStreamBufferNV:=TglBindVideoCaptureStreamBufferNV(GLGetProcAddr('glBindVideoCaptureStreamBufferNV'));
  if not Assigned(glBindVideoCaptureStreamBufferNV) then 
    glBindVideoCaptureStreamBufferNV:=TglBindVideoCaptureStreamBufferNV(GetProcAddress(Lib, 'glBindVideoCaptureStreamBufferNV'));
  glBindVideoCaptureStreamTextureNV:=TglBindVideoCaptureStreamTextureNV(GLGetProcAddr('glBindVideoCaptureStreamTextureNV'));
  if not Assigned(glBindVideoCaptureStreamTextureNV) then 
    glBindVideoCaptureStreamTextureNV:=TglBindVideoCaptureStreamTextureNV(GetProcAddress(Lib, 'glBindVideoCaptureStreamTextureNV'));
  glBinormal3bEXT:=TglBinormal3bEXT(GLGetProcAddr('glBinormal3bEXT'));
  if not Assigned(glBinormal3bEXT) then 
    glBinormal3bEXT:=TglBinormal3bEXT(GetProcAddress(Lib, 'glBinormal3bEXT'));
  glBinormal3bvEXT:=TglBinormal3bvEXT(GLGetProcAddr('glBinormal3bvEXT'));
  if not Assigned(glBinormal3bvEXT) then 
    glBinormal3bvEXT:=TglBinormal3bvEXT(GetProcAddress(Lib, 'glBinormal3bvEXT'));
  glBinormal3dEXT:=TglBinormal3dEXT(GLGetProcAddr('glBinormal3dEXT'));
  if not Assigned(glBinormal3dEXT) then
    glBinormal3dEXT:=TglBinormal3dEXT(GetProcAddress(Lib, 'glBinormal3dEXT'));
  glBinormal3dvEXT:=TglBinormal3dvEXT(GLGetProcAddr('glBinormal3dvEXT'));
  if not Assigned(glBinormal3dvEXT) then
    glBinormal3dvEXT:=TglBinormal3dvEXT(GetProcAddress(Lib, 'glBinormal3dvEXT'));
  glBinormal3fEXT:=TglBinormal3fEXT(GLGetProcAddr('glBinormal3fEXT'));
  if not Assigned(glBinormal3fEXT) then 
    glBinormal3fEXT:=TglBinormal3fEXT(GetProcAddress(Lib, 'glBinormal3fEXT'));
  glBinormal3fvEXT:=TglBinormal3fvEXT(GLGetProcAddr('glBinormal3fvEXT'));
  if not Assigned(glBinormal3fvEXT) then 
    glBinormal3fvEXT:=TglBinormal3fvEXT(GetProcAddress(Lib, 'glBinormal3fvEXT'));
  glBinormal3iEXT:=TglBinormal3iEXT(GLGetProcAddr('glBinormal3iEXT'));
  if not Assigned(glBinormal3iEXT) then
    glBinormal3iEXT:=TglBinormal3iEXT(GetProcAddress(Lib, 'glBinormal3iEXT'));
  glBinormal3ivEXT:=TglBinormal3ivEXT(GLGetProcAddr('glBinormal3ivEXT'));
  if not Assigned(glBinormal3ivEXT) then 
    glBinormal3ivEXT:=TglBinormal3ivEXT(GetProcAddress(Lib, 'glBinormal3ivEXT'));
  glBinormal3sEXT:=TglBinormal3sEXT(GLGetProcAddr('glBinormal3sEXT'));
  if not Assigned(glBinormal3sEXT) then 
    glBinormal3sEXT:=TglBinormal3sEXT(GetProcAddress(Lib, 'glBinormal3sEXT'));
  glBinormal3svEXT:=TglBinormal3svEXT(GLGetProcAddr('glBinormal3svEXT'));
  if not Assigned(glBinormal3svEXT) then 
    glBinormal3svEXT:=TglBinormal3svEXT(GetProcAddress(Lib, 'glBinormal3svEXT'));
  glBinormalPointerEXT:=TglBinormalPointerEXT(GLGetProcAddr('glBinormalPointerEXT'));
  if not Assigned(glBinormalPointerEXT) then 
    glBinormalPointerEXT:=TglBinormalPointerEXT(GetProcAddress(Lib, 'glBinormalPointerEXT'));
  glBitmap:=TglBitmap(GLGetProcAddr('glBitmap'));
  if not Assigned(glBitmap) then 
    glBitmap:=TglBitmap(GetProcAddress(Lib, 'glBitmap'));
  glBitmapxOES:=TglBitmapxOES(GLGetProcAddr('glBitmapxOES'));
  if not Assigned(glBitmapxOES) then 
    glBitmapxOES:=TglBitmapxOES(GetProcAddress(Lib, 'glBitmapxOES'));
  glBlendBarrier:=TglBlendBarrier(GLGetProcAddr('glBlendBarrier'));
  if not Assigned(glBlendBarrier) then 
    glBlendBarrier:=TglBlendBarrier(GetProcAddress(Lib, 'glBlendBarrier'));
  glBlendBarrierKHR:=TglBlendBarrierKHR(GLGetProcAddr('glBlendBarrierKHR'));
  if not Assigned(glBlendBarrierKHR) then 
    glBlendBarrierKHR:=TglBlendBarrierKHR(GetProcAddress(Lib, 'glBlendBarrierKHR'));
  glBlendBarrierNV:=TglBlendBarrierNV(GLGetProcAddr('glBlendBarrierNV'));
  if not Assigned(glBlendBarrierNV) then 
    glBlendBarrierNV:=TglBlendBarrierNV(GetProcAddress(Lib, 'glBlendBarrierNV'));
  glBlendColor:=TglBlendColor(GLGetProcAddr('glBlendColor'));
  if not Assigned(glBlendColor) then 
    glBlendColor:=TglBlendColor(GetProcAddress(Lib, 'glBlendColor'));
  glBlendColorEXT:=TglBlendColorEXT(GLGetProcAddr('glBlendColorEXT'));
  if not Assigned(glBlendColorEXT) then 
    glBlendColorEXT:=TglBlendColorEXT(GetProcAddress(Lib, 'glBlendColorEXT'));
  glBlendColorxOES:=TglBlendColorxOES(GLGetProcAddr('glBlendColorxOES'));
  if not Assigned(glBlendColorxOES) then 
    glBlendColorxOES:=TglBlendColorxOES(GetProcAddress(Lib, 'glBlendColorxOES'));
  glBlendEquation:=TglBlendEquation(GLGetProcAddr('glBlendEquation'));
  if not Assigned(glBlendEquation) then 
    glBlendEquation:=TglBlendEquation(GetProcAddress(Lib, 'glBlendEquation'));
  glBlendEquationEXT:=TglBlendEquationEXT(GLGetProcAddr('glBlendEquationEXT'));
  if not Assigned(glBlendEquationEXT) then 
    glBlendEquationEXT:=TglBlendEquationEXT(GetProcAddress(Lib, 'glBlendEquationEXT'));
  glBlendEquationIndexedAMD:=TglBlendEquationIndexedAMD(GLGetProcAddr('glBlendEquationIndexedAMD'));
  if not Assigned(glBlendEquationIndexedAMD) then
    glBlendEquationIndexedAMD:=TglBlendEquationIndexedAMD(GetProcAddress(Lib, 'glBlendEquationIndexedAMD'));
  glBlendEquationOES:=TglBlendEquationOES(GLGetProcAddr('glBlendEquationOES'));
  if not Assigned(glBlendEquationOES) then 
    glBlendEquationOES:=TglBlendEquationOES(GetProcAddress(Lib, 'glBlendEquationOES'));
  glBlendEquationSeparate:=TglBlendEquationSeparate(GLGetProcAddr('glBlendEquationSeparate'));
  if not Assigned(glBlendEquationSeparate) then 
    glBlendEquationSeparate:=TglBlendEquationSeparate(GetProcAddress(Lib, 'glBlendEquationSeparate'));
  glBlendEquationSeparateEXT:=TglBlendEquationSeparateEXT(GLGetProcAddr('glBlendEquationSeparateEXT'));
  if not Assigned(glBlendEquationSeparateEXT) then 
    glBlendEquationSeparateEXT:=TglBlendEquationSeparateEXT(GetProcAddress(Lib, 'glBlendEquationSeparateEXT'));
  glBlendEquationSeparateIndexedAMD:=TglBlendEquationSeparateIndexedAMD(GLGetProcAddr('glBlendEquationSeparateIndexedAMD'));
  if not Assigned(glBlendEquationSeparateIndexedAMD) then 
    glBlendEquationSeparateIndexedAMD:=TglBlendEquationSeparateIndexedAMD(GetProcAddress(Lib, 'glBlendEquationSeparateIndexedAMD'));
  glBlendEquationSeparateOES:=TglBlendEquationSeparateOES(GLGetProcAddr('glBlendEquationSeparateOES'));
  if not Assigned(glBlendEquationSeparateOES) then 
    glBlendEquationSeparateOES:=TglBlendEquationSeparateOES(GetProcAddress(Lib, 'glBlendEquationSeparateOES'));
  glBlendEquationSeparatei:=TglBlendEquationSeparatei(GLGetProcAddr('glBlendEquationSeparatei'));
  if not Assigned(glBlendEquationSeparatei) then 
    glBlendEquationSeparatei:=TglBlendEquationSeparatei(GetProcAddress(Lib, 'glBlendEquationSeparatei'));
  glBlendEquationSeparateiARB:=TglBlendEquationSeparateiARB(GLGetProcAddr('glBlendEquationSeparateiARB'));
  if not Assigned(glBlendEquationSeparateiARB) then 
    glBlendEquationSeparateiARB:=TglBlendEquationSeparateiARB(GetProcAddress(Lib, 'glBlendEquationSeparateiARB'));
  glBlendEquationSeparateiEXT:=TglBlendEquationSeparateiEXT(GLGetProcAddr('glBlendEquationSeparateiEXT'));
  if not Assigned(glBlendEquationSeparateiEXT) then
    glBlendEquationSeparateiEXT:=TglBlendEquationSeparateiEXT(GetProcAddress(Lib, 'glBlendEquationSeparateiEXT'));
  glBlendEquationSeparateiOES:=TglBlendEquationSeparateiOES(GLGetProcAddr('glBlendEquationSeparateiOES'));
  if not Assigned(glBlendEquationSeparateiOES) then 
    glBlendEquationSeparateiOES:=TglBlendEquationSeparateiOES(GetProcAddress(Lib, 'glBlendEquationSeparateiOES'));
  glBlendEquationi:=TglBlendEquationi(GLGetProcAddr('glBlendEquationi'));
  if not Assigned(glBlendEquationi) then 
    glBlendEquationi:=TglBlendEquationi(GetProcAddress(Lib, 'glBlendEquationi'));
  glBlendEquationiARB:=TglBlendEquationiARB(GLGetProcAddr('glBlendEquationiARB'));
  if not Assigned(glBlendEquationiARB) then
    glBlendEquationiARB:=TglBlendEquationiARB(GetProcAddress(Lib, 'glBlendEquationiARB'));
  glBlendEquationiEXT:=TglBlendEquationiEXT(GLGetProcAddr('glBlendEquationiEXT'));
  if not Assigned(glBlendEquationiEXT) then 
    glBlendEquationiEXT:=TglBlendEquationiEXT(GetProcAddress(Lib, 'glBlendEquationiEXT'));
  glBlendEquationiOES:=TglBlendEquationiOES(GLGetProcAddr('glBlendEquationiOES'));
  if not Assigned(glBlendEquationiOES) then 
    glBlendEquationiOES:=TglBlendEquationiOES(GetProcAddress(Lib, 'glBlendEquationiOES'));
  glBlendFunc:=TglBlendFunc(GLGetProcAddr('glBlendFunc'));
  if not Assigned(glBlendFunc) then 
    glBlendFunc:=TglBlendFunc(GetProcAddress(Lib, 'glBlendFunc'));
  glBlendFuncIndexedAMD:=TglBlendFuncIndexedAMD(GLGetProcAddr('glBlendFuncIndexedAMD'));
  if not Assigned(glBlendFuncIndexedAMD) then 
    glBlendFuncIndexedAMD:=TglBlendFuncIndexedAMD(GetProcAddress(Lib, 'glBlendFuncIndexedAMD'));
  glBlendFuncSeparate:=TglBlendFuncSeparate(GLGetProcAddr('glBlendFuncSeparate'));
  if not Assigned(glBlendFuncSeparate) then 
    glBlendFuncSeparate:=TglBlendFuncSeparate(GetProcAddress(Lib, 'glBlendFuncSeparate'));
  glBlendFuncSeparateEXT:=TglBlendFuncSeparateEXT(GLGetProcAddr('glBlendFuncSeparateEXT'));
  if not Assigned(glBlendFuncSeparateEXT) then 
    glBlendFuncSeparateEXT:=TglBlendFuncSeparateEXT(GetProcAddress(Lib, 'glBlendFuncSeparateEXT'));
  glBlendFuncSeparateINGR:=TglBlendFuncSeparateINGR(GLGetProcAddr('glBlendFuncSeparateINGR'));
  if not Assigned(glBlendFuncSeparateINGR) then 
    glBlendFuncSeparateINGR:=TglBlendFuncSeparateINGR(GetProcAddress(Lib, 'glBlendFuncSeparateINGR'));
  glBlendFuncSeparateIndexedAMD:=TglBlendFuncSeparateIndexedAMD(GLGetProcAddr('glBlendFuncSeparateIndexedAMD'));
  if not Assigned(glBlendFuncSeparateIndexedAMD) then
    glBlendFuncSeparateIndexedAMD:=TglBlendFuncSeparateIndexedAMD(GetProcAddress(Lib, 'glBlendFuncSeparateIndexedAMD'));
  glBlendFuncSeparateOES:=TglBlendFuncSeparateOES(GLGetProcAddr('glBlendFuncSeparateOES'));
  if not Assigned(glBlendFuncSeparateOES) then 
    glBlendFuncSeparateOES:=TglBlendFuncSeparateOES(GetProcAddress(Lib, 'glBlendFuncSeparateOES'));
  glBlendFuncSeparatei:=TglBlendFuncSeparatei(GLGetProcAddr('glBlendFuncSeparatei'));
  if not Assigned(glBlendFuncSeparatei) then 
    glBlendFuncSeparatei:=TglBlendFuncSeparatei(GetProcAddress(Lib, 'glBlendFuncSeparatei'));
  glBlendFuncSeparateiARB:=TglBlendFuncSeparateiARB(GLGetProcAddr('glBlendFuncSeparateiARB'));
  if not Assigned(glBlendFuncSeparateiARB) then 
    glBlendFuncSeparateiARB:=TglBlendFuncSeparateiARB(GetProcAddress(Lib, 'glBlendFuncSeparateiARB'));
  glBlendFuncSeparateiEXT:=TglBlendFuncSeparateiEXT(GLGetProcAddr('glBlendFuncSeparateiEXT'));
  if not Assigned(glBlendFuncSeparateiEXT) then 
    glBlendFuncSeparateiEXT:=TglBlendFuncSeparateiEXT(GetProcAddress(Lib, 'glBlendFuncSeparateiEXT'));
  glBlendFuncSeparateiOES:=TglBlendFuncSeparateiOES(GLGetProcAddr('glBlendFuncSeparateiOES'));
  if not Assigned(glBlendFuncSeparateiOES) then 
    glBlendFuncSeparateiOES:=TglBlendFuncSeparateiOES(GetProcAddress(Lib, 'glBlendFuncSeparateiOES'));
  glBlendFunci:=TglBlendFunci(GLGetProcAddr('glBlendFunci'));
  if not Assigned(glBlendFunci) then 
    glBlendFunci:=TglBlendFunci(GetProcAddress(Lib, 'glBlendFunci'));
  glBlendFunciARB:=TglBlendFunciARB(GLGetProcAddr('glBlendFunciARB'));
  if not Assigned(glBlendFunciARB) then 
    glBlendFunciARB:=TglBlendFunciARB(GetProcAddress(Lib, 'glBlendFunciARB'));
  glBlendFunciEXT:=TglBlendFunciEXT(GLGetProcAddr('glBlendFunciEXT'));
  if not Assigned(glBlendFunciEXT) then 
    glBlendFunciEXT:=TglBlendFunciEXT(GetProcAddress(Lib, 'glBlendFunciEXT'));
  glBlendFunciOES:=TglBlendFunciOES(GLGetProcAddr('glBlendFunciOES'));
  if not Assigned(glBlendFunciOES) then 
    glBlendFunciOES:=TglBlendFunciOES(GetProcAddress(Lib, 'glBlendFunciOES'));
  glBlendParameteriNV:=TglBlendParameteriNV(GLGetProcAddr('glBlendParameteriNV'));
  if not Assigned(glBlendParameteriNV) then 
    glBlendParameteriNV:=TglBlendParameteriNV(GetProcAddress(Lib, 'glBlendParameteriNV'));
  glBlitFramebuffer:=TglBlitFramebuffer(GLGetProcAddr('glBlitFramebuffer'));
  if not Assigned(glBlitFramebuffer) then 
    glBlitFramebuffer:=TglBlitFramebuffer(GetProcAddress(Lib, 'glBlitFramebuffer'));
  glBlitFramebufferANGLE:=TglBlitFramebufferANGLE(GLGetProcAddr('glBlitFramebufferANGLE'));
  if not Assigned(glBlitFramebufferANGLE) then 
    glBlitFramebufferANGLE:=TglBlitFramebufferANGLE(GetProcAddress(Lib, 'glBlitFramebufferANGLE'));
  glBlitFramebufferEXT:=TglBlitFramebufferEXT(GLGetProcAddr('glBlitFramebufferEXT'));
  if not Assigned(glBlitFramebufferEXT) then 
    glBlitFramebufferEXT:=TglBlitFramebufferEXT(GetProcAddress(Lib, 'glBlitFramebufferEXT'));
  glBlitFramebufferNV:=TglBlitFramebufferNV(GLGetProcAddr('glBlitFramebufferNV'));
  if not Assigned(glBlitFramebufferNV) then 
    glBlitFramebufferNV:=TglBlitFramebufferNV(GetProcAddress(Lib, 'glBlitFramebufferNV'));
  glBlitNamedFramebuffer:=TglBlitNamedFramebuffer(GLGetProcAddr('glBlitNamedFramebuffer'));
  if not Assigned(glBlitNamedFramebuffer) then
    glBlitNamedFramebuffer:=TglBlitNamedFramebuffer(GetProcAddress(Lib, 'glBlitNamedFramebuffer'));
  glBufferAddressRangeNV:=TglBufferAddressRangeNV(GLGetProcAddr('glBufferAddressRangeNV'));
  if not Assigned(glBufferAddressRangeNV) then 
    glBufferAddressRangeNV:=TglBufferAddressRangeNV(GetProcAddress(Lib, 'glBufferAddressRangeNV'));
  glBufferData:=TglBufferData(GLGetProcAddr('glBufferData'));
  if not Assigned(glBufferData) then 
    glBufferData:=TglBufferData(GetProcAddress(Lib, 'glBufferData'));
  glBufferDataARB:=TglBufferDataARB(GLGetProcAddr('glBufferDataARB'));
  if not Assigned(glBufferDataARB) then
    glBufferDataARB:=TglBufferDataARB(GetProcAddress(Lib, 'glBufferDataARB'));
  glBufferPageCommitmentARB:=TglBufferPageCommitmentARB(GLGetProcAddr('glBufferPageCommitmentARB'));
  if not Assigned(glBufferPageCommitmentARB) then
    glBufferPageCommitmentARB:=TglBufferPageCommitmentARB(GetProcAddress(Lib, 'glBufferPageCommitmentARB'));
  glBufferParameteriAPPLE:=TglBufferParameteriAPPLE(GLGetProcAddr('glBufferParameteriAPPLE'));
  if not Assigned(glBufferParameteriAPPLE) then 
    glBufferParameteriAPPLE:=TglBufferParameteriAPPLE(GetProcAddress(Lib, 'glBufferParameteriAPPLE'));
  glBufferStorage:=TglBufferStorage(GLGetProcAddr('glBufferStorage'));
  if not Assigned(glBufferStorage) then 
    glBufferStorage:=TglBufferStorage(GetProcAddress(Lib, 'glBufferStorage'));
  glBufferStorageEXT:=TglBufferStorageEXT(GLGetProcAddr('glBufferStorageEXT'));
  if not Assigned(glBufferStorageEXT) then 
    glBufferStorageEXT:=TglBufferStorageEXT(GetProcAddress(Lib, 'glBufferStorageEXT'));
  glBufferStorageExternalEXT:=TglBufferStorageExternalEXT(GLGetProcAddr('glBufferStorageExternalEXT'));
  if not Assigned(glBufferStorageExternalEXT) then 
    glBufferStorageExternalEXT:=TglBufferStorageExternalEXT(GetProcAddress(Lib, 'glBufferStorageExternalEXT'));
  glBufferStorageMemEXT:=TglBufferStorageMemEXT(GLGetProcAddr('glBufferStorageMemEXT'));
  if not Assigned(glBufferStorageMemEXT) then 
    glBufferStorageMemEXT:=TglBufferStorageMemEXT(GetProcAddress(Lib, 'glBufferStorageMemEXT'));
  glBufferSubData:=TglBufferSubData(GLGetProcAddr('glBufferSubData'));
  if not Assigned(glBufferSubData) then 
    glBufferSubData:=TglBufferSubData(GetProcAddress(Lib, 'glBufferSubData'));
  glBufferSubDataARB:=TglBufferSubDataARB(GLGetProcAddr('glBufferSubDataARB'));
  if not Assigned(glBufferSubDataARB) then 
    glBufferSubDataARB:=TglBufferSubDataARB(GetProcAddress(Lib, 'glBufferSubDataARB'));
  glCallCommandListNV:=TglCallCommandListNV(GLGetProcAddr('glCallCommandListNV'));
  if not Assigned(glCallCommandListNV) then 
    glCallCommandListNV:=TglCallCommandListNV(GetProcAddress(Lib, 'glCallCommandListNV'));
  glCallList:=TglCallList(GLGetProcAddr('glCallList'));
  if not Assigned(glCallList) then 
    glCallList:=TglCallList(GetProcAddress(Lib, 'glCallList'));
  glCallLists:=TglCallLists(GLGetProcAddr('glCallLists'));
  if not Assigned(glCallLists) then 
    glCallLists:=TglCallLists(GetProcAddress(Lib, 'glCallLists'));
  glCheckFramebufferStatus:=TglCheckFramebufferStatus(GLGetProcAddr('glCheckFramebufferStatus'));
  if not Assigned(glCheckFramebufferStatus) then 
    glCheckFramebufferStatus:=TglCheckFramebufferStatus(GetProcAddress(Lib, 'glCheckFramebufferStatus'));
  glCheckFramebufferStatusEXT:=TglCheckFramebufferStatusEXT(GLGetProcAddr('glCheckFramebufferStatusEXT'));
  if not Assigned(glCheckFramebufferStatusEXT) then 
    glCheckFramebufferStatusEXT:=TglCheckFramebufferStatusEXT(GetProcAddress(Lib, 'glCheckFramebufferStatusEXT'));
  glCheckFramebufferStatusOES:=TglCheckFramebufferStatusOES(GLGetProcAddr('glCheckFramebufferStatusOES'));
  if not Assigned(glCheckFramebufferStatusOES) then 
    glCheckFramebufferStatusOES:=TglCheckFramebufferStatusOES(GetProcAddress(Lib, 'glCheckFramebufferStatusOES'));
  glCheckNamedFramebufferStatus:=TglCheckNamedFramebufferStatus(GLGetProcAddr('glCheckNamedFramebufferStatus'));
  if not Assigned(glCheckNamedFramebufferStatus) then 
    glCheckNamedFramebufferStatus:=TglCheckNamedFramebufferStatus(GetProcAddress(Lib, 'glCheckNamedFramebufferStatus'));
  glCheckNamedFramebufferStatusEXT:=TglCheckNamedFramebufferStatusEXT(GLGetProcAddr('glCheckNamedFramebufferStatusEXT'));
  if not Assigned(glCheckNamedFramebufferStatusEXT) then 
    glCheckNamedFramebufferStatusEXT:=TglCheckNamedFramebufferStatusEXT(GetProcAddress(Lib, 'glCheckNamedFramebufferStatusEXT'));
  glClampColor:=TglClampColor(GLGetProcAddr('glClampColor'));
  if not Assigned(glClampColor) then 
    glClampColor:=TglClampColor(GetProcAddress(Lib, 'glClampColor'));
  glClampColorARB:=TglClampColorARB(GLGetProcAddr('glClampColorARB'));
  if not Assigned(glClampColorARB) then 
    glClampColorARB:=TglClampColorARB(GetProcAddress(Lib, 'glClampColorARB'));
  glClear:=TglClear(GLGetProcAddr('glClear'));
  if not Assigned(glClear) then 
    glClear:=TglClear(GetProcAddress(Lib, 'glClear'));
  glClearAccum:=TglClearAccum(GLGetProcAddr('glClearAccum'));
  if not Assigned(glClearAccum) then
    glClearAccum:=TglClearAccum(GetProcAddress(Lib, 'glClearAccum'));
  glClearAccumxOES:=TglClearAccumxOES(GLGetProcAddr('glClearAccumxOES'));
  if not Assigned(glClearAccumxOES) then 
    glClearAccumxOES:=TglClearAccumxOES(GetProcAddress(Lib, 'glClearAccumxOES'));
  glClearBufferData:=TglClearBufferData(GLGetProcAddr('glClearBufferData'));
  if not Assigned(glClearBufferData) then 
    glClearBufferData:=TglClearBufferData(GetProcAddress(Lib, 'glClearBufferData'));
  glClearBufferSubData:=TglClearBufferSubData(GLGetProcAddr('glClearBufferSubData'));
  if not Assigned(glClearBufferSubData) then
    glClearBufferSubData:=TglClearBufferSubData(GetProcAddress(Lib, 'glClearBufferSubData'));
  glClearBufferfi:=TglClearBufferfi(GLGetProcAddr('glClearBufferfi'));
  if not Assigned(glClearBufferfi) then 
    glClearBufferfi:=TglClearBufferfi(GetProcAddress(Lib, 'glClearBufferfi'));
  glClearBufferfv:=TglClearBufferfv(GLGetProcAddr('glClearBufferfv'));
  if not Assigned(glClearBufferfv) then 
    glClearBufferfv:=TglClearBufferfv(GetProcAddress(Lib, 'glClearBufferfv'));
  glClearBufferiv:=TglClearBufferiv(GLGetProcAddr('glClearBufferiv'));
  if not Assigned(glClearBufferiv) then
    glClearBufferiv:=TglClearBufferiv(GetProcAddress(Lib, 'glClearBufferiv'));
  glClearBufferuiv:=TglClearBufferuiv(GLGetProcAddr('glClearBufferuiv'));
  if not Assigned(glClearBufferuiv) then 
    glClearBufferuiv:=TglClearBufferuiv(GetProcAddress(Lib, 'glClearBufferuiv'));
  glClearColor:=TglClearColor(GLGetProcAddr('glClearColor'));
  if not Assigned(glClearColor) then 
    glClearColor:=TglClearColor(GetProcAddress(Lib, 'glClearColor'));
  glClearColorIiEXT:=TglClearColorIiEXT(GLGetProcAddr('glClearColorIiEXT'));
  if not Assigned(glClearColorIiEXT) then 
    glClearColorIiEXT:=TglClearColorIiEXT(GetProcAddress(Lib, 'glClearColorIiEXT'));
  glClearColorIuiEXT:=TglClearColorIuiEXT(GLGetProcAddr('glClearColorIuiEXT'));
  if not Assigned(glClearColorIuiEXT) then 
    glClearColorIuiEXT:=TglClearColorIuiEXT(GetProcAddress(Lib, 'glClearColorIuiEXT'));
  glClearColorx:=TglClearColorx(GLGetProcAddr('glClearColorx'));
  if not Assigned(glClearColorx) then 
    glClearColorx:=TglClearColorx(GetProcAddress(Lib, 'glClearColorx'));
  glClearColorxOES:=TglClearColorxOES(GLGetProcAddr('glClearColorxOES'));
  if not Assigned(glClearColorxOES) then 
    glClearColorxOES:=TglClearColorxOES(GetProcAddress(Lib, 'glClearColorxOES'));
  glClearDepth:=TglClearDepth(GLGetProcAddr('glClearDepth'));
  if not Assigned(glClearDepth) then 
    glClearDepth:=TglClearDepth(GetProcAddress(Lib, 'glClearDepth'));
  glClearDepthdNV:=TglClearDepthdNV(GLGetProcAddr('glClearDepthdNV'));
  if not Assigned(glClearDepthdNV) then 
    glClearDepthdNV:=TglClearDepthdNV(GetProcAddress(Lib, 'glClearDepthdNV'));
  glClearDepthf:=TglClearDepthf(GLGetProcAddr('glClearDepthf'));
  if not Assigned(glClearDepthf) then 
    glClearDepthf:=TglClearDepthf(GetProcAddress(Lib, 'glClearDepthf'));
  glClearDepthfOES:=TglClearDepthfOES(GLGetProcAddr('glClearDepthfOES'));
  if not Assigned(glClearDepthfOES) then 
    glClearDepthfOES:=TglClearDepthfOES(GetProcAddress(Lib, 'glClearDepthfOES'));
  glClearDepthx:=TglClearDepthx(GLGetProcAddr('glClearDepthx'));
  if not Assigned(glClearDepthx) then 
    glClearDepthx:=TglClearDepthx(GetProcAddress(Lib, 'glClearDepthx'));
  glClearDepthxOES:=TglClearDepthxOES(GLGetProcAddr('glClearDepthxOES'));
  if not Assigned(glClearDepthxOES) then 
    glClearDepthxOES:=TglClearDepthxOES(GetProcAddress(Lib, 'glClearDepthxOES'));
  glClearIndex:=TglClearIndex(GLGetProcAddr('glClearIndex'));
  if not Assigned(glClearIndex) then
    glClearIndex:=TglClearIndex(GetProcAddress(Lib, 'glClearIndex'));
  glClearNamedBufferData:=TglClearNamedBufferData(GLGetProcAddr('glClearNamedBufferData'));
  if not Assigned(glClearNamedBufferData) then 
    glClearNamedBufferData:=TglClearNamedBufferData(GetProcAddress(Lib, 'glClearNamedBufferData'));
  glClearNamedBufferDataEXT:=TglClearNamedBufferDataEXT(GLGetProcAddr('glClearNamedBufferDataEXT'));
  if not Assigned(glClearNamedBufferDataEXT) then 
    glClearNamedBufferDataEXT:=TglClearNamedBufferDataEXT(GetProcAddress(Lib, 'glClearNamedBufferDataEXT'));
  glClearNamedBufferSubData:=TglClearNamedBufferSubData(GLGetProcAddr('glClearNamedBufferSubData'));
  if not Assigned(glClearNamedBufferSubData) then 
    glClearNamedBufferSubData:=TglClearNamedBufferSubData(GetProcAddress(Lib, 'glClearNamedBufferSubData'));
  glClearNamedBufferSubDataEXT:=TglClearNamedBufferSubDataEXT(GLGetProcAddr('glClearNamedBufferSubDataEXT'));
  if not Assigned(glClearNamedBufferSubDataEXT) then 
    glClearNamedBufferSubDataEXT:=TglClearNamedBufferSubDataEXT(GetProcAddress(Lib, 'glClearNamedBufferSubDataEXT'));
  glClearNamedFramebufferfi:=TglClearNamedFramebufferfi(GLGetProcAddr('glClearNamedFramebufferfi'));
  if not Assigned(glClearNamedFramebufferfi) then 
    glClearNamedFramebufferfi:=TglClearNamedFramebufferfi(GetProcAddress(Lib, 'glClearNamedFramebufferfi'));
  glClearNamedFramebufferfv:=TglClearNamedFramebufferfv(GLGetProcAddr('glClearNamedFramebufferfv'));
  if not Assigned(glClearNamedFramebufferfv) then 
    glClearNamedFramebufferfv:=TglClearNamedFramebufferfv(GetProcAddress(Lib, 'glClearNamedFramebufferfv'));
  glClearNamedFramebufferiv:=TglClearNamedFramebufferiv(GLGetProcAddr('glClearNamedFramebufferiv'));
  if not Assigned(glClearNamedFramebufferiv) then 
    glClearNamedFramebufferiv:=TglClearNamedFramebufferiv(GetProcAddress(Lib, 'glClearNamedFramebufferiv'));
  glClearNamedFramebufferuiv:=TglClearNamedFramebufferuiv(GLGetProcAddr('glClearNamedFramebufferuiv'));
  if not Assigned(glClearNamedFramebufferuiv) then 
    glClearNamedFramebufferuiv:=TglClearNamedFramebufferuiv(GetProcAddress(Lib, 'glClearNamedFramebufferuiv'));
  glClearPixelLocalStorageuiEXT:=TglClearPixelLocalStorageuiEXT(GLGetProcAddr('glClearPixelLocalStorageuiEXT'));
  if not Assigned(glClearPixelLocalStorageuiEXT) then 
    glClearPixelLocalStorageuiEXT:=TglClearPixelLocalStorageuiEXT(GetProcAddress(Lib, 'glClearPixelLocalStorageuiEXT'));
  glClearStencil:=TglClearStencil(GLGetProcAddr('glClearStencil'));
  if not Assigned(glClearStencil) then
    glClearStencil:=TglClearStencil(GetProcAddress(Lib, 'glClearStencil'));
  glClearTexImage:=TglClearTexImage(GLGetProcAddr('glClearTexImage'));
  if not Assigned(glClearTexImage) then 
    glClearTexImage:=TglClearTexImage(GetProcAddress(Lib, 'glClearTexImage'));
  glClearTexImageEXT:=TglClearTexImageEXT(GLGetProcAddr('glClearTexImageEXT'));
  if not Assigned(glClearTexImageEXT) then 
    glClearTexImageEXT:=TglClearTexImageEXT(GetProcAddress(Lib, 'glClearTexImageEXT'));
  glClearTexSubImage:=TglClearTexSubImage(GLGetProcAddr('glClearTexSubImage'));
  if not Assigned(glClearTexSubImage) then
    glClearTexSubImage:=TglClearTexSubImage(GetProcAddress(Lib, 'glClearTexSubImage'));
  glClearTexSubImageEXT:=TglClearTexSubImageEXT(GLGetProcAddr('glClearTexSubImageEXT'));
  if not Assigned(glClearTexSubImageEXT) then 
    glClearTexSubImageEXT:=TglClearTexSubImageEXT(GetProcAddress(Lib, 'glClearTexSubImageEXT'));
  glClientActiveTexture:=TglClientActiveTexture(GLGetProcAddr('glClientActiveTexture'));
  if not Assigned(glClientActiveTexture) then 
    glClientActiveTexture:=TglClientActiveTexture(GetProcAddress(Lib, 'glClientActiveTexture'));
  glClientActiveTextureARB:=TglClientActiveTextureARB(GLGetProcAddr('glClientActiveTextureARB'));
  if not Assigned(glClientActiveTextureARB) then 
    glClientActiveTextureARB:=TglClientActiveTextureARB(GetProcAddress(Lib, 'glClientActiveTextureARB'));
  glClientActiveVertexStreamATI:=TglClientActiveVertexStreamATI(GLGetProcAddr('glClientActiveVertexStreamATI'));
  if not Assigned(glClientActiveVertexStreamATI) then 
    glClientActiveVertexStreamATI:=TglClientActiveVertexStreamATI(GetProcAddress(Lib, 'glClientActiveVertexStreamATI'));
  glClientAttribDefaultEXT:=TglClientAttribDefaultEXT(GLGetProcAddr('glClientAttribDefaultEXT'));
  if not Assigned(glClientAttribDefaultEXT) then 
    glClientAttribDefaultEXT:=TglClientAttribDefaultEXT(GetProcAddress(Lib, 'glClientAttribDefaultEXT'));
  glClientWaitSync:=TglClientWaitSync(GLGetProcAddr('glClientWaitSync'));
  if not Assigned(glClientWaitSync) then
    glClientWaitSync:=TglClientWaitSync(GetProcAddress(Lib, 'glClientWaitSync'));
  glClientWaitSyncAPPLE:=TglClientWaitSyncAPPLE(GLGetProcAddr('glClientWaitSyncAPPLE'));
  if not Assigned(glClientWaitSyncAPPLE) then 
    glClientWaitSyncAPPLE:=TglClientWaitSyncAPPLE(GetProcAddress(Lib, 'glClientWaitSyncAPPLE'));
  glClipControl:=TglClipControl(GLGetProcAddr('glClipControl'));
  if not Assigned(glClipControl) then 
    glClipControl:=TglClipControl(GetProcAddress(Lib, 'glClipControl'));
  glClipPlane:=TglClipPlane(GLGetProcAddr('glClipPlane'));
  if not Assigned(glClipPlane) then 
    glClipPlane:=TglClipPlane(GetProcAddress(Lib, 'glClipPlane'));
  glClipPlanef:=TglClipPlanef(GLGetProcAddr('glClipPlanef'));
  if not Assigned(glClipPlanef) then 
    glClipPlanef:=TglClipPlanef(GetProcAddress(Lib, 'glClipPlanef'));
  glClipPlanefIMG:=TglClipPlanefIMG(GLGetProcAddr('glClipPlanefIMG'));
  if not Assigned(glClipPlanefIMG) then 
    glClipPlanefIMG:=TglClipPlanefIMG(GetProcAddress(Lib, 'glClipPlanefIMG'));
  glClipPlanefOES:=TglClipPlanefOES(GLGetProcAddr('glClipPlanefOES'));
  if not Assigned(glClipPlanefOES) then 
    glClipPlanefOES:=TglClipPlanefOES(GetProcAddress(Lib, 'glClipPlanefOES'));
  glClipPlanex:=TglClipPlanex(GLGetProcAddr('glClipPlanex'));
  if not Assigned(glClipPlanex) then 
    glClipPlanex:=TglClipPlanex(GetProcAddress(Lib, 'glClipPlanex'));
  glClipPlanexIMG:=TglClipPlanexIMG(GLGetProcAddr('glClipPlanexIMG'));
  if not Assigned(glClipPlanexIMG) then 
    glClipPlanexIMG:=TglClipPlanexIMG(GetProcAddress(Lib, 'glClipPlanexIMG'));
  glClipPlanexOES:=TglClipPlanexOES(GLGetProcAddr('glClipPlanexOES'));
  if not Assigned(glClipPlanexOES) then 
    glClipPlanexOES:=TglClipPlanexOES(GetProcAddress(Lib, 'glClipPlanexOES'));
  glColor3b:=TglColor3b(GLGetProcAddr('glColor3b'));
  if not Assigned(glColor3b) then 
    glColor3b:=TglColor3b(GetProcAddress(Lib, 'glColor3b'));
  glColor3bv:=TglColor3bv(GLGetProcAddr('glColor3bv'));
  if not Assigned(glColor3bv) then 
    glColor3bv:=TglColor3bv(GetProcAddress(Lib, 'glColor3bv'));
  glColor3d:=TglColor3d(GLGetProcAddr('glColor3d'));
  if not Assigned(glColor3d) then 
    glColor3d:=TglColor3d(GetProcAddress(Lib, 'glColor3d'));
  glColor3dv:=TglColor3dv(GLGetProcAddr('glColor3dv'));
  if not Assigned(glColor3dv) then 
    glColor3dv:=TglColor3dv(GetProcAddress(Lib, 'glColor3dv'));
  glColor3f:=TglColor3f(GLGetProcAddr('glColor3f'));
  if not Assigned(glColor3f) then 
    glColor3f:=TglColor3f(GetProcAddress(Lib, 'glColor3f'));
  glColor3fVertex3fSUN:=TglColor3fVertex3fSUN(GLGetProcAddr('glColor3fVertex3fSUN'));
  if not Assigned(glColor3fVertex3fSUN) then 
    glColor3fVertex3fSUN:=TglColor3fVertex3fSUN(GetProcAddress(Lib, 'glColor3fVertex3fSUN'));
  glColor3fVertex3fvSUN:=TglColor3fVertex3fvSUN(GLGetProcAddr('glColor3fVertex3fvSUN'));
  if not Assigned(glColor3fVertex3fvSUN) then 
    glColor3fVertex3fvSUN:=TglColor3fVertex3fvSUN(GetProcAddress(Lib, 'glColor3fVertex3fvSUN'));
  glColor3fv:=TglColor3fv(GLGetProcAddr('glColor3fv'));
  if not Assigned(glColor3fv) then
    glColor3fv:=TglColor3fv(GetProcAddress(Lib, 'glColor3fv'));
  glColor3hNV:=TglColor3hNV(GLGetProcAddr('glColor3hNV'));
  if not Assigned(glColor3hNV) then 
    glColor3hNV:=TglColor3hNV(GetProcAddress(Lib, 'glColor3hNV'));
  glColor3hvNV:=TglColor3hvNV(GLGetProcAddr('glColor3hvNV'));
  if not Assigned(glColor3hvNV) then
    glColor3hvNV:=TglColor3hvNV(GetProcAddress(Lib, 'glColor3hvNV'));
  glColor3i:=TglColor3i(GLGetProcAddr('glColor3i'));
  if not Assigned(glColor3i) then
    glColor3i:=TglColor3i(GetProcAddress(Lib, 'glColor3i'));
  glColor3iv:=TglColor3iv(GLGetProcAddr('glColor3iv'));
  if not Assigned(glColor3iv) then 
    glColor3iv:=TglColor3iv(GetProcAddress(Lib, 'glColor3iv'));
  glColor3s:=TglColor3s(GLGetProcAddr('glColor3s'));
  if not Assigned(glColor3s) then 
    glColor3s:=TglColor3s(GetProcAddress(Lib, 'glColor3s'));
  glColor3sv:=TglColor3sv(GLGetProcAddr('glColor3sv'));
  if not Assigned(glColor3sv) then 
    glColor3sv:=TglColor3sv(GetProcAddress(Lib, 'glColor3sv'));
  glColor3ub:=TglColor3ub(GLGetProcAddr('glColor3ub'));
  if not Assigned(glColor3ub) then 
    glColor3ub:=TglColor3ub(GetProcAddress(Lib, 'glColor3ub'));
  glColor3ubv:=TglColor3ubv(GLGetProcAddr('glColor3ubv'));
  if not Assigned(glColor3ubv) then 
    glColor3ubv:=TglColor3ubv(GetProcAddress(Lib, 'glColor3ubv'));
  glColor3ui:=TglColor3ui(GLGetProcAddr('glColor3ui'));
  if not Assigned(glColor3ui) then 
    glColor3ui:=TglColor3ui(GetProcAddress(Lib, 'glColor3ui'));
  glColor3uiv:=TglColor3uiv(GLGetProcAddr('glColor3uiv'));
  if not Assigned(glColor3uiv) then 
    glColor3uiv:=TglColor3uiv(GetProcAddress(Lib, 'glColor3uiv'));
  glColor3us:=TglColor3us(GLGetProcAddr('glColor3us'));
  if not Assigned(glColor3us) then 
    glColor3us:=TglColor3us(GetProcAddress(Lib, 'glColor3us'));
  glColor3usv:=TglColor3usv(GLGetProcAddr('glColor3usv'));
  if not Assigned(glColor3usv) then 
    glColor3usv:=TglColor3usv(GetProcAddress(Lib, 'glColor3usv'));
  glColor3xOES:=TglColor3xOES(GLGetProcAddr('glColor3xOES'));
  if not Assigned(glColor3xOES) then 
    glColor3xOES:=TglColor3xOES(GetProcAddress(Lib, 'glColor3xOES'));
  glColor3xvOES:=TglColor3xvOES(GLGetProcAddr('glColor3xvOES'));
  if not Assigned(glColor3xvOES) then 
    glColor3xvOES:=TglColor3xvOES(GetProcAddress(Lib, 'glColor3xvOES'));
  glColor4b:=TglColor4b(GLGetProcAddr('glColor4b'));
  if not Assigned(glColor4b) then 
    glColor4b:=TglColor4b(GetProcAddress(Lib, 'glColor4b'));
  glColor4bv:=TglColor4bv(GLGetProcAddr('glColor4bv'));
  if not Assigned(glColor4bv) then 
    glColor4bv:=TglColor4bv(GetProcAddress(Lib, 'glColor4bv'));
  glColor4d:=TglColor4d(GLGetProcAddr('glColor4d'));
  if not Assigned(glColor4d) then 
    glColor4d:=TglColor4d(GetProcAddress(Lib, 'glColor4d'));
  glColor4dv:=TglColor4dv(GLGetProcAddr('glColor4dv'));
  if not Assigned(glColor4dv) then 
    glColor4dv:=TglColor4dv(GetProcAddress(Lib, 'glColor4dv'));
  glColor4f:=TglColor4f(GLGetProcAddr('glColor4f'));
  if not Assigned(glColor4f) then 
    glColor4f:=TglColor4f(GetProcAddress(Lib, 'glColor4f'));
  glColor4fNormal3fVertex3fSUN:=TglColor4fNormal3fVertex3fSUN(GLGetProcAddr('glColor4fNormal3fVertex3fSUN'));
  if not Assigned(glColor4fNormal3fVertex3fSUN) then 
    glColor4fNormal3fVertex3fSUN:=TglColor4fNormal3fVertex3fSUN(GetProcAddress(Lib, 'glColor4fNormal3fVertex3fSUN'));
  glColor4fNormal3fVertex3fvSUN:=TglColor4fNormal3fVertex3fvSUN(GLGetProcAddr('glColor4fNormal3fVertex3fvSUN'));
  if not Assigned(glColor4fNormal3fVertex3fvSUN) then
    glColor4fNormal3fVertex3fvSUN:=TglColor4fNormal3fVertex3fvSUN(GetProcAddress(Lib, 'glColor4fNormal3fVertex3fvSUN'));
  glColor4fv:=TglColor4fv(GLGetProcAddr('glColor4fv'));
  if not Assigned(glColor4fv) then 
    glColor4fv:=TglColor4fv(GetProcAddress(Lib, 'glColor4fv'));
  glColor4hNV:=TglColor4hNV(GLGetProcAddr('glColor4hNV'));
  if not Assigned(glColor4hNV) then 
    glColor4hNV:=TglColor4hNV(GetProcAddress(Lib, 'glColor4hNV'));
  glColor4hvNV:=TglColor4hvNV(GLGetProcAddr('glColor4hvNV'));
  if not Assigned(glColor4hvNV) then 
    glColor4hvNV:=TglColor4hvNV(GetProcAddress(Lib, 'glColor4hvNV'));
  glColor4i:=TglColor4i(GLGetProcAddr('glColor4i'));
  if not Assigned(glColor4i) then 
    glColor4i:=TglColor4i(GetProcAddress(Lib, 'glColor4i'));
  glColor4iv:=TglColor4iv(GLGetProcAddr('glColor4iv'));
  if not Assigned(glColor4iv) then
    glColor4iv:=TglColor4iv(GetProcAddress(Lib, 'glColor4iv'));
  glColor4s:=TglColor4s(GLGetProcAddr('glColor4s'));
  if not Assigned(glColor4s) then 
    glColor4s:=TglColor4s(GetProcAddress(Lib, 'glColor4s'));
  glColor4sv:=TglColor4sv(GLGetProcAddr('glColor4sv'));
  if not Assigned(glColor4sv) then 
    glColor4sv:=TglColor4sv(GetProcAddress(Lib, 'glColor4sv'));
  glColor4ub:=TglColor4ub(GLGetProcAddr('glColor4ub'));
  if not Assigned(glColor4ub) then
    glColor4ub:=TglColor4ub(GetProcAddress(Lib, 'glColor4ub'));
  glColor4ubVertex2fSUN:=TglColor4ubVertex2fSUN(GLGetProcAddr('glColor4ubVertex2fSUN'));
  if not Assigned(glColor4ubVertex2fSUN) then 
    glColor4ubVertex2fSUN:=TglColor4ubVertex2fSUN(GetProcAddress(Lib, 'glColor4ubVertex2fSUN'));
  glColor4ubVertex2fvSUN:=TglColor4ubVertex2fvSUN(GLGetProcAddr('glColor4ubVertex2fvSUN'));
  if not Assigned(glColor4ubVertex2fvSUN) then 
    glColor4ubVertex2fvSUN:=TglColor4ubVertex2fvSUN(GetProcAddress(Lib, 'glColor4ubVertex2fvSUN'));
  glColor4ubVertex3fSUN:=TglColor4ubVertex3fSUN(GLGetProcAddr('glColor4ubVertex3fSUN'));
  if not Assigned(glColor4ubVertex3fSUN) then 
    glColor4ubVertex3fSUN:=TglColor4ubVertex3fSUN(GetProcAddress(Lib, 'glColor4ubVertex3fSUN'));
  glColor4ubVertex3fvSUN:=TglColor4ubVertex3fvSUN(GLGetProcAddr('glColor4ubVertex3fvSUN'));
  if not Assigned(glColor4ubVertex3fvSUN) then 
    glColor4ubVertex3fvSUN:=TglColor4ubVertex3fvSUN(GetProcAddress(Lib, 'glColor4ubVertex3fvSUN'));
  glColor4ubv:=TglColor4ubv(GLGetProcAddr('glColor4ubv'));
  if not Assigned(glColor4ubv) then 
    glColor4ubv:=TglColor4ubv(GetProcAddress(Lib, 'glColor4ubv'));
  glColor4ui:=TglColor4ui(GLGetProcAddr('glColor4ui'));
  if not Assigned(glColor4ui) then 
    glColor4ui:=TglColor4ui(GetProcAddress(Lib, 'glColor4ui'));
  glColor4uiv:=TglColor4uiv(GLGetProcAddr('glColor4uiv'));
  if not Assigned(glColor4uiv) then 
    glColor4uiv:=TglColor4uiv(GetProcAddress(Lib, 'glColor4uiv'));
  glColor4us:=TglColor4us(GLGetProcAddr('glColor4us'));
  if not Assigned(glColor4us) then 
    glColor4us:=TglColor4us(GetProcAddress(Lib, 'glColor4us'));
  glColor4usv:=TglColor4usv(GLGetProcAddr('glColor4usv'));
  if not Assigned(glColor4usv) then 
    glColor4usv:=TglColor4usv(GetProcAddress(Lib, 'glColor4usv'));
  glColor4x:=TglColor4x(GLGetProcAddr('glColor4x'));
  if not Assigned(glColor4x) then 
    glColor4x:=TglColor4x(GetProcAddress(Lib, 'glColor4x'));
  glColor4xOES:=TglColor4xOES(GLGetProcAddr('glColor4xOES'));
  if not Assigned(glColor4xOES) then
    glColor4xOES:=TglColor4xOES(GetProcAddress(Lib, 'glColor4xOES'));
  glColor4xvOES:=TglColor4xvOES(GLGetProcAddr('glColor4xvOES'));
  if not Assigned(glColor4xvOES) then 
    glColor4xvOES:=TglColor4xvOES(GetProcAddress(Lib, 'glColor4xvOES'));
  glColorFormatNV:=TglColorFormatNV(GLGetProcAddr('glColorFormatNV'));
  if not Assigned(glColorFormatNV) then 
    glColorFormatNV:=TglColorFormatNV(GetProcAddress(Lib, 'glColorFormatNV'));
  glColorFragmentOp1ATI:=TglColorFragmentOp1ATI(GLGetProcAddr('glColorFragmentOp1ATI'));
  if not Assigned(glColorFragmentOp1ATI) then 
    glColorFragmentOp1ATI:=TglColorFragmentOp1ATI(GetProcAddress(Lib, 'glColorFragmentOp1ATI'));
  glColorFragmentOp2ATI:=TglColorFragmentOp2ATI(GLGetProcAddr('glColorFragmentOp2ATI'));
  if not Assigned(glColorFragmentOp2ATI) then 
    glColorFragmentOp2ATI:=TglColorFragmentOp2ATI(GetProcAddress(Lib, 'glColorFragmentOp2ATI'));
  glColorFragmentOp3ATI:=TglColorFragmentOp3ATI(GLGetProcAddr('glColorFragmentOp3ATI'));
  if not Assigned(glColorFragmentOp3ATI) then 
    glColorFragmentOp3ATI:=TglColorFragmentOp3ATI(GetProcAddress(Lib, 'glColorFragmentOp3ATI'));
  glColorMask:=TglColorMask(GLGetProcAddr('glColorMask'));
  if not Assigned(glColorMask) then 
    glColorMask:=TglColorMask(GetProcAddress(Lib, 'glColorMask'));
  glColorMaskIndexedEXT:=TglColorMaskIndexedEXT(GLGetProcAddr('glColorMaskIndexedEXT'));
  if not Assigned(glColorMaskIndexedEXT) then 
    glColorMaskIndexedEXT:=TglColorMaskIndexedEXT(GetProcAddress(Lib, 'glColorMaskIndexedEXT'));
  glColorMaski:=TglColorMaski(GLGetProcAddr('glColorMaski'));
  if not Assigned(glColorMaski) then 
    glColorMaski:=TglColorMaski(GetProcAddress(Lib, 'glColorMaski'));
  glColorMaskiEXT:=TglColorMaskiEXT(GLGetProcAddr('glColorMaskiEXT'));
  if not Assigned(glColorMaskiEXT) then 
    glColorMaskiEXT:=TglColorMaskiEXT(GetProcAddress(Lib, 'glColorMaskiEXT'));
  glColorMaskiOES:=TglColorMaskiOES(GLGetProcAddr('glColorMaskiOES'));
  if not Assigned(glColorMaskiOES) then 
    glColorMaskiOES:=TglColorMaskiOES(GetProcAddress(Lib, 'glColorMaskiOES'));
  glColorMaterial:=TglColorMaterial(GLGetProcAddr('glColorMaterial'));
  if not Assigned(glColorMaterial) then 
    glColorMaterial:=TglColorMaterial(GetProcAddress(Lib, 'glColorMaterial'));
  glColorP3ui:=TglColorP3ui(GLGetProcAddr('glColorP3ui'));
  if not Assigned(glColorP3ui) then
    glColorP3ui:=TglColorP3ui(GetProcAddress(Lib, 'glColorP3ui'));
  glColorP3uiv:=TglColorP3uiv(GLGetProcAddr('glColorP3uiv'));
  if not Assigned(glColorP3uiv) then 
    glColorP3uiv:=TglColorP3uiv(GetProcAddress(Lib, 'glColorP3uiv'));
  glColorP4ui:=TglColorP4ui(GLGetProcAddr('glColorP4ui'));
  if not Assigned(glColorP4ui) then 
    glColorP4ui:=TglColorP4ui(GetProcAddress(Lib, 'glColorP4ui'));
  glColorP4uiv:=TglColorP4uiv(GLGetProcAddr('glColorP4uiv'));
  if not Assigned(glColorP4uiv) then
    glColorP4uiv:=TglColorP4uiv(GetProcAddress(Lib, 'glColorP4uiv'));
  glColorPointer:=TglColorPointer(GLGetProcAddr('glColorPointer'));
  if not Assigned(glColorPointer) then 
    glColorPointer:=TglColorPointer(GetProcAddress(Lib, 'glColorPointer'));
  glColorPointerEXT:=TglColorPointerEXT(GLGetProcAddr('glColorPointerEXT'));
  if not Assigned(glColorPointerEXT) then 
    glColorPointerEXT:=TglColorPointerEXT(GetProcAddress(Lib, 'glColorPointerEXT'));
  glColorPointerListIBM:=TglColorPointerListIBM(GLGetProcAddr('glColorPointerListIBM'));
  if not Assigned(glColorPointerListIBM) then 
    glColorPointerListIBM:=TglColorPointerListIBM(GetProcAddress(Lib, 'glColorPointerListIBM'));
  glColorPointervINTEL:=TglColorPointervINTEL(GLGetProcAddr('glColorPointervINTEL'));
  if not Assigned(glColorPointervINTEL) then
    glColorPointervINTEL:=TglColorPointervINTEL(GetProcAddress(Lib, 'glColorPointervINTEL'));
  glColorSubTable:=TglColorSubTable(GLGetProcAddr('glColorSubTable'));
  if not Assigned(glColorSubTable) then 
    glColorSubTable:=TglColorSubTable(GetProcAddress(Lib, 'glColorSubTable'));
  glColorSubTableEXT:=TglColorSubTableEXT(GLGetProcAddr('glColorSubTableEXT'));
  if not Assigned(glColorSubTableEXT) then 
    glColorSubTableEXT:=TglColorSubTableEXT(GetProcAddress(Lib, 'glColorSubTableEXT'));
  glColorTable:=TglColorTable(GLGetProcAddr('glColorTable'));
  if not Assigned(glColorTable) then 
    glColorTable:=TglColorTable(GetProcAddress(Lib, 'glColorTable'));
  glColorTableEXT:=TglColorTableEXT(GLGetProcAddr('glColorTableEXT'));
  if not Assigned(glColorTableEXT) then 
    glColorTableEXT:=TglColorTableEXT(GetProcAddress(Lib, 'glColorTableEXT'));
  glColorTableParameterfv:=TglColorTableParameterfv(GLGetProcAddr('glColorTableParameterfv'));
  if not Assigned(glColorTableParameterfv) then 
    glColorTableParameterfv:=TglColorTableParameterfv(GetProcAddress(Lib, 'glColorTableParameterfv'));
  glColorTableParameterfvSGI:=TglColorTableParameterfvSGI(GLGetProcAddr('glColorTableParameterfvSGI'));
  if not Assigned(glColorTableParameterfvSGI) then 
    glColorTableParameterfvSGI:=TglColorTableParameterfvSGI(GetProcAddress(Lib, 'glColorTableParameterfvSGI'));
  glColorTableParameteriv:=TglColorTableParameteriv(GLGetProcAddr('glColorTableParameteriv'));
  if not Assigned(glColorTableParameteriv) then 
    glColorTableParameteriv:=TglColorTableParameteriv(GetProcAddress(Lib, 'glColorTableParameteriv'));
  glColorTableParameterivSGI:=TglColorTableParameterivSGI(GLGetProcAddr('glColorTableParameterivSGI'));
  if not Assigned(glColorTableParameterivSGI) then 
    glColorTableParameterivSGI:=TglColorTableParameterivSGI(GetProcAddress(Lib, 'glColorTableParameterivSGI'));
  glColorTableSGI:=TglColorTableSGI(GLGetProcAddr('glColorTableSGI'));
  if not Assigned(glColorTableSGI) then 
    glColorTableSGI:=TglColorTableSGI(GetProcAddress(Lib, 'glColorTableSGI'));
  glCombinerInputNV:=TglCombinerInputNV(GLGetProcAddr('glCombinerInputNV'));
  if not Assigned(glCombinerInputNV) then 
    glCombinerInputNV:=TglCombinerInputNV(GetProcAddress(Lib, 'glCombinerInputNV'));
  glCombinerOutputNV:=TglCombinerOutputNV(GLGetProcAddr('glCombinerOutputNV'));
  if not Assigned(glCombinerOutputNV) then 
    glCombinerOutputNV:=TglCombinerOutputNV(GetProcAddress(Lib, 'glCombinerOutputNV'));
  glCombinerParameterfNV:=TglCombinerParameterfNV(GLGetProcAddr('glCombinerParameterfNV'));
  if not Assigned(glCombinerParameterfNV) then 
    glCombinerParameterfNV:=TglCombinerParameterfNV(GetProcAddress(Lib, 'glCombinerParameterfNV'));
  glCombinerParameterfvNV:=TglCombinerParameterfvNV(GLGetProcAddr('glCombinerParameterfvNV'));
  if not Assigned(glCombinerParameterfvNV) then 
    glCombinerParameterfvNV:=TglCombinerParameterfvNV(GetProcAddress(Lib, 'glCombinerParameterfvNV'));
  glCombinerParameteriNV:=TglCombinerParameteriNV(GLGetProcAddr('glCombinerParameteriNV'));
  if not Assigned(glCombinerParameteriNV) then 
    glCombinerParameteriNV:=TglCombinerParameteriNV(GetProcAddress(Lib, 'glCombinerParameteriNV'));
  glCombinerParameterivNV:=TglCombinerParameterivNV(GLGetProcAddr('glCombinerParameterivNV'));
  if not Assigned(glCombinerParameterivNV) then 
    glCombinerParameterivNV:=TglCombinerParameterivNV(GetProcAddress(Lib, 'glCombinerParameterivNV'));
  glCombinerStageParameterfvNV:=TglCombinerStageParameterfvNV(GLGetProcAddr('glCombinerStageParameterfvNV'));
  if not Assigned(glCombinerStageParameterfvNV) then 
    glCombinerStageParameterfvNV:=TglCombinerStageParameterfvNV(GetProcAddress(Lib, 'glCombinerStageParameterfvNV'));
  glCommandListSegmentsNV:=TglCommandListSegmentsNV(GLGetProcAddr('glCommandListSegmentsNV'));
  if not Assigned(glCommandListSegmentsNV) then 
    glCommandListSegmentsNV:=TglCommandListSegmentsNV(GetProcAddress(Lib, 'glCommandListSegmentsNV'));
  glCompileCommandListNV:=TglCompileCommandListNV(GLGetProcAddr('glCompileCommandListNV'));
  if not Assigned(glCompileCommandListNV) then 
    glCompileCommandListNV:=TglCompileCommandListNV(GetProcAddress(Lib, 'glCompileCommandListNV'));
  glCompileShader:=TglCompileShader(GLGetProcAddr('glCompileShader'));
  if not Assigned(glCompileShader) then
    glCompileShader:=TglCompileShader(GetProcAddress(Lib, 'glCompileShader'));
  glCompileShaderARB:=TglCompileShaderARB(GLGetProcAddr('glCompileShaderARB'));
  if not Assigned(glCompileShaderARB) then 
    glCompileShaderARB:=TglCompileShaderARB(GetProcAddress(Lib, 'glCompileShaderARB'));
  glCompileShaderIncludeARB:=TglCompileShaderIncludeARB(GLGetProcAddr('glCompileShaderIncludeARB'));
  if not Assigned(glCompileShaderIncludeARB) then 
    glCompileShaderIncludeARB:=TglCompileShaderIncludeARB(GetProcAddress(Lib, 'glCompileShaderIncludeARB'));
  glCompressedMultiTexImage1DEXT:=TglCompressedMultiTexImage1DEXT(GLGetProcAddr('glCompressedMultiTexImage1DEXT'));
  if not Assigned(glCompressedMultiTexImage1DEXT) then
    glCompressedMultiTexImage1DEXT:=TglCompressedMultiTexImage1DEXT(GetProcAddress(Lib, 'glCompressedMultiTexImage1DEXT'));
  glCompressedMultiTexImage2DEXT:=TglCompressedMultiTexImage2DEXT(GLGetProcAddr('glCompressedMultiTexImage2DEXT'));
  if not Assigned(glCompressedMultiTexImage2DEXT) then 
    glCompressedMultiTexImage2DEXT:=TglCompressedMultiTexImage2DEXT(GetProcAddress(Lib, 'glCompressedMultiTexImage2DEXT'));
  glCompressedMultiTexImage3DEXT:=TglCompressedMultiTexImage3DEXT(GLGetProcAddr('glCompressedMultiTexImage3DEXT'));
  if not Assigned(glCompressedMultiTexImage3DEXT) then 
    glCompressedMultiTexImage3DEXT:=TglCompressedMultiTexImage3DEXT(GetProcAddress(Lib, 'glCompressedMultiTexImage3DEXT'));
  glCompressedMultiTexSubImage1DEXT:=TglCompressedMultiTexSubImage1DEXT(GLGetProcAddr('glCompressedMultiTexSubImage1DEXT'));
  if not Assigned(glCompressedMultiTexSubImage1DEXT) then 
    glCompressedMultiTexSubImage1DEXT:=TglCompressedMultiTexSubImage1DEXT(GetProcAddress(Lib, 'glCompressedMultiTexSubImage1DEXT'));
  glCompressedMultiTexSubImage2DEXT:=TglCompressedMultiTexSubImage2DEXT(GLGetProcAddr('glCompressedMultiTexSubImage2DEXT'));
  if not Assigned(glCompressedMultiTexSubImage2DEXT) then 
    glCompressedMultiTexSubImage2DEXT:=TglCompressedMultiTexSubImage2DEXT(GetProcAddress(Lib, 'glCompressedMultiTexSubImage2DEXT'));
  glCompressedMultiTexSubImage3DEXT:=TglCompressedMultiTexSubImage3DEXT(GLGetProcAddr('glCompressedMultiTexSubImage3DEXT'));
  if not Assigned(glCompressedMultiTexSubImage3DEXT) then 
    glCompressedMultiTexSubImage3DEXT:=TglCompressedMultiTexSubImage3DEXT(GetProcAddress(Lib, 'glCompressedMultiTexSubImage3DEXT'));
  glCompressedTexImage1D:=TglCompressedTexImage1D(GLGetProcAddr('glCompressedTexImage1D'));
  if not Assigned(glCompressedTexImage1D) then 
    glCompressedTexImage1D:=TglCompressedTexImage1D(GetProcAddress(Lib, 'glCompressedTexImage1D'));
  glCompressedTexImage1DARB:=TglCompressedTexImage1DARB(GLGetProcAddr('glCompressedTexImage1DARB'));
  if not Assigned(glCompressedTexImage1DARB) then 
    glCompressedTexImage1DARB:=TglCompressedTexImage1DARB(GetProcAddress(Lib, 'glCompressedTexImage1DARB'));
  glCompressedTexImage2D:=TglCompressedTexImage2D(GLGetProcAddr('glCompressedTexImage2D'));
  if not Assigned(glCompressedTexImage2D) then 
    glCompressedTexImage2D:=TglCompressedTexImage2D(GetProcAddress(Lib, 'glCompressedTexImage2D'));
  glCompressedTexImage2DARB:=TglCompressedTexImage2DARB(GLGetProcAddr('glCompressedTexImage2DARB'));
  if not Assigned(glCompressedTexImage2DARB) then 
    glCompressedTexImage2DARB:=TglCompressedTexImage2DARB(GetProcAddress(Lib, 'glCompressedTexImage2DARB'));
  glCompressedTexImage3D:=TglCompressedTexImage3D(GLGetProcAddr('glCompressedTexImage3D'));
  if not Assigned(glCompressedTexImage3D) then 
    glCompressedTexImage3D:=TglCompressedTexImage3D(GetProcAddress(Lib, 'glCompressedTexImage3D'));
  glCompressedTexImage3DARB:=TglCompressedTexImage3DARB(GLGetProcAddr('glCompressedTexImage3DARB'));
  if not Assigned(glCompressedTexImage3DARB) then 
    glCompressedTexImage3DARB:=TglCompressedTexImage3DARB(GetProcAddress(Lib, 'glCompressedTexImage3DARB'));
  glCompressedTexImage3DOES:=TglCompressedTexImage3DOES(GLGetProcAddr('glCompressedTexImage3DOES'));
  if not Assigned(glCompressedTexImage3DOES) then 
    glCompressedTexImage3DOES:=TglCompressedTexImage3DOES(GetProcAddress(Lib, 'glCompressedTexImage3DOES'));
  glCompressedTexSubImage1D:=TglCompressedTexSubImage1D(GLGetProcAddr('glCompressedTexSubImage1D'));
  if not Assigned(glCompressedTexSubImage1D) then 
    glCompressedTexSubImage1D:=TglCompressedTexSubImage1D(GetProcAddress(Lib, 'glCompressedTexSubImage1D'));
  glCompressedTexSubImage1DARB:=TglCompressedTexSubImage1DARB(GLGetProcAddr('glCompressedTexSubImage1DARB'));
  if not Assigned(glCompressedTexSubImage1DARB) then 
    glCompressedTexSubImage1DARB:=TglCompressedTexSubImage1DARB(GetProcAddress(Lib, 'glCompressedTexSubImage1DARB'));
  glCompressedTexSubImage2D:=TglCompressedTexSubImage2D(GLGetProcAddr('glCompressedTexSubImage2D'));
  if not Assigned(glCompressedTexSubImage2D) then 
    glCompressedTexSubImage2D:=TglCompressedTexSubImage2D(GetProcAddress(Lib, 'glCompressedTexSubImage2D'));
  glCompressedTexSubImage2DARB:=TglCompressedTexSubImage2DARB(GLGetProcAddr('glCompressedTexSubImage2DARB'));
  if not Assigned(glCompressedTexSubImage2DARB) then
    glCompressedTexSubImage2DARB:=TglCompressedTexSubImage2DARB(GetProcAddress(Lib, 'glCompressedTexSubImage2DARB'));
  glCompressedTexSubImage3D:=TglCompressedTexSubImage3D(GLGetProcAddr('glCompressedTexSubImage3D'));
  if not Assigned(glCompressedTexSubImage3D) then 
    glCompressedTexSubImage3D:=TglCompressedTexSubImage3D(GetProcAddress(Lib, 'glCompressedTexSubImage3D'));
  glCompressedTexSubImage3DARB:=TglCompressedTexSubImage3DARB(GLGetProcAddr('glCompressedTexSubImage3DARB'));
  if not Assigned(glCompressedTexSubImage3DARB) then 
    glCompressedTexSubImage3DARB:=TglCompressedTexSubImage3DARB(GetProcAddress(Lib, 'glCompressedTexSubImage3DARB'));
  glCompressedTexSubImage3DOES:=TglCompressedTexSubImage3DOES(GLGetProcAddr('glCompressedTexSubImage3DOES'));
  if not Assigned(glCompressedTexSubImage3DOES) then 
    glCompressedTexSubImage3DOES:=TglCompressedTexSubImage3DOES(GetProcAddress(Lib, 'glCompressedTexSubImage3DOES'));
  glCompressedTextureImage1DEXT:=TglCompressedTextureImage1DEXT(GLGetProcAddr('glCompressedTextureImage1DEXT'));
  if not Assigned(glCompressedTextureImage1DEXT) then 
    glCompressedTextureImage1DEXT:=TglCompressedTextureImage1DEXT(GetProcAddress(Lib, 'glCompressedTextureImage1DEXT'));
  glCompressedTextureImage2DEXT:=TglCompressedTextureImage2DEXT(GLGetProcAddr('glCompressedTextureImage2DEXT'));
  if not Assigned(glCompressedTextureImage2DEXT) then 
    glCompressedTextureImage2DEXT:=TglCompressedTextureImage2DEXT(GetProcAddress(Lib, 'glCompressedTextureImage2DEXT'));
  glCompressedTextureImage3DEXT:=TglCompressedTextureImage3DEXT(GLGetProcAddr('glCompressedTextureImage3DEXT'));
  if not Assigned(glCompressedTextureImage3DEXT) then 
    glCompressedTextureImage3DEXT:=TglCompressedTextureImage3DEXT(GetProcAddress(Lib, 'glCompressedTextureImage3DEXT'));
  glCompressedTextureSubImage1D:=TglCompressedTextureSubImage1D(GLGetProcAddr('glCompressedTextureSubImage1D'));
  if not Assigned(glCompressedTextureSubImage1D) then
    glCompressedTextureSubImage1D:=TglCompressedTextureSubImage1D(GetProcAddress(Lib, 'glCompressedTextureSubImage1D'));
  glCompressedTextureSubImage1DEXT:=TglCompressedTextureSubImage1DEXT(GLGetProcAddr('glCompressedTextureSubImage1DEXT'));
  if not Assigned(glCompressedTextureSubImage1DEXT) then 
    glCompressedTextureSubImage1DEXT:=TglCompressedTextureSubImage1DEXT(GetProcAddress(Lib, 'glCompressedTextureSubImage1DEXT'));
  glCompressedTextureSubImage2D:=TglCompressedTextureSubImage2D(GLGetProcAddr('glCompressedTextureSubImage2D'));
  if not Assigned(glCompressedTextureSubImage2D) then 
    glCompressedTextureSubImage2D:=TglCompressedTextureSubImage2D(GetProcAddress(Lib, 'glCompressedTextureSubImage2D'));
  glCompressedTextureSubImage2DEXT:=TglCompressedTextureSubImage2DEXT(GLGetProcAddr('glCompressedTextureSubImage2DEXT'));
  if not Assigned(glCompressedTextureSubImage2DEXT) then
    glCompressedTextureSubImage2DEXT:=TglCompressedTextureSubImage2DEXT(GetProcAddress(Lib, 'glCompressedTextureSubImage2DEXT'));
  glCompressedTextureSubImage3D:=TglCompressedTextureSubImage3D(GLGetProcAddr('glCompressedTextureSubImage3D'));
  if not Assigned(glCompressedTextureSubImage3D) then 
    glCompressedTextureSubImage3D:=TglCompressedTextureSubImage3D(GetProcAddress(Lib, 'glCompressedTextureSubImage3D'));
  glCompressedTextureSubImage3DEXT:=TglCompressedTextureSubImage3DEXT(GLGetProcAddr('glCompressedTextureSubImage3DEXT'));
  if not Assigned(glCompressedTextureSubImage3DEXT) then 
    glCompressedTextureSubImage3DEXT:=TglCompressedTextureSubImage3DEXT(GetProcAddress(Lib, 'glCompressedTextureSubImage3DEXT'));
  glConservativeRasterParameterfNV:=TglConservativeRasterParameterfNV(GLGetProcAddr('glConservativeRasterParameterfNV'));
  if not Assigned(glConservativeRasterParameterfNV) then 
    glConservativeRasterParameterfNV:=TglConservativeRasterParameterfNV(GetProcAddress(Lib, 'glConservativeRasterParameterfNV'));
  glConservativeRasterParameteriNV:=TglConservativeRasterParameteriNV(GLGetProcAddr('glConservativeRasterParameteriNV'));
  if not Assigned(glConservativeRasterParameteriNV) then 
    glConservativeRasterParameteriNV:=TglConservativeRasterParameteriNV(GetProcAddress(Lib, 'glConservativeRasterParameteriNV'));
  glConvolutionFilter1D:=TglConvolutionFilter1D(GLGetProcAddr('glConvolutionFilter1D'));
  if not Assigned(glConvolutionFilter1D) then 
    glConvolutionFilter1D:=TglConvolutionFilter1D(GetProcAddress(Lib, 'glConvolutionFilter1D'));
  glConvolutionFilter1DEXT:=TglConvolutionFilter1DEXT(GLGetProcAddr('glConvolutionFilter1DEXT'));
  if not Assigned(glConvolutionFilter1DEXT) then 
    glConvolutionFilter1DEXT:=TglConvolutionFilter1DEXT(GetProcAddress(Lib, 'glConvolutionFilter1DEXT'));
  glConvolutionFilter2D:=TglConvolutionFilter2D(GLGetProcAddr('glConvolutionFilter2D'));
  if not Assigned(glConvolutionFilter2D) then 
    glConvolutionFilter2D:=TglConvolutionFilter2D(GetProcAddress(Lib, 'glConvolutionFilter2D'));
  glConvolutionFilter2DEXT:=TglConvolutionFilter2DEXT(GLGetProcAddr('glConvolutionFilter2DEXT'));
  if not Assigned(glConvolutionFilter2DEXT) then 
    glConvolutionFilter2DEXT:=TglConvolutionFilter2DEXT(GetProcAddress(Lib, 'glConvolutionFilter2DEXT'));
  glConvolutionParameterf:=TglConvolutionParameterf(GLGetProcAddr('glConvolutionParameterf'));
  if not Assigned(glConvolutionParameterf) then
    glConvolutionParameterf:=TglConvolutionParameterf(GetProcAddress(Lib, 'glConvolutionParameterf'));
  glConvolutionParameterfEXT:=TglConvolutionParameterfEXT(GLGetProcAddr('glConvolutionParameterfEXT'));
  if not Assigned(glConvolutionParameterfEXT) then 
    glConvolutionParameterfEXT:=TglConvolutionParameterfEXT(GetProcAddress(Lib, 'glConvolutionParameterfEXT'));
  glConvolutionParameterfv:=TglConvolutionParameterfv(GLGetProcAddr('glConvolutionParameterfv'));
  if not Assigned(glConvolutionParameterfv) then 
    glConvolutionParameterfv:=TglConvolutionParameterfv(GetProcAddress(Lib, 'glConvolutionParameterfv'));
  glConvolutionParameterfvEXT:=TglConvolutionParameterfvEXT(GLGetProcAddr('glConvolutionParameterfvEXT'));
  if not Assigned(glConvolutionParameterfvEXT) then 
    glConvolutionParameterfvEXT:=TglConvolutionParameterfvEXT(GetProcAddress(Lib, 'glConvolutionParameterfvEXT'));
  glConvolutionParameteri:=TglConvolutionParameteri(GLGetProcAddr('glConvolutionParameteri'));
  if not Assigned(glConvolutionParameteri) then 
    glConvolutionParameteri:=TglConvolutionParameteri(GetProcAddress(Lib, 'glConvolutionParameteri'));
  glConvolutionParameteriEXT:=TglConvolutionParameteriEXT(GLGetProcAddr('glConvolutionParameteriEXT'));
  if not Assigned(glConvolutionParameteriEXT) then 
    glConvolutionParameteriEXT:=TglConvolutionParameteriEXT(GetProcAddress(Lib, 'glConvolutionParameteriEXT'));
  glConvolutionParameteriv:=TglConvolutionParameteriv(GLGetProcAddr('glConvolutionParameteriv'));
  if not Assigned(glConvolutionParameteriv) then 
    glConvolutionParameteriv:=TglConvolutionParameteriv(GetProcAddress(Lib, 'glConvolutionParameteriv'));
  glConvolutionParameterivEXT:=TglConvolutionParameterivEXT(GLGetProcAddr('glConvolutionParameterivEXT'));
  if not Assigned(glConvolutionParameterivEXT) then 
    glConvolutionParameterivEXT:=TglConvolutionParameterivEXT(GetProcAddress(Lib, 'glConvolutionParameterivEXT'));
  glConvolutionParameterxOES:=TglConvolutionParameterxOES(GLGetProcAddr('glConvolutionParameterxOES'));
  if not Assigned(glConvolutionParameterxOES) then 
    glConvolutionParameterxOES:=TglConvolutionParameterxOES(GetProcAddress(Lib, 'glConvolutionParameterxOES'));
  glConvolutionParameterxvOES:=TglConvolutionParameterxvOES(GLGetProcAddr('glConvolutionParameterxvOES'));
  if not Assigned(glConvolutionParameterxvOES) then 
    glConvolutionParameterxvOES:=TglConvolutionParameterxvOES(GetProcAddress(Lib, 'glConvolutionParameterxvOES'));
  glCopyBufferSubData:=TglCopyBufferSubData(GLGetProcAddr('glCopyBufferSubData'));
  if not Assigned(glCopyBufferSubData) then 
    glCopyBufferSubData:=TglCopyBufferSubData(GetProcAddress(Lib, 'glCopyBufferSubData'));
  glCopyBufferSubDataNV:=TglCopyBufferSubDataNV(GLGetProcAddr('glCopyBufferSubDataNV'));
  if not Assigned(glCopyBufferSubDataNV) then 
    glCopyBufferSubDataNV:=TglCopyBufferSubDataNV(GetProcAddress(Lib, 'glCopyBufferSubDataNV'));
  glCopyColorSubTable:=TglCopyColorSubTable(GLGetProcAddr('glCopyColorSubTable'));
  if not Assigned(glCopyColorSubTable) then 
    glCopyColorSubTable:=TglCopyColorSubTable(GetProcAddress(Lib, 'glCopyColorSubTable'));
  glCopyColorSubTableEXT:=TglCopyColorSubTableEXT(GLGetProcAddr('glCopyColorSubTableEXT'));
  if not Assigned(glCopyColorSubTableEXT) then 
    glCopyColorSubTableEXT:=TglCopyColorSubTableEXT(GetProcAddress(Lib, 'glCopyColorSubTableEXT'));
  glCopyColorTable:=TglCopyColorTable(GLGetProcAddr('glCopyColorTable'));
  if not Assigned(glCopyColorTable) then
    glCopyColorTable:=TglCopyColorTable(GetProcAddress(Lib, 'glCopyColorTable'));
  glCopyColorTableSGI:=TglCopyColorTableSGI(GLGetProcAddr('glCopyColorTableSGI'));
  if not Assigned(glCopyColorTableSGI) then 
    glCopyColorTableSGI:=TglCopyColorTableSGI(GetProcAddress(Lib, 'glCopyColorTableSGI'));
  glCopyConvolutionFilter1D:=TglCopyConvolutionFilter1D(GLGetProcAddr('glCopyConvolutionFilter1D'));
  if not Assigned(glCopyConvolutionFilter1D) then 
    glCopyConvolutionFilter1D:=TglCopyConvolutionFilter1D(GetProcAddress(Lib, 'glCopyConvolutionFilter1D'));
  glCopyConvolutionFilter1DEXT:=TglCopyConvolutionFilter1DEXT(GLGetProcAddr('glCopyConvolutionFilter1DEXT'));
  if not Assigned(glCopyConvolutionFilter1DEXT) then
    glCopyConvolutionFilter1DEXT:=TglCopyConvolutionFilter1DEXT(GetProcAddress(Lib, 'glCopyConvolutionFilter1DEXT'));
  glCopyConvolutionFilter2D:=TglCopyConvolutionFilter2D(GLGetProcAddr('glCopyConvolutionFilter2D'));
  if not Assigned(glCopyConvolutionFilter2D) then 
    glCopyConvolutionFilter2D:=TglCopyConvolutionFilter2D(GetProcAddress(Lib, 'glCopyConvolutionFilter2D'));
  glCopyConvolutionFilter2DEXT:=TglCopyConvolutionFilter2DEXT(GLGetProcAddr('glCopyConvolutionFilter2DEXT'));
  if not Assigned(glCopyConvolutionFilter2DEXT) then
    glCopyConvolutionFilter2DEXT:=TglCopyConvolutionFilter2DEXT(GetProcAddress(Lib, 'glCopyConvolutionFilter2DEXT'));
  glCopyImageSubData:=TglCopyImageSubData(GLGetProcAddr('glCopyImageSubData'));
  if not Assigned(glCopyImageSubData) then 
    glCopyImageSubData:=TglCopyImageSubData(GetProcAddress(Lib, 'glCopyImageSubData'));
  glCopyImageSubDataEXT:=TglCopyImageSubDataEXT(GLGetProcAddr('glCopyImageSubDataEXT'));
  if not Assigned(glCopyImageSubDataEXT) then 
    glCopyImageSubDataEXT:=TglCopyImageSubDataEXT(GetProcAddress(Lib, 'glCopyImageSubDataEXT'));
  glCopyImageSubDataNV:=TglCopyImageSubDataNV(GLGetProcAddr('glCopyImageSubDataNV'));
  if not Assigned(glCopyImageSubDataNV) then 
    glCopyImageSubDataNV:=TglCopyImageSubDataNV(GetProcAddress(Lib, 'glCopyImageSubDataNV'));
  glCopyImageSubDataOES:=TglCopyImageSubDataOES(GLGetProcAddr('glCopyImageSubDataOES'));
  if not Assigned(glCopyImageSubDataOES) then 
    glCopyImageSubDataOES:=TglCopyImageSubDataOES(GetProcAddress(Lib, 'glCopyImageSubDataOES'));
  glCopyMultiTexImage1DEXT:=TglCopyMultiTexImage1DEXT(GLGetProcAddr('glCopyMultiTexImage1DEXT'));
  if not Assigned(glCopyMultiTexImage1DEXT) then 
    glCopyMultiTexImage1DEXT:=TglCopyMultiTexImage1DEXT(GetProcAddress(Lib, 'glCopyMultiTexImage1DEXT'));
  glCopyMultiTexImage2DEXT:=TglCopyMultiTexImage2DEXT(GLGetProcAddr('glCopyMultiTexImage2DEXT'));
  if not Assigned(glCopyMultiTexImage2DEXT) then 
    glCopyMultiTexImage2DEXT:=TglCopyMultiTexImage2DEXT(GetProcAddress(Lib, 'glCopyMultiTexImage2DEXT'));
  glCopyMultiTexSubImage1DEXT:=TglCopyMultiTexSubImage1DEXT(GLGetProcAddr('glCopyMultiTexSubImage1DEXT'));
  if not Assigned(glCopyMultiTexSubImage1DEXT) then 
    glCopyMultiTexSubImage1DEXT:=TglCopyMultiTexSubImage1DEXT(GetProcAddress(Lib, 'glCopyMultiTexSubImage1DEXT'));
  glCopyMultiTexSubImage2DEXT:=TglCopyMultiTexSubImage2DEXT(GLGetProcAddr('glCopyMultiTexSubImage2DEXT'));
  if not Assigned(glCopyMultiTexSubImage2DEXT) then 
    glCopyMultiTexSubImage2DEXT:=TglCopyMultiTexSubImage2DEXT(GetProcAddress(Lib, 'glCopyMultiTexSubImage2DEXT'));
  glCopyMultiTexSubImage3DEXT:=TglCopyMultiTexSubImage3DEXT(GLGetProcAddr('glCopyMultiTexSubImage3DEXT'));
  if not Assigned(glCopyMultiTexSubImage3DEXT) then 
    glCopyMultiTexSubImage3DEXT:=TglCopyMultiTexSubImage3DEXT(GetProcAddress(Lib, 'glCopyMultiTexSubImage3DEXT'));
  glCopyNamedBufferSubData:=TglCopyNamedBufferSubData(GLGetProcAddr('glCopyNamedBufferSubData'));
  if not Assigned(glCopyNamedBufferSubData) then 
    glCopyNamedBufferSubData:=TglCopyNamedBufferSubData(GetProcAddress(Lib, 'glCopyNamedBufferSubData'));
  glCopyPathNV:=TglCopyPathNV(GLGetProcAddr('glCopyPathNV'));
  if not Assigned(glCopyPathNV) then 
    glCopyPathNV:=TglCopyPathNV(GetProcAddress(Lib, 'glCopyPathNV'));
  glCopyPixels:=TglCopyPixels(GLGetProcAddr('glCopyPixels'));
  if not Assigned(glCopyPixels) then 
    glCopyPixels:=TglCopyPixels(GetProcAddress(Lib, 'glCopyPixels'));
  glCopyTexImage1D:=TglCopyTexImage1D(GLGetProcAddr('glCopyTexImage1D'));
  if not Assigned(glCopyTexImage1D) then 
    glCopyTexImage1D:=TglCopyTexImage1D(GetProcAddress(Lib, 'glCopyTexImage1D'));
  glCopyTexImage1DEXT:=TglCopyTexImage1DEXT(GLGetProcAddr('glCopyTexImage1DEXT'));
  if not Assigned(glCopyTexImage1DEXT) then 
    glCopyTexImage1DEXT:=TglCopyTexImage1DEXT(GetProcAddress(Lib, 'glCopyTexImage1DEXT'));
  glCopyTexImage2D:=TglCopyTexImage2D(GLGetProcAddr('glCopyTexImage2D'));
  if not Assigned(glCopyTexImage2D) then 
    glCopyTexImage2D:=TglCopyTexImage2D(GetProcAddress(Lib, 'glCopyTexImage2D'));
  glCopyTexImage2DEXT:=TglCopyTexImage2DEXT(GLGetProcAddr('glCopyTexImage2DEXT'));
  if not Assigned(glCopyTexImage2DEXT) then 
    glCopyTexImage2DEXT:=TglCopyTexImage2DEXT(GetProcAddress(Lib, 'glCopyTexImage2DEXT'));
  glCopyTexSubImage1D:=TglCopyTexSubImage1D(GLGetProcAddr('glCopyTexSubImage1D'));
  if not Assigned(glCopyTexSubImage1D) then 
    glCopyTexSubImage1D:=TglCopyTexSubImage1D(GetProcAddress(Lib, 'glCopyTexSubImage1D'));
  glCopyTexSubImage1DEXT:=TglCopyTexSubImage1DEXT(GLGetProcAddr('glCopyTexSubImage1DEXT'));
  if not Assigned(glCopyTexSubImage1DEXT) then 
    glCopyTexSubImage1DEXT:=TglCopyTexSubImage1DEXT(GetProcAddress(Lib, 'glCopyTexSubImage1DEXT'));
  glCopyTexSubImage2D:=TglCopyTexSubImage2D(GLGetProcAddr('glCopyTexSubImage2D'));
  if not Assigned(glCopyTexSubImage2D) then
    glCopyTexSubImage2D:=TglCopyTexSubImage2D(GetProcAddress(Lib, 'glCopyTexSubImage2D'));
  glCopyTexSubImage2DEXT:=TglCopyTexSubImage2DEXT(GLGetProcAddr('glCopyTexSubImage2DEXT'));
  if not Assigned(glCopyTexSubImage2DEXT) then 
    glCopyTexSubImage2DEXT:=TglCopyTexSubImage2DEXT(GetProcAddress(Lib, 'glCopyTexSubImage2DEXT'));
  glCopyTexSubImage3D:=TglCopyTexSubImage3D(GLGetProcAddr('glCopyTexSubImage3D'));
  if not Assigned(glCopyTexSubImage3D) then
    glCopyTexSubImage3D:=TglCopyTexSubImage3D(GetProcAddress(Lib, 'glCopyTexSubImage3D'));
  glCopyTexSubImage3DEXT:=TglCopyTexSubImage3DEXT(GLGetProcAddr('glCopyTexSubImage3DEXT'));
  if not Assigned(glCopyTexSubImage3DEXT) then 
    glCopyTexSubImage3DEXT:=TglCopyTexSubImage3DEXT(GetProcAddress(Lib, 'glCopyTexSubImage3DEXT'));
  glCopyTexSubImage3DOES:=TglCopyTexSubImage3DOES(GLGetProcAddr('glCopyTexSubImage3DOES'));
  if not Assigned(glCopyTexSubImage3DOES) then 
    glCopyTexSubImage3DOES:=TglCopyTexSubImage3DOES(GetProcAddress(Lib, 'glCopyTexSubImage3DOES'));
  glCopyTextureImage1DEXT:=TglCopyTextureImage1DEXT(GLGetProcAddr('glCopyTextureImage1DEXT'));
  if not Assigned(glCopyTextureImage1DEXT) then
    glCopyTextureImage1DEXT:=TglCopyTextureImage1DEXT(GetProcAddress(Lib, 'glCopyTextureImage1DEXT'));
  glCopyTextureImage2DEXT:=TglCopyTextureImage2DEXT(GLGetProcAddr('glCopyTextureImage2DEXT'));
  if not Assigned(glCopyTextureImage2DEXT) then 
    glCopyTextureImage2DEXT:=TglCopyTextureImage2DEXT(GetProcAddress(Lib, 'glCopyTextureImage2DEXT'));
  glCopyTextureLevelsAPPLE:=TglCopyTextureLevelsAPPLE(GLGetProcAddr('glCopyTextureLevelsAPPLE'));
  if not Assigned(glCopyTextureLevelsAPPLE) then 
    glCopyTextureLevelsAPPLE:=TglCopyTextureLevelsAPPLE(GetProcAddress(Lib, 'glCopyTextureLevelsAPPLE'));
  glCopyTextureSubImage1D:=TglCopyTextureSubImage1D(GLGetProcAddr('glCopyTextureSubImage1D'));
  if not Assigned(glCopyTextureSubImage1D) then 
    glCopyTextureSubImage1D:=TglCopyTextureSubImage1D(GetProcAddress(Lib, 'glCopyTextureSubImage1D'));
  glCopyTextureSubImage1DEXT:=TglCopyTextureSubImage1DEXT(GLGetProcAddr('glCopyTextureSubImage1DEXT'));
  if not Assigned(glCopyTextureSubImage1DEXT) then 
    glCopyTextureSubImage1DEXT:=TglCopyTextureSubImage1DEXT(GetProcAddress(Lib, 'glCopyTextureSubImage1DEXT'));
  glCopyTextureSubImage2D:=TglCopyTextureSubImage2D(GLGetProcAddr('glCopyTextureSubImage2D'));
  if not Assigned(glCopyTextureSubImage2D) then 
    glCopyTextureSubImage2D:=TglCopyTextureSubImage2D(GetProcAddress(Lib, 'glCopyTextureSubImage2D'));
  glCopyTextureSubImage2DEXT:=TglCopyTextureSubImage2DEXT(GLGetProcAddr('glCopyTextureSubImage2DEXT'));
  if not Assigned(glCopyTextureSubImage2DEXT) then 
    glCopyTextureSubImage2DEXT:=TglCopyTextureSubImage2DEXT(GetProcAddress(Lib, 'glCopyTextureSubImage2DEXT'));
  glCopyTextureSubImage3D:=TglCopyTextureSubImage3D(GLGetProcAddr('glCopyTextureSubImage3D'));
  if not Assigned(glCopyTextureSubImage3D) then 
    glCopyTextureSubImage3D:=TglCopyTextureSubImage3D(GetProcAddress(Lib, 'glCopyTextureSubImage3D'));
  glCopyTextureSubImage3DEXT:=TglCopyTextureSubImage3DEXT(GLGetProcAddr('glCopyTextureSubImage3DEXT'));
  if not Assigned(glCopyTextureSubImage3DEXT) then 
    glCopyTextureSubImage3DEXT:=TglCopyTextureSubImage3DEXT(GetProcAddress(Lib, 'glCopyTextureSubImage3DEXT'));
  glCoverFillPathInstancedNV:=TglCoverFillPathInstancedNV(GLGetProcAddr('glCoverFillPathInstancedNV'));
  if not Assigned(glCoverFillPathInstancedNV) then 
    glCoverFillPathInstancedNV:=TglCoverFillPathInstancedNV(GetProcAddress(Lib, 'glCoverFillPathInstancedNV'));
  glCoverFillPathNV:=TglCoverFillPathNV(GLGetProcAddr('glCoverFillPathNV'));
  if not Assigned(glCoverFillPathNV) then 
    glCoverFillPathNV:=TglCoverFillPathNV(GetProcAddress(Lib, 'glCoverFillPathNV'));
  glCoverStrokePathInstancedNV:=TglCoverStrokePathInstancedNV(GLGetProcAddr('glCoverStrokePathInstancedNV'));
  if not Assigned(glCoverStrokePathInstancedNV) then 
    glCoverStrokePathInstancedNV:=TglCoverStrokePathInstancedNV(GetProcAddress(Lib, 'glCoverStrokePathInstancedNV'));
  glCoverStrokePathNV:=TglCoverStrokePathNV(GLGetProcAddr('glCoverStrokePathNV'));
  if not Assigned(glCoverStrokePathNV) then 
    glCoverStrokePathNV:=TglCoverStrokePathNV(GetProcAddress(Lib, 'glCoverStrokePathNV'));
  glCoverageMaskNV:=TglCoverageMaskNV(GLGetProcAddr('glCoverageMaskNV'));
  if not Assigned(glCoverageMaskNV) then 
    glCoverageMaskNV:=TglCoverageMaskNV(GetProcAddress(Lib, 'glCoverageMaskNV'));
  glCoverageModulationNV:=TglCoverageModulationNV(GLGetProcAddr('glCoverageModulationNV'));
  if not Assigned(glCoverageModulationNV) then
    glCoverageModulationNV:=TglCoverageModulationNV(GetProcAddress(Lib, 'glCoverageModulationNV'));
  glCoverageModulationTableNV:=TglCoverageModulationTableNV(GLGetProcAddr('glCoverageModulationTableNV'));
  if not Assigned(glCoverageModulationTableNV) then 
    glCoverageModulationTableNV:=TglCoverageModulationTableNV(GetProcAddress(Lib, 'glCoverageModulationTableNV'));
  glCoverageOperationNV:=TglCoverageOperationNV(GLGetProcAddr('glCoverageOperationNV'));
  if not Assigned(glCoverageOperationNV) then 
    glCoverageOperationNV:=TglCoverageOperationNV(GetProcAddress(Lib, 'glCoverageOperationNV'));
  glCreateBuffers:=TglCreateBuffers(GLGetProcAddr('glCreateBuffers'));
  if not Assigned(glCreateBuffers) then 
    glCreateBuffers:=TglCreateBuffers(GetProcAddress(Lib, 'glCreateBuffers'));
  glCreateCommandListsNV:=TglCreateCommandListsNV(GLGetProcAddr('glCreateCommandListsNV'));
  if not Assigned(glCreateCommandListsNV) then 
    glCreateCommandListsNV:=TglCreateCommandListsNV(GetProcAddress(Lib, 'glCreateCommandListsNV'));
  glCreateFramebuffers:=TglCreateFramebuffers(GLGetProcAddr('glCreateFramebuffers'));
  if not Assigned(glCreateFramebuffers) then 
    glCreateFramebuffers:=TglCreateFramebuffers(GetProcAddress(Lib, 'glCreateFramebuffers'));
  glCreateMemoryObjectsEXT:=TglCreateMemoryObjectsEXT(GLGetProcAddr('glCreateMemoryObjectsEXT'));
  if not Assigned(glCreateMemoryObjectsEXT) then 
    glCreateMemoryObjectsEXT:=TglCreateMemoryObjectsEXT(GetProcAddress(Lib, 'glCreateMemoryObjectsEXT'));
  glCreatePerfQueryINTEL:=TglCreatePerfQueryINTEL(GLGetProcAddr('glCreatePerfQueryINTEL'));
  if not Assigned(glCreatePerfQueryINTEL) then 
    glCreatePerfQueryINTEL:=TglCreatePerfQueryINTEL(GetProcAddress(Lib, 'glCreatePerfQueryINTEL'));
  glCreateProgram:=TglCreateProgram(GLGetProcAddr('glCreateProgram'));
  if not Assigned(glCreateProgram) then 
    glCreateProgram:=TglCreateProgram(GetProcAddress(Lib, 'glCreateProgram'));
  glCreateProgramObjectARB:=TglCreateProgramObjectARB(GLGetProcAddr('glCreateProgramObjectARB'));
  if not Assigned(glCreateProgramObjectARB) then
    glCreateProgramObjectARB:=TglCreateProgramObjectARB(GetProcAddress(Lib, 'glCreateProgramObjectARB'));
  glCreateProgramPipelines:=TglCreateProgramPipelines(GLGetProcAddr('glCreateProgramPipelines'));
  if not Assigned(glCreateProgramPipelines) then 
    glCreateProgramPipelines:=TglCreateProgramPipelines(GetProcAddress(Lib, 'glCreateProgramPipelines'));
  glCreateQueries:=TglCreateQueries(GLGetProcAddr('glCreateQueries'));
  if not Assigned(glCreateQueries) then 
    glCreateQueries:=TglCreateQueries(GetProcAddress(Lib, 'glCreateQueries'));
  glCreateRenderbuffers:=TglCreateRenderbuffers(GLGetProcAddr('glCreateRenderbuffers'));
  if not Assigned(glCreateRenderbuffers) then
    glCreateRenderbuffers:=TglCreateRenderbuffers(GetProcAddress(Lib, 'glCreateRenderbuffers'));
  glCreateSamplers:=TglCreateSamplers(GLGetProcAddr('glCreateSamplers'));
  if not Assigned(glCreateSamplers) then 
    glCreateSamplers:=TglCreateSamplers(GetProcAddress(Lib, 'glCreateSamplers'));
  glCreateShader:=TglCreateShader(GLGetProcAddr('glCreateShader'));
  if not Assigned(glCreateShader) then 
    glCreateShader:=TglCreateShader(GetProcAddress(Lib, 'glCreateShader'));
  glCreateShaderObjectARB:=TglCreateShaderObjectARB(GLGetProcAddr('glCreateShaderObjectARB'));
  if not Assigned(glCreateShaderObjectARB) then 
    glCreateShaderObjectARB:=TglCreateShaderObjectARB(GetProcAddress(Lib, 'glCreateShaderObjectARB'));
  glCreateShaderProgramEXT:=TglCreateShaderProgramEXT(GLGetProcAddr('glCreateShaderProgramEXT'));
  if not Assigned(glCreateShaderProgramEXT) then 
    glCreateShaderProgramEXT:=TglCreateShaderProgramEXT(GetProcAddress(Lib, 'glCreateShaderProgramEXT'));
  glCreateShaderProgramv:=TglCreateShaderProgramv(GLGetProcAddr('glCreateShaderProgramv'));
  if not Assigned(glCreateShaderProgramv) then 
    glCreateShaderProgramv:=TglCreateShaderProgramv(GetProcAddress(Lib, 'glCreateShaderProgramv'));
  glCreateShaderProgramvEXT:=TglCreateShaderProgramvEXT(GLGetProcAddr('glCreateShaderProgramvEXT'));
  if not Assigned(glCreateShaderProgramvEXT) then 
    glCreateShaderProgramvEXT:=TglCreateShaderProgramvEXT(GetProcAddress(Lib, 'glCreateShaderProgramvEXT'));
  glCreateStatesNV:=TglCreateStatesNV(GLGetProcAddr('glCreateStatesNV'));
  if not Assigned(glCreateStatesNV) then
    glCreateStatesNV:=TglCreateStatesNV(GetProcAddress(Lib, 'glCreateStatesNV'));
  glCreateSyncFromCLeventARB:=TglCreateSyncFromCLeventARB(GLGetProcAddr('glCreateSyncFromCLeventARB'));
  if not Assigned(glCreateSyncFromCLeventARB) then 
    glCreateSyncFromCLeventARB:=TglCreateSyncFromCLeventARB(GetProcAddress(Lib, 'glCreateSyncFromCLeventARB'));
  glCreateTextures:=TglCreateTextures(GLGetProcAddr('glCreateTextures'));
  if not Assigned(glCreateTextures) then 
    glCreateTextures:=TglCreateTextures(GetProcAddress(Lib, 'glCreateTextures'));
  glCreateTransformFeedbacks:=TglCreateTransformFeedbacks(GLGetProcAddr('glCreateTransformFeedbacks'));
  if not Assigned(glCreateTransformFeedbacks) then 
    glCreateTransformFeedbacks:=TglCreateTransformFeedbacks(GetProcAddress(Lib, 'glCreateTransformFeedbacks'));
  glCreateVertexArrays:=TglCreateVertexArrays(GLGetProcAddr('glCreateVertexArrays'));
  if not Assigned(glCreateVertexArrays) then 
    glCreateVertexArrays:=TglCreateVertexArrays(GetProcAddress(Lib, 'glCreateVertexArrays'));
  glCullFace:=TglCullFace(GLGetProcAddr('glCullFace'));
  if not Assigned(glCullFace) then 
    glCullFace:=TglCullFace(GetProcAddress(Lib, 'glCullFace'));
  glCullParameterdvEXT:=TglCullParameterdvEXT(GLGetProcAddr('glCullParameterdvEXT'));
  if not Assigned(glCullParameterdvEXT) then 
    glCullParameterdvEXT:=TglCullParameterdvEXT(GetProcAddress(Lib, 'glCullParameterdvEXT'));
  glCullParameterfvEXT:=TglCullParameterfvEXT(GLGetProcAddr('glCullParameterfvEXT'));
  if not Assigned(glCullParameterfvEXT) then 
    glCullParameterfvEXT:=TglCullParameterfvEXT(GetProcAddress(Lib, 'glCullParameterfvEXT'));
  glCurrentPaletteMatrixARB:=TglCurrentPaletteMatrixARB(GLGetProcAddr('glCurrentPaletteMatrixARB'));
  if not Assigned(glCurrentPaletteMatrixARB) then 
    glCurrentPaletteMatrixARB:=TglCurrentPaletteMatrixARB(GetProcAddress(Lib, 'glCurrentPaletteMatrixARB'));
  glCurrentPaletteMatrixOES:=TglCurrentPaletteMatrixOES(GLGetProcAddr('glCurrentPaletteMatrixOES'));
  if not Assigned(glCurrentPaletteMatrixOES) then 
    glCurrentPaletteMatrixOES:=TglCurrentPaletteMatrixOES(GetProcAddress(Lib, 'glCurrentPaletteMatrixOES'));
  glDebugMessageCallback:=TglDebugMessageCallback(GLGetProcAddr('glDebugMessageCallback'));
  if not Assigned(glDebugMessageCallback) then 
    glDebugMessageCallback:=TglDebugMessageCallback(GetProcAddress(Lib, 'glDebugMessageCallback'));
  glDebugMessageCallbackAMD:=TglDebugMessageCallbackAMD(GLGetProcAddr('glDebugMessageCallbackAMD'));
  if not Assigned(glDebugMessageCallbackAMD) then 
    glDebugMessageCallbackAMD:=TglDebugMessageCallbackAMD(GetProcAddress(Lib, 'glDebugMessageCallbackAMD'));
  glDebugMessageCallbackARB:=TglDebugMessageCallbackARB(GLGetProcAddr('glDebugMessageCallbackARB'));
  if not Assigned(glDebugMessageCallbackARB) then 
    glDebugMessageCallbackARB:=TglDebugMessageCallbackARB(GetProcAddress(Lib, 'glDebugMessageCallbackARB'));
  glDebugMessageCallbackKHR:=TglDebugMessageCallbackKHR(GLGetProcAddr('glDebugMessageCallbackKHR'));
  if not Assigned(glDebugMessageCallbackKHR) then 
    glDebugMessageCallbackKHR:=TglDebugMessageCallbackKHR(GetProcAddress(Lib, 'glDebugMessageCallbackKHR'));
  glDebugMessageControl:=TglDebugMessageControl(GLGetProcAddr('glDebugMessageControl'));
  if not Assigned(glDebugMessageControl) then 
    glDebugMessageControl:=TglDebugMessageControl(GetProcAddress(Lib, 'glDebugMessageControl'));
  glDebugMessageControlARB:=TglDebugMessageControlARB(GLGetProcAddr('glDebugMessageControlARB'));
  if not Assigned(glDebugMessageControlARB) then 
    glDebugMessageControlARB:=TglDebugMessageControlARB(GetProcAddress(Lib, 'glDebugMessageControlARB'));
  glDebugMessageControlKHR:=TglDebugMessageControlKHR(GLGetProcAddr('glDebugMessageControlKHR'));
  if not Assigned(glDebugMessageControlKHR) then
    glDebugMessageControlKHR:=TglDebugMessageControlKHR(GetProcAddress(Lib, 'glDebugMessageControlKHR'));
  glDebugMessageEnableAMD:=TglDebugMessageEnableAMD(GLGetProcAddr('glDebugMessageEnableAMD'));
  if not Assigned(glDebugMessageEnableAMD) then 
    glDebugMessageEnableAMD:=TglDebugMessageEnableAMD(GetProcAddress(Lib, 'glDebugMessageEnableAMD'));
  glDebugMessageInsert:=TglDebugMessageInsert(GLGetProcAddr('glDebugMessageInsert'));
  if not Assigned(glDebugMessageInsert) then 
    glDebugMessageInsert:=TglDebugMessageInsert(GetProcAddress(Lib, 'glDebugMessageInsert'));
  glDebugMessageInsertAMD:=TglDebugMessageInsertAMD(GLGetProcAddr('glDebugMessageInsertAMD'));
  if not Assigned(glDebugMessageInsertAMD) then
    glDebugMessageInsertAMD:=TglDebugMessageInsertAMD(GetProcAddress(Lib, 'glDebugMessageInsertAMD'));
  glDebugMessageInsertARB:=TglDebugMessageInsertARB(GLGetProcAddr('glDebugMessageInsertARB'));
  if not Assigned(glDebugMessageInsertARB) then 
    glDebugMessageInsertARB:=TglDebugMessageInsertARB(GetProcAddress(Lib, 'glDebugMessageInsertARB'));
  glDebugMessageInsertKHR:=TglDebugMessageInsertKHR(GLGetProcAddr('glDebugMessageInsertKHR'));
  if not Assigned(glDebugMessageInsertKHR) then 
    glDebugMessageInsertKHR:=TglDebugMessageInsertKHR(GetProcAddress(Lib, 'glDebugMessageInsertKHR'));
  glDeformSGIX:=TglDeformSGIX(GLGetProcAddr('glDeformSGIX'));
  if not Assigned(glDeformSGIX) then 
    glDeformSGIX:=TglDeformSGIX(GetProcAddress(Lib, 'glDeformSGIX'));
  glDeformationMap3dSGIX:=TglDeformationMap3dSGIX(GLGetProcAddr('glDeformationMap3dSGIX'));
  if not Assigned(glDeformationMap3dSGIX) then 
    glDeformationMap3dSGIX:=TglDeformationMap3dSGIX(GetProcAddress(Lib, 'glDeformationMap3dSGIX'));
  glDeformationMap3fSGIX:=TglDeformationMap3fSGIX(GLGetProcAddr('glDeformationMap3fSGIX'));
  if not Assigned(glDeformationMap3fSGIX) then 
    glDeformationMap3fSGIX:=TglDeformationMap3fSGIX(GetProcAddress(Lib, 'glDeformationMap3fSGIX'));
  glDeleteAsyncMarkersSGIX:=TglDeleteAsyncMarkersSGIX(GLGetProcAddr('glDeleteAsyncMarkersSGIX'));
  if not Assigned(glDeleteAsyncMarkersSGIX) then 
    glDeleteAsyncMarkersSGIX:=TglDeleteAsyncMarkersSGIX(GetProcAddress(Lib, 'glDeleteAsyncMarkersSGIX'));
  glDeleteBuffers:=TglDeleteBuffers(GLGetProcAddr('glDeleteBuffers'));
  if not Assigned(glDeleteBuffers) then 
    glDeleteBuffers:=TglDeleteBuffers(GetProcAddress(Lib, 'glDeleteBuffers'));
  glDeleteBuffersARB:=TglDeleteBuffersARB(GLGetProcAddr('glDeleteBuffersARB'));
  if not Assigned(glDeleteBuffersARB) then 
    glDeleteBuffersARB:=TglDeleteBuffersARB(GetProcAddress(Lib, 'glDeleteBuffersARB'));
  glDeleteCommandListsNV:=TglDeleteCommandListsNV(GLGetProcAddr('glDeleteCommandListsNV'));
  if not Assigned(glDeleteCommandListsNV) then 
    glDeleteCommandListsNV:=TglDeleteCommandListsNV(GetProcAddress(Lib, 'glDeleteCommandListsNV'));
  glDeleteFencesAPPLE:=TglDeleteFencesAPPLE(GLGetProcAddr('glDeleteFencesAPPLE'));
  if not Assigned(glDeleteFencesAPPLE) then 
    glDeleteFencesAPPLE:=TglDeleteFencesAPPLE(GetProcAddress(Lib, 'glDeleteFencesAPPLE'));
  glDeleteFencesNV:=TglDeleteFencesNV(GLGetProcAddr('glDeleteFencesNV'));
  if not Assigned(glDeleteFencesNV) then 
    glDeleteFencesNV:=TglDeleteFencesNV(GetProcAddress(Lib, 'glDeleteFencesNV'));
  glDeleteFragmentShaderATI:=TglDeleteFragmentShaderATI(GLGetProcAddr('glDeleteFragmentShaderATI'));
  if not Assigned(glDeleteFragmentShaderATI) then 
    glDeleteFragmentShaderATI:=TglDeleteFragmentShaderATI(GetProcAddress(Lib, 'glDeleteFragmentShaderATI'));
  glDeleteFramebuffers:=TglDeleteFramebuffers(GLGetProcAddr('glDeleteFramebuffers'));
  if not Assigned(glDeleteFramebuffers) then 
    glDeleteFramebuffers:=TglDeleteFramebuffers(GetProcAddress(Lib, 'glDeleteFramebuffers'));
  glDeleteFramebuffersEXT:=TglDeleteFramebuffersEXT(GLGetProcAddr('glDeleteFramebuffersEXT'));
  if not Assigned(glDeleteFramebuffersEXT) then 
    glDeleteFramebuffersEXT:=TglDeleteFramebuffersEXT(GetProcAddress(Lib, 'glDeleteFramebuffersEXT'));
  glDeleteFramebuffersOES:=TglDeleteFramebuffersOES(GLGetProcAddr('glDeleteFramebuffersOES'));
  if not Assigned(glDeleteFramebuffersOES) then 
    glDeleteFramebuffersOES:=TglDeleteFramebuffersOES(GetProcAddress(Lib, 'glDeleteFramebuffersOES'));
  glDeleteLists:=TglDeleteLists(GLGetProcAddr('glDeleteLists'));
  if not Assigned(glDeleteLists) then 
    glDeleteLists:=TglDeleteLists(GetProcAddress(Lib, 'glDeleteLists'));
  glDeleteMemoryObjectsEXT:=TglDeleteMemoryObjectsEXT(GLGetProcAddr('glDeleteMemoryObjectsEXT'));
  if not Assigned(glDeleteMemoryObjectsEXT) then 
    glDeleteMemoryObjectsEXT:=TglDeleteMemoryObjectsEXT(GetProcAddress(Lib, 'glDeleteMemoryObjectsEXT'));
  glDeleteNamedStringARB:=TglDeleteNamedStringARB(GLGetProcAddr('glDeleteNamedStringARB'));
  if not Assigned(glDeleteNamedStringARB) then 
    glDeleteNamedStringARB:=TglDeleteNamedStringARB(GetProcAddress(Lib, 'glDeleteNamedStringARB'));
  glDeleteNamesAMD:=TglDeleteNamesAMD(GLGetProcAddr('glDeleteNamesAMD'));
  if not Assigned(glDeleteNamesAMD) then
    glDeleteNamesAMD:=TglDeleteNamesAMD(GetProcAddress(Lib, 'glDeleteNamesAMD'));
  glDeleteObjectARB:=TglDeleteObjectARB(GLGetProcAddr('glDeleteObjectARB'));
  if not Assigned(glDeleteObjectARB) then 
    glDeleteObjectARB:=TglDeleteObjectARB(GetProcAddress(Lib, 'glDeleteObjectARB'));
  glDeleteOcclusionQueriesNV:=TglDeleteOcclusionQueriesNV(GLGetProcAddr('glDeleteOcclusionQueriesNV'));
  if not Assigned(glDeleteOcclusionQueriesNV) then 
    glDeleteOcclusionQueriesNV:=TglDeleteOcclusionQueriesNV(GetProcAddress(Lib, 'glDeleteOcclusionQueriesNV'));
  glDeletePathsNV:=TglDeletePathsNV(GLGetProcAddr('glDeletePathsNV'));
  if not Assigned(glDeletePathsNV) then 
    glDeletePathsNV:=TglDeletePathsNV(GetProcAddress(Lib, 'glDeletePathsNV'));
  glDeletePerfMonitorsAMD:=TglDeletePerfMonitorsAMD(GLGetProcAddr('glDeletePerfMonitorsAMD'));
  if not Assigned(glDeletePerfMonitorsAMD) then
    glDeletePerfMonitorsAMD:=TglDeletePerfMonitorsAMD(GetProcAddress(Lib, 'glDeletePerfMonitorsAMD'));
  glDeletePerfQueryINTEL:=TglDeletePerfQueryINTEL(GLGetProcAddr('glDeletePerfQueryINTEL'));
  if not Assigned(glDeletePerfQueryINTEL) then 
    glDeletePerfQueryINTEL:=TglDeletePerfQueryINTEL(GetProcAddress(Lib, 'glDeletePerfQueryINTEL'));
  glDeleteProgram:=TglDeleteProgram(GLGetProcAddr('glDeleteProgram'));
  if not Assigned(glDeleteProgram) then 
    glDeleteProgram:=TglDeleteProgram(GetProcAddress(Lib, 'glDeleteProgram'));
  glDeleteProgramPipelines:=TglDeleteProgramPipelines(GLGetProcAddr('glDeleteProgramPipelines'));
  if not Assigned(glDeleteProgramPipelines) then
    glDeleteProgramPipelines:=TglDeleteProgramPipelines(GetProcAddress(Lib, 'glDeleteProgramPipelines'));
  glDeleteProgramPipelinesEXT:=TglDeleteProgramPipelinesEXT(GLGetProcAddr('glDeleteProgramPipelinesEXT'));
  if not Assigned(glDeleteProgramPipelinesEXT) then 
    glDeleteProgramPipelinesEXT:=TglDeleteProgramPipelinesEXT(GetProcAddress(Lib, 'glDeleteProgramPipelinesEXT'));
  glDeleteProgramsARB:=TglDeleteProgramsARB(GLGetProcAddr('glDeleteProgramsARB'));
  if not Assigned(glDeleteProgramsARB) then 
    glDeleteProgramsARB:=TglDeleteProgramsARB(GetProcAddress(Lib, 'glDeleteProgramsARB'));
  glDeleteProgramsNV:=TglDeleteProgramsNV(GLGetProcAddr('glDeleteProgramsNV'));
  if not Assigned(glDeleteProgramsNV) then 
    glDeleteProgramsNV:=TglDeleteProgramsNV(GetProcAddress(Lib, 'glDeleteProgramsNV'));
  glDeleteQueries:=TglDeleteQueries(GLGetProcAddr('glDeleteQueries'));
  if not Assigned(glDeleteQueries) then 
    glDeleteQueries:=TglDeleteQueries(GetProcAddress(Lib, 'glDeleteQueries'));
  glDeleteQueriesARB:=TglDeleteQueriesARB(GLGetProcAddr('glDeleteQueriesARB'));
  if not Assigned(glDeleteQueriesARB) then 
    glDeleteQueriesARB:=TglDeleteQueriesARB(GetProcAddress(Lib, 'glDeleteQueriesARB'));
  glDeleteQueriesEXT:=TglDeleteQueriesEXT(GLGetProcAddr('glDeleteQueriesEXT'));
  if not Assigned(glDeleteQueriesEXT) then 
    glDeleteQueriesEXT:=TglDeleteQueriesEXT(GetProcAddress(Lib, 'glDeleteQueriesEXT'));
  glDeleteRenderbuffers:=TglDeleteRenderbuffers(GLGetProcAddr('glDeleteRenderbuffers'));
  if not Assigned(glDeleteRenderbuffers) then 
    glDeleteRenderbuffers:=TglDeleteRenderbuffers(GetProcAddress(Lib, 'glDeleteRenderbuffers'));
  glDeleteRenderbuffersEXT:=TglDeleteRenderbuffersEXT(GLGetProcAddr('glDeleteRenderbuffersEXT'));
  if not Assigned(glDeleteRenderbuffersEXT) then 
    glDeleteRenderbuffersEXT:=TglDeleteRenderbuffersEXT(GetProcAddress(Lib, 'glDeleteRenderbuffersEXT'));
  glDeleteRenderbuffersOES:=TglDeleteRenderbuffersOES(GLGetProcAddr('glDeleteRenderbuffersOES'));
  if not Assigned(glDeleteRenderbuffersOES) then
    glDeleteRenderbuffersOES:=TglDeleteRenderbuffersOES(GetProcAddress(Lib, 'glDeleteRenderbuffersOES'));
  glDeleteSamplers:=TglDeleteSamplers(GLGetProcAddr('glDeleteSamplers'));
  if not Assigned(glDeleteSamplers) then
    glDeleteSamplers:=TglDeleteSamplers(GetProcAddress(Lib, 'glDeleteSamplers'));
  glDeleteSemaphoresEXT:=TglDeleteSemaphoresEXT(GLGetProcAddr('glDeleteSemaphoresEXT'));
  if not Assigned(glDeleteSemaphoresEXT) then
    glDeleteSemaphoresEXT:=TglDeleteSemaphoresEXT(GetProcAddress(Lib, 'glDeleteSemaphoresEXT'));
  glDeleteShader:=TglDeleteShader(GLGetProcAddr('glDeleteShader'));
  if not Assigned(glDeleteShader) then
    glDeleteShader:=TglDeleteShader(GetProcAddress(Lib, 'glDeleteShader'));
  glDeleteStatesNV:=TglDeleteStatesNV(GLGetProcAddr('glDeleteStatesNV'));
  if not Assigned(glDeleteStatesNV) then 
    glDeleteStatesNV:=TglDeleteStatesNV(GetProcAddress(Lib, 'glDeleteStatesNV'));
  glDeleteSync:=TglDeleteSync(GLGetProcAddr('glDeleteSync'));
  if not Assigned(glDeleteSync) then 
    glDeleteSync:=TglDeleteSync(GetProcAddress(Lib, 'glDeleteSync'));
  glDeleteSyncAPPLE:=TglDeleteSyncAPPLE(GLGetProcAddr('glDeleteSyncAPPLE'));
  if not Assigned(glDeleteSyncAPPLE) then 
    glDeleteSyncAPPLE:=TglDeleteSyncAPPLE(GetProcAddress(Lib, 'glDeleteSyncAPPLE'));
  glDeleteTextures:=TglDeleteTextures(GLGetProcAddr('glDeleteTextures'));
  if not Assigned(glDeleteTextures) then 
    glDeleteTextures:=TglDeleteTextures(GetProcAddress(Lib, 'glDeleteTextures'));
  glDeleteTexturesEXT:=TglDeleteTexturesEXT(GLGetProcAddr('glDeleteTexturesEXT'));
  if not Assigned(glDeleteTexturesEXT) then 
    glDeleteTexturesEXT:=TglDeleteTexturesEXT(GetProcAddress(Lib, 'glDeleteTexturesEXT'));
  glDeleteTransformFeedbacks:=TglDeleteTransformFeedbacks(GLGetProcAddr('glDeleteTransformFeedbacks'));
  if not Assigned(glDeleteTransformFeedbacks) then 
    glDeleteTransformFeedbacks:=TglDeleteTransformFeedbacks(GetProcAddress(Lib, 'glDeleteTransformFeedbacks'));
  glDeleteTransformFeedbacksNV:=TglDeleteTransformFeedbacksNV(GLGetProcAddr('glDeleteTransformFeedbacksNV'));
  if not Assigned(glDeleteTransformFeedbacksNV) then 
    glDeleteTransformFeedbacksNV:=TglDeleteTransformFeedbacksNV(GetProcAddress(Lib, 'glDeleteTransformFeedbacksNV'));
  glDeleteVertexArrays:=TglDeleteVertexArrays(GLGetProcAddr('glDeleteVertexArrays'));
  if not Assigned(glDeleteVertexArrays) then 
    glDeleteVertexArrays:=TglDeleteVertexArrays(GetProcAddress(Lib, 'glDeleteVertexArrays'));
  glDeleteVertexArraysAPPLE:=TglDeleteVertexArraysAPPLE(GLGetProcAddr('glDeleteVertexArraysAPPLE'));
  if not Assigned(glDeleteVertexArraysAPPLE) then 
    glDeleteVertexArraysAPPLE:=TglDeleteVertexArraysAPPLE(GetProcAddress(Lib, 'glDeleteVertexArraysAPPLE'));
  glDeleteVertexArraysOES:=TglDeleteVertexArraysOES(GLGetProcAddr('glDeleteVertexArraysOES'));
  if not Assigned(glDeleteVertexArraysOES) then 
    glDeleteVertexArraysOES:=TglDeleteVertexArraysOES(GetProcAddress(Lib, 'glDeleteVertexArraysOES'));
  glDeleteVertexShaderEXT:=TglDeleteVertexShaderEXT(GLGetProcAddr('glDeleteVertexShaderEXT'));
  if not Assigned(glDeleteVertexShaderEXT) then
    glDeleteVertexShaderEXT:=TglDeleteVertexShaderEXT(GetProcAddress(Lib, 'glDeleteVertexShaderEXT'));
  glDepthBoundsEXT:=TglDepthBoundsEXT(GLGetProcAddr('glDepthBoundsEXT'));
  if not Assigned(glDepthBoundsEXT) then 
    glDepthBoundsEXT:=TglDepthBoundsEXT(GetProcAddress(Lib, 'glDepthBoundsEXT'));
  glDepthBoundsdNV:=TglDepthBoundsdNV(GLGetProcAddr('glDepthBoundsdNV'));
  if not Assigned(glDepthBoundsdNV) then 
    glDepthBoundsdNV:=TglDepthBoundsdNV(GetProcAddress(Lib, 'glDepthBoundsdNV'));
  glDepthFunc:=TglDepthFunc(GLGetProcAddr('glDepthFunc'));
  if not Assigned(glDepthFunc) then 
    glDepthFunc:=TglDepthFunc(GetProcAddress(Lib, 'glDepthFunc'));
  glDepthMask:=TglDepthMask(GLGetProcAddr('glDepthMask'));
  if not Assigned(glDepthMask) then 
    glDepthMask:=TglDepthMask(GetProcAddress(Lib, 'glDepthMask'));
  glDepthRange:=TglDepthRange(GLGetProcAddr('glDepthRange'));
  if not Assigned(glDepthRange) then 
    glDepthRange:=TglDepthRange(GetProcAddress(Lib, 'glDepthRange'));
  glDepthRangeArrayfvNV:=TglDepthRangeArrayfvNV(GLGetProcAddr('glDepthRangeArrayfvNV'));
  if not Assigned(glDepthRangeArrayfvNV) then 
    glDepthRangeArrayfvNV:=TglDepthRangeArrayfvNV(GetProcAddress(Lib, 'glDepthRangeArrayfvNV'));
  glDepthRangeArrayfvOES:=TglDepthRangeArrayfvOES(GLGetProcAddr('glDepthRangeArrayfvOES'));
  if not Assigned(glDepthRangeArrayfvOES) then 
    glDepthRangeArrayfvOES:=TglDepthRangeArrayfvOES(GetProcAddress(Lib, 'glDepthRangeArrayfvOES'));
  glDepthRangeArrayv:=TglDepthRangeArrayv(GLGetProcAddr('glDepthRangeArrayv'));
  if not Assigned(glDepthRangeArrayv) then
    glDepthRangeArrayv:=TglDepthRangeArrayv(GetProcAddress(Lib, 'glDepthRangeArrayv'));
  glDepthRangeIndexed:=TglDepthRangeIndexed(GLGetProcAddr('glDepthRangeIndexed'));
  if not Assigned(glDepthRangeIndexed) then 
    glDepthRangeIndexed:=TglDepthRangeIndexed(GetProcAddress(Lib, 'glDepthRangeIndexed'));
  glDepthRangeIndexedfNV:=TglDepthRangeIndexedfNV(GLGetProcAddr('glDepthRangeIndexedfNV'));
  if not Assigned(glDepthRangeIndexedfNV) then 
    glDepthRangeIndexedfNV:=TglDepthRangeIndexedfNV(GetProcAddress(Lib, 'glDepthRangeIndexedfNV'));
  glDepthRangeIndexedfOES:=TglDepthRangeIndexedfOES(GLGetProcAddr('glDepthRangeIndexedfOES'));
  if not Assigned(glDepthRangeIndexedfOES) then 
    glDepthRangeIndexedfOES:=TglDepthRangeIndexedfOES(GetProcAddress(Lib, 'glDepthRangeIndexedfOES'));
  glDepthRangedNV:=TglDepthRangedNV(GLGetProcAddr('glDepthRangedNV'));
  if not Assigned(glDepthRangedNV) then 
    glDepthRangedNV:=TglDepthRangedNV(GetProcAddress(Lib, 'glDepthRangedNV'));
  glDepthRangef:=TglDepthRangef(GLGetProcAddr('glDepthRangef'));
  if not Assigned(glDepthRangef) then 
    glDepthRangef:=TglDepthRangef(GetProcAddress(Lib, 'glDepthRangef'));
  glDepthRangefOES:=TglDepthRangefOES(GLGetProcAddr('glDepthRangefOES'));
  if not Assigned(glDepthRangefOES) then 
    glDepthRangefOES:=TglDepthRangefOES(GetProcAddress(Lib, 'glDepthRangefOES'));
  glDepthRangex:=TglDepthRangex(GLGetProcAddr('glDepthRangex'));
  if not Assigned(glDepthRangex) then 
    glDepthRangex:=TglDepthRangex(GetProcAddress(Lib, 'glDepthRangex'));
  glDepthRangexOES:=TglDepthRangexOES(GLGetProcAddr('glDepthRangexOES'));
  if not Assigned(glDepthRangexOES) then 
    glDepthRangexOES:=TglDepthRangexOES(GetProcAddress(Lib, 'glDepthRangexOES'));
  glDetachObjectARB:=TglDetachObjectARB(GLGetProcAddr('glDetachObjectARB'));
  if not Assigned(glDetachObjectARB) then 
    glDetachObjectARB:=TglDetachObjectARB(GetProcAddress(Lib, 'glDetachObjectARB'));
  glDetachShader:=TglDetachShader(GLGetProcAddr('glDetachShader'));
  if not Assigned(glDetachShader) then 
    glDetachShader:=TglDetachShader(GetProcAddress(Lib, 'glDetachShader'));
  glDetailTexFuncSGIS:=TglDetailTexFuncSGIS(GLGetProcAddr('glDetailTexFuncSGIS'));
  if not Assigned(glDetailTexFuncSGIS) then 
    glDetailTexFuncSGIS:=TglDetailTexFuncSGIS(GetProcAddress(Lib, 'glDetailTexFuncSGIS'));
  glDisable:=TglDisable(GLGetProcAddr('glDisable'));
  if not Assigned(glDisable) then 
    glDisable:=TglDisable(GetProcAddress(Lib, 'glDisable'));
  glDisableClientState:=TglDisableClientState(GLGetProcAddr('glDisableClientState'));
  if not Assigned(glDisableClientState) then 
    glDisableClientState:=TglDisableClientState(GetProcAddress(Lib, 'glDisableClientState'));
  glDisableClientStateIndexedEXT:=TglDisableClientStateIndexedEXT(GLGetProcAddr('glDisableClientStateIndexedEXT'));
  if not Assigned(glDisableClientStateIndexedEXT) then 
    glDisableClientStateIndexedEXT:=TglDisableClientStateIndexedEXT(GetProcAddress(Lib, 'glDisableClientStateIndexedEXT'));
  glDisableClientStateiEXT:=TglDisableClientStateiEXT(GLGetProcAddr('glDisableClientStateiEXT'));
  if not Assigned(glDisableClientStateiEXT) then 
    glDisableClientStateiEXT:=TglDisableClientStateiEXT(GetProcAddress(Lib, 'glDisableClientStateiEXT'));
  glDisableDriverControlQCOM:=TglDisableDriverControlQCOM(GLGetProcAddr('glDisableDriverControlQCOM'));
  if not Assigned(glDisableDriverControlQCOM) then 
    glDisableDriverControlQCOM:=TglDisableDriverControlQCOM(GetProcAddress(Lib, 'glDisableDriverControlQCOM'));
  glDisableIndexedEXT:=TglDisableIndexedEXT(GLGetProcAddr('glDisableIndexedEXT'));
  if not Assigned(glDisableIndexedEXT) then 
    glDisableIndexedEXT:=TglDisableIndexedEXT(GetProcAddress(Lib, 'glDisableIndexedEXT'));
  glDisableVariantClientStateEXT:=TglDisableVariantClientStateEXT(GLGetProcAddr('glDisableVariantClientStateEXT'));
  if not Assigned(glDisableVariantClientStateEXT) then
    glDisableVariantClientStateEXT:=TglDisableVariantClientStateEXT(GetProcAddress(Lib, 'glDisableVariantClientStateEXT'));
  glDisableVertexArrayAttrib:=TglDisableVertexArrayAttrib(GLGetProcAddr('glDisableVertexArrayAttrib'));
  if not Assigned(glDisableVertexArrayAttrib) then
    glDisableVertexArrayAttrib:=TglDisableVertexArrayAttrib(GetProcAddress(Lib, 'glDisableVertexArrayAttrib'));
  glDisableVertexArrayAttribEXT:=TglDisableVertexArrayAttribEXT(GLGetProcAddr('glDisableVertexArrayAttribEXT'));
  if not Assigned(glDisableVertexArrayAttribEXT) then 
    glDisableVertexArrayAttribEXT:=TglDisableVertexArrayAttribEXT(GetProcAddress(Lib, 'glDisableVertexArrayAttribEXT'));
  glDisableVertexArrayEXT:=TglDisableVertexArrayEXT(GLGetProcAddr('glDisableVertexArrayEXT'));
  if not Assigned(glDisableVertexArrayEXT) then 
    glDisableVertexArrayEXT:=TglDisableVertexArrayEXT(GetProcAddress(Lib, 'glDisableVertexArrayEXT'));
  glDisableVertexAttribAPPLE:=TglDisableVertexAttribAPPLE(GLGetProcAddr('glDisableVertexAttribAPPLE'));
  if not Assigned(glDisableVertexAttribAPPLE) then 
    glDisableVertexAttribAPPLE:=TglDisableVertexAttribAPPLE(GetProcAddress(Lib, 'glDisableVertexAttribAPPLE'));
  glDisableVertexAttribArray:=TglDisableVertexAttribArray(GLGetProcAddr('glDisableVertexAttribArray'));
  if not Assigned(glDisableVertexAttribArray) then 
    glDisableVertexAttribArray:=TglDisableVertexAttribArray(GetProcAddress(Lib, 'glDisableVertexAttribArray'));
  glDisableVertexAttribArrayARB:=TglDisableVertexAttribArrayARB(GLGetProcAddr('glDisableVertexAttribArrayARB'));
  if not Assigned(glDisableVertexAttribArrayARB) then 
    glDisableVertexAttribArrayARB:=TglDisableVertexAttribArrayARB(GetProcAddress(Lib, 'glDisableVertexAttribArrayARB'));
  glDisablei:=TglDisablei(GLGetProcAddr('glDisablei'));
  if not Assigned(glDisablei) then 
    glDisablei:=TglDisablei(GetProcAddress(Lib, 'glDisablei'));
  glDisableiEXT:=TglDisableiEXT(GLGetProcAddr('glDisableiEXT'));
  if not Assigned(glDisableiEXT) then 
    glDisableiEXT:=TglDisableiEXT(GetProcAddress(Lib, 'glDisableiEXT'));
  glDisableiNV:=TglDisableiNV(GLGetProcAddr('glDisableiNV'));
  if not Assigned(glDisableiNV) then 
    glDisableiNV:=TglDisableiNV(GetProcAddress(Lib, 'glDisableiNV'));
  glDisableiOES:=TglDisableiOES(GLGetProcAddr('glDisableiOES'));
  if not Assigned(glDisableiOES) then 
    glDisableiOES:=TglDisableiOES(GetProcAddress(Lib, 'glDisableiOES'));
  glDiscardFramebufferEXT:=TglDiscardFramebufferEXT(GLGetProcAddr('glDiscardFramebufferEXT'));
  if not Assigned(glDiscardFramebufferEXT) then 
    glDiscardFramebufferEXT:=TglDiscardFramebufferEXT(GetProcAddress(Lib, 'glDiscardFramebufferEXT'));
  glDispatchCompute:=TglDispatchCompute(GLGetProcAddr('glDispatchCompute'));
  if not Assigned(glDispatchCompute) then 
    glDispatchCompute:=TglDispatchCompute(GetProcAddress(Lib, 'glDispatchCompute'));
  glDispatchComputeGroupSizeARB:=TglDispatchComputeGroupSizeARB(GLGetProcAddr('glDispatchComputeGroupSizeARB'));
  if not Assigned(glDispatchComputeGroupSizeARB) then 
    glDispatchComputeGroupSizeARB:=TglDispatchComputeGroupSizeARB(GetProcAddress(Lib, 'glDispatchComputeGroupSizeARB'));
  glDispatchComputeIndirect:=TglDispatchComputeIndirect(GLGetProcAddr('glDispatchComputeIndirect'));
  if not Assigned(glDispatchComputeIndirect) then 
    glDispatchComputeIndirect:=TglDispatchComputeIndirect(GetProcAddress(Lib, 'glDispatchComputeIndirect'));
  glDrawArrays:=TglDrawArrays(GLGetProcAddr('glDrawArrays'));
  if not Assigned(glDrawArrays) then 
    glDrawArrays:=TglDrawArrays(GetProcAddress(Lib, 'glDrawArrays'));
  glDrawArraysEXT:=TglDrawArraysEXT(GLGetProcAddr('glDrawArraysEXT'));
  if not Assigned(glDrawArraysEXT) then 
    glDrawArraysEXT:=TglDrawArraysEXT(GetProcAddress(Lib, 'glDrawArraysEXT'));
  glDrawArraysIndirect:=TglDrawArraysIndirect(GLGetProcAddr('glDrawArraysIndirect'));
  if not Assigned(glDrawArraysIndirect) then 
    glDrawArraysIndirect:=TglDrawArraysIndirect(GetProcAddress(Lib, 'glDrawArraysIndirect'));
  glDrawArraysInstanced:=TglDrawArraysInstanced(GLGetProcAddr('glDrawArraysInstanced'));
  if not Assigned(glDrawArraysInstanced) then 
    glDrawArraysInstanced:=TglDrawArraysInstanced(GetProcAddress(Lib, 'glDrawArraysInstanced'));
  glDrawArraysInstancedANGLE:=TglDrawArraysInstancedANGLE(GLGetProcAddr('glDrawArraysInstancedANGLE'));
  if not Assigned(glDrawArraysInstancedANGLE) then 
    glDrawArraysInstancedANGLE:=TglDrawArraysInstancedANGLE(GetProcAddress(Lib, 'glDrawArraysInstancedANGLE'));
  glDrawArraysInstancedARB:=TglDrawArraysInstancedARB(GLGetProcAddr('glDrawArraysInstancedARB'));
  if not Assigned(glDrawArraysInstancedARB) then
    glDrawArraysInstancedARB:=TglDrawArraysInstancedARB(GetProcAddress(Lib, 'glDrawArraysInstancedARB'));
  glDrawArraysInstancedBaseInstance:=TglDrawArraysInstancedBaseInstance(GLGetProcAddr('glDrawArraysInstancedBaseInstance'));
  if not Assigned(glDrawArraysInstancedBaseInstance) then 
    glDrawArraysInstancedBaseInstance:=TglDrawArraysInstancedBaseInstance(GetProcAddress(Lib, 'glDrawArraysInstancedBaseInstance'));
  glDrawArraysInstancedBaseInstanceEXT:=TglDrawArraysInstancedBaseInstanceEXT(GLGetProcAddr('glDrawArraysInstancedBaseInstanceEXT'));
  if not Assigned(glDrawArraysInstancedBaseInstanceEXT) then 
    glDrawArraysInstancedBaseInstanceEXT:=TglDrawArraysInstancedBaseInstanceEXT(GetProcAddress(Lib, 'glDrawArraysInstancedBaseInstanceEXT'));
  glDrawArraysInstancedEXT:=TglDrawArraysInstancedEXT(GLGetProcAddr('glDrawArraysInstancedEXT'));
  if not Assigned(glDrawArraysInstancedEXT) then 
    glDrawArraysInstancedEXT:=TglDrawArraysInstancedEXT(GetProcAddress(Lib, 'glDrawArraysInstancedEXT'));
  glDrawArraysInstancedNV:=TglDrawArraysInstancedNV(GLGetProcAddr('glDrawArraysInstancedNV'));
  if not Assigned(glDrawArraysInstancedNV) then 
    glDrawArraysInstancedNV:=TglDrawArraysInstancedNV(GetProcAddress(Lib, 'glDrawArraysInstancedNV'));
  glDrawBuffer:=TglDrawBuffer(GLGetProcAddr('glDrawBuffer'));
  if not Assigned(glDrawBuffer) then 
    glDrawBuffer:=TglDrawBuffer(GetProcAddress(Lib, 'glDrawBuffer'));
  glDrawBuffers:=TglDrawBuffers(GLGetProcAddr('glDrawBuffers'));
  if not Assigned(glDrawBuffers) then
    glDrawBuffers:=TglDrawBuffers(GetProcAddress(Lib, 'glDrawBuffers'));
  glDrawBuffersARB:=TglDrawBuffersARB(GLGetProcAddr('glDrawBuffersARB'));
  if not Assigned(glDrawBuffersARB) then 
    glDrawBuffersARB:=TglDrawBuffersARB(GetProcAddress(Lib, 'glDrawBuffersARB'));
  glDrawBuffersATI:=TglDrawBuffersATI(GLGetProcAddr('glDrawBuffersATI'));
  if not Assigned(glDrawBuffersATI) then 
    glDrawBuffersATI:=TglDrawBuffersATI(GetProcAddress(Lib, 'glDrawBuffersATI'));
  glDrawBuffersEXT:=TglDrawBuffersEXT(GLGetProcAddr('glDrawBuffersEXT'));
  if not Assigned(glDrawBuffersEXT) then 
    glDrawBuffersEXT:=TglDrawBuffersEXT(GetProcAddress(Lib, 'glDrawBuffersEXT'));
  glDrawBuffersIndexedEXT:=TglDrawBuffersIndexedEXT(GLGetProcAddr('glDrawBuffersIndexedEXT'));
  if not Assigned(glDrawBuffersIndexedEXT) then 
    glDrawBuffersIndexedEXT:=TglDrawBuffersIndexedEXT(GetProcAddress(Lib, 'glDrawBuffersIndexedEXT'));
  glDrawBuffersNV:=TglDrawBuffersNV(GLGetProcAddr('glDrawBuffersNV'));
  if not Assigned(glDrawBuffersNV) then 
    glDrawBuffersNV:=TglDrawBuffersNV(GetProcAddress(Lib, 'glDrawBuffersNV'));
  glDrawCommandsAddressNV:=TglDrawCommandsAddressNV(GLGetProcAddr('glDrawCommandsAddressNV'));
  if not Assigned(glDrawCommandsAddressNV) then 
    glDrawCommandsAddressNV:=TglDrawCommandsAddressNV(GetProcAddress(Lib, 'glDrawCommandsAddressNV'));
  glDrawCommandsNV:=TglDrawCommandsNV(GLGetProcAddr('glDrawCommandsNV'));
  if not Assigned(glDrawCommandsNV) then 
    glDrawCommandsNV:=TglDrawCommandsNV(GetProcAddress(Lib, 'glDrawCommandsNV'));
  glDrawCommandsStatesAddressNV:=TglDrawCommandsStatesAddressNV(GLGetProcAddr('glDrawCommandsStatesAddressNV'));
  if not Assigned(glDrawCommandsStatesAddressNV) then 
    glDrawCommandsStatesAddressNV:=TglDrawCommandsStatesAddressNV(GetProcAddress(Lib, 'glDrawCommandsStatesAddressNV'));
  glDrawCommandsStatesNV:=TglDrawCommandsStatesNV(GLGetProcAddr('glDrawCommandsStatesNV'));
  if not Assigned(glDrawCommandsStatesNV) then 
    glDrawCommandsStatesNV:=TglDrawCommandsStatesNV(GetProcAddress(Lib, 'glDrawCommandsStatesNV'));
  glDrawElementArrayAPPLE:=TglDrawElementArrayAPPLE(GLGetProcAddr('glDrawElementArrayAPPLE'));
  if not Assigned(glDrawElementArrayAPPLE) then 
    glDrawElementArrayAPPLE:=TglDrawElementArrayAPPLE(GetProcAddress(Lib, 'glDrawElementArrayAPPLE'));
  glDrawElementArrayATI:=TglDrawElementArrayATI(GLGetProcAddr('glDrawElementArrayATI'));
  if not Assigned(glDrawElementArrayATI) then 
    glDrawElementArrayATI:=TglDrawElementArrayATI(GetProcAddress(Lib, 'glDrawElementArrayATI'));
  glDrawElements:=TglDrawElements(GLGetProcAddr('glDrawElements'));
  if not Assigned(glDrawElements) then 
    glDrawElements:=TglDrawElements(GetProcAddress(Lib, 'glDrawElements'));
  glDrawElementsBaseVertex:=TglDrawElementsBaseVertex(GLGetProcAddr('glDrawElementsBaseVertex'));
  if not Assigned(glDrawElementsBaseVertex) then
    glDrawElementsBaseVertex:=TglDrawElementsBaseVertex(GetProcAddress(Lib, 'glDrawElementsBaseVertex'));
  glDrawElementsBaseVertexEXT:=TglDrawElementsBaseVertexEXT(GLGetProcAddr('glDrawElementsBaseVertexEXT'));
  if not Assigned(glDrawElementsBaseVertexEXT) then 
    glDrawElementsBaseVertexEXT:=TglDrawElementsBaseVertexEXT(GetProcAddress(Lib, 'glDrawElementsBaseVertexEXT'));
  glDrawElementsBaseVertexOES:=TglDrawElementsBaseVertexOES(GLGetProcAddr('glDrawElementsBaseVertexOES'));
  if not Assigned(glDrawElementsBaseVertexOES) then 
    glDrawElementsBaseVertexOES:=TglDrawElementsBaseVertexOES(GetProcAddress(Lib, 'glDrawElementsBaseVertexOES'));
  glDrawElementsIndirect:=TglDrawElementsIndirect(GLGetProcAddr('glDrawElementsIndirect'));
  if not Assigned(glDrawElementsIndirect) then 
    glDrawElementsIndirect:=TglDrawElementsIndirect(GetProcAddress(Lib, 'glDrawElementsIndirect'));
  glDrawElementsInstanced:=TglDrawElementsInstanced(GLGetProcAddr('glDrawElementsInstanced'));
  if not Assigned(glDrawElementsInstanced) then
    glDrawElementsInstanced:=TglDrawElementsInstanced(GetProcAddress(Lib, 'glDrawElementsInstanced'));
  glDrawElementsInstancedANGLE:=TglDrawElementsInstancedANGLE(GLGetProcAddr('glDrawElementsInstancedANGLE'));
  if not Assigned(glDrawElementsInstancedANGLE) then 
    glDrawElementsInstancedANGLE:=TglDrawElementsInstancedANGLE(GetProcAddress(Lib, 'glDrawElementsInstancedANGLE'));
  glDrawElementsInstancedARB:=TglDrawElementsInstancedARB(GLGetProcAddr('glDrawElementsInstancedARB'));
  if not Assigned(glDrawElementsInstancedARB) then 
    glDrawElementsInstancedARB:=TglDrawElementsInstancedARB(GetProcAddress(Lib, 'glDrawElementsInstancedARB'));
  glDrawElementsInstancedBaseInstance:=TglDrawElementsInstancedBaseInstance(GLGetProcAddr('glDrawElementsInstancedBaseInstance'));
  if not Assigned(glDrawElementsInstancedBaseInstance) then 
    glDrawElementsInstancedBaseInstance:=TglDrawElementsInstancedBaseInstance(GetProcAddress(Lib, 'glDrawElementsInstancedBaseInstance'));
  glDrawElementsInstancedBaseInstanceEXT:=TglDrawElementsInstancedBaseInstanceEXT(GLGetProcAddr('glDrawElementsInstancedBaseInstanceEXT'));
  if not Assigned(glDrawElementsInstancedBaseInstanceEXT) then 
    glDrawElementsInstancedBaseInstanceEXT:=TglDrawElementsInstancedBaseInstanceEXT(GetProcAddress(Lib, 'glDrawElementsInstancedBaseInstanceEXT'));
  glDrawElementsInstancedBaseVertex:=TglDrawElementsInstancedBaseVertex(GLGetProcAddr('glDrawElementsInstancedBaseVertex'));
  if not Assigned(glDrawElementsInstancedBaseVertex) then 
    glDrawElementsInstancedBaseVertex:=TglDrawElementsInstancedBaseVertex(GetProcAddress(Lib, 'glDrawElementsInstancedBaseVertex'));
  glDrawElementsInstancedBaseVertexBaseInstance:=TglDrawElementsInstancedBaseVertexBaseInstance(GLGetProcAddr('glDrawElementsInstancedBaseVertexBaseInstance'));
  if not Assigned(glDrawElementsInstancedBaseVertexBaseInstance) then 
    glDrawElementsInstancedBaseVertexBaseInstance:=TglDrawElementsInstancedBaseVertexBaseInstance(GetProcAddress(Lib, 'glDrawElementsInstancedBaseVertexBaseInstance'));
  glDrawElementsInstancedBaseVertexBaseInstanceEXT:=TglDrawElementsInstancedBaseVertexBaseInstanceEXT(GLGetProcAddr('glDrawElementsInstancedBaseVertexBaseInstanceEXT'));
  if not Assigned(glDrawElementsInstancedBaseVertexBaseInstanceEXT) then 
    glDrawElementsInstancedBaseVertexBaseInstanceEXT:=TglDrawElementsInstancedBaseVertexBaseInstanceEXT(GetProcAddress(Lib, 'glDrawElementsInstancedBaseVertexBaseInstanceEXT'));
  glDrawElementsInstancedBaseVertexEXT:=TglDrawElementsInstancedBaseVertexEXT(GLGetProcAddr('glDrawElementsInstancedBaseVertexEXT'));
  if not Assigned(glDrawElementsInstancedBaseVertexEXT) then 
    glDrawElementsInstancedBaseVertexEXT:=TglDrawElementsInstancedBaseVertexEXT(GetProcAddress(Lib, 'glDrawElementsInstancedBaseVertexEXT'));
  glDrawElementsInstancedBaseVertexOES:=TglDrawElementsInstancedBaseVertexOES(GLGetProcAddr('glDrawElementsInstancedBaseVertexOES'));
  if not Assigned(glDrawElementsInstancedBaseVertexOES) then 
    glDrawElementsInstancedBaseVertexOES:=TglDrawElementsInstancedBaseVertexOES(GetProcAddress(Lib, 'glDrawElementsInstancedBaseVertexOES'));
  glDrawElementsInstancedEXT:=TglDrawElementsInstancedEXT(GLGetProcAddr('glDrawElementsInstancedEXT'));
  if not Assigned(glDrawElementsInstancedEXT) then 
    glDrawElementsInstancedEXT:=TglDrawElementsInstancedEXT(GetProcAddress(Lib, 'glDrawElementsInstancedEXT'));
  glDrawElementsInstancedNV:=TglDrawElementsInstancedNV(GLGetProcAddr('glDrawElementsInstancedNV'));
  if not Assigned(glDrawElementsInstancedNV) then 
    glDrawElementsInstancedNV:=TglDrawElementsInstancedNV(GetProcAddress(Lib, 'glDrawElementsInstancedNV'));
  glDrawMeshArraysSUN:=TglDrawMeshArraysSUN(GLGetProcAddr('glDrawMeshArraysSUN'));
  if not Assigned(glDrawMeshArraysSUN) then 
    glDrawMeshArraysSUN:=TglDrawMeshArraysSUN(GetProcAddress(Lib, 'glDrawMeshArraysSUN'));
  glDrawPixels:=TglDrawPixels(GLGetProcAddr('glDrawPixels'));
  if not Assigned(glDrawPixels) then 
    glDrawPixels:=TglDrawPixels(GetProcAddress(Lib, 'glDrawPixels'));
  glDrawRangeElementArrayAPPLE:=TglDrawRangeElementArrayAPPLE(GLGetProcAddr('glDrawRangeElementArrayAPPLE'));
  if not Assigned(glDrawRangeElementArrayAPPLE) then 
    glDrawRangeElementArrayAPPLE:=TglDrawRangeElementArrayAPPLE(GetProcAddress(Lib, 'glDrawRangeElementArrayAPPLE'));
  glDrawRangeElementArrayATI:=TglDrawRangeElementArrayATI(GLGetProcAddr('glDrawRangeElementArrayATI'));
  if not Assigned(glDrawRangeElementArrayATI) then
    glDrawRangeElementArrayATI:=TglDrawRangeElementArrayATI(GetProcAddress(Lib, 'glDrawRangeElementArrayATI'));
  glDrawRangeElements:=TglDrawRangeElements(GLGetProcAddr('glDrawRangeElements'));
  if not Assigned(glDrawRangeElements) then 
    glDrawRangeElements:=TglDrawRangeElements(GetProcAddress(Lib, 'glDrawRangeElements'));
  glDrawRangeElementsBaseVertex:=TglDrawRangeElementsBaseVertex(GLGetProcAddr('glDrawRangeElementsBaseVertex'));
  if not Assigned(glDrawRangeElementsBaseVertex) then 
    glDrawRangeElementsBaseVertex:=TglDrawRangeElementsBaseVertex(GetProcAddress(Lib, 'glDrawRangeElementsBaseVertex'));
  glDrawRangeElementsBaseVertexEXT:=TglDrawRangeElementsBaseVertexEXT(GLGetProcAddr('glDrawRangeElementsBaseVertexEXT'));
  if not Assigned(glDrawRangeElementsBaseVertexEXT) then 
    glDrawRangeElementsBaseVertexEXT:=TglDrawRangeElementsBaseVertexEXT(GetProcAddress(Lib, 'glDrawRangeElementsBaseVertexEXT'));
  glDrawRangeElementsBaseVertexOES:=TglDrawRangeElementsBaseVertexOES(GLGetProcAddr('glDrawRangeElementsBaseVertexOES'));
  if not Assigned(glDrawRangeElementsBaseVertexOES) then 
    glDrawRangeElementsBaseVertexOES:=TglDrawRangeElementsBaseVertexOES(GetProcAddress(Lib, 'glDrawRangeElementsBaseVertexOES'));
  glDrawRangeElementsEXT:=TglDrawRangeElementsEXT(GLGetProcAddr('glDrawRangeElementsEXT'));
  if not Assigned(glDrawRangeElementsEXT) then 
    glDrawRangeElementsEXT:=TglDrawRangeElementsEXT(GetProcAddress(Lib, 'glDrawRangeElementsEXT'));
  glDrawTexfOES:=TglDrawTexfOES(GLGetProcAddr('glDrawTexfOES'));
  if not Assigned(glDrawTexfOES) then 
    glDrawTexfOES:=TglDrawTexfOES(GetProcAddress(Lib, 'glDrawTexfOES'));
  glDrawTexfvOES:=TglDrawTexfvOES(GLGetProcAddr('glDrawTexfvOES'));
  if not Assigned(glDrawTexfvOES) then 
    glDrawTexfvOES:=TglDrawTexfvOES(GetProcAddress(Lib, 'glDrawTexfvOES'));
  glDrawTexiOES:=TglDrawTexiOES(GLGetProcAddr('glDrawTexiOES'));
  if not Assigned(glDrawTexiOES) then 
    glDrawTexiOES:=TglDrawTexiOES(GetProcAddress(Lib, 'glDrawTexiOES'));
  glDrawTexivOES:=TglDrawTexivOES(GLGetProcAddr('glDrawTexivOES'));
  if not Assigned(glDrawTexivOES) then 
    glDrawTexivOES:=TglDrawTexivOES(GetProcAddress(Lib, 'glDrawTexivOES'));
  glDrawTexsOES:=TglDrawTexsOES(GLGetProcAddr('glDrawTexsOES'));
  if not Assigned(glDrawTexsOES) then 
    glDrawTexsOES:=TglDrawTexsOES(GetProcAddress(Lib, 'glDrawTexsOES'));
  glDrawTexsvOES:=TglDrawTexsvOES(GLGetProcAddr('glDrawTexsvOES'));
  if not Assigned(glDrawTexsvOES) then
    glDrawTexsvOES:=TglDrawTexsvOES(GetProcAddress(Lib, 'glDrawTexsvOES'));
  glDrawTextureNV:=TglDrawTextureNV(GLGetProcAddr('glDrawTextureNV'));
  if not Assigned(glDrawTextureNV) then 
    glDrawTextureNV:=TglDrawTextureNV(GetProcAddress(Lib, 'glDrawTextureNV'));
  glDrawTexxOES:=TglDrawTexxOES(GLGetProcAddr('glDrawTexxOES'));
  if not Assigned(glDrawTexxOES) then 
    glDrawTexxOES:=TglDrawTexxOES(GetProcAddress(Lib, 'glDrawTexxOES'));
  glDrawTexxvOES:=TglDrawTexxvOES(GLGetProcAddr('glDrawTexxvOES'));
  if not Assigned(glDrawTexxvOES) then 
    glDrawTexxvOES:=TglDrawTexxvOES(GetProcAddress(Lib, 'glDrawTexxvOES'));
  glDrawTransformFeedback:=TglDrawTransformFeedback(GLGetProcAddr('glDrawTransformFeedback'));
  if not Assigned(glDrawTransformFeedback) then 
    glDrawTransformFeedback:=TglDrawTransformFeedback(GetProcAddress(Lib, 'glDrawTransformFeedback'));
  glDrawTransformFeedbackEXT:=TglDrawTransformFeedbackEXT(GLGetProcAddr('glDrawTransformFeedbackEXT'));
  if not Assigned(glDrawTransformFeedbackEXT) then 
    glDrawTransformFeedbackEXT:=TglDrawTransformFeedbackEXT(GetProcAddress(Lib, 'glDrawTransformFeedbackEXT'));
  glDrawTransformFeedbackInstanced:=TglDrawTransformFeedbackInstanced(GLGetProcAddr('glDrawTransformFeedbackInstanced'));
  if not Assigned(glDrawTransformFeedbackInstanced) then 
    glDrawTransformFeedbackInstanced:=TglDrawTransformFeedbackInstanced(GetProcAddress(Lib, 'glDrawTransformFeedbackInstanced'));
  glDrawTransformFeedbackInstancedEXT:=TglDrawTransformFeedbackInstancedEXT(GLGetProcAddr('glDrawTransformFeedbackInstancedEXT'));
  if not Assigned(glDrawTransformFeedbackInstancedEXT) then 
    glDrawTransformFeedbackInstancedEXT:=TglDrawTransformFeedbackInstancedEXT(GetProcAddress(Lib, 'glDrawTransformFeedbackInstancedEXT'));
  glDrawTransformFeedbackNV:=TglDrawTransformFeedbackNV(GLGetProcAddr('glDrawTransformFeedbackNV'));
  if not Assigned(glDrawTransformFeedbackNV) then
    glDrawTransformFeedbackNV:=TglDrawTransformFeedbackNV(GetProcAddress(Lib, 'glDrawTransformFeedbackNV'));
  glDrawTransformFeedbackStream:=TglDrawTransformFeedbackStream(GLGetProcAddr('glDrawTransformFeedbackStream'));
  if not Assigned(glDrawTransformFeedbackStream) then 
    glDrawTransformFeedbackStream:=TglDrawTransformFeedbackStream(GetProcAddress(Lib, 'glDrawTransformFeedbackStream'));
  glDrawTransformFeedbackStreamInstanced:=TglDrawTransformFeedbackStreamInstanced(GLGetProcAddr('glDrawTransformFeedbackStreamInstanced'));
  if not Assigned(glDrawTransformFeedbackStreamInstanced) then 
    glDrawTransformFeedbackStreamInstanced:=TglDrawTransformFeedbackStreamInstanced(GetProcAddress(Lib, 'glDrawTransformFeedbackStreamInstanced'));
  glEGLImageTargetRenderbufferStorageOES:=TglEGLImageTargetRenderbufferStorageOES(GLGetProcAddr('glEGLImageTargetRenderbufferStorageOES'));
  if not Assigned(glEGLImageTargetRenderbufferStorageOES) then 
    glEGLImageTargetRenderbufferStorageOES:=TglEGLImageTargetRenderbufferStorageOES(GetProcAddress(Lib, 'glEGLImageTargetRenderbufferStorageOES'));
  glEGLImageTargetTexture2DOES:=TglEGLImageTargetTexture2DOES(GLGetProcAddr('glEGLImageTargetTexture2DOES'));
  if not Assigned(glEGLImageTargetTexture2DOES) then 
    glEGLImageTargetTexture2DOES:=TglEGLImageTargetTexture2DOES(GetProcAddress(Lib, 'glEGLImageTargetTexture2DOES'));
  glEdgeFlag:=TglEdgeFlag(GLGetProcAddr('glEdgeFlag'));
  if not Assigned(glEdgeFlag) then 
    glEdgeFlag:=TglEdgeFlag(GetProcAddress(Lib, 'glEdgeFlag'));
  glEdgeFlagFormatNV:=TglEdgeFlagFormatNV(GLGetProcAddr('glEdgeFlagFormatNV'));
  if not Assigned(glEdgeFlagFormatNV) then 
    glEdgeFlagFormatNV:=TglEdgeFlagFormatNV(GetProcAddress(Lib, 'glEdgeFlagFormatNV'));
  glEdgeFlagPointer:=TglEdgeFlagPointer(GLGetProcAddr('glEdgeFlagPointer'));
  if not Assigned(glEdgeFlagPointer) then 
    glEdgeFlagPointer:=TglEdgeFlagPointer(GetProcAddress(Lib, 'glEdgeFlagPointer'));
  glEdgeFlagPointerEXT:=TglEdgeFlagPointerEXT(GLGetProcAddr('glEdgeFlagPointerEXT'));
  if not Assigned(glEdgeFlagPointerEXT) then 
    glEdgeFlagPointerEXT:=TglEdgeFlagPointerEXT(GetProcAddress(Lib, 'glEdgeFlagPointerEXT'));
  glEdgeFlagPointerListIBM:=TglEdgeFlagPointerListIBM(GLGetProcAddr('glEdgeFlagPointerListIBM'));
  if not Assigned(glEdgeFlagPointerListIBM) then 
    glEdgeFlagPointerListIBM:=TglEdgeFlagPointerListIBM(GetProcAddress(Lib, 'glEdgeFlagPointerListIBM'));
  glEdgeFlagv:=TglEdgeFlagv(GLGetProcAddr('glEdgeFlagv'));
  if not Assigned(glEdgeFlagv) then 
    glEdgeFlagv:=TglEdgeFlagv(GetProcAddress(Lib, 'glEdgeFlagv'));
  glElementPointerAPPLE:=TglElementPointerAPPLE(GLGetProcAddr('glElementPointerAPPLE'));
  if not Assigned(glElementPointerAPPLE) then 
    glElementPointerAPPLE:=TglElementPointerAPPLE(GetProcAddress(Lib, 'glElementPointerAPPLE'));
  glElementPointerATI:=TglElementPointerATI(GLGetProcAddr('glElementPointerATI'));
  if not Assigned(glElementPointerATI) then 
    glElementPointerATI:=TglElementPointerATI(GetProcAddress(Lib, 'glElementPointerATI'));
  glEnable:=TglEnable(GLGetProcAddr('glEnable'));
  if not Assigned(glEnable) then 
    glEnable:=TglEnable(GetProcAddress(Lib, 'glEnable'));
  glEnableClientState:=TglEnableClientState(GLGetProcAddr('glEnableClientState'));
  if not Assigned(glEnableClientState) then 
    glEnableClientState:=TglEnableClientState(GetProcAddress(Lib, 'glEnableClientState'));
  glEnableClientStateIndexedEXT:=TglEnableClientStateIndexedEXT(GLGetProcAddr('glEnableClientStateIndexedEXT'));
  if not Assigned(glEnableClientStateIndexedEXT) then 
    glEnableClientStateIndexedEXT:=TglEnableClientStateIndexedEXT(GetProcAddress(Lib, 'glEnableClientStateIndexedEXT'));
  glEnableClientStateiEXT:=TglEnableClientStateiEXT(GLGetProcAddr('glEnableClientStateiEXT'));
  if not Assigned(glEnableClientStateiEXT) then 
    glEnableClientStateiEXT:=TglEnableClientStateiEXT(GetProcAddress(Lib, 'glEnableClientStateiEXT'));
  glEnableDriverControlQCOM:=TglEnableDriverControlQCOM(GLGetProcAddr('glEnableDriverControlQCOM'));
  if not Assigned(glEnableDriverControlQCOM) then 
    glEnableDriverControlQCOM:=TglEnableDriverControlQCOM(GetProcAddress(Lib, 'glEnableDriverControlQCOM'));
  glEnableIndexedEXT:=TglEnableIndexedEXT(GLGetProcAddr('glEnableIndexedEXT'));
  if not Assigned(glEnableIndexedEXT) then
    glEnableIndexedEXT:=TglEnableIndexedEXT(GetProcAddress(Lib, 'glEnableIndexedEXT'));
  glEnableVariantClientStateEXT:=TglEnableVariantClientStateEXT(GLGetProcAddr('glEnableVariantClientStateEXT'));
  if not Assigned(glEnableVariantClientStateEXT) then
    glEnableVariantClientStateEXT:=TglEnableVariantClientStateEXT(GetProcAddress(Lib, 'glEnableVariantClientStateEXT'));
  glEnableVertexArrayAttrib:=TglEnableVertexArrayAttrib(GLGetProcAddr('glEnableVertexArrayAttrib'));
  if not Assigned(glEnableVertexArrayAttrib) then 
    glEnableVertexArrayAttrib:=TglEnableVertexArrayAttrib(GetProcAddress(Lib, 'glEnableVertexArrayAttrib'));
  glEnableVertexArrayAttribEXT:=TglEnableVertexArrayAttribEXT(GLGetProcAddr('glEnableVertexArrayAttribEXT'));
  if not Assigned(glEnableVertexArrayAttribEXT) then 
    glEnableVertexArrayAttribEXT:=TglEnableVertexArrayAttribEXT(GetProcAddress(Lib, 'glEnableVertexArrayAttribEXT'));
  glEnableVertexArrayEXT:=TglEnableVertexArrayEXT(GLGetProcAddr('glEnableVertexArrayEXT'));
  if not Assigned(glEnableVertexArrayEXT) then 
    glEnableVertexArrayEXT:=TglEnableVertexArrayEXT(GetProcAddress(Lib, 'glEnableVertexArrayEXT'));
  glEnableVertexAttribAPPLE:=TglEnableVertexAttribAPPLE(GLGetProcAddr('glEnableVertexAttribAPPLE'));
  if not Assigned(glEnableVertexAttribAPPLE) then 
    glEnableVertexAttribAPPLE:=TglEnableVertexAttribAPPLE(GetProcAddress(Lib, 'glEnableVertexAttribAPPLE'));
  glEnableVertexAttribArray:=TglEnableVertexAttribArray(GLGetProcAddr('glEnableVertexAttribArray'));
  if not Assigned(glEnableVertexAttribArray) then 
    glEnableVertexAttribArray:=TglEnableVertexAttribArray(GetProcAddress(Lib, 'glEnableVertexAttribArray'));
  glEnableVertexAttribArrayARB:=TglEnableVertexAttribArrayARB(GLGetProcAddr('glEnableVertexAttribArrayARB'));
  if not Assigned(glEnableVertexAttribArrayARB) then 
    glEnableVertexAttribArrayARB:=TglEnableVertexAttribArrayARB(GetProcAddress(Lib, 'glEnableVertexAttribArrayARB'));
  glEnablei:=TglEnablei(GLGetProcAddr('glEnablei'));
  if not Assigned(glEnablei) then 
    glEnablei:=TglEnablei(GetProcAddress(Lib, 'glEnablei'));
  glEnableiEXT:=TglEnableiEXT(GLGetProcAddr('glEnableiEXT'));
  if not Assigned(glEnableiEXT) then 
    glEnableiEXT:=TglEnableiEXT(GetProcAddress(Lib, 'glEnableiEXT'));
  glEnableiNV:=TglEnableiNV(GLGetProcAddr('glEnableiNV'));
  if not Assigned(glEnableiNV) then 
    glEnableiNV:=TglEnableiNV(GetProcAddress(Lib, 'glEnableiNV'));
  glEnableiOES:=TglEnableiOES(GLGetProcAddr('glEnableiOES'));
  if not Assigned(glEnableiOES) then 
    glEnableiOES:=TglEnableiOES(GetProcAddress(Lib, 'glEnableiOES'));
  glEnd:=TglEnd(GLGetProcAddr('glEnd'));
  if not Assigned(glEnd) then 
    glEnd:=TglEnd(GetProcAddress(Lib, 'glEnd'));
  glEndConditionalRender:=TglEndConditionalRender(GLGetProcAddr('glEndConditionalRender'));
  if not Assigned(glEndConditionalRender) then 
    glEndConditionalRender:=TglEndConditionalRender(GetProcAddress(Lib, 'glEndConditionalRender'));
  glEndConditionalRenderNV:=TglEndConditionalRenderNV(GLGetProcAddr('glEndConditionalRenderNV'));
  if not Assigned(glEndConditionalRenderNV) then 
    glEndConditionalRenderNV:=TglEndConditionalRenderNV(GetProcAddress(Lib, 'glEndConditionalRenderNV'));
  glEndConditionalRenderNVX:=TglEndConditionalRenderNVX(GLGetProcAddr('glEndConditionalRenderNVX'));
  if not Assigned(glEndConditionalRenderNVX) then 
    glEndConditionalRenderNVX:=TglEndConditionalRenderNVX(GetProcAddress(Lib, 'glEndConditionalRenderNVX'));
  glEndFragmentShaderATI:=TglEndFragmentShaderATI(GLGetProcAddr('glEndFragmentShaderATI'));
  if not Assigned(glEndFragmentShaderATI) then 
    glEndFragmentShaderATI:=TglEndFragmentShaderATI(GetProcAddress(Lib, 'glEndFragmentShaderATI'));
  glEndList:=TglEndList(GLGetProcAddr('glEndList'));
  if not Assigned(glEndList) then 
    glEndList:=TglEndList(GetProcAddress(Lib, 'glEndList'));
  glEndOcclusionQueryNV:=TglEndOcclusionQueryNV(GLGetProcAddr('glEndOcclusionQueryNV'));
  if not Assigned(glEndOcclusionQueryNV) then 
    glEndOcclusionQueryNV:=TglEndOcclusionQueryNV(GetProcAddress(Lib, 'glEndOcclusionQueryNV'));
  glEndPerfMonitorAMD:=TglEndPerfMonitorAMD(GLGetProcAddr('glEndPerfMonitorAMD'));
  if not Assigned(glEndPerfMonitorAMD) then 
    glEndPerfMonitorAMD:=TglEndPerfMonitorAMD(GetProcAddress(Lib, 'glEndPerfMonitorAMD'));
  glEndPerfQueryINTEL:=TglEndPerfQueryINTEL(GLGetProcAddr('glEndPerfQueryINTEL'));
  if not Assigned(glEndPerfQueryINTEL) then
    glEndPerfQueryINTEL:=TglEndPerfQueryINTEL(GetProcAddress(Lib, 'glEndPerfQueryINTEL'));
  glEndQuery:=TglEndQuery(GLGetProcAddr('glEndQuery'));
  if not Assigned(glEndQuery) then 
    glEndQuery:=TglEndQuery(GetProcAddress(Lib, 'glEndQuery'));
  glEndQueryARB:=TglEndQueryARB(GLGetProcAddr('glEndQueryARB'));
  if not Assigned(glEndQueryARB) then 
    glEndQueryARB:=TglEndQueryARB(GetProcAddress(Lib, 'glEndQueryARB'));
  glEndQueryEXT:=TglEndQueryEXT(GLGetProcAddr('glEndQueryEXT'));
  if not Assigned(glEndQueryEXT) then 
    glEndQueryEXT:=TglEndQueryEXT(GetProcAddress(Lib, 'glEndQueryEXT'));
  glEndQueryIndexed:=TglEndQueryIndexed(GLGetProcAddr('glEndQueryIndexed'));
  if not Assigned(glEndQueryIndexed) then 
    glEndQueryIndexed:=TglEndQueryIndexed(GetProcAddress(Lib, 'glEndQueryIndexed'));
  glEndTilingQCOM:=TglEndTilingQCOM(GLGetProcAddr('glEndTilingQCOM'));
  if not Assigned(glEndTilingQCOM) then 
    glEndTilingQCOM:=TglEndTilingQCOM(GetProcAddress(Lib, 'glEndTilingQCOM'));
  glEndTransformFeedback:=TglEndTransformFeedback(GLGetProcAddr('glEndTransformFeedback'));
  if not Assigned(glEndTransformFeedback) then
    glEndTransformFeedback:=TglEndTransformFeedback(GetProcAddress(Lib, 'glEndTransformFeedback'));
  glEndTransformFeedbackEXT:=TglEndTransformFeedbackEXT(GLGetProcAddr('glEndTransformFeedbackEXT'));
  if not Assigned(glEndTransformFeedbackEXT) then 
    glEndTransformFeedbackEXT:=TglEndTransformFeedbackEXT(GetProcAddress(Lib, 'glEndTransformFeedbackEXT'));
  glEndTransformFeedbackNV:=TglEndTransformFeedbackNV(GLGetProcAddr('glEndTransformFeedbackNV'));
  if not Assigned(glEndTransformFeedbackNV) then 
    glEndTransformFeedbackNV:=TglEndTransformFeedbackNV(GetProcAddress(Lib, 'glEndTransformFeedbackNV'));
  glEndVertexShaderEXT:=TglEndVertexShaderEXT(GLGetProcAddr('glEndVertexShaderEXT'));
  if not Assigned(glEndVertexShaderEXT) then 
    glEndVertexShaderEXT:=TglEndVertexShaderEXT(GetProcAddress(Lib, 'glEndVertexShaderEXT'));
  glEndVideoCaptureNV:=TglEndVideoCaptureNV(GLGetProcAddr('glEndVideoCaptureNV'));
  if not Assigned(glEndVideoCaptureNV) then 
    glEndVideoCaptureNV:=TglEndVideoCaptureNV(GetProcAddress(Lib, 'glEndVideoCaptureNV'));
  glEvalCoord1d:=TglEvalCoord1d(GLGetProcAddr('glEvalCoord1d'));
  if not Assigned(glEvalCoord1d) then 
    glEvalCoord1d:=TglEvalCoord1d(GetProcAddress(Lib, 'glEvalCoord1d'));
  glEvalCoord1dv:=TglEvalCoord1dv(GLGetProcAddr('glEvalCoord1dv'));
  if not Assigned(glEvalCoord1dv) then 
    glEvalCoord1dv:=TglEvalCoord1dv(GetProcAddress(Lib, 'glEvalCoord1dv'));
  glEvalCoord1f:=TglEvalCoord1f(GLGetProcAddr('glEvalCoord1f'));
  if not Assigned(glEvalCoord1f) then 
    glEvalCoord1f:=TglEvalCoord1f(GetProcAddress(Lib, 'glEvalCoord1f'));
  glEvalCoord1fv:=TglEvalCoord1fv(GLGetProcAddr('glEvalCoord1fv'));
  if not Assigned(glEvalCoord1fv) then 
    glEvalCoord1fv:=TglEvalCoord1fv(GetProcAddress(Lib, 'glEvalCoord1fv'));
  glEvalCoord1xOES:=TglEvalCoord1xOES(GLGetProcAddr('glEvalCoord1xOES'));
  if not Assigned(glEvalCoord1xOES) then 
    glEvalCoord1xOES:=TglEvalCoord1xOES(GetProcAddress(Lib, 'glEvalCoord1xOES'));
  glEvalCoord1xvOES:=TglEvalCoord1xvOES(GLGetProcAddr('glEvalCoord1xvOES'));
  if not Assigned(glEvalCoord1xvOES) then 
    glEvalCoord1xvOES:=TglEvalCoord1xvOES(GetProcAddress(Lib, 'glEvalCoord1xvOES'));
  glEvalCoord2d:=TglEvalCoord2d(GLGetProcAddr('glEvalCoord2d'));
  if not Assigned(glEvalCoord2d) then 
    glEvalCoord2d:=TglEvalCoord2d(GetProcAddress(Lib, 'glEvalCoord2d'));
  glEvalCoord2dv:=TglEvalCoord2dv(GLGetProcAddr('glEvalCoord2dv'));
  if not Assigned(glEvalCoord2dv) then 
    glEvalCoord2dv:=TglEvalCoord2dv(GetProcAddress(Lib, 'glEvalCoord2dv'));
  glEvalCoord2f:=TglEvalCoord2f(GLGetProcAddr('glEvalCoord2f'));
  if not Assigned(glEvalCoord2f) then
    glEvalCoord2f:=TglEvalCoord2f(GetProcAddress(Lib, 'glEvalCoord2f'));
  glEvalCoord2fv:=TglEvalCoord2fv(GLGetProcAddr('glEvalCoord2fv'));
  if not Assigned(glEvalCoord2fv) then 
    glEvalCoord2fv:=TglEvalCoord2fv(GetProcAddress(Lib, 'glEvalCoord2fv'));
  glEvalCoord2xOES:=TglEvalCoord2xOES(GLGetProcAddr('glEvalCoord2xOES'));
  if not Assigned(glEvalCoord2xOES) then 
    glEvalCoord2xOES:=TglEvalCoord2xOES(GetProcAddress(Lib, 'glEvalCoord2xOES'));
  glEvalCoord2xvOES:=TglEvalCoord2xvOES(GLGetProcAddr('glEvalCoord2xvOES'));
  if not Assigned(glEvalCoord2xvOES) then 
    glEvalCoord2xvOES:=TglEvalCoord2xvOES(GetProcAddress(Lib, 'glEvalCoord2xvOES'));
  glEvalMapsNV:=TglEvalMapsNV(GLGetProcAddr('glEvalMapsNV'));
  if not Assigned(glEvalMapsNV) then 
    glEvalMapsNV:=TglEvalMapsNV(GetProcAddress(Lib, 'glEvalMapsNV'));
  glEvalMesh1:=TglEvalMesh1(GLGetProcAddr('glEvalMesh1'));
  if not Assigned(glEvalMesh1) then 
    glEvalMesh1:=TglEvalMesh1(GetProcAddress(Lib, 'glEvalMesh1'));
  glEvalMesh2:=TglEvalMesh2(GLGetProcAddr('glEvalMesh2'));
  if not Assigned(glEvalMesh2) then 
    glEvalMesh2:=TglEvalMesh2(GetProcAddress(Lib, 'glEvalMesh2'));
  glEvalPoint1:=TglEvalPoint1(GLGetProcAddr('glEvalPoint1'));
  if not Assigned(glEvalPoint1) then 
    glEvalPoint1:=TglEvalPoint1(GetProcAddress(Lib, 'glEvalPoint1'));
  glEvalPoint2:=TglEvalPoint2(GLGetProcAddr('glEvalPoint2'));
  if not Assigned(glEvalPoint2) then 
    glEvalPoint2:=TglEvalPoint2(GetProcAddress(Lib, 'glEvalPoint2'));
  glEvaluateDepthValuesARB:=TglEvaluateDepthValuesARB(GLGetProcAddr('glEvaluateDepthValuesARB'));
  if not Assigned(glEvaluateDepthValuesARB) then 
    glEvaluateDepthValuesARB:=TglEvaluateDepthValuesARB(GetProcAddress(Lib, 'glEvaluateDepthValuesARB'));
  glExecuteProgramNV:=TglExecuteProgramNV(GLGetProcAddr('glExecuteProgramNV'));
  if not Assigned(glExecuteProgramNV) then 
    glExecuteProgramNV:=TglExecuteProgramNV(GetProcAddress(Lib, 'glExecuteProgramNV'));
  glExtGetBufferPointervQCOM:=TglExtGetBufferPointervQCOM(GLGetProcAddr('glExtGetBufferPointervQCOM'));
  if not Assigned(glExtGetBufferPointervQCOM) then 
    glExtGetBufferPointervQCOM:=TglExtGetBufferPointervQCOM(GetProcAddress(Lib, 'glExtGetBufferPointervQCOM'));
  glExtGetBuffersQCOM:=TglExtGetBuffersQCOM(GLGetProcAddr('glExtGetBuffersQCOM'));
  if not Assigned(glExtGetBuffersQCOM) then 
    glExtGetBuffersQCOM:=TglExtGetBuffersQCOM(GetProcAddress(Lib, 'glExtGetBuffersQCOM'));
  glExtGetFramebuffersQCOM:=TglExtGetFramebuffersQCOM(GLGetProcAddr('glExtGetFramebuffersQCOM'));
  if not Assigned(glExtGetFramebuffersQCOM) then
    glExtGetFramebuffersQCOM:=TglExtGetFramebuffersQCOM(GetProcAddress(Lib, 'glExtGetFramebuffersQCOM'));
  glExtGetProgramBinarySourceQCOM:=TglExtGetProgramBinarySourceQCOM(GLGetProcAddr('glExtGetProgramBinarySourceQCOM'));
  if not Assigned(glExtGetProgramBinarySourceQCOM) then 
    glExtGetProgramBinarySourceQCOM:=TglExtGetProgramBinarySourceQCOM(GetProcAddress(Lib, 'glExtGetProgramBinarySourceQCOM'));
  glExtGetProgramsQCOM:=TglExtGetProgramsQCOM(GLGetProcAddr('glExtGetProgramsQCOM'));
  if not Assigned(glExtGetProgramsQCOM) then 
    glExtGetProgramsQCOM:=TglExtGetProgramsQCOM(GetProcAddress(Lib, 'glExtGetProgramsQCOM'));
  glExtGetRenderbuffersQCOM:=TglExtGetRenderbuffersQCOM(GLGetProcAddr('glExtGetRenderbuffersQCOM'));
  if not Assigned(glExtGetRenderbuffersQCOM) then 
    glExtGetRenderbuffersQCOM:=TglExtGetRenderbuffersQCOM(GetProcAddress(Lib, 'glExtGetRenderbuffersQCOM'));
  glExtGetShadersQCOM:=TglExtGetShadersQCOM(GLGetProcAddr('glExtGetShadersQCOM'));
  if not Assigned(glExtGetShadersQCOM) then 
    glExtGetShadersQCOM:=TglExtGetShadersQCOM(GetProcAddress(Lib, 'glExtGetShadersQCOM'));
  glExtGetTexLevelParameterivQCOM:=TglExtGetTexLevelParameterivQCOM(GLGetProcAddr('glExtGetTexLevelParameterivQCOM'));
  if not Assigned(glExtGetTexLevelParameterivQCOM) then 
    glExtGetTexLevelParameterivQCOM:=TglExtGetTexLevelParameterivQCOM(GetProcAddress(Lib, 'glExtGetTexLevelParameterivQCOM'));
  glExtGetTexSubImageQCOM:=TglExtGetTexSubImageQCOM(GLGetProcAddr('glExtGetTexSubImageQCOM'));
  if not Assigned(glExtGetTexSubImageQCOM) then
    glExtGetTexSubImageQCOM:=TglExtGetTexSubImageQCOM(GetProcAddress(Lib, 'glExtGetTexSubImageQCOM'));
  glExtGetTexturesQCOM:=TglExtGetTexturesQCOM(GLGetProcAddr('glExtGetTexturesQCOM'));
  if not Assigned(glExtGetTexturesQCOM) then 
    glExtGetTexturesQCOM:=TglExtGetTexturesQCOM(GetProcAddress(Lib, 'glExtGetTexturesQCOM'));
  glExtIsProgramBinaryQCOM:=TglExtIsProgramBinaryQCOM(GLGetProcAddr('glExtIsProgramBinaryQCOM'));
  if not Assigned(glExtIsProgramBinaryQCOM) then 
    glExtIsProgramBinaryQCOM:=TglExtIsProgramBinaryQCOM(GetProcAddress(Lib, 'glExtIsProgramBinaryQCOM'));
  glExtTexObjectStateOverrideiQCOM:=TglExtTexObjectStateOverrideiQCOM(GLGetProcAddr('glExtTexObjectStateOverrideiQCOM'));
  if not Assigned(glExtTexObjectStateOverrideiQCOM) then 
    glExtTexObjectStateOverrideiQCOM:=TglExtTexObjectStateOverrideiQCOM(GetProcAddress(Lib, 'glExtTexObjectStateOverrideiQCOM'));
  glExtractComponentEXT:=TglExtractComponentEXT(GLGetProcAddr('glExtractComponentEXT'));
  if not Assigned(glExtractComponentEXT) then 
    glExtractComponentEXT:=TglExtractComponentEXT(GetProcAddress(Lib, 'glExtractComponentEXT'));
  glFeedbackBuffer:=TglFeedbackBuffer(GLGetProcAddr('glFeedbackBuffer'));
  if not Assigned(glFeedbackBuffer) then 
    glFeedbackBuffer:=TglFeedbackBuffer(GetProcAddress(Lib, 'glFeedbackBuffer'));
  glFeedbackBufferxOES:=TglFeedbackBufferxOES(GLGetProcAddr('glFeedbackBufferxOES'));
  if not Assigned(glFeedbackBufferxOES) then 
    glFeedbackBufferxOES:=TglFeedbackBufferxOES(GetProcAddress(Lib, 'glFeedbackBufferxOES'));
  glFenceSync:=TglFenceSync(GLGetProcAddr('glFenceSync'));
  if not Assigned(glFenceSync) then 
    glFenceSync:=TglFenceSync(GetProcAddress(Lib, 'glFenceSync'));
  glFenceSyncAPPLE:=TglFenceSyncAPPLE(GLGetProcAddr('glFenceSyncAPPLE'));
  if not Assigned(glFenceSyncAPPLE) then 
    glFenceSyncAPPLE:=TglFenceSyncAPPLE(GetProcAddress(Lib, 'glFenceSyncAPPLE'));
  glFinalCombinerInputNV:=TglFinalCombinerInputNV(GLGetProcAddr('glFinalCombinerInputNV'));
  if not Assigned(glFinalCombinerInputNV) then 
    glFinalCombinerInputNV:=TglFinalCombinerInputNV(GetProcAddress(Lib, 'glFinalCombinerInputNV'));
  glFinish:=TglFinish(GLGetProcAddr('glFinish'));
  if not Assigned(glFinish) then 
    glFinish:=TglFinish(GetProcAddress(Lib, 'glFinish'));
  glFinishAsyncSGIX:=TglFinishAsyncSGIX(GLGetProcAddr('glFinishAsyncSGIX'));
  if not Assigned(glFinishAsyncSGIX) then 
    glFinishAsyncSGIX:=TglFinishAsyncSGIX(GetProcAddress(Lib, 'glFinishAsyncSGIX'));
  glFinishFenceAPPLE:=TglFinishFenceAPPLE(GLGetProcAddr('glFinishFenceAPPLE'));
  if not Assigned(glFinishFenceAPPLE) then 
    glFinishFenceAPPLE:=TglFinishFenceAPPLE(GetProcAddress(Lib, 'glFinishFenceAPPLE'));
  glFinishFenceNV:=TglFinishFenceNV(GLGetProcAddr('glFinishFenceNV'));
  if not Assigned(glFinishFenceNV) then 
    glFinishFenceNV:=TglFinishFenceNV(GetProcAddress(Lib, 'glFinishFenceNV'));
  glFinishObjectAPPLE:=TglFinishObjectAPPLE(GLGetProcAddr('glFinishObjectAPPLE'));
  if not Assigned(glFinishObjectAPPLE) then 
    glFinishObjectAPPLE:=TglFinishObjectAPPLE(GetProcAddress(Lib, 'glFinishObjectAPPLE'));
  glFinishTextureSUNX:=TglFinishTextureSUNX(GLGetProcAddr('glFinishTextureSUNX'));
  if not Assigned(glFinishTextureSUNX) then 
    glFinishTextureSUNX:=TglFinishTextureSUNX(GetProcAddress(Lib, 'glFinishTextureSUNX'));
  glFlush:=TglFlush(GLGetProcAddr('glFlush'));
  if not Assigned(glFlush) then 
    glFlush:=TglFlush(GetProcAddress(Lib, 'glFlush'));
  glFlushMappedBufferRange:=TglFlushMappedBufferRange(GLGetProcAddr('glFlushMappedBufferRange'));
  if not Assigned(glFlushMappedBufferRange) then 
    glFlushMappedBufferRange:=TglFlushMappedBufferRange(GetProcAddress(Lib, 'glFlushMappedBufferRange'));
  glFlushMappedBufferRangeAPPLE:=TglFlushMappedBufferRangeAPPLE(GLGetProcAddr('glFlushMappedBufferRangeAPPLE'));
  if not Assigned(glFlushMappedBufferRangeAPPLE) then 
    glFlushMappedBufferRangeAPPLE:=TglFlushMappedBufferRangeAPPLE(GetProcAddress(Lib, 'glFlushMappedBufferRangeAPPLE'));
  glFlushMappedBufferRangeEXT:=TglFlushMappedBufferRangeEXT(GLGetProcAddr('glFlushMappedBufferRangeEXT'));
  if not Assigned(glFlushMappedBufferRangeEXT) then
    glFlushMappedBufferRangeEXT:=TglFlushMappedBufferRangeEXT(GetProcAddress(Lib, 'glFlushMappedBufferRangeEXT'));
  glFlushMappedNamedBufferRange:=TglFlushMappedNamedBufferRange(GLGetProcAddr('glFlushMappedNamedBufferRange'));
  if not Assigned(glFlushMappedNamedBufferRange) then
    glFlushMappedNamedBufferRange:=TglFlushMappedNamedBufferRange(GetProcAddress(Lib, 'glFlushMappedNamedBufferRange'));
  glFlushMappedNamedBufferRangeEXT:=TglFlushMappedNamedBufferRangeEXT(GLGetProcAddr('glFlushMappedNamedBufferRangeEXT'));
  if not Assigned(glFlushMappedNamedBufferRangeEXT) then 
    glFlushMappedNamedBufferRangeEXT:=TglFlushMappedNamedBufferRangeEXT(GetProcAddress(Lib, 'glFlushMappedNamedBufferRangeEXT'));
  glFlushPixelDataRangeNV:=TglFlushPixelDataRangeNV(GLGetProcAddr('glFlushPixelDataRangeNV'));
  if not Assigned(glFlushPixelDataRangeNV) then 
    glFlushPixelDataRangeNV:=TglFlushPixelDataRangeNV(GetProcAddress(Lib, 'glFlushPixelDataRangeNV'));
  glFlushRasterSGIX:=TglFlushRasterSGIX(GLGetProcAddr('glFlushRasterSGIX'));
  if not Assigned(glFlushRasterSGIX) then 
    glFlushRasterSGIX:=TglFlushRasterSGIX(GetProcAddress(Lib, 'glFlushRasterSGIX'));
  glFlushStaticDataIBM:=TglFlushStaticDataIBM(GLGetProcAddr('glFlushStaticDataIBM'));
  if not Assigned(glFlushStaticDataIBM) then 
    glFlushStaticDataIBM:=TglFlushStaticDataIBM(GetProcAddress(Lib, 'glFlushStaticDataIBM'));
  glFlushVertexArrayRangeAPPLE:=TglFlushVertexArrayRangeAPPLE(GLGetProcAddr('glFlushVertexArrayRangeAPPLE'));
  if not Assigned(glFlushVertexArrayRangeAPPLE) then 
    glFlushVertexArrayRangeAPPLE:=TglFlushVertexArrayRangeAPPLE(GetProcAddress(Lib, 'glFlushVertexArrayRangeAPPLE'));
  glFlushVertexArrayRangeNV:=TglFlushVertexArrayRangeNV(GLGetProcAddr('glFlushVertexArrayRangeNV'));
  if not Assigned(glFlushVertexArrayRangeNV) then 
    glFlushVertexArrayRangeNV:=TglFlushVertexArrayRangeNV(GetProcAddress(Lib, 'glFlushVertexArrayRangeNV'));
  glFogCoordFormatNV:=TglFogCoordFormatNV(GLGetProcAddr('glFogCoordFormatNV'));
  if not Assigned(glFogCoordFormatNV) then 
    glFogCoordFormatNV:=TglFogCoordFormatNV(GetProcAddress(Lib, 'glFogCoordFormatNV'));
  glFogCoordPointer:=TglFogCoordPointer(GLGetProcAddr('glFogCoordPointer'));
  if not Assigned(glFogCoordPointer) then 
    glFogCoordPointer:=TglFogCoordPointer(GetProcAddress(Lib, 'glFogCoordPointer'));
  glFogCoordPointerEXT:=TglFogCoordPointerEXT(GLGetProcAddr('glFogCoordPointerEXT'));
  if not Assigned(glFogCoordPointerEXT) then 
    glFogCoordPointerEXT:=TglFogCoordPointerEXT(GetProcAddress(Lib, 'glFogCoordPointerEXT'));
  glFogCoordPointerListIBM:=TglFogCoordPointerListIBM(GLGetProcAddr('glFogCoordPointerListIBM'));
  if not Assigned(glFogCoordPointerListIBM) then 
    glFogCoordPointerListIBM:=TglFogCoordPointerListIBM(GetProcAddress(Lib, 'glFogCoordPointerListIBM'));
  glFogCoordd:=TglFogCoordd(GLGetProcAddr('glFogCoordd'));
  if not Assigned(glFogCoordd) then 
    glFogCoordd:=TglFogCoordd(GetProcAddress(Lib, 'glFogCoordd'));
  glFogCoorddEXT:=TglFogCoorddEXT(GLGetProcAddr('glFogCoorddEXT'));
  if not Assigned(glFogCoorddEXT) then 
    glFogCoorddEXT:=TglFogCoorddEXT(GetProcAddress(Lib, 'glFogCoorddEXT'));
  glFogCoorddv:=TglFogCoorddv(GLGetProcAddr('glFogCoorddv'));
  if not Assigned(glFogCoorddv) then 
    glFogCoorddv:=TglFogCoorddv(GetProcAddress(Lib, 'glFogCoorddv'));
  glFogCoorddvEXT:=TglFogCoorddvEXT(GLGetProcAddr('glFogCoorddvEXT'));
  if not Assigned(glFogCoorddvEXT) then 
    glFogCoorddvEXT:=TglFogCoorddvEXT(GetProcAddress(Lib, 'glFogCoorddvEXT'));
  glFogCoordf:=TglFogCoordf(GLGetProcAddr('glFogCoordf'));
  if not Assigned(glFogCoordf) then 
    glFogCoordf:=TglFogCoordf(GetProcAddress(Lib, 'glFogCoordf'));
  glFogCoordfEXT:=TglFogCoordfEXT(GLGetProcAddr('glFogCoordfEXT'));
  if not Assigned(glFogCoordfEXT) then 
    glFogCoordfEXT:=TglFogCoordfEXT(GetProcAddress(Lib, 'glFogCoordfEXT'));
end;

procedure Part2;
begin
  glFogCoordfv:=TglFogCoordfv(GLGetProcAddr('glFogCoordfv'));
  if not Assigned(glFogCoordfv) then
    glFogCoordfv:=TglFogCoordfv(GetProcAddress(Lib, 'glFogCoordfv'));
  glFogCoordfvEXT:=TglFogCoordfvEXT(GLGetProcAddr('glFogCoordfvEXT'));
  if not Assigned(glFogCoordfvEXT) then
    glFogCoordfvEXT:=TglFogCoordfvEXT(GetProcAddress(Lib, 'glFogCoordfvEXT'));
  glFogCoordhNV:=TglFogCoordhNV(GLGetProcAddr('glFogCoordhNV'));
  if not Assigned(glFogCoordhNV) then 
    glFogCoordhNV:=TglFogCoordhNV(GetProcAddress(Lib, 'glFogCoordhNV'));
  glFogCoordhvNV:=TglFogCoordhvNV(GLGetProcAddr('glFogCoordhvNV'));
  if not Assigned(glFogCoordhvNV) then 
    glFogCoordhvNV:=TglFogCoordhvNV(GetProcAddress(Lib, 'glFogCoordhvNV'));
  glFogFuncSGIS:=TglFogFuncSGIS(GLGetProcAddr('glFogFuncSGIS'));
  if not Assigned(glFogFuncSGIS) then 
    glFogFuncSGIS:=TglFogFuncSGIS(GetProcAddress(Lib, 'glFogFuncSGIS'));
  glFogf:=TglFogf(GLGetProcAddr('glFogf'));
  if not Assigned(glFogf) then 
    glFogf:=TglFogf(GetProcAddress(Lib, 'glFogf'));
  glFogfv:=TglFogfv(GLGetProcAddr('glFogfv'));
  if not Assigned(glFogfv) then 
    glFogfv:=TglFogfv(GetProcAddress(Lib, 'glFogfv'));
  glFogi:=TglFogi(GLGetProcAddr('glFogi'));
  if not Assigned(glFogi) then 
    glFogi:=TglFogi(GetProcAddress(Lib, 'glFogi'));
  glFogiv:=TglFogiv(GLGetProcAddr('glFogiv'));
  if not Assigned(glFogiv) then 
    glFogiv:=TglFogiv(GetProcAddress(Lib, 'glFogiv'));
  glFogx:=TglFogx(GLGetProcAddr('glFogx'));
  if not Assigned(glFogx) then
    glFogx:=TglFogx(GetProcAddress(Lib, 'glFogx'));
  glFogxOES:=TglFogxOES(GLGetProcAddr('glFogxOES'));
  if not Assigned(glFogxOES) then 
    glFogxOES:=TglFogxOES(GetProcAddress(Lib, 'glFogxOES'));
  glFogxv:=TglFogxv(GLGetProcAddr('glFogxv'));
  if not Assigned(glFogxv) then 
    glFogxv:=TglFogxv(GetProcAddress(Lib, 'glFogxv'));
  glFogxvOES:=TglFogxvOES(GLGetProcAddr('glFogxvOES'));
  if not Assigned(glFogxvOES) then 
    glFogxvOES:=TglFogxvOES(GetProcAddress(Lib, 'glFogxvOES'));
  glFragmentColorMaterialSGIX:=TglFragmentColorMaterialSGIX(GLGetProcAddr('glFragmentColorMaterialSGIX'));
  if not Assigned(glFragmentColorMaterialSGIX) then 
    glFragmentColorMaterialSGIX:=TglFragmentColorMaterialSGIX(GetProcAddress(Lib, 'glFragmentColorMaterialSGIX'));
  glFragmentCoverageColorNV:=TglFragmentCoverageColorNV(GLGetProcAddr('glFragmentCoverageColorNV'));
  if not Assigned(glFragmentCoverageColorNV) then 
    glFragmentCoverageColorNV:=TglFragmentCoverageColorNV(GetProcAddress(Lib, 'glFragmentCoverageColorNV'));
  glFragmentLightModelfSGIX:=TglFragmentLightModelfSGIX(GLGetProcAddr('glFragmentLightModelfSGIX'));
  if not Assigned(glFragmentLightModelfSGIX) then 
    glFragmentLightModelfSGIX:=TglFragmentLightModelfSGIX(GetProcAddress(Lib, 'glFragmentLightModelfSGIX'));
  glFragmentLightModelfvSGIX:=TglFragmentLightModelfvSGIX(GLGetProcAddr('glFragmentLightModelfvSGIX'));
  if not Assigned(glFragmentLightModelfvSGIX) then 
    glFragmentLightModelfvSGIX:=TglFragmentLightModelfvSGIX(GetProcAddress(Lib, 'glFragmentLightModelfvSGIX'));
  glFragmentLightModeliSGIX:=TglFragmentLightModeliSGIX(GLGetProcAddr('glFragmentLightModeliSGIX'));
  if not Assigned(glFragmentLightModeliSGIX) then
    glFragmentLightModeliSGIX:=TglFragmentLightModeliSGIX(GetProcAddress(Lib, 'glFragmentLightModeliSGIX'));
  glFragmentLightModelivSGIX:=TglFragmentLightModelivSGIX(GLGetProcAddr('glFragmentLightModelivSGIX'));
  if not Assigned(glFragmentLightModelivSGIX) then 
    glFragmentLightModelivSGIX:=TglFragmentLightModelivSGIX(GetProcAddress(Lib, 'glFragmentLightModelivSGIX'));
  glFragmentLightfSGIX:=TglFragmentLightfSGIX(GLGetProcAddr('glFragmentLightfSGIX'));
  if not Assigned(glFragmentLightfSGIX) then 
    glFragmentLightfSGIX:=TglFragmentLightfSGIX(GetProcAddress(Lib, 'glFragmentLightfSGIX'));
  glFragmentLightfvSGIX:=TglFragmentLightfvSGIX(GLGetProcAddr('glFragmentLightfvSGIX'));
  if not Assigned(glFragmentLightfvSGIX) then
    glFragmentLightfvSGIX:=TglFragmentLightfvSGIX(GetProcAddress(Lib, 'glFragmentLightfvSGIX'));
  glFragmentLightiSGIX:=TglFragmentLightiSGIX(GLGetProcAddr('glFragmentLightiSGIX'));
  if not Assigned(glFragmentLightiSGIX) then 
    glFragmentLightiSGIX:=TglFragmentLightiSGIX(GetProcAddress(Lib, 'glFragmentLightiSGIX'));
  glFragmentLightivSGIX:=TglFragmentLightivSGIX(GLGetProcAddr('glFragmentLightivSGIX'));
  if not Assigned(glFragmentLightivSGIX) then 
    glFragmentLightivSGIX:=TglFragmentLightivSGIX(GetProcAddress(Lib, 'glFragmentLightivSGIX'));
  glFragmentMaterialfSGIX:=TglFragmentMaterialfSGIX(GLGetProcAddr('glFragmentMaterialfSGIX'));
  if not Assigned(glFragmentMaterialfSGIX) then 
    glFragmentMaterialfSGIX:=TglFragmentMaterialfSGIX(GetProcAddress(Lib, 'glFragmentMaterialfSGIX'));
  glFragmentMaterialfvSGIX:=TglFragmentMaterialfvSGIX(GLGetProcAddr('glFragmentMaterialfvSGIX'));
  if not Assigned(glFragmentMaterialfvSGIX) then 
    glFragmentMaterialfvSGIX:=TglFragmentMaterialfvSGIX(GetProcAddress(Lib, 'glFragmentMaterialfvSGIX'));
  glFragmentMaterialiSGIX:=TglFragmentMaterialiSGIX(GLGetProcAddr('glFragmentMaterialiSGIX'));
  if not Assigned(glFragmentMaterialiSGIX) then 
    glFragmentMaterialiSGIX:=TglFragmentMaterialiSGIX(GetProcAddress(Lib, 'glFragmentMaterialiSGIX'));
  glFragmentMaterialivSGIX:=TglFragmentMaterialivSGIX(GLGetProcAddr('glFragmentMaterialivSGIX'));
  if not Assigned(glFragmentMaterialivSGIX) then 
    glFragmentMaterialivSGIX:=TglFragmentMaterialivSGIX(GetProcAddress(Lib, 'glFragmentMaterialivSGIX'));
  glFrameTerminatorGREMEDY:=TglFrameTerminatorGREMEDY(GLGetProcAddr('glFrameTerminatorGREMEDY'));
  if not Assigned(glFrameTerminatorGREMEDY) then 
    glFrameTerminatorGREMEDY:=TglFrameTerminatorGREMEDY(GetProcAddress(Lib, 'glFrameTerminatorGREMEDY'));
  glFrameZoomSGIX:=TglFrameZoomSGIX(GLGetProcAddr('glFrameZoomSGIX'));
  if not Assigned(glFrameZoomSGIX) then 
    glFrameZoomSGIX:=TglFrameZoomSGIX(GetProcAddress(Lib, 'glFrameZoomSGIX'));
  glFramebufferDrawBufferEXT:=TglFramebufferDrawBufferEXT(GLGetProcAddr('glFramebufferDrawBufferEXT'));
  if not Assigned(glFramebufferDrawBufferEXT) then 
    glFramebufferDrawBufferEXT:=TglFramebufferDrawBufferEXT(GetProcAddress(Lib, 'glFramebufferDrawBufferEXT'));
  glFramebufferDrawBuffersEXT:=TglFramebufferDrawBuffersEXT(GLGetProcAddr('glFramebufferDrawBuffersEXT'));
  if not Assigned(glFramebufferDrawBuffersEXT) then 
    glFramebufferDrawBuffersEXT:=TglFramebufferDrawBuffersEXT(GetProcAddress(Lib, 'glFramebufferDrawBuffersEXT'));
  glFramebufferFetchBarrierQCOM:=TglFramebufferFetchBarrierQCOM(GLGetProcAddr('glFramebufferFetchBarrierQCOM'));
  if not Assigned(glFramebufferFetchBarrierQCOM) then 
    glFramebufferFetchBarrierQCOM:=TglFramebufferFetchBarrierQCOM(GetProcAddress(Lib, 'glFramebufferFetchBarrierQCOM'));
  glFramebufferFoveationConfigQCOM:=TglFramebufferFoveationConfigQCOM(GLGetProcAddr('glFramebufferFoveationConfigQCOM'));
  if not Assigned(glFramebufferFoveationConfigQCOM) then 
    glFramebufferFoveationConfigQCOM:=TglFramebufferFoveationConfigQCOM(GetProcAddress(Lib, 'glFramebufferFoveationConfigQCOM'));
  glFramebufferFoveationParametersQCOM:=TglFramebufferFoveationParametersQCOM(GLGetProcAddr('glFramebufferFoveationParametersQCOM'));
  if not Assigned(glFramebufferFoveationParametersQCOM) then 
    glFramebufferFoveationParametersQCOM:=TglFramebufferFoveationParametersQCOM(GetProcAddress(Lib, 'glFramebufferFoveationParametersQCOM'));
  glFramebufferParameteri:=TglFramebufferParameteri(GLGetProcAddr('glFramebufferParameteri'));
  if not Assigned(glFramebufferParameteri) then 
    glFramebufferParameteri:=TglFramebufferParameteri(GetProcAddress(Lib, 'glFramebufferParameteri'));
  glFramebufferPixelLocalStorageSizeEXT:=TglFramebufferPixelLocalStorageSizeEXT(GLGetProcAddr('glFramebufferPixelLocalStorageSizeEXT'));
  if not Assigned(glFramebufferPixelLocalStorageSizeEXT) then
    glFramebufferPixelLocalStorageSizeEXT:=TglFramebufferPixelLocalStorageSizeEXT(GetProcAddress(Lib, 'glFramebufferPixelLocalStorageSizeEXT'));
  glFramebufferReadBufferEXT:=TglFramebufferReadBufferEXT(GLGetProcAddr('glFramebufferReadBufferEXT'));
  if not Assigned(glFramebufferReadBufferEXT) then 
    glFramebufferReadBufferEXT:=TglFramebufferReadBufferEXT(GetProcAddress(Lib, 'glFramebufferReadBufferEXT'));
  glFramebufferRenderbuffer:=TglFramebufferRenderbuffer(GLGetProcAddr('glFramebufferRenderbuffer'));
  if not Assigned(glFramebufferRenderbuffer) then 
    glFramebufferRenderbuffer:=TglFramebufferRenderbuffer(GetProcAddress(Lib, 'glFramebufferRenderbuffer'));
  glFramebufferRenderbufferEXT:=TglFramebufferRenderbufferEXT(GLGetProcAddr('glFramebufferRenderbufferEXT'));
  if not Assigned(glFramebufferRenderbufferEXT) then 
    glFramebufferRenderbufferEXT:=TglFramebufferRenderbufferEXT(GetProcAddress(Lib, 'glFramebufferRenderbufferEXT'));
  glFramebufferRenderbufferOES:=TglFramebufferRenderbufferOES(GLGetProcAddr('glFramebufferRenderbufferOES'));
  if not Assigned(glFramebufferRenderbufferOES) then
    glFramebufferRenderbufferOES:=TglFramebufferRenderbufferOES(GetProcAddress(Lib, 'glFramebufferRenderbufferOES'));
  glFramebufferSampleLocationsfvARB:=TglFramebufferSampleLocationsfvARB(GLGetProcAddr('glFramebufferSampleLocationsfvARB'));
  if not Assigned(glFramebufferSampleLocationsfvARB) then 
    glFramebufferSampleLocationsfvARB:=TglFramebufferSampleLocationsfvARB(GetProcAddress(Lib, 'glFramebufferSampleLocationsfvARB'));
  glFramebufferSampleLocationsfvNV:=TglFramebufferSampleLocationsfvNV(GLGetProcAddr('glFramebufferSampleLocationsfvNV'));
  if not Assigned(glFramebufferSampleLocationsfvNV) then 
    glFramebufferSampleLocationsfvNV:=TglFramebufferSampleLocationsfvNV(GetProcAddress(Lib, 'glFramebufferSampleLocationsfvNV'));
  glFramebufferSamplePositionsfvAMD:=TglFramebufferSamplePositionsfvAMD(GLGetProcAddr('glFramebufferSamplePositionsfvAMD'));
  if not Assigned(glFramebufferSamplePositionsfvAMD) then 
    glFramebufferSamplePositionsfvAMD:=TglFramebufferSamplePositionsfvAMD(GetProcAddress(Lib, 'glFramebufferSamplePositionsfvAMD'));
  glFramebufferTexture:=TglFramebufferTexture(GLGetProcAddr('glFramebufferTexture'));
  if not Assigned(glFramebufferTexture) then
    glFramebufferTexture:=TglFramebufferTexture(GetProcAddress(Lib, 'glFramebufferTexture'));
  glFramebufferTexture1D:=TglFramebufferTexture1D(GLGetProcAddr('glFramebufferTexture1D'));
  if not Assigned(glFramebufferTexture1D) then 
    glFramebufferTexture1D:=TglFramebufferTexture1D(GetProcAddress(Lib, 'glFramebufferTexture1D'));
  glFramebufferTexture1DEXT:=TglFramebufferTexture1DEXT(GLGetProcAddr('glFramebufferTexture1DEXT'));
  if not Assigned(glFramebufferTexture1DEXT) then 
    glFramebufferTexture1DEXT:=TglFramebufferTexture1DEXT(GetProcAddress(Lib, 'glFramebufferTexture1DEXT'));
  glFramebufferTexture2D:=TglFramebufferTexture2D(GLGetProcAddr('glFramebufferTexture2D'));
  if not Assigned(glFramebufferTexture2D) then 
    glFramebufferTexture2D:=TglFramebufferTexture2D(GetProcAddress(Lib, 'glFramebufferTexture2D'));
  glFramebufferTexture2DEXT:=TglFramebufferTexture2DEXT(GLGetProcAddr('glFramebufferTexture2DEXT'));
  if not Assigned(glFramebufferTexture2DEXT) then 
    glFramebufferTexture2DEXT:=TglFramebufferTexture2DEXT(GetProcAddress(Lib, 'glFramebufferTexture2DEXT'));
  glFramebufferTexture2DDownsampleIMG:=TglFramebufferTexture2DDownsampleIMG(GLGetProcAddr('glFramebufferTexture2DDownsampleIMG'));
  if not Assigned(glFramebufferTexture2DDownsampleIMG) then 
    glFramebufferTexture2DDownsampleIMG:=TglFramebufferTexture2DDownsampleIMG(GetProcAddress(Lib, 'glFramebufferTexture2DDownsampleIMG'));
  glFramebufferTexture2DMultisampleEXT:=TglFramebufferTexture2DMultisampleEXT(GLGetProcAddr('glFramebufferTexture2DMultisampleEXT'));
  if not Assigned(glFramebufferTexture2DMultisampleEXT) then 
    glFramebufferTexture2DMultisampleEXT:=TglFramebufferTexture2DMultisampleEXT(GetProcAddress(Lib, 'glFramebufferTexture2DMultisampleEXT'));
  glFramebufferTexture2DMultisampleIMG:=TglFramebufferTexture2DMultisampleIMG(GLGetProcAddr('glFramebufferTexture2DMultisampleIMG'));
  if not Assigned(glFramebufferTexture2DMultisampleIMG) then 
    glFramebufferTexture2DMultisampleIMG:=TglFramebufferTexture2DMultisampleIMG(GetProcAddress(Lib, 'glFramebufferTexture2DMultisampleIMG'));
  glFramebufferTexture2DOES:=TglFramebufferTexture2DOES(GLGetProcAddr('glFramebufferTexture2DOES'));
  if not Assigned(glFramebufferTexture2DOES) then 
    glFramebufferTexture2DOES:=TglFramebufferTexture2DOES(GetProcAddress(Lib, 'glFramebufferTexture2DOES'));
  glFramebufferTexture3D:=TglFramebufferTexture3D(GLGetProcAddr('glFramebufferTexture3D'));
  if not Assigned(glFramebufferTexture3D) then 
    glFramebufferTexture3D:=TglFramebufferTexture3D(GetProcAddress(Lib, 'glFramebufferTexture3D'));
  glFramebufferTexture3DEXT:=TglFramebufferTexture3DEXT(GLGetProcAddr('glFramebufferTexture3DEXT'));
  if not Assigned(glFramebufferTexture3DEXT) then 
    glFramebufferTexture3DEXT:=TglFramebufferTexture3DEXT(GetProcAddress(Lib, 'glFramebufferTexture3DEXT'));
  glFramebufferTexture3DOES:=TglFramebufferTexture3DOES(GLGetProcAddr('glFramebufferTexture3DOES'));
  if not Assigned(glFramebufferTexture3DOES) then 
    glFramebufferTexture3DOES:=TglFramebufferTexture3DOES(GetProcAddress(Lib, 'glFramebufferTexture3DOES'));
  glFramebufferTextureARB:=TglFramebufferTextureARB(GLGetProcAddr('glFramebufferTextureARB'));
  if not Assigned(glFramebufferTextureARB) then 
    glFramebufferTextureARB:=TglFramebufferTextureARB(GetProcAddress(Lib, 'glFramebufferTextureARB'));
  glFramebufferTextureEXT:=TglFramebufferTextureEXT(GLGetProcAddr('glFramebufferTextureEXT'));
  if not Assigned(glFramebufferTextureEXT) then 
    glFramebufferTextureEXT:=TglFramebufferTextureEXT(GetProcAddress(Lib, 'glFramebufferTextureEXT'));
  glFramebufferTextureFaceARB:=TglFramebufferTextureFaceARB(GLGetProcAddr('glFramebufferTextureFaceARB'));
  if not Assigned(glFramebufferTextureFaceARB) then 
    glFramebufferTextureFaceARB:=TglFramebufferTextureFaceARB(GetProcAddress(Lib, 'glFramebufferTextureFaceARB'));
  glFramebufferTextureFaceEXT:=TglFramebufferTextureFaceEXT(GLGetProcAddr('glFramebufferTextureFaceEXT'));
  if not Assigned(glFramebufferTextureFaceEXT) then
    glFramebufferTextureFaceEXT:=TglFramebufferTextureFaceEXT(GetProcAddress(Lib, 'glFramebufferTextureFaceEXT'));
  glFramebufferTextureLayer:=TglFramebufferTextureLayer(GLGetProcAddr('glFramebufferTextureLayer'));
  if not Assigned(glFramebufferTextureLayer) then 
    glFramebufferTextureLayer:=TglFramebufferTextureLayer(GetProcAddress(Lib, 'glFramebufferTextureLayer'));
  glFramebufferTextureLayerARB:=TglFramebufferTextureLayerARB(GLGetProcAddr('glFramebufferTextureLayerARB'));
  if not Assigned(glFramebufferTextureLayerARB) then 
    glFramebufferTextureLayerARB:=TglFramebufferTextureLayerARB(GetProcAddress(Lib, 'glFramebufferTextureLayerARB'));
  glFramebufferTextureLayerEXT:=TglFramebufferTextureLayerEXT(GLGetProcAddr('glFramebufferTextureLayerEXT'));
  if not Assigned(glFramebufferTextureLayerEXT) then 
    glFramebufferTextureLayerEXT:=TglFramebufferTextureLayerEXT(GetProcAddress(Lib, 'glFramebufferTextureLayerEXT'));
  glFramebufferTextureLayerDownsampleIMG:=TglFramebufferTextureLayerDownsampleIMG(GLGetProcAddr('glFramebufferTextureLayerDownsampleIMG'));
  if not Assigned(glFramebufferTextureLayerDownsampleIMG) then 
    glFramebufferTextureLayerDownsampleIMG:=TglFramebufferTextureLayerDownsampleIMG(GetProcAddress(Lib, 'glFramebufferTextureLayerDownsampleIMG'));
  glFramebufferTextureMultisampleMultiviewOVR:=TglFramebufferTextureMultisampleMultiviewOVR(GLGetProcAddr('glFramebufferTextureMultisampleMultiviewOVR'));
  if not Assigned(glFramebufferTextureMultisampleMultiviewOVR) then 
    glFramebufferTextureMultisampleMultiviewOVR:=TglFramebufferTextureMultisampleMultiviewOVR(GetProcAddress(Lib, 'glFramebufferTextureMultisampleMultiviewOVR'));
  glFramebufferTextureMultiviewOVR:=TglFramebufferTextureMultiviewOVR(GLGetProcAddr('glFramebufferTextureMultiviewOVR'));
  if not Assigned(glFramebufferTextureMultiviewOVR) then 
    glFramebufferTextureMultiviewOVR:=TglFramebufferTextureMultiviewOVR(GetProcAddress(Lib, 'glFramebufferTextureMultiviewOVR'));
  glFramebufferTextureOES:=TglFramebufferTextureOES(GLGetProcAddr('glFramebufferTextureOES'));
  if not Assigned(glFramebufferTextureOES) then 
    glFramebufferTextureOES:=TglFramebufferTextureOES(GetProcAddress(Lib, 'glFramebufferTextureOES'));
  glFreeObjectBufferATI:=TglFreeObjectBufferATI(GLGetProcAddr('glFreeObjectBufferATI'));
  if not Assigned(glFreeObjectBufferATI) then 
    glFreeObjectBufferATI:=TglFreeObjectBufferATI(GetProcAddress(Lib, 'glFreeObjectBufferATI'));
  glFrontFace:=TglFrontFace(GLGetProcAddr('glFrontFace'));
  if not Assigned(glFrontFace) then 
    glFrontFace:=TglFrontFace(GetProcAddress(Lib, 'glFrontFace'));
  glFrustum:=TglFrustum(GLGetProcAddr('glFrustum'));
  if not Assigned(glFrustum) then 
    glFrustum:=TglFrustum(GetProcAddress(Lib, 'glFrustum'));
  glFrustumf:=TglFrustumf(GLGetProcAddr('glFrustumf'));
  if not Assigned(glFrustumf) then
    glFrustumf:=TglFrustumf(GetProcAddress(Lib, 'glFrustumf'));
  glFrustumfOES:=TglFrustumfOES(GLGetProcAddr('glFrustumfOES'));
  if not Assigned(glFrustumfOES) then 
    glFrustumfOES:=TglFrustumfOES(GetProcAddress(Lib, 'glFrustumfOES'));
  glFrustumx:=TglFrustumx(GLGetProcAddr('glFrustumx'));
  if not Assigned(glFrustumx) then 
    glFrustumx:=TglFrustumx(GetProcAddress(Lib, 'glFrustumx'));
  glFrustumxOES:=TglFrustumxOES(GLGetProcAddr('glFrustumxOES'));
  if not Assigned(glFrustumxOES) then 
    glFrustumxOES:=TglFrustumxOES(GetProcAddress(Lib, 'glFrustumxOES'));
  glGenAsyncMarkersSGIX:=TglGenAsyncMarkersSGIX(GLGetProcAddr('glGenAsyncMarkersSGIX'));
  if not Assigned(glGenAsyncMarkersSGIX) then 
    glGenAsyncMarkersSGIX:=TglGenAsyncMarkersSGIX(GetProcAddress(Lib, 'glGenAsyncMarkersSGIX'));
  glGenBuffers:=TglGenBuffers(GLGetProcAddr('glGenBuffers'));
  if not Assigned(glGenBuffers) then 
    glGenBuffers:=TglGenBuffers(GetProcAddress(Lib, 'glGenBuffers'));
  glGenBuffersARB:=TglGenBuffersARB(GLGetProcAddr('glGenBuffersARB'));
  if not Assigned(glGenBuffersARB) then 
    glGenBuffersARB:=TglGenBuffersARB(GetProcAddress(Lib, 'glGenBuffersARB'));
  glGenFencesAPPLE:=TglGenFencesAPPLE(GLGetProcAddr('glGenFencesAPPLE'));
  if not Assigned(glGenFencesAPPLE) then 
    glGenFencesAPPLE:=TglGenFencesAPPLE(GetProcAddress(Lib, 'glGenFencesAPPLE'));
  glGenFencesNV:=TglGenFencesNV(GLGetProcAddr('glGenFencesNV'));
  if not Assigned(glGenFencesNV) then
    glGenFencesNV:=TglGenFencesNV(GetProcAddress(Lib, 'glGenFencesNV'));
  glGenFragmentShadersATI:=TglGenFragmentShadersATI(GLGetProcAddr('glGenFragmentShadersATI'));
  if not Assigned(glGenFragmentShadersATI) then 
    glGenFragmentShadersATI:=TglGenFragmentShadersATI(GetProcAddress(Lib, 'glGenFragmentShadersATI'));
  glGenFramebuffers:=TglGenFramebuffers(GLGetProcAddr('glGenFramebuffers'));
  if not Assigned(glGenFramebuffers) then 
    glGenFramebuffers:=TglGenFramebuffers(GetProcAddress(Lib, 'glGenFramebuffers'));
  glGenFramebuffersEXT:=TglGenFramebuffersEXT(GLGetProcAddr('glGenFramebuffersEXT'));
  if not Assigned(glGenFramebuffersEXT) then 
    glGenFramebuffersEXT:=TglGenFramebuffersEXT(GetProcAddress(Lib, 'glGenFramebuffersEXT'));
  glGenFramebuffersOES:=TglGenFramebuffersOES(GLGetProcAddr('glGenFramebuffersOES'));
  if not Assigned(glGenFramebuffersOES) then 
    glGenFramebuffersOES:=TglGenFramebuffersOES(GetProcAddress(Lib, 'glGenFramebuffersOES'));
  glGenLists:=TglGenLists(GLGetProcAddr('glGenLists'));
  if not Assigned(glGenLists) then 
    glGenLists:=TglGenLists(GetProcAddress(Lib, 'glGenLists'));
  glGenNamesAMD:=TglGenNamesAMD(GLGetProcAddr('glGenNamesAMD'));
  if not Assigned(glGenNamesAMD) then 
    glGenNamesAMD:=TglGenNamesAMD(GetProcAddress(Lib, 'glGenNamesAMD'));
  glGenOcclusionQueriesNV:=TglGenOcclusionQueriesNV(GLGetProcAddr('glGenOcclusionQueriesNV'));
  if not Assigned(glGenOcclusionQueriesNV) then 
    glGenOcclusionQueriesNV:=TglGenOcclusionQueriesNV(GetProcAddress(Lib, 'glGenOcclusionQueriesNV'));
  glGenPathsNV:=TglGenPathsNV(GLGetProcAddr('glGenPathsNV'));
  if not Assigned(glGenPathsNV) then 
    glGenPathsNV:=TglGenPathsNV(GetProcAddress(Lib, 'glGenPathsNV'));
  glGenPerfMonitorsAMD:=TglGenPerfMonitorsAMD(GLGetProcAddr('glGenPerfMonitorsAMD'));
  if not Assigned(glGenPerfMonitorsAMD) then 
    glGenPerfMonitorsAMD:=TglGenPerfMonitorsAMD(GetProcAddress(Lib, 'glGenPerfMonitorsAMD'));
  glGenProgramPipelines:=TglGenProgramPipelines(GLGetProcAddr('glGenProgramPipelines'));
  if not Assigned(glGenProgramPipelines) then 
    glGenProgramPipelines:=TglGenProgramPipelines(GetProcAddress(Lib, 'glGenProgramPipelines'));
  glGenProgramPipelinesEXT:=TglGenProgramPipelinesEXT(GLGetProcAddr('glGenProgramPipelinesEXT'));
  if not Assigned(glGenProgramPipelinesEXT) then 
    glGenProgramPipelinesEXT:=TglGenProgramPipelinesEXT(GetProcAddress(Lib, 'glGenProgramPipelinesEXT'));
  glGenProgramsARB:=TglGenProgramsARB(GLGetProcAddr('glGenProgramsARB'));
  if not Assigned(glGenProgramsARB) then 
    glGenProgramsARB:=TglGenProgramsARB(GetProcAddress(Lib, 'glGenProgramsARB'));
  glGenProgramsNV:=TglGenProgramsNV(GLGetProcAddr('glGenProgramsNV'));
  if not Assigned(glGenProgramsNV) then 
    glGenProgramsNV:=TglGenProgramsNV(GetProcAddress(Lib, 'glGenProgramsNV'));
  glGenQueries:=TglGenQueries(GLGetProcAddr('glGenQueries'));
  if not Assigned(glGenQueries) then 
    glGenQueries:=TglGenQueries(GetProcAddress(Lib, 'glGenQueries'));
  glGenQueriesARB:=TglGenQueriesARB(GLGetProcAddr('glGenQueriesARB'));
  if not Assigned(glGenQueriesARB) then 
    glGenQueriesARB:=TglGenQueriesARB(GetProcAddress(Lib, 'glGenQueriesARB'));
  glGenQueriesEXT:=TglGenQueriesEXT(GLGetProcAddr('glGenQueriesEXT'));
  if not Assigned(glGenQueriesEXT) then 
    glGenQueriesEXT:=TglGenQueriesEXT(GetProcAddress(Lib, 'glGenQueriesEXT'));
  glGenRenderbuffers:=TglGenRenderbuffers(GLGetProcAddr('glGenRenderbuffers'));
  if not Assigned(glGenRenderbuffers) then 
    glGenRenderbuffers:=TglGenRenderbuffers(GetProcAddress(Lib, 'glGenRenderbuffers'));
  glGenRenderbuffersEXT:=TglGenRenderbuffersEXT(GLGetProcAddr('glGenRenderbuffersEXT'));
  if not Assigned(glGenRenderbuffersEXT) then
    glGenRenderbuffersEXT:=TglGenRenderbuffersEXT(GetProcAddress(Lib, 'glGenRenderbuffersEXT'));
  glGenRenderbuffersOES:=TglGenRenderbuffersOES(GLGetProcAddr('glGenRenderbuffersOES'));
  if not Assigned(glGenRenderbuffersOES) then
    glGenRenderbuffersOES:=TglGenRenderbuffersOES(GetProcAddress(Lib, 'glGenRenderbuffersOES'));
  glGenSamplers:=TglGenSamplers(GLGetProcAddr('glGenSamplers'));
  if not Assigned(glGenSamplers) then 
    glGenSamplers:=TglGenSamplers(GetProcAddress(Lib, 'glGenSamplers'));
  glGenSemaphoresEXT:=TglGenSemaphoresEXT(GLGetProcAddr('glGenSemaphoresEXT'));
  if not Assigned(glGenSemaphoresEXT) then 
    glGenSemaphoresEXT:=TglGenSemaphoresEXT(GetProcAddress(Lib, 'glGenSemaphoresEXT'));
  glGenSymbolsEXT:=TglGenSymbolsEXT(GLGetProcAddr('glGenSymbolsEXT'));
  if not Assigned(glGenSymbolsEXT) then 
    glGenSymbolsEXT:=TglGenSymbolsEXT(GetProcAddress(Lib, 'glGenSymbolsEXT'));
  glGenTextures:=TglGenTextures(GLGetProcAddr('glGenTextures'));
  if not Assigned(glGenTextures) then 
    glGenTextures:=TglGenTextures(GetProcAddress(Lib, 'glGenTextures'));
  glGenTexturesEXT:=TglGenTexturesEXT(GLGetProcAddr('glGenTexturesEXT'));
  if not Assigned(glGenTexturesEXT) then 
    glGenTexturesEXT:=TglGenTexturesEXT(GetProcAddress(Lib, 'glGenTexturesEXT'));
  glGenTransformFeedbacks:=TglGenTransformFeedbacks(GLGetProcAddr('glGenTransformFeedbacks'));
  if not Assigned(glGenTransformFeedbacks) then 
    glGenTransformFeedbacks:=TglGenTransformFeedbacks(GetProcAddress(Lib, 'glGenTransformFeedbacks'));
  glGenTransformFeedbacksNV:=TglGenTransformFeedbacksNV(GLGetProcAddr('glGenTransformFeedbacksNV'));
  if not Assigned(glGenTransformFeedbacksNV) then 
    glGenTransformFeedbacksNV:=TglGenTransformFeedbacksNV(GetProcAddress(Lib, 'glGenTransformFeedbacksNV'));
  glGenVertexArrays:=TglGenVertexArrays(GLGetProcAddr('glGenVertexArrays'));
  if not Assigned(glGenVertexArrays) then 
    glGenVertexArrays:=TglGenVertexArrays(GetProcAddress(Lib, 'glGenVertexArrays'));
  glGenVertexArraysAPPLE:=TglGenVertexArraysAPPLE(GLGetProcAddr('glGenVertexArraysAPPLE'));
  if not Assigned(glGenVertexArraysAPPLE) then 
    glGenVertexArraysAPPLE:=TglGenVertexArraysAPPLE(GetProcAddress(Lib, 'glGenVertexArraysAPPLE'));
  glGenVertexArraysOES:=TglGenVertexArraysOES(GLGetProcAddr('glGenVertexArraysOES'));
  if not Assigned(glGenVertexArraysOES) then 
    glGenVertexArraysOES:=TglGenVertexArraysOES(GetProcAddress(Lib, 'glGenVertexArraysOES'));
  glGenVertexShadersEXT:=TglGenVertexShadersEXT(GLGetProcAddr('glGenVertexShadersEXT'));
  if not Assigned(glGenVertexShadersEXT) then 
    glGenVertexShadersEXT:=TglGenVertexShadersEXT(GetProcAddress(Lib, 'glGenVertexShadersEXT'));
  glGenerateMipmap:=TglGenerateMipmap(GLGetProcAddr('glGenerateMipmap'));
  if not Assigned(glGenerateMipmap) then 
    glGenerateMipmap:=TglGenerateMipmap(GetProcAddress(Lib, 'glGenerateMipmap'));
  glGenerateMipmapEXT:=TglGenerateMipmapEXT(GLGetProcAddr('glGenerateMipmapEXT'));
  if not Assigned(glGenerateMipmapEXT) then 
    glGenerateMipmapEXT:=TglGenerateMipmapEXT(GetProcAddress(Lib, 'glGenerateMipmapEXT'));
  glGenerateMipmapOES:=TglGenerateMipmapOES(GLGetProcAddr('glGenerateMipmapOES'));
  if not Assigned(glGenerateMipmapOES) then 
    glGenerateMipmapOES:=TglGenerateMipmapOES(GetProcAddress(Lib, 'glGenerateMipmapOES'));
  glGenerateMultiTexMipmapEXT:=TglGenerateMultiTexMipmapEXT(GLGetProcAddr('glGenerateMultiTexMipmapEXT'));
  if not Assigned(glGenerateMultiTexMipmapEXT) then 
    glGenerateMultiTexMipmapEXT:=TglGenerateMultiTexMipmapEXT(GetProcAddress(Lib, 'glGenerateMultiTexMipmapEXT'));
  glGenerateTextureMipmap:=TglGenerateTextureMipmap(GLGetProcAddr('glGenerateTextureMipmap'));
  if not Assigned(glGenerateTextureMipmap) then 
    glGenerateTextureMipmap:=TglGenerateTextureMipmap(GetProcAddress(Lib, 'glGenerateTextureMipmap'));
  glGenerateTextureMipmapEXT:=TglGenerateTextureMipmapEXT(GLGetProcAddr('glGenerateTextureMipmapEXT'));
  if not Assigned(glGenerateTextureMipmapEXT) then 
    glGenerateTextureMipmapEXT:=TglGenerateTextureMipmapEXT(GetProcAddress(Lib, 'glGenerateTextureMipmapEXT'));
  glGetActiveAtomicCounterBufferiv:=TglGetActiveAtomicCounterBufferiv(GLGetProcAddr('glGetActiveAtomicCounterBufferiv'));
  if not Assigned(glGetActiveAtomicCounterBufferiv) then 
    glGetActiveAtomicCounterBufferiv:=TglGetActiveAtomicCounterBufferiv(GetProcAddress(Lib, 'glGetActiveAtomicCounterBufferiv'));
  glGetActiveAttrib:=TglGetActiveAttrib(GLGetProcAddr('glGetActiveAttrib'));
  if not Assigned(glGetActiveAttrib) then
    glGetActiveAttrib:=TglGetActiveAttrib(GetProcAddress(Lib, 'glGetActiveAttrib'));
  glGetActiveAttribARB:=TglGetActiveAttribARB(GLGetProcAddr('glGetActiveAttribARB'));
  if not Assigned(glGetActiveAttribARB) then 
    glGetActiveAttribARB:=TglGetActiveAttribARB(GetProcAddress(Lib, 'glGetActiveAttribARB'));
  glGetActiveSubroutineName:=TglGetActiveSubroutineName(GLGetProcAddr('glGetActiveSubroutineName'));
  if not Assigned(glGetActiveSubroutineName) then 
    glGetActiveSubroutineName:=TglGetActiveSubroutineName(GetProcAddress(Lib, 'glGetActiveSubroutineName'));
  glGetActiveSubroutineUniformName:=TglGetActiveSubroutineUniformName(GLGetProcAddr('glGetActiveSubroutineUniformName'));
  if not Assigned(glGetActiveSubroutineUniformName) then 
    glGetActiveSubroutineUniformName:=TglGetActiveSubroutineUniformName(GetProcAddress(Lib, 'glGetActiveSubroutineUniformName'));
  glGetActiveSubroutineUniformiv:=TglGetActiveSubroutineUniformiv(GLGetProcAddr('glGetActiveSubroutineUniformiv'));
  if not Assigned(glGetActiveSubroutineUniformiv) then 
    glGetActiveSubroutineUniformiv:=TglGetActiveSubroutineUniformiv(GetProcAddress(Lib, 'glGetActiveSubroutineUniformiv'));
  glGetActiveUniform:=TglGetActiveUniform(GLGetProcAddr('glGetActiveUniform'));
  if not Assigned(glGetActiveUniform) then 
    glGetActiveUniform:=TglGetActiveUniform(GetProcAddress(Lib, 'glGetActiveUniform'));
  glGetActiveUniformARB:=TglGetActiveUniformARB(GLGetProcAddr('glGetActiveUniformARB'));
  if not Assigned(glGetActiveUniformARB) then
    glGetActiveUniformARB:=TglGetActiveUniformARB(GetProcAddress(Lib, 'glGetActiveUniformARB'));
  glGetActiveUniformBlockName:=TglGetActiveUniformBlockName(GLGetProcAddr('glGetActiveUniformBlockName'));
  if not Assigned(glGetActiveUniformBlockName) then 
    glGetActiveUniformBlockName:=TglGetActiveUniformBlockName(GetProcAddress(Lib, 'glGetActiveUniformBlockName'));
  glGetActiveUniformBlockiv:=TglGetActiveUniformBlockiv(GLGetProcAddr('glGetActiveUniformBlockiv'));
  if not Assigned(glGetActiveUniformBlockiv) then 
    glGetActiveUniformBlockiv:=TglGetActiveUniformBlockiv(GetProcAddress(Lib, 'glGetActiveUniformBlockiv'));
  glGetActiveUniformName:=TglGetActiveUniformName(GLGetProcAddr('glGetActiveUniformName'));
  if not Assigned(glGetActiveUniformName) then 
    glGetActiveUniformName:=TglGetActiveUniformName(GetProcAddress(Lib, 'glGetActiveUniformName'));
  glGetActiveUniformsiv:=TglGetActiveUniformsiv(GLGetProcAddr('glGetActiveUniformsiv'));
  if not Assigned(glGetActiveUniformsiv) then 
    glGetActiveUniformsiv:=TglGetActiveUniformsiv(GetProcAddress(Lib, 'glGetActiveUniformsiv'));
  glGetActiveVaryingNV:=TglGetActiveVaryingNV(GLGetProcAddr('glGetActiveVaryingNV'));
  if not Assigned(glGetActiveVaryingNV) then 
    glGetActiveVaryingNV:=TglGetActiveVaryingNV(GetProcAddress(Lib, 'glGetActiveVaryingNV'));
  glGetArrayObjectfvATI:=TglGetArrayObjectfvATI(GLGetProcAddr('glGetArrayObjectfvATI'));
  if not Assigned(glGetArrayObjectfvATI) then 
    glGetArrayObjectfvATI:=TglGetArrayObjectfvATI(GetProcAddress(Lib, 'glGetArrayObjectfvATI'));
  glGetArrayObjectivATI:=TglGetArrayObjectivATI(GLGetProcAddr('glGetArrayObjectivATI'));
  if not Assigned(glGetArrayObjectivATI) then 
    glGetArrayObjectivATI:=TglGetArrayObjectivATI(GetProcAddress(Lib, 'glGetArrayObjectivATI'));
  glGetAttachedObjectsARB:=TglGetAttachedObjectsARB(GLGetProcAddr('glGetAttachedObjectsARB'));
  if not Assigned(glGetAttachedObjectsARB) then 
    glGetAttachedObjectsARB:=TglGetAttachedObjectsARB(GetProcAddress(Lib, 'glGetAttachedObjectsARB'));
  glGetAttachedShaders:=TglGetAttachedShaders(GLGetProcAddr('glGetAttachedShaders'));
  if not Assigned(glGetAttachedShaders) then 
    glGetAttachedShaders:=TglGetAttachedShaders(GetProcAddress(Lib, 'glGetAttachedShaders'));
  glGetAttribLocation:=TglGetAttribLocation(GLGetProcAddr('glGetAttribLocation'));
  if not Assigned(glGetAttribLocation) then 
    glGetAttribLocation:=TglGetAttribLocation(GetProcAddress(Lib, 'glGetAttribLocation'));
  glGetAttribLocationARB:=TglGetAttribLocationARB(GLGetProcAddr('glGetAttribLocationARB'));
  if not Assigned(glGetAttribLocationARB) then 
    glGetAttribLocationARB:=TglGetAttribLocationARB(GetProcAddress(Lib, 'glGetAttribLocationARB'));
  glGetBooleanIndexedvEXT:=TglGetBooleanIndexedvEXT(GLGetProcAddr('glGetBooleanIndexedvEXT'));
  if not Assigned(glGetBooleanIndexedvEXT) then 
    glGetBooleanIndexedvEXT:=TglGetBooleanIndexedvEXT(GetProcAddress(Lib, 'glGetBooleanIndexedvEXT'));
  glGetBooleani_v:=TglGetBooleani_v(GLGetProcAddr('glGetBooleani_v'));
  if not Assigned(glGetBooleani_v) then
    glGetBooleani_v:=TglGetBooleani_v(GetProcAddress(Lib, 'glGetBooleani_v'));
  glGetBooleanv:=TglGetBooleanv(GLGetProcAddr('glGetBooleanv'));
  if not Assigned(glGetBooleanv) then 
    glGetBooleanv:=TglGetBooleanv(GetProcAddress(Lib, 'glGetBooleanv'));
  glGetBufferParameteri64v:=TglGetBufferParameteri64v(GLGetProcAddr('glGetBufferParameteri64v'));
  if not Assigned(glGetBufferParameteri64v) then 
    glGetBufferParameteri64v:=TglGetBufferParameteri64v(GetProcAddress(Lib, 'glGetBufferParameteri64v'));
  glGetBufferParameteriv:=TglGetBufferParameteriv(GLGetProcAddr('glGetBufferParameteriv'));
  if not Assigned(glGetBufferParameteriv) then 
    glGetBufferParameteriv:=TglGetBufferParameteriv(GetProcAddress(Lib, 'glGetBufferParameteriv'));
  glGetBufferParameterivARB:=TglGetBufferParameterivARB(GLGetProcAddr('glGetBufferParameterivARB'));
  if not Assigned(glGetBufferParameterivARB) then 
    glGetBufferParameterivARB:=TglGetBufferParameterivARB(GetProcAddress(Lib, 'glGetBufferParameterivARB'));
  glGetBufferParameterui64vNV:=TglGetBufferParameterui64vNV(GLGetProcAddr('glGetBufferParameterui64vNV'));
  if not Assigned(glGetBufferParameterui64vNV) then 
    glGetBufferParameterui64vNV:=TglGetBufferParameterui64vNV(GetProcAddress(Lib, 'glGetBufferParameterui64vNV'));
  glGetBufferPointerv:=TglGetBufferPointerv(GLGetProcAddr('glGetBufferPointerv'));
  if not Assigned(glGetBufferPointerv) then 
    glGetBufferPointerv:=TglGetBufferPointerv(GetProcAddress(Lib, 'glGetBufferPointerv'));
  glGetBufferPointervARB:=TglGetBufferPointervARB(GLGetProcAddr('glGetBufferPointervARB'));
  if not Assigned(glGetBufferPointervARB) then 
    glGetBufferPointervARB:=TglGetBufferPointervARB(GetProcAddress(Lib, 'glGetBufferPointervARB'));
  glGetBufferPointervOES:=TglGetBufferPointervOES(GLGetProcAddr('glGetBufferPointervOES'));
  if not Assigned(glGetBufferPointervOES) then 
    glGetBufferPointervOES:=TglGetBufferPointervOES(GetProcAddress(Lib, 'glGetBufferPointervOES'));
  glGetBufferSubData:=TglGetBufferSubData(GLGetProcAddr('glGetBufferSubData'));
  if not Assigned(glGetBufferSubData) then 
    glGetBufferSubData:=TglGetBufferSubData(GetProcAddress(Lib, 'glGetBufferSubData'));
  glGetBufferSubDataARB:=TglGetBufferSubDataARB(GLGetProcAddr('glGetBufferSubDataARB'));
  if not Assigned(glGetBufferSubDataARB) then 
    glGetBufferSubDataARB:=TglGetBufferSubDataARB(GetProcAddress(Lib, 'glGetBufferSubDataARB'));
  glGetClipPlane:=TglGetClipPlane(GLGetProcAddr('glGetClipPlane'));
  if not Assigned(glGetClipPlane) then 
    glGetClipPlane:=TglGetClipPlane(GetProcAddress(Lib, 'glGetClipPlane'));
  glGetClipPlanef:=TglGetClipPlanef(GLGetProcAddr('glGetClipPlanef'));
  if not Assigned(glGetClipPlanef) then 
    glGetClipPlanef:=TglGetClipPlanef(GetProcAddress(Lib, 'glGetClipPlanef'));
  glGetClipPlanefOES:=TglGetClipPlanefOES(GLGetProcAddr('glGetClipPlanefOES'));
  if not Assigned(glGetClipPlanefOES) then
    glGetClipPlanefOES:=TglGetClipPlanefOES(GetProcAddress(Lib, 'glGetClipPlanefOES'));
  glGetClipPlanex:=TglGetClipPlanex(GLGetProcAddr('glGetClipPlanex'));
  if not Assigned(glGetClipPlanex) then 
    glGetClipPlanex:=TglGetClipPlanex(GetProcAddress(Lib, 'glGetClipPlanex'));
  glGetClipPlanexOES:=TglGetClipPlanexOES(GLGetProcAddr('glGetClipPlanexOES'));
  if not Assigned(glGetClipPlanexOES) then 
    glGetClipPlanexOES:=TglGetClipPlanexOES(GetProcAddress(Lib, 'glGetClipPlanexOES'));
  glGetColorTable:=TglGetColorTable(GLGetProcAddr('glGetColorTable'));
  if not Assigned(glGetColorTable) then 
    glGetColorTable:=TglGetColorTable(GetProcAddress(Lib, 'glGetColorTable'));
  glGetColorTableEXT:=TglGetColorTableEXT(GLGetProcAddr('glGetColorTableEXT'));
  if not Assigned(glGetColorTableEXT) then 
    glGetColorTableEXT:=TglGetColorTableEXT(GetProcAddress(Lib, 'glGetColorTableEXT'));
  glGetColorTableParameterfv:=TglGetColorTableParameterfv(GLGetProcAddr('glGetColorTableParameterfv'));
  if not Assigned(glGetColorTableParameterfv) then 
    glGetColorTableParameterfv:=TglGetColorTableParameterfv(GetProcAddress(Lib, 'glGetColorTableParameterfv'));
  glGetColorTableParameterfvEXT:=TglGetColorTableParameterfvEXT(GLGetProcAddr('glGetColorTableParameterfvEXT'));
  if not Assigned(glGetColorTableParameterfvEXT) then
    glGetColorTableParameterfvEXT:=TglGetColorTableParameterfvEXT(GetProcAddress(Lib, 'glGetColorTableParameterfvEXT'));
  glGetColorTableParameterfvSGI:=TglGetColorTableParameterfvSGI(GLGetProcAddr('glGetColorTableParameterfvSGI'));
  if not Assigned(glGetColorTableParameterfvSGI) then 
    glGetColorTableParameterfvSGI:=TglGetColorTableParameterfvSGI(GetProcAddress(Lib, 'glGetColorTableParameterfvSGI'));
  glGetColorTableParameteriv:=TglGetColorTableParameteriv(GLGetProcAddr('glGetColorTableParameteriv'));
  if not Assigned(glGetColorTableParameteriv) then 
    glGetColorTableParameteriv:=TglGetColorTableParameteriv(GetProcAddress(Lib, 'glGetColorTableParameteriv'));
  glGetColorTableParameterivEXT:=TglGetColorTableParameterivEXT(GLGetProcAddr('glGetColorTableParameterivEXT'));
  if not Assigned(glGetColorTableParameterivEXT) then 
    glGetColorTableParameterivEXT:=TglGetColorTableParameterivEXT(GetProcAddress(Lib, 'glGetColorTableParameterivEXT'));
  glGetColorTableParameterivSGI:=TglGetColorTableParameterivSGI(GLGetProcAddr('glGetColorTableParameterivSGI'));
  if not Assigned(glGetColorTableParameterivSGI) then 
    glGetColorTableParameterivSGI:=TglGetColorTableParameterivSGI(GetProcAddress(Lib, 'glGetColorTableParameterivSGI'));
  glGetColorTableSGI:=TglGetColorTableSGI(GLGetProcAddr('glGetColorTableSGI'));
  if not Assigned(glGetColorTableSGI) then 
    glGetColorTableSGI:=TglGetColorTableSGI(GetProcAddress(Lib, 'glGetColorTableSGI'));
  glGetCombinerInputParameterfvNV:=TglGetCombinerInputParameterfvNV(GLGetProcAddr('glGetCombinerInputParameterfvNV'));
  if not Assigned(glGetCombinerInputParameterfvNV) then 
    glGetCombinerInputParameterfvNV:=TglGetCombinerInputParameterfvNV(GetProcAddress(Lib, 'glGetCombinerInputParameterfvNV'));
  glGetCombinerInputParameterivNV:=TglGetCombinerInputParameterivNV(GLGetProcAddr('glGetCombinerInputParameterivNV'));
  if not Assigned(glGetCombinerInputParameterivNV) then 
    glGetCombinerInputParameterivNV:=TglGetCombinerInputParameterivNV(GetProcAddress(Lib, 'glGetCombinerInputParameterivNV'));
  glGetCombinerOutputParameterfvNV:=TglGetCombinerOutputParameterfvNV(GLGetProcAddr('glGetCombinerOutputParameterfvNV'));
  if not Assigned(glGetCombinerOutputParameterfvNV) then 
    glGetCombinerOutputParameterfvNV:=TglGetCombinerOutputParameterfvNV(GetProcAddress(Lib, 'glGetCombinerOutputParameterfvNV'));
  glGetCombinerOutputParameterivNV:=TglGetCombinerOutputParameterivNV(GLGetProcAddr('glGetCombinerOutputParameterivNV'));
  if not Assigned(glGetCombinerOutputParameterivNV) then 
    glGetCombinerOutputParameterivNV:=TglGetCombinerOutputParameterivNV(GetProcAddress(Lib, 'glGetCombinerOutputParameterivNV'));
  glGetCombinerStageParameterfvNV:=TglGetCombinerStageParameterfvNV(GLGetProcAddr('glGetCombinerStageParameterfvNV'));
  if not Assigned(glGetCombinerStageParameterfvNV) then 
    glGetCombinerStageParameterfvNV:=TglGetCombinerStageParameterfvNV(GetProcAddress(Lib, 'glGetCombinerStageParameterfvNV'));
  glGetCommandHeaderNV:=TglGetCommandHeaderNV(GLGetProcAddr('glGetCommandHeaderNV'));
  if not Assigned(glGetCommandHeaderNV) then 
    glGetCommandHeaderNV:=TglGetCommandHeaderNV(GetProcAddress(Lib, 'glGetCommandHeaderNV'));
  glGetCompressedMultiTexImageEXT:=TglGetCompressedMultiTexImageEXT(GLGetProcAddr('glGetCompressedMultiTexImageEXT'));
  if not Assigned(glGetCompressedMultiTexImageEXT) then 
    glGetCompressedMultiTexImageEXT:=TglGetCompressedMultiTexImageEXT(GetProcAddress(Lib, 'glGetCompressedMultiTexImageEXT'));
  glGetCompressedTexImage:=TglGetCompressedTexImage(GLGetProcAddr('glGetCompressedTexImage'));
  if not Assigned(glGetCompressedTexImage) then 
    glGetCompressedTexImage:=TglGetCompressedTexImage(GetProcAddress(Lib, 'glGetCompressedTexImage'));
  glGetCompressedTexImageARB:=TglGetCompressedTexImageARB(GLGetProcAddr('glGetCompressedTexImageARB'));
  if not Assigned(glGetCompressedTexImageARB) then 
    glGetCompressedTexImageARB:=TglGetCompressedTexImageARB(GetProcAddress(Lib, 'glGetCompressedTexImageARB'));
  glGetCompressedTextureImage:=TglGetCompressedTextureImage(GLGetProcAddr('glGetCompressedTextureImage'));
  if not Assigned(glGetCompressedTextureImage) then 
    glGetCompressedTextureImage:=TglGetCompressedTextureImage(GetProcAddress(Lib, 'glGetCompressedTextureImage'));
  glGetCompressedTextureImageEXT:=TglGetCompressedTextureImageEXT(GLGetProcAddr('glGetCompressedTextureImageEXT'));
  if not Assigned(glGetCompressedTextureImageEXT) then 
    glGetCompressedTextureImageEXT:=TglGetCompressedTextureImageEXT(GetProcAddress(Lib, 'glGetCompressedTextureImageEXT'));
  glGetCompressedTextureSubImage:=TglGetCompressedTextureSubImage(GLGetProcAddr('glGetCompressedTextureSubImage'));
  if not Assigned(glGetCompressedTextureSubImage) then 
    glGetCompressedTextureSubImage:=TglGetCompressedTextureSubImage(GetProcAddress(Lib, 'glGetCompressedTextureSubImage'));
  glGetConvolutionFilter:=TglGetConvolutionFilter(GLGetProcAddr('glGetConvolutionFilter'));
  if not Assigned(glGetConvolutionFilter) then 
    glGetConvolutionFilter:=TglGetConvolutionFilter(GetProcAddress(Lib, 'glGetConvolutionFilter'));
  glGetConvolutionFilterEXT:=TglGetConvolutionFilterEXT(GLGetProcAddr('glGetConvolutionFilterEXT'));
  if not Assigned(glGetConvolutionFilterEXT) then
    glGetConvolutionFilterEXT:=TglGetConvolutionFilterEXT(GetProcAddress(Lib, 'glGetConvolutionFilterEXT'));
  glGetConvolutionParameterfv:=TglGetConvolutionParameterfv(GLGetProcAddr('glGetConvolutionParameterfv'));
  if not Assigned(glGetConvolutionParameterfv) then
    glGetConvolutionParameterfv:=TglGetConvolutionParameterfv(GetProcAddress(Lib, 'glGetConvolutionParameterfv'));
  glGetConvolutionParameterfvEXT:=TglGetConvolutionParameterfvEXT(GLGetProcAddr('glGetConvolutionParameterfvEXT'));
  if not Assigned(glGetConvolutionParameterfvEXT) then 
    glGetConvolutionParameterfvEXT:=TglGetConvolutionParameterfvEXT(GetProcAddress(Lib, 'glGetConvolutionParameterfvEXT'));
  glGetConvolutionParameteriv:=TglGetConvolutionParameteriv(GLGetProcAddr('glGetConvolutionParameteriv'));
  if not Assigned(glGetConvolutionParameteriv) then 
    glGetConvolutionParameteriv:=TglGetConvolutionParameteriv(GetProcAddress(Lib, 'glGetConvolutionParameteriv'));
  glGetConvolutionParameterivEXT:=TglGetConvolutionParameterivEXT(GLGetProcAddr('glGetConvolutionParameterivEXT'));
  if not Assigned(glGetConvolutionParameterivEXT) then 
    glGetConvolutionParameterivEXT:=TglGetConvolutionParameterivEXT(GetProcAddress(Lib, 'glGetConvolutionParameterivEXT'));
  glGetConvolutionParameterxvOES:=TglGetConvolutionParameterxvOES(GLGetProcAddr('glGetConvolutionParameterxvOES'));
  if not Assigned(glGetConvolutionParameterxvOES) then 
    glGetConvolutionParameterxvOES:=TglGetConvolutionParameterxvOES(GetProcAddress(Lib, 'glGetConvolutionParameterxvOES'));
  glGetCoverageModulationTableNV:=TglGetCoverageModulationTableNV(GLGetProcAddr('glGetCoverageModulationTableNV'));
  if not Assigned(glGetCoverageModulationTableNV) then 
    glGetCoverageModulationTableNV:=TglGetCoverageModulationTableNV(GetProcAddress(Lib, 'glGetCoverageModulationTableNV'));
  glGetDebugMessageLog:=TglGetDebugMessageLog(GLGetProcAddr('glGetDebugMessageLog'));
  if not Assigned(glGetDebugMessageLog) then 
    glGetDebugMessageLog:=TglGetDebugMessageLog(GetProcAddress(Lib, 'glGetDebugMessageLog'));
  glGetDebugMessageLogAMD:=TglGetDebugMessageLogAMD(GLGetProcAddr('glGetDebugMessageLogAMD'));
  if not Assigned(glGetDebugMessageLogAMD) then 
    glGetDebugMessageLogAMD:=TglGetDebugMessageLogAMD(GetProcAddress(Lib, 'glGetDebugMessageLogAMD'));
  glGetDebugMessageLogARB:=TglGetDebugMessageLogARB(GLGetProcAddr('glGetDebugMessageLogARB'));
  if not Assigned(glGetDebugMessageLogARB) then 
    glGetDebugMessageLogARB:=TglGetDebugMessageLogARB(GetProcAddress(Lib, 'glGetDebugMessageLogARB'));
  glGetDebugMessageLogKHR:=TglGetDebugMessageLogKHR(GLGetProcAddr('glGetDebugMessageLogKHR'));
  if not Assigned(glGetDebugMessageLogKHR) then 
    glGetDebugMessageLogKHR:=TglGetDebugMessageLogKHR(GetProcAddress(Lib, 'glGetDebugMessageLogKHR'));
  glGetDetailTexFuncSGIS:=TglGetDetailTexFuncSGIS(GLGetProcAddr('glGetDetailTexFuncSGIS'));
  if not Assigned(glGetDetailTexFuncSGIS) then 
    glGetDetailTexFuncSGIS:=TglGetDetailTexFuncSGIS(GetProcAddress(Lib, 'glGetDetailTexFuncSGIS'));
  glGetDoubleIndexedvEXT:=TglGetDoubleIndexedvEXT(GLGetProcAddr('glGetDoubleIndexedvEXT'));
  if not Assigned(glGetDoubleIndexedvEXT) then 
    glGetDoubleIndexedvEXT:=TglGetDoubleIndexedvEXT(GetProcAddress(Lib, 'glGetDoubleIndexedvEXT'));
  glGetDoublei_v:=TglGetDoublei_v(GLGetProcAddr('glGetDoublei_v'));
  if not Assigned(glGetDoublei_v) then 
    glGetDoublei_v:=TglGetDoublei_v(GetProcAddress(Lib, 'glGetDoublei_v'));
  glGetDoublei_vEXT:=TglGetDoublei_vEXT(GLGetProcAddr('glGetDoublei_vEXT'));
  if not Assigned(glGetDoublei_vEXT) then 
    glGetDoublei_vEXT:=TglGetDoublei_vEXT(GetProcAddress(Lib, 'glGetDoublei_vEXT'));
  glGetDoublev:=TglGetDoublev(GLGetProcAddr('glGetDoublev'));
  if not Assigned(glGetDoublev) then 
    glGetDoublev:=TglGetDoublev(GetProcAddress(Lib, 'glGetDoublev'));
  glGetDriverControlStringQCOM:=TglGetDriverControlStringQCOM(GLGetProcAddr('glGetDriverControlStringQCOM'));
  if not Assigned(glGetDriverControlStringQCOM) then 
    glGetDriverControlStringQCOM:=TglGetDriverControlStringQCOM(GetProcAddress(Lib, 'glGetDriverControlStringQCOM'));
  glGetDriverControlsQCOM:=TglGetDriverControlsQCOM(GLGetProcAddr('glGetDriverControlsQCOM'));
  if not Assigned(glGetDriverControlsQCOM) then 
    glGetDriverControlsQCOM:=TglGetDriverControlsQCOM(GetProcAddress(Lib, 'glGetDriverControlsQCOM'));
  glGetError:=TglGetError(GLGetProcAddr('glGetError'));
  if not Assigned(glGetError) then 
    glGetError:=TglGetError(GetProcAddress(Lib, 'glGetError'));
  glGetFenceivNV:=TglGetFenceivNV(GLGetProcAddr('glGetFenceivNV'));
  if not Assigned(glGetFenceivNV) then
    glGetFenceivNV:=TglGetFenceivNV(GetProcAddress(Lib, 'glGetFenceivNV'));
  glGetFinalCombinerInputParameterfvNV:=TglGetFinalCombinerInputParameterfvNV(GLGetProcAddr('glGetFinalCombinerInputParameterfvNV'));
  if not Assigned(glGetFinalCombinerInputParameterfvNV) then 
    glGetFinalCombinerInputParameterfvNV:=TglGetFinalCombinerInputParameterfvNV(GetProcAddress(Lib, 'glGetFinalCombinerInputParameterfvNV'));
  glGetFinalCombinerInputParameterivNV:=TglGetFinalCombinerInputParameterivNV(GLGetProcAddr('glGetFinalCombinerInputParameterivNV'));
  if not Assigned(glGetFinalCombinerInputParameterivNV) then 
    glGetFinalCombinerInputParameterivNV:=TglGetFinalCombinerInputParameterivNV(GetProcAddress(Lib, 'glGetFinalCombinerInputParameterivNV'));
  glGetFirstPerfQueryIdINTEL:=TglGetFirstPerfQueryIdINTEL(GLGetProcAddr('glGetFirstPerfQueryIdINTEL'));
  if not Assigned(glGetFirstPerfQueryIdINTEL) then 
    glGetFirstPerfQueryIdINTEL:=TglGetFirstPerfQueryIdINTEL(GetProcAddress(Lib, 'glGetFirstPerfQueryIdINTEL'));
  glGetFixedv:=TglGetFixedv(GLGetProcAddr('glGetFixedv'));
  if not Assigned(glGetFixedv) then 
    glGetFixedv:=TglGetFixedv(GetProcAddress(Lib, 'glGetFixedv'));
  glGetFixedvOES:=TglGetFixedvOES(GLGetProcAddr('glGetFixedvOES'));
  if not Assigned(glGetFixedvOES) then 
    glGetFixedvOES:=TglGetFixedvOES(GetProcAddress(Lib, 'glGetFixedvOES'));
  glGetFloatIndexedvEXT:=TglGetFloatIndexedvEXT(GLGetProcAddr('glGetFloatIndexedvEXT'));
  if not Assigned(glGetFloatIndexedvEXT) then 
    glGetFloatIndexedvEXT:=TglGetFloatIndexedvEXT(GetProcAddress(Lib, 'glGetFloatIndexedvEXT'));
  glGetFloati_v:=TglGetFloati_v(GLGetProcAddr('glGetFloati_v'));
  if not Assigned(glGetFloati_v) then 
    glGetFloati_v:=TglGetFloati_v(GetProcAddress(Lib, 'glGetFloati_v'));
  glGetFloati_vEXT:=TglGetFloati_vEXT(GLGetProcAddr('glGetFloati_vEXT'));
  if not Assigned(glGetFloati_vEXT) then
    glGetFloati_vEXT:=TglGetFloati_vEXT(GetProcAddress(Lib, 'glGetFloati_vEXT'));
  glGetFloati_vNV:=TglGetFloati_vNV(GLGetProcAddr('glGetFloati_vNV'));
  if not Assigned(glGetFloati_vNV) then 
    glGetFloati_vNV:=TglGetFloati_vNV(GetProcAddress(Lib, 'glGetFloati_vNV'));
  glGetFloati_vOES:=TglGetFloati_vOES(GLGetProcAddr('glGetFloati_vOES'));
  if not Assigned(glGetFloati_vOES) then 
    glGetFloati_vOES:=TglGetFloati_vOES(GetProcAddress(Lib, 'glGetFloati_vOES'));
  glGetFloatv:=TglGetFloatv(GLGetProcAddr('glGetFloatv'));
  if not Assigned(glGetFloatv) then 
    glGetFloatv:=TglGetFloatv(GetProcAddress(Lib, 'glGetFloatv'));
  glGetFogFuncSGIS:=TglGetFogFuncSGIS(GLGetProcAddr('glGetFogFuncSGIS'));
  if not Assigned(glGetFogFuncSGIS) then 
    glGetFogFuncSGIS:=TglGetFogFuncSGIS(GetProcAddress(Lib, 'glGetFogFuncSGIS'));
  glGetFragDataIndex:=TglGetFragDataIndex(GLGetProcAddr('glGetFragDataIndex'));
  if not Assigned(glGetFragDataIndex) then 
    glGetFragDataIndex:=TglGetFragDataIndex(GetProcAddress(Lib, 'glGetFragDataIndex'));
  glGetFragDataIndexEXT:=TglGetFragDataIndexEXT(GLGetProcAddr('glGetFragDataIndexEXT'));
  if not Assigned(glGetFragDataIndexEXT) then 
    glGetFragDataIndexEXT:=TglGetFragDataIndexEXT(GetProcAddress(Lib, 'glGetFragDataIndexEXT'));
  glGetFragDataLocation:=TglGetFragDataLocation(GLGetProcAddr('glGetFragDataLocation'));
  if not Assigned(glGetFragDataLocation) then 
    glGetFragDataLocation:=TglGetFragDataLocation(GetProcAddress(Lib, 'glGetFragDataLocation'));
  glGetFragDataLocationEXT:=TglGetFragDataLocationEXT(GLGetProcAddr('glGetFragDataLocationEXT'));
  if not Assigned(glGetFragDataLocationEXT) then 
    glGetFragDataLocationEXT:=TglGetFragDataLocationEXT(GetProcAddress(Lib, 'glGetFragDataLocationEXT'));
  glGetFragmentLightfvSGIX:=TglGetFragmentLightfvSGIX(GLGetProcAddr('glGetFragmentLightfvSGIX'));
  if not Assigned(glGetFragmentLightfvSGIX) then 
    glGetFragmentLightfvSGIX:=TglGetFragmentLightfvSGIX(GetProcAddress(Lib, 'glGetFragmentLightfvSGIX'));
  glGetFragmentLightivSGIX:=TglGetFragmentLightivSGIX(GLGetProcAddr('glGetFragmentLightivSGIX'));
  if not Assigned(glGetFragmentLightivSGIX) then 
    glGetFragmentLightivSGIX:=TglGetFragmentLightivSGIX(GetProcAddress(Lib, 'glGetFragmentLightivSGIX'));
  glGetFragmentMaterialfvSGIX:=TglGetFragmentMaterialfvSGIX(GLGetProcAddr('glGetFragmentMaterialfvSGIX'));
  if not Assigned(glGetFragmentMaterialfvSGIX) then
    glGetFragmentMaterialfvSGIX:=TglGetFragmentMaterialfvSGIX(GetProcAddress(Lib, 'glGetFragmentMaterialfvSGIX'));
  glGetFragmentMaterialivSGIX:=TglGetFragmentMaterialivSGIX(GLGetProcAddr('glGetFragmentMaterialivSGIX'));
  if not Assigned(glGetFragmentMaterialivSGIX) then 
    glGetFragmentMaterialivSGIX:=TglGetFragmentMaterialivSGIX(GetProcAddress(Lib, 'glGetFragmentMaterialivSGIX'));
  glGetFramebufferAttachmentParameteriv:=TglGetFramebufferAttachmentParameteriv(GLGetProcAddr('glGetFramebufferAttachmentParameteriv'));
  if not Assigned(glGetFramebufferAttachmentParameteriv) then 
    glGetFramebufferAttachmentParameteriv:=TglGetFramebufferAttachmentParameteriv(GetProcAddress(Lib, 'glGetFramebufferAttachmentParameteriv'));
  glGetFramebufferAttachmentParameterivEXT:=TglGetFramebufferAttachmentParameterivEXT(GLGetProcAddr('glGetFramebufferAttachmentParameterivEXT'));
  if not Assigned(glGetFramebufferAttachmentParameterivEXT) then 
    glGetFramebufferAttachmentParameterivEXT:=TglGetFramebufferAttachmentParameterivEXT(GetProcAddress(Lib, 'glGetFramebufferAttachmentParameterivEXT'));
  glGetFramebufferAttachmentParameterivOES:=TglGetFramebufferAttachmentParameterivOES(GLGetProcAddr('glGetFramebufferAttachmentParameterivOES'));
  if not Assigned(glGetFramebufferAttachmentParameterivOES) then 
    glGetFramebufferAttachmentParameterivOES:=TglGetFramebufferAttachmentParameterivOES(GetProcAddress(Lib, 'glGetFramebufferAttachmentParameterivOES'));
  glGetFramebufferParameterfvAMD:=TglGetFramebufferParameterfvAMD(GLGetProcAddr('glGetFramebufferParameterfvAMD'));
  if not Assigned(glGetFramebufferParameterfvAMD) then 
    glGetFramebufferParameterfvAMD:=TglGetFramebufferParameterfvAMD(GetProcAddress(Lib, 'glGetFramebufferParameterfvAMD'));
  glGetFramebufferParameteriv:=TglGetFramebufferParameteriv(GLGetProcAddr('glGetFramebufferParameteriv'));
  if not Assigned(glGetFramebufferParameteriv) then 
    glGetFramebufferParameteriv:=TglGetFramebufferParameteriv(GetProcAddress(Lib, 'glGetFramebufferParameteriv'));
  glGetFramebufferParameterivEXT:=TglGetFramebufferParameterivEXT(GLGetProcAddr('glGetFramebufferParameterivEXT'));
  if not Assigned(glGetFramebufferParameterivEXT) then 
    glGetFramebufferParameterivEXT:=TglGetFramebufferParameterivEXT(GetProcAddress(Lib, 'glGetFramebufferParameterivEXT'));
  glGetFramebufferPixelLocalStorageSizeEXT:=TglGetFramebufferPixelLocalStorageSizeEXT(GLGetProcAddr('glGetFramebufferPixelLocalStorageSizeEXT'));
  if not Assigned(glGetFramebufferPixelLocalStorageSizeEXT) then 
    glGetFramebufferPixelLocalStorageSizeEXT:=TglGetFramebufferPixelLocalStorageSizeEXT(GetProcAddress(Lib, 'glGetFramebufferPixelLocalStorageSizeEXT'));
  glGetGraphicsResetStatus:=TglGetGraphicsResetStatus(GLGetProcAddr('glGetGraphicsResetStatus'));
  if not Assigned(glGetGraphicsResetStatus) then 
    glGetGraphicsResetStatus:=TglGetGraphicsResetStatus(GetProcAddress(Lib, 'glGetGraphicsResetStatus'));
  glGetGraphicsResetStatusARB:=TglGetGraphicsResetStatusARB(GLGetProcAddr('glGetGraphicsResetStatusARB'));
  if not Assigned(glGetGraphicsResetStatusARB) then 
    glGetGraphicsResetStatusARB:=TglGetGraphicsResetStatusARB(GetProcAddress(Lib, 'glGetGraphicsResetStatusARB'));
  glGetGraphicsResetStatusEXT:=TglGetGraphicsResetStatusEXT(GLGetProcAddr('glGetGraphicsResetStatusEXT'));
  if not Assigned(glGetGraphicsResetStatusEXT) then 
    glGetGraphicsResetStatusEXT:=TglGetGraphicsResetStatusEXT(GetProcAddress(Lib, 'glGetGraphicsResetStatusEXT'));
  glGetGraphicsResetStatusKHR:=TglGetGraphicsResetStatusKHR(GLGetProcAddr('glGetGraphicsResetStatusKHR'));
  if not Assigned(glGetGraphicsResetStatusKHR) then 
    glGetGraphicsResetStatusKHR:=TglGetGraphicsResetStatusKHR(GetProcAddress(Lib, 'glGetGraphicsResetStatusKHR'));
  glGetHandleARB:=TglGetHandleARB(GLGetProcAddr('glGetHandleARB'));
  if not Assigned(glGetHandleARB) then
    glGetHandleARB:=TglGetHandleARB(GetProcAddress(Lib, 'glGetHandleARB'));
  glGetHistogram:=TglGetHistogram(GLGetProcAddr('glGetHistogram'));
  if not Assigned(glGetHistogram) then 
    glGetHistogram:=TglGetHistogram(GetProcAddress(Lib, 'glGetHistogram'));
  glGetHistogramEXT:=TglGetHistogramEXT(GLGetProcAddr('glGetHistogramEXT'));
  if not Assigned(glGetHistogramEXT) then
    glGetHistogramEXT:=TglGetHistogramEXT(GetProcAddress(Lib, 'glGetHistogramEXT'));
  glGetHistogramParameterfv:=TglGetHistogramParameterfv(GLGetProcAddr('glGetHistogramParameterfv'));
  if not Assigned(glGetHistogramParameterfv) then 
    glGetHistogramParameterfv:=TglGetHistogramParameterfv(GetProcAddress(Lib, 'glGetHistogramParameterfv'));
  glGetHistogramParameterfvEXT:=TglGetHistogramParameterfvEXT(GLGetProcAddr('glGetHistogramParameterfvEXT'));
  if not Assigned(glGetHistogramParameterfvEXT) then 
    glGetHistogramParameterfvEXT:=TglGetHistogramParameterfvEXT(GetProcAddress(Lib, 'glGetHistogramParameterfvEXT'));
  glGetHistogramParameteriv:=TglGetHistogramParameteriv(GLGetProcAddr('glGetHistogramParameteriv'));
  if not Assigned(glGetHistogramParameteriv) then 
    glGetHistogramParameteriv:=TglGetHistogramParameteriv(GetProcAddress(Lib, 'glGetHistogramParameteriv'));
  glGetHistogramParameterivEXT:=TglGetHistogramParameterivEXT(GLGetProcAddr('glGetHistogramParameterivEXT'));
  if not Assigned(glGetHistogramParameterivEXT) then 
    glGetHistogramParameterivEXT:=TglGetHistogramParameterivEXT(GetProcAddress(Lib, 'glGetHistogramParameterivEXT'));
  glGetHistogramParameterxvOES:=TglGetHistogramParameterxvOES(GLGetProcAddr('glGetHistogramParameterxvOES'));
  if not Assigned(glGetHistogramParameterxvOES) then
    glGetHistogramParameterxvOES:=TglGetHistogramParameterxvOES(GetProcAddress(Lib, 'glGetHistogramParameterxvOES'));
  glGetImageHandleARB:=TglGetImageHandleARB(GLGetProcAddr('glGetImageHandleARB'));
  if not Assigned(glGetImageHandleARB) then 
    glGetImageHandleARB:=TglGetImageHandleARB(GetProcAddress(Lib, 'glGetImageHandleARB'));
  glGetImageHandleNV:=TglGetImageHandleNV(GLGetProcAddr('glGetImageHandleNV'));
  if not Assigned(glGetImageHandleNV) then 
    glGetImageHandleNV:=TglGetImageHandleNV(GetProcAddress(Lib, 'glGetImageHandleNV'));
  glGetImageTransformParameterfvHP:=TglGetImageTransformParameterfvHP(GLGetProcAddr('glGetImageTransformParameterfvHP'));
  if not Assigned(glGetImageTransformParameterfvHP) then 
    glGetImageTransformParameterfvHP:=TglGetImageTransformParameterfvHP(GetProcAddress(Lib, 'glGetImageTransformParameterfvHP'));
  glGetImageTransformParameterivHP:=TglGetImageTransformParameterivHP(GLGetProcAddr('glGetImageTransformParameterivHP'));
  if not Assigned(glGetImageTransformParameterivHP) then
    glGetImageTransformParameterivHP:=TglGetImageTransformParameterivHP(GetProcAddress(Lib, 'glGetImageTransformParameterivHP'));
  glGetInfoLogARB:=TglGetInfoLogARB(GLGetProcAddr('glGetInfoLogARB'));
  if not Assigned(glGetInfoLogARB) then
    glGetInfoLogARB:=TglGetInfoLogARB(GetProcAddress(Lib, 'glGetInfoLogARB'));
  glGetInstrumentsSGIX:=TglGetInstrumentsSGIX(GLGetProcAddr('glGetInstrumentsSGIX'));
  if not Assigned(glGetInstrumentsSGIX) then
    glGetInstrumentsSGIX:=TglGetInstrumentsSGIX(GetProcAddress(Lib, 'glGetInstrumentsSGIX'));
  glGetInteger64i_v:=TglGetInteger64i_v(GLGetProcAddr('glGetInteger64i_v'));
  if not Assigned(glGetInteger64i_v) then
    glGetInteger64i_v:=TglGetInteger64i_v(GetProcAddress(Lib, 'glGetInteger64i_v'));
  glGetInteger64v:=TglGetInteger64v(GLGetProcAddr('glGetInteger64v'));
  if not Assigned(glGetInteger64v) then
    glGetInteger64v:=TglGetInteger64v(GetProcAddress(Lib, 'glGetInteger64v'));
  glGetInteger64vAPPLE:=TglGetInteger64vAPPLE(GLGetProcAddr('glGetInteger64vAPPLE'));
  if not Assigned(glGetInteger64vAPPLE) then
    glGetInteger64vAPPLE:=TglGetInteger64vAPPLE(GetProcAddress(Lib, 'glGetInteger64vAPPLE'));
  glGetIntegerIndexedvEXT:=TglGetIntegerIndexedvEXT(GLGetProcAddr('glGetIntegerIndexedvEXT'));
  if not Assigned(glGetIntegerIndexedvEXT) then
    glGetIntegerIndexedvEXT:=TglGetIntegerIndexedvEXT(GetProcAddress(Lib, 'glGetIntegerIndexedvEXT'));
  glGetIntegeri_v:=TglGetIntegeri_v(GLGetProcAddr('glGetIntegeri_v'));
  if not Assigned(glGetIntegeri_v) then
    glGetIntegeri_v:=TglGetIntegeri_v(GetProcAddress(Lib, 'glGetIntegeri_v'));
  glGetIntegeri_vEXT:=TglGetIntegeri_vEXT(GLGetProcAddr('glGetIntegeri_vEXT'));
  if not Assigned(glGetIntegeri_vEXT) then
    glGetIntegeri_vEXT:=TglGetIntegeri_vEXT(GetProcAddress(Lib, 'glGetIntegeri_vEXT'));
  glGetIntegerui64i_vNV:=TglGetIntegerui64i_vNV(GLGetProcAddr('glGetIntegerui64i_vNV'));
  if not Assigned(glGetIntegerui64i_vNV) then
    glGetIntegerui64i_vNV:=TglGetIntegerui64i_vNV(GetProcAddress(Lib, 'glGetIntegerui64i_vNV'));
  glGetIntegerui64vNV:=TglGetIntegerui64vNV(GLGetProcAddr('glGetIntegerui64vNV'));
  if not Assigned(glGetIntegerui64vNV) then
    glGetIntegerui64vNV:=TglGetIntegerui64vNV(GetProcAddress(Lib, 'glGetIntegerui64vNV'));
  glGetIntegerv:=TglGetIntegerv(GLGetProcAddr('glGetIntegerv'));
  if not Assigned(glGetIntegerv) then
    glGetIntegerv:=TglGetIntegerv(GetProcAddress(Lib, 'glGetIntegerv'));
  glGetInternalformatSampleivNV:=TglGetInternalformatSampleivNV(GLGetProcAddr('glGetInternalformatSampleivNV'));
  if not Assigned(glGetInternalformatSampleivNV) then
    glGetInternalformatSampleivNV:=TglGetInternalformatSampleivNV(GetProcAddress(Lib, 'glGetInternalformatSampleivNV'));
  glGetInternalformati64v:=TglGetInternalformati64v(GLGetProcAddr('glGetInternalformati64v'));
  if not Assigned(glGetInternalformati64v) then 
    glGetInternalformati64v:=TglGetInternalformati64v(GetProcAddress(Lib, 'glGetInternalformati64v'));
  glGetInternalformativ:=TglGetInternalformativ(GLGetProcAddr('glGetInternalformativ'));
  if not Assigned(glGetInternalformativ) then 
    glGetInternalformativ:=TglGetInternalformativ(GetProcAddress(Lib, 'glGetInternalformativ'));
  glGetInvariantBooleanvEXT:=TglGetInvariantBooleanvEXT(GLGetProcAddr('glGetInvariantBooleanvEXT'));
  if not Assigned(glGetInvariantBooleanvEXT) then 
    glGetInvariantBooleanvEXT:=TglGetInvariantBooleanvEXT(GetProcAddress(Lib, 'glGetInvariantBooleanvEXT'));
  glGetInvariantFloatvEXT:=TglGetInvariantFloatvEXT(GLGetProcAddr('glGetInvariantFloatvEXT'));
  if not Assigned(glGetInvariantFloatvEXT) then 
    glGetInvariantFloatvEXT:=TglGetInvariantFloatvEXT(GetProcAddress(Lib, 'glGetInvariantFloatvEXT'));
  glGetInvariantIntegervEXT:=TglGetInvariantIntegervEXT(GLGetProcAddr('glGetInvariantIntegervEXT'));
  if not Assigned(glGetInvariantIntegervEXT) then
    glGetInvariantIntegervEXT:=TglGetInvariantIntegervEXT(GetProcAddress(Lib, 'glGetInvariantIntegervEXT'));
  glGetLightfv:=TglGetLightfv(GLGetProcAddr('glGetLightfv'));
  if not Assigned(glGetLightfv) then 
    glGetLightfv:=TglGetLightfv(GetProcAddress(Lib, 'glGetLightfv'));
  glGetLightiv:=TglGetLightiv(GLGetProcAddr('glGetLightiv'));
  if not Assigned(glGetLightiv) then 
    glGetLightiv:=TglGetLightiv(GetProcAddress(Lib, 'glGetLightiv'));
  glGetLightxOES:=TglGetLightxOES(GLGetProcAddr('glGetLightxOES'));
  if not Assigned(glGetLightxOES) then 
    glGetLightxOES:=TglGetLightxOES(GetProcAddress(Lib, 'glGetLightxOES'));
  glGetLightxv:=TglGetLightxv(GLGetProcAddr('glGetLightxv'));
  if not Assigned(glGetLightxv) then 
    glGetLightxv:=TglGetLightxv(GetProcAddress(Lib, 'glGetLightxv'));
  glGetLightxvOES:=TglGetLightxvOES(GLGetProcAddr('glGetLightxvOES'));
  if not Assigned(glGetLightxvOES) then 
    glGetLightxvOES:=TglGetLightxvOES(GetProcAddress(Lib, 'glGetLightxvOES'));
  glGetListParameterfvSGIX:=TglGetListParameterfvSGIX(GLGetProcAddr('glGetListParameterfvSGIX'));
  if not Assigned(glGetListParameterfvSGIX) then 
    glGetListParameterfvSGIX:=TglGetListParameterfvSGIX(GetProcAddress(Lib, 'glGetListParameterfvSGIX'));
  glGetListParameterivSGIX:=TglGetListParameterivSGIX(GLGetProcAddr('glGetListParameterivSGIX'));
  if not Assigned(glGetListParameterivSGIX) then 
    glGetListParameterivSGIX:=TglGetListParameterivSGIX(GetProcAddress(Lib, 'glGetListParameterivSGIX'));
  glGetLocalConstantBooleanvEXT:=TglGetLocalConstantBooleanvEXT(GLGetProcAddr('glGetLocalConstantBooleanvEXT'));
  if not Assigned(glGetLocalConstantBooleanvEXT) then 
    glGetLocalConstantBooleanvEXT:=TglGetLocalConstantBooleanvEXT(GetProcAddress(Lib, 'glGetLocalConstantBooleanvEXT'));
  glGetLocalConstantFloatvEXT:=TglGetLocalConstantFloatvEXT(GLGetProcAddr('glGetLocalConstantFloatvEXT'));
  if not Assigned(glGetLocalConstantFloatvEXT) then 
    glGetLocalConstantFloatvEXT:=TglGetLocalConstantFloatvEXT(GetProcAddress(Lib, 'glGetLocalConstantFloatvEXT'));
  glGetLocalConstantIntegervEXT:=TglGetLocalConstantIntegervEXT(GLGetProcAddr('glGetLocalConstantIntegervEXT'));
  if not Assigned(glGetLocalConstantIntegervEXT) then 
    glGetLocalConstantIntegervEXT:=TglGetLocalConstantIntegervEXT(GetProcAddress(Lib, 'glGetLocalConstantIntegervEXT'));
  glGetMapAttribParameterfvNV:=TglGetMapAttribParameterfvNV(GLGetProcAddr('glGetMapAttribParameterfvNV'));
  if not Assigned(glGetMapAttribParameterfvNV) then 
    glGetMapAttribParameterfvNV:=TglGetMapAttribParameterfvNV(GetProcAddress(Lib, 'glGetMapAttribParameterfvNV'));
  glGetMapAttribParameterivNV:=TglGetMapAttribParameterivNV(GLGetProcAddr('glGetMapAttribParameterivNV'));
  if not Assigned(glGetMapAttribParameterivNV) then 
    glGetMapAttribParameterivNV:=TglGetMapAttribParameterivNV(GetProcAddress(Lib, 'glGetMapAttribParameterivNV'));
  glGetMapControlPointsNV:=TglGetMapControlPointsNV(GLGetProcAddr('glGetMapControlPointsNV'));
  if not Assigned(glGetMapControlPointsNV) then 
    glGetMapControlPointsNV:=TglGetMapControlPointsNV(GetProcAddress(Lib, 'glGetMapControlPointsNV'));
  glGetMapParameterfvNV:=TglGetMapParameterfvNV(GLGetProcAddr('glGetMapParameterfvNV'));
  if not Assigned(glGetMapParameterfvNV) then 
    glGetMapParameterfvNV:=TglGetMapParameterfvNV(GetProcAddress(Lib, 'glGetMapParameterfvNV'));
  glGetMapParameterivNV:=TglGetMapParameterivNV(GLGetProcAddr('glGetMapParameterivNV'));
  if not Assigned(glGetMapParameterivNV) then 
    glGetMapParameterivNV:=TglGetMapParameterivNV(GetProcAddress(Lib, 'glGetMapParameterivNV'));
  glGetMapdv:=TglGetMapdv(GLGetProcAddr('glGetMapdv'));
  if not Assigned(glGetMapdv) then 
    glGetMapdv:=TglGetMapdv(GetProcAddress(Lib, 'glGetMapdv'));
  glGetMapfv:=TglGetMapfv(GLGetProcAddr('glGetMapfv'));
  if not Assigned(glGetMapfv) then 
    glGetMapfv:=TglGetMapfv(GetProcAddress(Lib, 'glGetMapfv'));
  glGetMapiv:=TglGetMapiv(GLGetProcAddr('glGetMapiv'));
  if not Assigned(glGetMapiv) then 
    glGetMapiv:=TglGetMapiv(GetProcAddress(Lib, 'glGetMapiv'));
  glGetMapxvOES:=TglGetMapxvOES(GLGetProcAddr('glGetMapxvOES'));
  if not Assigned(glGetMapxvOES) then 
    glGetMapxvOES:=TglGetMapxvOES(GetProcAddress(Lib, 'glGetMapxvOES'));
  glGetMaterialfv:=TglGetMaterialfv(GLGetProcAddr('glGetMaterialfv'));
  if not Assigned(glGetMaterialfv) then 
    glGetMaterialfv:=TglGetMaterialfv(GetProcAddress(Lib, 'glGetMaterialfv'));
  glGetMaterialiv:=TglGetMaterialiv(GLGetProcAddr('glGetMaterialiv'));
  if not Assigned(glGetMaterialiv) then 
    glGetMaterialiv:=TglGetMaterialiv(GetProcAddress(Lib, 'glGetMaterialiv'));
  glGetMaterialxOES:=TglGetMaterialxOES(GLGetProcAddr('glGetMaterialxOES'));
  if not Assigned(glGetMaterialxOES) then 
    glGetMaterialxOES:=TglGetMaterialxOES(GetProcAddress(Lib, 'glGetMaterialxOES'));
  glGetMaterialxv:=TglGetMaterialxv(GLGetProcAddr('glGetMaterialxv'));
  if not Assigned(glGetMaterialxv) then 
    glGetMaterialxv:=TglGetMaterialxv(GetProcAddress(Lib, 'glGetMaterialxv'));
  glGetMaterialxvOES:=TglGetMaterialxvOES(GLGetProcAddr('glGetMaterialxvOES'));
  if not Assigned(glGetMaterialxvOES) then 
    glGetMaterialxvOES:=TglGetMaterialxvOES(GetProcAddress(Lib, 'glGetMaterialxvOES'));
  glGetMemoryObjectParameterivEXT:=TglGetMemoryObjectParameterivEXT(GLGetProcAddr('glGetMemoryObjectParameterivEXT'));
  if not Assigned(glGetMemoryObjectParameterivEXT) then 
    glGetMemoryObjectParameterivEXT:=TglGetMemoryObjectParameterivEXT(GetProcAddress(Lib, 'glGetMemoryObjectParameterivEXT'));
  glGetMinmax:=TglGetMinmax(GLGetProcAddr('glGetMinmax'));
  if not Assigned(glGetMinmax) then
    glGetMinmax:=TglGetMinmax(GetProcAddress(Lib, 'glGetMinmax'));
  glGetMinmaxEXT:=TglGetMinmaxEXT(GLGetProcAddr('glGetMinmaxEXT'));
  if not Assigned(glGetMinmaxEXT) then 
    glGetMinmaxEXT:=TglGetMinmaxEXT(GetProcAddress(Lib, 'glGetMinmaxEXT'));
  glGetMinmaxParameterfv:=TglGetMinmaxParameterfv(GLGetProcAddr('glGetMinmaxParameterfv'));
  if not Assigned(glGetMinmaxParameterfv) then 
    glGetMinmaxParameterfv:=TglGetMinmaxParameterfv(GetProcAddress(Lib, 'glGetMinmaxParameterfv'));
  glGetMinmaxParameterfvEXT:=TglGetMinmaxParameterfvEXT(GLGetProcAddr('glGetMinmaxParameterfvEXT'));
  if not Assigned(glGetMinmaxParameterfvEXT) then 
    glGetMinmaxParameterfvEXT:=TglGetMinmaxParameterfvEXT(GetProcAddress(Lib, 'glGetMinmaxParameterfvEXT'));
  glGetMinmaxParameteriv:=TglGetMinmaxParameteriv(GLGetProcAddr('glGetMinmaxParameteriv'));
  if not Assigned(glGetMinmaxParameteriv) then 
    glGetMinmaxParameteriv:=TglGetMinmaxParameteriv(GetProcAddress(Lib, 'glGetMinmaxParameteriv'));
  glGetMinmaxParameterivEXT:=TglGetMinmaxParameterivEXT(GLGetProcAddr('glGetMinmaxParameterivEXT'));
  if not Assigned(glGetMinmaxParameterivEXT) then 
    glGetMinmaxParameterivEXT:=TglGetMinmaxParameterivEXT(GetProcAddress(Lib, 'glGetMinmaxParameterivEXT'));
  glGetMultiTexEnvfvEXT:=TglGetMultiTexEnvfvEXT(GLGetProcAddr('glGetMultiTexEnvfvEXT'));
  if not Assigned(glGetMultiTexEnvfvEXT) then 
    glGetMultiTexEnvfvEXT:=TglGetMultiTexEnvfvEXT(GetProcAddress(Lib, 'glGetMultiTexEnvfvEXT'));
  glGetMultiTexEnvivEXT:=TglGetMultiTexEnvivEXT(GLGetProcAddr('glGetMultiTexEnvivEXT'));
  if not Assigned(glGetMultiTexEnvivEXT) then 
    glGetMultiTexEnvivEXT:=TglGetMultiTexEnvivEXT(GetProcAddress(Lib, 'glGetMultiTexEnvivEXT'));
  glGetMultiTexGendvEXT:=TglGetMultiTexGendvEXT(GLGetProcAddr('glGetMultiTexGendvEXT'));
  if not Assigned(glGetMultiTexGendvEXT) then 
    glGetMultiTexGendvEXT:=TglGetMultiTexGendvEXT(GetProcAddress(Lib, 'glGetMultiTexGendvEXT'));
  glGetMultiTexGenfvEXT:=TglGetMultiTexGenfvEXT(GLGetProcAddr('glGetMultiTexGenfvEXT'));
  if not Assigned(glGetMultiTexGenfvEXT) then 
    glGetMultiTexGenfvEXT:=TglGetMultiTexGenfvEXT(GetProcAddress(Lib, 'glGetMultiTexGenfvEXT'));
  glGetMultiTexGenivEXT:=TglGetMultiTexGenivEXT(GLGetProcAddr('glGetMultiTexGenivEXT'));
  if not Assigned(glGetMultiTexGenivEXT) then 
    glGetMultiTexGenivEXT:=TglGetMultiTexGenivEXT(GetProcAddress(Lib, 'glGetMultiTexGenivEXT'));
  glGetMultiTexImageEXT:=TglGetMultiTexImageEXT(GLGetProcAddr('glGetMultiTexImageEXT'));
  if not Assigned(glGetMultiTexImageEXT) then 
    glGetMultiTexImageEXT:=TglGetMultiTexImageEXT(GetProcAddress(Lib, 'glGetMultiTexImageEXT'));
  glGetMultiTexLevelParameterfvEXT:=TglGetMultiTexLevelParameterfvEXT(GLGetProcAddr('glGetMultiTexLevelParameterfvEXT'));
  if not Assigned(glGetMultiTexLevelParameterfvEXT) then 
    glGetMultiTexLevelParameterfvEXT:=TglGetMultiTexLevelParameterfvEXT(GetProcAddress(Lib, 'glGetMultiTexLevelParameterfvEXT'));
  glGetMultiTexLevelParameterivEXT:=TglGetMultiTexLevelParameterivEXT(GLGetProcAddr('glGetMultiTexLevelParameterivEXT'));
  if not Assigned(glGetMultiTexLevelParameterivEXT) then 
    glGetMultiTexLevelParameterivEXT:=TglGetMultiTexLevelParameterivEXT(GetProcAddress(Lib, 'glGetMultiTexLevelParameterivEXT'));
  glGetMultiTexParameterIivEXT:=TglGetMultiTexParameterIivEXT(GLGetProcAddr('glGetMultiTexParameterIivEXT'));
  if not Assigned(glGetMultiTexParameterIivEXT) then 
    glGetMultiTexParameterIivEXT:=TglGetMultiTexParameterIivEXT(GetProcAddress(Lib, 'glGetMultiTexParameterIivEXT'));
  glGetMultiTexParameterIuivEXT:=TglGetMultiTexParameterIuivEXT(GLGetProcAddr('glGetMultiTexParameterIuivEXT'));
  if not Assigned(glGetMultiTexParameterIuivEXT) then 
    glGetMultiTexParameterIuivEXT:=TglGetMultiTexParameterIuivEXT(GetProcAddress(Lib, 'glGetMultiTexParameterIuivEXT'));
  glGetMultiTexParameterfvEXT:=TglGetMultiTexParameterfvEXT(GLGetProcAddr('glGetMultiTexParameterfvEXT'));
  if not Assigned(glGetMultiTexParameterfvEXT) then 
    glGetMultiTexParameterfvEXT:=TglGetMultiTexParameterfvEXT(GetProcAddress(Lib, 'glGetMultiTexParameterfvEXT'));
  glGetMultiTexParameterivEXT:=TglGetMultiTexParameterivEXT(GLGetProcAddr('glGetMultiTexParameterivEXT'));
  if not Assigned(glGetMultiTexParameterivEXT) then 
    glGetMultiTexParameterivEXT:=TglGetMultiTexParameterivEXT(GetProcAddress(Lib, 'glGetMultiTexParameterivEXT'));
  glGetMultisamplefv:=TglGetMultisamplefv(GLGetProcAddr('glGetMultisamplefv'));
  if not Assigned(glGetMultisamplefv) then 
    glGetMultisamplefv:=TglGetMultisamplefv(GetProcAddress(Lib, 'glGetMultisamplefv'));
  glGetMultisamplefvNV:=TglGetMultisamplefvNV(GLGetProcAddr('glGetMultisamplefvNV'));
  if not Assigned(glGetMultisamplefvNV) then 
    glGetMultisamplefvNV:=TglGetMultisamplefvNV(GetProcAddress(Lib, 'glGetMultisamplefvNV'));
  glGetNamedBufferParameteri64v:=TglGetNamedBufferParameteri64v(GLGetProcAddr('glGetNamedBufferParameteri64v'));
  if not Assigned(glGetNamedBufferParameteri64v) then 
    glGetNamedBufferParameteri64v:=TglGetNamedBufferParameteri64v(GetProcAddress(Lib, 'glGetNamedBufferParameteri64v'));
  glGetNamedBufferParameteriv:=TglGetNamedBufferParameteriv(GLGetProcAddr('glGetNamedBufferParameteriv'));
  if not Assigned(glGetNamedBufferParameteriv) then 
    glGetNamedBufferParameteriv:=TglGetNamedBufferParameteriv(GetProcAddress(Lib, 'glGetNamedBufferParameteriv'));
  glGetNamedBufferParameterivEXT:=TglGetNamedBufferParameterivEXT(GLGetProcAddr('glGetNamedBufferParameterivEXT'));
  if not Assigned(glGetNamedBufferParameterivEXT) then 
    glGetNamedBufferParameterivEXT:=TglGetNamedBufferParameterivEXT(GetProcAddress(Lib, 'glGetNamedBufferParameterivEXT'));
  glGetNamedBufferParameterui64vNV:=TglGetNamedBufferParameterui64vNV(GLGetProcAddr('glGetNamedBufferParameterui64vNV'));
  if not Assigned(glGetNamedBufferParameterui64vNV) then 
    glGetNamedBufferParameterui64vNV:=TglGetNamedBufferParameterui64vNV(GetProcAddress(Lib, 'glGetNamedBufferParameterui64vNV'));
  glGetNamedBufferPointerv:=TglGetNamedBufferPointerv(GLGetProcAddr('glGetNamedBufferPointerv'));
  if not Assigned(glGetNamedBufferPointerv) then 
    glGetNamedBufferPointerv:=TglGetNamedBufferPointerv(GetProcAddress(Lib, 'glGetNamedBufferPointerv'));
  glGetNamedBufferPointervEXT:=TglGetNamedBufferPointervEXT(GLGetProcAddr('glGetNamedBufferPointervEXT'));
  if not Assigned(glGetNamedBufferPointervEXT) then 
    glGetNamedBufferPointervEXT:=TglGetNamedBufferPointervEXT(GetProcAddress(Lib, 'glGetNamedBufferPointervEXT'));
  glGetNamedBufferSubData:=TglGetNamedBufferSubData(GLGetProcAddr('glGetNamedBufferSubData'));
  if not Assigned(glGetNamedBufferSubData) then
    glGetNamedBufferSubData:=TglGetNamedBufferSubData(GetProcAddress(Lib, 'glGetNamedBufferSubData'));
  glGetNamedBufferSubDataEXT:=TglGetNamedBufferSubDataEXT(GLGetProcAddr('glGetNamedBufferSubDataEXT'));
  if not Assigned(glGetNamedBufferSubDataEXT) then 
    glGetNamedBufferSubDataEXT:=TglGetNamedBufferSubDataEXT(GetProcAddress(Lib, 'glGetNamedBufferSubDataEXT'));
  glGetNamedFramebufferParameterfvAMD:=TglGetNamedFramebufferParameterfvAMD(GLGetProcAddr('glGetNamedFramebufferParameterfvAMD'));
  if not Assigned(glGetNamedFramebufferParameterfvAMD) then 
    glGetNamedFramebufferParameterfvAMD:=TglGetNamedFramebufferParameterfvAMD(GetProcAddress(Lib, 'glGetNamedFramebufferParameterfvAMD'));
  glGetNamedFramebufferAttachmentParameteriv:=TglGetNamedFramebufferAttachmentParameteriv(GLGetProcAddr('glGetNamedFramebufferAttachmentParameteriv'));
  if not Assigned(glGetNamedFramebufferAttachmentParameteriv) then 
    glGetNamedFramebufferAttachmentParameteriv:=TglGetNamedFramebufferAttachmentParameteriv(GetProcAddress(Lib, 'glGetNamedFramebufferAttachmentParameteriv'));
  glGetNamedFramebufferAttachmentParameterivEXT:=TglGetNamedFramebufferAttachmentParameterivEXT(GLGetProcAddr('glGetNamedFramebufferAttachmentParameterivEXT'));
  if not Assigned(glGetNamedFramebufferAttachmentParameterivEXT) then 
    glGetNamedFramebufferAttachmentParameterivEXT:=TglGetNamedFramebufferAttachmentParameterivEXT(GetProcAddress(Lib, 'glGetNamedFramebufferAttachmentParameterivEXT'));
  glGetNamedFramebufferParameteriv:=TglGetNamedFramebufferParameteriv(GLGetProcAddr('glGetNamedFramebufferParameteriv'));
  if not Assigned(glGetNamedFramebufferParameteriv) then 
    glGetNamedFramebufferParameteriv:=TglGetNamedFramebufferParameteriv(GetProcAddress(Lib, 'glGetNamedFramebufferParameteriv'));
  glGetNamedFramebufferParameterivEXT:=TglGetNamedFramebufferParameterivEXT(GLGetProcAddr('glGetNamedFramebufferParameterivEXT'));
  if not Assigned(glGetNamedFramebufferParameterivEXT) then 
    glGetNamedFramebufferParameterivEXT:=TglGetNamedFramebufferParameterivEXT(GetProcAddress(Lib, 'glGetNamedFramebufferParameterivEXT'));
  glGetNamedProgramLocalParameterIivEXT:=TglGetNamedProgramLocalParameterIivEXT(GLGetProcAddr('glGetNamedProgramLocalParameterIivEXT'));
  if not Assigned(glGetNamedProgramLocalParameterIivEXT) then 
    glGetNamedProgramLocalParameterIivEXT:=TglGetNamedProgramLocalParameterIivEXT(GetProcAddress(Lib, 'glGetNamedProgramLocalParameterIivEXT'));
  glGetNamedProgramLocalParameterIuivEXT:=TglGetNamedProgramLocalParameterIuivEXT(GLGetProcAddr('glGetNamedProgramLocalParameterIuivEXT'));
  if not Assigned(glGetNamedProgramLocalParameterIuivEXT) then 
    glGetNamedProgramLocalParameterIuivEXT:=TglGetNamedProgramLocalParameterIuivEXT(GetProcAddress(Lib, 'glGetNamedProgramLocalParameterIuivEXT'));
  glGetNamedProgramLocalParameterdvEXT:=TglGetNamedProgramLocalParameterdvEXT(GLGetProcAddr('glGetNamedProgramLocalParameterdvEXT'));
  if not Assigned(glGetNamedProgramLocalParameterdvEXT) then 
    glGetNamedProgramLocalParameterdvEXT:=TglGetNamedProgramLocalParameterdvEXT(GetProcAddress(Lib, 'glGetNamedProgramLocalParameterdvEXT'));
  glGetNamedProgramLocalParameterfvEXT:=TglGetNamedProgramLocalParameterfvEXT(GLGetProcAddr('glGetNamedProgramLocalParameterfvEXT'));
  if not Assigned(glGetNamedProgramLocalParameterfvEXT) then 
    glGetNamedProgramLocalParameterfvEXT:=TglGetNamedProgramLocalParameterfvEXT(GetProcAddress(Lib, 'glGetNamedProgramLocalParameterfvEXT'));
  glGetNamedProgramStringEXT:=TglGetNamedProgramStringEXT(GLGetProcAddr('glGetNamedProgramStringEXT'));
  if not Assigned(glGetNamedProgramStringEXT) then 
    glGetNamedProgramStringEXT:=TglGetNamedProgramStringEXT(GetProcAddress(Lib, 'glGetNamedProgramStringEXT'));
  glGetNamedProgramivEXT:=TglGetNamedProgramivEXT(GLGetProcAddr('glGetNamedProgramivEXT'));
  if not Assigned(glGetNamedProgramivEXT) then 
    glGetNamedProgramivEXT:=TglGetNamedProgramivEXT(GetProcAddress(Lib, 'glGetNamedProgramivEXT'));
  glGetNamedRenderbufferParameteriv:=TglGetNamedRenderbufferParameteriv(GLGetProcAddr('glGetNamedRenderbufferParameteriv'));
  if not Assigned(glGetNamedRenderbufferParameteriv) then 
    glGetNamedRenderbufferParameteriv:=TglGetNamedRenderbufferParameteriv(GetProcAddress(Lib, 'glGetNamedRenderbufferParameteriv'));
  glGetNamedRenderbufferParameterivEXT:=TglGetNamedRenderbufferParameterivEXT(GLGetProcAddr('glGetNamedRenderbufferParameterivEXT'));
  if not Assigned(glGetNamedRenderbufferParameterivEXT) then 
    glGetNamedRenderbufferParameterivEXT:=TglGetNamedRenderbufferParameterivEXT(GetProcAddress(Lib, 'glGetNamedRenderbufferParameterivEXT'));
  glGetNamedStringARB:=TglGetNamedStringARB(GLGetProcAddr('glGetNamedStringARB'));
  if not Assigned(glGetNamedStringARB) then 
    glGetNamedStringARB:=TglGetNamedStringARB(GetProcAddress(Lib, 'glGetNamedStringARB'));
  glGetNamedStringivARB:=TglGetNamedStringivARB(GLGetProcAddr('glGetNamedStringivARB'));
  if not Assigned(glGetNamedStringivARB) then 
    glGetNamedStringivARB:=TglGetNamedStringivARB(GetProcAddress(Lib, 'glGetNamedStringivARB'));
  glGetNextPerfQueryIdINTEL:=TglGetNextPerfQueryIdINTEL(GLGetProcAddr('glGetNextPerfQueryIdINTEL'));
  if not Assigned(glGetNextPerfQueryIdINTEL) then 
    glGetNextPerfQueryIdINTEL:=TglGetNextPerfQueryIdINTEL(GetProcAddress(Lib, 'glGetNextPerfQueryIdINTEL'));
  glGetObjectBufferfvATI:=TglGetObjectBufferfvATI(GLGetProcAddr('glGetObjectBufferfvATI'));
  if not Assigned(glGetObjectBufferfvATI) then 
    glGetObjectBufferfvATI:=TglGetObjectBufferfvATI(GetProcAddress(Lib, 'glGetObjectBufferfvATI'));
  glGetObjectBufferivATI:=TglGetObjectBufferivATI(GLGetProcAddr('glGetObjectBufferivATI'));
  if not Assigned(glGetObjectBufferivATI) then 
    glGetObjectBufferivATI:=TglGetObjectBufferivATI(GetProcAddress(Lib, 'glGetObjectBufferivATI'));
  glGetObjectLabel:=TglGetObjectLabel(GLGetProcAddr('glGetObjectLabel'));
  if not Assigned(glGetObjectLabel) then 
    glGetObjectLabel:=TglGetObjectLabel(GetProcAddress(Lib, 'glGetObjectLabel'));
  glGetObjectLabelEXT:=TglGetObjectLabelEXT(GLGetProcAddr('glGetObjectLabelEXT'));
  if not Assigned(glGetObjectLabelEXT) then 
    glGetObjectLabelEXT:=TglGetObjectLabelEXT(GetProcAddress(Lib, 'glGetObjectLabelEXT'));
  glGetObjectLabelKHR:=TglGetObjectLabelKHR(GLGetProcAddr('glGetObjectLabelKHR'));
  if not Assigned(glGetObjectLabelKHR) then 
    glGetObjectLabelKHR:=TglGetObjectLabelKHR(GetProcAddress(Lib, 'glGetObjectLabelKHR'));
  glGetObjectParameterfvARB:=TglGetObjectParameterfvARB(GLGetProcAddr('glGetObjectParameterfvARB'));
  if not Assigned(glGetObjectParameterfvARB) then 
    glGetObjectParameterfvARB:=TglGetObjectParameterfvARB(GetProcAddress(Lib, 'glGetObjectParameterfvARB'));
  glGetObjectParameterivAPPLE:=TglGetObjectParameterivAPPLE(GLGetProcAddr('glGetObjectParameterivAPPLE'));
  if not Assigned(glGetObjectParameterivAPPLE) then 
    glGetObjectParameterivAPPLE:=TglGetObjectParameterivAPPLE(GetProcAddress(Lib, 'glGetObjectParameterivAPPLE'));
  glGetObjectParameterivARB:=TglGetObjectParameterivARB(GLGetProcAddr('glGetObjectParameterivARB'));
  if not Assigned(glGetObjectParameterivARB) then 
    glGetObjectParameterivARB:=TglGetObjectParameterivARB(GetProcAddress(Lib, 'glGetObjectParameterivARB'));
  glGetObjectPtrLabel:=TglGetObjectPtrLabel(GLGetProcAddr('glGetObjectPtrLabel'));
  if not Assigned(glGetObjectPtrLabel) then
    glGetObjectPtrLabel:=TglGetObjectPtrLabel(GetProcAddress(Lib, 'glGetObjectPtrLabel'));
  glGetObjectPtrLabelKHR:=TglGetObjectPtrLabelKHR(GLGetProcAddr('glGetObjectPtrLabelKHR'));
  if not Assigned(glGetObjectPtrLabelKHR) then 
    glGetObjectPtrLabelKHR:=TglGetObjectPtrLabelKHR(GetProcAddress(Lib, 'glGetObjectPtrLabelKHR'));
  glGetOcclusionQueryivNV:=TglGetOcclusionQueryivNV(GLGetProcAddr('glGetOcclusionQueryivNV'));
  if not Assigned(glGetOcclusionQueryivNV) then 
    glGetOcclusionQueryivNV:=TglGetOcclusionQueryivNV(GetProcAddress(Lib, 'glGetOcclusionQueryivNV'));
  glGetOcclusionQueryuivNV:=TglGetOcclusionQueryuivNV(GLGetProcAddr('glGetOcclusionQueryuivNV'));
  if not Assigned(glGetOcclusionQueryuivNV) then 
    glGetOcclusionQueryuivNV:=TglGetOcclusionQueryuivNV(GetProcAddress(Lib, 'glGetOcclusionQueryuivNV'));
  glGetPathColorGenfvNV:=TglGetPathColorGenfvNV(GLGetProcAddr('glGetPathColorGenfvNV'));
  if not Assigned(glGetPathColorGenfvNV) then 
    glGetPathColorGenfvNV:=TglGetPathColorGenfvNV(GetProcAddress(Lib, 'glGetPathColorGenfvNV'));
  glGetPathColorGenivNV:=TglGetPathColorGenivNV(GLGetProcAddr('glGetPathColorGenivNV'));
  if not Assigned(glGetPathColorGenivNV) then 
    glGetPathColorGenivNV:=TglGetPathColorGenivNV(GetProcAddress(Lib, 'glGetPathColorGenivNV'));
  glGetPathCommandsNV:=TglGetPathCommandsNV(GLGetProcAddr('glGetPathCommandsNV'));
  if not Assigned(glGetPathCommandsNV) then 
    glGetPathCommandsNV:=TglGetPathCommandsNV(GetProcAddress(Lib, 'glGetPathCommandsNV'));
  glGetPathCoordsNV:=TglGetPathCoordsNV(GLGetProcAddr('glGetPathCoordsNV'));
  if not Assigned(glGetPathCoordsNV) then 
    glGetPathCoordsNV:=TglGetPathCoordsNV(GetProcAddress(Lib, 'glGetPathCoordsNV'));
  glGetPathDashArrayNV:=TglGetPathDashArrayNV(GLGetProcAddr('glGetPathDashArrayNV'));
  if not Assigned(glGetPathDashArrayNV) then 
    glGetPathDashArrayNV:=TglGetPathDashArrayNV(GetProcAddress(Lib, 'glGetPathDashArrayNV'));
  glGetPathLengthNV:=TglGetPathLengthNV(GLGetProcAddr('glGetPathLengthNV'));
  if not Assigned(glGetPathLengthNV) then 
    glGetPathLengthNV:=TglGetPathLengthNV(GetProcAddress(Lib, 'glGetPathLengthNV'));
  glGetPathMetricRangeNV:=TglGetPathMetricRangeNV(GLGetProcAddr('glGetPathMetricRangeNV'));
  if not Assigned(glGetPathMetricRangeNV) then 
    glGetPathMetricRangeNV:=TglGetPathMetricRangeNV(GetProcAddress(Lib, 'glGetPathMetricRangeNV'));
  glGetPathMetricsNV:=TglGetPathMetricsNV(GLGetProcAddr('glGetPathMetricsNV'));
  if not Assigned(glGetPathMetricsNV) then 
    glGetPathMetricsNV:=TglGetPathMetricsNV(GetProcAddress(Lib, 'glGetPathMetricsNV'));
  glGetPathParameterfvNV:=TglGetPathParameterfvNV(GLGetProcAddr('glGetPathParameterfvNV'));
  if not Assigned(glGetPathParameterfvNV) then 
    glGetPathParameterfvNV:=TglGetPathParameterfvNV(GetProcAddress(Lib, 'glGetPathParameterfvNV'));
  glGetPathParameterivNV:=TglGetPathParameterivNV(GLGetProcAddr('glGetPathParameterivNV'));
  if not Assigned(glGetPathParameterivNV) then 
    glGetPathParameterivNV:=TglGetPathParameterivNV(GetProcAddress(Lib, 'glGetPathParameterivNV'));
  glGetPathSpacingNV:=TglGetPathSpacingNV(GLGetProcAddr('glGetPathSpacingNV'));
  if not Assigned(glGetPathSpacingNV) then 
    glGetPathSpacingNV:=TglGetPathSpacingNV(GetProcAddress(Lib, 'glGetPathSpacingNV'));
  glGetPathTexGenfvNV:=TglGetPathTexGenfvNV(GLGetProcAddr('glGetPathTexGenfvNV'));
  if not Assigned(glGetPathTexGenfvNV) then 
    glGetPathTexGenfvNV:=TglGetPathTexGenfvNV(GetProcAddress(Lib, 'glGetPathTexGenfvNV'));
  glGetPathTexGenivNV:=TglGetPathTexGenivNV(GLGetProcAddr('glGetPathTexGenivNV'));
  if not Assigned(glGetPathTexGenivNV) then 
    glGetPathTexGenivNV:=TglGetPathTexGenivNV(GetProcAddress(Lib, 'glGetPathTexGenivNV'));
  glGetPerfCounterInfoINTEL:=TglGetPerfCounterInfoINTEL(GLGetProcAddr('glGetPerfCounterInfoINTEL'));
  if not Assigned(glGetPerfCounterInfoINTEL) then 
    glGetPerfCounterInfoINTEL:=TglGetPerfCounterInfoINTEL(GetProcAddress(Lib, 'glGetPerfCounterInfoINTEL'));
  glGetPerfMonitorCounterDataAMD:=TglGetPerfMonitorCounterDataAMD(GLGetProcAddr('glGetPerfMonitorCounterDataAMD'));
  if not Assigned(glGetPerfMonitorCounterDataAMD) then 
    glGetPerfMonitorCounterDataAMD:=TglGetPerfMonitorCounterDataAMD(GetProcAddress(Lib, 'glGetPerfMonitorCounterDataAMD'));
  glGetPerfMonitorCounterInfoAMD:=TglGetPerfMonitorCounterInfoAMD(GLGetProcAddr('glGetPerfMonitorCounterInfoAMD'));
  if not Assigned(glGetPerfMonitorCounterInfoAMD) then 
    glGetPerfMonitorCounterInfoAMD:=TglGetPerfMonitorCounterInfoAMD(GetProcAddress(Lib, 'glGetPerfMonitorCounterInfoAMD'));
  glGetPerfMonitorCounterStringAMD:=TglGetPerfMonitorCounterStringAMD(GLGetProcAddr('glGetPerfMonitorCounterStringAMD'));
  if not Assigned(glGetPerfMonitorCounterStringAMD) then 
    glGetPerfMonitorCounterStringAMD:=TglGetPerfMonitorCounterStringAMD(GetProcAddress(Lib, 'glGetPerfMonitorCounterStringAMD'));
  glGetPerfMonitorCountersAMD:=TglGetPerfMonitorCountersAMD(GLGetProcAddr('glGetPerfMonitorCountersAMD'));
  if not Assigned(glGetPerfMonitorCountersAMD) then 
    glGetPerfMonitorCountersAMD:=TglGetPerfMonitorCountersAMD(GetProcAddress(Lib, 'glGetPerfMonitorCountersAMD'));
  glGetPerfMonitorGroupStringAMD:=TglGetPerfMonitorGroupStringAMD(GLGetProcAddr('glGetPerfMonitorGroupStringAMD'));
  if not Assigned(glGetPerfMonitorGroupStringAMD) then 
    glGetPerfMonitorGroupStringAMD:=TglGetPerfMonitorGroupStringAMD(GetProcAddress(Lib, 'glGetPerfMonitorGroupStringAMD'));
  glGetPerfMonitorGroupsAMD:=TglGetPerfMonitorGroupsAMD(GLGetProcAddr('glGetPerfMonitorGroupsAMD'));
  if not Assigned(glGetPerfMonitorGroupsAMD) then 
    glGetPerfMonitorGroupsAMD:=TglGetPerfMonitorGroupsAMD(GetProcAddress(Lib, 'glGetPerfMonitorGroupsAMD'));
  glGetPerfQueryDataINTEL:=TglGetPerfQueryDataINTEL(GLGetProcAddr('glGetPerfQueryDataINTEL'));
  if not Assigned(glGetPerfQueryDataINTEL) then 
    glGetPerfQueryDataINTEL:=TglGetPerfQueryDataINTEL(GetProcAddress(Lib, 'glGetPerfQueryDataINTEL'));
  glGetPerfQueryIdByNameINTEL:=TglGetPerfQueryIdByNameINTEL(GLGetProcAddr('glGetPerfQueryIdByNameINTEL'));
  if not Assigned(glGetPerfQueryIdByNameINTEL) then 
    glGetPerfQueryIdByNameINTEL:=TglGetPerfQueryIdByNameINTEL(GetProcAddress(Lib, 'glGetPerfQueryIdByNameINTEL'));
  glGetPerfQueryInfoINTEL:=TglGetPerfQueryInfoINTEL(GLGetProcAddr('glGetPerfQueryInfoINTEL'));
  if not Assigned(glGetPerfQueryInfoINTEL) then
    glGetPerfQueryInfoINTEL:=TglGetPerfQueryInfoINTEL(GetProcAddress(Lib, 'glGetPerfQueryInfoINTEL'));
  glGetPixelMapfv:=TglGetPixelMapfv(GLGetProcAddr('glGetPixelMapfv'));
  if not Assigned(glGetPixelMapfv) then 
    glGetPixelMapfv:=TglGetPixelMapfv(GetProcAddress(Lib, 'glGetPixelMapfv'));
  glGetPixelMapuiv:=TglGetPixelMapuiv(GLGetProcAddr('glGetPixelMapuiv'));
  if not Assigned(glGetPixelMapuiv) then 
    glGetPixelMapuiv:=TglGetPixelMapuiv(GetProcAddress(Lib, 'glGetPixelMapuiv'));
  glGetPixelMapusv:=TglGetPixelMapusv(GLGetProcAddr('glGetPixelMapusv'));
  if not Assigned(glGetPixelMapusv) then 
    glGetPixelMapusv:=TglGetPixelMapusv(GetProcAddress(Lib, 'glGetPixelMapusv'));
  glGetPixelMapxv:=TglGetPixelMapxv(GLGetProcAddr('glGetPixelMapxv'));
  if not Assigned(glGetPixelMapxv) then 
    glGetPixelMapxv:=TglGetPixelMapxv(GetProcAddress(Lib, 'glGetPixelMapxv'));
  glGetPixelTexGenParameterfvSGIS:=TglGetPixelTexGenParameterfvSGIS(GLGetProcAddr('glGetPixelTexGenParameterfvSGIS'));
  if not Assigned(glGetPixelTexGenParameterfvSGIS) then 
    glGetPixelTexGenParameterfvSGIS:=TglGetPixelTexGenParameterfvSGIS(GetProcAddress(Lib, 'glGetPixelTexGenParameterfvSGIS'));
  glGetPixelTexGenParameterivSGIS:=TglGetPixelTexGenParameterivSGIS(GLGetProcAddr('glGetPixelTexGenParameterivSGIS'));
  if not Assigned(glGetPixelTexGenParameterivSGIS) then 
    glGetPixelTexGenParameterivSGIS:=TglGetPixelTexGenParameterivSGIS(GetProcAddress(Lib, 'glGetPixelTexGenParameterivSGIS'));
  glGetPixelTransformParameterfvEXT:=TglGetPixelTransformParameterfvEXT(GLGetProcAddr('glGetPixelTransformParameterfvEXT'));
  if not Assigned(glGetPixelTransformParameterfvEXT) then 
    glGetPixelTransformParameterfvEXT:=TglGetPixelTransformParameterfvEXT(GetProcAddress(Lib, 'glGetPixelTransformParameterfvEXT'));
  glGetPixelTransformParameterivEXT:=TglGetPixelTransformParameterivEXT(GLGetProcAddr('glGetPixelTransformParameterivEXT'));
  if not Assigned(glGetPixelTransformParameterivEXT) then 
    glGetPixelTransformParameterivEXT:=TglGetPixelTransformParameterivEXT(GetProcAddress(Lib, 'glGetPixelTransformParameterivEXT'));
  glGetPointerIndexedvEXT:=TglGetPointerIndexedvEXT(GLGetProcAddr('glGetPointerIndexedvEXT'));
  if not Assigned(glGetPointerIndexedvEXT) then 
    glGetPointerIndexedvEXT:=TglGetPointerIndexedvEXT(GetProcAddress(Lib, 'glGetPointerIndexedvEXT'));
  glGetPointeri_vEXT:=TglGetPointeri_vEXT(GLGetProcAddr('glGetPointeri_vEXT'));
  if not Assigned(glGetPointeri_vEXT) then 
    glGetPointeri_vEXT:=TglGetPointeri_vEXT(GetProcAddress(Lib, 'glGetPointeri_vEXT'));
  glGetPointerv:=TglGetPointerv(GLGetProcAddr('glGetPointerv'));
  if not Assigned(glGetPointerv) then 
    glGetPointerv:=TglGetPointerv(GetProcAddress(Lib, 'glGetPointerv'));
  glGetPointervEXT:=TglGetPointervEXT(GLGetProcAddr('glGetPointervEXT'));
  if not Assigned(glGetPointervEXT) then 
    glGetPointervEXT:=TglGetPointervEXT(GetProcAddress(Lib, 'glGetPointervEXT'));
  glGetPointervKHR:=TglGetPointervKHR(GLGetProcAddr('glGetPointervKHR'));
  if not Assigned(glGetPointervKHR) then 
    glGetPointervKHR:=TglGetPointervKHR(GetProcAddress(Lib, 'glGetPointervKHR'));
  glGetPolygonStipple:=TglGetPolygonStipple(GLGetProcAddr('glGetPolygonStipple'));
  if not Assigned(glGetPolygonStipple) then 
    glGetPolygonStipple:=TglGetPolygonStipple(GetProcAddress(Lib, 'glGetPolygonStipple'));
  glGetProgramBinary:=TglGetProgramBinary(GLGetProcAddr('glGetProgramBinary'));
  if not Assigned(glGetProgramBinary) then 
    glGetProgramBinary:=TglGetProgramBinary(GetProcAddress(Lib, 'glGetProgramBinary'));
  glGetProgramBinaryOES:=TglGetProgramBinaryOES(GLGetProcAddr('glGetProgramBinaryOES'));
  if not Assigned(glGetProgramBinaryOES) then 
    glGetProgramBinaryOES:=TglGetProgramBinaryOES(GetProcAddress(Lib, 'glGetProgramBinaryOES'));
  glGetProgramEnvParameterIivNV:=TglGetProgramEnvParameterIivNV(GLGetProcAddr('glGetProgramEnvParameterIivNV'));
  if not Assigned(glGetProgramEnvParameterIivNV) then 
    glGetProgramEnvParameterIivNV:=TglGetProgramEnvParameterIivNV(GetProcAddress(Lib, 'glGetProgramEnvParameterIivNV'));
  glGetProgramEnvParameterIuivNV:=TglGetProgramEnvParameterIuivNV(GLGetProcAddr('glGetProgramEnvParameterIuivNV'));
  if not Assigned(glGetProgramEnvParameterIuivNV) then 
    glGetProgramEnvParameterIuivNV:=TglGetProgramEnvParameterIuivNV(GetProcAddress(Lib, 'glGetProgramEnvParameterIuivNV'));
  glGetProgramEnvParameterdvARB:=TglGetProgramEnvParameterdvARB(GLGetProcAddr('glGetProgramEnvParameterdvARB'));
  if not Assigned(glGetProgramEnvParameterdvARB) then 
    glGetProgramEnvParameterdvARB:=TglGetProgramEnvParameterdvARB(GetProcAddress(Lib, 'glGetProgramEnvParameterdvARB'));
  glGetProgramEnvParameterfvARB:=TglGetProgramEnvParameterfvARB(GLGetProcAddr('glGetProgramEnvParameterfvARB'));
  if not Assigned(glGetProgramEnvParameterfvARB) then 
    glGetProgramEnvParameterfvARB:=TglGetProgramEnvParameterfvARB(GetProcAddress(Lib, 'glGetProgramEnvParameterfvARB'));
  glGetProgramInfoLog:=TglGetProgramInfoLog(GLGetProcAddr('glGetProgramInfoLog'));
  if not Assigned(glGetProgramInfoLog) then 
    glGetProgramInfoLog:=TglGetProgramInfoLog(GetProcAddress(Lib, 'glGetProgramInfoLog'));
  glGetProgramInterfaceiv:=TglGetProgramInterfaceiv(GLGetProcAddr('glGetProgramInterfaceiv'));
  if not Assigned(glGetProgramInterfaceiv) then 
    glGetProgramInterfaceiv:=TglGetProgramInterfaceiv(GetProcAddress(Lib, 'glGetProgramInterfaceiv'));
  glGetProgramLocalParameterIivNV:=TglGetProgramLocalParameterIivNV(GLGetProcAddr('glGetProgramLocalParameterIivNV'));
  if not Assigned(glGetProgramLocalParameterIivNV) then 
    glGetProgramLocalParameterIivNV:=TglGetProgramLocalParameterIivNV(GetProcAddress(Lib, 'glGetProgramLocalParameterIivNV'));
  glGetProgramLocalParameterIuivNV:=TglGetProgramLocalParameterIuivNV(GLGetProcAddr('glGetProgramLocalParameterIuivNV'));
  if not Assigned(glGetProgramLocalParameterIuivNV) then 
    glGetProgramLocalParameterIuivNV:=TglGetProgramLocalParameterIuivNV(GetProcAddress(Lib, 'glGetProgramLocalParameterIuivNV'));
  glGetProgramLocalParameterdvARB:=TglGetProgramLocalParameterdvARB(GLGetProcAddr('glGetProgramLocalParameterdvARB'));
  if not Assigned(glGetProgramLocalParameterdvARB) then 
    glGetProgramLocalParameterdvARB:=TglGetProgramLocalParameterdvARB(GetProcAddress(Lib, 'glGetProgramLocalParameterdvARB'));
  glGetProgramLocalParameterfvARB:=TglGetProgramLocalParameterfvARB(GLGetProcAddr('glGetProgramLocalParameterfvARB'));
  if not Assigned(glGetProgramLocalParameterfvARB) then
    glGetProgramLocalParameterfvARB:=TglGetProgramLocalParameterfvARB(GetProcAddress(Lib, 'glGetProgramLocalParameterfvARB'));
  glGetProgramNamedParameterdvNV:=TglGetProgramNamedParameterdvNV(GLGetProcAddr('glGetProgramNamedParameterdvNV'));
  if not Assigned(glGetProgramNamedParameterdvNV) then 
    glGetProgramNamedParameterdvNV:=TglGetProgramNamedParameterdvNV(GetProcAddress(Lib, 'glGetProgramNamedParameterdvNV'));
  glGetProgramNamedParameterfvNV:=TglGetProgramNamedParameterfvNV(GLGetProcAddr('glGetProgramNamedParameterfvNV'));
  if not Assigned(glGetProgramNamedParameterfvNV) then 
    glGetProgramNamedParameterfvNV:=TglGetProgramNamedParameterfvNV(GetProcAddress(Lib, 'glGetProgramNamedParameterfvNV'));
  glGetProgramParameterdvNV:=TglGetProgramParameterdvNV(GLGetProcAddr('glGetProgramParameterdvNV'));
  if not Assigned(glGetProgramParameterdvNV) then 
    glGetProgramParameterdvNV:=TglGetProgramParameterdvNV(GetProcAddress(Lib, 'glGetProgramParameterdvNV'));
  glGetProgramParameterfvNV:=TglGetProgramParameterfvNV(GLGetProcAddr('glGetProgramParameterfvNV'));
  if not Assigned(glGetProgramParameterfvNV) then 
    glGetProgramParameterfvNV:=TglGetProgramParameterfvNV(GetProcAddress(Lib, 'glGetProgramParameterfvNV'));
  glGetProgramPipelineInfoLog:=TglGetProgramPipelineInfoLog(GLGetProcAddr('glGetProgramPipelineInfoLog'));
  if not Assigned(glGetProgramPipelineInfoLog) then 
    glGetProgramPipelineInfoLog:=TglGetProgramPipelineInfoLog(GetProcAddress(Lib, 'glGetProgramPipelineInfoLog'));
  glGetProgramPipelineInfoLogEXT:=TglGetProgramPipelineInfoLogEXT(GLGetProcAddr('glGetProgramPipelineInfoLogEXT'));
  if not Assigned(glGetProgramPipelineInfoLogEXT) then 
    glGetProgramPipelineInfoLogEXT:=TglGetProgramPipelineInfoLogEXT(GetProcAddress(Lib, 'glGetProgramPipelineInfoLogEXT'));
  glGetProgramPipelineiv:=TglGetProgramPipelineiv(GLGetProcAddr('glGetProgramPipelineiv'));
  if not Assigned(glGetProgramPipelineiv) then 
    glGetProgramPipelineiv:=TglGetProgramPipelineiv(GetProcAddress(Lib, 'glGetProgramPipelineiv'));
  glGetProgramPipelineivEXT:=TglGetProgramPipelineivEXT(GLGetProcAddr('glGetProgramPipelineivEXT'));
  if not Assigned(glGetProgramPipelineivEXT) then 
    glGetProgramPipelineivEXT:=TglGetProgramPipelineivEXT(GetProcAddress(Lib, 'glGetProgramPipelineivEXT'));
  glGetProgramResourceIndex:=TglGetProgramResourceIndex(GLGetProcAddr('glGetProgramResourceIndex'));
  if not Assigned(glGetProgramResourceIndex) then 
    glGetProgramResourceIndex:=TglGetProgramResourceIndex(GetProcAddress(Lib, 'glGetProgramResourceIndex'));
  glGetProgramResourceLocation:=TglGetProgramResourceLocation(GLGetProcAddr('glGetProgramResourceLocation'));
  if not Assigned(glGetProgramResourceLocation) then 
    glGetProgramResourceLocation:=TglGetProgramResourceLocation(GetProcAddress(Lib, 'glGetProgramResourceLocation'));
  glGetProgramResourceLocationIndex:=TglGetProgramResourceLocationIndex(GLGetProcAddr('glGetProgramResourceLocationIndex'));
  if not Assigned(glGetProgramResourceLocationIndex) then 
    glGetProgramResourceLocationIndex:=TglGetProgramResourceLocationIndex(GetProcAddress(Lib, 'glGetProgramResourceLocationIndex'));
  glGetProgramResourceLocationIndexEXT:=TglGetProgramResourceLocationIndexEXT(GLGetProcAddr('glGetProgramResourceLocationIndexEXT'));
  if not Assigned(glGetProgramResourceLocationIndexEXT) then 
    glGetProgramResourceLocationIndexEXT:=TglGetProgramResourceLocationIndexEXT(GetProcAddress(Lib, 'glGetProgramResourceLocationIndexEXT'));
  glGetProgramResourceName:=TglGetProgramResourceName(GLGetProcAddr('glGetProgramResourceName'));
  if not Assigned(glGetProgramResourceName) then 
    glGetProgramResourceName:=TglGetProgramResourceName(GetProcAddress(Lib, 'glGetProgramResourceName'));
  glGetProgramResourcefvNV:=TglGetProgramResourcefvNV(GLGetProcAddr('glGetProgramResourcefvNV'));
  if not Assigned(glGetProgramResourcefvNV) then 
    glGetProgramResourcefvNV:=TglGetProgramResourcefvNV(GetProcAddress(Lib, 'glGetProgramResourcefvNV'));
  glGetProgramResourceiv:=TglGetProgramResourceiv(GLGetProcAddr('glGetProgramResourceiv'));
  if not Assigned(glGetProgramResourceiv) then 
    glGetProgramResourceiv:=TglGetProgramResourceiv(GetProcAddress(Lib, 'glGetProgramResourceiv'));
  glGetProgramStageiv:=TglGetProgramStageiv(GLGetProcAddr('glGetProgramStageiv'));
  if not Assigned(glGetProgramStageiv) then 
    glGetProgramStageiv:=TglGetProgramStageiv(GetProcAddress(Lib, 'glGetProgramStageiv'));
  glGetProgramStringARB:=TglGetProgramStringARB(GLGetProcAddr('glGetProgramStringARB'));
  if not Assigned(glGetProgramStringARB) then 
    glGetProgramStringARB:=TglGetProgramStringARB(GetProcAddress(Lib, 'glGetProgramStringARB'));
  glGetProgramStringNV:=TglGetProgramStringNV(GLGetProcAddr('glGetProgramStringNV'));
  if not Assigned(glGetProgramStringNV) then 
    glGetProgramStringNV:=TglGetProgramStringNV(GetProcAddress(Lib, 'glGetProgramStringNV'));
  glGetProgramSubroutineParameteruivNV:=TglGetProgramSubroutineParameteruivNV(GLGetProcAddr('glGetProgramSubroutineParameteruivNV'));
  if not Assigned(glGetProgramSubroutineParameteruivNV) then 
    glGetProgramSubroutineParameteruivNV:=TglGetProgramSubroutineParameteruivNV(GetProcAddress(Lib, 'glGetProgramSubroutineParameteruivNV'));
  glGetProgramiv:=TglGetProgramiv(GLGetProcAddr('glGetProgramiv'));
  if not Assigned(glGetProgramiv) then 
    glGetProgramiv:=TglGetProgramiv(GetProcAddress(Lib, 'glGetProgramiv'));
  glGetProgramivARB:=TglGetProgramivARB(GLGetProcAddr('glGetProgramivARB'));
  if not Assigned(glGetProgramivARB) then 
    glGetProgramivARB:=TglGetProgramivARB(GetProcAddress(Lib, 'glGetProgramivARB'));
  glGetProgramivNV:=TglGetProgramivNV(GLGetProcAddr('glGetProgramivNV'));
  if not Assigned(glGetProgramivNV) then 
    glGetProgramivNV:=TglGetProgramivNV(GetProcAddress(Lib, 'glGetProgramivNV'));
  glGetQueryBufferObjecti64v:=TglGetQueryBufferObjecti64v(GLGetProcAddr('glGetQueryBufferObjecti64v'));
  if not Assigned(glGetQueryBufferObjecti64v) then 
    glGetQueryBufferObjecti64v:=TglGetQueryBufferObjecti64v(GetProcAddress(Lib, 'glGetQueryBufferObjecti64v'));
  glGetQueryBufferObjectiv:=TglGetQueryBufferObjectiv(GLGetProcAddr('glGetQueryBufferObjectiv'));
  if not Assigned(glGetQueryBufferObjectiv) then 
    glGetQueryBufferObjectiv:=TglGetQueryBufferObjectiv(GetProcAddress(Lib, 'glGetQueryBufferObjectiv'));
  glGetQueryBufferObjectui64v:=TglGetQueryBufferObjectui64v(GLGetProcAddr('glGetQueryBufferObjectui64v'));
  if not Assigned(glGetQueryBufferObjectui64v) then 
    glGetQueryBufferObjectui64v:=TglGetQueryBufferObjectui64v(GetProcAddress(Lib, 'glGetQueryBufferObjectui64v'));
  glGetQueryBufferObjectuiv:=TglGetQueryBufferObjectuiv(GLGetProcAddr('glGetQueryBufferObjectuiv'));
  if not Assigned(glGetQueryBufferObjectuiv) then
    glGetQueryBufferObjectuiv:=TglGetQueryBufferObjectuiv(GetProcAddress(Lib, 'glGetQueryBufferObjectuiv'));
  glGetQueryIndexediv:=TglGetQueryIndexediv(GLGetProcAddr('glGetQueryIndexediv'));
  if not Assigned(glGetQueryIndexediv) then 
    glGetQueryIndexediv:=TglGetQueryIndexediv(GetProcAddress(Lib, 'glGetQueryIndexediv'));
  glGetQueryObjecti64v:=TglGetQueryObjecti64v(GLGetProcAddr('glGetQueryObjecti64v'));
  if not Assigned(glGetQueryObjecti64v) then 
    glGetQueryObjecti64v:=TglGetQueryObjecti64v(GetProcAddress(Lib, 'glGetQueryObjecti64v'));
  glGetQueryObjecti64vEXT:=TglGetQueryObjecti64vEXT(GLGetProcAddr('glGetQueryObjecti64vEXT'));
  if not Assigned(glGetQueryObjecti64vEXT) then 
    glGetQueryObjecti64vEXT:=TglGetQueryObjecti64vEXT(GetProcAddress(Lib, 'glGetQueryObjecti64vEXT'));
  glGetQueryObjectiv:=TglGetQueryObjectiv(GLGetProcAddr('glGetQueryObjectiv'));
  if not Assigned(glGetQueryObjectiv) then 
    glGetQueryObjectiv:=TglGetQueryObjectiv(GetProcAddress(Lib, 'glGetQueryObjectiv'));
  glGetQueryObjectivARB:=TglGetQueryObjectivARB(GLGetProcAddr('glGetQueryObjectivARB'));
  if not Assigned(glGetQueryObjectivARB) then 
    glGetQueryObjectivARB:=TglGetQueryObjectivARB(GetProcAddress(Lib, 'glGetQueryObjectivARB'));
  glGetQueryObjectivEXT:=TglGetQueryObjectivEXT(GLGetProcAddr('glGetQueryObjectivEXT'));
  if not Assigned(glGetQueryObjectivEXT) then 
    glGetQueryObjectivEXT:=TglGetQueryObjectivEXT(GetProcAddress(Lib, 'glGetQueryObjectivEXT'));
  glGetQueryObjectui64v:=TglGetQueryObjectui64v(GLGetProcAddr('glGetQueryObjectui64v'));
  if not Assigned(glGetQueryObjectui64v) then 
    glGetQueryObjectui64v:=TglGetQueryObjectui64v(GetProcAddress(Lib, 'glGetQueryObjectui64v'));
  glGetQueryObjectui64vEXT:=TglGetQueryObjectui64vEXT(GLGetProcAddr('glGetQueryObjectui64vEXT'));
  if not Assigned(glGetQueryObjectui64vEXT) then 
    glGetQueryObjectui64vEXT:=TglGetQueryObjectui64vEXT(GetProcAddress(Lib, 'glGetQueryObjectui64vEXT'));
  glGetQueryObjectuiv:=TglGetQueryObjectuiv(GLGetProcAddr('glGetQueryObjectuiv'));
  if not Assigned(glGetQueryObjectuiv) then 
    glGetQueryObjectuiv:=TglGetQueryObjectuiv(GetProcAddress(Lib, 'glGetQueryObjectuiv'));
  glGetQueryObjectuivARB:=TglGetQueryObjectuivARB(GLGetProcAddr('glGetQueryObjectuivARB'));
  if not Assigned(glGetQueryObjectuivARB) then 
    glGetQueryObjectuivARB:=TglGetQueryObjectuivARB(GetProcAddress(Lib, 'glGetQueryObjectuivARB'));
  glGetQueryObjectuivEXT:=TglGetQueryObjectuivEXT(GLGetProcAddr('glGetQueryObjectuivEXT'));
  if not Assigned(glGetQueryObjectuivEXT) then 
    glGetQueryObjectuivEXT:=TglGetQueryObjectuivEXT(GetProcAddress(Lib, 'glGetQueryObjectuivEXT'));
  glGetQueryiv:=TglGetQueryiv(GLGetProcAddr('glGetQueryiv'));
  if not Assigned(glGetQueryiv) then 
    glGetQueryiv:=TglGetQueryiv(GetProcAddress(Lib, 'glGetQueryiv'));
  glGetQueryivARB:=TglGetQueryivARB(GLGetProcAddr('glGetQueryivARB'));
  if not Assigned(glGetQueryivARB) then 
    glGetQueryivARB:=TglGetQueryivARB(GetProcAddress(Lib, 'glGetQueryivARB'));
  glGetQueryivEXT:=TglGetQueryivEXT(GLGetProcAddr('glGetQueryivEXT'));
  if not Assigned(glGetQueryivEXT) then 
    glGetQueryivEXT:=TglGetQueryivEXT(GetProcAddress(Lib, 'glGetQueryivEXT'));
  glGetRenderbufferParameteriv:=TglGetRenderbufferParameteriv(GLGetProcAddr('glGetRenderbufferParameteriv'));
  if not Assigned(glGetRenderbufferParameteriv) then 
    glGetRenderbufferParameteriv:=TglGetRenderbufferParameteriv(GetProcAddress(Lib, 'glGetRenderbufferParameteriv'));
  glGetRenderbufferParameterivEXT:=TglGetRenderbufferParameterivEXT(GLGetProcAddr('glGetRenderbufferParameterivEXT'));
  if not Assigned(glGetRenderbufferParameterivEXT) then 
    glGetRenderbufferParameterivEXT:=TglGetRenderbufferParameterivEXT(GetProcAddress(Lib, 'glGetRenderbufferParameterivEXT'));
  glGetRenderbufferParameterivOES:=TglGetRenderbufferParameterivOES(GLGetProcAddr('glGetRenderbufferParameterivOES'));
  if not Assigned(glGetRenderbufferParameterivOES) then 
    glGetRenderbufferParameterivOES:=TglGetRenderbufferParameterivOES(GetProcAddress(Lib, 'glGetRenderbufferParameterivOES'));
  glGetSamplerParameterIiv:=TglGetSamplerParameterIiv(GLGetProcAddr('glGetSamplerParameterIiv'));
  if not Assigned(glGetSamplerParameterIiv) then 
    glGetSamplerParameterIiv:=TglGetSamplerParameterIiv(GetProcAddress(Lib, 'glGetSamplerParameterIiv'));
  glGetSamplerParameterIivEXT:=TglGetSamplerParameterIivEXT(GLGetProcAddr('glGetSamplerParameterIivEXT'));
  if not Assigned(glGetSamplerParameterIivEXT) then 
    glGetSamplerParameterIivEXT:=TglGetSamplerParameterIivEXT(GetProcAddress(Lib, 'glGetSamplerParameterIivEXT'));
  glGetSamplerParameterIivOES:=TglGetSamplerParameterIivOES(GLGetProcAddr('glGetSamplerParameterIivOES'));
  if not Assigned(glGetSamplerParameterIivOES) then 
    glGetSamplerParameterIivOES:=TglGetSamplerParameterIivOES(GetProcAddress(Lib, 'glGetSamplerParameterIivOES'));
  glGetSamplerParameterIuiv:=TglGetSamplerParameterIuiv(GLGetProcAddr('glGetSamplerParameterIuiv'));
  if not Assigned(glGetSamplerParameterIuiv) then 
    glGetSamplerParameterIuiv:=TglGetSamplerParameterIuiv(GetProcAddress(Lib, 'glGetSamplerParameterIuiv'));
  glGetSamplerParameterIuivEXT:=TglGetSamplerParameterIuivEXT(GLGetProcAddr('glGetSamplerParameterIuivEXT'));
  if not Assigned(glGetSamplerParameterIuivEXT) then 
    glGetSamplerParameterIuivEXT:=TglGetSamplerParameterIuivEXT(GetProcAddress(Lib, 'glGetSamplerParameterIuivEXT'));
  glGetSamplerParameterIuivOES:=TglGetSamplerParameterIuivOES(GLGetProcAddr('glGetSamplerParameterIuivOES'));
  if not Assigned(glGetSamplerParameterIuivOES) then 
    glGetSamplerParameterIuivOES:=TglGetSamplerParameterIuivOES(GetProcAddress(Lib, 'glGetSamplerParameterIuivOES'));
  glGetSamplerParameterfv:=TglGetSamplerParameterfv(GLGetProcAddr('glGetSamplerParameterfv'));
  if not Assigned(glGetSamplerParameterfv) then 
    glGetSamplerParameterfv:=TglGetSamplerParameterfv(GetProcAddress(Lib, 'glGetSamplerParameterfv'));
  glGetSamplerParameteriv:=TglGetSamplerParameteriv(GLGetProcAddr('glGetSamplerParameteriv'));
  if not Assigned(glGetSamplerParameteriv) then 
    glGetSamplerParameteriv:=TglGetSamplerParameteriv(GetProcAddress(Lib, 'glGetSamplerParameteriv'));
  glGetSemaphoreParameterui64vEXT:=TglGetSemaphoreParameterui64vEXT(GLGetProcAddr('glGetSemaphoreParameterui64vEXT'));
  if not Assigned(glGetSemaphoreParameterui64vEXT) then
    glGetSemaphoreParameterui64vEXT:=TglGetSemaphoreParameterui64vEXT(GetProcAddress(Lib, 'glGetSemaphoreParameterui64vEXT'));
  glGetSeparableFilter:=TglGetSeparableFilter(GLGetProcAddr('glGetSeparableFilter'));
  if not Assigned(glGetSeparableFilter) then 
    glGetSeparableFilter:=TglGetSeparableFilter(GetProcAddress(Lib, 'glGetSeparableFilter'));
  glGetSeparableFilterEXT:=TglGetSeparableFilterEXT(GLGetProcAddr('glGetSeparableFilterEXT'));
  if not Assigned(glGetSeparableFilterEXT) then 
    glGetSeparableFilterEXT:=TglGetSeparableFilterEXT(GetProcAddress(Lib, 'glGetSeparableFilterEXT'));
  glGetShaderInfoLog:=TglGetShaderInfoLog(GLGetProcAddr('glGetShaderInfoLog'));
  if not Assigned(glGetShaderInfoLog) then 
    glGetShaderInfoLog:=TglGetShaderInfoLog(GetProcAddress(Lib, 'glGetShaderInfoLog'));
  glGetShaderPrecisionFormat:=TglGetShaderPrecisionFormat(GLGetProcAddr('glGetShaderPrecisionFormat'));
  if not Assigned(glGetShaderPrecisionFormat) then 
    glGetShaderPrecisionFormat:=TglGetShaderPrecisionFormat(GetProcAddress(Lib, 'glGetShaderPrecisionFormat'));
  glGetShaderSource:=TglGetShaderSource(GLGetProcAddr('glGetShaderSource'));
  if not Assigned(glGetShaderSource) then 
    glGetShaderSource:=TglGetShaderSource(GetProcAddress(Lib, 'glGetShaderSource'));
  glGetShaderSourceARB:=TglGetShaderSourceARB(GLGetProcAddr('glGetShaderSourceARB'));
  if not Assigned(glGetShaderSourceARB) then 
    glGetShaderSourceARB:=TglGetShaderSourceARB(GetProcAddress(Lib, 'glGetShaderSourceARB'));
  glGetShaderiv:=TglGetShaderiv(GLGetProcAddr('glGetShaderiv'));
  if not Assigned(glGetShaderiv) then 
    glGetShaderiv:=TglGetShaderiv(GetProcAddress(Lib, 'glGetShaderiv'));
  glGetSharpenTexFuncSGIS:=TglGetSharpenTexFuncSGIS(GLGetProcAddr('glGetSharpenTexFuncSGIS'));
  if not Assigned(glGetSharpenTexFuncSGIS) then 
    glGetSharpenTexFuncSGIS:=TglGetSharpenTexFuncSGIS(GetProcAddress(Lib, 'glGetSharpenTexFuncSGIS'));
  glGetStageIndexNV:=TglGetStageIndexNV(GLGetProcAddr('glGetStageIndexNV'));
  if not Assigned(glGetStageIndexNV) then 
    glGetStageIndexNV:=TglGetStageIndexNV(GetProcAddress(Lib, 'glGetStageIndexNV'));
  glGetString:=TglGetString(GLGetProcAddr('glGetString'));
  if not Assigned(glGetString) then 
    glGetString:=TglGetString(GetProcAddress(Lib, 'glGetString'));
  glGetStringi:=TglGetStringi(GLGetProcAddr('glGetStringi'));
  if not Assigned(glGetStringi) then 
    glGetStringi:=TglGetStringi(GetProcAddress(Lib, 'glGetStringi'));
  glGetSubroutineIndex:=TglGetSubroutineIndex(GLGetProcAddr('glGetSubroutineIndex'));
  if not Assigned(glGetSubroutineIndex) then 
    glGetSubroutineIndex:=TglGetSubroutineIndex(GetProcAddress(Lib, 'glGetSubroutineIndex'));
  glGetSubroutineUniformLocation:=TglGetSubroutineUniformLocation(GLGetProcAddr('glGetSubroutineUniformLocation'));
  if not Assigned(glGetSubroutineUniformLocation) then 
    glGetSubroutineUniformLocation:=TglGetSubroutineUniformLocation(GetProcAddress(Lib, 'glGetSubroutineUniformLocation'));
  glGetSynciv:=TglGetSynciv(GLGetProcAddr('glGetSynciv'));
  if not Assigned(glGetSynciv) then 
    glGetSynciv:=TglGetSynciv(GetProcAddress(Lib, 'glGetSynciv'));
  glGetSyncivAPPLE:=TglGetSyncivAPPLE(GLGetProcAddr('glGetSyncivAPPLE'));
  if not Assigned(glGetSyncivAPPLE) then 
    glGetSyncivAPPLE:=TglGetSyncivAPPLE(GetProcAddress(Lib, 'glGetSyncivAPPLE'));
  glGetTexBumpParameterfvATI:=TglGetTexBumpParameterfvATI(GLGetProcAddr('glGetTexBumpParameterfvATI'));
  if not Assigned(glGetTexBumpParameterfvATI) then 
    glGetTexBumpParameterfvATI:=TglGetTexBumpParameterfvATI(GetProcAddress(Lib, 'glGetTexBumpParameterfvATI'));
  glGetTexBumpParameterivATI:=TglGetTexBumpParameterivATI(GLGetProcAddr('glGetTexBumpParameterivATI'));
  if not Assigned(glGetTexBumpParameterivATI) then 
    glGetTexBumpParameterivATI:=TglGetTexBumpParameterivATI(GetProcAddress(Lib, 'glGetTexBumpParameterivATI'));
  glGetTexEnvfv:=TglGetTexEnvfv(GLGetProcAddr('glGetTexEnvfv'));
  if not Assigned(glGetTexEnvfv) then 
    glGetTexEnvfv:=TglGetTexEnvfv(GetProcAddress(Lib, 'glGetTexEnvfv'));
  glGetTexEnviv:=TglGetTexEnviv(GLGetProcAddr('glGetTexEnviv'));
  if not Assigned(glGetTexEnviv) then 
    glGetTexEnviv:=TglGetTexEnviv(GetProcAddress(Lib, 'glGetTexEnviv'));
  glGetTexEnvxv:=TglGetTexEnvxv(GLGetProcAddr('glGetTexEnvxv'));
  if not Assigned(glGetTexEnvxv) then 
    glGetTexEnvxv:=TglGetTexEnvxv(GetProcAddress(Lib, 'glGetTexEnvxv'));
  glGetTexEnvxvOES:=TglGetTexEnvxvOES(GLGetProcAddr('glGetTexEnvxvOES'));
  if not Assigned(glGetTexEnvxvOES) then 
    glGetTexEnvxvOES:=TglGetTexEnvxvOES(GetProcAddress(Lib, 'glGetTexEnvxvOES'));
  glGetTexFilterFuncSGIS:=TglGetTexFilterFuncSGIS(GLGetProcAddr('glGetTexFilterFuncSGIS'));
  if not Assigned(glGetTexFilterFuncSGIS) then 
    glGetTexFilterFuncSGIS:=TglGetTexFilterFuncSGIS(GetProcAddress(Lib, 'glGetTexFilterFuncSGIS'));
  glGetTexGendv:=TglGetTexGendv(GLGetProcAddr('glGetTexGendv'));
  if not Assigned(glGetTexGendv) then 
    glGetTexGendv:=TglGetTexGendv(GetProcAddress(Lib, 'glGetTexGendv'));
  glGetTexGenfv:=TglGetTexGenfv(GLGetProcAddr('glGetTexGenfv'));
  if not Assigned(glGetTexGenfv) then 
    glGetTexGenfv:=TglGetTexGenfv(GetProcAddress(Lib, 'glGetTexGenfv'));
  glGetTexGenfvOES:=TglGetTexGenfvOES(GLGetProcAddr('glGetTexGenfvOES'));
  if not Assigned(glGetTexGenfvOES) then 
    glGetTexGenfvOES:=TglGetTexGenfvOES(GetProcAddress(Lib, 'glGetTexGenfvOES'));
  glGetTexGeniv:=TglGetTexGeniv(GLGetProcAddr('glGetTexGeniv'));
  if not Assigned(glGetTexGeniv) then
    glGetTexGeniv:=TglGetTexGeniv(GetProcAddress(Lib, 'glGetTexGeniv'));
  glGetTexGenivOES:=TglGetTexGenivOES(GLGetProcAddr('glGetTexGenivOES'));
  if not Assigned(glGetTexGenivOES) then 
    glGetTexGenivOES:=TglGetTexGenivOES(GetProcAddress(Lib, 'glGetTexGenivOES'));
  glGetTexGenxvOES:=TglGetTexGenxvOES(GLGetProcAddr('glGetTexGenxvOES'));
  if not Assigned(glGetTexGenxvOES) then 
    glGetTexGenxvOES:=TglGetTexGenxvOES(GetProcAddress(Lib, 'glGetTexGenxvOES'));
  glGetTexImage:=TglGetTexImage(GLGetProcAddr('glGetTexImage'));
  if not Assigned(glGetTexImage) then 
    glGetTexImage:=TglGetTexImage(GetProcAddress(Lib, 'glGetTexImage'));
  glGetTexLevelParameterfv:=TglGetTexLevelParameterfv(GLGetProcAddr('glGetTexLevelParameterfv'));
  if not Assigned(glGetTexLevelParameterfv) then 
    glGetTexLevelParameterfv:=TglGetTexLevelParameterfv(GetProcAddress(Lib, 'glGetTexLevelParameterfv'));
  glGetTexLevelParameteriv:=TglGetTexLevelParameteriv(GLGetProcAddr('glGetTexLevelParameteriv'));
  if not Assigned(glGetTexLevelParameteriv) then 
    glGetTexLevelParameteriv:=TglGetTexLevelParameteriv(GetProcAddress(Lib, 'glGetTexLevelParameteriv'));
  glGetTexLevelParameterxvOES:=TglGetTexLevelParameterxvOES(GLGetProcAddr('glGetTexLevelParameterxvOES'));
  if not Assigned(glGetTexLevelParameterxvOES) then 
    glGetTexLevelParameterxvOES:=TglGetTexLevelParameterxvOES(GetProcAddress(Lib, 'glGetTexLevelParameterxvOES'));
  glGetTexParameterIiv:=TglGetTexParameterIiv(GLGetProcAddr('glGetTexParameterIiv'));
  if not Assigned(glGetTexParameterIiv) then 
    glGetTexParameterIiv:=TglGetTexParameterIiv(GetProcAddress(Lib, 'glGetTexParameterIiv'));
  glGetTexParameterIivEXT:=TglGetTexParameterIivEXT(GLGetProcAddr('glGetTexParameterIivEXT'));
  if not Assigned(glGetTexParameterIivEXT) then 
    glGetTexParameterIivEXT:=TglGetTexParameterIivEXT(GetProcAddress(Lib, 'glGetTexParameterIivEXT'));
  glGetTexParameterIivOES:=TglGetTexParameterIivOES(GLGetProcAddr('glGetTexParameterIivOES'));
  if not Assigned(glGetTexParameterIivOES) then 
    glGetTexParameterIivOES:=TglGetTexParameterIivOES(GetProcAddress(Lib, 'glGetTexParameterIivOES'));
  glGetTexParameterIuiv:=TglGetTexParameterIuiv(GLGetProcAddr('glGetTexParameterIuiv'));
  if not Assigned(glGetTexParameterIuiv) then 
    glGetTexParameterIuiv:=TglGetTexParameterIuiv(GetProcAddress(Lib, 'glGetTexParameterIuiv'));
  glGetTexParameterIuivEXT:=TglGetTexParameterIuivEXT(GLGetProcAddr('glGetTexParameterIuivEXT'));
  if not Assigned(glGetTexParameterIuivEXT) then 
    glGetTexParameterIuivEXT:=TglGetTexParameterIuivEXT(GetProcAddress(Lib, 'glGetTexParameterIuivEXT'));
  glGetTexParameterIuivOES:=TglGetTexParameterIuivOES(GLGetProcAddr('glGetTexParameterIuivOES'));
  if not Assigned(glGetTexParameterIuivOES) then 
    glGetTexParameterIuivOES:=TglGetTexParameterIuivOES(GetProcAddress(Lib, 'glGetTexParameterIuivOES'));
  glGetTexParameterPointervAPPLE:=TglGetTexParameterPointervAPPLE(GLGetProcAddr('glGetTexParameterPointervAPPLE'));
  if not Assigned(glGetTexParameterPointervAPPLE) then 
    glGetTexParameterPointervAPPLE:=TglGetTexParameterPointervAPPLE(GetProcAddress(Lib, 'glGetTexParameterPointervAPPLE'));
  glGetTexParameterfv:=TglGetTexParameterfv(GLGetProcAddr('glGetTexParameterfv'));
  if not Assigned(glGetTexParameterfv) then 
    glGetTexParameterfv:=TglGetTexParameterfv(GetProcAddress(Lib, 'glGetTexParameterfv'));
  glGetTexParameteriv:=TglGetTexParameteriv(GLGetProcAddr('glGetTexParameteriv'));
  if not Assigned(glGetTexParameteriv) then 
    glGetTexParameteriv:=TglGetTexParameteriv(GetProcAddress(Lib, 'glGetTexParameteriv'));
  glGetTexParameterxv:=TglGetTexParameterxv(GLGetProcAddr('glGetTexParameterxv'));
  if not Assigned(glGetTexParameterxv) then 
    glGetTexParameterxv:=TglGetTexParameterxv(GetProcAddress(Lib, 'glGetTexParameterxv'));
  glGetTexParameterxvOES:=TglGetTexParameterxvOES(GLGetProcAddr('glGetTexParameterxvOES'));
  if not Assigned(glGetTexParameterxvOES) then 
    glGetTexParameterxvOES:=TglGetTexParameterxvOES(GetProcAddress(Lib, 'glGetTexParameterxvOES'));
  glGetTextureHandleARB:=TglGetTextureHandleARB(GLGetProcAddr('glGetTextureHandleARB'));
  if not Assigned(glGetTextureHandleARB) then 
    glGetTextureHandleARB:=TglGetTextureHandleARB(GetProcAddress(Lib, 'glGetTextureHandleARB'));
  glGetTextureHandleIMG:=TglGetTextureHandleIMG(GLGetProcAddr('glGetTextureHandleIMG'));
  if not Assigned(glGetTextureHandleIMG) then 
    glGetTextureHandleIMG:=TglGetTextureHandleIMG(GetProcAddress(Lib, 'glGetTextureHandleIMG'));
  glGetTextureHandleNV:=TglGetTextureHandleNV(GLGetProcAddr('glGetTextureHandleNV'));
  if not Assigned(glGetTextureHandleNV) then 
    glGetTextureHandleNV:=TglGetTextureHandleNV(GetProcAddress(Lib, 'glGetTextureHandleNV'));
  glGetTextureImage:=TglGetTextureImage(GLGetProcAddr('glGetTextureImage'));
  if not Assigned(glGetTextureImage) then 
    glGetTextureImage:=TglGetTextureImage(GetProcAddress(Lib, 'glGetTextureImage'));
  glGetTextureImageEXT:=TglGetTextureImageEXT(GLGetProcAddr('glGetTextureImageEXT'));
  if not Assigned(glGetTextureImageEXT) then 
    glGetTextureImageEXT:=TglGetTextureImageEXT(GetProcAddress(Lib, 'glGetTextureImageEXT'));
  glGetTextureLevelParameterfv:=TglGetTextureLevelParameterfv(GLGetProcAddr('glGetTextureLevelParameterfv'));
  if not Assigned(glGetTextureLevelParameterfv) then 
    glGetTextureLevelParameterfv:=TglGetTextureLevelParameterfv(GetProcAddress(Lib, 'glGetTextureLevelParameterfv'));
  glGetTextureLevelParameterfvEXT:=TglGetTextureLevelParameterfvEXT(GLGetProcAddr('glGetTextureLevelParameterfvEXT'));
  if not Assigned(glGetTextureLevelParameterfvEXT) then 
    glGetTextureLevelParameterfvEXT:=TglGetTextureLevelParameterfvEXT(GetProcAddress(Lib, 'glGetTextureLevelParameterfvEXT'));
  glGetTextureLevelParameteriv:=TglGetTextureLevelParameteriv(GLGetProcAddr('glGetTextureLevelParameteriv'));
  if not Assigned(glGetTextureLevelParameteriv) then 
    glGetTextureLevelParameteriv:=TglGetTextureLevelParameteriv(GetProcAddress(Lib, 'glGetTextureLevelParameteriv'));
  glGetTextureLevelParameterivEXT:=TglGetTextureLevelParameterivEXT(GLGetProcAddr('glGetTextureLevelParameterivEXT'));
  if not Assigned(glGetTextureLevelParameterivEXT) then
    glGetTextureLevelParameterivEXT:=TglGetTextureLevelParameterivEXT(GetProcAddress(Lib, 'glGetTextureLevelParameterivEXT'));
  glGetTextureParameterIiv:=TglGetTextureParameterIiv(GLGetProcAddr('glGetTextureParameterIiv'));
  if not Assigned(glGetTextureParameterIiv) then 
    glGetTextureParameterIiv:=TglGetTextureParameterIiv(GetProcAddress(Lib, 'glGetTextureParameterIiv'));
  glGetTextureParameterIivEXT:=TglGetTextureParameterIivEXT(GLGetProcAddr('glGetTextureParameterIivEXT'));
  if not Assigned(glGetTextureParameterIivEXT) then 
    glGetTextureParameterIivEXT:=TglGetTextureParameterIivEXT(GetProcAddress(Lib, 'glGetTextureParameterIivEXT'));
  glGetTextureParameterIuiv:=TglGetTextureParameterIuiv(GLGetProcAddr('glGetTextureParameterIuiv'));
  if not Assigned(glGetTextureParameterIuiv) then 
    glGetTextureParameterIuiv:=TglGetTextureParameterIuiv(GetProcAddress(Lib, 'glGetTextureParameterIuiv'));
  glGetTextureParameterIuivEXT:=TglGetTextureParameterIuivEXT(GLGetProcAddr('glGetTextureParameterIuivEXT'));
  if not Assigned(glGetTextureParameterIuivEXT) then 
    glGetTextureParameterIuivEXT:=TglGetTextureParameterIuivEXT(GetProcAddress(Lib, 'glGetTextureParameterIuivEXT'));
  glGetTextureParameterfv:=TglGetTextureParameterfv(GLGetProcAddr('glGetTextureParameterfv'));
  if not Assigned(glGetTextureParameterfv) then 
    glGetTextureParameterfv:=TglGetTextureParameterfv(GetProcAddress(Lib, 'glGetTextureParameterfv'));
  glGetTextureParameterfvEXT:=TglGetTextureParameterfvEXT(GLGetProcAddr('glGetTextureParameterfvEXT'));
  if not Assigned(glGetTextureParameterfvEXT) then 
    glGetTextureParameterfvEXT:=TglGetTextureParameterfvEXT(GetProcAddress(Lib, 'glGetTextureParameterfvEXT'));
  glGetTextureParameteriv:=TglGetTextureParameteriv(GLGetProcAddr('glGetTextureParameteriv'));
  if not Assigned(glGetTextureParameteriv) then 
    glGetTextureParameteriv:=TglGetTextureParameteriv(GetProcAddress(Lib, 'glGetTextureParameteriv'));
  glGetTextureParameterivEXT:=TglGetTextureParameterivEXT(GLGetProcAddr('glGetTextureParameterivEXT'));
  if not Assigned(glGetTextureParameterivEXT) then 
    glGetTextureParameterivEXT:=TglGetTextureParameterivEXT(GetProcAddress(Lib, 'glGetTextureParameterivEXT'));
  glGetTextureSamplerHandleARB:=TglGetTextureSamplerHandleARB(GLGetProcAddr('glGetTextureSamplerHandleARB'));
  if not Assigned(glGetTextureSamplerHandleARB) then 
    glGetTextureSamplerHandleARB:=TglGetTextureSamplerHandleARB(GetProcAddress(Lib, 'glGetTextureSamplerHandleARB'));
  glGetTextureSamplerHandleIMG:=TglGetTextureSamplerHandleIMG(GLGetProcAddr('glGetTextureSamplerHandleIMG'));
  if not Assigned(glGetTextureSamplerHandleIMG) then 
    glGetTextureSamplerHandleIMG:=TglGetTextureSamplerHandleIMG(GetProcAddress(Lib, 'glGetTextureSamplerHandleIMG'));
  glGetTextureSamplerHandleNV:=TglGetTextureSamplerHandleNV(GLGetProcAddr('glGetTextureSamplerHandleNV'));
  if not Assigned(glGetTextureSamplerHandleNV) then 
    glGetTextureSamplerHandleNV:=TglGetTextureSamplerHandleNV(GetProcAddress(Lib, 'glGetTextureSamplerHandleNV'));