//---------------------------------------------------------------------------
#ifndef TexturesH
#define TexturesH
//---------------------------------------------------------------------------
#include "DynArray.h"
#include "Strings.h"
//---------------------------------------------------------------------------
// Forward class declarations
#if defined(__BORLANDC__) && !defined(GraphicsHPP)
namespace Graphics
{
    class TBitmap;
    class TImageList;
};
#endif
#if defined(__BORLANDC__) && !defined(ControlsHPP)
namespace Controls
{
    class TImageList;
};
#endif
//---------------------------------------------------------------------------
enum ETextureFormat
{
    TF_RGB,
    TF_RGBA
};
//---------------------------------------------------------------------------
// Single texture
class CTexture
{
public:
    // Create an anonymous texture
    CTexture();
    // Create a named texture
    CTexture(const AString& name);
    ~CTexture();
    // Load image from file
    bool LoadImage(const AString& path);
#ifdef __BORLANDC__
    // Set the texels from the given bitmap with the given mask (-1=no mask)
    bool SetFromBitmap(Graphics::TBitmap* bitmap, int maskColor=-1);
    // Set the texels from an image list with the given mask (-1=no mask)
    bool SetFromImageList(Controls::TImageList* il, int index, int maskColor=-1);
#endif
    // Set the texels for this texture
    void SetTexels(unsigned width, unsigned height, ETextureFormat format, bool genMips, const void* data);
    // Release the texture resources
    void Release();
    // Returns true if the texture is valid
    inline bool IsValid() const { return m_id != 0; }
    // Returns the texture's name
    inline const AString& GetName() const { return m_name; }
    // Returns the texture's id
    inline unsigned long GetID() const { DEBUG_ASSERT(IsValid(), "invalid texture"); return m_id; }
    // Returns the texture's width
    inline unsigned GetWidth() const { DEBUG_ASSERT(IsValid(), "invalid texture"); return m_width; }
    // Returns the texture's height
    inline unsigned GetHeight() const { DEBUG_ASSERT(IsValid(), "invalid texture"); return m_height; }
    // Returns the texture's format
    inline ETextureFormat GetFormat() const { DEBUG_ASSERT(IsValid(), "invalid texture"); return m_format; }
#ifdef __BORLANDC__
    // Returns the texture's thumbnail
    inline Graphics::TBitmap* GetThumbnail() const
    {
        DEBUG_ASSERT(IsValid(), "invalid texture");
        DEBUG_ASSERT(m_thumbnail, "no thumbnail");
        return m_thumbnail;
    }
#endif
private:
    AString             m_name;         // Texture name
    unsigned long       m_id;           // Texture ID
    unsigned            m_width;        // Texture width
    unsigned            m_height;       // Texture height
    ETextureFormat      m_format;       // Texture format
#ifdef __BORLANDC__
    Graphics::TBitmap*  m_thumbnail;    // Texture thumbnail
#endif
};
//---------------------------------------------------------------------------
// Texture set
class CTextureSet
{
public:
    ~CTextureSet();
    // Release the textures
    void Release();
    // Add a new texture
    void Add(CTexture* texture);
    // Scan the given directory for textures
    void ScanDirectory(const AString& path);
    // Returns the texture with the given name or NULL if it was not found
    CTexture* FindTexture(const AString& name) const;
    // Returns the number of textures in the set
    inline unsigned GetCount() const { return m_textures.GetSize(); }
    // Access operator
    inline CTexture* operator[](unsigned index) const { return m_textures[index]; }
private:
    TDynArray<CTexture*>    m_textures; // Set's textures
};
//---------------------------------------------------------------------------
#endif
