//---------------------------------------------------------------------------
#ifndef PairH
#define PairH
//---------------------------------------------------------------------------
#include "HashFunc.h"
//---------------------------------------------------------------------------
// A pair of values
template <typename A, typename B> struct TPair
{
    A   First;
    B   Second;
    TPair(){}
    TPair(const TPair<A,B>& rhs)
        : First(rhs.First)
        , Second(rhs.Second)
    {
    }
    TPair(const A& first, const B& second)
        : First(first)
        , Second(second)
    {
    }
    inline bool operator==(const TPair<A,B>& rhs) const
    {
        return First==rhs.First && Second==rhs.Second;
    }
};
//---------------------------------------------------------------------------
// Hash function for a pair
namespace NHash
{
    template <typename A, typename B> inline unsigned Func(const TPair<A,B>& value)
    {
        return Func(value.First) ^ Func(value.Second);
    }
}
#endif
