#ifndef MathUtilsH
#define MathUtilsH

#ifndef PI
#define PI 3.14159265359
#endif

template <typename T> inline T TSqr(T a)
{
    return a*a;
}
template <typename T> inline T TMin(T a, T b)
{
    return a < b ? a : b;
}
template <typename T> inline T TMax(T a, T b)
{
    return a > b ? a : b;
}
template <typename T> inline T TClamp(T v, T min=0, T max=1)
{
    return TMax<T>(TMin<T>(max, v), min);
}
template <typename T> inline void TSwap(T& a, T& b)
{
    T tmp = a;
    a = b;
    b = tmp;
}
template <typename T> inline T TSign(T a)
{
    return a > 0.0 ? 1.0 : (a < 0.0 ? -1.0 : 0.0);
}
template <typename T> inline int TRound(T a)
{
    return a > 0.0 ? (long)floor(a + 0.5) : (long)ceil(a - 0.5);
}
template <typename T> inline int TSnap(T v, unsigned i)
{
    return TRound(v/(T)i)*i;
}
#endif

