//----------------------------------------------------------------------------
#ifndef DebugAssertH
#define DebugAssertH
#include <stdlib.h>
//----------------------------------------------------------------------------
#if defined(DEBUG) && defined(NDEBUG)
#undef DEBUG
#endif
//----------------------------------------------------------------------------
#ifdef DEBUG
#define DEBUG_ASSERT(expr,msg) do { \
    if (::HandleDebugAssert((expr), ""#expr, msg, __FILE__, __LINE__)) { \
        *((int*)0)=0; \
        PostDebugAssertExit(); \
    } } while (false)
#define DEBUG_VERIFY(expr,msg) DEBUG_ASSERT((expr), msg)
#define DEBUG_FAIL(msg) DEBUG_ASSERT(!"Fail", msg)
#define GLCHECK() DEBUG_ASSERT(GetTheGLError() == 0, "OpenGL Error")
#define GLCALL(call) do {call; GLCHECK();} while (false)
#else
#define DEBUG_ASSERT(expr,msg) do {} while (false)
#define DEBUG_VERIFY(expr,msg) do {expr;} while (false)
#define DEBUG_FAIL(msg) exit(1)
#define GLCHECK()
#define GLCALL(call) do {call;} while (false)
#endif
//----------------------------------------------------------------------------
#ifdef DEBUG
bool HandleDebugAssert(bool expr, const char* exprstr, const char* msg, const char* file, int line);
void PostDebugAssertExit();
unsigned GetTheGLError();
#endif
//----------------------------------------------------------------------------
#endif

